/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.AESConstants;
import com.sun.crypto.provider.DESKey;
import com.sun.crypto.provider.DESedeKey;
import com.sun.crypto.provider.DHPublicKey;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import sun.security.util.KeyUtil;

public final class DHKeyAgreement
extends KeyAgreementSpi {
    private boolean generateSecret = false;
    private BigInteger init_p = null;
    private BigInteger init_g = null;
    private BigInteger x = BigInteger.ZERO;
    private BigInteger y = BigInteger.ZERO;

    @Override
    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(key, null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.generateSecret = false;
        this.init_p = null;
        this.init_g = null;
        if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Diffie-Hellman parameters expected");
        }
        if (!(key instanceof DHPrivateKey)) {
            throw new InvalidKeyException("Diffie-Hellman private key expected");
        }
        DHPrivateKey dHPrivateKey = (DHPrivateKey)key;
        if (algorithmParameterSpec != null) {
            this.init_p = ((DHParameterSpec)algorithmParameterSpec).getP();
            this.init_g = ((DHParameterSpec)algorithmParameterSpec).getG();
        }
        BigInteger bigInteger = dHPrivateKey.getParams().getP();
        BigInteger bigInteger2 = dHPrivateKey.getParams().getG();
        if (this.init_p != null && bigInteger != null && !this.init_p.equals(bigInteger)) {
            throw new InvalidKeyException("Incompatible parameters");
        }
        if (this.init_g != null && bigInteger2 != null && !this.init_g.equals(bigInteger2)) {
            throw new InvalidKeyException("Incompatible parameters");
        }
        if (this.init_p == null && bigInteger == null || this.init_g == null && bigInteger2 == null) {
            throw new InvalidKeyException("Missing parameters");
        }
        this.init_p = bigInteger;
        this.init_g = bigInteger2;
        this.x = dHPrivateKey.getX();
    }

    @Override
    protected Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        if (!(key instanceof javax.crypto.interfaces.DHPublicKey)) {
            throw new InvalidKeyException("Diffie-Hellman public key expected");
        }
        javax.crypto.interfaces.DHPublicKey dHPublicKey = (javax.crypto.interfaces.DHPublicKey)key;
        if (this.init_p == null || this.init_g == null) {
            throw new IllegalStateException("Not initialized");
        }
        BigInteger bigInteger = dHPublicKey.getParams().getP();
        BigInteger bigInteger2 = dHPublicKey.getParams().getG();
        if (bigInteger != null && !this.init_p.equals(bigInteger)) {
            throw new InvalidKeyException("Incompatible parameters");
        }
        if (bigInteger2 != null && !this.init_g.equals(bigInteger2)) {
            throw new InvalidKeyException("Incompatible parameters");
        }
        KeyUtil.validate(dHPublicKey);
        this.y = dHPublicKey.getY();
        this.generateSecret = true;
        if (!bl) {
            byte[] byArray = this.engineGenerateSecret();
            return new DHPublicKey(new BigInteger(1, byArray), this.init_p, this.init_g);
        }
        return null;
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        int n = this.init_p.bitLength() + 7 >>> 3;
        byte[] byArray = new byte[n];
        try {
            this.engineGenerateSecret(byArray, 0);
        }
        catch (ShortBufferException shortBufferException) {
            // empty catch block
        }
        return byArray;
    }

    @Override
    protected int engineGenerateSecret(byte[] byArray, int n) throws IllegalStateException, ShortBufferException {
        if (!this.generateSecret) {
            throw new IllegalStateException("Key agreement has not been completed yet");
        }
        if (byArray == null) {
            throw new ShortBufferException("No buffer provided for shared secret");
        }
        BigInteger bigInteger = this.init_p;
        int n2 = bigInteger.bitLength() + 7 >>> 3;
        if (byArray.length - n < n2) {
            throw new ShortBufferException("Buffer too short for shared secret");
        }
        this.generateSecret = false;
        byte[] byArray2 = this.y.modPow(this.x, bigInteger).toByteArray();
        if (byArray2.length == n2) {
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        } else if (byArray2.length < n2) {
            System.arraycopy(byArray2, 0, byArray, n + (n2 - byArray2.length), byArray2.length);
        } else if (byArray2.length == n2 + 1 && byArray2[0] == 0) {
            System.arraycopy(byArray2, 1, byArray, n, n2);
        } else {
            throw new ProviderException("Generated secret is out-of-range");
        }
        return n2;
    }

    @Override
    protected SecretKey engineGenerateSecret(String string) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        if (string == null) {
            throw new NoSuchAlgorithmException("null algorithm");
        }
        byte[] byArray = this.engineGenerateSecret();
        if (string.equalsIgnoreCase("DES")) {
            return new DESKey(byArray);
        }
        if (string.equalsIgnoreCase("DESede") || string.equalsIgnoreCase("TripleDES")) {
            return new DESedeKey(byArray);
        }
        if (string.equalsIgnoreCase("Blowfish")) {
            int n = byArray.length;
            if (n >= 56) {
                n = 56;
            }
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, 0, n, "Blowfish");
            return secretKeySpec;
        }
        if (string.equalsIgnoreCase("AES")) {
            int n = byArray.length;
            SecretKeySpec secretKeySpec = null;
            for (int i = AESConstants.AES_KEYSIZES.length - 1; secretKeySpec == null && i >= 0; --i) {
                if (n < AESConstants.AES_KEYSIZES[i]) continue;
                n = AESConstants.AES_KEYSIZES[i];
                secretKeySpec = new SecretKeySpec(byArray, 0, n, "AES");
            }
            if (secretKeySpec == null) {
                throw new InvalidKeyException("Key material is too short");
            }
            return secretKeySpec;
        }
        if (string.equals("TlsPremasterSecret")) {
            return new SecretKeySpec(KeyUtil.trimZeroes(byArray), "TlsPremasterSecret");
        }
        throw new NoSuchAlgorithmException("Unsupported secret key algorithm: " + string);
    }
}

