// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package datasync

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCancelTaskExecution = "CancelTaskExecution"

// CancelTaskExecutionRequest generates a "aws/request.Request" representing the
// client's request for the CancelTaskExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelTaskExecution for more information on using the CancelTaskExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelTaskExecutionRequest method.
//    req, resp := client.CancelTaskExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CancelTaskExecution
func (c *DataSync) CancelTaskExecutionRequest(input *CancelTaskExecutionInput) (req *request.Request, output *CancelTaskExecutionOutput) {
	op := &request.Operation{
		Name:       opCancelTaskExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelTaskExecutionInput{}
	}

	output = &CancelTaskExecutionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelTaskExecution API operation for AWS DataSync.
//
// Cancels execution of a task.
//
// When you cancel a task execution, the transfer of some files is abruptly
// interrupted. The contents of files that are transferred to the destination
// might be incomplete or inconsistent with the source files. However, if you
// start a new task execution on the same task and you allow the task execution
// to complete, file content on the destination is complete and consistent.
// This applies to other unexpected failures that interrupt a task execution.
// In all of these cases, AWS DataSync successfully complete the transfer when
// you start the next task execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation CancelTaskExecution for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * InternalException
//   This exception is thrown when an error occurs in the AWS DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CancelTaskExecution
func (c *DataSync) CancelTaskExecution(input *CancelTaskExecutionInput) (*CancelTaskExecutionOutput, error) {
	req, out := c.CancelTaskExecutionRequest(input)
	return out, req.Send()
}

// CancelTaskExecutionWithContext is the same as CancelTaskExecution with the addition of
// the ability to pass a context and additional request options.
//
// See CancelTaskExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) CancelTaskExecutionWithContext(ctx aws.Context, input *CancelTaskExecutionInput, opts ...request.Option) (*CancelTaskExecutionOutput, error) {
	req, out := c.CancelTaskExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAgent = "CreateAgent"

// CreateAgentRequest generates a "aws/request.Request" representing the
// client's request for the CreateAgent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAgent for more information on using the CreateAgent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAgentRequest method.
//    req, resp := client.CreateAgentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateAgent
func (c *DataSync) CreateAgentRequest(input *CreateAgentInput) (req *request.Request, output *CreateAgentOutput) {
	op := &request.Operation{
		Name:       opCreateAgent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAgentInput{}
	}

	output = &CreateAgentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAgent API operation for AWS DataSync.
//
// Activates an AWS DataSync agent that you have deployed on your host. The
// activation process associates your agent with your account. In the activation
// process, you specify information such as the AWS Region that you want to
// activate the agent in. You activate the agent in the AWS Region where your
// target locations (in Amazon S3 or Amazon EFS) reside. Your tasks are created
// in this AWS Region.
//
// You can activate the agent in a VPC (virtual private cloud) or provide the
// agent access to a VPC endpoint so you can run tasks without going over the
// public Internet.
//
// You can use an agent for more than one location. If a task uses multiple
// agents, all of them need to have status AVAILABLE for the task to run. If
// you use multiple agents for a source location, the status of all the agents
// must be AVAILABLE for the task to run.
//
// Agents are automatically updated by AWS on a regular basis, using a mechanism
// that ensures minimal interruption to your tasks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation CreateAgent for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * InternalException
//   This exception is thrown when an error occurs in the AWS DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateAgent
func (c *DataSync) CreateAgent(input *CreateAgentInput) (*CreateAgentOutput, error) {
	req, out := c.CreateAgentRequest(input)
	return out, req.Send()
}

// CreateAgentWithContext is the same as CreateAgent with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAgent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) CreateAgentWithContext(ctx aws.Context, input *CreateAgentInput, opts ...request.Option) (*CreateAgentOutput, error) {
	req, out := c.CreateAgentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLocationEfs = "CreateLocationEfs"

// CreateLocationEfsRequest generates a "aws/request.Request" representing the
// client's request for the CreateLocationEfs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLocationEfs for more information on using the CreateLocationEfs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLocationEfsRequest method.
//    req, resp := client.CreateLocationEfsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationEfs
func (c *DataSync) CreateLocationEfsRequest(input *CreateLocationEfsInput) (req *request.Request, output *CreateLocationEfsOutput) {
	op := &request.Operation{
		Name:       opCreateLocationEfs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLocationEfsInput{}
	}

	output = &CreateLocationEfsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLocationEfs API operation for AWS DataSync.
//
// Creates an endpoint for an Amazon EFS file system.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation CreateLocationEfs for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * InternalException
//   This exception is thrown when an error occurs in the AWS DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationEfs
func (c *DataSync) CreateLocationEfs(input *CreateLocationEfsInput) (*CreateLocationEfsOutput, error) {
	req, out := c.CreateLocationEfsRequest(input)
	return out, req.Send()
}

// CreateLocationEfsWithContext is the same as CreateLocationEfs with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLocationEfs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) CreateLocationEfsWithContext(ctx aws.Context, input *CreateLocationEfsInput, opts ...request.Option) (*CreateLocationEfsOutput, error) {
	req, out := c.CreateLocationEfsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLocationFsxWindows = "CreateLocationFsxWindows"

// CreateLocationFsxWindowsRequest generates a "aws/request.Request" representing the
// client's request for the CreateLocationFsxWindows operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLocationFsxWindows for more information on using the CreateLocationFsxWindows
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLocationFsxWindowsRequest method.
//    req, resp := client.CreateLocationFsxWindowsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationFsxWindows
func (c *DataSync) CreateLocationFsxWindowsRequest(input *CreateLocationFsxWindowsInput) (req *request.Request, output *CreateLocationFsxWindowsOutput) {
	op := &request.Operation{
		Name:       opCreateLocationFsxWindows,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLocationFsxWindowsInput{}
	}

	output = &CreateLocationFsxWindowsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLocationFsxWindows API operation for AWS DataSync.
//
// Creates an endpoint for an Amazon FSx for Windows file system.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation CreateLocationFsxWindows for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * InternalException
//   This exception is thrown when an error occurs in the AWS DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationFsxWindows
func (c *DataSync) CreateLocationFsxWindows(input *CreateLocationFsxWindowsInput) (*CreateLocationFsxWindowsOutput, error) {
	req, out := c.CreateLocationFsxWindowsRequest(input)
	return out, req.Send()
}

// CreateLocationFsxWindowsWithContext is the same as CreateLocationFsxWindows with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLocationFsxWindows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) CreateLocationFsxWindowsWithContext(ctx aws.Context, input *CreateLocationFsxWindowsInput, opts ...request.Option) (*CreateLocationFsxWindowsOutput, error) {
	req, out := c.CreateLocationFsxWindowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLocationNfs = "CreateLocationNfs"

// CreateLocationNfsRequest generates a "aws/request.Request" representing the
// client's request for the CreateLocationNfs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLocationNfs for more information on using the CreateLocationNfs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLocationNfsRequest method.
//    req, resp := client.CreateLocationNfsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationNfs
func (c *DataSync) CreateLocationNfsRequest(input *CreateLocationNfsInput) (req *request.Request, output *CreateLocationNfsOutput) {
	op := &request.Operation{
		Name:       opCreateLocationNfs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLocationNfsInput{}
	}

	output = &CreateLocationNfsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLocationNfs API operation for AWS DataSync.
//
// Defines a file system on a Network File System (NFS) server that can be read
// from or written to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation CreateLocationNfs for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * InternalException
//   This exception is thrown when an error occurs in the AWS DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationNfs
func (c *DataSync) CreateLocationNfs(input *CreateLocationNfsInput) (*CreateLocationNfsOutput, error) {
	req, out := c.CreateLocationNfsRequest(input)
	return out, req.Send()
}

// CreateLocationNfsWithContext is the same as CreateLocationNfs with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLocationNfs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) CreateLocationNfsWithContext(ctx aws.Context, input *CreateLocationNfsInput, opts ...request.Option) (*CreateLocationNfsOutput, error) {
	req, out := c.CreateLocationNfsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLocationObjectStorage = "CreateLocationObjectStorage"

// CreateLocationObjectStorageRequest generates a "aws/request.Request" representing the
// client's request for the CreateLocationObjectStorage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLocationObjectStorage for more information on using the CreateLocationObjectStorage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLocationObjectStorageRequest method.
//    req, resp := client.CreateLocationObjectStorageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationObjectStorage
func (c *DataSync) CreateLocationObjectStorageRequest(input *CreateLocationObjectStorageInput) (req *request.Request, output *CreateLocationObjectStorageOutput) {
	op := &request.Operation{
		Name:       opCreateLocationObjectStorage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLocationObjectStorageInput{}
	}

	output = &CreateLocationObjectStorageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLocationObjectStorage API operation for AWS DataSync.
//
// Creates an endpoint for a self-managed object storage bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation CreateLocationObjectStorage for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * InternalException
//   This exception is thrown when an error occurs in the AWS DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationObjectStorage
func (c *DataSync) CreateLocationObjectStorage(input *CreateLocationObjectStorageInput) (*CreateLocationObjectStorageOutput, error) {
	req, out := c.CreateLocationObjectStorageRequest(input)
	return out, req.Send()
}

// CreateLocationObjectStorageWithContext is the same as CreateLocationObjectStorage with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLocationObjectStorage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) CreateLocationObjectStorageWithContext(ctx aws.Context, input *CreateLocationObjectStorageInput, opts ...request.Option) (*CreateLocationObjectStorageOutput, error) {
	req, out := c.CreateLocationObjectStorageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLocationS3 = "CreateLocationS3"

// CreateLocationS3Request generates a "aws/request.Request" representing the
// client's request for the CreateLocationS3 operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLocationS3 for more information on using the CreateLocationS3
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLocationS3Request method.
//    req, resp := client.CreateLocationS3Request(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationS3
func (c *DataSync) CreateLocationS3Request(input *CreateLocationS3Input) (req *request.Request, output *CreateLocationS3Output) {
	op := &request.Operation{
		Name:       opCreateLocationS3,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLocationS3Input{}
	}

	output = &CreateLocationS3Output{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLocationS3 API operation for AWS DataSync.
//
// Creates an endpoint for an Amazon S3 bucket.
//
// For AWS DataSync to access a destination S3 bucket, it needs an AWS Identity
// and Access Management (IAM) role that has the required permissions. You can
// set up the required permissions by creating an IAM policy that grants the
// required permissions and attaching the policy to the role. An example of
// such a policy is shown in the examples section.
//
// For more information, see https://docs.aws.amazon.com/datasync/latest/userguide/working-with-locations.html#create-s3-location
// in the AWS DataSync User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation CreateLocationS3 for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * InternalException
//   This exception is thrown when an error occurs in the AWS DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationS3
func (c *DataSync) CreateLocationS3(input *CreateLocationS3Input) (*CreateLocationS3Output, error) {
	req, out := c.CreateLocationS3Request(input)
	return out, req.Send()
}

// CreateLocationS3WithContext is the same as CreateLocationS3 with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLocationS3 for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) CreateLocationS3WithContext(ctx aws.Context, input *CreateLocationS3Input, opts ...request.Option) (*CreateLocationS3Output, error) {
	req, out := c.CreateLocationS3Request(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLocationSmb = "CreateLocationSmb"

// CreateLocationSmbRequest generates a "aws/request.Request" representing the
// client's request for the CreateLocationSmb operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLocationSmb for more information on using the CreateLocationSmb
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLocationSmbRequest method.
//    req, resp := client.CreateLocationSmbRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationSmb
func (c *DataSync) CreateLocationSmbRequest(input *CreateLocationSmbInput) (req *request.Request, output *CreateLocationSmbOutput) {
	op := &request.Operation{
		Name:       opCreateLocationSmb,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLocationSmbInput{}
	}

	output = &CreateLocationSmbOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLocationSmb API operation for AWS DataSync.
//
// Defines a file system on a Server Message Block (SMB) server that can be
// read from or written to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation CreateLocationSmb for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * InternalException
//   This exception is thrown when an error occurs in the AWS DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateLocationSmb
func (c *DataSync) CreateLocationSmb(input *CreateLocationSmbInput) (*CreateLocationSmbOutput, error) {
	req, out := c.CreateLocationSmbRequest(input)
	return out, req.Send()
}

// CreateLocationSmbWithContext is the same as CreateLocationSmb with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLocationSmb for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) CreateLocationSmbWithContext(ctx aws.Context, input *CreateLocationSmbInput, opts ...request.Option) (*CreateLocationSmbOutput, error) {
	req, out := c.CreateLocationSmbRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTask = "CreateTask"

// CreateTaskRequest generates a "aws/request.Request" representing the
// client's request for the CreateTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTask for more information on using the CreateTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTaskRequest method.
//    req, resp := client.CreateTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateTask
func (c *DataSync) CreateTaskRequest(input *CreateTaskInput) (req *request.Request, output *CreateTaskOutput) {
	op := &request.Operation{
		Name:       opCreateTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTaskInput{}
	}

	output = &CreateTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTask API operation for AWS DataSync.
//
// Creates a task. A task is a set of two locations (source and destination)
// and a set of Options that you use to control the behavior of a task. If you
// don't specify Options when you create a task, AWS DataSync populates them
// with service defaults.
//
// When you create a task, it first enters the CREATING state. During CREATING
// AWS DataSync attempts to mount the on-premises Network File System (NFS)
// location. The task transitions to the AVAILABLE state without waiting for
// the AWS location to become mounted. If required, AWS DataSync mounts the
// AWS location before each task execution.
//
// If an agent that is associated with a source (NFS) location goes offline,
// the task transitions to the UNAVAILABLE status. If the status of the task
// remains in the CREATING status for more than a few minutes, it means that
// your agent might be having trouble mounting the source NFS file system. Check
// the task's ErrorCode and ErrorDetail. Mount issues are often caused by either
// a misconfigured firewall or a mistyped NFS server host name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation CreateTask for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * InternalException
//   This exception is thrown when an error occurs in the AWS DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/CreateTask
func (c *DataSync) CreateTask(input *CreateTaskInput) (*CreateTaskOutput, error) {
	req, out := c.CreateTaskRequest(input)
	return out, req.Send()
}

// CreateTaskWithContext is the same as CreateTask with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) CreateTaskWithContext(ctx aws.Context, input *CreateTaskInput, opts ...request.Option) (*CreateTaskOutput, error) {
	req, out := c.CreateTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAgent = "DeleteAgent"

// DeleteAgentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAgent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAgent for more information on using the DeleteAgent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAgentRequest method.
//    req, resp := client.DeleteAgentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DeleteAgent
func (c *DataSync) DeleteAgentRequest(input *DeleteAgentInput) (req *request.Request, output *DeleteAgentOutput) {
	op := &request.Operation{
		Name:       opDeleteAgent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAgentInput{}
	}

	output = &DeleteAgentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAgent API operation for AWS DataSync.
//
// Deletes an agent. To specify which agent to delete, use the Amazon Resource
// Name (ARN) of the agent in your request. The operation disassociates the
// agent from your AWS account. However, it doesn't delete the agent virtual
// machine (VM) from your on-premises environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DeleteAgent for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * InternalException
//   This exception is thrown when an error occurs in the AWS DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DeleteAgent
func (c *DataSync) DeleteAgent(input *DeleteAgentInput) (*DeleteAgentOutput, error) {
	req, out := c.DeleteAgentRequest(input)
	return out, req.Send()
}

// DeleteAgentWithContext is the same as DeleteAgent with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAgent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DeleteAgentWithContext(ctx aws.Context, input *DeleteAgentInput, opts ...request.Option) (*DeleteAgentOutput, error) {
	req, out := c.DeleteAgentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLocation = "DeleteLocation"

// DeleteLocationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLocation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLocation for more information on using the DeleteLocation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLocationRequest method.
//    req, resp := client.DeleteLocationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DeleteLocation
func (c *DataSync) DeleteLocationRequest(input *DeleteLocationInput) (req *request.Request, output *DeleteLocationOutput) {
	op := &request.Operation{
		Name:       opDeleteLocation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLocationInput{}
	}

	output = &DeleteLocationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLocation API operation for AWS DataSync.
//
// Deletes the configuration of a location used by AWS DataSync.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DeleteLocation for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * InternalException
//   This exception is thrown when an error occurs in the AWS DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DeleteLocation
func (c *DataSync) DeleteLocation(input *DeleteLocationInput) (*DeleteLocationOutput, error) {
	req, out := c.DeleteLocationRequest(input)
	return out, req.Send()
}

// DeleteLocationWithContext is the same as DeleteLocation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLocation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DeleteLocationWithContext(ctx aws.Context, input *DeleteLocationInput, opts ...request.Option) (*DeleteLocationOutput, error) {
	req, out := c.DeleteLocationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTask = "DeleteTask"

// DeleteTaskRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTask for more information on using the DeleteTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTaskRequest method.
//    req, resp := client.DeleteTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DeleteTask
func (c *DataSync) DeleteTaskRequest(input *DeleteTaskInput) (req *request.Request, output *DeleteTaskOutput) {
	op := &request.Operation{
		Name:       opDeleteTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTaskInput{}
	}

	output = &DeleteTaskOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTask API operation for AWS DataSync.
//
// Deletes a task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DeleteTask for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * InternalException
//   This exception is thrown when an error occurs in the AWS DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DeleteTask
func (c *DataSync) DeleteTask(input *DeleteTaskInput) (*DeleteTaskOutput, error) {
	req, out := c.DeleteTaskRequest(input)
	return out, req.Send()
}

// DeleteTaskWithContext is the same as DeleteTask with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DeleteTaskWithContext(ctx aws.Context, input *DeleteTaskInput, opts ...request.Option) (*DeleteTaskOutput, error) {
	req, out := c.DeleteTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAgent = "DescribeAgent"

// DescribeAgentRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAgent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAgent for more information on using the DescribeAgent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAgentRequest method.
//    req, resp := client.DescribeAgentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeAgent
func (c *DataSync) DescribeAgentRequest(input *DescribeAgentInput) (req *request.Request, output *DescribeAgentOutput) {
	op := &request.Operation{
		Name:       opDescribeAgent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAgentInput{}
	}

	output = &DescribeAgentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAgent API operation for AWS DataSync.
//
// Returns metadata such as the name, the network interfaces, and the status
// (that is, whether the agent is running or not) for an agent. To specify which
// agent to describe, use the Amazon Resource Name (ARN) of the agent in your
// request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DescribeAgent for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * InternalException
//   This exception is thrown when an error occurs in the AWS DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeAgent
func (c *DataSync) DescribeAgent(input *DescribeAgentInput) (*DescribeAgentOutput, error) {
	req, out := c.DescribeAgentRequest(input)
	return out, req.Send()
}

// DescribeAgentWithContext is the same as DescribeAgent with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAgent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DescribeAgentWithContext(ctx aws.Context, input *DescribeAgentInput, opts ...request.Option) (*DescribeAgentOutput, error) {
	req, out := c.DescribeAgentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLocationEfs = "DescribeLocationEfs"

// DescribeLocationEfsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLocationEfs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLocationEfs for more information on using the DescribeLocationEfs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLocationEfsRequest method.
//    req, resp := client.DescribeLocationEfsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationEfs
func (c *DataSync) DescribeLocationEfsRequest(input *DescribeLocationEfsInput) (req *request.Request, output *DescribeLocationEfsOutput) {
	op := &request.Operation{
		Name:       opDescribeLocationEfs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLocationEfsInput{}
	}

	output = &DescribeLocationEfsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLocationEfs API operation for AWS DataSync.
//
// Returns metadata, such as the path information about an Amazon EFS location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DescribeLocationEfs for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * InternalException
//   This exception is thrown when an error occurs in the AWS DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationEfs
func (c *DataSync) DescribeLocationEfs(input *DescribeLocationEfsInput) (*DescribeLocationEfsOutput, error) {
	req, out := c.DescribeLocationEfsRequest(input)
	return out, req.Send()
}

// DescribeLocationEfsWithContext is the same as DescribeLocationEfs with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLocationEfs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DescribeLocationEfsWithContext(ctx aws.Context, input *DescribeLocationEfsInput, opts ...request.Option) (*DescribeLocationEfsOutput, error) {
	req, out := c.DescribeLocationEfsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLocationFsxWindows = "DescribeLocationFsxWindows"

// DescribeLocationFsxWindowsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLocationFsxWindows operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLocationFsxWindows for more information on using the DescribeLocationFsxWindows
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLocationFsxWindowsRequest method.
//    req, resp := client.DescribeLocationFsxWindowsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationFsxWindows
func (c *DataSync) DescribeLocationFsxWindowsRequest(input *DescribeLocationFsxWindowsInput) (req *request.Request, output *DescribeLocationFsxWindowsOutput) {
	op := &request.Operation{
		Name:       opDescribeLocationFsxWindows,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLocationFsxWindowsInput{}
	}

	output = &DescribeLocationFsxWindowsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLocationFsxWindows API operation for AWS DataSync.
//
// Returns metadata, such as the path information about an Amazon FSx for Windows
// location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DescribeLocationFsxWindows for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * InternalException
//   This exception is thrown when an error occurs in the AWS DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationFsxWindows
func (c *DataSync) DescribeLocationFsxWindows(input *DescribeLocationFsxWindowsInput) (*DescribeLocationFsxWindowsOutput, error) {
	req, out := c.DescribeLocationFsxWindowsRequest(input)
	return out, req.Send()
}

// DescribeLocationFsxWindowsWithContext is the same as DescribeLocationFsxWindows with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLocationFsxWindows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DescribeLocationFsxWindowsWithContext(ctx aws.Context, input *DescribeLocationFsxWindowsInput, opts ...request.Option) (*DescribeLocationFsxWindowsOutput, error) {
	req, out := c.DescribeLocationFsxWindowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLocationNfs = "DescribeLocationNfs"

// DescribeLocationNfsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLocationNfs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLocationNfs for more information on using the DescribeLocationNfs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLocationNfsRequest method.
//    req, resp := client.DescribeLocationNfsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationNfs
func (c *DataSync) DescribeLocationNfsRequest(input *DescribeLocationNfsInput) (req *request.Request, output *DescribeLocationNfsOutput) {
	op := &request.Operation{
		Name:       opDescribeLocationNfs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLocationNfsInput{}
	}

	output = &DescribeLocationNfsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLocationNfs API operation for AWS DataSync.
//
// Returns metadata, such as the path information, about an NFS location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DescribeLocationNfs for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * InternalException
//   This exception is thrown when an error occurs in the AWS DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationNfs
func (c *DataSync) DescribeLocationNfs(input *DescribeLocationNfsInput) (*DescribeLocationNfsOutput, error) {
	req, out := c.DescribeLocationNfsRequest(input)
	return out, req.Send()
}

// DescribeLocationNfsWithContext is the same as DescribeLocationNfs with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLocationNfs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DescribeLocationNfsWithContext(ctx aws.Context, input *DescribeLocationNfsInput, opts ...request.Option) (*DescribeLocationNfsOutput, error) {
	req, out := c.DescribeLocationNfsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLocationObjectStorage = "DescribeLocationObjectStorage"

// DescribeLocationObjectStorageRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLocationObjectStorage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLocationObjectStorage for more information on using the DescribeLocationObjectStorage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLocationObjectStorageRequest method.
//    req, resp := client.DescribeLocationObjectStorageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationObjectStorage
func (c *DataSync) DescribeLocationObjectStorageRequest(input *DescribeLocationObjectStorageInput) (req *request.Request, output *DescribeLocationObjectStorageOutput) {
	op := &request.Operation{
		Name:       opDescribeLocationObjectStorage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLocationObjectStorageInput{}
	}

	output = &DescribeLocationObjectStorageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLocationObjectStorage API operation for AWS DataSync.
//
// Returns metadata about a self-managed object storage server location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DescribeLocationObjectStorage for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * InternalException
//   This exception is thrown when an error occurs in the AWS DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationObjectStorage
func (c *DataSync) DescribeLocationObjectStorage(input *DescribeLocationObjectStorageInput) (*DescribeLocationObjectStorageOutput, error) {
	req, out := c.DescribeLocationObjectStorageRequest(input)
	return out, req.Send()
}

// DescribeLocationObjectStorageWithContext is the same as DescribeLocationObjectStorage with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLocationObjectStorage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DescribeLocationObjectStorageWithContext(ctx aws.Context, input *DescribeLocationObjectStorageInput, opts ...request.Option) (*DescribeLocationObjectStorageOutput, error) {
	req, out := c.DescribeLocationObjectStorageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLocationS3 = "DescribeLocationS3"

// DescribeLocationS3Request generates a "aws/request.Request" representing the
// client's request for the DescribeLocationS3 operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLocationS3 for more information on using the DescribeLocationS3
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLocationS3Request method.
//    req, resp := client.DescribeLocationS3Request(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationS3
func (c *DataSync) DescribeLocationS3Request(input *DescribeLocationS3Input) (req *request.Request, output *DescribeLocationS3Output) {
	op := &request.Operation{
		Name:       opDescribeLocationS3,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLocationS3Input{}
	}

	output = &DescribeLocationS3Output{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLocationS3 API operation for AWS DataSync.
//
// Returns metadata, such as bucket name, about an Amazon S3 bucket location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DescribeLocationS3 for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * InternalException
//   This exception is thrown when an error occurs in the AWS DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationS3
func (c *DataSync) DescribeLocationS3(input *DescribeLocationS3Input) (*DescribeLocationS3Output, error) {
	req, out := c.DescribeLocationS3Request(input)
	return out, req.Send()
}

// DescribeLocationS3WithContext is the same as DescribeLocationS3 with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLocationS3 for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DescribeLocationS3WithContext(ctx aws.Context, input *DescribeLocationS3Input, opts ...request.Option) (*DescribeLocationS3Output, error) {
	req, out := c.DescribeLocationS3Request(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLocationSmb = "DescribeLocationSmb"

// DescribeLocationSmbRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLocationSmb operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLocationSmb for more information on using the DescribeLocationSmb
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLocationSmbRequest method.
//    req, resp := client.DescribeLocationSmbRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationSmb
func (c *DataSync) DescribeLocationSmbRequest(input *DescribeLocationSmbInput) (req *request.Request, output *DescribeLocationSmbOutput) {
	op := &request.Operation{
		Name:       opDescribeLocationSmb,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLocationSmbInput{}
	}

	output = &DescribeLocationSmbOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLocationSmb API operation for AWS DataSync.
//
// Returns metadata, such as the path and user information about an SMB location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DescribeLocationSmb for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * InternalException
//   This exception is thrown when an error occurs in the AWS DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationSmb
func (c *DataSync) DescribeLocationSmb(input *DescribeLocationSmbInput) (*DescribeLocationSmbOutput, error) {
	req, out := c.DescribeLocationSmbRequest(input)
	return out, req.Send()
}

// DescribeLocationSmbWithContext is the same as DescribeLocationSmb with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLocationSmb for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DescribeLocationSmbWithContext(ctx aws.Context, input *DescribeLocationSmbInput, opts ...request.Option) (*DescribeLocationSmbOutput, error) {
	req, out := c.DescribeLocationSmbRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTask = "DescribeTask"

// DescribeTaskRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTask for more information on using the DescribeTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTaskRequest method.
//    req, resp := client.DescribeTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeTask
func (c *DataSync) DescribeTaskRequest(input *DescribeTaskInput) (req *request.Request, output *DescribeTaskOutput) {
	op := &request.Operation{
		Name:       opDescribeTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTaskInput{}
	}

	output = &DescribeTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTask API operation for AWS DataSync.
//
// Returns metadata about a task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DescribeTask for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * InternalException
//   This exception is thrown when an error occurs in the AWS DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeTask
func (c *DataSync) DescribeTask(input *DescribeTaskInput) (*DescribeTaskOutput, error) {
	req, out := c.DescribeTaskRequest(input)
	return out, req.Send()
}

// DescribeTaskWithContext is the same as DescribeTask with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DescribeTaskWithContext(ctx aws.Context, input *DescribeTaskInput, opts ...request.Option) (*DescribeTaskOutput, error) {
	req, out := c.DescribeTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTaskExecution = "DescribeTaskExecution"

// DescribeTaskExecutionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTaskExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTaskExecution for more information on using the DescribeTaskExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTaskExecutionRequest method.
//    req, resp := client.DescribeTaskExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeTaskExecution
func (c *DataSync) DescribeTaskExecutionRequest(input *DescribeTaskExecutionInput) (req *request.Request, output *DescribeTaskExecutionOutput) {
	op := &request.Operation{
		Name:       opDescribeTaskExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTaskExecutionInput{}
	}

	output = &DescribeTaskExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTaskExecution API operation for AWS DataSync.
//
// Returns detailed metadata about a task that is being executed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation DescribeTaskExecution for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * InternalException
//   This exception is thrown when an error occurs in the AWS DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeTaskExecution
func (c *DataSync) DescribeTaskExecution(input *DescribeTaskExecutionInput) (*DescribeTaskExecutionOutput, error) {
	req, out := c.DescribeTaskExecutionRequest(input)
	return out, req.Send()
}

// DescribeTaskExecutionWithContext is the same as DescribeTaskExecution with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTaskExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) DescribeTaskExecutionWithContext(ctx aws.Context, input *DescribeTaskExecutionInput, opts ...request.Option) (*DescribeTaskExecutionOutput, error) {
	req, out := c.DescribeTaskExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAgents = "ListAgents"

// ListAgentsRequest generates a "aws/request.Request" representing the
// client's request for the ListAgents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAgents for more information on using the ListAgents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAgentsRequest method.
//    req, resp := client.ListAgentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListAgents
func (c *DataSync) ListAgentsRequest(input *ListAgentsInput) (req *request.Request, output *ListAgentsOutput) {
	op := &request.Operation{
		Name:       opListAgents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAgentsInput{}
	}

	output = &ListAgentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAgents API operation for AWS DataSync.
//
// Returns a list of agents owned by an AWS account in the AWS Region specified
// in the request. The returned list is ordered by agent Amazon Resource Name
// (ARN).
//
// By default, this operation returns a maximum of 100 agents. This operation
// supports pagination that enables you to optionally reduce the number of agents
// returned in a response.
//
// If you have more agents than are returned in a response (that is, the response
// returns only a truncated list of your agents), the response contains a marker
// that you can specify in your next request to fetch the next page of agents.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation ListAgents for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * InternalException
//   This exception is thrown when an error occurs in the AWS DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListAgents
func (c *DataSync) ListAgents(input *ListAgentsInput) (*ListAgentsOutput, error) {
	req, out := c.ListAgentsRequest(input)
	return out, req.Send()
}

// ListAgentsWithContext is the same as ListAgents with the addition of
// the ability to pass a context and additional request options.
//
// See ListAgents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) ListAgentsWithContext(ctx aws.Context, input *ListAgentsInput, opts ...request.Option) (*ListAgentsOutput, error) {
	req, out := c.ListAgentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAgentsPages iterates over the pages of a ListAgents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAgents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAgents operation.
//    pageNum := 0
//    err := client.ListAgentsPages(params,
//        func(page *datasync.ListAgentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DataSync) ListAgentsPages(input *ListAgentsInput, fn func(*ListAgentsOutput, bool) bool) error {
	return c.ListAgentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAgentsPagesWithContext same as ListAgentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) ListAgentsPagesWithContext(ctx aws.Context, input *ListAgentsInput, fn func(*ListAgentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAgentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAgentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAgentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLocations = "ListLocations"

// ListLocationsRequest generates a "aws/request.Request" representing the
// client's request for the ListLocations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLocations for more information on using the ListLocations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLocationsRequest method.
//    req, resp := client.ListLocationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListLocations
func (c *DataSync) ListLocationsRequest(input *ListLocationsInput) (req *request.Request, output *ListLocationsOutput) {
	op := &request.Operation{
		Name:       opListLocations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLocationsInput{}
	}

	output = &ListLocationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLocations API operation for AWS DataSync.
//
// Returns a list of source and destination locations.
//
// If you have more locations than are returned in a response (that is, the
// response returns only a truncated list of your agents), the response contains
// a token that you can specify in your next request to fetch the next page
// of locations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation ListLocations for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * InternalException
//   This exception is thrown when an error occurs in the AWS DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListLocations
func (c *DataSync) ListLocations(input *ListLocationsInput) (*ListLocationsOutput, error) {
	req, out := c.ListLocationsRequest(input)
	return out, req.Send()
}

// ListLocationsWithContext is the same as ListLocations with the addition of
// the ability to pass a context and additional request options.
//
// See ListLocations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) ListLocationsWithContext(ctx aws.Context, input *ListLocationsInput, opts ...request.Option) (*ListLocationsOutput, error) {
	req, out := c.ListLocationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLocationsPages iterates over the pages of a ListLocations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLocations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListLocations operation.
//    pageNum := 0
//    err := client.ListLocationsPages(params,
//        func(page *datasync.ListLocationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DataSync) ListLocationsPages(input *ListLocationsInput, fn func(*ListLocationsOutput, bool) bool) error {
	return c.ListLocationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLocationsPagesWithContext same as ListLocationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) ListLocationsPagesWithContext(ctx aws.Context, input *ListLocationsInput, fn func(*ListLocationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLocationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLocationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLocationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTagsForResource
func (c *DataSync) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS DataSync.
//
// Returns all the tags associated with a specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * InternalException
//   This exception is thrown when an error occurs in the AWS DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTagsForResource
func (c *DataSync) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsForResourcePages iterates over the pages of a ListTagsForResource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTagsForResource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTagsForResource operation.
//    pageNum := 0
//    err := client.ListTagsForResourcePages(params,
//        func(page *datasync.ListTagsForResourceOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DataSync) ListTagsForResourcePages(input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool) error {
	return c.ListTagsForResourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsForResourcePagesWithContext same as ListTagsForResourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) ListTagsForResourcePagesWithContext(ctx aws.Context, input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsForResourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsForResourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTagsForResourceOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTaskExecutions = "ListTaskExecutions"

// ListTaskExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the ListTaskExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTaskExecutions for more information on using the ListTaskExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTaskExecutionsRequest method.
//    req, resp := client.ListTaskExecutionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTaskExecutions
func (c *DataSync) ListTaskExecutionsRequest(input *ListTaskExecutionsInput) (req *request.Request, output *ListTaskExecutionsOutput) {
	op := &request.Operation{
		Name:       opListTaskExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTaskExecutionsInput{}
	}

	output = &ListTaskExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTaskExecutions API operation for AWS DataSync.
//
// Returns a list of executed tasks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation ListTaskExecutions for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * InternalException
//   This exception is thrown when an error occurs in the AWS DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTaskExecutions
func (c *DataSync) ListTaskExecutions(input *ListTaskExecutionsInput) (*ListTaskExecutionsOutput, error) {
	req, out := c.ListTaskExecutionsRequest(input)
	return out, req.Send()
}

// ListTaskExecutionsWithContext is the same as ListTaskExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See ListTaskExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) ListTaskExecutionsWithContext(ctx aws.Context, input *ListTaskExecutionsInput, opts ...request.Option) (*ListTaskExecutionsOutput, error) {
	req, out := c.ListTaskExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTaskExecutionsPages iterates over the pages of a ListTaskExecutions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTaskExecutions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTaskExecutions operation.
//    pageNum := 0
//    err := client.ListTaskExecutionsPages(params,
//        func(page *datasync.ListTaskExecutionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DataSync) ListTaskExecutionsPages(input *ListTaskExecutionsInput, fn func(*ListTaskExecutionsOutput, bool) bool) error {
	return c.ListTaskExecutionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTaskExecutionsPagesWithContext same as ListTaskExecutionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) ListTaskExecutionsPagesWithContext(ctx aws.Context, input *ListTaskExecutionsInput, fn func(*ListTaskExecutionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTaskExecutionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTaskExecutionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTaskExecutionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTasks = "ListTasks"

// ListTasksRequest generates a "aws/request.Request" representing the
// client's request for the ListTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTasks for more information on using the ListTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTasksRequest method.
//    req, resp := client.ListTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTasks
func (c *DataSync) ListTasksRequest(input *ListTasksInput) (req *request.Request, output *ListTasksOutput) {
	op := &request.Operation{
		Name:       opListTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTasksInput{}
	}

	output = &ListTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTasks API operation for AWS DataSync.
//
// Returns a list of all the tasks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation ListTasks for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * InternalException
//   This exception is thrown when an error occurs in the AWS DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTasks
func (c *DataSync) ListTasks(input *ListTasksInput) (*ListTasksOutput, error) {
	req, out := c.ListTasksRequest(input)
	return out, req.Send()
}

// ListTasksWithContext is the same as ListTasks with the addition of
// the ability to pass a context and additional request options.
//
// See ListTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) ListTasksWithContext(ctx aws.Context, input *ListTasksInput, opts ...request.Option) (*ListTasksOutput, error) {
	req, out := c.ListTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTasksPages iterates over the pages of a ListTasks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTasks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTasks operation.
//    pageNum := 0
//    err := client.ListTasksPages(params,
//        func(page *datasync.ListTasksOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DataSync) ListTasksPages(input *ListTasksInput, fn func(*ListTasksOutput, bool) bool) error {
	return c.ListTasksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTasksPagesWithContext same as ListTasksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) ListTasksPagesWithContext(ctx aws.Context, input *ListTasksInput, fn func(*ListTasksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTasksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTasksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTasksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartTaskExecution = "StartTaskExecution"

// StartTaskExecutionRequest generates a "aws/request.Request" representing the
// client's request for the StartTaskExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartTaskExecution for more information on using the StartTaskExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartTaskExecutionRequest method.
//    req, resp := client.StartTaskExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/StartTaskExecution
func (c *DataSync) StartTaskExecutionRequest(input *StartTaskExecutionInput) (req *request.Request, output *StartTaskExecutionOutput) {
	op := &request.Operation{
		Name:       opStartTaskExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartTaskExecutionInput{}
	}

	output = &StartTaskExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartTaskExecution API operation for AWS DataSync.
//
// Starts a specific invocation of a task. A TaskExecution value represents
// an individual run of a task. Each task can have at most one TaskExecution
// at a time.
//
// TaskExecution has the following transition phases: INITIALIZING | PREPARING
// | TRANSFERRING | VERIFYING | SUCCESS/FAILURE.
//
// For detailed information, see the Task Execution section in the Components
// and Terminology topic in the AWS DataSync User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation StartTaskExecution for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * InternalException
//   This exception is thrown when an error occurs in the AWS DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/StartTaskExecution
func (c *DataSync) StartTaskExecution(input *StartTaskExecutionInput) (*StartTaskExecutionOutput, error) {
	req, out := c.StartTaskExecutionRequest(input)
	return out, req.Send()
}

// StartTaskExecutionWithContext is the same as StartTaskExecution with the addition of
// the ability to pass a context and additional request options.
//
// See StartTaskExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) StartTaskExecutionWithContext(ctx aws.Context, input *StartTaskExecutionInput, opts ...request.Option) (*StartTaskExecutionOutput, error) {
	req, out := c.StartTaskExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/TagResource
func (c *DataSync) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS DataSync.
//
// Applies a key-value pair to an AWS resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * InternalException
//   This exception is thrown when an error occurs in the AWS DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/TagResource
func (c *DataSync) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UntagResource
func (c *DataSync) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS DataSync.
//
// Removes a tag from an AWS resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * InternalException
//   This exception is thrown when an error occurs in the AWS DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UntagResource
func (c *DataSync) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAgent = "UpdateAgent"

// UpdateAgentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAgent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAgent for more information on using the UpdateAgent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAgentRequest method.
//    req, resp := client.UpdateAgentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateAgent
func (c *DataSync) UpdateAgentRequest(input *UpdateAgentInput) (req *request.Request, output *UpdateAgentOutput) {
	op := &request.Operation{
		Name:       opUpdateAgent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAgentInput{}
	}

	output = &UpdateAgentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateAgent API operation for AWS DataSync.
//
// Updates the name of an agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation UpdateAgent for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * InternalException
//   This exception is thrown when an error occurs in the AWS DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateAgent
func (c *DataSync) UpdateAgent(input *UpdateAgentInput) (*UpdateAgentOutput, error) {
	req, out := c.UpdateAgentRequest(input)
	return out, req.Send()
}

// UpdateAgentWithContext is the same as UpdateAgent with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAgent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) UpdateAgentWithContext(ctx aws.Context, input *UpdateAgentInput, opts ...request.Option) (*UpdateAgentOutput, error) {
	req, out := c.UpdateAgentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTask = "UpdateTask"

// UpdateTaskRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTask for more information on using the UpdateTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTaskRequest method.
//    req, resp := client.UpdateTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateTask
func (c *DataSync) UpdateTaskRequest(input *UpdateTaskInput) (req *request.Request, output *UpdateTaskOutput) {
	op := &request.Operation{
		Name:       opUpdateTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTaskInput{}
	}

	output = &UpdateTaskOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateTask API operation for AWS DataSync.
//
// Updates the metadata associated with a task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS DataSync's
// API operation UpdateTask for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   This exception is thrown when the client submits a malformed request.
//
//   * InternalException
//   This exception is thrown when an error occurs in the AWS DataSync service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/UpdateTask
func (c *DataSync) UpdateTask(input *UpdateTaskInput) (*UpdateTaskOutput, error) {
	req, out := c.UpdateTaskRequest(input)
	return out, req.Send()
}

// UpdateTaskWithContext is the same as UpdateTask with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataSync) UpdateTaskWithContext(ctx aws.Context, input *UpdateTaskInput, opts ...request.Option) (*UpdateTaskOutput, error) {
	req, out := c.UpdateTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Represents a single entry in a list of agents. AgentListEntry returns an
// array that contains a list of agents when the ListAgents operation is called.
type AgentListEntry struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the agent.
	AgentArn *string `type:"string"`

	// The name of the agent.
	Name *string `min:"1" type:"string"`

	// The status of the agent.
	Status *string `type:"string" enum:"AgentStatus"`
}

// String returns the string representation
func (s AgentListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AgentListEntry) GoString() string {
	return s.String()
}

// SetAgentArn sets the AgentArn field's value.
func (s *AgentListEntry) SetAgentArn(v string) *AgentListEntry {
	s.AgentArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *AgentListEntry) SetName(v string) *AgentListEntry {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AgentListEntry) SetStatus(v string) *AgentListEntry {
	s.Status = &v
	return s
}

// CancelTaskExecutionRequest
type CancelTaskExecutionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the task execution to cancel.
	//
	// TaskExecutionArn is a required field
	TaskExecutionArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CancelTaskExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelTaskExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelTaskExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelTaskExecutionInput"}
	if s.TaskExecutionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskExecutionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaskExecutionArn sets the TaskExecutionArn field's value.
func (s *CancelTaskExecutionInput) SetTaskExecutionArn(v string) *CancelTaskExecutionInput {
	s.TaskExecutionArn = &v
	return s
}

type CancelTaskExecutionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelTaskExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelTaskExecutionOutput) GoString() string {
	return s.String()
}

// CreateAgentRequest
type CreateAgentInput struct {
	_ struct{} `type:"structure"`

	// Your agent activation key. You can get the activation key either by sending
	// an HTTP GET request with redirects that enable you to get the agent IP address
	// (port 80). Alternatively, you can get it from the AWS DataSync console.
	//
	// The redirect URL returned in the response provides you the activation key
	// for your agent in the query string parameter activationKey. It might also
	// include other activation-related parameters; however, these are merely defaults.
	// The arguments you pass to this API call determine the actual configuration
	// of your agent.
	//
	// For more information, see Activating an Agent in the AWS DataSync User Guide.
	//
	// ActivationKey is a required field
	ActivationKey *string `type:"string" required:"true"`

	// The name you configured for your agent. This value is a text reference that
	// is used to identify the agent in the console.
	AgentName *string `min:"1" type:"string"`

	// The ARNs of the security groups used to protect your data transfer task subnets.
	// See CreateAgentRequest$SubnetArns.
	SecurityGroupArns []*string `min:"1" type:"list"`

	// The Amazon Resource Names (ARNs) of the subnets in which DataSync will create
	// elastic network interfaces for each data transfer task. The agent that runs
	// a task must be private. When you start a task that is associated with an
	// agent created in a VPC, or one that has access to an IP address in a VPC,
	// then the task is also private. In this case, DataSync creates four network
	// interfaces for each task in your subnet. For a data transfer to work, the
	// agent must be able to route to all these four network interfaces.
	SubnetArns []*string `min:"1" type:"list"`

	// The key-value pair that represents the tag that you want to associate with
	// the agent. The value can be an empty string. This value helps you manage,
	// filter, and search for your agents.
	//
	// Valid characters for key and value are letters, spaces, and numbers representable
	// in UTF-8 format, and the following special characters: + - = . _ : / @.
	Tags []*TagListEntry `type:"list"`

	// The ID of the VPC (virtual private cloud) endpoint that the agent has access
	// to. This is the client-side VPC endpoint, also called a PrivateLink. If you
	// don't have a PrivateLink VPC endpoint, see Creating a VPC Endpoint Service
	// Configuration (https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html#create-endpoint-service)
	// in the Amazon VPC User Guide.
	//
	// VPC endpoint ID looks like this: vpce-01234d5aff67890e1.
	VpcEndpointId *string `type:"string"`
}

// String returns the string representation
func (s CreateAgentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAgentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAgentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAgentInput"}
	if s.ActivationKey == nil {
		invalidParams.Add(request.NewErrParamRequired("ActivationKey"))
	}
	if s.AgentName != nil && len(*s.AgentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentName", 1))
	}
	if s.SecurityGroupArns != nil && len(s.SecurityGroupArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupArns", 1))
	}
	if s.SubnetArns != nil && len(s.SubnetArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetArns", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivationKey sets the ActivationKey field's value.
func (s *CreateAgentInput) SetActivationKey(v string) *CreateAgentInput {
	s.ActivationKey = &v
	return s
}

// SetAgentName sets the AgentName field's value.
func (s *CreateAgentInput) SetAgentName(v string) *CreateAgentInput {
	s.AgentName = &v
	return s
}

// SetSecurityGroupArns sets the SecurityGroupArns field's value.
func (s *CreateAgentInput) SetSecurityGroupArns(v []*string) *CreateAgentInput {
	s.SecurityGroupArns = v
	return s
}

// SetSubnetArns sets the SubnetArns field's value.
func (s *CreateAgentInput) SetSubnetArns(v []*string) *CreateAgentInput {
	s.SubnetArns = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAgentInput) SetTags(v []*TagListEntry) *CreateAgentInput {
	s.Tags = v
	return s
}

// SetVpcEndpointId sets the VpcEndpointId field's value.
func (s *CreateAgentInput) SetVpcEndpointId(v string) *CreateAgentInput {
	s.VpcEndpointId = &v
	return s
}

// CreateAgentResponse
type CreateAgentOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the agent. Use the ListAgents operation
	// to return a list of agents for your account and AWS Region.
	AgentArn *string `type:"string"`
}

// String returns the string representation
func (s CreateAgentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAgentOutput) GoString() string {
	return s.String()
}

// SetAgentArn sets the AgentArn field's value.
func (s *CreateAgentOutput) SetAgentArn(v string) *CreateAgentOutput {
	s.AgentArn = &v
	return s
}

// CreateLocationEfsRequest
type CreateLocationEfsInput struct {
	_ struct{} `type:"structure"`

	// The subnet and security group that the Amazon EFS file system uses. The security
	// group that you provide needs to be able to communicate with the security
	// group on the mount target in the subnet specified.
	//
	// The exact relationship between security group M (of the mount target) and
	// security group S (which you provide for DataSync to use at this stage) is
	// as follows:
	//
	//    * Security group M (which you associate with the mount target) must allow
	//    inbound access for the Transmission Control Protocol (TCP) on the NFS
	//    port (2049) from security group S. You can enable inbound connections
	//    either by IP address (CIDR range) or security group.
	//
	//    * Security group S (provided to DataSync to access EFS) should have a
	//    rule that enables outbound connections to the NFS port on one of the file
	//    system’s mount targets. You can enable outbound connections either by
	//    IP address (CIDR range) or security group. For information about security
	//    groups and mount targets, see Security Groups for Amazon EC2 Instances
	//    and Mount Targets in the Amazon EFS User Guide.
	//
	// Ec2Config is a required field
	Ec2Config *Ec2Config `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) for the Amazon EFS file system.
	//
	// EfsFilesystemArn is a required field
	EfsFilesystemArn *string `type:"string" required:"true"`

	// A subdirectory in the location’s path. This subdirectory in the EFS file
	// system is used to read data from the EFS source location or write data to
	// the EFS destination. By default, AWS DataSync uses the root directory.
	//
	// Subdirectory must be specified with forward slashes. For example, /path/to/folder.
	Subdirectory *string `type:"string"`

	// The key-value pair that represents a tag that you want to add to the resource.
	// The value can be an empty string. This value helps you manage, filter, and
	// search for your resources. We recommend that you create a name tag for your
	// location.
	Tags []*TagListEntry `type:"list"`
}

// String returns the string representation
func (s CreateLocationEfsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLocationEfsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLocationEfsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLocationEfsInput"}
	if s.Ec2Config == nil {
		invalidParams.Add(request.NewErrParamRequired("Ec2Config"))
	}
	if s.EfsFilesystemArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EfsFilesystemArn"))
	}
	if s.Ec2Config != nil {
		if err := s.Ec2Config.Validate(); err != nil {
			invalidParams.AddNested("Ec2Config", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEc2Config sets the Ec2Config field's value.
func (s *CreateLocationEfsInput) SetEc2Config(v *Ec2Config) *CreateLocationEfsInput {
	s.Ec2Config = v
	return s
}

// SetEfsFilesystemArn sets the EfsFilesystemArn field's value.
func (s *CreateLocationEfsInput) SetEfsFilesystemArn(v string) *CreateLocationEfsInput {
	s.EfsFilesystemArn = &v
	return s
}

// SetSubdirectory sets the Subdirectory field's value.
func (s *CreateLocationEfsInput) SetSubdirectory(v string) *CreateLocationEfsInput {
	s.Subdirectory = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLocationEfsInput) SetTags(v []*TagListEntry) *CreateLocationEfsInput {
	s.Tags = v
	return s
}

// CreateLocationEfs
type CreateLocationEfsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon EFS file system location that
	// is created.
	LocationArn *string `type:"string"`
}

// String returns the string representation
func (s CreateLocationEfsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLocationEfsOutput) GoString() string {
	return s.String()
}

// SetLocationArn sets the LocationArn field's value.
func (s *CreateLocationEfsOutput) SetLocationArn(v string) *CreateLocationEfsOutput {
	s.LocationArn = &v
	return s
}

type CreateLocationFsxWindowsInput struct {
	_ struct{} `type:"structure"`

	// The name of the Windows domain that the FSx for Windows server belongs to.
	Domain *string `type:"string"`

	// The Amazon Resource Name (ARN) for the FSx for Windows file system.
	//
	// FsxFilesystemArn is a required field
	FsxFilesystemArn *string `type:"string" required:"true"`

	// The password of the user who has the permissions to access files and folders
	// in the FSx for Windows file system.
	//
	// Password is a required field
	Password *string `type:"string" required:"true" sensitive:"true"`

	// The Amazon Resource Names (ARNs) of the security groups that are to use to
	// configure the FSx for Windows file system.
	//
	// SecurityGroupArns is a required field
	SecurityGroupArns []*string `min:"1" type:"list" required:"true"`

	// A subdirectory in the location’s path. This subdirectory in the Amazon
	// FSx for Windows file system is used to read data from the Amazon FSx for
	// Windows source location or write data to the FSx for Windows destination.
	Subdirectory *string `type:"string"`

	// The key-value pair that represents a tag that you want to add to the resource.
	// The value can be an empty string. This value helps you manage, filter, and
	// search for your resources. We recommend that you create a name tag for your
	// location.
	Tags []*TagListEntry `type:"list"`

	// The user who has the permissions to access files and folders in the FSx for
	// Windows file system.
	//
	// User is a required field
	User *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateLocationFsxWindowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLocationFsxWindowsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLocationFsxWindowsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLocationFsxWindowsInput"}
	if s.FsxFilesystemArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FsxFilesystemArn"))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.SecurityGroupArns == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupArns"))
	}
	if s.SecurityGroupArns != nil && len(s.SecurityGroupArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupArns", 1))
	}
	if s.User == nil {
		invalidParams.Add(request.NewErrParamRequired("User"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *CreateLocationFsxWindowsInput) SetDomain(v string) *CreateLocationFsxWindowsInput {
	s.Domain = &v
	return s
}

// SetFsxFilesystemArn sets the FsxFilesystemArn field's value.
func (s *CreateLocationFsxWindowsInput) SetFsxFilesystemArn(v string) *CreateLocationFsxWindowsInput {
	s.FsxFilesystemArn = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *CreateLocationFsxWindowsInput) SetPassword(v string) *CreateLocationFsxWindowsInput {
	s.Password = &v
	return s
}

// SetSecurityGroupArns sets the SecurityGroupArns field's value.
func (s *CreateLocationFsxWindowsInput) SetSecurityGroupArns(v []*string) *CreateLocationFsxWindowsInput {
	s.SecurityGroupArns = v
	return s
}

// SetSubdirectory sets the Subdirectory field's value.
func (s *CreateLocationFsxWindowsInput) SetSubdirectory(v string) *CreateLocationFsxWindowsInput {
	s.Subdirectory = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLocationFsxWindowsInput) SetTags(v []*TagListEntry) *CreateLocationFsxWindowsInput {
	s.Tags = v
	return s
}

// SetUser sets the User field's value.
func (s *CreateLocationFsxWindowsInput) SetUser(v string) *CreateLocationFsxWindowsInput {
	s.User = &v
	return s
}

type CreateLocationFsxWindowsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the FSx for Windows file system location
	// that is created.
	LocationArn *string `type:"string"`
}

// String returns the string representation
func (s CreateLocationFsxWindowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLocationFsxWindowsOutput) GoString() string {
	return s.String()
}

// SetLocationArn sets the LocationArn field's value.
func (s *CreateLocationFsxWindowsOutput) SetLocationArn(v string) *CreateLocationFsxWindowsOutput {
	s.LocationArn = &v
	return s
}

// CreateLocationNfsRequest
type CreateLocationNfsInput struct {
	_ struct{} `type:"structure"`

	// The NFS mount options that DataSync can use to mount your NFS share.
	MountOptions *NfsMountOptions `type:"structure"`

	// Contains a list of Amazon Resource Names (ARNs) of agents that are used to
	// connect to an NFS server.
	//
	// If you are copying data to or from your AWS Snowcone device, see NFS Server
	// on AWS Snowcone (https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone)
	// for more information.
	//
	// OnPremConfig is a required field
	OnPremConfig *OnPremConfig `type:"structure" required:"true"`

	// The name of the NFS server. This value is the IP address or Domain Name Service
	// (DNS) name of the NFS server. An agent that is installed on-premises uses
	// this host name to mount the NFS server in a network.
	//
	// If you are copying data to or from your AWS Snowcone device, see NFS Server
	// on AWS Snowcone (https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone)
	// for more information.
	//
	// This name must either be DNS-compliant or must be an IP version 4 (IPv4)
	// address.
	//
	// ServerHostname is a required field
	ServerHostname *string `type:"string" required:"true"`

	// The subdirectory in the NFS file system that is used to read data from the
	// NFS source location or write data to the NFS destination. The NFS path should
	// be a path that's exported by the NFS server, or a subdirectory of that path.
	// The path should be such that it can be mounted by other NFS clients in your
	// network.
	//
	// To see all the paths exported by your NFS server. run "showmount -e nfs-server-name"
	// from an NFS client that has access to your server. You can specify any directory
	// that appears in the results, and any subdirectory of that directory. Ensure
	// that the NFS export is accessible without Kerberos authentication.
	//
	// To transfer all the data in the folder you specified, DataSync needs to have
	// permissions to read all the data. To ensure this, either configure the NFS
	// export with no_root_squash, or ensure that the permissions for all of the
	// files that you want DataSync allow read access for all users. Doing either
	// enables the agent to read the files. For the agent to access directories,
	// you must additionally enable all execute access.
	//
	// If you are copying data to or from your AWS Snowcone device, see NFS Server
	// on AWS Snowcone (https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#nfs-on-snowcone)
	// for more information.
	//
	// For information about NFS export configuration, see 18.7. The /etc/exports
	// Configuration File in the Red Hat Enterprise Linux documentation.
	//
	// Subdirectory is a required field
	Subdirectory *string `type:"string" required:"true"`

	// The key-value pair that represents the tag that you want to add to the location.
	// The value can be an empty string. We recommend using tags to name your resources.
	Tags []*TagListEntry `type:"list"`
}

// String returns the string representation
func (s CreateLocationNfsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLocationNfsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLocationNfsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLocationNfsInput"}
	if s.OnPremConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OnPremConfig"))
	}
	if s.ServerHostname == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerHostname"))
	}
	if s.Subdirectory == nil {
		invalidParams.Add(request.NewErrParamRequired("Subdirectory"))
	}
	if s.OnPremConfig != nil {
		if err := s.OnPremConfig.Validate(); err != nil {
			invalidParams.AddNested("OnPremConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMountOptions sets the MountOptions field's value.
func (s *CreateLocationNfsInput) SetMountOptions(v *NfsMountOptions) *CreateLocationNfsInput {
	s.MountOptions = v
	return s
}

// SetOnPremConfig sets the OnPremConfig field's value.
func (s *CreateLocationNfsInput) SetOnPremConfig(v *OnPremConfig) *CreateLocationNfsInput {
	s.OnPremConfig = v
	return s
}

// SetServerHostname sets the ServerHostname field's value.
func (s *CreateLocationNfsInput) SetServerHostname(v string) *CreateLocationNfsInput {
	s.ServerHostname = &v
	return s
}

// SetSubdirectory sets the Subdirectory field's value.
func (s *CreateLocationNfsInput) SetSubdirectory(v string) *CreateLocationNfsInput {
	s.Subdirectory = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLocationNfsInput) SetTags(v []*TagListEntry) *CreateLocationNfsInput {
	s.Tags = v
	return s
}

// CreateLocationNfsResponse
type CreateLocationNfsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the source NFS file system location that
	// is created.
	LocationArn *string `type:"string"`
}

// String returns the string representation
func (s CreateLocationNfsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLocationNfsOutput) GoString() string {
	return s.String()
}

// SetLocationArn sets the LocationArn field's value.
func (s *CreateLocationNfsOutput) SetLocationArn(v string) *CreateLocationNfsOutput {
	s.LocationArn = &v
	return s
}

// CreateLocationObjectStorageRequest
type CreateLocationObjectStorageInput struct {
	_ struct{} `type:"structure"`

	// Optional. The access key is used if credentials are required to access the
	// self-managed object storage server.
	AccessKey *string `min:"8" type:"string"`

	// The Amazon Resource Name (ARN) of the agents associated with the self-managed
	// object storage server location.
	//
	// AgentArns is a required field
	AgentArns []*string `min:"1" type:"list" required:"true"`

	// The bucket on the self-managed object storage server that is used to read
	// data from.
	//
	// BucketName is a required field
	BucketName *string `min:"3" type:"string" required:"true"`

	// Optional. The secret key is used if credentials are required to access the
	// self-managed object storage server.
	SecretKey *string `min:"8" type:"string" sensitive:"true"`

	// The name of the self-managed object storage server. This value is the IP
	// address or Domain Name Service (DNS) name of the object storage server. An
	// agent uses this host name to mount the object storage server in a network.
	//
	// ServerHostname is a required field
	ServerHostname *string `type:"string" required:"true"`

	// The port that your self-managed object storage server accepts inbound network
	// traffic on. The server port is set by default to TCP 80 (HTTP) or TCP 443
	// (HTTPS). You can specify a custom port if your self-managed object storage
	// server requires one.
	ServerPort *int64 `min:"1" type:"integer"`

	// The protocol that the object storage server uses to communicate. Valid values
	// are HTTP or HTTPS.
	ServerProtocol *string `type:"string" enum:"ObjectStorageServerProtocol"`

	// The subdirectory in the self-managed object storage server that is used to
	// read data from.
	Subdirectory *string `type:"string"`

	// The key-value pair that represents the tag that you want to add to the location.
	// The value can be an empty string. We recommend using tags to name your resources.
	Tags []*TagListEntry `type:"list"`
}

// String returns the string representation
func (s CreateLocationObjectStorageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLocationObjectStorageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLocationObjectStorageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLocationObjectStorageInput"}
	if s.AccessKey != nil && len(*s.AccessKey) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("AccessKey", 8))
	}
	if s.AgentArns == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentArns"))
	}
	if s.AgentArns != nil && len(s.AgentArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentArns", 1))
	}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}
	if s.SecretKey != nil && len(*s.SecretKey) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("SecretKey", 8))
	}
	if s.ServerHostname == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerHostname"))
	}
	if s.ServerPort != nil && *s.ServerPort < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ServerPort", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessKey sets the AccessKey field's value.
func (s *CreateLocationObjectStorageInput) SetAccessKey(v string) *CreateLocationObjectStorageInput {
	s.AccessKey = &v
	return s
}

// SetAgentArns sets the AgentArns field's value.
func (s *CreateLocationObjectStorageInput) SetAgentArns(v []*string) *CreateLocationObjectStorageInput {
	s.AgentArns = v
	return s
}

// SetBucketName sets the BucketName field's value.
func (s *CreateLocationObjectStorageInput) SetBucketName(v string) *CreateLocationObjectStorageInput {
	s.BucketName = &v
	return s
}

// SetSecretKey sets the SecretKey field's value.
func (s *CreateLocationObjectStorageInput) SetSecretKey(v string) *CreateLocationObjectStorageInput {
	s.SecretKey = &v
	return s
}

// SetServerHostname sets the ServerHostname field's value.
func (s *CreateLocationObjectStorageInput) SetServerHostname(v string) *CreateLocationObjectStorageInput {
	s.ServerHostname = &v
	return s
}

// SetServerPort sets the ServerPort field's value.
func (s *CreateLocationObjectStorageInput) SetServerPort(v int64) *CreateLocationObjectStorageInput {
	s.ServerPort = &v
	return s
}

// SetServerProtocol sets the ServerProtocol field's value.
func (s *CreateLocationObjectStorageInput) SetServerProtocol(v string) *CreateLocationObjectStorageInput {
	s.ServerProtocol = &v
	return s
}

// SetSubdirectory sets the Subdirectory field's value.
func (s *CreateLocationObjectStorageInput) SetSubdirectory(v string) *CreateLocationObjectStorageInput {
	s.Subdirectory = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLocationObjectStorageInput) SetTags(v []*TagListEntry) *CreateLocationObjectStorageInput {
	s.Tags = v
	return s
}

// CreateLocationObjectStorageResponse
type CreateLocationObjectStorageOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the agents associated with the self-managed
	// object storage server location.
	LocationArn *string `type:"string"`
}

// String returns the string representation
func (s CreateLocationObjectStorageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLocationObjectStorageOutput) GoString() string {
	return s.String()
}

// SetLocationArn sets the LocationArn field's value.
func (s *CreateLocationObjectStorageOutput) SetLocationArn(v string) *CreateLocationObjectStorageOutput {
	s.LocationArn = &v
	return s
}

// CreateLocationS3Request
type CreateLocationS3Input struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon S3 bucket.
	//
	// S3BucketArn is a required field
	S3BucketArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that is used to access an Amazon S3 bucket.
	//
	// For detailed information about using such a role, see Creating a Location
	// for Amazon S3 in the AWS DataSync User Guide.
	//
	// S3Config is a required field
	S3Config *S3Config `type:"structure" required:"true"`

	// The Amazon S3 storage class that you want to store your files in when this
	// location is used as a task destination. For more information about S3 storage
	// classes, see Amazon S3 Storage Classes (https://aws.amazon.com/s3/storage-classes/)
	// in the Amazon Simple Storage Service Developer Guide. Some storage classes
	// have behaviors that can affect your S3 storage cost. For detailed information,
	// see using-storage-classes.
	S3StorageClass *string `type:"string" enum:"S3StorageClass"`

	// A subdirectory in the Amazon S3 bucket. This subdirectory in Amazon S3 is
	// used to read data from the S3 source location or write data to the S3 destination.
	Subdirectory *string `type:"string"`

	// The key-value pair that represents the tag that you want to add to the location.
	// The value can be an empty string. We recommend using tags to name your resources.
	Tags []*TagListEntry `type:"list"`
}

// String returns the string representation
func (s CreateLocationS3Input) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLocationS3Input) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLocationS3Input) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLocationS3Input"}
	if s.S3BucketArn == nil {
		invalidParams.Add(request.NewErrParamRequired("S3BucketArn"))
	}
	if s.S3Config == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Config"))
	}
	if s.S3Config != nil {
		if err := s.S3Config.Validate(); err != nil {
			invalidParams.AddNested("S3Config", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3BucketArn sets the S3BucketArn field's value.
func (s *CreateLocationS3Input) SetS3BucketArn(v string) *CreateLocationS3Input {
	s.S3BucketArn = &v
	return s
}

// SetS3Config sets the S3Config field's value.
func (s *CreateLocationS3Input) SetS3Config(v *S3Config) *CreateLocationS3Input {
	s.S3Config = v
	return s
}

// SetS3StorageClass sets the S3StorageClass field's value.
func (s *CreateLocationS3Input) SetS3StorageClass(v string) *CreateLocationS3Input {
	s.S3StorageClass = &v
	return s
}

// SetSubdirectory sets the Subdirectory field's value.
func (s *CreateLocationS3Input) SetSubdirectory(v string) *CreateLocationS3Input {
	s.Subdirectory = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLocationS3Input) SetTags(v []*TagListEntry) *CreateLocationS3Input {
	s.Tags = v
	return s
}

// CreateLocationS3Response
type CreateLocationS3Output struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the source Amazon S3 bucket location that
	// is created.
	LocationArn *string `type:"string"`
}

// String returns the string representation
func (s CreateLocationS3Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLocationS3Output) GoString() string {
	return s.String()
}

// SetLocationArn sets the LocationArn field's value.
func (s *CreateLocationS3Output) SetLocationArn(v string) *CreateLocationS3Output {
	s.LocationArn = &v
	return s
}

// CreateLocationSmbRequest
type CreateLocationSmbInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Names (ARNs) of agents to use for a Simple Message Block
	// (SMB) location.
	//
	// AgentArns is a required field
	AgentArns []*string `min:"1" type:"list" required:"true"`

	// The name of the Windows domain that the SMB server belongs to.
	Domain *string `type:"string"`

	// The mount options used by DataSync to access the SMB server.
	MountOptions *SmbMountOptions `type:"structure"`

	// The password of the user who can mount the share, has the permissions to
	// access files and folders in the SMB share.
	//
	// Password is a required field
	Password *string `type:"string" required:"true" sensitive:"true"`

	// The name of the SMB server. This value is the IP address or Domain Name Service
	// (DNS) name of the SMB server. An agent that is installed on-premises uses
	// this hostname to mount the SMB server in a network.
	//
	// This name must either be DNS-compliant or must be an IP version 4 (IPv4)
	// address.
	//
	// ServerHostname is a required field
	ServerHostname *string `type:"string" required:"true"`

	// The subdirectory in the SMB file system that is used to read data from the
	// SMB source location or write data to the SMB destination. The SMB path should
	// be a path that's exported by the SMB server, or a subdirectory of that path.
	// The path should be such that it can be mounted by other SMB clients in your
	// network.
	//
	// Subdirectory must be specified with forward slashes. For example, /path/to/folder.
	//
	// To transfer all the data in the folder you specified, DataSync needs to have
	// permissions to mount the SMB share, as well as to access all the data in
	// that share. To ensure this, either ensure that the user/password specified
	// belongs to the user who can mount the share, and who has the appropriate
	// permissions for all of the files and directories that you want DataSync to
	// access, or use credentials of a member of the Backup Operators group to mount
	// the share. Doing either enables the agent to access the data. For the agent
	// to access directories, you must additionally enable all execute access.
	//
	// Subdirectory is a required field
	Subdirectory *string `type:"string" required:"true"`

	// The key-value pair that represents the tag that you want to add to the location.
	// The value can be an empty string. We recommend using tags to name your resources.
	Tags []*TagListEntry `type:"list"`

	// The user who can mount the share, has the permissions to access files and
	// folders in the SMB share.
	//
	// User is a required field
	User *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateLocationSmbInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLocationSmbInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLocationSmbInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLocationSmbInput"}
	if s.AgentArns == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentArns"))
	}
	if s.AgentArns != nil && len(s.AgentArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentArns", 1))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.ServerHostname == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerHostname"))
	}
	if s.Subdirectory == nil {
		invalidParams.Add(request.NewErrParamRequired("Subdirectory"))
	}
	if s.User == nil {
		invalidParams.Add(request.NewErrParamRequired("User"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentArns sets the AgentArns field's value.
func (s *CreateLocationSmbInput) SetAgentArns(v []*string) *CreateLocationSmbInput {
	s.AgentArns = v
	return s
}

// SetDomain sets the Domain field's value.
func (s *CreateLocationSmbInput) SetDomain(v string) *CreateLocationSmbInput {
	s.Domain = &v
	return s
}

// SetMountOptions sets the MountOptions field's value.
func (s *CreateLocationSmbInput) SetMountOptions(v *SmbMountOptions) *CreateLocationSmbInput {
	s.MountOptions = v
	return s
}

// SetPassword sets the Password field's value.
func (s *CreateLocationSmbInput) SetPassword(v string) *CreateLocationSmbInput {
	s.Password = &v
	return s
}

// SetServerHostname sets the ServerHostname field's value.
func (s *CreateLocationSmbInput) SetServerHostname(v string) *CreateLocationSmbInput {
	s.ServerHostname = &v
	return s
}

// SetSubdirectory sets the Subdirectory field's value.
func (s *CreateLocationSmbInput) SetSubdirectory(v string) *CreateLocationSmbInput {
	s.Subdirectory = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLocationSmbInput) SetTags(v []*TagListEntry) *CreateLocationSmbInput {
	s.Tags = v
	return s
}

// SetUser sets the User field's value.
func (s *CreateLocationSmbInput) SetUser(v string) *CreateLocationSmbInput {
	s.User = &v
	return s
}

// CreateLocationSmbResponse
type CreateLocationSmbOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the source SMB file system location that
	// is created.
	LocationArn *string `type:"string"`
}

// String returns the string representation
func (s CreateLocationSmbOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLocationSmbOutput) GoString() string {
	return s.String()
}

// SetLocationArn sets the LocationArn field's value.
func (s *CreateLocationSmbOutput) SetLocationArn(v string) *CreateLocationSmbOutput {
	s.LocationArn = &v
	return s
}

// CreateTaskRequest
type CreateTaskInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is
	// used to monitor and log events in the task.
	CloudWatchLogGroupArn *string `type:"string"`

	// The Amazon Resource Name (ARN) of an AWS storage resource's location.
	//
	// DestinationLocationArn is a required field
	DestinationLocationArn *string `type:"string" required:"true"`

	// A list of filter rules that determines which files to exclude from a task.
	// The list should contain a single filter string that consists of the patterns
	// to exclude. The patterns are delimited by "|" (that is, a pipe), for example,
	// "/folder1|/folder2"
	Excludes []*FilterRule `type:"list"`

	// The name of a task. This value is a text reference that is used to identify
	// the task in the console.
	Name *string `min:"1" type:"string"`

	// The set of configuration options that control the behavior of a single execution
	// of the task that occurs when you call StartTaskExecution. You can configure
	// these options to preserve metadata such as user ID (UID) and group ID (GID),
	// file permissions, data integrity verification, and so on.
	//
	// For each individual task execution, you can override these options by specifying
	// the OverrideOptions before starting the task execution. For more information,
	// see the operation.
	Options *Options `type:"structure"`

	// Specifies a schedule used to periodically transfer files from a source to
	// a destination location. The schedule should be specified in UTC time. For
	// more information, see task-scheduling.
	Schedule *TaskSchedule `type:"structure"`

	// The Amazon Resource Name (ARN) of the source location for the task.
	//
	// SourceLocationArn is a required field
	SourceLocationArn *string `type:"string" required:"true"`

	// The key-value pair that represents the tag that you want to add to the resource.
	// The value can be an empty string.
	Tags []*TagListEntry `type:"list"`
}

// String returns the string representation
func (s CreateTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTaskInput"}
	if s.DestinationLocationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationLocationArn"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SourceLocationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceLocationArn"))
	}
	if s.Options != nil {
		if err := s.Options.Validate(); err != nil {
			invalidParams.AddNested("Options", err.(request.ErrInvalidParams))
		}
	}
	if s.Schedule != nil {
		if err := s.Schedule.Validate(); err != nil {
			invalidParams.AddNested("Schedule", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLogGroupArn sets the CloudWatchLogGroupArn field's value.
func (s *CreateTaskInput) SetCloudWatchLogGroupArn(v string) *CreateTaskInput {
	s.CloudWatchLogGroupArn = &v
	return s
}

// SetDestinationLocationArn sets the DestinationLocationArn field's value.
func (s *CreateTaskInput) SetDestinationLocationArn(v string) *CreateTaskInput {
	s.DestinationLocationArn = &v
	return s
}

// SetExcludes sets the Excludes field's value.
func (s *CreateTaskInput) SetExcludes(v []*FilterRule) *CreateTaskInput {
	s.Excludes = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateTaskInput) SetName(v string) *CreateTaskInput {
	s.Name = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *CreateTaskInput) SetOptions(v *Options) *CreateTaskInput {
	s.Options = v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *CreateTaskInput) SetSchedule(v *TaskSchedule) *CreateTaskInput {
	s.Schedule = v
	return s
}

// SetSourceLocationArn sets the SourceLocationArn field's value.
func (s *CreateTaskInput) SetSourceLocationArn(v string) *CreateTaskInput {
	s.SourceLocationArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTaskInput) SetTags(v []*TagListEntry) *CreateTaskInput {
	s.Tags = v
	return s
}

// CreateTaskResponse
type CreateTaskOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the task.
	TaskArn *string `type:"string"`
}

// String returns the string representation
func (s CreateTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTaskOutput) GoString() string {
	return s.String()
}

// SetTaskArn sets the TaskArn field's value.
func (s *CreateTaskOutput) SetTaskArn(v string) *CreateTaskOutput {
	s.TaskArn = &v
	return s
}

// DeleteAgentRequest
type DeleteAgentInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the agent to delete. Use the ListAgents
	// operation to return a list of agents for your account and AWS Region.
	//
	// AgentArn is a required field
	AgentArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAgentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAgentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAgentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAgentInput"}
	if s.AgentArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentArn sets the AgentArn field's value.
func (s *DeleteAgentInput) SetAgentArn(v string) *DeleteAgentInput {
	s.AgentArn = &v
	return s
}

type DeleteAgentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAgentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAgentOutput) GoString() string {
	return s.String()
}

// DeleteLocation
type DeleteLocationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the location to delete.
	//
	// LocationArn is a required field
	LocationArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLocationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLocationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLocationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLocationInput"}
	if s.LocationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LocationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocationArn sets the LocationArn field's value.
func (s *DeleteLocationInput) SetLocationArn(v string) *DeleteLocationInput {
	s.LocationArn = &v
	return s
}

type DeleteLocationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLocationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLocationOutput) GoString() string {
	return s.String()
}

// DeleteTask
type DeleteTaskInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the task to delete.
	//
	// TaskArn is a required field
	TaskArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTaskInput"}
	if s.TaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaskArn sets the TaskArn field's value.
func (s *DeleteTaskInput) SetTaskArn(v string) *DeleteTaskInput {
	s.TaskArn = &v
	return s
}

type DeleteTaskOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTaskOutput) GoString() string {
	return s.String()
}

// DescribeAgent
type DescribeAgentInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the agent to describe.
	//
	// AgentArn is a required field
	AgentArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAgentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAgentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAgentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAgentInput"}
	if s.AgentArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentArn sets the AgentArn field's value.
func (s *DescribeAgentInput) SetAgentArn(v string) *DescribeAgentInput {
	s.AgentArn = &v
	return s
}

// DescribeAgentResponse
type DescribeAgentOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the agent.
	AgentArn *string `type:"string"`

	// The time that the agent was activated (that is, created in your account).
	CreationTime *time.Time `type:"timestamp"`

	// The type of endpoint that your agent is connected to. If the endpoint is
	// a VPC endpoint, the agent is not accessible over the public internet.
	EndpointType *string `type:"string" enum:"EndpointType"`

	// The time that the agent last connected to DataSyc.
	LastConnectionTime *time.Time `type:"timestamp"`

	// The name of the agent.
	Name *string `min:"1" type:"string"`

	// The subnet and the security group that DataSync used to access a VPC endpoint.
	PrivateLinkConfig *PrivateLinkConfig `type:"structure"`

	// The status of the agent. If the status is ONLINE, then the agent is configured
	// properly and is available to use. The Running status is the normal running
	// status for an agent. If the status is OFFLINE, the agent's VM is turned off
	// or the agent is in an unhealthy state. When the issue that caused the unhealthy
	// state is resolved, the agent returns to ONLINE status.
	Status *string `type:"string" enum:"AgentStatus"`
}

// String returns the string representation
func (s DescribeAgentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAgentOutput) GoString() string {
	return s.String()
}

// SetAgentArn sets the AgentArn field's value.
func (s *DescribeAgentOutput) SetAgentArn(v string) *DescribeAgentOutput {
	s.AgentArn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeAgentOutput) SetCreationTime(v time.Time) *DescribeAgentOutput {
	s.CreationTime = &v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *DescribeAgentOutput) SetEndpointType(v string) *DescribeAgentOutput {
	s.EndpointType = &v
	return s
}

// SetLastConnectionTime sets the LastConnectionTime field's value.
func (s *DescribeAgentOutput) SetLastConnectionTime(v time.Time) *DescribeAgentOutput {
	s.LastConnectionTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeAgentOutput) SetName(v string) *DescribeAgentOutput {
	s.Name = &v
	return s
}

// SetPrivateLinkConfig sets the PrivateLinkConfig field's value.
func (s *DescribeAgentOutput) SetPrivateLinkConfig(v *PrivateLinkConfig) *DescribeAgentOutput {
	s.PrivateLinkConfig = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeAgentOutput) SetStatus(v string) *DescribeAgentOutput {
	s.Status = &v
	return s
}

// DescribeLocationEfsRequest
type DescribeLocationEfsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the EFS location to describe.
	//
	// LocationArn is a required field
	LocationArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeLocationEfsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLocationEfsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLocationEfsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLocationEfsInput"}
	if s.LocationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LocationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationEfsInput) SetLocationArn(v string) *DescribeLocationEfsInput {
	s.LocationArn = &v
	return s
}

// DescribeLocationEfsResponse
type DescribeLocationEfsOutput struct {
	_ struct{} `type:"structure"`

	// The time that the EFS location was created.
	CreationTime *time.Time `type:"timestamp"`

	// The subnet and the security group that DataSync uses to access target EFS
	// file system. The subnet must have at least one mount target for that file
	// system. The security group that you provide needs to be able to communicate
	// with the security group on the mount target in the subnet specified.
	Ec2Config *Ec2Config `type:"structure"`

	// The Amazon Resource Name (ARN) of the EFS location that was described.
	LocationArn *string `type:"string"`

	// The URL of the EFS location that was described.
	LocationUri *string `type:"string"`
}

// String returns the string representation
func (s DescribeLocationEfsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLocationEfsOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeLocationEfsOutput) SetCreationTime(v time.Time) *DescribeLocationEfsOutput {
	s.CreationTime = &v
	return s
}

// SetEc2Config sets the Ec2Config field's value.
func (s *DescribeLocationEfsOutput) SetEc2Config(v *Ec2Config) *DescribeLocationEfsOutput {
	s.Ec2Config = v
	return s
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationEfsOutput) SetLocationArn(v string) *DescribeLocationEfsOutput {
	s.LocationArn = &v
	return s
}

// SetLocationUri sets the LocationUri field's value.
func (s *DescribeLocationEfsOutput) SetLocationUri(v string) *DescribeLocationEfsOutput {
	s.LocationUri = &v
	return s
}

type DescribeLocationFsxWindowsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the FSx for Windows location to describe.
	//
	// LocationArn is a required field
	LocationArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeLocationFsxWindowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLocationFsxWindowsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLocationFsxWindowsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLocationFsxWindowsInput"}
	if s.LocationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LocationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationFsxWindowsInput) SetLocationArn(v string) *DescribeLocationFsxWindowsInput {
	s.LocationArn = &v
	return s
}

type DescribeLocationFsxWindowsOutput struct {
	_ struct{} `type:"structure"`

	// The time that the FSx for Windows location was created.
	CreationTime *time.Time `type:"timestamp"`

	// The name of the Windows domain that the FSx for Windows server belongs to.
	Domain *string `type:"string"`

	// The Amazon Resource Name (ARN) of the FSx for Windows location that was described.
	LocationArn *string `type:"string"`

	// The URL of the FSx for Windows location that was described.
	LocationUri *string `type:"string"`

	// The Amazon Resource Names (ARNs) of the security groups that are configured
	// for the FSx for Windows file system.
	SecurityGroupArns []*string `min:"1" type:"list"`

	// The user who has the permissions to access files and folders in the FSx for
	// Windows file system.
	User *string `type:"string"`
}

// String returns the string representation
func (s DescribeLocationFsxWindowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLocationFsxWindowsOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeLocationFsxWindowsOutput) SetCreationTime(v time.Time) *DescribeLocationFsxWindowsOutput {
	s.CreationTime = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *DescribeLocationFsxWindowsOutput) SetDomain(v string) *DescribeLocationFsxWindowsOutput {
	s.Domain = &v
	return s
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationFsxWindowsOutput) SetLocationArn(v string) *DescribeLocationFsxWindowsOutput {
	s.LocationArn = &v
	return s
}

// SetLocationUri sets the LocationUri field's value.
func (s *DescribeLocationFsxWindowsOutput) SetLocationUri(v string) *DescribeLocationFsxWindowsOutput {
	s.LocationUri = &v
	return s
}

// SetSecurityGroupArns sets the SecurityGroupArns field's value.
func (s *DescribeLocationFsxWindowsOutput) SetSecurityGroupArns(v []*string) *DescribeLocationFsxWindowsOutput {
	s.SecurityGroupArns = v
	return s
}

// SetUser sets the User field's value.
func (s *DescribeLocationFsxWindowsOutput) SetUser(v string) *DescribeLocationFsxWindowsOutput {
	s.User = &v
	return s
}

// DescribeLocationNfsRequest
type DescribeLocationNfsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the NFS location to describe.
	//
	// LocationArn is a required field
	LocationArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeLocationNfsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLocationNfsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLocationNfsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLocationNfsInput"}
	if s.LocationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LocationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationNfsInput) SetLocationArn(v string) *DescribeLocationNfsInput {
	s.LocationArn = &v
	return s
}

// DescribeLocationNfsResponse
type DescribeLocationNfsOutput struct {
	_ struct{} `type:"structure"`

	// The time that the NFS location was created.
	CreationTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the NFS location that was described.
	LocationArn *string `type:"string"`

	// The URL of the source NFS location that was described.
	LocationUri *string `type:"string"`

	// The NFS mount options that DataSync used to mount your NFS share.
	MountOptions *NfsMountOptions `type:"structure"`

	// A list of Amazon Resource Names (ARNs) of agents to use for a Network File
	// System (NFS) location.
	OnPremConfig *OnPremConfig `type:"structure"`
}

// String returns the string representation
func (s DescribeLocationNfsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLocationNfsOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeLocationNfsOutput) SetCreationTime(v time.Time) *DescribeLocationNfsOutput {
	s.CreationTime = &v
	return s
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationNfsOutput) SetLocationArn(v string) *DescribeLocationNfsOutput {
	s.LocationArn = &v
	return s
}

// SetLocationUri sets the LocationUri field's value.
func (s *DescribeLocationNfsOutput) SetLocationUri(v string) *DescribeLocationNfsOutput {
	s.LocationUri = &v
	return s
}

// SetMountOptions sets the MountOptions field's value.
func (s *DescribeLocationNfsOutput) SetMountOptions(v *NfsMountOptions) *DescribeLocationNfsOutput {
	s.MountOptions = v
	return s
}

// SetOnPremConfig sets the OnPremConfig field's value.
func (s *DescribeLocationNfsOutput) SetOnPremConfig(v *OnPremConfig) *DescribeLocationNfsOutput {
	s.OnPremConfig = v
	return s
}

// DescribeLocationObjectStorageRequest
type DescribeLocationObjectStorageInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the self-managed object storage server
	// location that was described.
	//
	// LocationArn is a required field
	LocationArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeLocationObjectStorageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLocationObjectStorageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLocationObjectStorageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLocationObjectStorageInput"}
	if s.LocationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LocationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationObjectStorageInput) SetLocationArn(v string) *DescribeLocationObjectStorageInput {
	s.LocationArn = &v
	return s
}

// DescribeLocationObjectStorageResponse
type DescribeLocationObjectStorageOutput struct {
	_ struct{} `type:"structure"`

	// Optional. The access key is used if credentials are required to access the
	// self-managed object storage server.
	AccessKey *string `min:"8" type:"string"`

	// The Amazon Resource Name (ARN) of the agents associated with the self-managed
	// object storage server location.
	AgentArns []*string `min:"1" type:"list"`

	// The time that the self-managed object storage server agent was created.
	CreationTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the self-managed object storage server
	// location to describe.
	LocationArn *string `type:"string"`

	// The URL of the source self-managed object storage server location that was
	// described.
	LocationUri *string `type:"string"`

	// The port that your self-managed object storage server accepts inbound network
	// traffic on. The server port is set by default to TCP 80 (HTTP) or TCP 443
	// (HTTPS).
	ServerPort *int64 `min:"1" type:"integer"`

	// The protocol that the object storage server uses to communicate. Valid values
	// are HTTP or HTTPS.
	ServerProtocol *string `type:"string" enum:"ObjectStorageServerProtocol"`
}

// String returns the string representation
func (s DescribeLocationObjectStorageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLocationObjectStorageOutput) GoString() string {
	return s.String()
}

// SetAccessKey sets the AccessKey field's value.
func (s *DescribeLocationObjectStorageOutput) SetAccessKey(v string) *DescribeLocationObjectStorageOutput {
	s.AccessKey = &v
	return s
}

// SetAgentArns sets the AgentArns field's value.
func (s *DescribeLocationObjectStorageOutput) SetAgentArns(v []*string) *DescribeLocationObjectStorageOutput {
	s.AgentArns = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeLocationObjectStorageOutput) SetCreationTime(v time.Time) *DescribeLocationObjectStorageOutput {
	s.CreationTime = &v
	return s
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationObjectStorageOutput) SetLocationArn(v string) *DescribeLocationObjectStorageOutput {
	s.LocationArn = &v
	return s
}

// SetLocationUri sets the LocationUri field's value.
func (s *DescribeLocationObjectStorageOutput) SetLocationUri(v string) *DescribeLocationObjectStorageOutput {
	s.LocationUri = &v
	return s
}

// SetServerPort sets the ServerPort field's value.
func (s *DescribeLocationObjectStorageOutput) SetServerPort(v int64) *DescribeLocationObjectStorageOutput {
	s.ServerPort = &v
	return s
}

// SetServerProtocol sets the ServerProtocol field's value.
func (s *DescribeLocationObjectStorageOutput) SetServerProtocol(v string) *DescribeLocationObjectStorageOutput {
	s.ServerProtocol = &v
	return s
}

// DescribeLocationS3Request
type DescribeLocationS3Input struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon S3 bucket location to describe.
	//
	// LocationArn is a required field
	LocationArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeLocationS3Input) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLocationS3Input) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLocationS3Input) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLocationS3Input"}
	if s.LocationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LocationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationS3Input) SetLocationArn(v string) *DescribeLocationS3Input {
	s.LocationArn = &v
	return s
}

// DescribeLocationS3Response
type DescribeLocationS3Output struct {
	_ struct{} `type:"structure"`

	// The time that the Amazon S3 bucket location was created.
	CreationTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the Amazon S3 bucket location.
	LocationArn *string `type:"string"`

	// The URL of the Amazon S3 location that was described.
	LocationUri *string `type:"string"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that is used to access an Amazon S3 bucket.
	//
	// For detailed information about using such a role, see Creating a Location
	// for Amazon S3 in the AWS DataSync User Guide.
	S3Config *S3Config `type:"structure"`

	// The Amazon S3 storage class that you chose to store your files in when this
	// location is used as a task destination. For more information about S3 storage
	// classes, see Amazon S3 Storage Classes (https://aws.amazon.com/s3/storage-classes/)
	// in the Amazon Simple Storage Service Developer Guide. Some storage classes
	// have behaviors that can affect your S3 storage cost. For detailed information,
	// see using-storage-classes.
	S3StorageClass *string `type:"string" enum:"S3StorageClass"`
}

// String returns the string representation
func (s DescribeLocationS3Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLocationS3Output) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeLocationS3Output) SetCreationTime(v time.Time) *DescribeLocationS3Output {
	s.CreationTime = &v
	return s
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationS3Output) SetLocationArn(v string) *DescribeLocationS3Output {
	s.LocationArn = &v
	return s
}

// SetLocationUri sets the LocationUri field's value.
func (s *DescribeLocationS3Output) SetLocationUri(v string) *DescribeLocationS3Output {
	s.LocationUri = &v
	return s
}

// SetS3Config sets the S3Config field's value.
func (s *DescribeLocationS3Output) SetS3Config(v *S3Config) *DescribeLocationS3Output {
	s.S3Config = v
	return s
}

// SetS3StorageClass sets the S3StorageClass field's value.
func (s *DescribeLocationS3Output) SetS3StorageClass(v string) *DescribeLocationS3Output {
	s.S3StorageClass = &v
	return s
}

// DescribeLocationSmbRequest
type DescribeLocationSmbInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the SMB location to describe.
	//
	// LocationArn is a required field
	LocationArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeLocationSmbInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLocationSmbInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLocationSmbInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLocationSmbInput"}
	if s.LocationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LocationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationSmbInput) SetLocationArn(v string) *DescribeLocationSmbInput {
	s.LocationArn = &v
	return s
}

// DescribeLocationSmbResponse
type DescribeLocationSmbOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the source SMB file system location that
	// is created.
	AgentArns []*string `min:"1" type:"list"`

	// The time that the SMB location was created.
	CreationTime *time.Time `type:"timestamp"`

	// The name of the Windows domain that the SMB server belongs to.
	Domain *string `type:"string"`

	// The Amazon Resource Name (ARN) of the SMB location that was described.
	LocationArn *string `type:"string"`

	// The URL of the source SBM location that was described.
	LocationUri *string `type:"string"`

	// The mount options that are available for DataSync to use to access an SMB
	// location.
	MountOptions *SmbMountOptions `type:"structure"`

	// The user who can mount the share, has the permissions to access files and
	// folders in the SMB share.
	User *string `type:"string"`
}

// String returns the string representation
func (s DescribeLocationSmbOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLocationSmbOutput) GoString() string {
	return s.String()
}

// SetAgentArns sets the AgentArns field's value.
func (s *DescribeLocationSmbOutput) SetAgentArns(v []*string) *DescribeLocationSmbOutput {
	s.AgentArns = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeLocationSmbOutput) SetCreationTime(v time.Time) *DescribeLocationSmbOutput {
	s.CreationTime = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *DescribeLocationSmbOutput) SetDomain(v string) *DescribeLocationSmbOutput {
	s.Domain = &v
	return s
}

// SetLocationArn sets the LocationArn field's value.
func (s *DescribeLocationSmbOutput) SetLocationArn(v string) *DescribeLocationSmbOutput {
	s.LocationArn = &v
	return s
}

// SetLocationUri sets the LocationUri field's value.
func (s *DescribeLocationSmbOutput) SetLocationUri(v string) *DescribeLocationSmbOutput {
	s.LocationUri = &v
	return s
}

// SetMountOptions sets the MountOptions field's value.
func (s *DescribeLocationSmbOutput) SetMountOptions(v *SmbMountOptions) *DescribeLocationSmbOutput {
	s.MountOptions = v
	return s
}

// SetUser sets the User field's value.
func (s *DescribeLocationSmbOutput) SetUser(v string) *DescribeLocationSmbOutput {
	s.User = &v
	return s
}

// DescribeTaskExecutionRequest
type DescribeTaskExecutionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the task that is being executed.
	//
	// TaskExecutionArn is a required field
	TaskExecutionArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTaskExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTaskExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTaskExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTaskExecutionInput"}
	if s.TaskExecutionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskExecutionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaskExecutionArn sets the TaskExecutionArn field's value.
func (s *DescribeTaskExecutionInput) SetTaskExecutionArn(v string) *DescribeTaskExecutionInput {
	s.TaskExecutionArn = &v
	return s
}

// DescribeTaskExecutionResponse
type DescribeTaskExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The physical number of bytes transferred over the network.
	BytesTransferred *int64 `type:"long"`

	// The number of logical bytes written to the destination AWS storage resource.
	BytesWritten *int64 `type:"long"`

	// The estimated physical number of bytes that is to be transferred over the
	// network.
	EstimatedBytesToTransfer *int64 `type:"long"`

	// The expected number of files that is to be transferred over the network.
	// This value is calculated during the PREPARING phase, before the TRANSFERRING
	// phase. This value is the expected number of files to be transferred. It's
	// calculated based on comparing the content of the source and destination locations
	// and finding the delta that needs to be transferred.
	EstimatedFilesToTransfer *int64 `type:"long"`

	// A list of filter rules that determines which files to exclude from a task.
	// The list should contain a single filter string that consists of the patterns
	// to exclude. The patterns are delimited by "|" (that is, a pipe), for example:
	// "/folder1|/folder2"
	Excludes []*FilterRule `type:"list"`

	// The actual number of files that was transferred over the network. This value
	// is calculated and updated on an ongoing basis during the TRANSFERRING phase.
	// It's updated periodically when each file is read from the source and sent
	// over the network.
	//
	// If failures occur during a transfer, this value can be less than EstimatedFilesToTransfer.
	// This value can also be greater than EstimatedFilesTransferred in some cases.
	// This element is implementation-specific for some location types, so don't
	// use it as an indicator for a correct file number or to monitor your task
	// execution.
	FilesTransferred *int64 `type:"long"`

	// A list of filter rules that determines which files to include when running
	// a task. The list should contain a single filter string that consists of the
	// patterns to include. The patterns are delimited by "|" (that is, a pipe),
	// for example: "/folder1|/folder2"
	Includes []*FilterRule `type:"list"`

	// Represents the options that are available to control the behavior of a StartTaskExecution
	// operation. Behavior includes preserving metadata such as user ID (UID), group
	// ID (GID), and file permissions, and also overwriting files in the destination,
	// data integrity verification, and so on.
	//
	// A task has a set of default options associated with it. If you don't specify
	// an option in StartTaskExecution, the default value is used. You can override
	// the defaults options on each task execution by specifying an overriding Options
	// value to StartTaskExecution.
	Options *Options `type:"structure"`

	// The result of the task execution.
	Result *TaskExecutionResultDetail `type:"structure"`

	// The time that the task execution was started.
	StartTime *time.Time `type:"timestamp"`

	// The status of the task execution.
	//
	// For detailed information about task execution statuses, see Understanding
	// Task Statuses in the AWS DataSync User Guide.
	Status *string `type:"string" enum:"TaskExecutionStatus"`

	// The Amazon Resource Name (ARN) of the task execution that was described.
	// TaskExecutionArn is hierarchical and includes TaskArn for the task that was
	// executed.
	//
	// For example, a TaskExecution value with the ARN arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2/execution/exec-08ef1e88ec491019b
	// executed the task with the ARN arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2.
	TaskExecutionArn *string `type:"string"`
}

// String returns the string representation
func (s DescribeTaskExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTaskExecutionOutput) GoString() string {
	return s.String()
}

// SetBytesTransferred sets the BytesTransferred field's value.
func (s *DescribeTaskExecutionOutput) SetBytesTransferred(v int64) *DescribeTaskExecutionOutput {
	s.BytesTransferred = &v
	return s
}

// SetBytesWritten sets the BytesWritten field's value.
func (s *DescribeTaskExecutionOutput) SetBytesWritten(v int64) *DescribeTaskExecutionOutput {
	s.BytesWritten = &v
	return s
}

// SetEstimatedBytesToTransfer sets the EstimatedBytesToTransfer field's value.
func (s *DescribeTaskExecutionOutput) SetEstimatedBytesToTransfer(v int64) *DescribeTaskExecutionOutput {
	s.EstimatedBytesToTransfer = &v
	return s
}

// SetEstimatedFilesToTransfer sets the EstimatedFilesToTransfer field's value.
func (s *DescribeTaskExecutionOutput) SetEstimatedFilesToTransfer(v int64) *DescribeTaskExecutionOutput {
	s.EstimatedFilesToTransfer = &v
	return s
}

// SetExcludes sets the Excludes field's value.
func (s *DescribeTaskExecutionOutput) SetExcludes(v []*FilterRule) *DescribeTaskExecutionOutput {
	s.Excludes = v
	return s
}

// SetFilesTransferred sets the FilesTransferred field's value.
func (s *DescribeTaskExecutionOutput) SetFilesTransferred(v int64) *DescribeTaskExecutionOutput {
	s.FilesTransferred = &v
	return s
}

// SetIncludes sets the Includes field's value.
func (s *DescribeTaskExecutionOutput) SetIncludes(v []*FilterRule) *DescribeTaskExecutionOutput {
	s.Includes = v
	return s
}

// SetOptions sets the Options field's value.
func (s *DescribeTaskExecutionOutput) SetOptions(v *Options) *DescribeTaskExecutionOutput {
	s.Options = v
	return s
}

// SetResult sets the Result field's value.
func (s *DescribeTaskExecutionOutput) SetResult(v *TaskExecutionResultDetail) *DescribeTaskExecutionOutput {
	s.Result = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeTaskExecutionOutput) SetStartTime(v time.Time) *DescribeTaskExecutionOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeTaskExecutionOutput) SetStatus(v string) *DescribeTaskExecutionOutput {
	s.Status = &v
	return s
}

// SetTaskExecutionArn sets the TaskExecutionArn field's value.
func (s *DescribeTaskExecutionOutput) SetTaskExecutionArn(v string) *DescribeTaskExecutionOutput {
	s.TaskExecutionArn = &v
	return s
}

// DescribeTaskRequest
type DescribeTaskInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the task to describe.
	//
	// TaskArn is a required field
	TaskArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTaskInput"}
	if s.TaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaskArn sets the TaskArn field's value.
func (s *DescribeTaskInput) SetTaskArn(v string) *DescribeTaskInput {
	s.TaskArn = &v
	return s
}

// DescribeTaskResponse
type DescribeTaskOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that was
	// used to monitor and log events in the task.
	//
	// For more information on these groups, see Working with Log Groups and Log
	// Streams in the Amazon CloudWatch User Guide.
	CloudWatchLogGroupArn *string `type:"string"`

	// The time that the task was created.
	CreationTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the task execution that is syncing files.
	CurrentTaskExecutionArn *string `type:"string"`

	// The Amazon Resource Name (ARN) of the AWS storage resource's location.
	DestinationLocationArn *string `type:"string"`

	// The Amazon Resource Name (ARN) of the destination ENIs (Elastic Network Interface)
	// that was created for your subnet.
	DestinationNetworkInterfaceArns []*string `type:"list"`

	// Errors that AWS DataSync encountered during execution of the task. You can
	// use this error code to help troubleshoot issues.
	ErrorCode *string `type:"string"`

	// Detailed description of an error that was encountered during the task execution.
	// You can use this information to help troubleshoot issues.
	ErrorDetail *string `type:"string"`

	// A list of filter rules that determines which files to exclude from a task.
	// The list should contain a single filter string that consists of the patterns
	// to exclude. The patterns are delimited by "|" (that is, a pipe), for example:
	// "/folder1|/folder2"
	Excludes []*FilterRule `type:"list"`

	// The name of the task that was described.
	Name *string `min:"1" type:"string"`

	// The set of configuration options that control the behavior of a single execution
	// of the task that occurs when you call StartTaskExecution. You can configure
	// these options to preserve metadata such as user ID (UID) and group (GID),
	// file permissions, data integrity verification, and so on.
	//
	// For each individual task execution, you can override these options by specifying
	// the overriding OverrideOptions value to operation.
	Options *Options `type:"structure"`

	// The schedule used to periodically transfer files from a source to a destination
	// location.
	Schedule *TaskSchedule `type:"structure"`

	// The Amazon Resource Name (ARN) of the source file system's location.
	SourceLocationArn *string `type:"string"`

	// The Amazon Resource Name (ARN) of the source ENIs (Elastic Network Interface)
	// that was created for your subnet.
	SourceNetworkInterfaceArns []*string `type:"list"`

	// The status of the task that was described.
	//
	// For detailed information about task execution statuses, see Understanding
	// Task Statuses in the AWS DataSync User Guide.
	Status *string `type:"string" enum:"TaskStatus"`

	// The Amazon Resource Name (ARN) of the task that was described.
	TaskArn *string `type:"string"`
}

// String returns the string representation
func (s DescribeTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTaskOutput) GoString() string {
	return s.String()
}

// SetCloudWatchLogGroupArn sets the CloudWatchLogGroupArn field's value.
func (s *DescribeTaskOutput) SetCloudWatchLogGroupArn(v string) *DescribeTaskOutput {
	s.CloudWatchLogGroupArn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeTaskOutput) SetCreationTime(v time.Time) *DescribeTaskOutput {
	s.CreationTime = &v
	return s
}

// SetCurrentTaskExecutionArn sets the CurrentTaskExecutionArn field's value.
func (s *DescribeTaskOutput) SetCurrentTaskExecutionArn(v string) *DescribeTaskOutput {
	s.CurrentTaskExecutionArn = &v
	return s
}

// SetDestinationLocationArn sets the DestinationLocationArn field's value.
func (s *DescribeTaskOutput) SetDestinationLocationArn(v string) *DescribeTaskOutput {
	s.DestinationLocationArn = &v
	return s
}

// SetDestinationNetworkInterfaceArns sets the DestinationNetworkInterfaceArns field's value.
func (s *DescribeTaskOutput) SetDestinationNetworkInterfaceArns(v []*string) *DescribeTaskOutput {
	s.DestinationNetworkInterfaceArns = v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *DescribeTaskOutput) SetErrorCode(v string) *DescribeTaskOutput {
	s.ErrorCode = &v
	return s
}

// SetErrorDetail sets the ErrorDetail field's value.
func (s *DescribeTaskOutput) SetErrorDetail(v string) *DescribeTaskOutput {
	s.ErrorDetail = &v
	return s
}

// SetExcludes sets the Excludes field's value.
func (s *DescribeTaskOutput) SetExcludes(v []*FilterRule) *DescribeTaskOutput {
	s.Excludes = v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeTaskOutput) SetName(v string) *DescribeTaskOutput {
	s.Name = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *DescribeTaskOutput) SetOptions(v *Options) *DescribeTaskOutput {
	s.Options = v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *DescribeTaskOutput) SetSchedule(v *TaskSchedule) *DescribeTaskOutput {
	s.Schedule = v
	return s
}

// SetSourceLocationArn sets the SourceLocationArn field's value.
func (s *DescribeTaskOutput) SetSourceLocationArn(v string) *DescribeTaskOutput {
	s.SourceLocationArn = &v
	return s
}

// SetSourceNetworkInterfaceArns sets the SourceNetworkInterfaceArns field's value.
func (s *DescribeTaskOutput) SetSourceNetworkInterfaceArns(v []*string) *DescribeTaskOutput {
	s.SourceNetworkInterfaceArns = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeTaskOutput) SetStatus(v string) *DescribeTaskOutput {
	s.Status = &v
	return s
}

// SetTaskArn sets the TaskArn field's value.
func (s *DescribeTaskOutput) SetTaskArn(v string) *DescribeTaskOutput {
	s.TaskArn = &v
	return s
}

// The subnet and the security group that DataSync uses to access target EFS
// file system. The subnet must have at least one mount target for that file
// system. The security group that you provide needs to be able to communicate
// with the security group on the mount target in the subnet specified.
type Ec2Config struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Names (ARNs) of the security groups that are configured
	// for the Amazon EC2 resource.
	//
	// SecurityGroupArns is a required field
	SecurityGroupArns []*string `min:"1" type:"list" required:"true"`

	// The ARN of the subnet and the security group that DataSync uses to access
	// the target EFS file system.
	//
	// SubnetArn is a required field
	SubnetArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Ec2Config) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Ec2Config) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Ec2Config) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Ec2Config"}
	if s.SecurityGroupArns == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupArns"))
	}
	if s.SecurityGroupArns != nil && len(s.SecurityGroupArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupArns", 1))
	}
	if s.SubnetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecurityGroupArns sets the SecurityGroupArns field's value.
func (s *Ec2Config) SetSecurityGroupArns(v []*string) *Ec2Config {
	s.SecurityGroupArns = v
	return s
}

// SetSubnetArn sets the SubnetArn field's value.
func (s *Ec2Config) SetSubnetArn(v string) *Ec2Config {
	s.SubnetArn = &v
	return s
}

// Specifies which files, folders and objects to include or exclude when transferring
// files from source to destination.
type FilterRule struct {
	_ struct{} `type:"structure"`

	// The type of filter rule to apply. AWS DataSync only supports the SIMPLE_PATTERN
	// rule type.
	FilterType *string `type:"string" enum:"FilterType"`

	// A single filter string that consists of the patterns to include or exclude.
	// The patterns are delimited by "|" (that is, a pipe), for example: /folder1|/folder2
	Value *string `type:"string"`
}

// String returns the string representation
func (s FilterRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FilterRule) GoString() string {
	return s.String()
}

// SetFilterType sets the FilterType field's value.
func (s *FilterRule) SetFilterType(v string) *FilterRule {
	s.FilterType = &v
	return s
}

// SetValue sets the Value field's value.
func (s *FilterRule) SetValue(v string) *FilterRule {
	s.Value = &v
	return s
}

// This exception is thrown when an error occurs in the AWS DataSync service.
type InternalException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	ErrorCode *string `locationName:"errorCode" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalException) GoString() string {
	return s.String()
}

func newErrorInternalException(v protocol.ResponseMetadata) error {
	return &InternalException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalException) Code() string {
	return "InternalException"
}

// Message returns the exception's message.
func (s *InternalException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalException) OrigErr() error {
	return nil
}

func (s *InternalException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception is thrown when the client submits a malformed request.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	ErrorCode *string `locationName:"errorCode" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// ListAgentsRequest
type ListAgentsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of agents to list.
	MaxResults *int64 `type:"integer"`

	// An opaque string that indicates the position at which to begin the next list
	// of agents.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAgentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAgentsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAgentsInput) SetMaxResults(v int64) *ListAgentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAgentsInput) SetNextToken(v string) *ListAgentsInput {
	s.NextToken = &v
	return s
}

// ListAgentsResponse
type ListAgentsOutput struct {
	_ struct{} `type:"structure"`

	// A list of agents in your account.
	Agents []*AgentListEntry `type:"list"`

	// An opaque string that indicates the position at which to begin returning
	// the next list of agents.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAgentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAgentsOutput) GoString() string {
	return s.String()
}

// SetAgents sets the Agents field's value.
func (s *ListAgentsOutput) SetAgents(v []*AgentListEntry) *ListAgentsOutput {
	s.Agents = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAgentsOutput) SetNextToken(v string) *ListAgentsOutput {
	s.NextToken = &v
	return s
}

// ListLocationsRequest
type ListLocationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of locations to return.
	MaxResults *int64 `type:"integer"`

	// An opaque string that indicates the position at which to begin the next list
	// of locations.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListLocationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLocationsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLocationsInput) SetMaxResults(v int64) *ListLocationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLocationsInput) SetNextToken(v string) *ListLocationsInput {
	s.NextToken = &v
	return s
}

// ListLocationsResponse
type ListLocationsOutput struct {
	_ struct{} `type:"structure"`

	// An array that contains a list of locations.
	Locations []*LocationListEntry `type:"list"`

	// An opaque string that indicates the position at which to begin returning
	// the next list of locations.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListLocationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLocationsOutput) GoString() string {
	return s.String()
}

// SetLocations sets the Locations field's value.
func (s *ListLocationsOutput) SetLocations(v []*LocationListEntry) *ListLocationsOutput {
	s.Locations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLocationsOutput) SetNextToken(v string) *ListLocationsOutput {
	s.NextToken = &v
	return s
}

// ListTagsForResourceRequest
type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of locations to return.
	MaxResults *int64 `type:"integer"`

	// An opaque string that indicates the position at which to begin the next list
	// of locations.
	NextToken *string `type:"string"`

	// The Amazon Resource Name (ARN) of the resource whose tags to list.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsForResourceInput) SetMaxResults(v int64) *ListTagsForResourceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

// ListTagsForResourceResponse
type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// An opaque string that indicates the position at which to begin returning
	// the next list of resource tags.
	NextToken *string `type:"string"`

	// Array of resource tags.
	Tags []*TagListEntry `type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*TagListEntry) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// ListTaskExecutions
type ListTaskExecutionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of executed tasks to list.
	MaxResults *int64 `type:"integer"`

	// An opaque string that indicates the position at which to begin the next list
	// of the executed tasks.
	NextToken *string `type:"string"`

	// The Amazon Resource Name (ARN) of the task whose tasks you want to list.
	TaskArn *string `type:"string"`
}

// String returns the string representation
func (s ListTaskExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTaskExecutionsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTaskExecutionsInput) SetMaxResults(v int64) *ListTaskExecutionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTaskExecutionsInput) SetNextToken(v string) *ListTaskExecutionsInput {
	s.NextToken = &v
	return s
}

// SetTaskArn sets the TaskArn field's value.
func (s *ListTaskExecutionsInput) SetTaskArn(v string) *ListTaskExecutionsInput {
	s.TaskArn = &v
	return s
}

// ListTaskExecutionsResponse
type ListTaskExecutionsOutput struct {
	_ struct{} `type:"structure"`

	// An opaque string that indicates the position at which to begin returning
	// the next list of executed tasks.
	NextToken *string `type:"string"`

	// A list of executed tasks.
	TaskExecutions []*TaskExecutionListEntry `type:"list"`
}

// String returns the string representation
func (s ListTaskExecutionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTaskExecutionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTaskExecutionsOutput) SetNextToken(v string) *ListTaskExecutionsOutput {
	s.NextToken = &v
	return s
}

// SetTaskExecutions sets the TaskExecutions field's value.
func (s *ListTaskExecutionsOutput) SetTaskExecutions(v []*TaskExecutionListEntry) *ListTaskExecutionsOutput {
	s.TaskExecutions = v
	return s
}

// ListTasksRequest
type ListTasksInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of tasks to return.
	MaxResults *int64 `type:"integer"`

	// An opaque string that indicates the position at which to begin the next list
	// of tasks.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTasksInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTasksInput) SetMaxResults(v int64) *ListTasksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTasksInput) SetNextToken(v string) *ListTasksInput {
	s.NextToken = &v
	return s
}

// ListTasksResponse
type ListTasksOutput struct {
	_ struct{} `type:"structure"`

	// An opaque string that indicates the position at which to begin returning
	// the next list of tasks.
	NextToken *string `type:"string"`

	// A list of all the tasks that are returned.
	Tasks []*TaskListEntry `type:"list"`
}

// String returns the string representation
func (s ListTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTasksOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTasksOutput) SetNextToken(v string) *ListTasksOutput {
	s.NextToken = &v
	return s
}

// SetTasks sets the Tasks field's value.
func (s *ListTasksOutput) SetTasks(v []*TaskListEntry) *ListTasksOutput {
	s.Tasks = v
	return s
}

// Represents a single entry in a list of locations. LocationListEntry returns
// an array that contains a list of locations when the ListLocations operation
// is called.
type LocationListEntry struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the location. For Network File System (NFS)
	// or Amazon EFS, the location is the export path. For Amazon S3, the location
	// is the prefix path that you want to mount and use as the root of the location.
	LocationArn *string `type:"string"`

	// Represents a list of URLs of a location. LocationUri returns an array that
	// contains a list of locations when the ListLocations operation is called.
	//
	// Format: TYPE://GLOBAL_ID/SUBDIR.
	//
	// TYPE designates the type of location. Valid values: NFS | EFS | S3.
	//
	// GLOBAL_ID is the globally unique identifier of the resource that backs the
	// location. An example for EFS is us-east-2.fs-abcd1234. An example for Amazon
	// S3 is the bucket name, such as myBucket. An example for NFS is a valid IPv4
	// address or a host name compliant with Domain Name Service (DNS).
	//
	// SUBDIR is a valid file system path, delimited by forward slashes as is the
	// *nix convention. For NFS and Amazon EFS, it's the export path to mount the
	// location. For Amazon S3, it's the prefix path that you mount to and treat
	// as the root of the location.
	LocationUri *string `type:"string"`
}

// String returns the string representation
func (s LocationListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LocationListEntry) GoString() string {
	return s.String()
}

// SetLocationArn sets the LocationArn field's value.
func (s *LocationListEntry) SetLocationArn(v string) *LocationListEntry {
	s.LocationArn = &v
	return s
}

// SetLocationUri sets the LocationUri field's value.
func (s *LocationListEntry) SetLocationUri(v string) *LocationListEntry {
	s.LocationUri = &v
	return s
}

// Represents the mount options that are available for DataSync to access an
// NFS location.
type NfsMountOptions struct {
	_ struct{} `type:"structure"`

	// The specific NFS version that you want DataSync to use to mount your NFS
	// share. If the server refuses to use the version specified, the sync will
	// fail. If you don't specify a version, DataSync defaults to AUTOMATIC. That
	// is, DataSync automatically selects a version based on negotiation with the
	// NFS server.
	//
	// You can specify the following NFS versions:
	//
	//    * NFSv3 (https://tools.ietf.org/html/rfc1813) - stateless protocol version
	//    that allows for asynchronous writes on the server.
	//
	//    * NFSv4.0 (https://tools.ietf.org/html/rfc3530) - stateful, firewall-friendly
	//    protocol version that supports delegations and pseudo filesystems.
	//
	//    * NFSv4.1 (https://tools.ietf.org/html/rfc5661) - stateful protocol version
	//    that supports sessions, directory delegations, and parallel data processing.
	//    Version 4.1 also includes all features available in version 4.0.
	Version *string `type:"string" enum:"NfsVersion"`
}

// String returns the string representation
func (s NfsMountOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NfsMountOptions) GoString() string {
	return s.String()
}

// SetVersion sets the Version field's value.
func (s *NfsMountOptions) SetVersion(v string) *NfsMountOptions {
	s.Version = &v
	return s
}

// A list of Amazon Resource Names (ARNs) of agents to use for a Network File
// System (NFS) location.
type OnPremConfig struct {
	_ struct{} `type:"structure"`

	// ARNs)of the agents to use for an NFS location.
	//
	// AgentArns is a required field
	AgentArns []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s OnPremConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OnPremConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OnPremConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OnPremConfig"}
	if s.AgentArns == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentArns"))
	}
	if s.AgentArns != nil && len(s.AgentArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentArns sets the AgentArns field's value.
func (s *OnPremConfig) SetAgentArns(v []*string) *OnPremConfig {
	s.AgentArns = v
	return s
}

// Represents the options that are available to control the behavior of a StartTaskExecution
// operation. Behavior includes preserving metadata such as user ID (UID), group
// ID (GID), and file permissions, and also overwriting files in the destination,
// data integrity verification, and so on.
//
// A task has a set of default options associated with it. If you don't specify
// an option in StartTaskExecution, the default value is used. You can override
// the defaults options on each task execution by specifying an overriding Options
// value to StartTaskExecution.
type Options struct {
	_ struct{} `type:"structure"`

	// A file metadata value that shows the last time a file was accessed (that
	// is, when the file was read or written to). If you set Atime to BEST_EFFORT,
	// DataSync attempts to preserve the original Atime attribute on all source
	// files (that is, the version before the PREPARING phase). However, Atime's
	// behavior is not fully standard across platforms, so AWS DataSync can only
	// do this on a best-effort basis.
	//
	// Default value: BEST_EFFORT.
	//
	// BEST_EFFORT: Attempt to preserve the per-file Atime value (recommended).
	//
	// NONE: Ignore Atime.
	//
	// If Atime is set to BEST_EFFORT, Mtime must be set to PRESERVE.
	//
	// If Atime is set to NONE, Mtime must also be NONE.
	Atime *string `type:"string" enum:"Atime"`

	// A value that limits the bandwidth used by AWS DataSync. For example, if you
	// want AWS DataSync to use a maximum of 1 MB, set this value to 1048576 (=1024*1024).
	BytesPerSecond *int64 `type:"long"`

	// The group ID (GID) of the file's owners.
	//
	// Default value: INT_VALUE. This preserves the integer value of the ID.
	//
	// INT_VALUE: Preserve the integer value of user ID (UID) and GID (recommended).
	//
	// NONE: Ignore UID and GID.
	Gid *string `type:"string" enum:"Gid"`

	// A value that determines the type of logs that DataSync publishes to a log
	// stream in the Amazon CloudWatch log group that you provide. For more information
	// about providing a log group for DataSync, see CloudWatchLogGroupArn (https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateTask.html#DataSync-CreateTask-request-CloudWatchLogGroupArn).
	// If set to OFF, no logs are published. BASIC publishes logs on errors for
	// individual files transferred, and TRANSFER publishes logs for every file
	// or object that is transferred and integrity checked.
	LogLevel *string `type:"string" enum:"LogLevel"`

	// A value that indicates the last time that a file was modified (that is, a
	// file was written to) before the PREPARING phase.
	//
	// Default value: PRESERVE.
	//
	// PRESERVE: Preserve original Mtime (recommended)
	//
	// NONE: Ignore Mtime.
	//
	// If Mtime is set to PRESERVE, Atime must be set to BEST_EFFORT.
	//
	// If Mtime is set to NONE, Atime must also be set to NONE.
	Mtime *string `type:"string" enum:"Mtime"`

	// A value that determines whether files at the destination should be overwritten
	// or preserved when copying files. If set to NEVER a destination file will
	// not be replaced by a source file, even if the destination file differs from
	// the source file. If you modify files in the destination and you sync the
	// files, you can use this value to protect against overwriting those changes.
	//
	// Some storage classes have specific behaviors that can affect your S3 storage
	// cost. For detailed information, see using-storage-classes in the AWS DataSync
	// User Guide.
	OverwriteMode *string `type:"string" enum:"OverwriteMode"`

	// A value that determines which users or groups can access a file for a specific
	// purpose such as reading, writing, or execution of the file.
	//
	// Default value: PRESERVE.
	//
	// PRESERVE: Preserve POSIX-style permissions (recommended).
	//
	// NONE: Ignore permissions.
	//
	// AWS DataSync can preserve extant permissions of a source location.
	PosixPermissions *string `type:"string" enum:"PosixPermissions"`

	// A value that specifies whether files in the destination that don't exist
	// in the source file system should be preserved. This option can affect your
	// storage cost. If your task deletes objects, you might incur minimum storage
	// duration charges for certain storage classes. For detailed information, see
	// using-storage-classes in the AWS DataSync User Guide.
	//
	// Default value: PRESERVE.
	//
	// PRESERVE: Ignore such destination files (recommended).
	//
	// REMOVE: Delete destination files that aren’t present in the source.
	PreserveDeletedFiles *string `type:"string" enum:"PreserveDeletedFiles"`

	// A value that determines whether AWS DataSync should preserve the metadata
	// of block and character devices in the source file system, and recreate the
	// files with that device name and metadata on the destination.
	//
	// AWS DataSync can't sync the actual contents of such devices, because they
	// are nonterminal and don't return an end-of-file (EOF) marker.
	//
	// Default value: NONE.
	//
	// NONE: Ignore special devices (recommended).
	//
	// PRESERVE: Preserve character and block device metadata. This option isn't
	// currently supported for Amazon EFS.
	PreserveDevices *string `type:"string" enum:"PreserveDevices"`

	// A value that determines whether tasks should be queued before executing the
	// tasks. If set to ENABLED, the tasks will be queued. The default is ENABLED.
	//
	// If you use the same agent to run multiple tasks, you can enable the tasks
	// to run in series. For more information, see queue-task-execution.
	TaskQueueing *string `type:"string" enum:"TaskQueueing"`

	// TransferMode has two values: CHANGED and ALL. CHANGED performs an "incremental"
	// or "delta sync", it compares file modification time between source and destination
	// to determine which files need to be transferred. ALL skips destination inventory
	// and transfers all files discovered on the source.
	TransferMode *string `type:"string" enum:"TransferMode"`

	// The user ID (UID) of the file's owner.
	//
	// Default value: INT_VALUE. This preserves the integer value of the ID.
	//
	// INT_VALUE: Preserve the integer value of UID and group ID (GID) (recommended).
	//
	// NONE: Ignore UID and GID.
	Uid *string `type:"string" enum:"Uid"`

	// A value that determines whether a data integrity verification should be performed
	// at the end of a task execution after all data and metadata have been transferred.
	// For more information, see create-task
	//
	// Default value: POINT_IN_TIME_CONSISTENT.
	//
	// ONLY_FILES_TRANSFERRED (recommended): Perform verification only on files
	// that were transferred.
	//
	// POINT_IN_TIME_CONSISTENT: Scan the entire source and entire destination at
	// the end of the transfer to verify that source and destination are fully synchronized.
	// This option isn't supported when transferring to S3 Glacier or S3 Glacier
	// Deep Archive storage classes.
	//
	// NONE: No additional verification is done at the end of the transfer, but
	// all data transmissions are integrity-checked with checksum verification during
	// the transfer.
	VerifyMode *string `type:"string" enum:"VerifyMode"`
}

// String returns the string representation
func (s Options) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Options) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Options) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Options"}
	if s.BytesPerSecond != nil && *s.BytesPerSecond < -1 {
		invalidParams.Add(request.NewErrParamMinValue("BytesPerSecond", -1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAtime sets the Atime field's value.
func (s *Options) SetAtime(v string) *Options {
	s.Atime = &v
	return s
}

// SetBytesPerSecond sets the BytesPerSecond field's value.
func (s *Options) SetBytesPerSecond(v int64) *Options {
	s.BytesPerSecond = &v
	return s
}

// SetGid sets the Gid field's value.
func (s *Options) SetGid(v string) *Options {
	s.Gid = &v
	return s
}

// SetLogLevel sets the LogLevel field's value.
func (s *Options) SetLogLevel(v string) *Options {
	s.LogLevel = &v
	return s
}

// SetMtime sets the Mtime field's value.
func (s *Options) SetMtime(v string) *Options {
	s.Mtime = &v
	return s
}

// SetOverwriteMode sets the OverwriteMode field's value.
func (s *Options) SetOverwriteMode(v string) *Options {
	s.OverwriteMode = &v
	return s
}

// SetPosixPermissions sets the PosixPermissions field's value.
func (s *Options) SetPosixPermissions(v string) *Options {
	s.PosixPermissions = &v
	return s
}

// SetPreserveDeletedFiles sets the PreserveDeletedFiles field's value.
func (s *Options) SetPreserveDeletedFiles(v string) *Options {
	s.PreserveDeletedFiles = &v
	return s
}

// SetPreserveDevices sets the PreserveDevices field's value.
func (s *Options) SetPreserveDevices(v string) *Options {
	s.PreserveDevices = &v
	return s
}

// SetTaskQueueing sets the TaskQueueing field's value.
func (s *Options) SetTaskQueueing(v string) *Options {
	s.TaskQueueing = &v
	return s
}

// SetTransferMode sets the TransferMode field's value.
func (s *Options) SetTransferMode(v string) *Options {
	s.TransferMode = &v
	return s
}

// SetUid sets the Uid field's value.
func (s *Options) SetUid(v string) *Options {
	s.Uid = &v
	return s
}

// SetVerifyMode sets the VerifyMode field's value.
func (s *Options) SetVerifyMode(v string) *Options {
	s.VerifyMode = &v
	return s
}

// The VPC endpoint, subnet, and security group that an agent uses to access
// IP addresses in a VPC (Virtual Private Cloud).
type PrivateLinkConfig struct {
	_ struct{} `type:"structure"`

	// The private endpoint that is configured for an agent that has access to IP
	// addresses in a PrivateLink (https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html).
	// An agent that is configured with this endpoint will not be accessible over
	// the public internet.
	PrivateLinkEndpoint *string `min:"7" type:"string"`

	// The Amazon Resource Names (ARNs) of the security groups that are configured
	// for the EC2 resource that hosts an agent activated in a VPC or an agent that
	// has access to a VPC endpoint.
	SecurityGroupArns []*string `min:"1" type:"list"`

	// The Amazon Resource Names (ARNs) of the subnets that are configured for an
	// agent activated in a VPC or an agent that has access to a VPC endpoint.
	SubnetArns []*string `min:"1" type:"list"`

	// The ID of the VPC endpoint that is configured for an agent. An agent that
	// is configured with a VPC endpoint will not be accessible over the public
	// internet.
	VpcEndpointId *string `type:"string"`
}

// String returns the string representation
func (s PrivateLinkConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PrivateLinkConfig) GoString() string {
	return s.String()
}

// SetPrivateLinkEndpoint sets the PrivateLinkEndpoint field's value.
func (s *PrivateLinkConfig) SetPrivateLinkEndpoint(v string) *PrivateLinkConfig {
	s.PrivateLinkEndpoint = &v
	return s
}

// SetSecurityGroupArns sets the SecurityGroupArns field's value.
func (s *PrivateLinkConfig) SetSecurityGroupArns(v []*string) *PrivateLinkConfig {
	s.SecurityGroupArns = v
	return s
}

// SetSubnetArns sets the SubnetArns field's value.
func (s *PrivateLinkConfig) SetSubnetArns(v []*string) *PrivateLinkConfig {
	s.SubnetArns = v
	return s
}

// SetVpcEndpointId sets the VpcEndpointId field's value.
func (s *PrivateLinkConfig) SetVpcEndpointId(v string) *PrivateLinkConfig {
	s.VpcEndpointId = &v
	return s
}

// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
// (IAM) role that is used to access an Amazon S3 bucket.
//
// For detailed information about using such a role, see Creating a Location
// for Amazon S3 in the AWS DataSync User Guide.
type S3Config struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket to access. This bucket is used as a parameter in the
	// CreateLocationS3 operation.
	//
	// BucketAccessRoleArn is a required field
	BucketAccessRoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s S3Config) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Config) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Config) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Config"}
	if s.BucketAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketAccessRoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketAccessRoleArn sets the BucketAccessRoleArn field's value.
func (s *S3Config) SetBucketAccessRoleArn(v string) *S3Config {
	s.BucketAccessRoleArn = &v
	return s
}

// Represents the mount options that are available for DataSync to access an
// SMB location.
type SmbMountOptions struct {
	_ struct{} `type:"structure"`

	// The specific SMB version that you want DataSync to use to mount your SMB
	// share. If you don't specify a version, DataSync defaults to AUTOMATIC. That
	// is, DataSync automatically selects a version based on negotiation with the
	// SMB server.
	Version *string `type:"string" enum:"SmbVersion"`
}

// String returns the string representation
func (s SmbMountOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SmbMountOptions) GoString() string {
	return s.String()
}

// SetVersion sets the Version field's value.
func (s *SmbMountOptions) SetVersion(v string) *SmbMountOptions {
	s.Version = &v
	return s
}

// StartTaskExecutionRequest
type StartTaskExecutionInput struct {
	_ struct{} `type:"structure"`

	// A list of filter rules that determines which files to include when running
	// a task. The pattern should contain a single filter string that consists of
	// the patterns to include. The patterns are delimited by "|" (that is, a pipe).
	// For example: "/folder1|/folder2"
	Includes []*FilterRule `type:"list"`

	// Represents the options that are available to control the behavior of a StartTaskExecution
	// operation. Behavior includes preserving metadata such as user ID (UID), group
	// ID (GID), and file permissions, and also overwriting files in the destination,
	// data integrity verification, and so on.
	//
	// A task has a set of default options associated with it. If you don't specify
	// an option in StartTaskExecution, the default value is used. You can override
	// the defaults options on each task execution by specifying an overriding Options
	// value to StartTaskExecution.
	OverrideOptions *Options `type:"structure"`

	// The Amazon Resource Name (ARN) of the task to start.
	//
	// TaskArn is a required field
	TaskArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StartTaskExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartTaskExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartTaskExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartTaskExecutionInput"}
	if s.TaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskArn"))
	}
	if s.OverrideOptions != nil {
		if err := s.OverrideOptions.Validate(); err != nil {
			invalidParams.AddNested("OverrideOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIncludes sets the Includes field's value.
func (s *StartTaskExecutionInput) SetIncludes(v []*FilterRule) *StartTaskExecutionInput {
	s.Includes = v
	return s
}

// SetOverrideOptions sets the OverrideOptions field's value.
func (s *StartTaskExecutionInput) SetOverrideOptions(v *Options) *StartTaskExecutionInput {
	s.OverrideOptions = v
	return s
}

// SetTaskArn sets the TaskArn field's value.
func (s *StartTaskExecutionInput) SetTaskArn(v string) *StartTaskExecutionInput {
	s.TaskArn = &v
	return s
}

// StartTaskExecutionResponse
type StartTaskExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the specific task execution that was started.
	TaskExecutionArn *string `type:"string"`
}

// String returns the string representation
func (s StartTaskExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartTaskExecutionOutput) GoString() string {
	return s.String()
}

// SetTaskExecutionArn sets the TaskExecutionArn field's value.
func (s *StartTaskExecutionOutput) SetTaskExecutionArn(v string) *StartTaskExecutionOutput {
	s.TaskExecutionArn = &v
	return s
}

// Represents a single entry in a list of AWS resource tags. TagListEntry returns
// an array that contains a list of tasks when the ListTagsForResource operation
// is called.
type TagListEntry struct {
	_ struct{} `type:"structure"`

	// The key for an AWS resource tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value for an AWS resource tag.
	Value *string `min:"1" type:"string"`
}

// String returns the string representation
func (s TagListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagListEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagListEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagListEntry"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *TagListEntry) SetKey(v string) *TagListEntry {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagListEntry) SetValue(v string) *TagListEntry {
	s.Value = &v
	return s
}

// TagResourceRequest
type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to apply the tag to.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// The tags to apply.
	//
	// Tags is a required field
	Tags []*TagListEntry `type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*TagListEntry) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Represents a single entry in a list of task executions. TaskExecutionListEntry
// returns an array that contains a list of specific invocations of a task when
// ListTaskExecutions operation is called.
type TaskExecutionListEntry struct {
	_ struct{} `type:"structure"`

	// The status of a task execution.
	Status *string `type:"string" enum:"TaskExecutionStatus"`

	// The Amazon Resource Name (ARN) of the task that was executed.
	TaskExecutionArn *string `type:"string"`
}

// String returns the string representation
func (s TaskExecutionListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TaskExecutionListEntry) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *TaskExecutionListEntry) SetStatus(v string) *TaskExecutionListEntry {
	s.Status = &v
	return s
}

// SetTaskExecutionArn sets the TaskExecutionArn field's value.
func (s *TaskExecutionListEntry) SetTaskExecutionArn(v string) *TaskExecutionListEntry {
	s.TaskExecutionArn = &v
	return s
}

// Describes the detailed result of a TaskExecution operation. This result includes
// the time in milliseconds spent in each phase, the status of the task execution,
// and the errors encountered.
type TaskExecutionResultDetail struct {
	_ struct{} `type:"structure"`

	// Errors that AWS DataSync encountered during execution of the task. You can
	// use this error code to help troubleshoot issues.
	ErrorCode *string `type:"string"`

	// Detailed description of an error that was encountered during the task execution.
	// You can use this information to help troubleshoot issues.
	ErrorDetail *string `type:"string"`

	// The total time in milliseconds that AWS DataSync spent in the PREPARING phase.
	PrepareDuration *int64 `type:"long"`

	// The status of the PREPARING phase.
	PrepareStatus *string `type:"string" enum:"PhaseStatus"`

	// The total time in milliseconds that AWS DataSync took to transfer the file
	// from the source to the destination location.
	TotalDuration *int64 `type:"long"`

	// The total time in milliseconds that AWS DataSync spent in the TRANSFERRING
	// phase.
	TransferDuration *int64 `type:"long"`

	// The status of the TRANSFERRING Phase.
	TransferStatus *string `type:"string" enum:"PhaseStatus"`

	// The total time in milliseconds that AWS DataSync spent in the VERIFYING phase.
	VerifyDuration *int64 `type:"long"`

	// The status of the VERIFYING Phase.
	VerifyStatus *string `type:"string" enum:"PhaseStatus"`
}

// String returns the string representation
func (s TaskExecutionResultDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TaskExecutionResultDetail) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *TaskExecutionResultDetail) SetErrorCode(v string) *TaskExecutionResultDetail {
	s.ErrorCode = &v
	return s
}

// SetErrorDetail sets the ErrorDetail field's value.
func (s *TaskExecutionResultDetail) SetErrorDetail(v string) *TaskExecutionResultDetail {
	s.ErrorDetail = &v
	return s
}

// SetPrepareDuration sets the PrepareDuration field's value.
func (s *TaskExecutionResultDetail) SetPrepareDuration(v int64) *TaskExecutionResultDetail {
	s.PrepareDuration = &v
	return s
}

// SetPrepareStatus sets the PrepareStatus field's value.
func (s *TaskExecutionResultDetail) SetPrepareStatus(v string) *TaskExecutionResultDetail {
	s.PrepareStatus = &v
	return s
}

// SetTotalDuration sets the TotalDuration field's value.
func (s *TaskExecutionResultDetail) SetTotalDuration(v int64) *TaskExecutionResultDetail {
	s.TotalDuration = &v
	return s
}

// SetTransferDuration sets the TransferDuration field's value.
func (s *TaskExecutionResultDetail) SetTransferDuration(v int64) *TaskExecutionResultDetail {
	s.TransferDuration = &v
	return s
}

// SetTransferStatus sets the TransferStatus field's value.
func (s *TaskExecutionResultDetail) SetTransferStatus(v string) *TaskExecutionResultDetail {
	s.TransferStatus = &v
	return s
}

// SetVerifyDuration sets the VerifyDuration field's value.
func (s *TaskExecutionResultDetail) SetVerifyDuration(v int64) *TaskExecutionResultDetail {
	s.VerifyDuration = &v
	return s
}

// SetVerifyStatus sets the VerifyStatus field's value.
func (s *TaskExecutionResultDetail) SetVerifyStatus(v string) *TaskExecutionResultDetail {
	s.VerifyStatus = &v
	return s
}

// Represents a single entry in a list of tasks. TaskListEntry returns an array
// that contains a list of tasks when the ListTasks operation is called. A task
// includes the source and destination file systems to sync and the options
// to use for the tasks.
type TaskListEntry struct {
	_ struct{} `type:"structure"`

	// The name of the task.
	Name *string `min:"1" type:"string"`

	// The status of the task.
	Status *string `type:"string" enum:"TaskStatus"`

	// The Amazon Resource Name (ARN) of the task.
	TaskArn *string `type:"string"`
}

// String returns the string representation
func (s TaskListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TaskListEntry) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *TaskListEntry) SetName(v string) *TaskListEntry {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TaskListEntry) SetStatus(v string) *TaskListEntry {
	s.Status = &v
	return s
}

// SetTaskArn sets the TaskArn field's value.
func (s *TaskListEntry) SetTaskArn(v string) *TaskListEntry {
	s.TaskArn = &v
	return s
}

// Specifies the schedule you want your task to use for repeated executions.
// For more information, see Schedule Expressions for Rules (https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html).
type TaskSchedule struct {
	_ struct{} `type:"structure"`

	// A cron expression that specifies when AWS DataSync initiates a scheduled
	// transfer from a source to a destination location.
	//
	// ScheduleExpression is a required field
	ScheduleExpression *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TaskSchedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TaskSchedule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TaskSchedule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TaskSchedule"}
	if s.ScheduleExpression == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduleExpression"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *TaskSchedule) SetScheduleExpression(v string) *TaskSchedule {
	s.ScheduleExpression = &v
	return s
}

// UntagResourceRequest
type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The keys in the key-value pair in the tag to remove.
	//
	// Keys is a required field
	Keys []*string `min:"1" type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the resource to remove the tag from.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.Keys == nil {
		invalidParams.Add(request.NewErrParamRequired("Keys"))
	}
	if s.Keys != nil && len(s.Keys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Keys", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeys sets the Keys field's value.
func (s *UntagResourceInput) SetKeys(v []*string) *UntagResourceInput {
	s.Keys = v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// UpdateAgentRequest
type UpdateAgentInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the agent to update.
	//
	// AgentArn is a required field
	AgentArn *string `type:"string" required:"true"`

	// The name that you want to use to configure the agent.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateAgentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAgentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAgentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAgentInput"}
	if s.AgentArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentArn"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentArn sets the AgentArn field's value.
func (s *UpdateAgentInput) SetAgentArn(v string) *UpdateAgentInput {
	s.AgentArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAgentInput) SetName(v string) *UpdateAgentInput {
	s.Name = &v
	return s
}

type UpdateAgentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateAgentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAgentOutput) GoString() string {
	return s.String()
}

// UpdateTaskResponse
type UpdateTaskInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource name of the CloudWatch LogGroup.
	CloudWatchLogGroupArn *string `type:"string"`

	// A list of filter rules that determines which files to exclude from a task.
	// The list should contain a single filter string that consists of the patterns
	// to exclude. The patterns are delimited by "|" (that is, a pipe), for example:
	// "/folder1|/folder2"
	Excludes []*FilterRule `type:"list"`

	// The name of the task to update.
	Name *string `min:"1" type:"string"`

	// Represents the options that are available to control the behavior of a StartTaskExecution
	// operation. Behavior includes preserving metadata such as user ID (UID), group
	// ID (GID), and file permissions, and also overwriting files in the destination,
	// data integrity verification, and so on.
	//
	// A task has a set of default options associated with it. If you don't specify
	// an option in StartTaskExecution, the default value is used. You can override
	// the defaults options on each task execution by specifying an overriding Options
	// value to StartTaskExecution.
	Options *Options `type:"structure"`

	// Specifies a schedule used to periodically transfer files from a source to
	// a destination location. You can configure your task to execute hourly, daily,
	// weekly or on specific days of the week. You control when in the day or hour
	// you want the task to execute. The time you specify is UTC time. For more
	// information, see task-scheduling.
	Schedule *TaskSchedule `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource name of the task to update.
	//
	// TaskArn is a required field
	TaskArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTaskInput"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.TaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskArn"))
	}
	if s.Options != nil {
		if err := s.Options.Validate(); err != nil {
			invalidParams.AddNested("Options", err.(request.ErrInvalidParams))
		}
	}
	if s.Schedule != nil {
		if err := s.Schedule.Validate(); err != nil {
			invalidParams.AddNested("Schedule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLogGroupArn sets the CloudWatchLogGroupArn field's value.
func (s *UpdateTaskInput) SetCloudWatchLogGroupArn(v string) *UpdateTaskInput {
	s.CloudWatchLogGroupArn = &v
	return s
}

// SetExcludes sets the Excludes field's value.
func (s *UpdateTaskInput) SetExcludes(v []*FilterRule) *UpdateTaskInput {
	s.Excludes = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateTaskInput) SetName(v string) *UpdateTaskInput {
	s.Name = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *UpdateTaskInput) SetOptions(v *Options) *UpdateTaskInput {
	s.Options = v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *UpdateTaskInput) SetSchedule(v *TaskSchedule) *UpdateTaskInput {
	s.Schedule = v
	return s
}

// SetTaskArn sets the TaskArn field's value.
func (s *UpdateTaskInput) SetTaskArn(v string) *UpdateTaskInput {
	s.TaskArn = &v
	return s
}

type UpdateTaskOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTaskOutput) GoString() string {
	return s.String()
}

const (
	// AgentStatusOnline is a AgentStatus enum value
	AgentStatusOnline = "ONLINE"

	// AgentStatusOffline is a AgentStatus enum value
	AgentStatusOffline = "OFFLINE"
)

const (
	// AtimeNone is a Atime enum value
	AtimeNone = "NONE"

	// AtimeBestEffort is a Atime enum value
	AtimeBestEffort = "BEST_EFFORT"
)

const (
	// EndpointTypePublic is a EndpointType enum value
	EndpointTypePublic = "PUBLIC"

	// EndpointTypePrivateLink is a EndpointType enum value
	EndpointTypePrivateLink = "PRIVATE_LINK"

	// EndpointTypeFips is a EndpointType enum value
	EndpointTypeFips = "FIPS"
)

const (
	// FilterTypeSimplePattern is a FilterType enum value
	FilterTypeSimplePattern = "SIMPLE_PATTERN"
)

const (
	// GidNone is a Gid enum value
	GidNone = "NONE"

	// GidIntValue is a Gid enum value
	GidIntValue = "INT_VALUE"

	// GidName is a Gid enum value
	GidName = "NAME"

	// GidBoth is a Gid enum value
	GidBoth = "BOTH"
)

const (
	// LogLevelOff is a LogLevel enum value
	LogLevelOff = "OFF"

	// LogLevelBasic is a LogLevel enum value
	LogLevelBasic = "BASIC"

	// LogLevelTransfer is a LogLevel enum value
	LogLevelTransfer = "TRANSFER"
)

const (
	// MtimeNone is a Mtime enum value
	MtimeNone = "NONE"

	// MtimePreserve is a Mtime enum value
	MtimePreserve = "PRESERVE"
)

const (
	// NfsVersionAutomatic is a NfsVersion enum value
	NfsVersionAutomatic = "AUTOMATIC"

	// NfsVersionNfs3 is a NfsVersion enum value
	NfsVersionNfs3 = "NFS3"

	// NfsVersionNfs40 is a NfsVersion enum value
	NfsVersionNfs40 = "NFS4_0"

	// NfsVersionNfs41 is a NfsVersion enum value
	NfsVersionNfs41 = "NFS4_1"
)

const (
	// ObjectStorageServerProtocolHttps is a ObjectStorageServerProtocol enum value
	ObjectStorageServerProtocolHttps = "HTTPS"

	// ObjectStorageServerProtocolHttp is a ObjectStorageServerProtocol enum value
	ObjectStorageServerProtocolHttp = "HTTP"
)

const (
	// OverwriteModeAlways is a OverwriteMode enum value
	OverwriteModeAlways = "ALWAYS"

	// OverwriteModeNever is a OverwriteMode enum value
	OverwriteModeNever = "NEVER"
)

const (
	// PhaseStatusPending is a PhaseStatus enum value
	PhaseStatusPending = "PENDING"

	// PhaseStatusSuccess is a PhaseStatus enum value
	PhaseStatusSuccess = "SUCCESS"

	// PhaseStatusError is a PhaseStatus enum value
	PhaseStatusError = "ERROR"
)

const (
	// PosixPermissionsNone is a PosixPermissions enum value
	PosixPermissionsNone = "NONE"

	// PosixPermissionsPreserve is a PosixPermissions enum value
	PosixPermissionsPreserve = "PRESERVE"
)

const (
	// PreserveDeletedFilesPreserve is a PreserveDeletedFiles enum value
	PreserveDeletedFilesPreserve = "PRESERVE"

	// PreserveDeletedFilesRemove is a PreserveDeletedFiles enum value
	PreserveDeletedFilesRemove = "REMOVE"
)

const (
	// PreserveDevicesNone is a PreserveDevices enum value
	PreserveDevicesNone = "NONE"

	// PreserveDevicesPreserve is a PreserveDevices enum value
	PreserveDevicesPreserve = "PRESERVE"
)

const (
	// S3StorageClassStandard is a S3StorageClass enum value
	S3StorageClassStandard = "STANDARD"

	// S3StorageClassStandardIa is a S3StorageClass enum value
	S3StorageClassStandardIa = "STANDARD_IA"

	// S3StorageClassOnezoneIa is a S3StorageClass enum value
	S3StorageClassOnezoneIa = "ONEZONE_IA"

	// S3StorageClassIntelligentTiering is a S3StorageClass enum value
	S3StorageClassIntelligentTiering = "INTELLIGENT_TIERING"

	// S3StorageClassGlacier is a S3StorageClass enum value
	S3StorageClassGlacier = "GLACIER"

	// S3StorageClassDeepArchive is a S3StorageClass enum value
	S3StorageClassDeepArchive = "DEEP_ARCHIVE"
)

const (
	// SmbVersionAutomatic is a SmbVersion enum value
	SmbVersionAutomatic = "AUTOMATIC"

	// SmbVersionSmb2 is a SmbVersion enum value
	SmbVersionSmb2 = "SMB2"

	// SmbVersionSmb3 is a SmbVersion enum value
	SmbVersionSmb3 = "SMB3"
)

const (
	// TaskExecutionStatusQueued is a TaskExecutionStatus enum value
	TaskExecutionStatusQueued = "QUEUED"

	// TaskExecutionStatusLaunching is a TaskExecutionStatus enum value
	TaskExecutionStatusLaunching = "LAUNCHING"

	// TaskExecutionStatusPreparing is a TaskExecutionStatus enum value
	TaskExecutionStatusPreparing = "PREPARING"

	// TaskExecutionStatusTransferring is a TaskExecutionStatus enum value
	TaskExecutionStatusTransferring = "TRANSFERRING"

	// TaskExecutionStatusVerifying is a TaskExecutionStatus enum value
	TaskExecutionStatusVerifying = "VERIFYING"

	// TaskExecutionStatusSuccess is a TaskExecutionStatus enum value
	TaskExecutionStatusSuccess = "SUCCESS"

	// TaskExecutionStatusError is a TaskExecutionStatus enum value
	TaskExecutionStatusError = "ERROR"
)

const (
	// TaskQueueingEnabled is a TaskQueueing enum value
	TaskQueueingEnabled = "ENABLED"

	// TaskQueueingDisabled is a TaskQueueing enum value
	TaskQueueingDisabled = "DISABLED"
)

const (
	// TaskStatusAvailable is a TaskStatus enum value
	TaskStatusAvailable = "AVAILABLE"

	// TaskStatusCreating is a TaskStatus enum value
	TaskStatusCreating = "CREATING"

	// TaskStatusQueued is a TaskStatus enum value
	TaskStatusQueued = "QUEUED"

	// TaskStatusRunning is a TaskStatus enum value
	TaskStatusRunning = "RUNNING"

	// TaskStatusUnavailable is a TaskStatus enum value
	TaskStatusUnavailable = "UNAVAILABLE"
)

const (
	// TransferModeChanged is a TransferMode enum value
	TransferModeChanged = "CHANGED"

	// TransferModeAll is a TransferMode enum value
	TransferModeAll = "ALL"
)

const (
	// UidNone is a Uid enum value
	UidNone = "NONE"

	// UidIntValue is a Uid enum value
	UidIntValue = "INT_VALUE"

	// UidName is a Uid enum value
	UidName = "NAME"

	// UidBoth is a Uid enum value
	UidBoth = "BOTH"
)

const (
	// VerifyModePointInTimeConsistent is a VerifyMode enum value
	VerifyModePointInTimeConsistent = "POINT_IN_TIME_CONSISTENT"

	// VerifyModeOnlyFilesTransferred is a VerifyMode enum value
	VerifyModeOnlyFilesTransferred = "ONLY_FILES_TRANSFERRED"

	// VerifyModeNone is a VerifyMode enum value
	VerifyModeNone = "NONE"
)
