// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticache

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/query"
)

const opAddTagsToResource = "AddTagsToResource"

// AddTagsToResourceRequest generates a "aws/request.Request" representing the
// client's request for the AddTagsToResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddTagsToResource for more information on using the AddTagsToResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddTagsToResourceRequest method.
//    req, resp := client.AddTagsToResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/AddTagsToResource
func (c *ElastiCache) AddTagsToResourceRequest(input *AddTagsToResourceInput) (req *request.Request, output *TagListMessage) {
	op := &request.Operation{
		Name:       opAddTagsToResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsToResourceInput{}
	}

	output = &TagListMessage{}
	req = c.newRequest(op, input, output)
	return
}

// AddTagsToResource API operation for Amazon ElastiCache.
//
// Adds up to 50 cost allocation tags to the named resource. A cost allocation
// tag is a key-value pair where the key and value are case-sensitive. You can
// use cost allocation tags to categorize and track your AWS costs.
//
// When you apply tags to your ElastiCache resources, AWS generates a cost allocation
// report as a comma-separated value (CSV) file with your usage and costs aggregated
// by your tags. You can apply tags that represent business categories (such
// as cost centers, application names, or owners) to organize your costs across
// multiple services. For more information, see Using Cost Allocation Tags in
// Amazon ElastiCache (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Tagging.html)
// in the ElastiCache User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation AddTagsToResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCacheClusterNotFoundFault "CacheClusterNotFound"
//   The requested cluster ID does not refer to an existing cluster.
//
//   * ErrCodeSnapshotNotFoundFault "SnapshotNotFoundFault"
//   The requested snapshot name does not refer to an existing snapshot.
//
//   * ErrCodeTagQuotaPerResourceExceeded "TagQuotaPerResourceExceeded"
//   The request cannot be processed because it would cause the resource to have
//   more than the allowed number of tags. The maximum number of tags permitted
//   on a resource is 50.
//
//   * ErrCodeInvalidARNFault "InvalidARN"
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/AddTagsToResource
func (c *ElastiCache) AddTagsToResource(input *AddTagsToResourceInput) (*TagListMessage, error) {
	req, out := c.AddTagsToResourceRequest(input)
	return out, req.Send()
}

// AddTagsToResourceWithContext is the same as AddTagsToResource with the addition of
// the ability to pass a context and additional request options.
//
// See AddTagsToResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) AddTagsToResourceWithContext(ctx aws.Context, input *AddTagsToResourceInput, opts ...request.Option) (*TagListMessage, error) {
	req, out := c.AddTagsToResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAuthorizeCacheSecurityGroupIngress = "AuthorizeCacheSecurityGroupIngress"

// AuthorizeCacheSecurityGroupIngressRequest generates a "aws/request.Request" representing the
// client's request for the AuthorizeCacheSecurityGroupIngress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AuthorizeCacheSecurityGroupIngress for more information on using the AuthorizeCacheSecurityGroupIngress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AuthorizeCacheSecurityGroupIngressRequest method.
//    req, resp := client.AuthorizeCacheSecurityGroupIngressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/AuthorizeCacheSecurityGroupIngress
func (c *ElastiCache) AuthorizeCacheSecurityGroupIngressRequest(input *AuthorizeCacheSecurityGroupIngressInput) (req *request.Request, output *AuthorizeCacheSecurityGroupIngressOutput) {
	op := &request.Operation{
		Name:       opAuthorizeCacheSecurityGroupIngress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AuthorizeCacheSecurityGroupIngressInput{}
	}

	output = &AuthorizeCacheSecurityGroupIngressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AuthorizeCacheSecurityGroupIngress API operation for Amazon ElastiCache.
//
// Allows network ingress to a cache security group. Applications using ElastiCache
// must be running on Amazon EC2, and Amazon EC2 security groups are used as
// the authorization mechanism.
//
// You cannot authorize ingress from an Amazon EC2 security group in one region
// to an ElastiCache cluster in another region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation AuthorizeCacheSecurityGroupIngress for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCacheSecurityGroupNotFoundFault "CacheSecurityGroupNotFound"
//   The requested cache security group name does not refer to an existing cache
//   security group.
//
//   * ErrCodeInvalidCacheSecurityGroupStateFault "InvalidCacheSecurityGroupState"
//   The current state of the cache security group does not allow deletion.
//
//   * ErrCodeAuthorizationAlreadyExistsFault "AuthorizationAlreadyExists"
//   The specified Amazon EC2 security group is already authorized for the specified
//   cache security group.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/AuthorizeCacheSecurityGroupIngress
func (c *ElastiCache) AuthorizeCacheSecurityGroupIngress(input *AuthorizeCacheSecurityGroupIngressInput) (*AuthorizeCacheSecurityGroupIngressOutput, error) {
	req, out := c.AuthorizeCacheSecurityGroupIngressRequest(input)
	return out, req.Send()
}

// AuthorizeCacheSecurityGroupIngressWithContext is the same as AuthorizeCacheSecurityGroupIngress with the addition of
// the ability to pass a context and additional request options.
//
// See AuthorizeCacheSecurityGroupIngress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) AuthorizeCacheSecurityGroupIngressWithContext(ctx aws.Context, input *AuthorizeCacheSecurityGroupIngressInput, opts ...request.Option) (*AuthorizeCacheSecurityGroupIngressOutput, error) {
	req, out := c.AuthorizeCacheSecurityGroupIngressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchApplyUpdateAction = "BatchApplyUpdateAction"

// BatchApplyUpdateActionRequest generates a "aws/request.Request" representing the
// client's request for the BatchApplyUpdateAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchApplyUpdateAction for more information on using the BatchApplyUpdateAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchApplyUpdateActionRequest method.
//    req, resp := client.BatchApplyUpdateActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/BatchApplyUpdateAction
func (c *ElastiCache) BatchApplyUpdateActionRequest(input *BatchApplyUpdateActionInput) (req *request.Request, output *BatchApplyUpdateActionOutput) {
	op := &request.Operation{
		Name:       opBatchApplyUpdateAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchApplyUpdateActionInput{}
	}

	output = &BatchApplyUpdateActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchApplyUpdateAction API operation for Amazon ElastiCache.
//
// Apply the service update. For more information on service updates and applying
// them, see Applying Service Updates (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/applying-updates.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation BatchApplyUpdateAction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceUpdateNotFoundFault "ServiceUpdateNotFoundFault"
//   The service update doesn't exist
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/BatchApplyUpdateAction
func (c *ElastiCache) BatchApplyUpdateAction(input *BatchApplyUpdateActionInput) (*BatchApplyUpdateActionOutput, error) {
	req, out := c.BatchApplyUpdateActionRequest(input)
	return out, req.Send()
}

// BatchApplyUpdateActionWithContext is the same as BatchApplyUpdateAction with the addition of
// the ability to pass a context and additional request options.
//
// See BatchApplyUpdateAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) BatchApplyUpdateActionWithContext(ctx aws.Context, input *BatchApplyUpdateActionInput, opts ...request.Option) (*BatchApplyUpdateActionOutput, error) {
	req, out := c.BatchApplyUpdateActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchStopUpdateAction = "BatchStopUpdateAction"

// BatchStopUpdateActionRequest generates a "aws/request.Request" representing the
// client's request for the BatchStopUpdateAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchStopUpdateAction for more information on using the BatchStopUpdateAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchStopUpdateActionRequest method.
//    req, resp := client.BatchStopUpdateActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/BatchStopUpdateAction
func (c *ElastiCache) BatchStopUpdateActionRequest(input *BatchStopUpdateActionInput) (req *request.Request, output *BatchStopUpdateActionOutput) {
	op := &request.Operation{
		Name:       opBatchStopUpdateAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchStopUpdateActionInput{}
	}

	output = &BatchStopUpdateActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchStopUpdateAction API operation for Amazon ElastiCache.
//
// Stop the service update. For more information on service updates and stopping
// them, see Stopping Service Updates (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/stopping-self-service-updates.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation BatchStopUpdateAction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceUpdateNotFoundFault "ServiceUpdateNotFoundFault"
//   The service update doesn't exist
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/BatchStopUpdateAction
func (c *ElastiCache) BatchStopUpdateAction(input *BatchStopUpdateActionInput) (*BatchStopUpdateActionOutput, error) {
	req, out := c.BatchStopUpdateActionRequest(input)
	return out, req.Send()
}

// BatchStopUpdateActionWithContext is the same as BatchStopUpdateAction with the addition of
// the ability to pass a context and additional request options.
//
// See BatchStopUpdateAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) BatchStopUpdateActionWithContext(ctx aws.Context, input *BatchStopUpdateActionInput, opts ...request.Option) (*BatchStopUpdateActionOutput, error) {
	req, out := c.BatchStopUpdateActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCompleteMigration = "CompleteMigration"

// CompleteMigrationRequest generates a "aws/request.Request" representing the
// client's request for the CompleteMigration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CompleteMigration for more information on using the CompleteMigration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CompleteMigrationRequest method.
//    req, resp := client.CompleteMigrationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CompleteMigration
func (c *ElastiCache) CompleteMigrationRequest(input *CompleteMigrationInput) (req *request.Request, output *CompleteMigrationOutput) {
	op := &request.Operation{
		Name:       opCompleteMigration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CompleteMigrationInput{}
	}

	output = &CompleteMigrationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CompleteMigration API operation for Amazon ElastiCache.
//
// Complete the migration of data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation CompleteMigration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeReplicationGroupNotFoundFault "ReplicationGroupNotFoundFault"
//   The specified replication group does not exist.
//
//   * ErrCodeInvalidReplicationGroupStateFault "InvalidReplicationGroupState"
//   The requested replication group is not in the available state.
//
//   * ErrCodeReplicationGroupNotUnderMigrationFault "ReplicationGroupNotUnderMigrationFault"
//   The designated replication group is not available for data migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CompleteMigration
func (c *ElastiCache) CompleteMigration(input *CompleteMigrationInput) (*CompleteMigrationOutput, error) {
	req, out := c.CompleteMigrationRequest(input)
	return out, req.Send()
}

// CompleteMigrationWithContext is the same as CompleteMigration with the addition of
// the ability to pass a context and additional request options.
//
// See CompleteMigration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) CompleteMigrationWithContext(ctx aws.Context, input *CompleteMigrationInput, opts ...request.Option) (*CompleteMigrationOutput, error) {
	req, out := c.CompleteMigrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopySnapshot = "CopySnapshot"

// CopySnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CopySnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopySnapshot for more information on using the CopySnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CopySnapshotRequest method.
//    req, resp := client.CopySnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CopySnapshot
func (c *ElastiCache) CopySnapshotRequest(input *CopySnapshotInput) (req *request.Request, output *CopySnapshotOutput) {
	op := &request.Operation{
		Name:       opCopySnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopySnapshotInput{}
	}

	output = &CopySnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopySnapshot API operation for Amazon ElastiCache.
//
// Makes a copy of an existing snapshot.
//
// This operation is valid for Redis only.
//
// Users or groups that have permissions to use the CopySnapshot operation can
// create their own Amazon S3 buckets and copy snapshots to it. To control access
// to your snapshots, use an IAM policy to control who has the ability to use
// the CopySnapshot operation. For more information about using IAM to control
// the use of ElastiCache operations, see Exporting Snapshots (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html)
// and Authentication & Access Control (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.html).
//
// You could receive the following error messages.
//
// Error Messages
//
//    * Error Message: The S3 bucket %s is outside of the region. Solution:
//    Create an Amazon S3 bucket in the same region as your snapshot. For more
//    information, see Step 1: Create an Amazon S3 Bucket (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket)
//    in the ElastiCache User Guide.
//
//    * Error Message: The S3 bucket %s does not exist. Solution: Create an
//    Amazon S3 bucket in the same region as your snapshot. For more information,
//    see Step 1: Create an Amazon S3 Bucket (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket)
//    in the ElastiCache User Guide.
//
//    * Error Message: The S3 bucket %s is not owned by the authenticated user.
//    Solution: Create an Amazon S3 bucket in the same region as your snapshot.
//    For more information, see Step 1: Create an Amazon S3 Bucket (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket)
//    in the ElastiCache User Guide.
//
//    * Error Message: The authenticated user does not have sufficient permissions
//    to perform the desired activity. Solution: Contact your system administrator
//    to get the needed permissions.
//
//    * Error Message: The S3 bucket %s already contains an object with key
//    %s. Solution: Give the TargetSnapshotName a new and unique value. If exporting
//    a snapshot, you could alternatively create a new Amazon S3 bucket and
//    use this same value for TargetSnapshotName.
//
//    * Error Message: ElastiCache has not been granted READ permissions %s
//    on the S3 Bucket. Solution: Add List and Read permissions on the bucket.
//    For more information, see Step 2: Grant ElastiCache Access to Your Amazon
//    S3 Bucket (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access)
//    in the ElastiCache User Guide.
//
//    * Error Message: ElastiCache has not been granted WRITE permissions %s
//    on the S3 Bucket. Solution: Add Upload/Delete permissions on the bucket.
//    For more information, see Step 2: Grant ElastiCache Access to Your Amazon
//    S3 Bucket (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access)
//    in the ElastiCache User Guide.
//
//    * Error Message: ElastiCache has not been granted READ_ACP permissions
//    %s on the S3 Bucket. Solution: Add View Permissions on the bucket. For
//    more information, see Step 2: Grant ElastiCache Access to Your Amazon
//    S3 Bucket (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access)
//    in the ElastiCache User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation CopySnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSnapshotAlreadyExistsFault "SnapshotAlreadyExistsFault"
//   You already have a snapshot with the given name.
//
//   * ErrCodeSnapshotNotFoundFault "SnapshotNotFoundFault"
//   The requested snapshot name does not refer to an existing snapshot.
//
//   * ErrCodeSnapshotQuotaExceededFault "SnapshotQuotaExceededFault"
//   The request cannot be processed because it would exceed the maximum number
//   of snapshots.
//
//   * ErrCodeInvalidSnapshotStateFault "InvalidSnapshotState"
//   The current state of the snapshot does not allow the requested operation
//   to occur.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CopySnapshot
func (c *ElastiCache) CopySnapshot(input *CopySnapshotInput) (*CopySnapshotOutput, error) {
	req, out := c.CopySnapshotRequest(input)
	return out, req.Send()
}

// CopySnapshotWithContext is the same as CopySnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CopySnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) CopySnapshotWithContext(ctx aws.Context, input *CopySnapshotInput, opts ...request.Option) (*CopySnapshotOutput, error) {
	req, out := c.CopySnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCacheCluster = "CreateCacheCluster"

// CreateCacheClusterRequest generates a "aws/request.Request" representing the
// client's request for the CreateCacheCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCacheCluster for more information on using the CreateCacheCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCacheClusterRequest method.
//    req, resp := client.CreateCacheClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateCacheCluster
func (c *ElastiCache) CreateCacheClusterRequest(input *CreateCacheClusterInput) (req *request.Request, output *CreateCacheClusterOutput) {
	op := &request.Operation{
		Name:       opCreateCacheCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCacheClusterInput{}
	}

	output = &CreateCacheClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCacheCluster API operation for Amazon ElastiCache.
//
// Creates a cluster. All nodes in the cluster run the same protocol-compliant
// cache engine software, either Memcached or Redis.
//
// This operation is not supported for Redis (cluster mode enabled) clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation CreateCacheCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeReplicationGroupNotFoundFault "ReplicationGroupNotFoundFault"
//   The specified replication group does not exist.
//
//   * ErrCodeInvalidReplicationGroupStateFault "InvalidReplicationGroupState"
//   The requested replication group is not in the available state.
//
//   * ErrCodeCacheClusterAlreadyExistsFault "CacheClusterAlreadyExists"
//   You already have a cluster with the given identifier.
//
//   * ErrCodeInsufficientCacheClusterCapacityFault "InsufficientCacheClusterCapacity"
//   The requested cache node type is not available in the specified Availability
//   Zone. For more information, see InsufficientCacheClusterCapacity (http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY)
//   in the ElastiCache User Guide.
//
//   * ErrCodeCacheSecurityGroupNotFoundFault "CacheSecurityGroupNotFound"
//   The requested cache security group name does not refer to an existing cache
//   security group.
//
//   * ErrCodeCacheSubnetGroupNotFoundFault "CacheSubnetGroupNotFoundFault"
//   The requested cache subnet group name does not refer to an existing cache
//   subnet group.
//
//   * ErrCodeClusterQuotaForCustomerExceededFault "ClusterQuotaForCustomerExceeded"
//   The request cannot be processed because it would exceed the allowed number
//   of clusters per customer.
//
//   * ErrCodeNodeQuotaForClusterExceededFault "NodeQuotaForClusterExceeded"
//   The request cannot be processed because it would exceed the allowed number
//   of cache nodes in a single cluster.
//
//   * ErrCodeNodeQuotaForCustomerExceededFault "NodeQuotaForCustomerExceeded"
//   The request cannot be processed because it would exceed the allowed number
//   of cache nodes per customer.
//
//   * ErrCodeCacheParameterGroupNotFoundFault "CacheParameterGroupNotFound"
//   The requested cache parameter group name does not refer to an existing cache
//   parameter group.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   The VPC network is in an invalid state.
//
//   * ErrCodeTagQuotaPerResourceExceeded "TagQuotaPerResourceExceeded"
//   The request cannot be processed because it would cause the resource to have
//   more than the allowed number of tags. The maximum number of tags permitted
//   on a resource is 50.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateCacheCluster
func (c *ElastiCache) CreateCacheCluster(input *CreateCacheClusterInput) (*CreateCacheClusterOutput, error) {
	req, out := c.CreateCacheClusterRequest(input)
	return out, req.Send()
}

// CreateCacheClusterWithContext is the same as CreateCacheCluster with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCacheCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) CreateCacheClusterWithContext(ctx aws.Context, input *CreateCacheClusterInput, opts ...request.Option) (*CreateCacheClusterOutput, error) {
	req, out := c.CreateCacheClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCacheParameterGroup = "CreateCacheParameterGroup"

// CreateCacheParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateCacheParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCacheParameterGroup for more information on using the CreateCacheParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCacheParameterGroupRequest method.
//    req, resp := client.CreateCacheParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateCacheParameterGroup
func (c *ElastiCache) CreateCacheParameterGroupRequest(input *CreateCacheParameterGroupInput) (req *request.Request, output *CreateCacheParameterGroupOutput) {
	op := &request.Operation{
		Name:       opCreateCacheParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCacheParameterGroupInput{}
	}

	output = &CreateCacheParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCacheParameterGroup API operation for Amazon ElastiCache.
//
// Creates a new Amazon ElastiCache cache parameter group. An ElastiCache cache
// parameter group is a collection of parameters and their values that are applied
// to all of the nodes in any cluster or replication group using the CacheParameterGroup.
//
// A newly created CacheParameterGroup is an exact duplicate of the default
// parameter group for the CacheParameterGroupFamily. To customize the newly
// created CacheParameterGroup you can change the values of specific parameters.
// For more information, see:
//
//    * ModifyCacheParameterGroup (https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyCacheParameterGroup.html)
//    in the ElastiCache API Reference.
//
//    * Parameters and Parameter Groups (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ParameterGroups.html)
//    in the ElastiCache User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation CreateCacheParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCacheParameterGroupQuotaExceededFault "CacheParameterGroupQuotaExceeded"
//   The request cannot be processed because it would exceed the maximum number
//   of cache security groups.
//
//   * ErrCodeCacheParameterGroupAlreadyExistsFault "CacheParameterGroupAlreadyExists"
//   A cache parameter group with the requested name already exists.
//
//   * ErrCodeInvalidCacheParameterGroupStateFault "InvalidCacheParameterGroupState"
//   The current state of the cache parameter group does not allow the requested
//   operation to occur.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateCacheParameterGroup
func (c *ElastiCache) CreateCacheParameterGroup(input *CreateCacheParameterGroupInput) (*CreateCacheParameterGroupOutput, error) {
	req, out := c.CreateCacheParameterGroupRequest(input)
	return out, req.Send()
}

// CreateCacheParameterGroupWithContext is the same as CreateCacheParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCacheParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) CreateCacheParameterGroupWithContext(ctx aws.Context, input *CreateCacheParameterGroupInput, opts ...request.Option) (*CreateCacheParameterGroupOutput, error) {
	req, out := c.CreateCacheParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCacheSecurityGroup = "CreateCacheSecurityGroup"

// CreateCacheSecurityGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateCacheSecurityGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCacheSecurityGroup for more information on using the CreateCacheSecurityGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCacheSecurityGroupRequest method.
//    req, resp := client.CreateCacheSecurityGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateCacheSecurityGroup
func (c *ElastiCache) CreateCacheSecurityGroupRequest(input *CreateCacheSecurityGroupInput) (req *request.Request, output *CreateCacheSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opCreateCacheSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCacheSecurityGroupInput{}
	}

	output = &CreateCacheSecurityGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCacheSecurityGroup API operation for Amazon ElastiCache.
//
// Creates a new cache security group. Use a cache security group to control
// access to one or more clusters.
//
// Cache security groups are only used when you are creating a cluster outside
// of an Amazon Virtual Private Cloud (Amazon VPC). If you are creating a cluster
// inside of a VPC, use a cache subnet group instead. For more information,
// see CreateCacheSubnetGroup (https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateCacheSubnetGroup.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation CreateCacheSecurityGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCacheSecurityGroupAlreadyExistsFault "CacheSecurityGroupAlreadyExists"
//   A cache security group with the specified name already exists.
//
//   * ErrCodeCacheSecurityGroupQuotaExceededFault "QuotaExceeded.CacheSecurityGroup"
//   The request cannot be processed because it would exceed the allowed number
//   of cache security groups.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateCacheSecurityGroup
func (c *ElastiCache) CreateCacheSecurityGroup(input *CreateCacheSecurityGroupInput) (*CreateCacheSecurityGroupOutput, error) {
	req, out := c.CreateCacheSecurityGroupRequest(input)
	return out, req.Send()
}

// CreateCacheSecurityGroupWithContext is the same as CreateCacheSecurityGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCacheSecurityGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) CreateCacheSecurityGroupWithContext(ctx aws.Context, input *CreateCacheSecurityGroupInput, opts ...request.Option) (*CreateCacheSecurityGroupOutput, error) {
	req, out := c.CreateCacheSecurityGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCacheSubnetGroup = "CreateCacheSubnetGroup"

// CreateCacheSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateCacheSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCacheSubnetGroup for more information on using the CreateCacheSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCacheSubnetGroupRequest method.
//    req, resp := client.CreateCacheSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateCacheSubnetGroup
func (c *ElastiCache) CreateCacheSubnetGroupRequest(input *CreateCacheSubnetGroupInput) (req *request.Request, output *CreateCacheSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opCreateCacheSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCacheSubnetGroupInput{}
	}

	output = &CreateCacheSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCacheSubnetGroup API operation for Amazon ElastiCache.
//
// Creates a new cache subnet group.
//
// Use this parameter only when you are creating a cluster in an Amazon Virtual
// Private Cloud (Amazon VPC).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation CreateCacheSubnetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCacheSubnetGroupAlreadyExistsFault "CacheSubnetGroupAlreadyExists"
//   The requested cache subnet group name is already in use by an existing cache
//   subnet group.
//
//   * ErrCodeCacheSubnetGroupQuotaExceededFault "CacheSubnetGroupQuotaExceeded"
//   The request cannot be processed because it would exceed the allowed number
//   of cache subnet groups.
//
//   * ErrCodeCacheSubnetQuotaExceededFault "CacheSubnetQuotaExceededFault"
//   The request cannot be processed because it would exceed the allowed number
//   of subnets in a cache subnet group.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   An invalid subnet identifier was specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateCacheSubnetGroup
func (c *ElastiCache) CreateCacheSubnetGroup(input *CreateCacheSubnetGroupInput) (*CreateCacheSubnetGroupOutput, error) {
	req, out := c.CreateCacheSubnetGroupRequest(input)
	return out, req.Send()
}

// CreateCacheSubnetGroupWithContext is the same as CreateCacheSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCacheSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) CreateCacheSubnetGroupWithContext(ctx aws.Context, input *CreateCacheSubnetGroupInput, opts ...request.Option) (*CreateCacheSubnetGroupOutput, error) {
	req, out := c.CreateCacheSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGlobalReplicationGroup = "CreateGlobalReplicationGroup"

// CreateGlobalReplicationGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateGlobalReplicationGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGlobalReplicationGroup for more information on using the CreateGlobalReplicationGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGlobalReplicationGroupRequest method.
//    req, resp := client.CreateGlobalReplicationGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateGlobalReplicationGroup
func (c *ElastiCache) CreateGlobalReplicationGroupRequest(input *CreateGlobalReplicationGroupInput) (req *request.Request, output *CreateGlobalReplicationGroupOutput) {
	op := &request.Operation{
		Name:       opCreateGlobalReplicationGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGlobalReplicationGroupInput{}
	}

	output = &CreateGlobalReplicationGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGlobalReplicationGroup API operation for Amazon ElastiCache.
//
// Global Datastore for Redis offers fully managed, fast, reliable and secure
// cross-region replication. Using Global Datastore for Redis, you can create
// cross-region read replica clusters for ElastiCache for Redis to enable low-latency
// reads and disaster recovery across regions. For more information, see Replication
// Across Regions Using Global Datastore (/AmazonElastiCache/latest/red-ug/Redis-Global-Clusters.html).
//
//    * The GlobalReplicationGroupIdSuffix is the name of the Global Datastore.
//
//    * The PrimaryReplicationGroupId represents the name of the primary cluster
//    that accepts writes and will replicate updates to the secondary cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation CreateGlobalReplicationGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeReplicationGroupNotFoundFault "ReplicationGroupNotFoundFault"
//   The specified replication group does not exist.
//
//   * ErrCodeInvalidReplicationGroupStateFault "InvalidReplicationGroupState"
//   The requested replication group is not in the available state.
//
//   * ErrCodeGlobalReplicationGroupAlreadyExistsFault "GlobalReplicationGroupAlreadyExistsFault"
//   The Global Datastore name already exists.
//
//   * ErrCodeServiceLinkedRoleNotFoundFault "ServiceLinkedRoleNotFoundFault"
//   The specified service linked role (SLR) was not found.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateGlobalReplicationGroup
func (c *ElastiCache) CreateGlobalReplicationGroup(input *CreateGlobalReplicationGroupInput) (*CreateGlobalReplicationGroupOutput, error) {
	req, out := c.CreateGlobalReplicationGroupRequest(input)
	return out, req.Send()
}

// CreateGlobalReplicationGroupWithContext is the same as CreateGlobalReplicationGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGlobalReplicationGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) CreateGlobalReplicationGroupWithContext(ctx aws.Context, input *CreateGlobalReplicationGroupInput, opts ...request.Option) (*CreateGlobalReplicationGroupOutput, error) {
	req, out := c.CreateGlobalReplicationGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateReplicationGroup = "CreateReplicationGroup"

// CreateReplicationGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateReplicationGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateReplicationGroup for more information on using the CreateReplicationGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateReplicationGroupRequest method.
//    req, resp := client.CreateReplicationGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateReplicationGroup
func (c *ElastiCache) CreateReplicationGroupRequest(input *CreateReplicationGroupInput) (req *request.Request, output *CreateReplicationGroupOutput) {
	op := &request.Operation{
		Name:       opCreateReplicationGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReplicationGroupInput{}
	}

	output = &CreateReplicationGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateReplicationGroup API operation for Amazon ElastiCache.
//
// Creates a Redis (cluster mode disabled) or a Redis (cluster mode enabled)
// replication group.
//
// This API can be used to create a standalone regional replication group or
// a secondary replication group associated with a Global Datastore.
//
// A Redis (cluster mode disabled) replication group is a collection of clusters,
// where one of the clusters is a read/write primary and the others are read-only
// replicas. Writes to the primary are asynchronously propagated to the replicas.
//
// A Redis (cluster mode enabled) replication group is a collection of 1 to
// 90 node groups (shards). Each node group (shard) has one read/write primary
// node and up to 5 read-only replica nodes. Writes to the primary are asynchronously
// propagated to the replicas. Redis (cluster mode enabled) replication groups
// partition the data across node groups (shards).
//
// When a Redis (cluster mode disabled) replication group has been successfully
// created, you can add one or more read replicas to it, up to a total of 5
// read replicas. If you need to increase or decrease the number of node groups
// (console: shards), you can avail yourself of ElastiCache for Redis' scaling.
// For more information, see Scaling ElastiCache for Redis Clusters (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Scaling.html)
// in the ElastiCache User Guide.
//
// This operation is valid for Redis only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation CreateReplicationGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCacheClusterNotFoundFault "CacheClusterNotFound"
//   The requested cluster ID does not refer to an existing cluster.
//
//   * ErrCodeInvalidCacheClusterStateFault "InvalidCacheClusterState"
//   The requested cluster is not in the available state.
//
//   * ErrCodeReplicationGroupAlreadyExistsFault "ReplicationGroupAlreadyExists"
//   The specified replication group already exists.
//
//   * ErrCodeInsufficientCacheClusterCapacityFault "InsufficientCacheClusterCapacity"
//   The requested cache node type is not available in the specified Availability
//   Zone. For more information, see InsufficientCacheClusterCapacity (http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY)
//   in the ElastiCache User Guide.
//
//   * ErrCodeCacheSecurityGroupNotFoundFault "CacheSecurityGroupNotFound"
//   The requested cache security group name does not refer to an existing cache
//   security group.
//
//   * ErrCodeCacheSubnetGroupNotFoundFault "CacheSubnetGroupNotFoundFault"
//   The requested cache subnet group name does not refer to an existing cache
//   subnet group.
//
//   * ErrCodeClusterQuotaForCustomerExceededFault "ClusterQuotaForCustomerExceeded"
//   The request cannot be processed because it would exceed the allowed number
//   of clusters per customer.
//
//   * ErrCodeNodeQuotaForClusterExceededFault "NodeQuotaForClusterExceeded"
//   The request cannot be processed because it would exceed the allowed number
//   of cache nodes in a single cluster.
//
//   * ErrCodeNodeQuotaForCustomerExceededFault "NodeQuotaForCustomerExceeded"
//   The request cannot be processed because it would exceed the allowed number
//   of cache nodes per customer.
//
//   * ErrCodeCacheParameterGroupNotFoundFault "CacheParameterGroupNotFound"
//   The requested cache parameter group name does not refer to an existing cache
//   parameter group.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   The VPC network is in an invalid state.
//
//   * ErrCodeTagQuotaPerResourceExceeded "TagQuotaPerResourceExceeded"
//   The request cannot be processed because it would cause the resource to have
//   more than the allowed number of tags. The maximum number of tags permitted
//   on a resource is 50.
//
//   * ErrCodeNodeGroupsPerReplicationGroupQuotaExceededFault "NodeGroupsPerReplicationGroupQuotaExceeded"
//   The request cannot be processed because it would exceed the maximum allowed
//   number of node groups (shards) in a single replication group. The default
//   maximum is 90
//
//   * ErrCodeGlobalReplicationGroupNotFoundFault "GlobalReplicationGroupNotFoundFault"
//   The Global Datastore does not exist
//
//   * ErrCodeInvalidGlobalReplicationGroupStateFault "InvalidGlobalReplicationGroupState"
//   The Global Datastore is not available or in primary-only state.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateReplicationGroup
func (c *ElastiCache) CreateReplicationGroup(input *CreateReplicationGroupInput) (*CreateReplicationGroupOutput, error) {
	req, out := c.CreateReplicationGroupRequest(input)
	return out, req.Send()
}

// CreateReplicationGroupWithContext is the same as CreateReplicationGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReplicationGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) CreateReplicationGroupWithContext(ctx aws.Context, input *CreateReplicationGroupInput, opts ...request.Option) (*CreateReplicationGroupOutput, error) {
	req, out := c.CreateReplicationGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSnapshot = "CreateSnapshot"

// CreateSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSnapshot for more information on using the CreateSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSnapshotRequest method.
//    req, resp := client.CreateSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateSnapshot
func (c *ElastiCache) CreateSnapshotRequest(input *CreateSnapshotInput) (req *request.Request, output *CreateSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSnapshotInput{}
	}

	output = &CreateSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSnapshot API operation for Amazon ElastiCache.
//
// Creates a copy of an entire cluster or replication group at a specific moment
// in time.
//
// This operation is valid for Redis only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation CreateSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSnapshotAlreadyExistsFault "SnapshotAlreadyExistsFault"
//   You already have a snapshot with the given name.
//
//   * ErrCodeCacheClusterNotFoundFault "CacheClusterNotFound"
//   The requested cluster ID does not refer to an existing cluster.
//
//   * ErrCodeReplicationGroupNotFoundFault "ReplicationGroupNotFoundFault"
//   The specified replication group does not exist.
//
//   * ErrCodeInvalidCacheClusterStateFault "InvalidCacheClusterState"
//   The requested cluster is not in the available state.
//
//   * ErrCodeInvalidReplicationGroupStateFault "InvalidReplicationGroupState"
//   The requested replication group is not in the available state.
//
//   * ErrCodeSnapshotQuotaExceededFault "SnapshotQuotaExceededFault"
//   The request cannot be processed because it would exceed the maximum number
//   of snapshots.
//
//   * ErrCodeSnapshotFeatureNotSupportedFault "SnapshotFeatureNotSupportedFault"
//   You attempted one of the following operations:
//
//      * Creating a snapshot of a Redis cluster running on a cache.t1.micro cache
//      node.
//
//      * Creating a snapshot of a cluster that is running Memcached rather than
//      Redis.
//
//   Neither of these are supported by ElastiCache.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateSnapshot
func (c *ElastiCache) CreateSnapshot(input *CreateSnapshotInput) (*CreateSnapshotOutput, error) {
	req, out := c.CreateSnapshotRequest(input)
	return out, req.Send()
}

// CreateSnapshotWithContext is the same as CreateSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) CreateSnapshotWithContext(ctx aws.Context, input *CreateSnapshotInput, opts ...request.Option) (*CreateSnapshotOutput, error) {
	req, out := c.CreateSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDecreaseNodeGroupsInGlobalReplicationGroup = "DecreaseNodeGroupsInGlobalReplicationGroup"

// DecreaseNodeGroupsInGlobalReplicationGroupRequest generates a "aws/request.Request" representing the
// client's request for the DecreaseNodeGroupsInGlobalReplicationGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DecreaseNodeGroupsInGlobalReplicationGroup for more information on using the DecreaseNodeGroupsInGlobalReplicationGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DecreaseNodeGroupsInGlobalReplicationGroupRequest method.
//    req, resp := client.DecreaseNodeGroupsInGlobalReplicationGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DecreaseNodeGroupsInGlobalReplicationGroup
func (c *ElastiCache) DecreaseNodeGroupsInGlobalReplicationGroupRequest(input *DecreaseNodeGroupsInGlobalReplicationGroupInput) (req *request.Request, output *DecreaseNodeGroupsInGlobalReplicationGroupOutput) {
	op := &request.Operation{
		Name:       opDecreaseNodeGroupsInGlobalReplicationGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DecreaseNodeGroupsInGlobalReplicationGroupInput{}
	}

	output = &DecreaseNodeGroupsInGlobalReplicationGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DecreaseNodeGroupsInGlobalReplicationGroup API operation for Amazon ElastiCache.
//
// Decreases the number of node groups in a Global Datastore
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation DecreaseNodeGroupsInGlobalReplicationGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeGlobalReplicationGroupNotFoundFault "GlobalReplicationGroupNotFoundFault"
//   The Global Datastore does not exist
//
//   * ErrCodeInvalidGlobalReplicationGroupStateFault "InvalidGlobalReplicationGroupState"
//   The Global Datastore is not available or in primary-only state.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DecreaseNodeGroupsInGlobalReplicationGroup
func (c *ElastiCache) DecreaseNodeGroupsInGlobalReplicationGroup(input *DecreaseNodeGroupsInGlobalReplicationGroupInput) (*DecreaseNodeGroupsInGlobalReplicationGroupOutput, error) {
	req, out := c.DecreaseNodeGroupsInGlobalReplicationGroupRequest(input)
	return out, req.Send()
}

// DecreaseNodeGroupsInGlobalReplicationGroupWithContext is the same as DecreaseNodeGroupsInGlobalReplicationGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DecreaseNodeGroupsInGlobalReplicationGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DecreaseNodeGroupsInGlobalReplicationGroupWithContext(ctx aws.Context, input *DecreaseNodeGroupsInGlobalReplicationGroupInput, opts ...request.Option) (*DecreaseNodeGroupsInGlobalReplicationGroupOutput, error) {
	req, out := c.DecreaseNodeGroupsInGlobalReplicationGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDecreaseReplicaCount = "DecreaseReplicaCount"

// DecreaseReplicaCountRequest generates a "aws/request.Request" representing the
// client's request for the DecreaseReplicaCount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DecreaseReplicaCount for more information on using the DecreaseReplicaCount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DecreaseReplicaCountRequest method.
//    req, resp := client.DecreaseReplicaCountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DecreaseReplicaCount
func (c *ElastiCache) DecreaseReplicaCountRequest(input *DecreaseReplicaCountInput) (req *request.Request, output *DecreaseReplicaCountOutput) {
	op := &request.Operation{
		Name:       opDecreaseReplicaCount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DecreaseReplicaCountInput{}
	}

	output = &DecreaseReplicaCountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DecreaseReplicaCount API operation for Amazon ElastiCache.
//
// Dynamically decreases the number of replicas in a Redis (cluster mode disabled)
// replication group or the number of replica nodes in one or more node groups
// (shards) of a Redis (cluster mode enabled) replication group. This operation
// is performed with no cluster down time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation DecreaseReplicaCount for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeReplicationGroupNotFoundFault "ReplicationGroupNotFoundFault"
//   The specified replication group does not exist.
//
//   * ErrCodeInvalidReplicationGroupStateFault "InvalidReplicationGroupState"
//   The requested replication group is not in the available state.
//
//   * ErrCodeInvalidCacheClusterStateFault "InvalidCacheClusterState"
//   The requested cluster is not in the available state.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   The VPC network is in an invalid state.
//
//   * ErrCodeInsufficientCacheClusterCapacityFault "InsufficientCacheClusterCapacity"
//   The requested cache node type is not available in the specified Availability
//   Zone. For more information, see InsufficientCacheClusterCapacity (http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY)
//   in the ElastiCache User Guide.
//
//   * ErrCodeClusterQuotaForCustomerExceededFault "ClusterQuotaForCustomerExceeded"
//   The request cannot be processed because it would exceed the allowed number
//   of clusters per customer.
//
//   * ErrCodeNodeGroupsPerReplicationGroupQuotaExceededFault "NodeGroupsPerReplicationGroupQuotaExceeded"
//   The request cannot be processed because it would exceed the maximum allowed
//   number of node groups (shards) in a single replication group. The default
//   maximum is 90
//
//   * ErrCodeNodeQuotaForCustomerExceededFault "NodeQuotaForCustomerExceeded"
//   The request cannot be processed because it would exceed the allowed number
//   of cache nodes per customer.
//
//   * ErrCodeServiceLinkedRoleNotFoundFault "ServiceLinkedRoleNotFoundFault"
//   The specified service linked role (SLR) was not found.
//
//   * ErrCodeNoOperationFault "NoOperationFault"
//   The operation was not performed because no changes were required.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DecreaseReplicaCount
func (c *ElastiCache) DecreaseReplicaCount(input *DecreaseReplicaCountInput) (*DecreaseReplicaCountOutput, error) {
	req, out := c.DecreaseReplicaCountRequest(input)
	return out, req.Send()
}

// DecreaseReplicaCountWithContext is the same as DecreaseReplicaCount with the addition of
// the ability to pass a context and additional request options.
//
// See DecreaseReplicaCount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DecreaseReplicaCountWithContext(ctx aws.Context, input *DecreaseReplicaCountInput, opts ...request.Option) (*DecreaseReplicaCountOutput, error) {
	req, out := c.DecreaseReplicaCountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCacheCluster = "DeleteCacheCluster"

// DeleteCacheClusterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCacheCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCacheCluster for more information on using the DeleteCacheCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCacheClusterRequest method.
//    req, resp := client.DeleteCacheClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteCacheCluster
func (c *ElastiCache) DeleteCacheClusterRequest(input *DeleteCacheClusterInput) (req *request.Request, output *DeleteCacheClusterOutput) {
	op := &request.Operation{
		Name:       opDeleteCacheCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCacheClusterInput{}
	}

	output = &DeleteCacheClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCacheCluster API operation for Amazon ElastiCache.
//
// Deletes a previously provisioned cluster. DeleteCacheCluster deletes all
// associated cache nodes, node endpoints and the cluster itself. When you receive
// a successful response from this operation, Amazon ElastiCache immediately
// begins deleting the cluster; you cannot cancel or revert this operation.
//
// This operation is not valid for:
//
//    * Redis (cluster mode enabled) clusters
//
//    * A cluster that is the last read replica of a replication group
//
//    * A node group (shard) that has Multi-AZ mode enabled
//
//    * A cluster from a Redis (cluster mode enabled) replication group
//
//    * A cluster that is not in the available state
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation DeleteCacheCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCacheClusterNotFoundFault "CacheClusterNotFound"
//   The requested cluster ID does not refer to an existing cluster.
//
//   * ErrCodeInvalidCacheClusterStateFault "InvalidCacheClusterState"
//   The requested cluster is not in the available state.
//
//   * ErrCodeSnapshotAlreadyExistsFault "SnapshotAlreadyExistsFault"
//   You already have a snapshot with the given name.
//
//   * ErrCodeSnapshotFeatureNotSupportedFault "SnapshotFeatureNotSupportedFault"
//   You attempted one of the following operations:
//
//      * Creating a snapshot of a Redis cluster running on a cache.t1.micro cache
//      node.
//
//      * Creating a snapshot of a cluster that is running Memcached rather than
//      Redis.
//
//   Neither of these are supported by ElastiCache.
//
//   * ErrCodeSnapshotQuotaExceededFault "SnapshotQuotaExceededFault"
//   The request cannot be processed because it would exceed the maximum number
//   of snapshots.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteCacheCluster
func (c *ElastiCache) DeleteCacheCluster(input *DeleteCacheClusterInput) (*DeleteCacheClusterOutput, error) {
	req, out := c.DeleteCacheClusterRequest(input)
	return out, req.Send()
}

// DeleteCacheClusterWithContext is the same as DeleteCacheCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCacheCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DeleteCacheClusterWithContext(ctx aws.Context, input *DeleteCacheClusterInput, opts ...request.Option) (*DeleteCacheClusterOutput, error) {
	req, out := c.DeleteCacheClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCacheParameterGroup = "DeleteCacheParameterGroup"

// DeleteCacheParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCacheParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCacheParameterGroup for more information on using the DeleteCacheParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCacheParameterGroupRequest method.
//    req, resp := client.DeleteCacheParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteCacheParameterGroup
func (c *ElastiCache) DeleteCacheParameterGroupRequest(input *DeleteCacheParameterGroupInput) (req *request.Request, output *DeleteCacheParameterGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteCacheParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCacheParameterGroupInput{}
	}

	output = &DeleteCacheParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCacheParameterGroup API operation for Amazon ElastiCache.
//
// Deletes the specified cache parameter group. You cannot delete a cache parameter
// group if it is associated with any cache clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation DeleteCacheParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidCacheParameterGroupStateFault "InvalidCacheParameterGroupState"
//   The current state of the cache parameter group does not allow the requested
//   operation to occur.
//
//   * ErrCodeCacheParameterGroupNotFoundFault "CacheParameterGroupNotFound"
//   The requested cache parameter group name does not refer to an existing cache
//   parameter group.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteCacheParameterGroup
func (c *ElastiCache) DeleteCacheParameterGroup(input *DeleteCacheParameterGroupInput) (*DeleteCacheParameterGroupOutput, error) {
	req, out := c.DeleteCacheParameterGroupRequest(input)
	return out, req.Send()
}

// DeleteCacheParameterGroupWithContext is the same as DeleteCacheParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCacheParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DeleteCacheParameterGroupWithContext(ctx aws.Context, input *DeleteCacheParameterGroupInput, opts ...request.Option) (*DeleteCacheParameterGroupOutput, error) {
	req, out := c.DeleteCacheParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCacheSecurityGroup = "DeleteCacheSecurityGroup"

// DeleteCacheSecurityGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCacheSecurityGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCacheSecurityGroup for more information on using the DeleteCacheSecurityGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCacheSecurityGroupRequest method.
//    req, resp := client.DeleteCacheSecurityGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteCacheSecurityGroup
func (c *ElastiCache) DeleteCacheSecurityGroupRequest(input *DeleteCacheSecurityGroupInput) (req *request.Request, output *DeleteCacheSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteCacheSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCacheSecurityGroupInput{}
	}

	output = &DeleteCacheSecurityGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCacheSecurityGroup API operation for Amazon ElastiCache.
//
// Deletes a cache security group.
//
// You cannot delete a cache security group if it is associated with any clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation DeleteCacheSecurityGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidCacheSecurityGroupStateFault "InvalidCacheSecurityGroupState"
//   The current state of the cache security group does not allow deletion.
//
//   * ErrCodeCacheSecurityGroupNotFoundFault "CacheSecurityGroupNotFound"
//   The requested cache security group name does not refer to an existing cache
//   security group.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteCacheSecurityGroup
func (c *ElastiCache) DeleteCacheSecurityGroup(input *DeleteCacheSecurityGroupInput) (*DeleteCacheSecurityGroupOutput, error) {
	req, out := c.DeleteCacheSecurityGroupRequest(input)
	return out, req.Send()
}

// DeleteCacheSecurityGroupWithContext is the same as DeleteCacheSecurityGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCacheSecurityGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DeleteCacheSecurityGroupWithContext(ctx aws.Context, input *DeleteCacheSecurityGroupInput, opts ...request.Option) (*DeleteCacheSecurityGroupOutput, error) {
	req, out := c.DeleteCacheSecurityGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCacheSubnetGroup = "DeleteCacheSubnetGroup"

// DeleteCacheSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCacheSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCacheSubnetGroup for more information on using the DeleteCacheSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCacheSubnetGroupRequest method.
//    req, resp := client.DeleteCacheSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteCacheSubnetGroup
func (c *ElastiCache) DeleteCacheSubnetGroupRequest(input *DeleteCacheSubnetGroupInput) (req *request.Request, output *DeleteCacheSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteCacheSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCacheSubnetGroupInput{}
	}

	output = &DeleteCacheSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCacheSubnetGroup API operation for Amazon ElastiCache.
//
// Deletes a cache subnet group.
//
// You cannot delete a cache subnet group if it is associated with any clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation DeleteCacheSubnetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCacheSubnetGroupInUse "CacheSubnetGroupInUse"
//   The requested cache subnet group is currently in use.
//
//   * ErrCodeCacheSubnetGroupNotFoundFault "CacheSubnetGroupNotFoundFault"
//   The requested cache subnet group name does not refer to an existing cache
//   subnet group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteCacheSubnetGroup
func (c *ElastiCache) DeleteCacheSubnetGroup(input *DeleteCacheSubnetGroupInput) (*DeleteCacheSubnetGroupOutput, error) {
	req, out := c.DeleteCacheSubnetGroupRequest(input)
	return out, req.Send()
}

// DeleteCacheSubnetGroupWithContext is the same as DeleteCacheSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCacheSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DeleteCacheSubnetGroupWithContext(ctx aws.Context, input *DeleteCacheSubnetGroupInput, opts ...request.Option) (*DeleteCacheSubnetGroupOutput, error) {
	req, out := c.DeleteCacheSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGlobalReplicationGroup = "DeleteGlobalReplicationGroup"

// DeleteGlobalReplicationGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGlobalReplicationGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGlobalReplicationGroup for more information on using the DeleteGlobalReplicationGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGlobalReplicationGroupRequest method.
//    req, resp := client.DeleteGlobalReplicationGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteGlobalReplicationGroup
func (c *ElastiCache) DeleteGlobalReplicationGroupRequest(input *DeleteGlobalReplicationGroupInput) (req *request.Request, output *DeleteGlobalReplicationGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteGlobalReplicationGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteGlobalReplicationGroupInput{}
	}

	output = &DeleteGlobalReplicationGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteGlobalReplicationGroup API operation for Amazon ElastiCache.
//
// Deleting a Global Datastore is a two-step process:
//
//    * First, you must DisassociateGlobalReplicationGroup to remove the secondary
//    clusters in the Global Datastore.
//
//    * Once the Global Datastore contains only the primary cluster, you can
//    use DeleteGlobalReplicationGroup API to delete the Global Datastore while
//    retainining the primary cluster using Retain…= true.
//
// Since the Global Datastore has only a primary cluster, you can delete the
// Global Datastore while retaining the primary by setting RetainPrimaryCluster=true.
//
// When you receive a successful response from this operation, Amazon ElastiCache
// immediately begins deleting the selected resources; you cannot cancel or
// revert this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation DeleteGlobalReplicationGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeGlobalReplicationGroupNotFoundFault "GlobalReplicationGroupNotFoundFault"
//   The Global Datastore does not exist
//
//   * ErrCodeInvalidGlobalReplicationGroupStateFault "InvalidGlobalReplicationGroupState"
//   The Global Datastore is not available or in primary-only state.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteGlobalReplicationGroup
func (c *ElastiCache) DeleteGlobalReplicationGroup(input *DeleteGlobalReplicationGroupInput) (*DeleteGlobalReplicationGroupOutput, error) {
	req, out := c.DeleteGlobalReplicationGroupRequest(input)
	return out, req.Send()
}

// DeleteGlobalReplicationGroupWithContext is the same as DeleteGlobalReplicationGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGlobalReplicationGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DeleteGlobalReplicationGroupWithContext(ctx aws.Context, input *DeleteGlobalReplicationGroupInput, opts ...request.Option) (*DeleteGlobalReplicationGroupOutput, error) {
	req, out := c.DeleteGlobalReplicationGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReplicationGroup = "DeleteReplicationGroup"

// DeleteReplicationGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReplicationGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReplicationGroup for more information on using the DeleteReplicationGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteReplicationGroupRequest method.
//    req, resp := client.DeleteReplicationGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteReplicationGroup
func (c *ElastiCache) DeleteReplicationGroupRequest(input *DeleteReplicationGroupInput) (req *request.Request, output *DeleteReplicationGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteReplicationGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReplicationGroupInput{}
	}

	output = &DeleteReplicationGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteReplicationGroup API operation for Amazon ElastiCache.
//
// Deletes an existing replication group. By default, this operation deletes
// the entire replication group, including the primary/primaries and all of
// the read replicas. If the replication group has only one primary, you can
// optionally delete only the read replicas, while retaining the primary by
// setting RetainPrimaryCluster=true.
//
// When you receive a successful response from this operation, Amazon ElastiCache
// immediately begins deleting the selected resources; you cannot cancel or
// revert this operation.
//
// This operation is valid for Redis only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation DeleteReplicationGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeReplicationGroupNotFoundFault "ReplicationGroupNotFoundFault"
//   The specified replication group does not exist.
//
//   * ErrCodeInvalidReplicationGroupStateFault "InvalidReplicationGroupState"
//   The requested replication group is not in the available state.
//
//   * ErrCodeSnapshotAlreadyExistsFault "SnapshotAlreadyExistsFault"
//   You already have a snapshot with the given name.
//
//   * ErrCodeSnapshotFeatureNotSupportedFault "SnapshotFeatureNotSupportedFault"
//   You attempted one of the following operations:
//
//      * Creating a snapshot of a Redis cluster running on a cache.t1.micro cache
//      node.
//
//      * Creating a snapshot of a cluster that is running Memcached rather than
//      Redis.
//
//   Neither of these are supported by ElastiCache.
//
//   * ErrCodeSnapshotQuotaExceededFault "SnapshotQuotaExceededFault"
//   The request cannot be processed because it would exceed the maximum number
//   of snapshots.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteReplicationGroup
func (c *ElastiCache) DeleteReplicationGroup(input *DeleteReplicationGroupInput) (*DeleteReplicationGroupOutput, error) {
	req, out := c.DeleteReplicationGroupRequest(input)
	return out, req.Send()
}

// DeleteReplicationGroupWithContext is the same as DeleteReplicationGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReplicationGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DeleteReplicationGroupWithContext(ctx aws.Context, input *DeleteReplicationGroupInput, opts ...request.Option) (*DeleteReplicationGroupOutput, error) {
	req, out := c.DeleteReplicationGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSnapshot = "DeleteSnapshot"

// DeleteSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSnapshot for more information on using the DeleteSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSnapshotRequest method.
//    req, resp := client.DeleteSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteSnapshot
func (c *ElastiCache) DeleteSnapshotRequest(input *DeleteSnapshotInput) (req *request.Request, output *DeleteSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeleteSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSnapshotInput{}
	}

	output = &DeleteSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSnapshot API operation for Amazon ElastiCache.
//
// Deletes an existing snapshot. When you receive a successful response from
// this operation, ElastiCache immediately begins deleting the snapshot; you
// cannot cancel or revert this operation.
//
// This operation is valid for Redis only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation DeleteSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSnapshotNotFoundFault "SnapshotNotFoundFault"
//   The requested snapshot name does not refer to an existing snapshot.
//
//   * ErrCodeInvalidSnapshotStateFault "InvalidSnapshotState"
//   The current state of the snapshot does not allow the requested operation
//   to occur.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteSnapshot
func (c *ElastiCache) DeleteSnapshot(input *DeleteSnapshotInput) (*DeleteSnapshotOutput, error) {
	req, out := c.DeleteSnapshotRequest(input)
	return out, req.Send()
}

// DeleteSnapshotWithContext is the same as DeleteSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DeleteSnapshotWithContext(ctx aws.Context, input *DeleteSnapshotInput, opts ...request.Option) (*DeleteSnapshotOutput, error) {
	req, out := c.DeleteSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCacheClusters = "DescribeCacheClusters"

// DescribeCacheClustersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCacheClusters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCacheClusters for more information on using the DescribeCacheClusters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCacheClustersRequest method.
//    req, resp := client.DescribeCacheClustersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheClusters
func (c *ElastiCache) DescribeCacheClustersRequest(input *DescribeCacheClustersInput) (req *request.Request, output *DescribeCacheClustersOutput) {
	op := &request.Operation{
		Name:       opDescribeCacheClusters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCacheClustersInput{}
	}

	output = &DescribeCacheClustersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCacheClusters API operation for Amazon ElastiCache.
//
// Returns information about all provisioned clusters if no cluster identifier
// is specified, or about a specific cache cluster if a cluster identifier is
// supplied.
//
// By default, abbreviated information about the clusters is returned. You can
// use the optional ShowCacheNodeInfo flag to retrieve detailed information
// about the cache nodes associated with the clusters. These details include
// the DNS address and port for the cache node endpoint.
//
// If the cluster is in the creating state, only cluster-level information is
// displayed until all of the nodes are successfully provisioned.
//
// If the cluster is in the deleting state, only cluster-level information is
// displayed.
//
// If cache nodes are currently being added to the cluster, node endpoint information
// and creation time for the additional nodes are not displayed until they are
// completely provisioned. When the cluster state is available, the cluster
// is ready for use.
//
// If cache nodes are currently being removed from the cluster, no endpoint
// information for the removed nodes is displayed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation DescribeCacheClusters for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCacheClusterNotFoundFault "CacheClusterNotFound"
//   The requested cluster ID does not refer to an existing cluster.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheClusters
func (c *ElastiCache) DescribeCacheClusters(input *DescribeCacheClustersInput) (*DescribeCacheClustersOutput, error) {
	req, out := c.DescribeCacheClustersRequest(input)
	return out, req.Send()
}

// DescribeCacheClustersWithContext is the same as DescribeCacheClusters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCacheClusters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DescribeCacheClustersWithContext(ctx aws.Context, input *DescribeCacheClustersInput, opts ...request.Option) (*DescribeCacheClustersOutput, error) {
	req, out := c.DescribeCacheClustersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeCacheClustersPages iterates over the pages of a DescribeCacheClusters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeCacheClusters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeCacheClusters operation.
//    pageNum := 0
//    err := client.DescribeCacheClustersPages(params,
//        func(page *elasticache.DescribeCacheClustersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ElastiCache) DescribeCacheClustersPages(input *DescribeCacheClustersInput, fn func(*DescribeCacheClustersOutput, bool) bool) error {
	return c.DescribeCacheClustersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeCacheClustersPagesWithContext same as DescribeCacheClustersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DescribeCacheClustersPagesWithContext(ctx aws.Context, input *DescribeCacheClustersInput, fn func(*DescribeCacheClustersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeCacheClustersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeCacheClustersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeCacheClustersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeCacheEngineVersions = "DescribeCacheEngineVersions"

// DescribeCacheEngineVersionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCacheEngineVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCacheEngineVersions for more information on using the DescribeCacheEngineVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCacheEngineVersionsRequest method.
//    req, resp := client.DescribeCacheEngineVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheEngineVersions
func (c *ElastiCache) DescribeCacheEngineVersionsRequest(input *DescribeCacheEngineVersionsInput) (req *request.Request, output *DescribeCacheEngineVersionsOutput) {
	op := &request.Operation{
		Name:       opDescribeCacheEngineVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCacheEngineVersionsInput{}
	}

	output = &DescribeCacheEngineVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCacheEngineVersions API operation for Amazon ElastiCache.
//
// Returns a list of the available cache engines and their versions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation DescribeCacheEngineVersions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheEngineVersions
func (c *ElastiCache) DescribeCacheEngineVersions(input *DescribeCacheEngineVersionsInput) (*DescribeCacheEngineVersionsOutput, error) {
	req, out := c.DescribeCacheEngineVersionsRequest(input)
	return out, req.Send()
}

// DescribeCacheEngineVersionsWithContext is the same as DescribeCacheEngineVersions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCacheEngineVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DescribeCacheEngineVersionsWithContext(ctx aws.Context, input *DescribeCacheEngineVersionsInput, opts ...request.Option) (*DescribeCacheEngineVersionsOutput, error) {
	req, out := c.DescribeCacheEngineVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeCacheEngineVersionsPages iterates over the pages of a DescribeCacheEngineVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeCacheEngineVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeCacheEngineVersions operation.
//    pageNum := 0
//    err := client.DescribeCacheEngineVersionsPages(params,
//        func(page *elasticache.DescribeCacheEngineVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ElastiCache) DescribeCacheEngineVersionsPages(input *DescribeCacheEngineVersionsInput, fn func(*DescribeCacheEngineVersionsOutput, bool) bool) error {
	return c.DescribeCacheEngineVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeCacheEngineVersionsPagesWithContext same as DescribeCacheEngineVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DescribeCacheEngineVersionsPagesWithContext(ctx aws.Context, input *DescribeCacheEngineVersionsInput, fn func(*DescribeCacheEngineVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeCacheEngineVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeCacheEngineVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeCacheEngineVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeCacheParameterGroups = "DescribeCacheParameterGroups"

// DescribeCacheParameterGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCacheParameterGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCacheParameterGroups for more information on using the DescribeCacheParameterGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCacheParameterGroupsRequest method.
//    req, resp := client.DescribeCacheParameterGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheParameterGroups
func (c *ElastiCache) DescribeCacheParameterGroupsRequest(input *DescribeCacheParameterGroupsInput) (req *request.Request, output *DescribeCacheParameterGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeCacheParameterGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCacheParameterGroupsInput{}
	}

	output = &DescribeCacheParameterGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCacheParameterGroups API operation for Amazon ElastiCache.
//
// Returns a list of cache parameter group descriptions. If a cache parameter
// group name is specified, the list contains only the descriptions for that
// group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation DescribeCacheParameterGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCacheParameterGroupNotFoundFault "CacheParameterGroupNotFound"
//   The requested cache parameter group name does not refer to an existing cache
//   parameter group.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheParameterGroups
func (c *ElastiCache) DescribeCacheParameterGroups(input *DescribeCacheParameterGroupsInput) (*DescribeCacheParameterGroupsOutput, error) {
	req, out := c.DescribeCacheParameterGroupsRequest(input)
	return out, req.Send()
}

// DescribeCacheParameterGroupsWithContext is the same as DescribeCacheParameterGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCacheParameterGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DescribeCacheParameterGroupsWithContext(ctx aws.Context, input *DescribeCacheParameterGroupsInput, opts ...request.Option) (*DescribeCacheParameterGroupsOutput, error) {
	req, out := c.DescribeCacheParameterGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeCacheParameterGroupsPages iterates over the pages of a DescribeCacheParameterGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeCacheParameterGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeCacheParameterGroups operation.
//    pageNum := 0
//    err := client.DescribeCacheParameterGroupsPages(params,
//        func(page *elasticache.DescribeCacheParameterGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ElastiCache) DescribeCacheParameterGroupsPages(input *DescribeCacheParameterGroupsInput, fn func(*DescribeCacheParameterGroupsOutput, bool) bool) error {
	return c.DescribeCacheParameterGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeCacheParameterGroupsPagesWithContext same as DescribeCacheParameterGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DescribeCacheParameterGroupsPagesWithContext(ctx aws.Context, input *DescribeCacheParameterGroupsInput, fn func(*DescribeCacheParameterGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeCacheParameterGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeCacheParameterGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeCacheParameterGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeCacheParameters = "DescribeCacheParameters"

// DescribeCacheParametersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCacheParameters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCacheParameters for more information on using the DescribeCacheParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCacheParametersRequest method.
//    req, resp := client.DescribeCacheParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheParameters
func (c *ElastiCache) DescribeCacheParametersRequest(input *DescribeCacheParametersInput) (req *request.Request, output *DescribeCacheParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeCacheParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCacheParametersInput{}
	}

	output = &DescribeCacheParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCacheParameters API operation for Amazon ElastiCache.
//
// Returns the detailed parameter list for a particular cache parameter group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation DescribeCacheParameters for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCacheParameterGroupNotFoundFault "CacheParameterGroupNotFound"
//   The requested cache parameter group name does not refer to an existing cache
//   parameter group.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheParameters
func (c *ElastiCache) DescribeCacheParameters(input *DescribeCacheParametersInput) (*DescribeCacheParametersOutput, error) {
	req, out := c.DescribeCacheParametersRequest(input)
	return out, req.Send()
}

// DescribeCacheParametersWithContext is the same as DescribeCacheParameters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCacheParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DescribeCacheParametersWithContext(ctx aws.Context, input *DescribeCacheParametersInput, opts ...request.Option) (*DescribeCacheParametersOutput, error) {
	req, out := c.DescribeCacheParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeCacheParametersPages iterates over the pages of a DescribeCacheParameters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeCacheParameters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeCacheParameters operation.
//    pageNum := 0
//    err := client.DescribeCacheParametersPages(params,
//        func(page *elasticache.DescribeCacheParametersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ElastiCache) DescribeCacheParametersPages(input *DescribeCacheParametersInput, fn func(*DescribeCacheParametersOutput, bool) bool) error {
	return c.DescribeCacheParametersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeCacheParametersPagesWithContext same as DescribeCacheParametersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DescribeCacheParametersPagesWithContext(ctx aws.Context, input *DescribeCacheParametersInput, fn func(*DescribeCacheParametersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeCacheParametersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeCacheParametersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeCacheParametersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeCacheSecurityGroups = "DescribeCacheSecurityGroups"

// DescribeCacheSecurityGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCacheSecurityGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCacheSecurityGroups for more information on using the DescribeCacheSecurityGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCacheSecurityGroupsRequest method.
//    req, resp := client.DescribeCacheSecurityGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheSecurityGroups
func (c *ElastiCache) DescribeCacheSecurityGroupsRequest(input *DescribeCacheSecurityGroupsInput) (req *request.Request, output *DescribeCacheSecurityGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeCacheSecurityGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCacheSecurityGroupsInput{}
	}

	output = &DescribeCacheSecurityGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCacheSecurityGroups API operation for Amazon ElastiCache.
//
// Returns a list of cache security group descriptions. If a cache security
// group name is specified, the list contains only the description of that group.
// This applicable only when you have ElastiCache in Classic setup
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation DescribeCacheSecurityGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCacheSecurityGroupNotFoundFault "CacheSecurityGroupNotFound"
//   The requested cache security group name does not refer to an existing cache
//   security group.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheSecurityGroups
func (c *ElastiCache) DescribeCacheSecurityGroups(input *DescribeCacheSecurityGroupsInput) (*DescribeCacheSecurityGroupsOutput, error) {
	req, out := c.DescribeCacheSecurityGroupsRequest(input)
	return out, req.Send()
}

// DescribeCacheSecurityGroupsWithContext is the same as DescribeCacheSecurityGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCacheSecurityGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DescribeCacheSecurityGroupsWithContext(ctx aws.Context, input *DescribeCacheSecurityGroupsInput, opts ...request.Option) (*DescribeCacheSecurityGroupsOutput, error) {
	req, out := c.DescribeCacheSecurityGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeCacheSecurityGroupsPages iterates over the pages of a DescribeCacheSecurityGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeCacheSecurityGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeCacheSecurityGroups operation.
//    pageNum := 0
//    err := client.DescribeCacheSecurityGroupsPages(params,
//        func(page *elasticache.DescribeCacheSecurityGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ElastiCache) DescribeCacheSecurityGroupsPages(input *DescribeCacheSecurityGroupsInput, fn func(*DescribeCacheSecurityGroupsOutput, bool) bool) error {
	return c.DescribeCacheSecurityGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeCacheSecurityGroupsPagesWithContext same as DescribeCacheSecurityGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DescribeCacheSecurityGroupsPagesWithContext(ctx aws.Context, input *DescribeCacheSecurityGroupsInput, fn func(*DescribeCacheSecurityGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeCacheSecurityGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeCacheSecurityGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeCacheSecurityGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeCacheSubnetGroups = "DescribeCacheSubnetGroups"

// DescribeCacheSubnetGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCacheSubnetGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCacheSubnetGroups for more information on using the DescribeCacheSubnetGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCacheSubnetGroupsRequest method.
//    req, resp := client.DescribeCacheSubnetGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheSubnetGroups
func (c *ElastiCache) DescribeCacheSubnetGroupsRequest(input *DescribeCacheSubnetGroupsInput) (req *request.Request, output *DescribeCacheSubnetGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeCacheSubnetGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCacheSubnetGroupsInput{}
	}

	output = &DescribeCacheSubnetGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCacheSubnetGroups API operation for Amazon ElastiCache.
//
// Returns a list of cache subnet group descriptions. If a subnet group name
// is specified, the list contains only the description of that group. This
// is applicable only when you have ElastiCache in VPC setup. All ElastiCache
// clusters now launch in VPC by default.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation DescribeCacheSubnetGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCacheSubnetGroupNotFoundFault "CacheSubnetGroupNotFoundFault"
//   The requested cache subnet group name does not refer to an existing cache
//   subnet group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheSubnetGroups
func (c *ElastiCache) DescribeCacheSubnetGroups(input *DescribeCacheSubnetGroupsInput) (*DescribeCacheSubnetGroupsOutput, error) {
	req, out := c.DescribeCacheSubnetGroupsRequest(input)
	return out, req.Send()
}

// DescribeCacheSubnetGroupsWithContext is the same as DescribeCacheSubnetGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCacheSubnetGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DescribeCacheSubnetGroupsWithContext(ctx aws.Context, input *DescribeCacheSubnetGroupsInput, opts ...request.Option) (*DescribeCacheSubnetGroupsOutput, error) {
	req, out := c.DescribeCacheSubnetGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeCacheSubnetGroupsPages iterates over the pages of a DescribeCacheSubnetGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeCacheSubnetGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeCacheSubnetGroups operation.
//    pageNum := 0
//    err := client.DescribeCacheSubnetGroupsPages(params,
//        func(page *elasticache.DescribeCacheSubnetGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ElastiCache) DescribeCacheSubnetGroupsPages(input *DescribeCacheSubnetGroupsInput, fn func(*DescribeCacheSubnetGroupsOutput, bool) bool) error {
	return c.DescribeCacheSubnetGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeCacheSubnetGroupsPagesWithContext same as DescribeCacheSubnetGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DescribeCacheSubnetGroupsPagesWithContext(ctx aws.Context, input *DescribeCacheSubnetGroupsInput, fn func(*DescribeCacheSubnetGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeCacheSubnetGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeCacheSubnetGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeCacheSubnetGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeEngineDefaultParameters = "DescribeEngineDefaultParameters"

// DescribeEngineDefaultParametersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEngineDefaultParameters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEngineDefaultParameters for more information on using the DescribeEngineDefaultParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEngineDefaultParametersRequest method.
//    req, resp := client.DescribeEngineDefaultParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeEngineDefaultParameters
func (c *ElastiCache) DescribeEngineDefaultParametersRequest(input *DescribeEngineDefaultParametersInput) (req *request.Request, output *DescribeEngineDefaultParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeEngineDefaultParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"EngineDefaults.Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEngineDefaultParametersInput{}
	}

	output = &DescribeEngineDefaultParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEngineDefaultParameters API operation for Amazon ElastiCache.
//
// Returns the default engine and system parameter information for the specified
// cache engine.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation DescribeEngineDefaultParameters for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeEngineDefaultParameters
func (c *ElastiCache) DescribeEngineDefaultParameters(input *DescribeEngineDefaultParametersInput) (*DescribeEngineDefaultParametersOutput, error) {
	req, out := c.DescribeEngineDefaultParametersRequest(input)
	return out, req.Send()
}

// DescribeEngineDefaultParametersWithContext is the same as DescribeEngineDefaultParameters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEngineDefaultParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DescribeEngineDefaultParametersWithContext(ctx aws.Context, input *DescribeEngineDefaultParametersInput, opts ...request.Option) (*DescribeEngineDefaultParametersOutput, error) {
	req, out := c.DescribeEngineDefaultParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEngineDefaultParametersPages iterates over the pages of a DescribeEngineDefaultParameters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEngineDefaultParameters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEngineDefaultParameters operation.
//    pageNum := 0
//    err := client.DescribeEngineDefaultParametersPages(params,
//        func(page *elasticache.DescribeEngineDefaultParametersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ElastiCache) DescribeEngineDefaultParametersPages(input *DescribeEngineDefaultParametersInput, fn func(*DescribeEngineDefaultParametersOutput, bool) bool) error {
	return c.DescribeEngineDefaultParametersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEngineDefaultParametersPagesWithContext same as DescribeEngineDefaultParametersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DescribeEngineDefaultParametersPagesWithContext(ctx aws.Context, input *DescribeEngineDefaultParametersInput, fn func(*DescribeEngineDefaultParametersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEngineDefaultParametersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEngineDefaultParametersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeEngineDefaultParametersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeEvents = "DescribeEvents"

// DescribeEventsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEvents for more information on using the DescribeEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventsRequest method.
//    req, resp := client.DescribeEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeEvents
func (c *ElastiCache) DescribeEventsRequest(input *DescribeEventsInput) (req *request.Request, output *DescribeEventsOutput) {
	op := &request.Operation{
		Name:       opDescribeEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEventsInput{}
	}

	output = &DescribeEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEvents API operation for Amazon ElastiCache.
//
// Returns events related to clusters, cache security groups, and cache parameter
// groups. You can obtain events specific to a particular cluster, cache security
// group, or cache parameter group by providing the name as a parameter.
//
// By default, only the events occurring within the last hour are returned;
// however, you can retrieve up to 14 days' worth of events if necessary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation DescribeEvents for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeEvents
func (c *ElastiCache) DescribeEvents(input *DescribeEventsInput) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	return out, req.Send()
}

// DescribeEventsWithContext is the same as DescribeEvents with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DescribeEventsWithContext(ctx aws.Context, input *DescribeEventsInput, opts ...request.Option) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEventsPages iterates over the pages of a DescribeEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEvents operation.
//    pageNum := 0
//    err := client.DescribeEventsPages(params,
//        func(page *elasticache.DescribeEventsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ElastiCache) DescribeEventsPages(input *DescribeEventsInput, fn func(*DescribeEventsOutput, bool) bool) error {
	return c.DescribeEventsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEventsPagesWithContext same as DescribeEventsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DescribeEventsPagesWithContext(ctx aws.Context, input *DescribeEventsInput, fn func(*DescribeEventsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEventsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEventsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeEventsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeGlobalReplicationGroups = "DescribeGlobalReplicationGroups"

// DescribeGlobalReplicationGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGlobalReplicationGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGlobalReplicationGroups for more information on using the DescribeGlobalReplicationGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeGlobalReplicationGroupsRequest method.
//    req, resp := client.DescribeGlobalReplicationGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeGlobalReplicationGroups
func (c *ElastiCache) DescribeGlobalReplicationGroupsRequest(input *DescribeGlobalReplicationGroupsInput) (req *request.Request, output *DescribeGlobalReplicationGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeGlobalReplicationGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeGlobalReplicationGroupsInput{}
	}

	output = &DescribeGlobalReplicationGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGlobalReplicationGroups API operation for Amazon ElastiCache.
//
// Returns information about a particular global replication group. If no identifier
// is specified, returns information about all Global Datastores.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation DescribeGlobalReplicationGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeGlobalReplicationGroupNotFoundFault "GlobalReplicationGroupNotFoundFault"
//   The Global Datastore does not exist
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeGlobalReplicationGroups
func (c *ElastiCache) DescribeGlobalReplicationGroups(input *DescribeGlobalReplicationGroupsInput) (*DescribeGlobalReplicationGroupsOutput, error) {
	req, out := c.DescribeGlobalReplicationGroupsRequest(input)
	return out, req.Send()
}

// DescribeGlobalReplicationGroupsWithContext is the same as DescribeGlobalReplicationGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGlobalReplicationGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DescribeGlobalReplicationGroupsWithContext(ctx aws.Context, input *DescribeGlobalReplicationGroupsInput, opts ...request.Option) (*DescribeGlobalReplicationGroupsOutput, error) {
	req, out := c.DescribeGlobalReplicationGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeGlobalReplicationGroupsPages iterates over the pages of a DescribeGlobalReplicationGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeGlobalReplicationGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeGlobalReplicationGroups operation.
//    pageNum := 0
//    err := client.DescribeGlobalReplicationGroupsPages(params,
//        func(page *elasticache.DescribeGlobalReplicationGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ElastiCache) DescribeGlobalReplicationGroupsPages(input *DescribeGlobalReplicationGroupsInput, fn func(*DescribeGlobalReplicationGroupsOutput, bool) bool) error {
	return c.DescribeGlobalReplicationGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeGlobalReplicationGroupsPagesWithContext same as DescribeGlobalReplicationGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DescribeGlobalReplicationGroupsPagesWithContext(ctx aws.Context, input *DescribeGlobalReplicationGroupsInput, fn func(*DescribeGlobalReplicationGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeGlobalReplicationGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeGlobalReplicationGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeGlobalReplicationGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeReplicationGroups = "DescribeReplicationGroups"

// DescribeReplicationGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReplicationGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReplicationGroups for more information on using the DescribeReplicationGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReplicationGroupsRequest method.
//    req, resp := client.DescribeReplicationGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReplicationGroups
func (c *ElastiCache) DescribeReplicationGroupsRequest(input *DescribeReplicationGroupsInput) (req *request.Request, output *DescribeReplicationGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeReplicationGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReplicationGroupsInput{}
	}

	output = &DescribeReplicationGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReplicationGroups API operation for Amazon ElastiCache.
//
// Returns information about a particular replication group. If no identifier
// is specified, DescribeReplicationGroups returns information about all replication
// groups.
//
// This operation is valid for Redis only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation DescribeReplicationGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeReplicationGroupNotFoundFault "ReplicationGroupNotFoundFault"
//   The specified replication group does not exist.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReplicationGroups
func (c *ElastiCache) DescribeReplicationGroups(input *DescribeReplicationGroupsInput) (*DescribeReplicationGroupsOutput, error) {
	req, out := c.DescribeReplicationGroupsRequest(input)
	return out, req.Send()
}

// DescribeReplicationGroupsWithContext is the same as DescribeReplicationGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReplicationGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DescribeReplicationGroupsWithContext(ctx aws.Context, input *DescribeReplicationGroupsInput, opts ...request.Option) (*DescribeReplicationGroupsOutput, error) {
	req, out := c.DescribeReplicationGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReplicationGroupsPages iterates over the pages of a DescribeReplicationGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReplicationGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReplicationGroups operation.
//    pageNum := 0
//    err := client.DescribeReplicationGroupsPages(params,
//        func(page *elasticache.DescribeReplicationGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ElastiCache) DescribeReplicationGroupsPages(input *DescribeReplicationGroupsInput, fn func(*DescribeReplicationGroupsOutput, bool) bool) error {
	return c.DescribeReplicationGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReplicationGroupsPagesWithContext same as DescribeReplicationGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DescribeReplicationGroupsPagesWithContext(ctx aws.Context, input *DescribeReplicationGroupsInput, fn func(*DescribeReplicationGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReplicationGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReplicationGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReplicationGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeReservedCacheNodes = "DescribeReservedCacheNodes"

// DescribeReservedCacheNodesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReservedCacheNodes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReservedCacheNodes for more information on using the DescribeReservedCacheNodes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReservedCacheNodesRequest method.
//    req, resp := client.DescribeReservedCacheNodesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReservedCacheNodes
func (c *ElastiCache) DescribeReservedCacheNodesRequest(input *DescribeReservedCacheNodesInput) (req *request.Request, output *DescribeReservedCacheNodesOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedCacheNodes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedCacheNodesInput{}
	}

	output = &DescribeReservedCacheNodesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReservedCacheNodes API operation for Amazon ElastiCache.
//
// Returns information about reserved cache nodes for this account, or about
// a specified reserved cache node.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation DescribeReservedCacheNodes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeReservedCacheNodeNotFoundFault "ReservedCacheNodeNotFound"
//   The requested reserved cache node was not found.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReservedCacheNodes
func (c *ElastiCache) DescribeReservedCacheNodes(input *DescribeReservedCacheNodesInput) (*DescribeReservedCacheNodesOutput, error) {
	req, out := c.DescribeReservedCacheNodesRequest(input)
	return out, req.Send()
}

// DescribeReservedCacheNodesWithContext is the same as DescribeReservedCacheNodes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReservedCacheNodes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DescribeReservedCacheNodesWithContext(ctx aws.Context, input *DescribeReservedCacheNodesInput, opts ...request.Option) (*DescribeReservedCacheNodesOutput, error) {
	req, out := c.DescribeReservedCacheNodesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReservedCacheNodesPages iterates over the pages of a DescribeReservedCacheNodes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReservedCacheNodes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReservedCacheNodes operation.
//    pageNum := 0
//    err := client.DescribeReservedCacheNodesPages(params,
//        func(page *elasticache.DescribeReservedCacheNodesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ElastiCache) DescribeReservedCacheNodesPages(input *DescribeReservedCacheNodesInput, fn func(*DescribeReservedCacheNodesOutput, bool) bool) error {
	return c.DescribeReservedCacheNodesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReservedCacheNodesPagesWithContext same as DescribeReservedCacheNodesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DescribeReservedCacheNodesPagesWithContext(ctx aws.Context, input *DescribeReservedCacheNodesInput, fn func(*DescribeReservedCacheNodesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReservedCacheNodesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReservedCacheNodesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReservedCacheNodesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeReservedCacheNodesOfferings = "DescribeReservedCacheNodesOfferings"

// DescribeReservedCacheNodesOfferingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReservedCacheNodesOfferings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReservedCacheNodesOfferings for more information on using the DescribeReservedCacheNodesOfferings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReservedCacheNodesOfferingsRequest method.
//    req, resp := client.DescribeReservedCacheNodesOfferingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReservedCacheNodesOfferings
func (c *ElastiCache) DescribeReservedCacheNodesOfferingsRequest(input *DescribeReservedCacheNodesOfferingsInput) (req *request.Request, output *DescribeReservedCacheNodesOfferingsOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedCacheNodesOfferings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedCacheNodesOfferingsInput{}
	}

	output = &DescribeReservedCacheNodesOfferingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReservedCacheNodesOfferings API operation for Amazon ElastiCache.
//
// Lists available reserved cache node offerings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation DescribeReservedCacheNodesOfferings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeReservedCacheNodesOfferingNotFoundFault "ReservedCacheNodesOfferingNotFound"
//   The requested cache node offering does not exist.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReservedCacheNodesOfferings
func (c *ElastiCache) DescribeReservedCacheNodesOfferings(input *DescribeReservedCacheNodesOfferingsInput) (*DescribeReservedCacheNodesOfferingsOutput, error) {
	req, out := c.DescribeReservedCacheNodesOfferingsRequest(input)
	return out, req.Send()
}

// DescribeReservedCacheNodesOfferingsWithContext is the same as DescribeReservedCacheNodesOfferings with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReservedCacheNodesOfferings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DescribeReservedCacheNodesOfferingsWithContext(ctx aws.Context, input *DescribeReservedCacheNodesOfferingsInput, opts ...request.Option) (*DescribeReservedCacheNodesOfferingsOutput, error) {
	req, out := c.DescribeReservedCacheNodesOfferingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReservedCacheNodesOfferingsPages iterates over the pages of a DescribeReservedCacheNodesOfferings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReservedCacheNodesOfferings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReservedCacheNodesOfferings operation.
//    pageNum := 0
//    err := client.DescribeReservedCacheNodesOfferingsPages(params,
//        func(page *elasticache.DescribeReservedCacheNodesOfferingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ElastiCache) DescribeReservedCacheNodesOfferingsPages(input *DescribeReservedCacheNodesOfferingsInput, fn func(*DescribeReservedCacheNodesOfferingsOutput, bool) bool) error {
	return c.DescribeReservedCacheNodesOfferingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReservedCacheNodesOfferingsPagesWithContext same as DescribeReservedCacheNodesOfferingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DescribeReservedCacheNodesOfferingsPagesWithContext(ctx aws.Context, input *DescribeReservedCacheNodesOfferingsInput, fn func(*DescribeReservedCacheNodesOfferingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReservedCacheNodesOfferingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReservedCacheNodesOfferingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReservedCacheNodesOfferingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeServiceUpdates = "DescribeServiceUpdates"

// DescribeServiceUpdatesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeServiceUpdates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeServiceUpdates for more information on using the DescribeServiceUpdates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeServiceUpdatesRequest method.
//    req, resp := client.DescribeServiceUpdatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeServiceUpdates
func (c *ElastiCache) DescribeServiceUpdatesRequest(input *DescribeServiceUpdatesInput) (req *request.Request, output *DescribeServiceUpdatesOutput) {
	op := &request.Operation{
		Name:       opDescribeServiceUpdates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeServiceUpdatesInput{}
	}

	output = &DescribeServiceUpdatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeServiceUpdates API operation for Amazon ElastiCache.
//
// Returns details of the service updates
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation DescribeServiceUpdates for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceUpdateNotFoundFault "ServiceUpdateNotFoundFault"
//   The service update doesn't exist
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeServiceUpdates
func (c *ElastiCache) DescribeServiceUpdates(input *DescribeServiceUpdatesInput) (*DescribeServiceUpdatesOutput, error) {
	req, out := c.DescribeServiceUpdatesRequest(input)
	return out, req.Send()
}

// DescribeServiceUpdatesWithContext is the same as DescribeServiceUpdates with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeServiceUpdates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DescribeServiceUpdatesWithContext(ctx aws.Context, input *DescribeServiceUpdatesInput, opts ...request.Option) (*DescribeServiceUpdatesOutput, error) {
	req, out := c.DescribeServiceUpdatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeServiceUpdatesPages iterates over the pages of a DescribeServiceUpdates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeServiceUpdates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeServiceUpdates operation.
//    pageNum := 0
//    err := client.DescribeServiceUpdatesPages(params,
//        func(page *elasticache.DescribeServiceUpdatesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ElastiCache) DescribeServiceUpdatesPages(input *DescribeServiceUpdatesInput, fn func(*DescribeServiceUpdatesOutput, bool) bool) error {
	return c.DescribeServiceUpdatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeServiceUpdatesPagesWithContext same as DescribeServiceUpdatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DescribeServiceUpdatesPagesWithContext(ctx aws.Context, input *DescribeServiceUpdatesInput, fn func(*DescribeServiceUpdatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeServiceUpdatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeServiceUpdatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeServiceUpdatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeSnapshots = "DescribeSnapshots"

// DescribeSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSnapshots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSnapshots for more information on using the DescribeSnapshots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSnapshotsRequest method.
//    req, resp := client.DescribeSnapshotsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeSnapshots
func (c *ElastiCache) DescribeSnapshotsRequest(input *DescribeSnapshotsInput) (req *request.Request, output *DescribeSnapshotsOutput) {
	op := &request.Operation{
		Name:       opDescribeSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeSnapshotsInput{}
	}

	output = &DescribeSnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSnapshots API operation for Amazon ElastiCache.
//
// Returns information about cluster or replication group snapshots. By default,
// DescribeSnapshots lists all of your snapshots; it can optionally describe
// a single snapshot, or just the snapshots associated with a particular cache
// cluster.
//
// This operation is valid for Redis only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation DescribeSnapshots for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCacheClusterNotFoundFault "CacheClusterNotFound"
//   The requested cluster ID does not refer to an existing cluster.
//
//   * ErrCodeSnapshotNotFoundFault "SnapshotNotFoundFault"
//   The requested snapshot name does not refer to an existing snapshot.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeSnapshots
func (c *ElastiCache) DescribeSnapshots(input *DescribeSnapshotsInput) (*DescribeSnapshotsOutput, error) {
	req, out := c.DescribeSnapshotsRequest(input)
	return out, req.Send()
}

// DescribeSnapshotsWithContext is the same as DescribeSnapshots with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSnapshots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DescribeSnapshotsWithContext(ctx aws.Context, input *DescribeSnapshotsInput, opts ...request.Option) (*DescribeSnapshotsOutput, error) {
	req, out := c.DescribeSnapshotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeSnapshotsPages iterates over the pages of a DescribeSnapshots operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeSnapshots method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeSnapshots operation.
//    pageNum := 0
//    err := client.DescribeSnapshotsPages(params,
//        func(page *elasticache.DescribeSnapshotsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ElastiCache) DescribeSnapshotsPages(input *DescribeSnapshotsInput, fn func(*DescribeSnapshotsOutput, bool) bool) error {
	return c.DescribeSnapshotsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeSnapshotsPagesWithContext same as DescribeSnapshotsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DescribeSnapshotsPagesWithContext(ctx aws.Context, input *DescribeSnapshotsInput, fn func(*DescribeSnapshotsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeSnapshotsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeSnapshotsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeSnapshotsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeUpdateActions = "DescribeUpdateActions"

// DescribeUpdateActionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUpdateActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUpdateActions for more information on using the DescribeUpdateActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUpdateActionsRequest method.
//    req, resp := client.DescribeUpdateActionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeUpdateActions
func (c *ElastiCache) DescribeUpdateActionsRequest(input *DescribeUpdateActionsInput) (req *request.Request, output *DescribeUpdateActionsOutput) {
	op := &request.Operation{
		Name:       opDescribeUpdateActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeUpdateActionsInput{}
	}

	output = &DescribeUpdateActionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUpdateActions API operation for Amazon ElastiCache.
//
// Returns details of the update actions
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation DescribeUpdateActions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeUpdateActions
func (c *ElastiCache) DescribeUpdateActions(input *DescribeUpdateActionsInput) (*DescribeUpdateActionsOutput, error) {
	req, out := c.DescribeUpdateActionsRequest(input)
	return out, req.Send()
}

// DescribeUpdateActionsWithContext is the same as DescribeUpdateActions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUpdateActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DescribeUpdateActionsWithContext(ctx aws.Context, input *DescribeUpdateActionsInput, opts ...request.Option) (*DescribeUpdateActionsOutput, error) {
	req, out := c.DescribeUpdateActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeUpdateActionsPages iterates over the pages of a DescribeUpdateActions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeUpdateActions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeUpdateActions operation.
//    pageNum := 0
//    err := client.DescribeUpdateActionsPages(params,
//        func(page *elasticache.DescribeUpdateActionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ElastiCache) DescribeUpdateActionsPages(input *DescribeUpdateActionsInput, fn func(*DescribeUpdateActionsOutput, bool) bool) error {
	return c.DescribeUpdateActionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeUpdateActionsPagesWithContext same as DescribeUpdateActionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DescribeUpdateActionsPagesWithContext(ctx aws.Context, input *DescribeUpdateActionsInput, fn func(*DescribeUpdateActionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeUpdateActionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeUpdateActionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeUpdateActionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDisassociateGlobalReplicationGroup = "DisassociateGlobalReplicationGroup"

// DisassociateGlobalReplicationGroupRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateGlobalReplicationGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateGlobalReplicationGroup for more information on using the DisassociateGlobalReplicationGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateGlobalReplicationGroupRequest method.
//    req, resp := client.DisassociateGlobalReplicationGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DisassociateGlobalReplicationGroup
func (c *ElastiCache) DisassociateGlobalReplicationGroupRequest(input *DisassociateGlobalReplicationGroupInput) (req *request.Request, output *DisassociateGlobalReplicationGroupOutput) {
	op := &request.Operation{
		Name:       opDisassociateGlobalReplicationGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateGlobalReplicationGroupInput{}
	}

	output = &DisassociateGlobalReplicationGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateGlobalReplicationGroup API operation for Amazon ElastiCache.
//
// Remove a secondary cluster from the Global Datastore using the Global Datastore
// name. The secondary cluster will no longer receive updates from the primary
// cluster, but will remain as a standalone cluster in that AWS region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation DisassociateGlobalReplicationGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeGlobalReplicationGroupNotFoundFault "GlobalReplicationGroupNotFoundFault"
//   The Global Datastore does not exist
//
//   * ErrCodeInvalidGlobalReplicationGroupStateFault "InvalidGlobalReplicationGroupState"
//   The Global Datastore is not available or in primary-only state.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DisassociateGlobalReplicationGroup
func (c *ElastiCache) DisassociateGlobalReplicationGroup(input *DisassociateGlobalReplicationGroupInput) (*DisassociateGlobalReplicationGroupOutput, error) {
	req, out := c.DisassociateGlobalReplicationGroupRequest(input)
	return out, req.Send()
}

// DisassociateGlobalReplicationGroupWithContext is the same as DisassociateGlobalReplicationGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateGlobalReplicationGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) DisassociateGlobalReplicationGroupWithContext(ctx aws.Context, input *DisassociateGlobalReplicationGroupInput, opts ...request.Option) (*DisassociateGlobalReplicationGroupOutput, error) {
	req, out := c.DisassociateGlobalReplicationGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opFailoverGlobalReplicationGroup = "FailoverGlobalReplicationGroup"

// FailoverGlobalReplicationGroupRequest generates a "aws/request.Request" representing the
// client's request for the FailoverGlobalReplicationGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See FailoverGlobalReplicationGroup for more information on using the FailoverGlobalReplicationGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the FailoverGlobalReplicationGroupRequest method.
//    req, resp := client.FailoverGlobalReplicationGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/FailoverGlobalReplicationGroup
func (c *ElastiCache) FailoverGlobalReplicationGroupRequest(input *FailoverGlobalReplicationGroupInput) (req *request.Request, output *FailoverGlobalReplicationGroupOutput) {
	op := &request.Operation{
		Name:       opFailoverGlobalReplicationGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &FailoverGlobalReplicationGroupInput{}
	}

	output = &FailoverGlobalReplicationGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// FailoverGlobalReplicationGroup API operation for Amazon ElastiCache.
//
// Used to failover the primary region to a selected secondary region. The selected
// secondary region will become primary, and all other clusters will become
// secondary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation FailoverGlobalReplicationGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeGlobalReplicationGroupNotFoundFault "GlobalReplicationGroupNotFoundFault"
//   The Global Datastore does not exist
//
//   * ErrCodeInvalidGlobalReplicationGroupStateFault "InvalidGlobalReplicationGroupState"
//   The Global Datastore is not available or in primary-only state.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/FailoverGlobalReplicationGroup
func (c *ElastiCache) FailoverGlobalReplicationGroup(input *FailoverGlobalReplicationGroupInput) (*FailoverGlobalReplicationGroupOutput, error) {
	req, out := c.FailoverGlobalReplicationGroupRequest(input)
	return out, req.Send()
}

// FailoverGlobalReplicationGroupWithContext is the same as FailoverGlobalReplicationGroup with the addition of
// the ability to pass a context and additional request options.
//
// See FailoverGlobalReplicationGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) FailoverGlobalReplicationGroupWithContext(ctx aws.Context, input *FailoverGlobalReplicationGroupInput, opts ...request.Option) (*FailoverGlobalReplicationGroupOutput, error) {
	req, out := c.FailoverGlobalReplicationGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opIncreaseNodeGroupsInGlobalReplicationGroup = "IncreaseNodeGroupsInGlobalReplicationGroup"

// IncreaseNodeGroupsInGlobalReplicationGroupRequest generates a "aws/request.Request" representing the
// client's request for the IncreaseNodeGroupsInGlobalReplicationGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See IncreaseNodeGroupsInGlobalReplicationGroup for more information on using the IncreaseNodeGroupsInGlobalReplicationGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the IncreaseNodeGroupsInGlobalReplicationGroupRequest method.
//    req, resp := client.IncreaseNodeGroupsInGlobalReplicationGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/IncreaseNodeGroupsInGlobalReplicationGroup
func (c *ElastiCache) IncreaseNodeGroupsInGlobalReplicationGroupRequest(input *IncreaseNodeGroupsInGlobalReplicationGroupInput) (req *request.Request, output *IncreaseNodeGroupsInGlobalReplicationGroupOutput) {
	op := &request.Operation{
		Name:       opIncreaseNodeGroupsInGlobalReplicationGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &IncreaseNodeGroupsInGlobalReplicationGroupInput{}
	}

	output = &IncreaseNodeGroupsInGlobalReplicationGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// IncreaseNodeGroupsInGlobalReplicationGroup API operation for Amazon ElastiCache.
//
// Increase the number of node groups in the Global Datastore
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation IncreaseNodeGroupsInGlobalReplicationGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeGlobalReplicationGroupNotFoundFault "GlobalReplicationGroupNotFoundFault"
//   The Global Datastore does not exist
//
//   * ErrCodeInvalidGlobalReplicationGroupStateFault "InvalidGlobalReplicationGroupState"
//   The Global Datastore is not available or in primary-only state.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/IncreaseNodeGroupsInGlobalReplicationGroup
func (c *ElastiCache) IncreaseNodeGroupsInGlobalReplicationGroup(input *IncreaseNodeGroupsInGlobalReplicationGroupInput) (*IncreaseNodeGroupsInGlobalReplicationGroupOutput, error) {
	req, out := c.IncreaseNodeGroupsInGlobalReplicationGroupRequest(input)
	return out, req.Send()
}

// IncreaseNodeGroupsInGlobalReplicationGroupWithContext is the same as IncreaseNodeGroupsInGlobalReplicationGroup with the addition of
// the ability to pass a context and additional request options.
//
// See IncreaseNodeGroupsInGlobalReplicationGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) IncreaseNodeGroupsInGlobalReplicationGroupWithContext(ctx aws.Context, input *IncreaseNodeGroupsInGlobalReplicationGroupInput, opts ...request.Option) (*IncreaseNodeGroupsInGlobalReplicationGroupOutput, error) {
	req, out := c.IncreaseNodeGroupsInGlobalReplicationGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opIncreaseReplicaCount = "IncreaseReplicaCount"

// IncreaseReplicaCountRequest generates a "aws/request.Request" representing the
// client's request for the IncreaseReplicaCount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See IncreaseReplicaCount for more information on using the IncreaseReplicaCount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the IncreaseReplicaCountRequest method.
//    req, resp := client.IncreaseReplicaCountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/IncreaseReplicaCount
func (c *ElastiCache) IncreaseReplicaCountRequest(input *IncreaseReplicaCountInput) (req *request.Request, output *IncreaseReplicaCountOutput) {
	op := &request.Operation{
		Name:       opIncreaseReplicaCount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &IncreaseReplicaCountInput{}
	}

	output = &IncreaseReplicaCountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// IncreaseReplicaCount API operation for Amazon ElastiCache.
//
// Dynamically increases the number of replics in a Redis (cluster mode disabled)
// replication group or the number of replica nodes in one or more node groups
// (shards) of a Redis (cluster mode enabled) replication group. This operation
// is performed with no cluster down time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation IncreaseReplicaCount for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeReplicationGroupNotFoundFault "ReplicationGroupNotFoundFault"
//   The specified replication group does not exist.
//
//   * ErrCodeInvalidReplicationGroupStateFault "InvalidReplicationGroupState"
//   The requested replication group is not in the available state.
//
//   * ErrCodeInvalidCacheClusterStateFault "InvalidCacheClusterState"
//   The requested cluster is not in the available state.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   The VPC network is in an invalid state.
//
//   * ErrCodeInsufficientCacheClusterCapacityFault "InsufficientCacheClusterCapacity"
//   The requested cache node type is not available in the specified Availability
//   Zone. For more information, see InsufficientCacheClusterCapacity (http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY)
//   in the ElastiCache User Guide.
//
//   * ErrCodeClusterQuotaForCustomerExceededFault "ClusterQuotaForCustomerExceeded"
//   The request cannot be processed because it would exceed the allowed number
//   of clusters per customer.
//
//   * ErrCodeNodeGroupsPerReplicationGroupQuotaExceededFault "NodeGroupsPerReplicationGroupQuotaExceeded"
//   The request cannot be processed because it would exceed the maximum allowed
//   number of node groups (shards) in a single replication group. The default
//   maximum is 90
//
//   * ErrCodeNodeQuotaForCustomerExceededFault "NodeQuotaForCustomerExceeded"
//   The request cannot be processed because it would exceed the allowed number
//   of cache nodes per customer.
//
//   * ErrCodeNoOperationFault "NoOperationFault"
//   The operation was not performed because no changes were required.
//
//   * ErrCodeInvalidKMSKeyFault "InvalidKMSKeyFault"
//   The KMS key supplied is not valid.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/IncreaseReplicaCount
func (c *ElastiCache) IncreaseReplicaCount(input *IncreaseReplicaCountInput) (*IncreaseReplicaCountOutput, error) {
	req, out := c.IncreaseReplicaCountRequest(input)
	return out, req.Send()
}

// IncreaseReplicaCountWithContext is the same as IncreaseReplicaCount with the addition of
// the ability to pass a context and additional request options.
//
// See IncreaseReplicaCount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) IncreaseReplicaCountWithContext(ctx aws.Context, input *IncreaseReplicaCountInput, opts ...request.Option) (*IncreaseReplicaCountOutput, error) {
	req, out := c.IncreaseReplicaCountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAllowedNodeTypeModifications = "ListAllowedNodeTypeModifications"

// ListAllowedNodeTypeModificationsRequest generates a "aws/request.Request" representing the
// client's request for the ListAllowedNodeTypeModifications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAllowedNodeTypeModifications for more information on using the ListAllowedNodeTypeModifications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAllowedNodeTypeModificationsRequest method.
//    req, resp := client.ListAllowedNodeTypeModificationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ListAllowedNodeTypeModifications
func (c *ElastiCache) ListAllowedNodeTypeModificationsRequest(input *ListAllowedNodeTypeModificationsInput) (req *request.Request, output *ListAllowedNodeTypeModificationsOutput) {
	op := &request.Operation{
		Name:       opListAllowedNodeTypeModifications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAllowedNodeTypeModificationsInput{}
	}

	output = &ListAllowedNodeTypeModificationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAllowedNodeTypeModifications API operation for Amazon ElastiCache.
//
// Lists all available node types that you can scale your Redis cluster's or
// replication group's current node type.
//
// When you use the ModifyCacheCluster or ModifyReplicationGroup operations
// to scale your cluster or replication group, the value of the CacheNodeType
// parameter must be one of the node types returned by this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation ListAllowedNodeTypeModifications for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCacheClusterNotFoundFault "CacheClusterNotFound"
//   The requested cluster ID does not refer to an existing cluster.
//
//   * ErrCodeReplicationGroupNotFoundFault "ReplicationGroupNotFoundFault"
//   The specified replication group does not exist.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ListAllowedNodeTypeModifications
func (c *ElastiCache) ListAllowedNodeTypeModifications(input *ListAllowedNodeTypeModificationsInput) (*ListAllowedNodeTypeModificationsOutput, error) {
	req, out := c.ListAllowedNodeTypeModificationsRequest(input)
	return out, req.Send()
}

// ListAllowedNodeTypeModificationsWithContext is the same as ListAllowedNodeTypeModifications with the addition of
// the ability to pass a context and additional request options.
//
// See ListAllowedNodeTypeModifications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) ListAllowedNodeTypeModificationsWithContext(ctx aws.Context, input *ListAllowedNodeTypeModificationsInput, opts ...request.Option) (*ListAllowedNodeTypeModificationsOutput, error) {
	req, out := c.ListAllowedNodeTypeModificationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ListTagsForResource
func (c *ElastiCache) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *TagListMessage) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &TagListMessage{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon ElastiCache.
//
// Lists all cost allocation tags currently on the named resource. A cost allocation
// tag is a key-value pair where the key is case-sensitive and the value is
// optional. You can use cost allocation tags to categorize and track your AWS
// costs.
//
// If the cluster is not in the available state, ListTagsForResource returns
// an error.
//
// You can have a maximum of 50 cost allocation tags on an ElastiCache resource.
// For more information, see Monitoring Costs with Tags (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Tagging.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCacheClusterNotFoundFault "CacheClusterNotFound"
//   The requested cluster ID does not refer to an existing cluster.
//
//   * ErrCodeSnapshotNotFoundFault "SnapshotNotFoundFault"
//   The requested snapshot name does not refer to an existing snapshot.
//
//   * ErrCodeInvalidARNFault "InvalidARN"
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ListTagsForResource
func (c *ElastiCache) ListTagsForResource(input *ListTagsForResourceInput) (*TagListMessage, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*TagListMessage, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyCacheCluster = "ModifyCacheCluster"

// ModifyCacheClusterRequest generates a "aws/request.Request" representing the
// client's request for the ModifyCacheCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyCacheCluster for more information on using the ModifyCacheCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyCacheClusterRequest method.
//    req, resp := client.ModifyCacheClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyCacheCluster
func (c *ElastiCache) ModifyCacheClusterRequest(input *ModifyCacheClusterInput) (req *request.Request, output *ModifyCacheClusterOutput) {
	op := &request.Operation{
		Name:       opModifyCacheCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyCacheClusterInput{}
	}

	output = &ModifyCacheClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyCacheCluster API operation for Amazon ElastiCache.
//
// Modifies the settings for a cluster. You can use this operation to change
// one or more cluster configuration parameters by specifying the parameters
// and the new values.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation ModifyCacheCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidCacheClusterStateFault "InvalidCacheClusterState"
//   The requested cluster is not in the available state.
//
//   * ErrCodeInvalidCacheSecurityGroupStateFault "InvalidCacheSecurityGroupState"
//   The current state of the cache security group does not allow deletion.
//
//   * ErrCodeInsufficientCacheClusterCapacityFault "InsufficientCacheClusterCapacity"
//   The requested cache node type is not available in the specified Availability
//   Zone. For more information, see InsufficientCacheClusterCapacity (http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY)
//   in the ElastiCache User Guide.
//
//   * ErrCodeCacheClusterNotFoundFault "CacheClusterNotFound"
//   The requested cluster ID does not refer to an existing cluster.
//
//   * ErrCodeNodeQuotaForClusterExceededFault "NodeQuotaForClusterExceeded"
//   The request cannot be processed because it would exceed the allowed number
//   of cache nodes in a single cluster.
//
//   * ErrCodeNodeQuotaForCustomerExceededFault "NodeQuotaForCustomerExceeded"
//   The request cannot be processed because it would exceed the allowed number
//   of cache nodes per customer.
//
//   * ErrCodeCacheSecurityGroupNotFoundFault "CacheSecurityGroupNotFound"
//   The requested cache security group name does not refer to an existing cache
//   security group.
//
//   * ErrCodeCacheParameterGroupNotFoundFault "CacheParameterGroupNotFound"
//   The requested cache parameter group name does not refer to an existing cache
//   parameter group.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   The VPC network is in an invalid state.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyCacheCluster
func (c *ElastiCache) ModifyCacheCluster(input *ModifyCacheClusterInput) (*ModifyCacheClusterOutput, error) {
	req, out := c.ModifyCacheClusterRequest(input)
	return out, req.Send()
}

// ModifyCacheClusterWithContext is the same as ModifyCacheCluster with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyCacheCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) ModifyCacheClusterWithContext(ctx aws.Context, input *ModifyCacheClusterInput, opts ...request.Option) (*ModifyCacheClusterOutput, error) {
	req, out := c.ModifyCacheClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyCacheParameterGroup = "ModifyCacheParameterGroup"

// ModifyCacheParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the ModifyCacheParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyCacheParameterGroup for more information on using the ModifyCacheParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyCacheParameterGroupRequest method.
//    req, resp := client.ModifyCacheParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyCacheParameterGroup
func (c *ElastiCache) ModifyCacheParameterGroupRequest(input *ModifyCacheParameterGroupInput) (req *request.Request, output *CacheParameterGroupNameMessage) {
	op := &request.Operation{
		Name:       opModifyCacheParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyCacheParameterGroupInput{}
	}

	output = &CacheParameterGroupNameMessage{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyCacheParameterGroup API operation for Amazon ElastiCache.
//
// Modifies the parameters of a cache parameter group. You can modify up to
// 20 parameters in a single request by submitting a list parameter name and
// value pairs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation ModifyCacheParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCacheParameterGroupNotFoundFault "CacheParameterGroupNotFound"
//   The requested cache parameter group name does not refer to an existing cache
//   parameter group.
//
//   * ErrCodeInvalidCacheParameterGroupStateFault "InvalidCacheParameterGroupState"
//   The current state of the cache parameter group does not allow the requested
//   operation to occur.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
//   * ErrCodeInvalidGlobalReplicationGroupStateFault "InvalidGlobalReplicationGroupState"
//   The Global Datastore is not available or in primary-only state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyCacheParameterGroup
func (c *ElastiCache) ModifyCacheParameterGroup(input *ModifyCacheParameterGroupInput) (*CacheParameterGroupNameMessage, error) {
	req, out := c.ModifyCacheParameterGroupRequest(input)
	return out, req.Send()
}

// ModifyCacheParameterGroupWithContext is the same as ModifyCacheParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyCacheParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) ModifyCacheParameterGroupWithContext(ctx aws.Context, input *ModifyCacheParameterGroupInput, opts ...request.Option) (*CacheParameterGroupNameMessage, error) {
	req, out := c.ModifyCacheParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyCacheSubnetGroup = "ModifyCacheSubnetGroup"

// ModifyCacheSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the ModifyCacheSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyCacheSubnetGroup for more information on using the ModifyCacheSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyCacheSubnetGroupRequest method.
//    req, resp := client.ModifyCacheSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyCacheSubnetGroup
func (c *ElastiCache) ModifyCacheSubnetGroupRequest(input *ModifyCacheSubnetGroupInput) (req *request.Request, output *ModifyCacheSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opModifyCacheSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyCacheSubnetGroupInput{}
	}

	output = &ModifyCacheSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyCacheSubnetGroup API operation for Amazon ElastiCache.
//
// Modifies an existing cache subnet group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation ModifyCacheSubnetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCacheSubnetGroupNotFoundFault "CacheSubnetGroupNotFoundFault"
//   The requested cache subnet group name does not refer to an existing cache
//   subnet group.
//
//   * ErrCodeCacheSubnetQuotaExceededFault "CacheSubnetQuotaExceededFault"
//   The request cannot be processed because it would exceed the allowed number
//   of subnets in a cache subnet group.
//
//   * ErrCodeSubnetInUse "SubnetInUse"
//   The requested subnet is being used by another cache subnet group.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   An invalid subnet identifier was specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyCacheSubnetGroup
func (c *ElastiCache) ModifyCacheSubnetGroup(input *ModifyCacheSubnetGroupInput) (*ModifyCacheSubnetGroupOutput, error) {
	req, out := c.ModifyCacheSubnetGroupRequest(input)
	return out, req.Send()
}

// ModifyCacheSubnetGroupWithContext is the same as ModifyCacheSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyCacheSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) ModifyCacheSubnetGroupWithContext(ctx aws.Context, input *ModifyCacheSubnetGroupInput, opts ...request.Option) (*ModifyCacheSubnetGroupOutput, error) {
	req, out := c.ModifyCacheSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyGlobalReplicationGroup = "ModifyGlobalReplicationGroup"

// ModifyGlobalReplicationGroupRequest generates a "aws/request.Request" representing the
// client's request for the ModifyGlobalReplicationGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyGlobalReplicationGroup for more information on using the ModifyGlobalReplicationGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyGlobalReplicationGroupRequest method.
//    req, resp := client.ModifyGlobalReplicationGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyGlobalReplicationGroup
func (c *ElastiCache) ModifyGlobalReplicationGroupRequest(input *ModifyGlobalReplicationGroupInput) (req *request.Request, output *ModifyGlobalReplicationGroupOutput) {
	op := &request.Operation{
		Name:       opModifyGlobalReplicationGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyGlobalReplicationGroupInput{}
	}

	output = &ModifyGlobalReplicationGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyGlobalReplicationGroup API operation for Amazon ElastiCache.
//
// Modifies the settings for a Global Datastore.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation ModifyGlobalReplicationGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeGlobalReplicationGroupNotFoundFault "GlobalReplicationGroupNotFoundFault"
//   The Global Datastore does not exist
//
//   * ErrCodeInvalidGlobalReplicationGroupStateFault "InvalidGlobalReplicationGroupState"
//   The Global Datastore is not available or in primary-only state.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyGlobalReplicationGroup
func (c *ElastiCache) ModifyGlobalReplicationGroup(input *ModifyGlobalReplicationGroupInput) (*ModifyGlobalReplicationGroupOutput, error) {
	req, out := c.ModifyGlobalReplicationGroupRequest(input)
	return out, req.Send()
}

// ModifyGlobalReplicationGroupWithContext is the same as ModifyGlobalReplicationGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyGlobalReplicationGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) ModifyGlobalReplicationGroupWithContext(ctx aws.Context, input *ModifyGlobalReplicationGroupInput, opts ...request.Option) (*ModifyGlobalReplicationGroupOutput, error) {
	req, out := c.ModifyGlobalReplicationGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyReplicationGroup = "ModifyReplicationGroup"

// ModifyReplicationGroupRequest generates a "aws/request.Request" representing the
// client's request for the ModifyReplicationGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyReplicationGroup for more information on using the ModifyReplicationGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyReplicationGroupRequest method.
//    req, resp := client.ModifyReplicationGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyReplicationGroup
func (c *ElastiCache) ModifyReplicationGroupRequest(input *ModifyReplicationGroupInput) (req *request.Request, output *ModifyReplicationGroupOutput) {
	op := &request.Operation{
		Name:       opModifyReplicationGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyReplicationGroupInput{}
	}

	output = &ModifyReplicationGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyReplicationGroup API operation for Amazon ElastiCache.
//
// Modifies the settings for a replication group.
//
//    * Scaling for Amazon ElastiCache for Redis (cluster mode enabled) (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/scaling-redis-cluster-mode-enabled.html)
//    in the ElastiCache User Guide
//
//    * ModifyReplicationGroupShardConfiguration (https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyReplicationGroupShardConfiguration.html)
//    in the ElastiCache API Reference
//
// This operation is valid for Redis only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation ModifyReplicationGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeReplicationGroupNotFoundFault "ReplicationGroupNotFoundFault"
//   The specified replication group does not exist.
//
//   * ErrCodeInvalidReplicationGroupStateFault "InvalidReplicationGroupState"
//   The requested replication group is not in the available state.
//
//   * ErrCodeInvalidCacheClusterStateFault "InvalidCacheClusterState"
//   The requested cluster is not in the available state.
//
//   * ErrCodeInvalidCacheSecurityGroupStateFault "InvalidCacheSecurityGroupState"
//   The current state of the cache security group does not allow deletion.
//
//   * ErrCodeInsufficientCacheClusterCapacityFault "InsufficientCacheClusterCapacity"
//   The requested cache node type is not available in the specified Availability
//   Zone. For more information, see InsufficientCacheClusterCapacity (http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY)
//   in the ElastiCache User Guide.
//
//   * ErrCodeCacheClusterNotFoundFault "CacheClusterNotFound"
//   The requested cluster ID does not refer to an existing cluster.
//
//   * ErrCodeNodeQuotaForClusterExceededFault "NodeQuotaForClusterExceeded"
//   The request cannot be processed because it would exceed the allowed number
//   of cache nodes in a single cluster.
//
//   * ErrCodeNodeQuotaForCustomerExceededFault "NodeQuotaForCustomerExceeded"
//   The request cannot be processed because it would exceed the allowed number
//   of cache nodes per customer.
//
//   * ErrCodeCacheSecurityGroupNotFoundFault "CacheSecurityGroupNotFound"
//   The requested cache security group name does not refer to an existing cache
//   security group.
//
//   * ErrCodeCacheParameterGroupNotFoundFault "CacheParameterGroupNotFound"
//   The requested cache parameter group name does not refer to an existing cache
//   parameter group.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   The VPC network is in an invalid state.
//
//   * ErrCodeInvalidKMSKeyFault "InvalidKMSKeyFault"
//   The KMS key supplied is not valid.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyReplicationGroup
func (c *ElastiCache) ModifyReplicationGroup(input *ModifyReplicationGroupInput) (*ModifyReplicationGroupOutput, error) {
	req, out := c.ModifyReplicationGroupRequest(input)
	return out, req.Send()
}

// ModifyReplicationGroupWithContext is the same as ModifyReplicationGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyReplicationGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) ModifyReplicationGroupWithContext(ctx aws.Context, input *ModifyReplicationGroupInput, opts ...request.Option) (*ModifyReplicationGroupOutput, error) {
	req, out := c.ModifyReplicationGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyReplicationGroupShardConfiguration = "ModifyReplicationGroupShardConfiguration"

// ModifyReplicationGroupShardConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the ModifyReplicationGroupShardConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyReplicationGroupShardConfiguration for more information on using the ModifyReplicationGroupShardConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyReplicationGroupShardConfigurationRequest method.
//    req, resp := client.ModifyReplicationGroupShardConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyReplicationGroupShardConfiguration
func (c *ElastiCache) ModifyReplicationGroupShardConfigurationRequest(input *ModifyReplicationGroupShardConfigurationInput) (req *request.Request, output *ModifyReplicationGroupShardConfigurationOutput) {
	op := &request.Operation{
		Name:       opModifyReplicationGroupShardConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyReplicationGroupShardConfigurationInput{}
	}

	output = &ModifyReplicationGroupShardConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyReplicationGroupShardConfiguration API operation for Amazon ElastiCache.
//
// Modifies a replication group's shards (node groups) by allowing you to add
// shards, remove shards, or rebalance the keyspaces among exisiting shards.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation ModifyReplicationGroupShardConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeReplicationGroupNotFoundFault "ReplicationGroupNotFoundFault"
//   The specified replication group does not exist.
//
//   * ErrCodeInvalidReplicationGroupStateFault "InvalidReplicationGroupState"
//   The requested replication group is not in the available state.
//
//   * ErrCodeInvalidCacheClusterStateFault "InvalidCacheClusterState"
//   The requested cluster is not in the available state.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   The VPC network is in an invalid state.
//
//   * ErrCodeInsufficientCacheClusterCapacityFault "InsufficientCacheClusterCapacity"
//   The requested cache node type is not available in the specified Availability
//   Zone. For more information, see InsufficientCacheClusterCapacity (http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY)
//   in the ElastiCache User Guide.
//
//   * ErrCodeNodeGroupsPerReplicationGroupQuotaExceededFault "NodeGroupsPerReplicationGroupQuotaExceeded"
//   The request cannot be processed because it would exceed the maximum allowed
//   number of node groups (shards) in a single replication group. The default
//   maximum is 90
//
//   * ErrCodeNodeQuotaForCustomerExceededFault "NodeQuotaForCustomerExceeded"
//   The request cannot be processed because it would exceed the allowed number
//   of cache nodes per customer.
//
//   * ErrCodeInvalidKMSKeyFault "InvalidKMSKeyFault"
//   The KMS key supplied is not valid.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyReplicationGroupShardConfiguration
func (c *ElastiCache) ModifyReplicationGroupShardConfiguration(input *ModifyReplicationGroupShardConfigurationInput) (*ModifyReplicationGroupShardConfigurationOutput, error) {
	req, out := c.ModifyReplicationGroupShardConfigurationRequest(input)
	return out, req.Send()
}

// ModifyReplicationGroupShardConfigurationWithContext is the same as ModifyReplicationGroupShardConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyReplicationGroupShardConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) ModifyReplicationGroupShardConfigurationWithContext(ctx aws.Context, input *ModifyReplicationGroupShardConfigurationInput, opts ...request.Option) (*ModifyReplicationGroupShardConfigurationOutput, error) {
	req, out := c.ModifyReplicationGroupShardConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPurchaseReservedCacheNodesOffering = "PurchaseReservedCacheNodesOffering"

// PurchaseReservedCacheNodesOfferingRequest generates a "aws/request.Request" representing the
// client's request for the PurchaseReservedCacheNodesOffering operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PurchaseReservedCacheNodesOffering for more information on using the PurchaseReservedCacheNodesOffering
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PurchaseReservedCacheNodesOfferingRequest method.
//    req, resp := client.PurchaseReservedCacheNodesOfferingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/PurchaseReservedCacheNodesOffering
func (c *ElastiCache) PurchaseReservedCacheNodesOfferingRequest(input *PurchaseReservedCacheNodesOfferingInput) (req *request.Request, output *PurchaseReservedCacheNodesOfferingOutput) {
	op := &request.Operation{
		Name:       opPurchaseReservedCacheNodesOffering,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PurchaseReservedCacheNodesOfferingInput{}
	}

	output = &PurchaseReservedCacheNodesOfferingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PurchaseReservedCacheNodesOffering API operation for Amazon ElastiCache.
//
// Allows you to purchase a reserved cache node offering.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation PurchaseReservedCacheNodesOffering for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeReservedCacheNodesOfferingNotFoundFault "ReservedCacheNodesOfferingNotFound"
//   The requested cache node offering does not exist.
//
//   * ErrCodeReservedCacheNodeAlreadyExistsFault "ReservedCacheNodeAlreadyExists"
//   You already have a reservation with the given identifier.
//
//   * ErrCodeReservedCacheNodeQuotaExceededFault "ReservedCacheNodeQuotaExceeded"
//   The request cannot be processed because it would exceed the user's cache
//   node quota.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/PurchaseReservedCacheNodesOffering
func (c *ElastiCache) PurchaseReservedCacheNodesOffering(input *PurchaseReservedCacheNodesOfferingInput) (*PurchaseReservedCacheNodesOfferingOutput, error) {
	req, out := c.PurchaseReservedCacheNodesOfferingRequest(input)
	return out, req.Send()
}

// PurchaseReservedCacheNodesOfferingWithContext is the same as PurchaseReservedCacheNodesOffering with the addition of
// the ability to pass a context and additional request options.
//
// See PurchaseReservedCacheNodesOffering for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) PurchaseReservedCacheNodesOfferingWithContext(ctx aws.Context, input *PurchaseReservedCacheNodesOfferingInput, opts ...request.Option) (*PurchaseReservedCacheNodesOfferingOutput, error) {
	req, out := c.PurchaseReservedCacheNodesOfferingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRebalanceSlotsInGlobalReplicationGroup = "RebalanceSlotsInGlobalReplicationGroup"

// RebalanceSlotsInGlobalReplicationGroupRequest generates a "aws/request.Request" representing the
// client's request for the RebalanceSlotsInGlobalReplicationGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RebalanceSlotsInGlobalReplicationGroup for more information on using the RebalanceSlotsInGlobalReplicationGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RebalanceSlotsInGlobalReplicationGroupRequest method.
//    req, resp := client.RebalanceSlotsInGlobalReplicationGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/RebalanceSlotsInGlobalReplicationGroup
func (c *ElastiCache) RebalanceSlotsInGlobalReplicationGroupRequest(input *RebalanceSlotsInGlobalReplicationGroupInput) (req *request.Request, output *RebalanceSlotsInGlobalReplicationGroupOutput) {
	op := &request.Operation{
		Name:       opRebalanceSlotsInGlobalReplicationGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebalanceSlotsInGlobalReplicationGroupInput{}
	}

	output = &RebalanceSlotsInGlobalReplicationGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RebalanceSlotsInGlobalReplicationGroup API operation for Amazon ElastiCache.
//
// Redistribute slots to ensure uniform distribution across existing shards
// in the cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation RebalanceSlotsInGlobalReplicationGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeGlobalReplicationGroupNotFoundFault "GlobalReplicationGroupNotFoundFault"
//   The Global Datastore does not exist
//
//   * ErrCodeInvalidGlobalReplicationGroupStateFault "InvalidGlobalReplicationGroupState"
//   The Global Datastore is not available or in primary-only state.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/RebalanceSlotsInGlobalReplicationGroup
func (c *ElastiCache) RebalanceSlotsInGlobalReplicationGroup(input *RebalanceSlotsInGlobalReplicationGroupInput) (*RebalanceSlotsInGlobalReplicationGroupOutput, error) {
	req, out := c.RebalanceSlotsInGlobalReplicationGroupRequest(input)
	return out, req.Send()
}

// RebalanceSlotsInGlobalReplicationGroupWithContext is the same as RebalanceSlotsInGlobalReplicationGroup with the addition of
// the ability to pass a context and additional request options.
//
// See RebalanceSlotsInGlobalReplicationGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) RebalanceSlotsInGlobalReplicationGroupWithContext(ctx aws.Context, input *RebalanceSlotsInGlobalReplicationGroupInput, opts ...request.Option) (*RebalanceSlotsInGlobalReplicationGroupOutput, error) {
	req, out := c.RebalanceSlotsInGlobalReplicationGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRebootCacheCluster = "RebootCacheCluster"

// RebootCacheClusterRequest generates a "aws/request.Request" representing the
// client's request for the RebootCacheCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RebootCacheCluster for more information on using the RebootCacheCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RebootCacheClusterRequest method.
//    req, resp := client.RebootCacheClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/RebootCacheCluster
func (c *ElastiCache) RebootCacheClusterRequest(input *RebootCacheClusterInput) (req *request.Request, output *RebootCacheClusterOutput) {
	op := &request.Operation{
		Name:       opRebootCacheCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootCacheClusterInput{}
	}

	output = &RebootCacheClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RebootCacheCluster API operation for Amazon ElastiCache.
//
// Reboots some, or all, of the cache nodes within a provisioned cluster. This
// operation applies any modified cache parameter groups to the cluster. The
// reboot operation takes place as soon as possible, and results in a momentary
// outage to the cluster. During the reboot, the cluster status is set to REBOOTING.
//
// The reboot causes the contents of the cache (for each cache node being rebooted)
// to be lost.
//
// When the reboot is complete, a cluster event is created.
//
// Rebooting a cluster is currently supported on Memcached and Redis (cluster
// mode disabled) clusters. Rebooting is not supported on Redis (cluster mode
// enabled) clusters.
//
// If you make changes to parameters that require a Redis (cluster mode enabled)
// cluster reboot for the changes to be applied, see Rebooting a Cluster (http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html)
// for an alternate process.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation RebootCacheCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidCacheClusterStateFault "InvalidCacheClusterState"
//   The requested cluster is not in the available state.
//
//   * ErrCodeCacheClusterNotFoundFault "CacheClusterNotFound"
//   The requested cluster ID does not refer to an existing cluster.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/RebootCacheCluster
func (c *ElastiCache) RebootCacheCluster(input *RebootCacheClusterInput) (*RebootCacheClusterOutput, error) {
	req, out := c.RebootCacheClusterRequest(input)
	return out, req.Send()
}

// RebootCacheClusterWithContext is the same as RebootCacheCluster with the addition of
// the ability to pass a context and additional request options.
//
// See RebootCacheCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) RebootCacheClusterWithContext(ctx aws.Context, input *RebootCacheClusterInput, opts ...request.Option) (*RebootCacheClusterOutput, error) {
	req, out := c.RebootCacheClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveTagsFromResource = "RemoveTagsFromResource"

// RemoveTagsFromResourceRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTagsFromResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveTagsFromResource for more information on using the RemoveTagsFromResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveTagsFromResourceRequest method.
//    req, resp := client.RemoveTagsFromResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/RemoveTagsFromResource
func (c *ElastiCache) RemoveTagsFromResourceRequest(input *RemoveTagsFromResourceInput) (req *request.Request, output *TagListMessage) {
	op := &request.Operation{
		Name:       opRemoveTagsFromResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsFromResourceInput{}
	}

	output = &TagListMessage{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveTagsFromResource API operation for Amazon ElastiCache.
//
// Removes the tags identified by the TagKeys list from the named resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation RemoveTagsFromResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCacheClusterNotFoundFault "CacheClusterNotFound"
//   The requested cluster ID does not refer to an existing cluster.
//
//   * ErrCodeSnapshotNotFoundFault "SnapshotNotFoundFault"
//   The requested snapshot name does not refer to an existing snapshot.
//
//   * ErrCodeInvalidARNFault "InvalidARN"
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * ErrCodeTagNotFoundFault "TagNotFound"
//   The requested tag was not found on this resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/RemoveTagsFromResource
func (c *ElastiCache) RemoveTagsFromResource(input *RemoveTagsFromResourceInput) (*TagListMessage, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	return out, req.Send()
}

// RemoveTagsFromResourceWithContext is the same as RemoveTagsFromResource with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveTagsFromResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) RemoveTagsFromResourceWithContext(ctx aws.Context, input *RemoveTagsFromResourceInput, opts ...request.Option) (*TagListMessage, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResetCacheParameterGroup = "ResetCacheParameterGroup"

// ResetCacheParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the ResetCacheParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResetCacheParameterGroup for more information on using the ResetCacheParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResetCacheParameterGroupRequest method.
//    req, resp := client.ResetCacheParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ResetCacheParameterGroup
func (c *ElastiCache) ResetCacheParameterGroupRequest(input *ResetCacheParameterGroupInput) (req *request.Request, output *CacheParameterGroupNameMessage) {
	op := &request.Operation{
		Name:       opResetCacheParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetCacheParameterGroupInput{}
	}

	output = &CacheParameterGroupNameMessage{}
	req = c.newRequest(op, input, output)
	return
}

// ResetCacheParameterGroup API operation for Amazon ElastiCache.
//
// Modifies the parameters of a cache parameter group to the engine or system
// default value. You can reset specific parameters by submitting a list of
// parameter names. To reset the entire cache parameter group, specify the ResetAllParameters
// and CacheParameterGroupName parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation ResetCacheParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidCacheParameterGroupStateFault "InvalidCacheParameterGroupState"
//   The current state of the cache parameter group does not allow the requested
//   operation to occur.
//
//   * ErrCodeCacheParameterGroupNotFoundFault "CacheParameterGroupNotFound"
//   The requested cache parameter group name does not refer to an existing cache
//   parameter group.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
//   * ErrCodeInvalidGlobalReplicationGroupStateFault "InvalidGlobalReplicationGroupState"
//   The Global Datastore is not available or in primary-only state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ResetCacheParameterGroup
func (c *ElastiCache) ResetCacheParameterGroup(input *ResetCacheParameterGroupInput) (*CacheParameterGroupNameMessage, error) {
	req, out := c.ResetCacheParameterGroupRequest(input)
	return out, req.Send()
}

// ResetCacheParameterGroupWithContext is the same as ResetCacheParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ResetCacheParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) ResetCacheParameterGroupWithContext(ctx aws.Context, input *ResetCacheParameterGroupInput, opts ...request.Option) (*CacheParameterGroupNameMessage, error) {
	req, out := c.ResetCacheParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRevokeCacheSecurityGroupIngress = "RevokeCacheSecurityGroupIngress"

// RevokeCacheSecurityGroupIngressRequest generates a "aws/request.Request" representing the
// client's request for the RevokeCacheSecurityGroupIngress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RevokeCacheSecurityGroupIngress for more information on using the RevokeCacheSecurityGroupIngress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RevokeCacheSecurityGroupIngressRequest method.
//    req, resp := client.RevokeCacheSecurityGroupIngressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/RevokeCacheSecurityGroupIngress
func (c *ElastiCache) RevokeCacheSecurityGroupIngressRequest(input *RevokeCacheSecurityGroupIngressInput) (req *request.Request, output *RevokeCacheSecurityGroupIngressOutput) {
	op := &request.Operation{
		Name:       opRevokeCacheSecurityGroupIngress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeCacheSecurityGroupIngressInput{}
	}

	output = &RevokeCacheSecurityGroupIngressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RevokeCacheSecurityGroupIngress API operation for Amazon ElastiCache.
//
// Revokes ingress from a cache security group. Use this operation to disallow
// access from an Amazon EC2 security group that had been previously authorized.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation RevokeCacheSecurityGroupIngress for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCacheSecurityGroupNotFoundFault "CacheSecurityGroupNotFound"
//   The requested cache security group name does not refer to an existing cache
//   security group.
//
//   * ErrCodeAuthorizationNotFoundFault "AuthorizationNotFound"
//   The specified Amazon EC2 security group is not authorized for the specified
//   cache security group.
//
//   * ErrCodeInvalidCacheSecurityGroupStateFault "InvalidCacheSecurityGroupState"
//   The current state of the cache security group does not allow deletion.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/RevokeCacheSecurityGroupIngress
func (c *ElastiCache) RevokeCacheSecurityGroupIngress(input *RevokeCacheSecurityGroupIngressInput) (*RevokeCacheSecurityGroupIngressOutput, error) {
	req, out := c.RevokeCacheSecurityGroupIngressRequest(input)
	return out, req.Send()
}

// RevokeCacheSecurityGroupIngressWithContext is the same as RevokeCacheSecurityGroupIngress with the addition of
// the ability to pass a context and additional request options.
//
// See RevokeCacheSecurityGroupIngress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) RevokeCacheSecurityGroupIngressWithContext(ctx aws.Context, input *RevokeCacheSecurityGroupIngressInput, opts ...request.Option) (*RevokeCacheSecurityGroupIngressOutput, error) {
	req, out := c.RevokeCacheSecurityGroupIngressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartMigration = "StartMigration"

// StartMigrationRequest generates a "aws/request.Request" representing the
// client's request for the StartMigration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMigration for more information on using the StartMigration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartMigrationRequest method.
//    req, resp := client.StartMigrationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/StartMigration
func (c *ElastiCache) StartMigrationRequest(input *StartMigrationInput) (req *request.Request, output *StartMigrationOutput) {
	op := &request.Operation{
		Name:       opStartMigration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartMigrationInput{}
	}

	output = &StartMigrationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartMigration API operation for Amazon ElastiCache.
//
// Start the migration of data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation StartMigration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeReplicationGroupNotFoundFault "ReplicationGroupNotFoundFault"
//   The specified replication group does not exist.
//
//   * ErrCodeInvalidReplicationGroupStateFault "InvalidReplicationGroupState"
//   The requested replication group is not in the available state.
//
//   * ErrCodeReplicationGroupAlreadyUnderMigrationFault "ReplicationGroupAlreadyUnderMigrationFault"
//   The targeted replication group is not available.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/StartMigration
func (c *ElastiCache) StartMigration(input *StartMigrationInput) (*StartMigrationOutput, error) {
	req, out := c.StartMigrationRequest(input)
	return out, req.Send()
}

// StartMigrationWithContext is the same as StartMigration with the addition of
// the ability to pass a context and additional request options.
//
// See StartMigration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) StartMigrationWithContext(ctx aws.Context, input *StartMigrationInput, opts ...request.Option) (*StartMigrationOutput, error) {
	req, out := c.StartMigrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTestFailover = "TestFailover"

// TestFailoverRequest generates a "aws/request.Request" representing the
// client's request for the TestFailover operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TestFailover for more information on using the TestFailover
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TestFailoverRequest method.
//    req, resp := client.TestFailoverRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/TestFailover
func (c *ElastiCache) TestFailoverRequest(input *TestFailoverInput) (req *request.Request, output *TestFailoverOutput) {
	op := &request.Operation{
		Name:       opTestFailover,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TestFailoverInput{}
	}

	output = &TestFailoverOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TestFailover API operation for Amazon ElastiCache.
//
// Represents the input of a TestFailover operation which test automatic failover
// on a specified node group (called shard in the console) in a replication
// group (called cluster in the console).
//
// Note the following
//
//    * A customer can use this operation to test automatic failover on up to
//    5 shards (called node groups in the ElastiCache API and AWS CLI) in any
//    rolling 24-hour period.
//
//    * If calling this operation on shards in different clusters (called replication
//    groups in the API and CLI), the calls can be made concurrently.
//
//    * If calling this operation multiple times on different shards in the
//    same Redis (cluster mode enabled) replication group, the first node replacement
//    must complete before a subsequent call can be made.
//
//    * To determine whether the node replacement is complete you can check
//    Events using the Amazon ElastiCache console, the AWS CLI, or the ElastiCache
//    API. Look for the following automatic failover related events, listed
//    here in order of occurrance: Replication group message: Test Failover
//    API called for node group <node-group-id> Cache cluster message: Failover
//    from master node <primary-node-id> to replica node <node-id> completed
//    Replication group message: Failover from master node <primary-node-id>
//    to replica node <node-id> completed Cache cluster message: Recovering
//    cache nodes <node-id> Cache cluster message: Finished recovery for cache
//    nodes <node-id> For more information see: Viewing ElastiCache Events (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ECEvents.Viewing.html)
//    in the ElastiCache User Guide DescribeEvents (https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DescribeEvents.html)
//    in the ElastiCache API Reference
//
// Also see, Testing Multi-AZ (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html#auto-failover-test)
// in the ElastiCache User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon ElastiCache's
// API operation TestFailover for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAPICallRateForCustomerExceededFault "APICallRateForCustomerExceeded"
//   The customer has exceeded the allowed rate of API calls.
//
//   * ErrCodeInvalidCacheClusterStateFault "InvalidCacheClusterState"
//   The requested cluster is not in the available state.
//
//   * ErrCodeInvalidReplicationGroupStateFault "InvalidReplicationGroupState"
//   The requested replication group is not in the available state.
//
//   * ErrCodeNodeGroupNotFoundFault "NodeGroupNotFoundFault"
//   The node group specified by the NodeGroupId parameter could not be found.
//   Please verify that the node group exists and that you spelled the NodeGroupId
//   value correctly.
//
//   * ErrCodeReplicationGroupNotFoundFault "ReplicationGroupNotFoundFault"
//   The specified replication group does not exist.
//
//   * ErrCodeTestFailoverNotAvailableFault "TestFailoverNotAvailableFault"
//   The TestFailover action is not available.
//
//   * ErrCodeInvalidKMSKeyFault "InvalidKMSKeyFault"
//   The KMS key supplied is not valid.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombination"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/TestFailover
func (c *ElastiCache) TestFailover(input *TestFailoverInput) (*TestFailoverOutput, error) {
	req, out := c.TestFailoverRequest(input)
	return out, req.Send()
}

// TestFailoverWithContext is the same as TestFailover with the addition of
// the ability to pass a context and additional request options.
//
// See TestFailover for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElastiCache) TestFailoverWithContext(ctx aws.Context, input *TestFailoverInput, opts ...request.Option) (*TestFailoverOutput, error) {
	req, out := c.TestFailoverRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Represents the input of an AddTagsToResource operation.
type AddTagsToResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to which the tags are to be
	// added, for example arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster
	// or arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot. ElastiCache
	// resources are cluster and snapshot.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// ResourceName is a required field
	ResourceName *string `type:"string" required:"true"`

	// A list of cost allocation tags to be added to this resource. A tag is a key-value
	// pair. A tag key must be accompanied by a tag value.
	//
	// Tags is a required field
	Tags []*Tag `locationNameList:"Tag" type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsToResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsToResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsToResourceInput"}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceName sets the ResourceName field's value.
func (s *AddTagsToResourceInput) SetResourceName(v string) *AddTagsToResourceInput {
	s.ResourceName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AddTagsToResourceInput) SetTags(v []*Tag) *AddTagsToResourceInput {
	s.Tags = v
	return s
}

// Represents the input of an AuthorizeCacheSecurityGroupIngress operation.
type AuthorizeCacheSecurityGroupIngressInput struct {
	_ struct{} `type:"structure"`

	// The cache security group that allows network ingress.
	//
	// CacheSecurityGroupName is a required field
	CacheSecurityGroupName *string `type:"string" required:"true"`

	// The Amazon EC2 security group to be authorized for ingress to the cache security
	// group.
	//
	// EC2SecurityGroupName is a required field
	EC2SecurityGroupName *string `type:"string" required:"true"`

	// The AWS account number of the Amazon EC2 security group owner. Note that
	// this is not the same thing as an AWS access key ID - you must provide a valid
	// AWS account number for this parameter.
	//
	// EC2SecurityGroupOwnerId is a required field
	EC2SecurityGroupOwnerId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AuthorizeCacheSecurityGroupIngressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeCacheSecurityGroupIngressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuthorizeCacheSecurityGroupIngressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuthorizeCacheSecurityGroupIngressInput"}
	if s.CacheSecurityGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("CacheSecurityGroupName"))
	}
	if s.EC2SecurityGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("EC2SecurityGroupName"))
	}
	if s.EC2SecurityGroupOwnerId == nil {
		invalidParams.Add(request.NewErrParamRequired("EC2SecurityGroupOwnerId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCacheSecurityGroupName sets the CacheSecurityGroupName field's value.
func (s *AuthorizeCacheSecurityGroupIngressInput) SetCacheSecurityGroupName(v string) *AuthorizeCacheSecurityGroupIngressInput {
	s.CacheSecurityGroupName = &v
	return s
}

// SetEC2SecurityGroupName sets the EC2SecurityGroupName field's value.
func (s *AuthorizeCacheSecurityGroupIngressInput) SetEC2SecurityGroupName(v string) *AuthorizeCacheSecurityGroupIngressInput {
	s.EC2SecurityGroupName = &v
	return s
}

// SetEC2SecurityGroupOwnerId sets the EC2SecurityGroupOwnerId field's value.
func (s *AuthorizeCacheSecurityGroupIngressInput) SetEC2SecurityGroupOwnerId(v string) *AuthorizeCacheSecurityGroupIngressInput {
	s.EC2SecurityGroupOwnerId = &v
	return s
}

type AuthorizeCacheSecurityGroupIngressOutput struct {
	_ struct{} `type:"structure"`

	// Represents the output of one of the following operations:
	//
	//    * AuthorizeCacheSecurityGroupIngress
	//
	//    * CreateCacheSecurityGroup
	//
	//    * RevokeCacheSecurityGroupIngress
	CacheSecurityGroup *CacheSecurityGroup `type:"structure"`
}

// String returns the string representation
func (s AuthorizeCacheSecurityGroupIngressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeCacheSecurityGroupIngressOutput) GoString() string {
	return s.String()
}

// SetCacheSecurityGroup sets the CacheSecurityGroup field's value.
func (s *AuthorizeCacheSecurityGroupIngressOutput) SetCacheSecurityGroup(v *CacheSecurityGroup) *AuthorizeCacheSecurityGroupIngressOutput {
	s.CacheSecurityGroup = v
	return s
}

// Describes an Availability Zone in which the cluster is launched.
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The name of the Availability Zone.
	Name *string `type:"string"`
}

// String returns the string representation
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailabilityZone) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AvailabilityZone) SetName(v string) *AvailabilityZone {
	s.Name = &v
	return s
}

type BatchApplyUpdateActionInput struct {
	_ struct{} `type:"structure"`

	// The cache cluster IDs
	CacheClusterIds []*string `type:"list"`

	// The replication group IDs
	ReplicationGroupIds []*string `type:"list"`

	// The unique ID of the service update
	//
	// ServiceUpdateName is a required field
	ServiceUpdateName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s BatchApplyUpdateActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchApplyUpdateActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchApplyUpdateActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchApplyUpdateActionInput"}
	if s.ServiceUpdateName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceUpdateName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCacheClusterIds sets the CacheClusterIds field's value.
func (s *BatchApplyUpdateActionInput) SetCacheClusterIds(v []*string) *BatchApplyUpdateActionInput {
	s.CacheClusterIds = v
	return s
}

// SetReplicationGroupIds sets the ReplicationGroupIds field's value.
func (s *BatchApplyUpdateActionInput) SetReplicationGroupIds(v []*string) *BatchApplyUpdateActionInput {
	s.ReplicationGroupIds = v
	return s
}

// SetServiceUpdateName sets the ServiceUpdateName field's value.
func (s *BatchApplyUpdateActionInput) SetServiceUpdateName(v string) *BatchApplyUpdateActionInput {
	s.ServiceUpdateName = &v
	return s
}

type BatchApplyUpdateActionOutput struct {
	_ struct{} `type:"structure"`

	// Update actions that have been processed successfully
	ProcessedUpdateActions []*ProcessedUpdateAction `locationNameList:"ProcessedUpdateAction" type:"list"`

	// Update actions that haven't been processed successfully
	UnprocessedUpdateActions []*UnprocessedUpdateAction `locationNameList:"UnprocessedUpdateAction" type:"list"`
}

// String returns the string representation
func (s BatchApplyUpdateActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchApplyUpdateActionOutput) GoString() string {
	return s.String()
}

// SetProcessedUpdateActions sets the ProcessedUpdateActions field's value.
func (s *BatchApplyUpdateActionOutput) SetProcessedUpdateActions(v []*ProcessedUpdateAction) *BatchApplyUpdateActionOutput {
	s.ProcessedUpdateActions = v
	return s
}

// SetUnprocessedUpdateActions sets the UnprocessedUpdateActions field's value.
func (s *BatchApplyUpdateActionOutput) SetUnprocessedUpdateActions(v []*UnprocessedUpdateAction) *BatchApplyUpdateActionOutput {
	s.UnprocessedUpdateActions = v
	return s
}

type BatchStopUpdateActionInput struct {
	_ struct{} `type:"structure"`

	// The cache cluster IDs
	CacheClusterIds []*string `type:"list"`

	// The replication group IDs
	ReplicationGroupIds []*string `type:"list"`

	// The unique ID of the service update
	//
	// ServiceUpdateName is a required field
	ServiceUpdateName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s BatchStopUpdateActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchStopUpdateActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchStopUpdateActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchStopUpdateActionInput"}
	if s.ServiceUpdateName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceUpdateName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCacheClusterIds sets the CacheClusterIds field's value.
func (s *BatchStopUpdateActionInput) SetCacheClusterIds(v []*string) *BatchStopUpdateActionInput {
	s.CacheClusterIds = v
	return s
}

// SetReplicationGroupIds sets the ReplicationGroupIds field's value.
func (s *BatchStopUpdateActionInput) SetReplicationGroupIds(v []*string) *BatchStopUpdateActionInput {
	s.ReplicationGroupIds = v
	return s
}

// SetServiceUpdateName sets the ServiceUpdateName field's value.
func (s *BatchStopUpdateActionInput) SetServiceUpdateName(v string) *BatchStopUpdateActionInput {
	s.ServiceUpdateName = &v
	return s
}

type BatchStopUpdateActionOutput struct {
	_ struct{} `type:"structure"`

	// Update actions that have been processed successfully
	ProcessedUpdateActions []*ProcessedUpdateAction `locationNameList:"ProcessedUpdateAction" type:"list"`

	// Update actions that haven't been processed successfully
	UnprocessedUpdateActions []*UnprocessedUpdateAction `locationNameList:"UnprocessedUpdateAction" type:"list"`
}

// String returns the string representation
func (s BatchStopUpdateActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchStopUpdateActionOutput) GoString() string {
	return s.String()
}

// SetProcessedUpdateActions sets the ProcessedUpdateActions field's value.
func (s *BatchStopUpdateActionOutput) SetProcessedUpdateActions(v []*ProcessedUpdateAction) *BatchStopUpdateActionOutput {
	s.ProcessedUpdateActions = v
	return s
}

// SetUnprocessedUpdateActions sets the UnprocessedUpdateActions field's value.
func (s *BatchStopUpdateActionOutput) SetUnprocessedUpdateActions(v []*UnprocessedUpdateAction) *BatchStopUpdateActionOutput {
	s.UnprocessedUpdateActions = v
	return s
}

// Contains all of the attributes of a specific cluster.
type CacheCluster struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) of the cache cluster.
	ARN *string `type:"string"`

	// A flag that enables encryption at-rest when set to true.
	//
	// You cannot modify the value of AtRestEncryptionEnabled after the cluster
	// is created. To enable at-rest encryption on a cluster you must set AtRestEncryptionEnabled
	// to true when you create a cluster.
	//
	// Required: Only available when creating a replication group in an Amazon VPC
	// using redis version 3.2.6, 4.x or later.
	//
	// Default: false
	AtRestEncryptionEnabled *bool `type:"boolean"`

	// A flag that enables using an AuthToken (password) when issuing Redis commands.
	//
	// Default: false
	AuthTokenEnabled *bool `type:"boolean"`

	// The date the auth token was last modified
	AuthTokenLastModifiedDate *time.Time `type:"timestamp"`

	// This parameter is currently disabled.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The date and time when the cluster was created.
	CacheClusterCreateTime *time.Time `type:"timestamp"`

	// The user-supplied identifier of the cluster. This identifier is a unique
	// key that identifies a cluster.
	CacheClusterId *string `type:"string"`

	// The current state of this cluster, one of the following values: available,
	// creating, deleted, deleting, incompatible-network, modifying, rebooting cluster
	// nodes, restore-failed, or snapshotting.
	CacheClusterStatus *string `type:"string"`

	// The name of the compute and memory capacity node type for the cluster.
	//
	// The following node types are supported by ElastiCache. Generally speaking,
	// the current generation types provide more memory and computational power
	// at lower cost when compared to their equivalent previous generation counterparts.
	//
	//    * General purpose: Current generation: M5 node types: cache.m5.large,
	//    cache.m5.xlarge, cache.m5.2xlarge, cache.m5.4xlarge, cache.m5.12xlarge,
	//    cache.m5.24xlarge M4 node types: cache.m4.large, cache.m4.xlarge, cache.m4.2xlarge,
	//    cache.m4.4xlarge, cache.m4.10xlarge T3 node types: cache.t3.micro, cache.t3.small,
	//    cache.t3.medium T2 node types: cache.t2.micro, cache.t2.small, cache.t2.medium
	//    Previous generation: (not recommended) T1 node types: cache.t1.micro M1
	//    node types: cache.m1.small, cache.m1.medium, cache.m1.large, cache.m1.xlarge
	//    M3 node types: cache.m3.medium, cache.m3.large, cache.m3.xlarge, cache.m3.2xlarge
	//
	//    * Compute optimized: Previous generation: (not recommended) C1 node types:
	//    cache.c1.xlarge
	//
	//    * Memory optimized: Current generation: R5 node types: cache.r5.large,
	//    cache.r5.xlarge, cache.r5.2xlarge, cache.r5.4xlarge, cache.r5.12xlarge,
	//    cache.r5.24xlarge R4 node types: cache.r4.large, cache.r4.xlarge, cache.r4.2xlarge,
	//    cache.r4.4xlarge, cache.r4.8xlarge, cache.r4.16xlarge Previous generation:
	//    (not recommended) M2 node types: cache.m2.xlarge, cache.m2.2xlarge, cache.m2.4xlarge
	//    R3 node types: cache.r3.large, cache.r3.xlarge, cache.r3.2xlarge, cache.r3.4xlarge,
	//    cache.r3.8xlarge
	//
	// Additional node type info
	//
	//    * All current generation instance types are created in Amazon VPC by default.
	//
	//    * Redis append-only files (AOF) are not supported for T1 or T2 instances.
	//
	//    * Redis Multi-AZ with automatic failover is not supported on T1 instances.
	//
	//    * Redis configuration variables appendonly and appendfsync are not supported
	//    on Redis version 2.8.22 and later.
	CacheNodeType *string `type:"string"`

	// A list of cache nodes that are members of the cluster.
	CacheNodes []*CacheNode `locationNameList:"CacheNode" type:"list"`

	// Status of the cache parameter group.
	CacheParameterGroup *CacheParameterGroupStatus `type:"structure"`

	// A list of cache security group elements, composed of name and status sub-elements.
	CacheSecurityGroups []*CacheSecurityGroupMembership `locationNameList:"CacheSecurityGroup" type:"list"`

	// The name of the cache subnet group associated with the cluster.
	CacheSubnetGroupName *string `type:"string"`

	// The URL of the web page where you can download the latest ElastiCache client
	// library.
	ClientDownloadLandingPage *string `type:"string"`

	// Represents a Memcached cluster endpoint which, if Automatic Discovery is
	// enabled on the cluster, can be used by an application to connect to any node
	// in the cluster. The configuration endpoint will always have .cfg in it.
	//
	// Example: mem-3.9dvc4r.cfg.usw2.cache.amazonaws.com:11211
	ConfigurationEndpoint *Endpoint `type:"structure"`

	// The name of the cache engine (memcached or redis) to be used for this cluster.
	Engine *string `type:"string"`

	// The version of the cache engine that is used in this cluster.
	EngineVersion *string `type:"string"`

	// Describes a notification topic and its status. Notification topics are used
	// for publishing ElastiCache events to subscribers using Amazon Simple Notification
	// Service (SNS).
	NotificationConfiguration *NotificationConfiguration `type:"structure"`

	// The number of cache nodes in the cluster.
	//
	// For clusters running Redis, this value must be 1. For clusters running Memcached,
	// this value must be between 1 and 20.
	NumCacheNodes *int64 `type:"integer"`

	// A group of settings that are applied to the cluster in the future, or that
	// are currently being applied.
	PendingModifiedValues *PendingModifiedValues `type:"structure"`

	// The name of the Availability Zone in which the cluster is located or "Multiple"
	// if the cache nodes are located in different Availability Zones.
	PreferredAvailabilityZone *string `type:"string"`

	// Specifies the weekly time range during which maintenance on the cluster is
	// performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi
	// (24H Clock UTC). The minimum maintenance window is a 60 minute period.
	//
	// Valid values for ddd are:
	//
	//    * sun
	//
	//    * mon
	//
	//    * tue
	//
	//    * wed
	//
	//    * thu
	//
	//    * fri
	//
	//    * sat
	//
	// Example: sun:23:00-mon:01:30
	PreferredMaintenanceWindow *string `type:"string"`

	// The replication group to which this cluster belongs. If this field is empty,
	// the cluster is not associated with any replication group.
	ReplicationGroupId *string `type:"string"`

	// A list of VPC Security Groups associated with the cluster.
	SecurityGroups []*SecurityGroupMembership `type:"list"`

	// The number of days for which ElastiCache retains automatic cluster snapshots
	// before deleting them. For example, if you set SnapshotRetentionLimit to 5,
	// a snapshot that was taken today is retained for 5 days before being deleted.
	//
	// If the value of SnapshotRetentionLimit is set to zero (0), backups are turned
	// off.
	SnapshotRetentionLimit *int64 `type:"integer"`

	// The daily time range (in UTC) during which ElastiCache begins taking a daily
	// snapshot of your cluster.
	//
	// Example: 05:00-09:00
	SnapshotWindow *string `type:"string"`

	// A flag that enables in-transit encryption when set to true.
	//
	// You cannot modify the value of TransitEncryptionEnabled after the cluster
	// is created. To enable in-transit encryption on a cluster you must set TransitEncryptionEnabled
	// to true when you create a cluster.
	//
	// Required: Only available when creating a replication group in an Amazon VPC
	// using redis version 3.2.6, 4.x or later.
	//
	// Default: false
	TransitEncryptionEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s CacheCluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheCluster) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *CacheCluster) SetARN(v string) *CacheCluster {
	s.ARN = &v
	return s
}

// SetAtRestEncryptionEnabled sets the AtRestEncryptionEnabled field's value.
func (s *CacheCluster) SetAtRestEncryptionEnabled(v bool) *CacheCluster {
	s.AtRestEncryptionEnabled = &v
	return s
}

// SetAuthTokenEnabled sets the AuthTokenEnabled field's value.
func (s *CacheCluster) SetAuthTokenEnabled(v bool) *CacheCluster {
	s.AuthTokenEnabled = &v
	return s
}

// SetAuthTokenLastModifiedDate sets the AuthTokenLastModifiedDate field's value.
func (s *CacheCluster) SetAuthTokenLastModifiedDate(v time.Time) *CacheCluster {
	s.AuthTokenLastModifiedDate = &v
	return s
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *CacheCluster) SetAutoMinorVersionUpgrade(v bool) *CacheCluster {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetCacheClusterCreateTime sets the CacheClusterCreateTime field's value.
func (s *CacheCluster) SetCacheClusterCreateTime(v time.Time) *CacheCluster {
	s.CacheClusterCreateTime = &v
	return s
}

// SetCacheClusterId sets the CacheClusterId field's value.
func (s *CacheCluster) SetCacheClusterId(v string) *CacheCluster {
	s.CacheClusterId = &v
	return s
}

// SetCacheClusterStatus sets the CacheClusterStatus field's value.
func (s *CacheCluster) SetCacheClusterStatus(v string) *CacheCluster {
	s.CacheClusterStatus = &v
	return s
}

// SetCacheNodeType sets the CacheNodeType field's value.
func (s *CacheCluster) SetCacheNodeType(v string) *CacheCluster {
	s.CacheNodeType = &v
	return s
}

// SetCacheNodes sets the CacheNodes field's value.
func (s *CacheCluster) SetCacheNodes(v []*CacheNode) *CacheCluster {
	s.CacheNodes = v
	return s
}

// SetCacheParameterGroup sets the CacheParameterGroup field's value.
func (s *CacheCluster) SetCacheParameterGroup(v *CacheParameterGroupStatus) *CacheCluster {
	s.CacheParameterGroup = v
	return s
}

// SetCacheSecurityGroups sets the CacheSecurityGroups field's value.
func (s *CacheCluster) SetCacheSecurityGroups(v []*CacheSecurityGroupMembership) *CacheCluster {
	s.CacheSecurityGroups = v
	return s
}

// SetCacheSubnetGroupName sets the CacheSubnetGroupName field's value.
func (s *CacheCluster) SetCacheSubnetGroupName(v string) *CacheCluster {
	s.CacheSubnetGroupName = &v
	return s
}

// SetClientDownloadLandingPage sets the ClientDownloadLandingPage field's value.
func (s *CacheCluster) SetClientDownloadLandingPage(v string) *CacheCluster {
	s.ClientDownloadLandingPage = &v
	return s
}

// SetConfigurationEndpoint sets the ConfigurationEndpoint field's value.
func (s *CacheCluster) SetConfigurationEndpoint(v *Endpoint) *CacheCluster {
	s.ConfigurationEndpoint = v
	return s
}

// SetEngine sets the Engine field's value.
func (s *CacheCluster) SetEngine(v string) *CacheCluster {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *CacheCluster) SetEngineVersion(v string) *CacheCluster {
	s.EngineVersion = &v
	return s
}

// SetNotificationConfiguration sets the NotificationConfiguration field's value.
func (s *CacheCluster) SetNotificationConfiguration(v *NotificationConfiguration) *CacheCluster {
	s.NotificationConfiguration = v
	return s
}

// SetNumCacheNodes sets the NumCacheNodes field's value.
func (s *CacheCluster) SetNumCacheNodes(v int64) *CacheCluster {
	s.NumCacheNodes = &v
	return s
}

// SetPendingModifiedValues sets the PendingModifiedValues field's value.
func (s *CacheCluster) SetPendingModifiedValues(v *PendingModifiedValues) *CacheCluster {
	s.PendingModifiedValues = v
	return s
}

// SetPreferredAvailabilityZone sets the PreferredAvailabilityZone field's value.
func (s *CacheCluster) SetPreferredAvailabilityZone(v string) *CacheCluster {
	s.PreferredAvailabilityZone = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *CacheCluster) SetPreferredMaintenanceWindow(v string) *CacheCluster {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetReplicationGroupId sets the ReplicationGroupId field's value.
func (s *CacheCluster) SetReplicationGroupId(v string) *CacheCluster {
	s.ReplicationGroupId = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *CacheCluster) SetSecurityGroups(v []*SecurityGroupMembership) *CacheCluster {
	s.SecurityGroups = v
	return s
}

// SetSnapshotRetentionLimit sets the SnapshotRetentionLimit field's value.
func (s *CacheCluster) SetSnapshotRetentionLimit(v int64) *CacheCluster {
	s.SnapshotRetentionLimit = &v
	return s
}

// SetSnapshotWindow sets the SnapshotWindow field's value.
func (s *CacheCluster) SetSnapshotWindow(v string) *CacheCluster {
	s.SnapshotWindow = &v
	return s
}

// SetTransitEncryptionEnabled sets the TransitEncryptionEnabled field's value.
func (s *CacheCluster) SetTransitEncryptionEnabled(v bool) *CacheCluster {
	s.TransitEncryptionEnabled = &v
	return s
}

// Provides all of the details about a particular cache engine version.
type CacheEngineVersion struct {
	_ struct{} `type:"structure"`

	// The description of the cache engine.
	CacheEngineDescription *string `type:"string"`

	// The description of the cache engine version.
	CacheEngineVersionDescription *string `type:"string"`

	// The name of the cache parameter group family associated with this cache engine.
	//
	// Valid values are: memcached1.4 | memcached1.5 | redis2.6 | redis2.8 | redis3.2
	// | redis4.0 | redis5.0 |
	CacheParameterGroupFamily *string `type:"string"`

	// The name of the cache engine.
	Engine *string `type:"string"`

	// The version number of the cache engine.
	EngineVersion *string `type:"string"`
}

// String returns the string representation
func (s CacheEngineVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheEngineVersion) GoString() string {
	return s.String()
}

// SetCacheEngineDescription sets the CacheEngineDescription field's value.
func (s *CacheEngineVersion) SetCacheEngineDescription(v string) *CacheEngineVersion {
	s.CacheEngineDescription = &v
	return s
}

// SetCacheEngineVersionDescription sets the CacheEngineVersionDescription field's value.
func (s *CacheEngineVersion) SetCacheEngineVersionDescription(v string) *CacheEngineVersion {
	s.CacheEngineVersionDescription = &v
	return s
}

// SetCacheParameterGroupFamily sets the CacheParameterGroupFamily field's value.
func (s *CacheEngineVersion) SetCacheParameterGroupFamily(v string) *CacheEngineVersion {
	s.CacheParameterGroupFamily = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *CacheEngineVersion) SetEngine(v string) *CacheEngineVersion {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *CacheEngineVersion) SetEngineVersion(v string) *CacheEngineVersion {
	s.EngineVersion = &v
	return s
}

// Represents an individual cache node within a cluster. Each cache node runs
// its own instance of the cluster's protocol-compliant caching software - either
// Memcached or Redis.
//
// The following node types are supported by ElastiCache. Generally speaking,
// the current generation types provide more memory and computational power
// at lower cost when compared to their equivalent previous generation counterparts.
//
//    * General purpose: Current generation: M5 node types: cache.m5.large,
//    cache.m5.xlarge, cache.m5.2xlarge, cache.m5.4xlarge, cache.m5.12xlarge,
//    cache.m5.24xlarge M4 node types: cache.m4.large, cache.m4.xlarge, cache.m4.2xlarge,
//    cache.m4.4xlarge, cache.m4.10xlarge T3 node types: cache.t3.micro, cache.t3.small,
//    cache.t3.medium T2 node types: cache.t2.micro, cache.t2.small, cache.t2.medium
//    Previous generation: (not recommended) T1 node types: cache.t1.micro M1
//    node types: cache.m1.small, cache.m1.medium, cache.m1.large, cache.m1.xlarge
//    M3 node types: cache.m3.medium, cache.m3.large, cache.m3.xlarge, cache.m3.2xlarge
//
//    * Compute optimized: Previous generation: (not recommended) C1 node types:
//    cache.c1.xlarge
//
//    * Memory optimized: Current generation: R5 node types: cache.r5.large,
//    cache.r5.xlarge, cache.r5.2xlarge, cache.r5.4xlarge, cache.r5.12xlarge,
//    cache.r5.24xlarge R4 node types: cache.r4.large, cache.r4.xlarge, cache.r4.2xlarge,
//    cache.r4.4xlarge, cache.r4.8xlarge, cache.r4.16xlarge Previous generation:
//    (not recommended) M2 node types: cache.m2.xlarge, cache.m2.2xlarge, cache.m2.4xlarge
//    R3 node types: cache.r3.large, cache.r3.xlarge, cache.r3.2xlarge, cache.r3.4xlarge,
//    cache.r3.8xlarge
//
// Additional node type info
//
//    * All current generation instance types are created in Amazon VPC by default.
//
//    * Redis append-only files (AOF) are not supported for T1 or T2 instances.
//
//    * Redis Multi-AZ with automatic failover is not supported on T1 instances.
//
//    * Redis configuration variables appendonly and appendfsync are not supported
//    on Redis version 2.8.22 and later.
type CacheNode struct {
	_ struct{} `type:"structure"`

	// The date and time when the cache node was created.
	CacheNodeCreateTime *time.Time `type:"timestamp"`

	// The cache node identifier. A node ID is a numeric identifier (0001, 0002,
	// etc.). The combination of cluster ID and node ID uniquely identifies every
	// cache node used in a customer's AWS account.
	CacheNodeId *string `type:"string"`

	// The current state of this cache node, one of the following values: available,
	// creating, rebooting, or deleting.
	CacheNodeStatus *string `type:"string"`

	// The Availability Zone where this node was created and now resides.
	CustomerAvailabilityZone *string `type:"string"`

	// The hostname for connecting to this cache node.
	Endpoint *Endpoint `type:"structure"`

	// The status of the parameter group applied to this cache node.
	ParameterGroupStatus *string `type:"string"`

	// The ID of the primary node to which this read replica node is synchronized.
	// If this field is empty, this node is not associated with a primary cluster.
	SourceCacheNodeId *string `type:"string"`
}

// String returns the string representation
func (s CacheNode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheNode) GoString() string {
	return s.String()
}

// SetCacheNodeCreateTime sets the CacheNodeCreateTime field's value.
func (s *CacheNode) SetCacheNodeCreateTime(v time.Time) *CacheNode {
	s.CacheNodeCreateTime = &v
	return s
}

// SetCacheNodeId sets the CacheNodeId field's value.
func (s *CacheNode) SetCacheNodeId(v string) *CacheNode {
	s.CacheNodeId = &v
	return s
}

// SetCacheNodeStatus sets the CacheNodeStatus field's value.
func (s *CacheNode) SetCacheNodeStatus(v string) *CacheNode {
	s.CacheNodeStatus = &v
	return s
}

// SetCustomerAvailabilityZone sets the CustomerAvailabilityZone field's value.
func (s *CacheNode) SetCustomerAvailabilityZone(v string) *CacheNode {
	s.CustomerAvailabilityZone = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *CacheNode) SetEndpoint(v *Endpoint) *CacheNode {
	s.Endpoint = v
	return s
}

// SetParameterGroupStatus sets the ParameterGroupStatus field's value.
func (s *CacheNode) SetParameterGroupStatus(v string) *CacheNode {
	s.ParameterGroupStatus = &v
	return s
}

// SetSourceCacheNodeId sets the SourceCacheNodeId field's value.
func (s *CacheNode) SetSourceCacheNodeId(v string) *CacheNode {
	s.SourceCacheNodeId = &v
	return s
}

// A parameter that has a different value for each cache node type it is applied
// to. For example, in a Redis cluster, a cache.m1.large cache node type would
// have a larger maxmemory value than a cache.m1.small type.
type CacheNodeTypeSpecificParameter struct {
	_ struct{} `type:"structure"`

	// The valid range of values for the parameter.
	AllowedValues *string `type:"string"`

	// A list of cache node types and their corresponding values for this parameter.
	CacheNodeTypeSpecificValues []*CacheNodeTypeSpecificValue `locationNameList:"CacheNodeTypeSpecificValue" type:"list"`

	// Indicates whether a change to the parameter is applied immediately or requires
	// a reboot for the change to be applied. You can force a reboot or wait until
	// the next maintenance window's reboot. For more information, see Rebooting
	// a Cluster (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html).
	ChangeType *string `type:"string" enum:"ChangeType"`

	// The valid data type for the parameter.
	DataType *string `type:"string"`

	// A description of the parameter.
	Description *string `type:"string"`

	// Indicates whether (true) or not (false) the parameter can be modified. Some
	// parameters have security or operational implications that prevent them from
	// being changed.
	IsModifiable *bool `type:"boolean"`

	// The earliest cache engine version to which the parameter can apply.
	MinimumEngineVersion *string `type:"string"`

	// The name of the parameter.
	ParameterName *string `type:"string"`

	// The source of the parameter value.
	Source *string `type:"string"`
}

// String returns the string representation
func (s CacheNodeTypeSpecificParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheNodeTypeSpecificParameter) GoString() string {
	return s.String()
}

// SetAllowedValues sets the AllowedValues field's value.
func (s *CacheNodeTypeSpecificParameter) SetAllowedValues(v string) *CacheNodeTypeSpecificParameter {
	s.AllowedValues = &v
	return s
}

// SetCacheNodeTypeSpecificValues sets the CacheNodeTypeSpecificValues field's value.
func (s *CacheNodeTypeSpecificParameter) SetCacheNodeTypeSpecificValues(v []*CacheNodeTypeSpecificValue) *CacheNodeTypeSpecificParameter {
	s.CacheNodeTypeSpecificValues = v
	return s
}

// SetChangeType sets the ChangeType field's value.
func (s *CacheNodeTypeSpecificParameter) SetChangeType(v string) *CacheNodeTypeSpecificParameter {
	s.ChangeType = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *CacheNodeTypeSpecificParameter) SetDataType(v string) *CacheNodeTypeSpecificParameter {
	s.DataType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CacheNodeTypeSpecificParameter) SetDescription(v string) *CacheNodeTypeSpecificParameter {
	s.Description = &v
	return s
}

// SetIsModifiable sets the IsModifiable field's value.
func (s *CacheNodeTypeSpecificParameter) SetIsModifiable(v bool) *CacheNodeTypeSpecificParameter {
	s.IsModifiable = &v
	return s
}

// SetMinimumEngineVersion sets the MinimumEngineVersion field's value.
func (s *CacheNodeTypeSpecificParameter) SetMinimumEngineVersion(v string) *CacheNodeTypeSpecificParameter {
	s.MinimumEngineVersion = &v
	return s
}

// SetParameterName sets the ParameterName field's value.
func (s *CacheNodeTypeSpecificParameter) SetParameterName(v string) *CacheNodeTypeSpecificParameter {
	s.ParameterName = &v
	return s
}

// SetSource sets the Source field's value.
func (s *CacheNodeTypeSpecificParameter) SetSource(v string) *CacheNodeTypeSpecificParameter {
	s.Source = &v
	return s
}

// A value that applies only to a certain cache node type.
type CacheNodeTypeSpecificValue struct {
	_ struct{} `type:"structure"`

	// The cache node type for which this value applies.
	CacheNodeType *string `type:"string"`

	// The value for the cache node type.
	Value *string `type:"string"`
}

// String returns the string representation
func (s CacheNodeTypeSpecificValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheNodeTypeSpecificValue) GoString() string {
	return s.String()
}

// SetCacheNodeType sets the CacheNodeType field's value.
func (s *CacheNodeTypeSpecificValue) SetCacheNodeType(v string) *CacheNodeTypeSpecificValue {
	s.CacheNodeType = &v
	return s
}

// SetValue sets the Value field's value.
func (s *CacheNodeTypeSpecificValue) SetValue(v string) *CacheNodeTypeSpecificValue {
	s.Value = &v
	return s
}

// The status of the service update on the cache node
type CacheNodeUpdateStatus struct {
	_ struct{} `type:"structure"`

	// The node ID of the cache cluster
	CacheNodeId *string `type:"string"`

	// The deletion date of the node
	NodeDeletionDate *time.Time `type:"timestamp"`

	// The end date of the update for a node
	NodeUpdateEndDate *time.Time `type:"timestamp"`

	// Reflects whether the update was initiated by the customer or automatically
	// applied
	NodeUpdateInitiatedBy *string `type:"string" enum:"NodeUpdateInitiatedBy"`

	// The date when the update is triggered
	NodeUpdateInitiatedDate *time.Time `type:"timestamp"`

	// The start date of the update for a node
	NodeUpdateStartDate *time.Time `type:"timestamp"`

	// The update status of the node
	NodeUpdateStatus *string `type:"string" enum:"NodeUpdateStatus"`

	// The date when the NodeUpdateStatus was last modified>
	NodeUpdateStatusModifiedDate *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s CacheNodeUpdateStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheNodeUpdateStatus) GoString() string {
	return s.String()
}

// SetCacheNodeId sets the CacheNodeId field's value.
func (s *CacheNodeUpdateStatus) SetCacheNodeId(v string) *CacheNodeUpdateStatus {
	s.CacheNodeId = &v
	return s
}

// SetNodeDeletionDate sets the NodeDeletionDate field's value.
func (s *CacheNodeUpdateStatus) SetNodeDeletionDate(v time.Time) *CacheNodeUpdateStatus {
	s.NodeDeletionDate = &v
	return s
}

// SetNodeUpdateEndDate sets the NodeUpdateEndDate field's value.
func (s *CacheNodeUpdateStatus) SetNodeUpdateEndDate(v time.Time) *CacheNodeUpdateStatus {
	s.NodeUpdateEndDate = &v
	return s
}

// SetNodeUpdateInitiatedBy sets the NodeUpdateInitiatedBy field's value.
func (s *CacheNodeUpdateStatus) SetNodeUpdateInitiatedBy(v string) *CacheNodeUpdateStatus {
	s.NodeUpdateInitiatedBy = &v
	return s
}

// SetNodeUpdateInitiatedDate sets the NodeUpdateInitiatedDate field's value.
func (s *CacheNodeUpdateStatus) SetNodeUpdateInitiatedDate(v time.Time) *CacheNodeUpdateStatus {
	s.NodeUpdateInitiatedDate = &v
	return s
}

// SetNodeUpdateStartDate sets the NodeUpdateStartDate field's value.
func (s *CacheNodeUpdateStatus) SetNodeUpdateStartDate(v time.Time) *CacheNodeUpdateStatus {
	s.NodeUpdateStartDate = &v
	return s
}

// SetNodeUpdateStatus sets the NodeUpdateStatus field's value.
func (s *CacheNodeUpdateStatus) SetNodeUpdateStatus(v string) *CacheNodeUpdateStatus {
	s.NodeUpdateStatus = &v
	return s
}

// SetNodeUpdateStatusModifiedDate sets the NodeUpdateStatusModifiedDate field's value.
func (s *CacheNodeUpdateStatus) SetNodeUpdateStatusModifiedDate(v time.Time) *CacheNodeUpdateStatus {
	s.NodeUpdateStatusModifiedDate = &v
	return s
}

// Represents the output of a CreateCacheParameterGroup operation.
type CacheParameterGroup struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) of the cache parameter group.
	ARN *string `type:"string"`

	// The name of the cache parameter group family that this cache parameter group
	// is compatible with.
	//
	// Valid values are: memcached1.4 | memcached1.5 | redis2.6 | redis2.8 | redis3.2
	// | redis4.0 | redis5.0 |
	CacheParameterGroupFamily *string `type:"string"`

	// The name of the cache parameter group.
	CacheParameterGroupName *string `type:"string"`

	// The description for this cache parameter group.
	Description *string `type:"string"`

	// Indicates whether the parameter group is associated with a Global Datastore
	IsGlobal *bool `type:"boolean"`
}

// String returns the string representation
func (s CacheParameterGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheParameterGroup) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *CacheParameterGroup) SetARN(v string) *CacheParameterGroup {
	s.ARN = &v
	return s
}

// SetCacheParameterGroupFamily sets the CacheParameterGroupFamily field's value.
func (s *CacheParameterGroup) SetCacheParameterGroupFamily(v string) *CacheParameterGroup {
	s.CacheParameterGroupFamily = &v
	return s
}

// SetCacheParameterGroupName sets the CacheParameterGroupName field's value.
func (s *CacheParameterGroup) SetCacheParameterGroupName(v string) *CacheParameterGroup {
	s.CacheParameterGroupName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CacheParameterGroup) SetDescription(v string) *CacheParameterGroup {
	s.Description = &v
	return s
}

// SetIsGlobal sets the IsGlobal field's value.
func (s *CacheParameterGroup) SetIsGlobal(v bool) *CacheParameterGroup {
	s.IsGlobal = &v
	return s
}

// Represents the output of one of the following operations:
//
//    * ModifyCacheParameterGroup
//
//    * ResetCacheParameterGroup
type CacheParameterGroupNameMessage struct {
	_ struct{} `type:"structure"`

	// The name of the cache parameter group.
	CacheParameterGroupName *string `type:"string"`
}

// String returns the string representation
func (s CacheParameterGroupNameMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheParameterGroupNameMessage) GoString() string {
	return s.String()
}

// SetCacheParameterGroupName sets the CacheParameterGroupName field's value.
func (s *CacheParameterGroupNameMessage) SetCacheParameterGroupName(v string) *CacheParameterGroupNameMessage {
	s.CacheParameterGroupName = &v
	return s
}

// Status of the cache parameter group.
type CacheParameterGroupStatus struct {
	_ struct{} `type:"structure"`

	// A list of the cache node IDs which need to be rebooted for parameter changes
	// to be applied. A node ID is a numeric identifier (0001, 0002, etc.).
	CacheNodeIdsToReboot []*string `locationNameList:"CacheNodeId" type:"list"`

	// The name of the cache parameter group.
	CacheParameterGroupName *string `type:"string"`

	// The status of parameter updates.
	ParameterApplyStatus *string `type:"string"`
}

// String returns the string representation
func (s CacheParameterGroupStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheParameterGroupStatus) GoString() string {
	return s.String()
}

// SetCacheNodeIdsToReboot sets the CacheNodeIdsToReboot field's value.
func (s *CacheParameterGroupStatus) SetCacheNodeIdsToReboot(v []*string) *CacheParameterGroupStatus {
	s.CacheNodeIdsToReboot = v
	return s
}

// SetCacheParameterGroupName sets the CacheParameterGroupName field's value.
func (s *CacheParameterGroupStatus) SetCacheParameterGroupName(v string) *CacheParameterGroupStatus {
	s.CacheParameterGroupName = &v
	return s
}

// SetParameterApplyStatus sets the ParameterApplyStatus field's value.
func (s *CacheParameterGroupStatus) SetParameterApplyStatus(v string) *CacheParameterGroupStatus {
	s.ParameterApplyStatus = &v
	return s
}

// Represents the output of one of the following operations:
//
//    * AuthorizeCacheSecurityGroupIngress
//
//    * CreateCacheSecurityGroup
//
//    * RevokeCacheSecurityGroupIngress
type CacheSecurityGroup struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) of the cache security group.
	ARN *string `type:"string"`

	// The name of the cache security group.
	CacheSecurityGroupName *string `type:"string"`

	// The description of the cache security group.
	Description *string `type:"string"`

	// A list of Amazon EC2 security groups that are associated with this cache
	// security group.
	EC2SecurityGroups []*EC2SecurityGroup `locationNameList:"EC2SecurityGroup" type:"list"`

	// The AWS account ID of the cache security group owner.
	OwnerId *string `type:"string"`
}

// String returns the string representation
func (s CacheSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheSecurityGroup) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *CacheSecurityGroup) SetARN(v string) *CacheSecurityGroup {
	s.ARN = &v
	return s
}

// SetCacheSecurityGroupName sets the CacheSecurityGroupName field's value.
func (s *CacheSecurityGroup) SetCacheSecurityGroupName(v string) *CacheSecurityGroup {
	s.CacheSecurityGroupName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CacheSecurityGroup) SetDescription(v string) *CacheSecurityGroup {
	s.Description = &v
	return s
}

// SetEC2SecurityGroups sets the EC2SecurityGroups field's value.
func (s *CacheSecurityGroup) SetEC2SecurityGroups(v []*EC2SecurityGroup) *CacheSecurityGroup {
	s.EC2SecurityGroups = v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *CacheSecurityGroup) SetOwnerId(v string) *CacheSecurityGroup {
	s.OwnerId = &v
	return s
}

// Represents a cluster's status within a particular cache security group.
type CacheSecurityGroupMembership struct {
	_ struct{} `type:"structure"`

	// The name of the cache security group.
	CacheSecurityGroupName *string `type:"string"`

	// The membership status in the cache security group. The status changes when
	// a cache security group is modified, or when the cache security groups assigned
	// to a cluster are modified.
	Status *string `type:"string"`
}

// String returns the string representation
func (s CacheSecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheSecurityGroupMembership) GoString() string {
	return s.String()
}

// SetCacheSecurityGroupName sets the CacheSecurityGroupName field's value.
func (s *CacheSecurityGroupMembership) SetCacheSecurityGroupName(v string) *CacheSecurityGroupMembership {
	s.CacheSecurityGroupName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CacheSecurityGroupMembership) SetStatus(v string) *CacheSecurityGroupMembership {
	s.Status = &v
	return s
}

// Represents the output of one of the following operations:
//
//    * CreateCacheSubnetGroup
//
//    * ModifyCacheSubnetGroup
type CacheSubnetGroup struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) of the cache subnet group.
	ARN *string `type:"string"`

	// The description of the cache subnet group.
	CacheSubnetGroupDescription *string `type:"string"`

	// The name of the cache subnet group.
	CacheSubnetGroupName *string `type:"string"`

	// A list of subnets associated with the cache subnet group.
	Subnets []*Subnet `locationNameList:"Subnet" type:"list"`

	// The Amazon Virtual Private Cloud identifier (VPC ID) of the cache subnet
	// group.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s CacheSubnetGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheSubnetGroup) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *CacheSubnetGroup) SetARN(v string) *CacheSubnetGroup {
	s.ARN = &v
	return s
}

// SetCacheSubnetGroupDescription sets the CacheSubnetGroupDescription field's value.
func (s *CacheSubnetGroup) SetCacheSubnetGroupDescription(v string) *CacheSubnetGroup {
	s.CacheSubnetGroupDescription = &v
	return s
}

// SetCacheSubnetGroupName sets the CacheSubnetGroupName field's value.
func (s *CacheSubnetGroup) SetCacheSubnetGroupName(v string) *CacheSubnetGroup {
	s.CacheSubnetGroupName = &v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *CacheSubnetGroup) SetSubnets(v []*Subnet) *CacheSubnetGroup {
	s.Subnets = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CacheSubnetGroup) SetVpcId(v string) *CacheSubnetGroup {
	s.VpcId = &v
	return s
}

type CompleteMigrationInput struct {
	_ struct{} `type:"structure"`

	// Forces the migration to stop without ensuring that data is in sync. It is
	// recommended to use this option only to abort the migration and not recommended
	// when application wants to continue migration to ElastiCache.
	Force *bool `type:"boolean"`

	// The ID of the replication group to which data is being migrated.
	//
	// ReplicationGroupId is a required field
	ReplicationGroupId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CompleteMigrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompleteMigrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompleteMigrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CompleteMigrationInput"}
	if s.ReplicationGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationGroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForce sets the Force field's value.
func (s *CompleteMigrationInput) SetForce(v bool) *CompleteMigrationInput {
	s.Force = &v
	return s
}

// SetReplicationGroupId sets the ReplicationGroupId field's value.
func (s *CompleteMigrationInput) SetReplicationGroupId(v string) *CompleteMigrationInput {
	s.ReplicationGroupId = &v
	return s
}

type CompleteMigrationOutput struct {
	_ struct{} `type:"structure"`

	// Contains all of the attributes of a specific Redis replication group.
	ReplicationGroup *ReplicationGroup `type:"structure"`
}

// String returns the string representation
func (s CompleteMigrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompleteMigrationOutput) GoString() string {
	return s.String()
}

// SetReplicationGroup sets the ReplicationGroup field's value.
func (s *CompleteMigrationOutput) SetReplicationGroup(v *ReplicationGroup) *CompleteMigrationOutput {
	s.ReplicationGroup = v
	return s
}

// Node group (shard) configuration options when adding or removing replicas.
// Each node group (shard) configuration has the following members: NodeGroupId,
// NewReplicaCount, and PreferredAvailabilityZones.
type ConfigureShard struct {
	_ struct{} `type:"structure"`

	// The number of replicas you want in this node group at the end of this operation.
	// The maximum value for NewReplicaCount is 5. The minimum value depends upon
	// the type of Redis replication group you are working with.
	//
	// The minimum number of replicas in a shard or replication group is:
	//
	//    * Redis (cluster mode disabled) If Multi-AZ: 1 If Multi-AZ: 0
	//
	//    * Redis (cluster mode enabled): 0 (though you will not be able to failover
	//    to a replica if your primary node fails)
	//
	// NewReplicaCount is a required field
	NewReplicaCount *int64 `type:"integer" required:"true"`

	// The 4-digit id for the node group you are configuring. For Redis (cluster
	// mode disabled) replication groups, the node group id is always 0001. To find
	// a Redis (cluster mode enabled)'s node group's (shard's) id, see Finding a
	// Shard's Id (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/shard-find-id.html).
	//
	// NodeGroupId is a required field
	NodeGroupId *string `min:"1" type:"string" required:"true"`

	// A list of PreferredAvailabilityZone strings that specify which availability
	// zones the replication group's nodes are to be in. The nummber of PreferredAvailabilityZone
	// values must equal the value of NewReplicaCount plus 1 to account for the
	// primary node. If this member of ReplicaConfiguration is omitted, ElastiCache
	// for Redis selects the availability zone for each of the replicas.
	PreferredAvailabilityZones []*string `locationNameList:"PreferredAvailabilityZone" type:"list"`
}

// String returns the string representation
func (s ConfigureShard) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigureShard) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigureShard) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfigureShard"}
	if s.NewReplicaCount == nil {
		invalidParams.Add(request.NewErrParamRequired("NewReplicaCount"))
	}
	if s.NodeGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeGroupId"))
	}
	if s.NodeGroupId != nil && len(*s.NodeGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NodeGroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNewReplicaCount sets the NewReplicaCount field's value.
func (s *ConfigureShard) SetNewReplicaCount(v int64) *ConfigureShard {
	s.NewReplicaCount = &v
	return s
}

// SetNodeGroupId sets the NodeGroupId field's value.
func (s *ConfigureShard) SetNodeGroupId(v string) *ConfigureShard {
	s.NodeGroupId = &v
	return s
}

// SetPreferredAvailabilityZones sets the PreferredAvailabilityZones field's value.
func (s *ConfigureShard) SetPreferredAvailabilityZones(v []*string) *ConfigureShard {
	s.PreferredAvailabilityZones = v
	return s
}

// Represents the input of a CopySnapshotMessage operation.
type CopySnapshotInput struct {
	_ struct{} `type:"structure"`

	// The ID of the KMS key used to encrypt the target snapshot.
	KmsKeyId *string `type:"string"`

	// The name of an existing snapshot from which to make a copy.
	//
	// SourceSnapshotName is a required field
	SourceSnapshotName *string `type:"string" required:"true"`

	// The Amazon S3 bucket to which the snapshot is exported. This parameter is
	// used only when exporting a snapshot for external access.
	//
	// When using this parameter to export a snapshot, be sure Amazon ElastiCache
	// has the needed permissions to this S3 bucket. For more information, see Step
	// 2: Grant ElastiCache Access to Your Amazon S3 Bucket (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access)
	// in the Amazon ElastiCache User Guide.
	//
	// For more information, see Exporting a Snapshot (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Snapshots.Exporting.html)
	// in the Amazon ElastiCache User Guide.
	TargetBucket *string `type:"string"`

	// A name for the snapshot copy. ElastiCache does not permit overwriting a snapshot,
	// therefore this name must be unique within its context - ElastiCache or an
	// Amazon S3 bucket if exporting.
	//
	// TargetSnapshotName is a required field
	TargetSnapshotName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopySnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopySnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopySnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopySnapshotInput"}
	if s.SourceSnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceSnapshotName"))
	}
	if s.TargetSnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetSnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CopySnapshotInput) SetKmsKeyId(v string) *CopySnapshotInput {
	s.KmsKeyId = &v
	return s
}

// SetSourceSnapshotName sets the SourceSnapshotName field's value.
func (s *CopySnapshotInput) SetSourceSnapshotName(v string) *CopySnapshotInput {
	s.SourceSnapshotName = &v
	return s
}

// SetTargetBucket sets the TargetBucket field's value.
func (s *CopySnapshotInput) SetTargetBucket(v string) *CopySnapshotInput {
	s.TargetBucket = &v
	return s
}

// SetTargetSnapshotName sets the TargetSnapshotName field's value.
func (s *CopySnapshotInput) SetTargetSnapshotName(v string) *CopySnapshotInput {
	s.TargetSnapshotName = &v
	return s
}

type CopySnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Represents a copy of an entire Redis cluster as of the time when the snapshot
	// was taken.
	Snapshot *Snapshot `type:"structure"`
}

// String returns the string representation
func (s CopySnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopySnapshotOutput) GoString() string {
	return s.String()
}

// SetSnapshot sets the Snapshot field's value.
func (s *CopySnapshotOutput) SetSnapshot(v *Snapshot) *CopySnapshotOutput {
	s.Snapshot = v
	return s
}

// Represents the input of a CreateCacheCluster operation.
type CreateCacheClusterInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the nodes in this Memcached cluster are created in a single
	// Availability Zone or created across multiple Availability Zones in the cluster's
	// region.
	//
	// This parameter is only supported for Memcached clusters.
	//
	// If the AZMode and PreferredAvailabilityZones are not specified, ElastiCache
	// assumes single-az mode.
	AZMode *string `type:"string" enum:"AZMode"`

	// Reserved parameter. The password used to access a password protected server.
	//
	// Password constraints:
	//
	//    * Must be only printable ASCII characters.
	//
	//    * Must be at least 16 characters and no more than 128 characters in length.
	//
	//    * The only permitted printable special characters are !, &, #, $, ^, <,
	//    >, and -. Other printable special characters cannot be used in the AUTH
	//    token.
	//
	// For more information, see AUTH password (http://redis.io/commands/AUTH) at
	// http://redis.io/commands/AUTH.
	AuthToken *string `type:"string"`

	// This parameter is currently disabled.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The node group (shard) identifier. This parameter is stored as a lowercase
	// string.
	//
	// Constraints:
	//
	//    * A name must contain from 1 to 50 alphanumeric characters or hyphens.
	//
	//    * The first character must be a letter.
	//
	//    * A name cannot end with a hyphen or contain two consecutive hyphens.
	//
	// CacheClusterId is a required field
	CacheClusterId *string `type:"string" required:"true"`

	// The compute and memory capacity of the nodes in the node group (shard).
	//
	// The following node types are supported by ElastiCache. Generally speaking,
	// the current generation types provide more memory and computational power
	// at lower cost when compared to their equivalent previous generation counterparts.
	//
	//    * General purpose: Current generation: M5 node types: cache.m5.large,
	//    cache.m5.xlarge, cache.m5.2xlarge, cache.m5.4xlarge, cache.m5.12xlarge,
	//    cache.m5.24xlarge M4 node types: cache.m4.large, cache.m4.xlarge, cache.m4.2xlarge,
	//    cache.m4.4xlarge, cache.m4.10xlarge T3 node types: cache.t3.micro, cache.t3.small,
	//    cache.t3.medium T2 node types: cache.t2.micro, cache.t2.small, cache.t2.medium
	//    Previous generation: (not recommended) T1 node types: cache.t1.micro M1
	//    node types: cache.m1.small, cache.m1.medium, cache.m1.large, cache.m1.xlarge
	//    M3 node types: cache.m3.medium, cache.m3.large, cache.m3.xlarge, cache.m3.2xlarge
	//
	//    * Compute optimized: Previous generation: (not recommended) C1 node types:
	//    cache.c1.xlarge
	//
	//    * Memory optimized: Current generation: R5 node types: cache.r5.large,
	//    cache.r5.xlarge, cache.r5.2xlarge, cache.r5.4xlarge, cache.r5.12xlarge,
	//    cache.r5.24xlarge R4 node types: cache.r4.large, cache.r4.xlarge, cache.r4.2xlarge,
	//    cache.r4.4xlarge, cache.r4.8xlarge, cache.r4.16xlarge Previous generation:
	//    (not recommended) M2 node types: cache.m2.xlarge, cache.m2.2xlarge, cache.m2.4xlarge
	//    R3 node types: cache.r3.large, cache.r3.xlarge, cache.r3.2xlarge, cache.r3.4xlarge,
	//    cache.r3.8xlarge
	//
	// Additional node type info
	//
	//    * All current generation instance types are created in Amazon VPC by default.
	//
	//    * Redis append-only files (AOF) are not supported for T1 or T2 instances.
	//
	//    * Redis Multi-AZ with automatic failover is not supported on T1 instances.
	//
	//    * Redis configuration variables appendonly and appendfsync are not supported
	//    on Redis version 2.8.22 and later.
	CacheNodeType *string `type:"string"`

	// The name of the parameter group to associate with this cluster. If this argument
	// is omitted, the default parameter group for the specified engine is used.
	// You cannot use any parameter group which has cluster-enabled='yes' when creating
	// a cluster.
	CacheParameterGroupName *string `type:"string"`

	// A list of security group names to associate with this cluster.
	//
	// Use this parameter only when you are creating a cluster outside of an Amazon
	// Virtual Private Cloud (Amazon VPC).
	CacheSecurityGroupNames []*string `locationNameList:"CacheSecurityGroupName" type:"list"`

	// The name of the subnet group to be used for the cluster.
	//
	// Use this parameter only when you are creating a cluster in an Amazon Virtual
	// Private Cloud (Amazon VPC).
	//
	// If you're going to launch your cluster in an Amazon VPC, you need to create
	// a subnet group before you start creating a cluster. For more information,
	// see Subnets and Subnet Groups (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html).
	CacheSubnetGroupName *string `type:"string"`

	// The name of the cache engine to be used for this cluster.
	//
	// Valid values for this parameter are: memcached | redis
	Engine *string `type:"string"`

	// The version number of the cache engine to be used for this cluster. To view
	// the supported cache engine versions, use the DescribeCacheEngineVersions
	// operation.
	//
	// Important: You can upgrade to a newer engine version (see Selecting a Cache
	// Engine and Version (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement)),
	// but you cannot downgrade to an earlier engine version. If you want to use
	// an earlier engine version, you must delete the existing cluster or replication
	// group and create it anew with the earlier engine version.
	EngineVersion *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
	// (SNS) topic to which notifications are sent.
	//
	// The Amazon SNS topic owner must be the same as the cluster owner.
	NotificationTopicArn *string `type:"string"`

	// The initial number of cache nodes that the cluster has.
	//
	// For clusters running Redis, this value must be 1. For clusters running Memcached,
	// this value must be between 1 and 20.
	//
	// If you need more than 20 nodes for your Memcached cluster, please fill out
	// the ElastiCache Limit Increase Request form at http://aws.amazon.com/contact-us/elasticache-node-limit-request/
	// (http://aws.amazon.com/contact-us/elasticache-node-limit-request/).
	NumCacheNodes *int64 `type:"integer"`

	// The port number on which each of the cache nodes accepts connections.
	Port *int64 `type:"integer"`

	// The EC2 Availability Zone in which the cluster is created.
	//
	// All nodes belonging to this cluster are placed in the preferred Availability
	// Zone. If you want to create your nodes across multiple Availability Zones,
	// use PreferredAvailabilityZones.
	//
	// Default: System chosen Availability Zone.
	PreferredAvailabilityZone *string `type:"string"`

	// A list of the Availability Zones in which cache nodes are created. The order
	// of the zones in the list is not important.
	//
	// This option is only supported on Memcached.
	//
	// If you are creating your cluster in an Amazon VPC (recommended) you can only
	// locate nodes in Availability Zones that are associated with the subnets in
	// the selected subnet group.
	//
	// The number of Availability Zones listed must equal the value of NumCacheNodes.
	//
	// If you want all the nodes in the same Availability Zone, use PreferredAvailabilityZone
	// instead, or repeat the Availability Zone multiple times in the list.
	//
	// Default: System chosen Availability Zones.
	PreferredAvailabilityZones []*string `locationNameList:"PreferredAvailabilityZone" type:"list"`

	// Specifies the weekly time range during which maintenance on the cluster is
	// performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi
	// (24H Clock UTC). The minimum maintenance window is a 60 minute period. Valid
	// values for ddd are:
	//
	// Specifies the weekly time range during which maintenance on the cluster is
	// performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi
	// (24H Clock UTC). The minimum maintenance window is a 60 minute period.
	//
	// Valid values for ddd are:
	//
	//    * sun
	//
	//    * mon
	//
	//    * tue
	//
	//    * wed
	//
	//    * thu
	//
	//    * fri
	//
	//    * sat
	//
	// Example: sun:23:00-mon:01:30
	PreferredMaintenanceWindow *string `type:"string"`

	// The ID of the replication group to which this cluster should belong. If this
	// parameter is specified, the cluster is added to the specified replication
	// group as a read replica; otherwise, the cluster is a standalone primary that
	// is not part of any replication group.
	//
	// If the specified replication group is Multi-AZ enabled and the Availability
	// Zone is not specified, the cluster is created in Availability Zones that
	// provide the best spread of read replicas across Availability Zones.
	//
	// This parameter is only valid if the Engine parameter is redis.
	ReplicationGroupId *string `type:"string"`

	// One or more VPC security groups associated with the cluster.
	//
	// Use this parameter only when you are creating a cluster in an Amazon Virtual
	// Private Cloud (Amazon VPC).
	SecurityGroupIds []*string `locationNameList:"SecurityGroupId" type:"list"`

	// A single-element string list containing an Amazon Resource Name (ARN) that
	// uniquely identifies a Redis RDB snapshot file stored in Amazon S3. The snapshot
	// file is used to populate the node group (shard). The Amazon S3 object name
	// in the ARN cannot contain any commas.
	//
	// This parameter is only valid if the Engine parameter is redis.
	//
	// Example of an Amazon S3 ARN: arn:aws:s3:::my_bucket/snapshot1.rdb
	SnapshotArns []*string `locationNameList:"SnapshotArn" type:"list"`

	// The name of a Redis snapshot from which to restore data into the new node
	// group (shard). The snapshot status changes to restoring while the new node
	// group (shard) is being created.
	//
	// This parameter is only valid if the Engine parameter is redis.
	SnapshotName *string `type:"string"`

	// The number of days for which ElastiCache retains automatic snapshots before
	// deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot
	// taken today is retained for 5 days before being deleted.
	//
	// This parameter is only valid if the Engine parameter is redis.
	//
	// Default: 0 (i.e., automatic backups are disabled for this cache cluster).
	SnapshotRetentionLimit *int64 `type:"integer"`

	// The daily time range (in UTC) during which ElastiCache begins taking a daily
	// snapshot of your node group (shard).
	//
	// Example: 05:00-09:00
	//
	// If you do not specify this parameter, ElastiCache automatically chooses an
	// appropriate time range.
	//
	// This parameter is only valid if the Engine parameter is redis.
	SnapshotWindow *string `type:"string"`

	// A list of cost allocation tags to be added to this resource.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateCacheClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCacheClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCacheClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCacheClusterInput"}
	if s.CacheClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("CacheClusterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAZMode sets the AZMode field's value.
func (s *CreateCacheClusterInput) SetAZMode(v string) *CreateCacheClusterInput {
	s.AZMode = &v
	return s
}

// SetAuthToken sets the AuthToken field's value.
func (s *CreateCacheClusterInput) SetAuthToken(v string) *CreateCacheClusterInput {
	s.AuthToken = &v
	return s
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *CreateCacheClusterInput) SetAutoMinorVersionUpgrade(v bool) *CreateCacheClusterInput {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetCacheClusterId sets the CacheClusterId field's value.
func (s *CreateCacheClusterInput) SetCacheClusterId(v string) *CreateCacheClusterInput {
	s.CacheClusterId = &v
	return s
}

// SetCacheNodeType sets the CacheNodeType field's value.
func (s *CreateCacheClusterInput) SetCacheNodeType(v string) *CreateCacheClusterInput {
	s.CacheNodeType = &v
	return s
}

// SetCacheParameterGroupName sets the CacheParameterGroupName field's value.
func (s *CreateCacheClusterInput) SetCacheParameterGroupName(v string) *CreateCacheClusterInput {
	s.CacheParameterGroupName = &v
	return s
}

// SetCacheSecurityGroupNames sets the CacheSecurityGroupNames field's value.
func (s *CreateCacheClusterInput) SetCacheSecurityGroupNames(v []*string) *CreateCacheClusterInput {
	s.CacheSecurityGroupNames = v
	return s
}

// SetCacheSubnetGroupName sets the CacheSubnetGroupName field's value.
func (s *CreateCacheClusterInput) SetCacheSubnetGroupName(v string) *CreateCacheClusterInput {
	s.CacheSubnetGroupName = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *CreateCacheClusterInput) SetEngine(v string) *CreateCacheClusterInput {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *CreateCacheClusterInput) SetEngineVersion(v string) *CreateCacheClusterInput {
	s.EngineVersion = &v
	return s
}

// SetNotificationTopicArn sets the NotificationTopicArn field's value.
func (s *CreateCacheClusterInput) SetNotificationTopicArn(v string) *CreateCacheClusterInput {
	s.NotificationTopicArn = &v
	return s
}

// SetNumCacheNodes sets the NumCacheNodes field's value.
func (s *CreateCacheClusterInput) SetNumCacheNodes(v int64) *CreateCacheClusterInput {
	s.NumCacheNodes = &v
	return s
}

// SetPort sets the Port field's value.
func (s *CreateCacheClusterInput) SetPort(v int64) *CreateCacheClusterInput {
	s.Port = &v
	return s
}

// SetPreferredAvailabilityZone sets the PreferredAvailabilityZone field's value.
func (s *CreateCacheClusterInput) SetPreferredAvailabilityZone(v string) *CreateCacheClusterInput {
	s.PreferredAvailabilityZone = &v
	return s
}

// SetPreferredAvailabilityZones sets the PreferredAvailabilityZones field's value.
func (s *CreateCacheClusterInput) SetPreferredAvailabilityZones(v []*string) *CreateCacheClusterInput {
	s.PreferredAvailabilityZones = v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *CreateCacheClusterInput) SetPreferredMaintenanceWindow(v string) *CreateCacheClusterInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetReplicationGroupId sets the ReplicationGroupId field's value.
func (s *CreateCacheClusterInput) SetReplicationGroupId(v string) *CreateCacheClusterInput {
	s.ReplicationGroupId = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *CreateCacheClusterInput) SetSecurityGroupIds(v []*string) *CreateCacheClusterInput {
	s.SecurityGroupIds = v
	return s
}

// SetSnapshotArns sets the SnapshotArns field's value.
func (s *CreateCacheClusterInput) SetSnapshotArns(v []*string) *CreateCacheClusterInput {
	s.SnapshotArns = v
	return s
}

// SetSnapshotName sets the SnapshotName field's value.
func (s *CreateCacheClusterInput) SetSnapshotName(v string) *CreateCacheClusterInput {
	s.SnapshotName = &v
	return s
}

// SetSnapshotRetentionLimit sets the SnapshotRetentionLimit field's value.
func (s *CreateCacheClusterInput) SetSnapshotRetentionLimit(v int64) *CreateCacheClusterInput {
	s.SnapshotRetentionLimit = &v
	return s
}

// SetSnapshotWindow sets the SnapshotWindow field's value.
func (s *CreateCacheClusterInput) SetSnapshotWindow(v string) *CreateCacheClusterInput {
	s.SnapshotWindow = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCacheClusterInput) SetTags(v []*Tag) *CreateCacheClusterInput {
	s.Tags = v
	return s
}

type CreateCacheClusterOutput struct {
	_ struct{} `type:"structure"`

	// Contains all of the attributes of a specific cluster.
	CacheCluster *CacheCluster `type:"structure"`
}

// String returns the string representation
func (s CreateCacheClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCacheClusterOutput) GoString() string {
	return s.String()
}

// SetCacheCluster sets the CacheCluster field's value.
func (s *CreateCacheClusterOutput) SetCacheCluster(v *CacheCluster) *CreateCacheClusterOutput {
	s.CacheCluster = v
	return s
}

// Represents the input of a CreateCacheParameterGroup operation.
type CreateCacheParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the cache parameter group family that the cache parameter group
	// can be used with.
	//
	// Valid values are: memcached1.4 | memcached1.5 | redis2.6 | redis2.8 | redis3.2
	// | redis4.0 | redis5.0 |
	//
	// CacheParameterGroupFamily is a required field
	CacheParameterGroupFamily *string `type:"string" required:"true"`

	// A user-specified name for the cache parameter group.
	//
	// CacheParameterGroupName is a required field
	CacheParameterGroupName *string `type:"string" required:"true"`

	// A user-specified description for the cache parameter group.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateCacheParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCacheParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCacheParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCacheParameterGroupInput"}
	if s.CacheParameterGroupFamily == nil {
		invalidParams.Add(request.NewErrParamRequired("CacheParameterGroupFamily"))
	}
	if s.CacheParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("CacheParameterGroupName"))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCacheParameterGroupFamily sets the CacheParameterGroupFamily field's value.
func (s *CreateCacheParameterGroupInput) SetCacheParameterGroupFamily(v string) *CreateCacheParameterGroupInput {
	s.CacheParameterGroupFamily = &v
	return s
}

// SetCacheParameterGroupName sets the CacheParameterGroupName field's value.
func (s *CreateCacheParameterGroupInput) SetCacheParameterGroupName(v string) *CreateCacheParameterGroupInput {
	s.CacheParameterGroupName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateCacheParameterGroupInput) SetDescription(v string) *CreateCacheParameterGroupInput {
	s.Description = &v
	return s
}

type CreateCacheParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// Represents the output of a CreateCacheParameterGroup operation.
	CacheParameterGroup *CacheParameterGroup `type:"structure"`
}

// String returns the string representation
func (s CreateCacheParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCacheParameterGroupOutput) GoString() string {
	return s.String()
}

// SetCacheParameterGroup sets the CacheParameterGroup field's value.
func (s *CreateCacheParameterGroupOutput) SetCacheParameterGroup(v *CacheParameterGroup) *CreateCacheParameterGroupOutput {
	s.CacheParameterGroup = v
	return s
}

// Represents the input of a CreateCacheSecurityGroup operation.
type CreateCacheSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	// A name for the cache security group. This value is stored as a lowercase
	// string.
	//
	// Constraints: Must contain no more than 255 alphanumeric characters. Cannot
	// be the word "Default".
	//
	// Example: mysecuritygroup
	//
	// CacheSecurityGroupName is a required field
	CacheSecurityGroupName *string `type:"string" required:"true"`

	// A description for the cache security group.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateCacheSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCacheSecurityGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCacheSecurityGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCacheSecurityGroupInput"}
	if s.CacheSecurityGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("CacheSecurityGroupName"))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCacheSecurityGroupName sets the CacheSecurityGroupName field's value.
func (s *CreateCacheSecurityGroupInput) SetCacheSecurityGroupName(v string) *CreateCacheSecurityGroupInput {
	s.CacheSecurityGroupName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateCacheSecurityGroupInput) SetDescription(v string) *CreateCacheSecurityGroupInput {
	s.Description = &v
	return s
}

type CreateCacheSecurityGroupOutput struct {
	_ struct{} `type:"structure"`

	// Represents the output of one of the following operations:
	//
	//    * AuthorizeCacheSecurityGroupIngress
	//
	//    * CreateCacheSecurityGroup
	//
	//    * RevokeCacheSecurityGroupIngress
	CacheSecurityGroup *CacheSecurityGroup `type:"structure"`
}

// String returns the string representation
func (s CreateCacheSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCacheSecurityGroupOutput) GoString() string {
	return s.String()
}

// SetCacheSecurityGroup sets the CacheSecurityGroup field's value.
func (s *CreateCacheSecurityGroupOutput) SetCacheSecurityGroup(v *CacheSecurityGroup) *CreateCacheSecurityGroupOutput {
	s.CacheSecurityGroup = v
	return s
}

// Represents the input of a CreateCacheSubnetGroup operation.
type CreateCacheSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// A description for the cache subnet group.
	//
	// CacheSubnetGroupDescription is a required field
	CacheSubnetGroupDescription *string `type:"string" required:"true"`

	// A name for the cache subnet group. This value is stored as a lowercase string.
	//
	// Constraints: Must contain no more than 255 alphanumeric characters or hyphens.
	//
	// Example: mysubnetgroup
	//
	// CacheSubnetGroupName is a required field
	CacheSubnetGroupName *string `type:"string" required:"true"`

	// A list of VPC subnet IDs for the cache subnet group.
	//
	// SubnetIds is a required field
	SubnetIds []*string `locationNameList:"SubnetIdentifier" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateCacheSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCacheSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCacheSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCacheSubnetGroupInput"}
	if s.CacheSubnetGroupDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("CacheSubnetGroupDescription"))
	}
	if s.CacheSubnetGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("CacheSubnetGroupName"))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCacheSubnetGroupDescription sets the CacheSubnetGroupDescription field's value.
func (s *CreateCacheSubnetGroupInput) SetCacheSubnetGroupDescription(v string) *CreateCacheSubnetGroupInput {
	s.CacheSubnetGroupDescription = &v
	return s
}

// SetCacheSubnetGroupName sets the CacheSubnetGroupName field's value.
func (s *CreateCacheSubnetGroupInput) SetCacheSubnetGroupName(v string) *CreateCacheSubnetGroupInput {
	s.CacheSubnetGroupName = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *CreateCacheSubnetGroupInput) SetSubnetIds(v []*string) *CreateCacheSubnetGroupInput {
	s.SubnetIds = v
	return s
}

type CreateCacheSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// Represents the output of one of the following operations:
	//
	//    * CreateCacheSubnetGroup
	//
	//    * ModifyCacheSubnetGroup
	CacheSubnetGroup *CacheSubnetGroup `type:"structure"`
}

// String returns the string representation
func (s CreateCacheSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCacheSubnetGroupOutput) GoString() string {
	return s.String()
}

// SetCacheSubnetGroup sets the CacheSubnetGroup field's value.
func (s *CreateCacheSubnetGroupOutput) SetCacheSubnetGroup(v *CacheSubnetGroup) *CreateCacheSubnetGroupOutput {
	s.CacheSubnetGroup = v
	return s
}

type CreateGlobalReplicationGroupInput struct {
	_ struct{} `type:"structure"`

	// Provides details of the Global Datastore
	GlobalReplicationGroupDescription *string `type:"string"`

	// The suffix name of a Global Datastore. The suffix guarantees uniqueness of
	// the Global Datastore name across multiple regions.
	//
	// GlobalReplicationGroupIdSuffix is a required field
	GlobalReplicationGroupIdSuffix *string `type:"string" required:"true"`

	// The name of the primary cluster that accepts writes and will replicate updates
	// to the secondary cluster.
	//
	// PrimaryReplicationGroupId is a required field
	PrimaryReplicationGroupId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateGlobalReplicationGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGlobalReplicationGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGlobalReplicationGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGlobalReplicationGroupInput"}
	if s.GlobalReplicationGroupIdSuffix == nil {
		invalidParams.Add(request.NewErrParamRequired("GlobalReplicationGroupIdSuffix"))
	}
	if s.PrimaryReplicationGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrimaryReplicationGroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGlobalReplicationGroupDescription sets the GlobalReplicationGroupDescription field's value.
func (s *CreateGlobalReplicationGroupInput) SetGlobalReplicationGroupDescription(v string) *CreateGlobalReplicationGroupInput {
	s.GlobalReplicationGroupDescription = &v
	return s
}

// SetGlobalReplicationGroupIdSuffix sets the GlobalReplicationGroupIdSuffix field's value.
func (s *CreateGlobalReplicationGroupInput) SetGlobalReplicationGroupIdSuffix(v string) *CreateGlobalReplicationGroupInput {
	s.GlobalReplicationGroupIdSuffix = &v
	return s
}

// SetPrimaryReplicationGroupId sets the PrimaryReplicationGroupId field's value.
func (s *CreateGlobalReplicationGroupInput) SetPrimaryReplicationGroupId(v string) *CreateGlobalReplicationGroupInput {
	s.PrimaryReplicationGroupId = &v
	return s
}

type CreateGlobalReplicationGroupOutput struct {
	_ struct{} `type:"structure"`

	// Consists of a primary cluster that accepts writes and an associated secondary
	// cluster that resides in a different AWS region. The secondary cluster accepts
	// only reads. The primary cluster automatically replicates updates to the secondary
	// cluster.
	//
	//    * The GlobalReplicationGroupIdSuffix represents the name of the Global
	//    Datastore, which is what you use to associate a secondary cluster.
	GlobalReplicationGroup *GlobalReplicationGroup `type:"structure"`
}

// String returns the string representation
func (s CreateGlobalReplicationGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGlobalReplicationGroupOutput) GoString() string {
	return s.String()
}

// SetGlobalReplicationGroup sets the GlobalReplicationGroup field's value.
func (s *CreateGlobalReplicationGroupOutput) SetGlobalReplicationGroup(v *GlobalReplicationGroup) *CreateGlobalReplicationGroupOutput {
	s.GlobalReplicationGroup = v
	return s
}

// Represents the input of a CreateReplicationGroup operation.
type CreateReplicationGroupInput struct {
	_ struct{} `type:"structure"`

	// A flag that enables encryption at rest when set to true.
	//
	// You cannot modify the value of AtRestEncryptionEnabled after the replication
	// group is created. To enable encryption at rest on a replication group you
	// must set AtRestEncryptionEnabled to true when you create the replication
	// group.
	//
	// Required: Only available when creating a replication group in an Amazon VPC
	// using redis version 3.2.6, 4.x or later.
	//
	// Default: false
	AtRestEncryptionEnabled *bool `type:"boolean"`

	// Reserved parameter. The password used to access a password protected server.
	//
	// AuthToken can be specified only on replication groups where TransitEncryptionEnabled
	// is true.
	//
	// For HIPAA compliance, you must specify TransitEncryptionEnabled as true,
	// an AuthToken, and a CacheSubnetGroup.
	//
	// Password constraints:
	//
	//    * Must be only printable ASCII characters.
	//
	//    * Must be at least 16 characters and no more than 128 characters in length.
	//
	//    * The only permitted printable special characters are !, &, #, $, ^, <,
	//    >, and -. Other printable special characters cannot be used in the AUTH
	//    token.
	//
	// For more information, see AUTH password (http://redis.io/commands/AUTH) at
	// http://redis.io/commands/AUTH.
	AuthToken *string `type:"string"`

	// This parameter is currently disabled.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// Specifies whether a read-only replica is automatically promoted to read/write
	// primary if the existing primary fails.
	//
	// AutomaticFailoverEnabled must be enabled for Redis (cluster mode enabled)
	// replication groups.
	//
	// Default: false
	AutomaticFailoverEnabled *bool `type:"boolean"`

	// The compute and memory capacity of the nodes in the node group (shard).
	//
	// The following node types are supported by ElastiCache. Generally speaking,
	// the current generation types provide more memory and computational power
	// at lower cost when compared to their equivalent previous generation counterparts.
	//
	//    * General purpose: Current generation: M5 node types: cache.m5.large,
	//    cache.m5.xlarge, cache.m5.2xlarge, cache.m5.4xlarge, cache.m5.12xlarge,
	//    cache.m5.24xlarge M4 node types: cache.m4.large, cache.m4.xlarge, cache.m4.2xlarge,
	//    cache.m4.4xlarge, cache.m4.10xlarge T3 node types: cache.t3.micro, cache.t3.small,
	//    cache.t3.medium T2 node types: cache.t2.micro, cache.t2.small, cache.t2.medium
	//    Previous generation: (not recommended) T1 node types: cache.t1.micro M1
	//    node types: cache.m1.small, cache.m1.medium, cache.m1.large, cache.m1.xlarge
	//    M3 node types: cache.m3.medium, cache.m3.large, cache.m3.xlarge, cache.m3.2xlarge
	//
	//    * Compute optimized: Previous generation: (not recommended) C1 node types:
	//    cache.c1.xlarge
	//
	//    * Memory optimized: Current generation: R5 node types: cache.r5.large,
	//    cache.r5.xlarge, cache.r5.2xlarge, cache.r5.4xlarge, cache.r5.12xlarge,
	//    cache.r5.24xlarge R4 node types: cache.r4.large, cache.r4.xlarge, cache.r4.2xlarge,
	//    cache.r4.4xlarge, cache.r4.8xlarge, cache.r4.16xlarge Previous generation:
	//    (not recommended) M2 node types: cache.m2.xlarge, cache.m2.2xlarge, cache.m2.4xlarge
	//    R3 node types: cache.r3.large, cache.r3.xlarge, cache.r3.2xlarge, cache.r3.4xlarge,
	//    cache.r3.8xlarge
	//
	// Additional node type info
	//
	//    * All current generation instance types are created in Amazon VPC by default.
	//
	//    * Redis append-only files (AOF) are not supported for T1 or T2 instances.
	//
	//    * Redis Multi-AZ with automatic failover is not supported on T1 instances.
	//
	//    * Redis configuration variables appendonly and appendfsync are not supported
	//    on Redis version 2.8.22 and later.
	CacheNodeType *string `type:"string"`

	// The name of the parameter group to associate with this replication group.
	// If this argument is omitted, the default cache parameter group for the specified
	// engine is used.
	//
	// If you are restoring to an engine version that is different than the original,
	// you must specify the default version of that version. For example, CacheParameterGroupName=default.redis4.0.
	//
	// If you are running Redis version 3.2.4 or later, only one node group (shard),
	// and want to use a default parameter group, we recommend that you specify
	// the parameter group by name.
	//
	//    * To create a Redis (cluster mode disabled) replication group, use CacheParameterGroupName=default.redis3.2.
	//
	//    * To create a Redis (cluster mode enabled) replication group, use CacheParameterGroupName=default.redis3.2.cluster.on.
	CacheParameterGroupName *string `type:"string"`

	// A list of cache security group names to associate with this replication group.
	CacheSecurityGroupNames []*string `locationNameList:"CacheSecurityGroupName" type:"list"`

	// The name of the cache subnet group to be used for the replication group.
	//
	// If you're going to launch your cluster in an Amazon VPC, you need to create
	// a subnet group before you start creating a cluster. For more information,
	// see Subnets and Subnet Groups (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html).
	CacheSubnetGroupName *string `type:"string"`

	// The name of the cache engine to be used for the clusters in this replication
	// group.
	Engine *string `type:"string"`

	// The version number of the cache engine to be used for the clusters in this
	// replication group. To view the supported cache engine versions, use the DescribeCacheEngineVersions
	// operation.
	//
	// Important: You can upgrade to a newer engine version (see Selecting a Cache
	// Engine and Version (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement))
	// in the ElastiCache User Guide, but you cannot downgrade to an earlier engine
	// version. If you want to use an earlier engine version, you must delete the
	// existing cluster or replication group and create it anew with the earlier
	// engine version.
	EngineVersion *string `type:"string"`

	// The name of the Global Datastore
	GlobalReplicationGroupId *string `type:"string"`

	// The ID of the KMS key used to encrypt the disk in the cluster.
	KmsKeyId *string `type:"string"`

	// A flag indicating if you have Multi-AZ enabled to enhance fault tolerance.
	// For more information, see Minimizing Downtime: Multi-AZ (http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html).
	MultiAZEnabled *bool `type:"boolean"`

	// A list of node group (shard) configuration options. Each node group (shard)
	// configuration has the following members: PrimaryAvailabilityZone, ReplicaAvailabilityZones,
	// ReplicaCount, and Slots.
	//
	// If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode
	// enabled) replication group, you can use this parameter to individually configure
	// each node group (shard), or you can omit this parameter. However, it is required
	// when seeding a Redis (cluster mode enabled) cluster from a S3 rdb file. You
	// must configure each node group (shard) using this parameter because you must
	// specify the slots for each node group.
	NodeGroupConfiguration []*NodeGroupConfiguration `locationNameList:"NodeGroupConfiguration" type:"list"`

	// The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
	// (SNS) topic to which notifications are sent.
	//
	// The Amazon SNS topic owner must be the same as the cluster owner.
	NotificationTopicArn *string `type:"string"`

	// The number of clusters this replication group initially has.
	//
	// This parameter is not used if there is more than one node group (shard).
	// You should use ReplicasPerNodeGroup instead.
	//
	// If AutomaticFailoverEnabled is true, the value of this parameter must be
	// at least 2. If AutomaticFailoverEnabled is false you can omit this parameter
	// (it will default to 1), or you can explicitly set it to a value between 2
	// and 6.
	//
	// The maximum permitted value for NumCacheClusters is 6 (1 primary plus 5 replicas).
	NumCacheClusters *int64 `type:"integer"`

	// An optional parameter that specifies the number of node groups (shards) for
	// this Redis (cluster mode enabled) replication group. For Redis (cluster mode
	// disabled) either omit this parameter or set it to 1.
	//
	// Default: 1
	NumNodeGroups *int64 `type:"integer"`

	// The port number on which each member of the replication group accepts connections.
	Port *int64 `type:"integer"`

	// A list of EC2 Availability Zones in which the replication group's clusters
	// are created. The order of the Availability Zones in the list is the order
	// in which clusters are allocated. The primary cluster is created in the first
	// AZ in the list.
	//
	// This parameter is not used if there is more than one node group (shard).
	// You should use NodeGroupConfiguration instead.
	//
	// If you are creating your replication group in an Amazon VPC (recommended),
	// you can only locate clusters in Availability Zones associated with the subnets
	// in the selected subnet group.
	//
	// The number of Availability Zones listed must equal the value of NumCacheClusters.
	//
	// Default: system chosen Availability Zones.
	PreferredCacheClusterAZs []*string `locationNameList:"AvailabilityZone" type:"list"`

	// Specifies the weekly time range during which maintenance on the cluster is
	// performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi
	// (24H Clock UTC). The minimum maintenance window is a 60 minute period. Valid
	// values for ddd are:
	//
	// Specifies the weekly time range during which maintenance on the cluster is
	// performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi
	// (24H Clock UTC). The minimum maintenance window is a 60 minute period.
	//
	// Valid values for ddd are:
	//
	//    * sun
	//
	//    * mon
	//
	//    * tue
	//
	//    * wed
	//
	//    * thu
	//
	//    * fri
	//
	//    * sat
	//
	// Example: sun:23:00-mon:01:30
	PreferredMaintenanceWindow *string `type:"string"`

	// The identifier of the cluster that serves as the primary for this replication
	// group. This cluster must already exist and have a status of available.
	//
	// This parameter is not required if NumCacheClusters, NumNodeGroups, or ReplicasPerNodeGroup
	// is specified.
	PrimaryClusterId *string `type:"string"`

	// An optional parameter that specifies the number of replica nodes in each
	// node group (shard). Valid values are 0 to 5.
	ReplicasPerNodeGroup *int64 `type:"integer"`

	// A user-created description for the replication group.
	//
	// ReplicationGroupDescription is a required field
	ReplicationGroupDescription *string `type:"string" required:"true"`

	// The replication group identifier. This parameter is stored as a lowercase
	// string.
	//
	// Constraints:
	//
	//    * A name must contain from 1 to 40 alphanumeric characters or hyphens.
	//
	//    * The first character must be a letter.
	//
	//    * A name cannot end with a hyphen or contain two consecutive hyphens.
	//
	// ReplicationGroupId is a required field
	ReplicationGroupId *string `type:"string" required:"true"`

	// One or more Amazon VPC security groups associated with this replication group.
	//
	// Use this parameter only when you are creating a replication group in an Amazon
	// Virtual Private Cloud (Amazon VPC).
	SecurityGroupIds []*string `locationNameList:"SecurityGroupId" type:"list"`

	// A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB
	// snapshot files stored in Amazon S3. The snapshot files are used to populate
	// the new replication group. The Amazon S3 object name in the ARN cannot contain
	// any commas. The new replication group will have the number of node groups
	// (console: shards) specified by the parameter NumNodeGroups or the number
	// of node groups configured by NodeGroupConfiguration regardless of the number
	// of ARNs specified here.
	//
	// Example of an Amazon S3 ARN: arn:aws:s3:::my_bucket/snapshot1.rdb
	SnapshotArns []*string `locationNameList:"SnapshotArn" type:"list"`

	// The name of a snapshot from which to restore data into the new replication
	// group. The snapshot status changes to restoring while the new replication
	// group is being created.
	SnapshotName *string `type:"string"`

	// The number of days for which ElastiCache retains automatic snapshots before
	// deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot
	// that was taken today is retained for 5 days before being deleted.
	//
	// Default: 0 (i.e., automatic backups are disabled for this cluster).
	SnapshotRetentionLimit *int64 `type:"integer"`

	// The daily time range (in UTC) during which ElastiCache begins taking a daily
	// snapshot of your node group (shard).
	//
	// Example: 05:00-09:00
	//
	// If you do not specify this parameter, ElastiCache automatically chooses an
	// appropriate time range.
	SnapshotWindow *string `type:"string"`

	// A list of cost allocation tags to be added to this resource. Tags are comma-separated
	// key,value pairs (e.g. Key=myKey, Value=myKeyValue. You can include multiple
	// tags as shown following: Key=myKey, Value=myKeyValue Key=mySecondKey, Value=mySecondKeyValue.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// A flag that enables in-transit encryption when set to true.
	//
	// You cannot modify the value of TransitEncryptionEnabled after the cluster
	// is created. To enable in-transit encryption on a cluster you must set TransitEncryptionEnabled
	// to true when you create a cluster.
	//
	// This parameter is valid only if the Engine parameter is redis, the EngineVersion
	// parameter is 3.2.6, 4.x or later, and the cluster is being created in an
	// Amazon VPC.
	//
	// If you enable in-transit encryption, you must also specify a value for CacheSubnetGroup.
	//
	// Required: Only available when creating a replication group in an Amazon VPC
	// using redis version 3.2.6, 4.x or later.
	//
	// Default: false
	//
	// For HIPAA compliance, you must specify TransitEncryptionEnabled as true,
	// an AuthToken, and a CacheSubnetGroup.
	TransitEncryptionEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s CreateReplicationGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReplicationGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReplicationGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReplicationGroupInput"}
	if s.ReplicationGroupDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationGroupDescription"))
	}
	if s.ReplicationGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationGroupId"))
	}
	if s.NodeGroupConfiguration != nil {
		for i, v := range s.NodeGroupConfiguration {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "NodeGroupConfiguration", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAtRestEncryptionEnabled sets the AtRestEncryptionEnabled field's value.
func (s *CreateReplicationGroupInput) SetAtRestEncryptionEnabled(v bool) *CreateReplicationGroupInput {
	s.AtRestEncryptionEnabled = &v
	return s
}

// SetAuthToken sets the AuthToken field's value.
func (s *CreateReplicationGroupInput) SetAuthToken(v string) *CreateReplicationGroupInput {
	s.AuthToken = &v
	return s
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *CreateReplicationGroupInput) SetAutoMinorVersionUpgrade(v bool) *CreateReplicationGroupInput {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetAutomaticFailoverEnabled sets the AutomaticFailoverEnabled field's value.
func (s *CreateReplicationGroupInput) SetAutomaticFailoverEnabled(v bool) *CreateReplicationGroupInput {
	s.AutomaticFailoverEnabled = &v
	return s
}

// SetCacheNodeType sets the CacheNodeType field's value.
func (s *CreateReplicationGroupInput) SetCacheNodeType(v string) *CreateReplicationGroupInput {
	s.CacheNodeType = &v
	return s
}

// SetCacheParameterGroupName sets the CacheParameterGroupName field's value.
func (s *CreateReplicationGroupInput) SetCacheParameterGroupName(v string) *CreateReplicationGroupInput {
	s.CacheParameterGroupName = &v
	return s
}

// SetCacheSecurityGroupNames sets the CacheSecurityGroupNames field's value.
func (s *CreateReplicationGroupInput) SetCacheSecurityGroupNames(v []*string) *CreateReplicationGroupInput {
	s.CacheSecurityGroupNames = v
	return s
}

// SetCacheSubnetGroupName sets the CacheSubnetGroupName field's value.
func (s *CreateReplicationGroupInput) SetCacheSubnetGroupName(v string) *CreateReplicationGroupInput {
	s.CacheSubnetGroupName = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *CreateReplicationGroupInput) SetEngine(v string) *CreateReplicationGroupInput {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *CreateReplicationGroupInput) SetEngineVersion(v string) *CreateReplicationGroupInput {
	s.EngineVersion = &v
	return s
}

// SetGlobalReplicationGroupId sets the GlobalReplicationGroupId field's value.
func (s *CreateReplicationGroupInput) SetGlobalReplicationGroupId(v string) *CreateReplicationGroupInput {
	s.GlobalReplicationGroupId = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateReplicationGroupInput) SetKmsKeyId(v string) *CreateReplicationGroupInput {
	s.KmsKeyId = &v
	return s
}

// SetMultiAZEnabled sets the MultiAZEnabled field's value.
func (s *CreateReplicationGroupInput) SetMultiAZEnabled(v bool) *CreateReplicationGroupInput {
	s.MultiAZEnabled = &v
	return s
}

// SetNodeGroupConfiguration sets the NodeGroupConfiguration field's value.
func (s *CreateReplicationGroupInput) SetNodeGroupConfiguration(v []*NodeGroupConfiguration) *CreateReplicationGroupInput {
	s.NodeGroupConfiguration = v
	return s
}

// SetNotificationTopicArn sets the NotificationTopicArn field's value.
func (s *CreateReplicationGroupInput) SetNotificationTopicArn(v string) *CreateReplicationGroupInput {
	s.NotificationTopicArn = &v
	return s
}

// SetNumCacheClusters sets the NumCacheClusters field's value.
func (s *CreateReplicationGroupInput) SetNumCacheClusters(v int64) *CreateReplicationGroupInput {
	s.NumCacheClusters = &v
	return s
}

// SetNumNodeGroups sets the NumNodeGroups field's value.
func (s *CreateReplicationGroupInput) SetNumNodeGroups(v int64) *CreateReplicationGroupInput {
	s.NumNodeGroups = &v
	return s
}

// SetPort sets the Port field's value.
func (s *CreateReplicationGroupInput) SetPort(v int64) *CreateReplicationGroupInput {
	s.Port = &v
	return s
}

// SetPreferredCacheClusterAZs sets the PreferredCacheClusterAZs field's value.
func (s *CreateReplicationGroupInput) SetPreferredCacheClusterAZs(v []*string) *CreateReplicationGroupInput {
	s.PreferredCacheClusterAZs = v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *CreateReplicationGroupInput) SetPreferredMaintenanceWindow(v string) *CreateReplicationGroupInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPrimaryClusterId sets the PrimaryClusterId field's value.
func (s *CreateReplicationGroupInput) SetPrimaryClusterId(v string) *CreateReplicationGroupInput {
	s.PrimaryClusterId = &v
	return s
}

// SetReplicasPerNodeGroup sets the ReplicasPerNodeGroup field's value.
func (s *CreateReplicationGroupInput) SetReplicasPerNodeGroup(v int64) *CreateReplicationGroupInput {
	s.ReplicasPerNodeGroup = &v
	return s
}

// SetReplicationGroupDescription sets the ReplicationGroupDescription field's value.
func (s *CreateReplicationGroupInput) SetReplicationGroupDescription(v string) *CreateReplicationGroupInput {
	s.ReplicationGroupDescription = &v
	return s
}

// SetReplicationGroupId sets the ReplicationGroupId field's value.
func (s *CreateReplicationGroupInput) SetReplicationGroupId(v string) *CreateReplicationGroupInput {
	s.ReplicationGroupId = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *CreateReplicationGroupInput) SetSecurityGroupIds(v []*string) *CreateReplicationGroupInput {
	s.SecurityGroupIds = v
	return s
}

// SetSnapshotArns sets the SnapshotArns field's value.
func (s *CreateReplicationGroupInput) SetSnapshotArns(v []*string) *CreateReplicationGroupInput {
	s.SnapshotArns = v
	return s
}

// SetSnapshotName sets the SnapshotName field's value.
func (s *CreateReplicationGroupInput) SetSnapshotName(v string) *CreateReplicationGroupInput {
	s.SnapshotName = &v
	return s
}

// SetSnapshotRetentionLimit sets the SnapshotRetentionLimit field's value.
func (s *CreateReplicationGroupInput) SetSnapshotRetentionLimit(v int64) *CreateReplicationGroupInput {
	s.SnapshotRetentionLimit = &v
	return s
}

// SetSnapshotWindow sets the SnapshotWindow field's value.
func (s *CreateReplicationGroupInput) SetSnapshotWindow(v string) *CreateReplicationGroupInput {
	s.SnapshotWindow = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateReplicationGroupInput) SetTags(v []*Tag) *CreateReplicationGroupInput {
	s.Tags = v
	return s
}

// SetTransitEncryptionEnabled sets the TransitEncryptionEnabled field's value.
func (s *CreateReplicationGroupInput) SetTransitEncryptionEnabled(v bool) *CreateReplicationGroupInput {
	s.TransitEncryptionEnabled = &v
	return s
}

type CreateReplicationGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains all of the attributes of a specific Redis replication group.
	ReplicationGroup *ReplicationGroup `type:"structure"`
}

// String returns the string representation
func (s CreateReplicationGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReplicationGroupOutput) GoString() string {
	return s.String()
}

// SetReplicationGroup sets the ReplicationGroup field's value.
func (s *CreateReplicationGroupOutput) SetReplicationGroup(v *ReplicationGroup) *CreateReplicationGroupOutput {
	s.ReplicationGroup = v
	return s
}

// Represents the input of a CreateSnapshot operation.
type CreateSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The identifier of an existing cluster. The snapshot is created from this
	// cluster.
	CacheClusterId *string `type:"string"`

	// The ID of the KMS key used to encrypt the snapshot.
	KmsKeyId *string `type:"string"`

	// The identifier of an existing replication group. The snapshot is created
	// from this replication group.
	ReplicationGroupId *string `type:"string"`

	// A name for the snapshot being created.
	//
	// SnapshotName is a required field
	SnapshotName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSnapshotInput"}
	if s.SnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCacheClusterId sets the CacheClusterId field's value.
func (s *CreateSnapshotInput) SetCacheClusterId(v string) *CreateSnapshotInput {
	s.CacheClusterId = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateSnapshotInput) SetKmsKeyId(v string) *CreateSnapshotInput {
	s.KmsKeyId = &v
	return s
}

// SetReplicationGroupId sets the ReplicationGroupId field's value.
func (s *CreateSnapshotInput) SetReplicationGroupId(v string) *CreateSnapshotInput {
	s.ReplicationGroupId = &v
	return s
}

// SetSnapshotName sets the SnapshotName field's value.
func (s *CreateSnapshotInput) SetSnapshotName(v string) *CreateSnapshotInput {
	s.SnapshotName = &v
	return s
}

type CreateSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Represents a copy of an entire Redis cluster as of the time when the snapshot
	// was taken.
	Snapshot *Snapshot `type:"structure"`
}

// String returns the string representation
func (s CreateSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotOutput) GoString() string {
	return s.String()
}

// SetSnapshot sets the Snapshot field's value.
func (s *CreateSnapshotOutput) SetSnapshot(v *Snapshot) *CreateSnapshotOutput {
	s.Snapshot = v
	return s
}

// The endpoint from which data should be migrated.
type CustomerNodeEndpoint struct {
	_ struct{} `type:"structure"`

	// The address of the node endpoint
	Address *string `type:"string"`

	// The port of the node endpoint
	Port *int64 `type:"integer"`
}

// String returns the string representation
func (s CustomerNodeEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomerNodeEndpoint) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *CustomerNodeEndpoint) SetAddress(v string) *CustomerNodeEndpoint {
	s.Address = &v
	return s
}

// SetPort sets the Port field's value.
func (s *CustomerNodeEndpoint) SetPort(v int64) *CustomerNodeEndpoint {
	s.Port = &v
	return s
}

type DecreaseNodeGroupsInGlobalReplicationGroupInput struct {
	_ struct{} `type:"structure"`

	// Indicates that the shard reconfiguration process begins immediately. At present,
	// the only permitted value for this parameter is true.
	//
	// ApplyImmediately is a required field
	ApplyImmediately *bool `type:"boolean" required:"true"`

	// If the value of NodeGroupCount is less than the current number of node groups
	// (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is required.
	// NodeGroupsToRemove is a list of NodeGroupIds to remove from the cluster.
	// ElastiCache for Redis will attempt to remove all node groups listed by NodeGroupsToRemove
	// from the cluster.
	GlobalNodeGroupsToRemove []*string `locationNameList:"GlobalNodeGroupId" type:"list"`

	// If the value of NodeGroupCount is less than the current number of node groups
	// (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is required.
	// NodeGroupsToRemove is a list of NodeGroupIds to remove from the cluster.
	// ElastiCache for Redis will attempt to remove all node groups listed by NodeGroupsToRemove
	// from the cluster.
	GlobalNodeGroupsToRetain []*string `locationNameList:"GlobalNodeGroupId" type:"list"`

	// The name of the Global Datastore
	//
	// GlobalReplicationGroupId is a required field
	GlobalReplicationGroupId *string `type:"string" required:"true"`

	// The number of node groups (shards) that results from the modification of
	// the shard configuration
	//
	// NodeGroupCount is a required field
	NodeGroupCount *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s DecreaseNodeGroupsInGlobalReplicationGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DecreaseNodeGroupsInGlobalReplicationGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DecreaseNodeGroupsInGlobalReplicationGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DecreaseNodeGroupsInGlobalReplicationGroupInput"}
	if s.ApplyImmediately == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplyImmediately"))
	}
	if s.GlobalReplicationGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GlobalReplicationGroupId"))
	}
	if s.NodeGroupCount == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeGroupCount"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplyImmediately sets the ApplyImmediately field's value.
func (s *DecreaseNodeGroupsInGlobalReplicationGroupInput) SetApplyImmediately(v bool) *DecreaseNodeGroupsInGlobalReplicationGroupInput {
	s.ApplyImmediately = &v
	return s
}

// SetGlobalNodeGroupsToRemove sets the GlobalNodeGroupsToRemove field's value.
func (s *DecreaseNodeGroupsInGlobalReplicationGroupInput) SetGlobalNodeGroupsToRemove(v []*string) *DecreaseNodeGroupsInGlobalReplicationGroupInput {
	s.GlobalNodeGroupsToRemove = v
	return s
}

// SetGlobalNodeGroupsToRetain sets the GlobalNodeGroupsToRetain field's value.
func (s *DecreaseNodeGroupsInGlobalReplicationGroupInput) SetGlobalNodeGroupsToRetain(v []*string) *DecreaseNodeGroupsInGlobalReplicationGroupInput {
	s.GlobalNodeGroupsToRetain = v
	return s
}

// SetGlobalReplicationGroupId sets the GlobalReplicationGroupId field's value.
func (s *DecreaseNodeGroupsInGlobalReplicationGroupInput) SetGlobalReplicationGroupId(v string) *DecreaseNodeGroupsInGlobalReplicationGroupInput {
	s.GlobalReplicationGroupId = &v
	return s
}

// SetNodeGroupCount sets the NodeGroupCount field's value.
func (s *DecreaseNodeGroupsInGlobalReplicationGroupInput) SetNodeGroupCount(v int64) *DecreaseNodeGroupsInGlobalReplicationGroupInput {
	s.NodeGroupCount = &v
	return s
}

type DecreaseNodeGroupsInGlobalReplicationGroupOutput struct {
	_ struct{} `type:"structure"`

	// Consists of a primary cluster that accepts writes and an associated secondary
	// cluster that resides in a different AWS region. The secondary cluster accepts
	// only reads. The primary cluster automatically replicates updates to the secondary
	// cluster.
	//
	//    * The GlobalReplicationGroupIdSuffix represents the name of the Global
	//    Datastore, which is what you use to associate a secondary cluster.
	GlobalReplicationGroup *GlobalReplicationGroup `type:"structure"`
}

// String returns the string representation
func (s DecreaseNodeGroupsInGlobalReplicationGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DecreaseNodeGroupsInGlobalReplicationGroupOutput) GoString() string {
	return s.String()
}

// SetGlobalReplicationGroup sets the GlobalReplicationGroup field's value.
func (s *DecreaseNodeGroupsInGlobalReplicationGroupOutput) SetGlobalReplicationGroup(v *GlobalReplicationGroup) *DecreaseNodeGroupsInGlobalReplicationGroupOutput {
	s.GlobalReplicationGroup = v
	return s
}

type DecreaseReplicaCountInput struct {
	_ struct{} `type:"structure"`

	// If True, the number of replica nodes is decreased immediately. ApplyImmediately=False
	// is not currently supported.
	//
	// ApplyImmediately is a required field
	ApplyImmediately *bool `type:"boolean" required:"true"`

	// The number of read replica nodes you want at the completion of this operation.
	// For Redis (cluster mode disabled) replication groups, this is the number
	// of replica nodes in the replication group. For Redis (cluster mode enabled)
	// replication groups, this is the number of replica nodes in each of the replication
	// group's node groups.
	//
	// The minimum number of replicas in a shard or replication group is:
	//
	//    * Redis (cluster mode disabled) If Multi-AZ is enabled: 1 If Multi-AZ
	//    is not enabled: 0
	//
	//    * Redis (cluster mode enabled): 0 (though you will not be able to failover
	//    to a replica if your primary node fails)
	NewReplicaCount *int64 `type:"integer"`

	// A list of ConfigureShard objects that can be used to configure each shard
	// in a Redis (cluster mode enabled) replication group. The ConfigureShard has
	// three members: NewReplicaCount, NodeGroupId, and PreferredAvailabilityZones.
	ReplicaConfiguration []*ConfigureShard `locationNameList:"ConfigureShard" type:"list"`

	// A list of the node ids to remove from the replication group or node group
	// (shard).
	ReplicasToRemove []*string `type:"list"`

	// The id of the replication group from which you want to remove replica nodes.
	//
	// ReplicationGroupId is a required field
	ReplicationGroupId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DecreaseReplicaCountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DecreaseReplicaCountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DecreaseReplicaCountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DecreaseReplicaCountInput"}
	if s.ApplyImmediately == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplyImmediately"))
	}
	if s.ReplicationGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationGroupId"))
	}
	if s.ReplicaConfiguration != nil {
		for i, v := range s.ReplicaConfiguration {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ReplicaConfiguration", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplyImmediately sets the ApplyImmediately field's value.
func (s *DecreaseReplicaCountInput) SetApplyImmediately(v bool) *DecreaseReplicaCountInput {
	s.ApplyImmediately = &v
	return s
}

// SetNewReplicaCount sets the NewReplicaCount field's value.
func (s *DecreaseReplicaCountInput) SetNewReplicaCount(v int64) *DecreaseReplicaCountInput {
	s.NewReplicaCount = &v
	return s
}

// SetReplicaConfiguration sets the ReplicaConfiguration field's value.
func (s *DecreaseReplicaCountInput) SetReplicaConfiguration(v []*ConfigureShard) *DecreaseReplicaCountInput {
	s.ReplicaConfiguration = v
	return s
}

// SetReplicasToRemove sets the ReplicasToRemove field's value.
func (s *DecreaseReplicaCountInput) SetReplicasToRemove(v []*string) *DecreaseReplicaCountInput {
	s.ReplicasToRemove = v
	return s
}

// SetReplicationGroupId sets the ReplicationGroupId field's value.
func (s *DecreaseReplicaCountInput) SetReplicationGroupId(v string) *DecreaseReplicaCountInput {
	s.ReplicationGroupId = &v
	return s
}

type DecreaseReplicaCountOutput struct {
	_ struct{} `type:"structure"`

	// Contains all of the attributes of a specific Redis replication group.
	ReplicationGroup *ReplicationGroup `type:"structure"`
}

// String returns the string representation
func (s DecreaseReplicaCountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DecreaseReplicaCountOutput) GoString() string {
	return s.String()
}

// SetReplicationGroup sets the ReplicationGroup field's value.
func (s *DecreaseReplicaCountOutput) SetReplicationGroup(v *ReplicationGroup) *DecreaseReplicaCountOutput {
	s.ReplicationGroup = v
	return s
}

// Represents the input of a DeleteCacheCluster operation.
type DeleteCacheClusterInput struct {
	_ struct{} `type:"structure"`

	// The cluster identifier for the cluster to be deleted. This parameter is not
	// case sensitive.
	//
	// CacheClusterId is a required field
	CacheClusterId *string `type:"string" required:"true"`

	// The user-supplied name of a final cluster snapshot. This is the unique name
	// that identifies the snapshot. ElastiCache creates the snapshot, and then
	// deletes the cluster immediately afterward.
	FinalSnapshotIdentifier *string `type:"string"`
}

// String returns the string representation
func (s DeleteCacheClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCacheClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCacheClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCacheClusterInput"}
	if s.CacheClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("CacheClusterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCacheClusterId sets the CacheClusterId field's value.
func (s *DeleteCacheClusterInput) SetCacheClusterId(v string) *DeleteCacheClusterInput {
	s.CacheClusterId = &v
	return s
}

// SetFinalSnapshotIdentifier sets the FinalSnapshotIdentifier field's value.
func (s *DeleteCacheClusterInput) SetFinalSnapshotIdentifier(v string) *DeleteCacheClusterInput {
	s.FinalSnapshotIdentifier = &v
	return s
}

type DeleteCacheClusterOutput struct {
	_ struct{} `type:"structure"`

	// Contains all of the attributes of a specific cluster.
	CacheCluster *CacheCluster `type:"structure"`
}

// String returns the string representation
func (s DeleteCacheClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCacheClusterOutput) GoString() string {
	return s.String()
}

// SetCacheCluster sets the CacheCluster field's value.
func (s *DeleteCacheClusterOutput) SetCacheCluster(v *CacheCluster) *DeleteCacheClusterOutput {
	s.CacheCluster = v
	return s
}

// Represents the input of a DeleteCacheParameterGroup operation.
type DeleteCacheParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the cache parameter group to delete.
	//
	// The specified cache security group must not be associated with any clusters.
	//
	// CacheParameterGroupName is a required field
	CacheParameterGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCacheParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCacheParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCacheParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCacheParameterGroupInput"}
	if s.CacheParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("CacheParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCacheParameterGroupName sets the CacheParameterGroupName field's value.
func (s *DeleteCacheParameterGroupInput) SetCacheParameterGroupName(v string) *DeleteCacheParameterGroupInput {
	s.CacheParameterGroupName = &v
	return s
}

type DeleteCacheParameterGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCacheParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCacheParameterGroupOutput) GoString() string {
	return s.String()
}

// Represents the input of a DeleteCacheSecurityGroup operation.
type DeleteCacheSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the cache security group to delete.
	//
	// You cannot delete the default security group.
	//
	// CacheSecurityGroupName is a required field
	CacheSecurityGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCacheSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCacheSecurityGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCacheSecurityGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCacheSecurityGroupInput"}
	if s.CacheSecurityGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("CacheSecurityGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCacheSecurityGroupName sets the CacheSecurityGroupName field's value.
func (s *DeleteCacheSecurityGroupInput) SetCacheSecurityGroupName(v string) *DeleteCacheSecurityGroupInput {
	s.CacheSecurityGroupName = &v
	return s
}

type DeleteCacheSecurityGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCacheSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCacheSecurityGroupOutput) GoString() string {
	return s.String()
}

// Represents the input of a DeleteCacheSubnetGroup operation.
type DeleteCacheSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the cache subnet group to delete.
	//
	// Constraints: Must contain no more than 255 alphanumeric characters or hyphens.
	//
	// CacheSubnetGroupName is a required field
	CacheSubnetGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCacheSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCacheSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCacheSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCacheSubnetGroupInput"}
	if s.CacheSubnetGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("CacheSubnetGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCacheSubnetGroupName sets the CacheSubnetGroupName field's value.
func (s *DeleteCacheSubnetGroupInput) SetCacheSubnetGroupName(v string) *DeleteCacheSubnetGroupInput {
	s.CacheSubnetGroupName = &v
	return s
}

type DeleteCacheSubnetGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCacheSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCacheSubnetGroupOutput) GoString() string {
	return s.String()
}

type DeleteGlobalReplicationGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the Global Datastore
	//
	// GlobalReplicationGroupId is a required field
	GlobalReplicationGroupId *string `type:"string" required:"true"`

	// The primary replication group is retained as a standalone replication group.
	//
	// RetainPrimaryReplicationGroup is a required field
	RetainPrimaryReplicationGroup *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s DeleteGlobalReplicationGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGlobalReplicationGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGlobalReplicationGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGlobalReplicationGroupInput"}
	if s.GlobalReplicationGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GlobalReplicationGroupId"))
	}
	if s.RetainPrimaryReplicationGroup == nil {
		invalidParams.Add(request.NewErrParamRequired("RetainPrimaryReplicationGroup"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGlobalReplicationGroupId sets the GlobalReplicationGroupId field's value.
func (s *DeleteGlobalReplicationGroupInput) SetGlobalReplicationGroupId(v string) *DeleteGlobalReplicationGroupInput {
	s.GlobalReplicationGroupId = &v
	return s
}

// SetRetainPrimaryReplicationGroup sets the RetainPrimaryReplicationGroup field's value.
func (s *DeleteGlobalReplicationGroupInput) SetRetainPrimaryReplicationGroup(v bool) *DeleteGlobalReplicationGroupInput {
	s.RetainPrimaryReplicationGroup = &v
	return s
}

type DeleteGlobalReplicationGroupOutput struct {
	_ struct{} `type:"structure"`

	// Consists of a primary cluster that accepts writes and an associated secondary
	// cluster that resides in a different AWS region. The secondary cluster accepts
	// only reads. The primary cluster automatically replicates updates to the secondary
	// cluster.
	//
	//    * The GlobalReplicationGroupIdSuffix represents the name of the Global
	//    Datastore, which is what you use to associate a secondary cluster.
	GlobalReplicationGroup *GlobalReplicationGroup `type:"structure"`
}

// String returns the string representation
func (s DeleteGlobalReplicationGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGlobalReplicationGroupOutput) GoString() string {
	return s.String()
}

// SetGlobalReplicationGroup sets the GlobalReplicationGroup field's value.
func (s *DeleteGlobalReplicationGroupOutput) SetGlobalReplicationGroup(v *GlobalReplicationGroup) *DeleteGlobalReplicationGroupOutput {
	s.GlobalReplicationGroup = v
	return s
}

// Represents the input of a DeleteReplicationGroup operation.
type DeleteReplicationGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of a final node group (shard) snapshot. ElastiCache creates the
	// snapshot from the primary node in the cluster, rather than one of the replicas;
	// this is to ensure that it captures the freshest data. After the final snapshot
	// is taken, the replication group is immediately deleted.
	FinalSnapshotIdentifier *string `type:"string"`

	// The identifier for the cluster to be deleted. This parameter is not case
	// sensitive.
	//
	// ReplicationGroupId is a required field
	ReplicationGroupId *string `type:"string" required:"true"`

	// If set to true, all of the read replicas are deleted, but the primary node
	// is retained.
	RetainPrimaryCluster *bool `type:"boolean"`
}

// String returns the string representation
func (s DeleteReplicationGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReplicationGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReplicationGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReplicationGroupInput"}
	if s.ReplicationGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationGroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFinalSnapshotIdentifier sets the FinalSnapshotIdentifier field's value.
func (s *DeleteReplicationGroupInput) SetFinalSnapshotIdentifier(v string) *DeleteReplicationGroupInput {
	s.FinalSnapshotIdentifier = &v
	return s
}

// SetReplicationGroupId sets the ReplicationGroupId field's value.
func (s *DeleteReplicationGroupInput) SetReplicationGroupId(v string) *DeleteReplicationGroupInput {
	s.ReplicationGroupId = &v
	return s
}

// SetRetainPrimaryCluster sets the RetainPrimaryCluster field's value.
func (s *DeleteReplicationGroupInput) SetRetainPrimaryCluster(v bool) *DeleteReplicationGroupInput {
	s.RetainPrimaryCluster = &v
	return s
}

type DeleteReplicationGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains all of the attributes of a specific Redis replication group.
	ReplicationGroup *ReplicationGroup `type:"structure"`
}

// String returns the string representation
func (s DeleteReplicationGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReplicationGroupOutput) GoString() string {
	return s.String()
}

// SetReplicationGroup sets the ReplicationGroup field's value.
func (s *DeleteReplicationGroupOutput) SetReplicationGroup(v *ReplicationGroup) *DeleteReplicationGroupOutput {
	s.ReplicationGroup = v
	return s
}

// Represents the input of a DeleteSnapshot operation.
type DeleteSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The name of the snapshot to be deleted.
	//
	// SnapshotName is a required field
	SnapshotName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSnapshotInput"}
	if s.SnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSnapshotName sets the SnapshotName field's value.
func (s *DeleteSnapshotInput) SetSnapshotName(v string) *DeleteSnapshotInput {
	s.SnapshotName = &v
	return s
}

type DeleteSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Represents a copy of an entire Redis cluster as of the time when the snapshot
	// was taken.
	Snapshot *Snapshot `type:"structure"`
}

// String returns the string representation
func (s DeleteSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSnapshotOutput) GoString() string {
	return s.String()
}

// SetSnapshot sets the Snapshot field's value.
func (s *DeleteSnapshotOutput) SetSnapshot(v *Snapshot) *DeleteSnapshotOutput {
	s.Snapshot = v
	return s
}

// Represents the input of a DescribeCacheClusters operation.
type DescribeCacheClustersInput struct {
	_ struct{} `type:"structure"`

	// The user-supplied cluster identifier. If this parameter is specified, only
	// information about that specific cluster is returned. This parameter isn't
	// case sensitive.
	CacheClusterId *string `type:"string"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this operation. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a marker is included in the response
	// so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: minimum 20; maximum 100.
	MaxRecords *int64 `type:"integer"`

	// An optional flag that can be included in the DescribeCacheCluster request
	// to show only nodes (API/CLI: clusters) that are not members of a replication
	// group. In practice, this mean Memcached and single node Redis clusters.
	ShowCacheClustersNotInReplicationGroups *bool `type:"boolean"`

	// An optional flag that can be included in the DescribeCacheCluster request
	// to retrieve information about the individual cache nodes.
	ShowCacheNodeInfo *bool `type:"boolean"`
}

// String returns the string representation
func (s DescribeCacheClustersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheClustersInput) GoString() string {
	return s.String()
}

// SetCacheClusterId sets the CacheClusterId field's value.
func (s *DescribeCacheClustersInput) SetCacheClusterId(v string) *DescribeCacheClustersInput {
	s.CacheClusterId = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeCacheClustersInput) SetMarker(v string) *DescribeCacheClustersInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeCacheClustersInput) SetMaxRecords(v int64) *DescribeCacheClustersInput {
	s.MaxRecords = &v
	return s
}

// SetShowCacheClustersNotInReplicationGroups sets the ShowCacheClustersNotInReplicationGroups field's value.
func (s *DescribeCacheClustersInput) SetShowCacheClustersNotInReplicationGroups(v bool) *DescribeCacheClustersInput {
	s.ShowCacheClustersNotInReplicationGroups = &v
	return s
}

// SetShowCacheNodeInfo sets the ShowCacheNodeInfo field's value.
func (s *DescribeCacheClustersInput) SetShowCacheNodeInfo(v bool) *DescribeCacheClustersInput {
	s.ShowCacheNodeInfo = &v
	return s
}

// Represents the output of a DescribeCacheClusters operation.
type DescribeCacheClustersOutput struct {
	_ struct{} `type:"structure"`

	// A list of clusters. Each item in the list contains detailed information about
	// one cluster.
	CacheClusters []*CacheCluster `locationNameList:"CacheCluster" type:"list"`

	// Provides an identifier to allow retrieval of paginated results.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeCacheClustersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheClustersOutput) GoString() string {
	return s.String()
}

// SetCacheClusters sets the CacheClusters field's value.
func (s *DescribeCacheClustersOutput) SetCacheClusters(v []*CacheCluster) *DescribeCacheClustersOutput {
	s.CacheClusters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeCacheClustersOutput) SetMarker(v string) *DescribeCacheClustersOutput {
	s.Marker = &v
	return s
}

// Represents the input of a DescribeCacheEngineVersions operation.
type DescribeCacheEngineVersionsInput struct {
	_ struct{} `type:"structure"`

	// The name of a specific cache parameter group family to return details for.
	//
	// Valid values are: memcached1.4 | memcached1.5 | redis2.6 | redis2.8 | redis3.2
	// | redis4.0 | redis5.0 |
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	CacheParameterGroupFamily *string `type:"string"`

	// If true, specifies that only the default version of the specified engine
	// or engine and major version combination is to be returned.
	DefaultOnly *bool `type:"boolean"`

	// The cache engine to return. Valid values: memcached | redis
	Engine *string `type:"string"`

	// The cache engine version to return.
	//
	// Example: 1.4.14
	EngineVersion *string `type:"string"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this operation. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a marker is included in the response
	// so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: minimum 20; maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeCacheEngineVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheEngineVersionsInput) GoString() string {
	return s.String()
}

// SetCacheParameterGroupFamily sets the CacheParameterGroupFamily field's value.
func (s *DescribeCacheEngineVersionsInput) SetCacheParameterGroupFamily(v string) *DescribeCacheEngineVersionsInput {
	s.CacheParameterGroupFamily = &v
	return s
}

// SetDefaultOnly sets the DefaultOnly field's value.
func (s *DescribeCacheEngineVersionsInput) SetDefaultOnly(v bool) *DescribeCacheEngineVersionsInput {
	s.DefaultOnly = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *DescribeCacheEngineVersionsInput) SetEngine(v string) *DescribeCacheEngineVersionsInput {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DescribeCacheEngineVersionsInput) SetEngineVersion(v string) *DescribeCacheEngineVersionsInput {
	s.EngineVersion = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeCacheEngineVersionsInput) SetMarker(v string) *DescribeCacheEngineVersionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeCacheEngineVersionsInput) SetMaxRecords(v int64) *DescribeCacheEngineVersionsInput {
	s.MaxRecords = &v
	return s
}

// Represents the output of a DescribeCacheEngineVersions operation.
type DescribeCacheEngineVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of cache engine version details. Each element in the list contains
	// detailed information about one cache engine version.
	CacheEngineVersions []*CacheEngineVersion `locationNameList:"CacheEngineVersion" type:"list"`

	// Provides an identifier to allow retrieval of paginated results.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeCacheEngineVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheEngineVersionsOutput) GoString() string {
	return s.String()
}

// SetCacheEngineVersions sets the CacheEngineVersions field's value.
func (s *DescribeCacheEngineVersionsOutput) SetCacheEngineVersions(v []*CacheEngineVersion) *DescribeCacheEngineVersionsOutput {
	s.CacheEngineVersions = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeCacheEngineVersionsOutput) SetMarker(v string) *DescribeCacheEngineVersionsOutput {
	s.Marker = &v
	return s
}

// Represents the input of a DescribeCacheParameterGroups operation.
type DescribeCacheParameterGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of a specific cache parameter group to return details for.
	CacheParameterGroupName *string `type:"string"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this operation. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a marker is included in the response
	// so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: minimum 20; maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeCacheParameterGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheParameterGroupsInput) GoString() string {
	return s.String()
}

// SetCacheParameterGroupName sets the CacheParameterGroupName field's value.
func (s *DescribeCacheParameterGroupsInput) SetCacheParameterGroupName(v string) *DescribeCacheParameterGroupsInput {
	s.CacheParameterGroupName = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeCacheParameterGroupsInput) SetMarker(v string) *DescribeCacheParameterGroupsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeCacheParameterGroupsInput) SetMaxRecords(v int64) *DescribeCacheParameterGroupsInput {
	s.MaxRecords = &v
	return s
}

// Represents the output of a DescribeCacheParameterGroups operation.
type DescribeCacheParameterGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of cache parameter groups. Each element in the list contains detailed
	// information about one cache parameter group.
	CacheParameterGroups []*CacheParameterGroup `locationNameList:"CacheParameterGroup" type:"list"`

	// Provides an identifier to allow retrieval of paginated results.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeCacheParameterGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheParameterGroupsOutput) GoString() string {
	return s.String()
}

// SetCacheParameterGroups sets the CacheParameterGroups field's value.
func (s *DescribeCacheParameterGroupsOutput) SetCacheParameterGroups(v []*CacheParameterGroup) *DescribeCacheParameterGroupsOutput {
	s.CacheParameterGroups = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeCacheParameterGroupsOutput) SetMarker(v string) *DescribeCacheParameterGroupsOutput {
	s.Marker = &v
	return s
}

// Represents the input of a DescribeCacheParameters operation.
type DescribeCacheParametersInput struct {
	_ struct{} `type:"structure"`

	// The name of a specific cache parameter group to return details for.
	//
	// CacheParameterGroupName is a required field
	CacheParameterGroupName *string `type:"string" required:"true"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this operation. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a marker is included in the response
	// so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: minimum 20; maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The parameter types to return.
	//
	// Valid values: user | system | engine-default
	Source *string `type:"string"`
}

// String returns the string representation
func (s DescribeCacheParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheParametersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCacheParametersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCacheParametersInput"}
	if s.CacheParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("CacheParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCacheParameterGroupName sets the CacheParameterGroupName field's value.
func (s *DescribeCacheParametersInput) SetCacheParameterGroupName(v string) *DescribeCacheParametersInput {
	s.CacheParameterGroupName = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeCacheParametersInput) SetMarker(v string) *DescribeCacheParametersInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeCacheParametersInput) SetMaxRecords(v int64) *DescribeCacheParametersInput {
	s.MaxRecords = &v
	return s
}

// SetSource sets the Source field's value.
func (s *DescribeCacheParametersInput) SetSource(v string) *DescribeCacheParametersInput {
	s.Source = &v
	return s
}

// Represents the output of a DescribeCacheParameters operation.
type DescribeCacheParametersOutput struct {
	_ struct{} `type:"structure"`

	// A list of parameters specific to a particular cache node type. Each element
	// in the list contains detailed information about one parameter.
	CacheNodeTypeSpecificParameters []*CacheNodeTypeSpecificParameter `locationNameList:"CacheNodeTypeSpecificParameter" type:"list"`

	// Provides an identifier to allow retrieval of paginated results.
	Marker *string `type:"string"`

	// A list of Parameter instances.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`
}

// String returns the string representation
func (s DescribeCacheParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheParametersOutput) GoString() string {
	return s.String()
}

// SetCacheNodeTypeSpecificParameters sets the CacheNodeTypeSpecificParameters field's value.
func (s *DescribeCacheParametersOutput) SetCacheNodeTypeSpecificParameters(v []*CacheNodeTypeSpecificParameter) *DescribeCacheParametersOutput {
	s.CacheNodeTypeSpecificParameters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeCacheParametersOutput) SetMarker(v string) *DescribeCacheParametersOutput {
	s.Marker = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *DescribeCacheParametersOutput) SetParameters(v []*Parameter) *DescribeCacheParametersOutput {
	s.Parameters = v
	return s
}

// Represents the input of a DescribeCacheSecurityGroups operation.
type DescribeCacheSecurityGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of the cache security group to return details for.
	CacheSecurityGroupName *string `type:"string"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this operation. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a marker is included in the response
	// so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: minimum 20; maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeCacheSecurityGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheSecurityGroupsInput) GoString() string {
	return s.String()
}

// SetCacheSecurityGroupName sets the CacheSecurityGroupName field's value.
func (s *DescribeCacheSecurityGroupsInput) SetCacheSecurityGroupName(v string) *DescribeCacheSecurityGroupsInput {
	s.CacheSecurityGroupName = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeCacheSecurityGroupsInput) SetMarker(v string) *DescribeCacheSecurityGroupsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeCacheSecurityGroupsInput) SetMaxRecords(v int64) *DescribeCacheSecurityGroupsInput {
	s.MaxRecords = &v
	return s
}

// Represents the output of a DescribeCacheSecurityGroups operation.
type DescribeCacheSecurityGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of cache security groups. Each element in the list contains detailed
	// information about one group.
	CacheSecurityGroups []*CacheSecurityGroup `locationNameList:"CacheSecurityGroup" type:"list"`

	// Provides an identifier to allow retrieval of paginated results.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeCacheSecurityGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheSecurityGroupsOutput) GoString() string {
	return s.String()
}

// SetCacheSecurityGroups sets the CacheSecurityGroups field's value.
func (s *DescribeCacheSecurityGroupsOutput) SetCacheSecurityGroups(v []*CacheSecurityGroup) *DescribeCacheSecurityGroupsOutput {
	s.CacheSecurityGroups = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeCacheSecurityGroupsOutput) SetMarker(v string) *DescribeCacheSecurityGroupsOutput {
	s.Marker = &v
	return s
}

// Represents the input of a DescribeCacheSubnetGroups operation.
type DescribeCacheSubnetGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of the cache subnet group to return details for.
	CacheSubnetGroupName *string `type:"string"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this operation. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a marker is included in the response
	// so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: minimum 20; maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeCacheSubnetGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheSubnetGroupsInput) GoString() string {
	return s.String()
}

// SetCacheSubnetGroupName sets the CacheSubnetGroupName field's value.
func (s *DescribeCacheSubnetGroupsInput) SetCacheSubnetGroupName(v string) *DescribeCacheSubnetGroupsInput {
	s.CacheSubnetGroupName = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeCacheSubnetGroupsInput) SetMarker(v string) *DescribeCacheSubnetGroupsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeCacheSubnetGroupsInput) SetMaxRecords(v int64) *DescribeCacheSubnetGroupsInput {
	s.MaxRecords = &v
	return s
}

// Represents the output of a DescribeCacheSubnetGroups operation.
type DescribeCacheSubnetGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of cache subnet groups. Each element in the list contains detailed
	// information about one group.
	CacheSubnetGroups []*CacheSubnetGroup `locationNameList:"CacheSubnetGroup" type:"list"`

	// Provides an identifier to allow retrieval of paginated results.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeCacheSubnetGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheSubnetGroupsOutput) GoString() string {
	return s.String()
}

// SetCacheSubnetGroups sets the CacheSubnetGroups field's value.
func (s *DescribeCacheSubnetGroupsOutput) SetCacheSubnetGroups(v []*CacheSubnetGroup) *DescribeCacheSubnetGroupsOutput {
	s.CacheSubnetGroups = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeCacheSubnetGroupsOutput) SetMarker(v string) *DescribeCacheSubnetGroupsOutput {
	s.Marker = &v
	return s
}

// Represents the input of a DescribeEngineDefaultParameters operation.
type DescribeEngineDefaultParametersInput struct {
	_ struct{} `type:"structure"`

	// The name of the cache parameter group family.
	//
	// Valid values are: memcached1.4 | memcached1.5 | redis2.6 | redis2.8 | redis3.2
	// | redis4.0 | redis5.0 |
	//
	// CacheParameterGroupFamily is a required field
	CacheParameterGroupFamily *string `type:"string" required:"true"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this operation. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a marker is included in the response
	// so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: minimum 20; maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeEngineDefaultParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEngineDefaultParametersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEngineDefaultParametersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEngineDefaultParametersInput"}
	if s.CacheParameterGroupFamily == nil {
		invalidParams.Add(request.NewErrParamRequired("CacheParameterGroupFamily"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCacheParameterGroupFamily sets the CacheParameterGroupFamily field's value.
func (s *DescribeEngineDefaultParametersInput) SetCacheParameterGroupFamily(v string) *DescribeEngineDefaultParametersInput {
	s.CacheParameterGroupFamily = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEngineDefaultParametersInput) SetMarker(v string) *DescribeEngineDefaultParametersInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEngineDefaultParametersInput) SetMaxRecords(v int64) *DescribeEngineDefaultParametersInput {
	s.MaxRecords = &v
	return s
}

type DescribeEngineDefaultParametersOutput struct {
	_ struct{} `type:"structure"`

	// Represents the output of a DescribeEngineDefaultParameters operation.
	EngineDefaults *EngineDefaults `type:"structure"`
}

// String returns the string representation
func (s DescribeEngineDefaultParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEngineDefaultParametersOutput) GoString() string {
	return s.String()
}

// SetEngineDefaults sets the EngineDefaults field's value.
func (s *DescribeEngineDefaultParametersOutput) SetEngineDefaults(v *EngineDefaults) *DescribeEngineDefaultParametersOutput {
	s.EngineDefaults = v
	return s
}

// Represents the input of a DescribeEvents operation.
type DescribeEventsInput struct {
	_ struct{} `type:"structure"`

	// The number of minutes worth of events to retrieve.
	Duration *int64 `type:"integer"`

	// The end of the time interval for which to retrieve events, specified in ISO
	// 8601 format.
	//
	// Example: 2017-03-30T07:03:49.555Z
	EndTime *time.Time `type:"timestamp"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this operation. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a marker is included in the response
	// so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: minimum 20; maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The identifier of the event source for which events are returned. If not
	// specified, all sources are included in the response.
	SourceIdentifier *string `type:"string"`

	// The event source to retrieve events for. If no value is specified, all events
	// are returned.
	SourceType *string `type:"string" enum:"SourceType"`

	// The beginning of the time interval to retrieve events for, specified in ISO
	// 8601 format.
	//
	// Example: 2017-03-30T07:03:49.555Z
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DescribeEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsInput) GoString() string {
	return s.String()
}

// SetDuration sets the Duration field's value.
func (s *DescribeEventsInput) SetDuration(v int64) *DescribeEventsInput {
	s.Duration = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeEventsInput) SetEndTime(v time.Time) *DescribeEventsInput {
	s.EndTime = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventsInput) SetMarker(v string) *DescribeEventsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEventsInput) SetMaxRecords(v int64) *DescribeEventsInput {
	s.MaxRecords = &v
	return s
}

// SetSourceIdentifier sets the SourceIdentifier field's value.
func (s *DescribeEventsInput) SetSourceIdentifier(v string) *DescribeEventsInput {
	s.SourceIdentifier = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *DescribeEventsInput) SetSourceType(v string) *DescribeEventsInput {
	s.SourceType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeEventsInput) SetStartTime(v time.Time) *DescribeEventsInput {
	s.StartTime = &v
	return s
}

// Represents the output of a DescribeEvents operation.
type DescribeEventsOutput struct {
	_ struct{} `type:"structure"`

	// A list of events. Each element in the list contains detailed information
	// about one event.
	Events []*Event `locationNameList:"Event" type:"list"`

	// Provides an identifier to allow retrieval of paginated results.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *DescribeEventsOutput) SetEvents(v []*Event) *DescribeEventsOutput {
	s.Events = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventsOutput) SetMarker(v string) *DescribeEventsOutput {
	s.Marker = &v
	return s
}

type DescribeGlobalReplicationGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of the Global Datastore
	GlobalReplicationGroupId *string `type:"string"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this operation. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a marker is included in the response
	// so that the remaining results can be retrieved.
	MaxRecords *int64 `type:"integer"`

	// Returns the list of members that comprise the Global Datastore.
	ShowMemberInfo *bool `type:"boolean"`
}

// String returns the string representation
func (s DescribeGlobalReplicationGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGlobalReplicationGroupsInput) GoString() string {
	return s.String()
}

// SetGlobalReplicationGroupId sets the GlobalReplicationGroupId field's value.
func (s *DescribeGlobalReplicationGroupsInput) SetGlobalReplicationGroupId(v string) *DescribeGlobalReplicationGroupsInput {
	s.GlobalReplicationGroupId = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeGlobalReplicationGroupsInput) SetMarker(v string) *DescribeGlobalReplicationGroupsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeGlobalReplicationGroupsInput) SetMaxRecords(v int64) *DescribeGlobalReplicationGroupsInput {
	s.MaxRecords = &v
	return s
}

// SetShowMemberInfo sets the ShowMemberInfo field's value.
func (s *DescribeGlobalReplicationGroupsInput) SetShowMemberInfo(v bool) *DescribeGlobalReplicationGroupsInput {
	s.ShowMemberInfo = &v
	return s
}

type DescribeGlobalReplicationGroupsOutput struct {
	_ struct{} `type:"structure"`

	// Indicates the slot configuration and global identifier for each slice group.
	GlobalReplicationGroups []*GlobalReplicationGroup `locationNameList:"GlobalReplicationGroup" type:"list"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this operation. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	// >
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeGlobalReplicationGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGlobalReplicationGroupsOutput) GoString() string {
	return s.String()
}

// SetGlobalReplicationGroups sets the GlobalReplicationGroups field's value.
func (s *DescribeGlobalReplicationGroupsOutput) SetGlobalReplicationGroups(v []*GlobalReplicationGroup) *DescribeGlobalReplicationGroupsOutput {
	s.GlobalReplicationGroups = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeGlobalReplicationGroupsOutput) SetMarker(v string) *DescribeGlobalReplicationGroupsOutput {
	s.Marker = &v
	return s
}

// Represents the input of a DescribeReplicationGroups operation.
type DescribeReplicationGroupsInput struct {
	_ struct{} `type:"structure"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this operation. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a marker is included in the response
	// so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: minimum 20; maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The identifier for the replication group to be described. This parameter
	// is not case sensitive.
	//
	// If you do not specify this parameter, information about all replication groups
	// is returned.
	ReplicationGroupId *string `type:"string"`
}

// String returns the string representation
func (s DescribeReplicationGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationGroupsInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationGroupsInput) SetMarker(v string) *DescribeReplicationGroupsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeReplicationGroupsInput) SetMaxRecords(v int64) *DescribeReplicationGroupsInput {
	s.MaxRecords = &v
	return s
}

// SetReplicationGroupId sets the ReplicationGroupId field's value.
func (s *DescribeReplicationGroupsInput) SetReplicationGroupId(v string) *DescribeReplicationGroupsInput {
	s.ReplicationGroupId = &v
	return s
}

// Represents the output of a DescribeReplicationGroups operation.
type DescribeReplicationGroupsOutput struct {
	_ struct{} `type:"structure"`

	// Provides an identifier to allow retrieval of paginated results.
	Marker *string `type:"string"`

	// A list of replication groups. Each item in the list contains detailed information
	// about one replication group.
	ReplicationGroups []*ReplicationGroup `locationNameList:"ReplicationGroup" type:"list"`
}

// String returns the string representation
func (s DescribeReplicationGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationGroupsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationGroupsOutput) SetMarker(v string) *DescribeReplicationGroupsOutput {
	s.Marker = &v
	return s
}

// SetReplicationGroups sets the ReplicationGroups field's value.
func (s *DescribeReplicationGroupsOutput) SetReplicationGroups(v []*ReplicationGroup) *DescribeReplicationGroupsOutput {
	s.ReplicationGroups = v
	return s
}

// Represents the input of a DescribeReservedCacheNodes operation.
type DescribeReservedCacheNodesInput struct {
	_ struct{} `type:"structure"`

	// The cache node type filter value. Use this parameter to show only those reservations
	// matching the specified cache node type.
	//
	// The following node types are supported by ElastiCache. Generally speaking,
	// the current generation types provide more memory and computational power
	// at lower cost when compared to their equivalent previous generation counterparts.
	//
	//    * General purpose: Current generation: M5 node types: cache.m5.large,
	//    cache.m5.xlarge, cache.m5.2xlarge, cache.m5.4xlarge, cache.m5.12xlarge,
	//    cache.m5.24xlarge M4 node types: cache.m4.large, cache.m4.xlarge, cache.m4.2xlarge,
	//    cache.m4.4xlarge, cache.m4.10xlarge T3 node types: cache.t3.micro, cache.t3.small,
	//    cache.t3.medium T2 node types: cache.t2.micro, cache.t2.small, cache.t2.medium
	//    Previous generation: (not recommended) T1 node types: cache.t1.micro M1
	//    node types: cache.m1.small, cache.m1.medium, cache.m1.large, cache.m1.xlarge
	//    M3 node types: cache.m3.medium, cache.m3.large, cache.m3.xlarge, cache.m3.2xlarge
	//
	//    * Compute optimized: Previous generation: (not recommended) C1 node types:
	//    cache.c1.xlarge
	//
	//    * Memory optimized: Current generation: R5 node types: cache.r5.large,
	//    cache.r5.xlarge, cache.r5.2xlarge, cache.r5.4xlarge, cache.r5.12xlarge,
	//    cache.r5.24xlarge R4 node types: cache.r4.large, cache.r4.xlarge, cache.r4.2xlarge,
	//    cache.r4.4xlarge, cache.r4.8xlarge, cache.r4.16xlarge Previous generation:
	//    (not recommended) M2 node types: cache.m2.xlarge, cache.m2.2xlarge, cache.m2.4xlarge
	//    R3 node types: cache.r3.large, cache.r3.xlarge, cache.r3.2xlarge, cache.r3.4xlarge,
	//    cache.r3.8xlarge
	//
	// Additional node type info
	//
	//    * All current generation instance types are created in Amazon VPC by default.
	//
	//    * Redis append-only files (AOF) are not supported for T1 or T2 instances.
	//
	//    * Redis Multi-AZ with automatic failover is not supported on T1 instances.
	//
	//    * Redis configuration variables appendonly and appendfsync are not supported
	//    on Redis version 2.8.22 and later.
	CacheNodeType *string `type:"string"`

	// The duration filter value, specified in years or seconds. Use this parameter
	// to show only reservations for this duration.
	//
	// Valid Values: 1 | 3 | 31536000 | 94608000
	Duration *string `type:"string"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this operation. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a marker is included in the response
	// so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: minimum 20; maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The offering type filter value. Use this parameter to show only the available
	// offerings matching the specified offering type.
	//
	// Valid values: "Light Utilization"|"Medium Utilization"|"Heavy Utilization"
	OfferingType *string `type:"string"`

	// The product description filter value. Use this parameter to show only those
	// reservations matching the specified product description.
	ProductDescription *string `type:"string"`

	// The reserved cache node identifier filter value. Use this parameter to show
	// only the reservation that matches the specified reservation ID.
	ReservedCacheNodeId *string `type:"string"`

	// The offering identifier filter value. Use this parameter to show only purchased
	// reservations matching the specified offering identifier.
	ReservedCacheNodesOfferingId *string `type:"string"`
}

// String returns the string representation
func (s DescribeReservedCacheNodesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedCacheNodesInput) GoString() string {
	return s.String()
}

// SetCacheNodeType sets the CacheNodeType field's value.
func (s *DescribeReservedCacheNodesInput) SetCacheNodeType(v string) *DescribeReservedCacheNodesInput {
	s.CacheNodeType = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *DescribeReservedCacheNodesInput) SetDuration(v string) *DescribeReservedCacheNodesInput {
	s.Duration = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeReservedCacheNodesInput) SetMarker(v string) *DescribeReservedCacheNodesInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeReservedCacheNodesInput) SetMaxRecords(v int64) *DescribeReservedCacheNodesInput {
	s.MaxRecords = &v
	return s
}

// SetOfferingType sets the OfferingType field's value.
func (s *DescribeReservedCacheNodesInput) SetOfferingType(v string) *DescribeReservedCacheNodesInput {
	s.OfferingType = &v
	return s
}

// SetProductDescription sets the ProductDescription field's value.
func (s *DescribeReservedCacheNodesInput) SetProductDescription(v string) *DescribeReservedCacheNodesInput {
	s.ProductDescription = &v
	return s
}

// SetReservedCacheNodeId sets the ReservedCacheNodeId field's value.
func (s *DescribeReservedCacheNodesInput) SetReservedCacheNodeId(v string) *DescribeReservedCacheNodesInput {
	s.ReservedCacheNodeId = &v
	return s
}

// SetReservedCacheNodesOfferingId sets the ReservedCacheNodesOfferingId field's value.
func (s *DescribeReservedCacheNodesInput) SetReservedCacheNodesOfferingId(v string) *DescribeReservedCacheNodesInput {
	s.ReservedCacheNodesOfferingId = &v
	return s
}

// Represents the input of a DescribeReservedCacheNodesOfferings operation.
type DescribeReservedCacheNodesOfferingsInput struct {
	_ struct{} `type:"structure"`

	// The cache node type filter value. Use this parameter to show only the available
	// offerings matching the specified cache node type.
	//
	// The following node types are supported by ElastiCache. Generally speaking,
	// the current generation types provide more memory and computational power
	// at lower cost when compared to their equivalent previous generation counterparts.
	//
	//    * General purpose: Current generation: M5 node types: cache.m5.large,
	//    cache.m5.xlarge, cache.m5.2xlarge, cache.m5.4xlarge, cache.m5.12xlarge,
	//    cache.m5.24xlarge M4 node types: cache.m4.large, cache.m4.xlarge, cache.m4.2xlarge,
	//    cache.m4.4xlarge, cache.m4.10xlarge T3 node types: cache.t3.micro, cache.t3.small,
	//    cache.t3.medium T2 node types: cache.t2.micro, cache.t2.small, cache.t2.medium
	//    Previous generation: (not recommended) T1 node types: cache.t1.micro M1
	//    node types: cache.m1.small, cache.m1.medium, cache.m1.large, cache.m1.xlarge
	//    M3 node types: cache.m3.medium, cache.m3.large, cache.m3.xlarge, cache.m3.2xlarge
	//
	//    * Compute optimized: Previous generation: (not recommended) C1 node types:
	//    cache.c1.xlarge
	//
	//    * Memory optimized: Current generation: R5 node types: cache.r5.large,
	//    cache.r5.xlarge, cache.r5.2xlarge, cache.r5.4xlarge, cache.r5.12xlarge,
	//    cache.r5.24xlarge R4 node types: cache.r4.large, cache.r4.xlarge, cache.r4.2xlarge,
	//    cache.r4.4xlarge, cache.r4.8xlarge, cache.r4.16xlarge Previous generation:
	//    (not recommended) M2 node types: cache.m2.xlarge, cache.m2.2xlarge, cache.m2.4xlarge
	//    R3 node types: cache.r3.large, cache.r3.xlarge, cache.r3.2xlarge, cache.r3.4xlarge,
	//    cache.r3.8xlarge
	//
	// Additional node type info
	//
	//    * All current generation instance types are created in Amazon VPC by default.
	//
	//    * Redis append-only files (AOF) are not supported for T1 or T2 instances.
	//
	//    * Redis Multi-AZ with automatic failover is not supported on T1 instances.
	//
	//    * Redis configuration variables appendonly and appendfsync are not supported
	//    on Redis version 2.8.22 and later.
	CacheNodeType *string `type:"string"`

	// Duration filter value, specified in years or seconds. Use this parameter
	// to show only reservations for a given duration.
	//
	// Valid Values: 1 | 3 | 31536000 | 94608000
	Duration *string `type:"string"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this operation. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a marker is included in the response
	// so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: minimum 20; maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The offering type filter value. Use this parameter to show only the available
	// offerings matching the specified offering type.
	//
	// Valid Values: "Light Utilization"|"Medium Utilization"|"Heavy Utilization"
	OfferingType *string `type:"string"`

	// The product description filter value. Use this parameter to show only the
	// available offerings matching the specified product description.
	ProductDescription *string `type:"string"`

	// The offering identifier filter value. Use this parameter to show only the
	// available offering that matches the specified reservation identifier.
	//
	// Example: 438012d3-4052-4cc7-b2e3-8d3372e0e706
	ReservedCacheNodesOfferingId *string `type:"string"`
}

// String returns the string representation
func (s DescribeReservedCacheNodesOfferingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedCacheNodesOfferingsInput) GoString() string {
	return s.String()
}

// SetCacheNodeType sets the CacheNodeType field's value.
func (s *DescribeReservedCacheNodesOfferingsInput) SetCacheNodeType(v string) *DescribeReservedCacheNodesOfferingsInput {
	s.CacheNodeType = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *DescribeReservedCacheNodesOfferingsInput) SetDuration(v string) *DescribeReservedCacheNodesOfferingsInput {
	s.Duration = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeReservedCacheNodesOfferingsInput) SetMarker(v string) *DescribeReservedCacheNodesOfferingsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeReservedCacheNodesOfferingsInput) SetMaxRecords(v int64) *DescribeReservedCacheNodesOfferingsInput {
	s.MaxRecords = &v
	return s
}

// SetOfferingType sets the OfferingType field's value.
func (s *DescribeReservedCacheNodesOfferingsInput) SetOfferingType(v string) *DescribeReservedCacheNodesOfferingsInput {
	s.OfferingType = &v
	return s
}

// SetProductDescription sets the ProductDescription field's value.
func (s *DescribeReservedCacheNodesOfferingsInput) SetProductDescription(v string) *DescribeReservedCacheNodesOfferingsInput {
	s.ProductDescription = &v
	return s
}

// SetReservedCacheNodesOfferingId sets the ReservedCacheNodesOfferingId field's value.
func (s *DescribeReservedCacheNodesOfferingsInput) SetReservedCacheNodesOfferingId(v string) *DescribeReservedCacheNodesOfferingsInput {
	s.ReservedCacheNodesOfferingId = &v
	return s
}

// Represents the output of a DescribeReservedCacheNodesOfferings operation.
type DescribeReservedCacheNodesOfferingsOutput struct {
	_ struct{} `type:"structure"`

	// Provides an identifier to allow retrieval of paginated results.
	Marker *string `type:"string"`

	// A list of reserved cache node offerings. Each element in the list contains
	// detailed information about one offering.
	ReservedCacheNodesOfferings []*ReservedCacheNodesOffering `locationNameList:"ReservedCacheNodesOffering" type:"list"`
}

// String returns the string representation
func (s DescribeReservedCacheNodesOfferingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedCacheNodesOfferingsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReservedCacheNodesOfferingsOutput) SetMarker(v string) *DescribeReservedCacheNodesOfferingsOutput {
	s.Marker = &v
	return s
}

// SetReservedCacheNodesOfferings sets the ReservedCacheNodesOfferings field's value.
func (s *DescribeReservedCacheNodesOfferingsOutput) SetReservedCacheNodesOfferings(v []*ReservedCacheNodesOffering) *DescribeReservedCacheNodesOfferingsOutput {
	s.ReservedCacheNodesOfferings = v
	return s
}

// Represents the output of a DescribeReservedCacheNodes operation.
type DescribeReservedCacheNodesOutput struct {
	_ struct{} `type:"structure"`

	// Provides an identifier to allow retrieval of paginated results.
	Marker *string `type:"string"`

	// A list of reserved cache nodes. Each element in the list contains detailed
	// information about one node.
	ReservedCacheNodes []*ReservedCacheNode `locationNameList:"ReservedCacheNode" type:"list"`
}

// String returns the string representation
func (s DescribeReservedCacheNodesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedCacheNodesOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReservedCacheNodesOutput) SetMarker(v string) *DescribeReservedCacheNodesOutput {
	s.Marker = &v
	return s
}

// SetReservedCacheNodes sets the ReservedCacheNodes field's value.
func (s *DescribeReservedCacheNodesOutput) SetReservedCacheNodes(v []*ReservedCacheNode) *DescribeReservedCacheNodesOutput {
	s.ReservedCacheNodes = v
	return s
}

type DescribeServiceUpdatesInput struct {
	_ struct{} `type:"structure"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this operation. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response
	MaxRecords *int64 `type:"integer"`

	// The unique ID of the service update
	ServiceUpdateName *string `type:"string"`

	// The status of the service update
	ServiceUpdateStatus []*string `type:"list"`
}

// String returns the string representation
func (s DescribeServiceUpdatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeServiceUpdatesInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeServiceUpdatesInput) SetMarker(v string) *DescribeServiceUpdatesInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeServiceUpdatesInput) SetMaxRecords(v int64) *DescribeServiceUpdatesInput {
	s.MaxRecords = &v
	return s
}

// SetServiceUpdateName sets the ServiceUpdateName field's value.
func (s *DescribeServiceUpdatesInput) SetServiceUpdateName(v string) *DescribeServiceUpdatesInput {
	s.ServiceUpdateName = &v
	return s
}

// SetServiceUpdateStatus sets the ServiceUpdateStatus field's value.
func (s *DescribeServiceUpdatesInput) SetServiceUpdateStatus(v []*string) *DescribeServiceUpdatesInput {
	s.ServiceUpdateStatus = v
	return s
}

type DescribeServiceUpdatesOutput struct {
	_ struct{} `type:"structure"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this operation. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// A list of service updates
	ServiceUpdates []*ServiceUpdate `locationNameList:"ServiceUpdate" type:"list"`
}

// String returns the string representation
func (s DescribeServiceUpdatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeServiceUpdatesOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeServiceUpdatesOutput) SetMarker(v string) *DescribeServiceUpdatesOutput {
	s.Marker = &v
	return s
}

// SetServiceUpdates sets the ServiceUpdates field's value.
func (s *DescribeServiceUpdatesOutput) SetServiceUpdates(v []*ServiceUpdate) *DescribeServiceUpdatesOutput {
	s.ServiceUpdates = v
	return s
}

// Represents the input of a DescribeSnapshotsMessage operation.
type DescribeSnapshotsInput struct {
	_ struct{} `type:"structure"`

	// A user-supplied cluster identifier. If this parameter is specified, only
	// snapshots associated with that specific cluster are described.
	CacheClusterId *string `type:"string"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this operation. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a marker is included in the response
	// so that the remaining results can be retrieved.
	//
	// Default: 50
	//
	// Constraints: minimum 20; maximum 50.
	MaxRecords *int64 `type:"integer"`

	// A user-supplied replication group identifier. If this parameter is specified,
	// only snapshots associated with that specific replication group are described.
	ReplicationGroupId *string `type:"string"`

	// A Boolean value which if true, the node group (shard) configuration is included
	// in the snapshot description.
	ShowNodeGroupConfig *bool `type:"boolean"`

	// A user-supplied name of the snapshot. If this parameter is specified, only
	// this snapshot are described.
	SnapshotName *string `type:"string"`

	// If set to system, the output shows snapshots that were automatically created
	// by ElastiCache. If set to user the output shows snapshots that were manually
	// created. If omitted, the output shows both automatically and manually created
	// snapshots.
	SnapshotSource *string `type:"string"`
}

// String returns the string representation
func (s DescribeSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSnapshotsInput) GoString() string {
	return s.String()
}

// SetCacheClusterId sets the CacheClusterId field's value.
func (s *DescribeSnapshotsInput) SetCacheClusterId(v string) *DescribeSnapshotsInput {
	s.CacheClusterId = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeSnapshotsInput) SetMarker(v string) *DescribeSnapshotsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeSnapshotsInput) SetMaxRecords(v int64) *DescribeSnapshotsInput {
	s.MaxRecords = &v
	return s
}

// SetReplicationGroupId sets the ReplicationGroupId field's value.
func (s *DescribeSnapshotsInput) SetReplicationGroupId(v string) *DescribeSnapshotsInput {
	s.ReplicationGroupId = &v
	return s
}

// SetShowNodeGroupConfig sets the ShowNodeGroupConfig field's value.
func (s *DescribeSnapshotsInput) SetShowNodeGroupConfig(v bool) *DescribeSnapshotsInput {
	s.ShowNodeGroupConfig = &v
	return s
}

// SetSnapshotName sets the SnapshotName field's value.
func (s *DescribeSnapshotsInput) SetSnapshotName(v string) *DescribeSnapshotsInput {
	s.SnapshotName = &v
	return s
}

// SetSnapshotSource sets the SnapshotSource field's value.
func (s *DescribeSnapshotsInput) SetSnapshotSource(v string) *DescribeSnapshotsInput {
	s.SnapshotSource = &v
	return s
}

// Represents the output of a DescribeSnapshots operation.
type DescribeSnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this operation. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// A list of snapshots. Each item in the list contains detailed information
	// about one snapshot.
	Snapshots []*Snapshot `locationNameList:"Snapshot" type:"list"`
}

// String returns the string representation
func (s DescribeSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSnapshotsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeSnapshotsOutput) SetMarker(v string) *DescribeSnapshotsOutput {
	s.Marker = &v
	return s
}

// SetSnapshots sets the Snapshots field's value.
func (s *DescribeSnapshotsOutput) SetSnapshots(v []*Snapshot) *DescribeSnapshotsOutput {
	s.Snapshots = v
	return s
}

type DescribeUpdateActionsInput struct {
	_ struct{} `type:"structure"`

	// The cache cluster IDs
	CacheClusterIds []*string `type:"list"`

	// The Elasticache engine to which the update applies. Either Redis or Memcached
	Engine *string `type:"string"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this operation. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response
	MaxRecords *int64 `type:"integer"`

	// The replication group IDs
	ReplicationGroupIds []*string `type:"list"`

	// The unique ID of the service update
	ServiceUpdateName *string `type:"string"`

	// The status of the service update
	ServiceUpdateStatus []*string `type:"list"`

	// The range of time specified to search for service updates that are in available
	// status
	ServiceUpdateTimeRange *TimeRangeFilter `type:"structure"`

	// Dictates whether to include node level update status in the response
	ShowNodeLevelUpdateStatus *bool `type:"boolean"`

	// The status of the update action.
	UpdateActionStatus []*string `type:"list"`
}

// String returns the string representation
func (s DescribeUpdateActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUpdateActionsInput) GoString() string {
	return s.String()
}

// SetCacheClusterIds sets the CacheClusterIds field's value.
func (s *DescribeUpdateActionsInput) SetCacheClusterIds(v []*string) *DescribeUpdateActionsInput {
	s.CacheClusterIds = v
	return s
}

// SetEngine sets the Engine field's value.
func (s *DescribeUpdateActionsInput) SetEngine(v string) *DescribeUpdateActionsInput {
	s.Engine = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeUpdateActionsInput) SetMarker(v string) *DescribeUpdateActionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeUpdateActionsInput) SetMaxRecords(v int64) *DescribeUpdateActionsInput {
	s.MaxRecords = &v
	return s
}

// SetReplicationGroupIds sets the ReplicationGroupIds field's value.
func (s *DescribeUpdateActionsInput) SetReplicationGroupIds(v []*string) *DescribeUpdateActionsInput {
	s.ReplicationGroupIds = v
	return s
}

// SetServiceUpdateName sets the ServiceUpdateName field's value.
func (s *DescribeUpdateActionsInput) SetServiceUpdateName(v string) *DescribeUpdateActionsInput {
	s.ServiceUpdateName = &v
	return s
}

// SetServiceUpdateStatus sets the ServiceUpdateStatus field's value.
func (s *DescribeUpdateActionsInput) SetServiceUpdateStatus(v []*string) *DescribeUpdateActionsInput {
	s.ServiceUpdateStatus = v
	return s
}

// SetServiceUpdateTimeRange sets the ServiceUpdateTimeRange field's value.
func (s *DescribeUpdateActionsInput) SetServiceUpdateTimeRange(v *TimeRangeFilter) *DescribeUpdateActionsInput {
	s.ServiceUpdateTimeRange = v
	return s
}

// SetShowNodeLevelUpdateStatus sets the ShowNodeLevelUpdateStatus field's value.
func (s *DescribeUpdateActionsInput) SetShowNodeLevelUpdateStatus(v bool) *DescribeUpdateActionsInput {
	s.ShowNodeLevelUpdateStatus = &v
	return s
}

// SetUpdateActionStatus sets the UpdateActionStatus field's value.
func (s *DescribeUpdateActionsInput) SetUpdateActionStatus(v []*string) *DescribeUpdateActionsInput {
	s.UpdateActionStatus = v
	return s
}

type DescribeUpdateActionsOutput struct {
	_ struct{} `type:"structure"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this operation. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// Returns a list of update actions
	UpdateActions []*UpdateAction `locationNameList:"UpdateAction" type:"list"`
}

// String returns the string representation
func (s DescribeUpdateActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUpdateActionsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeUpdateActionsOutput) SetMarker(v string) *DescribeUpdateActionsOutput {
	s.Marker = &v
	return s
}

// SetUpdateActions sets the UpdateActions field's value.
func (s *DescribeUpdateActionsOutput) SetUpdateActions(v []*UpdateAction) *DescribeUpdateActionsOutput {
	s.UpdateActions = v
	return s
}

type DisassociateGlobalReplicationGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the Global Datastore
	//
	// GlobalReplicationGroupId is a required field
	GlobalReplicationGroupId *string `type:"string" required:"true"`

	// The name of the secondary cluster you wish to remove from the Global Datastore
	//
	// ReplicationGroupId is a required field
	ReplicationGroupId *string `type:"string" required:"true"`

	// The AWS region of secondary cluster you wish to remove from the Global Datastore
	//
	// ReplicationGroupRegion is a required field
	ReplicationGroupRegion *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateGlobalReplicationGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateGlobalReplicationGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateGlobalReplicationGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateGlobalReplicationGroupInput"}
	if s.GlobalReplicationGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GlobalReplicationGroupId"))
	}
	if s.ReplicationGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationGroupId"))
	}
	if s.ReplicationGroupRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationGroupRegion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGlobalReplicationGroupId sets the GlobalReplicationGroupId field's value.
func (s *DisassociateGlobalReplicationGroupInput) SetGlobalReplicationGroupId(v string) *DisassociateGlobalReplicationGroupInput {
	s.GlobalReplicationGroupId = &v
	return s
}

// SetReplicationGroupId sets the ReplicationGroupId field's value.
func (s *DisassociateGlobalReplicationGroupInput) SetReplicationGroupId(v string) *DisassociateGlobalReplicationGroupInput {
	s.ReplicationGroupId = &v
	return s
}

// SetReplicationGroupRegion sets the ReplicationGroupRegion field's value.
func (s *DisassociateGlobalReplicationGroupInput) SetReplicationGroupRegion(v string) *DisassociateGlobalReplicationGroupInput {
	s.ReplicationGroupRegion = &v
	return s
}

type DisassociateGlobalReplicationGroupOutput struct {
	_ struct{} `type:"structure"`

	// Consists of a primary cluster that accepts writes and an associated secondary
	// cluster that resides in a different AWS region. The secondary cluster accepts
	// only reads. The primary cluster automatically replicates updates to the secondary
	// cluster.
	//
	//    * The GlobalReplicationGroupIdSuffix represents the name of the Global
	//    Datastore, which is what you use to associate a secondary cluster.
	GlobalReplicationGroup *GlobalReplicationGroup `type:"structure"`
}

// String returns the string representation
func (s DisassociateGlobalReplicationGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateGlobalReplicationGroupOutput) GoString() string {
	return s.String()
}

// SetGlobalReplicationGroup sets the GlobalReplicationGroup field's value.
func (s *DisassociateGlobalReplicationGroupOutput) SetGlobalReplicationGroup(v *GlobalReplicationGroup) *DisassociateGlobalReplicationGroupOutput {
	s.GlobalReplicationGroup = v
	return s
}

// Provides ownership and status information for an Amazon EC2 security group.
type EC2SecurityGroup struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon EC2 security group.
	EC2SecurityGroupName *string `type:"string"`

	// The AWS account ID of the Amazon EC2 security group owner.
	EC2SecurityGroupOwnerId *string `type:"string"`

	// The status of the Amazon EC2 security group.
	Status *string `type:"string"`
}

// String returns the string representation
func (s EC2SecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EC2SecurityGroup) GoString() string {
	return s.String()
}

// SetEC2SecurityGroupName sets the EC2SecurityGroupName field's value.
func (s *EC2SecurityGroup) SetEC2SecurityGroupName(v string) *EC2SecurityGroup {
	s.EC2SecurityGroupName = &v
	return s
}

// SetEC2SecurityGroupOwnerId sets the EC2SecurityGroupOwnerId field's value.
func (s *EC2SecurityGroup) SetEC2SecurityGroupOwnerId(v string) *EC2SecurityGroup {
	s.EC2SecurityGroupOwnerId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EC2SecurityGroup) SetStatus(v string) *EC2SecurityGroup {
	s.Status = &v
	return s
}

// Represents the information required for client programs to connect to a cache
// node.
type Endpoint struct {
	_ struct{} `type:"structure"`

	// The DNS hostname of the cache node.
	Address *string `type:"string"`

	// The port number that the cache engine is listening on.
	Port *int64 `type:"integer"`
}

// String returns the string representation
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Endpoint) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *Endpoint) SetAddress(v string) *Endpoint {
	s.Address = &v
	return s
}

// SetPort sets the Port field's value.
func (s *Endpoint) SetPort(v int64) *Endpoint {
	s.Port = &v
	return s
}

// Represents the output of a DescribeEngineDefaultParameters operation.
type EngineDefaults struct {
	_ struct{} `type:"structure"`

	// A list of parameters specific to a particular cache node type. Each element
	// in the list contains detailed information about one parameter.
	CacheNodeTypeSpecificParameters []*CacheNodeTypeSpecificParameter `locationNameList:"CacheNodeTypeSpecificParameter" type:"list"`

	// Specifies the name of the cache parameter group family to which the engine
	// default parameters apply.
	//
	// Valid values are: memcached1.4 | memcached1.5 | redis2.6 | redis2.8 | redis3.2
	// | redis4.0 | redis5.0 |
	CacheParameterGroupFamily *string `type:"string"`

	// Provides an identifier to allow retrieval of paginated results.
	Marker *string `type:"string"`

	// Contains a list of engine default parameters.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`
}

// String returns the string representation
func (s EngineDefaults) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EngineDefaults) GoString() string {
	return s.String()
}

// SetCacheNodeTypeSpecificParameters sets the CacheNodeTypeSpecificParameters field's value.
func (s *EngineDefaults) SetCacheNodeTypeSpecificParameters(v []*CacheNodeTypeSpecificParameter) *EngineDefaults {
	s.CacheNodeTypeSpecificParameters = v
	return s
}

// SetCacheParameterGroupFamily sets the CacheParameterGroupFamily field's value.
func (s *EngineDefaults) SetCacheParameterGroupFamily(v string) *EngineDefaults {
	s.CacheParameterGroupFamily = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *EngineDefaults) SetMarker(v string) *EngineDefaults {
	s.Marker = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *EngineDefaults) SetParameters(v []*Parameter) *EngineDefaults {
	s.Parameters = v
	return s
}

// Represents a single occurrence of something interesting within the system.
// Some examples of events are creating a cluster, adding or removing a cache
// node, or rebooting a node.
type Event struct {
	_ struct{} `type:"structure"`

	// The date and time when the event occurred.
	Date *time.Time `type:"timestamp"`

	// The text of the event.
	Message *string `type:"string"`

	// The identifier for the source of the event. For example, if the event occurred
	// at the cluster level, the identifier would be the name of the cluster.
	SourceIdentifier *string `type:"string"`

	// Specifies the origin of this event - a cluster, a parameter group, a security
	// group, etc.
	SourceType *string `type:"string" enum:"SourceType"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Event) GoString() string {
	return s.String()
}

// SetDate sets the Date field's value.
func (s *Event) SetDate(v time.Time) *Event {
	s.Date = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *Event) SetMessage(v string) *Event {
	s.Message = &v
	return s
}

// SetSourceIdentifier sets the SourceIdentifier field's value.
func (s *Event) SetSourceIdentifier(v string) *Event {
	s.SourceIdentifier = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *Event) SetSourceType(v string) *Event {
	s.SourceType = &v
	return s
}

type FailoverGlobalReplicationGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the Global Datastore
	//
	// GlobalReplicationGroupId is a required field
	GlobalReplicationGroupId *string `type:"string" required:"true"`

	// The AWS region of the primary cluster of the Global Datastore
	//
	// PrimaryRegion is a required field
	PrimaryRegion *string `type:"string" required:"true"`

	// The name of the primary replication group
	//
	// PrimaryReplicationGroupId is a required field
	PrimaryReplicationGroupId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s FailoverGlobalReplicationGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailoverGlobalReplicationGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FailoverGlobalReplicationGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FailoverGlobalReplicationGroupInput"}
	if s.GlobalReplicationGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GlobalReplicationGroupId"))
	}
	if s.PrimaryRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("PrimaryRegion"))
	}
	if s.PrimaryReplicationGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrimaryReplicationGroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGlobalReplicationGroupId sets the GlobalReplicationGroupId field's value.
func (s *FailoverGlobalReplicationGroupInput) SetGlobalReplicationGroupId(v string) *FailoverGlobalReplicationGroupInput {
	s.GlobalReplicationGroupId = &v
	return s
}

// SetPrimaryRegion sets the PrimaryRegion field's value.
func (s *FailoverGlobalReplicationGroupInput) SetPrimaryRegion(v string) *FailoverGlobalReplicationGroupInput {
	s.PrimaryRegion = &v
	return s
}

// SetPrimaryReplicationGroupId sets the PrimaryReplicationGroupId field's value.
func (s *FailoverGlobalReplicationGroupInput) SetPrimaryReplicationGroupId(v string) *FailoverGlobalReplicationGroupInput {
	s.PrimaryReplicationGroupId = &v
	return s
}

type FailoverGlobalReplicationGroupOutput struct {
	_ struct{} `type:"structure"`

	// Consists of a primary cluster that accepts writes and an associated secondary
	// cluster that resides in a different AWS region. The secondary cluster accepts
	// only reads. The primary cluster automatically replicates updates to the secondary
	// cluster.
	//
	//    * The GlobalReplicationGroupIdSuffix represents the name of the Global
	//    Datastore, which is what you use to associate a secondary cluster.
	GlobalReplicationGroup *GlobalReplicationGroup `type:"structure"`
}

// String returns the string representation
func (s FailoverGlobalReplicationGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailoverGlobalReplicationGroupOutput) GoString() string {
	return s.String()
}

// SetGlobalReplicationGroup sets the GlobalReplicationGroup field's value.
func (s *FailoverGlobalReplicationGroupOutput) SetGlobalReplicationGroup(v *GlobalReplicationGroup) *FailoverGlobalReplicationGroupOutput {
	s.GlobalReplicationGroup = v
	return s
}

// Indicates the slot configuration and global identifier for a slice group.
type GlobalNodeGroup struct {
	_ struct{} `type:"structure"`

	// The name of the global node group
	GlobalNodeGroupId *string `type:"string"`

	// The keyspace for this node group
	Slots *string `type:"string"`
}

// String returns the string representation
func (s GlobalNodeGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GlobalNodeGroup) GoString() string {
	return s.String()
}

// SetGlobalNodeGroupId sets the GlobalNodeGroupId field's value.
func (s *GlobalNodeGroup) SetGlobalNodeGroupId(v string) *GlobalNodeGroup {
	s.GlobalNodeGroupId = &v
	return s
}

// SetSlots sets the Slots field's value.
func (s *GlobalNodeGroup) SetSlots(v string) *GlobalNodeGroup {
	s.Slots = &v
	return s
}

// Consists of a primary cluster that accepts writes and an associated secondary
// cluster that resides in a different AWS region. The secondary cluster accepts
// only reads. The primary cluster automatically replicates updates to the secondary
// cluster.
//
//    * The GlobalReplicationGroupIdSuffix represents the name of the Global
//    Datastore, which is what you use to associate a secondary cluster.
type GlobalReplicationGroup struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) of the global replication group.
	ARN *string `type:"string"`

	// A flag that enables encryption at rest when set to true.
	//
	// You cannot modify the value of AtRestEncryptionEnabled after the replication
	// group is created. To enable encryption at rest on a replication group you
	// must set AtRestEncryptionEnabled to true when you create the replication
	// group.
	//
	// Required: Only available when creating a replication group in an Amazon VPC
	// using redis version 3.2.6, 4.x or later.
	AtRestEncryptionEnabled *bool `type:"boolean"`

	// A flag that enables using an AuthToken (password) when issuing Redis commands.
	//
	// Default: false
	AuthTokenEnabled *bool `type:"boolean"`

	// The cache node type of the Global Datastore
	CacheNodeType *string `type:"string"`

	// A flag that indicates whether the Global Datastore is cluster enabled.
	ClusterEnabled *bool `type:"boolean"`

	// The Elasticache engine. For Redis only.
	Engine *string `type:"string"`

	// The Elasticache Redis engine version. For preview, it is Redis version 5.0.5
	// only.
	EngineVersion *string `type:"string"`

	// Indicates the slot configuration and global identifier for each slice group.
	GlobalNodeGroups []*GlobalNodeGroup `locationNameList:"GlobalNodeGroup" type:"list"`

	// The optional description of the Global Datastore
	GlobalReplicationGroupDescription *string `type:"string"`

	// The name of the Global Datastore
	GlobalReplicationGroupId *string `type:"string"`

	// The replication groups that comprise the Global Datastore.
	Members []*GlobalReplicationGroupMember `locationNameList:"GlobalReplicationGroupMember" type:"list"`

	// The status of the Global Datastore
	Status *string `type:"string"`

	// A flag that enables in-transit encryption when set to true. You cannot modify
	// the value of TransitEncryptionEnabled after the cluster is created. To enable
	// in-transit encryption on a cluster you must set TransitEncryptionEnabled
	// to true when you create a cluster.
	TransitEncryptionEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s GlobalReplicationGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GlobalReplicationGroup) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *GlobalReplicationGroup) SetARN(v string) *GlobalReplicationGroup {
	s.ARN = &v
	return s
}

// SetAtRestEncryptionEnabled sets the AtRestEncryptionEnabled field's value.
func (s *GlobalReplicationGroup) SetAtRestEncryptionEnabled(v bool) *GlobalReplicationGroup {
	s.AtRestEncryptionEnabled = &v
	return s
}

// SetAuthTokenEnabled sets the AuthTokenEnabled field's value.
func (s *GlobalReplicationGroup) SetAuthTokenEnabled(v bool) *GlobalReplicationGroup {
	s.AuthTokenEnabled = &v
	return s
}

// SetCacheNodeType sets the CacheNodeType field's value.
func (s *GlobalReplicationGroup) SetCacheNodeType(v string) *GlobalReplicationGroup {
	s.CacheNodeType = &v
	return s
}

// SetClusterEnabled sets the ClusterEnabled field's value.
func (s *GlobalReplicationGroup) SetClusterEnabled(v bool) *GlobalReplicationGroup {
	s.ClusterEnabled = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *GlobalReplicationGroup) SetEngine(v string) *GlobalReplicationGroup {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *GlobalReplicationGroup) SetEngineVersion(v string) *GlobalReplicationGroup {
	s.EngineVersion = &v
	return s
}

// SetGlobalNodeGroups sets the GlobalNodeGroups field's value.
func (s *GlobalReplicationGroup) SetGlobalNodeGroups(v []*GlobalNodeGroup) *GlobalReplicationGroup {
	s.GlobalNodeGroups = v
	return s
}

// SetGlobalReplicationGroupDescription sets the GlobalReplicationGroupDescription field's value.
func (s *GlobalReplicationGroup) SetGlobalReplicationGroupDescription(v string) *GlobalReplicationGroup {
	s.GlobalReplicationGroupDescription = &v
	return s
}

// SetGlobalReplicationGroupId sets the GlobalReplicationGroupId field's value.
func (s *GlobalReplicationGroup) SetGlobalReplicationGroupId(v string) *GlobalReplicationGroup {
	s.GlobalReplicationGroupId = &v
	return s
}

// SetMembers sets the Members field's value.
func (s *GlobalReplicationGroup) SetMembers(v []*GlobalReplicationGroupMember) *GlobalReplicationGroup {
	s.Members = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GlobalReplicationGroup) SetStatus(v string) *GlobalReplicationGroup {
	s.Status = &v
	return s
}

// SetTransitEncryptionEnabled sets the TransitEncryptionEnabled field's value.
func (s *GlobalReplicationGroup) SetTransitEncryptionEnabled(v bool) *GlobalReplicationGroup {
	s.TransitEncryptionEnabled = &v
	return s
}

// The name of the Global Datastore and role of this replication group in the
// Global Datastore.
type GlobalReplicationGroupInfo struct {
	_ struct{} `type:"structure"`

	// The name of the Global Datastore
	GlobalReplicationGroupId *string `type:"string"`

	// The role of the replication group in a Global Datastore. Can be primary or
	// secondary.
	GlobalReplicationGroupMemberRole *string `type:"string"`
}

// String returns the string representation
func (s GlobalReplicationGroupInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GlobalReplicationGroupInfo) GoString() string {
	return s.String()
}

// SetGlobalReplicationGroupId sets the GlobalReplicationGroupId field's value.
func (s *GlobalReplicationGroupInfo) SetGlobalReplicationGroupId(v string) *GlobalReplicationGroupInfo {
	s.GlobalReplicationGroupId = &v
	return s
}

// SetGlobalReplicationGroupMemberRole sets the GlobalReplicationGroupMemberRole field's value.
func (s *GlobalReplicationGroupInfo) SetGlobalReplicationGroupMemberRole(v string) *GlobalReplicationGroupInfo {
	s.GlobalReplicationGroupMemberRole = &v
	return s
}

// A member of a Global Datastore. It contains the Replication Group Id, the
// AWS region and the role of the replication group.
type GlobalReplicationGroupMember struct {
	_ struct{} `type:"structure"`

	// Indicates whether automatic failover is enabled for the replication group.
	AutomaticFailover *string `type:"string" enum:"AutomaticFailoverStatus"`

	// The replication group id of the Global Datastore member.
	ReplicationGroupId *string `type:"string"`

	// The AWS region of the Global Datastore member.
	ReplicationGroupRegion *string `type:"string"`

	// Indicates the role of the replication group, primary or secondary.
	Role *string `type:"string"`

	// The status of the membership of the replication group.
	Status *string `type:"string"`
}

// String returns the string representation
func (s GlobalReplicationGroupMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GlobalReplicationGroupMember) GoString() string {
	return s.String()
}

// SetAutomaticFailover sets the AutomaticFailover field's value.
func (s *GlobalReplicationGroupMember) SetAutomaticFailover(v string) *GlobalReplicationGroupMember {
	s.AutomaticFailover = &v
	return s
}

// SetReplicationGroupId sets the ReplicationGroupId field's value.
func (s *GlobalReplicationGroupMember) SetReplicationGroupId(v string) *GlobalReplicationGroupMember {
	s.ReplicationGroupId = &v
	return s
}

// SetReplicationGroupRegion sets the ReplicationGroupRegion field's value.
func (s *GlobalReplicationGroupMember) SetReplicationGroupRegion(v string) *GlobalReplicationGroupMember {
	s.ReplicationGroupRegion = &v
	return s
}

// SetRole sets the Role field's value.
func (s *GlobalReplicationGroupMember) SetRole(v string) *GlobalReplicationGroupMember {
	s.Role = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GlobalReplicationGroupMember) SetStatus(v string) *GlobalReplicationGroupMember {
	s.Status = &v
	return s
}

type IncreaseNodeGroupsInGlobalReplicationGroupInput struct {
	_ struct{} `type:"structure"`

	// Indicates that the process begins immediately. At present, the only permitted
	// value for this parameter is true.
	//
	// ApplyImmediately is a required field
	ApplyImmediately *bool `type:"boolean" required:"true"`

	// The name of the Global Datastore
	//
	// GlobalReplicationGroupId is a required field
	GlobalReplicationGroupId *string `type:"string" required:"true"`

	// The number of node groups you wish to add
	//
	// NodeGroupCount is a required field
	NodeGroupCount *int64 `type:"integer" required:"true"`

	// Describes the replication group IDs, the AWS regions where they are stored
	// and the shard configuration for each that comprise the Global Datastore
	RegionalConfigurations []*RegionalConfiguration `locationNameList:"RegionalConfiguration" type:"list"`
}

// String returns the string representation
func (s IncreaseNodeGroupsInGlobalReplicationGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IncreaseNodeGroupsInGlobalReplicationGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IncreaseNodeGroupsInGlobalReplicationGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IncreaseNodeGroupsInGlobalReplicationGroupInput"}
	if s.ApplyImmediately == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplyImmediately"))
	}
	if s.GlobalReplicationGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GlobalReplicationGroupId"))
	}
	if s.NodeGroupCount == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeGroupCount"))
	}
	if s.RegionalConfigurations != nil {
		for i, v := range s.RegionalConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RegionalConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplyImmediately sets the ApplyImmediately field's value.
func (s *IncreaseNodeGroupsInGlobalReplicationGroupInput) SetApplyImmediately(v bool) *IncreaseNodeGroupsInGlobalReplicationGroupInput {
	s.ApplyImmediately = &v
	return s
}

// SetGlobalReplicationGroupId sets the GlobalReplicationGroupId field's value.
func (s *IncreaseNodeGroupsInGlobalReplicationGroupInput) SetGlobalReplicationGroupId(v string) *IncreaseNodeGroupsInGlobalReplicationGroupInput {
	s.GlobalReplicationGroupId = &v
	return s
}

// SetNodeGroupCount sets the NodeGroupCount field's value.
func (s *IncreaseNodeGroupsInGlobalReplicationGroupInput) SetNodeGroupCount(v int64) *IncreaseNodeGroupsInGlobalReplicationGroupInput {
	s.NodeGroupCount = &v
	return s
}

// SetRegionalConfigurations sets the RegionalConfigurations field's value.
func (s *IncreaseNodeGroupsInGlobalReplicationGroupInput) SetRegionalConfigurations(v []*RegionalConfiguration) *IncreaseNodeGroupsInGlobalReplicationGroupInput {
	s.RegionalConfigurations = v
	return s
}

type IncreaseNodeGroupsInGlobalReplicationGroupOutput struct {
	_ struct{} `type:"structure"`

	// Consists of a primary cluster that accepts writes and an associated secondary
	// cluster that resides in a different AWS region. The secondary cluster accepts
	// only reads. The primary cluster automatically replicates updates to the secondary
	// cluster.
	//
	//    * The GlobalReplicationGroupIdSuffix represents the name of the Global
	//    Datastore, which is what you use to associate a secondary cluster.
	GlobalReplicationGroup *GlobalReplicationGroup `type:"structure"`
}

// String returns the string representation
func (s IncreaseNodeGroupsInGlobalReplicationGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IncreaseNodeGroupsInGlobalReplicationGroupOutput) GoString() string {
	return s.String()
}

// SetGlobalReplicationGroup sets the GlobalReplicationGroup field's value.
func (s *IncreaseNodeGroupsInGlobalReplicationGroupOutput) SetGlobalReplicationGroup(v *GlobalReplicationGroup) *IncreaseNodeGroupsInGlobalReplicationGroupOutput {
	s.GlobalReplicationGroup = v
	return s
}

type IncreaseReplicaCountInput struct {
	_ struct{} `type:"structure"`

	// If True, the number of replica nodes is increased immediately. ApplyImmediately=False
	// is not currently supported.
	//
	// ApplyImmediately is a required field
	ApplyImmediately *bool `type:"boolean" required:"true"`

	// The number of read replica nodes you want at the completion of this operation.
	// For Redis (cluster mode disabled) replication groups, this is the number
	// of replica nodes in the replication group. For Redis (cluster mode enabled)
	// replication groups, this is the number of replica nodes in each of the replication
	// group's node groups.
	NewReplicaCount *int64 `type:"integer"`

	// A list of ConfigureShard objects that can be used to configure each shard
	// in a Redis (cluster mode enabled) replication group. The ConfigureShard has
	// three members: NewReplicaCount, NodeGroupId, and PreferredAvailabilityZones.
	ReplicaConfiguration []*ConfigureShard `locationNameList:"ConfigureShard" type:"list"`

	// The id of the replication group to which you want to add replica nodes.
	//
	// ReplicationGroupId is a required field
	ReplicationGroupId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s IncreaseReplicaCountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IncreaseReplicaCountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IncreaseReplicaCountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IncreaseReplicaCountInput"}
	if s.ApplyImmediately == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplyImmediately"))
	}
	if s.ReplicationGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationGroupId"))
	}
	if s.ReplicaConfiguration != nil {
		for i, v := range s.ReplicaConfiguration {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ReplicaConfiguration", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplyImmediately sets the ApplyImmediately field's value.
func (s *IncreaseReplicaCountInput) SetApplyImmediately(v bool) *IncreaseReplicaCountInput {
	s.ApplyImmediately = &v
	return s
}

// SetNewReplicaCount sets the NewReplicaCount field's value.
func (s *IncreaseReplicaCountInput) SetNewReplicaCount(v int64) *IncreaseReplicaCountInput {
	s.NewReplicaCount = &v
	return s
}

// SetReplicaConfiguration sets the ReplicaConfiguration field's value.
func (s *IncreaseReplicaCountInput) SetReplicaConfiguration(v []*ConfigureShard) *IncreaseReplicaCountInput {
	s.ReplicaConfiguration = v
	return s
}

// SetReplicationGroupId sets the ReplicationGroupId field's value.
func (s *IncreaseReplicaCountInput) SetReplicationGroupId(v string) *IncreaseReplicaCountInput {
	s.ReplicationGroupId = &v
	return s
}

type IncreaseReplicaCountOutput struct {
	_ struct{} `type:"structure"`

	// Contains all of the attributes of a specific Redis replication group.
	ReplicationGroup *ReplicationGroup `type:"structure"`
}

// String returns the string representation
func (s IncreaseReplicaCountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IncreaseReplicaCountOutput) GoString() string {
	return s.String()
}

// SetReplicationGroup sets the ReplicationGroup field's value.
func (s *IncreaseReplicaCountOutput) SetReplicationGroup(v *ReplicationGroup) *IncreaseReplicaCountOutput {
	s.ReplicationGroup = v
	return s
}

// The input parameters for the ListAllowedNodeTypeModifications operation.
type ListAllowedNodeTypeModificationsInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster you want to scale up to a larger node instanced type.
	// ElastiCache uses the cluster id to identify the current node type of this
	// cluster and from that to create a list of node types you can scale up to.
	//
	// You must provide a value for either the CacheClusterId or the ReplicationGroupId.
	CacheClusterId *string `type:"string"`

	// The name of the replication group want to scale up to a larger node type.
	// ElastiCache uses the replication group id to identify the current node type
	// being used by this replication group, and from that to create a list of node
	// types you can scale up to.
	//
	// You must provide a value for either the CacheClusterId or the ReplicationGroupId.
	ReplicationGroupId *string `type:"string"`
}

// String returns the string representation
func (s ListAllowedNodeTypeModificationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAllowedNodeTypeModificationsInput) GoString() string {
	return s.String()
}

// SetCacheClusterId sets the CacheClusterId field's value.
func (s *ListAllowedNodeTypeModificationsInput) SetCacheClusterId(v string) *ListAllowedNodeTypeModificationsInput {
	s.CacheClusterId = &v
	return s
}

// SetReplicationGroupId sets the ReplicationGroupId field's value.
func (s *ListAllowedNodeTypeModificationsInput) SetReplicationGroupId(v string) *ListAllowedNodeTypeModificationsInput {
	s.ReplicationGroupId = &v
	return s
}

// Represents the allowed node types you can use to modify your cluster or replication
// group.
type ListAllowedNodeTypeModificationsOutput struct {
	_ struct{} `type:"structure"`

	// A string list, each element of which specifies a cache node type which you
	// can use to scale your cluster or replication group. When scaling down a Redis
	// cluster or replication group using ModifyCacheCluster or ModifyReplicationGroup,
	// use a value from this list for the CacheNodeType parameter.
	ScaleDownModifications []*string `type:"list"`

	// A string list, each element of which specifies a cache node type which you
	// can use to scale your cluster or replication group.
	//
	// When scaling up a Redis cluster or replication group using ModifyCacheCluster
	// or ModifyReplicationGroup, use a value from this list for the CacheNodeType
	// parameter.
	ScaleUpModifications []*string `type:"list"`
}

// String returns the string representation
func (s ListAllowedNodeTypeModificationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAllowedNodeTypeModificationsOutput) GoString() string {
	return s.String()
}

// SetScaleDownModifications sets the ScaleDownModifications field's value.
func (s *ListAllowedNodeTypeModificationsOutput) SetScaleDownModifications(v []*string) *ListAllowedNodeTypeModificationsOutput {
	s.ScaleDownModifications = v
	return s
}

// SetScaleUpModifications sets the ScaleUpModifications field's value.
func (s *ListAllowedNodeTypeModificationsOutput) SetScaleUpModifications(v []*string) *ListAllowedNodeTypeModificationsOutput {
	s.ScaleUpModifications = v
	return s
}

// The input parameters for the ListTagsForResource operation.
type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource for which you want the list
	// of tags, for example arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster
	// or arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// ResourceName is a required field
	ResourceName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceName sets the ResourceName field's value.
func (s *ListTagsForResourceInput) SetResourceName(v string) *ListTagsForResourceInput {
	s.ResourceName = &v
	return s
}

// Represents the input of a ModifyCacheCluster operation.
type ModifyCacheClusterInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the new nodes in this Memcached cluster are all created
	// in a single Availability Zone or created across multiple Availability Zones.
	//
	// Valid values: single-az | cross-az.
	//
	// This option is only supported for Memcached clusters.
	//
	// You cannot specify single-az if the Memcached cluster already has cache nodes
	// in different Availability Zones. If cross-az is specified, existing Memcached
	// nodes remain in their current Availability Zone.
	//
	// Only newly created nodes are located in different Availability Zones.
	AZMode *string `type:"string" enum:"AZMode"`

	// If true, this parameter causes the modifications in this request and any
	// pending modifications to be applied, asynchronously and as soon as possible,
	// regardless of the PreferredMaintenanceWindow setting for the cluster.
	//
	// If false, changes to the cluster are applied on the next maintenance reboot,
	// or the next failure reboot, whichever occurs first.
	//
	// If you perform a ModifyCacheCluster before a pending modification is applied,
	// the pending modification is replaced by the newer modification.
	//
	// Valid values: true | false
	//
	// Default: false
	ApplyImmediately *bool `type:"boolean"`

	// Reserved parameter. The password used to access a password protected server.
	// This parameter must be specified with the auth-token-update parameter. Password
	// constraints:
	//
	//    * Must be only printable ASCII characters
	//
	//    * Must be at least 16 characters and no more than 128 characters in length
	//
	//    * Cannot contain any of the following characters: '/', '"', or '@', '%'
	//
	// For more information, see AUTH password at AUTH (http://redis.io/commands/AUTH).
	AuthToken *string `type:"string"`

	// Specifies the strategy to use to update the AUTH token. This parameter must
	// be specified with the auth-token parameter. Possible values:
	//
	//    * Rotate
	//
	//    * Set
	//
	// For more information, see Authenticating Users with Redis AUTH (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html)
	AuthTokenUpdateStrategy *string `type:"string" enum:"AuthTokenUpdateStrategyType"`

	// This parameter is currently disabled.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The cluster identifier. This value is stored as a lowercase string.
	//
	// CacheClusterId is a required field
	CacheClusterId *string `type:"string" required:"true"`

	// A list of cache node IDs to be removed. A node ID is a numeric identifier
	// (0001, 0002, etc.). This parameter is only valid when NumCacheNodes is less
	// than the existing number of cache nodes. The number of cache node IDs supplied
	// in this parameter must match the difference between the existing number of
	// cache nodes in the cluster or pending cache nodes, whichever is greater,
	// and the value of NumCacheNodes in the request.
	//
	// For example: If you have 3 active cache nodes, 7 pending cache nodes, and
	// the number of cache nodes in this ModifyCacheCluster call is 5, you must
	// list 2 (7 - 5) cache node IDs to remove.
	CacheNodeIdsToRemove []*string `locationNameList:"CacheNodeId" type:"list"`

	// A valid cache node type that you want to scale this cluster up to.
	CacheNodeType *string `type:"string"`

	// The name of the cache parameter group to apply to this cluster. This change
	// is asynchronously applied as soon as possible for parameters when the ApplyImmediately
	// parameter is specified as true for this request.
	CacheParameterGroupName *string `type:"string"`

	// A list of cache security group names to authorize on this cluster. This change
	// is asynchronously applied as soon as possible.
	//
	// You can use this parameter only with clusters that are created outside of
	// an Amazon Virtual Private Cloud (Amazon VPC).
	//
	// Constraints: Must contain no more than 255 alphanumeric characters. Must
	// not be "Default".
	CacheSecurityGroupNames []*string `locationNameList:"CacheSecurityGroupName" type:"list"`

	// The upgraded version of the cache engine to be run on the cache nodes.
	//
	// Important: You can upgrade to a newer engine version (see Selecting a Cache
	// Engine and Version (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement)),
	// but you cannot downgrade to an earlier engine version. If you want to use
	// an earlier engine version, you must delete the existing cluster and create
	// it anew with the earlier engine version.
	EngineVersion *string `type:"string"`

	// The list of Availability Zones where the new Memcached cache nodes are created.
	//
	// This parameter is only valid when NumCacheNodes in the request is greater
	// than the sum of the number of active cache nodes and the number of cache
	// nodes pending creation (which may be zero). The number of Availability Zones
	// supplied in this list must match the cache nodes being added in this request.
	//
	// This option is only supported on Memcached clusters.
	//
	// Scenarios:
	//
	//    * Scenario 1: You have 3 active nodes and wish to add 2 nodes. Specify
	//    NumCacheNodes=5 (3 + 2) and optionally specify two Availability Zones
	//    for the two new nodes.
	//
	//    * Scenario 2: You have 3 active nodes and 2 nodes pending creation (from
	//    the scenario 1 call) and want to add 1 more node. Specify NumCacheNodes=6
	//    ((3 + 2) + 1) and optionally specify an Availability Zone for the new
	//    node.
	//
	//    * Scenario 3: You want to cancel all pending operations. Specify NumCacheNodes=3
	//    to cancel all pending operations.
	//
	// The Availability Zone placement of nodes pending creation cannot be modified.
	// If you wish to cancel any nodes pending creation, add 0 nodes by setting
	// NumCacheNodes to the number of current nodes.
	//
	// If cross-az is specified, existing Memcached nodes remain in their current
	// Availability Zone. Only newly created nodes can be located in different Availability
	// Zones. For guidance on how to move existing Memcached nodes to different
	// Availability Zones, see the Availability Zone Considerations section of Cache
	// Node Considerations for Memcached (https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/CacheNodes.SupportedTypes.html).
	//
	// Impact of new add/remove requests upon pending requests
	//
	//    * Scenario-1 Pending Action: Delete New Request: Delete Result: The new
	//    delete, pending or immediate, replaces the pending delete.
	//
	//    * Scenario-2 Pending Action: Delete New Request: Create Result: The new
	//    create, pending or immediate, replaces the pending delete.
	//
	//    * Scenario-3 Pending Action: Create New Request: Delete Result: The new
	//    delete, pending or immediate, replaces the pending create.
	//
	//    * Scenario-4 Pending Action: Create New Request: Create Result: The new
	//    create is added to the pending create. Important: If the new create request
	//    is Apply Immediately - Yes, all creates are performed immediately. If
	//    the new create request is Apply Immediately - No, all creates are pending.
	NewAvailabilityZones []*string `locationNameList:"PreferredAvailabilityZone" type:"list"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications
	// are sent.
	//
	// The Amazon SNS topic owner must be same as the cluster owner.
	NotificationTopicArn *string `type:"string"`

	// The status of the Amazon SNS notification topic. Notifications are sent only
	// if the status is active.
	//
	// Valid values: active | inactive
	NotificationTopicStatus *string `type:"string"`

	// The number of cache nodes that the cluster should have. If the value for
	// NumCacheNodes is greater than the sum of the number of current cache nodes
	// and the number of cache nodes pending creation (which may be zero), more
	// nodes are added. If the value is less than the number of existing cache nodes,
	// nodes are removed. If the value is equal to the number of current cache nodes,
	// any pending add or remove requests are canceled.
	//
	// If you are removing cache nodes, you must use the CacheNodeIdsToRemove parameter
	// to provide the IDs of the specific cache nodes to remove.
	//
	// For clusters running Redis, this value must be 1. For clusters running Memcached,
	// this value must be between 1 and 20.
	//
	// Adding or removing Memcached cache nodes can be applied immediately or as
	// a pending operation (see ApplyImmediately).
	//
	// A pending operation to modify the number of cache nodes in a cluster during
	// its maintenance window, whether by adding or removing nodes in accordance
	// with the scale out architecture, is not queued. The customer's latest request
	// to add or remove nodes to the cluster overrides any previous pending operations
	// to modify the number of cache nodes in the cluster. For example, a request
	// to remove 2 nodes would override a previous pending operation to remove 3
	// nodes. Similarly, a request to add 2 nodes would override a previous pending
	// operation to remove 3 nodes and vice versa. As Memcached cache nodes may
	// now be provisioned in different Availability Zones with flexible cache node
	// placement, a request to add nodes does not automatically override a previous
	// pending operation to add nodes. The customer can modify the previous pending
	// operation to add more nodes or explicitly cancel the pending request and
	// retry the new request. To cancel pending operations to modify the number
	// of cache nodes in a cluster, use the ModifyCacheCluster request and set NumCacheNodes
	// equal to the number of cache nodes currently in the cluster.
	NumCacheNodes *int64 `type:"integer"`

	// Specifies the weekly time range during which maintenance on the cluster is
	// performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi
	// (24H Clock UTC). The minimum maintenance window is a 60 minute period.
	//
	// Valid values for ddd are:
	//
	//    * sun
	//
	//    * mon
	//
	//    * tue
	//
	//    * wed
	//
	//    * thu
	//
	//    * fri
	//
	//    * sat
	//
	// Example: sun:23:00-mon:01:30
	PreferredMaintenanceWindow *string `type:"string"`

	// Specifies the VPC Security Groups associated with the cluster.
	//
	// This parameter can be used only with clusters that are created in an Amazon
	// Virtual Private Cloud (Amazon VPC).
	SecurityGroupIds []*string `locationNameList:"SecurityGroupId" type:"list"`

	// The number of days for which ElastiCache retains automatic cluster snapshots
	// before deleting them. For example, if you set SnapshotRetentionLimit to 5,
	// a snapshot that was taken today is retained for 5 days before being deleted.
	//
	// If the value of SnapshotRetentionLimit is set to zero (0), backups are turned
	// off.
	SnapshotRetentionLimit *int64 `type:"integer"`

	// The daily time range (in UTC) during which ElastiCache begins taking a daily
	// snapshot of your cluster.
	SnapshotWindow *string `type:"string"`
}

// String returns the string representation
func (s ModifyCacheClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyCacheClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyCacheClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyCacheClusterInput"}
	if s.CacheClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("CacheClusterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAZMode sets the AZMode field's value.
func (s *ModifyCacheClusterInput) SetAZMode(v string) *ModifyCacheClusterInput {
	s.AZMode = &v
	return s
}

// SetApplyImmediately sets the ApplyImmediately field's value.
func (s *ModifyCacheClusterInput) SetApplyImmediately(v bool) *ModifyCacheClusterInput {
	s.ApplyImmediately = &v
	return s
}

// SetAuthToken sets the AuthToken field's value.
func (s *ModifyCacheClusterInput) SetAuthToken(v string) *ModifyCacheClusterInput {
	s.AuthToken = &v
	return s
}

// SetAuthTokenUpdateStrategy sets the AuthTokenUpdateStrategy field's value.
func (s *ModifyCacheClusterInput) SetAuthTokenUpdateStrategy(v string) *ModifyCacheClusterInput {
	s.AuthTokenUpdateStrategy = &v
	return s
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *ModifyCacheClusterInput) SetAutoMinorVersionUpgrade(v bool) *ModifyCacheClusterInput {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetCacheClusterId sets the CacheClusterId field's value.
func (s *ModifyCacheClusterInput) SetCacheClusterId(v string) *ModifyCacheClusterInput {
	s.CacheClusterId = &v
	return s
}

// SetCacheNodeIdsToRemove sets the CacheNodeIdsToRemove field's value.
func (s *ModifyCacheClusterInput) SetCacheNodeIdsToRemove(v []*string) *ModifyCacheClusterInput {
	s.CacheNodeIdsToRemove = v
	return s
}

// SetCacheNodeType sets the CacheNodeType field's value.
func (s *ModifyCacheClusterInput) SetCacheNodeType(v string) *ModifyCacheClusterInput {
	s.CacheNodeType = &v
	return s
}

// SetCacheParameterGroupName sets the CacheParameterGroupName field's value.
func (s *ModifyCacheClusterInput) SetCacheParameterGroupName(v string) *ModifyCacheClusterInput {
	s.CacheParameterGroupName = &v
	return s
}

// SetCacheSecurityGroupNames sets the CacheSecurityGroupNames field's value.
func (s *ModifyCacheClusterInput) SetCacheSecurityGroupNames(v []*string) *ModifyCacheClusterInput {
	s.CacheSecurityGroupNames = v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *ModifyCacheClusterInput) SetEngineVersion(v string) *ModifyCacheClusterInput {
	s.EngineVersion = &v
	return s
}

// SetNewAvailabilityZones sets the NewAvailabilityZones field's value.
func (s *ModifyCacheClusterInput) SetNewAvailabilityZones(v []*string) *ModifyCacheClusterInput {
	s.NewAvailabilityZones = v
	return s
}

// SetNotificationTopicArn sets the NotificationTopicArn field's value.
func (s *ModifyCacheClusterInput) SetNotificationTopicArn(v string) *ModifyCacheClusterInput {
	s.NotificationTopicArn = &v
	return s
}

// SetNotificationTopicStatus sets the NotificationTopicStatus field's value.
func (s *ModifyCacheClusterInput) SetNotificationTopicStatus(v string) *ModifyCacheClusterInput {
	s.NotificationTopicStatus = &v
	return s
}

// SetNumCacheNodes sets the NumCacheNodes field's value.
func (s *ModifyCacheClusterInput) SetNumCacheNodes(v int64) *ModifyCacheClusterInput {
	s.NumCacheNodes = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *ModifyCacheClusterInput) SetPreferredMaintenanceWindow(v string) *ModifyCacheClusterInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *ModifyCacheClusterInput) SetSecurityGroupIds(v []*string) *ModifyCacheClusterInput {
	s.SecurityGroupIds = v
	return s
}

// SetSnapshotRetentionLimit sets the SnapshotRetentionLimit field's value.
func (s *ModifyCacheClusterInput) SetSnapshotRetentionLimit(v int64) *ModifyCacheClusterInput {
	s.SnapshotRetentionLimit = &v
	return s
}

// SetSnapshotWindow sets the SnapshotWindow field's value.
func (s *ModifyCacheClusterInput) SetSnapshotWindow(v string) *ModifyCacheClusterInput {
	s.SnapshotWindow = &v
	return s
}

type ModifyCacheClusterOutput struct {
	_ struct{} `type:"structure"`

	// Contains all of the attributes of a specific cluster.
	CacheCluster *CacheCluster `type:"structure"`
}

// String returns the string representation
func (s ModifyCacheClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyCacheClusterOutput) GoString() string {
	return s.String()
}

// SetCacheCluster sets the CacheCluster field's value.
func (s *ModifyCacheClusterOutput) SetCacheCluster(v *CacheCluster) *ModifyCacheClusterOutput {
	s.CacheCluster = v
	return s
}

// Represents the input of a ModifyCacheParameterGroup operation.
type ModifyCacheParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the cache parameter group to modify.
	//
	// CacheParameterGroupName is a required field
	CacheParameterGroupName *string `type:"string" required:"true"`

	// An array of parameter names and values for the parameter update. You must
	// supply at least one parameter name and value; subsequent arguments are optional.
	// A maximum of 20 parameters may be modified per request.
	//
	// ParameterNameValues is a required field
	ParameterNameValues []*ParameterNameValue `locationNameList:"ParameterNameValue" type:"list" required:"true"`
}

// String returns the string representation
func (s ModifyCacheParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyCacheParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyCacheParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyCacheParameterGroupInput"}
	if s.CacheParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("CacheParameterGroupName"))
	}
	if s.ParameterNameValues == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterNameValues"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCacheParameterGroupName sets the CacheParameterGroupName field's value.
func (s *ModifyCacheParameterGroupInput) SetCacheParameterGroupName(v string) *ModifyCacheParameterGroupInput {
	s.CacheParameterGroupName = &v
	return s
}

// SetParameterNameValues sets the ParameterNameValues field's value.
func (s *ModifyCacheParameterGroupInput) SetParameterNameValues(v []*ParameterNameValue) *ModifyCacheParameterGroupInput {
	s.ParameterNameValues = v
	return s
}

// Represents the input of a ModifyCacheSubnetGroup operation.
type ModifyCacheSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// A description of the cache subnet group.
	CacheSubnetGroupDescription *string `type:"string"`

	// The name for the cache subnet group. This value is stored as a lowercase
	// string.
	//
	// Constraints: Must contain no more than 255 alphanumeric characters or hyphens.
	//
	// Example: mysubnetgroup
	//
	// CacheSubnetGroupName is a required field
	CacheSubnetGroupName *string `type:"string" required:"true"`

	// The EC2 subnet IDs for the cache subnet group.
	SubnetIds []*string `locationNameList:"SubnetIdentifier" type:"list"`
}

// String returns the string representation
func (s ModifyCacheSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyCacheSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyCacheSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyCacheSubnetGroupInput"}
	if s.CacheSubnetGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("CacheSubnetGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCacheSubnetGroupDescription sets the CacheSubnetGroupDescription field's value.
func (s *ModifyCacheSubnetGroupInput) SetCacheSubnetGroupDescription(v string) *ModifyCacheSubnetGroupInput {
	s.CacheSubnetGroupDescription = &v
	return s
}

// SetCacheSubnetGroupName sets the CacheSubnetGroupName field's value.
func (s *ModifyCacheSubnetGroupInput) SetCacheSubnetGroupName(v string) *ModifyCacheSubnetGroupInput {
	s.CacheSubnetGroupName = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *ModifyCacheSubnetGroupInput) SetSubnetIds(v []*string) *ModifyCacheSubnetGroupInput {
	s.SubnetIds = v
	return s
}

type ModifyCacheSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// Represents the output of one of the following operations:
	//
	//    * CreateCacheSubnetGroup
	//
	//    * ModifyCacheSubnetGroup
	CacheSubnetGroup *CacheSubnetGroup `type:"structure"`
}

// String returns the string representation
func (s ModifyCacheSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyCacheSubnetGroupOutput) GoString() string {
	return s.String()
}

// SetCacheSubnetGroup sets the CacheSubnetGroup field's value.
func (s *ModifyCacheSubnetGroupOutput) SetCacheSubnetGroup(v *CacheSubnetGroup) *ModifyCacheSubnetGroupOutput {
	s.CacheSubnetGroup = v
	return s
}

type ModifyGlobalReplicationGroupInput struct {
	_ struct{} `type:"structure"`

	// This parameter causes the modifications in this request and any pending modifications
	// to be applied, asynchronously and as soon as possible. Modifications to Global
	// Replication Groups cannot be requested to be applied in PreferredMaintenceWindow.
	//
	// ApplyImmediately is a required field
	ApplyImmediately *bool `type:"boolean" required:"true"`

	// Determines whether a read replica is automatically promoted to read/write
	// primary if the existing primary encounters a failure.
	AutomaticFailoverEnabled *bool `type:"boolean"`

	// A valid cache node type that you want to scale this Global Datastore to.
	CacheNodeType *string `type:"string"`

	// The upgraded version of the cache engine to be run on the clusters in the
	// Global Datastore.
	EngineVersion *string `type:"string"`

	// A description of the Global Datastore
	GlobalReplicationGroupDescription *string `type:"string"`

	// The name of the Global Datastore
	//
	// GlobalReplicationGroupId is a required field
	GlobalReplicationGroupId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyGlobalReplicationGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyGlobalReplicationGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyGlobalReplicationGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyGlobalReplicationGroupInput"}
	if s.ApplyImmediately == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplyImmediately"))
	}
	if s.GlobalReplicationGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GlobalReplicationGroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplyImmediately sets the ApplyImmediately field's value.
func (s *ModifyGlobalReplicationGroupInput) SetApplyImmediately(v bool) *ModifyGlobalReplicationGroupInput {
	s.ApplyImmediately = &v
	return s
}

// SetAutomaticFailoverEnabled sets the AutomaticFailoverEnabled field's value.
func (s *ModifyGlobalReplicationGroupInput) SetAutomaticFailoverEnabled(v bool) *ModifyGlobalReplicationGroupInput {
	s.AutomaticFailoverEnabled = &v
	return s
}

// SetCacheNodeType sets the CacheNodeType field's value.
func (s *ModifyGlobalReplicationGroupInput) SetCacheNodeType(v string) *ModifyGlobalReplicationGroupInput {
	s.CacheNodeType = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *ModifyGlobalReplicationGroupInput) SetEngineVersion(v string) *ModifyGlobalReplicationGroupInput {
	s.EngineVersion = &v
	return s
}

// SetGlobalReplicationGroupDescription sets the GlobalReplicationGroupDescription field's value.
func (s *ModifyGlobalReplicationGroupInput) SetGlobalReplicationGroupDescription(v string) *ModifyGlobalReplicationGroupInput {
	s.GlobalReplicationGroupDescription = &v
	return s
}

// SetGlobalReplicationGroupId sets the GlobalReplicationGroupId field's value.
func (s *ModifyGlobalReplicationGroupInput) SetGlobalReplicationGroupId(v string) *ModifyGlobalReplicationGroupInput {
	s.GlobalReplicationGroupId = &v
	return s
}

type ModifyGlobalReplicationGroupOutput struct {
	_ struct{} `type:"structure"`

	// Consists of a primary cluster that accepts writes and an associated secondary
	// cluster that resides in a different AWS region. The secondary cluster accepts
	// only reads. The primary cluster automatically replicates updates to the secondary
	// cluster.
	//
	//    * The GlobalReplicationGroupIdSuffix represents the name of the Global
	//    Datastore, which is what you use to associate a secondary cluster.
	GlobalReplicationGroup *GlobalReplicationGroup `type:"structure"`
}

// String returns the string representation
func (s ModifyGlobalReplicationGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyGlobalReplicationGroupOutput) GoString() string {
	return s.String()
}

// SetGlobalReplicationGroup sets the GlobalReplicationGroup field's value.
func (s *ModifyGlobalReplicationGroupOutput) SetGlobalReplicationGroup(v *GlobalReplicationGroup) *ModifyGlobalReplicationGroupOutput {
	s.GlobalReplicationGroup = v
	return s
}

// Represents the input of a ModifyReplicationGroups operation.
type ModifyReplicationGroupInput struct {
	_ struct{} `type:"structure"`

	// If true, this parameter causes the modifications in this request and any
	// pending modifications to be applied, asynchronously and as soon as possible,
	// regardless of the PreferredMaintenanceWindow setting for the replication
	// group.
	//
	// If false, changes to the nodes in the replication group are applied on the
	// next maintenance reboot, or the next failure reboot, whichever occurs first.
	//
	// Valid values: true | false
	//
	// Default: false
	ApplyImmediately *bool `type:"boolean"`

	// Reserved parameter. The password used to access a password protected server.
	// This parameter must be specified with the auth-token-update-strategy parameter.
	// Password constraints:
	//
	//    * Must be only printable ASCII characters
	//
	//    * Must be at least 16 characters and no more than 128 characters in length
	//
	//    * Cannot contain any of the following characters: '/', '"', or '@', '%'
	//
	// For more information, see AUTH password at AUTH (http://redis.io/commands/AUTH).
	AuthToken *string `type:"string"`

	// Specifies the strategy to use to update the AUTH token. This parameter must
	// be specified with the auth-token parameter. Possible values:
	//
	//    * Rotate
	//
	//    * Set
	//
	// For more information, see Authenticating Users with Redis AUTH (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html)
	AuthTokenUpdateStrategy *string `type:"string" enum:"AuthTokenUpdateStrategyType"`

	// This parameter is currently disabled.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// Determines whether a read replica is automatically promoted to read/write
	// primary if the existing primary encounters a failure.
	//
	// Valid values: true | false
	AutomaticFailoverEnabled *bool `type:"boolean"`

	// A valid cache node type that you want to scale this replication group to.
	CacheNodeType *string `type:"string"`

	// The name of the cache parameter group to apply to all of the clusters in
	// this replication group. This change is asynchronously applied as soon as
	// possible for parameters when the ApplyImmediately parameter is specified
	// as true for this request.
	CacheParameterGroupName *string `type:"string"`

	// A list of cache security group names to authorize for the clusters in this
	// replication group. This change is asynchronously applied as soon as possible.
	//
	// This parameter can be used only with replication group containing clusters
	// running outside of an Amazon Virtual Private Cloud (Amazon VPC).
	//
	// Constraints: Must contain no more than 255 alphanumeric characters. Must
	// not be Default.
	CacheSecurityGroupNames []*string `locationNameList:"CacheSecurityGroupName" type:"list"`

	// The upgraded version of the cache engine to be run on the clusters in the
	// replication group.
	//
	// Important: You can upgrade to a newer engine version (see Selecting a Cache
	// Engine and Version (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement)),
	// but you cannot downgrade to an earlier engine version. If you want to use
	// an earlier engine version, you must delete the existing replication group
	// and create it anew with the earlier engine version.
	EngineVersion *string `type:"string"`

	// A flag indicating if you have Multi-AZ enabled to enhance fault tolerance.
	// For more information, see Minimizing Downtime: Multi-AZ (http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html).
	MultiAZEnabled *bool `type:"boolean"`

	// Deprecated. This parameter is not used.
	//
	// Deprecated: NodeGroupId has been deprecated
	NodeGroupId *string `deprecated:"true" type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications
	// are sent.
	//
	// The Amazon SNS topic owner must be same as the replication group owner.
	NotificationTopicArn *string `type:"string"`

	// The status of the Amazon SNS notification topic for the replication group.
	// Notifications are sent only if the status is active.
	//
	// Valid values: active | inactive
	NotificationTopicStatus *string `type:"string"`

	// Specifies the weekly time range during which maintenance on the cluster is
	// performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi
	// (24H Clock UTC). The minimum maintenance window is a 60 minute period.
	//
	// Valid values for ddd are:
	//
	//    * sun
	//
	//    * mon
	//
	//    * tue
	//
	//    * wed
	//
	//    * thu
	//
	//    * fri
	//
	//    * sat
	//
	// Example: sun:23:00-mon:01:30
	PreferredMaintenanceWindow *string `type:"string"`

	// For replication groups with a single primary, if this parameter is specified,
	// ElastiCache promotes the specified cluster in the specified replication group
	// to the primary role. The nodes of all other clusters in the replication group
	// are read replicas.
	PrimaryClusterId *string `type:"string"`

	// A description for the replication group. Maximum length is 255 characters.
	ReplicationGroupDescription *string `type:"string"`

	// The identifier of the replication group to modify.
	//
	// ReplicationGroupId is a required field
	ReplicationGroupId *string `type:"string" required:"true"`

	// Specifies the VPC Security Groups associated with the clusters in the replication
	// group.
	//
	// This parameter can be used only with replication group containing clusters
	// running in an Amazon Virtual Private Cloud (Amazon VPC).
	SecurityGroupIds []*string `locationNameList:"SecurityGroupId" type:"list"`

	// The number of days for which ElastiCache retains automatic node group (shard)
	// snapshots before deleting them. For example, if you set SnapshotRetentionLimit
	// to 5, a snapshot that was taken today is retained for 5 days before being
	// deleted.
	//
	// Important If the value of SnapshotRetentionLimit is set to zero (0), backups
	// are turned off.
	SnapshotRetentionLimit *int64 `type:"integer"`

	// The daily time range (in UTC) during which ElastiCache begins taking a daily
	// snapshot of the node group (shard) specified by SnapshottingClusterId.
	//
	// Example: 05:00-09:00
	//
	// If you do not specify this parameter, ElastiCache automatically chooses an
	// appropriate time range.
	SnapshotWindow *string `type:"string"`

	// The cluster ID that is used as the daily snapshot source for the replication
	// group. This parameter cannot be set for Redis (cluster mode enabled) replication
	// groups.
	SnapshottingClusterId *string `type:"string"`
}

// String returns the string representation
func (s ModifyReplicationGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyReplicationGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyReplicationGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyReplicationGroupInput"}
	if s.ReplicationGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationGroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplyImmediately sets the ApplyImmediately field's value.
func (s *ModifyReplicationGroupInput) SetApplyImmediately(v bool) *ModifyReplicationGroupInput {
	s.ApplyImmediately = &v
	return s
}

// SetAuthToken sets the AuthToken field's value.
func (s *ModifyReplicationGroupInput) SetAuthToken(v string) *ModifyReplicationGroupInput {
	s.AuthToken = &v
	return s
}

// SetAuthTokenUpdateStrategy sets the AuthTokenUpdateStrategy field's value.
func (s *ModifyReplicationGroupInput) SetAuthTokenUpdateStrategy(v string) *ModifyReplicationGroupInput {
	s.AuthTokenUpdateStrategy = &v
	return s
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *ModifyReplicationGroupInput) SetAutoMinorVersionUpgrade(v bool) *ModifyReplicationGroupInput {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetAutomaticFailoverEnabled sets the AutomaticFailoverEnabled field's value.
func (s *ModifyReplicationGroupInput) SetAutomaticFailoverEnabled(v bool) *ModifyReplicationGroupInput {
	s.AutomaticFailoverEnabled = &v
	return s
}

// SetCacheNodeType sets the CacheNodeType field's value.
func (s *ModifyReplicationGroupInput) SetCacheNodeType(v string) *ModifyReplicationGroupInput {
	s.CacheNodeType = &v
	return s
}

// SetCacheParameterGroupName sets the CacheParameterGroupName field's value.
func (s *ModifyReplicationGroupInput) SetCacheParameterGroupName(v string) *ModifyReplicationGroupInput {
	s.CacheParameterGroupName = &v
	return s
}

// SetCacheSecurityGroupNames sets the CacheSecurityGroupNames field's value.
func (s *ModifyReplicationGroupInput) SetCacheSecurityGroupNames(v []*string) *ModifyReplicationGroupInput {
	s.CacheSecurityGroupNames = v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *ModifyReplicationGroupInput) SetEngineVersion(v string) *ModifyReplicationGroupInput {
	s.EngineVersion = &v
	return s
}

// SetMultiAZEnabled sets the MultiAZEnabled field's value.
func (s *ModifyReplicationGroupInput) SetMultiAZEnabled(v bool) *ModifyReplicationGroupInput {
	s.MultiAZEnabled = &v
	return s
}

// SetNodeGroupId sets the NodeGroupId field's value.
func (s *ModifyReplicationGroupInput) SetNodeGroupId(v string) *ModifyReplicationGroupInput {
	s.NodeGroupId = &v
	return s
}

// SetNotificationTopicArn sets the NotificationTopicArn field's value.
func (s *ModifyReplicationGroupInput) SetNotificationTopicArn(v string) *ModifyReplicationGroupInput {
	s.NotificationTopicArn = &v
	return s
}

// SetNotificationTopicStatus sets the NotificationTopicStatus field's value.
func (s *ModifyReplicationGroupInput) SetNotificationTopicStatus(v string) *ModifyReplicationGroupInput {
	s.NotificationTopicStatus = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *ModifyReplicationGroupInput) SetPreferredMaintenanceWindow(v string) *ModifyReplicationGroupInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPrimaryClusterId sets the PrimaryClusterId field's value.
func (s *ModifyReplicationGroupInput) SetPrimaryClusterId(v string) *ModifyReplicationGroupInput {
	s.PrimaryClusterId = &v
	return s
}

// SetReplicationGroupDescription sets the ReplicationGroupDescription field's value.
func (s *ModifyReplicationGroupInput) SetReplicationGroupDescription(v string) *ModifyReplicationGroupInput {
	s.ReplicationGroupDescription = &v
	return s
}

// SetReplicationGroupId sets the ReplicationGroupId field's value.
func (s *ModifyReplicationGroupInput) SetReplicationGroupId(v string) *ModifyReplicationGroupInput {
	s.ReplicationGroupId = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *ModifyReplicationGroupInput) SetSecurityGroupIds(v []*string) *ModifyReplicationGroupInput {
	s.SecurityGroupIds = v
	return s
}

// SetSnapshotRetentionLimit sets the SnapshotRetentionLimit field's value.
func (s *ModifyReplicationGroupInput) SetSnapshotRetentionLimit(v int64) *ModifyReplicationGroupInput {
	s.SnapshotRetentionLimit = &v
	return s
}

// SetSnapshotWindow sets the SnapshotWindow field's value.
func (s *ModifyReplicationGroupInput) SetSnapshotWindow(v string) *ModifyReplicationGroupInput {
	s.SnapshotWindow = &v
	return s
}

// SetSnapshottingClusterId sets the SnapshottingClusterId field's value.
func (s *ModifyReplicationGroupInput) SetSnapshottingClusterId(v string) *ModifyReplicationGroupInput {
	s.SnapshottingClusterId = &v
	return s
}

type ModifyReplicationGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains all of the attributes of a specific Redis replication group.
	ReplicationGroup *ReplicationGroup `type:"structure"`
}

// String returns the string representation
func (s ModifyReplicationGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyReplicationGroupOutput) GoString() string {
	return s.String()
}

// SetReplicationGroup sets the ReplicationGroup field's value.
func (s *ModifyReplicationGroupOutput) SetReplicationGroup(v *ReplicationGroup) *ModifyReplicationGroupOutput {
	s.ReplicationGroup = v
	return s
}

// Represents the input for a ModifyReplicationGroupShardConfiguration operation.
type ModifyReplicationGroupShardConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Indicates that the shard reconfiguration process begins immediately. At present,
	// the only permitted value for this parameter is true.
	//
	// Value: true
	//
	// ApplyImmediately is a required field
	ApplyImmediately *bool `type:"boolean" required:"true"`

	// The number of node groups (shards) that results from the modification of
	// the shard configuration.
	//
	// NodeGroupCount is a required field
	NodeGroupCount *int64 `type:"integer" required:"true"`

	// If the value of NodeGroupCount is less than the current number of node groups
	// (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is required.
	// NodeGroupsToRemove is a list of NodeGroupIds to remove from the cluster.
	//
	// ElastiCache for Redis will attempt to remove all node groups listed by NodeGroupsToRemove
	// from the cluster.
	NodeGroupsToRemove []*string `locationNameList:"NodeGroupToRemove" type:"list"`

	// If the value of NodeGroupCount is less than the current number of node groups
	// (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is required.
	// NodeGroupsToRetain is a list of NodeGroupIds to retain in the cluster.
	//
	// ElastiCache for Redis will attempt to remove all node groups except those
	// listed by NodeGroupsToRetain from the cluster.
	NodeGroupsToRetain []*string `locationNameList:"NodeGroupToRetain" type:"list"`

	// The name of the Redis (cluster mode enabled) cluster (replication group)
	// on which the shards are to be configured.
	//
	// ReplicationGroupId is a required field
	ReplicationGroupId *string `type:"string" required:"true"`

	// Specifies the preferred availability zones for each node group in the cluster.
	// If the value of NodeGroupCount is greater than the current number of node
	// groups (shards), you can use this parameter to specify the preferred availability
	// zones of the cluster's shards. If you omit this parameter ElastiCache selects
	// availability zones for you.
	//
	// You can specify this parameter only if the value of NodeGroupCount is greater
	// than the current number of node groups (shards).
	ReshardingConfiguration []*ReshardingConfiguration `locationNameList:"ReshardingConfiguration" type:"list"`
}

// String returns the string representation
func (s ModifyReplicationGroupShardConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyReplicationGroupShardConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyReplicationGroupShardConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyReplicationGroupShardConfigurationInput"}
	if s.ApplyImmediately == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplyImmediately"))
	}
	if s.NodeGroupCount == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeGroupCount"))
	}
	if s.ReplicationGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationGroupId"))
	}
	if s.ReshardingConfiguration != nil {
		for i, v := range s.ReshardingConfiguration {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ReshardingConfiguration", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplyImmediately sets the ApplyImmediately field's value.
func (s *ModifyReplicationGroupShardConfigurationInput) SetApplyImmediately(v bool) *ModifyReplicationGroupShardConfigurationInput {
	s.ApplyImmediately = &v
	return s
}

// SetNodeGroupCount sets the NodeGroupCount field's value.
func (s *ModifyReplicationGroupShardConfigurationInput) SetNodeGroupCount(v int64) *ModifyReplicationGroupShardConfigurationInput {
	s.NodeGroupCount = &v
	return s
}

// SetNodeGroupsToRemove sets the NodeGroupsToRemove field's value.
func (s *ModifyReplicationGroupShardConfigurationInput) SetNodeGroupsToRemove(v []*string) *ModifyReplicationGroupShardConfigurationInput {
	s.NodeGroupsToRemove = v
	return s
}

// SetNodeGroupsToRetain sets the NodeGroupsToRetain field's value.
func (s *ModifyReplicationGroupShardConfigurationInput) SetNodeGroupsToRetain(v []*string) *ModifyReplicationGroupShardConfigurationInput {
	s.NodeGroupsToRetain = v
	return s
}

// SetReplicationGroupId sets the ReplicationGroupId field's value.
func (s *ModifyReplicationGroupShardConfigurationInput) SetReplicationGroupId(v string) *ModifyReplicationGroupShardConfigurationInput {
	s.ReplicationGroupId = &v
	return s
}

// SetReshardingConfiguration sets the ReshardingConfiguration field's value.
func (s *ModifyReplicationGroupShardConfigurationInput) SetReshardingConfiguration(v []*ReshardingConfiguration) *ModifyReplicationGroupShardConfigurationInput {
	s.ReshardingConfiguration = v
	return s
}

type ModifyReplicationGroupShardConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Contains all of the attributes of a specific Redis replication group.
	ReplicationGroup *ReplicationGroup `type:"structure"`
}

// String returns the string representation
func (s ModifyReplicationGroupShardConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyReplicationGroupShardConfigurationOutput) GoString() string {
	return s.String()
}

// SetReplicationGroup sets the ReplicationGroup field's value.
func (s *ModifyReplicationGroupShardConfigurationOutput) SetReplicationGroup(v *ReplicationGroup) *ModifyReplicationGroupShardConfigurationOutput {
	s.ReplicationGroup = v
	return s
}

// Represents a collection of cache nodes in a replication group. One node in
// the node group is the read/write primary node. All the other nodes are read-only
// Replica nodes.
type NodeGroup struct {
	_ struct{} `type:"structure"`

	// The identifier for the node group (shard). A Redis (cluster mode disabled)
	// replication group contains only 1 node group; therefore, the node group ID
	// is 0001. A Redis (cluster mode enabled) replication group contains 1 to 90
	// node groups numbered 0001 to 0090. Optionally, the user can provide the id
	// for a node group.
	NodeGroupId *string `type:"string"`

	// A list containing information about individual nodes within the node group
	// (shard).
	NodeGroupMembers []*NodeGroupMember `locationNameList:"NodeGroupMember" type:"list"`

	// The endpoint of the primary node in this node group (shard).
	PrimaryEndpoint *Endpoint `type:"structure"`

	// The endpoint of the replica nodes in this node group (shard).
	ReaderEndpoint *Endpoint `type:"structure"`

	// The keyspace for this node group (shard).
	Slots *string `type:"string"`

	// The current state of this replication group - creating, available, modifying,
	// deleting.
	Status *string `type:"string"`
}

// String returns the string representation
func (s NodeGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeGroup) GoString() string {
	return s.String()
}

// SetNodeGroupId sets the NodeGroupId field's value.
func (s *NodeGroup) SetNodeGroupId(v string) *NodeGroup {
	s.NodeGroupId = &v
	return s
}

// SetNodeGroupMembers sets the NodeGroupMembers field's value.
func (s *NodeGroup) SetNodeGroupMembers(v []*NodeGroupMember) *NodeGroup {
	s.NodeGroupMembers = v
	return s
}

// SetPrimaryEndpoint sets the PrimaryEndpoint field's value.
func (s *NodeGroup) SetPrimaryEndpoint(v *Endpoint) *NodeGroup {
	s.PrimaryEndpoint = v
	return s
}

// SetReaderEndpoint sets the ReaderEndpoint field's value.
func (s *NodeGroup) SetReaderEndpoint(v *Endpoint) *NodeGroup {
	s.ReaderEndpoint = v
	return s
}

// SetSlots sets the Slots field's value.
func (s *NodeGroup) SetSlots(v string) *NodeGroup {
	s.Slots = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *NodeGroup) SetStatus(v string) *NodeGroup {
	s.Status = &v
	return s
}

// Node group (shard) configuration options. Each node group (shard) configuration
// has the following: Slots, PrimaryAvailabilityZone, ReplicaAvailabilityZones,
// ReplicaCount.
type NodeGroupConfiguration struct {
	_ struct{} `type:"structure"`

	// Either the ElastiCache for Redis supplied 4-digit id or a user supplied id
	// for the node group these configuration values apply to.
	NodeGroupId *string `min:"1" type:"string"`

	// The Availability Zone where the primary node of this node group (shard) is
	// launched.
	PrimaryAvailabilityZone *string `type:"string"`

	// A list of Availability Zones to be used for the read replicas. The number
	// of Availability Zones in this list must match the value of ReplicaCount or
	// ReplicasPerNodeGroup if not specified.
	ReplicaAvailabilityZones []*string `locationNameList:"AvailabilityZone" type:"list"`

	// The number of read replica nodes in this node group (shard).
	ReplicaCount *int64 `type:"integer"`

	// A string that specifies the keyspace for a particular node group. Keyspaces
	// range from 0 to 16,383. The string is in the format startkey-endkey.
	//
	// Example: "0-3999"
	Slots *string `type:"string"`
}

// String returns the string representation
func (s NodeGroupConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeGroupConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NodeGroupConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NodeGroupConfiguration"}
	if s.NodeGroupId != nil && len(*s.NodeGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NodeGroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNodeGroupId sets the NodeGroupId field's value.
func (s *NodeGroupConfiguration) SetNodeGroupId(v string) *NodeGroupConfiguration {
	s.NodeGroupId = &v
	return s
}

// SetPrimaryAvailabilityZone sets the PrimaryAvailabilityZone field's value.
func (s *NodeGroupConfiguration) SetPrimaryAvailabilityZone(v string) *NodeGroupConfiguration {
	s.PrimaryAvailabilityZone = &v
	return s
}

// SetReplicaAvailabilityZones sets the ReplicaAvailabilityZones field's value.
func (s *NodeGroupConfiguration) SetReplicaAvailabilityZones(v []*string) *NodeGroupConfiguration {
	s.ReplicaAvailabilityZones = v
	return s
}

// SetReplicaCount sets the ReplicaCount field's value.
func (s *NodeGroupConfiguration) SetReplicaCount(v int64) *NodeGroupConfiguration {
	s.ReplicaCount = &v
	return s
}

// SetSlots sets the Slots field's value.
func (s *NodeGroupConfiguration) SetSlots(v string) *NodeGroupConfiguration {
	s.Slots = &v
	return s
}

// Represents a single node within a node group (shard).
type NodeGroupMember struct {
	_ struct{} `type:"structure"`

	// The ID of the cluster to which the node belongs.
	CacheClusterId *string `type:"string"`

	// The ID of the node within its cluster. A node ID is a numeric identifier
	// (0001, 0002, etc.).
	CacheNodeId *string `type:"string"`

	// The role that is currently assigned to the node - primary or replica. This
	// member is only applicable for Redis (cluster mode disabled) replication groups.
	CurrentRole *string `type:"string"`

	// The name of the Availability Zone in which the node is located.
	PreferredAvailabilityZone *string `type:"string"`

	// The information required for client programs to connect to a node for read
	// operations. The read endpoint is only applicable on Redis (cluster mode disabled)
	// clusters.
	ReadEndpoint *Endpoint `type:"structure"`
}

// String returns the string representation
func (s NodeGroupMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeGroupMember) GoString() string {
	return s.String()
}

// SetCacheClusterId sets the CacheClusterId field's value.
func (s *NodeGroupMember) SetCacheClusterId(v string) *NodeGroupMember {
	s.CacheClusterId = &v
	return s
}

// SetCacheNodeId sets the CacheNodeId field's value.
func (s *NodeGroupMember) SetCacheNodeId(v string) *NodeGroupMember {
	s.CacheNodeId = &v
	return s
}

// SetCurrentRole sets the CurrentRole field's value.
func (s *NodeGroupMember) SetCurrentRole(v string) *NodeGroupMember {
	s.CurrentRole = &v
	return s
}

// SetPreferredAvailabilityZone sets the PreferredAvailabilityZone field's value.
func (s *NodeGroupMember) SetPreferredAvailabilityZone(v string) *NodeGroupMember {
	s.PreferredAvailabilityZone = &v
	return s
}

// SetReadEndpoint sets the ReadEndpoint field's value.
func (s *NodeGroupMember) SetReadEndpoint(v *Endpoint) *NodeGroupMember {
	s.ReadEndpoint = v
	return s
}

// The status of the service update on the node group member
type NodeGroupMemberUpdateStatus struct {
	_ struct{} `type:"structure"`

	// The cache cluster ID
	CacheClusterId *string `type:"string"`

	// The node ID of the cache cluster
	CacheNodeId *string `type:"string"`

	// The deletion date of the node
	NodeDeletionDate *time.Time `type:"timestamp"`

	// The end date of the update for a node
	NodeUpdateEndDate *time.Time `type:"timestamp"`

	// Reflects whether the update was initiated by the customer or automatically
	// applied
	NodeUpdateInitiatedBy *string `type:"string" enum:"NodeUpdateInitiatedBy"`

	// The date when the update is triggered
	NodeUpdateInitiatedDate *time.Time `type:"timestamp"`

	// The start date of the update for a node
	NodeUpdateStartDate *time.Time `type:"timestamp"`

	// The update status of the node
	NodeUpdateStatus *string `type:"string" enum:"NodeUpdateStatus"`

	// The date when the NodeUpdateStatus was last modified
	NodeUpdateStatusModifiedDate *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s NodeGroupMemberUpdateStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeGroupMemberUpdateStatus) GoString() string {
	return s.String()
}

// SetCacheClusterId sets the CacheClusterId field's value.
func (s *NodeGroupMemberUpdateStatus) SetCacheClusterId(v string) *NodeGroupMemberUpdateStatus {
	s.CacheClusterId = &v
	return s
}

// SetCacheNodeId sets the CacheNodeId field's value.
func (s *NodeGroupMemberUpdateStatus) SetCacheNodeId(v string) *NodeGroupMemberUpdateStatus {
	s.CacheNodeId = &v
	return s
}

// SetNodeDeletionDate sets the NodeDeletionDate field's value.
func (s *NodeGroupMemberUpdateStatus) SetNodeDeletionDate(v time.Time) *NodeGroupMemberUpdateStatus {
	s.NodeDeletionDate = &v
	return s
}

// SetNodeUpdateEndDate sets the NodeUpdateEndDate field's value.
func (s *NodeGroupMemberUpdateStatus) SetNodeUpdateEndDate(v time.Time) *NodeGroupMemberUpdateStatus {
	s.NodeUpdateEndDate = &v
	return s
}

// SetNodeUpdateInitiatedBy sets the NodeUpdateInitiatedBy field's value.
func (s *NodeGroupMemberUpdateStatus) SetNodeUpdateInitiatedBy(v string) *NodeGroupMemberUpdateStatus {
	s.NodeUpdateInitiatedBy = &v
	return s
}

// SetNodeUpdateInitiatedDate sets the NodeUpdateInitiatedDate field's value.
func (s *NodeGroupMemberUpdateStatus) SetNodeUpdateInitiatedDate(v time.Time) *NodeGroupMemberUpdateStatus {
	s.NodeUpdateInitiatedDate = &v
	return s
}

// SetNodeUpdateStartDate sets the NodeUpdateStartDate field's value.
func (s *NodeGroupMemberUpdateStatus) SetNodeUpdateStartDate(v time.Time) *NodeGroupMemberUpdateStatus {
	s.NodeUpdateStartDate = &v
	return s
}

// SetNodeUpdateStatus sets the NodeUpdateStatus field's value.
func (s *NodeGroupMemberUpdateStatus) SetNodeUpdateStatus(v string) *NodeGroupMemberUpdateStatus {
	s.NodeUpdateStatus = &v
	return s
}

// SetNodeUpdateStatusModifiedDate sets the NodeUpdateStatusModifiedDate field's value.
func (s *NodeGroupMemberUpdateStatus) SetNodeUpdateStatusModifiedDate(v time.Time) *NodeGroupMemberUpdateStatus {
	s.NodeUpdateStatusModifiedDate = &v
	return s
}

// The status of the service update on the node group
type NodeGroupUpdateStatus struct {
	_ struct{} `type:"structure"`

	// The ID of the node group
	NodeGroupId *string `type:"string"`

	// The status of the service update on the node group member
	NodeGroupMemberUpdateStatus []*NodeGroupMemberUpdateStatus `locationNameList:"NodeGroupMemberUpdateStatus" type:"list"`
}

// String returns the string representation
func (s NodeGroupUpdateStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeGroupUpdateStatus) GoString() string {
	return s.String()
}

// SetNodeGroupId sets the NodeGroupId field's value.
func (s *NodeGroupUpdateStatus) SetNodeGroupId(v string) *NodeGroupUpdateStatus {
	s.NodeGroupId = &v
	return s
}

// SetNodeGroupMemberUpdateStatus sets the NodeGroupMemberUpdateStatus field's value.
func (s *NodeGroupUpdateStatus) SetNodeGroupMemberUpdateStatus(v []*NodeGroupMemberUpdateStatus) *NodeGroupUpdateStatus {
	s.NodeGroupMemberUpdateStatus = v
	return s
}

// Represents an individual cache node in a snapshot of a cluster.
type NodeSnapshot struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the source cluster.
	CacheClusterId *string `type:"string"`

	// The date and time when the cache node was created in the source cluster.
	CacheNodeCreateTime *time.Time `type:"timestamp"`

	// The cache node identifier for the node in the source cluster.
	CacheNodeId *string `type:"string"`

	// The size of the cache on the source cache node.
	CacheSize *string `type:"string"`

	// The configuration for the source node group (shard).
	NodeGroupConfiguration *NodeGroupConfiguration `type:"structure"`

	// A unique identifier for the source node group (shard).
	NodeGroupId *string `type:"string"`

	// The date and time when the source node's metadata and cache data set was
	// obtained for the snapshot.
	SnapshotCreateTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s NodeSnapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeSnapshot) GoString() string {
	return s.String()
}

// SetCacheClusterId sets the CacheClusterId field's value.
func (s *NodeSnapshot) SetCacheClusterId(v string) *NodeSnapshot {
	s.CacheClusterId = &v
	return s
}

// SetCacheNodeCreateTime sets the CacheNodeCreateTime field's value.
func (s *NodeSnapshot) SetCacheNodeCreateTime(v time.Time) *NodeSnapshot {
	s.CacheNodeCreateTime = &v
	return s
}

// SetCacheNodeId sets the CacheNodeId field's value.
func (s *NodeSnapshot) SetCacheNodeId(v string) *NodeSnapshot {
	s.CacheNodeId = &v
	return s
}

// SetCacheSize sets the CacheSize field's value.
func (s *NodeSnapshot) SetCacheSize(v string) *NodeSnapshot {
	s.CacheSize = &v
	return s
}

// SetNodeGroupConfiguration sets the NodeGroupConfiguration field's value.
func (s *NodeSnapshot) SetNodeGroupConfiguration(v *NodeGroupConfiguration) *NodeSnapshot {
	s.NodeGroupConfiguration = v
	return s
}

// SetNodeGroupId sets the NodeGroupId field's value.
func (s *NodeSnapshot) SetNodeGroupId(v string) *NodeSnapshot {
	s.NodeGroupId = &v
	return s
}

// SetSnapshotCreateTime sets the SnapshotCreateTime field's value.
func (s *NodeSnapshot) SetSnapshotCreateTime(v time.Time) *NodeSnapshot {
	s.SnapshotCreateTime = &v
	return s
}

// Describes a notification topic and its status. Notification topics are used
// for publishing ElastiCache events to subscribers using Amazon Simple Notification
// Service (SNS).
type NotificationConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the topic.
	TopicArn *string `type:"string"`

	// The current state of the topic.
	TopicStatus *string `type:"string"`
}

// String returns the string representation
func (s NotificationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotificationConfiguration) GoString() string {
	return s.String()
}

// SetTopicArn sets the TopicArn field's value.
func (s *NotificationConfiguration) SetTopicArn(v string) *NotificationConfiguration {
	s.TopicArn = &v
	return s
}

// SetTopicStatus sets the TopicStatus field's value.
func (s *NotificationConfiguration) SetTopicStatus(v string) *NotificationConfiguration {
	s.TopicStatus = &v
	return s
}

// Describes an individual setting that controls some aspect of ElastiCache
// behavior.
type Parameter struct {
	_ struct{} `type:"structure"`

	// The valid range of values for the parameter.
	AllowedValues *string `type:"string"`

	// Indicates whether a change to the parameter is applied immediately or requires
	// a reboot for the change to be applied. You can force a reboot or wait until
	// the next maintenance window's reboot. For more information, see Rebooting
	// a Cluster (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html).
	ChangeType *string `type:"string" enum:"ChangeType"`

	// The valid data type for the parameter.
	DataType *string `type:"string"`

	// A description of the parameter.
	Description *string `type:"string"`

	// Indicates whether (true) or not (false) the parameter can be modified. Some
	// parameters have security or operational implications that prevent them from
	// being changed.
	IsModifiable *bool `type:"boolean"`

	// The earliest cache engine version to which the parameter can apply.
	MinimumEngineVersion *string `type:"string"`

	// The name of the parameter.
	ParameterName *string `type:"string"`

	// The value of the parameter.
	ParameterValue *string `type:"string"`

	// The source of the parameter.
	Source *string `type:"string"`
}

// String returns the string representation
func (s Parameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Parameter) GoString() string {
	return s.String()
}

// SetAllowedValues sets the AllowedValues field's value.
func (s *Parameter) SetAllowedValues(v string) *Parameter {
	s.AllowedValues = &v
	return s
}

// SetChangeType sets the ChangeType field's value.
func (s *Parameter) SetChangeType(v string) *Parameter {
	s.ChangeType = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *Parameter) SetDataType(v string) *Parameter {
	s.DataType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Parameter) SetDescription(v string) *Parameter {
	s.Description = &v
	return s
}

// SetIsModifiable sets the IsModifiable field's value.
func (s *Parameter) SetIsModifiable(v bool) *Parameter {
	s.IsModifiable = &v
	return s
}

// SetMinimumEngineVersion sets the MinimumEngineVersion field's value.
func (s *Parameter) SetMinimumEngineVersion(v string) *Parameter {
	s.MinimumEngineVersion = &v
	return s
}

// SetParameterName sets the ParameterName field's value.
func (s *Parameter) SetParameterName(v string) *Parameter {
	s.ParameterName = &v
	return s
}

// SetParameterValue sets the ParameterValue field's value.
func (s *Parameter) SetParameterValue(v string) *Parameter {
	s.ParameterValue = &v
	return s
}

// SetSource sets the Source field's value.
func (s *Parameter) SetSource(v string) *Parameter {
	s.Source = &v
	return s
}

// Describes a name-value pair that is used to update the value of a parameter.
type ParameterNameValue struct {
	_ struct{} `type:"structure"`

	// The name of the parameter.
	ParameterName *string `type:"string"`

	// The value of the parameter.
	ParameterValue *string `type:"string"`
}

// String returns the string representation
func (s ParameterNameValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterNameValue) GoString() string {
	return s.String()
}

// SetParameterName sets the ParameterName field's value.
func (s *ParameterNameValue) SetParameterName(v string) *ParameterNameValue {
	s.ParameterName = &v
	return s
}

// SetParameterValue sets the ParameterValue field's value.
func (s *ParameterNameValue) SetParameterValue(v string) *ParameterNameValue {
	s.ParameterValue = &v
	return s
}

// A group of settings that are applied to the cluster in the future, or that
// are currently being applied.
type PendingModifiedValues struct {
	_ struct{} `type:"structure"`

	// The auth token status
	AuthTokenStatus *string `type:"string" enum:"AuthTokenUpdateStatus"`

	// A list of cache node IDs that are being removed (or will be removed) from
	// the cluster. A node ID is a 4-digit numeric identifier (0001, 0002, etc.).
	CacheNodeIdsToRemove []*string `locationNameList:"CacheNodeId" type:"list"`

	// The cache node type that this cluster or replication group is scaled to.
	CacheNodeType *string `type:"string"`

	// The new cache engine version that the cluster runs.
	EngineVersion *string `type:"string"`

	// The new number of cache nodes for the cluster.
	//
	// For clusters running Redis, this value must be 1. For clusters running Memcached,
	// this value must be between 1 and 20.
	NumCacheNodes *int64 `type:"integer"`
}

// String returns the string representation
func (s PendingModifiedValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PendingModifiedValues) GoString() string {
	return s.String()
}

// SetAuthTokenStatus sets the AuthTokenStatus field's value.
func (s *PendingModifiedValues) SetAuthTokenStatus(v string) *PendingModifiedValues {
	s.AuthTokenStatus = &v
	return s
}

// SetCacheNodeIdsToRemove sets the CacheNodeIdsToRemove field's value.
func (s *PendingModifiedValues) SetCacheNodeIdsToRemove(v []*string) *PendingModifiedValues {
	s.CacheNodeIdsToRemove = v
	return s
}

// SetCacheNodeType sets the CacheNodeType field's value.
func (s *PendingModifiedValues) SetCacheNodeType(v string) *PendingModifiedValues {
	s.CacheNodeType = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *PendingModifiedValues) SetEngineVersion(v string) *PendingModifiedValues {
	s.EngineVersion = &v
	return s
}

// SetNumCacheNodes sets the NumCacheNodes field's value.
func (s *PendingModifiedValues) SetNumCacheNodes(v int64) *PendingModifiedValues {
	s.NumCacheNodes = &v
	return s
}

// Update action that has been processed for the corresponding apply/stop request
type ProcessedUpdateAction struct {
	_ struct{} `type:"structure"`

	// The ID of the cache cluster
	CacheClusterId *string `type:"string"`

	// The ID of the replication group
	ReplicationGroupId *string `type:"string"`

	// The unique ID of the service update
	ServiceUpdateName *string `type:"string"`

	// The status of the update action on the Redis cluster
	UpdateActionStatus *string `type:"string" enum:"UpdateActionStatus"`
}

// String returns the string representation
func (s ProcessedUpdateAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProcessedUpdateAction) GoString() string {
	return s.String()
}

// SetCacheClusterId sets the CacheClusterId field's value.
func (s *ProcessedUpdateAction) SetCacheClusterId(v string) *ProcessedUpdateAction {
	s.CacheClusterId = &v
	return s
}

// SetReplicationGroupId sets the ReplicationGroupId field's value.
func (s *ProcessedUpdateAction) SetReplicationGroupId(v string) *ProcessedUpdateAction {
	s.ReplicationGroupId = &v
	return s
}

// SetServiceUpdateName sets the ServiceUpdateName field's value.
func (s *ProcessedUpdateAction) SetServiceUpdateName(v string) *ProcessedUpdateAction {
	s.ServiceUpdateName = &v
	return s
}

// SetUpdateActionStatus sets the UpdateActionStatus field's value.
func (s *ProcessedUpdateAction) SetUpdateActionStatus(v string) *ProcessedUpdateAction {
	s.UpdateActionStatus = &v
	return s
}

// Represents the input of a PurchaseReservedCacheNodesOffering operation.
type PurchaseReservedCacheNodesOfferingInput struct {
	_ struct{} `type:"structure"`

	// The number of cache node instances to reserve.
	//
	// Default: 1
	CacheNodeCount *int64 `type:"integer"`

	// A customer-specified identifier to track this reservation.
	//
	// The Reserved Cache Node ID is an unique customer-specified identifier to
	// track this reservation. If this parameter is not specified, ElastiCache automatically
	// generates an identifier for the reservation.
	//
	// Example: myreservationID
	ReservedCacheNodeId *string `type:"string"`

	// The ID of the reserved cache node offering to purchase.
	//
	// Example: 438012d3-4052-4cc7-b2e3-8d3372e0e706
	//
	// ReservedCacheNodesOfferingId is a required field
	ReservedCacheNodesOfferingId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PurchaseReservedCacheNodesOfferingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PurchaseReservedCacheNodesOfferingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PurchaseReservedCacheNodesOfferingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PurchaseReservedCacheNodesOfferingInput"}
	if s.ReservedCacheNodesOfferingId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReservedCacheNodesOfferingId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCacheNodeCount sets the CacheNodeCount field's value.
func (s *PurchaseReservedCacheNodesOfferingInput) SetCacheNodeCount(v int64) *PurchaseReservedCacheNodesOfferingInput {
	s.CacheNodeCount = &v
	return s
}

// SetReservedCacheNodeId sets the ReservedCacheNodeId field's value.
func (s *PurchaseReservedCacheNodesOfferingInput) SetReservedCacheNodeId(v string) *PurchaseReservedCacheNodesOfferingInput {
	s.ReservedCacheNodeId = &v
	return s
}

// SetReservedCacheNodesOfferingId sets the ReservedCacheNodesOfferingId field's value.
func (s *PurchaseReservedCacheNodesOfferingInput) SetReservedCacheNodesOfferingId(v string) *PurchaseReservedCacheNodesOfferingInput {
	s.ReservedCacheNodesOfferingId = &v
	return s
}

type PurchaseReservedCacheNodesOfferingOutput struct {
	_ struct{} `type:"structure"`

	// Represents the output of a PurchaseReservedCacheNodesOffering operation.
	ReservedCacheNode *ReservedCacheNode `type:"structure"`
}

// String returns the string representation
func (s PurchaseReservedCacheNodesOfferingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PurchaseReservedCacheNodesOfferingOutput) GoString() string {
	return s.String()
}

// SetReservedCacheNode sets the ReservedCacheNode field's value.
func (s *PurchaseReservedCacheNodesOfferingOutput) SetReservedCacheNode(v *ReservedCacheNode) *PurchaseReservedCacheNodesOfferingOutput {
	s.ReservedCacheNode = v
	return s
}

type RebalanceSlotsInGlobalReplicationGroupInput struct {
	_ struct{} `type:"structure"`

	// If True, redistribution is applied immediately.
	//
	// ApplyImmediately is a required field
	ApplyImmediately *bool `type:"boolean" required:"true"`

	// The name of the Global Datastore
	//
	// GlobalReplicationGroupId is a required field
	GlobalReplicationGroupId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RebalanceSlotsInGlobalReplicationGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebalanceSlotsInGlobalReplicationGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebalanceSlotsInGlobalReplicationGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebalanceSlotsInGlobalReplicationGroupInput"}
	if s.ApplyImmediately == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplyImmediately"))
	}
	if s.GlobalReplicationGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GlobalReplicationGroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplyImmediately sets the ApplyImmediately field's value.
func (s *RebalanceSlotsInGlobalReplicationGroupInput) SetApplyImmediately(v bool) *RebalanceSlotsInGlobalReplicationGroupInput {
	s.ApplyImmediately = &v
	return s
}

// SetGlobalReplicationGroupId sets the GlobalReplicationGroupId field's value.
func (s *RebalanceSlotsInGlobalReplicationGroupInput) SetGlobalReplicationGroupId(v string) *RebalanceSlotsInGlobalReplicationGroupInput {
	s.GlobalReplicationGroupId = &v
	return s
}

type RebalanceSlotsInGlobalReplicationGroupOutput struct {
	_ struct{} `type:"structure"`

	// Consists of a primary cluster that accepts writes and an associated secondary
	// cluster that resides in a different AWS region. The secondary cluster accepts
	// only reads. The primary cluster automatically replicates updates to the secondary
	// cluster.
	//
	//    * The GlobalReplicationGroupIdSuffix represents the name of the Global
	//    Datastore, which is what you use to associate a secondary cluster.
	GlobalReplicationGroup *GlobalReplicationGroup `type:"structure"`
}

// String returns the string representation
func (s RebalanceSlotsInGlobalReplicationGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebalanceSlotsInGlobalReplicationGroupOutput) GoString() string {
	return s.String()
}

// SetGlobalReplicationGroup sets the GlobalReplicationGroup field's value.
func (s *RebalanceSlotsInGlobalReplicationGroupOutput) SetGlobalReplicationGroup(v *GlobalReplicationGroup) *RebalanceSlotsInGlobalReplicationGroupOutput {
	s.GlobalReplicationGroup = v
	return s
}

// Represents the input of a RebootCacheCluster operation.
type RebootCacheClusterInput struct {
	_ struct{} `type:"structure"`

	// The cluster identifier. This parameter is stored as a lowercase string.
	//
	// CacheClusterId is a required field
	CacheClusterId *string `type:"string" required:"true"`

	// A list of cache node IDs to reboot. A node ID is a numeric identifier (0001,
	// 0002, etc.). To reboot an entire cluster, specify all of the cache node IDs.
	//
	// CacheNodeIdsToReboot is a required field
	CacheNodeIdsToReboot []*string `locationNameList:"CacheNodeId" type:"list" required:"true"`
}

// String returns the string representation
func (s RebootCacheClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootCacheClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootCacheClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebootCacheClusterInput"}
	if s.CacheClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("CacheClusterId"))
	}
	if s.CacheNodeIdsToReboot == nil {
		invalidParams.Add(request.NewErrParamRequired("CacheNodeIdsToReboot"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCacheClusterId sets the CacheClusterId field's value.
func (s *RebootCacheClusterInput) SetCacheClusterId(v string) *RebootCacheClusterInput {
	s.CacheClusterId = &v
	return s
}

// SetCacheNodeIdsToReboot sets the CacheNodeIdsToReboot field's value.
func (s *RebootCacheClusterInput) SetCacheNodeIdsToReboot(v []*string) *RebootCacheClusterInput {
	s.CacheNodeIdsToReboot = v
	return s
}

type RebootCacheClusterOutput struct {
	_ struct{} `type:"structure"`

	// Contains all of the attributes of a specific cluster.
	CacheCluster *CacheCluster `type:"structure"`
}

// String returns the string representation
func (s RebootCacheClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootCacheClusterOutput) GoString() string {
	return s.String()
}

// SetCacheCluster sets the CacheCluster field's value.
func (s *RebootCacheClusterOutput) SetCacheCluster(v *CacheCluster) *RebootCacheClusterOutput {
	s.CacheCluster = v
	return s
}

// Contains the specific price and frequency of a recurring charges for a reserved
// cache node, or for a reserved cache node offering.
type RecurringCharge struct {
	_ struct{} `type:"structure"`

	// The monetary amount of the recurring charge.
	RecurringChargeAmount *float64 `type:"double"`

	// The frequency of the recurring charge.
	RecurringChargeFrequency *string `type:"string"`
}

// String returns the string representation
func (s RecurringCharge) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecurringCharge) GoString() string {
	return s.String()
}

// SetRecurringChargeAmount sets the RecurringChargeAmount field's value.
func (s *RecurringCharge) SetRecurringChargeAmount(v float64) *RecurringCharge {
	s.RecurringChargeAmount = &v
	return s
}

// SetRecurringChargeFrequency sets the RecurringChargeFrequency field's value.
func (s *RecurringCharge) SetRecurringChargeFrequency(v string) *RecurringCharge {
	s.RecurringChargeFrequency = &v
	return s
}

// A list of the replication groups
type RegionalConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the secondary cluster
	//
	// ReplicationGroupId is a required field
	ReplicationGroupId *string `type:"string" required:"true"`

	// The AWS region where the cluster is stored
	//
	// ReplicationGroupRegion is a required field
	ReplicationGroupRegion *string `type:"string" required:"true"`

	// A list of PreferredAvailabilityZones objects that specifies the configuration
	// of a node group in the resharded cluster.
	//
	// ReshardingConfiguration is a required field
	ReshardingConfiguration []*ReshardingConfiguration `locationNameList:"ReshardingConfiguration" type:"list" required:"true"`
}

// String returns the string representation
func (s RegionalConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegionalConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegionalConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegionalConfiguration"}
	if s.ReplicationGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationGroupId"))
	}
	if s.ReplicationGroupRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationGroupRegion"))
	}
	if s.ReshardingConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("ReshardingConfiguration"))
	}
	if s.ReshardingConfiguration != nil {
		for i, v := range s.ReshardingConfiguration {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ReshardingConfiguration", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplicationGroupId sets the ReplicationGroupId field's value.
func (s *RegionalConfiguration) SetReplicationGroupId(v string) *RegionalConfiguration {
	s.ReplicationGroupId = &v
	return s
}

// SetReplicationGroupRegion sets the ReplicationGroupRegion field's value.
func (s *RegionalConfiguration) SetReplicationGroupRegion(v string) *RegionalConfiguration {
	s.ReplicationGroupRegion = &v
	return s
}

// SetReshardingConfiguration sets the ReshardingConfiguration field's value.
func (s *RegionalConfiguration) SetReshardingConfiguration(v []*ReshardingConfiguration) *RegionalConfiguration {
	s.ReshardingConfiguration = v
	return s
}

// Represents the input of a RemoveTagsFromResource operation.
type RemoveTagsFromResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource from which you want the tags
	// removed, for example arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster
	// or arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// ResourceName is a required field
	ResourceName *string `type:"string" required:"true"`

	// A list of TagKeys identifying the tags you want removed from the named resource.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsFromResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsFromResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsFromResourceInput"}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceName sets the ResourceName field's value.
func (s *RemoveTagsFromResourceInput) SetResourceName(v string) *RemoveTagsFromResourceInput {
	s.ResourceName = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *RemoveTagsFromResourceInput) SetTagKeys(v []*string) *RemoveTagsFromResourceInput {
	s.TagKeys = v
	return s
}

// Contains all of the attributes of a specific Redis replication group.
type ReplicationGroup struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) of the replication group.
	ARN *string `type:"string"`

	// A flag that enables encryption at-rest when set to true.
	//
	// You cannot modify the value of AtRestEncryptionEnabled after the cluster
	// is created. To enable encryption at-rest on a cluster you must set AtRestEncryptionEnabled
	// to true when you create a cluster.
	//
	// Required: Only available when creating a replication group in an Amazon VPC
	// using redis version 3.2.6, 4.x or later.
	//
	// Default: false
	AtRestEncryptionEnabled *bool `type:"boolean"`

	// A flag that enables using an AuthToken (password) when issuing Redis commands.
	//
	// Default: false
	AuthTokenEnabled *bool `type:"boolean"`

	// The date the auth token was last modified
	AuthTokenLastModifiedDate *time.Time `type:"timestamp"`

	// Indicates the status of automatic failover for this Redis replication group.
	AutomaticFailover *string `type:"string" enum:"AutomaticFailoverStatus"`

	// The name of the compute and memory capacity node type for each node in the
	// replication group.
	CacheNodeType *string `type:"string"`

	// A flag indicating whether or not this replication group is cluster enabled;
	// i.e., whether its data can be partitioned across multiple shards (API/CLI:
	// node groups).
	//
	// Valid values: true | false
	ClusterEnabled *bool `type:"boolean"`

	// The configuration endpoint for this replication group. Use the configuration
	// endpoint to connect to this replication group.
	ConfigurationEndpoint *Endpoint `type:"structure"`

	// The user supplied description of the replication group.
	Description *string `type:"string"`

	// The name of the Global Datastore and role of this replication group in the
	// Global Datastore.
	GlobalReplicationGroupInfo *GlobalReplicationGroupInfo `type:"structure"`

	// The ID of the KMS key used to encrypt the disk in the cluster.
	KmsKeyId *string `type:"string"`

	// The names of all the cache clusters that are part of this replication group.
	MemberClusters []*string `locationNameList:"ClusterId" type:"list"`

	// A flag indicating if you have Multi-AZ enabled to enhance fault tolerance.
	// For more information, see Minimizing Downtime: Multi-AZ (http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html)
	MultiAZ *string `type:"string" enum:"MultiAZStatus"`

	// A list of node groups in this replication group. For Redis (cluster mode
	// disabled) replication groups, this is a single-element list. For Redis (cluster
	// mode enabled) replication groups, the list contains an entry for each node
	// group (shard).
	NodeGroups []*NodeGroup `locationNameList:"NodeGroup" type:"list"`

	// A group of settings to be applied to the replication group, either immediately
	// or during the next maintenance window.
	PendingModifiedValues *ReplicationGroupPendingModifiedValues `type:"structure"`

	// The identifier for the replication group.
	ReplicationGroupId *string `type:"string"`

	// The number of days for which ElastiCache retains automatic cluster snapshots
	// before deleting them. For example, if you set SnapshotRetentionLimit to 5,
	// a snapshot that was taken today is retained for 5 days before being deleted.
	//
	// If the value of SnapshotRetentionLimit is set to zero (0), backups are turned
	// off.
	SnapshotRetentionLimit *int64 `type:"integer"`

	// The daily time range (in UTC) during which ElastiCache begins taking a daily
	// snapshot of your node group (shard).
	//
	// Example: 05:00-09:00
	//
	// If you do not specify this parameter, ElastiCache automatically chooses an
	// appropriate time range.
	//
	// This parameter is only valid if the Engine parameter is redis.
	SnapshotWindow *string `type:"string"`

	// The cluster ID that is used as the daily snapshot source for the replication
	// group.
	SnapshottingClusterId *string `type:"string"`

	// The current state of this replication group - creating, available, modifying,
	// deleting, create-failed, snapshotting.
	Status *string `type:"string"`

	// A flag that enables in-transit encryption when set to true.
	//
	// You cannot modify the value of TransitEncryptionEnabled after the cluster
	// is created. To enable in-transit encryption on a cluster you must set TransitEncryptionEnabled
	// to true when you create a cluster.
	//
	// Required: Only available when creating a replication group in an Amazon VPC
	// using redis version 3.2.6, 4.x or later.
	//
	// Default: false
	TransitEncryptionEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s ReplicationGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationGroup) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *ReplicationGroup) SetARN(v string) *ReplicationGroup {
	s.ARN = &v
	return s
}

// SetAtRestEncryptionEnabled sets the AtRestEncryptionEnabled field's value.
func (s *ReplicationGroup) SetAtRestEncryptionEnabled(v bool) *ReplicationGroup {
	s.AtRestEncryptionEnabled = &v
	return s
}

// SetAuthTokenEnabled sets the AuthTokenEnabled field's value.
func (s *ReplicationGroup) SetAuthTokenEnabled(v bool) *ReplicationGroup {
	s.AuthTokenEnabled = &v
	return s
}

// SetAuthTokenLastModifiedDate sets the AuthTokenLastModifiedDate field's value.
func (s *ReplicationGroup) SetAuthTokenLastModifiedDate(v time.Time) *ReplicationGroup {
	s.AuthTokenLastModifiedDate = &v
	return s
}

// SetAutomaticFailover sets the AutomaticFailover field's value.
func (s *ReplicationGroup) SetAutomaticFailover(v string) *ReplicationGroup {
	s.AutomaticFailover = &v
	return s
}

// SetCacheNodeType sets the CacheNodeType field's value.
func (s *ReplicationGroup) SetCacheNodeType(v string) *ReplicationGroup {
	s.CacheNodeType = &v
	return s
}

// SetClusterEnabled sets the ClusterEnabled field's value.
func (s *ReplicationGroup) SetClusterEnabled(v bool) *ReplicationGroup {
	s.ClusterEnabled = &v
	return s
}

// SetConfigurationEndpoint sets the ConfigurationEndpoint field's value.
func (s *ReplicationGroup) SetConfigurationEndpoint(v *Endpoint) *ReplicationGroup {
	s.ConfigurationEndpoint = v
	return s
}

// SetDescription sets the Description field's value.
func (s *ReplicationGroup) SetDescription(v string) *ReplicationGroup {
	s.Description = &v
	return s
}

// SetGlobalReplicationGroupInfo sets the GlobalReplicationGroupInfo field's value.
func (s *ReplicationGroup) SetGlobalReplicationGroupInfo(v *GlobalReplicationGroupInfo) *ReplicationGroup {
	s.GlobalReplicationGroupInfo = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *ReplicationGroup) SetKmsKeyId(v string) *ReplicationGroup {
	s.KmsKeyId = &v
	return s
}

// SetMemberClusters sets the MemberClusters field's value.
func (s *ReplicationGroup) SetMemberClusters(v []*string) *ReplicationGroup {
	s.MemberClusters = v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *ReplicationGroup) SetMultiAZ(v string) *ReplicationGroup {
	s.MultiAZ = &v
	return s
}

// SetNodeGroups sets the NodeGroups field's value.
func (s *ReplicationGroup) SetNodeGroups(v []*NodeGroup) *ReplicationGroup {
	s.NodeGroups = v
	return s
}

// SetPendingModifiedValues sets the PendingModifiedValues field's value.
func (s *ReplicationGroup) SetPendingModifiedValues(v *ReplicationGroupPendingModifiedValues) *ReplicationGroup {
	s.PendingModifiedValues = v
	return s
}

// SetReplicationGroupId sets the ReplicationGroupId field's value.
func (s *ReplicationGroup) SetReplicationGroupId(v string) *ReplicationGroup {
	s.ReplicationGroupId = &v
	return s
}

// SetSnapshotRetentionLimit sets the SnapshotRetentionLimit field's value.
func (s *ReplicationGroup) SetSnapshotRetentionLimit(v int64) *ReplicationGroup {
	s.SnapshotRetentionLimit = &v
	return s
}

// SetSnapshotWindow sets the SnapshotWindow field's value.
func (s *ReplicationGroup) SetSnapshotWindow(v string) *ReplicationGroup {
	s.SnapshotWindow = &v
	return s
}

// SetSnapshottingClusterId sets the SnapshottingClusterId field's value.
func (s *ReplicationGroup) SetSnapshottingClusterId(v string) *ReplicationGroup {
	s.SnapshottingClusterId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReplicationGroup) SetStatus(v string) *ReplicationGroup {
	s.Status = &v
	return s
}

// SetTransitEncryptionEnabled sets the TransitEncryptionEnabled field's value.
func (s *ReplicationGroup) SetTransitEncryptionEnabled(v bool) *ReplicationGroup {
	s.TransitEncryptionEnabled = &v
	return s
}

// The settings to be applied to the Redis replication group, either immediately
// or during the next maintenance window.
type ReplicationGroupPendingModifiedValues struct {
	_ struct{} `type:"structure"`

	// The auth token status
	AuthTokenStatus *string `type:"string" enum:"AuthTokenUpdateStatus"`

	// Indicates the status of automatic failover for this Redis replication group.
	AutomaticFailoverStatus *string `type:"string" enum:"PendingAutomaticFailoverStatus"`

	// The primary cluster ID that is applied immediately (if --apply-immediately
	// was specified), or during the next maintenance window.
	PrimaryClusterId *string `type:"string"`

	// The status of an online resharding operation.
	Resharding *ReshardingStatus `type:"structure"`
}

// String returns the string representation
func (s ReplicationGroupPendingModifiedValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationGroupPendingModifiedValues) GoString() string {
	return s.String()
}

// SetAuthTokenStatus sets the AuthTokenStatus field's value.
func (s *ReplicationGroupPendingModifiedValues) SetAuthTokenStatus(v string) *ReplicationGroupPendingModifiedValues {
	s.AuthTokenStatus = &v
	return s
}

// SetAutomaticFailoverStatus sets the AutomaticFailoverStatus field's value.
func (s *ReplicationGroupPendingModifiedValues) SetAutomaticFailoverStatus(v string) *ReplicationGroupPendingModifiedValues {
	s.AutomaticFailoverStatus = &v
	return s
}

// SetPrimaryClusterId sets the PrimaryClusterId field's value.
func (s *ReplicationGroupPendingModifiedValues) SetPrimaryClusterId(v string) *ReplicationGroupPendingModifiedValues {
	s.PrimaryClusterId = &v
	return s
}

// SetResharding sets the Resharding field's value.
func (s *ReplicationGroupPendingModifiedValues) SetResharding(v *ReshardingStatus) *ReplicationGroupPendingModifiedValues {
	s.Resharding = v
	return s
}

// Represents the output of a PurchaseReservedCacheNodesOffering operation.
type ReservedCacheNode struct {
	_ struct{} `type:"structure"`

	// The number of cache nodes that have been reserved.
	CacheNodeCount *int64 `type:"integer"`

	// The cache node type for the reserved cache nodes.
	//
	// The following node types are supported by ElastiCache. Generally speaking,
	// the current generation types provide more memory and computational power
	// at lower cost when compared to their equivalent previous generation counterparts.
	//
	//    * General purpose: Current generation: M5 node types: cache.m5.large,
	//    cache.m5.xlarge, cache.m5.2xlarge, cache.m5.4xlarge, cache.m5.12xlarge,
	//    cache.m5.24xlarge M4 node types: cache.m4.large, cache.m4.xlarge, cache.m4.2xlarge,
	//    cache.m4.4xlarge, cache.m4.10xlarge T3 node types: cache.t3.micro, cache.t3.small,
	//    cache.t3.medium T2 node types: cache.t2.micro, cache.t2.small, cache.t2.medium
	//    Previous generation: (not recommended) T1 node types: cache.t1.micro M1
	//    node types: cache.m1.small, cache.m1.medium, cache.m1.large, cache.m1.xlarge
	//    M3 node types: cache.m3.medium, cache.m3.large, cache.m3.xlarge, cache.m3.2xlarge
	//
	//    * Compute optimized: Previous generation: (not recommended) C1 node types:
	//    cache.c1.xlarge
	//
	//    * Memory optimized: Current generation: R5 node types: cache.r5.large,
	//    cache.r5.xlarge, cache.r5.2xlarge, cache.r5.4xlarge, cache.r5.12xlarge,
	//    cache.r5.24xlarge R4 node types: cache.r4.large, cache.r4.xlarge, cache.r4.2xlarge,
	//    cache.r4.4xlarge, cache.r4.8xlarge, cache.r4.16xlarge Previous generation:
	//    (not recommended) M2 node types: cache.m2.xlarge, cache.m2.2xlarge, cache.m2.4xlarge
	//    R3 node types: cache.r3.large, cache.r3.xlarge, cache.r3.2xlarge, cache.r3.4xlarge,
	//    cache.r3.8xlarge
	//
	// Additional node type info
	//
	//    * All current generation instance types are created in Amazon VPC by default.
	//
	//    * Redis append-only files (AOF) are not supported for T1 or T2 instances.
	//
	//    * Redis Multi-AZ with automatic failover is not supported on T1 instances.
	//
	//    * Redis configuration variables appendonly and appendfsync are not supported
	//    on Redis version 2.8.22 and later.
	CacheNodeType *string `type:"string"`

	// The duration of the reservation in seconds.
	Duration *int64 `type:"integer"`

	// The fixed price charged for this reserved cache node.
	FixedPrice *float64 `type:"double"`

	// The offering type of this reserved cache node.
	OfferingType *string `type:"string"`

	// The description of the reserved cache node.
	ProductDescription *string `type:"string"`

	// The recurring price charged to run this reserved cache node.
	RecurringCharges []*RecurringCharge `locationNameList:"RecurringCharge" type:"list"`

	// The Amazon Resource Name (ARN) of the reserved cache node.
	//
	// Example: arn:aws:elasticache:us-east-1:123456789012:reserved-instance:ri-2017-03-27-08-33-25-582
	ReservationARN *string `type:"string"`

	// The unique identifier for the reservation.
	ReservedCacheNodeId *string `type:"string"`

	// The offering identifier.
	ReservedCacheNodesOfferingId *string `type:"string"`

	// The time the reservation started.
	StartTime *time.Time `type:"timestamp"`

	// The state of the reserved cache node.
	State *string `type:"string"`

	// The hourly price charged for this reserved cache node.
	UsagePrice *float64 `type:"double"`
}

// String returns the string representation
func (s ReservedCacheNode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservedCacheNode) GoString() string {
	return s.String()
}

// SetCacheNodeCount sets the CacheNodeCount field's value.
func (s *ReservedCacheNode) SetCacheNodeCount(v int64) *ReservedCacheNode {
	s.CacheNodeCount = &v
	return s
}

// SetCacheNodeType sets the CacheNodeType field's value.
func (s *ReservedCacheNode) SetCacheNodeType(v string) *ReservedCacheNode {
	s.CacheNodeType = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *ReservedCacheNode) SetDuration(v int64) *ReservedCacheNode {
	s.Duration = &v
	return s
}

// SetFixedPrice sets the FixedPrice field's value.
func (s *ReservedCacheNode) SetFixedPrice(v float64) *ReservedCacheNode {
	s.FixedPrice = &v
	return s
}

// SetOfferingType sets the OfferingType field's value.
func (s *ReservedCacheNode) SetOfferingType(v string) *ReservedCacheNode {
	s.OfferingType = &v
	return s
}

// SetProductDescription sets the ProductDescription field's value.
func (s *ReservedCacheNode) SetProductDescription(v string) *ReservedCacheNode {
	s.ProductDescription = &v
	return s
}

// SetRecurringCharges sets the RecurringCharges field's value.
func (s *ReservedCacheNode) SetRecurringCharges(v []*RecurringCharge) *ReservedCacheNode {
	s.RecurringCharges = v
	return s
}

// SetReservationARN sets the ReservationARN field's value.
func (s *ReservedCacheNode) SetReservationARN(v string) *ReservedCacheNode {
	s.ReservationARN = &v
	return s
}

// SetReservedCacheNodeId sets the ReservedCacheNodeId field's value.
func (s *ReservedCacheNode) SetReservedCacheNodeId(v string) *ReservedCacheNode {
	s.ReservedCacheNodeId = &v
	return s
}

// SetReservedCacheNodesOfferingId sets the ReservedCacheNodesOfferingId field's value.
func (s *ReservedCacheNode) SetReservedCacheNodesOfferingId(v string) *ReservedCacheNode {
	s.ReservedCacheNodesOfferingId = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ReservedCacheNode) SetStartTime(v time.Time) *ReservedCacheNode {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *ReservedCacheNode) SetState(v string) *ReservedCacheNode {
	s.State = &v
	return s
}

// SetUsagePrice sets the UsagePrice field's value.
func (s *ReservedCacheNode) SetUsagePrice(v float64) *ReservedCacheNode {
	s.UsagePrice = &v
	return s
}

// Describes all of the attributes of a reserved cache node offering.
type ReservedCacheNodesOffering struct {
	_ struct{} `type:"structure"`

	// The cache node type for the reserved cache node.
	//
	// The following node types are supported by ElastiCache. Generally speaking,
	// the current generation types provide more memory and computational power
	// at lower cost when compared to their equivalent previous generation counterparts.
	//
	//    * General purpose: Current generation: M5 node types: cache.m5.large,
	//    cache.m5.xlarge, cache.m5.2xlarge, cache.m5.4xlarge, cache.m5.12xlarge,
	//    cache.m5.24xlarge M4 node types: cache.m4.large, cache.m4.xlarge, cache.m4.2xlarge,
	//    cache.m4.4xlarge, cache.m4.10xlarge T3 node types: cache.t3.micro, cache.t3.small,
	//    cache.t3.medium T2 node types: cache.t2.micro, cache.t2.small, cache.t2.medium
	//    Previous generation: (not recommended) T1 node types: cache.t1.micro M1
	//    node types: cache.m1.small, cache.m1.medium, cache.m1.large, cache.m1.xlarge
	//    M3 node types: cache.m3.medium, cache.m3.large, cache.m3.xlarge, cache.m3.2xlarge
	//
	//    * Compute optimized: Previous generation: (not recommended) C1 node types:
	//    cache.c1.xlarge
	//
	//    * Memory optimized: Current generation: R5 node types: cache.r5.large,
	//    cache.r5.xlarge, cache.r5.2xlarge, cache.r5.4xlarge, cache.r5.12xlarge,
	//    cache.r5.24xlarge R4 node types: cache.r4.large, cache.r4.xlarge, cache.r4.2xlarge,
	//    cache.r4.4xlarge, cache.r4.8xlarge, cache.r4.16xlarge Previous generation:
	//    (not recommended) M2 node types: cache.m2.xlarge, cache.m2.2xlarge, cache.m2.4xlarge
	//    R3 node types: cache.r3.large, cache.r3.xlarge, cache.r3.2xlarge, cache.r3.4xlarge,
	//    cache.r3.8xlarge
	//
	// Additional node type info
	//
	//    * All current generation instance types are created in Amazon VPC by default.
	//
	//    * Redis append-only files (AOF) are not supported for T1 or T2 instances.
	//
	//    * Redis Multi-AZ with automatic failover is not supported on T1 instances.
	//
	//    * Redis configuration variables appendonly and appendfsync are not supported
	//    on Redis version 2.8.22 and later.
	CacheNodeType *string `type:"string"`

	// The duration of the offering. in seconds.
	Duration *int64 `type:"integer"`

	// The fixed price charged for this offering.
	FixedPrice *float64 `type:"double"`

	// The offering type.
	OfferingType *string `type:"string"`

	// The cache engine used by the offering.
	ProductDescription *string `type:"string"`

	// The recurring price charged to run this reserved cache node.
	RecurringCharges []*RecurringCharge `locationNameList:"RecurringCharge" type:"list"`

	// A unique identifier for the reserved cache node offering.
	ReservedCacheNodesOfferingId *string `type:"string"`

	// The hourly price charged for this offering.
	UsagePrice *float64 `type:"double"`
}

// String returns the string representation
func (s ReservedCacheNodesOffering) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservedCacheNodesOffering) GoString() string {
	return s.String()
}

// SetCacheNodeType sets the CacheNodeType field's value.
func (s *ReservedCacheNodesOffering) SetCacheNodeType(v string) *ReservedCacheNodesOffering {
	s.CacheNodeType = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *ReservedCacheNodesOffering) SetDuration(v int64) *ReservedCacheNodesOffering {
	s.Duration = &v
	return s
}

// SetFixedPrice sets the FixedPrice field's value.
func (s *ReservedCacheNodesOffering) SetFixedPrice(v float64) *ReservedCacheNodesOffering {
	s.FixedPrice = &v
	return s
}

// SetOfferingType sets the OfferingType field's value.
func (s *ReservedCacheNodesOffering) SetOfferingType(v string) *ReservedCacheNodesOffering {
	s.OfferingType = &v
	return s
}

// SetProductDescription sets the ProductDescription field's value.
func (s *ReservedCacheNodesOffering) SetProductDescription(v string) *ReservedCacheNodesOffering {
	s.ProductDescription = &v
	return s
}

// SetRecurringCharges sets the RecurringCharges field's value.
func (s *ReservedCacheNodesOffering) SetRecurringCharges(v []*RecurringCharge) *ReservedCacheNodesOffering {
	s.RecurringCharges = v
	return s
}

// SetReservedCacheNodesOfferingId sets the ReservedCacheNodesOfferingId field's value.
func (s *ReservedCacheNodesOffering) SetReservedCacheNodesOfferingId(v string) *ReservedCacheNodesOffering {
	s.ReservedCacheNodesOfferingId = &v
	return s
}

// SetUsagePrice sets the UsagePrice field's value.
func (s *ReservedCacheNodesOffering) SetUsagePrice(v float64) *ReservedCacheNodesOffering {
	s.UsagePrice = &v
	return s
}

// Represents the input of a ResetCacheParameterGroup operation.
type ResetCacheParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the cache parameter group to reset.
	//
	// CacheParameterGroupName is a required field
	CacheParameterGroupName *string `type:"string" required:"true"`

	// An array of parameter names to reset to their default values. If ResetAllParameters
	// is true, do not use ParameterNameValues. If ResetAllParameters is false,
	// you must specify the name of at least one parameter to reset.
	ParameterNameValues []*ParameterNameValue `locationNameList:"ParameterNameValue" type:"list"`

	// If true, all parameters in the cache parameter group are reset to their default
	// values. If false, only the parameters listed by ParameterNameValues are reset
	// to their default values.
	//
	// Valid values: true | false
	ResetAllParameters *bool `type:"boolean"`
}

// String returns the string representation
func (s ResetCacheParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetCacheParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetCacheParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResetCacheParameterGroupInput"}
	if s.CacheParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("CacheParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCacheParameterGroupName sets the CacheParameterGroupName field's value.
func (s *ResetCacheParameterGroupInput) SetCacheParameterGroupName(v string) *ResetCacheParameterGroupInput {
	s.CacheParameterGroupName = &v
	return s
}

// SetParameterNameValues sets the ParameterNameValues field's value.
func (s *ResetCacheParameterGroupInput) SetParameterNameValues(v []*ParameterNameValue) *ResetCacheParameterGroupInput {
	s.ParameterNameValues = v
	return s
}

// SetResetAllParameters sets the ResetAllParameters field's value.
func (s *ResetCacheParameterGroupInput) SetResetAllParameters(v bool) *ResetCacheParameterGroupInput {
	s.ResetAllParameters = &v
	return s
}

// A list of PreferredAvailabilityZones objects that specifies the configuration
// of a node group in the resharded cluster.
type ReshardingConfiguration struct {
	_ struct{} `type:"structure"`

	// Either the ElastiCache for Redis supplied 4-digit id or a user supplied id
	// for the node group these configuration values apply to.
	NodeGroupId *string `min:"1" type:"string"`

	// A list of preferred availability zones for the nodes in this cluster.
	PreferredAvailabilityZones []*string `locationNameList:"AvailabilityZone" type:"list"`
}

// String returns the string representation
func (s ReshardingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReshardingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReshardingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReshardingConfiguration"}
	if s.NodeGroupId != nil && len(*s.NodeGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NodeGroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNodeGroupId sets the NodeGroupId field's value.
func (s *ReshardingConfiguration) SetNodeGroupId(v string) *ReshardingConfiguration {
	s.NodeGroupId = &v
	return s
}

// SetPreferredAvailabilityZones sets the PreferredAvailabilityZones field's value.
func (s *ReshardingConfiguration) SetPreferredAvailabilityZones(v []*string) *ReshardingConfiguration {
	s.PreferredAvailabilityZones = v
	return s
}

// The status of an online resharding operation.
type ReshardingStatus struct {
	_ struct{} `type:"structure"`

	// Represents the progress of an online resharding operation.
	SlotMigration *SlotMigration `type:"structure"`
}

// String returns the string representation
func (s ReshardingStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReshardingStatus) GoString() string {
	return s.String()
}

// SetSlotMigration sets the SlotMigration field's value.
func (s *ReshardingStatus) SetSlotMigration(v *SlotMigration) *ReshardingStatus {
	s.SlotMigration = v
	return s
}

// Represents the input of a RevokeCacheSecurityGroupIngress operation.
type RevokeCacheSecurityGroupIngressInput struct {
	_ struct{} `type:"structure"`

	// The name of the cache security group to revoke ingress from.
	//
	// CacheSecurityGroupName is a required field
	CacheSecurityGroupName *string `type:"string" required:"true"`

	// The name of the Amazon EC2 security group to revoke access from.
	//
	// EC2SecurityGroupName is a required field
	EC2SecurityGroupName *string `type:"string" required:"true"`

	// The AWS account number of the Amazon EC2 security group owner. Note that
	// this is not the same thing as an AWS access key ID - you must provide a valid
	// AWS account number for this parameter.
	//
	// EC2SecurityGroupOwnerId is a required field
	EC2SecurityGroupOwnerId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RevokeCacheSecurityGroupIngressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeCacheSecurityGroupIngressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevokeCacheSecurityGroupIngressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RevokeCacheSecurityGroupIngressInput"}
	if s.CacheSecurityGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("CacheSecurityGroupName"))
	}
	if s.EC2SecurityGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("EC2SecurityGroupName"))
	}
	if s.EC2SecurityGroupOwnerId == nil {
		invalidParams.Add(request.NewErrParamRequired("EC2SecurityGroupOwnerId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCacheSecurityGroupName sets the CacheSecurityGroupName field's value.
func (s *RevokeCacheSecurityGroupIngressInput) SetCacheSecurityGroupName(v string) *RevokeCacheSecurityGroupIngressInput {
	s.CacheSecurityGroupName = &v
	return s
}

// SetEC2SecurityGroupName sets the EC2SecurityGroupName field's value.
func (s *RevokeCacheSecurityGroupIngressInput) SetEC2SecurityGroupName(v string) *RevokeCacheSecurityGroupIngressInput {
	s.EC2SecurityGroupName = &v
	return s
}

// SetEC2SecurityGroupOwnerId sets the EC2SecurityGroupOwnerId field's value.
func (s *RevokeCacheSecurityGroupIngressInput) SetEC2SecurityGroupOwnerId(v string) *RevokeCacheSecurityGroupIngressInput {
	s.EC2SecurityGroupOwnerId = &v
	return s
}

type RevokeCacheSecurityGroupIngressOutput struct {
	_ struct{} `type:"structure"`

	// Represents the output of one of the following operations:
	//
	//    * AuthorizeCacheSecurityGroupIngress
	//
	//    * CreateCacheSecurityGroup
	//
	//    * RevokeCacheSecurityGroupIngress
	CacheSecurityGroup *CacheSecurityGroup `type:"structure"`
}

// String returns the string representation
func (s RevokeCacheSecurityGroupIngressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeCacheSecurityGroupIngressOutput) GoString() string {
	return s.String()
}

// SetCacheSecurityGroup sets the CacheSecurityGroup field's value.
func (s *RevokeCacheSecurityGroupIngressOutput) SetCacheSecurityGroup(v *CacheSecurityGroup) *RevokeCacheSecurityGroupIngressOutput {
	s.CacheSecurityGroup = v
	return s
}

// Represents a single cache security group and its status.
type SecurityGroupMembership struct {
	_ struct{} `type:"structure"`

	// The identifier of the cache security group.
	SecurityGroupId *string `type:"string"`

	// The status of the cache security group membership. The status changes whenever
	// a cache security group is modified, or when the cache security groups assigned
	// to a cluster are modified.
	Status *string `type:"string"`
}

// String returns the string representation
func (s SecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SecurityGroupMembership) GoString() string {
	return s.String()
}

// SetSecurityGroupId sets the SecurityGroupId field's value.
func (s *SecurityGroupMembership) SetSecurityGroupId(v string) *SecurityGroupMembership {
	s.SecurityGroupId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SecurityGroupMembership) SetStatus(v string) *SecurityGroupMembership {
	s.Status = &v
	return s
}

// An update that you can apply to your Redis clusters.
type ServiceUpdate struct {
	_ struct{} `type:"structure"`

	// Indicates whether the service update will be automatically applied once the
	// recommended apply-by date has expired.
	AutoUpdateAfterRecommendedApplyByDate *bool `type:"boolean"`

	// The Elasticache engine to which the update applies. Either Redis or Memcached
	Engine *string `type:"string"`

	// The Elasticache engine version to which the update applies. Either Redis
	// or Memcached engine version
	EngineVersion *string `type:"string"`

	// The estimated length of time the service update will take
	EstimatedUpdateTime *string `type:"string"`

	// Provides details of the service update
	ServiceUpdateDescription *string `type:"string"`

	// The date after which the service update is no longer available
	ServiceUpdateEndDate *time.Time `type:"timestamp"`

	// The unique ID of the service update
	ServiceUpdateName *string `type:"string"`

	// The recommendend date to apply the service update in order to ensure compliance.
	// For information on compliance, see Self-Service Security Updates for Compliance
	// (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/elasticache-compliance.html#elasticache-compliance-self-service).
	ServiceUpdateRecommendedApplyByDate *time.Time `type:"timestamp"`

	// The date when the service update is initially available
	ServiceUpdateReleaseDate *time.Time `type:"timestamp"`

	// The severity of the service update
	ServiceUpdateSeverity *string `type:"string" enum:"ServiceUpdateSeverity"`

	// The status of the service update
	ServiceUpdateStatus *string `type:"string" enum:"ServiceUpdateStatus"`

	// Reflects the nature of the service update
	ServiceUpdateType *string `type:"string" enum:"ServiceUpdateType"`
}

// String returns the string representation
func (s ServiceUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceUpdate) GoString() string {
	return s.String()
}

// SetAutoUpdateAfterRecommendedApplyByDate sets the AutoUpdateAfterRecommendedApplyByDate field's value.
func (s *ServiceUpdate) SetAutoUpdateAfterRecommendedApplyByDate(v bool) *ServiceUpdate {
	s.AutoUpdateAfterRecommendedApplyByDate = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *ServiceUpdate) SetEngine(v string) *ServiceUpdate {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *ServiceUpdate) SetEngineVersion(v string) *ServiceUpdate {
	s.EngineVersion = &v
	return s
}

// SetEstimatedUpdateTime sets the EstimatedUpdateTime field's value.
func (s *ServiceUpdate) SetEstimatedUpdateTime(v string) *ServiceUpdate {
	s.EstimatedUpdateTime = &v
	return s
}

// SetServiceUpdateDescription sets the ServiceUpdateDescription field's value.
func (s *ServiceUpdate) SetServiceUpdateDescription(v string) *ServiceUpdate {
	s.ServiceUpdateDescription = &v
	return s
}

// SetServiceUpdateEndDate sets the ServiceUpdateEndDate field's value.
func (s *ServiceUpdate) SetServiceUpdateEndDate(v time.Time) *ServiceUpdate {
	s.ServiceUpdateEndDate = &v
	return s
}

// SetServiceUpdateName sets the ServiceUpdateName field's value.
func (s *ServiceUpdate) SetServiceUpdateName(v string) *ServiceUpdate {
	s.ServiceUpdateName = &v
	return s
}

// SetServiceUpdateRecommendedApplyByDate sets the ServiceUpdateRecommendedApplyByDate field's value.
func (s *ServiceUpdate) SetServiceUpdateRecommendedApplyByDate(v time.Time) *ServiceUpdate {
	s.ServiceUpdateRecommendedApplyByDate = &v
	return s
}

// SetServiceUpdateReleaseDate sets the ServiceUpdateReleaseDate field's value.
func (s *ServiceUpdate) SetServiceUpdateReleaseDate(v time.Time) *ServiceUpdate {
	s.ServiceUpdateReleaseDate = &v
	return s
}

// SetServiceUpdateSeverity sets the ServiceUpdateSeverity field's value.
func (s *ServiceUpdate) SetServiceUpdateSeverity(v string) *ServiceUpdate {
	s.ServiceUpdateSeverity = &v
	return s
}

// SetServiceUpdateStatus sets the ServiceUpdateStatus field's value.
func (s *ServiceUpdate) SetServiceUpdateStatus(v string) *ServiceUpdate {
	s.ServiceUpdateStatus = &v
	return s
}

// SetServiceUpdateType sets the ServiceUpdateType field's value.
func (s *ServiceUpdate) SetServiceUpdateType(v string) *ServiceUpdate {
	s.ServiceUpdateType = &v
	return s
}

// Represents the progress of an online resharding operation.
type SlotMigration struct {
	_ struct{} `type:"structure"`

	// The percentage of the slot migration that is complete.
	ProgressPercentage *float64 `type:"double"`
}

// String returns the string representation
func (s SlotMigration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SlotMigration) GoString() string {
	return s.String()
}

// SetProgressPercentage sets the ProgressPercentage field's value.
func (s *SlotMigration) SetProgressPercentage(v float64) *SlotMigration {
	s.ProgressPercentage = &v
	return s
}

// Represents a copy of an entire Redis cluster as of the time when the snapshot
// was taken.
type Snapshot struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) of the snapshot.
	ARN *string `type:"string"`

	// This parameter is currently disabled.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// Indicates the status of automatic failover for the source Redis replication
	// group.
	AutomaticFailover *string `type:"string" enum:"AutomaticFailoverStatus"`

	// The date and time when the source cluster was created.
	CacheClusterCreateTime *time.Time `type:"timestamp"`

	// The user-supplied identifier of the source cluster.
	CacheClusterId *string `type:"string"`

	// The name of the compute and memory capacity node type for the source cluster.
	//
	// The following node types are supported by ElastiCache. Generally speaking,
	// the current generation types provide more memory and computational power
	// at lower cost when compared to their equivalent previous generation counterparts.
	//
	//    * General purpose: Current generation: M5 node types: cache.m5.large,
	//    cache.m5.xlarge, cache.m5.2xlarge, cache.m5.4xlarge, cache.m5.12xlarge,
	//    cache.m5.24xlarge M4 node types: cache.m4.large, cache.m4.xlarge, cache.m4.2xlarge,
	//    cache.m4.4xlarge, cache.m4.10xlarge T3 node types: cache.t3.micro, cache.t3.small,
	//    cache.t3.medium T2 node types: cache.t2.micro, cache.t2.small, cache.t2.medium
	//    Previous generation: (not recommended) T1 node types: cache.t1.micro M1
	//    node types: cache.m1.small, cache.m1.medium, cache.m1.large, cache.m1.xlarge
	//    M3 node types: cache.m3.medium, cache.m3.large, cache.m3.xlarge, cache.m3.2xlarge
	//
	//    * Compute optimized: Previous generation: (not recommended) C1 node types:
	//    cache.c1.xlarge
	//
	//    * Memory optimized: Current generation: R5 node types: cache.r5.large,
	//    cache.r5.xlarge, cache.r5.2xlarge, cache.r5.4xlarge, cache.r5.12xlarge,
	//    cache.r5.24xlarge R4 node types: cache.r4.large, cache.r4.xlarge, cache.r4.2xlarge,
	//    cache.r4.4xlarge, cache.r4.8xlarge, cache.r4.16xlarge Previous generation:
	//    (not recommended) M2 node types: cache.m2.xlarge, cache.m2.2xlarge, cache.m2.4xlarge
	//    R3 node types: cache.r3.large, cache.r3.xlarge, cache.r3.2xlarge, cache.r3.4xlarge,
	//    cache.r3.8xlarge
	//
	// Additional node type info
	//
	//    * All current generation instance types are created in Amazon VPC by default.
	//
	//    * Redis append-only files (AOF) are not supported for T1 or T2 instances.
	//
	//    * Redis Multi-AZ with automatic failover is not supported on T1 instances.
	//
	//    * Redis configuration variables appendonly and appendfsync are not supported
	//    on Redis version 2.8.22 and later.
	CacheNodeType *string `type:"string"`

	// The cache parameter group that is associated with the source cluster.
	CacheParameterGroupName *string `type:"string"`

	// The name of the cache subnet group associated with the source cluster.
	CacheSubnetGroupName *string `type:"string"`

	// The name of the cache engine (memcached or redis) used by the source cluster.
	Engine *string `type:"string"`

	// The version of the cache engine version that is used by the source cluster.
	EngineVersion *string `type:"string"`

	// The ID of the KMS key used to encrypt the snapshot.
	KmsKeyId *string `type:"string"`

	// A list of the cache nodes in the source cluster.
	NodeSnapshots []*NodeSnapshot `locationNameList:"NodeSnapshot" type:"list"`

	// The number of cache nodes in the source cluster.
	//
	// For clusters running Redis, this value must be 1. For clusters running Memcached,
	// this value must be between 1 and 20.
	NumCacheNodes *int64 `type:"integer"`

	// The number of node groups (shards) in this snapshot. When restoring from
	// a snapshot, the number of node groups (shards) in the snapshot and in the
	// restored replication group must be the same.
	NumNodeGroups *int64 `type:"integer"`

	// The port number used by each cache nodes in the source cluster.
	Port *int64 `type:"integer"`

	// The name of the Availability Zone in which the source cluster is located.
	PreferredAvailabilityZone *string `type:"string"`

	// Specifies the weekly time range during which maintenance on the cluster is
	// performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi
	// (24H Clock UTC). The minimum maintenance window is a 60 minute period.
	//
	// Valid values for ddd are:
	//
	//    * sun
	//
	//    * mon
	//
	//    * tue
	//
	//    * wed
	//
	//    * thu
	//
	//    * fri
	//
	//    * sat
	//
	// Example: sun:23:00-mon:01:30
	PreferredMaintenanceWindow *string `type:"string"`

	// A description of the source replication group.
	ReplicationGroupDescription *string `type:"string"`

	// The unique identifier of the source replication group.
	ReplicationGroupId *string `type:"string"`

	// The name of a snapshot. For an automatic snapshot, the name is system-generated.
	// For a manual snapshot, this is the user-provided name.
	SnapshotName *string `type:"string"`

	// For an automatic snapshot, the number of days for which ElastiCache retains
	// the snapshot before deleting it.
	//
	// For manual snapshots, this field reflects the SnapshotRetentionLimit for
	// the source cluster when the snapshot was created. This field is otherwise
	// ignored: Manual snapshots do not expire, and can only be deleted using the
	// DeleteSnapshot operation.
	//
	// Important If the value of SnapshotRetentionLimit is set to zero (0), backups
	// are turned off.
	SnapshotRetentionLimit *int64 `type:"integer"`

	// Indicates whether the snapshot is from an automatic backup (automated) or
	// was created manually (manual).
	SnapshotSource *string `type:"string"`

	// The status of the snapshot. Valid values: creating | available | restoring
	// | copying | deleting.
	SnapshotStatus *string `type:"string"`

	// The daily time range during which ElastiCache takes daily snapshots of the
	// source cluster.
	SnapshotWindow *string `type:"string"`

	// The Amazon Resource Name (ARN) for the topic used by the source cluster for
	// publishing notifications.
	TopicArn *string `type:"string"`

	// The Amazon Virtual Private Cloud identifier (VPC ID) of the cache subnet
	// group for the source cluster.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s Snapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Snapshot) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *Snapshot) SetARN(v string) *Snapshot {
	s.ARN = &v
	return s
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *Snapshot) SetAutoMinorVersionUpgrade(v bool) *Snapshot {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetAutomaticFailover sets the AutomaticFailover field's value.
func (s *Snapshot) SetAutomaticFailover(v string) *Snapshot {
	s.AutomaticFailover = &v
	return s
}

// SetCacheClusterCreateTime sets the CacheClusterCreateTime field's value.
func (s *Snapshot) SetCacheClusterCreateTime(v time.Time) *Snapshot {
	s.CacheClusterCreateTime = &v
	return s
}

// SetCacheClusterId sets the CacheClusterId field's value.
func (s *Snapshot) SetCacheClusterId(v string) *Snapshot {
	s.CacheClusterId = &v
	return s
}

// SetCacheNodeType sets the CacheNodeType field's value.
func (s *Snapshot) SetCacheNodeType(v string) *Snapshot {
	s.CacheNodeType = &v
	return s
}

// SetCacheParameterGroupName sets the CacheParameterGroupName field's value.
func (s *Snapshot) SetCacheParameterGroupName(v string) *Snapshot {
	s.CacheParameterGroupName = &v
	return s
}

// SetCacheSubnetGroupName sets the CacheSubnetGroupName field's value.
func (s *Snapshot) SetCacheSubnetGroupName(v string) *Snapshot {
	s.CacheSubnetGroupName = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *Snapshot) SetEngine(v string) *Snapshot {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *Snapshot) SetEngineVersion(v string) *Snapshot {
	s.EngineVersion = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *Snapshot) SetKmsKeyId(v string) *Snapshot {
	s.KmsKeyId = &v
	return s
}

// SetNodeSnapshots sets the NodeSnapshots field's value.
func (s *Snapshot) SetNodeSnapshots(v []*NodeSnapshot) *Snapshot {
	s.NodeSnapshots = v
	return s
}

// SetNumCacheNodes sets the NumCacheNodes field's value.
func (s *Snapshot) SetNumCacheNodes(v int64) *Snapshot {
	s.NumCacheNodes = &v
	return s
}

// SetNumNodeGroups sets the NumNodeGroups field's value.
func (s *Snapshot) SetNumNodeGroups(v int64) *Snapshot {
	s.NumNodeGroups = &v
	return s
}

// SetPort sets the Port field's value.
func (s *Snapshot) SetPort(v int64) *Snapshot {
	s.Port = &v
	return s
}

// SetPreferredAvailabilityZone sets the PreferredAvailabilityZone field's value.
func (s *Snapshot) SetPreferredAvailabilityZone(v string) *Snapshot {
	s.PreferredAvailabilityZone = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *Snapshot) SetPreferredMaintenanceWindow(v string) *Snapshot {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetReplicationGroupDescription sets the ReplicationGroupDescription field's value.
func (s *Snapshot) SetReplicationGroupDescription(v string) *Snapshot {
	s.ReplicationGroupDescription = &v
	return s
}

// SetReplicationGroupId sets the ReplicationGroupId field's value.
func (s *Snapshot) SetReplicationGroupId(v string) *Snapshot {
	s.ReplicationGroupId = &v
	return s
}

// SetSnapshotName sets the SnapshotName field's value.
func (s *Snapshot) SetSnapshotName(v string) *Snapshot {
	s.SnapshotName = &v
	return s
}

// SetSnapshotRetentionLimit sets the SnapshotRetentionLimit field's value.
func (s *Snapshot) SetSnapshotRetentionLimit(v int64) *Snapshot {
	s.SnapshotRetentionLimit = &v
	return s
}

// SetSnapshotSource sets the SnapshotSource field's value.
func (s *Snapshot) SetSnapshotSource(v string) *Snapshot {
	s.SnapshotSource = &v
	return s
}

// SetSnapshotStatus sets the SnapshotStatus field's value.
func (s *Snapshot) SetSnapshotStatus(v string) *Snapshot {
	s.SnapshotStatus = &v
	return s
}

// SetSnapshotWindow sets the SnapshotWindow field's value.
func (s *Snapshot) SetSnapshotWindow(v string) *Snapshot {
	s.SnapshotWindow = &v
	return s
}

// SetTopicArn sets the TopicArn field's value.
func (s *Snapshot) SetTopicArn(v string) *Snapshot {
	s.TopicArn = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *Snapshot) SetVpcId(v string) *Snapshot {
	s.VpcId = &v
	return s
}

type StartMigrationInput struct {
	_ struct{} `type:"structure"`

	// List of endpoints from which data should be migrated. For Redis (cluster
	// mode disabled), list should have only one element.
	//
	// CustomerNodeEndpointList is a required field
	CustomerNodeEndpointList []*CustomerNodeEndpoint `type:"list" required:"true"`

	// The ID of the replication group to which data should be migrated.
	//
	// ReplicationGroupId is a required field
	ReplicationGroupId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StartMigrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartMigrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartMigrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartMigrationInput"}
	if s.CustomerNodeEndpointList == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomerNodeEndpointList"))
	}
	if s.ReplicationGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationGroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomerNodeEndpointList sets the CustomerNodeEndpointList field's value.
func (s *StartMigrationInput) SetCustomerNodeEndpointList(v []*CustomerNodeEndpoint) *StartMigrationInput {
	s.CustomerNodeEndpointList = v
	return s
}

// SetReplicationGroupId sets the ReplicationGroupId field's value.
func (s *StartMigrationInput) SetReplicationGroupId(v string) *StartMigrationInput {
	s.ReplicationGroupId = &v
	return s
}

type StartMigrationOutput struct {
	_ struct{} `type:"structure"`

	// Contains all of the attributes of a specific Redis replication group.
	ReplicationGroup *ReplicationGroup `type:"structure"`
}

// String returns the string representation
func (s StartMigrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartMigrationOutput) GoString() string {
	return s.String()
}

// SetReplicationGroup sets the ReplicationGroup field's value.
func (s *StartMigrationOutput) SetReplicationGroup(v *ReplicationGroup) *StartMigrationOutput {
	s.ReplicationGroup = v
	return s
}

// Represents the subnet associated with a cluster. This parameter refers to
// subnets defined in Amazon Virtual Private Cloud (Amazon VPC) and used with
// ElastiCache.
type Subnet struct {
	_ struct{} `type:"structure"`

	// The Availability Zone associated with the subnet.
	SubnetAvailabilityZone *AvailabilityZone `type:"structure"`

	// The unique identifier for the subnet.
	SubnetIdentifier *string `type:"string"`
}

// String returns the string representation
func (s Subnet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Subnet) GoString() string {
	return s.String()
}

// SetSubnetAvailabilityZone sets the SubnetAvailabilityZone field's value.
func (s *Subnet) SetSubnetAvailabilityZone(v *AvailabilityZone) *Subnet {
	s.SubnetAvailabilityZone = v
	return s
}

// SetSubnetIdentifier sets the SubnetIdentifier field's value.
func (s *Subnet) SetSubnetIdentifier(v string) *Subnet {
	s.SubnetIdentifier = &v
	return s
}

// A cost allocation Tag that can be added to an ElastiCache cluster or replication
// group. Tags are composed of a Key/Value pair. A tag with a null Value is
// permitted.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key for the tag. May not be null.
	Key *string `type:"string"`

	// The tag's value. May be null.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// Represents the output from the AddTagsToResource, ListTagsForResource, and
// RemoveTagsFromResource operations.
type TagListMessage struct {
	_ struct{} `type:"structure"`

	// A list of cost allocation tags as key-value pairs.
	TagList []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s TagListMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagListMessage) GoString() string {
	return s.String()
}

// SetTagList sets the TagList field's value.
func (s *TagListMessage) SetTagList(v []*Tag) *TagListMessage {
	s.TagList = v
	return s
}

type TestFailoverInput struct {
	_ struct{} `type:"structure"`

	// The name of the node group (called shard in the console) in this replication
	// group on which automatic failover is to be tested. You may test automatic
	// failover on up to 5 node groups in any rolling 24-hour period.
	//
	// NodeGroupId is a required field
	NodeGroupId *string `min:"1" type:"string" required:"true"`

	// The name of the replication group (console: cluster) whose automatic failover
	// is being tested by this operation.
	//
	// ReplicationGroupId is a required field
	ReplicationGroupId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TestFailoverInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestFailoverInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestFailoverInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TestFailoverInput"}
	if s.NodeGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeGroupId"))
	}
	if s.NodeGroupId != nil && len(*s.NodeGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NodeGroupId", 1))
	}
	if s.ReplicationGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationGroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNodeGroupId sets the NodeGroupId field's value.
func (s *TestFailoverInput) SetNodeGroupId(v string) *TestFailoverInput {
	s.NodeGroupId = &v
	return s
}

// SetReplicationGroupId sets the ReplicationGroupId field's value.
func (s *TestFailoverInput) SetReplicationGroupId(v string) *TestFailoverInput {
	s.ReplicationGroupId = &v
	return s
}

type TestFailoverOutput struct {
	_ struct{} `type:"structure"`

	// Contains all of the attributes of a specific Redis replication group.
	ReplicationGroup *ReplicationGroup `type:"structure"`
}

// String returns the string representation
func (s TestFailoverOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestFailoverOutput) GoString() string {
	return s.String()
}

// SetReplicationGroup sets the ReplicationGroup field's value.
func (s *TestFailoverOutput) SetReplicationGroup(v *ReplicationGroup) *TestFailoverOutput {
	s.ReplicationGroup = v
	return s
}

// Filters update actions from the service updates that are in available status
// during the time range.
type TimeRangeFilter struct {
	_ struct{} `type:"structure"`

	// The end time of the time range filter
	EndTime *time.Time `type:"timestamp"`

	// The start time of the time range filter
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s TimeRangeFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeRangeFilter) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *TimeRangeFilter) SetEndTime(v time.Time) *TimeRangeFilter {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *TimeRangeFilter) SetStartTime(v time.Time) *TimeRangeFilter {
	s.StartTime = &v
	return s
}

// Update action that has failed to be processed for the corresponding apply/stop
// request
type UnprocessedUpdateAction struct {
	_ struct{} `type:"structure"`

	// The ID of the cache cluster
	CacheClusterId *string `type:"string"`

	// The error message that describes the reason the request was not processed
	ErrorMessage *string `type:"string"`

	// The error type for requests that are not processed
	ErrorType *string `type:"string"`

	// The replication group ID
	ReplicationGroupId *string `type:"string"`

	// The unique ID of the service update
	ServiceUpdateName *string `type:"string"`
}

// String returns the string representation
func (s UnprocessedUpdateAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnprocessedUpdateAction) GoString() string {
	return s.String()
}

// SetCacheClusterId sets the CacheClusterId field's value.
func (s *UnprocessedUpdateAction) SetCacheClusterId(v string) *UnprocessedUpdateAction {
	s.CacheClusterId = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *UnprocessedUpdateAction) SetErrorMessage(v string) *UnprocessedUpdateAction {
	s.ErrorMessage = &v
	return s
}

// SetErrorType sets the ErrorType field's value.
func (s *UnprocessedUpdateAction) SetErrorType(v string) *UnprocessedUpdateAction {
	s.ErrorType = &v
	return s
}

// SetReplicationGroupId sets the ReplicationGroupId field's value.
func (s *UnprocessedUpdateAction) SetReplicationGroupId(v string) *UnprocessedUpdateAction {
	s.ReplicationGroupId = &v
	return s
}

// SetServiceUpdateName sets the ServiceUpdateName field's value.
func (s *UnprocessedUpdateAction) SetServiceUpdateName(v string) *UnprocessedUpdateAction {
	s.ServiceUpdateName = &v
	return s
}

// The status of the service update for a specific replication group
type UpdateAction struct {
	_ struct{} `type:"structure"`

	// The ID of the cache cluster
	CacheClusterId *string `type:"string"`

	// The status of the service update on the cache node
	CacheNodeUpdateStatus []*CacheNodeUpdateStatus `locationNameList:"CacheNodeUpdateStatus" type:"list"`

	// The Elasticache engine to which the update applies. Either Redis or Memcached
	Engine *string `type:"string"`

	// The estimated length of time for the update to complete
	EstimatedUpdateTime *string `type:"string"`

	// The status of the service update on the node group
	NodeGroupUpdateStatus []*NodeGroupUpdateStatus `locationNameList:"NodeGroupUpdateStatus" type:"list"`

	// The progress of the service update on the replication group
	NodesUpdated *string `type:"string"`

	// The ID of the replication group
	ReplicationGroupId *string `type:"string"`

	// The unique ID of the service update
	ServiceUpdateName *string `type:"string"`

	// The recommended date to apply the service update to ensure compliance. For
	// information on compliance, see Self-Service Security Updates for Compliance
	// (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/elasticache-compliance.html#elasticache-compliance-self-service).
	ServiceUpdateRecommendedApplyByDate *time.Time `type:"timestamp"`

	// The date the update is first available
	ServiceUpdateReleaseDate *time.Time `type:"timestamp"`

	// The severity of the service update
	ServiceUpdateSeverity *string `type:"string" enum:"ServiceUpdateSeverity"`

	// The status of the service update
	ServiceUpdateStatus *string `type:"string" enum:"ServiceUpdateStatus"`

	// Reflects the nature of the service update
	ServiceUpdateType *string `type:"string" enum:"ServiceUpdateType"`

	// If yes, all nodes in the replication group have been updated by the recommended
	// apply-by date. If no, at least one node in the replication group have not
	// been updated by the recommended apply-by date. If N/A, the replication group
	// was created after the recommended apply-by date.
	SlaMet *string `type:"string" enum:"SlaMet"`

	// The date that the service update is available to a replication group
	UpdateActionAvailableDate *time.Time `type:"timestamp"`

	// The status of the update action
	UpdateActionStatus *string `type:"string" enum:"UpdateActionStatus"`

	// The date when the UpdateActionStatus was last modified
	UpdateActionStatusModifiedDate *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s UpdateAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAction) GoString() string {
	return s.String()
}

// SetCacheClusterId sets the CacheClusterId field's value.
func (s *UpdateAction) SetCacheClusterId(v string) *UpdateAction {
	s.CacheClusterId = &v
	return s
}

// SetCacheNodeUpdateStatus sets the CacheNodeUpdateStatus field's value.
func (s *UpdateAction) SetCacheNodeUpdateStatus(v []*CacheNodeUpdateStatus) *UpdateAction {
	s.CacheNodeUpdateStatus = v
	return s
}

// SetEngine sets the Engine field's value.
func (s *UpdateAction) SetEngine(v string) *UpdateAction {
	s.Engine = &v
	return s
}

// SetEstimatedUpdateTime sets the EstimatedUpdateTime field's value.
func (s *UpdateAction) SetEstimatedUpdateTime(v string) *UpdateAction {
	s.EstimatedUpdateTime = &v
	return s
}

// SetNodeGroupUpdateStatus sets the NodeGroupUpdateStatus field's value.
func (s *UpdateAction) SetNodeGroupUpdateStatus(v []*NodeGroupUpdateStatus) *UpdateAction {
	s.NodeGroupUpdateStatus = v
	return s
}

// SetNodesUpdated sets the NodesUpdated field's value.
func (s *UpdateAction) SetNodesUpdated(v string) *UpdateAction {
	s.NodesUpdated = &v
	return s
}

// SetReplicationGroupId sets the ReplicationGroupId field's value.
func (s *UpdateAction) SetReplicationGroupId(v string) *UpdateAction {
	s.ReplicationGroupId = &v
	return s
}

// SetServiceUpdateName sets the ServiceUpdateName field's value.
func (s *UpdateAction) SetServiceUpdateName(v string) *UpdateAction {
	s.ServiceUpdateName = &v
	return s
}

// SetServiceUpdateRecommendedApplyByDate sets the ServiceUpdateRecommendedApplyByDate field's value.
func (s *UpdateAction) SetServiceUpdateRecommendedApplyByDate(v time.Time) *UpdateAction {
	s.ServiceUpdateRecommendedApplyByDate = &v
	return s
}

// SetServiceUpdateReleaseDate sets the ServiceUpdateReleaseDate field's value.
func (s *UpdateAction) SetServiceUpdateReleaseDate(v time.Time) *UpdateAction {
	s.ServiceUpdateReleaseDate = &v
	return s
}

// SetServiceUpdateSeverity sets the ServiceUpdateSeverity field's value.
func (s *UpdateAction) SetServiceUpdateSeverity(v string) *UpdateAction {
	s.ServiceUpdateSeverity = &v
	return s
}

// SetServiceUpdateStatus sets the ServiceUpdateStatus field's value.
func (s *UpdateAction) SetServiceUpdateStatus(v string) *UpdateAction {
	s.ServiceUpdateStatus = &v
	return s
}

// SetServiceUpdateType sets the ServiceUpdateType field's value.
func (s *UpdateAction) SetServiceUpdateType(v string) *UpdateAction {
	s.ServiceUpdateType = &v
	return s
}

// SetSlaMet sets the SlaMet field's value.
func (s *UpdateAction) SetSlaMet(v string) *UpdateAction {
	s.SlaMet = &v
	return s
}

// SetUpdateActionAvailableDate sets the UpdateActionAvailableDate field's value.
func (s *UpdateAction) SetUpdateActionAvailableDate(v time.Time) *UpdateAction {
	s.UpdateActionAvailableDate = &v
	return s
}

// SetUpdateActionStatus sets the UpdateActionStatus field's value.
func (s *UpdateAction) SetUpdateActionStatus(v string) *UpdateAction {
	s.UpdateActionStatus = &v
	return s
}

// SetUpdateActionStatusModifiedDate sets the UpdateActionStatusModifiedDate field's value.
func (s *UpdateAction) SetUpdateActionStatusModifiedDate(v time.Time) *UpdateAction {
	s.UpdateActionStatusModifiedDate = &v
	return s
}

const (
	// AZModeSingleAz is a AZMode enum value
	AZModeSingleAz = "single-az"

	// AZModeCrossAz is a AZMode enum value
	AZModeCrossAz = "cross-az"
)

const (
	// AuthTokenUpdateStatusSetting is a AuthTokenUpdateStatus enum value
	AuthTokenUpdateStatusSetting = "SETTING"

	// AuthTokenUpdateStatusRotating is a AuthTokenUpdateStatus enum value
	AuthTokenUpdateStatusRotating = "ROTATING"
)

const (
	// AuthTokenUpdateStrategyTypeSet is a AuthTokenUpdateStrategyType enum value
	AuthTokenUpdateStrategyTypeSet = "SET"

	// AuthTokenUpdateStrategyTypeRotate is a AuthTokenUpdateStrategyType enum value
	AuthTokenUpdateStrategyTypeRotate = "ROTATE"
)

const (
	// AutomaticFailoverStatusEnabled is a AutomaticFailoverStatus enum value
	AutomaticFailoverStatusEnabled = "enabled"

	// AutomaticFailoverStatusDisabled is a AutomaticFailoverStatus enum value
	AutomaticFailoverStatusDisabled = "disabled"

	// AutomaticFailoverStatusEnabling is a AutomaticFailoverStatus enum value
	AutomaticFailoverStatusEnabling = "enabling"

	// AutomaticFailoverStatusDisabling is a AutomaticFailoverStatus enum value
	AutomaticFailoverStatusDisabling = "disabling"
)

const (
	// ChangeTypeImmediate is a ChangeType enum value
	ChangeTypeImmediate = "immediate"

	// ChangeTypeRequiresReboot is a ChangeType enum value
	ChangeTypeRequiresReboot = "requires-reboot"
)

const (
	// MultiAZStatusEnabled is a MultiAZStatus enum value
	MultiAZStatusEnabled = "enabled"

	// MultiAZStatusDisabled is a MultiAZStatus enum value
	MultiAZStatusDisabled = "disabled"
)

const (
	// NodeUpdateInitiatedBySystem is a NodeUpdateInitiatedBy enum value
	NodeUpdateInitiatedBySystem = "system"

	// NodeUpdateInitiatedByCustomer is a NodeUpdateInitiatedBy enum value
	NodeUpdateInitiatedByCustomer = "customer"
)

const (
	// NodeUpdateStatusNotApplied is a NodeUpdateStatus enum value
	NodeUpdateStatusNotApplied = "not-applied"

	// NodeUpdateStatusWaitingToStart is a NodeUpdateStatus enum value
	NodeUpdateStatusWaitingToStart = "waiting-to-start"

	// NodeUpdateStatusInProgress is a NodeUpdateStatus enum value
	NodeUpdateStatusInProgress = "in-progress"

	// NodeUpdateStatusStopping is a NodeUpdateStatus enum value
	NodeUpdateStatusStopping = "stopping"

	// NodeUpdateStatusStopped is a NodeUpdateStatus enum value
	NodeUpdateStatusStopped = "stopped"

	// NodeUpdateStatusComplete is a NodeUpdateStatus enum value
	NodeUpdateStatusComplete = "complete"
)

const (
	// PendingAutomaticFailoverStatusEnabled is a PendingAutomaticFailoverStatus enum value
	PendingAutomaticFailoverStatusEnabled = "enabled"

	// PendingAutomaticFailoverStatusDisabled is a PendingAutomaticFailoverStatus enum value
	PendingAutomaticFailoverStatusDisabled = "disabled"
)

const (
	// ServiceUpdateSeverityCritical is a ServiceUpdateSeverity enum value
	ServiceUpdateSeverityCritical = "critical"

	// ServiceUpdateSeverityImportant is a ServiceUpdateSeverity enum value
	ServiceUpdateSeverityImportant = "important"

	// ServiceUpdateSeverityMedium is a ServiceUpdateSeverity enum value
	ServiceUpdateSeverityMedium = "medium"

	// ServiceUpdateSeverityLow is a ServiceUpdateSeverity enum value
	ServiceUpdateSeverityLow = "low"
)

const (
	// ServiceUpdateStatusAvailable is a ServiceUpdateStatus enum value
	ServiceUpdateStatusAvailable = "available"

	// ServiceUpdateStatusCancelled is a ServiceUpdateStatus enum value
	ServiceUpdateStatusCancelled = "cancelled"

	// ServiceUpdateStatusExpired is a ServiceUpdateStatus enum value
	ServiceUpdateStatusExpired = "expired"
)

const (
	// ServiceUpdateTypeSecurityUpdate is a ServiceUpdateType enum value
	ServiceUpdateTypeSecurityUpdate = "security-update"
)

const (
	// SlaMetYes is a SlaMet enum value
	SlaMetYes = "yes"

	// SlaMetNo is a SlaMet enum value
	SlaMetNo = "no"

	// SlaMetNA is a SlaMet enum value
	SlaMetNA = "n/a"
)

const (
	// SourceTypeCacheCluster is a SourceType enum value
	SourceTypeCacheCluster = "cache-cluster"

	// SourceTypeCacheParameterGroup is a SourceType enum value
	SourceTypeCacheParameterGroup = "cache-parameter-group"

	// SourceTypeCacheSecurityGroup is a SourceType enum value
	SourceTypeCacheSecurityGroup = "cache-security-group"

	// SourceTypeCacheSubnetGroup is a SourceType enum value
	SourceTypeCacheSubnetGroup = "cache-subnet-group"

	// SourceTypeReplicationGroup is a SourceType enum value
	SourceTypeReplicationGroup = "replication-group"
)

const (
	// UpdateActionStatusNotApplied is a UpdateActionStatus enum value
	UpdateActionStatusNotApplied = "not-applied"

	// UpdateActionStatusWaitingToStart is a UpdateActionStatus enum value
	UpdateActionStatusWaitingToStart = "waiting-to-start"

	// UpdateActionStatusInProgress is a UpdateActionStatus enum value
	UpdateActionStatusInProgress = "in-progress"

	// UpdateActionStatusStopping is a UpdateActionStatus enum value
	UpdateActionStatusStopping = "stopping"

	// UpdateActionStatusStopped is a UpdateActionStatus enum value
	UpdateActionStatusStopped = "stopped"

	// UpdateActionStatusComplete is a UpdateActionStatus enum value
	UpdateActionStatusComplete = "complete"

	// UpdateActionStatusScheduling is a UpdateActionStatus enum value
	UpdateActionStatusScheduling = "scheduling"

	// UpdateActionStatusScheduled is a UpdateActionStatus enum value
	UpdateActionStatusScheduled = "scheduled"

	// UpdateActionStatusNotApplicable is a UpdateActionStatus enum value
	UpdateActionStatusNotApplicable = "not-applicable"
)
