// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsitewise

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociateAssets = "AssociateAssets"

// AssociateAssetsRequest generates a "aws/request.Request" representing the
// client's request for the AssociateAssets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateAssets for more information on using the AssociateAssets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateAssetsRequest method.
//    req, resp := client.AssociateAssetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/AssociateAssets
func (c *IoTSiteWise) AssociateAssetsRequest(input *AssociateAssetsInput) (req *request.Request, output *AssociateAssetsOutput) {
	op := &request.Operation{
		Name:       opAssociateAssets,
		HTTPMethod: "POST",
		HTTPPath:   "/assets/{assetId}/associate",
	}

	if input == nil {
		input = &AssociateAssetsInput{}
	}

	output = &AssociateAssetsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("model.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// AssociateAssets API operation for AWS IoT SiteWise.
//
// Associates a child asset with the given parent asset through a hierarchy
// defined in the parent asset's model. For more information, see Associating
// Assets (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/add-associated-assets.html)
// in the AWS IoT SiteWise User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation AssociateAssets for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * LimitExceededException
//   You've reached the limit for a resource. For example, this can occur if you're
//   trying to associate more than the allowed number of child assets or attempting
//   to create more than the allowed number of properties for an asset model.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/AssociateAssets
func (c *IoTSiteWise) AssociateAssets(input *AssociateAssetsInput) (*AssociateAssetsOutput, error) {
	req, out := c.AssociateAssetsRequest(input)
	return out, req.Send()
}

// AssociateAssetsWithContext is the same as AssociateAssets with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateAssets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) AssociateAssetsWithContext(ctx aws.Context, input *AssociateAssetsInput, opts ...request.Option) (*AssociateAssetsOutput, error) {
	req, out := c.AssociateAssetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchAssociateProjectAssets = "BatchAssociateProjectAssets"

// BatchAssociateProjectAssetsRequest generates a "aws/request.Request" representing the
// client's request for the BatchAssociateProjectAssets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchAssociateProjectAssets for more information on using the BatchAssociateProjectAssets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchAssociateProjectAssetsRequest method.
//    req, resp := client.BatchAssociateProjectAssetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchAssociateProjectAssets
func (c *IoTSiteWise) BatchAssociateProjectAssetsRequest(input *BatchAssociateProjectAssetsInput) (req *request.Request, output *BatchAssociateProjectAssetsOutput) {
	op := &request.Operation{
		Name:       opBatchAssociateProjectAssets,
		HTTPMethod: "POST",
		HTTPPath:   "/projects/{projectId}/assets/associate",
	}

	if input == nil {
		input = &BatchAssociateProjectAssetsInput{}
	}

	output = &BatchAssociateProjectAssetsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// BatchAssociateProjectAssets API operation for AWS IoT SiteWise.
//
// Associates a group (batch) of assets with an AWS IoT SiteWise Monitor project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation BatchAssociateProjectAssets for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * LimitExceededException
//   You've reached the limit for a resource. For example, this can occur if you're
//   trying to associate more than the allowed number of child assets or attempting
//   to create more than the allowed number of properties for an asset model.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchAssociateProjectAssets
func (c *IoTSiteWise) BatchAssociateProjectAssets(input *BatchAssociateProjectAssetsInput) (*BatchAssociateProjectAssetsOutput, error) {
	req, out := c.BatchAssociateProjectAssetsRequest(input)
	return out, req.Send()
}

// BatchAssociateProjectAssetsWithContext is the same as BatchAssociateProjectAssets with the addition of
// the ability to pass a context and additional request options.
//
// See BatchAssociateProjectAssets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) BatchAssociateProjectAssetsWithContext(ctx aws.Context, input *BatchAssociateProjectAssetsInput, opts ...request.Option) (*BatchAssociateProjectAssetsOutput, error) {
	req, out := c.BatchAssociateProjectAssetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDisassociateProjectAssets = "BatchDisassociateProjectAssets"

// BatchDisassociateProjectAssetsRequest generates a "aws/request.Request" representing the
// client's request for the BatchDisassociateProjectAssets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDisassociateProjectAssets for more information on using the BatchDisassociateProjectAssets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDisassociateProjectAssetsRequest method.
//    req, resp := client.BatchDisassociateProjectAssetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchDisassociateProjectAssets
func (c *IoTSiteWise) BatchDisassociateProjectAssetsRequest(input *BatchDisassociateProjectAssetsInput) (req *request.Request, output *BatchDisassociateProjectAssetsOutput) {
	op := &request.Operation{
		Name:       opBatchDisassociateProjectAssets,
		HTTPMethod: "POST",
		HTTPPath:   "/projects/{projectId}/assets/disassociate",
	}

	if input == nil {
		input = &BatchDisassociateProjectAssetsInput{}
	}

	output = &BatchDisassociateProjectAssetsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// BatchDisassociateProjectAssets API operation for AWS IoT SiteWise.
//
// Disassociates a group (batch) of assets from an AWS IoT SiteWise Monitor
// project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation BatchDisassociateProjectAssets for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchDisassociateProjectAssets
func (c *IoTSiteWise) BatchDisassociateProjectAssets(input *BatchDisassociateProjectAssetsInput) (*BatchDisassociateProjectAssetsOutput, error) {
	req, out := c.BatchDisassociateProjectAssetsRequest(input)
	return out, req.Send()
}

// BatchDisassociateProjectAssetsWithContext is the same as BatchDisassociateProjectAssets with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDisassociateProjectAssets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) BatchDisassociateProjectAssetsWithContext(ctx aws.Context, input *BatchDisassociateProjectAssetsInput, opts ...request.Option) (*BatchDisassociateProjectAssetsOutput, error) {
	req, out := c.BatchDisassociateProjectAssetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchPutAssetPropertyValue = "BatchPutAssetPropertyValue"

// BatchPutAssetPropertyValueRequest generates a "aws/request.Request" representing the
// client's request for the BatchPutAssetPropertyValue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchPutAssetPropertyValue for more information on using the BatchPutAssetPropertyValue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchPutAssetPropertyValueRequest method.
//    req, resp := client.BatchPutAssetPropertyValueRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchPutAssetPropertyValue
func (c *IoTSiteWise) BatchPutAssetPropertyValueRequest(input *BatchPutAssetPropertyValueInput) (req *request.Request, output *BatchPutAssetPropertyValueOutput) {
	op := &request.Operation{
		Name:       opBatchPutAssetPropertyValue,
		HTTPMethod: "POST",
		HTTPPath:   "/properties",
	}

	if input == nil {
		input = &BatchPutAssetPropertyValueInput{}
	}

	output = &BatchPutAssetPropertyValueOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("data.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// BatchPutAssetPropertyValue API operation for AWS IoT SiteWise.
//
// Sends a list of asset property values to AWS IoT SiteWise. Each value is
// a timestamp-quality-value (TQV) data point. For more information, see Ingesting
// Data Using the API (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/ingest-api.html)
// in the AWS IoT SiteWise User Guide.
//
// To identify an asset property, you must specify one of the following:
//
//    * The assetId and propertyId of an asset property.
//
//    * A propertyAlias, which is a data stream alias (for example, /company/windfarm/3/turbine/7/temperature).
//    To define an asset property's alias, see UpdateAssetProperty (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
//
// With respect to Unix epoch time, AWS IoT SiteWise accepts only TQVs that
// have a timestamp of no more than 15 minutes in the past and no more than
// 5 minutes in the future. AWS IoT SiteWise rejects timestamps outside of the
// inclusive range of [-15, +5] minutes and returns a TimestampOutOfRangeException
// error.
//
// For each asset property, AWS IoT SiteWise overwrites TQVs with duplicate
// timestamps unless the newer TQV has a different quality. For example, if
// you store a TQV {T1, GOOD, V1}, then storing {T1, GOOD, V2} replaces the
// existing TQV.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation BatchPutAssetPropertyValue for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * LimitExceededException
//   You've reached the limit for a resource. For example, this can occur if you're
//   trying to associate more than the allowed number of child assets or attempting
//   to create more than the allowed number of properties for an asset model.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * ServiceUnavailableException
//   The requested service is unavailable.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchPutAssetPropertyValue
func (c *IoTSiteWise) BatchPutAssetPropertyValue(input *BatchPutAssetPropertyValueInput) (*BatchPutAssetPropertyValueOutput, error) {
	req, out := c.BatchPutAssetPropertyValueRequest(input)
	return out, req.Send()
}

// BatchPutAssetPropertyValueWithContext is the same as BatchPutAssetPropertyValue with the addition of
// the ability to pass a context and additional request options.
//
// See BatchPutAssetPropertyValue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) BatchPutAssetPropertyValueWithContext(ctx aws.Context, input *BatchPutAssetPropertyValueInput, opts ...request.Option) (*BatchPutAssetPropertyValueOutput, error) {
	req, out := c.BatchPutAssetPropertyValueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAccessPolicy = "CreateAccessPolicy"

// CreateAccessPolicyRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccessPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAccessPolicy for more information on using the CreateAccessPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAccessPolicyRequest method.
//    req, resp := client.CreateAccessPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAccessPolicy
func (c *IoTSiteWise) CreateAccessPolicyRequest(input *CreateAccessPolicyInput) (req *request.Request, output *CreateAccessPolicyOutput) {
	op := &request.Operation{
		Name:       opCreateAccessPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/access-policies",
	}

	if input == nil {
		input = &CreateAccessPolicyInput{}
	}

	output = &CreateAccessPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateAccessPolicy API operation for AWS IoT SiteWise.
//
// Creates an access policy that grants the specified AWS Single Sign-On user
// or group access to the specified AWS IoT SiteWise Monitor portal or project
// resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation CreateAccessPolicy for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * LimitExceededException
//   You've reached the limit for a resource. For example, this can occur if you're
//   trying to associate more than the allowed number of child assets or attempting
//   to create more than the allowed number of properties for an asset model.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAccessPolicy
func (c *IoTSiteWise) CreateAccessPolicy(input *CreateAccessPolicyInput) (*CreateAccessPolicyOutput, error) {
	req, out := c.CreateAccessPolicyRequest(input)
	return out, req.Send()
}

// CreateAccessPolicyWithContext is the same as CreateAccessPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAccessPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) CreateAccessPolicyWithContext(ctx aws.Context, input *CreateAccessPolicyInput, opts ...request.Option) (*CreateAccessPolicyOutput, error) {
	req, out := c.CreateAccessPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAsset = "CreateAsset"

// CreateAssetRequest generates a "aws/request.Request" representing the
// client's request for the CreateAsset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAsset for more information on using the CreateAsset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAssetRequest method.
//    req, resp := client.CreateAssetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAsset
func (c *IoTSiteWise) CreateAssetRequest(input *CreateAssetInput) (req *request.Request, output *CreateAssetOutput) {
	op := &request.Operation{
		Name:       opCreateAsset,
		HTTPMethod: "POST",
		HTTPPath:   "/assets",
	}

	if input == nil {
		input = &CreateAssetInput{}
	}

	output = &CreateAssetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("model.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateAsset API operation for AWS IoT SiteWise.
//
// Creates an asset from an existing asset model. For more information, see
// Creating Assets (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-assets.html)
// in the AWS IoT SiteWise User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation CreateAsset for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * LimitExceededException
//   You've reached the limit for a resource. For example, this can occur if you're
//   trying to associate more than the allowed number of child assets or attempting
//   to create more than the allowed number of properties for an asset model.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAsset
func (c *IoTSiteWise) CreateAsset(input *CreateAssetInput) (*CreateAssetOutput, error) {
	req, out := c.CreateAssetRequest(input)
	return out, req.Send()
}

// CreateAssetWithContext is the same as CreateAsset with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAsset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) CreateAssetWithContext(ctx aws.Context, input *CreateAssetInput, opts ...request.Option) (*CreateAssetOutput, error) {
	req, out := c.CreateAssetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAssetModel = "CreateAssetModel"

// CreateAssetModelRequest generates a "aws/request.Request" representing the
// client's request for the CreateAssetModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAssetModel for more information on using the CreateAssetModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAssetModelRequest method.
//    req, resp := client.CreateAssetModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAssetModel
func (c *IoTSiteWise) CreateAssetModelRequest(input *CreateAssetModelInput) (req *request.Request, output *CreateAssetModelOutput) {
	op := &request.Operation{
		Name:       opCreateAssetModel,
		HTTPMethod: "POST",
		HTTPPath:   "/asset-models",
	}

	if input == nil {
		input = &CreateAssetModelInput{}
	}

	output = &CreateAssetModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("model.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateAssetModel API operation for AWS IoT SiteWise.
//
// Creates an asset model from specified property and hierarchy definitions.
// You create assets from asset models. With asset models, you can easily create
// assets of the same type that have standardized definitions. Each asset created
// from a model inherits the asset model's property and hierarchy definitions.
// For more information, see Defining Asset Models (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/define-models.html)
// in the AWS IoT SiteWise User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation CreateAssetModel for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * LimitExceededException
//   You've reached the limit for a resource. For example, this can occur if you're
//   trying to associate more than the allowed number of child assets or attempting
//   to create more than the allowed number of properties for an asset model.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAssetModel
func (c *IoTSiteWise) CreateAssetModel(input *CreateAssetModelInput) (*CreateAssetModelOutput, error) {
	req, out := c.CreateAssetModelRequest(input)
	return out, req.Send()
}

// CreateAssetModelWithContext is the same as CreateAssetModel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAssetModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) CreateAssetModelWithContext(ctx aws.Context, input *CreateAssetModelInput, opts ...request.Option) (*CreateAssetModelOutput, error) {
	req, out := c.CreateAssetModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDashboard = "CreateDashboard"

// CreateDashboardRequest generates a "aws/request.Request" representing the
// client's request for the CreateDashboard operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDashboard for more information on using the CreateDashboard
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDashboardRequest method.
//    req, resp := client.CreateDashboardRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateDashboard
func (c *IoTSiteWise) CreateDashboardRequest(input *CreateDashboardInput) (req *request.Request, output *CreateDashboardOutput) {
	op := &request.Operation{
		Name:       opCreateDashboard,
		HTTPMethod: "POST",
		HTTPPath:   "/dashboards",
	}

	if input == nil {
		input = &CreateDashboardInput{}
	}

	output = &CreateDashboardOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateDashboard API operation for AWS IoT SiteWise.
//
// Creates a dashboard in an AWS IoT SiteWise Monitor project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation CreateDashboard for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * LimitExceededException
//   You've reached the limit for a resource. For example, this can occur if you're
//   trying to associate more than the allowed number of child assets or attempting
//   to create more than the allowed number of properties for an asset model.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateDashboard
func (c *IoTSiteWise) CreateDashboard(input *CreateDashboardInput) (*CreateDashboardOutput, error) {
	req, out := c.CreateDashboardRequest(input)
	return out, req.Send()
}

// CreateDashboardWithContext is the same as CreateDashboard with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDashboard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) CreateDashboardWithContext(ctx aws.Context, input *CreateDashboardInput, opts ...request.Option) (*CreateDashboardOutput, error) {
	req, out := c.CreateDashboardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGateway = "CreateGateway"

// CreateGatewayRequest generates a "aws/request.Request" representing the
// client's request for the CreateGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGateway for more information on using the CreateGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGatewayRequest method.
//    req, resp := client.CreateGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateGateway
func (c *IoTSiteWise) CreateGatewayRequest(input *CreateGatewayInput) (req *request.Request, output *CreateGatewayOutput) {
	op := &request.Operation{
		Name:       opCreateGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/20200301/gateways",
	}

	if input == nil {
		input = &CreateGatewayInput{}
	}

	output = &CreateGatewayOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("edge.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateGateway API operation for AWS IoT SiteWise.
//
// Creates a gateway, which is a virtual or edge device that delivers industrial
// data streams from local servers to AWS IoT SiteWise. For more information,
// see Ingesting data using a gateway (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/gateway-connector.html)
// in the AWS IoT SiteWise User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation CreateGateway for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * LimitExceededException
//   You've reached the limit for a resource. For example, this can occur if you're
//   trying to associate more than the allowed number of child assets or attempting
//   to create more than the allowed number of properties for an asset model.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateGateway
func (c *IoTSiteWise) CreateGateway(input *CreateGatewayInput) (*CreateGatewayOutput, error) {
	req, out := c.CreateGatewayRequest(input)
	return out, req.Send()
}

// CreateGatewayWithContext is the same as CreateGateway with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) CreateGatewayWithContext(ctx aws.Context, input *CreateGatewayInput, opts ...request.Option) (*CreateGatewayOutput, error) {
	req, out := c.CreateGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePortal = "CreatePortal"

// CreatePortalRequest generates a "aws/request.Request" representing the
// client's request for the CreatePortal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePortal for more information on using the CreatePortal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePortalRequest method.
//    req, resp := client.CreatePortalRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreatePortal
func (c *IoTSiteWise) CreatePortalRequest(input *CreatePortalInput) (req *request.Request, output *CreatePortalOutput) {
	op := &request.Operation{
		Name:       opCreatePortal,
		HTTPMethod: "POST",
		HTTPPath:   "/portals",
	}

	if input == nil {
		input = &CreatePortalInput{}
	}

	output = &CreatePortalOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreatePortal API operation for AWS IoT SiteWise.
//
// Creates a portal, which can contain projects and dashboards. Before you can
// create a portal, you must configure AWS Single Sign-On in the current Region.
// AWS IoT SiteWise Monitor uses AWS SSO to manage user permissions. For more
// information, see Enabling AWS SSO (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso)
// in the AWS IoT SiteWise User Guide.
//
// Before you can sign in to a new portal, you must add at least one AWS SSO
// user or group to that portal. For more information, see Adding or Removing
// Portal Administrators (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/administer-portals.html#portal-change-admins)
// in the AWS IoT SiteWise User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation CreatePortal for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * LimitExceededException
//   You've reached the limit for a resource. For example, this can occur if you're
//   trying to associate more than the allowed number of child assets or attempting
//   to create more than the allowed number of properties for an asset model.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreatePortal
func (c *IoTSiteWise) CreatePortal(input *CreatePortalInput) (*CreatePortalOutput, error) {
	req, out := c.CreatePortalRequest(input)
	return out, req.Send()
}

// CreatePortalWithContext is the same as CreatePortal with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePortal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) CreatePortalWithContext(ctx aws.Context, input *CreatePortalInput, opts ...request.Option) (*CreatePortalOutput, error) {
	req, out := c.CreatePortalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProject = "CreateProject"

// CreateProjectRequest generates a "aws/request.Request" representing the
// client's request for the CreateProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProject for more information on using the CreateProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateProjectRequest method.
//    req, resp := client.CreateProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateProject
func (c *IoTSiteWise) CreateProjectRequest(input *CreateProjectInput) (req *request.Request, output *CreateProjectOutput) {
	op := &request.Operation{
		Name:       opCreateProject,
		HTTPMethod: "POST",
		HTTPPath:   "/projects",
	}

	if input == nil {
		input = &CreateProjectInput{}
	}

	output = &CreateProjectOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateProject API operation for AWS IoT SiteWise.
//
// Creates a project in the specified portal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation CreateProject for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * LimitExceededException
//   You've reached the limit for a resource. For example, this can occur if you're
//   trying to associate more than the allowed number of child assets or attempting
//   to create more than the allowed number of properties for an asset model.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateProject
func (c *IoTSiteWise) CreateProject(input *CreateProjectInput) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	return out, req.Send()
}

// CreateProjectWithContext is the same as CreateProject with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) CreateProjectWithContext(ctx aws.Context, input *CreateProjectInput, opts ...request.Option) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccessPolicy = "DeleteAccessPolicy"

// DeleteAccessPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccessPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccessPolicy for more information on using the DeleteAccessPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAccessPolicyRequest method.
//    req, resp := client.DeleteAccessPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAccessPolicy
func (c *IoTSiteWise) DeleteAccessPolicyRequest(input *DeleteAccessPolicyInput) (req *request.Request, output *DeleteAccessPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteAccessPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/access-policies/{accessPolicyId}",
	}

	if input == nil {
		input = &DeleteAccessPolicyInput{}
	}

	output = &DeleteAccessPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteAccessPolicy API operation for AWS IoT SiteWise.
//
// Deletes an access policy that grants the specified AWS Single Sign-On identity
// access to the specified AWS IoT SiteWise Monitor resource. You can use this
// operation to revoke access to an AWS IoT SiteWise Monitor resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DeleteAccessPolicy for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAccessPolicy
func (c *IoTSiteWise) DeleteAccessPolicy(input *DeleteAccessPolicyInput) (*DeleteAccessPolicyOutput, error) {
	req, out := c.DeleteAccessPolicyRequest(input)
	return out, req.Send()
}

// DeleteAccessPolicyWithContext is the same as DeleteAccessPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccessPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DeleteAccessPolicyWithContext(ctx aws.Context, input *DeleteAccessPolicyInput, opts ...request.Option) (*DeleteAccessPolicyOutput, error) {
	req, out := c.DeleteAccessPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAsset = "DeleteAsset"

// DeleteAssetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAsset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAsset for more information on using the DeleteAsset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAssetRequest method.
//    req, resp := client.DeleteAssetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAsset
func (c *IoTSiteWise) DeleteAssetRequest(input *DeleteAssetInput) (req *request.Request, output *DeleteAssetOutput) {
	op := &request.Operation{
		Name:       opDeleteAsset,
		HTTPMethod: "DELETE",
		HTTPPath:   "/assets/{assetId}",
	}

	if input == nil {
		input = &DeleteAssetInput{}
	}

	output = &DeleteAssetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("model.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteAsset API operation for AWS IoT SiteWise.
//
// Deletes an asset. This action can't be undone. For more information, see
// Deleting Assets and Models (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html)
// in the AWS IoT SiteWise User Guide.
//
// You can't delete an asset that's associated to another asset. For more information,
// see DisassociateAssets (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DisassociateAssets.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DeleteAsset for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAsset
func (c *IoTSiteWise) DeleteAsset(input *DeleteAssetInput) (*DeleteAssetOutput, error) {
	req, out := c.DeleteAssetRequest(input)
	return out, req.Send()
}

// DeleteAssetWithContext is the same as DeleteAsset with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAsset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DeleteAssetWithContext(ctx aws.Context, input *DeleteAssetInput, opts ...request.Option) (*DeleteAssetOutput, error) {
	req, out := c.DeleteAssetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAssetModel = "DeleteAssetModel"

// DeleteAssetModelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAssetModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAssetModel for more information on using the DeleteAssetModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAssetModelRequest method.
//    req, resp := client.DeleteAssetModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAssetModel
func (c *IoTSiteWise) DeleteAssetModelRequest(input *DeleteAssetModelInput) (req *request.Request, output *DeleteAssetModelOutput) {
	op := &request.Operation{
		Name:       opDeleteAssetModel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/asset-models/{assetModelId}",
	}

	if input == nil {
		input = &DeleteAssetModelInput{}
	}

	output = &DeleteAssetModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("model.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteAssetModel API operation for AWS IoT SiteWise.
//
// Deletes an asset model. This action can't be undone. You must delete all
// assets created from an asset model before you can delete the model. Also,
// you can't delete an asset model if a parent asset model exists that contains
// a property formula expression that depends on the asset model that you want
// to delete. For more information, see Deleting Assets and Models (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html)
// in the AWS IoT SiteWise User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DeleteAssetModel for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAssetModel
func (c *IoTSiteWise) DeleteAssetModel(input *DeleteAssetModelInput) (*DeleteAssetModelOutput, error) {
	req, out := c.DeleteAssetModelRequest(input)
	return out, req.Send()
}

// DeleteAssetModelWithContext is the same as DeleteAssetModel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAssetModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DeleteAssetModelWithContext(ctx aws.Context, input *DeleteAssetModelInput, opts ...request.Option) (*DeleteAssetModelOutput, error) {
	req, out := c.DeleteAssetModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDashboard = "DeleteDashboard"

// DeleteDashboardRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDashboard operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDashboard for more information on using the DeleteDashboard
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDashboardRequest method.
//    req, resp := client.DeleteDashboardRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteDashboard
func (c *IoTSiteWise) DeleteDashboardRequest(input *DeleteDashboardInput) (req *request.Request, output *DeleteDashboardOutput) {
	op := &request.Operation{
		Name:       opDeleteDashboard,
		HTTPMethod: "DELETE",
		HTTPPath:   "/dashboards/{dashboardId}",
	}

	if input == nil {
		input = &DeleteDashboardInput{}
	}

	output = &DeleteDashboardOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteDashboard API operation for AWS IoT SiteWise.
//
// Deletes a dashboard from AWS IoT SiteWise Monitor.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DeleteDashboard for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteDashboard
func (c *IoTSiteWise) DeleteDashboard(input *DeleteDashboardInput) (*DeleteDashboardOutput, error) {
	req, out := c.DeleteDashboardRequest(input)
	return out, req.Send()
}

// DeleteDashboardWithContext is the same as DeleteDashboard with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDashboard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DeleteDashboardWithContext(ctx aws.Context, input *DeleteDashboardInput, opts ...request.Option) (*DeleteDashboardOutput, error) {
	req, out := c.DeleteDashboardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGateway = "DeleteGateway"

// DeleteGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGateway for more information on using the DeleteGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGatewayRequest method.
//    req, resp := client.DeleteGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteGateway
func (c *IoTSiteWise) DeleteGatewayRequest(input *DeleteGatewayInput) (req *request.Request, output *DeleteGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteGateway,
		HTTPMethod: "DELETE",
		HTTPPath:   "/20200301/gateways/{gatewayId}",
	}

	if input == nil {
		input = &DeleteGatewayInput{}
	}

	output = &DeleteGatewayOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("edge.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteGateway API operation for AWS IoT SiteWise.
//
// Deletes a gateway from AWS IoT SiteWise. When you delete a gateway, some
// of the gateway's files remain in your gateway's file system. For more information,
// see Data retention (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/data-retention.html)
// in the AWS IoT SiteWise User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DeleteGateway for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteGateway
func (c *IoTSiteWise) DeleteGateway(input *DeleteGatewayInput) (*DeleteGatewayOutput, error) {
	req, out := c.DeleteGatewayRequest(input)
	return out, req.Send()
}

// DeleteGatewayWithContext is the same as DeleteGateway with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DeleteGatewayWithContext(ctx aws.Context, input *DeleteGatewayInput, opts ...request.Option) (*DeleteGatewayOutput, error) {
	req, out := c.DeleteGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePortal = "DeletePortal"

// DeletePortalRequest generates a "aws/request.Request" representing the
// client's request for the DeletePortal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePortal for more information on using the DeletePortal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePortalRequest method.
//    req, resp := client.DeletePortalRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeletePortal
func (c *IoTSiteWise) DeletePortalRequest(input *DeletePortalInput) (req *request.Request, output *DeletePortalOutput) {
	op := &request.Operation{
		Name:       opDeletePortal,
		HTTPMethod: "DELETE",
		HTTPPath:   "/portals/{portalId}",
	}

	if input == nil {
		input = &DeletePortalInput{}
	}

	output = &DeletePortalOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeletePortal API operation for AWS IoT SiteWise.
//
// Deletes a portal from AWS IoT SiteWise Monitor.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DeletePortal for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeletePortal
func (c *IoTSiteWise) DeletePortal(input *DeletePortalInput) (*DeletePortalOutput, error) {
	req, out := c.DeletePortalRequest(input)
	return out, req.Send()
}

// DeletePortalWithContext is the same as DeletePortal with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePortal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DeletePortalWithContext(ctx aws.Context, input *DeletePortalInput, opts ...request.Option) (*DeletePortalOutput, error) {
	req, out := c.DeletePortalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProject = "DeleteProject"

// DeleteProjectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProject for more information on using the DeleteProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteProjectRequest method.
//    req, resp := client.DeleteProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteProject
func (c *IoTSiteWise) DeleteProjectRequest(input *DeleteProjectInput) (req *request.Request, output *DeleteProjectOutput) {
	op := &request.Operation{
		Name:       opDeleteProject,
		HTTPMethod: "DELETE",
		HTTPPath:   "/projects/{projectId}",
	}

	if input == nil {
		input = &DeleteProjectInput{}
	}

	output = &DeleteProjectOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteProject API operation for AWS IoT SiteWise.
//
// Deletes a project from AWS IoT SiteWise Monitor.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DeleteProject for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteProject
func (c *IoTSiteWise) DeleteProject(input *DeleteProjectInput) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	return out, req.Send()
}

// DeleteProjectWithContext is the same as DeleteProject with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DeleteProjectWithContext(ctx aws.Context, input *DeleteProjectInput, opts ...request.Option) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccessPolicy = "DescribeAccessPolicy"

// DescribeAccessPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccessPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccessPolicy for more information on using the DescribeAccessPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAccessPolicyRequest method.
//    req, resp := client.DescribeAccessPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAccessPolicy
func (c *IoTSiteWise) DescribeAccessPolicyRequest(input *DescribeAccessPolicyInput) (req *request.Request, output *DescribeAccessPolicyOutput) {
	op := &request.Operation{
		Name:       opDescribeAccessPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/access-policies/{accessPolicyId}",
	}

	if input == nil {
		input = &DescribeAccessPolicyInput{}
	}

	output = &DescribeAccessPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeAccessPolicy API operation for AWS IoT SiteWise.
//
// Describes an access policy, which specifies an AWS SSO user or group's access
// to an AWS IoT SiteWise Monitor portal or project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DescribeAccessPolicy for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAccessPolicy
func (c *IoTSiteWise) DescribeAccessPolicy(input *DescribeAccessPolicyInput) (*DescribeAccessPolicyOutput, error) {
	req, out := c.DescribeAccessPolicyRequest(input)
	return out, req.Send()
}

// DescribeAccessPolicyWithContext is the same as DescribeAccessPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccessPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DescribeAccessPolicyWithContext(ctx aws.Context, input *DescribeAccessPolicyInput, opts ...request.Option) (*DescribeAccessPolicyOutput, error) {
	req, out := c.DescribeAccessPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAsset = "DescribeAsset"

// DescribeAssetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAsset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAsset for more information on using the DescribeAsset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAssetRequest method.
//    req, resp := client.DescribeAssetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAsset
func (c *IoTSiteWise) DescribeAssetRequest(input *DescribeAssetInput) (req *request.Request, output *DescribeAssetOutput) {
	op := &request.Operation{
		Name:       opDescribeAsset,
		HTTPMethod: "GET",
		HTTPPath:   "/assets/{assetId}",
	}

	if input == nil {
		input = &DescribeAssetInput{}
	}

	output = &DescribeAssetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("model.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeAsset API operation for AWS IoT SiteWise.
//
// Retrieves information about an asset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DescribeAsset for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAsset
func (c *IoTSiteWise) DescribeAsset(input *DescribeAssetInput) (*DescribeAssetOutput, error) {
	req, out := c.DescribeAssetRequest(input)
	return out, req.Send()
}

// DescribeAssetWithContext is the same as DescribeAsset with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAsset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DescribeAssetWithContext(ctx aws.Context, input *DescribeAssetInput, opts ...request.Option) (*DescribeAssetOutput, error) {
	req, out := c.DescribeAssetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAssetModel = "DescribeAssetModel"

// DescribeAssetModelRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAssetModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAssetModel for more information on using the DescribeAssetModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAssetModelRequest method.
//    req, resp := client.DescribeAssetModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAssetModel
func (c *IoTSiteWise) DescribeAssetModelRequest(input *DescribeAssetModelInput) (req *request.Request, output *DescribeAssetModelOutput) {
	op := &request.Operation{
		Name:       opDescribeAssetModel,
		HTTPMethod: "GET",
		HTTPPath:   "/asset-models/{assetModelId}",
	}

	if input == nil {
		input = &DescribeAssetModelInput{}
	}

	output = &DescribeAssetModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("model.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeAssetModel API operation for AWS IoT SiteWise.
//
// Retrieves information about an asset model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DescribeAssetModel for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAssetModel
func (c *IoTSiteWise) DescribeAssetModel(input *DescribeAssetModelInput) (*DescribeAssetModelOutput, error) {
	req, out := c.DescribeAssetModelRequest(input)
	return out, req.Send()
}

// DescribeAssetModelWithContext is the same as DescribeAssetModel with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAssetModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DescribeAssetModelWithContext(ctx aws.Context, input *DescribeAssetModelInput, opts ...request.Option) (*DescribeAssetModelOutput, error) {
	req, out := c.DescribeAssetModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAssetProperty = "DescribeAssetProperty"

// DescribeAssetPropertyRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAssetProperty operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAssetProperty for more information on using the DescribeAssetProperty
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAssetPropertyRequest method.
//    req, resp := client.DescribeAssetPropertyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAssetProperty
func (c *IoTSiteWise) DescribeAssetPropertyRequest(input *DescribeAssetPropertyInput) (req *request.Request, output *DescribeAssetPropertyOutput) {
	op := &request.Operation{
		Name:       opDescribeAssetProperty,
		HTTPMethod: "GET",
		HTTPPath:   "/assets/{assetId}/properties/{propertyId}",
	}

	if input == nil {
		input = &DescribeAssetPropertyInput{}
	}

	output = &DescribeAssetPropertyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("model.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeAssetProperty API operation for AWS IoT SiteWise.
//
// Retrieves information about an asset's property.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DescribeAssetProperty for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAssetProperty
func (c *IoTSiteWise) DescribeAssetProperty(input *DescribeAssetPropertyInput) (*DescribeAssetPropertyOutput, error) {
	req, out := c.DescribeAssetPropertyRequest(input)
	return out, req.Send()
}

// DescribeAssetPropertyWithContext is the same as DescribeAssetProperty with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAssetProperty for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DescribeAssetPropertyWithContext(ctx aws.Context, input *DescribeAssetPropertyInput, opts ...request.Option) (*DescribeAssetPropertyOutput, error) {
	req, out := c.DescribeAssetPropertyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDashboard = "DescribeDashboard"

// DescribeDashboardRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDashboard operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDashboard for more information on using the DescribeDashboard
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDashboardRequest method.
//    req, resp := client.DescribeDashboardRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeDashboard
func (c *IoTSiteWise) DescribeDashboardRequest(input *DescribeDashboardInput) (req *request.Request, output *DescribeDashboardOutput) {
	op := &request.Operation{
		Name:       opDescribeDashboard,
		HTTPMethod: "GET",
		HTTPPath:   "/dashboards/{dashboardId}",
	}

	if input == nil {
		input = &DescribeDashboardInput{}
	}

	output = &DescribeDashboardOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeDashboard API operation for AWS IoT SiteWise.
//
// Retrieves information about a dashboard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DescribeDashboard for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeDashboard
func (c *IoTSiteWise) DescribeDashboard(input *DescribeDashboardInput) (*DescribeDashboardOutput, error) {
	req, out := c.DescribeDashboardRequest(input)
	return out, req.Send()
}

// DescribeDashboardWithContext is the same as DescribeDashboard with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDashboard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DescribeDashboardWithContext(ctx aws.Context, input *DescribeDashboardInput, opts ...request.Option) (*DescribeDashboardOutput, error) {
	req, out := c.DescribeDashboardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGateway = "DescribeGateway"

// DescribeGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGateway for more information on using the DescribeGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeGatewayRequest method.
//    req, resp := client.DescribeGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeGateway
func (c *IoTSiteWise) DescribeGatewayRequest(input *DescribeGatewayInput) (req *request.Request, output *DescribeGatewayOutput) {
	op := &request.Operation{
		Name:       opDescribeGateway,
		HTTPMethod: "GET",
		HTTPPath:   "/20200301/gateways/{gatewayId}",
	}

	if input == nil {
		input = &DescribeGatewayInput{}
	}

	output = &DescribeGatewayOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("edge.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeGateway API operation for AWS IoT SiteWise.
//
// Retrieves information about a gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DescribeGateway for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeGateway
func (c *IoTSiteWise) DescribeGateway(input *DescribeGatewayInput) (*DescribeGatewayOutput, error) {
	req, out := c.DescribeGatewayRequest(input)
	return out, req.Send()
}

// DescribeGatewayWithContext is the same as DescribeGateway with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DescribeGatewayWithContext(ctx aws.Context, input *DescribeGatewayInput, opts ...request.Option) (*DescribeGatewayOutput, error) {
	req, out := c.DescribeGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGatewayCapabilityConfiguration = "DescribeGatewayCapabilityConfiguration"

// DescribeGatewayCapabilityConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGatewayCapabilityConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGatewayCapabilityConfiguration for more information on using the DescribeGatewayCapabilityConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeGatewayCapabilityConfigurationRequest method.
//    req, resp := client.DescribeGatewayCapabilityConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeGatewayCapabilityConfiguration
func (c *IoTSiteWise) DescribeGatewayCapabilityConfigurationRequest(input *DescribeGatewayCapabilityConfigurationInput) (req *request.Request, output *DescribeGatewayCapabilityConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeGatewayCapabilityConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/20200301/gateways/{gatewayId}/capability/{capabilityNamespace}",
	}

	if input == nil {
		input = &DescribeGatewayCapabilityConfigurationInput{}
	}

	output = &DescribeGatewayCapabilityConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("edge.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeGatewayCapabilityConfiguration API operation for AWS IoT SiteWise.
//
// Retrieves information about a gateway capability configuration. Each gateway
// capability defines data sources for a gateway. A capability configuration
// can contain multiple data source configurations. If you define OPC-UA sources
// for a gateway in the AWS IoT SiteWise console, all of your OPC-UA sources
// are stored in one capability configuration. To list all capability configurations
// for a gateway, use DescribeGateway (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGateway.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DescribeGatewayCapabilityConfiguration for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeGatewayCapabilityConfiguration
func (c *IoTSiteWise) DescribeGatewayCapabilityConfiguration(input *DescribeGatewayCapabilityConfigurationInput) (*DescribeGatewayCapabilityConfigurationOutput, error) {
	req, out := c.DescribeGatewayCapabilityConfigurationRequest(input)
	return out, req.Send()
}

// DescribeGatewayCapabilityConfigurationWithContext is the same as DescribeGatewayCapabilityConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGatewayCapabilityConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DescribeGatewayCapabilityConfigurationWithContext(ctx aws.Context, input *DescribeGatewayCapabilityConfigurationInput, opts ...request.Option) (*DescribeGatewayCapabilityConfigurationOutput, error) {
	req, out := c.DescribeGatewayCapabilityConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLoggingOptions = "DescribeLoggingOptions"

// DescribeLoggingOptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLoggingOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLoggingOptions for more information on using the DescribeLoggingOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLoggingOptionsRequest method.
//    req, resp := client.DescribeLoggingOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeLoggingOptions
func (c *IoTSiteWise) DescribeLoggingOptionsRequest(input *DescribeLoggingOptionsInput) (req *request.Request, output *DescribeLoggingOptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeLoggingOptions,
		HTTPMethod: "GET",
		HTTPPath:   "/logging",
	}

	if input == nil {
		input = &DescribeLoggingOptionsInput{}
	}

	output = &DescribeLoggingOptionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("model.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeLoggingOptions API operation for AWS IoT SiteWise.
//
// Retrieves the current AWS IoT SiteWise logging options.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DescribeLoggingOptions for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeLoggingOptions
func (c *IoTSiteWise) DescribeLoggingOptions(input *DescribeLoggingOptionsInput) (*DescribeLoggingOptionsOutput, error) {
	req, out := c.DescribeLoggingOptionsRequest(input)
	return out, req.Send()
}

// DescribeLoggingOptionsWithContext is the same as DescribeLoggingOptions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLoggingOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DescribeLoggingOptionsWithContext(ctx aws.Context, input *DescribeLoggingOptionsInput, opts ...request.Option) (*DescribeLoggingOptionsOutput, error) {
	req, out := c.DescribeLoggingOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePortal = "DescribePortal"

// DescribePortalRequest generates a "aws/request.Request" representing the
// client's request for the DescribePortal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePortal for more information on using the DescribePortal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePortalRequest method.
//    req, resp := client.DescribePortalRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribePortal
func (c *IoTSiteWise) DescribePortalRequest(input *DescribePortalInput) (req *request.Request, output *DescribePortalOutput) {
	op := &request.Operation{
		Name:       opDescribePortal,
		HTTPMethod: "GET",
		HTTPPath:   "/portals/{portalId}",
	}

	if input == nil {
		input = &DescribePortalInput{}
	}

	output = &DescribePortalOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribePortal API operation for AWS IoT SiteWise.
//
// Retrieves information about a portal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DescribePortal for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribePortal
func (c *IoTSiteWise) DescribePortal(input *DescribePortalInput) (*DescribePortalOutput, error) {
	req, out := c.DescribePortalRequest(input)
	return out, req.Send()
}

// DescribePortalWithContext is the same as DescribePortal with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePortal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DescribePortalWithContext(ctx aws.Context, input *DescribePortalInput, opts ...request.Option) (*DescribePortalOutput, error) {
	req, out := c.DescribePortalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProject = "DescribeProject"

// DescribeProjectRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeProject for more information on using the DescribeProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeProjectRequest method.
//    req, resp := client.DescribeProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeProject
func (c *IoTSiteWise) DescribeProjectRequest(input *DescribeProjectInput) (req *request.Request, output *DescribeProjectOutput) {
	op := &request.Operation{
		Name:       opDescribeProject,
		HTTPMethod: "GET",
		HTTPPath:   "/projects/{projectId}",
	}

	if input == nil {
		input = &DescribeProjectInput{}
	}

	output = &DescribeProjectOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeProject API operation for AWS IoT SiteWise.
//
// Retrieves information about a project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DescribeProject for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeProject
func (c *IoTSiteWise) DescribeProject(input *DescribeProjectInput) (*DescribeProjectOutput, error) {
	req, out := c.DescribeProjectRequest(input)
	return out, req.Send()
}

// DescribeProjectWithContext is the same as DescribeProject with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DescribeProjectWithContext(ctx aws.Context, input *DescribeProjectInput, opts ...request.Option) (*DescribeProjectOutput, error) {
	req, out := c.DescribeProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateAssets = "DisassociateAssets"

// DisassociateAssetsRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateAssets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateAssets for more information on using the DisassociateAssets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateAssetsRequest method.
//    req, resp := client.DisassociateAssetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DisassociateAssets
func (c *IoTSiteWise) DisassociateAssetsRequest(input *DisassociateAssetsInput) (req *request.Request, output *DisassociateAssetsOutput) {
	op := &request.Operation{
		Name:       opDisassociateAssets,
		HTTPMethod: "POST",
		HTTPPath:   "/assets/{assetId}/disassociate",
	}

	if input == nil {
		input = &DisassociateAssetsInput{}
	}

	output = &DisassociateAssetsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("model.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DisassociateAssets API operation for AWS IoT SiteWise.
//
// Disassociates a child asset from the given parent asset through a hierarchy
// defined in the parent asset's model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation DisassociateAssets for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DisassociateAssets
func (c *IoTSiteWise) DisassociateAssets(input *DisassociateAssetsInput) (*DisassociateAssetsOutput, error) {
	req, out := c.DisassociateAssetsRequest(input)
	return out, req.Send()
}

// DisassociateAssetsWithContext is the same as DisassociateAssets with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateAssets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) DisassociateAssetsWithContext(ctx aws.Context, input *DisassociateAssetsInput, opts ...request.Option) (*DisassociateAssetsOutput, error) {
	req, out := c.DisassociateAssetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAssetPropertyAggregates = "GetAssetPropertyAggregates"

// GetAssetPropertyAggregatesRequest generates a "aws/request.Request" representing the
// client's request for the GetAssetPropertyAggregates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAssetPropertyAggregates for more information on using the GetAssetPropertyAggregates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAssetPropertyAggregatesRequest method.
//    req, resp := client.GetAssetPropertyAggregatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyAggregates
func (c *IoTSiteWise) GetAssetPropertyAggregatesRequest(input *GetAssetPropertyAggregatesInput) (req *request.Request, output *GetAssetPropertyAggregatesOutput) {
	op := &request.Operation{
		Name:       opGetAssetPropertyAggregates,
		HTTPMethod: "GET",
		HTTPPath:   "/properties/aggregates",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetAssetPropertyAggregatesInput{}
	}

	output = &GetAssetPropertyAggregatesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("data.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetAssetPropertyAggregates API operation for AWS IoT SiteWise.
//
// Gets aggregated values for an asset property. For more information, see Querying
// Aggregated Property Values (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates)
// in the AWS IoT SiteWise User Guide.
//
// To identify an asset property, you must specify one of the following:
//
//    * The assetId and propertyId of an asset property.
//
//    * A propertyAlias, which is a data stream alias (for example, /company/windfarm/3/turbine/7/temperature).
//    To define an asset property's alias, see UpdateAssetProperty (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation GetAssetPropertyAggregates for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * ServiceUnavailableException
//   The requested service is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyAggregates
func (c *IoTSiteWise) GetAssetPropertyAggregates(input *GetAssetPropertyAggregatesInput) (*GetAssetPropertyAggregatesOutput, error) {
	req, out := c.GetAssetPropertyAggregatesRequest(input)
	return out, req.Send()
}

// GetAssetPropertyAggregatesWithContext is the same as GetAssetPropertyAggregates with the addition of
// the ability to pass a context and additional request options.
//
// See GetAssetPropertyAggregates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) GetAssetPropertyAggregatesWithContext(ctx aws.Context, input *GetAssetPropertyAggregatesInput, opts ...request.Option) (*GetAssetPropertyAggregatesOutput, error) {
	req, out := c.GetAssetPropertyAggregatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetAssetPropertyAggregatesPages iterates over the pages of a GetAssetPropertyAggregates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetAssetPropertyAggregates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetAssetPropertyAggregates operation.
//    pageNum := 0
//    err := client.GetAssetPropertyAggregatesPages(params,
//        func(page *iotsitewise.GetAssetPropertyAggregatesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTSiteWise) GetAssetPropertyAggregatesPages(input *GetAssetPropertyAggregatesInput, fn func(*GetAssetPropertyAggregatesOutput, bool) bool) error {
	return c.GetAssetPropertyAggregatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetAssetPropertyAggregatesPagesWithContext same as GetAssetPropertyAggregatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) GetAssetPropertyAggregatesPagesWithContext(ctx aws.Context, input *GetAssetPropertyAggregatesInput, fn func(*GetAssetPropertyAggregatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetAssetPropertyAggregatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetAssetPropertyAggregatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetAssetPropertyAggregatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetAssetPropertyValue = "GetAssetPropertyValue"

// GetAssetPropertyValueRequest generates a "aws/request.Request" representing the
// client's request for the GetAssetPropertyValue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAssetPropertyValue for more information on using the GetAssetPropertyValue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAssetPropertyValueRequest method.
//    req, resp := client.GetAssetPropertyValueRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyValue
func (c *IoTSiteWise) GetAssetPropertyValueRequest(input *GetAssetPropertyValueInput) (req *request.Request, output *GetAssetPropertyValueOutput) {
	op := &request.Operation{
		Name:       opGetAssetPropertyValue,
		HTTPMethod: "GET",
		HTTPPath:   "/properties/latest",
	}

	if input == nil {
		input = &GetAssetPropertyValueInput{}
	}

	output = &GetAssetPropertyValueOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("data.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetAssetPropertyValue API operation for AWS IoT SiteWise.
//
// Gets an asset property's current value. For more information, see Querying
// Current Property Values (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#current-values)
// in the AWS IoT SiteWise User Guide.
//
// To identify an asset property, you must specify one of the following:
//
//    * The assetId and propertyId of an asset property.
//
//    * A propertyAlias, which is a data stream alias (for example, /company/windfarm/3/turbine/7/temperature).
//    To define an asset property's alias, see UpdateAssetProperty (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation GetAssetPropertyValue for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * ServiceUnavailableException
//   The requested service is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyValue
func (c *IoTSiteWise) GetAssetPropertyValue(input *GetAssetPropertyValueInput) (*GetAssetPropertyValueOutput, error) {
	req, out := c.GetAssetPropertyValueRequest(input)
	return out, req.Send()
}

// GetAssetPropertyValueWithContext is the same as GetAssetPropertyValue with the addition of
// the ability to pass a context and additional request options.
//
// See GetAssetPropertyValue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) GetAssetPropertyValueWithContext(ctx aws.Context, input *GetAssetPropertyValueInput, opts ...request.Option) (*GetAssetPropertyValueOutput, error) {
	req, out := c.GetAssetPropertyValueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAssetPropertyValueHistory = "GetAssetPropertyValueHistory"

// GetAssetPropertyValueHistoryRequest generates a "aws/request.Request" representing the
// client's request for the GetAssetPropertyValueHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAssetPropertyValueHistory for more information on using the GetAssetPropertyValueHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAssetPropertyValueHistoryRequest method.
//    req, resp := client.GetAssetPropertyValueHistoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyValueHistory
func (c *IoTSiteWise) GetAssetPropertyValueHistoryRequest(input *GetAssetPropertyValueHistoryInput) (req *request.Request, output *GetAssetPropertyValueHistoryOutput) {
	op := &request.Operation{
		Name:       opGetAssetPropertyValueHistory,
		HTTPMethod: "GET",
		HTTPPath:   "/properties/history",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetAssetPropertyValueHistoryInput{}
	}

	output = &GetAssetPropertyValueHistoryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("data.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetAssetPropertyValueHistory API operation for AWS IoT SiteWise.
//
// Gets the history of an asset property's values. For more information, see
// Querying Historical Property Values (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values)
// in the AWS IoT SiteWise User Guide.
//
// To identify an asset property, you must specify one of the following:
//
//    * The assetId and propertyId of an asset property.
//
//    * A propertyAlias, which is a data stream alias (for example, /company/windfarm/3/turbine/7/temperature).
//    To define an asset property's alias, see UpdateAssetProperty (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation GetAssetPropertyValueHistory for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * ServiceUnavailableException
//   The requested service is unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyValueHistory
func (c *IoTSiteWise) GetAssetPropertyValueHistory(input *GetAssetPropertyValueHistoryInput) (*GetAssetPropertyValueHistoryOutput, error) {
	req, out := c.GetAssetPropertyValueHistoryRequest(input)
	return out, req.Send()
}

// GetAssetPropertyValueHistoryWithContext is the same as GetAssetPropertyValueHistory with the addition of
// the ability to pass a context and additional request options.
//
// See GetAssetPropertyValueHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) GetAssetPropertyValueHistoryWithContext(ctx aws.Context, input *GetAssetPropertyValueHistoryInput, opts ...request.Option) (*GetAssetPropertyValueHistoryOutput, error) {
	req, out := c.GetAssetPropertyValueHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetAssetPropertyValueHistoryPages iterates over the pages of a GetAssetPropertyValueHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetAssetPropertyValueHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetAssetPropertyValueHistory operation.
//    pageNum := 0
//    err := client.GetAssetPropertyValueHistoryPages(params,
//        func(page *iotsitewise.GetAssetPropertyValueHistoryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTSiteWise) GetAssetPropertyValueHistoryPages(input *GetAssetPropertyValueHistoryInput, fn func(*GetAssetPropertyValueHistoryOutput, bool) bool) error {
	return c.GetAssetPropertyValueHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetAssetPropertyValueHistoryPagesWithContext same as GetAssetPropertyValueHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) GetAssetPropertyValueHistoryPagesWithContext(ctx aws.Context, input *GetAssetPropertyValueHistoryInput, fn func(*GetAssetPropertyValueHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetAssetPropertyValueHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetAssetPropertyValueHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetAssetPropertyValueHistoryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAccessPolicies = "ListAccessPolicies"

// ListAccessPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListAccessPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccessPolicies for more information on using the ListAccessPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAccessPoliciesRequest method.
//    req, resp := client.ListAccessPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAccessPolicies
func (c *IoTSiteWise) ListAccessPoliciesRequest(input *ListAccessPoliciesInput) (req *request.Request, output *ListAccessPoliciesOutput) {
	op := &request.Operation{
		Name:       opListAccessPolicies,
		HTTPMethod: "GET",
		HTTPPath:   "/access-policies",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccessPoliciesInput{}
	}

	output = &ListAccessPoliciesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListAccessPolicies API operation for AWS IoT SiteWise.
//
// Retrieves a paginated list of access policies for an AWS SSO identity (a
// user or group) or an AWS IoT SiteWise Monitor resource (a portal or project).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation ListAccessPolicies for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAccessPolicies
func (c *IoTSiteWise) ListAccessPolicies(input *ListAccessPoliciesInput) (*ListAccessPoliciesOutput, error) {
	req, out := c.ListAccessPoliciesRequest(input)
	return out, req.Send()
}

// ListAccessPoliciesWithContext is the same as ListAccessPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccessPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListAccessPoliciesWithContext(ctx aws.Context, input *ListAccessPoliciesInput, opts ...request.Option) (*ListAccessPoliciesOutput, error) {
	req, out := c.ListAccessPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccessPoliciesPages iterates over the pages of a ListAccessPolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccessPolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAccessPolicies operation.
//    pageNum := 0
//    err := client.ListAccessPoliciesPages(params,
//        func(page *iotsitewise.ListAccessPoliciesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTSiteWise) ListAccessPoliciesPages(input *ListAccessPoliciesInput, fn func(*ListAccessPoliciesOutput, bool) bool) error {
	return c.ListAccessPoliciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccessPoliciesPagesWithContext same as ListAccessPoliciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListAccessPoliciesPagesWithContext(ctx aws.Context, input *ListAccessPoliciesInput, fn func(*ListAccessPoliciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccessPoliciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccessPoliciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccessPoliciesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAssetModels = "ListAssetModels"

// ListAssetModelsRequest generates a "aws/request.Request" representing the
// client's request for the ListAssetModels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssetModels for more information on using the ListAssetModels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAssetModelsRequest method.
//    req, resp := client.ListAssetModelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetModels
func (c *IoTSiteWise) ListAssetModelsRequest(input *ListAssetModelsInput) (req *request.Request, output *ListAssetModelsOutput) {
	op := &request.Operation{
		Name:       opListAssetModels,
		HTTPMethod: "GET",
		HTTPPath:   "/asset-models",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssetModelsInput{}
	}

	output = &ListAssetModelsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("model.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListAssetModels API operation for AWS IoT SiteWise.
//
// Retrieves a paginated list of summaries of all asset models.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation ListAssetModels for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetModels
func (c *IoTSiteWise) ListAssetModels(input *ListAssetModelsInput) (*ListAssetModelsOutput, error) {
	req, out := c.ListAssetModelsRequest(input)
	return out, req.Send()
}

// ListAssetModelsWithContext is the same as ListAssetModels with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssetModels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListAssetModelsWithContext(ctx aws.Context, input *ListAssetModelsInput, opts ...request.Option) (*ListAssetModelsOutput, error) {
	req, out := c.ListAssetModelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAssetModelsPages iterates over the pages of a ListAssetModels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssetModels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAssetModels operation.
//    pageNum := 0
//    err := client.ListAssetModelsPages(params,
//        func(page *iotsitewise.ListAssetModelsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTSiteWise) ListAssetModelsPages(input *ListAssetModelsInput, fn func(*ListAssetModelsOutput, bool) bool) error {
	return c.ListAssetModelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAssetModelsPagesWithContext same as ListAssetModelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListAssetModelsPagesWithContext(ctx aws.Context, input *ListAssetModelsInput, fn func(*ListAssetModelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAssetModelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAssetModelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAssetModelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAssets = "ListAssets"

// ListAssetsRequest generates a "aws/request.Request" representing the
// client's request for the ListAssets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssets for more information on using the ListAssets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAssetsRequest method.
//    req, resp := client.ListAssetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssets
func (c *IoTSiteWise) ListAssetsRequest(input *ListAssetsInput) (req *request.Request, output *ListAssetsOutput) {
	op := &request.Operation{
		Name:       opListAssets,
		HTTPMethod: "GET",
		HTTPPath:   "/assets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssetsInput{}
	}

	output = &ListAssetsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("model.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListAssets API operation for AWS IoT SiteWise.
//
// Retrieves a paginated list of asset summaries.
//
// You can use this operation to do the following:
//
//    * List assets based on a specific asset model.
//
//    * List top-level assets.
//
// You can't use this operation to list all assets. To retrieve summaries for
// all of your assets, use ListAssetModels (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_ListAssetModels.html)
// to get all of your asset model IDs. Then, use ListAssets to get all assets
// for each asset model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation ListAssets for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssets
func (c *IoTSiteWise) ListAssets(input *ListAssetsInput) (*ListAssetsOutput, error) {
	req, out := c.ListAssetsRequest(input)
	return out, req.Send()
}

// ListAssetsWithContext is the same as ListAssets with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListAssetsWithContext(ctx aws.Context, input *ListAssetsInput, opts ...request.Option) (*ListAssetsOutput, error) {
	req, out := c.ListAssetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAssetsPages iterates over the pages of a ListAssets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAssets operation.
//    pageNum := 0
//    err := client.ListAssetsPages(params,
//        func(page *iotsitewise.ListAssetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTSiteWise) ListAssetsPages(input *ListAssetsInput, fn func(*ListAssetsOutput, bool) bool) error {
	return c.ListAssetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAssetsPagesWithContext same as ListAssetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListAssetsPagesWithContext(ctx aws.Context, input *ListAssetsInput, fn func(*ListAssetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAssetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAssetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAssetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAssociatedAssets = "ListAssociatedAssets"

// ListAssociatedAssetsRequest generates a "aws/request.Request" representing the
// client's request for the ListAssociatedAssets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssociatedAssets for more information on using the ListAssociatedAssets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAssociatedAssetsRequest method.
//    req, resp := client.ListAssociatedAssetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssociatedAssets
func (c *IoTSiteWise) ListAssociatedAssetsRequest(input *ListAssociatedAssetsInput) (req *request.Request, output *ListAssociatedAssetsOutput) {
	op := &request.Operation{
		Name:       opListAssociatedAssets,
		HTTPMethod: "GET",
		HTTPPath:   "/assets/{assetId}/hierarchies",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssociatedAssetsInput{}
	}

	output = &ListAssociatedAssetsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("model.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListAssociatedAssets API operation for AWS IoT SiteWise.
//
// Retrieves a paginated list of the assets associated to a parent asset (assetId)
// by a given hierarchy (hierarchyId).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation ListAssociatedAssets for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssociatedAssets
func (c *IoTSiteWise) ListAssociatedAssets(input *ListAssociatedAssetsInput) (*ListAssociatedAssetsOutput, error) {
	req, out := c.ListAssociatedAssetsRequest(input)
	return out, req.Send()
}

// ListAssociatedAssetsWithContext is the same as ListAssociatedAssets with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssociatedAssets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListAssociatedAssetsWithContext(ctx aws.Context, input *ListAssociatedAssetsInput, opts ...request.Option) (*ListAssociatedAssetsOutput, error) {
	req, out := c.ListAssociatedAssetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAssociatedAssetsPages iterates over the pages of a ListAssociatedAssets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssociatedAssets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAssociatedAssets operation.
//    pageNum := 0
//    err := client.ListAssociatedAssetsPages(params,
//        func(page *iotsitewise.ListAssociatedAssetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTSiteWise) ListAssociatedAssetsPages(input *ListAssociatedAssetsInput, fn func(*ListAssociatedAssetsOutput, bool) bool) error {
	return c.ListAssociatedAssetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAssociatedAssetsPagesWithContext same as ListAssociatedAssetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListAssociatedAssetsPagesWithContext(ctx aws.Context, input *ListAssociatedAssetsInput, fn func(*ListAssociatedAssetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAssociatedAssetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAssociatedAssetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAssociatedAssetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDashboards = "ListDashboards"

// ListDashboardsRequest generates a "aws/request.Request" representing the
// client's request for the ListDashboards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDashboards for more information on using the ListDashboards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDashboardsRequest method.
//    req, resp := client.ListDashboardsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListDashboards
func (c *IoTSiteWise) ListDashboardsRequest(input *ListDashboardsInput) (req *request.Request, output *ListDashboardsOutput) {
	op := &request.Operation{
		Name:       opListDashboards,
		HTTPMethod: "GET",
		HTTPPath:   "/dashboards",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDashboardsInput{}
	}

	output = &ListDashboardsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListDashboards API operation for AWS IoT SiteWise.
//
// Retrieves a paginated list of dashboards for an AWS IoT SiteWise Monitor
// project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation ListDashboards for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListDashboards
func (c *IoTSiteWise) ListDashboards(input *ListDashboardsInput) (*ListDashboardsOutput, error) {
	req, out := c.ListDashboardsRequest(input)
	return out, req.Send()
}

// ListDashboardsWithContext is the same as ListDashboards with the addition of
// the ability to pass a context and additional request options.
//
// See ListDashboards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListDashboardsWithContext(ctx aws.Context, input *ListDashboardsInput, opts ...request.Option) (*ListDashboardsOutput, error) {
	req, out := c.ListDashboardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDashboardsPages iterates over the pages of a ListDashboards operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDashboards method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDashboards operation.
//    pageNum := 0
//    err := client.ListDashboardsPages(params,
//        func(page *iotsitewise.ListDashboardsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTSiteWise) ListDashboardsPages(input *ListDashboardsInput, fn func(*ListDashboardsOutput, bool) bool) error {
	return c.ListDashboardsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDashboardsPagesWithContext same as ListDashboardsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListDashboardsPagesWithContext(ctx aws.Context, input *ListDashboardsInput, fn func(*ListDashboardsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDashboardsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDashboardsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDashboardsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListGateways = "ListGateways"

// ListGatewaysRequest generates a "aws/request.Request" representing the
// client's request for the ListGateways operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGateways for more information on using the ListGateways
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGatewaysRequest method.
//    req, resp := client.ListGatewaysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListGateways
func (c *IoTSiteWise) ListGatewaysRequest(input *ListGatewaysInput) (req *request.Request, output *ListGatewaysOutput) {
	op := &request.Operation{
		Name:       opListGateways,
		HTTPMethod: "GET",
		HTTPPath:   "/20200301/gateways",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGatewaysInput{}
	}

	output = &ListGatewaysOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("edge.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListGateways API operation for AWS IoT SiteWise.
//
// Retrieves a paginated list of gateways.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation ListGateways for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListGateways
func (c *IoTSiteWise) ListGateways(input *ListGatewaysInput) (*ListGatewaysOutput, error) {
	req, out := c.ListGatewaysRequest(input)
	return out, req.Send()
}

// ListGatewaysWithContext is the same as ListGateways with the addition of
// the ability to pass a context and additional request options.
//
// See ListGateways for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListGatewaysWithContext(ctx aws.Context, input *ListGatewaysInput, opts ...request.Option) (*ListGatewaysOutput, error) {
	req, out := c.ListGatewaysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGatewaysPages iterates over the pages of a ListGateways operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGateways method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListGateways operation.
//    pageNum := 0
//    err := client.ListGatewaysPages(params,
//        func(page *iotsitewise.ListGatewaysOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTSiteWise) ListGatewaysPages(input *ListGatewaysInput, fn func(*ListGatewaysOutput, bool) bool) error {
	return c.ListGatewaysPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGatewaysPagesWithContext same as ListGatewaysPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListGatewaysPagesWithContext(ctx aws.Context, input *ListGatewaysInput, fn func(*ListGatewaysOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGatewaysInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGatewaysRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGatewaysOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPortals = "ListPortals"

// ListPortalsRequest generates a "aws/request.Request" representing the
// client's request for the ListPortals operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPortals for more information on using the ListPortals
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPortalsRequest method.
//    req, resp := client.ListPortalsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListPortals
func (c *IoTSiteWise) ListPortalsRequest(input *ListPortalsInput) (req *request.Request, output *ListPortalsOutput) {
	op := &request.Operation{
		Name:       opListPortals,
		HTTPMethod: "GET",
		HTTPPath:   "/portals",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPortalsInput{}
	}

	output = &ListPortalsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListPortals API operation for AWS IoT SiteWise.
//
// Retrieves a paginated list of AWS IoT SiteWise Monitor portals.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation ListPortals for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListPortals
func (c *IoTSiteWise) ListPortals(input *ListPortalsInput) (*ListPortalsOutput, error) {
	req, out := c.ListPortalsRequest(input)
	return out, req.Send()
}

// ListPortalsWithContext is the same as ListPortals with the addition of
// the ability to pass a context and additional request options.
//
// See ListPortals for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListPortalsWithContext(ctx aws.Context, input *ListPortalsInput, opts ...request.Option) (*ListPortalsOutput, error) {
	req, out := c.ListPortalsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPortalsPages iterates over the pages of a ListPortals operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPortals method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPortals operation.
//    pageNum := 0
//    err := client.ListPortalsPages(params,
//        func(page *iotsitewise.ListPortalsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTSiteWise) ListPortalsPages(input *ListPortalsInput, fn func(*ListPortalsOutput, bool) bool) error {
	return c.ListPortalsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPortalsPagesWithContext same as ListPortalsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListPortalsPagesWithContext(ctx aws.Context, input *ListPortalsInput, fn func(*ListPortalsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPortalsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPortalsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPortalsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProjectAssets = "ListProjectAssets"

// ListProjectAssetsRequest generates a "aws/request.Request" representing the
// client's request for the ListProjectAssets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProjectAssets for more information on using the ListProjectAssets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListProjectAssetsRequest method.
//    req, resp := client.ListProjectAssetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListProjectAssets
func (c *IoTSiteWise) ListProjectAssetsRequest(input *ListProjectAssetsInput) (req *request.Request, output *ListProjectAssetsOutput) {
	op := &request.Operation{
		Name:       opListProjectAssets,
		HTTPMethod: "GET",
		HTTPPath:   "/projects/{projectId}/assets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProjectAssetsInput{}
	}

	output = &ListProjectAssetsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListProjectAssets API operation for AWS IoT SiteWise.
//
// Retrieves a paginated list of assets associated with an AWS IoT SiteWise
// Monitor project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation ListProjectAssets for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListProjectAssets
func (c *IoTSiteWise) ListProjectAssets(input *ListProjectAssetsInput) (*ListProjectAssetsOutput, error) {
	req, out := c.ListProjectAssetsRequest(input)
	return out, req.Send()
}

// ListProjectAssetsWithContext is the same as ListProjectAssets with the addition of
// the ability to pass a context and additional request options.
//
// See ListProjectAssets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListProjectAssetsWithContext(ctx aws.Context, input *ListProjectAssetsInput, opts ...request.Option) (*ListProjectAssetsOutput, error) {
	req, out := c.ListProjectAssetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProjectAssetsPages iterates over the pages of a ListProjectAssets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProjectAssets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListProjectAssets operation.
//    pageNum := 0
//    err := client.ListProjectAssetsPages(params,
//        func(page *iotsitewise.ListProjectAssetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTSiteWise) ListProjectAssetsPages(input *ListProjectAssetsInput, fn func(*ListProjectAssetsOutput, bool) bool) error {
	return c.ListProjectAssetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProjectAssetsPagesWithContext same as ListProjectAssetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListProjectAssetsPagesWithContext(ctx aws.Context, input *ListProjectAssetsInput, fn func(*ListProjectAssetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProjectAssetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProjectAssetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProjectAssetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProjects = "ListProjects"

// ListProjectsRequest generates a "aws/request.Request" representing the
// client's request for the ListProjects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProjects for more information on using the ListProjects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListProjectsRequest method.
//    req, resp := client.ListProjectsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListProjects
func (c *IoTSiteWise) ListProjectsRequest(input *ListProjectsInput) (req *request.Request, output *ListProjectsOutput) {
	op := &request.Operation{
		Name:       opListProjects,
		HTTPMethod: "GET",
		HTTPPath:   "/projects",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProjectsInput{}
	}

	output = &ListProjectsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListProjects API operation for AWS IoT SiteWise.
//
// Retrieves a paginated list of projects for an AWS IoT SiteWise Monitor portal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation ListProjects for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListProjects
func (c *IoTSiteWise) ListProjects(input *ListProjectsInput) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	return out, req.Send()
}

// ListProjectsWithContext is the same as ListProjects with the addition of
// the ability to pass a context and additional request options.
//
// See ListProjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListProjectsWithContext(ctx aws.Context, input *ListProjectsInput, opts ...request.Option) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProjectsPages iterates over the pages of a ListProjects operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProjects method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListProjects operation.
//    pageNum := 0
//    err := client.ListProjectsPages(params,
//        func(page *iotsitewise.ListProjectsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTSiteWise) ListProjectsPages(input *ListProjectsInput, fn func(*ListProjectsOutput, bool) bool) error {
	return c.ListProjectsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProjectsPagesWithContext same as ListProjectsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListProjectsPagesWithContext(ctx aws.Context, input *ListProjectsInput, fn func(*ListProjectsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProjectsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProjectsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProjectsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListTagsForResource
func (c *IoTSiteWise) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS IoT SiteWise.
//
// Retrieves the list of tags for an AWS IoT SiteWise resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListTagsForResource
func (c *IoTSiteWise) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutLoggingOptions = "PutLoggingOptions"

// PutLoggingOptionsRequest generates a "aws/request.Request" representing the
// client's request for the PutLoggingOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutLoggingOptions for more information on using the PutLoggingOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutLoggingOptionsRequest method.
//    req, resp := client.PutLoggingOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/PutLoggingOptions
func (c *IoTSiteWise) PutLoggingOptionsRequest(input *PutLoggingOptionsInput) (req *request.Request, output *PutLoggingOptionsOutput) {
	op := &request.Operation{
		Name:       opPutLoggingOptions,
		HTTPMethod: "PUT",
		HTTPPath:   "/logging",
	}

	if input == nil {
		input = &PutLoggingOptionsInput{}
	}

	output = &PutLoggingOptionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("model.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// PutLoggingOptions API operation for AWS IoT SiteWise.
//
// Sets logging options for AWS IoT SiteWise.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation PutLoggingOptions for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/PutLoggingOptions
func (c *IoTSiteWise) PutLoggingOptions(input *PutLoggingOptionsInput) (*PutLoggingOptionsOutput, error) {
	req, out := c.PutLoggingOptionsRequest(input)
	return out, req.Send()
}

// PutLoggingOptionsWithContext is the same as PutLoggingOptions with the addition of
// the ability to pass a context and additional request options.
//
// See PutLoggingOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) PutLoggingOptionsWithContext(ctx aws.Context, input *PutLoggingOptionsInput, opts ...request.Option) (*PutLoggingOptionsOutput, error) {
	req, out := c.PutLoggingOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/TagResource
func (c *IoTSiteWise) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS IoT SiteWise.
//
// Adds tags to an AWS IoT SiteWise resource. If a tag already exists for the
// resource, this operation updates the tag's value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * TooManyTagsException
//   You've reached the limit for the number of tags allowed for a resource. For
//   more information, see Tag naming limits and requirements (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html#tag-conventions)
//   in the AWS General Reference.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/TagResource
func (c *IoTSiteWise) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UntagResource
func (c *IoTSiteWise) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS IoT SiteWise.
//
// Removes a tag from an AWS IoT SiteWise resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UntagResource
func (c *IoTSiteWise) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAccessPolicy = "UpdateAccessPolicy"

// UpdateAccessPolicyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccessPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAccessPolicy for more information on using the UpdateAccessPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAccessPolicyRequest method.
//    req, resp := client.UpdateAccessPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAccessPolicy
func (c *IoTSiteWise) UpdateAccessPolicyRequest(input *UpdateAccessPolicyInput) (req *request.Request, output *UpdateAccessPolicyOutput) {
	op := &request.Operation{
		Name:       opUpdateAccessPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/access-policies/{accessPolicyId}",
	}

	if input == nil {
		input = &UpdateAccessPolicyInput{}
	}

	output = &UpdateAccessPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateAccessPolicy API operation for AWS IoT SiteWise.
//
// Updates an existing access policy that specifies an AWS SSO user or group's
// access to an AWS IoT SiteWise Monitor portal or project resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation UpdateAccessPolicy for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAccessPolicy
func (c *IoTSiteWise) UpdateAccessPolicy(input *UpdateAccessPolicyInput) (*UpdateAccessPolicyOutput, error) {
	req, out := c.UpdateAccessPolicyRequest(input)
	return out, req.Send()
}

// UpdateAccessPolicyWithContext is the same as UpdateAccessPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAccessPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) UpdateAccessPolicyWithContext(ctx aws.Context, input *UpdateAccessPolicyInput, opts ...request.Option) (*UpdateAccessPolicyOutput, error) {
	req, out := c.UpdateAccessPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAsset = "UpdateAsset"

// UpdateAssetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAsset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAsset for more information on using the UpdateAsset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAssetRequest method.
//    req, resp := client.UpdateAssetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAsset
func (c *IoTSiteWise) UpdateAssetRequest(input *UpdateAssetInput) (req *request.Request, output *UpdateAssetOutput) {
	op := &request.Operation{
		Name:       opUpdateAsset,
		HTTPMethod: "PUT",
		HTTPPath:   "/assets/{assetId}",
	}

	if input == nil {
		input = &UpdateAssetInput{}
	}

	output = &UpdateAssetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("model.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateAsset API operation for AWS IoT SiteWise.
//
// Updates an asset's name. For more information, see Updating Assets and Models
// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html)
// in the AWS IoT SiteWise User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation UpdateAsset for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAsset
func (c *IoTSiteWise) UpdateAsset(input *UpdateAssetInput) (*UpdateAssetOutput, error) {
	req, out := c.UpdateAssetRequest(input)
	return out, req.Send()
}

// UpdateAssetWithContext is the same as UpdateAsset with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAsset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) UpdateAssetWithContext(ctx aws.Context, input *UpdateAssetInput, opts ...request.Option) (*UpdateAssetOutput, error) {
	req, out := c.UpdateAssetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAssetModel = "UpdateAssetModel"

// UpdateAssetModelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAssetModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAssetModel for more information on using the UpdateAssetModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAssetModelRequest method.
//    req, resp := client.UpdateAssetModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAssetModel
func (c *IoTSiteWise) UpdateAssetModelRequest(input *UpdateAssetModelInput) (req *request.Request, output *UpdateAssetModelOutput) {
	op := &request.Operation{
		Name:       opUpdateAssetModel,
		HTTPMethod: "PUT",
		HTTPPath:   "/asset-models/{assetModelId}",
	}

	if input == nil {
		input = &UpdateAssetModelInput{}
	}

	output = &UpdateAssetModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("model.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateAssetModel API operation for AWS IoT SiteWise.
//
// Updates an asset model and all of the assets that were created from the model.
// Each asset created from the model inherits the updated asset model's property
// and hierarchy definitions. For more information, see Updating Assets and
// Models (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html)
// in the AWS IoT SiteWise User Guide.
//
// This operation overwrites the existing model with the provided model. To
// avoid deleting your asset model's properties or hierarchies, you must include
// their IDs and definitions in the updated asset model payload. For more information,
// see DescribeAssetModel (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModel.html).
//
// If you remove a property from an asset model or update a property's formula
// expression, AWS IoT SiteWise deletes all previous data for that property.
// If you remove a hierarchy definition from an asset model, AWS IoT SiteWise
// disassociates every asset associated with that hierarchy. You can't change
// the type or data type of an existing property.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation UpdateAssetModel for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * LimitExceededException
//   You've reached the limit for a resource. For example, this can occur if you're
//   trying to associate more than the allowed number of child assets or attempting
//   to create more than the allowed number of properties for an asset model.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAssetModel
func (c *IoTSiteWise) UpdateAssetModel(input *UpdateAssetModelInput) (*UpdateAssetModelOutput, error) {
	req, out := c.UpdateAssetModelRequest(input)
	return out, req.Send()
}

// UpdateAssetModelWithContext is the same as UpdateAssetModel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAssetModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) UpdateAssetModelWithContext(ctx aws.Context, input *UpdateAssetModelInput, opts ...request.Option) (*UpdateAssetModelOutput, error) {
	req, out := c.UpdateAssetModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAssetProperty = "UpdateAssetProperty"

// UpdateAssetPropertyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAssetProperty operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAssetProperty for more information on using the UpdateAssetProperty
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAssetPropertyRequest method.
//    req, resp := client.UpdateAssetPropertyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAssetProperty
func (c *IoTSiteWise) UpdateAssetPropertyRequest(input *UpdateAssetPropertyInput) (req *request.Request, output *UpdateAssetPropertyOutput) {
	op := &request.Operation{
		Name:       opUpdateAssetProperty,
		HTTPMethod: "PUT",
		HTTPPath:   "/assets/{assetId}/properties/{propertyId}",
	}

	if input == nil {
		input = &UpdateAssetPropertyInput{}
	}

	output = &UpdateAssetPropertyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("model.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateAssetProperty API operation for AWS IoT SiteWise.
//
// Updates an asset property's alias and notification state.
//
// This operation overwrites the property's existing alias and notification
// state. To keep your existing property's alias or notification state, you
// must include the existing values in the UpdateAssetProperty request. For
// more information, see DescribeAssetProperty (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetProperty.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation UpdateAssetProperty for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAssetProperty
func (c *IoTSiteWise) UpdateAssetProperty(input *UpdateAssetPropertyInput) (*UpdateAssetPropertyOutput, error) {
	req, out := c.UpdateAssetPropertyRequest(input)
	return out, req.Send()
}

// UpdateAssetPropertyWithContext is the same as UpdateAssetProperty with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAssetProperty for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) UpdateAssetPropertyWithContext(ctx aws.Context, input *UpdateAssetPropertyInput, opts ...request.Option) (*UpdateAssetPropertyOutput, error) {
	req, out := c.UpdateAssetPropertyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDashboard = "UpdateDashboard"

// UpdateDashboardRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDashboard operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDashboard for more information on using the UpdateDashboard
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDashboardRequest method.
//    req, resp := client.UpdateDashboardRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateDashboard
func (c *IoTSiteWise) UpdateDashboardRequest(input *UpdateDashboardInput) (req *request.Request, output *UpdateDashboardOutput) {
	op := &request.Operation{
		Name:       opUpdateDashboard,
		HTTPMethod: "PUT",
		HTTPPath:   "/dashboards/{dashboardId}",
	}

	if input == nil {
		input = &UpdateDashboardInput{}
	}

	output = &UpdateDashboardOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateDashboard API operation for AWS IoT SiteWise.
//
// Updates an AWS IoT SiteWise Monitor dashboard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation UpdateDashboard for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateDashboard
func (c *IoTSiteWise) UpdateDashboard(input *UpdateDashboardInput) (*UpdateDashboardOutput, error) {
	req, out := c.UpdateDashboardRequest(input)
	return out, req.Send()
}

// UpdateDashboardWithContext is the same as UpdateDashboard with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDashboard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) UpdateDashboardWithContext(ctx aws.Context, input *UpdateDashboardInput, opts ...request.Option) (*UpdateDashboardOutput, error) {
	req, out := c.UpdateDashboardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGateway = "UpdateGateway"

// UpdateGatewayRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGateway for more information on using the UpdateGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGatewayRequest method.
//    req, resp := client.UpdateGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateGateway
func (c *IoTSiteWise) UpdateGatewayRequest(input *UpdateGatewayInput) (req *request.Request, output *UpdateGatewayOutput) {
	op := &request.Operation{
		Name:       opUpdateGateway,
		HTTPMethod: "PUT",
		HTTPPath:   "/20200301/gateways/{gatewayId}",
	}

	if input == nil {
		input = &UpdateGatewayInput{}
	}

	output = &UpdateGatewayOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("edge.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateGateway API operation for AWS IoT SiteWise.
//
// Updates a gateway's name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation UpdateGateway for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateGateway
func (c *IoTSiteWise) UpdateGateway(input *UpdateGatewayInput) (*UpdateGatewayOutput, error) {
	req, out := c.UpdateGatewayRequest(input)
	return out, req.Send()
}

// UpdateGatewayWithContext is the same as UpdateGateway with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) UpdateGatewayWithContext(ctx aws.Context, input *UpdateGatewayInput, opts ...request.Option) (*UpdateGatewayOutput, error) {
	req, out := c.UpdateGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGatewayCapabilityConfiguration = "UpdateGatewayCapabilityConfiguration"

// UpdateGatewayCapabilityConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGatewayCapabilityConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGatewayCapabilityConfiguration for more information on using the UpdateGatewayCapabilityConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGatewayCapabilityConfigurationRequest method.
//    req, resp := client.UpdateGatewayCapabilityConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateGatewayCapabilityConfiguration
func (c *IoTSiteWise) UpdateGatewayCapabilityConfigurationRequest(input *UpdateGatewayCapabilityConfigurationInput) (req *request.Request, output *UpdateGatewayCapabilityConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateGatewayCapabilityConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/20200301/gateways/{gatewayId}/capability",
	}

	if input == nil {
		input = &UpdateGatewayCapabilityConfigurationInput{}
	}

	output = &UpdateGatewayCapabilityConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("edge.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateGatewayCapabilityConfiguration API operation for AWS IoT SiteWise.
//
// Updates a gateway capability configuration or defines a new capability configuration.
// Each gateway capability defines data sources for a gateway. A capability
// configuration can contain multiple data source configurations. If you define
// OPC-UA sources for a gateway in the AWS IoT SiteWise console, all of your
// OPC-UA sources are stored in one capability configuration. To list all capability
// configurations for a gateway, use DescribeGateway (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGateway.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation UpdateGatewayCapabilityConfiguration for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * LimitExceededException
//   You've reached the limit for a resource. For example, this can occur if you're
//   trying to associate more than the allowed number of child assets or attempting
//   to create more than the allowed number of properties for an asset model.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateGatewayCapabilityConfiguration
func (c *IoTSiteWise) UpdateGatewayCapabilityConfiguration(input *UpdateGatewayCapabilityConfigurationInput) (*UpdateGatewayCapabilityConfigurationOutput, error) {
	req, out := c.UpdateGatewayCapabilityConfigurationRequest(input)
	return out, req.Send()
}

// UpdateGatewayCapabilityConfigurationWithContext is the same as UpdateGatewayCapabilityConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGatewayCapabilityConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) UpdateGatewayCapabilityConfigurationWithContext(ctx aws.Context, input *UpdateGatewayCapabilityConfigurationInput, opts ...request.Option) (*UpdateGatewayCapabilityConfigurationOutput, error) {
	req, out := c.UpdateGatewayCapabilityConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePortal = "UpdatePortal"

// UpdatePortalRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePortal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePortal for more information on using the UpdatePortal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdatePortalRequest method.
//    req, resp := client.UpdatePortalRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdatePortal
func (c *IoTSiteWise) UpdatePortalRequest(input *UpdatePortalInput) (req *request.Request, output *UpdatePortalOutput) {
	op := &request.Operation{
		Name:       opUpdatePortal,
		HTTPMethod: "PUT",
		HTTPPath:   "/portals/{portalId}",
	}

	if input == nil {
		input = &UpdatePortalInput{}
	}

	output = &UpdatePortalOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdatePortal API operation for AWS IoT SiteWise.
//
// Updates an AWS IoT SiteWise Monitor portal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation UpdatePortal for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
//   * ConflictingOperationException
//   Your request has conflicting operations. This can occur if you're trying
//   to perform more than one operation on the same resource at the same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdatePortal
func (c *IoTSiteWise) UpdatePortal(input *UpdatePortalInput) (*UpdatePortalOutput, error) {
	req, out := c.UpdatePortalRequest(input)
	return out, req.Send()
}

// UpdatePortalWithContext is the same as UpdatePortal with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePortal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) UpdatePortalWithContext(ctx aws.Context, input *UpdatePortalInput, opts ...request.Option) (*UpdatePortalOutput, error) {
	req, out := c.UpdatePortalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProject = "UpdateProject"

// UpdateProjectRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateProject for more information on using the UpdateProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateProjectRequest method.
//    req, resp := client.UpdateProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateProject
func (c *IoTSiteWise) UpdateProjectRequest(input *UpdateProjectInput) (req *request.Request, output *UpdateProjectOutput) {
	op := &request.Operation{
		Name:       opUpdateProject,
		HTTPMethod: "PUT",
		HTTPPath:   "/projects/{projectId}",
	}

	if input == nil {
		input = &UpdateProjectInput{}
	}

	output = &UpdateProjectOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateProject API operation for AWS IoT SiteWise.
//
// Updates an AWS IoT SiteWise Monitor project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT SiteWise's
// API operation UpdateProject for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request isn't valid. This can occur if your request contains malformed
//   JSON or unsupported characters. Check your request and try again.
//
//   * ResourceNotFoundException
//   The requested resource can't be found.
//
//   * InternalFailureException
//   AWS IoT SiteWise can't process your request right now. Try again later.
//
//   * ThrottlingException
//   Your request exceeded a rate limit. For example, you might have exceeded
//   the number of AWS IoT SiteWise assets that can be created per second, the
//   allowed number of messages per second, and so on.
//
//   For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
//   in the AWS IoT SiteWise User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateProject
func (c *IoTSiteWise) UpdateProject(input *UpdateProjectInput) (*UpdateProjectOutput, error) {
	req, out := c.UpdateProjectRequest(input)
	return out, req.Send()
}

// UpdateProjectWithContext is the same as UpdateProject with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSiteWise) UpdateProjectWithContext(ctx aws.Context, input *UpdateProjectInput, opts ...request.Option) (*UpdateProjectOutput, error) {
	req, out := c.UpdateProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Contains an access policy that defines an AWS SSO identity's access to an
// AWS IoT SiteWise Monitor resource.
type AccessPolicySummary struct {
	_ struct{} `type:"structure"`

	// The date the access policy was created, in Unix epoch time.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The ID of the access policy.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The AWS SSO identity (a user or group).
	//
	// Identity is a required field
	Identity *Identity `locationName:"identity" type:"structure" required:"true"`

	// The date the access policy was last updated, in Unix epoch time.
	LastUpdateDate *time.Time `locationName:"lastUpdateDate" type:"timestamp"`

	// The permissions for the access policy. Note that a project ADMINISTRATOR
	// is also known as a project owner.
	//
	// Permission is a required field
	Permission *string `locationName:"permission" type:"string" required:"true" enum:"Permission"`

	// The AWS IoT SiteWise Monitor resource (a portal or project).
	//
	// Resource is a required field
	Resource *Resource `locationName:"resource" type:"structure" required:"true"`
}

// String returns the string representation
func (s AccessPolicySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessPolicySummary) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *AccessPolicySummary) SetCreationDate(v time.Time) *AccessPolicySummary {
	s.CreationDate = &v
	return s
}

// SetId sets the Id field's value.
func (s *AccessPolicySummary) SetId(v string) *AccessPolicySummary {
	s.Id = &v
	return s
}

// SetIdentity sets the Identity field's value.
func (s *AccessPolicySummary) SetIdentity(v *Identity) *AccessPolicySummary {
	s.Identity = v
	return s
}

// SetLastUpdateDate sets the LastUpdateDate field's value.
func (s *AccessPolicySummary) SetLastUpdateDate(v time.Time) *AccessPolicySummary {
	s.LastUpdateDate = &v
	return s
}

// SetPermission sets the Permission field's value.
func (s *AccessPolicySummary) SetPermission(v string) *AccessPolicySummary {
	s.Permission = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *AccessPolicySummary) SetResource(v *Resource) *AccessPolicySummary {
	s.Resource = v
	return s
}

// Contains aggregated asset property values (for example, average, minimum,
// and maximum).
type AggregatedValue struct {
	_ struct{} `type:"structure"`

	// The quality of the aggregated data.
	Quality *string `locationName:"quality" type:"string" enum:"Quality"`

	// The date the aggregating computations occurred, in Unix epoch time.
	//
	// Timestamp is a required field
	Timestamp *time.Time `locationName:"timestamp" type:"timestamp" required:"true"`

	// The value of the aggregates.
	//
	// Value is a required field
	Value *Aggregates `locationName:"value" type:"structure" required:"true"`
}

// String returns the string representation
func (s AggregatedValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AggregatedValue) GoString() string {
	return s.String()
}

// SetQuality sets the Quality field's value.
func (s *AggregatedValue) SetQuality(v string) *AggregatedValue {
	s.Quality = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *AggregatedValue) SetTimestamp(v time.Time) *AggregatedValue {
	s.Timestamp = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AggregatedValue) SetValue(v *Aggregates) *AggregatedValue {
	s.Value = v
	return s
}

// Contains the (pre-calculated) aggregate values for an asset property.
type Aggregates struct {
	_ struct{} `type:"structure"`

	// The average (mean) value of the time series over a time interval window.
	Average *float64 `locationName:"average" type:"double"`

	// The count of data points in the time series over a time interval window.
	Count *float64 `locationName:"count" type:"double"`

	// The maximum value of the time series over a time interval window.
	Maximum *float64 `locationName:"maximum" type:"double"`

	// The minimum value of the time series over a time interval window.
	Minimum *float64 `locationName:"minimum" type:"double"`

	// The standard deviation of the time series over a time interval window.
	StandardDeviation *float64 `locationName:"standardDeviation" type:"double"`

	// The sum of the time series over a time interval window.
	Sum *float64 `locationName:"sum" type:"double"`
}

// String returns the string representation
func (s Aggregates) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Aggregates) GoString() string {
	return s.String()
}

// SetAverage sets the Average field's value.
func (s *Aggregates) SetAverage(v float64) *Aggregates {
	s.Average = &v
	return s
}

// SetCount sets the Count field's value.
func (s *Aggregates) SetCount(v float64) *Aggregates {
	s.Count = &v
	return s
}

// SetMaximum sets the Maximum field's value.
func (s *Aggregates) SetMaximum(v float64) *Aggregates {
	s.Maximum = &v
	return s
}

// SetMinimum sets the Minimum field's value.
func (s *Aggregates) SetMinimum(v float64) *Aggregates {
	s.Minimum = &v
	return s
}

// SetStandardDeviation sets the StandardDeviation field's value.
func (s *Aggregates) SetStandardDeviation(v float64) *Aggregates {
	s.StandardDeviation = &v
	return s
}

// SetSum sets the Sum field's value.
func (s *Aggregates) SetSum(v float64) *Aggregates {
	s.Sum = &v
	return s
}

// Contains error details for the requested associate project asset action.
type AssetErrorDetails struct {
	_ struct{} `type:"structure"`

	// The ID of the asset.
	//
	// AssetId is a required field
	AssetId *string `locationName:"assetId" min:"36" type:"string" required:"true"`

	// The error code.
	//
	// Code is a required field
	Code *string `locationName:"code" type:"string" required:"true" enum:"AssetErrorCode"`

	// The error message.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation
func (s AssetErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssetErrorDetails) GoString() string {
	return s.String()
}

// SetAssetId sets the AssetId field's value.
func (s *AssetErrorDetails) SetAssetId(v string) *AssetErrorDetails {
	s.AssetId = &v
	return s
}

// SetCode sets the Code field's value.
func (s *AssetErrorDetails) SetCode(v string) *AssetErrorDetails {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *AssetErrorDetails) SetMessage(v string) *AssetErrorDetails {
	s.Message = &v
	return s
}

// Describes an asset hierarchy that contains a hierarchy's name and ID.
type AssetHierarchy struct {
	_ struct{} `type:"structure"`

	// The ID of the hierarchy. This ID is a hierarchyId.
	Id *string `locationName:"id" min:"36" type:"string"`

	// The hierarchy name provided in the CreateAssetModel (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html)
	// or UpdateAssetModel (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html)
	// API.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssetHierarchy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssetHierarchy) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *AssetHierarchy) SetId(v string) *AssetHierarchy {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssetHierarchy) SetName(v string) *AssetHierarchy {
	s.Name = &v
	return s
}

// Describes an asset hierarchy that contains a hierarchy's name, ID, and child
// asset model ID that specifies the type of asset that can be in this hierarchy.
type AssetModelHierarchy struct {
	_ struct{} `type:"structure"`

	// The ID of the asset model. All assets in this hierarchy must be instances
	// of the childAssetModelId asset model.
	//
	// ChildAssetModelId is a required field
	ChildAssetModelId *string `locationName:"childAssetModelId" min:"36" type:"string" required:"true"`

	// The ID of the asset model hierarchy. This ID is a hierarchyId.
	Id *string `locationName:"id" min:"36" type:"string"`

	// The name of the asset model hierarchy that you specify by using the CreateAssetModel
	// (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html)
	// or UpdateAssetModel (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html)
	// API.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssetModelHierarchy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssetModelHierarchy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetModelHierarchy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetModelHierarchy"}
	if s.ChildAssetModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChildAssetModelId"))
	}
	if s.ChildAssetModelId != nil && len(*s.ChildAssetModelId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ChildAssetModelId", 36))
	}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 36))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChildAssetModelId sets the ChildAssetModelId field's value.
func (s *AssetModelHierarchy) SetChildAssetModelId(v string) *AssetModelHierarchy {
	s.ChildAssetModelId = &v
	return s
}

// SetId sets the Id field's value.
func (s *AssetModelHierarchy) SetId(v string) *AssetModelHierarchy {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssetModelHierarchy) SetName(v string) *AssetModelHierarchy {
	s.Name = &v
	return s
}

// Contains an asset model hierarchy used in asset model creation. An asset
// model hierarchy determines the kind (or type) of asset that can belong to
// a hierarchy.
type AssetModelHierarchyDefinition struct {
	_ struct{} `type:"structure"`

	// The ID of an asset model for this hierarchy.
	//
	// ChildAssetModelId is a required field
	ChildAssetModelId *string `locationName:"childAssetModelId" min:"36" type:"string" required:"true"`

	// The name of the asset model hierarchy definition (as specified in CreateAssetModel
	// (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModel.html)
	// or UpdateAssetModel (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetModel.html)).
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssetModelHierarchyDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssetModelHierarchyDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetModelHierarchyDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetModelHierarchyDefinition"}
	if s.ChildAssetModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChildAssetModelId"))
	}
	if s.ChildAssetModelId != nil && len(*s.ChildAssetModelId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ChildAssetModelId", 36))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChildAssetModelId sets the ChildAssetModelId field's value.
func (s *AssetModelHierarchyDefinition) SetChildAssetModelId(v string) *AssetModelHierarchyDefinition {
	s.ChildAssetModelId = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssetModelHierarchyDefinition) SetName(v string) *AssetModelHierarchyDefinition {
	s.Name = &v
	return s
}

// Contains information about an asset model property.
type AssetModelProperty struct {
	_ struct{} `type:"structure"`

	// The data type of the asset model property.
	//
	// DataType is a required field
	DataType *string `locationName:"dataType" type:"string" required:"true" enum:"PropertyDataType"`

	// The ID of the asset model property.
	Id *string `locationName:"id" min:"36" type:"string"`

	// The name of the asset model property.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The property type (see PropertyType).
	//
	// Type is a required field
	Type *PropertyType `locationName:"type" type:"structure" required:"true"`

	// The unit of the asset model property, such as Newtons or RPM.
	Unit *string `locationName:"unit" min:"1" type:"string"`
}

// String returns the string representation
func (s AssetModelProperty) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssetModelProperty) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetModelProperty) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetModelProperty"}
	if s.DataType == nil {
		invalidParams.Add(request.NewErrParamRequired("DataType"))
	}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 36))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Unit != nil && len(*s.Unit) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Unit", 1))
	}
	if s.Type != nil {
		if err := s.Type.Validate(); err != nil {
			invalidParams.AddNested("Type", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataType sets the DataType field's value.
func (s *AssetModelProperty) SetDataType(v string) *AssetModelProperty {
	s.DataType = &v
	return s
}

// SetId sets the Id field's value.
func (s *AssetModelProperty) SetId(v string) *AssetModelProperty {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssetModelProperty) SetName(v string) *AssetModelProperty {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *AssetModelProperty) SetType(v *PropertyType) *AssetModelProperty {
	s.Type = v
	return s
}

// SetUnit sets the Unit field's value.
func (s *AssetModelProperty) SetUnit(v string) *AssetModelProperty {
	s.Unit = &v
	return s
}

// Contains an asset model property definition. This property definition is
// applied to all assets created from the asset model.
type AssetModelPropertyDefinition struct {
	_ struct{} `type:"structure"`

	// The data type of the property definition.
	//
	// DataType is a required field
	DataType *string `locationName:"dataType" type:"string" required:"true" enum:"PropertyDataType"`

	// The name of the property definition.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The property definition type (see PropertyType). You can only specify one
	// type in a property definition.
	//
	// Type is a required field
	Type *PropertyType `locationName:"type" type:"structure" required:"true"`

	// The unit of the property definition, such as Newtons or RPM.
	Unit *string `locationName:"unit" min:"1" type:"string"`
}

// String returns the string representation
func (s AssetModelPropertyDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssetModelPropertyDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetModelPropertyDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetModelPropertyDefinition"}
	if s.DataType == nil {
		invalidParams.Add(request.NewErrParamRequired("DataType"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Unit != nil && len(*s.Unit) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Unit", 1))
	}
	if s.Type != nil {
		if err := s.Type.Validate(); err != nil {
			invalidParams.AddNested("Type", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataType sets the DataType field's value.
func (s *AssetModelPropertyDefinition) SetDataType(v string) *AssetModelPropertyDefinition {
	s.DataType = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssetModelPropertyDefinition) SetName(v string) *AssetModelPropertyDefinition {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *AssetModelPropertyDefinition) SetType(v *PropertyType) *AssetModelPropertyDefinition {
	s.Type = v
	return s
}

// SetUnit sets the Unit field's value.
func (s *AssetModelPropertyDefinition) SetUnit(v string) *AssetModelPropertyDefinition {
	s.Unit = &v
	return s
}

// Contains current status information for an asset model. For more information,
// see Asset and Model States (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-and-model-states.html)
// in the AWS IoT SiteWise User Guide.
type AssetModelStatus struct {
	_ struct{} `type:"structure"`

	// Contains associated error information, if any.
	Error *ErrorDetails `locationName:"error" type:"structure"`

	// The current state of the asset model.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"AssetModelState"`
}

// String returns the string representation
func (s AssetModelStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssetModelStatus) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *AssetModelStatus) SetError(v *ErrorDetails) *AssetModelStatus {
	s.Error = v
	return s
}

// SetState sets the State field's value.
func (s *AssetModelStatus) SetState(v string) *AssetModelStatus {
	s.State = &v
	return s
}

// Contains a summary of an asset model.
type AssetModelSummary struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the asset model, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The date the asset model was created, in Unix epoch time.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" required:"true"`

	// The asset model description.
	//
	// Description is a required field
	Description *string `locationName:"description" min:"1" type:"string" required:"true"`

	// The ID of the asset model (used with AWS IoT SiteWise APIs).
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The date the asset model was last updated, in Unix epoch time.
	//
	// LastUpdateDate is a required field
	LastUpdateDate *time.Time `locationName:"lastUpdateDate" type:"timestamp" required:"true"`

	// The name of the asset model.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The current status of the asset model.
	//
	// Status is a required field
	Status *AssetModelStatus `locationName:"status" type:"structure" required:"true"`
}

// String returns the string representation
func (s AssetModelSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssetModelSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AssetModelSummary) SetArn(v string) *AssetModelSummary {
	s.Arn = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *AssetModelSummary) SetCreationDate(v time.Time) *AssetModelSummary {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AssetModelSummary) SetDescription(v string) *AssetModelSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *AssetModelSummary) SetId(v string) *AssetModelSummary {
	s.Id = &v
	return s
}

// SetLastUpdateDate sets the LastUpdateDate field's value.
func (s *AssetModelSummary) SetLastUpdateDate(v time.Time) *AssetModelSummary {
	s.LastUpdateDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssetModelSummary) SetName(v string) *AssetModelSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AssetModelSummary) SetStatus(v *AssetModelStatus) *AssetModelSummary {
	s.Status = v
	return s
}

// Contains asset property information.
type AssetProperty struct {
	_ struct{} `type:"structure"`

	// The property alias that identifies the property, such as an OPC-UA server
	// data stream path (for example, /company/windfarm/3/turbine/7/temperature).
	// For more information, see Mapping Industrial Data Streams to Asset Properties
	// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html)
	// in the AWS IoT SiteWise User Guide.
	Alias *string `locationName:"alias" min:"1" type:"string"`

	// The data type of the asset property.
	//
	// DataType is a required field
	DataType *string `locationName:"dataType" type:"string" required:"true" enum:"PropertyDataType"`

	// The ID of the asset property.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The name of the property.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The asset property's notification topic and state. For more information,
	// see UpdateAssetProperty (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html)
	Notification *PropertyNotification `locationName:"notification" type:"structure"`

	// The unit (such as Newtons or RPM) of the asset property.
	Unit *string `locationName:"unit" min:"1" type:"string"`
}

// String returns the string representation
func (s AssetProperty) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssetProperty) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *AssetProperty) SetAlias(v string) *AssetProperty {
	s.Alias = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *AssetProperty) SetDataType(v string) *AssetProperty {
	s.DataType = &v
	return s
}

// SetId sets the Id field's value.
func (s *AssetProperty) SetId(v string) *AssetProperty {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssetProperty) SetName(v string) *AssetProperty {
	s.Name = &v
	return s
}

// SetNotification sets the Notification field's value.
func (s *AssetProperty) SetNotification(v *PropertyNotification) *AssetProperty {
	s.Notification = v
	return s
}

// SetUnit sets the Unit field's value.
func (s *AssetProperty) SetUnit(v string) *AssetProperty {
	s.Unit = &v
	return s
}

// Contains asset property value information.
type AssetPropertyValue struct {
	_ struct{} `type:"structure"`

	// The quality of the asset property value.
	Quality *string `locationName:"quality" type:"string" enum:"Quality"`

	// The timestamp of the asset property value.
	//
	// Timestamp is a required field
	Timestamp *TimeInNanos `locationName:"timestamp" type:"structure" required:"true"`

	// The value of the asset property (see Variant).
	//
	// Value is a required field
	Value *Variant `locationName:"value" type:"structure" required:"true"`
}

// String returns the string representation
func (s AssetPropertyValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssetPropertyValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetPropertyValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetPropertyValue"}
	if s.Timestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("Timestamp"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Timestamp != nil {
		if err := s.Timestamp.Validate(); err != nil {
			invalidParams.AddNested("Timestamp", err.(request.ErrInvalidParams))
		}
	}
	if s.Value != nil {
		if err := s.Value.Validate(); err != nil {
			invalidParams.AddNested("Value", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQuality sets the Quality field's value.
func (s *AssetPropertyValue) SetQuality(v string) *AssetPropertyValue {
	s.Quality = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *AssetPropertyValue) SetTimestamp(v *TimeInNanos) *AssetPropertyValue {
	s.Timestamp = v
	return s
}

// SetValue sets the Value field's value.
func (s *AssetPropertyValue) SetValue(v *Variant) *AssetPropertyValue {
	s.Value = v
	return s
}

// Contains information about the current status of an asset. For more information,
// see Asset and Model States (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-and-model-states.html)
// in the AWS IoT SiteWise User Guide.
type AssetStatus struct {
	_ struct{} `type:"structure"`

	// Contains associated error information, if any.
	Error *ErrorDetails `locationName:"error" type:"structure"`

	// The current status of the asset.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"AssetState"`
}

// String returns the string representation
func (s AssetStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssetStatus) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *AssetStatus) SetError(v *ErrorDetails) *AssetStatus {
	s.Error = v
	return s
}

// SetState sets the State field's value.
func (s *AssetStatus) SetState(v string) *AssetStatus {
	s.State = &v
	return s
}

// Contains a summary of an asset.
type AssetSummary struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the asset, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The ID of the asset model used to create this asset.
	//
	// AssetModelId is a required field
	AssetModelId *string `locationName:"assetModelId" min:"36" type:"string" required:"true"`

	// The date the asset was created, in Unix epoch time.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" required:"true"`

	// A list of asset hierarchies that each contain a hierarchyId. A hierarchy
	// specifies allowed parent/child asset relationships.
	//
	// Hierarchies is a required field
	Hierarchies []*AssetHierarchy `locationName:"hierarchies" type:"list" required:"true"`

	// The ID of the asset.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The date the asset was last updated, in Unix epoch time.
	//
	// LastUpdateDate is a required field
	LastUpdateDate *time.Time `locationName:"lastUpdateDate" type:"timestamp" required:"true"`

	// The name of the asset.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The current status of the asset.
	//
	// Status is a required field
	Status *AssetStatus `locationName:"status" type:"structure" required:"true"`
}

// String returns the string representation
func (s AssetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssetSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AssetSummary) SetArn(v string) *AssetSummary {
	s.Arn = &v
	return s
}

// SetAssetModelId sets the AssetModelId field's value.
func (s *AssetSummary) SetAssetModelId(v string) *AssetSummary {
	s.AssetModelId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *AssetSummary) SetCreationDate(v time.Time) *AssetSummary {
	s.CreationDate = &v
	return s
}

// SetHierarchies sets the Hierarchies field's value.
func (s *AssetSummary) SetHierarchies(v []*AssetHierarchy) *AssetSummary {
	s.Hierarchies = v
	return s
}

// SetId sets the Id field's value.
func (s *AssetSummary) SetId(v string) *AssetSummary {
	s.Id = &v
	return s
}

// SetLastUpdateDate sets the LastUpdateDate field's value.
func (s *AssetSummary) SetLastUpdateDate(v time.Time) *AssetSummary {
	s.LastUpdateDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssetSummary) SetName(v string) *AssetSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AssetSummary) SetStatus(v *AssetStatus) *AssetSummary {
	s.Status = v
	return s
}

type AssociateAssetsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the parent asset.
	//
	// AssetId is a required field
	AssetId *string `location:"uri" locationName:"assetId" min:"36" type:"string" required:"true"`

	// The ID of the child asset to be associated.
	//
	// ChildAssetId is a required field
	ChildAssetId *string `locationName:"childAssetId" min:"36" type:"string" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The ID of a hierarchy in the parent asset's model. Hierarchies allow different
	// groupings of assets to be formed that all come from the same asset model.
	// For more information, see Asset Hierarchies (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html)
	// in the AWS IoT SiteWise User Guide.
	//
	// HierarchyId is a required field
	HierarchyId *string `locationName:"hierarchyId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateAssetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateAssetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateAssetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateAssetsInput"}
	if s.AssetId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetId"))
	}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.ChildAssetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChildAssetId"))
	}
	if s.ChildAssetId != nil && len(*s.ChildAssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ChildAssetId", 36))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.HierarchyId == nil {
		invalidParams.Add(request.NewErrParamRequired("HierarchyId"))
	}
	if s.HierarchyId != nil && len(*s.HierarchyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("HierarchyId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *AssociateAssetsInput) SetAssetId(v string) *AssociateAssetsInput {
	s.AssetId = &v
	return s
}

// SetChildAssetId sets the ChildAssetId field's value.
func (s *AssociateAssetsInput) SetChildAssetId(v string) *AssociateAssetsInput {
	s.ChildAssetId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *AssociateAssetsInput) SetClientToken(v string) *AssociateAssetsInput {
	s.ClientToken = &v
	return s
}

// SetHierarchyId sets the HierarchyId field's value.
func (s *AssociateAssetsInput) SetHierarchyId(v string) *AssociateAssetsInput {
	s.HierarchyId = &v
	return s
}

type AssociateAssetsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateAssetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateAssetsOutput) GoString() string {
	return s.String()
}

// Contains a summary of an associated asset.
type AssociatedAssetsSummary struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the asset, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The ID of the asset model used to create the asset.
	//
	// AssetModelId is a required field
	AssetModelId *string `locationName:"assetModelId" min:"36" type:"string" required:"true"`

	// The date the asset was created, in Unix epoch time.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" required:"true"`

	// A list of asset hierarchies that each contain a hierarchyId. A hierarchy
	// specifies allowed parent/child asset relationships.
	//
	// Hierarchies is a required field
	Hierarchies []*AssetHierarchy `locationName:"hierarchies" type:"list" required:"true"`

	// The ID of the asset.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The date the asset was last updated, in Unix epoch time.
	//
	// LastUpdateDate is a required field
	LastUpdateDate *time.Time `locationName:"lastUpdateDate" type:"timestamp" required:"true"`

	// The name of the asset.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The current status of the asset.
	//
	// Status is a required field
	Status *AssetStatus `locationName:"status" type:"structure" required:"true"`
}

// String returns the string representation
func (s AssociatedAssetsSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociatedAssetsSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AssociatedAssetsSummary) SetArn(v string) *AssociatedAssetsSummary {
	s.Arn = &v
	return s
}

// SetAssetModelId sets the AssetModelId field's value.
func (s *AssociatedAssetsSummary) SetAssetModelId(v string) *AssociatedAssetsSummary {
	s.AssetModelId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *AssociatedAssetsSummary) SetCreationDate(v time.Time) *AssociatedAssetsSummary {
	s.CreationDate = &v
	return s
}

// SetHierarchies sets the Hierarchies field's value.
func (s *AssociatedAssetsSummary) SetHierarchies(v []*AssetHierarchy) *AssociatedAssetsSummary {
	s.Hierarchies = v
	return s
}

// SetId sets the Id field's value.
func (s *AssociatedAssetsSummary) SetId(v string) *AssociatedAssetsSummary {
	s.Id = &v
	return s
}

// SetLastUpdateDate sets the LastUpdateDate field's value.
func (s *AssociatedAssetsSummary) SetLastUpdateDate(v time.Time) *AssociatedAssetsSummary {
	s.LastUpdateDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssociatedAssetsSummary) SetName(v string) *AssociatedAssetsSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AssociatedAssetsSummary) SetStatus(v *AssetStatus) *AssociatedAssetsSummary {
	s.Status = v
	return s
}

// Contains an asset attribute property. For more information, see Attributes
// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#attributes)
// in the AWS IoT SiteWise User Guide.
type Attribute struct {
	_ struct{} `type:"structure"`

	// The default value of the asset model property attribute. All assets that
	// you create from the asset model contain this attribute value. You can update
	// an attribute's value after you create an asset. For more information, see
	// Updating Attribute Values (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-attribute-values.html)
	// in the AWS IoT SiteWise User Guide.
	DefaultValue *string `locationName:"defaultValue" min:"1" type:"string"`
}

// String returns the string representation
func (s Attribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Attribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Attribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Attribute"}
	if s.DefaultValue != nil && len(*s.DefaultValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DefaultValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *Attribute) SetDefaultValue(v string) *Attribute {
	s.DefaultValue = &v
	return s
}

type BatchAssociateProjectAssetsInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the assets to be associated to the project.
	//
	// AssetIds is a required field
	AssetIds []*string `locationName:"assetIds" min:"1" type:"list" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The ID of the project to which to associate the assets.
	//
	// ProjectId is a required field
	ProjectId *string `location:"uri" locationName:"projectId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s BatchAssociateProjectAssetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchAssociateProjectAssetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchAssociateProjectAssetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchAssociateProjectAssetsInput"}
	if s.AssetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetIds"))
	}
	if s.AssetIds != nil && len(s.AssetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssetIds", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.ProjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetIds sets the AssetIds field's value.
func (s *BatchAssociateProjectAssetsInput) SetAssetIds(v []*string) *BatchAssociateProjectAssetsInput {
	s.AssetIds = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *BatchAssociateProjectAssetsInput) SetClientToken(v string) *BatchAssociateProjectAssetsInput {
	s.ClientToken = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *BatchAssociateProjectAssetsInput) SetProjectId(v string) *BatchAssociateProjectAssetsInput {
	s.ProjectId = &v
	return s
}

type BatchAssociateProjectAssetsOutput struct {
	_ struct{} `type:"structure"`

	// A list of associated error information, if any.
	Errors []*AssetErrorDetails `locationName:"errors" type:"list"`
}

// String returns the string representation
func (s BatchAssociateProjectAssetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchAssociateProjectAssetsOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchAssociateProjectAssetsOutput) SetErrors(v []*AssetErrorDetails) *BatchAssociateProjectAssetsOutput {
	s.Errors = v
	return s
}

type BatchDisassociateProjectAssetsInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the assets to be disassociated from the project.
	//
	// AssetIds is a required field
	AssetIds []*string `locationName:"assetIds" min:"1" type:"list" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The ID of the project from which to disassociate the assets.
	//
	// ProjectId is a required field
	ProjectId *string `location:"uri" locationName:"projectId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s BatchDisassociateProjectAssetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDisassociateProjectAssetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDisassociateProjectAssetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDisassociateProjectAssetsInput"}
	if s.AssetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetIds"))
	}
	if s.AssetIds != nil && len(s.AssetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssetIds", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.ProjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetIds sets the AssetIds field's value.
func (s *BatchDisassociateProjectAssetsInput) SetAssetIds(v []*string) *BatchDisassociateProjectAssetsInput {
	s.AssetIds = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *BatchDisassociateProjectAssetsInput) SetClientToken(v string) *BatchDisassociateProjectAssetsInput {
	s.ClientToken = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *BatchDisassociateProjectAssetsInput) SetProjectId(v string) *BatchDisassociateProjectAssetsInput {
	s.ProjectId = &v
	return s
}

type BatchDisassociateProjectAssetsOutput struct {
	_ struct{} `type:"structure"`

	// A list of associated error information, if any.
	Errors []*AssetErrorDetails `locationName:"errors" type:"list"`
}

// String returns the string representation
func (s BatchDisassociateProjectAssetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDisassociateProjectAssetsOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchDisassociateProjectAssetsOutput) SetErrors(v []*AssetErrorDetails) *BatchDisassociateProjectAssetsOutput {
	s.Errors = v
	return s
}

// Contains error information from updating a batch of asset property values.
type BatchPutAssetPropertyError struct {
	_ struct{} `type:"structure"`

	// The error code.
	//
	// ErrorCode is a required field
	ErrorCode *string `locationName:"errorCode" type:"string" required:"true" enum:"BatchPutAssetPropertyValueErrorCode"`

	// The associated error message.
	//
	// ErrorMessage is a required field
	ErrorMessage *string `locationName:"errorMessage" type:"string" required:"true"`

	// A list of timestamps for each error, if any.
	//
	// Timestamps is a required field
	Timestamps []*TimeInNanos `locationName:"timestamps" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchPutAssetPropertyError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchPutAssetPropertyError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchPutAssetPropertyError) SetErrorCode(v string) *BatchPutAssetPropertyError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchPutAssetPropertyError) SetErrorMessage(v string) *BatchPutAssetPropertyError {
	s.ErrorMessage = &v
	return s
}

// SetTimestamps sets the Timestamps field's value.
func (s *BatchPutAssetPropertyError) SetTimestamps(v []*TimeInNanos) *BatchPutAssetPropertyError {
	s.Timestamps = v
	return s
}

// Contains error information for asset property value entries that are associated
// with the BatchPutAssetPropertyValue (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchPutAssetPropertyValue.html)
// API.
type BatchPutAssetPropertyErrorEntry struct {
	_ struct{} `type:"structure"`

	// The ID of the failed entry.
	//
	// EntryId is a required field
	EntryId *string `locationName:"entryId" min:"1" type:"string" required:"true"`

	// The list of update property value errors.
	//
	// Errors is a required field
	Errors []*BatchPutAssetPropertyError `locationName:"errors" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchPutAssetPropertyErrorEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchPutAssetPropertyErrorEntry) GoString() string {
	return s.String()
}

// SetEntryId sets the EntryId field's value.
func (s *BatchPutAssetPropertyErrorEntry) SetEntryId(v string) *BatchPutAssetPropertyErrorEntry {
	s.EntryId = &v
	return s
}

// SetErrors sets the Errors field's value.
func (s *BatchPutAssetPropertyErrorEntry) SetErrors(v []*BatchPutAssetPropertyError) *BatchPutAssetPropertyErrorEntry {
	s.Errors = v
	return s
}

type BatchPutAssetPropertyValueInput struct {
	_ struct{} `type:"structure"`

	// The list of asset property value entries for the batch put request. You can
	// specify up to 10 entries per request.
	//
	// Entries is a required field
	Entries []*PutAssetPropertyValueEntry `locationName:"entries" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchPutAssetPropertyValueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchPutAssetPropertyValueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchPutAssetPropertyValueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchPutAssetPropertyValueInput"}
	if s.Entries == nil {
		invalidParams.Add(request.NewErrParamRequired("Entries"))
	}
	if s.Entries != nil {
		for i, v := range s.Entries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Entries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntries sets the Entries field's value.
func (s *BatchPutAssetPropertyValueInput) SetEntries(v []*PutAssetPropertyValueEntry) *BatchPutAssetPropertyValueInput {
	s.Entries = v
	return s
}

type BatchPutAssetPropertyValueOutput struct {
	_ struct{} `type:"structure"`

	// A list of the errors (if any) associated with the batch put request. Each
	// error entry contains the entryId of the entry that failed.
	//
	// ErrorEntries is a required field
	ErrorEntries []*BatchPutAssetPropertyErrorEntry `locationName:"errorEntries" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchPutAssetPropertyValueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchPutAssetPropertyValueOutput) GoString() string {
	return s.String()
}

// SetErrorEntries sets the ErrorEntries field's value.
func (s *BatchPutAssetPropertyValueOutput) SetErrorEntries(v []*BatchPutAssetPropertyErrorEntry) *BatchPutAssetPropertyValueOutput {
	s.ErrorEntries = v
	return s
}

// Your request has conflicting operations. This can occur if you're trying
// to perform more than one operation on the same resource at the same time.
type ConflictingOperationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ARN of the resource that conflicts with this operation.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`

	// The ID of the resource that conflicts with this operation.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`
}

// String returns the string representation
func (s ConflictingOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictingOperationException) GoString() string {
	return s.String()
}

func newErrorConflictingOperationException(v protocol.ResponseMetadata) error {
	return &ConflictingOperationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictingOperationException) Code() string {
	return "ConflictingOperationException"
}

// Message returns the exception's message.
func (s *ConflictingOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictingOperationException) OrigErr() error {
	return nil
}

func (s *ConflictingOperationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictingOperationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictingOperationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateAccessPolicyInput struct {
	_ struct{} `type:"structure"`

	// The identity for this access policy. Choose either a user or a group but
	// not both.
	//
	// AccessPolicyIdentity is a required field
	AccessPolicyIdentity *Identity `locationName:"accessPolicyIdentity" type:"structure" required:"true"`

	// The permission level for this access policy. Note that a project ADMINISTRATOR
	// is also known as a project owner.
	//
	// AccessPolicyPermission is a required field
	AccessPolicyPermission *string `locationName:"accessPolicyPermission" type:"string" required:"true" enum:"Permission"`

	// The AWS IoT SiteWise Monitor resource for this access policy. Choose either
	// portal or project but not both.
	//
	// AccessPolicyResource is a required field
	AccessPolicyResource *Resource `locationName:"accessPolicyResource" type:"structure" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// A list of key-value pairs that contain metadata for the access policy. For
	// more information, see Tagging your AWS IoT SiteWise resources (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html)
	// in the AWS IoT SiteWise User Guide.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s CreateAccessPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAccessPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAccessPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAccessPolicyInput"}
	if s.AccessPolicyIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessPolicyIdentity"))
	}
	if s.AccessPolicyPermission == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessPolicyPermission"))
	}
	if s.AccessPolicyResource == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessPolicyResource"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.AccessPolicyIdentity != nil {
		if err := s.AccessPolicyIdentity.Validate(); err != nil {
			invalidParams.AddNested("AccessPolicyIdentity", err.(request.ErrInvalidParams))
		}
	}
	if s.AccessPolicyResource != nil {
		if err := s.AccessPolicyResource.Validate(); err != nil {
			invalidParams.AddNested("AccessPolicyResource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessPolicyIdentity sets the AccessPolicyIdentity field's value.
func (s *CreateAccessPolicyInput) SetAccessPolicyIdentity(v *Identity) *CreateAccessPolicyInput {
	s.AccessPolicyIdentity = v
	return s
}

// SetAccessPolicyPermission sets the AccessPolicyPermission field's value.
func (s *CreateAccessPolicyInput) SetAccessPolicyPermission(v string) *CreateAccessPolicyInput {
	s.AccessPolicyPermission = &v
	return s
}

// SetAccessPolicyResource sets the AccessPolicyResource field's value.
func (s *CreateAccessPolicyInput) SetAccessPolicyResource(v *Resource) *CreateAccessPolicyInput {
	s.AccessPolicyResource = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAccessPolicyInput) SetClientToken(v string) *CreateAccessPolicyInput {
	s.ClientToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAccessPolicyInput) SetTags(v map[string]*string) *CreateAccessPolicyInput {
	s.Tags = v
	return s
}

type CreateAccessPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the access policy, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:access-policy/${AccessPolicyId}
	//
	// AccessPolicyArn is a required field
	AccessPolicyArn *string `locationName:"accessPolicyArn" min:"1" type:"string" required:"true"`

	// The ID of the access policy.
	//
	// AccessPolicyId is a required field
	AccessPolicyId *string `locationName:"accessPolicyId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAccessPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAccessPolicyOutput) GoString() string {
	return s.String()
}

// SetAccessPolicyArn sets the AccessPolicyArn field's value.
func (s *CreateAccessPolicyOutput) SetAccessPolicyArn(v string) *CreateAccessPolicyOutput {
	s.AccessPolicyArn = &v
	return s
}

// SetAccessPolicyId sets the AccessPolicyId field's value.
func (s *CreateAccessPolicyOutput) SetAccessPolicyId(v string) *CreateAccessPolicyOutput {
	s.AccessPolicyId = &v
	return s
}

type CreateAssetInput struct {
	_ struct{} `type:"structure"`

	// The ID of the asset model from which to create the asset.
	//
	// AssetModelId is a required field
	AssetModelId *string `locationName:"assetModelId" min:"36" type:"string" required:"true"`

	// A unique, friendly name for the asset.
	//
	// AssetName is a required field
	AssetName *string `locationName:"assetName" min:"1" type:"string" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// A list of key-value pairs that contain metadata for the asset. For more information,
	// see Tagging your AWS IoT SiteWise resources (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html)
	// in the AWS IoT SiteWise User Guide.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s CreateAssetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAssetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAssetInput"}
	if s.AssetModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetModelId"))
	}
	if s.AssetModelId != nil && len(*s.AssetModelId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetModelId", 36))
	}
	if s.AssetName == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetName"))
	}
	if s.AssetName != nil && len(*s.AssetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssetName", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetModelId sets the AssetModelId field's value.
func (s *CreateAssetInput) SetAssetModelId(v string) *CreateAssetInput {
	s.AssetModelId = &v
	return s
}

// SetAssetName sets the AssetName field's value.
func (s *CreateAssetInput) SetAssetName(v string) *CreateAssetInput {
	s.AssetName = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAssetInput) SetClientToken(v string) *CreateAssetInput {
	s.ClientToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAssetInput) SetTags(v map[string]*string) *CreateAssetInput {
	s.Tags = v
	return s
}

type CreateAssetModelInput struct {
	_ struct{} `type:"structure"`

	// A description for the asset model.
	AssetModelDescription *string `locationName:"assetModelDescription" min:"1" type:"string"`

	// The hierarchy definitions of the asset model. Each hierarchy specifies an
	// asset model whose assets can be children of any other assets created from
	// this asset model. For more information, see Asset Hierarchies (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html)
	// in the AWS IoT SiteWise User Guide.
	//
	// You can specify up to 10 hierarchies per asset model. For more information,
	// see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
	// in the AWS IoT SiteWise User Guide.
	AssetModelHierarchies []*AssetModelHierarchyDefinition `locationName:"assetModelHierarchies" type:"list"`

	// A unique, friendly name for the asset model.
	//
	// AssetModelName is a required field
	AssetModelName *string `locationName:"assetModelName" min:"1" type:"string" required:"true"`

	// The property definitions of the asset model. For more information, see Asset
	// Properties (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html)
	// in the AWS IoT SiteWise User Guide.
	//
	// You can specify up to 200 properties per asset model. For more information,
	// see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
	// in the AWS IoT SiteWise User Guide.
	AssetModelProperties []*AssetModelPropertyDefinition `locationName:"assetModelProperties" type:"list"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// A list of key-value pairs that contain metadata for the asset model. For
	// more information, see Tagging your AWS IoT SiteWise resources (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html)
	// in the AWS IoT SiteWise User Guide.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s CreateAssetModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssetModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAssetModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAssetModelInput"}
	if s.AssetModelDescription != nil && len(*s.AssetModelDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssetModelDescription", 1))
	}
	if s.AssetModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetModelName"))
	}
	if s.AssetModelName != nil && len(*s.AssetModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssetModelName", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.AssetModelHierarchies != nil {
		for i, v := range s.AssetModelHierarchies {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AssetModelHierarchies", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.AssetModelProperties != nil {
		for i, v := range s.AssetModelProperties {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AssetModelProperties", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetModelDescription sets the AssetModelDescription field's value.
func (s *CreateAssetModelInput) SetAssetModelDescription(v string) *CreateAssetModelInput {
	s.AssetModelDescription = &v
	return s
}

// SetAssetModelHierarchies sets the AssetModelHierarchies field's value.
func (s *CreateAssetModelInput) SetAssetModelHierarchies(v []*AssetModelHierarchyDefinition) *CreateAssetModelInput {
	s.AssetModelHierarchies = v
	return s
}

// SetAssetModelName sets the AssetModelName field's value.
func (s *CreateAssetModelInput) SetAssetModelName(v string) *CreateAssetModelInput {
	s.AssetModelName = &v
	return s
}

// SetAssetModelProperties sets the AssetModelProperties field's value.
func (s *CreateAssetModelInput) SetAssetModelProperties(v []*AssetModelPropertyDefinition) *CreateAssetModelInput {
	s.AssetModelProperties = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAssetModelInput) SetClientToken(v string) *CreateAssetModelInput {
	s.ClientToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAssetModelInput) SetTags(v map[string]*string) *CreateAssetModelInput {
	s.Tags = v
	return s
}

type CreateAssetModelOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the asset model, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}
	//
	// AssetModelArn is a required field
	AssetModelArn *string `locationName:"assetModelArn" min:"1" type:"string" required:"true"`

	// The ID of the asset model. You can use this ID when you call other AWS IoT
	// SiteWise APIs.
	//
	// AssetModelId is a required field
	AssetModelId *string `locationName:"assetModelId" min:"36" type:"string" required:"true"`

	// The status of the asset model, which contains a state (CREATING after successfully
	// calling this operation) and any error message.
	//
	// AssetModelStatus is a required field
	AssetModelStatus *AssetModelStatus `locationName:"assetModelStatus" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateAssetModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssetModelOutput) GoString() string {
	return s.String()
}

// SetAssetModelArn sets the AssetModelArn field's value.
func (s *CreateAssetModelOutput) SetAssetModelArn(v string) *CreateAssetModelOutput {
	s.AssetModelArn = &v
	return s
}

// SetAssetModelId sets the AssetModelId field's value.
func (s *CreateAssetModelOutput) SetAssetModelId(v string) *CreateAssetModelOutput {
	s.AssetModelId = &v
	return s
}

// SetAssetModelStatus sets the AssetModelStatus field's value.
func (s *CreateAssetModelOutput) SetAssetModelStatus(v *AssetModelStatus) *CreateAssetModelOutput {
	s.AssetModelStatus = v
	return s
}

type CreateAssetOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the asset, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}
	//
	// AssetArn is a required field
	AssetArn *string `locationName:"assetArn" min:"1" type:"string" required:"true"`

	// The ID of the asset. This ID uniquely identifies the asset within AWS IoT
	// SiteWise and can be used with other AWS IoT SiteWise APIs.
	//
	// AssetId is a required field
	AssetId *string `locationName:"assetId" min:"36" type:"string" required:"true"`

	// The status of the asset, which contains a state (CREATING after successfully
	// calling this operation) and any error message.
	//
	// AssetStatus is a required field
	AssetStatus *AssetStatus `locationName:"assetStatus" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateAssetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssetOutput) GoString() string {
	return s.String()
}

// SetAssetArn sets the AssetArn field's value.
func (s *CreateAssetOutput) SetAssetArn(v string) *CreateAssetOutput {
	s.AssetArn = &v
	return s
}

// SetAssetId sets the AssetId field's value.
func (s *CreateAssetOutput) SetAssetId(v string) *CreateAssetOutput {
	s.AssetId = &v
	return s
}

// SetAssetStatus sets the AssetStatus field's value.
func (s *CreateAssetOutput) SetAssetStatus(v *AssetStatus) *CreateAssetOutput {
	s.AssetStatus = v
	return s
}

type CreateDashboardInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The dashboard definition specified in a JSON literal. For detailed information,
	// see Creating Dashboards (CLI) (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html)
	// in the AWS IoT SiteWise User Guide.
	//
	// DashboardDefinition is a required field
	DashboardDefinition *string `locationName:"dashboardDefinition" type:"string" required:"true"`

	// A description for the dashboard.
	DashboardDescription *string `locationName:"dashboardDescription" min:"1" type:"string"`

	// A friendly name for the dashboard.
	//
	// DashboardName is a required field
	DashboardName *string `locationName:"dashboardName" min:"1" type:"string" required:"true"`

	// The ID of the project in which to create the dashboard.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" min:"36" type:"string" required:"true"`

	// A list of key-value pairs that contain metadata for the dashboard. For more
	// information, see Tagging your AWS IoT SiteWise resources (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html)
	// in the AWS IoT SiteWise User Guide.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s CreateDashboardInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDashboardInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDashboardInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDashboardInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.DashboardDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardDefinition"))
	}
	if s.DashboardDescription != nil && len(*s.DashboardDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardDescription", 1))
	}
	if s.DashboardName == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardName"))
	}
	if s.DashboardName != nil && len(*s.DashboardName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardName", 1))
	}
	if s.ProjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectId", 36))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateDashboardInput) SetClientToken(v string) *CreateDashboardInput {
	s.ClientToken = &v
	return s
}

// SetDashboardDefinition sets the DashboardDefinition field's value.
func (s *CreateDashboardInput) SetDashboardDefinition(v string) *CreateDashboardInput {
	s.DashboardDefinition = &v
	return s
}

// SetDashboardDescription sets the DashboardDescription field's value.
func (s *CreateDashboardInput) SetDashboardDescription(v string) *CreateDashboardInput {
	s.DashboardDescription = &v
	return s
}

// SetDashboardName sets the DashboardName field's value.
func (s *CreateDashboardInput) SetDashboardName(v string) *CreateDashboardInput {
	s.DashboardName = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *CreateDashboardInput) SetProjectId(v string) *CreateDashboardInput {
	s.ProjectId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDashboardInput) SetTags(v map[string]*string) *CreateDashboardInput {
	s.Tags = v
	return s
}

type CreateDashboardOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the dashboard, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:dashboard/${DashboardId}
	//
	// DashboardArn is a required field
	DashboardArn *string `locationName:"dashboardArn" min:"1" type:"string" required:"true"`

	// The ID of the dashboard.
	//
	// DashboardId is a required field
	DashboardId *string `locationName:"dashboardId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDashboardOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDashboardOutput) GoString() string {
	return s.String()
}

// SetDashboardArn sets the DashboardArn field's value.
func (s *CreateDashboardOutput) SetDashboardArn(v string) *CreateDashboardOutput {
	s.DashboardArn = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *CreateDashboardOutput) SetDashboardId(v string) *CreateDashboardOutput {
	s.DashboardId = &v
	return s
}

type CreateGatewayInput struct {
	_ struct{} `type:"structure"`

	// A unique, friendly name for the gateway.
	//
	// GatewayName is a required field
	GatewayName *string `locationName:"gatewayName" min:"1" type:"string" required:"true"`

	// The gateway's platform. You can only specify one platform in a gateway.
	//
	// GatewayPlatform is a required field
	GatewayPlatform *GatewayPlatform `locationName:"gatewayPlatform" type:"structure" required:"true"`

	// A list of key-value pairs that contain metadata for the gateway. For more
	// information, see Tagging your AWS IoT SiteWise resources (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html)
	// in the AWS IoT SiteWise User Guide.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s CreateGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGatewayInput"}
	if s.GatewayName == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayName"))
	}
	if s.GatewayName != nil && len(*s.GatewayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayName", 1))
	}
	if s.GatewayPlatform == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayPlatform"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.GatewayPlatform != nil {
		if err := s.GatewayPlatform.Validate(); err != nil {
			invalidParams.AddNested("GatewayPlatform", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayName sets the GatewayName field's value.
func (s *CreateGatewayInput) SetGatewayName(v string) *CreateGatewayInput {
	s.GatewayName = &v
	return s
}

// SetGatewayPlatform sets the GatewayPlatform field's value.
func (s *CreateGatewayInput) SetGatewayPlatform(v *GatewayPlatform) *CreateGatewayInput {
	s.GatewayPlatform = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateGatewayInput) SetTags(v map[string]*string) *CreateGatewayInput {
	s.Tags = v
	return s
}

type CreateGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the gateway, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:gateway/${GatewayId}
	//
	// GatewayArn is a required field
	GatewayArn *string `locationName:"gatewayArn" min:"1" type:"string" required:"true"`

	// The ID of the gateway device. You can use this ID when you call other AWS
	// IoT SiteWise APIs.
	//
	// GatewayId is a required field
	GatewayId *string `locationName:"gatewayId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGatewayOutput) GoString() string {
	return s.String()
}

// SetGatewayArn sets the GatewayArn field's value.
func (s *CreateGatewayOutput) SetGatewayArn(v string) *CreateGatewayOutput {
	s.GatewayArn = &v
	return s
}

// SetGatewayId sets the GatewayId field's value.
func (s *CreateGatewayOutput) SetGatewayId(v string) *CreateGatewayOutput {
	s.GatewayId = &v
	return s
}

type CreatePortalInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The AWS administrator's contact email address.
	//
	// PortalContactEmail is a required field
	PortalContactEmail *string `locationName:"portalContactEmail" min:"1" type:"string" required:"true"`

	// A description for the portal.
	PortalDescription *string `locationName:"portalDescription" min:"1" type:"string"`

	// A logo image to display in the portal. Upload a square, high-resolution image.
	// The image is displayed on a dark background.
	PortalLogoImageFile *ImageFile `locationName:"portalLogoImageFile" type:"structure"`

	// A friendly name for the portal.
	//
	// PortalName is a required field
	PortalName *string `locationName:"portalName" min:"1" type:"string" required:"true"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of a service role that allows the portal's users to access your AWS IoT SiteWise
	// resources on your behalf. For more information, see Using service roles for
	// AWS IoT SiteWise Monitor (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html)
	// in the AWS IoT SiteWise User Guide.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"1" type:"string" required:"true"`

	// A list of key-value pairs that contain metadata for the portal. For more
	// information, see Tagging your AWS IoT SiteWise resources (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html)
	// in the AWS IoT SiteWise User Guide.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s CreatePortalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePortalInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePortalInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePortalInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.PortalContactEmail == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalContactEmail"))
	}
	if s.PortalContactEmail != nil && len(*s.PortalContactEmail) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortalContactEmail", 1))
	}
	if s.PortalDescription != nil && len(*s.PortalDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortalDescription", 1))
	}
	if s.PortalName == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalName"))
	}
	if s.PortalName != nil && len(*s.PortalName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortalName", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.PortalLogoImageFile != nil {
		if err := s.PortalLogoImageFile.Validate(); err != nil {
			invalidParams.AddNested("PortalLogoImageFile", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreatePortalInput) SetClientToken(v string) *CreatePortalInput {
	s.ClientToken = &v
	return s
}

// SetPortalContactEmail sets the PortalContactEmail field's value.
func (s *CreatePortalInput) SetPortalContactEmail(v string) *CreatePortalInput {
	s.PortalContactEmail = &v
	return s
}

// SetPortalDescription sets the PortalDescription field's value.
func (s *CreatePortalInput) SetPortalDescription(v string) *CreatePortalInput {
	s.PortalDescription = &v
	return s
}

// SetPortalLogoImageFile sets the PortalLogoImageFile field's value.
func (s *CreatePortalInput) SetPortalLogoImageFile(v *ImageFile) *CreatePortalInput {
	s.PortalLogoImageFile = v
	return s
}

// SetPortalName sets the PortalName field's value.
func (s *CreatePortalInput) SetPortalName(v string) *CreatePortalInput {
	s.PortalName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreatePortalInput) SetRoleArn(v string) *CreatePortalInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePortalInput) SetTags(v map[string]*string) *CreatePortalInput {
	s.Tags = v
	return s
}

type CreatePortalOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the portal, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}
	//
	// PortalArn is a required field
	PortalArn *string `locationName:"portalArn" min:"1" type:"string" required:"true"`

	// The ID of the created portal.
	//
	// PortalId is a required field
	PortalId *string `locationName:"portalId" min:"36" type:"string" required:"true"`

	// The public URL for the AWS IoT SiteWise Monitor portal.
	//
	// PortalStartUrl is a required field
	PortalStartUrl *string `locationName:"portalStartUrl" min:"1" type:"string" required:"true"`

	// The status of the portal, which contains a state (CREATING after successfully
	// calling this operation) and any error message.
	//
	// PortalStatus is a required field
	PortalStatus *PortalStatus `locationName:"portalStatus" type:"structure" required:"true"`

	// The associated AWS SSO application Id.
	//
	// SsoApplicationId is a required field
	SsoApplicationId *string `locationName:"ssoApplicationId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePortalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePortalOutput) GoString() string {
	return s.String()
}

// SetPortalArn sets the PortalArn field's value.
func (s *CreatePortalOutput) SetPortalArn(v string) *CreatePortalOutput {
	s.PortalArn = &v
	return s
}

// SetPortalId sets the PortalId field's value.
func (s *CreatePortalOutput) SetPortalId(v string) *CreatePortalOutput {
	s.PortalId = &v
	return s
}

// SetPortalStartUrl sets the PortalStartUrl field's value.
func (s *CreatePortalOutput) SetPortalStartUrl(v string) *CreatePortalOutput {
	s.PortalStartUrl = &v
	return s
}

// SetPortalStatus sets the PortalStatus field's value.
func (s *CreatePortalOutput) SetPortalStatus(v *PortalStatus) *CreatePortalOutput {
	s.PortalStatus = v
	return s
}

// SetSsoApplicationId sets the SsoApplicationId field's value.
func (s *CreatePortalOutput) SetSsoApplicationId(v string) *CreatePortalOutput {
	s.SsoApplicationId = &v
	return s
}

type CreateProjectInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The ID of the portal in which to create the project.
	//
	// PortalId is a required field
	PortalId *string `locationName:"portalId" min:"36" type:"string" required:"true"`

	// A description for the project.
	ProjectDescription *string `locationName:"projectDescription" min:"1" type:"string"`

	// A friendly name for the project.
	//
	// ProjectName is a required field
	ProjectName *string `locationName:"projectName" min:"1" type:"string" required:"true"`

	// A list of key-value pairs that contain metadata for the project. For more
	// information, see Tagging your AWS IoT SiteWise resources (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html)
	// in the AWS IoT SiteWise User Guide.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s CreateProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProjectInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.PortalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalId"))
	}
	if s.PortalId != nil && len(*s.PortalId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PortalId", 36))
	}
	if s.ProjectDescription != nil && len(*s.ProjectDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectDescription", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateProjectInput) SetClientToken(v string) *CreateProjectInput {
	s.ClientToken = &v
	return s
}

// SetPortalId sets the PortalId field's value.
func (s *CreateProjectInput) SetPortalId(v string) *CreateProjectInput {
	s.PortalId = &v
	return s
}

// SetProjectDescription sets the ProjectDescription field's value.
func (s *CreateProjectInput) SetProjectDescription(v string) *CreateProjectInput {
	s.ProjectDescription = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateProjectInput) SetProjectName(v string) *CreateProjectInput {
	s.ProjectName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateProjectInput) SetTags(v map[string]*string) *CreateProjectInput {
	s.Tags = v
	return s
}

type CreateProjectOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the project, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:project/${ProjectId}
	//
	// ProjectArn is a required field
	ProjectArn *string `locationName:"projectArn" min:"1" type:"string" required:"true"`

	// The ID of the project.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProjectOutput) GoString() string {
	return s.String()
}

// SetProjectArn sets the ProjectArn field's value.
func (s *CreateProjectOutput) SetProjectArn(v string) *CreateProjectOutput {
	s.ProjectArn = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *CreateProjectOutput) SetProjectId(v string) *CreateProjectOutput {
	s.ProjectId = &v
	return s
}

// Contains a dashboard summary.
type DashboardSummary struct {
	_ struct{} `type:"structure"`

	// The date the dashboard was created, in Unix epoch time.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The dashboard's description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The ID of the dashboard.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The date the dashboard was last updated, in Unix epoch time.
	LastUpdateDate *time.Time `locationName:"lastUpdateDate" type:"timestamp"`

	// The name of the dashboard
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DashboardSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DashboardSummary) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *DashboardSummary) SetCreationDate(v time.Time) *DashboardSummary {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DashboardSummary) SetDescription(v string) *DashboardSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *DashboardSummary) SetId(v string) *DashboardSummary {
	s.Id = &v
	return s
}

// SetLastUpdateDate sets the LastUpdateDate field's value.
func (s *DashboardSummary) SetLastUpdateDate(v time.Time) *DashboardSummary {
	s.LastUpdateDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *DashboardSummary) SetName(v string) *DashboardSummary {
	s.Name = &v
	return s
}

type DeleteAccessPolicyInput struct {
	_ struct{} `type:"structure"`

	// The ID of the access policy to be deleted.
	//
	// AccessPolicyId is a required field
	AccessPolicyId *string `location:"uri" locationName:"accessPolicyId" min:"36" type:"string" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`
}

// String returns the string representation
func (s DeleteAccessPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccessPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccessPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAccessPolicyInput"}
	if s.AccessPolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessPolicyId"))
	}
	if s.AccessPolicyId != nil && len(*s.AccessPolicyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AccessPolicyId", 36))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessPolicyId sets the AccessPolicyId field's value.
func (s *DeleteAccessPolicyInput) SetAccessPolicyId(v string) *DeleteAccessPolicyInput {
	s.AccessPolicyId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteAccessPolicyInput) SetClientToken(v string) *DeleteAccessPolicyInput {
	s.ClientToken = &v
	return s
}

type DeleteAccessPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAccessPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccessPolicyOutput) GoString() string {
	return s.String()
}

type DeleteAssetInput struct {
	_ struct{} `type:"structure"`

	// The ID of the asset to delete.
	//
	// AssetId is a required field
	AssetId *string `location:"uri" locationName:"assetId" min:"36" type:"string" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`
}

// String returns the string representation
func (s DeleteAssetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAssetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAssetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAssetInput"}
	if s.AssetId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetId"))
	}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *DeleteAssetInput) SetAssetId(v string) *DeleteAssetInput {
	s.AssetId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteAssetInput) SetClientToken(v string) *DeleteAssetInput {
	s.ClientToken = &v
	return s
}

type DeleteAssetModelInput struct {
	_ struct{} `type:"structure"`

	// The ID of the asset model to delete.
	//
	// AssetModelId is a required field
	AssetModelId *string `location:"uri" locationName:"assetModelId" min:"36" type:"string" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`
}

// String returns the string representation
func (s DeleteAssetModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAssetModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAssetModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAssetModelInput"}
	if s.AssetModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetModelId"))
	}
	if s.AssetModelId != nil && len(*s.AssetModelId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetModelId", 36))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetModelId sets the AssetModelId field's value.
func (s *DeleteAssetModelInput) SetAssetModelId(v string) *DeleteAssetModelInput {
	s.AssetModelId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteAssetModelInput) SetClientToken(v string) *DeleteAssetModelInput {
	s.ClientToken = &v
	return s
}

type DeleteAssetModelOutput struct {
	_ struct{} `type:"structure"`

	// The status of the asset model, which contains a state (DELETING after successfully
	// calling this operation) and any error message.
	//
	// AssetModelStatus is a required field
	AssetModelStatus *AssetModelStatus `locationName:"assetModelStatus" type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteAssetModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAssetModelOutput) GoString() string {
	return s.String()
}

// SetAssetModelStatus sets the AssetModelStatus field's value.
func (s *DeleteAssetModelOutput) SetAssetModelStatus(v *AssetModelStatus) *DeleteAssetModelOutput {
	s.AssetModelStatus = v
	return s
}

type DeleteAssetOutput struct {
	_ struct{} `type:"structure"`

	// The status of the asset, which contains a state (DELETING after successfully
	// calling this operation) and any error message.
	//
	// AssetStatus is a required field
	AssetStatus *AssetStatus `locationName:"assetStatus" type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteAssetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAssetOutput) GoString() string {
	return s.String()
}

// SetAssetStatus sets the AssetStatus field's value.
func (s *DeleteAssetOutput) SetAssetStatus(v *AssetStatus) *DeleteAssetOutput {
	s.AssetStatus = v
	return s
}

type DeleteDashboardInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The ID of the dashboard to delete.
	//
	// DashboardId is a required field
	DashboardId *string `location:"uri" locationName:"dashboardId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDashboardInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDashboardInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDashboardInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDashboardInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.DashboardId == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardId"))
	}
	if s.DashboardId != nil && len(*s.DashboardId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteDashboardInput) SetClientToken(v string) *DeleteDashboardInput {
	s.ClientToken = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *DeleteDashboardInput) SetDashboardId(v string) *DeleteDashboardInput {
	s.DashboardId = &v
	return s
}

type DeleteDashboardOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDashboardOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDashboardOutput) GoString() string {
	return s.String()
}

type DeleteGatewayInput struct {
	_ struct{} `type:"structure"`

	// The ID of the gateway to delete.
	//
	// GatewayId is a required field
	GatewayId *string `location:"uri" locationName:"gatewayId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGatewayInput"}
	if s.GatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayId"))
	}
	if s.GatewayId != nil && len(*s.GatewayId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayId sets the GatewayId field's value.
func (s *DeleteGatewayInput) SetGatewayId(v string) *DeleteGatewayInput {
	s.GatewayId = &v
	return s
}

type DeleteGatewayOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGatewayOutput) GoString() string {
	return s.String()
}

type DeletePortalInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The ID of the portal to delete.
	//
	// PortalId is a required field
	PortalId *string `location:"uri" locationName:"portalId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePortalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePortalInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePortalInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePortalInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.PortalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalId"))
	}
	if s.PortalId != nil && len(*s.PortalId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PortalId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeletePortalInput) SetClientToken(v string) *DeletePortalInput {
	s.ClientToken = &v
	return s
}

// SetPortalId sets the PortalId field's value.
func (s *DeletePortalInput) SetPortalId(v string) *DeletePortalInput {
	s.PortalId = &v
	return s
}

type DeletePortalOutput struct {
	_ struct{} `type:"structure"`

	// The status of the portal, which contains a state (DELETING after successfully
	// calling this operation) and any error message.
	//
	// PortalStatus is a required field
	PortalStatus *PortalStatus `locationName:"portalStatus" type:"structure" required:"true"`
}

// String returns the string representation
func (s DeletePortalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePortalOutput) GoString() string {
	return s.String()
}

// SetPortalStatus sets the PortalStatus field's value.
func (s *DeletePortalOutput) SetPortalStatus(v *PortalStatus) *DeletePortalOutput {
	s.PortalStatus = v
	return s
}

type DeleteProjectInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The ID of the project.
	//
	// ProjectId is a required field
	ProjectId *string `location:"uri" locationName:"projectId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProjectInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.ProjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteProjectInput) SetClientToken(v string) *DeleteProjectInput {
	s.ClientToken = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *DeleteProjectInput) SetProjectId(v string) *DeleteProjectInput {
	s.ProjectId = &v
	return s
}

type DeleteProjectOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProjectOutput) GoString() string {
	return s.String()
}

type DescribeAccessPolicyInput struct {
	_ struct{} `type:"structure"`

	// The ID of the access policy.
	//
	// AccessPolicyId is a required field
	AccessPolicyId *string `location:"uri" locationName:"accessPolicyId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAccessPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccessPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAccessPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAccessPolicyInput"}
	if s.AccessPolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessPolicyId"))
	}
	if s.AccessPolicyId != nil && len(*s.AccessPolicyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AccessPolicyId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessPolicyId sets the AccessPolicyId field's value.
func (s *DescribeAccessPolicyInput) SetAccessPolicyId(v string) *DescribeAccessPolicyInput {
	s.AccessPolicyId = &v
	return s
}

type DescribeAccessPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the access policy, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:access-policy/${AccessPolicyId}
	//
	// AccessPolicyArn is a required field
	AccessPolicyArn *string `locationName:"accessPolicyArn" min:"1" type:"string" required:"true"`

	// The date the access policy was created, in Unix epoch time.
	//
	// AccessPolicyCreationDate is a required field
	AccessPolicyCreationDate *time.Time `locationName:"accessPolicyCreationDate" type:"timestamp" required:"true"`

	// The ID of the access policy.
	//
	// AccessPolicyId is a required field
	AccessPolicyId *string `locationName:"accessPolicyId" min:"36" type:"string" required:"true"`

	// The AWS SSO identity (user or group) to which this access policy applies.
	//
	// AccessPolicyIdentity is a required field
	AccessPolicyIdentity *Identity `locationName:"accessPolicyIdentity" type:"structure" required:"true"`

	// The date the access policy was last updated, in Unix epoch time.
	//
	// AccessPolicyLastUpdateDate is a required field
	AccessPolicyLastUpdateDate *time.Time `locationName:"accessPolicyLastUpdateDate" type:"timestamp" required:"true"`

	// The access policy permission. Note that a project ADMINISTRATOR is also known
	// as a project owner.
	//
	// AccessPolicyPermission is a required field
	AccessPolicyPermission *string `locationName:"accessPolicyPermission" type:"string" required:"true" enum:"Permission"`

	// The AWS IoT SiteWise Monitor resource (portal or project) to which this access
	// policy provides access.
	//
	// AccessPolicyResource is a required field
	AccessPolicyResource *Resource `locationName:"accessPolicyResource" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeAccessPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccessPolicyOutput) GoString() string {
	return s.String()
}

// SetAccessPolicyArn sets the AccessPolicyArn field's value.
func (s *DescribeAccessPolicyOutput) SetAccessPolicyArn(v string) *DescribeAccessPolicyOutput {
	s.AccessPolicyArn = &v
	return s
}

// SetAccessPolicyCreationDate sets the AccessPolicyCreationDate field's value.
func (s *DescribeAccessPolicyOutput) SetAccessPolicyCreationDate(v time.Time) *DescribeAccessPolicyOutput {
	s.AccessPolicyCreationDate = &v
	return s
}

// SetAccessPolicyId sets the AccessPolicyId field's value.
func (s *DescribeAccessPolicyOutput) SetAccessPolicyId(v string) *DescribeAccessPolicyOutput {
	s.AccessPolicyId = &v
	return s
}

// SetAccessPolicyIdentity sets the AccessPolicyIdentity field's value.
func (s *DescribeAccessPolicyOutput) SetAccessPolicyIdentity(v *Identity) *DescribeAccessPolicyOutput {
	s.AccessPolicyIdentity = v
	return s
}

// SetAccessPolicyLastUpdateDate sets the AccessPolicyLastUpdateDate field's value.
func (s *DescribeAccessPolicyOutput) SetAccessPolicyLastUpdateDate(v time.Time) *DescribeAccessPolicyOutput {
	s.AccessPolicyLastUpdateDate = &v
	return s
}

// SetAccessPolicyPermission sets the AccessPolicyPermission field's value.
func (s *DescribeAccessPolicyOutput) SetAccessPolicyPermission(v string) *DescribeAccessPolicyOutput {
	s.AccessPolicyPermission = &v
	return s
}

// SetAccessPolicyResource sets the AccessPolicyResource field's value.
func (s *DescribeAccessPolicyOutput) SetAccessPolicyResource(v *Resource) *DescribeAccessPolicyOutput {
	s.AccessPolicyResource = v
	return s
}

type DescribeAssetInput struct {
	_ struct{} `type:"structure"`

	// The ID of the asset.
	//
	// AssetId is a required field
	AssetId *string `location:"uri" locationName:"assetId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAssetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAssetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAssetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAssetInput"}
	if s.AssetId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetId"))
	}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *DescribeAssetInput) SetAssetId(v string) *DescribeAssetInput {
	s.AssetId = &v
	return s
}

type DescribeAssetModelInput struct {
	_ struct{} `type:"structure"`

	// The ID of the asset model.
	//
	// AssetModelId is a required field
	AssetModelId *string `location:"uri" locationName:"assetModelId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAssetModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAssetModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAssetModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAssetModelInput"}
	if s.AssetModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetModelId"))
	}
	if s.AssetModelId != nil && len(*s.AssetModelId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetModelId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetModelId sets the AssetModelId field's value.
func (s *DescribeAssetModelInput) SetAssetModelId(v string) *DescribeAssetModelInput {
	s.AssetModelId = &v
	return s
}

type DescribeAssetModelOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the asset model, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}
	//
	// AssetModelArn is a required field
	AssetModelArn *string `locationName:"assetModelArn" min:"1" type:"string" required:"true"`

	// The date the asset model was created, in Unix epoch time.
	//
	// AssetModelCreationDate is a required field
	AssetModelCreationDate *time.Time `locationName:"assetModelCreationDate" type:"timestamp" required:"true"`

	// The asset model's description.
	//
	// AssetModelDescription is a required field
	AssetModelDescription *string `locationName:"assetModelDescription" min:"1" type:"string" required:"true"`

	// A list of asset model hierarchies that each contain a childAssetModelId and
	// a hierarchyId (named id). A hierarchy specifies allowed parent/child asset
	// relationships for an asset model.
	//
	// AssetModelHierarchies is a required field
	AssetModelHierarchies []*AssetModelHierarchy `locationName:"assetModelHierarchies" type:"list" required:"true"`

	// The ID of the asset model.
	//
	// AssetModelId is a required field
	AssetModelId *string `locationName:"assetModelId" min:"36" type:"string" required:"true"`

	// The date the asset model was last updated, in Unix epoch time.
	//
	// AssetModelLastUpdateDate is a required field
	AssetModelLastUpdateDate *time.Time `locationName:"assetModelLastUpdateDate" type:"timestamp" required:"true"`

	// The name of the asset model.
	//
	// AssetModelName is a required field
	AssetModelName *string `locationName:"assetModelName" min:"1" type:"string" required:"true"`

	// The list of asset properties for the asset model.
	//
	// AssetModelProperties is a required field
	AssetModelProperties []*AssetModelProperty `locationName:"assetModelProperties" type:"list" required:"true"`

	// The current status of the asset model, which contains a state and any error
	// message.
	//
	// AssetModelStatus is a required field
	AssetModelStatus *AssetModelStatus `locationName:"assetModelStatus" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeAssetModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAssetModelOutput) GoString() string {
	return s.String()
}

// SetAssetModelArn sets the AssetModelArn field's value.
func (s *DescribeAssetModelOutput) SetAssetModelArn(v string) *DescribeAssetModelOutput {
	s.AssetModelArn = &v
	return s
}

// SetAssetModelCreationDate sets the AssetModelCreationDate field's value.
func (s *DescribeAssetModelOutput) SetAssetModelCreationDate(v time.Time) *DescribeAssetModelOutput {
	s.AssetModelCreationDate = &v
	return s
}

// SetAssetModelDescription sets the AssetModelDescription field's value.
func (s *DescribeAssetModelOutput) SetAssetModelDescription(v string) *DescribeAssetModelOutput {
	s.AssetModelDescription = &v
	return s
}

// SetAssetModelHierarchies sets the AssetModelHierarchies field's value.
func (s *DescribeAssetModelOutput) SetAssetModelHierarchies(v []*AssetModelHierarchy) *DescribeAssetModelOutput {
	s.AssetModelHierarchies = v
	return s
}

// SetAssetModelId sets the AssetModelId field's value.
func (s *DescribeAssetModelOutput) SetAssetModelId(v string) *DescribeAssetModelOutput {
	s.AssetModelId = &v
	return s
}

// SetAssetModelLastUpdateDate sets the AssetModelLastUpdateDate field's value.
func (s *DescribeAssetModelOutput) SetAssetModelLastUpdateDate(v time.Time) *DescribeAssetModelOutput {
	s.AssetModelLastUpdateDate = &v
	return s
}

// SetAssetModelName sets the AssetModelName field's value.
func (s *DescribeAssetModelOutput) SetAssetModelName(v string) *DescribeAssetModelOutput {
	s.AssetModelName = &v
	return s
}

// SetAssetModelProperties sets the AssetModelProperties field's value.
func (s *DescribeAssetModelOutput) SetAssetModelProperties(v []*AssetModelProperty) *DescribeAssetModelOutput {
	s.AssetModelProperties = v
	return s
}

// SetAssetModelStatus sets the AssetModelStatus field's value.
func (s *DescribeAssetModelOutput) SetAssetModelStatus(v *AssetModelStatus) *DescribeAssetModelOutput {
	s.AssetModelStatus = v
	return s
}

type DescribeAssetOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the asset, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}
	//
	// AssetArn is a required field
	AssetArn *string `locationName:"assetArn" min:"1" type:"string" required:"true"`

	// The date the asset was created, in Unix epoch time.
	//
	// AssetCreationDate is a required field
	AssetCreationDate *time.Time `locationName:"assetCreationDate" type:"timestamp" required:"true"`

	// A list of asset hierarchies that each contain a hierarchyId. A hierarchy
	// specifies allowed parent/child asset relationships.
	//
	// AssetHierarchies is a required field
	AssetHierarchies []*AssetHierarchy `locationName:"assetHierarchies" type:"list" required:"true"`

	// The ID of the asset.
	//
	// AssetId is a required field
	AssetId *string `locationName:"assetId" min:"36" type:"string" required:"true"`

	// The date the asset was last updated, in Unix epoch time.
	//
	// AssetLastUpdateDate is a required field
	AssetLastUpdateDate *time.Time `locationName:"assetLastUpdateDate" type:"timestamp" required:"true"`

	// The ID of the asset model that was used to create the asset.
	//
	// AssetModelId is a required field
	AssetModelId *string `locationName:"assetModelId" min:"36" type:"string" required:"true"`

	// The name of the asset.
	//
	// AssetName is a required field
	AssetName *string `locationName:"assetName" min:"1" type:"string" required:"true"`

	// The list of asset properties for the asset.
	//
	// AssetProperties is a required field
	AssetProperties []*AssetProperty `locationName:"assetProperties" type:"list" required:"true"`

	// The current status of the asset, which contains a state and any error message.
	//
	// AssetStatus is a required field
	AssetStatus *AssetStatus `locationName:"assetStatus" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeAssetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAssetOutput) GoString() string {
	return s.String()
}

// SetAssetArn sets the AssetArn field's value.
func (s *DescribeAssetOutput) SetAssetArn(v string) *DescribeAssetOutput {
	s.AssetArn = &v
	return s
}

// SetAssetCreationDate sets the AssetCreationDate field's value.
func (s *DescribeAssetOutput) SetAssetCreationDate(v time.Time) *DescribeAssetOutput {
	s.AssetCreationDate = &v
	return s
}

// SetAssetHierarchies sets the AssetHierarchies field's value.
func (s *DescribeAssetOutput) SetAssetHierarchies(v []*AssetHierarchy) *DescribeAssetOutput {
	s.AssetHierarchies = v
	return s
}

// SetAssetId sets the AssetId field's value.
func (s *DescribeAssetOutput) SetAssetId(v string) *DescribeAssetOutput {
	s.AssetId = &v
	return s
}

// SetAssetLastUpdateDate sets the AssetLastUpdateDate field's value.
func (s *DescribeAssetOutput) SetAssetLastUpdateDate(v time.Time) *DescribeAssetOutput {
	s.AssetLastUpdateDate = &v
	return s
}

// SetAssetModelId sets the AssetModelId field's value.
func (s *DescribeAssetOutput) SetAssetModelId(v string) *DescribeAssetOutput {
	s.AssetModelId = &v
	return s
}

// SetAssetName sets the AssetName field's value.
func (s *DescribeAssetOutput) SetAssetName(v string) *DescribeAssetOutput {
	s.AssetName = &v
	return s
}

// SetAssetProperties sets the AssetProperties field's value.
func (s *DescribeAssetOutput) SetAssetProperties(v []*AssetProperty) *DescribeAssetOutput {
	s.AssetProperties = v
	return s
}

// SetAssetStatus sets the AssetStatus field's value.
func (s *DescribeAssetOutput) SetAssetStatus(v *AssetStatus) *DescribeAssetOutput {
	s.AssetStatus = v
	return s
}

type DescribeAssetPropertyInput struct {
	_ struct{} `type:"structure"`

	// The ID of the asset.
	//
	// AssetId is a required field
	AssetId *string `location:"uri" locationName:"assetId" min:"36" type:"string" required:"true"`

	// The ID of the asset property.
	//
	// PropertyId is a required field
	PropertyId *string `location:"uri" locationName:"propertyId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAssetPropertyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAssetPropertyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAssetPropertyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAssetPropertyInput"}
	if s.AssetId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetId"))
	}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.PropertyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PropertyId"))
	}
	if s.PropertyId != nil && len(*s.PropertyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *DescribeAssetPropertyInput) SetAssetId(v string) *DescribeAssetPropertyInput {
	s.AssetId = &v
	return s
}

// SetPropertyId sets the PropertyId field's value.
func (s *DescribeAssetPropertyInput) SetPropertyId(v string) *DescribeAssetPropertyInput {
	s.PropertyId = &v
	return s
}

type DescribeAssetPropertyOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the asset.
	//
	// AssetId is a required field
	AssetId *string `locationName:"assetId" min:"36" type:"string" required:"true"`

	// The ID of the asset model.
	//
	// AssetModelId is a required field
	AssetModelId *string `locationName:"assetModelId" min:"36" type:"string" required:"true"`

	// The name of the asset.
	//
	// AssetName is a required field
	AssetName *string `locationName:"assetName" min:"1" type:"string" required:"true"`

	// The asset property's definition, alias, and notification state.
	//
	// AssetProperty is a required field
	AssetProperty *Property `locationName:"assetProperty" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeAssetPropertyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAssetPropertyOutput) GoString() string {
	return s.String()
}

// SetAssetId sets the AssetId field's value.
func (s *DescribeAssetPropertyOutput) SetAssetId(v string) *DescribeAssetPropertyOutput {
	s.AssetId = &v
	return s
}

// SetAssetModelId sets the AssetModelId field's value.
func (s *DescribeAssetPropertyOutput) SetAssetModelId(v string) *DescribeAssetPropertyOutput {
	s.AssetModelId = &v
	return s
}

// SetAssetName sets the AssetName field's value.
func (s *DescribeAssetPropertyOutput) SetAssetName(v string) *DescribeAssetPropertyOutput {
	s.AssetName = &v
	return s
}

// SetAssetProperty sets the AssetProperty field's value.
func (s *DescribeAssetPropertyOutput) SetAssetProperty(v *Property) *DescribeAssetPropertyOutput {
	s.AssetProperty = v
	return s
}

type DescribeDashboardInput struct {
	_ struct{} `type:"structure"`

	// The ID of the dashboard.
	//
	// DashboardId is a required field
	DashboardId *string `location:"uri" locationName:"dashboardId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDashboardInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDashboardInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDashboardInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDashboardInput"}
	if s.DashboardId == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardId"))
	}
	if s.DashboardId != nil && len(*s.DashboardId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDashboardId sets the DashboardId field's value.
func (s *DescribeDashboardInput) SetDashboardId(v string) *DescribeDashboardInput {
	s.DashboardId = &v
	return s
}

type DescribeDashboardOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the dashboard, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:dashboard/${DashboardId}
	//
	// DashboardArn is a required field
	DashboardArn *string `locationName:"dashboardArn" min:"1" type:"string" required:"true"`

	// The date the dashboard was created, in Unix epoch time.
	//
	// DashboardCreationDate is a required field
	DashboardCreationDate *time.Time `locationName:"dashboardCreationDate" type:"timestamp" required:"true"`

	// The dashboard's definition JSON literal. For detailed information, see Creating
	// Dashboards (CLI) (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html)
	// in the AWS IoT SiteWise User Guide.
	//
	// DashboardDefinition is a required field
	DashboardDefinition *string `locationName:"dashboardDefinition" type:"string" required:"true"`

	// The dashboard's description.
	DashboardDescription *string `locationName:"dashboardDescription" min:"1" type:"string"`

	// The ID of the dashboard.
	//
	// DashboardId is a required field
	DashboardId *string `locationName:"dashboardId" min:"36" type:"string" required:"true"`

	// The date the dashboard was last updated, in Unix epoch time.
	//
	// DashboardLastUpdateDate is a required field
	DashboardLastUpdateDate *time.Time `locationName:"dashboardLastUpdateDate" type:"timestamp" required:"true"`

	// The name of the dashboard.
	//
	// DashboardName is a required field
	DashboardName *string `locationName:"dashboardName" min:"1" type:"string" required:"true"`

	// The ID of the project that the dashboard is in.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDashboardOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDashboardOutput) GoString() string {
	return s.String()
}

// SetDashboardArn sets the DashboardArn field's value.
func (s *DescribeDashboardOutput) SetDashboardArn(v string) *DescribeDashboardOutput {
	s.DashboardArn = &v
	return s
}

// SetDashboardCreationDate sets the DashboardCreationDate field's value.
func (s *DescribeDashboardOutput) SetDashboardCreationDate(v time.Time) *DescribeDashboardOutput {
	s.DashboardCreationDate = &v
	return s
}

// SetDashboardDefinition sets the DashboardDefinition field's value.
func (s *DescribeDashboardOutput) SetDashboardDefinition(v string) *DescribeDashboardOutput {
	s.DashboardDefinition = &v
	return s
}

// SetDashboardDescription sets the DashboardDescription field's value.
func (s *DescribeDashboardOutput) SetDashboardDescription(v string) *DescribeDashboardOutput {
	s.DashboardDescription = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *DescribeDashboardOutput) SetDashboardId(v string) *DescribeDashboardOutput {
	s.DashboardId = &v
	return s
}

// SetDashboardLastUpdateDate sets the DashboardLastUpdateDate field's value.
func (s *DescribeDashboardOutput) SetDashboardLastUpdateDate(v time.Time) *DescribeDashboardOutput {
	s.DashboardLastUpdateDate = &v
	return s
}

// SetDashboardName sets the DashboardName field's value.
func (s *DescribeDashboardOutput) SetDashboardName(v string) *DescribeDashboardOutput {
	s.DashboardName = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *DescribeDashboardOutput) SetProjectId(v string) *DescribeDashboardOutput {
	s.ProjectId = &v
	return s
}

type DescribeGatewayCapabilityConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The namespace of the capability configuration. For example, if you configure
	// OPC-UA sources from the AWS IoT SiteWise console, your OPC-UA capability
	// configuration has the namespace iotsitewise:opcuacollector:version, where
	// version is a number such as 1.
	//
	// CapabilityNamespace is a required field
	CapabilityNamespace *string `location:"uri" locationName:"capabilityNamespace" min:"1" type:"string" required:"true"`

	// The ID of the gateway that defines the capability configuration.
	//
	// GatewayId is a required field
	GatewayId *string `location:"uri" locationName:"gatewayId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeGatewayCapabilityConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGatewayCapabilityConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGatewayCapabilityConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGatewayCapabilityConfigurationInput"}
	if s.CapabilityNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("CapabilityNamespace"))
	}
	if s.CapabilityNamespace != nil && len(*s.CapabilityNamespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CapabilityNamespace", 1))
	}
	if s.GatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayId"))
	}
	if s.GatewayId != nil && len(*s.GatewayId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapabilityNamespace sets the CapabilityNamespace field's value.
func (s *DescribeGatewayCapabilityConfigurationInput) SetCapabilityNamespace(v string) *DescribeGatewayCapabilityConfigurationInput {
	s.CapabilityNamespace = &v
	return s
}

// SetGatewayId sets the GatewayId field's value.
func (s *DescribeGatewayCapabilityConfigurationInput) SetGatewayId(v string) *DescribeGatewayCapabilityConfigurationInput {
	s.GatewayId = &v
	return s
}

type DescribeGatewayCapabilityConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The JSON document that defines the gateway capability's configuration. For
	// more information, see Configuring data sources (CLI) (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli)
	// in the AWS IoT SiteWise User Guide.
	//
	// CapabilityConfiguration is a required field
	CapabilityConfiguration *string `locationName:"capabilityConfiguration" min:"1" type:"string" required:"true"`

	// The namespace of the gateway capability.
	//
	// CapabilityNamespace is a required field
	CapabilityNamespace *string `locationName:"capabilityNamespace" min:"1" type:"string" required:"true"`

	// The synchronization status of the capability configuration. The sync status
	// can be one of the following:
	//
	//    * IN_SYNC – The gateway is running the capability configuration.
	//
	//    * OUT_OF_SYNC – The gateway hasn't received the capability configuration.
	//
	//    * SYNC_FAILED – The gateway rejected the capability configuration.
	//
	// CapabilitySyncStatus is a required field
	CapabilitySyncStatus *string `locationName:"capabilitySyncStatus" type:"string" required:"true" enum:"CapabilitySyncStatus"`

	// The ID of the gateway that defines the capability configuration.
	//
	// GatewayId is a required field
	GatewayId *string `locationName:"gatewayId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeGatewayCapabilityConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGatewayCapabilityConfigurationOutput) GoString() string {
	return s.String()
}

// SetCapabilityConfiguration sets the CapabilityConfiguration field's value.
func (s *DescribeGatewayCapabilityConfigurationOutput) SetCapabilityConfiguration(v string) *DescribeGatewayCapabilityConfigurationOutput {
	s.CapabilityConfiguration = &v
	return s
}

// SetCapabilityNamespace sets the CapabilityNamespace field's value.
func (s *DescribeGatewayCapabilityConfigurationOutput) SetCapabilityNamespace(v string) *DescribeGatewayCapabilityConfigurationOutput {
	s.CapabilityNamespace = &v
	return s
}

// SetCapabilitySyncStatus sets the CapabilitySyncStatus field's value.
func (s *DescribeGatewayCapabilityConfigurationOutput) SetCapabilitySyncStatus(v string) *DescribeGatewayCapabilityConfigurationOutput {
	s.CapabilitySyncStatus = &v
	return s
}

// SetGatewayId sets the GatewayId field's value.
func (s *DescribeGatewayCapabilityConfigurationOutput) SetGatewayId(v string) *DescribeGatewayCapabilityConfigurationOutput {
	s.GatewayId = &v
	return s
}

type DescribeGatewayInput struct {
	_ struct{} `type:"structure"`

	// The ID of the gateway device.
	//
	// GatewayId is a required field
	GatewayId *string `location:"uri" locationName:"gatewayId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGatewayInput"}
	if s.GatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayId"))
	}
	if s.GatewayId != nil && len(*s.GatewayId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayId sets the GatewayId field's value.
func (s *DescribeGatewayInput) SetGatewayId(v string) *DescribeGatewayInput {
	s.GatewayId = &v
	return s
}

type DescribeGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The date the gateway was created, in Unix epoch time.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" required:"true"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the gateway, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:gateway/${GatewayId}
	//
	// GatewayArn is a required field
	GatewayArn *string `locationName:"gatewayArn" min:"1" type:"string" required:"true"`

	// A list of gateway capability summaries that each contain a namespace and
	// status. Each gateway capability defines data sources for the gateway. To
	// retrieve a capability configuration's definition, use DescribeGatewayCapabilityConfiguration
	// (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html).
	//
	// GatewayCapabilitySummaries is a required field
	GatewayCapabilitySummaries []*GatewayCapabilitySummary `locationName:"gatewayCapabilitySummaries" type:"list" required:"true"`

	// The ID of the gateway device.
	//
	// GatewayId is a required field
	GatewayId *string `locationName:"gatewayId" min:"36" type:"string" required:"true"`

	// The name of the gateway.
	//
	// GatewayName is a required field
	GatewayName *string `locationName:"gatewayName" min:"1" type:"string" required:"true"`

	// The gateway's platform.
	GatewayPlatform *GatewayPlatform `locationName:"gatewayPlatform" type:"structure"`

	// The date the gateway was last updated, in Unix epoch time.
	//
	// LastUpdateDate is a required field
	LastUpdateDate *time.Time `locationName:"lastUpdateDate" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s DescribeGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGatewayOutput) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *DescribeGatewayOutput) SetCreationDate(v time.Time) *DescribeGatewayOutput {
	s.CreationDate = &v
	return s
}

// SetGatewayArn sets the GatewayArn field's value.
func (s *DescribeGatewayOutput) SetGatewayArn(v string) *DescribeGatewayOutput {
	s.GatewayArn = &v
	return s
}

// SetGatewayCapabilitySummaries sets the GatewayCapabilitySummaries field's value.
func (s *DescribeGatewayOutput) SetGatewayCapabilitySummaries(v []*GatewayCapabilitySummary) *DescribeGatewayOutput {
	s.GatewayCapabilitySummaries = v
	return s
}

// SetGatewayId sets the GatewayId field's value.
func (s *DescribeGatewayOutput) SetGatewayId(v string) *DescribeGatewayOutput {
	s.GatewayId = &v
	return s
}

// SetGatewayName sets the GatewayName field's value.
func (s *DescribeGatewayOutput) SetGatewayName(v string) *DescribeGatewayOutput {
	s.GatewayName = &v
	return s
}

// SetGatewayPlatform sets the GatewayPlatform field's value.
func (s *DescribeGatewayOutput) SetGatewayPlatform(v *GatewayPlatform) *DescribeGatewayOutput {
	s.GatewayPlatform = v
	return s
}

// SetLastUpdateDate sets the LastUpdateDate field's value.
func (s *DescribeGatewayOutput) SetLastUpdateDate(v time.Time) *DescribeGatewayOutput {
	s.LastUpdateDate = &v
	return s
}

type DescribeLoggingOptionsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeLoggingOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoggingOptionsInput) GoString() string {
	return s.String()
}

type DescribeLoggingOptionsOutput struct {
	_ struct{} `type:"structure"`

	// The current logging options.
	//
	// LoggingOptions is a required field
	LoggingOptions *LoggingOptions `locationName:"loggingOptions" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeLoggingOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoggingOptionsOutput) GoString() string {
	return s.String()
}

// SetLoggingOptions sets the LoggingOptions field's value.
func (s *DescribeLoggingOptionsOutput) SetLoggingOptions(v *LoggingOptions) *DescribeLoggingOptionsOutput {
	s.LoggingOptions = v
	return s
}

type DescribePortalInput struct {
	_ struct{} `type:"structure"`

	// The ID of the portal.
	//
	// PortalId is a required field
	PortalId *string `location:"uri" locationName:"portalId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribePortalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePortalInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePortalInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePortalInput"}
	if s.PortalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalId"))
	}
	if s.PortalId != nil && len(*s.PortalId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PortalId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPortalId sets the PortalId field's value.
func (s *DescribePortalInput) SetPortalId(v string) *DescribePortalInput {
	s.PortalId = &v
	return s
}

type DescribePortalOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the portal, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}
	//
	// PortalArn is a required field
	PortalArn *string `locationName:"portalArn" min:"1" type:"string" required:"true"`

	// The AWS SSO application generated client ID (used with AWS SSO APIs).
	//
	// PortalClientId is a required field
	PortalClientId *string `locationName:"portalClientId" min:"1" type:"string" required:"true"`

	// The AWS administrator's contact email address.
	//
	// PortalContactEmail is a required field
	PortalContactEmail *string `locationName:"portalContactEmail" min:"1" type:"string" required:"true"`

	// The date the portal was created, in Unix epoch time.
	//
	// PortalCreationDate is a required field
	PortalCreationDate *time.Time `locationName:"portalCreationDate" type:"timestamp" required:"true"`

	// The portal's description.
	PortalDescription *string `locationName:"portalDescription" min:"1" type:"string"`

	// The ID of the portal.
	//
	// PortalId is a required field
	PortalId *string `locationName:"portalId" min:"36" type:"string" required:"true"`

	// The date the portal was last updated, in Unix epoch time.
	//
	// PortalLastUpdateDate is a required field
	PortalLastUpdateDate *time.Time `locationName:"portalLastUpdateDate" type:"timestamp" required:"true"`

	// The portal's logo image, which is available at a URL.
	PortalLogoImageLocation *ImageLocation `locationName:"portalLogoImageLocation" type:"structure"`

	// The name of the portal.
	//
	// PortalName is a required field
	PortalName *string `locationName:"portalName" min:"1" type:"string" required:"true"`

	// The public root URL for the AWS IoT AWS IoT SiteWise Monitor application
	// portal.
	//
	// PortalStartUrl is a required field
	PortalStartUrl *string `locationName:"portalStartUrl" min:"1" type:"string" required:"true"`

	// The current status of the portal, which contains a state and any error message.
	//
	// PortalStatus is a required field
	PortalStatus *PortalStatus `locationName:"portalStatus" type:"structure" required:"true"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the service role that allows the portal's users to access your AWS IoT
	// SiteWise resources on your behalf. For more information, see Using service
	// roles for AWS IoT SiteWise Monitor (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html)
	// in the AWS IoT SiteWise User Guide.
	RoleArn *string `locationName:"roleArn" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribePortalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePortalOutput) GoString() string {
	return s.String()
}

// SetPortalArn sets the PortalArn field's value.
func (s *DescribePortalOutput) SetPortalArn(v string) *DescribePortalOutput {
	s.PortalArn = &v
	return s
}

// SetPortalClientId sets the PortalClientId field's value.
func (s *DescribePortalOutput) SetPortalClientId(v string) *DescribePortalOutput {
	s.PortalClientId = &v
	return s
}

// SetPortalContactEmail sets the PortalContactEmail field's value.
func (s *DescribePortalOutput) SetPortalContactEmail(v string) *DescribePortalOutput {
	s.PortalContactEmail = &v
	return s
}

// SetPortalCreationDate sets the PortalCreationDate field's value.
func (s *DescribePortalOutput) SetPortalCreationDate(v time.Time) *DescribePortalOutput {
	s.PortalCreationDate = &v
	return s
}

// SetPortalDescription sets the PortalDescription field's value.
func (s *DescribePortalOutput) SetPortalDescription(v string) *DescribePortalOutput {
	s.PortalDescription = &v
	return s
}

// SetPortalId sets the PortalId field's value.
func (s *DescribePortalOutput) SetPortalId(v string) *DescribePortalOutput {
	s.PortalId = &v
	return s
}

// SetPortalLastUpdateDate sets the PortalLastUpdateDate field's value.
func (s *DescribePortalOutput) SetPortalLastUpdateDate(v time.Time) *DescribePortalOutput {
	s.PortalLastUpdateDate = &v
	return s
}

// SetPortalLogoImageLocation sets the PortalLogoImageLocation field's value.
func (s *DescribePortalOutput) SetPortalLogoImageLocation(v *ImageLocation) *DescribePortalOutput {
	s.PortalLogoImageLocation = v
	return s
}

// SetPortalName sets the PortalName field's value.
func (s *DescribePortalOutput) SetPortalName(v string) *DescribePortalOutput {
	s.PortalName = &v
	return s
}

// SetPortalStartUrl sets the PortalStartUrl field's value.
func (s *DescribePortalOutput) SetPortalStartUrl(v string) *DescribePortalOutput {
	s.PortalStartUrl = &v
	return s
}

// SetPortalStatus sets the PortalStatus field's value.
func (s *DescribePortalOutput) SetPortalStatus(v *PortalStatus) *DescribePortalOutput {
	s.PortalStatus = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribePortalOutput) SetRoleArn(v string) *DescribePortalOutput {
	s.RoleArn = &v
	return s
}

type DescribeProjectInput struct {
	_ struct{} `type:"structure"`

	// The ID of the project.
	//
	// ProjectId is a required field
	ProjectId *string `location:"uri" locationName:"projectId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeProjectInput"}
	if s.ProjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProjectId sets the ProjectId field's value.
func (s *DescribeProjectInput) SetProjectId(v string) *DescribeProjectInput {
	s.ProjectId = &v
	return s
}

type DescribeProjectOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the portal that the project is in.
	//
	// PortalId is a required field
	PortalId *string `locationName:"portalId" min:"36" type:"string" required:"true"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the project, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:project/${ProjectId}
	//
	// ProjectArn is a required field
	ProjectArn *string `locationName:"projectArn" min:"1" type:"string" required:"true"`

	// The date the project was created, in Unix epoch time.
	//
	// ProjectCreationDate is a required field
	ProjectCreationDate *time.Time `locationName:"projectCreationDate" type:"timestamp" required:"true"`

	// The project's description.
	ProjectDescription *string `locationName:"projectDescription" min:"1" type:"string"`

	// The ID of the project.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" min:"36" type:"string" required:"true"`

	// The date the project was last updated, in Unix epoch time.
	//
	// ProjectLastUpdateDate is a required field
	ProjectLastUpdateDate *time.Time `locationName:"projectLastUpdateDate" type:"timestamp" required:"true"`

	// The name of the project.
	//
	// ProjectName is a required field
	ProjectName *string `locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProjectOutput) GoString() string {
	return s.String()
}

// SetPortalId sets the PortalId field's value.
func (s *DescribeProjectOutput) SetPortalId(v string) *DescribeProjectOutput {
	s.PortalId = &v
	return s
}

// SetProjectArn sets the ProjectArn field's value.
func (s *DescribeProjectOutput) SetProjectArn(v string) *DescribeProjectOutput {
	s.ProjectArn = &v
	return s
}

// SetProjectCreationDate sets the ProjectCreationDate field's value.
func (s *DescribeProjectOutput) SetProjectCreationDate(v time.Time) *DescribeProjectOutput {
	s.ProjectCreationDate = &v
	return s
}

// SetProjectDescription sets the ProjectDescription field's value.
func (s *DescribeProjectOutput) SetProjectDescription(v string) *DescribeProjectOutput {
	s.ProjectDescription = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *DescribeProjectOutput) SetProjectId(v string) *DescribeProjectOutput {
	s.ProjectId = &v
	return s
}

// SetProjectLastUpdateDate sets the ProjectLastUpdateDate field's value.
func (s *DescribeProjectOutput) SetProjectLastUpdateDate(v time.Time) *DescribeProjectOutput {
	s.ProjectLastUpdateDate = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *DescribeProjectOutput) SetProjectName(v string) *DescribeProjectOutput {
	s.ProjectName = &v
	return s
}

type DisassociateAssetsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the parent asset from which to disassociate the child asset.
	//
	// AssetId is a required field
	AssetId *string `location:"uri" locationName:"assetId" min:"36" type:"string" required:"true"`

	// The ID of the child asset to disassociate.
	//
	// ChildAssetId is a required field
	ChildAssetId *string `locationName:"childAssetId" min:"36" type:"string" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The ID of a hierarchy in the parent asset's model. Hierarchies allow different
	// groupings of assets to be formed that all come from the same asset model.
	// You can use the hierarchy ID to identify the correct asset to disassociate.
	// For more information, see Asset Hierarchies (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html)
	// in the AWS IoT SiteWise User Guide.
	//
	// HierarchyId is a required field
	HierarchyId *string `locationName:"hierarchyId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateAssetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateAssetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateAssetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateAssetsInput"}
	if s.AssetId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetId"))
	}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.ChildAssetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChildAssetId"))
	}
	if s.ChildAssetId != nil && len(*s.ChildAssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ChildAssetId", 36))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.HierarchyId == nil {
		invalidParams.Add(request.NewErrParamRequired("HierarchyId"))
	}
	if s.HierarchyId != nil && len(*s.HierarchyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("HierarchyId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *DisassociateAssetsInput) SetAssetId(v string) *DisassociateAssetsInput {
	s.AssetId = &v
	return s
}

// SetChildAssetId sets the ChildAssetId field's value.
func (s *DisassociateAssetsInput) SetChildAssetId(v string) *DisassociateAssetsInput {
	s.ChildAssetId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *DisassociateAssetsInput) SetClientToken(v string) *DisassociateAssetsInput {
	s.ClientToken = &v
	return s
}

// SetHierarchyId sets the HierarchyId field's value.
func (s *DisassociateAssetsInput) SetHierarchyId(v string) *DisassociateAssetsInput {
	s.HierarchyId = &v
	return s
}

type DisassociateAssetsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateAssetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateAssetsOutput) GoString() string {
	return s.String()
}

// Contains the details of an AWS IoT SiteWise error.
type ErrorDetails struct {
	_ struct{} `type:"structure"`

	// The error code.
	//
	// Code is a required field
	Code *string `locationName:"code" type:"string" required:"true" enum:"ErrorCode"`

	// The error message.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation
func (s ErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorDetails) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *ErrorDetails) SetCode(v string) *ErrorDetails {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ErrorDetails) SetMessage(v string) *ErrorDetails {
	s.Message = &v
	return s
}

// Contains expression variable information.
type ExpressionVariable struct {
	_ struct{} `type:"structure"`

	// The friendly name of the variable to be used in the expression.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The variable that identifies an asset property from which to use values.
	//
	// Value is a required field
	Value *VariableValue `locationName:"value" type:"structure" required:"true"`
}

// String returns the string representation
func (s ExpressionVariable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExpressionVariable) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExpressionVariable) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExpressionVariable"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil {
		if err := s.Value.Validate(); err != nil {
			invalidParams.AddNested("Value", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ExpressionVariable) SetName(v string) *ExpressionVariable {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ExpressionVariable) SetValue(v *VariableValue) *ExpressionVariable {
	s.Value = v
	return s
}

// Contains a summary of a gateway capability configuration.
type GatewayCapabilitySummary struct {
	_ struct{} `type:"structure"`

	// The namespace of the capability configuration. For example, if you configure
	// OPC-UA sources from the AWS IoT SiteWise console, your OPC-UA capability
	// configuration has the namespace iotsitewise:opcuacollector:version, where
	// version is a number such as 1.
	//
	// CapabilityNamespace is a required field
	CapabilityNamespace *string `locationName:"capabilityNamespace" min:"1" type:"string" required:"true"`

	// The synchronization status of the capability configuration. The sync status
	// can be one of the following:
	//
	//    * IN_SYNC – The gateway is running the capability configuration.
	//
	//    * OUT_OF_SYNC – The gateway hasn't received the capability configuration.
	//
	//    * SYNC_FAILED – The gateway rejected the capability configuration.
	//
	// CapabilitySyncStatus is a required field
	CapabilitySyncStatus *string `locationName:"capabilitySyncStatus" type:"string" required:"true" enum:"CapabilitySyncStatus"`
}

// String returns the string representation
func (s GatewayCapabilitySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GatewayCapabilitySummary) GoString() string {
	return s.String()
}

// SetCapabilityNamespace sets the CapabilityNamespace field's value.
func (s *GatewayCapabilitySummary) SetCapabilityNamespace(v string) *GatewayCapabilitySummary {
	s.CapabilityNamespace = &v
	return s
}

// SetCapabilitySyncStatus sets the CapabilitySyncStatus field's value.
func (s *GatewayCapabilitySummary) SetCapabilitySyncStatus(v string) *GatewayCapabilitySummary {
	s.CapabilitySyncStatus = &v
	return s
}

// Contains a gateway's platform information.
type GatewayPlatform struct {
	_ struct{} `type:"structure"`

	// A gateway that runs on AWS IoT Greengrass.
	//
	// Greengrass is a required field
	Greengrass *Greengrass `locationName:"greengrass" type:"structure" required:"true"`
}

// String returns the string representation
func (s GatewayPlatform) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GatewayPlatform) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GatewayPlatform) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GatewayPlatform"}
	if s.Greengrass == nil {
		invalidParams.Add(request.NewErrParamRequired("Greengrass"))
	}
	if s.Greengrass != nil {
		if err := s.Greengrass.Validate(); err != nil {
			invalidParams.AddNested("Greengrass", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGreengrass sets the Greengrass field's value.
func (s *GatewayPlatform) SetGreengrass(v *Greengrass) *GatewayPlatform {
	s.Greengrass = v
	return s
}

// Contains a summary of a gateway.
type GatewaySummary struct {
	_ struct{} `type:"structure"`

	// The date the gateway was created, in Unix epoch time.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" required:"true"`

	// A list of gateway capability summaries that each contain a namespace and
	// status. Each gateway capability defines data sources for the gateway. To
	// retrieve a capability configuration's definition, use DescribeGatewayCapabilityConfiguration
	// (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html).
	GatewayCapabilitySummaries []*GatewayCapabilitySummary `locationName:"gatewayCapabilitySummaries" type:"list"`

	// The ID of the gateway device.
	//
	// GatewayId is a required field
	GatewayId *string `locationName:"gatewayId" min:"36" type:"string" required:"true"`

	// The name of the asset.
	//
	// GatewayName is a required field
	GatewayName *string `locationName:"gatewayName" min:"1" type:"string" required:"true"`

	// The date the gateway was last updated, in Unix epoch time.
	//
	// LastUpdateDate is a required field
	LastUpdateDate *time.Time `locationName:"lastUpdateDate" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s GatewaySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GatewaySummary) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *GatewaySummary) SetCreationDate(v time.Time) *GatewaySummary {
	s.CreationDate = &v
	return s
}

// SetGatewayCapabilitySummaries sets the GatewayCapabilitySummaries field's value.
func (s *GatewaySummary) SetGatewayCapabilitySummaries(v []*GatewayCapabilitySummary) *GatewaySummary {
	s.GatewayCapabilitySummaries = v
	return s
}

// SetGatewayId sets the GatewayId field's value.
func (s *GatewaySummary) SetGatewayId(v string) *GatewaySummary {
	s.GatewayId = &v
	return s
}

// SetGatewayName sets the GatewayName field's value.
func (s *GatewaySummary) SetGatewayName(v string) *GatewaySummary {
	s.GatewayName = &v
	return s
}

// SetLastUpdateDate sets the LastUpdateDate field's value.
func (s *GatewaySummary) SetLastUpdateDate(v time.Time) *GatewaySummary {
	s.LastUpdateDate = &v
	return s
}

type GetAssetPropertyAggregatesInput struct {
	_ struct{} `type:"structure"`

	// The data aggregating function.
	//
	// AggregateTypes is a required field
	AggregateTypes []*string `location:"querystring" locationName:"aggregateTypes" min:"1" type:"list" required:"true"`

	// The ID of the asset.
	AssetId *string `location:"querystring" locationName:"assetId" min:"36" type:"string"`

	// The inclusive end of the range from which to query historical data, expressed
	// in seconds in Unix epoch time.
	//
	// EndDate is a required field
	EndDate *time.Time `location:"querystring" locationName:"endDate" type:"timestamp" required:"true"`

	// The maximum number of results to be returned per paginated request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The property alias that identifies the property, such as an OPC-UA server
	// data stream path (for example, /company/windfarm/3/turbine/7/temperature).
	// For more information, see Mapping Industrial Data Streams to Asset Properties
	// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html)
	// in the AWS IoT SiteWise User Guide.
	PropertyAlias *string `location:"querystring" locationName:"propertyAlias" min:"1" type:"string"`

	// The ID of the asset property.
	PropertyId *string `location:"querystring" locationName:"propertyId" min:"36" type:"string"`

	// The quality by which to filter asset data.
	Qualities []*string `location:"querystring" locationName:"qualities" min:"1" type:"list"`

	// The time interval over which to aggregate data.
	//
	// Resolution is a required field
	Resolution *string `location:"querystring" locationName:"resolution" min:"2" type:"string" required:"true"`

	// The exclusive start of the range from which to query historical data, expressed
	// in seconds in Unix epoch time.
	//
	// StartDate is a required field
	StartDate *time.Time `location:"querystring" locationName:"startDate" type:"timestamp" required:"true"`

	// The chronological sorting order of the requested information.
	TimeOrdering *string `location:"querystring" locationName:"timeOrdering" type:"string" enum:"TimeOrdering"`
}

// String returns the string representation
func (s GetAssetPropertyAggregatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAssetPropertyAggregatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAssetPropertyAggregatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAssetPropertyAggregatesInput"}
	if s.AggregateTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("AggregateTypes"))
	}
	if s.AggregateTypes != nil && len(s.AggregateTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AggregateTypes", 1))
	}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.EndDate == nil {
		invalidParams.Add(request.NewErrParamRequired("EndDate"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PropertyAlias != nil && len(*s.PropertyAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyAlias", 1))
	}
	if s.PropertyId != nil && len(*s.PropertyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyId", 36))
	}
	if s.Qualities != nil && len(s.Qualities) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualities", 1))
	}
	if s.Resolution == nil {
		invalidParams.Add(request.NewErrParamRequired("Resolution"))
	}
	if s.Resolution != nil && len(*s.Resolution) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Resolution", 2))
	}
	if s.StartDate == nil {
		invalidParams.Add(request.NewErrParamRequired("StartDate"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAggregateTypes sets the AggregateTypes field's value.
func (s *GetAssetPropertyAggregatesInput) SetAggregateTypes(v []*string) *GetAssetPropertyAggregatesInput {
	s.AggregateTypes = v
	return s
}

// SetAssetId sets the AssetId field's value.
func (s *GetAssetPropertyAggregatesInput) SetAssetId(v string) *GetAssetPropertyAggregatesInput {
	s.AssetId = &v
	return s
}

// SetEndDate sets the EndDate field's value.
func (s *GetAssetPropertyAggregatesInput) SetEndDate(v time.Time) *GetAssetPropertyAggregatesInput {
	s.EndDate = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetAssetPropertyAggregatesInput) SetMaxResults(v int64) *GetAssetPropertyAggregatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAssetPropertyAggregatesInput) SetNextToken(v string) *GetAssetPropertyAggregatesInput {
	s.NextToken = &v
	return s
}

// SetPropertyAlias sets the PropertyAlias field's value.
func (s *GetAssetPropertyAggregatesInput) SetPropertyAlias(v string) *GetAssetPropertyAggregatesInput {
	s.PropertyAlias = &v
	return s
}

// SetPropertyId sets the PropertyId field's value.
func (s *GetAssetPropertyAggregatesInput) SetPropertyId(v string) *GetAssetPropertyAggregatesInput {
	s.PropertyId = &v
	return s
}

// SetQualities sets the Qualities field's value.
func (s *GetAssetPropertyAggregatesInput) SetQualities(v []*string) *GetAssetPropertyAggregatesInput {
	s.Qualities = v
	return s
}

// SetResolution sets the Resolution field's value.
func (s *GetAssetPropertyAggregatesInput) SetResolution(v string) *GetAssetPropertyAggregatesInput {
	s.Resolution = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *GetAssetPropertyAggregatesInput) SetStartDate(v time.Time) *GetAssetPropertyAggregatesInput {
	s.StartDate = &v
	return s
}

// SetTimeOrdering sets the TimeOrdering field's value.
func (s *GetAssetPropertyAggregatesInput) SetTimeOrdering(v string) *GetAssetPropertyAggregatesInput {
	s.TimeOrdering = &v
	return s
}

type GetAssetPropertyAggregatesOutput struct {
	_ struct{} `type:"structure"`

	// The requested aggregated values.
	//
	// AggregatedValues is a required field
	AggregatedValues []*AggregatedValue `locationName:"aggregatedValues" type:"list" required:"true"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s GetAssetPropertyAggregatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAssetPropertyAggregatesOutput) GoString() string {
	return s.String()
}

// SetAggregatedValues sets the AggregatedValues field's value.
func (s *GetAssetPropertyAggregatesOutput) SetAggregatedValues(v []*AggregatedValue) *GetAssetPropertyAggregatesOutput {
	s.AggregatedValues = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAssetPropertyAggregatesOutput) SetNextToken(v string) *GetAssetPropertyAggregatesOutput {
	s.NextToken = &v
	return s
}

type GetAssetPropertyValueHistoryInput struct {
	_ struct{} `type:"structure"`

	// The ID of the asset.
	AssetId *string `location:"querystring" locationName:"assetId" min:"36" type:"string"`

	// The inclusive end of the range from which to query historical data, expressed
	// in seconds in Unix epoch time.
	EndDate *time.Time `location:"querystring" locationName:"endDate" type:"timestamp"`

	// The maximum number of results to be returned per paginated request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The property alias that identifies the property, such as an OPC-UA server
	// data stream path (for example, /company/windfarm/3/turbine/7/temperature).
	// For more information, see Mapping Industrial Data Streams to Asset Properties
	// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html)
	// in the AWS IoT SiteWise User Guide.
	PropertyAlias *string `location:"querystring" locationName:"propertyAlias" min:"1" type:"string"`

	// The ID of the asset property.
	PropertyId *string `location:"querystring" locationName:"propertyId" min:"36" type:"string"`

	// The quality by which to filter asset data.
	Qualities []*string `location:"querystring" locationName:"qualities" min:"1" type:"list"`

	// The exclusive start of the range from which to query historical data, expressed
	// in seconds in Unix epoch time.
	StartDate *time.Time `location:"querystring" locationName:"startDate" type:"timestamp"`

	// The chronological sorting order of the requested information.
	TimeOrdering *string `location:"querystring" locationName:"timeOrdering" type:"string" enum:"TimeOrdering"`
}

// String returns the string representation
func (s GetAssetPropertyValueHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAssetPropertyValueHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAssetPropertyValueHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAssetPropertyValueHistoryInput"}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PropertyAlias != nil && len(*s.PropertyAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyAlias", 1))
	}
	if s.PropertyId != nil && len(*s.PropertyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyId", 36))
	}
	if s.Qualities != nil && len(s.Qualities) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualities", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *GetAssetPropertyValueHistoryInput) SetAssetId(v string) *GetAssetPropertyValueHistoryInput {
	s.AssetId = &v
	return s
}

// SetEndDate sets the EndDate field's value.
func (s *GetAssetPropertyValueHistoryInput) SetEndDate(v time.Time) *GetAssetPropertyValueHistoryInput {
	s.EndDate = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetAssetPropertyValueHistoryInput) SetMaxResults(v int64) *GetAssetPropertyValueHistoryInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAssetPropertyValueHistoryInput) SetNextToken(v string) *GetAssetPropertyValueHistoryInput {
	s.NextToken = &v
	return s
}

// SetPropertyAlias sets the PropertyAlias field's value.
func (s *GetAssetPropertyValueHistoryInput) SetPropertyAlias(v string) *GetAssetPropertyValueHistoryInput {
	s.PropertyAlias = &v
	return s
}

// SetPropertyId sets the PropertyId field's value.
func (s *GetAssetPropertyValueHistoryInput) SetPropertyId(v string) *GetAssetPropertyValueHistoryInput {
	s.PropertyId = &v
	return s
}

// SetQualities sets the Qualities field's value.
func (s *GetAssetPropertyValueHistoryInput) SetQualities(v []*string) *GetAssetPropertyValueHistoryInput {
	s.Qualities = v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *GetAssetPropertyValueHistoryInput) SetStartDate(v time.Time) *GetAssetPropertyValueHistoryInput {
	s.StartDate = &v
	return s
}

// SetTimeOrdering sets the TimeOrdering field's value.
func (s *GetAssetPropertyValueHistoryInput) SetTimeOrdering(v string) *GetAssetPropertyValueHistoryInput {
	s.TimeOrdering = &v
	return s
}

type GetAssetPropertyValueHistoryOutput struct {
	_ struct{} `type:"structure"`

	// The asset property's value history.
	//
	// AssetPropertyValueHistory is a required field
	AssetPropertyValueHistory []*AssetPropertyValue `locationName:"assetPropertyValueHistory" type:"list" required:"true"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s GetAssetPropertyValueHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAssetPropertyValueHistoryOutput) GoString() string {
	return s.String()
}

// SetAssetPropertyValueHistory sets the AssetPropertyValueHistory field's value.
func (s *GetAssetPropertyValueHistoryOutput) SetAssetPropertyValueHistory(v []*AssetPropertyValue) *GetAssetPropertyValueHistoryOutput {
	s.AssetPropertyValueHistory = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAssetPropertyValueHistoryOutput) SetNextToken(v string) *GetAssetPropertyValueHistoryOutput {
	s.NextToken = &v
	return s
}

type GetAssetPropertyValueInput struct {
	_ struct{} `type:"structure"`

	// The ID of the asset.
	AssetId *string `location:"querystring" locationName:"assetId" min:"36" type:"string"`

	// The property alias that identifies the property, such as an OPC-UA server
	// data stream path (for example, /company/windfarm/3/turbine/7/temperature).
	// For more information, see Mapping Industrial Data Streams to Asset Properties
	// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html)
	// in the AWS IoT SiteWise User Guide.
	PropertyAlias *string `location:"querystring" locationName:"propertyAlias" min:"1" type:"string"`

	// The ID of the asset property.
	PropertyId *string `location:"querystring" locationName:"propertyId" min:"36" type:"string"`
}

// String returns the string representation
func (s GetAssetPropertyValueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAssetPropertyValueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAssetPropertyValueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAssetPropertyValueInput"}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.PropertyAlias != nil && len(*s.PropertyAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyAlias", 1))
	}
	if s.PropertyId != nil && len(*s.PropertyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *GetAssetPropertyValueInput) SetAssetId(v string) *GetAssetPropertyValueInput {
	s.AssetId = &v
	return s
}

// SetPropertyAlias sets the PropertyAlias field's value.
func (s *GetAssetPropertyValueInput) SetPropertyAlias(v string) *GetAssetPropertyValueInput {
	s.PropertyAlias = &v
	return s
}

// SetPropertyId sets the PropertyId field's value.
func (s *GetAssetPropertyValueInput) SetPropertyId(v string) *GetAssetPropertyValueInput {
	s.PropertyId = &v
	return s
}

type GetAssetPropertyValueOutput struct {
	_ struct{} `type:"structure"`

	// The current asset property value.
	PropertyValue *AssetPropertyValue `locationName:"propertyValue" type:"structure"`
}

// String returns the string representation
func (s GetAssetPropertyValueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAssetPropertyValueOutput) GoString() string {
	return s.String()
}

// SetPropertyValue sets the PropertyValue field's value.
func (s *GetAssetPropertyValueOutput) SetPropertyValue(v *AssetPropertyValue) *GetAssetPropertyValueOutput {
	s.PropertyValue = v
	return s
}

// Contains details for a gateway that runs on AWS IoT Greengrass. To create
// a gateway that runs on AWS IoT Greengrass, you must add the IoT SiteWise
// connector to a Greengrass group and deploy it. Your Greengrass group must
// also have permissions to upload data to AWS IoT SiteWise. For more information,
// see Ingesting data using a gateway (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/gateway-connector.html)
// in the AWS IoT SiteWise User Guide.
type Greengrass struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the Greengrass group. For more information about how to find a group's
	// ARN, see ListGroups (https://docs.aws.amazon.com/greengrass/latest/apireference/listgroups-get.html)
	// and GetGroup (https://docs.aws.amazon.com/greengrass/latest/apireference/getgroup-get.html)
	// in the AWS IoT Greengrass API Reference.
	//
	// GroupArn is a required field
	GroupArn *string `locationName:"groupArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Greengrass) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Greengrass) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Greengrass) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Greengrass"}
	if s.GroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupArn"))
	}
	if s.GroupArn != nil && len(*s.GroupArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupArn sets the GroupArn field's value.
func (s *Greengrass) SetGroupArn(v string) *Greengrass {
	s.GroupArn = &v
	return s
}

// Contains information for a group identity in an access policy.
type GroupIdentity struct {
	_ struct{} `type:"structure"`

	// The AWS SSO ID of the group.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GroupIdentity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupIdentity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GroupIdentity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GroupIdentity"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GroupIdentity) SetId(v string) *GroupIdentity {
	s.Id = &v
	return s
}

// Contains an AWS SSO identity ID for a user or group.
//
// Currently, you can't use AWS APIs to retrieve AWS SSO identity IDs. You can
// find the AWS SSO identity IDs in the URL of user and group pages in the AWS
// SSO console (https://console.aws.amazon.com/singlesignon).
type Identity struct {
	_ struct{} `type:"structure"`

	// A group identity.
	Group *GroupIdentity `locationName:"group" type:"structure"`

	// A user identity.
	User *UserIdentity `locationName:"user" type:"structure"`
}

// String returns the string representation
func (s Identity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Identity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Identity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Identity"}
	if s.Group != nil {
		if err := s.Group.Validate(); err != nil {
			invalidParams.AddNested("Group", err.(request.ErrInvalidParams))
		}
	}
	if s.User != nil {
		if err := s.User.Validate(); err != nil {
			invalidParams.AddNested("User", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroup sets the Group field's value.
func (s *Identity) SetGroup(v *GroupIdentity) *Identity {
	s.Group = v
	return s
}

// SetUser sets the User field's value.
func (s *Identity) SetUser(v *UserIdentity) *Identity {
	s.User = v
	return s
}

// Contains an image that is one of the following:
//
//    * An image file. Choose this option to upload a new image.
//
//    * The ID of an existing image. Choose this option to keep an existing
//    image.
type Image struct {
	_ struct{} `type:"structure"`

	// Contains an image file.
	File *ImageFile `locationName:"file" type:"structure"`

	// The ID of an existing image. Specify this parameter to keep an existing image.
	Id *string `locationName:"id" min:"36" type:"string"`
}

// String returns the string representation
func (s Image) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Image) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Image) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Image"}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 36))
	}
	if s.File != nil {
		if err := s.File.Validate(); err != nil {
			invalidParams.AddNested("File", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFile sets the File field's value.
func (s *Image) SetFile(v *ImageFile) *Image {
	s.File = v
	return s
}

// SetId sets the Id field's value.
func (s *Image) SetId(v string) *Image {
	s.Id = &v
	return s
}

// Contains an image file.
type ImageFile struct {
	_ struct{} `type:"structure"`

	// The image file contents, represented as a base64-encoded string. The file
	// size must be less than 1 MB.
	//
	// Data is automatically base64 encoded/decoded by the SDK.
	//
	// Data is a required field
	Data []byte `locationName:"data" min:"1" type:"blob" required:"true"`

	// The file type of the image.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"ImageFileType"`
}

// String returns the string representation
func (s ImageFile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImageFile) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImageFile) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImageFile"}
	if s.Data == nil {
		invalidParams.Add(request.NewErrParamRequired("Data"))
	}
	if s.Data != nil && len(s.Data) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Data", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetData sets the Data field's value.
func (s *ImageFile) SetData(v []byte) *ImageFile {
	s.Data = v
	return s
}

// SetType sets the Type field's value.
func (s *ImageFile) SetType(v string) *ImageFile {
	s.Type = &v
	return s
}

// Contains an image that is uploaded to AWS IoT SiteWise and available at a
// URL.
type ImageLocation struct {
	_ struct{} `type:"structure"`

	// The ID of the image.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The URL where the image is available. The URL is valid for 15 minutes so
	// that you can view and download the image
	//
	// Url is a required field
	Url *string `locationName:"url" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ImageLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImageLocation) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *ImageLocation) SetId(v string) *ImageLocation {
	s.Id = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *ImageLocation) SetUrl(v string) *ImageLocation {
	s.Url = &v
	return s
}

// AWS IoT SiteWise can't process your request right now. Try again later.
type InternalFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalFailureException) GoString() string {
	return s.String()
}

func newErrorInternalFailureException(v protocol.ResponseMetadata) error {
	return &InternalFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalFailureException) Code() string {
	return "InternalFailureException"
}

// Message returns the exception's message.
func (s *InternalFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalFailureException) OrigErr() error {
	return nil
}

func (s *InternalFailureException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request isn't valid. This can occur if your request contains malformed
// JSON or unsupported characters. Check your request and try again.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You've reached the limit for a resource. For example, this can occur if you're
// trying to associate more than the allowed number of child assets or attempting
// to create more than the allowed number of properties for an asset model.
//
// For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
// in the AWS IoT SiteWise User Guide.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAccessPoliciesInput struct {
	_ struct{} `type:"structure"`

	// The ID of the identity. This parameter is required if you specify identityType.
	IdentityId *string `location:"querystring" locationName:"identityId" min:"1" type:"string"`

	// The type of identity (user or group). This parameter is required if you specify
	// identityId.
	IdentityType *string `location:"querystring" locationName:"identityType" type:"string" enum:"IdentityType"`

	// The maximum number of results to be returned per paginated request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The ID of the resource. This parameter is required if you specify resourceType.
	ResourceId *string `location:"querystring" locationName:"resourceId" min:"36" type:"string"`

	// The type of resource (portal or project). This parameter is required if you
	// specify resourceId.
	ResourceType *string `location:"querystring" locationName:"resourceType" type:"string" enum:"ResourceType"`
}

// String returns the string representation
func (s ListAccessPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccessPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccessPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccessPoliciesInput"}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityId sets the IdentityId field's value.
func (s *ListAccessPoliciesInput) SetIdentityId(v string) *ListAccessPoliciesInput {
	s.IdentityId = &v
	return s
}

// SetIdentityType sets the IdentityType field's value.
func (s *ListAccessPoliciesInput) SetIdentityType(v string) *ListAccessPoliciesInput {
	s.IdentityType = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccessPoliciesInput) SetMaxResults(v int64) *ListAccessPoliciesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessPoliciesInput) SetNextToken(v string) *ListAccessPoliciesInput {
	s.NextToken = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ListAccessPoliciesInput) SetResourceId(v string) *ListAccessPoliciesInput {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ListAccessPoliciesInput) SetResourceType(v string) *ListAccessPoliciesInput {
	s.ResourceType = &v
	return s
}

type ListAccessPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// A list that summarizes each access policy.
	//
	// AccessPolicySummaries is a required field
	AccessPolicySummaries []*AccessPolicySummary `locationName:"accessPolicySummaries" type:"list" required:"true"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAccessPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccessPoliciesOutput) GoString() string {
	return s.String()
}

// SetAccessPolicySummaries sets the AccessPolicySummaries field's value.
func (s *ListAccessPoliciesOutput) SetAccessPolicySummaries(v []*AccessPolicySummary) *ListAccessPoliciesOutput {
	s.AccessPolicySummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessPoliciesOutput) SetNextToken(v string) *ListAccessPoliciesOutput {
	s.NextToken = &v
	return s
}

type ListAssetModelsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be returned per paginated request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssetModelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssetModelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssetModelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssetModelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAssetModelsInput) SetMaxResults(v int64) *ListAssetModelsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssetModelsInput) SetNextToken(v string) *ListAssetModelsInput {
	s.NextToken = &v
	return s
}

type ListAssetModelsOutput struct {
	_ struct{} `type:"structure"`

	// A list that summarizes each asset model.
	//
	// AssetModelSummaries is a required field
	AssetModelSummaries []*AssetModelSummary `locationName:"assetModelSummaries" type:"list" required:"true"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssetModelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssetModelsOutput) GoString() string {
	return s.String()
}

// SetAssetModelSummaries sets the AssetModelSummaries field's value.
func (s *ListAssetModelsOutput) SetAssetModelSummaries(v []*AssetModelSummary) *ListAssetModelsOutput {
	s.AssetModelSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssetModelsOutput) SetNextToken(v string) *ListAssetModelsOutput {
	s.NextToken = &v
	return s
}

type ListAssetsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the asset model by which to filter the list of assets. This parameter
	// is required if you choose ALL for filter.
	AssetModelId *string `location:"querystring" locationName:"assetModelId" min:"36" type:"string"`

	// The filter for the requested list of assets. Choose one of the following
	// options. Defaults to ALL.
	//
	//    * ALL – The list includes all assets for a given asset model ID. The
	//    assetModelId parameter is required if you filter by ALL.
	//
	//    * TOP_LEVEL – The list includes only top-level assets in the asset hierarchy
	//    tree.
	Filter *string `location:"querystring" locationName:"filter" type:"string" enum:"ListAssetsFilter"`

	// The maximum number of results to be returned per paginated request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssetsInput"}
	if s.AssetModelId != nil && len(*s.AssetModelId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetModelId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetModelId sets the AssetModelId field's value.
func (s *ListAssetsInput) SetAssetModelId(v string) *ListAssetsInput {
	s.AssetModelId = &v
	return s
}

// SetFilter sets the Filter field's value.
func (s *ListAssetsInput) SetFilter(v string) *ListAssetsInput {
	s.Filter = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAssetsInput) SetMaxResults(v int64) *ListAssetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssetsInput) SetNextToken(v string) *ListAssetsInput {
	s.NextToken = &v
	return s
}

type ListAssetsOutput struct {
	_ struct{} `type:"structure"`

	// A list that summarizes each asset.
	//
	// AssetSummaries is a required field
	AssetSummaries []*AssetSummary `locationName:"assetSummaries" type:"list" required:"true"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssetsOutput) GoString() string {
	return s.String()
}

// SetAssetSummaries sets the AssetSummaries field's value.
func (s *ListAssetsOutput) SetAssetSummaries(v []*AssetSummary) *ListAssetsOutput {
	s.AssetSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssetsOutput) SetNextToken(v string) *ListAssetsOutput {
	s.NextToken = &v
	return s
}

type ListAssociatedAssetsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the parent asset.
	//
	// AssetId is a required field
	AssetId *string `location:"uri" locationName:"assetId" min:"36" type:"string" required:"true"`

	// The hierarchy ID (of the parent asset model) whose associated assets are
	// returned. To find a hierarchy ID, use the DescribeAsset (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAsset.html)
	// or DescribeAssetModel (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModel.html)
	// actions.
	//
	// For more information, see Asset Hierarchies (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html)
	// in the AWS IoT SiteWise User Guide.
	//
	// HierarchyId is a required field
	HierarchyId *string `location:"querystring" locationName:"hierarchyId" min:"36" type:"string" required:"true"`

	// The maximum number of results to be returned per paginated request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssociatedAssetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssociatedAssetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssociatedAssetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssociatedAssetsInput"}
	if s.AssetId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetId"))
	}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.HierarchyId == nil {
		invalidParams.Add(request.NewErrParamRequired("HierarchyId"))
	}
	if s.HierarchyId != nil && len(*s.HierarchyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("HierarchyId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *ListAssociatedAssetsInput) SetAssetId(v string) *ListAssociatedAssetsInput {
	s.AssetId = &v
	return s
}

// SetHierarchyId sets the HierarchyId field's value.
func (s *ListAssociatedAssetsInput) SetHierarchyId(v string) *ListAssociatedAssetsInput {
	s.HierarchyId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAssociatedAssetsInput) SetMaxResults(v int64) *ListAssociatedAssetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssociatedAssetsInput) SetNextToken(v string) *ListAssociatedAssetsInput {
	s.NextToken = &v
	return s
}

type ListAssociatedAssetsOutput struct {
	_ struct{} `type:"structure"`

	// A list that summarizes the associated assets.
	//
	// AssetSummaries is a required field
	AssetSummaries []*AssociatedAssetsSummary `locationName:"assetSummaries" type:"list" required:"true"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssociatedAssetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssociatedAssetsOutput) GoString() string {
	return s.String()
}

// SetAssetSummaries sets the AssetSummaries field's value.
func (s *ListAssociatedAssetsOutput) SetAssetSummaries(v []*AssociatedAssetsSummary) *ListAssociatedAssetsOutput {
	s.AssetSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssociatedAssetsOutput) SetNextToken(v string) *ListAssociatedAssetsOutput {
	s.NextToken = &v
	return s
}

type ListDashboardsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be returned per paginated request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The ID of the project.
	//
	// ProjectId is a required field
	ProjectId *string `location:"querystring" locationName:"projectId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s ListDashboardsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDashboardsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDashboardsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDashboardsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ProjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDashboardsInput) SetMaxResults(v int64) *ListDashboardsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDashboardsInput) SetNextToken(v string) *ListDashboardsInput {
	s.NextToken = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *ListDashboardsInput) SetProjectId(v string) *ListDashboardsInput {
	s.ProjectId = &v
	return s
}

type ListDashboardsOutput struct {
	_ struct{} `type:"structure"`

	// A list that summarizes each dashboard in the project.
	//
	// DashboardSummaries is a required field
	DashboardSummaries []*DashboardSummary `locationName:"dashboardSummaries" type:"list" required:"true"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListDashboardsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDashboardsOutput) GoString() string {
	return s.String()
}

// SetDashboardSummaries sets the DashboardSummaries field's value.
func (s *ListDashboardsOutput) SetDashboardSummaries(v []*DashboardSummary) *ListDashboardsOutput {
	s.DashboardSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDashboardsOutput) SetNextToken(v string) *ListDashboardsOutput {
	s.NextToken = &v
	return s
}

type ListGatewaysInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be returned per paginated request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListGatewaysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGatewaysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGatewaysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGatewaysInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGatewaysInput) SetMaxResults(v int64) *ListGatewaysInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGatewaysInput) SetNextToken(v string) *ListGatewaysInput {
	s.NextToken = &v
	return s
}

type ListGatewaysOutput struct {
	_ struct{} `type:"structure"`

	// A list that summarizes each gateway.
	//
	// GatewaySummaries is a required field
	GatewaySummaries []*GatewaySummary `locationName:"gatewaySummaries" type:"list" required:"true"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListGatewaysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGatewaysOutput) GoString() string {
	return s.String()
}

// SetGatewaySummaries sets the GatewaySummaries field's value.
func (s *ListGatewaysOutput) SetGatewaySummaries(v []*GatewaySummary) *ListGatewaysOutput {
	s.GatewaySummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGatewaysOutput) SetNextToken(v string) *ListGatewaysOutput {
	s.NextToken = &v
	return s
}

type ListPortalsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be returned per paginated request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListPortalsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPortalsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPortalsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPortalsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPortalsInput) SetMaxResults(v int64) *ListPortalsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPortalsInput) SetNextToken(v string) *ListPortalsInput {
	s.NextToken = &v
	return s
}

type ListPortalsOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list that summarizes each portal.
	PortalSummaries []*PortalSummary `locationName:"portalSummaries" type:"list"`
}

// String returns the string representation
func (s ListPortalsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPortalsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPortalsOutput) SetNextToken(v string) *ListPortalsOutput {
	s.NextToken = &v
	return s
}

// SetPortalSummaries sets the PortalSummaries field's value.
func (s *ListPortalsOutput) SetPortalSummaries(v []*PortalSummary) *ListPortalsOutput {
	s.PortalSummaries = v
	return s
}

type ListProjectAssetsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be returned per paginated request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The ID of the project.
	//
	// ProjectId is a required field
	ProjectId *string `location:"uri" locationName:"projectId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s ListProjectAssetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProjectAssetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProjectAssetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProjectAssetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ProjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProjectAssetsInput) SetMaxResults(v int64) *ListProjectAssetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectAssetsInput) SetNextToken(v string) *ListProjectAssetsInput {
	s.NextToken = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *ListProjectAssetsInput) SetProjectId(v string) *ListProjectAssetsInput {
	s.ProjectId = &v
	return s
}

type ListProjectAssetsOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains the IDs of each asset associated with the project.
	//
	// AssetIds is a required field
	AssetIds []*string `locationName:"assetIds" type:"list" required:"true"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListProjectAssetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProjectAssetsOutput) GoString() string {
	return s.String()
}

// SetAssetIds sets the AssetIds field's value.
func (s *ListProjectAssetsOutput) SetAssetIds(v []*string) *ListProjectAssetsOutput {
	s.AssetIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectAssetsOutput) SetNextToken(v string) *ListProjectAssetsOutput {
	s.NextToken = &v
	return s
}

type ListProjectsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be returned per paginated request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The ID of the portal.
	//
	// PortalId is a required field
	PortalId *string `location:"querystring" locationName:"portalId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s ListProjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProjectsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PortalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalId"))
	}
	if s.PortalId != nil && len(*s.PortalId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PortalId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProjectsInput) SetMaxResults(v int64) *ListProjectsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectsInput) SetNextToken(v string) *ListProjectsInput {
	s.NextToken = &v
	return s
}

// SetPortalId sets the PortalId field's value.
func (s *ListProjectsInput) SetPortalId(v string) *ListProjectsInput {
	s.PortalId = &v
	return s
}

type ListProjectsOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list that summarizes each project in the portal.
	//
	// ProjectSummaries is a required field
	ProjectSummaries []*ProjectSummary `locationName:"projectSummaries" type:"list" required:"true"`
}

// String returns the string representation
func (s ListProjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProjectsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectsOutput) SetNextToken(v string) *ListProjectsOutput {
	s.NextToken = &v
	return s
}

// SetProjectSummaries sets the ProjectSummaries field's value.
func (s *ListProjectsOutput) SetProjectSummaries(v []*ProjectSummary) *ListProjectsOutput {
	s.ProjectSummaries = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The list of key-value pairs that contain metadata for the resource. For more
	// information, see Tagging your AWS IoT SiteWise resources (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html)
	// in the AWS IoT SiteWise User Guide.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Contains logging options.
type LoggingOptions struct {
	_ struct{} `type:"structure"`

	// The AWS IoT SiteWise logging verbosity level.
	//
	// Level is a required field
	Level *string `locationName:"level" type:"string" required:"true" enum:"LoggingLevel"`
}

// String returns the string representation
func (s LoggingOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoggingOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LoggingOptions"}
	if s.Level == nil {
		invalidParams.Add(request.NewErrParamRequired("Level"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLevel sets the Level field's value.
func (s *LoggingOptions) SetLevel(v string) *LoggingOptions {
	s.Level = &v
	return s
}

// Contains an asset measurement property. This structure is empty. For more
// information, see Measurements (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#measurements)
// in the AWS IoT SiteWise User Guide.
type Measurement struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s Measurement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Measurement) GoString() string {
	return s.String()
}

// Contains an asset metric property. With metrics, you can calculate aggregate
// functions, such as an average, maximum, or minimum, as specified through
// an expression. A metric maps several values to a single value (such as a
// sum).
//
// The maximum number of dependent/cascading variables used in any one metric
// calculation is 10. Therefore, a root metric can have up to 10 cascading metrics
// in its computational dependency tree. Additionally, a metric can only have
// a data type of DOUBLE and consume properties with data types of INTEGER or
// DOUBLE.
//
// For more information, see Metrics (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#metrics)
// in the AWS IoT SiteWise User Guide.
type Metric struct {
	_ struct{} `type:"structure"`

	// The mathematical expression that defines the metric aggregation function.
	// You can specify up to 10 variables per expression. You can specify up to
	// 10 functions per expression.
	//
	// For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
	// in the AWS IoT SiteWise User Guide.
	//
	// Expression is a required field
	Expression *string `locationName:"expression" min:"1" type:"string" required:"true"`

	// The list of variables used in the expression.
	//
	// Variables is a required field
	Variables []*ExpressionVariable `locationName:"variables" type:"list" required:"true"`

	// The window (time interval) over which AWS IoT SiteWise computes the metric's
	// aggregation expression. AWS IoT SiteWise computes one data point per window.
	//
	// Window is a required field
	Window *MetricWindow `locationName:"window" type:"structure" required:"true"`
}

// String returns the string representation
func (s Metric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Metric) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Metric) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Metric"}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}
	if s.Variables == nil {
		invalidParams.Add(request.NewErrParamRequired("Variables"))
	}
	if s.Window == nil {
		invalidParams.Add(request.NewErrParamRequired("Window"))
	}
	if s.Variables != nil {
		for i, v := range s.Variables {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Variables", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Window != nil {
		if err := s.Window.Validate(); err != nil {
			invalidParams.AddNested("Window", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpression sets the Expression field's value.
func (s *Metric) SetExpression(v string) *Metric {
	s.Expression = &v
	return s
}

// SetVariables sets the Variables field's value.
func (s *Metric) SetVariables(v []*ExpressionVariable) *Metric {
	s.Variables = v
	return s
}

// SetWindow sets the Window field's value.
func (s *Metric) SetWindow(v *MetricWindow) *Metric {
	s.Window = v
	return s
}

// Contains a time interval window used for data aggregate computations (for
// example, average, sum, count, and so on).
type MetricWindow struct {
	_ struct{} `type:"structure"`

	// The tumbling time interval window.
	Tumbling *TumblingWindow `locationName:"tumbling" type:"structure"`
}

// String returns the string representation
func (s MetricWindow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricWindow) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricWindow) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricWindow"}
	if s.Tumbling != nil {
		if err := s.Tumbling.Validate(); err != nil {
			invalidParams.AddNested("Tumbling", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTumbling sets the Tumbling field's value.
func (s *MetricWindow) SetTumbling(v *TumblingWindow) *MetricWindow {
	s.Tumbling = v
	return s
}

// Contains AWS IoT SiteWise Monitor error details.
type MonitorErrorDetails struct {
	_ struct{} `type:"structure"`

	// The error code.
	Code *string `locationName:"code" type:"string" enum:"MonitorErrorCode"`

	// The error message.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s MonitorErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MonitorErrorDetails) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *MonitorErrorDetails) SetCode(v string) *MonitorErrorDetails {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *MonitorErrorDetails) SetMessage(v string) *MonitorErrorDetails {
	s.Message = &v
	return s
}

// Identifies an AWS IoT SiteWise Monitor portal.
type PortalResource struct {
	_ struct{} `type:"structure"`

	// The ID of the portal.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s PortalResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PortalResource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PortalResource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PortalResource"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *PortalResource) SetId(v string) *PortalResource {
	s.Id = &v
	return s
}

// Contains information about the current status of a portal.
type PortalStatus struct {
	_ struct{} `type:"structure"`

	// Contains associated error information, if any.
	Error *MonitorErrorDetails `locationName:"error" type:"structure"`

	// The current state of the portal.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"PortalState"`
}

// String returns the string representation
func (s PortalStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PortalStatus) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *PortalStatus) SetError(v *MonitorErrorDetails) *PortalStatus {
	s.Error = v
	return s
}

// SetState sets the State field's value.
func (s *PortalStatus) SetState(v string) *PortalStatus {
	s.State = &v
	return s
}

// Contains a portal summary.
type PortalSummary struct {
	_ struct{} `type:"structure"`

	// The date the portal was created, in Unix epoch time.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The portal's description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The ID of the portal.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The date the portal was last updated, in Unix epoch time.
	LastUpdateDate *time.Time `locationName:"lastUpdateDate" type:"timestamp"`

	// The name of the portal.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the service role that allows the portal's users to access your AWS IoT
	// SiteWise resources on your behalf. For more information, see Using service
	// roles for AWS IoT SiteWise Monitor (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html)
	// in the AWS IoT SiteWise User Guide.
	RoleArn *string `locationName:"roleArn" min:"1" type:"string"`

	// The public root URL for the AWS IoT AWS IoT SiteWise Monitor application
	// portal.
	//
	// StartUrl is a required field
	StartUrl *string `locationName:"startUrl" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PortalSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PortalSummary) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *PortalSummary) SetCreationDate(v time.Time) *PortalSummary {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PortalSummary) SetDescription(v string) *PortalSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *PortalSummary) SetId(v string) *PortalSummary {
	s.Id = &v
	return s
}

// SetLastUpdateDate sets the LastUpdateDate field's value.
func (s *PortalSummary) SetLastUpdateDate(v time.Time) *PortalSummary {
	s.LastUpdateDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *PortalSummary) SetName(v string) *PortalSummary {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *PortalSummary) SetRoleArn(v string) *PortalSummary {
	s.RoleArn = &v
	return s
}

// SetStartUrl sets the StartUrl field's value.
func (s *PortalSummary) SetStartUrl(v string) *PortalSummary {
	s.StartUrl = &v
	return s
}

// Identifies a specific AWS IoT SiteWise Monitor project.
type ProjectResource struct {
	_ struct{} `type:"structure"`

	// The ID of the project.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s ProjectResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProjectResource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProjectResource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProjectResource"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *ProjectResource) SetId(v string) *ProjectResource {
	s.Id = &v
	return s
}

// Contains project summary information.
type ProjectSummary struct {
	_ struct{} `type:"structure"`

	// The date the project was created, in Unix epoch time.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp"`

	// The project's description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The ID of the project.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The date the project was last updated, in Unix epoch time.
	LastUpdateDate *time.Time `locationName:"lastUpdateDate" type:"timestamp"`

	// The name of the project.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ProjectSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProjectSummary) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *ProjectSummary) SetCreationDate(v time.Time) *ProjectSummary {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ProjectSummary) SetDescription(v string) *ProjectSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ProjectSummary) SetId(v string) *ProjectSummary {
	s.Id = &v
	return s
}

// SetLastUpdateDate sets the LastUpdateDate field's value.
func (s *ProjectSummary) SetLastUpdateDate(v time.Time) *ProjectSummary {
	s.LastUpdateDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *ProjectSummary) SetName(v string) *ProjectSummary {
	s.Name = &v
	return s
}

// Contains asset property information.
type Property struct {
	_ struct{} `type:"structure"`

	// The property alias that identifies the property, such as an OPC-UA server
	// data stream path (for example, /company/windfarm/3/turbine/7/temperature).
	// For more information, see Mapping Industrial Data Streams to Asset Properties
	// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html)
	// in the AWS IoT SiteWise User Guide.
	Alias *string `locationName:"alias" min:"1" type:"string"`

	// The property data type.
	//
	// DataType is a required field
	DataType *string `locationName:"dataType" type:"string" required:"true" enum:"PropertyDataType"`

	// The ID of the asset property.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"36" type:"string" required:"true"`

	// The name of the property.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The asset property's notification topic and state. For more information,
	// see UpdateAssetProperty (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html)
	Notification *PropertyNotification `locationName:"notification" type:"structure"`

	// The property type (see PropertyType). A property contains one type.
	Type *PropertyType `locationName:"type" type:"structure"`

	// The unit (such as Newtons or RPM) of the asset property.
	Unit *string `locationName:"unit" min:"1" type:"string"`
}

// String returns the string representation
func (s Property) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Property) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *Property) SetAlias(v string) *Property {
	s.Alias = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *Property) SetDataType(v string) *Property {
	s.DataType = &v
	return s
}

// SetId sets the Id field's value.
func (s *Property) SetId(v string) *Property {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *Property) SetName(v string) *Property {
	s.Name = &v
	return s
}

// SetNotification sets the Notification field's value.
func (s *Property) SetNotification(v *PropertyNotification) *Property {
	s.Notification = v
	return s
}

// SetType sets the Type field's value.
func (s *Property) SetType(v *PropertyType) *Property {
	s.Type = v
	return s
}

// SetUnit sets the Unit field's value.
func (s *Property) SetUnit(v string) *Property {
	s.Unit = &v
	return s
}

// Contains asset property value notification information. When the notification
// state is enabled, AWS IoT SiteWise publishes property value updates to a
// unique MQTT topic. For more information, see Interacting with Other Services
// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html)
// in the AWS IoT SiteWise User Guide.
type PropertyNotification struct {
	_ struct{} `type:"structure"`

	// The current notification state.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"PropertyNotificationState"`

	// The MQTT topic to which AWS IoT SiteWise publishes property value update
	// notifications.
	//
	// Topic is a required field
	Topic *string `locationName:"topic" type:"string" required:"true"`
}

// String returns the string representation
func (s PropertyNotification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PropertyNotification) GoString() string {
	return s.String()
}

// SetState sets the State field's value.
func (s *PropertyNotification) SetState(v string) *PropertyNotification {
	s.State = &v
	return s
}

// SetTopic sets the Topic field's value.
func (s *PropertyNotification) SetTopic(v string) *PropertyNotification {
	s.Topic = &v
	return s
}

// Contains a property type, which can be one of attribute, measurement, metric,
// or transform.
type PropertyType struct {
	_ struct{} `type:"structure"`

	// Specifies an asset attribute property. An attribute generally contains static
	// information, such as the serial number of an IIoT (https://en.wikipedia.org/wiki/Internet_of_things#Industrial_applications)
	// wind turbine.
	Attribute *Attribute `locationName:"attribute" type:"structure"`

	// Specifies an asset measurement property. A measurement represents a device's
	// raw sensor data stream, such as timestamped temperature values or timestamped
	// power values.
	Measurement *Measurement `locationName:"measurement" type:"structure"`

	// Specifies an asset metric property. A metric contains a mathematical expression
	// that uses aggregate functions to process all input data points over a time
	// interval and output a single data point, such as to calculate the average
	// hourly temperature.
	Metric *Metric `locationName:"metric" type:"structure"`

	// Specifies an asset transform property. A transform contains a mathematical
	// expression that maps a property's data points from one form to another, such
	// as a unit conversion from Celsius to Fahrenheit.
	Transform *Transform `locationName:"transform" type:"structure"`
}

// String returns the string representation
func (s PropertyType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PropertyType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PropertyType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PropertyType"}
	if s.Attribute != nil {
		if err := s.Attribute.Validate(); err != nil {
			invalidParams.AddNested("Attribute", err.(request.ErrInvalidParams))
		}
	}
	if s.Metric != nil {
		if err := s.Metric.Validate(); err != nil {
			invalidParams.AddNested("Metric", err.(request.ErrInvalidParams))
		}
	}
	if s.Transform != nil {
		if err := s.Transform.Validate(); err != nil {
			invalidParams.AddNested("Transform", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttribute sets the Attribute field's value.
func (s *PropertyType) SetAttribute(v *Attribute) *PropertyType {
	s.Attribute = v
	return s
}

// SetMeasurement sets the Measurement field's value.
func (s *PropertyType) SetMeasurement(v *Measurement) *PropertyType {
	s.Measurement = v
	return s
}

// SetMetric sets the Metric field's value.
func (s *PropertyType) SetMetric(v *Metric) *PropertyType {
	s.Metric = v
	return s
}

// SetTransform sets the Transform field's value.
func (s *PropertyType) SetTransform(v *Transform) *PropertyType {
	s.Transform = v
	return s
}

// Contains a list of value updates for an asset property in the list of asset
// entries consumed by the BatchPutAssetPropertyValue (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchPutAssetPropertyValue.html)
// API.
type PutAssetPropertyValueEntry struct {
	_ struct{} `type:"structure"`

	// The ID of the asset to update.
	AssetId *string `locationName:"assetId" min:"36" type:"string"`

	// The user specified ID for the entry. You can use this ID to identify which
	// entries failed.
	//
	// EntryId is a required field
	EntryId *string `locationName:"entryId" min:"1" type:"string" required:"true"`

	// The property alias that identifies the property, such as an OPC-UA server
	// data stream path (for example, /company/windfarm/3/turbine/7/temperature).
	// For more information, see Mapping Industrial Data Streams to Asset Properties
	// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html)
	// in the AWS IoT SiteWise User Guide.
	PropertyAlias *string `locationName:"propertyAlias" min:"1" type:"string"`

	// The ID of the asset property for this entry.
	PropertyId *string `locationName:"propertyId" min:"36" type:"string"`

	// The list of property values to upload. You can specify up to 10 propertyValues
	// array elements.
	//
	// PropertyValues is a required field
	PropertyValues []*AssetPropertyValue `locationName:"propertyValues" type:"list" required:"true"`
}

// String returns the string representation
func (s PutAssetPropertyValueEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAssetPropertyValueEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAssetPropertyValueEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutAssetPropertyValueEntry"}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.EntryId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntryId"))
	}
	if s.EntryId != nil && len(*s.EntryId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntryId", 1))
	}
	if s.PropertyAlias != nil && len(*s.PropertyAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyAlias", 1))
	}
	if s.PropertyId != nil && len(*s.PropertyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyId", 36))
	}
	if s.PropertyValues == nil {
		invalidParams.Add(request.NewErrParamRequired("PropertyValues"))
	}
	if s.PropertyValues != nil {
		for i, v := range s.PropertyValues {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PropertyValues", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *PutAssetPropertyValueEntry) SetAssetId(v string) *PutAssetPropertyValueEntry {
	s.AssetId = &v
	return s
}

// SetEntryId sets the EntryId field's value.
func (s *PutAssetPropertyValueEntry) SetEntryId(v string) *PutAssetPropertyValueEntry {
	s.EntryId = &v
	return s
}

// SetPropertyAlias sets the PropertyAlias field's value.
func (s *PutAssetPropertyValueEntry) SetPropertyAlias(v string) *PutAssetPropertyValueEntry {
	s.PropertyAlias = &v
	return s
}

// SetPropertyId sets the PropertyId field's value.
func (s *PutAssetPropertyValueEntry) SetPropertyId(v string) *PutAssetPropertyValueEntry {
	s.PropertyId = &v
	return s
}

// SetPropertyValues sets the PropertyValues field's value.
func (s *PutAssetPropertyValueEntry) SetPropertyValues(v []*AssetPropertyValue) *PutAssetPropertyValueEntry {
	s.PropertyValues = v
	return s
}

type PutLoggingOptionsInput struct {
	_ struct{} `type:"structure"`

	// The logging options to set.
	//
	// LoggingOptions is a required field
	LoggingOptions *LoggingOptions `locationName:"loggingOptions" type:"structure" required:"true"`
}

// String returns the string representation
func (s PutLoggingOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutLoggingOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutLoggingOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutLoggingOptionsInput"}
	if s.LoggingOptions == nil {
		invalidParams.Add(request.NewErrParamRequired("LoggingOptions"))
	}
	if s.LoggingOptions != nil {
		if err := s.LoggingOptions.Validate(); err != nil {
			invalidParams.AddNested("LoggingOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoggingOptions sets the LoggingOptions field's value.
func (s *PutLoggingOptionsInput) SetLoggingOptions(v *LoggingOptions) *PutLoggingOptionsInput {
	s.LoggingOptions = v
	return s
}

type PutLoggingOptionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutLoggingOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutLoggingOptionsOutput) GoString() string {
	return s.String()
}

// Contains an AWS IoT SiteWise Monitor resource ID for a portal or project.
type Resource struct {
	_ struct{} `type:"structure"`

	// A portal resource.
	Portal *PortalResource `locationName:"portal" type:"structure"`

	// A project resource.
	Project *ProjectResource `locationName:"project" type:"structure"`
}

// String returns the string representation
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Resource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Resource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Resource"}
	if s.Portal != nil {
		if err := s.Portal.Validate(); err != nil {
			invalidParams.AddNested("Portal", err.(request.ErrInvalidParams))
		}
	}
	if s.Project != nil {
		if err := s.Project.Validate(); err != nil {
			invalidParams.AddNested("Project", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPortal sets the Portal field's value.
func (s *Resource) SetPortal(v *PortalResource) *Resource {
	s.Portal = v
	return s
}

// SetProject sets the Project field's value.
func (s *Resource) SetProject(v *ProjectResource) *Resource {
	s.Project = v
	return s
}

// The resource already exists.
type ResourceAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ARN of the resource that already exists.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`

	// The ID of the resource that already exists.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`
}

// String returns the string representation
func (s ResourceAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorResourceAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &ResourceAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceAlreadyExistsException) Code() string {
	return "ResourceAlreadyExistsException"
}

// Message returns the exception's message.
func (s *ResourceAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *ResourceAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The requested resource can't be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The requested service is unavailable.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the resource to tag.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// A list of key-value pairs that contain metadata for the resource. For more
	// information, see Tagging your AWS IoT SiteWise resources (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html)
	// in the AWS IoT SiteWise User Guide.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Your request exceeded a rate limit. For example, you might have exceeded
// the number of AWS IoT SiteWise assets that can be created per second, the
// allowed number of messages per second, and so on.
//
// For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
// in the AWS IoT SiteWise User Guide.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains a timestamp with optional nanosecond granularity.
type TimeInNanos struct {
	_ struct{} `type:"structure"`

	// The nanosecond offset from timeInSeconds.
	OffsetInNanos *int64 `locationName:"offsetInNanos" type:"integer"`

	// The timestamp date, in seconds, in the Unix epoch format. Fractional nanosecond
	// data is provided by offsetInNanos.
	//
	// TimeInSeconds is a required field
	TimeInSeconds *int64 `locationName:"timeInSeconds" min:"1" type:"long" required:"true"`
}

// String returns the string representation
func (s TimeInNanos) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeInNanos) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TimeInNanos) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TimeInNanos"}
	if s.TimeInSeconds == nil {
		invalidParams.Add(request.NewErrParamRequired("TimeInSeconds"))
	}
	if s.TimeInSeconds != nil && *s.TimeInSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TimeInSeconds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOffsetInNanos sets the OffsetInNanos field's value.
func (s *TimeInNanos) SetOffsetInNanos(v int64) *TimeInNanos {
	s.OffsetInNanos = &v
	return s
}

// SetTimeInSeconds sets the TimeInSeconds field's value.
func (s *TimeInNanos) SetTimeInSeconds(v int64) *TimeInNanos {
	s.TimeInSeconds = &v
	return s
}

// You've reached the limit for the number of tags allowed for a resource. For
// more information, see Tag naming limits and requirements (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html#tag-conventions)
// in the AWS General Reference.
type TooManyTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The name of the resource with too many tags.
	ResourceName *string `locationName:"resourceName" min:"1" type:"string"`
}

// String returns the string representation
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s *TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagsException) OrigErr() error {
	return nil
}

func (s *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains an asset transform property. A transform is a one-to-one mapping
// of a property's data points from one form to another. For example, you can
// use a transform to convert a Celsius data stream to Fahrenheit by applying
// the transformation expression to each data point of the Celsius stream. A
// transform can only have a data type of DOUBLE and consume properties with
// data types of INTEGER or DOUBLE.
//
// For more information, see Transforms (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#transforms)
// in the AWS IoT SiteWise User Guide.
type Transform struct {
	_ struct{} `type:"structure"`

	// The mathematical expression that defines the transformation function. You
	// can specify up to 10 variables per expression. You can specify up to 10 functions
	// per expression.
	//
	// For more information, see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
	// in the AWS IoT SiteWise User Guide.
	//
	// Expression is a required field
	Expression *string `locationName:"expression" min:"1" type:"string" required:"true"`

	// The list of variables used in the expression.
	//
	// Variables is a required field
	Variables []*ExpressionVariable `locationName:"variables" type:"list" required:"true"`
}

// String returns the string representation
func (s Transform) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Transform) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Transform) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Transform"}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}
	if s.Variables == nil {
		invalidParams.Add(request.NewErrParamRequired("Variables"))
	}
	if s.Variables != nil {
		for i, v := range s.Variables {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Variables", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpression sets the Expression field's value.
func (s *Transform) SetExpression(v string) *Transform {
	s.Expression = &v
	return s
}

// SetVariables sets the Variables field's value.
func (s *Transform) SetVariables(v []*ExpressionVariable) *Transform {
	s.Variables = v
	return s
}

// Contains a tumbling window, which is a repeating fixed-sized, non-overlapping,
// and contiguous time interval. This window is used in metric and aggregation
// computations.
type TumblingWindow struct {
	_ struct{} `type:"structure"`

	// The time interval for the tumbling window. Note that w represents weeks,
	// d represents days, h represents hours, and m represents minutes. AWS IoT
	// SiteWise computes the 1w interval the end of Sunday at midnight each week
	// (UTC), the 1d interval at the end of each day at midnight (UTC), the 1h interval
	// at the end of each hour, and so on.
	//
	// When AWS IoT SiteWise aggregates data points for metric computations, the
	// start of each interval is exclusive and the end of each interval is inclusive.
	// AWS IoT SiteWise places the computed data point at the end of the interval.
	//
	// Interval is a required field
	Interval *string `locationName:"interval" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s TumblingWindow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TumblingWindow) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TumblingWindow) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TumblingWindow"}
	if s.Interval == nil {
		invalidParams.Add(request.NewErrParamRequired("Interval"))
	}
	if s.Interval != nil && len(*s.Interval) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Interval", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInterval sets the Interval field's value.
func (s *TumblingWindow) SetInterval(v string) *TumblingWindow {
	s.Interval = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the resource to untag.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// A list of keys for tags to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateAccessPolicyInput struct {
	_ struct{} `type:"structure"`

	// The ID of the access policy.
	//
	// AccessPolicyId is a required field
	AccessPolicyId *string `location:"uri" locationName:"accessPolicyId" min:"36" type:"string" required:"true"`

	// The identity for this access policy. Choose either a user or a group but
	// not both.
	//
	// AccessPolicyIdentity is a required field
	AccessPolicyIdentity *Identity `locationName:"accessPolicyIdentity" type:"structure" required:"true"`

	// The permission level for this access policy. Note that a project ADMINISTRATOR
	// is also known as a project owner.
	//
	// AccessPolicyPermission is a required field
	AccessPolicyPermission *string `locationName:"accessPolicyPermission" type:"string" required:"true" enum:"Permission"`

	// The AWS IoT SiteWise Monitor resource for this access policy. Choose either
	// portal or project but not both.
	//
	// AccessPolicyResource is a required field
	AccessPolicyResource *Resource `locationName:"accessPolicyResource" type:"structure" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`
}

// String returns the string representation
func (s UpdateAccessPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAccessPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAccessPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAccessPolicyInput"}
	if s.AccessPolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessPolicyId"))
	}
	if s.AccessPolicyId != nil && len(*s.AccessPolicyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AccessPolicyId", 36))
	}
	if s.AccessPolicyIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessPolicyIdentity"))
	}
	if s.AccessPolicyPermission == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessPolicyPermission"))
	}
	if s.AccessPolicyResource == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessPolicyResource"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.AccessPolicyIdentity != nil {
		if err := s.AccessPolicyIdentity.Validate(); err != nil {
			invalidParams.AddNested("AccessPolicyIdentity", err.(request.ErrInvalidParams))
		}
	}
	if s.AccessPolicyResource != nil {
		if err := s.AccessPolicyResource.Validate(); err != nil {
			invalidParams.AddNested("AccessPolicyResource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessPolicyId sets the AccessPolicyId field's value.
func (s *UpdateAccessPolicyInput) SetAccessPolicyId(v string) *UpdateAccessPolicyInput {
	s.AccessPolicyId = &v
	return s
}

// SetAccessPolicyIdentity sets the AccessPolicyIdentity field's value.
func (s *UpdateAccessPolicyInput) SetAccessPolicyIdentity(v *Identity) *UpdateAccessPolicyInput {
	s.AccessPolicyIdentity = v
	return s
}

// SetAccessPolicyPermission sets the AccessPolicyPermission field's value.
func (s *UpdateAccessPolicyInput) SetAccessPolicyPermission(v string) *UpdateAccessPolicyInput {
	s.AccessPolicyPermission = &v
	return s
}

// SetAccessPolicyResource sets the AccessPolicyResource field's value.
func (s *UpdateAccessPolicyInput) SetAccessPolicyResource(v *Resource) *UpdateAccessPolicyInput {
	s.AccessPolicyResource = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateAccessPolicyInput) SetClientToken(v string) *UpdateAccessPolicyInput {
	s.ClientToken = &v
	return s
}

type UpdateAccessPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateAccessPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAccessPolicyOutput) GoString() string {
	return s.String()
}

type UpdateAssetInput struct {
	_ struct{} `type:"structure"`

	// The ID of the asset to update.
	//
	// AssetId is a required field
	AssetId *string `location:"uri" locationName:"assetId" min:"36" type:"string" required:"true"`

	// A unique, friendly name for the asset.
	//
	// AssetName is a required field
	AssetName *string `locationName:"assetName" min:"1" type:"string" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`
}

// String returns the string representation
func (s UpdateAssetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAssetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAssetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAssetInput"}
	if s.AssetId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetId"))
	}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.AssetName == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetName"))
	}
	if s.AssetName != nil && len(*s.AssetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssetName", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *UpdateAssetInput) SetAssetId(v string) *UpdateAssetInput {
	s.AssetId = &v
	return s
}

// SetAssetName sets the AssetName field's value.
func (s *UpdateAssetInput) SetAssetName(v string) *UpdateAssetInput {
	s.AssetName = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateAssetInput) SetClientToken(v string) *UpdateAssetInput {
	s.ClientToken = &v
	return s
}

type UpdateAssetModelInput struct {
	_ struct{} `type:"structure"`

	// A description for the asset model.
	AssetModelDescription *string `locationName:"assetModelDescription" min:"1" type:"string"`

	// The updated hierarchy definitions of the asset model. Each hierarchy specifies
	// an asset model whose assets can be children of any other assets created from
	// this asset model. For more information, see Asset Hierarchies (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html)
	// in the AWS IoT SiteWise User Guide.
	//
	// You can specify up to 10 hierarchies per asset model. For more information,
	// see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
	// in the AWS IoT SiteWise User Guide.
	AssetModelHierarchies []*AssetModelHierarchy `locationName:"assetModelHierarchies" type:"list"`

	// The ID of the asset model to update.
	//
	// AssetModelId is a required field
	AssetModelId *string `location:"uri" locationName:"assetModelId" min:"36" type:"string" required:"true"`

	// A unique, friendly name for the asset model.
	//
	// AssetModelName is a required field
	AssetModelName *string `locationName:"assetModelName" min:"1" type:"string" required:"true"`

	// The updated property definitions of the asset model. For more information,
	// see Asset Properties (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html)
	// in the AWS IoT SiteWise User Guide.
	//
	// You can specify up to 200 properties per asset model. For more information,
	// see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
	// in the AWS IoT SiteWise User Guide.
	AssetModelProperties []*AssetModelProperty `locationName:"assetModelProperties" type:"list"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`
}

// String returns the string representation
func (s UpdateAssetModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAssetModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAssetModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAssetModelInput"}
	if s.AssetModelDescription != nil && len(*s.AssetModelDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssetModelDescription", 1))
	}
	if s.AssetModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetModelId"))
	}
	if s.AssetModelId != nil && len(*s.AssetModelId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetModelId", 36))
	}
	if s.AssetModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetModelName"))
	}
	if s.AssetModelName != nil && len(*s.AssetModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssetModelName", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.AssetModelHierarchies != nil {
		for i, v := range s.AssetModelHierarchies {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AssetModelHierarchies", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.AssetModelProperties != nil {
		for i, v := range s.AssetModelProperties {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AssetModelProperties", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetModelDescription sets the AssetModelDescription field's value.
func (s *UpdateAssetModelInput) SetAssetModelDescription(v string) *UpdateAssetModelInput {
	s.AssetModelDescription = &v
	return s
}

// SetAssetModelHierarchies sets the AssetModelHierarchies field's value.
func (s *UpdateAssetModelInput) SetAssetModelHierarchies(v []*AssetModelHierarchy) *UpdateAssetModelInput {
	s.AssetModelHierarchies = v
	return s
}

// SetAssetModelId sets the AssetModelId field's value.
func (s *UpdateAssetModelInput) SetAssetModelId(v string) *UpdateAssetModelInput {
	s.AssetModelId = &v
	return s
}

// SetAssetModelName sets the AssetModelName field's value.
func (s *UpdateAssetModelInput) SetAssetModelName(v string) *UpdateAssetModelInput {
	s.AssetModelName = &v
	return s
}

// SetAssetModelProperties sets the AssetModelProperties field's value.
func (s *UpdateAssetModelInput) SetAssetModelProperties(v []*AssetModelProperty) *UpdateAssetModelInput {
	s.AssetModelProperties = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateAssetModelInput) SetClientToken(v string) *UpdateAssetModelInput {
	s.ClientToken = &v
	return s
}

type UpdateAssetModelOutput struct {
	_ struct{} `type:"structure"`

	// The status of the asset model, which contains a state (UPDATING after successfully
	// calling this operation) and any error message.
	//
	// AssetModelStatus is a required field
	AssetModelStatus *AssetModelStatus `locationName:"assetModelStatus" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateAssetModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAssetModelOutput) GoString() string {
	return s.String()
}

// SetAssetModelStatus sets the AssetModelStatus field's value.
func (s *UpdateAssetModelOutput) SetAssetModelStatus(v *AssetModelStatus) *UpdateAssetModelOutput {
	s.AssetModelStatus = v
	return s
}

type UpdateAssetOutput struct {
	_ struct{} `type:"structure"`

	// The status of the asset, which contains a state (UPDATING after successfully
	// calling this operation) and any error message.
	//
	// AssetStatus is a required field
	AssetStatus *AssetStatus `locationName:"assetStatus" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateAssetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAssetOutput) GoString() string {
	return s.String()
}

// SetAssetStatus sets the AssetStatus field's value.
func (s *UpdateAssetOutput) SetAssetStatus(v *AssetStatus) *UpdateAssetOutput {
	s.AssetStatus = v
	return s
}

type UpdateAssetPropertyInput struct {
	_ struct{} `type:"structure"`

	// The ID of the asset to be updated.
	//
	// AssetId is a required field
	AssetId *string `location:"uri" locationName:"assetId" min:"36" type:"string" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The property alias that identifies the property, such as an OPC-UA server
	// data stream path (for example, /company/windfarm/3/turbine/7/temperature).
	// For more information, see Mapping Industrial Data Streams to Asset Properties
	// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html)
	// in the AWS IoT SiteWise User Guide.
	//
	// If you omit this parameter, the alias is removed from the property.
	PropertyAlias *string `locationName:"propertyAlias" min:"1" type:"string"`

	// The ID of the asset property to be updated.
	//
	// PropertyId is a required field
	PropertyId *string `location:"uri" locationName:"propertyId" min:"36" type:"string" required:"true"`

	// The MQTT notification state (enabled or disabled) for this asset property.
	// When the notification state is enabled, AWS IoT SiteWise publishes property
	// value updates to a unique MQTT topic. For more information, see Interacting
	// with Other Services (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html)
	// in the AWS IoT SiteWise User Guide.
	//
	// If you omit this parameter, the notification state is set to DISABLED.
	PropertyNotificationState *string `locationName:"propertyNotificationState" type:"string" enum:"PropertyNotificationState"`
}

// String returns the string representation
func (s UpdateAssetPropertyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAssetPropertyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAssetPropertyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAssetPropertyInput"}
	if s.AssetId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetId"))
	}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AssetId", 36))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.PropertyAlias != nil && len(*s.PropertyAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyAlias", 1))
	}
	if s.PropertyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PropertyId"))
	}
	if s.PropertyId != nil && len(*s.PropertyId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *UpdateAssetPropertyInput) SetAssetId(v string) *UpdateAssetPropertyInput {
	s.AssetId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateAssetPropertyInput) SetClientToken(v string) *UpdateAssetPropertyInput {
	s.ClientToken = &v
	return s
}

// SetPropertyAlias sets the PropertyAlias field's value.
func (s *UpdateAssetPropertyInput) SetPropertyAlias(v string) *UpdateAssetPropertyInput {
	s.PropertyAlias = &v
	return s
}

// SetPropertyId sets the PropertyId field's value.
func (s *UpdateAssetPropertyInput) SetPropertyId(v string) *UpdateAssetPropertyInput {
	s.PropertyId = &v
	return s
}

// SetPropertyNotificationState sets the PropertyNotificationState field's value.
func (s *UpdateAssetPropertyInput) SetPropertyNotificationState(v string) *UpdateAssetPropertyInput {
	s.PropertyNotificationState = &v
	return s
}

type UpdateAssetPropertyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateAssetPropertyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAssetPropertyOutput) GoString() string {
	return s.String()
}

type UpdateDashboardInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The new dashboard definition, as specified in a JSON literal. For detailed
	// information, see Creating Dashboards (CLI) (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html)
	// in the AWS IoT SiteWise User Guide.
	//
	// DashboardDefinition is a required field
	DashboardDefinition *string `locationName:"dashboardDefinition" type:"string" required:"true"`

	// A new description for the dashboard.
	DashboardDescription *string `locationName:"dashboardDescription" min:"1" type:"string"`

	// The ID of the dashboard to update.
	//
	// DashboardId is a required field
	DashboardId *string `location:"uri" locationName:"dashboardId" min:"36" type:"string" required:"true"`

	// A new friendly name for the dashboard.
	//
	// DashboardName is a required field
	DashboardName *string `locationName:"dashboardName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateDashboardInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDashboardInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDashboardInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDashboardInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.DashboardDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardDefinition"))
	}
	if s.DashboardDescription != nil && len(*s.DashboardDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardDescription", 1))
	}
	if s.DashboardId == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardId"))
	}
	if s.DashboardId != nil && len(*s.DashboardId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardId", 36))
	}
	if s.DashboardName == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardName"))
	}
	if s.DashboardName != nil && len(*s.DashboardName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateDashboardInput) SetClientToken(v string) *UpdateDashboardInput {
	s.ClientToken = &v
	return s
}

// SetDashboardDefinition sets the DashboardDefinition field's value.
func (s *UpdateDashboardInput) SetDashboardDefinition(v string) *UpdateDashboardInput {
	s.DashboardDefinition = &v
	return s
}

// SetDashboardDescription sets the DashboardDescription field's value.
func (s *UpdateDashboardInput) SetDashboardDescription(v string) *UpdateDashboardInput {
	s.DashboardDescription = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *UpdateDashboardInput) SetDashboardId(v string) *UpdateDashboardInput {
	s.DashboardId = &v
	return s
}

// SetDashboardName sets the DashboardName field's value.
func (s *UpdateDashboardInput) SetDashboardName(v string) *UpdateDashboardInput {
	s.DashboardName = &v
	return s
}

type UpdateDashboardOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDashboardOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDashboardOutput) GoString() string {
	return s.String()
}

type UpdateGatewayCapabilityConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The JSON document that defines the configuration for the gateway capability.
	// For more information, see Configuring data sources (CLI) (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli)
	// in the AWS IoT SiteWise User Guide.
	//
	// CapabilityConfiguration is a required field
	CapabilityConfiguration *string `locationName:"capabilityConfiguration" min:"1" type:"string" required:"true"`

	// The namespace of the gateway capability configuration to be updated. For
	// example, if you configure OPC-UA sources from the AWS IoT SiteWise console,
	// your OPC-UA capability configuration has the namespace iotsitewise:opcuacollector:version,
	// where version is a number such as 1.
	//
	// CapabilityNamespace is a required field
	CapabilityNamespace *string `locationName:"capabilityNamespace" min:"1" type:"string" required:"true"`

	// The ID of the gateway to be updated.
	//
	// GatewayId is a required field
	GatewayId *string `location:"uri" locationName:"gatewayId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateGatewayCapabilityConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGatewayCapabilityConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGatewayCapabilityConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGatewayCapabilityConfigurationInput"}
	if s.CapabilityConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("CapabilityConfiguration"))
	}
	if s.CapabilityConfiguration != nil && len(*s.CapabilityConfiguration) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CapabilityConfiguration", 1))
	}
	if s.CapabilityNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("CapabilityNamespace"))
	}
	if s.CapabilityNamespace != nil && len(*s.CapabilityNamespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CapabilityNamespace", 1))
	}
	if s.GatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayId"))
	}
	if s.GatewayId != nil && len(*s.GatewayId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapabilityConfiguration sets the CapabilityConfiguration field's value.
func (s *UpdateGatewayCapabilityConfigurationInput) SetCapabilityConfiguration(v string) *UpdateGatewayCapabilityConfigurationInput {
	s.CapabilityConfiguration = &v
	return s
}

// SetCapabilityNamespace sets the CapabilityNamespace field's value.
func (s *UpdateGatewayCapabilityConfigurationInput) SetCapabilityNamespace(v string) *UpdateGatewayCapabilityConfigurationInput {
	s.CapabilityNamespace = &v
	return s
}

// SetGatewayId sets the GatewayId field's value.
func (s *UpdateGatewayCapabilityConfigurationInput) SetGatewayId(v string) *UpdateGatewayCapabilityConfigurationInput {
	s.GatewayId = &v
	return s
}

type UpdateGatewayCapabilityConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The namespace of the gateway capability.
	//
	// CapabilityNamespace is a required field
	CapabilityNamespace *string `locationName:"capabilityNamespace" min:"1" type:"string" required:"true"`

	// The synchronization status of the capability configuration. The sync status
	// can be one of the following:
	//
	//    * IN_SYNC – The gateway is running the capability configuration.
	//
	//    * OUT_OF_SYNC – The gateway hasn't received the capability configuration.
	//
	//    * SYNC_FAILED – The gateway rejected the capability configuration.
	//
	// After you update a capability configuration, its sync status is OUT_OF_SYNC
	// until the gateway receives and applies or rejects the updated configuration.
	//
	// CapabilitySyncStatus is a required field
	CapabilitySyncStatus *string `locationName:"capabilitySyncStatus" type:"string" required:"true" enum:"CapabilitySyncStatus"`
}

// String returns the string representation
func (s UpdateGatewayCapabilityConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGatewayCapabilityConfigurationOutput) GoString() string {
	return s.String()
}

// SetCapabilityNamespace sets the CapabilityNamespace field's value.
func (s *UpdateGatewayCapabilityConfigurationOutput) SetCapabilityNamespace(v string) *UpdateGatewayCapabilityConfigurationOutput {
	s.CapabilityNamespace = &v
	return s
}

// SetCapabilitySyncStatus sets the CapabilitySyncStatus field's value.
func (s *UpdateGatewayCapabilityConfigurationOutput) SetCapabilitySyncStatus(v string) *UpdateGatewayCapabilityConfigurationOutput {
	s.CapabilitySyncStatus = &v
	return s
}

type UpdateGatewayInput struct {
	_ struct{} `type:"structure"`

	// The ID of the gateway to update.
	//
	// GatewayId is a required field
	GatewayId *string `location:"uri" locationName:"gatewayId" min:"36" type:"string" required:"true"`

	// A unique, friendly name for the gateway.
	//
	// GatewayName is a required field
	GatewayName *string `locationName:"gatewayName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGatewayInput"}
	if s.GatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayId"))
	}
	if s.GatewayId != nil && len(*s.GatewayId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayId", 36))
	}
	if s.GatewayName == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayName"))
	}
	if s.GatewayName != nil && len(*s.GatewayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayId sets the GatewayId field's value.
func (s *UpdateGatewayInput) SetGatewayId(v string) *UpdateGatewayInput {
	s.GatewayId = &v
	return s
}

// SetGatewayName sets the GatewayName field's value.
func (s *UpdateGatewayInput) SetGatewayName(v string) *UpdateGatewayInput {
	s.GatewayName = &v
	return s
}

type UpdateGatewayOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGatewayOutput) GoString() string {
	return s.String()
}

type UpdatePortalInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The AWS administrator's contact email address.
	//
	// PortalContactEmail is a required field
	PortalContactEmail *string `locationName:"portalContactEmail" min:"1" type:"string" required:"true"`

	// A new description for the portal.
	PortalDescription *string `locationName:"portalDescription" min:"1" type:"string"`

	// The ID of the portal to update.
	//
	// PortalId is a required field
	PortalId *string `location:"uri" locationName:"portalId" min:"36" type:"string" required:"true"`

	// Contains an image that is one of the following:
	//
	//    * An image file. Choose this option to upload a new image.
	//
	//    * The ID of an existing image. Choose this option to keep an existing
	//    image.
	PortalLogoImage *Image `locationName:"portalLogoImage" type:"structure"`

	// A new friendly name for the portal.
	//
	// PortalName is a required field
	PortalName *string `locationName:"portalName" min:"1" type:"string" required:"true"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of a service role that allows the portal's users to access your AWS IoT SiteWise
	// resources on your behalf. For more information, see Using service roles for
	// AWS IoT SiteWise Monitor (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html)
	// in the AWS IoT SiteWise User Guide.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdatePortalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePortalInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePortalInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePortalInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.PortalContactEmail == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalContactEmail"))
	}
	if s.PortalContactEmail != nil && len(*s.PortalContactEmail) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortalContactEmail", 1))
	}
	if s.PortalDescription != nil && len(*s.PortalDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortalDescription", 1))
	}
	if s.PortalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalId"))
	}
	if s.PortalId != nil && len(*s.PortalId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PortalId", 36))
	}
	if s.PortalName == nil {
		invalidParams.Add(request.NewErrParamRequired("PortalName"))
	}
	if s.PortalName != nil && len(*s.PortalName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortalName", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.PortalLogoImage != nil {
		if err := s.PortalLogoImage.Validate(); err != nil {
			invalidParams.AddNested("PortalLogoImage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdatePortalInput) SetClientToken(v string) *UpdatePortalInput {
	s.ClientToken = &v
	return s
}

// SetPortalContactEmail sets the PortalContactEmail field's value.
func (s *UpdatePortalInput) SetPortalContactEmail(v string) *UpdatePortalInput {
	s.PortalContactEmail = &v
	return s
}

// SetPortalDescription sets the PortalDescription field's value.
func (s *UpdatePortalInput) SetPortalDescription(v string) *UpdatePortalInput {
	s.PortalDescription = &v
	return s
}

// SetPortalId sets the PortalId field's value.
func (s *UpdatePortalInput) SetPortalId(v string) *UpdatePortalInput {
	s.PortalId = &v
	return s
}

// SetPortalLogoImage sets the PortalLogoImage field's value.
func (s *UpdatePortalInput) SetPortalLogoImage(v *Image) *UpdatePortalInput {
	s.PortalLogoImage = v
	return s
}

// SetPortalName sets the PortalName field's value.
func (s *UpdatePortalInput) SetPortalName(v string) *UpdatePortalInput {
	s.PortalName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdatePortalInput) SetRoleArn(v string) *UpdatePortalInput {
	s.RoleArn = &v
	return s
}

type UpdatePortalOutput struct {
	_ struct{} `type:"structure"`

	// The status of the portal, which contains a state (UPDATING after successfully
	// calling this operation) and any error message.
	//
	// PortalStatus is a required field
	PortalStatus *PortalStatus `locationName:"portalStatus" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdatePortalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePortalOutput) GoString() string {
	return s.String()
}

// SetPortalStatus sets the PortalStatus field's value.
func (s *UpdatePortalOutput) SetPortalStatus(v *PortalStatus) *UpdatePortalOutput {
	s.PortalStatus = v
	return s
}

type UpdateProjectInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// A new description for the project.
	ProjectDescription *string `locationName:"projectDescription" min:"1" type:"string"`

	// The ID of the project to update.
	//
	// ProjectId is a required field
	ProjectId *string `location:"uri" locationName:"projectId" min:"36" type:"string" required:"true"`

	// A new friendly name for the project.
	//
	// ProjectName is a required field
	ProjectName *string `locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProjectInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 36))
	}
	if s.ProjectDescription != nil && len(*s.ProjectDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectDescription", 1))
	}
	if s.ProjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectId", 36))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateProjectInput) SetClientToken(v string) *UpdateProjectInput {
	s.ClientToken = &v
	return s
}

// SetProjectDescription sets the ProjectDescription field's value.
func (s *UpdateProjectInput) SetProjectDescription(v string) *UpdateProjectInput {
	s.ProjectDescription = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *UpdateProjectInput) SetProjectId(v string) *UpdateProjectInput {
	s.ProjectId = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *UpdateProjectInput) SetProjectName(v string) *UpdateProjectInput {
	s.ProjectName = &v
	return s
}

type UpdateProjectOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateProjectOutput) GoString() string {
	return s.String()
}

// Contains information for a user identity in an access policy.
type UserIdentity struct {
	_ struct{} `type:"structure"`

	// The AWS SSO ID of the user.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UserIdentity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserIdentity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserIdentity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UserIdentity"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *UserIdentity) SetId(v string) *UserIdentity {
	s.Id = &v
	return s
}

// Identifies a property value used in an expression.
type VariableValue struct {
	_ struct{} `type:"structure"`

	// The ID of the hierarchy to query for the property ID. You can use the hierarchy's
	// name instead of the hierarchy's ID.
	//
	// You use a hierarchy ID instead of a model ID because you can have several
	// hierarchies using the same model and therefore the same propertyId. For example,
	// you might have separately grouped assets that come from the same asset model.
	// For more information, see Asset Hierarchies (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html)
	// in the AWS IoT SiteWise User Guide.
	HierarchyId *string `locationName:"hierarchyId" min:"1" type:"string"`

	// The ID of the property to use as the variable. You can use the property name
	// if it's from the same asset model.
	//
	// PropertyId is a required field
	PropertyId *string `locationName:"propertyId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VariableValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VariableValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VariableValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VariableValue"}
	if s.HierarchyId != nil && len(*s.HierarchyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HierarchyId", 1))
	}
	if s.PropertyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PropertyId"))
	}
	if s.PropertyId != nil && len(*s.PropertyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHierarchyId sets the HierarchyId field's value.
func (s *VariableValue) SetHierarchyId(v string) *VariableValue {
	s.HierarchyId = &v
	return s
}

// SetPropertyId sets the PropertyId field's value.
func (s *VariableValue) SetPropertyId(v string) *VariableValue {
	s.PropertyId = &v
	return s
}

// Contains an asset property value (of a single type only).
type Variant struct {
	_ struct{} `type:"structure"`

	// Asset property data of type Boolean (true or false).
	BooleanValue *bool `locationName:"booleanValue" type:"boolean"`

	// Asset property data of type double (floating point number).
	DoubleValue *float64 `locationName:"doubleValue" type:"double"`

	// Asset property data of type integer (whole number).
	IntegerValue *int64 `locationName:"integerValue" type:"integer"`

	// Asset property data of type string (sequence of characters).
	StringValue *string `locationName:"stringValue" min:"1" type:"string"`
}

// String returns the string representation
func (s Variant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Variant) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Variant) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Variant"}
	if s.StringValue != nil && len(*s.StringValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StringValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBooleanValue sets the BooleanValue field's value.
func (s *Variant) SetBooleanValue(v bool) *Variant {
	s.BooleanValue = &v
	return s
}

// SetDoubleValue sets the DoubleValue field's value.
func (s *Variant) SetDoubleValue(v float64) *Variant {
	s.DoubleValue = &v
	return s
}

// SetIntegerValue sets the IntegerValue field's value.
func (s *Variant) SetIntegerValue(v int64) *Variant {
	s.IntegerValue = &v
	return s
}

// SetStringValue sets the StringValue field's value.
func (s *Variant) SetStringValue(v string) *Variant {
	s.StringValue = &v
	return s
}

const (
	// AggregateTypeAverage is a AggregateType enum value
	AggregateTypeAverage = "AVERAGE"

	// AggregateTypeCount is a AggregateType enum value
	AggregateTypeCount = "COUNT"

	// AggregateTypeMaximum is a AggregateType enum value
	AggregateTypeMaximum = "MAXIMUM"

	// AggregateTypeMinimum is a AggregateType enum value
	AggregateTypeMinimum = "MINIMUM"

	// AggregateTypeSum is a AggregateType enum value
	AggregateTypeSum = "SUM"

	// AggregateTypeStandardDeviation is a AggregateType enum value
	AggregateTypeStandardDeviation = "STANDARD_DEVIATION"
)

const (
	// AssetErrorCodeInternalFailure is a AssetErrorCode enum value
	AssetErrorCodeInternalFailure = "INTERNAL_FAILURE"
)

const (
	// AssetModelStateCreating is a AssetModelState enum value
	AssetModelStateCreating = "CREATING"

	// AssetModelStateActive is a AssetModelState enum value
	AssetModelStateActive = "ACTIVE"

	// AssetModelStateUpdating is a AssetModelState enum value
	AssetModelStateUpdating = "UPDATING"

	// AssetModelStatePropagating is a AssetModelState enum value
	AssetModelStatePropagating = "PROPAGATING"

	// AssetModelStateDeleting is a AssetModelState enum value
	AssetModelStateDeleting = "DELETING"

	// AssetModelStateFailed is a AssetModelState enum value
	AssetModelStateFailed = "FAILED"
)

const (
	// AssetStateCreating is a AssetState enum value
	AssetStateCreating = "CREATING"

	// AssetStateActive is a AssetState enum value
	AssetStateActive = "ACTIVE"

	// AssetStateUpdating is a AssetState enum value
	AssetStateUpdating = "UPDATING"

	// AssetStateDeleting is a AssetState enum value
	AssetStateDeleting = "DELETING"

	// AssetStateFailed is a AssetState enum value
	AssetStateFailed = "FAILED"
)

const (
	// BatchPutAssetPropertyValueErrorCodeResourceNotFoundException is a BatchPutAssetPropertyValueErrorCode enum value
	BatchPutAssetPropertyValueErrorCodeResourceNotFoundException = "ResourceNotFoundException"

	// BatchPutAssetPropertyValueErrorCodeInvalidRequestException is a BatchPutAssetPropertyValueErrorCode enum value
	BatchPutAssetPropertyValueErrorCodeInvalidRequestException = "InvalidRequestException"

	// BatchPutAssetPropertyValueErrorCodeInternalFailureException is a BatchPutAssetPropertyValueErrorCode enum value
	BatchPutAssetPropertyValueErrorCodeInternalFailureException = "InternalFailureException"

	// BatchPutAssetPropertyValueErrorCodeServiceUnavailableException is a BatchPutAssetPropertyValueErrorCode enum value
	BatchPutAssetPropertyValueErrorCodeServiceUnavailableException = "ServiceUnavailableException"

	// BatchPutAssetPropertyValueErrorCodeThrottlingException is a BatchPutAssetPropertyValueErrorCode enum value
	BatchPutAssetPropertyValueErrorCodeThrottlingException = "ThrottlingException"

	// BatchPutAssetPropertyValueErrorCodeLimitExceededException is a BatchPutAssetPropertyValueErrorCode enum value
	BatchPutAssetPropertyValueErrorCodeLimitExceededException = "LimitExceededException"

	// BatchPutAssetPropertyValueErrorCodeConflictingOperationException is a BatchPutAssetPropertyValueErrorCode enum value
	BatchPutAssetPropertyValueErrorCodeConflictingOperationException = "ConflictingOperationException"

	// BatchPutAssetPropertyValueErrorCodeTimestampOutOfRangeException is a BatchPutAssetPropertyValueErrorCode enum value
	BatchPutAssetPropertyValueErrorCodeTimestampOutOfRangeException = "TimestampOutOfRangeException"

	// BatchPutAssetPropertyValueErrorCodeAccessDeniedException is a BatchPutAssetPropertyValueErrorCode enum value
	BatchPutAssetPropertyValueErrorCodeAccessDeniedException = "AccessDeniedException"
)

const (
	// CapabilitySyncStatusInSync is a CapabilitySyncStatus enum value
	CapabilitySyncStatusInSync = "IN_SYNC"

	// CapabilitySyncStatusOutOfSync is a CapabilitySyncStatus enum value
	CapabilitySyncStatusOutOfSync = "OUT_OF_SYNC"

	// CapabilitySyncStatusSyncFailed is a CapabilitySyncStatus enum value
	CapabilitySyncStatusSyncFailed = "SYNC_FAILED"
)

const (
	// ErrorCodeValidationError is a ErrorCode enum value
	ErrorCodeValidationError = "VALIDATION_ERROR"

	// ErrorCodeInternalFailure is a ErrorCode enum value
	ErrorCodeInternalFailure = "INTERNAL_FAILURE"
)

const (
	// IdentityTypeUser is a IdentityType enum value
	IdentityTypeUser = "USER"

	// IdentityTypeGroup is a IdentityType enum value
	IdentityTypeGroup = "GROUP"
)

const (
	// ImageFileTypePng is a ImageFileType enum value
	ImageFileTypePng = "PNG"
)

const (
	// ListAssetsFilterAll is a ListAssetsFilter enum value
	ListAssetsFilterAll = "ALL"

	// ListAssetsFilterTopLevel is a ListAssetsFilter enum value
	ListAssetsFilterTopLevel = "TOP_LEVEL"
)

const (
	// LoggingLevelError is a LoggingLevel enum value
	LoggingLevelError = "ERROR"

	// LoggingLevelInfo is a LoggingLevel enum value
	LoggingLevelInfo = "INFO"

	// LoggingLevelOff is a LoggingLevel enum value
	LoggingLevelOff = "OFF"
)

const (
	// MonitorErrorCodeInternalFailure is a MonitorErrorCode enum value
	MonitorErrorCodeInternalFailure = "INTERNAL_FAILURE"
)

const (
	// PermissionAdministrator is a Permission enum value
	PermissionAdministrator = "ADMINISTRATOR"

	// PermissionViewer is a Permission enum value
	PermissionViewer = "VIEWER"
)

const (
	// PortalStateCreating is a PortalState enum value
	PortalStateCreating = "CREATING"

	// PortalStateUpdating is a PortalState enum value
	PortalStateUpdating = "UPDATING"

	// PortalStateDeleting is a PortalState enum value
	PortalStateDeleting = "DELETING"

	// PortalStateActive is a PortalState enum value
	PortalStateActive = "ACTIVE"

	// PortalStateFailed is a PortalState enum value
	PortalStateFailed = "FAILED"
)

const (
	// PropertyDataTypeString is a PropertyDataType enum value
	PropertyDataTypeString = "STRING"

	// PropertyDataTypeInteger is a PropertyDataType enum value
	PropertyDataTypeInteger = "INTEGER"

	// PropertyDataTypeDouble is a PropertyDataType enum value
	PropertyDataTypeDouble = "DOUBLE"

	// PropertyDataTypeBoolean is a PropertyDataType enum value
	PropertyDataTypeBoolean = "BOOLEAN"
)

const (
	// PropertyNotificationStateEnabled is a PropertyNotificationState enum value
	PropertyNotificationStateEnabled = "ENABLED"

	// PropertyNotificationStateDisabled is a PropertyNotificationState enum value
	PropertyNotificationStateDisabled = "DISABLED"
)

const (
	// QualityGood is a Quality enum value
	QualityGood = "GOOD"

	// QualityBad is a Quality enum value
	QualityBad = "BAD"

	// QualityUncertain is a Quality enum value
	QualityUncertain = "UNCERTAIN"
)

const (
	// ResourceTypePortal is a ResourceType enum value
	ResourceTypePortal = "PORTAL"

	// ResourceTypeProject is a ResourceType enum value
	ResourceTypeProject = "PROJECT"
)

const (
	// TimeOrderingAscending is a TimeOrdering enum value
	TimeOrderingAscending = "ASCENDING"

	// TimeOrderingDescending is a TimeOrdering enum value
	TimeOrderingDescending = "DESCENDING"
)
