/*
 * Subset of Influx API covered by Influx CLI
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * API version: 2.0.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package api

import (
	"encoding/json"
)

// DBRP struct for DBRP
type DBRP struct {
	// The ID of the DBRP mapping.
	Id string `json:"id" yaml:"id"`
	// The ID of the organization.
	OrgID string `json:"orgID" yaml:"orgID"`
	// The ID of the bucket used as the target for the translation.
	BucketID string `json:"bucketID" yaml:"bucketID"`
	// InfluxDB v1 database
	Database string `json:"database" yaml:"database"`
	// InfluxDB v1 retention policy
	RetentionPolicy string `json:"retention_policy" yaml:"retention_policy"`
	// Mapping represents the default retention policy for the database specified.
	Default bool `json:"default" yaml:"default"`
	// Indicates an autogenerated, virtual mapping based on the bucket name. Currently only available in OSS.
	Virtual *bool  `json:"virtual,omitempty" yaml:"virtual,omitempty"`
	Links   *Links `json:"links,omitempty" yaml:"links,omitempty"`
}

// NewDBRP instantiates a new DBRP object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDBRP(id string, orgID string, bucketID string, database string, retentionPolicy string, default_ bool) *DBRP {
	this := DBRP{}
	this.Id = id
	this.OrgID = orgID
	this.BucketID = bucketID
	this.Database = database
	this.RetentionPolicy = retentionPolicy
	this.Default = default_
	return &this
}

// NewDBRPWithDefaults instantiates a new DBRP object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDBRPWithDefaults() *DBRP {
	this := DBRP{}
	return &this
}

// GetId returns the Id field value
func (o *DBRP) GetId() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *DBRP) GetIdOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *DBRP) SetId(v string) {
	o.Id = v
}

// GetOrgID returns the OrgID field value
func (o *DBRP) GetOrgID() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.OrgID
}

// GetOrgIDOk returns a tuple with the OrgID field value
// and a boolean to check if the value has been set.
func (o *DBRP) GetOrgIDOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.OrgID, true
}

// SetOrgID sets field value
func (o *DBRP) SetOrgID(v string) {
	o.OrgID = v
}

// GetBucketID returns the BucketID field value
func (o *DBRP) GetBucketID() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.BucketID
}

// GetBucketIDOk returns a tuple with the BucketID field value
// and a boolean to check if the value has been set.
func (o *DBRP) GetBucketIDOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.BucketID, true
}

// SetBucketID sets field value
func (o *DBRP) SetBucketID(v string) {
	o.BucketID = v
}

// GetDatabase returns the Database field value
func (o *DBRP) GetDatabase() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Database
}

// GetDatabaseOk returns a tuple with the Database field value
// and a boolean to check if the value has been set.
func (o *DBRP) GetDatabaseOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Database, true
}

// SetDatabase sets field value
func (o *DBRP) SetDatabase(v string) {
	o.Database = v
}

// GetRetentionPolicy returns the RetentionPolicy field value
func (o *DBRP) GetRetentionPolicy() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.RetentionPolicy
}

// GetRetentionPolicyOk returns a tuple with the RetentionPolicy field value
// and a boolean to check if the value has been set.
func (o *DBRP) GetRetentionPolicyOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.RetentionPolicy, true
}

// SetRetentionPolicy sets field value
func (o *DBRP) SetRetentionPolicy(v string) {
	o.RetentionPolicy = v
}

// GetDefault returns the Default field value
func (o *DBRP) GetDefault() bool {
	if o == nil {
		var ret bool
		return ret
	}

	return o.Default
}

// GetDefaultOk returns a tuple with the Default field value
// and a boolean to check if the value has been set.
func (o *DBRP) GetDefaultOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Default, true
}

// SetDefault sets field value
func (o *DBRP) SetDefault(v bool) {
	o.Default = v
}

// GetVirtual returns the Virtual field value if set, zero value otherwise.
func (o *DBRP) GetVirtual() bool {
	if o == nil || o.Virtual == nil {
		var ret bool
		return ret
	}
	return *o.Virtual
}

// GetVirtualOk returns a tuple with the Virtual field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DBRP) GetVirtualOk() (*bool, bool) {
	if o == nil || o.Virtual == nil {
		return nil, false
	}
	return o.Virtual, true
}

// HasVirtual returns a boolean if a field has been set.
func (o *DBRP) HasVirtual() bool {
	if o != nil && o.Virtual != nil {
		return true
	}

	return false
}

// SetVirtual gets a reference to the given bool and assigns it to the Virtual field.
func (o *DBRP) SetVirtual(v bool) {
	o.Virtual = &v
}

// GetLinks returns the Links field value if set, zero value otherwise.
func (o *DBRP) GetLinks() Links {
	if o == nil || o.Links == nil {
		var ret Links
		return ret
	}
	return *o.Links
}

// GetLinksOk returns a tuple with the Links field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DBRP) GetLinksOk() (*Links, bool) {
	if o == nil || o.Links == nil {
		return nil, false
	}
	return o.Links, true
}

// HasLinks returns a boolean if a field has been set.
func (o *DBRP) HasLinks() bool {
	if o != nil && o.Links != nil {
		return true
	}

	return false
}

// SetLinks gets a reference to the given Links and assigns it to the Links field.
func (o *DBRP) SetLinks(v Links) {
	o.Links = &v
}

func (o DBRP) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["id"] = o.Id
	}
	if true {
		toSerialize["orgID"] = o.OrgID
	}
	if true {
		toSerialize["bucketID"] = o.BucketID
	}
	if true {
		toSerialize["database"] = o.Database
	}
	if true {
		toSerialize["retention_policy"] = o.RetentionPolicy
	}
	if true {
		toSerialize["default"] = o.Default
	}
	if o.Virtual != nil {
		toSerialize["virtual"] = o.Virtual
	}
	if o.Links != nil {
		toSerialize["links"] = o.Links
	}
	return json.Marshal(toSerialize)
}

type NullableDBRP struct {
	value *DBRP
	isSet bool
}

func (v NullableDBRP) Get() *DBRP {
	return v.value
}

func (v *NullableDBRP) Set(val *DBRP) {
	v.value = val
	v.isSet = true
}

func (v NullableDBRP) IsSet() bool {
	return v.isSet
}

func (v *NullableDBRP) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDBRP(val *DBRP) *NullableDBRP {
	return &NullableDBRP{value: val, isSet: true}
}

func (v NullableDBRP) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDBRP) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
