"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getActualDestination = getActualDestination;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/**
 * Calculates the actual destination of an item based on its start location
 * and target location.
 *
 * The actual destination may not be the same as the target location.
 * An item moving to a higher index in the same list introduces an
 * off-by-one error that this function accounts for.
 */
function getActualDestination(_ref) {
  var start = _ref.start,
    target = _ref.target;
  if (target === null) {
    return null;
  }

  /**
   * When reordering an item to an index greater than its current index
   * in the same list, then the target index needs adjustment.
   *
   * This is to account for the item itself moving, which would cause a shift.
   */
  var isSameList = start.droppableId === target.droppableId;
  var isMovingForward = target.index > start.index;
  var shouldAdjust = isSameList && isMovingForward;

  /**
   * A clone is returned, even though it is the same value.
   * This is because the returned object might be mutated.
   */
  if (!shouldAdjust) {
    return _objectSpread({}, target);
  }
  return _objectSpread(_objectSpread({}, target), {}, {
    index: target.index - 1
  });
}