"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = require("react");
var _react2 = require("@emotion/react");
var _analyticsNext = require("@atlaskit/analytics-next");
var _noop = _interopRequireDefault(require("@atlaskit/ds-lib/noop"));
var _interactionContext = _interopRequireDefault(require("@atlaskit/interaction-context"));
var _styleMaps = require("../xcss/style-maps.partial");
var _xcss = require("../xcss/xcss");
var _excluded = ["children", "backgroundColor", "padding", "paddingBlock", "paddingBlockStart", "paddingBlockEnd", "paddingInline", "paddingInlineStart", "paddingInlineEnd", "isDisabled", "type", "onClick", "interactionName", "componentName", "analyticsContext", "style", "testId", "xcss"],
  _excluded2 = ["className"];
/**
 * @jsxRuntime classic
 * @jsx jsx
 */
// eslint-disable-next-line @atlaskit/ui-styling-standard/use-compiled -- Ignored via go/DSP-18766
// This duplicates FocusRing styles from `@atlaskit/focus-ring`.
var focusRingStyles = (0, _react2.css)({
  '&:focus, &:focus-visible': {
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values, @atlaskit/ui-styling-standard/no-unsafe-values
    outlineColor: _styleMaps.borderColorMap['color.border.focused'],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values, @atlaskit/ui-styling-standard/no-unsafe-values
    outlineOffset: _styleMaps.positiveSpaceMap['space.025'],
    outlineStyle: 'solid',
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values, @atlaskit/ui-styling-standard/no-unsafe-values
    outlineWidth: _styleMaps.borderWidthMap['border.width.outline']
  },
  // eslint-disable-next-line @atlaskit/ui-styling-standard/no-unsafe-selectors
  '&:focus:not(:focus-visible)': {
    outline: 'none'
  },
  '@media screen and (forced-colors: active), screen and (-ms-high-contrast: active)': {
    '&:focus-visible': {
      outline: '1px solid'
    }
  }
});
var baseStyles = (0, _react2.css)({
  boxSizing: 'border-box',
  appearance: 'none',
  border: 'none'
});
var enabledStyles = (0, _react2.css)({
  cursor: 'pointer'
});
var disabledStyles = (0, _react2.css)({
  cursor: 'not-allowed'
});

/**
 * __Pressable__
 *
 * A primitive for building custom buttons.
 *
 * - [Examples](https://atlassian.design/components/primitives/pressable/examples)
 * - [Code](https://atlassian.design/components/primitives/pressable/code)
 * - [Usage](https://atlassian.design/components/primitives/pressable/usage)
 */
var Pressable = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var children = _ref.children,
    backgroundColor = _ref.backgroundColor,
    padding = _ref.padding,
    paddingBlock = _ref.paddingBlock,
    paddingBlockStart = _ref.paddingBlockStart,
    paddingBlockEnd = _ref.paddingBlockEnd,
    paddingInline = _ref.paddingInline,
    paddingInlineStart = _ref.paddingInlineStart,
    paddingInlineEnd = _ref.paddingInlineEnd,
    isDisabled = _ref.isDisabled,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'button' : _ref$type,
    _ref$onClick = _ref.onClick,
    providedOnClick = _ref$onClick === void 0 ? _noop.default : _ref$onClick,
    interactionName = _ref.interactionName,
    componentName = _ref.componentName,
    analyticsContext = _ref.analyticsContext,
    style = _ref.style,
    testId = _ref.testId,
    xcss = _ref.xcss,
    htmlAttributes = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var interactionContext = (0, _react.useContext)(_interactionContext.default);
  var handleClick = (0, _react.useCallback)(function (e, analyticsEvent) {
    interactionContext && interactionContext.tracePress(interactionName, e.timeStamp);
    providedOnClick(e, analyticsEvent);
  }, [providedOnClick, interactionContext, interactionName]);
  var onClick = (0, _analyticsNext.usePlatformLeafEventHandler)({
    fn: handleClick,
    action: 'clicked',
    componentName: componentName || 'Pressable',
    packageName: "@atlaskit/primitives",
    packageVersion: "14.8.0",
    analyticsData: analyticsContext,
    actionSubject: 'button'
  });

  // This is to remove className from safeHtmlAttributes
  // @ts-expect-error className doesn't exist in the prop definition but we want to ensure it cannot be applied even if types are bypassed
  var _spreadClass = htmlAttributes.className,
    safeHtmlAttributes = (0, _objectWithoutProperties2.default)(htmlAttributes, _excluded2);
  var resolvedStyles = (0, _xcss.parseXcss)(xcss);
  return (0, _react2.jsx)("button", (0, _extends2.default)({
    // eslint-disable-next-line @atlaskit/ui-styling-standard/enforce-style-prop -- Ignored via go/DSP-18766
    style: style,
    ref: ref
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-classname-prop -- Ignored via go/DSP-18766
    ,
    className: resolvedStyles.static
  }, safeHtmlAttributes, {
    // eslint-disable-next-line react/button-has-type
    type: type,
    onClick: onClick,
    disabled: isDisabled,
    css: [baseStyles, focusRingStyles, isDisabled ? disabledStyles : enabledStyles,
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    backgroundColor && _styleMaps.backgroundColorStylesMap[backgroundColor],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    padding && _styleMaps.paddingStylesMap.padding[padding],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    paddingBlock && _styleMaps.paddingStylesMap.paddingBlock[paddingBlock],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    paddingBlockStart && _styleMaps.paddingStylesMap.paddingBlockStart[paddingBlockStart],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    paddingBlockEnd && _styleMaps.paddingStylesMap.paddingBlockEnd[paddingBlockEnd],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    paddingInline && _styleMaps.paddingStylesMap.paddingInline[paddingInline],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    paddingInlineStart && _styleMaps.paddingStylesMap.paddingInlineStart[paddingInlineStart],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    paddingInlineEnd && _styleMaps.paddingStylesMap.paddingInlineEnd[paddingInlineEnd], resolvedStyles.emotion],
    "data-testid": testId
  }), children);
});
var _default = exports.default = Pressable;