#!/bin/sh
# A simple script that generates loongarch-str.h and loongarch.opt
# from genopt/loongarch-optstr.
#
# Copyright (C) 2021-2025 Free Software Foundation, Inc.
#
# This file is part of GCC.
#
# GCC is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 3, or (at your option) any later
# version.
#
# GCC is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
# License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GCC; see the file COPYING3.  If not see
# <http://www.gnu.org/licenses/>.

cd "$(dirname "$0")"

# Generate a header containing definitions from the string table.
gen_defines() {
    cat <<EOF
/* Generated automatically by "genstr" from "loongarch-strings" and
   "isa-evolution.in".  Please do not edit this file directly.

   Copyright (C) 2021-2025 Free Software Foundation, Inc.
   Contributed by Loongson Ltd.

This file is part of GCC.

GCC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GCC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#ifndef LOONGARCH_STR_H
#define LOONGARCH_STR_H
EOF

    awk '/^#.*$/ { next } /^$/ { print; next }
         { printf ("#define %s \"%s\"\n", $1, $2) }' \
         loongarch-strings

    echo

    # Generate the strings from isa-evolution.in.
    awk '{
      a=$3
      gsub(/-/, "_", a)
      print("#define OPTSTR_"toupper(a)"\t\""$3"\"")
    }' isa-evolution.in

    echo
    echo "#endif /* LOONGARCH_STR_H */"
}


# Substitute all "@@<KEY>@@" to "<VALUE>" in loongarch.opt.in
# according to the key-value pairs defined in loongarch-strings.

gen_options() {
    # print a header
    cat << EOF
; Generated by "genstr" from the template "loongarch.opt.in"
; and definitions from "loongarch-strings" and "isa-evolution.in".
;
; Please do not edit this file directly.
; It will be automatically updated during a gcc build
; if you change "loongarch.opt.in", "loongarch-strings", or
; "isa-evolution.in".
;
EOF

    # Generate loongarch.opt.
    awk 'BEGIN {
            delete strtab
            while (getline < "loongarch-strings" > 0) {
                if ($0 ~ /^#.*$/ || $0 ~ /^$/) continue
                strtab[$1] = $2
            }
        }
        {
            n = split($0, tmp, "@@")
            for (i = 2; i <= n; i += 2)
                tmp[i] = strtab[tmp[i]]

            for (i = 1; i <= n; i++)
                printf("%s", tmp[i])
            printf ("\n")

        }' loongarch.opt.in


    # Generate the strings from isa-evolution.in.
    awk '{
      print("")
      print("m"$3)
      gsub(/-/, "_", $3)
      print("Target Mask(ISA_"toupper($3)") Var(la_isa_evolution)")
      $1=""; $2=""; $3=""; $4=""
      sub(/^ */, "", $0)
      print($0)
    }' isa-evolution.in
}

main() {
    case "$1" in
	evolution_h)
            awk -v header_p=1 -f gen-evolution.awk isa-evolution.in
            ;;
	evolution_c)
            awk -v header_p=0 -f gen-evolution.awk isa-evolution.in
            ;;
	evolution_def)
            awk -v header_p=2 -f gen-evolution.awk isa-evolution.in
            ;;
	header)
            gen_defines
            ;;
	opt)
            gen_options
            ;;
	*)
            echo "Unknown Command: \"$1\". Available: header, opt, evolution_h, evolution_c"
            exit 1
            ;;
    esac
}

main "$@"
