/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.choiceset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.ChooseInformation;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.content.CNAbilityFactory;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.Nature;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.helper.CNAbilitySelection;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Deity;
import pcgen.core.PlayerCharacter;
import pcgen.core.WeaponProf;

public class AbilityRefChoiceSet
implements PrimitiveChoiceSet<CNAbilitySelection> {
    private final Set<CDOMReference<Ability>> abilityRefSet;
    private final CDOMSingleRef<AbilityCategory> category;
    private final Nature nature;

    public AbilityRefChoiceSet(CDOMSingleRef<AbilityCategory> cat, Collection<? extends CDOMReference<Ability>> arCollection, Nature nat) {
        if (arCollection == null) {
            throw new IllegalArgumentException("Choice Collection cannot be null");
        }
        if (arCollection.isEmpty()) {
            throw new IllegalArgumentException("Choice Collection cannot be empty");
        }
        this.abilityRefSet = new HashSet<CDOMReference<Ability>>(arCollection);
        if (nat == null) {
            throw new IllegalArgumentException("Choice Nature cannot be null");
        }
        this.nature = nat;
        if (cat == null) {
            throw new IllegalArgumentException("Choice Category cannot be null");
        }
        this.category = cat;
    }

    @Override
    public String getLSTformat(boolean useAny) {
        TreeSet sortedSet = new TreeSet(ReferenceUtilities.REFERENCE_SORTER);
        for (CDOMReference<Ability> ar : this.abilityRefSet) {
            sortedSet.add(ar);
        }
        return ReferenceUtilities.joinLstFormat(sortedSet, ",", useAny);
    }

    @Override
    public Class<CNAbilitySelection> getChoiceClass() {
        return CNAbilitySelection.class;
    }

    @Override
    public Set<CNAbilitySelection> getSet(PlayerCharacter pc) {
        LinkedHashSet<CNAbilitySelection> returnSet = new LinkedHashSet<CNAbilitySelection>();
        for (CDOMReference<Ability> ref : this.abilityRefSet) {
            for (Ability a : ref.getContainedObjects()) {
                if (a.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
                    returnSet.addAll(this.addMultiplySelectableAbility(pc, a, ref.getChoice()));
                    continue;
                }
                returnSet.add(new CNAbilitySelection(CNAbilityFactory.getCNAbility(this.category.resolvesTo(), this.nature, a)));
            }
        }
        return returnSet;
    }

    private Collection<CNAbilitySelection> addMultiplySelectableAbility(PlayerCharacter aPC, Ability ability, String subName) {
        boolean isPattern = false;
        String nameRoot = null;
        if (subName != null) {
            int percIdx = subName.indexOf(37);
            if (percIdx > -1) {
                isPattern = true;
                nameRoot = subName.substring(0, percIdx);
            } else if (subName.length() != 0) {
                nameRoot = subName;
            }
        }
        ChooseInformation<?> chooseInfo = ability.get(ObjectKey.CHOOSE_INFO);
        List<String> availableList = this.getAvailableList(aPC, chooseInfo);
        if ("DEITYWEAPON".equals(nameRoot) && chooseInfo != null && chooseInfo.getClassIdentity().getChoiceClass().equals(WeaponProf.class)) {
            Deity deity = aPC.getDeity();
            if (deity == null) {
                availableList.clear();
            } else {
                List<CDOMReference<WeaponProf>> dwp = deity.getSafeListFor(ListKey.DEITYWEAPON);
                HashSet<String> set = new HashSet<String>();
                for (CDOMReference<WeaponProf> ref : dwp) {
                    for (WeaponProf wp : ref.getContainedObjects()) {
                        set.add(wp.getKeyName());
                    }
                }
                availableList.retainAll(set);
            }
        } else if (nameRoot != null && nameRoot.length() != 0) {
            for (int n = availableList.size() - 1; n >= 0; --n) {
                String aString = availableList.get(n);
                if (aString.startsWith(nameRoot)) continue;
                availableList.remove(n);
            }
            if (isPattern && !availableList.isEmpty()) {
                availableList.add(nameRoot);
            }
        }
        ArrayList<CNAbilitySelection> returnList = new ArrayList<CNAbilitySelection>(availableList.size());
        for (String s : availableList) {
            returnList.add(new CNAbilitySelection(CNAbilityFactory.getCNAbility(this.category.resolvesTo(), this.nature, ability), s));
        }
        return returnList;
    }

    private <T> List<String> getAvailableList(PlayerCharacter aPC, ChooseInformation<T> chooseInfo) {
        ArrayList<String> availableList = new ArrayList<String>();
        Collection<T> tempAvailList = chooseInfo.getSet(aPC);
        for (T o : tempAvailList) {
            availableList.add(chooseInfo.encodeChoice(o));
        }
        return availableList;
    }

    public int hashCode() {
        return this.abilityRefSet.size();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbilityRefChoiceSet) {
            AbilityRefChoiceSet other = (AbilityRefChoiceSet)obj;
            return this.abilityRefSet.equals(other.abilityRefSet);
        }
        return false;
    }

    public CDOMSingleRef<AbilityCategory> getCategory() {
        return this.category;
    }

    public Nature getNature() {
        return this.nature;
    }

    @Override
    public GroupingState getGroupingState() {
        GroupingState state = GroupingState.EMPTY;
        for (CDOMReference<Ability> ref : this.abilityRefSet) {
            state = state.add(ref.getGroupingState());
        }
        return state;
    }
}

