/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.converter;

import java.util.Collection;
import pcgen.base.util.ObjectContainer;
import pcgen.cdom.base.Converter;
import pcgen.cdom.base.PrimitiveFilter;
import pcgen.core.PlayerCharacter;

public class NegateFilterConverter<B, R>
implements Converter<B, R> {
    private final Converter<B, R> converter;
    private static final PrimitiveFilter PREVENT = new PrimitiveFilter(){

        public boolean allow(PlayerCharacter pc, Object obj) {
            return false;
        }
    };

    public NegateFilterConverter(Converter<B, R> conv) {
        if (conv == null) {
            throw new IllegalArgumentException("Converter cannot be null");
        }
        this.converter = conv;
    }

    @Override
    public Collection<? extends R> convert(ObjectContainer<B> orig) {
        return this.converter.convert(orig, PREVENT);
    }

    @Override
    public Collection<? extends R> convert(ObjectContainer<B> orig, PrimitiveFilter<B> lim) {
        return this.converter.convert(orig, new InvertingFilter<B>(lim));
    }

    public int hashCode() {
        return this.converter.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof NegateFilterConverter && ((NegateFilterConverter)obj).converter.equals(this.converter);
    }

    private static final class InvertingFilter<T>
    implements PrimitiveFilter<T> {
        private final PrimitiveFilter<T> filter;

        public InvertingFilter(PrimitiveFilter<T> fil) {
            if (fil == null) {
                throw new IllegalArgumentException("PrimitiveFilter cannot be null");
            }
            this.filter = fil;
        }

        @Override
        public boolean allow(PlayerCharacter pc, T obj) {
            return !this.filter.allow(pc, obj);
        }
    }
}

