/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.dialog;

import gmgen.gui.PreferencesPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import pcgen.pluginmgr.PluginManager;
import pcgen.system.LanguageBundle;
import pcgen.system.PCGenSettings;

class PreferencesPluginsPanel
extends PreferencesPanel {
    private final HashMap<String, PluginRef> pluginMap = new HashMap();
    private JPanel mainPanel;
    private JScrollPane jScrollPane1;

    public PreferencesPluginsPanel() {
        for (PluginManager.PluginInfo info : PluginManager.getInstance().getPluginInfoList()) {
            this.addPanel(info.logName, info.pluginName, "GMGen");
        }
        this.initComponents();
        this.initPreferences();
    }

    @Override
    public void applyPreferences() {
        for (String key : this.pluginMap.keySet()) {
            this.pluginMap.get(key).applyPreferences();
        }
    }

    @Override
    public void initPreferences() {
        for (String key : this.pluginMap.keySet()) {
            this.pluginMap.get(key).initPreferences();
        }
    }

    @Override
    public String toString() {
        return LanguageBundle.getString("in_Prefs_pluginsTitle");
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.mainPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        for (String key : this.pluginMap.keySet()) {
            this.mainPanel.add(this.pluginMap.get(key));
        }
        this.jScrollPane1.setViewportView(this.mainPanel);
        this.add((Component)this.jScrollPane1, "Center");
        this.add((Component)new JLabel(LanguageBundle.getString("in_Prefs_restartInfo")), "South");
    }

    private void addPanel(String pluginName, String pluginTitle, String defaultSystem) {
        if (!this.pluginMap.containsKey(pluginName)) {
            PluginRef pluginRef = new PluginRef(pluginName, pluginTitle, defaultSystem);
            this.pluginMap.put(pluginName, pluginRef);
        }
    }

    private static class PluginRef
    extends JPanel {
        private String pluginName;
        private String pluginTitle;
        private String defaultSystem;
        private JCheckBox checkBox;
        private JRadioButton pcgenButton;
        private JRadioButton gmgenButton;

        public PluginRef(String pluginName, String pluginTitle, String defaultSystem) {
            this.pluginName = pluginName;
            this.pluginTitle = pluginTitle;
            this.defaultSystem = defaultSystem;
            this.initComponents();
        }

        private void initComponents() {
            this.checkBox = new JCheckBox();
            this.pcgenButton = new JRadioButton();
            this.gmgenButton = new JRadioButton();
            ButtonGroup pluginGroup = new ButtonGroup();
            this.setLayout(new BoxLayout(this, 0));
            this.setBorder(new TitledBorder(null, this.pluginTitle, 0, 0));
            this.checkBox.setText(LanguageBundle.getString("in_Prefs_pluginsRun"));
            this.add(this.checkBox);
            this.pcgenButton.setText(LanguageBundle.getString("in_Prefs_pluginPcgenWin"));
            this.pcgenButton.setEnabled(false);
            pluginGroup.add(this.pcgenButton);
            this.add(this.pcgenButton);
            this.gmgenButton.setText(LanguageBundle.getString("in_Prefs_pluginGMGenWin"));
            pluginGroup.add(this.gmgenButton);
            this.add(this.gmgenButton);
        }

        public void initPreferences() {
            this.checkBox.setSelected(PCGenSettings.GMGEN_OPTIONS_CONTEXT.initBoolean(this.pluginName + ".Load", true));
            String system = "GMGen";
            if (system.equals("PCGen")) {
                this.pcgenButton.setSelected(true);
            } else {
                this.gmgenButton.setSelected(true);
            }
        }

        public void applyPreferences() {
            PCGenSettings.GMGEN_OPTIONS_CONTEXT.setBoolean(this.pluginName + ".Load", this.checkBox.isSelected());
            if (this.pcgenButton.isSelected()) {
                PCGenSettings.GMGEN_OPTIONS_CONTEXT.setProperty(this.pluginName + ".System", "PCGen");
            } else {
                PCGenSettings.GMGEN_OPTIONS_CONTEXT.setProperty(this.pluginName + ".System", "GMGen");
            }
        }
    }
}

