/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGUniverse;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.engine.GraphvizException;
import guru.nidi.graphviz.engine.SvgRasterizer;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.function.Consumer;

class SalamanderRasterizer
extends SvgRasterizer {
    SalamanderRasterizer() {
    }

    @Override
    public BufferedImage doRasterize(Graphviz graphviz, Consumer<Graphics2D> graphicsConfigurer, String svg) {
        SVGDiagram diagram = this.createDiagram(svg);
        BufferedImage image = new BufferedImage((int)diagram.getWidth(), (int)diagram.getHeight(), 2);
        Graphics2D graphics = image.createGraphics();
        this.configGraphics(graphics);
        graphicsConfigurer.accept(graphics);
        this.renderDiagram(diagram, graphics);
        return image;
    }

    private SVGDiagram createDiagram(String svg) {
        SVGUniverse universe = new SVGUniverse();
        URI uri = universe.loadSVG((Reader)new StringReader(svg), "//graph/");
        SVGDiagram diagram = universe.getDiagram(uri);
        diagram.setIgnoringClipHeuristic(true);
        return diagram;
    }

    private void renderDiagram(SVGDiagram diagram, Graphics2D graphics) {
        try {
            diagram.render(graphics);
        }
        catch (SVGException e) {
            throw new GraphvizException("Problem rendering SVG", e);
        }
    }

    private void configGraphics(Graphics2D graphics) {
        graphics.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }
}

