/* automatically generated by rust-bindgen 0.70.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
#[derive(PartialEq, Copy, Clone, Hash, Debug, Default)]
#[repr(C)]
pub struct __BindgenComplex<T> {
    pub re: T,
    pub im: T,
}
pub const __HIP_ARCH_HAS_GLOBAL_INT32_ATOMICS__: u32 = 0;
pub const __HIP_ARCH_HAS_GLOBAL_FLOAT_ATOMIC_EXCH__: u32 = 0;
pub const __HIP_ARCH_HAS_SHARED_INT32_ATOMICS__: u32 = 0;
pub const __HIP_ARCH_HAS_SHARED_FLOAT_ATOMIC_EXCH__: u32 = 0;
pub const __HIP_ARCH_HAS_FLOAT_ATOMIC_ADD__: u32 = 0;
pub const __HIP_ARCH_HAS_GLOBAL_INT64_ATOMICS__: u32 = 0;
pub const __HIP_ARCH_HAS_SHARED_INT64_ATOMICS__: u32 = 0;
pub const __HIP_ARCH_HAS_DOUBLES__: u32 = 0;
pub const __HIP_ARCH_HAS_WARP_VOTE__: u32 = 0;
pub const __HIP_ARCH_HAS_WARP_BALLOT__: u32 = 0;
pub const __HIP_ARCH_HAS_WARP_SHUFFLE__: u32 = 0;
pub const __HIP_ARCH_HAS_WARP_FUNNEL_SHIFT__: u32 = 0;
pub const __HIP_ARCH_HAS_THREAD_FENCE_SYSTEM__: u32 = 0;
pub const __HIP_ARCH_HAS_SYNC_THREAD_EXT__: u32 = 0;
pub const __HIP_ARCH_HAS_SURFACE_FUNCS__: u32 = 0;
pub const __HIP_ARCH_HAS_3DGRID__: u32 = 0;
pub const __HIP_ARCH_HAS_DYNAMIC_PARALLEL__: u32 = 0;
pub const _FEATURES_H: u32 = 1;
pub const _DEFAULT_SOURCE: u32 = 1;
pub const __GLIBC_USE_ISOC2Y: u32 = 0;
pub const __GLIBC_USE_ISOC23: u32 = 0;
pub const __USE_ISOC11: u32 = 1;
pub const __USE_ISOC99: u32 = 1;
pub const __USE_ISOC95: u32 = 1;
pub const __USE_POSIX_IMPLICITLY: u32 = 1;
pub const _POSIX_SOURCE: u32 = 1;
pub const _POSIX_C_SOURCE: u32 = 200809;
pub const __USE_POSIX: u32 = 1;
pub const __USE_POSIX2: u32 = 1;
pub const __USE_POSIX199309: u32 = 1;
pub const __USE_POSIX199506: u32 = 1;
pub const __USE_XOPEN2K: u32 = 1;
pub const __USE_XOPEN2K8: u32 = 1;
pub const _ATFILE_SOURCE: u32 = 1;
pub const __WORDSIZE: u32 = 64;
pub const __WORDSIZE_TIME64_COMPAT32: u32 = 1;
pub const __SYSCALL_WORDSIZE: u32 = 64;
pub const __TIMESIZE: u32 = 64;
pub const __USE_TIME_BITS64: u32 = 1;
pub const __USE_MISC: u32 = 1;
pub const __USE_ATFILE: u32 = 1;
pub const __USE_FORTIFY_LEVEL: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_GETS: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_SCANF: u32 = 0;
pub const __GLIBC_USE_C23_STRTOL: u32 = 0;
pub const _STDC_PREDEF_H: u32 = 1;
pub const __STDC_IEC_559__: u32 = 1;
pub const __STDC_IEC_60559_BFP__: u32 = 201404;
pub const __STDC_IEC_559_COMPLEX__: u32 = 1;
pub const __STDC_IEC_60559_COMPLEX__: u32 = 201404;
pub const __STDC_ISO_10646__: u32 = 201706;
pub const __GNU_LIBRARY__: u32 = 6;
pub const __GLIBC__: u32 = 2;
pub const __GLIBC_MINOR__: u32 = 41;
pub const _SYS_CDEFS_H: u32 = 1;
pub const __glibc_c99_flexarr_available: u32 = 1;
pub const __LDOUBLE_REDIRECTS_TO_FLOAT128_ABI: u32 = 0;
pub const __HAVE_GENERIC_SELECTION: u32 = 1;
pub const __GLIBC_USE_LIB_EXT2: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT_C23: u32 = 0;
pub const __GLIBC_USE_IEC_60559_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT_C23: u32 = 0;
pub const __GLIBC_USE_IEC_60559_TYPES_EXT: u32 = 0;
pub const _STDLIB_H: u32 = 1;
pub const WNOHANG: u32 = 1;
pub const WUNTRACED: u32 = 2;
pub const WSTOPPED: u32 = 2;
pub const WEXITED: u32 = 4;
pub const WCONTINUED: u32 = 8;
pub const WNOWAIT: u32 = 16777216;
pub const __WNOTHREAD: u32 = 536870912;
pub const __WALL: u32 = 1073741824;
pub const __WCLONE: u32 = 2147483648;
pub const __W_CONTINUED: u32 = 65535;
pub const __WCOREFLAG: u32 = 128;
pub const __HAVE_FLOAT128: u32 = 1;
pub const __HAVE_DISTINCT_FLOAT128: u32 = 1;
pub const __HAVE_FLOAT64X: u32 = 1;
pub const __HAVE_FLOAT64X_LONG_DOUBLE: u32 = 1;
pub const __HAVE_FLOAT16: u32 = 0;
pub const __HAVE_FLOAT32: u32 = 1;
pub const __HAVE_FLOAT64: u32 = 1;
pub const __HAVE_FLOAT32X: u32 = 1;
pub const __HAVE_FLOAT128X: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT16: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT32: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT64: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT32X: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT64X: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT128X: u32 = 0;
pub const __HAVE_FLOATN_NOT_TYPEDEF: u32 = 0;
pub const __ldiv_t_defined: u32 = 1;
pub const __lldiv_t_defined: u32 = 1;
pub const RAND_MAX: u32 = 2147483647;
pub const EXIT_FAILURE: u32 = 1;
pub const EXIT_SUCCESS: u32 = 0;
pub const _SYS_TYPES_H: u32 = 1;
pub const _BITS_TYPES_H: u32 = 1;
pub const _BITS_TYPESIZES_H: u32 = 1;
pub const __OFF_T_MATCHES_OFF64_T: u32 = 1;
pub const __INO_T_MATCHES_INO64_T: u32 = 1;
pub const __RLIM_T_MATCHES_RLIM64_T: u32 = 1;
pub const __STATFS_MATCHES_STATFS64: u32 = 1;
pub const __KERNEL_OLD_TIMEVAL_MATCHES_TIMEVAL64: u32 = 1;
pub const __FD_SETSIZE: u32 = 1024;
pub const _BITS_TIME64_H: u32 = 1;
pub const __clock_t_defined: u32 = 1;
pub const __clockid_t_defined: u32 = 1;
pub const __time_t_defined: u32 = 1;
pub const __timer_t_defined: u32 = 1;
pub const _BITS_STDINT_INTN_H: u32 = 1;
pub const __BIT_TYPES_DEFINED__: u32 = 1;
pub const _ENDIAN_H: u32 = 1;
pub const _BITS_ENDIAN_H: u32 = 1;
pub const __LITTLE_ENDIAN: u32 = 1234;
pub const __BIG_ENDIAN: u32 = 4321;
pub const __PDP_ENDIAN: u32 = 3412;
pub const _BITS_ENDIANNESS_H: u32 = 1;
pub const __BYTE_ORDER: u32 = 1234;
pub const __FLOAT_WORD_ORDER: u32 = 1234;
pub const LITTLE_ENDIAN: u32 = 1234;
pub const BIG_ENDIAN: u32 = 4321;
pub const PDP_ENDIAN: u32 = 3412;
pub const BYTE_ORDER: u32 = 1234;
pub const _BITS_BYTESWAP_H: u32 = 1;
pub const _BITS_UINTN_IDENTITY_H: u32 = 1;
pub const _SYS_SELECT_H: u32 = 1;
pub const __sigset_t_defined: u32 = 1;
pub const __timeval_defined: u32 = 1;
pub const _STRUCT_TIMESPEC: u32 = 1;
pub const FD_SETSIZE: u32 = 1024;
pub const _BITS_PTHREADTYPES_COMMON_H: u32 = 1;
pub const _THREAD_SHARED_TYPES_H: u32 = 1;
pub const _BITS_PTHREADTYPES_ARCH_H: u32 = 1;
pub const __SIZEOF_PTHREAD_MUTEX_T: u32 = 40;
pub const __SIZEOF_PTHREAD_ATTR_T: u32 = 56;
pub const __SIZEOF_PTHREAD_RWLOCK_T: u32 = 56;
pub const __SIZEOF_PTHREAD_BARRIER_T: u32 = 32;
pub const __SIZEOF_PTHREAD_MUTEXATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_COND_T: u32 = 48;
pub const __SIZEOF_PTHREAD_CONDATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_RWLOCKATTR_T: u32 = 8;
pub const __SIZEOF_PTHREAD_BARRIERATTR_T: u32 = 4;
pub const _THREAD_MUTEX_INTERNAL_H: u32 = 1;
pub const __PTHREAD_MUTEX_HAVE_PREV: u32 = 1;
pub const __have_pthread_attr_t: u32 = 1;
pub const _ALLOCA_H: u32 = 1;
pub const _STRING_H: u32 = 1;
pub const _BITS_TYPES_LOCALE_T_H: u32 = 1;
pub const _BITS_TYPES___LOCALE_T_H: u32 = 1;
pub const _STRINGS_H: u32 = 1;
pub const HIP_VERSION_MAJOR: u32 = 6;
pub const HIP_VERSION_MINOR: u32 = 4;
pub const HIP_VERSION_PATCH: u32 = 43482;
pub const HIP_VERSION_GITHASH: &[u8; 10] = b"0f2d60242\0";
pub const HIP_VERSION_BUILD_ID: u32 = 0;
pub const HIP_VERSION_BUILD_NAME: &[u8; 1] = b"\0";
pub const HIP_VERSION: u32 = 60443482;
pub const __HIP_HAS_GET_PCH: u32 = 1;
pub const _STDINT_H: u32 = 1;
pub const _BITS_WCHAR_H: u32 = 1;
pub const _BITS_STDINT_UINTN_H: u32 = 1;
pub const _BITS_STDINT_LEAST_H: u32 = 1;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i64 = -9223372036854775808;
pub const INT_FAST32_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u64 = 9223372036854775807;
pub const INT_FAST32_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: i32 = -1;
pub const UINT_FAST32_MAX: i32 = -1;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const UINTPTR_MAX: i32 = -1;
pub const PTRDIFF_MIN: i64 = -9223372036854775808;
pub const PTRDIFF_MAX: u64 = 9223372036854775807;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const SIZE_MAX: i32 = -1;
pub const WINT_MIN: u32 = 0;
pub const WINT_MAX: u32 = 4294967295;
pub const GENERIC_GRID_LAUNCH: u32 = 1;
pub const __bool_true_false_are_defined: u32 = 1;
pub const true_: u32 = 1;
pub const false_: u32 = 0;
pub const HIP_TRSA_OVERRIDE_FORMAT: u32 = 1;
pub const HIP_TRSF_READ_AS_INTEGER: u32 = 1;
pub const HIP_TRSF_NORMALIZED_COORDINATES: u32 = 2;
pub const HIP_TRSF_SRGB: u32 = 16;
pub const _LIBC_LIMITS_H_: u32 = 1;
pub const MB_LEN_MAX: u32 = 16;
pub const _BITS_POSIX1_LIM_H: u32 = 1;
pub const _POSIX_AIO_LISTIO_MAX: u32 = 2;
pub const _POSIX_AIO_MAX: u32 = 1;
pub const _POSIX_ARG_MAX: u32 = 4096;
pub const _POSIX_CHILD_MAX: u32 = 25;
pub const _POSIX_DELAYTIMER_MAX: u32 = 32;
pub const _POSIX_HOST_NAME_MAX: u32 = 255;
pub const _POSIX_LINK_MAX: u32 = 8;
pub const _POSIX_LOGIN_NAME_MAX: u32 = 9;
pub const _POSIX_MAX_CANON: u32 = 255;
pub const _POSIX_MAX_INPUT: u32 = 255;
pub const _POSIX_MQ_OPEN_MAX: u32 = 8;
pub const _POSIX_MQ_PRIO_MAX: u32 = 32;
pub const _POSIX_NAME_MAX: u32 = 14;
pub const _POSIX_NGROUPS_MAX: u32 = 8;
pub const _POSIX_OPEN_MAX: u32 = 20;
pub const _POSIX_PATH_MAX: u32 = 256;
pub const _POSIX_PIPE_BUF: u32 = 512;
pub const _POSIX_RE_DUP_MAX: u32 = 255;
pub const _POSIX_RTSIG_MAX: u32 = 8;
pub const _POSIX_SEM_NSEMS_MAX: u32 = 256;
pub const _POSIX_SEM_VALUE_MAX: u32 = 32767;
pub const _POSIX_SIGQUEUE_MAX: u32 = 32;
pub const _POSIX_SSIZE_MAX: u32 = 32767;
pub const _POSIX_STREAM_MAX: u32 = 8;
pub const _POSIX_SYMLINK_MAX: u32 = 255;
pub const _POSIX_SYMLOOP_MAX: u32 = 8;
pub const _POSIX_TIMER_MAX: u32 = 32;
pub const _POSIX_TTY_NAME_MAX: u32 = 9;
pub const _POSIX_TZNAME_MAX: u32 = 6;
pub const _POSIX_CLOCKRES_MIN: u32 = 20000000;
pub const NR_OPEN: u32 = 1024;
pub const NGROUPS_MAX: u32 = 65536;
pub const ARG_MAX: u32 = 131072;
pub const LINK_MAX: u32 = 127;
pub const MAX_CANON: u32 = 255;
pub const MAX_INPUT: u32 = 255;
pub const NAME_MAX: u32 = 255;
pub const PATH_MAX: u32 = 4096;
pub const PIPE_BUF: u32 = 4096;
pub const XATTR_NAME_MAX: u32 = 255;
pub const XATTR_SIZE_MAX: u32 = 65536;
pub const XATTR_LIST_MAX: u32 = 65536;
pub const RTSIG_MAX: u32 = 32;
pub const _POSIX_THREAD_KEYS_MAX: u32 = 128;
pub const PTHREAD_KEYS_MAX: u32 = 1024;
pub const _POSIX_THREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const PTHREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const _POSIX_THREAD_THREADS_MAX: u32 = 64;
pub const AIO_PRIO_DELTA_MAX: u32 = 20;
pub const PTHREAD_STACK_MIN: u32 = 16384;
pub const DELAYTIMER_MAX: u32 = 2147483647;
pub const TTY_NAME_MAX: u32 = 32;
pub const LOGIN_NAME_MAX: u32 = 256;
pub const HOST_NAME_MAX: u32 = 64;
pub const MQ_PRIO_MAX: u32 = 32768;
pub const SEM_VALUE_MAX: u32 = 2147483647;
pub const _BITS_POSIX2_LIM_H: u32 = 1;
pub const _POSIX2_BC_BASE_MAX: u32 = 99;
pub const _POSIX2_BC_DIM_MAX: u32 = 2048;
pub const _POSIX2_BC_SCALE_MAX: u32 = 99;
pub const _POSIX2_BC_STRING_MAX: u32 = 1000;
pub const _POSIX2_COLL_WEIGHTS_MAX: u32 = 2;
pub const _POSIX2_EXPR_NEST_MAX: u32 = 32;
pub const _POSIX2_LINE_MAX: u32 = 2048;
pub const _POSIX2_RE_DUP_MAX: u32 = 255;
pub const _POSIX2_CHARCLASS_NAME_MAX: u32 = 14;
pub const BC_BASE_MAX: u32 = 99;
pub const BC_DIM_MAX: u32 = 2048;
pub const BC_SCALE_MAX: u32 = 99;
pub const BC_STRING_MAX: u32 = 1000;
pub const COLL_WEIGHTS_MAX: u32 = 255;
pub const EXPR_NEST_MAX: u32 = 32;
pub const LINE_MAX: u32 = 2048;
pub const CHARCLASS_NAME_MAX: u32 = 2048;
pub const RE_DUP_MAX: u32 = 32767;
pub const __HIP_USE_NATIVE_VECTOR__: u32 = 1;
pub const hipTextureType1D: u32 = 1;
pub const hipTextureType2D: u32 = 2;
pub const hipTextureType3D: u32 = 3;
pub const hipTextureTypeCubemap: u32 = 12;
pub const hipTextureType1DLayered: u32 = 241;
pub const hipTextureType2DLayered: u32 = 242;
pub const hipTextureTypeCubemapLayered: u32 = 252;
pub const HIP_IMAGE_OBJECT_SIZE_DWORD: u32 = 12;
pub const HIP_SAMPLER_OBJECT_SIZE_DWORD: u32 = 8;
pub const HIP_SAMPLER_OBJECT_OFFSET_DWORD: u32 = 12;
pub const HIP_TEXTURE_OBJECT_SIZE_DWORD: u32 = 20;
pub const HIP_DEPRECATED_MSG : & [u8 ; 189] = b"This API is marked as deprecated and might not be supported in future releases. For more details please refer https://github.com/ROCm/HIP/blob/develop/docs/reference/deprecated_api_list.md\0" ;
pub const hipIpcMemLazyEnablePeerAccess: u32 = 1;
pub const HIP_IPC_HANDLE_SIZE: u32 = 64;
pub const hipStreamDefault: u32 = 0;
pub const hipStreamNonBlocking: u32 = 1;
pub const hipEventDefault: u32 = 0;
pub const hipEventBlockingSync: u32 = 1;
pub const hipEventDisableTiming: u32 = 2;
pub const hipEventInterprocess: u32 = 4;
pub const hipEventRecordDefault: u32 = 0;
pub const hipEventRecordExternal: u32 = 1;
pub const hipEventDisableSystemFence: u32 = 536870912;
pub const hipEventReleaseToDevice: u32 = 1073741824;
pub const hipEventReleaseToSystem: u32 = 2147483648;
pub const hipHostAllocDefault: u32 = 0;
pub const hipHostMallocDefault: u32 = 0;
pub const hipHostAllocPortable: u32 = 1;
pub const hipHostMallocPortable: u32 = 1;
pub const hipHostAllocMapped: u32 = 2;
pub const hipHostMallocMapped: u32 = 2;
pub const hipHostAllocWriteCombined: u32 = 4;
pub const hipHostMallocWriteCombined: u32 = 4;
pub const hipHostMallocNumaUser: u32 = 536870912;
pub const hipHostMallocCoherent: u32 = 1073741824;
pub const hipHostMallocNonCoherent: u32 = 2147483648;
pub const hipMemAttachGlobal: u32 = 1;
pub const hipMemAttachHost: u32 = 2;
pub const hipMemAttachSingle: u32 = 4;
pub const hipDeviceMallocDefault: u32 = 0;
pub const hipDeviceMallocFinegrained: u32 = 1;
pub const hipMallocSignalMemory: u32 = 2;
pub const hipDeviceMallocUncached: u32 = 3;
pub const hipDeviceMallocContiguous: u32 = 4;
pub const hipHostRegisterDefault: u32 = 0;
pub const hipHostRegisterPortable: u32 = 1;
pub const hipHostRegisterMapped: u32 = 2;
pub const hipHostRegisterIoMemory: u32 = 4;
pub const hipHostRegisterReadOnly: u32 = 8;
pub const hipExtHostRegisterCoarseGrained: u32 = 8;
pub const hipDeviceScheduleAuto: u32 = 0;
pub const hipDeviceScheduleSpin: u32 = 1;
pub const hipDeviceScheduleYield: u32 = 2;
pub const hipDeviceScheduleBlockingSync: u32 = 4;
pub const hipDeviceScheduleMask: u32 = 7;
pub const hipDeviceMapHost: u32 = 8;
pub const hipDeviceLmemResizeToMax: u32 = 16;
pub const hipArrayDefault: u32 = 0;
pub const hipArrayLayered: u32 = 1;
pub const hipArraySurfaceLoadStore: u32 = 2;
pub const hipArrayCubemap: u32 = 4;
pub const hipArrayTextureGather: u32 = 8;
pub const hipOccupancyDefault: u32 = 0;
pub const hipOccupancyDisableCachingOverride: u32 = 1;
pub const hipCooperativeLaunchMultiDeviceNoPreSync: u32 = 1;
pub const hipCooperativeLaunchMultiDeviceNoPostSync: u32 = 2;
pub const hipExtAnyOrderLaunch: u32 = 1;
pub const hipStreamWaitValueGte: u32 = 0;
pub const hipStreamWaitValueEq: u32 = 1;
pub const hipStreamWaitValueAnd: u32 = 2;
pub const hipStreamWaitValueNor: u32 = 3;
pub const hipExternalMemoryDedicated: u32 = 1;
pub const hipGraphKernelNodePortDefault: u32 = 0;
pub const hipGraphKernelNodePortLaunchCompletion: u32 = 2;
pub const hipGraphKernelNodePortProgrammatic: u32 = 1;
pub const USE_PEER_NON_UNIFIED: u32 = 1;
#[doc = "< CUDA Only Maximum registers may be used in a thread,\n< passed to compiler"]
pub const hipJitOption_hipJitOptionMaxRegisters: hipJitOption = 0;
#[doc = "< CUDA Only Number of thread per block"]
pub const hipJitOption_hipJitOptionThreadsPerBlock: hipJitOption = 1;
#[doc = "< CUDA Only Value for total wall clock time"]
pub const hipJitOption_hipJitOptionWallTime: hipJitOption = 2;
#[doc = "< CUDA Only Pointer to the buffer with logged information"]
pub const hipJitOption_hipJitOptionInfoLogBuffer: hipJitOption = 3;
#[doc = "< CUDA Only Size of the buffer in bytes for logged info"]
pub const hipJitOption_hipJitOptionInfoLogBufferSizeBytes: hipJitOption = 4;
#[doc = "< CUDA Only Pointer to the buffer with logged error(s)"]
pub const hipJitOption_hipJitOptionErrorLogBuffer: hipJitOption = 5;
#[doc = "< CUDA Only Size of the buffer in bytes for logged error(s)"]
pub const hipJitOption_hipJitOptionErrorLogBufferSizeBytes: hipJitOption = 6;
#[doc = "< Value of optimization level for generated codes, acceptable options\n< -O0, -O1, -O2, -O3"]
pub const hipJitOption_hipJitOptionOptimizationLevel: hipJitOption = 7;
#[doc = "< CUDA Only The target context, which is the default"]
pub const hipJitOption_hipJitOptionTargetFromContext: hipJitOption = 8;
#[doc = "< CUDA Only JIT target"]
pub const hipJitOption_hipJitOptionTarget: hipJitOption = 9;
#[doc = "< CUDA Only Fallback strategy"]
pub const hipJitOption_hipJitOptionFallbackStrategy: hipJitOption = 10;
#[doc = "< CUDA Only Generate debug information"]
pub const hipJitOption_hipJitOptionGenerateDebugInfo: hipJitOption = 11;
#[doc = "< CUDA Only Generate log verbose"]
pub const hipJitOption_hipJitOptionLogVerbose: hipJitOption = 12;
#[doc = "< CUDA Only Generate line number information"]
pub const hipJitOption_hipJitOptionGenerateLineInfo: hipJitOption = 13;
#[doc = "< CUDA Only Set cache mode"]
pub const hipJitOption_hipJitOptionCacheMode: hipJitOption = 14;
#[doc = "< @deprecated CUDA Only New SM3X option."]
pub const hipJitOption_hipJitOptionSm3xOpt: hipJitOption = 15;
#[doc = "< CUDA Only Set fast compile"]
pub const hipJitOption_hipJitOptionFastCompile: hipJitOption = 16;
#[doc = "< CUDA Only Array of device symbol names to be relocated to the host"]
pub const hipJitOption_hipJitOptionGlobalSymbolNames: hipJitOption = 17;
#[doc = "< CUDA Only Array of host addresses to be relocated to the device"]
pub const hipJitOption_hipJitOptionGlobalSymbolAddresses: hipJitOption = 18;
#[doc = "< CUDA Only Number of symbol count."]
pub const hipJitOption_hipJitOptionGlobalSymbolCount: hipJitOption = 19;
#[doc = "< @deprecated CUDA Only Enable link-time optimization for device code"]
pub const hipJitOption_hipJitOptionLto: hipJitOption = 20;
#[doc = "< @deprecated CUDA Only Set single-precision denormals."]
pub const hipJitOption_hipJitOptionFtz: hipJitOption = 21;
#[doc = "< @deprecated CUDA Only Set single-precision floating-point division\n< and reciprocals"]
pub const hipJitOption_hipJitOptionPrecDiv: hipJitOption = 22;
#[doc = "< @deprecated CUDA Only Set single-precision floating-point square root"]
pub const hipJitOption_hipJitOptionPrecSqrt: hipJitOption = 23;
#[doc = "< @deprecated CUDA Only Enable floating-point multiplies and\n< adds/subtracts operations"]
pub const hipJitOption_hipJitOptionFma: hipJitOption = 24;
#[doc = "< CUDA Only Generates Position Independent code"]
pub const hipJitOption_hipJitOptionPositionIndependentCode: hipJitOption = 25;
#[doc = "< CUDA Only Hints to JIT compiler the minimum number of CTAs frin kernel's\n< grid to be mapped to SM"]
pub const hipJitOption_hipJitOptionMinCTAPerSM: hipJitOption = 26;
#[doc = "< CUDA only Maximum number of threads in a thread block"]
pub const hipJitOption_hipJitOptionMaxThreadsPerBlock: hipJitOption = 27;
#[doc = "< Cuda only Override Directive values"]
pub const hipJitOption_hipJitOptionOverrideDirectiveValues: hipJitOption = 28;
#[doc = "< Number of options"]
pub const hipJitOption_hipJitOptionNumOptions: hipJitOption = 29;
#[doc = "< Hip Only Linker options to be passed on to compiler"]
pub const hipJitOption_hipJitOptionIRtoISAOptExt: hipJitOption = 10000;
#[doc = "< Hip Only Count of linker options to be passed on to compiler"]
pub const hipJitOption_hipJitOptionIRtoISAOptCountExt: hipJitOption = 10001;
#[doc = " hipJitOption"]
pub type hipJitOption = ::std::os::raw::c_uint;
#[doc = "< Cuda only Input cubin"]
pub const hipJitInputType_hipJitInputCubin: hipJitInputType = 0;
#[doc = "< Cuda only Input PTX"]
pub const hipJitInputType_hipJitInputPtx: hipJitInputType = 1;
#[doc = "< Cuda Only Input FAT Binary"]
pub const hipJitInputType_hipJitInputFatBinary: hipJitInputType = 2;
#[doc = "< Cuda Only Host Object with embedded device code"]
pub const hipJitInputType_hipJitInputObject: hipJitInputType = 3;
#[doc = "< Cuda Only Archive of Host Objects with embedded\n< device code"]
pub const hipJitInputType_hipJitInputLibrary: hipJitInputType = 4;
#[doc = "< @deprecated Cuda only High Level intermediate\n< code for LTO"]
pub const hipJitInputType_hipJitInputNvvm: hipJitInputType = 5;
#[doc = "< Count of Legacy Input Types"]
pub const hipJitInputType_hipJitNumLegacyInputTypes: hipJitInputType = 6;
#[doc = "< HIP Only LLVM Bitcode or IR assembly"]
pub const hipJitInputType_hipJitInputLLVMBitcode: hipJitInputType = 100;
#[doc = "< HIP Only LLVM Clang Bundled Code"]
pub const hipJitInputType_hipJitInputLLVMBundledBitcode: hipJitInputType = 101;
#[doc = "< HIP Only LLVM Archive of Bundled Bitcode"]
pub const hipJitInputType_hipJitInputLLVMArchivesOfBundledBitcode: hipJitInputType = 102;
#[doc = "< HIP Only SPIRV Code Object"]
pub const hipJitInputType_hipJitInputSpirv: hipJitInputType = 103;
#[doc = "< Count of Input Types"]
pub const hipJitInputType_hipJitNumInputTypes: hipJitInputType = 10;
#[doc = " hipJitInputType"]
pub type hipJitInputType = ::std::os::raw::c_uint;
pub const hipJitCacheMode_hipJitCacheOptionNone: hipJitCacheMode = 0;
pub const hipJitCacheMode_hipJitCacheOptionCG: hipJitCacheMode = 1;
pub const hipJitCacheMode_hipJitCacheOptionCA: hipJitCacheMode = 2;
#[doc = " hipJitCacheMode"]
pub type hipJitCacheMode = ::std::os::raw::c_uint;
pub const hipJitFallback_hipJitPreferPTX: hipJitFallback = 0;
pub const hipJitFallback_hipJitPreferBinary: hipJitFallback = 1;
#[doc = " hipJitFallback"]
pub type hipJitFallback = ::std::os::raw::c_uint;
pub type wchar_t = ::std::os::raw::c_int;
pub type __cfloat128 = __BindgenComplex<u128>;
pub type _Float128 = u128;
pub type _Float32 = f32;
pub type _Float64 = f64;
pub type _Float32x = f64;
pub type _Float64x = u128;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct div_t {
    pub quot: ::std::os::raw::c_int,
    pub rem: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ldiv_t {
    pub quot: ::std::os::raw::c_long,
    pub rem: ::std::os::raw::c_long,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lldiv_t {
    pub quot: ::std::os::raw::c_longlong,
    pub rem: ::std::os::raw::c_longlong,
}
extern "C" {
    pub fn __ctype_get_mb_cur_max() -> usize;
}
extern "C" {
    pub fn atof(__nptr: *const ::std::os::raw::c_char) -> f64;
}
extern "C" {
    pub fn atoi(__nptr: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn atol(__nptr: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn atoll(__nptr: *const ::std::os::raw::c_char) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtod(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
    ) -> f64;
}
extern "C" {
    pub fn strtof(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
    ) -> f32;
}
extern "C" {
    pub fn strtold(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
    ) -> u128;
}
extern "C" {
    pub fn strtol(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn strtoul(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strtoq(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtouq(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn strtoll(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtoull(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn l64a(__n: ::std::os::raw::c_long) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn a64l(__s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
pub type __u_char = ::std::os::raw::c_uchar;
pub type __u_short = ::std::os::raw::c_ushort;
pub type __u_int = ::std::os::raw::c_uint;
pub type __u_long = ::std::os::raw::c_ulong;
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_long;
pub type __uint64_t = ::std::os::raw::c_ulong;
pub type __int_least8_t = __int8_t;
pub type __uint_least8_t = __uint8_t;
pub type __int_least16_t = __int16_t;
pub type __uint_least16_t = __uint16_t;
pub type __int_least32_t = __int32_t;
pub type __uint_least32_t = __uint32_t;
pub type __int_least64_t = __int64_t;
pub type __uint_least64_t = __uint64_t;
pub type __quad_t = ::std::os::raw::c_long;
pub type __u_quad_t = ::std::os::raw::c_ulong;
pub type __intmax_t = ::std::os::raw::c_long;
pub type __uintmax_t = ::std::os::raw::c_ulong;
pub type __dev_t = ::std::os::raw::c_ulong;
pub type __uid_t = ::std::os::raw::c_uint;
pub type __gid_t = ::std::os::raw::c_uint;
pub type __ino_t = ::std::os::raw::c_ulong;
pub type __ino64_t = ::std::os::raw::c_ulong;
pub type __mode_t = ::std::os::raw::c_uint;
pub type __nlink_t = ::std::os::raw::c_ulong;
pub type __off_t = ::std::os::raw::c_long;
pub type __off64_t = ::std::os::raw::c_long;
pub type __pid_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __fsid_t {
    pub __val: [::std::os::raw::c_int; 2usize],
}
pub type __clock_t = ::std::os::raw::c_long;
pub type __rlim_t = ::std::os::raw::c_ulong;
pub type __rlim64_t = ::std::os::raw::c_ulong;
pub type __id_t = ::std::os::raw::c_uint;
pub type __time_t = ::std::os::raw::c_long;
pub type __useconds_t = ::std::os::raw::c_uint;
pub type __suseconds_t = ::std::os::raw::c_long;
pub type __suseconds64_t = ::std::os::raw::c_long;
pub type __daddr_t = ::std::os::raw::c_int;
pub type __key_t = ::std::os::raw::c_int;
pub type __clockid_t = ::std::os::raw::c_int;
pub type __timer_t = *mut ::std::os::raw::c_void;
pub type __blksize_t = ::std::os::raw::c_long;
pub type __blkcnt_t = ::std::os::raw::c_long;
pub type __blkcnt64_t = ::std::os::raw::c_long;
pub type __fsblkcnt_t = ::std::os::raw::c_ulong;
pub type __fsblkcnt64_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt64_t = ::std::os::raw::c_ulong;
pub type __fsword_t = ::std::os::raw::c_long;
pub type __ssize_t = ::std::os::raw::c_long;
pub type __syscall_slong_t = ::std::os::raw::c_long;
pub type __syscall_ulong_t = ::std::os::raw::c_ulong;
pub type __loff_t = __off64_t;
pub type __caddr_t = *mut ::std::os::raw::c_char;
pub type __intptr_t = ::std::os::raw::c_long;
pub type __socklen_t = ::std::os::raw::c_uint;
pub type __sig_atomic_t = ::std::os::raw::c_int;
pub type u_char = __u_char;
pub type u_short = __u_short;
pub type u_int = __u_int;
pub type u_long = __u_long;
pub type quad_t = __quad_t;
pub type u_quad_t = __u_quad_t;
pub type fsid_t = __fsid_t;
pub type loff_t = __loff_t;
pub type ino_t = __ino_t;
pub type dev_t = __dev_t;
pub type gid_t = __gid_t;
pub type mode_t = __mode_t;
pub type nlink_t = __nlink_t;
pub type uid_t = __uid_t;
pub type off_t = __off_t;
pub type pid_t = __pid_t;
pub type id_t = __id_t;
pub type daddr_t = __daddr_t;
pub type caddr_t = __caddr_t;
pub type key_t = __key_t;
pub type clock_t = __clock_t;
pub type clockid_t = __clockid_t;
pub type time_t = __time_t;
pub type timer_t = __timer_t;
pub type ulong = ::std::os::raw::c_ulong;
pub type ushort = ::std::os::raw::c_ushort;
pub type uint = ::std::os::raw::c_uint;
pub type u_int8_t = __uint8_t;
pub type u_int16_t = __uint16_t;
pub type u_int32_t = __uint32_t;
pub type u_int64_t = __uint64_t;
pub type register_t = ::std::os::raw::c_long;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sigset_t {
    pub __val: [::std::os::raw::c_ulong; 16usize],
}
pub type sigset_t = __sigset_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timeval {
    pub tv_sec: __time_t,
    pub tv_usec: __suseconds_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timespec {
    pub tv_sec: __time_t,
    pub tv_nsec: __syscall_slong_t,
}
pub type suseconds_t = __suseconds_t;
pub type __fd_mask = ::std::os::raw::c_long;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fd_set {
    pub __fds_bits: [__fd_mask; 16usize],
}
pub type fd_mask = __fd_mask;
extern "C" {
    pub fn select(
        __nfds: ::std::os::raw::c_int,
        __readfds: *mut fd_set,
        __writefds: *mut fd_set,
        __exceptfds: *mut fd_set,
        __timeout: *mut timeval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pselect(
        __nfds: ::std::os::raw::c_int,
        __readfds: *mut fd_set,
        __writefds: *mut fd_set,
        __exceptfds: *mut fd_set,
        __timeout: *const timespec,
        __sigmask: *const __sigset_t,
    ) -> ::std::os::raw::c_int;
}
pub type blksize_t = __blksize_t;
pub type blkcnt_t = __blkcnt_t;
pub type fsblkcnt_t = __fsblkcnt_t;
pub type fsfilcnt_t = __fsfilcnt_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub union __atomic_wide_counter {
    pub __value64: ::std::os::raw::c_ulonglong,
    pub __value32: __atomic_wide_counter__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __atomic_wide_counter__bindgen_ty_1 {
    pub __low: ::std::os::raw::c_uint,
    pub __high: ::std::os::raw::c_uint,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_internal_list {
    pub __prev: *mut __pthread_internal_list,
    pub __next: *mut __pthread_internal_list,
}
pub type __pthread_list_t = __pthread_internal_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_internal_slist {
    pub __next: *mut __pthread_internal_slist,
}
pub type __pthread_slist_t = __pthread_internal_slist;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_mutex_s {
    pub __lock: ::std::os::raw::c_int,
    pub __count: ::std::os::raw::c_uint,
    pub __owner: ::std::os::raw::c_int,
    pub __nusers: ::std::os::raw::c_uint,
    pub __kind: ::std::os::raw::c_int,
    pub __spins: ::std::os::raw::c_short,
    pub __elision: ::std::os::raw::c_short,
    pub __list: __pthread_list_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_rwlock_arch_t {
    pub __readers: ::std::os::raw::c_uint,
    pub __writers: ::std::os::raw::c_uint,
    pub __wrphase_futex: ::std::os::raw::c_uint,
    pub __writers_futex: ::std::os::raw::c_uint,
    pub __pad3: ::std::os::raw::c_uint,
    pub __pad4: ::std::os::raw::c_uint,
    pub __cur_writer: ::std::os::raw::c_int,
    pub __shared: ::std::os::raw::c_int,
    pub __rwelision: ::std::os::raw::c_schar,
    pub __pad1: [::std::os::raw::c_uchar; 7usize],
    pub __pad2: ::std::os::raw::c_ulong,
    pub __flags: ::std::os::raw::c_uint,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __pthread_cond_s {
    pub __wseq: __atomic_wide_counter,
    pub __g1_start: __atomic_wide_counter,
    pub __g_size: [::std::os::raw::c_uint; 2usize],
    pub __g1_orig_size: ::std::os::raw::c_uint,
    pub __wrefs: ::std::os::raw::c_uint,
    pub __g_signals: [::std::os::raw::c_uint; 2usize],
}
pub type __tss_t = ::std::os::raw::c_uint;
pub type __thrd_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __once_flag {
    pub __data: ::std::os::raw::c_int,
}
pub type pthread_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutexattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_condattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
pub type pthread_key_t = ::std::os::raw::c_uint;
pub type pthread_once_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_attr_t {
    pub __size: [::std::os::raw::c_char; 56usize],
    pub __align: ::std::os::raw::c_long,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutex_t {
    pub __data: __pthread_mutex_s,
    pub __size: [::std::os::raw::c_char; 40usize],
    pub __align: ::std::os::raw::c_long,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_cond_t {
    pub __data: __pthread_cond_s,
    pub __size: [::std::os::raw::c_char; 48usize],
    pub __align: ::std::os::raw::c_longlong,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlock_t {
    pub __data: __pthread_rwlock_arch_t,
    pub __size: [::std::os::raw::c_char; 56usize],
    pub __align: ::std::os::raw::c_long,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlockattr_t {
    pub __size: [::std::os::raw::c_char; 8usize],
    pub __align: ::std::os::raw::c_long,
}
pub type pthread_spinlock_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrier_t {
    pub __size: [::std::os::raw::c_char; 32usize],
    pub __align: ::std::os::raw::c_long,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrierattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
extern "C" {
    pub fn random() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn srandom(__seed: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn initstate(
        __seed: ::std::os::raw::c_uint,
        __statebuf: *mut ::std::os::raw::c_char,
        __statelen: usize,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn setstate(__statebuf: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct random_data {
    pub fptr: *mut i32,
    pub rptr: *mut i32,
    pub state: *mut i32,
    pub rand_type: ::std::os::raw::c_int,
    pub rand_deg: ::std::os::raw::c_int,
    pub rand_sep: ::std::os::raw::c_int,
    pub end_ptr: *mut i32,
}
extern "C" {
    pub fn random_r(__buf: *mut random_data, __result: *mut i32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srandom_r(
        __seed: ::std::os::raw::c_uint,
        __buf: *mut random_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn initstate_r(
        __seed: ::std::os::raw::c_uint,
        __statebuf: *mut ::std::os::raw::c_char,
        __statelen: usize,
        __buf: *mut random_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setstate_r(
        __statebuf: *mut ::std::os::raw::c_char,
        __buf: *mut random_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rand() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srand(__seed: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn rand_r(__seed: *mut ::std::os::raw::c_uint) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn drand48() -> f64;
}
extern "C" {
    pub fn erand48(__xsubi: *mut ::std::os::raw::c_ushort) -> f64;
}
extern "C" {
    pub fn lrand48() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn nrand48(__xsubi: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn mrand48() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn jrand48(__xsubi: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn srand48(__seedval: ::std::os::raw::c_long);
}
extern "C" {
    pub fn seed48(__seed16v: *mut ::std::os::raw::c_ushort) -> *mut ::std::os::raw::c_ushort;
}
extern "C" {
    pub fn lcong48(__param: *mut ::std::os::raw::c_ushort);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drand48_data {
    pub __x: [::std::os::raw::c_ushort; 3usize],
    pub __old_x: [::std::os::raw::c_ushort; 3usize],
    pub __c: ::std::os::raw::c_ushort,
    pub __init: ::std::os::raw::c_ushort,
    pub __a: ::std::os::raw::c_ulonglong,
}
extern "C" {
    pub fn drand48_r(__buffer: *mut drand48_data, __result: *mut f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn erand48_r(
        __xsubi: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
        __result: *mut f64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lrand48_r(
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn nrand48_r(
        __xsubi: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mrand48_r(
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn jrand48_r(
        __xsubi: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
        __result: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srand48_r(
        __seedval: ::std::os::raw::c_long,
        __buffer: *mut drand48_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn seed48_r(
        __seed16v: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lcong48_r(
        __param: *mut ::std::os::raw::c_ushort,
        __buffer: *mut drand48_data,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn arc4random() -> __uint32_t;
}
extern "C" {
    pub fn arc4random_buf(__buf: *mut ::std::os::raw::c_void, __size: usize);
}
extern "C" {
    pub fn arc4random_uniform(__upper_bound: __uint32_t) -> __uint32_t;
}
extern "C" {
    pub fn malloc(__size: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn calloc(
        __nmemb: ::std::os::raw::c_ulong,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn realloc(
        __ptr: *mut ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn free(__ptr: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn reallocarray(
        __ptr: *mut ::std::os::raw::c_void,
        __nmemb: usize,
        __size: usize,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn alloca(__size: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn valloc(__size: usize) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn posix_memalign(
        __memptr: *mut *mut ::std::os::raw::c_void,
        __alignment: usize,
        __size: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn aligned_alloc(
        __alignment: ::std::os::raw::c_ulong,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn abort() -> !;
}
extern "C" {
    pub fn atexit(__func: ::std::option::Option<unsafe extern "C" fn()>) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn at_quick_exit(
        __func: ::std::option::Option<unsafe extern "C" fn()>,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn on_exit(
        __func: ::std::option::Option<
            unsafe extern "C" fn(
                __status: ::std::os::raw::c_int,
                __arg: *mut ::std::os::raw::c_void,
            ),
        >,
        __arg: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn exit(__status: ::std::os::raw::c_int) -> !;
}
extern "C" {
    pub fn quick_exit(__status: ::std::os::raw::c_int) -> !;
}
extern "C" {
    pub fn _Exit(__status: ::std::os::raw::c_int) -> !;
}
extern "C" {
    pub fn getenv(__name: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn putenv(__string: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setenv(
        __name: *const ::std::os::raw::c_char,
        __value: *const ::std::os::raw::c_char,
        __replace: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn unsetenv(__name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clearenv() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mktemp(__template: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn mkstemp(__template: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkstemps(
        __template: *mut ::std::os::raw::c_char,
        __suffixlen: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkdtemp(__template: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn system(__command: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn realpath(
        __name: *const ::std::os::raw::c_char,
        __resolved: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
pub type __compar_fn_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn bsearch(
        __key: *const ::std::os::raw::c_void,
        __base: *const ::std::os::raw::c_void,
        __nmemb: usize,
        __size: usize,
        __compar: __compar_fn_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn qsort(
        __base: *mut ::std::os::raw::c_void,
        __nmemb: usize,
        __size: usize,
        __compar: __compar_fn_t,
    );
}
extern "C" {
    pub fn abs(__x: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn labs(__x: ::std::os::raw::c_long) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn llabs(__x: ::std::os::raw::c_longlong) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn div(__numer: ::std::os::raw::c_int, __denom: ::std::os::raw::c_int) -> div_t;
}
extern "C" {
    pub fn ldiv(__numer: ::std::os::raw::c_long, __denom: ::std::os::raw::c_long) -> ldiv_t;
}
extern "C" {
    pub fn lldiv(
        __numer: ::std::os::raw::c_longlong,
        __denom: ::std::os::raw::c_longlong,
    ) -> lldiv_t;
}
extern "C" {
    pub fn ecvt(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fcvt(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn gcvt(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn qecvt(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn qfcvt(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn qgcvt(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ecvt_r(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fcvt_r(
        __value: f64,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qecvt_r(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qfcvt_r(
        __value: u128,
        __ndigit: ::std::os::raw::c_int,
        __decpt: *mut ::std::os::raw::c_int,
        __sign: *mut ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mblen(__s: *const ::std::os::raw::c_char, __n: usize) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mbtowc(
        __pwc: *mut wchar_t,
        __s: *const ::std::os::raw::c_char,
        __n: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wctomb(__s: *mut ::std::os::raw::c_char, __wchar: wchar_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mbstowcs(__pwcs: *mut wchar_t, __s: *const ::std::os::raw::c_char, __n: usize) -> usize;
}
extern "C" {
    pub fn wcstombs(__s: *mut ::std::os::raw::c_char, __pwcs: *const wchar_t, __n: usize) -> usize;
}
extern "C" {
    pub fn rpmatch(__response: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getsubopt(
        __optionp: *mut *mut ::std::os::raw::c_char,
        __tokens: *const *mut ::std::os::raw::c_char,
        __valuep: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getloadavg(__loadavg: *mut f64, __nelem: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
#[doc = "< Success"]
pub const hiprtcResult_HIPRTC_SUCCESS: hiprtcResult = 0;
#[doc = "< Out of memory"]
pub const hiprtcResult_HIPRTC_ERROR_OUT_OF_MEMORY: hiprtcResult = 1;
#[doc = "< Failed to create program"]
pub const hiprtcResult_HIPRTC_ERROR_PROGRAM_CREATION_FAILURE: hiprtcResult = 2;
#[doc = "< Invalid input"]
pub const hiprtcResult_HIPRTC_ERROR_INVALID_INPUT: hiprtcResult = 3;
#[doc = "< Invalid program"]
pub const hiprtcResult_HIPRTC_ERROR_INVALID_PROGRAM: hiprtcResult = 4;
#[doc = "< Invalid option"]
pub const hiprtcResult_HIPRTC_ERROR_INVALID_OPTION: hiprtcResult = 5;
#[doc = "< Compilation error"]
pub const hiprtcResult_HIPRTC_ERROR_COMPILATION: hiprtcResult = 6;
#[doc = "< Failed in builtin operation"]
pub const hiprtcResult_HIPRTC_ERROR_BUILTIN_OPERATION_FAILURE: hiprtcResult = 7;
#[doc = "< No name expression after compilation"]
pub const hiprtcResult_HIPRTC_ERROR_NO_NAME_EXPRESSIONS_AFTER_COMPILATION: hiprtcResult = 8;
#[doc = "< No lowered names before compilation"]
pub const hiprtcResult_HIPRTC_ERROR_NO_LOWERED_NAMES_BEFORE_COMPILATION: hiprtcResult = 9;
#[doc = "< Invalid name expression"]
pub const hiprtcResult_HIPRTC_ERROR_NAME_EXPRESSION_NOT_VALID: hiprtcResult = 10;
#[doc = "< Internal error"]
pub const hiprtcResult_HIPRTC_ERROR_INTERNAL_ERROR: hiprtcResult = 11;
#[doc = "< Error in linking"]
pub const hiprtcResult_HIPRTC_ERROR_LINKING: hiprtcResult = 100;
#[doc = " @addtogroup GlobalDefs\n @{\n\n/\n/**\n hiprtc error code"]
pub type hiprtcResult = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ihiprtcLinkState {
    _unused: [u8; 0],
}
#[doc = "  hiprtc link state\n"]
pub type hiprtcLinkState = *mut ihiprtcLinkState;
extern "C" {
    #[doc = "  @ingroup Runtime\n\n @brief Returns text string message to explain the error which occurred\n\n @param [in] result  code to convert to string.\n @returns  const char pointer to the NULL-terminated error string\n\n @warning In HIP, this function returns the name of the error,\n if the hiprtc result is defined, it will return \"Invalid HIPRTC error code\"\n\n @see hiprtcResult"]
    pub fn hiprtcGetErrorString(result: hiprtcResult) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " @ingroup Runtime\n @brief Sets the parameters as major and minor version.\n\n @param [out] major  HIP Runtime Compilation major version.\n @param [out] minor  HIP Runtime Compilation minor version.\n\n @returns #HIPRTC_ERROR_INVALID_INPUT, #HIPRTC_SUCCESS\n"]
    pub fn hiprtcVersion(
        major: *mut ::std::os::raw::c_int,
        minor: *mut ::std::os::raw::c_int,
    ) -> hiprtcResult;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _hiprtcProgram {
    _unused: [u8; 0],
}
#[doc = "  hiprtc program\n"]
pub type hiprtcProgram = *mut _hiprtcProgram;
extern "C" {
    #[doc = " @ingroup Runtime\n @brief Adds the given name exprssion to the runtime compilation program.\n\n @param [in] prog  runtime compilation program instance.\n @param [in] name_expression  const char pointer to the name expression.\n @returns  #HIPRTC_SUCCESS\n\n If const char pointer is NULL, it will return #HIPRTC_ERROR_INVALID_INPUT.\n\n @see hiprtcResult"]
    pub fn hiprtcAddNameExpression(
        prog: hiprtcProgram,
        name_expression: *const ::std::os::raw::c_char,
    ) -> hiprtcResult;
}
extern "C" {
    #[doc = " @ingroup Runtime\n @brief Compiles the given runtime compilation program.\n\n @param [in] prog  runtime compilation program instance.\n @param [in] numOptions  number of compiler options.\n @param [in] options  compiler options as const array of strins.\n @returns #HIPRTC_SUCCESS\n\n If the compiler failed to build the runtime compilation program,\n it will return #HIPRTC_ERROR_COMPILATION.\n\n @see hiprtcResult"]
    pub fn hiprtcCompileProgram(
        prog: hiprtcProgram,
        numOptions: ::std::os::raw::c_int,
        options: *mut *const ::std::os::raw::c_char,
    ) -> hiprtcResult;
}
extern "C" {
    #[doc = " @ingroup Runtime\n @brief Creates an instance of hiprtcProgram with the given input parameters,\n and sets the output hiprtcProgram prog with it.\n\n @param [in, out] prog  runtime compilation program instance.\n @param [in] src  const char pointer to the program source.\n @param [in] name  const char pointer to the program name.\n @param [in] numHeaders  number of headers.\n @param [in] headers  array of strings pointing to headers.\n @param [in] includeNames  array of strings pointing to names included in program source.\n @returns #HIPRTC_SUCCESS\n\n Any invalide input parameter, it will return #HIPRTC_ERROR_INVALID_INPUT\n or #HIPRTC_ERROR_INVALID_PROGRAM.\n\n If failed to create the program, it will return #HIPRTC_ERROR_PROGRAM_CREATION_FAILURE.\n\n @see hiprtcResult"]
    pub fn hiprtcCreateProgram(
        prog: *mut hiprtcProgram,
        src: *const ::std::os::raw::c_char,
        name: *const ::std::os::raw::c_char,
        numHeaders: ::std::os::raw::c_int,
        headers: *mut *const ::std::os::raw::c_char,
        includeNames: *mut *const ::std::os::raw::c_char,
    ) -> hiprtcResult;
}
extern "C" {
    #[doc = " @brief Destroys an instance of given hiprtcProgram.\n @ingroup Runtime\n @param [in] prog  runtime compilation program instance.\n @returns #HIPRTC_SUCCESS\n\n If prog is NULL, it will return #HIPRTC_ERROR_INVALID_INPUT.\n\n @see hiprtcResult"]
    pub fn hiprtcDestroyProgram(prog: *mut hiprtcProgram) -> hiprtcResult;
}
extern "C" {
    #[doc = " @brief Gets the lowered (mangled) name from an instance of hiprtcProgram with the given input parameters,\n and sets the output lowered_name with it.\n @ingroup Runtime\n @param [in] prog  runtime compilation program instance.\n @param [in] name_expression  const char pointer to the name expression.\n @param [in, out] lowered_name  const char array to the lowered (mangled) name.\n @returns #HIPRTC_SUCCESS\n\n If any invalide nullptr input parameters, it will return #HIPRTC_ERROR_INVALID_INPUT\n\n If name_expression is not found, it will return #HIPRTC_ERROR_NAME_EXPRESSION_NOT_VALID\n\n If failed to get lowered_name from the program, it will return #HIPRTC_ERROR_COMPILATION.\n\n @see hiprtcResult"]
    pub fn hiprtcGetLoweredName(
        prog: hiprtcProgram,
        name_expression: *const ::std::os::raw::c_char,
        lowered_name: *mut *const ::std::os::raw::c_char,
    ) -> hiprtcResult;
}
extern "C" {
    #[doc = " @brief Gets the log generated by the runtime compilation program instance.\n @ingroup Runtime\n @param [in] prog  runtime compilation program instance.\n @param [out] log  memory pointer to the generated log.\n @returns #HIPRTC_SUCCESS\n\n @see hiprtcResult"]
    pub fn hiprtcGetProgramLog(
        prog: hiprtcProgram,
        log: *mut ::std::os::raw::c_char,
    ) -> hiprtcResult;
}
extern "C" {
    #[doc = " @brief Gets the size of log generated by the runtime compilation program instance.\n\n @param [in] prog  runtime compilation program instance.\n @param [out] logSizeRet  size of generated log.\n @returns #HIPRTC_SUCCESS\n\n @see hiprtcResult"]
    pub fn hiprtcGetProgramLogSize(prog: hiprtcProgram, logSizeRet: *mut usize) -> hiprtcResult;
}
extern "C" {
    #[doc = " @brief Gets the pointer of compilation binary by the runtime compilation program instance.\n @ingroup Runtime\n @param [in] prog  runtime compilation program instance.\n @param [out] code  char pointer to binary.\n @returns #HIPRTC_SUCCESS\n\n @see hiprtcResult"]
    pub fn hiprtcGetCode(prog: hiprtcProgram, code: *mut ::std::os::raw::c_char) -> hiprtcResult;
}
extern "C" {
    #[doc = " @brief Gets the size of compilation binary by the runtime compilation program instance.\n @ingroup Runtime\n @param [in] prog  runtime compilation program instance.\n @param [out] codeSizeRet  the size of binary.\n @returns #HIPRTC_SUCCESS\n\n @see hiprtcResult"]
    pub fn hiprtcGetCodeSize(prog: hiprtcProgram, codeSizeRet: *mut usize) -> hiprtcResult;
}
extern "C" {
    #[doc = " @brief Gets the pointer of compiled bitcode by the runtime compilation program instance.\n\n @param [in] prog  runtime compilation program instance.\n @param [out] bitcode  char pointer to bitcode.\n @return HIPRTC_SUCCESS\n\n @see hiprtcResult"]
    pub fn hiprtcGetBitcode(
        prog: hiprtcProgram,
        bitcode: *mut ::std::os::raw::c_char,
    ) -> hiprtcResult;
}
extern "C" {
    #[doc = " @brief Gets the size of compiled bitcode by the runtime compilation program instance.\n @ingroup Runtime\n\n @param [in] prog  runtime compilation program instance.\n @param [out] bitcode_size  the size of bitcode.\n @returns #HIPRTC_SUCCESS\n\n @see hiprtcResult"]
    pub fn hiprtcGetBitcodeSize(prog: hiprtcProgram, bitcode_size: *mut usize) -> hiprtcResult;
}
extern "C" {
    #[doc = " @brief Creates the link instance via hiprtc APIs.\n @ingroup Runtime\n @param [in] num_options  Number of options\n @param [in] option_ptr  Array of options\n @param [in] option_vals_pptr  Array of option values cast to void*\n @param [out] hip_link_state_ptr  hiprtc link state created upon success\n\n @returns #HIPRTC_SUCCESS, #HIPRTC_ERROR_INVALID_INPUT, #HIPRTC_ERROR_INVALID_OPTION\n\n @see hiprtcResult"]
    pub fn hiprtcLinkCreate(
        num_options: ::std::os::raw::c_uint,
        option_ptr: *mut hipJitOption,
        option_vals_pptr: *mut *mut ::std::os::raw::c_void,
        hip_link_state_ptr: *mut hiprtcLinkState,
    ) -> hiprtcResult;
}
extern "C" {
    #[doc = " @brief Adds a file with bit code to be linked with options\n @ingroup Runtime\n @param [in] hip_link_state  hiprtc link state\n @param [in] input_type  Type of the input data or bitcode\n @param [in] file_path  Path to the input file where bitcode is present\n @param [in] num_options  Size of the options\n @param [in] options_ptr  Array of options applied to this input\n @param [in] option_values  Array of option values cast to void*\n\n @returns #HIPRTC_SUCCESS\n\n If input values are invalid, it will\n @return #HIPRTC_ERROR_INVALID_INPUT\n\n @see hiprtcResult"]
    pub fn hiprtcLinkAddFile(
        hip_link_state: hiprtcLinkState,
        input_type: hipJitInputType,
        file_path: *const ::std::os::raw::c_char,
        num_options: ::std::os::raw::c_uint,
        options_ptr: *mut hipJitOption,
        option_values: *mut *mut ::std::os::raw::c_void,
    ) -> hiprtcResult;
}
extern "C" {
    #[doc = " @brief Completes the linking of the given program.\n @ingroup Runtime\n @param [in] hip_link_state  hiprtc link state\n @param [in] input_type  Type of the input data or bitcode\n @param [in] image  Input data which is null terminated\n @param [in] image_size  Size of the input data\n @param [in] name  Optional name for this input\n @param [in] num_options  Size of the options\n @param [in] options_ptr  Array of options applied to this input\n @param [in] option_values  Array of option values cast to void*\n\n @returns #HIPRTC_SUCCESS, #HIPRTC_ERROR_INVALID_INPUT\n\n If adding the file fails, it will\n @return #HIPRTC_ERROR_PROGRAM_CREATION_FAILURE\n\n @see hiprtcResult"]
    pub fn hiprtcLinkAddData(
        hip_link_state: hiprtcLinkState,
        input_type: hipJitInputType,
        image: *mut ::std::os::raw::c_void,
        image_size: usize,
        name: *const ::std::os::raw::c_char,
        num_options: ::std::os::raw::c_uint,
        options_ptr: *mut hipJitOption,
        option_values: *mut *mut ::std::os::raw::c_void,
    ) -> hiprtcResult;
}
extern "C" {
    #[doc = " @brief Completes the linking of the given program.\n @ingroup Runtime\n @param [in]  hip_link_state  hiprtc link state\n @param [out]  bin_out  Upon success, points to the output binary\n @param [out]  size_out  Size of the binary is stored (optional)\n\n @returns #HIPRTC_SUCCESS\n\n If adding the data fails, it will\n @return #HIPRTC_ERROR_LINKING\n\n @see hiprtcResult"]
    pub fn hiprtcLinkComplete(
        hip_link_state: hiprtcLinkState,
        bin_out: *mut *mut ::std::os::raw::c_void,
        size_out: *mut usize,
    ) -> hiprtcResult;
}
extern "C" {
    #[doc = " @brief Deletes the link instance via hiprtc APIs.\n @ingroup Runtime\n @param [in] hip_link_state link state instance\n\n @returns #HIPRTC_SUCCESS\n\n @see hiprtcResult"]
    pub fn hiprtcLinkDestroy(hip_link_state: hiprtcLinkState) -> hiprtcResult;
}
extern "C" {
    pub fn memcpy(
        __dest: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memmove(
        __dest: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memccpy(
        __dest: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memset(
        __s: *mut ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memcmp(
        __s1: *const ::std::os::raw::c_void,
        __s2: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __memcmpeq(
        __s1: *const ::std::os::raw::c_void,
        __s2: *const ::std::os::raw::c_void,
        __n: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn memchr(
        __s: *const ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn strcpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strncpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcat(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strncat(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcoll(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strxfrm(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __locale_struct {
    pub __locales: [*mut __locale_data; 13usize],
    pub __ctype_b: *const ::std::os::raw::c_ushort,
    pub __ctype_tolower: *const ::std::os::raw::c_int,
    pub __ctype_toupper: *const ::std::os::raw::c_int,
    pub __names: [*const ::std::os::raw::c_char; 13usize],
}
pub type __locale_t = *mut __locale_struct;
pub type locale_t = __locale_t;
extern "C" {
    pub fn strcoll_l(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __l: locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strxfrm_l(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: usize,
        __l: locale_t,
    ) -> usize;
}
extern "C" {
    pub fn strdup(__s: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strndup(
        __string: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strchr(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strrchr(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strchrnul(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcspn(
        __s: *const ::std::os::raw::c_char,
        __reject: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strspn(
        __s: *const ::std::os::raw::c_char,
        __accept: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strpbrk(
        __s: *const ::std::os::raw::c_char,
        __accept: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strstr(
        __haystack: *const ::std::os::raw::c_char,
        __needle: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strtok(
        __s: *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __strtok_r(
        __s: *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
        __save_ptr: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strtok_r(
        __s: *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
        __save_ptr: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcasestr(
        __haystack: *const ::std::os::raw::c_char,
        __needle: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn memmem(
        __haystack: *const ::std::os::raw::c_void,
        __haystacklen: usize,
        __needle: *const ::std::os::raw::c_void,
        __needlelen: usize,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn __mempcpy(
        __dest: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __n: usize,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn mempcpy(
        __dest: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn strlen(__s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strnlen(__string: *const ::std::os::raw::c_char, __maxlen: usize) -> usize;
}
extern "C" {
    pub fn strerror(__errnum: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}__xpg_strerror_r"]
    pub fn strerror_r(
        __errnum: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __buflen: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strerror_l(
        __errnum: ::std::os::raw::c_int,
        __l: locale_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn bcmp(
        __s1: *const ::std::os::raw::c_void,
        __s2: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcopy(
        __src: *const ::std::os::raw::c_void,
        __dest: *mut ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    );
}
extern "C" {
    pub fn bzero(__s: *mut ::std::os::raw::c_void, __n: ::std::os::raw::c_ulong);
}
extern "C" {
    pub fn index(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn rindex(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ffs(__i: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ffsl(__l: ::std::os::raw::c_long) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ffsll(__ll: ::std::os::raw::c_longlong) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcasecmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncasecmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcasecmp_l(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __loc: locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncasecmp_l(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: usize,
        __loc: locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn explicit_bzero(__s: *mut ::std::os::raw::c_void, __n: usize);
}
extern "C" {
    pub fn strsep(
        __stringp: *mut *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strsignal(__sig: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __stpcpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn stpcpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __stpncpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: usize,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn stpncpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strlcpy(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strlcat(
        __dest: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
pub const HIP_SUCCESS: _bindgen_ty_1 = 0;
pub const HIP_ERROR_INVALID_VALUE: _bindgen_ty_1 = 1;
pub const HIP_ERROR_NOT_INITIALIZED: _bindgen_ty_1 = 2;
pub const HIP_ERROR_LAUNCH_OUT_OF_RESOURCES: _bindgen_ty_1 = 3;
pub type _bindgen_ty_1 = ::std::os::raw::c_uint;
#[doc = " @defgroup GlobalDefs Global enum and defines\n @{\n\n/\n/**\n hipDeviceArch_t\n"]
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct hipDeviceArch_t {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 3usize]>,
    pub __bindgen_padding_0: u8,
}
impl hipDeviceArch_t {
    #[inline]
    pub fn hasGlobalInt32Atomics(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_hasGlobalInt32Atomics(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn hasGlobalFloatAtomicExch(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_hasGlobalFloatAtomicExch(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn hasSharedInt32Atomics(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_hasSharedInt32Atomics(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn hasSharedFloatAtomicExch(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_hasSharedFloatAtomicExch(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn hasFloatAtomicAdd(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_hasFloatAtomicAdd(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn hasGlobalInt64Atomics(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_hasGlobalInt64Atomics(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn hasSharedInt64Atomics(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_hasSharedInt64Atomics(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn hasDoubles(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_hasDoubles(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn hasWarpVote(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_hasWarpVote(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn hasWarpBallot(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_hasWarpBallot(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn hasWarpShuffle(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_hasWarpShuffle(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn hasFunnelShift(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_hasFunnelShift(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn hasThreadFenceSystem(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_hasThreadFenceSystem(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn hasSyncThreadsExt(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_hasSyncThreadsExt(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn hasSurfaceFuncs(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_hasSurfaceFuncs(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn has3dGrid(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_has3dGrid(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn hasDynamicParallelism(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_hasDynamicParallelism(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        hasGlobalInt32Atomics: ::std::os::raw::c_uint,
        hasGlobalFloatAtomicExch: ::std::os::raw::c_uint,
        hasSharedInt32Atomics: ::std::os::raw::c_uint,
        hasSharedFloatAtomicExch: ::std::os::raw::c_uint,
        hasFloatAtomicAdd: ::std::os::raw::c_uint,
        hasGlobalInt64Atomics: ::std::os::raw::c_uint,
        hasSharedInt64Atomics: ::std::os::raw::c_uint,
        hasDoubles: ::std::os::raw::c_uint,
        hasWarpVote: ::std::os::raw::c_uint,
        hasWarpBallot: ::std::os::raw::c_uint,
        hasWarpShuffle: ::std::os::raw::c_uint,
        hasFunnelShift: ::std::os::raw::c_uint,
        hasThreadFenceSystem: ::std::os::raw::c_uint,
        hasSyncThreadsExt: ::std::os::raw::c_uint,
        hasSurfaceFuncs: ::std::os::raw::c_uint,
        has3dGrid: ::std::os::raw::c_uint,
        hasDynamicParallelism: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 3usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 3usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let hasGlobalInt32Atomics: u32 =
                unsafe { ::std::mem::transmute(hasGlobalInt32Atomics) };
            hasGlobalInt32Atomics as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let hasGlobalFloatAtomicExch: u32 =
                unsafe { ::std::mem::transmute(hasGlobalFloatAtomicExch) };
            hasGlobalFloatAtomicExch as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let hasSharedInt32Atomics: u32 =
                unsafe { ::std::mem::transmute(hasSharedInt32Atomics) };
            hasSharedInt32Atomics as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let hasSharedFloatAtomicExch: u32 =
                unsafe { ::std::mem::transmute(hasSharedFloatAtomicExch) };
            hasSharedFloatAtomicExch as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let hasFloatAtomicAdd: u32 = unsafe { ::std::mem::transmute(hasFloatAtomicAdd) };
            hasFloatAtomicAdd as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let hasGlobalInt64Atomics: u32 =
                unsafe { ::std::mem::transmute(hasGlobalInt64Atomics) };
            hasGlobalInt64Atomics as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let hasSharedInt64Atomics: u32 =
                unsafe { ::std::mem::transmute(hasSharedInt64Atomics) };
            hasSharedInt64Atomics as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let hasDoubles: u32 = unsafe { ::std::mem::transmute(hasDoubles) };
            hasDoubles as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let hasWarpVote: u32 = unsafe { ::std::mem::transmute(hasWarpVote) };
            hasWarpVote as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let hasWarpBallot: u32 = unsafe { ::std::mem::transmute(hasWarpBallot) };
            hasWarpBallot as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let hasWarpShuffle: u32 = unsafe { ::std::mem::transmute(hasWarpShuffle) };
            hasWarpShuffle as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let hasFunnelShift: u32 = unsafe { ::std::mem::transmute(hasFunnelShift) };
            hasFunnelShift as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let hasThreadFenceSystem: u32 = unsafe { ::std::mem::transmute(hasThreadFenceSystem) };
            hasThreadFenceSystem as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let hasSyncThreadsExt: u32 = unsafe { ::std::mem::transmute(hasSyncThreadsExt) };
            hasSyncThreadsExt as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let hasSurfaceFuncs: u32 = unsafe { ::std::mem::transmute(hasSurfaceFuncs) };
            hasSurfaceFuncs as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let has3dGrid: u32 = unsafe { ::std::mem::transmute(has3dGrid) };
            has3dGrid as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let hasDynamicParallelism: u32 =
                unsafe { ::std::mem::transmute(hasDynamicParallelism) };
            hasDynamicParallelism as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipUUID_t {
    pub bytes: [::std::os::raw::c_char; 16usize],
}
pub type hipUUID = hipUUID_t;
#[doc = " hipDeviceProp\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipDeviceProp_tR0600 {
    #[doc = "< Device name."]
    pub name: [::std::os::raw::c_char; 256usize],
    #[doc = "< UUID of a device"]
    pub uuid: hipUUID,
    #[doc = "< 8-byte unique identifier. Only valid on windows"]
    pub luid: [::std::os::raw::c_char; 8usize],
    #[doc = "< LUID node mask"]
    pub luidDeviceNodeMask: ::std::os::raw::c_uint,
    #[doc = "< Size of global memory region (in bytes)."]
    pub totalGlobalMem: usize,
    #[doc = "< Size of shared memory per block (in bytes)."]
    pub sharedMemPerBlock: usize,
    #[doc = "< Registers per block."]
    pub regsPerBlock: ::std::os::raw::c_int,
    #[doc = "< Warp size."]
    pub warpSize: ::std::os::raw::c_int,
    #[doc = "< Maximum pitch in bytes allowed by memory copies\n< pitched memory"]
    pub memPitch: usize,
    #[doc = "< Max work items per work group or workgroup max size."]
    pub maxThreadsPerBlock: ::std::os::raw::c_int,
    #[doc = "< Max number of threads in each dimension (XYZ) of a block."]
    pub maxThreadsDim: [::std::os::raw::c_int; 3usize],
    #[doc = "< Max grid dimensions (XYZ)."]
    pub maxGridSize: [::std::os::raw::c_int; 3usize],
    #[doc = "< Max clock frequency of the multiProcessors in khz."]
    pub clockRate: ::std::os::raw::c_int,
    #[doc = "< Size of shared constant memory region on the device\n< (in bytes)."]
    pub totalConstMem: usize,
    #[doc = "< Major compute capability.  On HCC, this is an approximation and features may\n< differ from CUDA CC.  See the arch feature flags for portable ways to query\n< feature caps."]
    pub major: ::std::os::raw::c_int,
    #[doc = "< Minor compute capability.  On HCC, this is an approximation and features may\n< differ from CUDA CC.  See the arch feature flags for portable ways to query\n< feature caps."]
    pub minor: ::std::os::raw::c_int,
    #[doc = "< Alignment requirement for textures"]
    pub textureAlignment: usize,
    #[doc = "< Pitch alignment requirement for texture references bound to"]
    pub texturePitchAlignment: usize,
    #[doc = "< Deprecated. Use asyncEngineCount instead"]
    pub deviceOverlap: ::std::os::raw::c_int,
    #[doc = "< Number of multi-processors (compute units)."]
    pub multiProcessorCount: ::std::os::raw::c_int,
    #[doc = "< Run time limit for kernels executed on the device"]
    pub kernelExecTimeoutEnabled: ::std::os::raw::c_int,
    #[doc = "< APU vs dGPU"]
    pub integrated: ::std::os::raw::c_int,
    #[doc = "< Check whether HIP can map host memory"]
    pub canMapHostMemory: ::std::os::raw::c_int,
    #[doc = "< Compute mode."]
    pub computeMode: ::std::os::raw::c_int,
    #[doc = "< Maximum number of elements in 1D images"]
    pub maxTexture1D: ::std::os::raw::c_int,
    #[doc = "< Maximum 1D mipmap texture size"]
    pub maxTexture1DMipmap: ::std::os::raw::c_int,
    #[doc = "< Maximum size for 1D textures bound to linear memory"]
    pub maxTexture1DLinear: ::std::os::raw::c_int,
    #[doc = "< Maximum dimensions (width, height) of 2D images, in image elements"]
    pub maxTexture2D: [::std::os::raw::c_int; 2usize],
    #[doc = "< Maximum number of elements in 2D array mipmap of images"]
    pub maxTexture2DMipmap: [::std::os::raw::c_int; 2usize],
    #[doc = "< Maximum 2D tex dimensions if tex are bound to pitched memory"]
    pub maxTexture2DLinear: [::std::os::raw::c_int; 3usize],
    #[doc = "< Maximum 2D tex dimensions if gather has to be performed"]
    pub maxTexture2DGather: [::std::os::raw::c_int; 2usize],
    #[doc = "< Maximum dimensions (width, height, depth) of 3D images, in image\n< elements"]
    pub maxTexture3D: [::std::os::raw::c_int; 3usize],
    #[doc = "< Maximum alternate 3D texture dims"]
    pub maxTexture3DAlt: [::std::os::raw::c_int; 3usize],
    #[doc = "< Maximum cubemap texture dims"]
    pub maxTextureCubemap: ::std::os::raw::c_int,
    #[doc = "< Maximum number of elements in 1D array images"]
    pub maxTexture1DLayered: [::std::os::raw::c_int; 2usize],
    #[doc = "< Maximum number of elements in 2D array images"]
    pub maxTexture2DLayered: [::std::os::raw::c_int; 3usize],
    #[doc = "< Maximum cubemaps layered texture dims"]
    pub maxTextureCubemapLayered: [::std::os::raw::c_int; 2usize],
    #[doc = "< Maximum 1D surface size"]
    pub maxSurface1D: ::std::os::raw::c_int,
    #[doc = "< Maximum 2D surface size"]
    pub maxSurface2D: [::std::os::raw::c_int; 2usize],
    #[doc = "< Maximum 3D surface size"]
    pub maxSurface3D: [::std::os::raw::c_int; 3usize],
    #[doc = "< Maximum 1D layered surface size"]
    pub maxSurface1DLayered: [::std::os::raw::c_int; 2usize],
    #[doc = "< Maximum 2D layared surface size"]
    pub maxSurface2DLayered: [::std::os::raw::c_int; 3usize],
    #[doc = "< Maximum cubemap surface size"]
    pub maxSurfaceCubemap: ::std::os::raw::c_int,
    #[doc = "< Maximum cubemap layered surface size"]
    pub maxSurfaceCubemapLayered: [::std::os::raw::c_int; 2usize],
    #[doc = "< Alignment requirement for surface"]
    pub surfaceAlignment: usize,
    #[doc = "< Device can possibly execute multiple kernels concurrently."]
    pub concurrentKernels: ::std::os::raw::c_int,
    #[doc = "< Device has ECC support enabled"]
    pub ECCEnabled: ::std::os::raw::c_int,
    #[doc = "< PCI Bus ID."]
    pub pciBusID: ::std::os::raw::c_int,
    #[doc = "< PCI Device ID."]
    pub pciDeviceID: ::std::os::raw::c_int,
    #[doc = "< PCI Domain ID"]
    pub pciDomainID: ::std::os::raw::c_int,
    #[doc = "< 1:If device is Tesla device using TCC driver, else 0"]
    pub tccDriver: ::std::os::raw::c_int,
    #[doc = "< Number of async engines"]
    pub asyncEngineCount: ::std::os::raw::c_int,
    #[doc = "< Does device and host share unified address space"]
    pub unifiedAddressing: ::std::os::raw::c_int,
    #[doc = "< Max global memory clock frequency in khz."]
    pub memoryClockRate: ::std::os::raw::c_int,
    #[doc = "< Global memory bus width in bits."]
    pub memoryBusWidth: ::std::os::raw::c_int,
    #[doc = "< L2 cache size."]
    pub l2CacheSize: ::std::os::raw::c_int,
    #[doc = "< Device's max L2 persisting lines in bytes"]
    pub persistingL2CacheMaxSize: ::std::os::raw::c_int,
    #[doc = "< Maximum resident threads per multi-processor."]
    pub maxThreadsPerMultiProcessor: ::std::os::raw::c_int,
    #[doc = "< Device supports stream priority"]
    pub streamPrioritiesSupported: ::std::os::raw::c_int,
    #[doc = "< Indicates globals are cached in L1"]
    pub globalL1CacheSupported: ::std::os::raw::c_int,
    #[doc = "< Locals are cahced in L1"]
    pub localL1CacheSupported: ::std::os::raw::c_int,
    #[doc = "< Amount of shared memory available per multiprocessor."]
    pub sharedMemPerMultiprocessor: usize,
    #[doc = "< registers available per multiprocessor"]
    pub regsPerMultiprocessor: ::std::os::raw::c_int,
    #[doc = "< Device supports allocating managed memory on this system"]
    pub managedMemory: ::std::os::raw::c_int,
    #[doc = "< 1 if device is on a multi-GPU board, 0 if not."]
    pub isMultiGpuBoard: ::std::os::raw::c_int,
    #[doc = "< Unique identifier for a group of devices on same multiboard GPU"]
    pub multiGpuBoardGroupID: ::std::os::raw::c_int,
    #[doc = "< Link between host and device supports native atomics"]
    pub hostNativeAtomicSupported: ::std::os::raw::c_int,
    #[doc = "< Deprecated. CUDA only."]
    pub singleToDoublePrecisionPerfRatio: ::std::os::raw::c_int,
    #[doc = "< Device supports coherently accessing pageable memory\n< without calling hipHostRegister on it"]
    pub pageableMemoryAccess: ::std::os::raw::c_int,
    #[doc = "< Device can coherently access managed memory concurrently with\n< the CPU"]
    pub concurrentManagedAccess: ::std::os::raw::c_int,
    #[doc = "< Is compute preemption supported on the device"]
    pub computePreemptionSupported: ::std::os::raw::c_int,
    #[doc = "< Device can access host registered memory with same\n< address as the host"]
    pub canUseHostPointerForRegisteredMem: ::std::os::raw::c_int,
    #[doc = "< HIP device supports cooperative launch"]
    pub cooperativeLaunch: ::std::os::raw::c_int,
    #[doc = "< HIP device supports cooperative launch on multiple\n< devices"]
    pub cooperativeMultiDeviceLaunch: ::std::os::raw::c_int,
    #[doc = "< Per device m ax shared mem per block usable by special opt in"]
    pub sharedMemPerBlockOptin: usize,
    #[doc = "< Device accesses pageable memory via the host's\n< page tables"]
    pub pageableMemoryAccessUsesHostPageTables: ::std::os::raw::c_int,
    #[doc = "< Host can directly access managed memory on the device\n< without migration"]
    pub directManagedMemAccessFromHost: ::std::os::raw::c_int,
    #[doc = "< Max number of blocks on CU"]
    pub maxBlocksPerMultiProcessor: ::std::os::raw::c_int,
    #[doc = "< Max value of access policy window"]
    pub accessPolicyMaxWindowSize: ::std::os::raw::c_int,
    #[doc = "< Shared memory reserved by driver per block"]
    pub reservedSharedMemPerBlock: usize,
    #[doc = "< Device supports hipHostRegister"]
    pub hostRegisterSupported: ::std::os::raw::c_int,
    #[doc = "< Indicates if device supports sparse hip arrays"]
    pub sparseHipArraySupported: ::std::os::raw::c_int,
    #[doc = "< Device supports using the hipHostRegisterReadOnly flag\n< with hipHostRegistger"]
    pub hostRegisterReadOnlySupported: ::std::os::raw::c_int,
    #[doc = "< Indicates external timeline semaphore support"]
    pub timelineSemaphoreInteropSupported: ::std::os::raw::c_int,
    #[doc = "< Indicates if device supports hipMallocAsync and hipMemPool APIs"]
    pub memoryPoolsSupported: ::std::os::raw::c_int,
    #[doc = "< Indicates device support of RDMA APIs"]
    pub gpuDirectRDMASupported: ::std::os::raw::c_int,
    #[doc = "< Bitmask to be interpreted according to\n< hipFlushGPUDirectRDMAWritesOptions"]
    pub gpuDirectRDMAFlushWritesOptions: ::std::os::raw::c_uint,
    #[doc = "< value of hipGPUDirectRDMAWritesOrdering"]
    pub gpuDirectRDMAWritesOrdering: ::std::os::raw::c_int,
    #[doc = "< Bitmask of handle types support with mempool based IPC"]
    pub memoryPoolSupportedHandleTypes: ::std::os::raw::c_uint,
    #[doc = "< Device supports deferred mapping HIP arrays and HIP\n< mipmapped arrays"]
    pub deferredMappingHipArraySupported: ::std::os::raw::c_int,
    #[doc = "< Device supports IPC events"]
    pub ipcEventSupported: ::std::os::raw::c_int,
    #[doc = "< Device supports cluster launch"]
    pub clusterLaunch: ::std::os::raw::c_int,
    #[doc = "< Indicates device supports unified function pointers"]
    pub unifiedFunctionPointers: ::std::os::raw::c_int,
    #[doc = "< CUDA Reserved."]
    pub reserved: [::std::os::raw::c_int; 63usize],
    #[doc = "< Reserved for adding new entries for HIP/CUDA."]
    pub hipReserved: [::std::os::raw::c_int; 32usize],
    #[doc = "< AMD GCN Arch Name. HIP Only."]
    pub gcnArchName: [::std::os::raw::c_char; 256usize],
    #[doc = "< Maximum Shared Memory Per CU. HIP Only."]
    pub maxSharedMemoryPerMultiProcessor: usize,
    #[doc = "< Frequency in khz of the timer used by the device-side \"clock*\"\n< instructions.  New for HIP."]
    pub clockInstructionRate: ::std::os::raw::c_int,
    #[doc = "< Architectural feature flags.  New for HIP."]
    pub arch: hipDeviceArch_t,
    #[doc = "< Addres of HDP_MEM_COHERENCY_FLUSH_CNTL register"]
    pub hdpMemFlushCntl: *mut ::std::os::raw::c_uint,
    #[doc = "< Addres of HDP_REG_COHERENCY_FLUSH_CNTL register"]
    pub hdpRegFlushCntl: *mut ::std::os::raw::c_uint,
    #[doc = "< HIP device supports cooperative launch on\n< multiple"]
    pub cooperativeMultiDeviceUnmatchedFunc: ::std::os::raw::c_int,
    #[doc = "< HIP device supports cooperative launch on\n< multiple"]
    pub cooperativeMultiDeviceUnmatchedGridDim: ::std::os::raw::c_int,
    #[doc = "< HIP device supports cooperative launch on\n< multiple"]
    pub cooperativeMultiDeviceUnmatchedBlockDim: ::std::os::raw::c_int,
    #[doc = "< HIP device supports cooperative launch on\n< multiple"]
    pub cooperativeMultiDeviceUnmatchedSharedMem: ::std::os::raw::c_int,
    #[doc = "< 1: if it is a large PCI bar device, else 0"]
    pub isLargeBar: ::std::os::raw::c_int,
    #[doc = "< Revision of the GPU in this device"]
    pub asicRevision: ::std::os::raw::c_int,
}
#[doc = "< Unregistered memory"]
pub const hipMemoryType_hipMemoryTypeUnregistered: hipMemoryType = 0;
#[doc = "< Memory is physically located on host"]
pub const hipMemoryType_hipMemoryTypeHost: hipMemoryType = 1;
#[doc = "< Memory is physically located on device. (see deviceId for\n< specific device)"]
pub const hipMemoryType_hipMemoryTypeDevice: hipMemoryType = 2;
#[doc = "< Managed memory, automaticallly managed by the unified\n< memory system\n< place holder for new values."]
pub const hipMemoryType_hipMemoryTypeManaged: hipMemoryType = 3;
#[doc = "< Array memory, physically located on device. (see deviceId for\n< specific device)"]
pub const hipMemoryType_hipMemoryTypeArray: hipMemoryType = 10;
#[doc = "< unified address space"]
pub const hipMemoryType_hipMemoryTypeUnified: hipMemoryType = 11;
#[doc = " hipMemoryType (for pointer attributes)\n\n @note hipMemoryType enum values are combination of cudaMemoryType and cuMemoryType and AMD specific enum values.\n"]
pub type hipMemoryType = ::std::os::raw::c_uint;
#[doc = " Pointer attributes"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipPointerAttribute_t {
    pub type_: hipMemoryType,
    pub device: ::std::os::raw::c_int,
    pub devicePointer: *mut ::std::os::raw::c_void,
    pub hostPointer: *mut ::std::os::raw::c_void,
    pub isManaged: ::std::os::raw::c_int,
    pub allocationFlags: ::std::os::raw::c_uint,
}
#[doc = "< Successful completion."]
pub const hipError_t_hipSuccess: hipError_t = 0;
#[doc = "< One or more of the parameters passed to the API call is NULL\n< or not in an acceptable range."]
pub const hipError_t_hipErrorInvalidValue: hipError_t = 1;
#[doc = "< out of memory range."]
pub const hipError_t_hipErrorOutOfMemory: hipError_t = 2;
#[doc = "< Memory allocation error."]
pub const hipError_t_hipErrorMemoryAllocation: hipError_t = 2;
#[doc = "< Invalid not initialized"]
pub const hipError_t_hipErrorNotInitialized: hipError_t = 3;
pub const hipError_t_hipErrorInitializationError: hipError_t = 3;
#[doc = "< Deinitialized"]
pub const hipError_t_hipErrorDeinitialized: hipError_t = 4;
pub const hipError_t_hipErrorProfilerDisabled: hipError_t = 5;
pub const hipError_t_hipErrorProfilerNotInitialized: hipError_t = 6;
pub const hipError_t_hipErrorProfilerAlreadyStarted: hipError_t = 7;
pub const hipError_t_hipErrorProfilerAlreadyStopped: hipError_t = 8;
#[doc = "< Invalide configuration"]
pub const hipError_t_hipErrorInvalidConfiguration: hipError_t = 9;
#[doc = "< Invalid pitch value"]
pub const hipError_t_hipErrorInvalidPitchValue: hipError_t = 12;
#[doc = "< Invalid symbol"]
pub const hipError_t_hipErrorInvalidSymbol: hipError_t = 13;
#[doc = "< Invalid Device Pointer"]
pub const hipError_t_hipErrorInvalidDevicePointer: hipError_t = 17;
#[doc = "< Invalid memory copy direction"]
pub const hipError_t_hipErrorInvalidMemcpyDirection: hipError_t = 21;
pub const hipError_t_hipErrorInsufficientDriver: hipError_t = 35;
pub const hipError_t_hipErrorMissingConfiguration: hipError_t = 52;
pub const hipError_t_hipErrorPriorLaunchFailure: hipError_t = 53;
#[doc = "< Invalid device function"]
pub const hipError_t_hipErrorInvalidDeviceFunction: hipError_t = 98;
#[doc = "< Call to hipGetDeviceCount returned 0 devices"]
pub const hipError_t_hipErrorNoDevice: hipError_t = 100;
#[doc = "< DeviceID must be in range from 0 to compute-devices."]
pub const hipError_t_hipErrorInvalidDevice: hipError_t = 101;
#[doc = "< Invalid image"]
pub const hipError_t_hipErrorInvalidImage: hipError_t = 200;
#[doc = "< Produced when input context is invalid."]
pub const hipError_t_hipErrorInvalidContext: hipError_t = 201;
pub const hipError_t_hipErrorContextAlreadyCurrent: hipError_t = 202;
pub const hipError_t_hipErrorMapFailed: hipError_t = 205;
#[doc = "< Produced when the IPC memory attach failed from ROCr."]
pub const hipError_t_hipErrorMapBufferObjectFailed: hipError_t = 205;
pub const hipError_t_hipErrorUnmapFailed: hipError_t = 206;
pub const hipError_t_hipErrorArrayIsMapped: hipError_t = 207;
pub const hipError_t_hipErrorAlreadyMapped: hipError_t = 208;
pub const hipError_t_hipErrorNoBinaryForGpu: hipError_t = 209;
pub const hipError_t_hipErrorAlreadyAcquired: hipError_t = 210;
pub const hipError_t_hipErrorNotMapped: hipError_t = 211;
pub const hipError_t_hipErrorNotMappedAsArray: hipError_t = 212;
pub const hipError_t_hipErrorNotMappedAsPointer: hipError_t = 213;
pub const hipError_t_hipErrorECCNotCorrectable: hipError_t = 214;
#[doc = "< Unsupported limit"]
pub const hipError_t_hipErrorUnsupportedLimit: hipError_t = 215;
#[doc = "< The context is already in use"]
pub const hipError_t_hipErrorContextAlreadyInUse: hipError_t = 216;
pub const hipError_t_hipErrorPeerAccessUnsupported: hipError_t = 217;
#[doc = "< In CUDA DRV, it is CUDA_ERROR_INVALID_PTX"]
pub const hipError_t_hipErrorInvalidKernelFile: hipError_t = 218;
pub const hipError_t_hipErrorInvalidGraphicsContext: hipError_t = 219;
#[doc = "< Invalid source."]
pub const hipError_t_hipErrorInvalidSource: hipError_t = 300;
#[doc = "< the file is not found."]
pub const hipError_t_hipErrorFileNotFound: hipError_t = 301;
pub const hipError_t_hipErrorSharedObjectSymbolNotFound: hipError_t = 302;
#[doc = "< Failed to initialize shared object."]
pub const hipError_t_hipErrorSharedObjectInitFailed: hipError_t = 303;
#[doc = "< Not the correct operating system"]
pub const hipError_t_hipErrorOperatingSystem: hipError_t = 304;
#[doc = "< Invalide handle"]
pub const hipError_t_hipErrorInvalidHandle: hipError_t = 400;
#[doc = "< Resource handle (hipEvent_t or hipStream_t) invalid."]
pub const hipError_t_hipErrorInvalidResourceHandle: hipError_t = 400;
#[doc = "< Resource required is not in a valid state to perform operation."]
pub const hipError_t_hipErrorIllegalState: hipError_t = 401;
#[doc = "< Not found"]
pub const hipError_t_hipErrorNotFound: hipError_t = 500;
#[doc = "< Indicates that asynchronous operations enqueued earlier are not\n< ready.  This is not actually an error, but is used to distinguish\n< from hipSuccess (which indicates completion).  APIs that return\n< this error include hipEventQuery and hipStreamQuery."]
pub const hipError_t_hipErrorNotReady: hipError_t = 600;
pub const hipError_t_hipErrorIllegalAddress: hipError_t = 700;
#[doc = "< Out of resources error."]
pub const hipError_t_hipErrorLaunchOutOfResources: hipError_t = 701;
#[doc = "< Timeout for the launch."]
pub const hipError_t_hipErrorLaunchTimeOut: hipError_t = 702;
#[doc = "< Peer access was already enabled from the current\n< device."]
pub const hipError_t_hipErrorPeerAccessAlreadyEnabled: hipError_t = 704;
#[doc = "< Peer access was never enabled from the current device."]
pub const hipError_t_hipErrorPeerAccessNotEnabled: hipError_t = 705;
#[doc = "< The process is active."]
pub const hipError_t_hipErrorSetOnActiveProcess: hipError_t = 708;
#[doc = "< The context is already destroyed"]
pub const hipError_t_hipErrorContextIsDestroyed: hipError_t = 709;
#[doc = "< Produced when the kernel calls assert."]
pub const hipError_t_hipErrorAssert: hipError_t = 710;
#[doc = "< Produced when trying to lock a page-locked\n< memory."]
pub const hipError_t_hipErrorHostMemoryAlreadyRegistered: hipError_t = 712;
#[doc = "< Produced when trying to unlock a non-page-locked\n< memory."]
pub const hipError_t_hipErrorHostMemoryNotRegistered: hipError_t = 713;
#[doc = "< An exception occurred on the device while executing a kernel."]
pub const hipError_t_hipErrorLaunchFailure: hipError_t = 719;
#[doc = "< This error indicates that the number of blocks\n< launched per grid for a kernel that was launched\n< via cooperative launch APIs exceeds the maximum\n< number of allowed blocks for the current device."]
pub const hipError_t_hipErrorCooperativeLaunchTooLarge: hipError_t = 720;
#[doc = "< Produced when the hip API is not supported/implemented"]
pub const hipError_t_hipErrorNotSupported: hipError_t = 801;
#[doc = "< The operation is not permitted when the stream\n< is capturing."]
pub const hipError_t_hipErrorStreamCaptureUnsupported: hipError_t = 900;
#[doc = "< The current capture sequence on the stream\n< has been invalidated due to a previous error."]
pub const hipError_t_hipErrorStreamCaptureInvalidated: hipError_t = 901;
#[doc = "< The operation would have resulted in a merge of\n< two independent capture sequences."]
pub const hipError_t_hipErrorStreamCaptureMerge: hipError_t = 902;
#[doc = "< The capture was not initiated in this stream."]
pub const hipError_t_hipErrorStreamCaptureUnmatched: hipError_t = 903;
#[doc = "< The capture sequence contains a fork that was not\n< joined to the primary stream."]
pub const hipError_t_hipErrorStreamCaptureUnjoined: hipError_t = 904;
#[doc = "< A dependency would have been created which crosses\n< the capture sequence boundary. Only implicit\n< in-stream ordering dependencies  are allowed\n< to cross the boundary"]
pub const hipError_t_hipErrorStreamCaptureIsolation: hipError_t = 905;
#[doc = "< The operation would have resulted in a disallowed\n< implicit dependency on a current capture sequence\n< from hipStreamLegacy."]
pub const hipError_t_hipErrorStreamCaptureImplicit: hipError_t = 906;
#[doc = "< The operation is not permitted on an event which was last\n< recorded in a capturing stream."]
pub const hipError_t_hipErrorCapturedEvent: hipError_t = 907;
#[doc = "< A stream capture sequence not initiated with\n< the hipStreamCaptureModeRelaxed argument to\n< hipStreamBeginCapture was passed to\n< hipStreamEndCapture in a different thread."]
pub const hipError_t_hipErrorStreamCaptureWrongThread: hipError_t = 908;
#[doc = "< This error indicates that the graph update\n< not performed because it included changes which\n< violated constraintsspecific to instantiated graph\n< update."]
pub const hipError_t_hipErrorGraphExecUpdateFailure: hipError_t = 910;
#[doc = "< Invalid channel descriptor."]
pub const hipError_t_hipErrorInvalidChannelDescriptor: hipError_t = 911;
#[doc = "< Invalid texture."]
pub const hipError_t_hipErrorInvalidTexture: hipError_t = 912;
#[doc = "< Unknown error."]
pub const hipError_t_hipErrorUnknown: hipError_t = 999;
#[doc = "< HSA runtime memory call returned error.  Typically not seen\n< in production systems."]
pub const hipError_t_hipErrorRuntimeMemory: hipError_t = 1052;
#[doc = "< HSA runtime call other than memory returned error.  Typically\n< not seen in production systems."]
pub const hipError_t_hipErrorRuntimeOther: hipError_t = 1053;
#[doc = "< Marker that more error codes are needed."]
pub const hipError_t_hipErrorTbd: hipError_t = 1054;
#[doc = " HIP error type\n"]
pub type hipError_t = ::std::os::raw::c_uint;
pub const hipDeviceAttribute_t_hipDeviceAttributeCudaCompatibleBegin: hipDeviceAttribute_t = 0;
#[doc = "< Whether ECC support is enabled."]
pub const hipDeviceAttribute_t_hipDeviceAttributeEccEnabled: hipDeviceAttribute_t = 0;
#[doc = "< Cuda only. The maximum size of the window policy in bytes."]
pub const hipDeviceAttribute_t_hipDeviceAttributeAccessPolicyMaxWindowSize: hipDeviceAttribute_t =
    1;
#[doc = "< Asynchronous engines number."]
pub const hipDeviceAttribute_t_hipDeviceAttributeAsyncEngineCount: hipDeviceAttribute_t = 2;
#[doc = "< Whether host memory can be mapped into device address space"]
pub const hipDeviceAttribute_t_hipDeviceAttributeCanMapHostMemory: hipDeviceAttribute_t = 3;
#[doc = "< Device can access host registered memory\n< at the same virtual address as the CPU"]
pub const hipDeviceAttribute_t_hipDeviceAttributeCanUseHostPointerForRegisteredMem:
    hipDeviceAttribute_t = 4;
#[doc = "< Peak clock frequency in kilohertz."]
pub const hipDeviceAttribute_t_hipDeviceAttributeClockRate: hipDeviceAttribute_t = 5;
#[doc = "< Compute mode that device is currently in."]
pub const hipDeviceAttribute_t_hipDeviceAttributeComputeMode: hipDeviceAttribute_t = 6;
#[doc = "< Device supports Compute Preemption."]
pub const hipDeviceAttribute_t_hipDeviceAttributeComputePreemptionSupported: hipDeviceAttribute_t =
    7;
#[doc = "< Device can possibly execute multiple kernels concurrently."]
pub const hipDeviceAttribute_t_hipDeviceAttributeConcurrentKernels: hipDeviceAttribute_t = 8;
#[doc = "< Device can coherently access managed memory concurrently with the CPU"]
pub const hipDeviceAttribute_t_hipDeviceAttributeConcurrentManagedAccess: hipDeviceAttribute_t = 9;
#[doc = "< Support cooperative launch"]
pub const hipDeviceAttribute_t_hipDeviceAttributeCooperativeLaunch: hipDeviceAttribute_t = 10;
#[doc = "< Support cooperative launch on multiple devices"]
pub const hipDeviceAttribute_t_hipDeviceAttributeCooperativeMultiDeviceLaunch:
    hipDeviceAttribute_t = 11;
#[doc = "< Device can concurrently copy memory and execute a kernel.\n< Deprecated. Use instead asyncEngineCount."]
pub const hipDeviceAttribute_t_hipDeviceAttributeDeviceOverlap: hipDeviceAttribute_t = 12;
#[doc = "< Host can directly access managed memory on\n< the device without migration"]
pub const hipDeviceAttribute_t_hipDeviceAttributeDirectManagedMemAccessFromHost:
    hipDeviceAttribute_t = 13;
#[doc = "< Device supports caching globals in L1"]
pub const hipDeviceAttribute_t_hipDeviceAttributeGlobalL1CacheSupported: hipDeviceAttribute_t = 14;
#[doc = "< Link between the device and the host supports native atomic operations"]
pub const hipDeviceAttribute_t_hipDeviceAttributeHostNativeAtomicSupported: hipDeviceAttribute_t =
    15;
#[doc = "< Device is integrated GPU"]
pub const hipDeviceAttribute_t_hipDeviceAttributeIntegrated: hipDeviceAttribute_t = 16;
#[doc = "< Multiple GPU devices."]
pub const hipDeviceAttribute_t_hipDeviceAttributeIsMultiGpuBoard: hipDeviceAttribute_t = 17;
#[doc = "< Run time limit for kernels executed on the device"]
pub const hipDeviceAttribute_t_hipDeviceAttributeKernelExecTimeout: hipDeviceAttribute_t = 18;
#[doc = "< Size of L2 cache in bytes. 0 if the device doesn't have L2 cache."]
pub const hipDeviceAttribute_t_hipDeviceAttributeL2CacheSize: hipDeviceAttribute_t = 19;
#[doc = "< caching locals in L1 is supported"]
pub const hipDeviceAttribute_t_hipDeviceAttributeLocalL1CacheSupported: hipDeviceAttribute_t = 20;
#[doc = "< 8-byte locally unique identifier in 8 bytes. Undefined on TCC and non-Windows platforms"]
pub const hipDeviceAttribute_t_hipDeviceAttributeLuid: hipDeviceAttribute_t = 21;
#[doc = "< Luid device node mask. Undefined on TCC and non-Windows platforms"]
pub const hipDeviceAttribute_t_hipDeviceAttributeLuidDeviceNodeMask: hipDeviceAttribute_t = 22;
#[doc = "< Major compute capability version number."]
pub const hipDeviceAttribute_t_hipDeviceAttributeComputeCapabilityMajor: hipDeviceAttribute_t = 23;
#[doc = "< Device supports allocating managed memory on this system"]
pub const hipDeviceAttribute_t_hipDeviceAttributeManagedMemory: hipDeviceAttribute_t = 24;
#[doc = "< Max block size per multiprocessor"]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxBlocksPerMultiProcessor: hipDeviceAttribute_t =
    25;
#[doc = "< Max block size in width."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxBlockDimX: hipDeviceAttribute_t = 26;
#[doc = "< Max block size in height."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxBlockDimY: hipDeviceAttribute_t = 27;
#[doc = "< Max block size in depth."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxBlockDimZ: hipDeviceAttribute_t = 28;
#[doc = "< Max grid size  in width."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxGridDimX: hipDeviceAttribute_t = 29;
#[doc = "< Max grid size  in height."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxGridDimY: hipDeviceAttribute_t = 30;
#[doc = "< Max grid size  in depth."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxGridDimZ: hipDeviceAttribute_t = 31;
#[doc = "< Maximum size of 1D surface."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxSurface1D: hipDeviceAttribute_t = 32;
#[doc = "< Cuda only. Maximum dimensions of 1D layered surface."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxSurface1DLayered: hipDeviceAttribute_t = 33;
#[doc = "< Maximum dimension (width, height) of 2D surface."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxSurface2D: hipDeviceAttribute_t = 34;
#[doc = "< Cuda only. Maximum dimensions of 2D layered surface."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxSurface2DLayered: hipDeviceAttribute_t = 35;
#[doc = "< Maximum dimension (width, height, depth) of 3D surface."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxSurface3D: hipDeviceAttribute_t = 36;
#[doc = "< Cuda only. Maximum dimensions of Cubemap surface."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxSurfaceCubemap: hipDeviceAttribute_t = 37;
#[doc = "< Cuda only. Maximum dimension of Cubemap layered surface."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxSurfaceCubemapLayered: hipDeviceAttribute_t =
    38;
#[doc = "< Maximum size of 1D texture."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxTexture1DWidth: hipDeviceAttribute_t = 39;
#[doc = "< Maximum dimensions of 1D layered texture."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxTexture1DLayered: hipDeviceAttribute_t = 40;
#[doc = "< Maximum number of elements allocatable in a 1D linear texture.\n< Use cudaDeviceGetTexture1DLinearMaxWidth() instead on Cuda."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxTexture1DLinear: hipDeviceAttribute_t = 41;
#[doc = "< Maximum size of 1D mipmapped texture."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxTexture1DMipmap: hipDeviceAttribute_t = 42;
#[doc = "< Maximum dimension width of 2D texture."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxTexture2DWidth: hipDeviceAttribute_t = 43;
#[doc = "< Maximum dimension hight of 2D texture."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxTexture2DHeight: hipDeviceAttribute_t = 44;
#[doc = "< Maximum dimensions of 2D texture if gather operations  performed."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxTexture2DGather: hipDeviceAttribute_t = 45;
#[doc = "< Maximum dimensions of 2D layered texture."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxTexture2DLayered: hipDeviceAttribute_t = 46;
#[doc = "< Maximum dimensions (width, height, pitch) of 2D textures bound to pitched memory."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxTexture2DLinear: hipDeviceAttribute_t = 47;
#[doc = "< Maximum dimensions of 2D mipmapped texture."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxTexture2DMipmap: hipDeviceAttribute_t = 48;
#[doc = "< Maximum dimension width of 3D texture."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxTexture3DWidth: hipDeviceAttribute_t = 49;
#[doc = "< Maximum dimension height of 3D texture."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxTexture3DHeight: hipDeviceAttribute_t = 50;
#[doc = "< Maximum dimension depth of 3D texture."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxTexture3DDepth: hipDeviceAttribute_t = 51;
#[doc = "< Maximum dimensions of alternate 3D texture."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxTexture3DAlt: hipDeviceAttribute_t = 52;
#[doc = "< Maximum dimensions of Cubemap texture"]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxTextureCubemap: hipDeviceAttribute_t = 53;
#[doc = "< Maximum dimensions of Cubemap layered texture."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxTextureCubemapLayered: hipDeviceAttribute_t =
    54;
#[doc = "< Maximum dimension of a block"]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxThreadsDim: hipDeviceAttribute_t = 55;
#[doc = "< Maximum number of threads per block."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxThreadsPerBlock: hipDeviceAttribute_t = 56;
#[doc = "< Maximum resident threads per multiprocessor."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxThreadsPerMultiProcessor: hipDeviceAttribute_t =
    57;
#[doc = "< Maximum pitch in bytes allowed by memory copies"]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxPitch: hipDeviceAttribute_t = 58;
#[doc = "< Global memory bus width in bits."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMemoryBusWidth: hipDeviceAttribute_t = 59;
#[doc = "< Peak memory clock frequency in kilohertz."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMemoryClockRate: hipDeviceAttribute_t = 60;
#[doc = "< Minor compute capability version number."]
pub const hipDeviceAttribute_t_hipDeviceAttributeComputeCapabilityMinor: hipDeviceAttribute_t = 61;
#[doc = "< Unique ID of device group on the same multi-GPU board"]
pub const hipDeviceAttribute_t_hipDeviceAttributeMultiGpuBoardGroupID: hipDeviceAttribute_t = 62;
#[doc = "< Number of multiprocessors on the device."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMultiprocessorCount: hipDeviceAttribute_t = 63;
#[doc = "< Previously hipDeviceAttributeName"]
pub const hipDeviceAttribute_t_hipDeviceAttributeUnused1: hipDeviceAttribute_t = 64;
#[doc = "< Device supports coherently accessing pageable memory\n< without calling hipHostRegister on it"]
pub const hipDeviceAttribute_t_hipDeviceAttributePageableMemoryAccess: hipDeviceAttribute_t = 65;
#[doc = "< Device accesses pageable memory via the host's page tables"]
pub const hipDeviceAttribute_t_hipDeviceAttributePageableMemoryAccessUsesHostPageTables:
    hipDeviceAttribute_t = 66;
#[doc = "< PCI Bus ID."]
pub const hipDeviceAttribute_t_hipDeviceAttributePciBusId: hipDeviceAttribute_t = 67;
#[doc = "< PCI Device ID."]
pub const hipDeviceAttribute_t_hipDeviceAttributePciDeviceId: hipDeviceAttribute_t = 68;
#[doc = "< PCI Domain ID."]
pub const hipDeviceAttribute_t_hipDeviceAttributePciDomainID: hipDeviceAttribute_t = 69;
#[doc = "< Maximum l2 persisting lines capacity in bytes"]
pub const hipDeviceAttribute_t_hipDeviceAttributePersistingL2CacheMaxSize: hipDeviceAttribute_t =
    70;
#[doc = "< 32-bit registers available to a thread block. This number is shared\n< by all thread blocks simultaneously resident on a multiprocessor."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxRegistersPerBlock: hipDeviceAttribute_t = 71;
#[doc = "< 32-bit registers available per block."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxRegistersPerMultiprocessor:
    hipDeviceAttribute_t = 72;
#[doc = "< Shared memory reserved by CUDA driver per block."]
pub const hipDeviceAttribute_t_hipDeviceAttributeReservedSharedMemPerBlock: hipDeviceAttribute_t =
    73;
#[doc = "< Maximum shared memory available per block in bytes."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxSharedMemoryPerBlock: hipDeviceAttribute_t = 74;
#[doc = "< Maximum shared memory per block usable by special opt in."]
pub const hipDeviceAttribute_t_hipDeviceAttributeSharedMemPerBlockOptin: hipDeviceAttribute_t = 75;
#[doc = "< Shared memory available per multiprocessor."]
pub const hipDeviceAttribute_t_hipDeviceAttributeSharedMemPerMultiprocessor: hipDeviceAttribute_t =
    76;
#[doc = "< Cuda only. Performance ratio of single precision to double precision."]
pub const hipDeviceAttribute_t_hipDeviceAttributeSingleToDoublePrecisionPerfRatio:
    hipDeviceAttribute_t = 77;
#[doc = "< Whether to support stream priorities."]
pub const hipDeviceAttribute_t_hipDeviceAttributeStreamPrioritiesSupported: hipDeviceAttribute_t =
    78;
#[doc = "< Alignment requirement for surfaces"]
pub const hipDeviceAttribute_t_hipDeviceAttributeSurfaceAlignment: hipDeviceAttribute_t = 79;
#[doc = "< Cuda only. Whether device is a Tesla device using TCC driver"]
pub const hipDeviceAttribute_t_hipDeviceAttributeTccDriver: hipDeviceAttribute_t = 80;
#[doc = "< Alignment requirement for textures"]
pub const hipDeviceAttribute_t_hipDeviceAttributeTextureAlignment: hipDeviceAttribute_t = 81;
#[doc = "< Pitch alignment requirement for 2D texture references bound to pitched memory;"]
pub const hipDeviceAttribute_t_hipDeviceAttributeTexturePitchAlignment: hipDeviceAttribute_t = 82;
#[doc = "< Constant memory size in bytes."]
pub const hipDeviceAttribute_t_hipDeviceAttributeTotalConstantMemory: hipDeviceAttribute_t = 83;
#[doc = "< Global memory available on devicice."]
pub const hipDeviceAttribute_t_hipDeviceAttributeTotalGlobalMem: hipDeviceAttribute_t = 84;
#[doc = "< Cuda only. An unified address space shared with the host."]
pub const hipDeviceAttribute_t_hipDeviceAttributeUnifiedAddressing: hipDeviceAttribute_t = 85;
#[doc = "< Previously hipDeviceAttributeUuid"]
pub const hipDeviceAttribute_t_hipDeviceAttributeUnused2: hipDeviceAttribute_t = 86;
#[doc = "< Warp size in threads."]
pub const hipDeviceAttribute_t_hipDeviceAttributeWarpSize: hipDeviceAttribute_t = 87;
#[doc = "< Device supports HIP Stream Ordered Memory Allocator"]
pub const hipDeviceAttribute_t_hipDeviceAttributeMemoryPoolsSupported: hipDeviceAttribute_t = 88;
#[doc = "< Device supports HIP virtual memory management"]
pub const hipDeviceAttribute_t_hipDeviceAttributeVirtualMemoryManagementSupported:
    hipDeviceAttribute_t = 89;
#[doc = "< Can device support host memory registration via hipHostRegister"]
pub const hipDeviceAttribute_t_hipDeviceAttributeHostRegisterSupported: hipDeviceAttribute_t = 90;
#[doc = "< Supported handle mask for HIP Stream Ordered Memory Allocator"]
pub const hipDeviceAttribute_t_hipDeviceAttributeMemoryPoolSupportedHandleTypes:
    hipDeviceAttribute_t = 91;
pub const hipDeviceAttribute_t_hipDeviceAttributeCudaCompatibleEnd: hipDeviceAttribute_t = 9999;
pub const hipDeviceAttribute_t_hipDeviceAttributeAmdSpecificBegin: hipDeviceAttribute_t = 10000;
#[doc = "< Frequency in khz of the timer used by the device-side \"clock*\""]
pub const hipDeviceAttribute_t_hipDeviceAttributeClockInstructionRate: hipDeviceAttribute_t = 10000;
#[doc = "< Previously hipDeviceAttributeArch"]
pub const hipDeviceAttribute_t_hipDeviceAttributeUnused3: hipDeviceAttribute_t = 10001;
#[doc = "< Maximum Shared Memory PerMultiprocessor."]
pub const hipDeviceAttribute_t_hipDeviceAttributeMaxSharedMemoryPerMultiprocessor:
    hipDeviceAttribute_t = 10002;
#[doc = "< Previously hipDeviceAttributeGcnArch"]
pub const hipDeviceAttribute_t_hipDeviceAttributeUnused4: hipDeviceAttribute_t = 10003;
#[doc = "< Previously hipDeviceAttributeGcnArchName"]
pub const hipDeviceAttribute_t_hipDeviceAttributeUnused5: hipDeviceAttribute_t = 10004;
#[doc = "< Address of the HDP_MEM_COHERENCY_FLUSH_CNTL register"]
pub const hipDeviceAttribute_t_hipDeviceAttributeHdpMemFlushCntl: hipDeviceAttribute_t = 10005;
#[doc = "< Address of the HDP_REG_COHERENCY_FLUSH_CNTL register"]
pub const hipDeviceAttribute_t_hipDeviceAttributeHdpRegFlushCntl: hipDeviceAttribute_t = 10006;
#[doc = "< Supports cooperative launch on multiple\n< devices with unmatched functions"]
pub const hipDeviceAttribute_t_hipDeviceAttributeCooperativeMultiDeviceUnmatchedFunc:
    hipDeviceAttribute_t = 10007;
#[doc = "< Supports cooperative launch on multiple\n< devices with unmatched grid dimensions"]
pub const hipDeviceAttribute_t_hipDeviceAttributeCooperativeMultiDeviceUnmatchedGridDim:
    hipDeviceAttribute_t = 10008;
#[doc = "< Supports cooperative launch on multiple\n< devices with unmatched block dimensions"]
pub const hipDeviceAttribute_t_hipDeviceAttributeCooperativeMultiDeviceUnmatchedBlockDim:
    hipDeviceAttribute_t = 10009;
#[doc = "< Supports cooperative launch on multiple\n< devices with unmatched shared memories"]
pub const hipDeviceAttribute_t_hipDeviceAttributeCooperativeMultiDeviceUnmatchedSharedMem:
    hipDeviceAttribute_t = 10010;
#[doc = "< Whether it is LargeBar"]
pub const hipDeviceAttribute_t_hipDeviceAttributeIsLargeBar: hipDeviceAttribute_t = 10011;
#[doc = "< Revision of the GPU in this device"]
pub const hipDeviceAttribute_t_hipDeviceAttributeAsicRevision: hipDeviceAttribute_t = 10012;
#[doc = "< '1' if Device supports hipStreamWaitValue32() and\n< hipStreamWaitValue64(), '0' otherwise."]
pub const hipDeviceAttribute_t_hipDeviceAttributeCanUseStreamWaitValue: hipDeviceAttribute_t =
    10013;
#[doc = "< '1' if Device supports image, '0' otherwise."]
pub const hipDeviceAttribute_t_hipDeviceAttributeImageSupport: hipDeviceAttribute_t = 10014;
#[doc = "< All available physical compute\n< units for the device"]
pub const hipDeviceAttribute_t_hipDeviceAttributePhysicalMultiProcessorCount: hipDeviceAttribute_t =
    10015;
#[doc = "< '1' if Device supports fine grain, '0' otherwise"]
pub const hipDeviceAttribute_t_hipDeviceAttributeFineGrainSupport: hipDeviceAttribute_t = 10016;
#[doc = "< Constant frequency of wall clock in kilohertz."]
pub const hipDeviceAttribute_t_hipDeviceAttributeWallClockRate: hipDeviceAttribute_t = 10017;
pub const hipDeviceAttribute_t_hipDeviceAttributeAmdSpecificEnd: hipDeviceAttribute_t = 19999;
pub const hipDeviceAttribute_t_hipDeviceAttributeVendorSpecificBegin: hipDeviceAttribute_t = 20000;
#[doc = " hipDeviceAttribute_t\n hipDeviceAttributeUnused number: 5"]
pub type hipDeviceAttribute_t = ::std::os::raw::c_uint;
pub const hipDriverProcAddressQueryResult_HIP_GET_PROC_ADDRESS_SUCCESS:
    hipDriverProcAddressQueryResult = 0;
pub const hipDriverProcAddressQueryResult_HIP_GET_PROC_ADDRESS_SYMBOL_NOT_FOUND:
    hipDriverProcAddressQueryResult = 1;
pub const hipDriverProcAddressQueryResult_HIP_GET_PROC_ADDRESS_VERSION_NOT_SUFFICIENT:
    hipDriverProcAddressQueryResult = 2;
pub type hipDriverProcAddressQueryResult = ::std::os::raw::c_uint;
pub const hipComputeMode_hipComputeModeDefault: hipComputeMode = 0;
pub const hipComputeMode_hipComputeModeExclusive: hipComputeMode = 1;
pub const hipComputeMode_hipComputeModeProhibited: hipComputeMode = 2;
pub const hipComputeMode_hipComputeModeExclusiveProcess: hipComputeMode = 3;
pub type hipComputeMode = ::std::os::raw::c_uint;
pub const hipFlushGPUDirectRDMAWritesOptions_hipFlushGPUDirectRDMAWritesOptionHost:
    hipFlushGPUDirectRDMAWritesOptions = 1;
pub const hipFlushGPUDirectRDMAWritesOptions_hipFlushGPUDirectRDMAWritesOptionMemOps:
    hipFlushGPUDirectRDMAWritesOptions = 2;
pub type hipFlushGPUDirectRDMAWritesOptions = ::std::os::raw::c_uint;
pub const hipGPUDirectRDMAWritesOrdering_hipGPUDirectRDMAWritesOrderingNone:
    hipGPUDirectRDMAWritesOrdering = 0;
pub const hipGPUDirectRDMAWritesOrdering_hipGPUDirectRDMAWritesOrderingOwner:
    hipGPUDirectRDMAWritesOrdering = 100;
pub const hipGPUDirectRDMAWritesOrdering_hipGPUDirectRDMAWritesOrderingAllDevices:
    hipGPUDirectRDMAWritesOrdering = 200;
pub type hipGPUDirectRDMAWritesOrdering = ::std::os::raw::c_uint;
pub type int_least8_t = __int_least8_t;
pub type int_least16_t = __int_least16_t;
pub type int_least32_t = __int_least32_t;
pub type int_least64_t = __int_least64_t;
pub type uint_least8_t = __uint_least8_t;
pub type uint_least16_t = __uint_least16_t;
pub type uint_least32_t = __uint_least32_t;
pub type uint_least64_t = __uint_least64_t;
pub type int_fast8_t = ::std::os::raw::c_schar;
pub type int_fast16_t = ::std::os::raw::c_long;
pub type int_fast32_t = ::std::os::raw::c_long;
pub type int_fast64_t = ::std::os::raw::c_long;
pub type uint_fast8_t = ::std::os::raw::c_uchar;
pub type uint_fast16_t = ::std::os::raw::c_ulong;
pub type uint_fast32_t = ::std::os::raw::c_ulong;
pub type uint_fast64_t = ::std::os::raw::c_ulong;
pub type intmax_t = __intmax_t;
pub type uintmax_t = __uintmax_t;
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Copy, Clone)]
pub struct max_align_t {
    pub __clang_max_align_nonce1: ::std::os::raw::c_longlong,
    pub __bindgen_padding_0: u64,
    pub __clang_max_align_nonce2: u128,
}
#[doc = "  @defgroup DriverTypes Driver Types\n  @{\n  This section describes the driver data types.\n"]
pub type hipDeviceptr_t = *mut ::std::os::raw::c_void;
#[doc = "< Signed channel format"]
pub const hipChannelFormatKind_hipChannelFormatKindSigned: hipChannelFormatKind = 0;
#[doc = "< Unsigned channel format"]
pub const hipChannelFormatKind_hipChannelFormatKindUnsigned: hipChannelFormatKind = 1;
#[doc = "< Float channel format"]
pub const hipChannelFormatKind_hipChannelFormatKindFloat: hipChannelFormatKind = 2;
#[doc = "< No channel format"]
pub const hipChannelFormatKind_hipChannelFormatKindNone: hipChannelFormatKind = 3;
#[doc = " HIP channel format kinds"]
pub type hipChannelFormatKind = ::std::os::raw::c_uint;
#[doc = " HIP channel format descriptor"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipChannelFormatDesc {
    pub x: ::std::os::raw::c_int,
    pub y: ::std::os::raw::c_int,
    pub z: ::std::os::raw::c_int,
    pub w: ::std::os::raw::c_int,
    #[doc = "< Channel format kind"]
    pub f: hipChannelFormatKind,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipArray {
    _unused: [u8; 0],
}
pub type hipArray_t = *mut hipArray;
pub type hipArray_const_t = *const hipArray;
#[doc = "< Unsigned 8-bit array format"]
pub const hipArray_Format_HIP_AD_FORMAT_UNSIGNED_INT8: hipArray_Format = 1;
#[doc = "< Unsigned 16-bit array format"]
pub const hipArray_Format_HIP_AD_FORMAT_UNSIGNED_INT16: hipArray_Format = 2;
#[doc = "< Unsigned 32-bit array format"]
pub const hipArray_Format_HIP_AD_FORMAT_UNSIGNED_INT32: hipArray_Format = 3;
#[doc = "< Signed 8-bit array format"]
pub const hipArray_Format_HIP_AD_FORMAT_SIGNED_INT8: hipArray_Format = 8;
#[doc = "< Signed 16-bit array format"]
pub const hipArray_Format_HIP_AD_FORMAT_SIGNED_INT16: hipArray_Format = 9;
#[doc = "< Signed 32-bit array format"]
pub const hipArray_Format_HIP_AD_FORMAT_SIGNED_INT32: hipArray_Format = 10;
#[doc = "< Half array format"]
pub const hipArray_Format_HIP_AD_FORMAT_HALF: hipArray_Format = 16;
#[doc = "< Float array format"]
pub const hipArray_Format_HIP_AD_FORMAT_FLOAT: hipArray_Format = 32;
#[doc = " HIP array format"]
pub type hipArray_Format = ::std::os::raw::c_uint;
#[doc = " HIP array descriptor"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HIP_ARRAY_DESCRIPTOR {
    #[doc = "< Width of the array"]
    pub Width: usize,
    #[doc = "< Height of the array"]
    pub Height: usize,
    #[doc = "< Format of the array"]
    pub Format: hipArray_Format,
    #[doc = "< Number of channels of the array"]
    pub NumChannels: ::std::os::raw::c_uint,
}
#[doc = " HIP 3D array descriptor"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HIP_ARRAY3D_DESCRIPTOR {
    #[doc = "< Width of the array"]
    pub Width: usize,
    #[doc = "< Height of the array"]
    pub Height: usize,
    #[doc = "< Depth of the array"]
    pub Depth: usize,
    #[doc = "< Format of the array"]
    pub Format: hipArray_Format,
    #[doc = "< Number of channels of the array"]
    pub NumChannels: ::std::os::raw::c_uint,
    #[doc = "< Flags of the array"]
    pub Flags: ::std::os::raw::c_uint,
}
#[doc = " HIP 2D memory copy parameters"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hip_Memcpy2D {
    #[doc = "< Source width in bytes"]
    pub srcXInBytes: usize,
    #[doc = "< Source height"]
    pub srcY: usize,
    #[doc = "< Source memory type"]
    pub srcMemoryType: hipMemoryType,
    #[doc = "< Source pointer"]
    pub srcHost: *const ::std::os::raw::c_void,
    #[doc = "< Source device"]
    pub srcDevice: hipDeviceptr_t,
    #[doc = "< Source array"]
    pub srcArray: hipArray_t,
    #[doc = "< Source pitch"]
    pub srcPitch: usize,
    #[doc = "< Destination width in bytes"]
    pub dstXInBytes: usize,
    #[doc = "< Destination height"]
    pub dstY: usize,
    #[doc = "< Destination memory type"]
    pub dstMemoryType: hipMemoryType,
    #[doc = "< Destination pointer"]
    pub dstHost: *mut ::std::os::raw::c_void,
    #[doc = "< Destination device"]
    pub dstDevice: hipDeviceptr_t,
    #[doc = "< Destination array"]
    pub dstArray: hipArray_t,
    #[doc = "< Destination pitch"]
    pub dstPitch: usize,
    #[doc = "< Width in bytes of the 2D memory copy"]
    pub WidthInBytes: usize,
    #[doc = "< Height of the 2D memory copy"]
    pub Height: usize,
}
#[doc = " HIP mipmapped array"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipMipmappedArray {
    #[doc = "< Data pointer of the mipmapped array"]
    pub data: *mut ::std::os::raw::c_void,
    #[doc = "< Description of the mipmapped array"]
    pub desc: hipChannelFormatDesc,
    #[doc = "< Type of the mipmapped array"]
    pub type_: ::std::os::raw::c_uint,
    #[doc = "< Width of the mipmapped array"]
    pub width: ::std::os::raw::c_uint,
    #[doc = "< Height of the mipmapped array"]
    pub height: ::std::os::raw::c_uint,
    #[doc = "< Depth of the mipmapped array"]
    pub depth: ::std::os::raw::c_uint,
    #[doc = "< Minimum level of the mipmapped array"]
    pub min_mipmap_level: ::std::os::raw::c_uint,
    #[doc = "< Maximum level of the mipmapped array"]
    pub max_mipmap_level: ::std::os::raw::c_uint,
    #[doc = "< Flags of the mipmapped array"]
    pub flags: ::std::os::raw::c_uint,
    #[doc = "< Format of the mipmapped array"]
    pub format: hipArray_Format,
    #[doc = "< Number of channels of the mipmapped array"]
    pub num_channels: ::std::os::raw::c_uint,
}
#[doc = " HIP mipmapped array pointer"]
pub type hipMipmappedArray_t = *mut hipMipmappedArray;
pub type hipmipmappedArray = hipMipmappedArray_t;
pub type hipMipmappedArray_const_t = *const hipMipmappedArray;
#[doc = "< Array resource"]
pub const hipResourceType_hipResourceTypeArray: hipResourceType = 0;
#[doc = "< Mipmapped array resource"]
pub const hipResourceType_hipResourceTypeMipmappedArray: hipResourceType = 1;
#[doc = "< Linear resource"]
pub const hipResourceType_hipResourceTypeLinear: hipResourceType = 2;
#[doc = "< Pitch 2D resource"]
pub const hipResourceType_hipResourceTypePitch2D: hipResourceType = 3;
#[doc = " HIP resource types"]
pub type hipResourceType = ::std::os::raw::c_uint;
#[doc = "< Array resource"]
pub const HIPresourcetype_enum_HIP_RESOURCE_TYPE_ARRAY: HIPresourcetype_enum = 0;
#[doc = "< Mipmapped array resource"]
pub const HIPresourcetype_enum_HIP_RESOURCE_TYPE_MIPMAPPED_ARRAY: HIPresourcetype_enum = 1;
#[doc = "< Linear resource"]
pub const HIPresourcetype_enum_HIP_RESOURCE_TYPE_LINEAR: HIPresourcetype_enum = 2;
#[doc = "< Pitch 2D resource"]
pub const HIPresourcetype_enum_HIP_RESOURCE_TYPE_PITCH2D: HIPresourcetype_enum = 3;
pub type HIPresourcetype_enum = ::std::os::raw::c_uint;
pub use self::HIPresourcetype_enum as HIPresourcetype;
pub use self::HIPresourcetype_enum as hipResourcetype;
#[doc = "< Wrap address mode"]
pub const HIPaddress_mode_enum_HIP_TR_ADDRESS_MODE_WRAP: HIPaddress_mode_enum = 0;
#[doc = "< Clamp address mode"]
pub const HIPaddress_mode_enum_HIP_TR_ADDRESS_MODE_CLAMP: HIPaddress_mode_enum = 1;
#[doc = "< Mirror address mode"]
pub const HIPaddress_mode_enum_HIP_TR_ADDRESS_MODE_MIRROR: HIPaddress_mode_enum = 2;
#[doc = "< Border address mode"]
pub const HIPaddress_mode_enum_HIP_TR_ADDRESS_MODE_BORDER: HIPaddress_mode_enum = 3;
#[doc = " HIP texture address modes"]
pub type HIPaddress_mode_enum = ::std::os::raw::c_uint;
#[doc = " HIP texture address modes"]
pub use self::HIPaddress_mode_enum as HIPaddress_mode;
#[doc = "< Filter mode point"]
pub const HIPfilter_mode_enum_HIP_TR_FILTER_MODE_POINT: HIPfilter_mode_enum = 0;
#[doc = "< Filter mode linear"]
pub const HIPfilter_mode_enum_HIP_TR_FILTER_MODE_LINEAR: HIPfilter_mode_enum = 1;
#[doc = " HIP filter modes"]
pub type HIPfilter_mode_enum = ::std::os::raw::c_uint;
#[doc = " HIP filter modes"]
pub use self::HIPfilter_mode_enum as HIPfilter_mode;
#[doc = " HIP texture descriptor"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HIP_TEXTURE_DESC_st {
    #[doc = "< Address modes"]
    pub addressMode: [HIPaddress_mode; 3usize],
    #[doc = "< Filter mode"]
    pub filterMode: HIPfilter_mode,
    #[doc = "< Flags"]
    pub flags: ::std::os::raw::c_uint,
    #[doc = "< Maximum anisotropy ratio"]
    pub maxAnisotropy: ::std::os::raw::c_uint,
    #[doc = "< Mipmap filter mode"]
    pub mipmapFilterMode: HIPfilter_mode,
    #[doc = "< Mipmap level bias"]
    pub mipmapLevelBias: f32,
    #[doc = "< Mipmap minimum level clamp"]
    pub minMipmapLevelClamp: f32,
    #[doc = "< Mipmap maximum level clamp"]
    pub maxMipmapLevelClamp: f32,
    #[doc = "< Border Color"]
    pub borderColor: [f32; 4usize],
    pub reserved: [::std::os::raw::c_int; 12usize],
}
#[doc = " HIP texture descriptor"]
pub type HIP_TEXTURE_DESC = HIP_TEXTURE_DESC_st;
#[doc = "< No resource view format (use underlying resource format)"]
pub const hipResourceViewFormat_hipResViewFormatNone: hipResourceViewFormat = 0;
#[doc = "< 1 channel, unsigned 8-bit integers"]
pub const hipResourceViewFormat_hipResViewFormatUnsignedChar1: hipResourceViewFormat = 1;
#[doc = "< 2 channels, unsigned 8-bit integers"]
pub const hipResourceViewFormat_hipResViewFormatUnsignedChar2: hipResourceViewFormat = 2;
#[doc = "< 4 channels, unsigned 8-bit integers"]
pub const hipResourceViewFormat_hipResViewFormatUnsignedChar4: hipResourceViewFormat = 3;
#[doc = "< 1 channel, signed 8-bit integers"]
pub const hipResourceViewFormat_hipResViewFormatSignedChar1: hipResourceViewFormat = 4;
#[doc = "< 2 channels, signed 8-bit integers"]
pub const hipResourceViewFormat_hipResViewFormatSignedChar2: hipResourceViewFormat = 5;
#[doc = "< 4 channels, signed 8-bit integers"]
pub const hipResourceViewFormat_hipResViewFormatSignedChar4: hipResourceViewFormat = 6;
#[doc = "< 1 channel, unsigned 16-bit integers"]
pub const hipResourceViewFormat_hipResViewFormatUnsignedShort1: hipResourceViewFormat = 7;
#[doc = "< 2 channels, unsigned 16-bit integers"]
pub const hipResourceViewFormat_hipResViewFormatUnsignedShort2: hipResourceViewFormat = 8;
#[doc = "< 4 channels, unsigned 16-bit integers"]
pub const hipResourceViewFormat_hipResViewFormatUnsignedShort4: hipResourceViewFormat = 9;
#[doc = "< 1 channel, signed 16-bit integers"]
pub const hipResourceViewFormat_hipResViewFormatSignedShort1: hipResourceViewFormat = 10;
#[doc = "< 2 channels, signed 16-bit integers"]
pub const hipResourceViewFormat_hipResViewFormatSignedShort2: hipResourceViewFormat = 11;
#[doc = "< 4 channels, signed 16-bit integers"]
pub const hipResourceViewFormat_hipResViewFormatSignedShort4: hipResourceViewFormat = 12;
#[doc = "< 1 channel, unsigned 32-bit integers"]
pub const hipResourceViewFormat_hipResViewFormatUnsignedInt1: hipResourceViewFormat = 13;
#[doc = "< 2 channels, unsigned 32-bit integers"]
pub const hipResourceViewFormat_hipResViewFormatUnsignedInt2: hipResourceViewFormat = 14;
#[doc = "< 4 channels, unsigned 32-bit integers"]
pub const hipResourceViewFormat_hipResViewFormatUnsignedInt4: hipResourceViewFormat = 15;
#[doc = "< 1 channel, signed 32-bit integers"]
pub const hipResourceViewFormat_hipResViewFormatSignedInt1: hipResourceViewFormat = 16;
#[doc = "< 2 channels, signed 32-bit integers"]
pub const hipResourceViewFormat_hipResViewFormatSignedInt2: hipResourceViewFormat = 17;
#[doc = "< 4 channels, signed 32-bit integers"]
pub const hipResourceViewFormat_hipResViewFormatSignedInt4: hipResourceViewFormat = 18;
#[doc = "< 1 channel, 16-bit floating point"]
pub const hipResourceViewFormat_hipResViewFormatHalf1: hipResourceViewFormat = 19;
#[doc = "< 2 channels, 16-bit floating point"]
pub const hipResourceViewFormat_hipResViewFormatHalf2: hipResourceViewFormat = 20;
#[doc = "< 4 channels, 16-bit floating point"]
pub const hipResourceViewFormat_hipResViewFormatHalf4: hipResourceViewFormat = 21;
#[doc = "< 1 channel, 32-bit floating point"]
pub const hipResourceViewFormat_hipResViewFormatFloat1: hipResourceViewFormat = 22;
#[doc = "< 2 channels, 32-bit floating point"]
pub const hipResourceViewFormat_hipResViewFormatFloat2: hipResourceViewFormat = 23;
#[doc = "< 4 channels, 32-bit floating point"]
pub const hipResourceViewFormat_hipResViewFormatFloat4: hipResourceViewFormat = 24;
#[doc = "< Block-compressed 1"]
pub const hipResourceViewFormat_hipResViewFormatUnsignedBlockCompressed1: hipResourceViewFormat =
    25;
#[doc = "< Block-compressed 2"]
pub const hipResourceViewFormat_hipResViewFormatUnsignedBlockCompressed2: hipResourceViewFormat =
    26;
#[doc = "< Block-compressed 3"]
pub const hipResourceViewFormat_hipResViewFormatUnsignedBlockCompressed3: hipResourceViewFormat =
    27;
#[doc = "< Block-compressed 4 unsigned"]
pub const hipResourceViewFormat_hipResViewFormatUnsignedBlockCompressed4: hipResourceViewFormat =
    28;
#[doc = "< Block-compressed 4 signed"]
pub const hipResourceViewFormat_hipResViewFormatSignedBlockCompressed4: hipResourceViewFormat = 29;
#[doc = "< Block-compressed 5 unsigned"]
pub const hipResourceViewFormat_hipResViewFormatUnsignedBlockCompressed5: hipResourceViewFormat =
    30;
#[doc = "< Block-compressed 5 signed"]
pub const hipResourceViewFormat_hipResViewFormatSignedBlockCompressed5: hipResourceViewFormat = 31;
#[doc = "< Block-compressed 6 unsigned half-float"]
pub const hipResourceViewFormat_hipResViewFormatUnsignedBlockCompressed6H: hipResourceViewFormat =
    32;
#[doc = "< Block-compressed 6 signed half-float"]
pub const hipResourceViewFormat_hipResViewFormatSignedBlockCompressed6H: hipResourceViewFormat = 33;
#[doc = "< Block-compressed 7"]
pub const hipResourceViewFormat_hipResViewFormatUnsignedBlockCompressed7: hipResourceViewFormat =
    34;
#[doc = " HIP texture resource view formats"]
pub type hipResourceViewFormat = ::std::os::raw::c_uint;
#[doc = "< No resource view format (use underlying resource format)"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_NONE: HIPresourceViewFormat_enum = 0;
#[doc = "< 1 channel, unsigned 8-bit integers"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_UINT_1X8: HIPresourceViewFormat_enum = 1;
#[doc = "< 2 channels, unsigned 8-bit integers"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_UINT_2X8: HIPresourceViewFormat_enum = 2;
#[doc = "< 4 channels, unsigned 8-bit integers"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_UINT_4X8: HIPresourceViewFormat_enum = 3;
#[doc = "< 1 channel, signed 8-bit integers"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_SINT_1X8: HIPresourceViewFormat_enum = 4;
#[doc = "< 2 channels, signed 8-bit integers"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_SINT_2X8: HIPresourceViewFormat_enum = 5;
#[doc = "< 4 channels, signed 8-bit integers"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_SINT_4X8: HIPresourceViewFormat_enum = 6;
#[doc = "< 1 channel, unsigned 16-bit integers"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_UINT_1X16: HIPresourceViewFormat_enum = 7;
#[doc = "< 2 channels, unsigned 16-bit integers"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_UINT_2X16: HIPresourceViewFormat_enum = 8;
#[doc = "< 4 channels, unsigned 16-bit integers"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_UINT_4X16: HIPresourceViewFormat_enum = 9;
#[doc = "< 1 channel, signed 16-bit integers"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_SINT_1X16: HIPresourceViewFormat_enum = 10;
#[doc = "< 2 channels, signed 16-bit integers"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_SINT_2X16: HIPresourceViewFormat_enum = 11;
#[doc = "< 4 channels, signed 16-bit integers"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_SINT_4X16: HIPresourceViewFormat_enum = 12;
#[doc = "< 1 channel, unsigned 32-bit integers"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_UINT_1X32: HIPresourceViewFormat_enum = 13;
#[doc = "< 2 channels, unsigned 32-bit integers"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_UINT_2X32: HIPresourceViewFormat_enum = 14;
#[doc = "< 4 channels, unsigned 32-bit integers"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_UINT_4X32: HIPresourceViewFormat_enum = 15;
#[doc = "< 1 channel, signed 32-bit integers"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_SINT_1X32: HIPresourceViewFormat_enum = 16;
#[doc = "< 2 channels, signed 32-bit integers"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_SINT_2X32: HIPresourceViewFormat_enum = 17;
#[doc = "< 4 channels, signed 32-bit integers"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_SINT_4X32: HIPresourceViewFormat_enum = 18;
#[doc = "< 1 channel, 16-bit floating point"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_FLOAT_1X16: HIPresourceViewFormat_enum =
    19;
#[doc = "< 2 channels, 16-bit floating point"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_FLOAT_2X16: HIPresourceViewFormat_enum =
    20;
#[doc = "< 4 channels, 16-bit floating point"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_FLOAT_4X16: HIPresourceViewFormat_enum =
    21;
#[doc = "< 1 channel, 32-bit floating point"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_FLOAT_1X32: HIPresourceViewFormat_enum =
    22;
#[doc = "< 2 channels, 32-bit floating point"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_FLOAT_2X32: HIPresourceViewFormat_enum =
    23;
#[doc = "< 4 channels, 32-bit floating point"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_FLOAT_4X32: HIPresourceViewFormat_enum =
    24;
#[doc = "< Block-compressed 1"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_UNSIGNED_BC1: HIPresourceViewFormat_enum =
    25;
#[doc = "< Block-compressed 2"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_UNSIGNED_BC2: HIPresourceViewFormat_enum =
    26;
#[doc = "< Block-compressed 3"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_UNSIGNED_BC3: HIPresourceViewFormat_enum =
    27;
#[doc = "< Block-compressed 4 unsigned"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_UNSIGNED_BC4: HIPresourceViewFormat_enum =
    28;
#[doc = "< Block-compressed 4 signed"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_SIGNED_BC4: HIPresourceViewFormat_enum =
    29;
#[doc = "< Block-compressed 5 unsigned"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_UNSIGNED_BC5: HIPresourceViewFormat_enum =
    30;
#[doc = "< Block-compressed 5 signed"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_SIGNED_BC5: HIPresourceViewFormat_enum =
    31;
#[doc = "< Block-compressed 6 unsigned half-float"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_UNSIGNED_BC6H: HIPresourceViewFormat_enum =
    32;
#[doc = "< Block-compressed 6 signed half-float"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_SIGNED_BC6H: HIPresourceViewFormat_enum =
    33;
#[doc = "< Block-compressed 7"]
pub const HIPresourceViewFormat_enum_HIP_RES_VIEW_FORMAT_UNSIGNED_BC7: HIPresourceViewFormat_enum =
    34;
#[doc = " HIP texture resource view formats"]
pub type HIPresourceViewFormat_enum = ::std::os::raw::c_uint;
#[doc = " HIP texture resource view formats"]
pub use self::HIPresourceViewFormat_enum as HIPresourceViewFormat;
#[doc = " HIP resource descriptor"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hipResourceDesc {
    #[doc = "< Resource type"]
    pub resType: hipResourceType,
    pub res: hipResourceDesc__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union hipResourceDesc__bindgen_ty_1 {
    pub array: hipResourceDesc__bindgen_ty_1__bindgen_ty_1,
    pub mipmap: hipResourceDesc__bindgen_ty_1__bindgen_ty_2,
    pub linear: hipResourceDesc__bindgen_ty_1__bindgen_ty_3,
    pub pitch2D: hipResourceDesc__bindgen_ty_1__bindgen_ty_4,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipResourceDesc__bindgen_ty_1__bindgen_ty_1 {
    #[doc = "< HIP array"]
    pub array: hipArray_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipResourceDesc__bindgen_ty_1__bindgen_ty_2 {
    #[doc = "< HIP mipmapped array"]
    pub mipmap: hipMipmappedArray_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipResourceDesc__bindgen_ty_1__bindgen_ty_3 {
    #[doc = "< Device pointer"]
    pub devPtr: *mut ::std::os::raw::c_void,
    #[doc = "< Channel format description"]
    pub desc: hipChannelFormatDesc,
    #[doc = "< Size in bytes"]
    pub sizeInBytes: usize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipResourceDesc__bindgen_ty_1__bindgen_ty_4 {
    #[doc = "< Device pointer"]
    pub devPtr: *mut ::std::os::raw::c_void,
    #[doc = "< Channel format description"]
    pub desc: hipChannelFormatDesc,
    #[doc = "< Width of the array in elements"]
    pub width: usize,
    #[doc = "< Height of the array in elements"]
    pub height: usize,
    #[doc = "< Pitch between two rows in bytes"]
    pub pitchInBytes: usize,
}
#[doc = " HIP resource view descriptor struct"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct HIP_RESOURCE_DESC_st {
    #[doc = "< Resource type"]
    pub resType: HIPresourcetype,
    pub res: HIP_RESOURCE_DESC_st__bindgen_ty_1,
    #[doc = "< Flags (must be zero)"]
    pub flags: ::std::os::raw::c_uint,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union HIP_RESOURCE_DESC_st__bindgen_ty_1 {
    pub array: HIP_RESOURCE_DESC_st__bindgen_ty_1__bindgen_ty_1,
    pub mipmap: HIP_RESOURCE_DESC_st__bindgen_ty_1__bindgen_ty_2,
    pub linear: HIP_RESOURCE_DESC_st__bindgen_ty_1__bindgen_ty_3,
    pub pitch2D: HIP_RESOURCE_DESC_st__bindgen_ty_1__bindgen_ty_4,
    pub reserved: HIP_RESOURCE_DESC_st__bindgen_ty_1__bindgen_ty_5,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HIP_RESOURCE_DESC_st__bindgen_ty_1__bindgen_ty_1 {
    #[doc = "< HIP array"]
    pub hArray: hipArray_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HIP_RESOURCE_DESC_st__bindgen_ty_1__bindgen_ty_2 {
    #[doc = "< HIP mipmapped array"]
    pub hMipmappedArray: hipMipmappedArray_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HIP_RESOURCE_DESC_st__bindgen_ty_1__bindgen_ty_3 {
    #[doc = "< Device pointer"]
    pub devPtr: hipDeviceptr_t,
    #[doc = "< Array format"]
    pub format: hipArray_Format,
    #[doc = "< Channels per array element"]
    pub numChannels: ::std::os::raw::c_uint,
    #[doc = "< Size in bytes"]
    pub sizeInBytes: usize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HIP_RESOURCE_DESC_st__bindgen_ty_1__bindgen_ty_4 {
    #[doc = "< Device pointer"]
    pub devPtr: hipDeviceptr_t,
    #[doc = "< Array format"]
    pub format: hipArray_Format,
    #[doc = "< Channels per array element"]
    pub numChannels: ::std::os::raw::c_uint,
    #[doc = "< Width of the array in elements"]
    pub width: usize,
    #[doc = "< Height of the array in elements"]
    pub height: usize,
    #[doc = "< Pitch between two rows in bytes"]
    pub pitchInBytes: usize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HIP_RESOURCE_DESC_st__bindgen_ty_1__bindgen_ty_5 {
    pub reserved: [::std::os::raw::c_int; 32usize],
}
#[doc = " HIP resource view descriptor struct"]
pub type HIP_RESOURCE_DESC = HIP_RESOURCE_DESC_st;
#[doc = " HIP resource view descriptor"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipResourceViewDesc {
    #[doc = "< Resource view format"]
    pub format: hipResourceViewFormat,
    #[doc = "< Width of the resource view"]
    pub width: usize,
    #[doc = "< Height of the resource view"]
    pub height: usize,
    #[doc = "< Depth of the resource view"]
    pub depth: usize,
    #[doc = "< First defined mipmap level"]
    pub firstMipmapLevel: ::std::os::raw::c_uint,
    #[doc = "< Last defined mipmap level"]
    pub lastMipmapLevel: ::std::os::raw::c_uint,
    #[doc = "< First layer index"]
    pub firstLayer: ::std::os::raw::c_uint,
    #[doc = "< Last layer index"]
    pub lastLayer: ::std::os::raw::c_uint,
}
#[doc = " Resource view descriptor"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HIP_RESOURCE_VIEW_DESC_st {
    #[doc = "< Resource view format"]
    pub format: HIPresourceViewFormat,
    #[doc = "< Width of the resource view"]
    pub width: usize,
    #[doc = "< Height of the resource view"]
    pub height: usize,
    #[doc = "< Depth of the resource view"]
    pub depth: usize,
    #[doc = "< First defined mipmap level"]
    pub firstMipmapLevel: ::std::os::raw::c_uint,
    #[doc = "< Last defined mipmap level"]
    pub lastMipmapLevel: ::std::os::raw::c_uint,
    #[doc = "< First layer index"]
    pub firstLayer: ::std::os::raw::c_uint,
    #[doc = "< Last layer index"]
    pub lastLayer: ::std::os::raw::c_uint,
    pub reserved: [::std::os::raw::c_uint; 16usize],
}
#[doc = " Resource view descriptor"]
pub type HIP_RESOURCE_VIEW_DESC = HIP_RESOURCE_VIEW_DESC_st;
#[doc = "< Host-to-Host Copy"]
pub const hipMemcpyKind_hipMemcpyHostToHost: hipMemcpyKind = 0;
#[doc = "< Host-to-Device Copy"]
pub const hipMemcpyKind_hipMemcpyHostToDevice: hipMemcpyKind = 1;
#[doc = "< Device-to-Host Copy"]
pub const hipMemcpyKind_hipMemcpyDeviceToHost: hipMemcpyKind = 2;
#[doc = "< Device-to-Device Copy"]
pub const hipMemcpyKind_hipMemcpyDeviceToDevice: hipMemcpyKind = 3;
#[doc = "< Runtime will automatically determine\n<copy-kind based on virtual addresses."]
pub const hipMemcpyKind_hipMemcpyDefault: hipMemcpyKind = 4;
#[doc = "< Device-to-Device Copy without using compute units"]
pub const hipMemcpyKind_hipMemcpyDeviceToDeviceNoCU: hipMemcpyKind = 1024;
pub type hipMemcpyKind = ::std::os::raw::c_uint;
#[doc = " HIP pithed pointer"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipPitchedPtr {
    #[doc = "< Pointer to the allocated memory"]
    pub ptr: *mut ::std::os::raw::c_void,
    #[doc = "< Pitch in bytes"]
    pub pitch: usize,
    #[doc = "< Logical size of the first dimension of allocation in elements"]
    pub xsize: usize,
    #[doc = "< Logical size of the second dimension of allocation in elements"]
    pub ysize: usize,
}
#[doc = " HIP extent"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipExtent {
    pub width: usize,
    pub height: usize,
    pub depth: usize,
}
#[doc = "  HIP position"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipPos {
    #[doc = "< X coordinate"]
    pub x: usize,
    #[doc = "< Y coordinate"]
    pub y: usize,
    #[doc = "< Z coordinate"]
    pub z: usize,
}
#[doc = " HIP 3D memory copy parameters"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipMemcpy3DParms {
    #[doc = "< Source array"]
    pub srcArray: hipArray_t,
    #[doc = "< Source position"]
    pub srcPos: hipPos,
    #[doc = "< Source pointer"]
    pub srcPtr: hipPitchedPtr,
    #[doc = "< Destination array"]
    pub dstArray: hipArray_t,
    #[doc = "< Destination position"]
    pub dstPos: hipPos,
    #[doc = "< Destination pointer"]
    pub dstPtr: hipPitchedPtr,
    #[doc = "< Extent of 3D memory copy"]
    pub extent: hipExtent,
    #[doc = "< Kind of 3D memory copy"]
    pub kind: hipMemcpyKind,
}
#[doc = " HIP 3D memory copy"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HIP_MEMCPY3D {
    #[doc = "< Source X in bytes"]
    pub srcXInBytes: usize,
    #[doc = "< Source Y"]
    pub srcY: usize,
    #[doc = "< Source Z"]
    pub srcZ: usize,
    #[doc = "< Source LOD"]
    pub srcLOD: usize,
    #[doc = "< Source memory type"]
    pub srcMemoryType: hipMemoryType,
    #[doc = "< Source host pointer"]
    pub srcHost: *const ::std::os::raw::c_void,
    #[doc = "< Source device"]
    pub srcDevice: hipDeviceptr_t,
    #[doc = "< Source array"]
    pub srcArray: hipArray_t,
    #[doc = "< Source pitch"]
    pub srcPitch: usize,
    #[doc = "< Source height"]
    pub srcHeight: usize,
    #[doc = "< Destination X in bytes"]
    pub dstXInBytes: usize,
    #[doc = "< Destination Y"]
    pub dstY: usize,
    #[doc = "< Destination Z"]
    pub dstZ: usize,
    #[doc = "< Destination LOD"]
    pub dstLOD: usize,
    #[doc = "< Destination memory type"]
    pub dstMemoryType: hipMemoryType,
    #[doc = "< Destination host pointer"]
    pub dstHost: *mut ::std::os::raw::c_void,
    #[doc = "< Destination device"]
    pub dstDevice: hipDeviceptr_t,
    #[doc = "< Destination array"]
    pub dstArray: hipArray_t,
    #[doc = "< Destination pitch"]
    pub dstPitch: usize,
    #[doc = "< Destination height"]
    pub dstHeight: usize,
    #[doc = "< Width in bytes of 3D memory copy"]
    pub WidthInBytes: usize,
    #[doc = "< Height in bytes of 3D memory copy"]
    pub Height: usize,
    #[doc = "< Depth in bytes of 3D memory copy"]
    pub Depth: usize,
}
#[doc = "< The maximum number of threads per block. Depends on function and device."]
pub const hipFunction_attribute_HIP_FUNC_ATTRIBUTE_MAX_THREADS_PER_BLOCK: hipFunction_attribute = 0;
#[doc = "< The statically allocated shared memory size in bytes per block required by the function."]
pub const hipFunction_attribute_HIP_FUNC_ATTRIBUTE_SHARED_SIZE_BYTES: hipFunction_attribute = 1;
#[doc = "< The user-allocated constant memory by the function in bytes."]
pub const hipFunction_attribute_HIP_FUNC_ATTRIBUTE_CONST_SIZE_BYTES: hipFunction_attribute = 2;
#[doc = "< The local memory usage of each thread by this function in bytes."]
pub const hipFunction_attribute_HIP_FUNC_ATTRIBUTE_LOCAL_SIZE_BYTES: hipFunction_attribute = 3;
#[doc = "< The number of registers used by each thread of this function."]
pub const hipFunction_attribute_HIP_FUNC_ATTRIBUTE_NUM_REGS: hipFunction_attribute = 4;
#[doc = "< PTX version"]
pub const hipFunction_attribute_HIP_FUNC_ATTRIBUTE_PTX_VERSION: hipFunction_attribute = 5;
#[doc = "< Binary version"]
pub const hipFunction_attribute_HIP_FUNC_ATTRIBUTE_BINARY_VERSION: hipFunction_attribute = 6;
#[doc = "< Cache mode"]
pub const hipFunction_attribute_HIP_FUNC_ATTRIBUTE_CACHE_MODE_CA: hipFunction_attribute = 7;
#[doc = "< The maximum dynamic shared memory per block for this function in bytes."]
pub const hipFunction_attribute_HIP_FUNC_ATTRIBUTE_MAX_DYNAMIC_SHARED_SIZE_BYTES:
    hipFunction_attribute = 8;
#[doc = "< The shared memory carveout preference in percent of the maximum shared memory."]
pub const hipFunction_attribute_HIP_FUNC_ATTRIBUTE_PREFERRED_SHARED_MEMORY_CARVEOUT:
    hipFunction_attribute = 9;
pub const hipFunction_attribute_HIP_FUNC_ATTRIBUTE_MAX: hipFunction_attribute = 10;
pub type hipFunction_attribute = ::std::os::raw::c_uint;
#[doc = "< The context on which a pointer was allocated\n< @warning This attribute is not supported in HIP"]
pub const hipPointer_attribute_HIP_POINTER_ATTRIBUTE_CONTEXT: hipPointer_attribute = 1;
#[doc = "< memory type describing the location of a pointer"]
pub const hipPointer_attribute_HIP_POINTER_ATTRIBUTE_MEMORY_TYPE: hipPointer_attribute = 2;
#[doc = "< address at which the pointer is allocated on the device"]
pub const hipPointer_attribute_HIP_POINTER_ATTRIBUTE_DEVICE_POINTER: hipPointer_attribute = 3;
#[doc = "< address at which the pointer is allocated on the host"]
pub const hipPointer_attribute_HIP_POINTER_ATTRIBUTE_HOST_POINTER: hipPointer_attribute = 4;
#[doc = "< A pair of tokens for use with Linux kernel interface\n< @warning This attribute is not supported in HIP"]
pub const hipPointer_attribute_HIP_POINTER_ATTRIBUTE_P2P_TOKENS: hipPointer_attribute = 5;
#[doc = "< Synchronize every synchronous memory operation\n< initiated on this region"]
pub const hipPointer_attribute_HIP_POINTER_ATTRIBUTE_SYNC_MEMOPS: hipPointer_attribute = 6;
#[doc = "< Unique ID for an allocated memory region"]
pub const hipPointer_attribute_HIP_POINTER_ATTRIBUTE_BUFFER_ID: hipPointer_attribute = 7;
#[doc = "< Indicates if the pointer points to managed memory"]
pub const hipPointer_attribute_HIP_POINTER_ATTRIBUTE_IS_MANAGED: hipPointer_attribute = 8;
#[doc = "< device ordinal of a device on which a pointer\n< was allocated or registered"]
pub const hipPointer_attribute_HIP_POINTER_ATTRIBUTE_DEVICE_ORDINAL: hipPointer_attribute = 9;
#[doc = "< if this pointer maps to an allocation\n< that is suitable for hipIpcGetMemHandle\n< @warning This attribute is not supported in HIP"]
pub const hipPointer_attribute_HIP_POINTER_ATTRIBUTE_IS_LEGACY_HIP_IPC_CAPABLE:
    hipPointer_attribute = 10;
#[doc = "< Starting address for this requested pointer"]
pub const hipPointer_attribute_HIP_POINTER_ATTRIBUTE_RANGE_START_ADDR: hipPointer_attribute = 11;
#[doc = "< Size of the address range for this requested pointer"]
pub const hipPointer_attribute_HIP_POINTER_ATTRIBUTE_RANGE_SIZE: hipPointer_attribute = 12;
#[doc = "< tells if this pointer is in a valid address range\n< that is mapped to a backing allocation"]
pub const hipPointer_attribute_HIP_POINTER_ATTRIBUTE_MAPPED: hipPointer_attribute = 13;
#[doc = "< Bitmask of allowed hipmemAllocationHandleType\n< for this allocation @warning This attribute is not supported in HIP"]
pub const hipPointer_attribute_HIP_POINTER_ATTRIBUTE_ALLOWED_HANDLE_TYPES: hipPointer_attribute =
    14;
#[doc = "< returns if the memory referenced by\n< this pointer can be used with the GPUDirect RDMA API\n< @warning This attribute is not supported in HIP"]
pub const hipPointer_attribute_HIP_POINTER_ATTRIBUTE_IS_GPU_DIRECT_RDMA_CAPABLE:
    hipPointer_attribute = 15;
#[doc = "< Returns the access flags the device associated with\n< for the corresponding memory referenced by the ptr"]
pub const hipPointer_attribute_HIP_POINTER_ATTRIBUTE_ACCESS_FLAGS: hipPointer_attribute = 16;
#[doc = "< Returns the mempool handle for the allocation if\n< it was allocated from a mempool\n< @warning This attribute is not supported in HIP"]
pub const hipPointer_attribute_HIP_POINTER_ATTRIBUTE_MEMPOOL_HANDLE: hipPointer_attribute = 17;
pub type hipPointer_attribute = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct uchar1 {
    pub x: ::std::os::raw::c_uchar,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct uchar2 {
    pub x: ::std::os::raw::c_uchar,
    pub y: ::std::os::raw::c_uchar,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct uchar3 {
    pub x: ::std::os::raw::c_uchar,
    pub y: ::std::os::raw::c_uchar,
    pub z: ::std::os::raw::c_uchar,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct uchar4 {
    pub x: ::std::os::raw::c_uchar,
    pub y: ::std::os::raw::c_uchar,
    pub z: ::std::os::raw::c_uchar,
    pub w: ::std::os::raw::c_uchar,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct char1 {
    pub x: ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct char2 {
    pub x: ::std::os::raw::c_char,
    pub y: ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct char3 {
    pub x: ::std::os::raw::c_char,
    pub y: ::std::os::raw::c_char,
    pub z: ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct char4 {
    pub x: ::std::os::raw::c_char,
    pub y: ::std::os::raw::c_char,
    pub z: ::std::os::raw::c_char,
    pub w: ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ushort1 {
    pub x: ::std::os::raw::c_ushort,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ushort2 {
    pub x: ::std::os::raw::c_ushort,
    pub y: ::std::os::raw::c_ushort,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ushort3 {
    pub x: ::std::os::raw::c_ushort,
    pub y: ::std::os::raw::c_ushort,
    pub z: ::std::os::raw::c_ushort,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ushort4 {
    pub x: ::std::os::raw::c_ushort,
    pub y: ::std::os::raw::c_ushort,
    pub z: ::std::os::raw::c_ushort,
    pub w: ::std::os::raw::c_ushort,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct short1 {
    pub x: ::std::os::raw::c_short,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct short2 {
    pub x: ::std::os::raw::c_short,
    pub y: ::std::os::raw::c_short,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct short3 {
    pub x: ::std::os::raw::c_short,
    pub y: ::std::os::raw::c_short,
    pub z: ::std::os::raw::c_short,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct short4 {
    pub x: ::std::os::raw::c_short,
    pub y: ::std::os::raw::c_short,
    pub z: ::std::os::raw::c_short,
    pub w: ::std::os::raw::c_short,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct uint1 {
    pub x: ::std::os::raw::c_uint,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct uint2 {
    pub x: ::std::os::raw::c_uint,
    pub y: ::std::os::raw::c_uint,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct uint3 {
    pub x: ::std::os::raw::c_uint,
    pub y: ::std::os::raw::c_uint,
    pub z: ::std::os::raw::c_uint,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct uint4 {
    pub x: ::std::os::raw::c_uint,
    pub y: ::std::os::raw::c_uint,
    pub z: ::std::os::raw::c_uint,
    pub w: ::std::os::raw::c_uint,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct int1 {
    pub x: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct int2 {
    pub x: ::std::os::raw::c_int,
    pub y: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct int3 {
    pub x: ::std::os::raw::c_int,
    pub y: ::std::os::raw::c_int,
    pub z: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct int4 {
    pub x: ::std::os::raw::c_int,
    pub y: ::std::os::raw::c_int,
    pub z: ::std::os::raw::c_int,
    pub w: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ulong1 {
    pub x: ::std::os::raw::c_ulong,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ulong2 {
    pub x: ::std::os::raw::c_ulong,
    pub y: ::std::os::raw::c_ulong,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ulong3 {
    pub x: ::std::os::raw::c_ulong,
    pub y: ::std::os::raw::c_ulong,
    pub z: ::std::os::raw::c_ulong,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ulong4 {
    pub x: ::std::os::raw::c_ulong,
    pub y: ::std::os::raw::c_ulong,
    pub z: ::std::os::raw::c_ulong,
    pub w: ::std::os::raw::c_ulong,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct long1 {
    pub x: ::std::os::raw::c_long,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct long2 {
    pub x: ::std::os::raw::c_long,
    pub y: ::std::os::raw::c_long,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct long3 {
    pub x: ::std::os::raw::c_long,
    pub y: ::std::os::raw::c_long,
    pub z: ::std::os::raw::c_long,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct long4 {
    pub x: ::std::os::raw::c_long,
    pub y: ::std::os::raw::c_long,
    pub z: ::std::os::raw::c_long,
    pub w: ::std::os::raw::c_long,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ulonglong1 {
    pub x: ::std::os::raw::c_ulonglong,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ulonglong2 {
    pub x: ::std::os::raw::c_ulonglong,
    pub y: ::std::os::raw::c_ulonglong,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ulonglong3 {
    pub x: ::std::os::raw::c_ulonglong,
    pub y: ::std::os::raw::c_ulonglong,
    pub z: ::std::os::raw::c_ulonglong,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ulonglong4 {
    pub x: ::std::os::raw::c_ulonglong,
    pub y: ::std::os::raw::c_ulonglong,
    pub z: ::std::os::raw::c_ulonglong,
    pub w: ::std::os::raw::c_ulonglong,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct longlong1 {
    pub x: ::std::os::raw::c_longlong,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct longlong2 {
    pub x: ::std::os::raw::c_longlong,
    pub y: ::std::os::raw::c_longlong,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct longlong3 {
    pub x: ::std::os::raw::c_longlong,
    pub y: ::std::os::raw::c_longlong,
    pub z: ::std::os::raw::c_longlong,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct longlong4 {
    pub x: ::std::os::raw::c_longlong,
    pub y: ::std::os::raw::c_longlong,
    pub z: ::std::os::raw::c_longlong,
    pub w: ::std::os::raw::c_longlong,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct float1 {
    pub x: f32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct float2 {
    pub x: f32,
    pub y: f32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct float3 {
    pub x: f32,
    pub y: f32,
    pub z: f32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct float4 {
    pub x: f32,
    pub y: f32,
    pub z: f32,
    pub w: f32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct double1 {
    pub x: f64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct double2 {
    pub x: f64,
    pub y: f64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct double3 {
    pub x: f64,
    pub y: f64,
    pub z: f64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct double4 {
    pub x: f64,
    pub y: f64,
    pub z: f64,
    pub w: f64,
}
extern "C" {
    pub fn hipCreateChannelDesc(
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
        z: ::std::os::raw::c_int,
        w: ::std::os::raw::c_int,
        f: hipChannelFormatKind,
    ) -> hipChannelFormatDesc;
}
#[doc = " An opaque value that represents a hip texture object"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __hip_texture {
    _unused: [u8; 0],
}
pub type hipTextureObject_t = *mut __hip_texture;
pub const hipTextureAddressMode_hipAddressModeWrap: hipTextureAddressMode = 0;
pub const hipTextureAddressMode_hipAddressModeClamp: hipTextureAddressMode = 1;
pub const hipTextureAddressMode_hipAddressModeMirror: hipTextureAddressMode = 2;
pub const hipTextureAddressMode_hipAddressModeBorder: hipTextureAddressMode = 3;
#[doc = " hip texture address modes"]
pub type hipTextureAddressMode = ::std::os::raw::c_uint;
pub const hipTextureFilterMode_hipFilterModePoint: hipTextureFilterMode = 0;
pub const hipTextureFilterMode_hipFilterModeLinear: hipTextureFilterMode = 1;
#[doc = " hip texture filter modes"]
pub type hipTextureFilterMode = ::std::os::raw::c_uint;
pub const hipTextureReadMode_hipReadModeElementType: hipTextureReadMode = 0;
pub const hipTextureReadMode_hipReadModeNormalizedFloat: hipTextureReadMode = 1;
#[doc = " hip texture read modes"]
pub type hipTextureReadMode = ::std::os::raw::c_uint;
#[doc = " hip texture reference"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct textureReference {
    pub normalized: ::std::os::raw::c_int,
    pub readMode: hipTextureReadMode,
    pub filterMode: hipTextureFilterMode,
    pub addressMode: [hipTextureAddressMode; 3usize],
    pub channelDesc: hipChannelFormatDesc,
    pub sRGB: ::std::os::raw::c_int,
    pub maxAnisotropy: ::std::os::raw::c_uint,
    pub mipmapFilterMode: hipTextureFilterMode,
    pub mipmapLevelBias: f32,
    pub minMipmapLevelClamp: f32,
    pub maxMipmapLevelClamp: f32,
    pub textureObject: hipTextureObject_t,
    pub numChannels: ::std::os::raw::c_int,
    pub format: hipArray_Format,
}
#[doc = " hip texture descriptor"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipTextureDesc {
    pub addressMode: [hipTextureAddressMode; 3usize],
    pub filterMode: hipTextureFilterMode,
    pub readMode: hipTextureReadMode,
    pub sRGB: ::std::os::raw::c_int,
    pub borderColor: [f32; 4usize],
    pub normalizedCoords: ::std::os::raw::c_int,
    pub maxAnisotropy: ::std::os::raw::c_uint,
    pub mipmapFilterMode: hipTextureFilterMode,
    pub mipmapLevelBias: f32,
    pub minMipmapLevelClamp: f32,
    pub maxMipmapLevelClamp: f32,
}
#[doc = " An opaque value that represents a hip surface object"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __hip_surface {
    _unused: [u8; 0],
}
pub type hipSurfaceObject_t = *mut __hip_surface;
#[doc = " hip surface reference"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct surfaceReference {
    pub surfaceObject: hipSurfaceObject_t,
}
pub const hipSurfaceBoundaryMode_hipBoundaryModeZero: hipSurfaceBoundaryMode = 0;
pub const hipSurfaceBoundaryMode_hipBoundaryModeTrap: hipSurfaceBoundaryMode = 1;
pub const hipSurfaceBoundaryMode_hipBoundaryModeClamp: hipSurfaceBoundaryMode = 2;
#[doc = " hip surface boundary modes"]
pub type hipSurfaceBoundaryMode = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ihipCtx_t {
    _unused: [u8; 0],
}
pub type hipCtx_t = *mut ihipCtx_t;
pub type hipDevice_t = ::std::os::raw::c_int;
pub const hipDeviceP2PAttr_hipDevP2PAttrPerformanceRank: hipDeviceP2PAttr = 0;
pub const hipDeviceP2PAttr_hipDevP2PAttrAccessSupported: hipDeviceP2PAttr = 1;
pub const hipDeviceP2PAttr_hipDevP2PAttrNativeAtomicSupported: hipDeviceP2PAttr = 2;
pub const hipDeviceP2PAttr_hipDevP2PAttrHipArrayAccessSupported: hipDeviceP2PAttr = 3;
pub type hipDeviceP2PAttr = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ihipStream_t {
    _unused: [u8; 0],
}
pub type hipStream_t = *mut ihipStream_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipIpcMemHandle_st {
    pub reserved: [::std::os::raw::c_char; 64usize],
}
pub type hipIpcMemHandle_t = hipIpcMemHandle_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipIpcEventHandle_st {
    pub reserved: [::std::os::raw::c_char; 64usize],
}
pub type hipIpcEventHandle_t = hipIpcEventHandle_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ihipModule_t {
    _unused: [u8; 0],
}
pub type hipModule_t = *mut ihipModule_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ihipModuleSymbol_t {
    _unused: [u8; 0],
}
pub type hipFunction_t = *mut ihipModuleSymbol_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ihipLinkState_t {
    _unused: [u8; 0],
}
pub type hipLinkState_t = *mut ihipLinkState_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ihipMemPoolHandle_t {
    _unused: [u8; 0],
}
#[doc = " HIP memory pool"]
pub type hipMemPool_t = *mut ihipMemPoolHandle_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipFuncAttributes {
    pub binaryVersion: ::std::os::raw::c_int,
    pub cacheModeCA: ::std::os::raw::c_int,
    pub constSizeBytes: usize,
    pub localSizeBytes: usize,
    pub maxDynamicSharedSizeBytes: ::std::os::raw::c_int,
    pub maxThreadsPerBlock: ::std::os::raw::c_int,
    pub numRegs: ::std::os::raw::c_int,
    pub preferredShmemCarveout: ::std::os::raw::c_int,
    pub ptxVersion: ::std::os::raw::c_int,
    pub sharedSizeBytes: usize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ihipEvent_t {
    _unused: [u8; 0],
}
pub type hipEvent_t = *mut ihipEvent_t;
#[doc = "< Limit of stack size in bytes on the current device, per\n< thread. The size is in units of 256 dwords, up to the\n< limit of (128K - 16)"]
pub const hipLimit_t_hipLimitStackSize: hipLimit_t = 0;
#[doc = "< Size limit in bytes of fifo used by printf call on the\n< device. Currently not supported"]
pub const hipLimit_t_hipLimitPrintfFifoSize: hipLimit_t = 1;
#[doc = "< Limit of heap size in bytes on the current device, should\n< be less than the global memory size on the device"]
pub const hipLimit_t_hipLimitMallocHeapSize: hipLimit_t = 2;
#[doc = "< Supported limit range"]
pub const hipLimit_t_hipLimitRange: hipLimit_t = 3;
#[doc = " hipLimit\n\n @note In HIP device limit-related APIs, any input limit value other than those defined in the\n enum is treated as \"UnsupportedLimit\" by default."]
pub type hipLimit_t = ::std::os::raw::c_uint;
pub const hipStreamBatchMemOpType_hipStreamMemOpWaitValue32: hipStreamBatchMemOpType = 1;
pub const hipStreamBatchMemOpType_hipStreamMemOpWriteValue32: hipStreamBatchMemOpType = 2;
pub const hipStreamBatchMemOpType_hipStreamMemOpWaitValue64: hipStreamBatchMemOpType = 4;
pub const hipStreamBatchMemOpType_hipStreamMemOpWriteValue64: hipStreamBatchMemOpType = 5;
#[doc = "< Currently not supported"]
pub const hipStreamBatchMemOpType_hipStreamMemOpBarrier: hipStreamBatchMemOpType = 6;
#[doc = "< Currently not supported"]
pub const hipStreamBatchMemOpType_hipStreamMemOpFlushRemoteWrites: hipStreamBatchMemOpType = 3;
#[doc = " Operations for hipStreamBatchMemOp"]
pub type hipStreamBatchMemOpType = ::std::os::raw::c_uint;
#[doc = " @brief Union representing batch memory operation parameters for HIP streams.\n\n hipStreamBatchMemOpParams is used to specify the parameters for batch memory\n operations in a HIP stream. This union supports various operations including\n waiting for a specific value, writing a value, and different flags for wait conditions.\n\n @details\n The union includes fields for different types of operations defined in the\n enum hipStreamBatchMemOpType:\n - hipStreamMemOpWaitValue32:  Wait for a 32-bit value.\n - hipStreamMemOpWriteValue32: Write a 32-bit value.\n - hipStreamMemOpWaitValue64:  Wait for a 64-bit value.\n - hipStreamMemOpWriteValue64: Write a 64-bit value.\n\n Each operation type includes an address, the value to wait for or write, flags, and an\n optional alias that is not relevant on AMD GPUs. Flags can be used to specify different\n wait conditions such as equality, bitwise AND, greater than or equal, and bitwise NOR.\n\n Example usage:\n @code\n hipStreamBatchMemOpParams myArray[2];\n myArray[0].operation = hipStreamMemOpWaitValue32;\n myArray[0].waitValue.address = waitAddr1;\n myArray[0].waitValue.value = 0x1;\n myArray[0].waitValue.flags = CU_STREAM_WAIT_VALUE_EQ;\n\n myArray[1].operation = hipStreamMemOpWriteValue32;\n myArray[1].writeValue.address = writeAddr1;\n myArray[1].writeValue.value = 0x1;\n myArray[1].writeValue.flags = 0x0;\n\n result = hipStreamBatchMemOp(stream, 2, myArray, 0);\n @endcode"]
#[repr(C)]
#[derive(Copy, Clone)]
pub union hipStreamBatchMemOpParams_union {
    pub operation: hipStreamBatchMemOpType,
    pub waitValue: hipStreamBatchMemOpParams_union_hipStreamMemOpWaitValueParams_t,
    pub writeValue: hipStreamBatchMemOpParams_union_hipStreamMemOpWriteValueParams_t,
    #[doc = "< Currently not supported on AMD"]
    pub flushRemoteWrites: hipStreamBatchMemOpParams_union_hipStreamMemOpFlushRemoteWritesParams_t,
    #[doc = "< Currently not supported on AMD"]
    pub memoryBarrier: hipStreamBatchMemOpParams_union_hipStreamMemOpMemoryBarrierParams_t,
    pub pad: [u64; 6usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hipStreamBatchMemOpParams_union_hipStreamMemOpWaitValueParams_t {
    pub operation: hipStreamBatchMemOpType,
    pub address: hipDeviceptr_t,
    pub __bindgen_anon_1:
        hipStreamBatchMemOpParams_union_hipStreamMemOpWaitValueParams_t__bindgen_ty_1,
    pub flags: ::std::os::raw::c_uint,
    #[doc = "< Not valid for AMD backend. Initial value is unimportant"]
    pub alias: hipDeviceptr_t,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union hipStreamBatchMemOpParams_union_hipStreamMemOpWaitValueParams_t__bindgen_ty_1 {
    pub value: u32,
    pub value64: u64,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hipStreamBatchMemOpParams_union_hipStreamMemOpWriteValueParams_t {
    pub operation: hipStreamBatchMemOpType,
    pub address: hipDeviceptr_t,
    pub __bindgen_anon_1:
        hipStreamBatchMemOpParams_union_hipStreamMemOpWriteValueParams_t__bindgen_ty_1,
    pub flags: ::std::os::raw::c_uint,
    #[doc = "< Not valid for AMD backend. Initial value is unimportant"]
    pub alias: hipDeviceptr_t,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union hipStreamBatchMemOpParams_union_hipStreamMemOpWriteValueParams_t__bindgen_ty_1 {
    pub value: u32,
    pub value64: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipStreamBatchMemOpParams_union_hipStreamMemOpFlushRemoteWritesParams_t {
    pub operation: hipStreamBatchMemOpType,
    pub flags: ::std::os::raw::c_uint,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipStreamBatchMemOpParams_union_hipStreamMemOpMemoryBarrierParams_t {
    pub operation: hipStreamBatchMemOpType,
    pub flags: ::std::os::raw::c_uint,
}
#[doc = " @brief Union representing batch memory operation parameters for HIP streams.\n\n hipStreamBatchMemOpParams is used to specify the parameters for batch memory\n operations in a HIP stream. This union supports various operations including\n waiting for a specific value, writing a value, and different flags for wait conditions.\n\n @details\n The union includes fields for different types of operations defined in the\n enum hipStreamBatchMemOpType:\n - hipStreamMemOpWaitValue32:  Wait for a 32-bit value.\n - hipStreamMemOpWriteValue32: Write a 32-bit value.\n - hipStreamMemOpWaitValue64:  Wait for a 64-bit value.\n - hipStreamMemOpWriteValue64: Write a 64-bit value.\n\n Each operation type includes an address, the value to wait for or write, flags, and an\n optional alias that is not relevant on AMD GPUs. Flags can be used to specify different\n wait conditions such as equality, bitwise AND, greater than or equal, and bitwise NOR.\n\n Example usage:\n @code\n hipStreamBatchMemOpParams myArray[2];\n myArray[0].operation = hipStreamMemOpWaitValue32;\n myArray[0].waitValue.address = waitAddr1;\n myArray[0].waitValue.value = 0x1;\n myArray[0].waitValue.flags = CU_STREAM_WAIT_VALUE_EQ;\n\n myArray[1].operation = hipStreamMemOpWriteValue32;\n myArray[1].writeValue.address = writeAddr1;\n myArray[1].writeValue.value = 0x1;\n myArray[1].writeValue.flags = 0x0;\n\n result = hipStreamBatchMemOp(stream, 2, myArray, 0);\n @endcode"]
pub type hipStreamBatchMemOpParams = hipStreamBatchMemOpParams_union;
#[doc = " @brief Structure representing node parameters for batch memory operations in HIP graphs.\n\n hipBatchMemOpNodeParams is used to specify the parameters for batch memory\n operations in HIP graphs. This struct includes the context to use for the operations, the\n number of operations, and an array of hipStreamBatchMemOpParams that describe the operations.\n\n @details\n The structure includes the following fields:\n - ctx: The HIP context to use for the operations.\n - count: The number of operations in the paramArray.\n - paramArray: A pointer to an array of hipStreamBatchMemOpParams.\n - flags: Flags to control the node.\n\n Example usage:\n @code\n hipBatchMemOpNodeParams nodeParams;\n nodeParams.ctx = context;\n nodeParams.count = ARRAY_SIZE;\n nodeParams.paramArray = myArray;\n nodeParams.flags = 0;\n\n Pass nodeParams to a HIP graph APIs hipGraphAddBatchMemOpNode, hipGraphBatchMemOpNodeGetParams,\n hipGraphBatchMemOpNodeSetParams, hipGraphExecBatchMemOpNodeSetParams\n @endcode"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipBatchMemOpNodeParams {
    pub ctx: hipCtx_t,
    pub count: ::std::os::raw::c_uint,
    pub paramArray: *mut hipStreamBatchMemOpParams,
    pub flags: ::std::os::raw::c_uint,
}
#[doc = "< Data will mostly be read and only occassionally\n< be written to"]
pub const hipMemoryAdvise_hipMemAdviseSetReadMostly: hipMemoryAdvise = 1;
#[doc = "< Undo the effect of hipMemAdviseSetReadMostly"]
pub const hipMemoryAdvise_hipMemAdviseUnsetReadMostly: hipMemoryAdvise = 2;
#[doc = "< Set the preferred location for the data as\n< the specified device"]
pub const hipMemoryAdvise_hipMemAdviseSetPreferredLocation: hipMemoryAdvise = 3;
#[doc = "< Clear the preferred location for the data"]
pub const hipMemoryAdvise_hipMemAdviseUnsetPreferredLocation: hipMemoryAdvise = 4;
#[doc = "< Data will be accessed by the specified device\n< so prevent page faults as much as possible"]
pub const hipMemoryAdvise_hipMemAdviseSetAccessedBy: hipMemoryAdvise = 5;
#[doc = "< Let HIP to decide on the page faulting policy\n< for the specified device"]
pub const hipMemoryAdvise_hipMemAdviseUnsetAccessedBy: hipMemoryAdvise = 6;
#[doc = "< The default memory model is fine-grain. That allows\n< coherent operations between host and device, while\n< executing kernels. The coarse-grain can be used\n< for data that only needs to be coherent at dispatch\n< boundaries for better performance"]
pub const hipMemoryAdvise_hipMemAdviseSetCoarseGrain: hipMemoryAdvise = 100;
#[doc = "< Restores cache coherency policy back to fine-grain"]
pub const hipMemoryAdvise_hipMemAdviseUnsetCoarseGrain: hipMemoryAdvise = 101;
#[doc = " HIP Memory Advise values\n\n @note This memory advise enumeration is used on Linux, not Windows."]
pub type hipMemoryAdvise = ::std::os::raw::c_uint;
#[doc = "< Updates to memory with this attribute can be\n< done coherently from all devices"]
pub const hipMemRangeCoherencyMode_hipMemRangeCoherencyModeFineGrain: hipMemRangeCoherencyMode = 0;
#[doc = "< Writes to memory with this attribute can be\n< performed by a single device at a time"]
pub const hipMemRangeCoherencyMode_hipMemRangeCoherencyModeCoarseGrain: hipMemRangeCoherencyMode =
    1;
#[doc = "< Memory region queried contains subregions with\n< both hipMemRangeCoherencyModeFineGrain and\n< hipMemRangeCoherencyModeCoarseGrain attributes"]
pub const hipMemRangeCoherencyMode_hipMemRangeCoherencyModeIndeterminate: hipMemRangeCoherencyMode =
    2;
#[doc = " HIP Coherency Mode"]
pub type hipMemRangeCoherencyMode = ::std::os::raw::c_uint;
#[doc = "< Whether the range will mostly be read and\n< only occassionally be written to"]
pub const hipMemRangeAttribute_hipMemRangeAttributeReadMostly: hipMemRangeAttribute = 1;
#[doc = "< The preferred location of the range"]
pub const hipMemRangeAttribute_hipMemRangeAttributePreferredLocation: hipMemRangeAttribute = 2;
#[doc = "< Memory range has hipMemAdviseSetAccessedBy\n< set for the specified device"]
pub const hipMemRangeAttribute_hipMemRangeAttributeAccessedBy: hipMemRangeAttribute = 3;
#[doc = "< The last location to where the range was\n< prefetched"]
pub const hipMemRangeAttribute_hipMemRangeAttributeLastPrefetchLocation: hipMemRangeAttribute = 4;
#[doc = "< Returns coherency mode\n< @ref hipMemRangeCoherencyMode for the range"]
pub const hipMemRangeAttribute_hipMemRangeAttributeCoherencyMode: hipMemRangeAttribute = 100;
#[doc = " HIP range attributes"]
pub type hipMemRangeAttribute = ::std::os::raw::c_uint;
#[doc = " (value type = int)\n Allow @p hipMemAllocAsync to use memory asynchronously freed\n in another streams as long as a stream ordering dependency\n of the allocating stream on the free action exists.\n hip events and null stream interactions can create the required\n stream ordered dependencies. (default enabled)"]
pub const hipMemPoolAttr_hipMemPoolReuseFollowEventDependencies: hipMemPoolAttr = 1;
#[doc = " (value type = int)\n Allow reuse of already completed frees when there is no dependency\n between the free and allocation. (default enabled)"]
pub const hipMemPoolAttr_hipMemPoolReuseAllowOpportunistic: hipMemPoolAttr = 2;
#[doc = " (value type = int)\n Allow @p hipMemAllocAsync to insert new stream dependencies\n in order to establish the stream ordering required to reuse\n a piece of memory released by cuFreeAsync (default enabled)."]
pub const hipMemPoolAttr_hipMemPoolReuseAllowInternalDependencies: hipMemPoolAttr = 3;
#[doc = " (value type = uint64_t)\n Amount of reserved memory in bytes to hold onto before trying\n to release memory back to the OS. When more than the release\n threshold bytes of memory are held by the memory pool, the\n allocator will try to release memory back to the OS on the\n next call to stream, event or context synchronize. (default 0)"]
pub const hipMemPoolAttr_hipMemPoolAttrReleaseThreshold: hipMemPoolAttr = 4;
#[doc = " (value type = uint64_t)\n Amount of backing memory currently allocated for the mempool."]
pub const hipMemPoolAttr_hipMemPoolAttrReservedMemCurrent: hipMemPoolAttr = 5;
#[doc = " (value type = uint64_t)\n High watermark of backing memory allocated for the mempool since the\n last time it was reset. High watermark can only be reset to zero."]
pub const hipMemPoolAttr_hipMemPoolAttrReservedMemHigh: hipMemPoolAttr = 6;
#[doc = " (value type = uint64_t)\n Amount of memory from the pool that is currently in use by the application."]
pub const hipMemPoolAttr_hipMemPoolAttrUsedMemCurrent: hipMemPoolAttr = 7;
#[doc = " (value type = uint64_t)\n High watermark of the amount of memory from the pool that was in use by the application since\n the last time it was reset. High watermark can only be reset to zero."]
pub const hipMemPoolAttr_hipMemPoolAttrUsedMemHigh: hipMemPoolAttr = 8;
#[doc = " HIP memory pool attributes"]
pub type hipMemPoolAttr = ::std::os::raw::c_uint;
pub const hipMemLocationType_hipMemLocationTypeInvalid: hipMemLocationType = 0;
#[doc = "< Device location, thus it's HIP device ID"]
pub const hipMemLocationType_hipMemLocationTypeDevice: hipMemLocationType = 1;
#[doc = " Specifies the type of location"]
pub type hipMemLocationType = ::std::os::raw::c_uint;
#[doc = " Specifies a memory location.\n\n To specify a gpu, set type = @p hipMemLocationTypeDevice and set id = the gpu's device ID"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipMemLocation {
    #[doc = "< Specifies the location type, which describes the meaning of id"]
    pub type_: hipMemLocationType,
    #[doc = "< Identifier for the provided location type @p hipMemLocationType"]
    pub id: ::std::os::raw::c_int,
}
#[doc = "< Default, make the address range not accessible"]
pub const hipMemAccessFlags_hipMemAccessFlagsProtNone: hipMemAccessFlags = 0;
#[doc = "< Set the address range read accessible"]
pub const hipMemAccessFlags_hipMemAccessFlagsProtRead: hipMemAccessFlags = 1;
#[doc = "< Set the address range read-write accessible"]
pub const hipMemAccessFlags_hipMemAccessFlagsProtReadWrite: hipMemAccessFlags = 3;
#[doc = " Specifies the memory protection flags for mapping\n"]
pub type hipMemAccessFlags = ::std::os::raw::c_uint;
#[doc = " Memory access descriptor"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipMemAccessDesc {
    #[doc = "< Location on which the accessibility has to change"]
    pub location: hipMemLocation,
    #[doc = "< Accessibility flags to set"]
    pub flags: hipMemAccessFlags,
}
pub const hipMemAllocationType_hipMemAllocationTypeInvalid: hipMemAllocationType = 0;
#[doc = " This allocation type is 'pinned', i.e. cannot migrate from its current\n location while the application is actively using it"]
pub const hipMemAllocationType_hipMemAllocationTypePinned: hipMemAllocationType = 1;
#[doc = " This allocation type is 'pinned', i.e. cannot migrate from its current\n location while the application is actively using it"]
pub const hipMemAllocationType_hipMemAllocationTypeMax: hipMemAllocationType = 2147483647;
#[doc = " Defines the allocation types"]
pub type hipMemAllocationType = ::std::os::raw::c_uint;
#[doc = "< Does not allow any export mechanism"]
pub const hipMemAllocationHandleType_hipMemHandleTypeNone: hipMemAllocationHandleType = 0;
#[doc = "< Allows a file descriptor for exporting. Permitted only on POSIX systems"]
pub const hipMemAllocationHandleType_hipMemHandleTypePosixFileDescriptor:
    hipMemAllocationHandleType = 1;
#[doc = "< Allows a Win32 NT handle for exporting. (HANDLE)"]
pub const hipMemAllocationHandleType_hipMemHandleTypeWin32: hipMemAllocationHandleType = 2;
#[doc = "< Allows a Win32 KMT handle for exporting. (D3DKMT_HANDLE)"]
pub const hipMemAllocationHandleType_hipMemHandleTypeWin32Kmt: hipMemAllocationHandleType = 4;
#[doc = " Flags for specifying handle types for memory pool allocations\n"]
pub type hipMemAllocationHandleType = ::std::os::raw::c_uint;
#[doc = " Specifies the properties of allocations made from the pool."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipMemPoolProps {
    #[doc = "< Allocation type. Currently must be specified as @p hipMemAllocationTypePinned"]
    pub allocType: hipMemAllocationType,
    #[doc = "< Handle types that will be supported by allocations from the pool"]
    pub handleTypes: hipMemAllocationHandleType,
    #[doc = "< Location where allocations should reside"]
    pub location: hipMemLocation,
    #[doc = " Windows-specific LPSECURITYATTRIBUTES required when @p hipMemHandleTypeWin32 is specified"]
    pub win32SecurityAttributes: *mut ::std::os::raw::c_void,
    #[doc = "< Maximum pool size. When set to 0, defaults to a system dependent value"]
    pub maxSize: usize,
    #[doc = "< Reserved for future use, must be 0"]
    pub reserved: [::std::os::raw::c_uchar; 56usize],
}
#[doc = " Opaque data structure for exporting a pool allocation"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipMemPoolPtrExportData {
    pub reserved: [::std::os::raw::c_uchar; 64usize],
}
pub const hipFuncAttribute_hipFuncAttributeMaxDynamicSharedMemorySize: hipFuncAttribute = 8;
pub const hipFuncAttribute_hipFuncAttributePreferredSharedMemoryCarveout: hipFuncAttribute = 9;
pub const hipFuncAttribute_hipFuncAttributeMax: hipFuncAttribute = 10;
#[doc = " @warning On AMD devices and some Nvidia devices, these hints and controls are ignored."]
pub type hipFuncAttribute = ::std::os::raw::c_uint;
#[doc = "< no preference for shared memory or L1 (default)"]
pub const hipFuncCache_t_hipFuncCachePreferNone: hipFuncCache_t = 0;
#[doc = "< prefer larger shared memory and smaller L1 cache"]
pub const hipFuncCache_t_hipFuncCachePreferShared: hipFuncCache_t = 1;
#[doc = "< prefer larger L1 cache and smaller shared memory"]
pub const hipFuncCache_t_hipFuncCachePreferL1: hipFuncCache_t = 2;
#[doc = "< prefer equal size L1 cache and shared memory"]
pub const hipFuncCache_t_hipFuncCachePreferEqual: hipFuncCache_t = 3;
#[doc = " @warning On AMD devices and some Nvidia devices, these hints and controls are ignored."]
pub type hipFuncCache_t = ::std::os::raw::c_uint;
#[doc = "< The compiler selects a device-specific value for the banking."]
pub const hipSharedMemConfig_hipSharedMemBankSizeDefault: hipSharedMemConfig = 0;
#[doc = "< Shared mem is banked at 4-bytes intervals and performs best\n< when adjacent threads access data 4 bytes apart."]
pub const hipSharedMemConfig_hipSharedMemBankSizeFourByte: hipSharedMemConfig = 1;
#[doc = "< Shared mem is banked at 8-byte intervals and performs best\n< when adjacent threads access data 4 bytes apart."]
pub const hipSharedMemConfig_hipSharedMemBankSizeEightByte: hipSharedMemConfig = 2;
#[doc = " @warning On AMD devices and some Nvidia devices, these hints and controls are ignored."]
pub type hipSharedMemConfig = ::std::os::raw::c_uint;
#[doc = " Struct for data in 3D"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dim3 {
    #[doc = "< x"]
    pub x: u32,
    #[doc = "< y"]
    pub y: u32,
    #[doc = "< z"]
    pub z: u32,
}
#[doc = " struct hipLaunchParams_t"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipLaunchParams_t {
    #[doc = "< Device function symbol"]
    pub func: *mut ::std::os::raw::c_void,
    #[doc = "< Grid dimensions"]
    pub gridDim: dim3,
    #[doc = "< Block dimensions"]
    pub blockDim: dim3,
    #[doc = "< Arguments"]
    pub args: *mut *mut ::std::os::raw::c_void,
    #[doc = "< Shared memory"]
    pub sharedMem: usize,
    #[doc = "< Stream identifier"]
    pub stream: hipStream_t,
}
#[doc = " struct hipLaunchParams_t"]
pub type hipLaunchParams = hipLaunchParams_t;
#[doc = " struct hipFunctionLaunchParams_t"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipFunctionLaunchParams_t {
    #[doc = "< Kernel to launch"]
    pub function: hipFunction_t,
    #[doc = "< Width(X) of grid in blocks"]
    pub gridDimX: ::std::os::raw::c_uint,
    #[doc = "< Height(Y) of grid in blocks"]
    pub gridDimY: ::std::os::raw::c_uint,
    #[doc = "< Depth(Z) of grid in blocks"]
    pub gridDimZ: ::std::os::raw::c_uint,
    #[doc = "< X dimension of each thread block"]
    pub blockDimX: ::std::os::raw::c_uint,
    #[doc = "< Y dimension of each thread block"]
    pub blockDimY: ::std::os::raw::c_uint,
    #[doc = "< Z dimension of each thread block"]
    pub blockDimZ: ::std::os::raw::c_uint,
    #[doc = "< Shared memory"]
    pub sharedMemBytes: ::std::os::raw::c_uint,
    #[doc = "< Stream identifier"]
    pub hStream: hipStream_t,
    #[doc = "< Kernel parameters"]
    pub kernelParams: *mut *mut ::std::os::raw::c_void,
}
#[doc = " struct hipFunctionLaunchParams_t"]
pub type hipFunctionLaunchParams = hipFunctionLaunchParams_t;
pub const hipExternalMemoryHandleType_enum_hipExternalMemoryHandleTypeOpaqueFd:
    hipExternalMemoryHandleType_enum = 1;
pub const hipExternalMemoryHandleType_enum_hipExternalMemoryHandleTypeOpaqueWin32:
    hipExternalMemoryHandleType_enum = 2;
pub const hipExternalMemoryHandleType_enum_hipExternalMemoryHandleTypeOpaqueWin32Kmt:
    hipExternalMemoryHandleType_enum = 3;
pub const hipExternalMemoryHandleType_enum_hipExternalMemoryHandleTypeD3D12Heap:
    hipExternalMemoryHandleType_enum = 4;
pub const hipExternalMemoryHandleType_enum_hipExternalMemoryHandleTypeD3D12Resource:
    hipExternalMemoryHandleType_enum = 5;
pub const hipExternalMemoryHandleType_enum_hipExternalMemoryHandleTypeD3D11Resource:
    hipExternalMemoryHandleType_enum = 6;
pub const hipExternalMemoryHandleType_enum_hipExternalMemoryHandleTypeD3D11ResourceKmt:
    hipExternalMemoryHandleType_enum = 7;
pub const hipExternalMemoryHandleType_enum_hipExternalMemoryHandleTypeNvSciBuf:
    hipExternalMemoryHandleType_enum = 8;
pub type hipExternalMemoryHandleType_enum = ::std::os::raw::c_uint;
pub use self::hipExternalMemoryHandleType_enum as hipExternalMemoryHandleType;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hipExternalMemoryHandleDesc_st {
    pub type_: hipExternalMemoryHandleType,
    pub handle: hipExternalMemoryHandleDesc_st__bindgen_ty_1,
    pub size: ::std::os::raw::c_ulonglong,
    pub flags: ::std::os::raw::c_uint,
    pub reserved: [::std::os::raw::c_uint; 16usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union hipExternalMemoryHandleDesc_st__bindgen_ty_1 {
    pub fd: ::std::os::raw::c_int,
    pub win32: hipExternalMemoryHandleDesc_st__bindgen_ty_1__bindgen_ty_1,
    pub nvSciBufObject: *const ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipExternalMemoryHandleDesc_st__bindgen_ty_1__bindgen_ty_1 {
    pub handle: *mut ::std::os::raw::c_void,
    pub name: *const ::std::os::raw::c_void,
}
pub type hipExternalMemoryHandleDesc = hipExternalMemoryHandleDesc_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipExternalMemoryBufferDesc_st {
    pub offset: ::std::os::raw::c_ulonglong,
    pub size: ::std::os::raw::c_ulonglong,
    pub flags: ::std::os::raw::c_uint,
    pub reserved: [::std::os::raw::c_uint; 16usize],
}
pub type hipExternalMemoryBufferDesc = hipExternalMemoryBufferDesc_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipExternalMemoryMipmappedArrayDesc_st {
    pub offset: ::std::os::raw::c_ulonglong,
    pub formatDesc: hipChannelFormatDesc,
    pub extent: hipExtent,
    pub flags: ::std::os::raw::c_uint,
    pub numLevels: ::std::os::raw::c_uint,
}
pub type hipExternalMemoryMipmappedArrayDesc = hipExternalMemoryMipmappedArrayDesc_st;
pub type hipExternalMemory_t = *mut ::std::os::raw::c_void;
pub const hipExternalSemaphoreHandleType_enum_hipExternalSemaphoreHandleTypeOpaqueFd:
    hipExternalSemaphoreHandleType_enum = 1;
pub const hipExternalSemaphoreHandleType_enum_hipExternalSemaphoreHandleTypeOpaqueWin32:
    hipExternalSemaphoreHandleType_enum = 2;
pub const hipExternalSemaphoreHandleType_enum_hipExternalSemaphoreHandleTypeOpaqueWin32Kmt:
    hipExternalSemaphoreHandleType_enum = 3;
pub const hipExternalSemaphoreHandleType_enum_hipExternalSemaphoreHandleTypeD3D12Fence:
    hipExternalSemaphoreHandleType_enum = 4;
pub const hipExternalSemaphoreHandleType_enum_hipExternalSemaphoreHandleTypeD3D11Fence:
    hipExternalSemaphoreHandleType_enum = 5;
pub const hipExternalSemaphoreHandleType_enum_hipExternalSemaphoreHandleTypeNvSciSync:
    hipExternalSemaphoreHandleType_enum = 6;
pub const hipExternalSemaphoreHandleType_enum_hipExternalSemaphoreHandleTypeKeyedMutex:
    hipExternalSemaphoreHandleType_enum = 7;
pub const hipExternalSemaphoreHandleType_enum_hipExternalSemaphoreHandleTypeKeyedMutexKmt:
    hipExternalSemaphoreHandleType_enum = 8;
pub const hipExternalSemaphoreHandleType_enum_hipExternalSemaphoreHandleTypeTimelineSemaphoreFd:
    hipExternalSemaphoreHandleType_enum = 9;
pub const hipExternalSemaphoreHandleType_enum_hipExternalSemaphoreHandleTypeTimelineSemaphoreWin32 : hipExternalSemaphoreHandleType_enum = 10 ;
pub type hipExternalSemaphoreHandleType_enum = ::std::os::raw::c_uint;
pub use self::hipExternalSemaphoreHandleType_enum as hipExternalSemaphoreHandleType;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hipExternalSemaphoreHandleDesc_st {
    pub type_: hipExternalSemaphoreHandleType,
    pub handle: hipExternalSemaphoreHandleDesc_st__bindgen_ty_1,
    pub flags: ::std::os::raw::c_uint,
    pub reserved: [::std::os::raw::c_uint; 16usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union hipExternalSemaphoreHandleDesc_st__bindgen_ty_1 {
    pub fd: ::std::os::raw::c_int,
    pub win32: hipExternalSemaphoreHandleDesc_st__bindgen_ty_1__bindgen_ty_1,
    pub NvSciSyncObj: *const ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipExternalSemaphoreHandleDesc_st__bindgen_ty_1__bindgen_ty_1 {
    pub handle: *mut ::std::os::raw::c_void,
    pub name: *const ::std::os::raw::c_void,
}
pub type hipExternalSemaphoreHandleDesc = hipExternalSemaphoreHandleDesc_st;
pub type hipExternalSemaphore_t = *mut ::std::os::raw::c_void;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hipExternalSemaphoreSignalParams_st {
    pub params: hipExternalSemaphoreSignalParams_st__bindgen_ty_1,
    pub flags: ::std::os::raw::c_uint,
    pub reserved: [::std::os::raw::c_uint; 16usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hipExternalSemaphoreSignalParams_st__bindgen_ty_1 {
    pub fence: hipExternalSemaphoreSignalParams_st__bindgen_ty_1__bindgen_ty_1,
    pub nvSciSync: hipExternalSemaphoreSignalParams_st__bindgen_ty_1__bindgen_ty_2,
    pub keyedMutex: hipExternalSemaphoreSignalParams_st__bindgen_ty_1__bindgen_ty_3,
    pub reserved: [::std::os::raw::c_uint; 12usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipExternalSemaphoreSignalParams_st__bindgen_ty_1__bindgen_ty_1 {
    pub value: ::std::os::raw::c_ulonglong,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union hipExternalSemaphoreSignalParams_st__bindgen_ty_1__bindgen_ty_2 {
    pub fence: *mut ::std::os::raw::c_void,
    pub reserved: ::std::os::raw::c_ulonglong,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipExternalSemaphoreSignalParams_st__bindgen_ty_1__bindgen_ty_3 {
    pub key: ::std::os::raw::c_ulonglong,
}
pub type hipExternalSemaphoreSignalParams = hipExternalSemaphoreSignalParams_st;
#[doc = " External semaphore wait parameters, compatible with driver type"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hipExternalSemaphoreWaitParams_st {
    pub params: hipExternalSemaphoreWaitParams_st__bindgen_ty_1,
    pub flags: ::std::os::raw::c_uint,
    pub reserved: [::std::os::raw::c_uint; 16usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hipExternalSemaphoreWaitParams_st__bindgen_ty_1 {
    pub fence: hipExternalSemaphoreWaitParams_st__bindgen_ty_1__bindgen_ty_1,
    pub nvSciSync: hipExternalSemaphoreWaitParams_st__bindgen_ty_1__bindgen_ty_2,
    pub keyedMutex: hipExternalSemaphoreWaitParams_st__bindgen_ty_1__bindgen_ty_3,
    pub reserved: [::std::os::raw::c_uint; 10usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipExternalSemaphoreWaitParams_st__bindgen_ty_1__bindgen_ty_1 {
    pub value: ::std::os::raw::c_ulonglong,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union hipExternalSemaphoreWaitParams_st__bindgen_ty_1__bindgen_ty_2 {
    pub fence: *mut ::std::os::raw::c_void,
    pub reserved: ::std::os::raw::c_ulonglong,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipExternalSemaphoreWaitParams_st__bindgen_ty_1__bindgen_ty_3 {
    pub key: ::std::os::raw::c_ulonglong,
    pub timeoutMs: ::std::os::raw::c_uint,
}
#[doc = " External semaphore wait parameters, compatible with driver type"]
pub type hipExternalSemaphoreWaitParams = hipExternalSemaphoreWaitParams_st;
extern "C" {
    #[doc = " Internal use only. This API may change in the future\n Pre-Compiled header for online compilation"]
    pub fn __hipGetPCH(pch: *mut *const ::std::os::raw::c_char, size: *mut ::std::os::raw::c_uint);
}
pub const hipGraphicsRegisterFlags_hipGraphicsRegisterFlagsNone: hipGraphicsRegisterFlags = 0;
#[doc = "< HIP will not write to this registered resource"]
pub const hipGraphicsRegisterFlags_hipGraphicsRegisterFlagsReadOnly: hipGraphicsRegisterFlags = 1;
pub const hipGraphicsRegisterFlags_hipGraphicsRegisterFlagsWriteDiscard: hipGraphicsRegisterFlags =
    2;
#[doc = "< HIP will bind this resource to a surface"]
pub const hipGraphicsRegisterFlags_hipGraphicsRegisterFlagsSurfaceLoadStore:
    hipGraphicsRegisterFlags = 4;
pub const hipGraphicsRegisterFlags_hipGraphicsRegisterFlagsTextureGather: hipGraphicsRegisterFlags =
    8;
#[doc = " HIP Access falgs for Interop resources."]
pub type hipGraphicsRegisterFlags = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _hipGraphicsResource {
    _unused: [u8; 0],
}
pub type hipGraphicsResource = _hipGraphicsResource;
pub type hipGraphicsResource_t = *mut hipGraphicsResource;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ihipGraph {
    _unused: [u8; 0],
}
#[doc = " An opaque value that represents a hip graph"]
pub type hipGraph_t = *mut ihipGraph;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipGraphNode {
    _unused: [u8; 0],
}
#[doc = " An opaque value that represents a hip graph node"]
pub type hipGraphNode_t = *mut hipGraphNode;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipGraphExec {
    _unused: [u8; 0],
}
#[doc = " An opaque value that represents a hip graph Exec"]
pub type hipGraphExec_t = *mut hipGraphExec;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipUserObject {
    _unused: [u8; 0],
}
#[doc = " An opaque value that represents a user obj"]
pub type hipUserObject_t = *mut hipUserObject;
#[doc = "< GPU kernel node"]
pub const hipGraphNodeType_hipGraphNodeTypeKernel: hipGraphNodeType = 0;
#[doc = "< Memcpy node"]
pub const hipGraphNodeType_hipGraphNodeTypeMemcpy: hipGraphNodeType = 1;
#[doc = "< Memset node"]
pub const hipGraphNodeType_hipGraphNodeTypeMemset: hipGraphNodeType = 2;
#[doc = "< Host (executable) node"]
pub const hipGraphNodeType_hipGraphNodeTypeHost: hipGraphNodeType = 3;
#[doc = "< Node which executes an embedded graph"]
pub const hipGraphNodeType_hipGraphNodeTypeGraph: hipGraphNodeType = 4;
#[doc = "< Empty (no-op) node"]
pub const hipGraphNodeType_hipGraphNodeTypeEmpty: hipGraphNodeType = 5;
#[doc = "< External event wait node"]
pub const hipGraphNodeType_hipGraphNodeTypeWaitEvent: hipGraphNodeType = 6;
#[doc = "< External event record node"]
pub const hipGraphNodeType_hipGraphNodeTypeEventRecord: hipGraphNodeType = 7;
#[doc = "< External Semaphore signal node"]
pub const hipGraphNodeType_hipGraphNodeTypeExtSemaphoreSignal: hipGraphNodeType = 8;
#[doc = "< External Semaphore wait node"]
pub const hipGraphNodeType_hipGraphNodeTypeExtSemaphoreWait: hipGraphNodeType = 9;
#[doc = "< Memory alloc node"]
pub const hipGraphNodeType_hipGraphNodeTypeMemAlloc: hipGraphNodeType = 10;
#[doc = "< Memory free node"]
pub const hipGraphNodeType_hipGraphNodeTypeMemFree: hipGraphNodeType = 11;
#[doc = "< MemcpyFromSymbol node"]
pub const hipGraphNodeType_hipGraphNodeTypeMemcpyFromSymbol: hipGraphNodeType = 12;
#[doc = "< MemcpyToSymbol node"]
pub const hipGraphNodeType_hipGraphNodeTypeMemcpyToSymbol: hipGraphNodeType = 13;
#[doc = "< BatchMemOp node"]
pub const hipGraphNodeType_hipGraphNodeTypeBatchMemOp: hipGraphNodeType = 14;
pub const hipGraphNodeType_hipGraphNodeTypeCount: hipGraphNodeType = 15;
#[doc = " hipGraphNodeType"]
pub type hipGraphNodeType = ::std::os::raw::c_uint;
pub type hipHostFn_t =
    ::std::option::Option<unsafe extern "C" fn(userData: *mut ::std::os::raw::c_void)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipHostNodeParams {
    pub fn_: hipHostFn_t,
    pub userData: *mut ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipKernelNodeParams {
    pub blockDim: dim3,
    pub extra: *mut *mut ::std::os::raw::c_void,
    pub func: *mut ::std::os::raw::c_void,
    pub gridDim: dim3,
    pub kernelParams: *mut *mut ::std::os::raw::c_void,
    pub sharedMemBytes: ::std::os::raw::c_uint,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipMemsetParams {
    pub dst: *mut ::std::os::raw::c_void,
    pub elementSize: ::std::os::raw::c_uint,
    pub height: usize,
    pub pitch: usize,
    pub value: ::std::os::raw::c_uint,
    pub width: usize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipMemAllocNodeParams {
    #[doc = "< Pool properties, which contain where\n< the location should reside"]
    pub poolProps: hipMemPoolProps,
    #[doc = "< The number of memory access descriptors."]
    pub accessDescs: *const hipMemAccessDesc,
    #[doc = "< The number of access descriptors.\n< Must not be bigger than the number of GPUs"]
    pub accessDescCount: usize,
    #[doc = "< The size of the requested allocation in bytes"]
    pub bytesize: usize,
    #[doc = "< Returned device address of the allocation"]
    pub dptr: *mut ::std::os::raw::c_void,
}
pub const hipAccessProperty_hipAccessPropertyNormal: hipAccessProperty = 0;
pub const hipAccessProperty_hipAccessPropertyStreaming: hipAccessProperty = 1;
pub const hipAccessProperty_hipAccessPropertyPersisting: hipAccessProperty = 2;
pub type hipAccessProperty = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipAccessPolicyWindow {
    pub base_ptr: *mut ::std::os::raw::c_void,
    pub hitProp: hipAccessProperty,
    pub hitRatio: f32,
    pub missProp: hipAccessProperty,
    pub num_bytes: usize,
}
#[doc = "< Valid for Streams, graph nodes, launches"]
pub const hipLaunchAttributeID_hipLaunchAttributeAccessPolicyWindow: hipLaunchAttributeID = 1;
#[doc = "< Valid for graph nodes, launches"]
pub const hipLaunchAttributeID_hipLaunchAttributeCooperative: hipLaunchAttributeID = 2;
#[doc = "< Valid for graph node, streams, launches"]
pub const hipLaunchAttributeID_hipLaunchAttributePriority: hipLaunchAttributeID = 8;
#[doc = "  Launch Attribute ID"]
pub type hipLaunchAttributeID = ::std::os::raw::c_uint;
#[doc = "  Launch Attribute Value"]
#[repr(C)]
#[derive(Copy, Clone)]
pub union hipLaunchAttributeValue {
    #[doc = "< Value of launch attribute::\nhipLaunchAttributePolicyWindow."]
    pub accessPolicyWindow: hipAccessPolicyWindow,
    #[doc = "< Value of launch attribute ::hipLaunchAttributeCooperative"]
    pub cooperative: ::std::os::raw::c_int,
    #[doc = "< Value of launch attribute :: hipLaunchAttributePriority. Execution\npriority of kernel."]
    pub priority: ::std::os::raw::c_int,
}
#[doc = " Memset node params"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HIP_MEMSET_NODE_PARAMS {
    #[doc = "< Destination pointer on device"]
    pub dst: hipDeviceptr_t,
    #[doc = "< Destination device pointer pitch. Unused if height equals 1"]
    pub pitch: usize,
    #[doc = "< Value of memset to be set"]
    pub value: ::std::os::raw::c_uint,
    #[doc = "< Element in bytes. Must be 1, 2, or 4."]
    pub elementSize: ::std::os::raw::c_uint,
    #[doc = "< Width of a row"]
    pub width: usize,
    #[doc = "< Number of rows"]
    pub height: usize,
}
#[doc = "< The update succeeded"]
pub const hipGraphExecUpdateResult_hipGraphExecUpdateSuccess: hipGraphExecUpdateResult = 0;
#[doc = "< The update failed for an unexpected reason which is described\n< in the return value of the function"]
pub const hipGraphExecUpdateResult_hipGraphExecUpdateError: hipGraphExecUpdateResult = 1;
#[doc = "< The update failed because the topology changed"]
pub const hipGraphExecUpdateResult_hipGraphExecUpdateErrorTopologyChanged:
    hipGraphExecUpdateResult = 2;
#[doc = "< The update failed because a node type changed"]
pub const hipGraphExecUpdateResult_hipGraphExecUpdateErrorNodeTypeChanged:
    hipGraphExecUpdateResult = 3;
pub const hipGraphExecUpdateResult_hipGraphExecUpdateErrorFunctionChanged:
    hipGraphExecUpdateResult = 4;
pub const hipGraphExecUpdateResult_hipGraphExecUpdateErrorParametersChanged:
    hipGraphExecUpdateResult = 5;
pub const hipGraphExecUpdateResult_hipGraphExecUpdateErrorNotSupported: hipGraphExecUpdateResult =
    6;
pub const hipGraphExecUpdateResult_hipGraphExecUpdateErrorUnsupportedFunctionChange:
    hipGraphExecUpdateResult = 7;
#[doc = " Graph execution update result"]
pub type hipGraphExecUpdateResult = ::std::os::raw::c_uint;
pub const hipStreamCaptureMode_hipStreamCaptureModeGlobal: hipStreamCaptureMode = 0;
pub const hipStreamCaptureMode_hipStreamCaptureModeThreadLocal: hipStreamCaptureMode = 1;
pub const hipStreamCaptureMode_hipStreamCaptureModeRelaxed: hipStreamCaptureMode = 2;
pub type hipStreamCaptureMode = ::std::os::raw::c_uint;
#[doc = "< Stream is not capturing"]
pub const hipStreamCaptureStatus_hipStreamCaptureStatusNone: hipStreamCaptureStatus = 0;
#[doc = "< Stream is actively capturing"]
pub const hipStreamCaptureStatus_hipStreamCaptureStatusActive: hipStreamCaptureStatus = 1;
#[doc = "< Stream is part of a capture sequence that has been\n< invalidated, but not terminated"]
pub const hipStreamCaptureStatus_hipStreamCaptureStatusInvalidated: hipStreamCaptureStatus = 2;
pub type hipStreamCaptureStatus = ::std::os::raw::c_uint;
#[doc = "< Add new nodes to the dependency set"]
pub const hipStreamUpdateCaptureDependenciesFlags_hipStreamAddCaptureDependencies:
    hipStreamUpdateCaptureDependenciesFlags = 0;
#[doc = "< Replace the dependency set with the new nodes"]
pub const hipStreamUpdateCaptureDependenciesFlags_hipStreamSetCaptureDependencies:
    hipStreamUpdateCaptureDependenciesFlags = 1;
pub type hipStreamUpdateCaptureDependenciesFlags = ::std::os::raw::c_uint;
#[doc = "< Amount of memory, in bytes, currently associated with graphs"]
pub const hipGraphMemAttributeType_hipGraphMemAttrUsedMemCurrent: hipGraphMemAttributeType = 0;
#[doc = "< High watermark of memory, in bytes, associated with graphs since the last time."]
pub const hipGraphMemAttributeType_hipGraphMemAttrUsedMemHigh: hipGraphMemAttributeType = 1;
#[doc = "< Amount of memory, in bytes, currently allocated for graphs."]
pub const hipGraphMemAttributeType_hipGraphMemAttrReservedMemCurrent: hipGraphMemAttributeType = 2;
#[doc = "< High watermark of memory, in bytes, currently allocated for graphs"]
pub const hipGraphMemAttributeType_hipGraphMemAttrReservedMemHigh: hipGraphMemAttributeType = 3;
pub type hipGraphMemAttributeType = ::std::os::raw::c_uint;
#[doc = "< Destructor execution is not synchronized."]
pub const hipUserObjectFlags_hipUserObjectNoDestructorSync: hipUserObjectFlags = 1;
pub type hipUserObjectFlags = ::std::os::raw::c_uint;
#[doc = "< Add new reference or retain."]
pub const hipUserObjectRetainFlags_hipGraphUserObjectMove: hipUserObjectRetainFlags = 1;
pub type hipUserObjectRetainFlags = ::std::os::raw::c_uint;
pub const hipGraphInstantiateFlags_hipGraphInstantiateFlagAutoFreeOnLaunch:
    hipGraphInstantiateFlags = 1;
pub const hipGraphInstantiateFlags_hipGraphInstantiateFlagUpload: hipGraphInstantiateFlags = 2;
pub const hipGraphInstantiateFlags_hipGraphInstantiateFlagDeviceLaunch: hipGraphInstantiateFlags =
    4;
pub const hipGraphInstantiateFlags_hipGraphInstantiateFlagUseNodePriority:
    hipGraphInstantiateFlags = 8;
pub type hipGraphInstantiateFlags = ::std::os::raw::c_uint;
pub const hipGraphDebugDotFlags_hipGraphDebugDotFlagsVerbose: hipGraphDebugDotFlags = 1;
#[doc = "< Adds hipKernelNodeParams to output"]
pub const hipGraphDebugDotFlags_hipGraphDebugDotFlagsKernelNodeParams: hipGraphDebugDotFlags = 4;
#[doc = "< Adds hipMemcpy3DParms to output"]
pub const hipGraphDebugDotFlags_hipGraphDebugDotFlagsMemcpyNodeParams: hipGraphDebugDotFlags = 8;
#[doc = "< Adds hipMemsetParams to output"]
pub const hipGraphDebugDotFlags_hipGraphDebugDotFlagsMemsetNodeParams: hipGraphDebugDotFlags = 16;
#[doc = "< Adds hipHostNodeParams to output"]
pub const hipGraphDebugDotFlags_hipGraphDebugDotFlagsHostNodeParams: hipGraphDebugDotFlags = 32;
pub const hipGraphDebugDotFlags_hipGraphDebugDotFlagsEventNodeParams: hipGraphDebugDotFlags = 64;
pub const hipGraphDebugDotFlags_hipGraphDebugDotFlagsExtSemasSignalNodeParams:
    hipGraphDebugDotFlags = 128;
pub const hipGraphDebugDotFlags_hipGraphDebugDotFlagsExtSemasWaitNodeParams: hipGraphDebugDotFlags =
    256;
pub const hipGraphDebugDotFlags_hipGraphDebugDotFlagsKernelNodeAttributes: hipGraphDebugDotFlags =
    512;
pub const hipGraphDebugDotFlags_hipGraphDebugDotFlagsHandles: hipGraphDebugDotFlags = 1024;
pub type hipGraphDebugDotFlags = ::std::os::raw::c_uint;
#[doc = "< Instantiation Success"]
pub const hipGraphInstantiateResult_hipGraphInstantiateSuccess: hipGraphInstantiateResult = 0;
#[doc = "< Instantiation failed for an\nunexpected reason which is described in the return value of the function"]
pub const hipGraphInstantiateResult_hipGraphInstantiateError: hipGraphInstantiateResult = 1;
#[doc = "< Instantiation failed due\nto invalid structure, such as cycles"]
pub const hipGraphInstantiateResult_hipGraphInstantiateInvalidStructure: hipGraphInstantiateResult =
    2;
#[doc = "< Instantiation for device launch failed\nbecause the graph contained an unsupported operation"]
pub const hipGraphInstantiateResult_hipGraphInstantiateNodeOperationNotSupported:
    hipGraphInstantiateResult = 3;
#[doc = "< Instantiation for device launch failed\ndue to the nodes belonging to different contexts"]
pub const hipGraphInstantiateResult_hipGraphInstantiateMultipleDevicesNotSupported:
    hipGraphInstantiateResult = 4;
#[doc = " hipGraphInstantiateWithParams results"]
pub type hipGraphInstantiateResult = ::std::os::raw::c_uint;
#[doc = " Graph Instantiation parameters"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipGraphInstantiateParams {
    #[doc = "< The node which caused instantiation to fail, if any"]
    pub errNode_out: hipGraphNode_t,
    #[doc = "< Instantiation flags"]
    pub flags: ::std::os::raw::c_ulonglong,
    #[doc = "< Whether instantiation was successful.\nIf it failed, the reason why"]
    pub result_out: hipGraphInstantiateResult,
    #[doc = "< Upload stream"]
    pub uploadStream: hipStream_t,
}
#[doc = " Memory allocation properties"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipMemAllocationProp {
    #[doc = "< Memory allocation type"]
    pub type_: hipMemAllocationType,
    #[doc = "< Requested handle type"]
    pub requestedHandleType: hipMemAllocationHandleType,
    #[doc = "< Memory location"]
    pub location: hipMemLocation,
    #[doc = "< Metadata for Win32 handles"]
    pub win32HandleMetaData: *mut ::std::os::raw::c_void,
    pub allocFlags: hipMemAllocationProp__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipMemAllocationProp__bindgen_ty_1 {
    #[doc = "< Compression type"]
    pub compressionType: ::std::os::raw::c_uchar,
    #[doc = "< RDMA capable"]
    pub gpuDirectRDMACapable: ::std::os::raw::c_uchar,
    #[doc = "< Usage"]
    pub usage: ::std::os::raw::c_ushort,
}
#[doc = " External semaphore signal node parameters"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipExternalSemaphoreSignalNodeParams {
    pub extSemArray: *mut hipExternalSemaphore_t,
    pub paramsArray: *const hipExternalSemaphoreSignalParams,
    pub numExtSems: ::std::os::raw::c_uint,
}
#[doc = " External semaphore wait node parameters"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipExternalSemaphoreWaitNodeParams {
    pub extSemArray: *mut hipExternalSemaphore_t,
    pub paramsArray: *const hipExternalSemaphoreWaitParams,
    pub numExtSems: ::std::os::raw::c_uint,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ihipMemGenericAllocationHandle {
    _unused: [u8; 0],
}
#[doc = " Generic handle for memory allocation"]
pub type hipMemGenericAllocationHandle_t = *mut ihipMemGenericAllocationHandle;
#[doc = "< Minimum granularity"]
pub const hipMemAllocationGranularity_flags_hipMemAllocationGranularityMinimum:
    hipMemAllocationGranularity_flags = 0;
#[doc = "< Recommended granularity for performance"]
pub const hipMemAllocationGranularity_flags_hipMemAllocationGranularityRecommended:
    hipMemAllocationGranularity_flags = 1;
#[doc = " Flags for granularity"]
pub type hipMemAllocationGranularity_flags = ::std::os::raw::c_uint;
#[doc = "< Generic handle type"]
pub const hipMemHandleType_hipMemHandleTypeGeneric: hipMemHandleType = 0;
#[doc = " Memory handle type"]
pub type hipMemHandleType = ::std::os::raw::c_uint;
#[doc = "< Map operation"]
pub const hipMemOperationType_hipMemOperationTypeMap: hipMemOperationType = 1;
#[doc = "< Unmap operation"]
pub const hipMemOperationType_hipMemOperationTypeUnmap: hipMemOperationType = 2;
#[doc = " Memory operation types"]
pub type hipMemOperationType = ::std::os::raw::c_uint;
#[doc = "< Sparse level"]
pub const hipArraySparseSubresourceType_hipArraySparseSubresourceTypeSparseLevel:
    hipArraySparseSubresourceType = 0;
#[doc = "< Miptail"]
pub const hipArraySparseSubresourceType_hipArraySparseSubresourceTypeMiptail:
    hipArraySparseSubresourceType = 1;
#[doc = " Subresource types for sparse arrays"]
pub type hipArraySparseSubresourceType = ::std::os::raw::c_uint;
#[doc = " Map info for arrays"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hipArrayMapInfo {
    #[doc = "< Resource type"]
    pub resourceType: hipResourceType,
    pub resource: hipArrayMapInfo__bindgen_ty_1,
    #[doc = "< Sparse subresource type"]
    pub subresourceType: hipArraySparseSubresourceType,
    pub subresource: hipArrayMapInfo__bindgen_ty_2,
    #[doc = "< Memory operation type"]
    pub memOperationType: hipMemOperationType,
    #[doc = "< Memory handle type"]
    pub memHandleType: hipMemHandleType,
    pub memHandle: hipArrayMapInfo__bindgen_ty_3,
    #[doc = "< Offset within the memory"]
    pub offset: ::std::os::raw::c_ulonglong,
    #[doc = "< Device ordinal bit mask"]
    pub deviceBitMask: ::std::os::raw::c_uint,
    #[doc = "< flags for future use, must be zero now."]
    pub flags: ::std::os::raw::c_uint,
    #[doc = "< Reserved for future use, must be zero now."]
    pub reserved: [::std::os::raw::c_uint; 2usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union hipArrayMapInfo__bindgen_ty_1 {
    pub mipmap: hipMipmappedArray,
    pub array: hipArray_t,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union hipArrayMapInfo__bindgen_ty_2 {
    pub sparseLevel: hipArrayMapInfo__bindgen_ty_2__bindgen_ty_1,
    pub miptail: hipArrayMapInfo__bindgen_ty_2__bindgen_ty_2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipArrayMapInfo__bindgen_ty_2__bindgen_ty_1 {
    #[doc = "< For mipmapped arrays must be a valid mipmap level. For arrays must be zero"]
    pub level: ::std::os::raw::c_uint,
    #[doc = "< For layered arrays must be a valid layer index. Otherwise, must be zero"]
    pub layer: ::std::os::raw::c_uint,
    #[doc = "< X offset in elements"]
    pub offsetX: ::std::os::raw::c_uint,
    #[doc = "< Y offset in elements"]
    pub offsetY: ::std::os::raw::c_uint,
    #[doc = "< Z offset in elements"]
    pub offsetZ: ::std::os::raw::c_uint,
    #[doc = "< Width in elements"]
    pub extentWidth: ::std::os::raw::c_uint,
    #[doc = "< Height in elements"]
    pub extentHeight: ::std::os::raw::c_uint,
    #[doc = "< Depth in elements"]
    pub extentDepth: ::std::os::raw::c_uint,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipArrayMapInfo__bindgen_ty_2__bindgen_ty_2 {
    #[doc = "< For layered arrays must be a valid layer index. Otherwise, must be zero"]
    pub layer: ::std::os::raw::c_uint,
    #[doc = "< Offset within mip tail"]
    pub offset: ::std::os::raw::c_ulonglong,
    #[doc = "< Extent in bytes"]
    pub size: ::std::os::raw::c_ulonglong,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union hipArrayMapInfo__bindgen_ty_3 {
    pub memHandle: hipMemGenericAllocationHandle_t,
}
#[doc = " Memcpy node params"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipMemcpyNodeParams {
    #[doc = "< Must be zero."]
    pub flags: ::std::os::raw::c_int,
    #[doc = "< Must be zero."]
    pub reserved: [::std::os::raw::c_int; 3usize],
    #[doc = "< Params set for the memory copy."]
    pub copyParams: hipMemcpy3DParms,
}
#[doc = " Child graph node params"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipChildGraphNodeParams {
    #[doc = "< Either the child graph to clone into the node, or\n< a handle to the graph possesed by the node used during query"]
    pub graph: hipGraph_t,
}
#[doc = " Event record node params"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipEventWaitNodeParams {
    #[doc = "< Event to wait on"]
    pub event: hipEvent_t,
}
#[doc = " Event record node params"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipEventRecordNodeParams {
    #[doc = "< The event to be recorded when node executes"]
    pub event: hipEvent_t,
}
#[doc = " Memory free node params"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipMemFreeNodeParams {
    #[doc = "< the pointer to be freed"]
    pub dptr: *mut ::std::os::raw::c_void,
}
#[doc = " Params for different graph nodes"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hipGraphNodeParams {
    pub type_: hipGraphNodeType,
    pub reserved0: [::std::os::raw::c_int; 3usize],
    pub __bindgen_anon_1: hipGraphNodeParams__bindgen_ty_1,
    pub reserved2: ::std::os::raw::c_longlong,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union hipGraphNodeParams__bindgen_ty_1 {
    pub reserved1: [::std::os::raw::c_longlong; 29usize],
    pub kernel: hipKernelNodeParams,
    pub memcpy: hipMemcpyNodeParams,
    pub memset: hipMemsetParams,
    pub host: hipHostNodeParams,
    pub graph: hipChildGraphNodeParams,
    pub eventWait: hipEventWaitNodeParams,
    pub eventRecord: hipEventRecordNodeParams,
    pub extSemSignal: hipExternalSemaphoreSignalNodeParams,
    pub extSemWait: hipExternalSemaphoreWaitNodeParams,
    pub alloc: hipMemAllocNodeParams,
    pub free: hipMemFreeNodeParams,
}
pub const hipGraphDependencyType_hipGraphDependencyTypeDefault: hipGraphDependencyType = 0;
pub const hipGraphDependencyType_hipGraphDependencyTypeProgrammatic: hipGraphDependencyType = 1;
pub type hipGraphDependencyType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hipGraphEdgeData {
    #[doc = "< This indicates when the dependency is triggered from the upstream node on the\n< edge. The meaning is specfic to the node type. A value of 0 in all cases\n< means full completion of the upstream node, with memory visibility to the\n< downstream node or portion thereof (indicated by to_port). Only kernel nodes\n< define non-zero ports. A kernel node can use the following output port types:\n< hipGraphKernelNodePortDefault, hipGraphKernelNodePortProgrammatic, or\n< hipGraphKernelNodePortLaunchCompletion."]
    pub from_port: ::std::os::raw::c_uchar,
    #[doc = "< These bytes are unused and must be zeroed"]
    pub reserved: [::std::os::raw::c_uchar; 5usize],
    #[doc = "< Currently no node types define non-zero ports. This field must be set to zero."]
    pub to_port: ::std::os::raw::c_uchar,
    #[doc = "< This should be populated with a value from hipGraphDependencyType"]
    pub type_: ::std::os::raw::c_uchar,
}
extern "C" {
    #[doc = " @}\n/\n/**\n  @defgroup API HIP API\n  @{\n\n  Defines the HIP API.  See the individual sections for more information.\n/\n/**\n  @defgroup Driver Initialization and Version\n  @{\n  This section describes the initializtion and version functions of HIP runtime API.\n\n/\n/**\n @brief Explicitly initializes the HIP runtime.\n\n @param [in] flags  Initialization flag, should be zero.\n\n Most HIP APIs implicitly initialize the HIP runtime.\n This API provides control over the timing of the initialization.\n\n @returns #hipSuccess, #hipErrorInvalidValue"]
    pub fn hipInit(flags: ::std::os::raw::c_uint) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns the approximate HIP driver version.\n\n @param [out] driverVersion driver version\n\n HIP driver version shows up in the format:\n HIP_VERSION_MAJOR * 10000000 + HIP_VERSION_MINOR * 100000 + HIP_VERSION_PATCH.\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @warning The HIP driver version does not correspond to an exact CUDA driver revision.\n On AMD platform, the API returns the HIP driver version, while on NVIDIA platform, it calls\n the corresponding CUDA runtime API and returns the CUDA driver version.\n There is no mapping/correlation between HIP driver version and CUDA driver version.\n\n @see hipRuntimeGetVersion"]
    pub fn hipDriverGetVersion(driverVersion: *mut ::std::os::raw::c_int) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns the approximate HIP Runtime version.\n\n @param [out] runtimeVersion HIP runtime version\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @warning The version definition of HIP runtime is different from CUDA.\n On AMD platform, the function returns HIP runtime version,\n while on NVIDIA platform, it returns CUDA runtime version.\n And there is no mapping/correlation between HIP version and CUDA version.\n\n @see hipDriverGetVersion"]
    pub fn hipRuntimeGetVersion(runtimeVersion: *mut ::std::os::raw::c_int) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns a handle to a compute device\n @param [out] device Handle of device\n @param [in] ordinal Device ordinal\n\n @returns #hipSuccess, #hipErrorInvalidDevice"]
    pub fn hipDeviceGet(device: *mut hipDevice_t, ordinal: ::std::os::raw::c_int) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns the compute capability of the device\n @param [out] major Major compute capability version number\n @param [out] minor Minor compute capability version number\n @param [in] device Device ordinal\n\n @returns #hipSuccess, #hipErrorInvalidDevice"]
    pub fn hipDeviceComputeCapability(
        major: *mut ::std::os::raw::c_int,
        minor: *mut ::std::os::raw::c_int,
        device: hipDevice_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns an identifer string for the device.\n @param [out] name String of the device name\n @param [in] len Maximum length of string to store in device name\n @param [in] device Device ordinal\n\n @returns #hipSuccess, #hipErrorInvalidDevice"]
    pub fn hipDeviceGetName(
        name: *mut ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
        device: hipDevice_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns an UUID for the device.[BETA]\n @param [out] uuid UUID for the device\n @param [in] device device ordinal\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @returns #hipSuccess, #hipErrorInvalidDevice, #hipErrorInvalidValue, #hipErrorNotInitialized,\n #hipErrorDeinitialized"]
    pub fn hipDeviceGetUuid(uuid: *mut hipUUID, device: hipDevice_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns a value for attribute of link between two devices\n @param [out] value Pointer of the value for the attrubute\n @param [in] attr enum of hipDeviceP2PAttr to query\n @param [in] srcDevice The source device of the link\n @param [in] dstDevice The destination device of the link\n\n @returns #hipSuccess, #hipErrorInvalidDevice"]
    pub fn hipDeviceGetP2PAttribute(
        value: *mut ::std::os::raw::c_int,
        attr: hipDeviceP2PAttr,
        srcDevice: ::std::os::raw::c_int,
        dstDevice: ::std::os::raw::c_int,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns a PCI Bus Id string for the device, overloaded to take int device ID.\n @param [out] pciBusId The string of PCI Bus Id format for the device\n @param [in] len Maximum length of string\n @param [in] device The device ordinal\n\n @returns #hipSuccess, #hipErrorInvalidDevice"]
    pub fn hipDeviceGetPCIBusId(
        pciBusId: *mut ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
        device: ::std::os::raw::c_int,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns a handle to a compute device.\n @param [out] device The handle of the device\n @param [in] pciBusId The string of PCI Bus Id for the device\n\n @returns #hipSuccess, #hipErrorInvalidDevice, #hipErrorInvalidValue"]
    pub fn hipDeviceGetByPCIBusId(
        device: *mut ::std::os::raw::c_int,
        pciBusId: *const ::std::os::raw::c_char,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns the total amount of memory on the device.\n @param [out] bytes The size of memory in bytes, on the device\n @param [in] device The ordinal of the device\n\n @returns #hipSuccess, #hipErrorInvalidDevice"]
    pub fn hipDeviceTotalMem(bytes: *mut usize, device: hipDevice_t) -> hipError_t;
}
extern "C" {
    #[doc = " @}\n/\n/**\n  @defgroup Device Device Management\n  @{\n  This section describes the device management functions of HIP runtime API.\n/\n/**\n @brief Waits on all active streams on current device\n\n When this command is invoked, the host thread gets blocked until all the commands associated\n with streams associated with the device. HIP does not support multiple blocking modes (yet!).\n\n @returns #hipSuccess\n\n @see hipSetDevice, hipDeviceReset"]
    pub fn hipDeviceSynchronize() -> hipError_t;
}
extern "C" {
    #[doc = " @brief The state of current device is discarded and updated to a fresh state.\n\n Calling this function deletes all streams created, memory allocated, kernels running, events\n created. Make sure that no other thread is using the device or streams, memory, kernels, events\n associated with the current device.\n\n @returns #hipSuccess\n\n @see hipDeviceSynchronize"]
    pub fn hipDeviceReset() -> hipError_t;
}
extern "C" {
    #[doc = " @brief Set default device to be used for subsequent hip API calls from this thread.\n\n @param[in] deviceId Valid device in range 0...hipGetDeviceCount().\n\n Sets @p device as the default device for the calling host thread.  Valid device id's are 0...\n (hipGetDeviceCount()-1).\n\n Many HIP APIs implicitly use the \"default device\" :\n\n - Any device memory subsequently allocated from this host thread (using hipMalloc) will be\n allocated on device.\n - Any streams or events created from this host thread will be associated with device.\n - Any kernels launched from this host thread (using hipLaunchKernel) will be executed on device\n (unless a specific stream is specified, in which case the device associated with that stream will\n be used).\n\n This function may be called from any host thread.  Multiple host threads may use the same device.\n This function does no synchronization with the previous or new device, and has very little\n runtime overhead. Applications can use hipSetDevice to quickly switch the default device before\n making a HIP runtime call which uses the default device.\n\n The default device is stored in thread-local-storage for each thread.\n Thread-pool implementations may inherit the default device of the previous thread.  A good\n practice is to always call hipSetDevice at the start of HIP coding sequency to establish a known\n standard device.\n\n @returns #hipSuccess, #hipErrorInvalidDevice, #hipErrorNoDevice\n\n @see #hipGetDevice, #hipGetDeviceCount"]
    pub fn hipSetDevice(deviceId: ::std::os::raw::c_int) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Set a list of devices that can be used.\n\n @param[in] device_arr List of devices to try\n @param[in] len Number of devices in specified list\n\n @returns #hipSuccess, #hipErrorInvalidDevice, #hipErrorInvalidValue\n\n @see #hipGetDevice, #hipGetDeviceCount. #hipSetDevice. #hipGetDeviceProperties. #hipSetDeviceFlags. #hipChooseDevice\n"]
    pub fn hipSetValidDevices(
        device_arr: *mut ::std::os::raw::c_int,
        len: ::std::os::raw::c_int,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Return the default device id for the calling host thread.\n\n @param [out] deviceId *device is written with the default device\n\n HIP maintains an default device for each thread using thread-local-storage.\n This device is used implicitly for HIP runtime APIs called by this thread.\n hipGetDevice returns in * @p device the default device for the calling host thread.\n\n @returns #hipSuccess, #hipErrorInvalidDevice, #hipErrorInvalidValue\n\n @see hipSetDevice, hipGetDevicesizeBytes"]
    pub fn hipGetDevice(deviceId: *mut ::std::os::raw::c_int) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Return number of compute-capable devices.\n\n @param [out] count Returns number of compute-capable devices.\n\n @returns #hipSuccess, #hipErrorNoDevice\n\n\n Returns in @p *count the number of devices that have ability to run compute commands.  If there\n are no such devices, then @ref hipGetDeviceCount will return #hipErrorNoDevice. If 1 or more\n devices can be found, then hipGetDeviceCount returns #hipSuccess."]
    pub fn hipGetDeviceCount(count: *mut ::std::os::raw::c_int) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Query for a specific device attribute.\n\n @param [out] pi pointer to value to return\n @param [in] attr attribute to query\n @param [in] deviceId which device to query for information\n\n @returns #hipSuccess, #hipErrorInvalidDevice, #hipErrorInvalidValue"]
    pub fn hipDeviceGetAttribute(
        pi: *mut ::std::os::raw::c_int,
        attr: hipDeviceAttribute_t,
        deviceId: ::std::os::raw::c_int,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns the default memory pool of the specified device\n\n @param [out] mem_pool Default memory pool to return\n @param [in] device    Device index for query the default memory pool\n\n @returns #hipSuccess, #hipErrorInvalidDevice, #hipErrorInvalidValue, #hipErrorNotSupported\n\n @see hipDeviceGetDefaultMemPool, hipMallocAsync, hipMemPoolTrimTo, hipMemPoolGetAttribute,\n hipDeviceSetMemPool, hipMemPoolSetAttribute, hipMemPoolSetAccess, hipMemPoolGetAccess\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipDeviceGetDefaultMemPool(
        mem_pool: *mut hipMemPool_t,
        device: ::std::os::raw::c_int,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets the current memory pool of a device\n\n The memory pool must be local to the specified device.\n @p hipMallocAsync allocates from the current mempool of the provided stream's device.\n By default, a device's current memory pool is its default memory pool.\n\n @note Use @p hipMallocFromPoolAsync for asynchronous memory allocations from a device\n different than the one the stream runs on.\n\n @param [in] device   Device index for the update\n @param [in] mem_pool Memory pool for update as the current on the specified device\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidDevice, #hipErrorNotSupported\n\n @see hipDeviceGetDefaultMemPool, hipMallocAsync, hipMemPoolTrimTo, hipMemPoolGetAttribute,\n hipDeviceSetMemPool, hipMemPoolSetAttribute, hipMemPoolSetAccess, hipMemPoolGetAccess\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipDeviceSetMemPool(device: ::std::os::raw::c_int, mem_pool: hipMemPool_t)
        -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets the current memory pool for the specified device\n\n Returns the last pool provided to @p hipDeviceSetMemPool for this device\n or the device's default memory pool if @p hipDeviceSetMemPool has never been called.\n By default the current mempool is the default mempool for a device,\n otherwise the returned pool must have been set with @p hipDeviceSetMemPool.\n\n @param [out] mem_pool Current memory pool on the specified device\n @param [in] device    Device index to query the current memory pool\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n\n @see hipDeviceGetDefaultMemPool, hipMallocAsync, hipMemPoolTrimTo, hipMemPoolGetAttribute,\n hipDeviceSetMemPool, hipMemPoolSetAttribute, hipMemPoolSetAccess, hipMemPoolGetAccess\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipDeviceGetMemPool(
        mem_pool: *mut hipMemPool_t,
        device: ::std::os::raw::c_int,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns device properties.\n\n @param [out] prop written with device properties\n @param [in]  deviceId which device to query for information\n\n @returns #hipSuccess, #hipErrorInvalidDevice\n @bug HCC always returns 0 for maxThreadsPerMultiProcessor\n @bug HCC always returns 0 for regsPerBlock\n @bug HCC always returns 0 for l2CacheSize\n\n Populates hipGetDeviceProperties with information for the specified device."]
    pub fn hipGetDevicePropertiesR0600(
        prop: *mut hipDeviceProp_tR0600,
        deviceId: ::std::os::raw::c_int,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets the maximum width for 1D linear textures on the specified device\n\n This function queries the maximum width, in elements, of 1D linear textures that can be allocated\n on the specified device. The maximum width depends on the texture element size and the hardware\n limitations of the device.\n\n @param [out] max_width Maximum width, in elements, of 1D linear textures that the device can support\n @param [in] device     Device index to query for maximum 1D texture width\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidDevice\n\n @see hipDeviceGetAttribute, hipMalloc, hipTexRefSetAddressMode"]
    pub fn hipDeviceGetTexture1DLinearMaxWidth(
        mem_pool: *mut hipMemPool_t,
        device: ::std::os::raw::c_int,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Set L1/Shared cache partition.\n\n @param [in] cacheConfig Cache configuration\n\n @returns #hipSuccess, #hipErrorNotInitialized, #hipErrorNotSupported\n\n Note: AMD devices do not support reconfigurable cache. This API is not implemented\n on AMD platform. If the function is called, it will return hipErrorNotSupported.\n"]
    pub fn hipDeviceSetCacheConfig(cacheConfig: hipFuncCache_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Get Cache configuration for a specific Device\n\n @param [out] cacheConfig Pointer of cache configuration\n\n @returns #hipSuccess, #hipErrorNotInitialized\n Note: AMD devices do not support reconfigurable cache. This hint is ignored\n on these architectures.\n"]
    pub fn hipDeviceGetCacheConfig(cacheConfig: *mut hipFuncCache_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets resource limits of current device\n\n The function queries the size of limit value, as required by the input enum value hipLimit_t,\n which can be either #hipLimitStackSize, or #hipLimitMallocHeapSize. Any other input as\n default, the function will return #hipErrorUnsupportedLimit.\n\n @param [out] pValue Returns the size of the limit in bytes\n @param [in]  limit The limit to query\n\n @returns #hipSuccess, #hipErrorUnsupportedLimit, #hipErrorInvalidValue\n"]
    pub fn hipDeviceGetLimit(pValue: *mut usize, limit: hipLimit_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets resource limits of current device.\n\n As the input enum limit,\n #hipLimitStackSize sets the limit value of the stack size on the current GPU device, per thread.\n The limit size can get via hipDeviceGetLimit. The size is in units of 256 dwords, up to the limit\n (128K - 16).\n\n #hipLimitMallocHeapSize sets the limit value of the heap used by the malloc()/free()\n calls. For limit size, use the #hipDeviceGetLimit API.\n\n Any other input as default, the funtion will return hipErrorUnsupportedLimit.\n\n @param [in] limit Enum of hipLimit_t to set\n @param [in] value The size of limit value in bytes\n\n @returns #hipSuccess, #hipErrorUnsupportedLimit, #hipErrorInvalidValue\n"]
    pub fn hipDeviceSetLimit(limit: hipLimit_t, value: usize) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns bank width of shared memory for current device\n\n @param [out] pConfig The pointer of the bank width for shared memory\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotInitialized\n\n Note: AMD devices and some Nvidia GPUS do not support shared cache banking, and the hint is\n ignored on those architectures.\n"]
    pub fn hipDeviceGetSharedMemConfig(pConfig: *mut hipSharedMemConfig) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets the flags set for current device\n\n @param [out] flags Pointer of the flags\n\n @returns #hipSuccess, #hipErrorInvalidDevice, #hipErrorInvalidValue"]
    pub fn hipGetDeviceFlags(flags: *mut ::std::os::raw::c_uint) -> hipError_t;
}
extern "C" {
    #[doc = " @brief The bank width of shared memory on current device is set\n\n @param [in] config Configuration for the bank width of shared memory\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotInitialized\n\n Note: AMD devices and some Nvidia GPUS do not support shared cache banking, and the hint is\n ignored on those architectures.\n"]
    pub fn hipDeviceSetSharedMemConfig(config: hipSharedMemConfig) -> hipError_t;
}
extern "C" {
    #[doc = " @brief The current device behavior is changed according to the flags passed.\n\n @param [in] flags Flag to set on the current device\n\n The schedule flags impact how HIP waits for the completion of a command running on a device.\n\n #hipDeviceScheduleSpin         : HIP runtime will actively spin in the thread which submitted\n the work until the command completes.  This offers the lowest latency, but will consume a CPU\n core and may increase power.\n\n #hipDeviceScheduleYield        : The HIP runtime will yield the CPU to system so that other\n tasks can use it. This may increase latency to detect the completion but will consume less\n power and is friendlier to other tasks in the system.\n\n #hipDeviceScheduleBlockingSync : On ROCm platform, this is a synonym for hipDeviceScheduleYield.\n\n #hipDeviceScheduleAuto         : This is the default value if the input 'flags' is zero.\n Uses a heuristic to select between Spin and Yield modes. If the number of HIP contexts is\n greater than the number of logical processors in the system, uses Spin scheduling, otherwise\n uses Yield scheduling.\n\n #hipDeviceMapHost              : Allows mapping host memory. On ROCm, this is always allowed and\n the flag is ignored.\n\n #hipDeviceLmemResizeToMax      : This flag is silently ignored on ROCm.\n\n @returns #hipSuccess, #hipErrorNoDevice, #hipErrorInvalidDevice, #hipErrorSetOnActiveProcess\n\n"]
    pub fn hipSetDeviceFlags(flags: ::std::os::raw::c_uint) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Device which matches hipDeviceProp_t is returned\n\n @param [out] device Pointer of the device\n @param [in]  prop Pointer of the properties\n\n @returns #hipSuccess, #hipErrorInvalidValue"]
    pub fn hipChooseDeviceR0600(
        device: *mut ::std::os::raw::c_int,
        prop: *const hipDeviceProp_tR0600,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns the link type and hop count between two devices\n\n @param [in] device1 Ordinal for device1\n @param [in] device2 Ordinal for device2\n @param [out] linktype Returns the link type (See hsa_amd_link_info_type_t) between the two devices\n @param [out] hopcount Returns the hop count between the two devices\n\n Queries and returns the HSA link type and the hop count between the two specified devices.\n\n @returns #hipSuccess, #hipErrorInvalidValue"]
    pub fn hipExtGetLinkTypeAndHopCount(
        device1: ::std::os::raw::c_int,
        device2: ::std::os::raw::c_int,
        linktype: *mut u32,
        hopcount: *mut u32,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets an interprocess memory handle for an existing device memory allocation.\n\n Takes a pointer to the base of an existing device memory allocation created with ::hipMalloc\n and exports it for use in another process. This is a lightweight operation and may be called\n multiple times on an allocation without adverse effects.\n\n If a region of memory is freed with ::hipFree and a subsequent call to ::hipMalloc returns\n memory with the same device address, ::hipIpcGetMemHandle will return a unique handle for\n the new memory.\n\n @param handle - Pointer to user allocated hipIpcMemHandle to return the handle in.\n @param devPtr - Base pointer to previously allocated device memory.\n\n @returns #hipSuccess, #hipErrorInvalidHandle, #hipErrorOutOfMemory, #hipErrorMapFailed\n\n @note This IPC memory related feature API on Windows may behave differently from Linux.\n"]
    pub fn hipIpcGetMemHandle(
        handle: *mut hipIpcMemHandle_t,
        devPtr: *mut ::std::os::raw::c_void,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Opens an interprocess memory handle exported from another process and returns a device\n pointer usable in the local process.\n\n Maps memory exported from another process with ::hipIpcGetMemHandle into the current device\n address space. For contexts on different devices ::hipIpcOpenMemHandle can attempt to enable\n peer access between the devices like the user called ::hipDeviceEnablePeerAccess.\n This behavior is controlled by the flag #hipIpcMemLazyEnablePeerAccess.\n The API ::hipDeviceCanAccessPeer can determine if a mapping is possible.\n\n hipIpcMemHandles from each device in a given process may only be opened by one context per\n device per other process.\n\n Memory returned from ::hipIpcOpenMemHandle must be freed with ::hipIpcCloseMemHandle.\n\n Calling ::hipFree on an exported memory region before calling ::hipIpcCloseMemHandle in the\n importing context will result in undefined behavior.\n\n @param devPtr - Returned device pointer\n @param handle - hipIpcMemHandle to open\n @param flags  - Flags for this operation. Must be specified as hipIpcMemLazyEnablePeerAccess\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidContext,\n #hipErrorInvalidDevicePointer\n\n @note During multiple processes, using the same memory handle opened by the current context,\n there is no guarantee that the same device pointer will be returned in @p *devPtr.\n This is diffrent from CUDA.\n\n @note This IPC memory related feature API on Windows may behave differently from Linux.\n"]
    pub fn hipIpcOpenMemHandle(
        devPtr: *mut *mut ::std::os::raw::c_void,
        handle: hipIpcMemHandle_t,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Close memory mapped with ::hipIpcOpenMemHandle\n\n Unmaps memory returned by ::hipIpcOpenMemHandle. The original allocation in the exporting\n process as well as imported mappings in other processes will be unaffected.\n\n Any resources used to enable peer access will be freed if this is the last mapping using them.\n\n @param devPtr - Device pointer returned by ::hipIpcOpenMemHandle\n\n @returns #hipSuccess, #hipErrorMapFailed, #hipErrorInvalidHandle\n\n @note This IPC memory related feature API on Windows may behave differently from Linux.\n"]
    pub fn hipIpcCloseMemHandle(devPtr: *mut ::std::os::raw::c_void) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets an opaque interprocess handle for an event.\n\n The event is previously allocated with #hipEventInterprocess and #hipEventDisableTiming flags.\n The opaque interprocess handle may be copied into other processes and opened with\n ::hipIpcOpenEventHandle. Then ::hipEventRecord, ::hipEventSynchronize, ::hipStreamWaitEvent and\n ::hipEventQuery may be used in either process. After the exported event has been freed with\n ::hipEventDestroy, operations on the imported event will result in undefined behavior.\n\n @param[out]  handle Pointer to #hipIpcEventHandle to return the opaque event handle\n @param[in]   event  Event allocated with #hipEventInterprocess and #hipEventDisableTiming flags\n\n @returns #hipSuccess, #hipErrorInvalidConfiguration, #hipErrorInvalidValue\n\n @note This IPC event related feature API is currently applicable on Linux.\n"]
    pub fn hipIpcGetEventHandle(handle: *mut hipIpcEventHandle_t, event: hipEvent_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Opens an interprocess event handle.\n\n Opens an interprocess event handle exported from another process with ::hipIpcGetEventHandle.\n The returned #hipEvent_t behaves like a locally created event with the #hipEventDisableTiming\n flag specified. This event needs be freed with ::hipEventDestroy. After the exported event\n has been freed with ::hipEventDestroy, operations on the imported event will result in\n undefined behavior. If the input handle is from the same process, it will return\n #hipErrorInvalidContext.\n\n @param[out]  event  Pointer to hipEvent_t to return the imported event\n @param[in]   handle The opaque interprocess handle to open\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidContext\n\n @note This IPC event related feature API is currently applicable on Linux.\n"]
    pub fn hipIpcOpenEventHandle(event: *mut hipEvent_t, handle: hipIpcEventHandle_t)
        -> hipError_t;
}
extern "C" {
    #[doc = " @}\n/\n/**\n\n  @defgroup Execution Execution Control\n  @{\n  This section describes the execution control functions of HIP runtime API.\n\n/\n/**\n @brief Set attribute for a specific function\n\n @param [in] func Pointer of the function\n @param [in] attr Attribute to set\n @param [in] value Value to set\n\n @returns #hipSuccess, #hipErrorInvalidDeviceFunction, #hipErrorInvalidValue\n\n Note: AMD devices and some Nvidia GPUS do not support shared cache banking, and the hint is\n ignored on those architectures.\n"]
    pub fn hipFuncSetAttribute(
        func: *const ::std::os::raw::c_void,
        attr: hipFuncAttribute,
        value: ::std::os::raw::c_int,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Set Cache configuration for a specific function\n\n @param [in] func Pointer of the function.\n @param [in] config Configuration to set.\n\n @returns #hipSuccess, #hipErrorNotInitialized\n Note: AMD devices and some Nvidia GPUS do not support reconfigurable cache.  This hint is ignored\n on those architectures.\n"]
    pub fn hipFuncSetCacheConfig(
        func: *const ::std::os::raw::c_void,
        config: hipFuncCache_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Set shared memory configuation for a specific function\n\n @param [in] func Pointer of the function\n @param [in] config Configuration\n\n @returns #hipSuccess, #hipErrorInvalidDeviceFunction, #hipErrorInvalidValue\n\n Note: AMD devices and some Nvidia GPUS do not support shared cache banking, and the hint is\n ignored on those architectures.\n"]
    pub fn hipFuncSetSharedMemConfig(
        func: *const ::std::os::raw::c_void,
        config: hipSharedMemConfig,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @}\n/\n/**\n-------------------------------------------------------------------------------------------------\n-------------------------------------------------------------------------------------------------\n  @defgroup Error Error Handling\n  @{\n  This section describes the error handling functions of HIP runtime API.\n/\n/**\n @brief Return last error returned by any HIP runtime API call and resets the stored error code to\n #hipSuccess\n\n @returns return code from last HIP called from the active host thread\n\n Returns the last error that has been returned by any of the runtime calls in the same host\n thread, and then resets the saved error to #hipSuccess.\n\n @see hipGetErrorString, hipGetLastError, hipPeakAtLastError, hipError_t"]
    pub fn hipGetLastError() -> hipError_t;
}
extern "C" {
    #[doc = " @brief Return last error returned by any HIP runtime API call and resets the stored error code to\n #hipSuccess\n\n @returns return code from last HIP called from the active host thread\n\n Returns the last error that has been returned by any of the runtime calls in the same host\n thread, and then resets the saved error to #hipSuccess.\n\n @see hipGetErrorString, hipGetLastError, hipPeakAtLastError, hipError_t"]
    pub fn hipExtGetLastError() -> hipError_t;
}
extern "C" {
    #[doc = " @brief Return last error returned by any HIP runtime API call.\n\n @returns #hipSuccess\n\n Returns the last error that has been returned by any of the runtime calls in the same host\n thread. Unlike hipGetLastError, this function does not reset the saved error code.\n\n @see hipGetErrorString, hipGetLastError, hipPeakAtLastError, hipError_t"]
    pub fn hipPeekAtLastError() -> hipError_t;
}
extern "C" {
    #[doc = " @brief Return hip error as text string form.\n\n @param hip_error Error code to convert to name.\n @returns const char pointer to the NULL-terminated error name\n\n @see hipGetErrorString, hipGetLastError, hipPeakAtLastError, hipError_t"]
    pub fn hipGetErrorName(hip_error: hipError_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " @brief Return handy text string message to explain the error which occurred\n\n @param hipError Error code to convert to string.\n @returns const char pointer to the NULL-terminated error string\n\n @see hipGetErrorName, hipGetLastError, hipPeakAtLastError, hipError_t"]
    pub fn hipGetErrorString(hipError: hipError_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " @brief Return hip error as text string form.\n\n @param [in] hipError Error code to convert to string.\n @param [out] errorString char pointer to the NULL-terminated error string\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @see hipGetErrorName, hipGetLastError, hipPeakAtLastError, hipError_t"]
    pub fn hipDrvGetErrorName(
        hipError: hipError_t,
        errorString: *mut *const ::std::os::raw::c_char,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Return handy text string message to explain the error which occurred\n\n @param [in] hipError Error code to convert to string.\n @param [out] errorString char pointer to the NULL-terminated error string\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @see hipGetErrorName, hipGetLastError, hipPeakAtLastError, hipError_t"]
    pub fn hipDrvGetErrorString(
        hipError: hipError_t,
        errorString: *mut *const ::std::os::raw::c_char,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Create an asynchronous stream.\n\n @param[in, out] stream Valid pointer to hipStream_t.  This function writes the memory with the\n newly created stream.\n @returns #hipSuccess, #hipErrorInvalidValue\n\n Create a new asynchronous stream.  @p stream returns an opaque handle that can be used to\n reference the newly created stream in subsequent hipStream* commands.  The stream is allocated on\n the heap and will remain allocated even if the handle goes out-of-scope.  To release the memory\n used by the stream, application must call hipStreamDestroy.\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @see hipStreamCreateWithFlags, hipStreamCreateWithPriority, hipStreamSynchronize, hipStreamWaitEvent, hipStreamDestroy"]
    pub fn hipStreamCreate(stream: *mut hipStream_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Create an asynchronous stream.\n\n @param[in, out] stream Pointer to new stream\n @param[in ] flags to control stream creation.\n @returns #hipSuccess, #hipErrorInvalidValue\n\n Create a new asynchronous stream.  @p stream returns an opaque handle that can be used to\n reference the newly created stream in subsequent hipStream* commands.  The stream is allocated on\n the heap and will remain allocated even if the handle goes out-of-scope.  To release the memory\n used by the stream, application must call hipStreamDestroy. Flags controls behavior of the\n stream.  See #hipStreamDefault, #hipStreamNonBlocking.\n\n\n @see hipStreamCreate, hipStreamCreateWithPriority, hipStreamSynchronize, hipStreamWaitEvent, hipStreamDestroy"]
    pub fn hipStreamCreateWithFlags(
        stream: *mut hipStream_t,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Create an asynchronous stream with the specified priority.\n\n @param[in, out] stream Pointer to new stream\n @param[in ] flags to control stream creation.\n @param[in ] priority of the stream. Lower numbers represent higher priorities.\n @returns #hipSuccess, #hipErrorInvalidValue\n\n Create a new asynchronous stream with the specified priority.  @p stream returns an opaque handle\n that can be used to reference the newly created stream in subsequent hipStream* commands.  The\n stream is allocated on the heap and will remain allocated even if the handle goes out-of-scope.\n To release the memory used by the stream, application must call hipStreamDestroy. Flags controls\n behavior of the stream.  See #hipStreamDefault, #hipStreamNonBlocking.\n\n\n @see hipStreamCreate, hipStreamSynchronize, hipStreamWaitEvent, hipStreamDestroy"]
    pub fn hipStreamCreateWithPriority(
        stream: *mut hipStream_t,
        flags: ::std::os::raw::c_uint,
        priority: ::std::os::raw::c_int,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns numerical values that correspond to the least and greatest stream priority.\n\n @param[in, out] leastPriority pointer in which value corresponding to least priority is returned.\n @param[in, out] greatestPriority pointer in which value corresponding to greatest priority is returned.\n @returns #hipSuccess\n\n Returns in *leastPriority and *greatestPriority the numerical values that correspond to the least\n and greatest stream priority respectively. Stream priorities follow a convention where lower numbers\n imply greater priorities. The range of meaningful stream priorities is given by\n [*greatestPriority, *leastPriority]. If the user attempts to create a stream with a priority value\n that is outside the meaningful range as specified by this API, the priority is automatically\n clamped to within the valid range."]
    pub fn hipDeviceGetStreamPriorityRange(
        leastPriority: *mut ::std::os::raw::c_int,
        greatestPriority: *mut ::std::os::raw::c_int,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Destroys the specified stream.\n\n @param[in] stream stream identifier.\n @returns #hipSuccess #hipErrorInvalidHandle\n\n Destroys the specified stream.\n\n If commands are still executing on the specified stream, some may complete execution before the\n queue is deleted.\n\n The queue may be destroyed while some commands are still inflight, or may wait for all commands\n queued to the stream before destroying it.\n\n @see hipStreamCreate, hipStreamCreateWithFlags, hipStreamCreateWithPriority, hipStreamQuery,\n hipStreamWaitEvent, hipStreamSynchronize"]
    pub fn hipStreamDestroy(stream: hipStream_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Return #hipSuccess if all of the operations in the specified @p stream have completed, or\n #hipErrorNotReady if not.\n\n @param[in] stream stream to query\n\n @returns #hipSuccess, #hipErrorNotReady, #hipErrorInvalidHandle\n\n This is thread-safe and returns a snapshot of the current state of the queue.  However, if other\n host threads are sending work to the stream, the status may change immediately after the function\n is called.  It is typically used for debug.\n\n @see hipStreamCreate, hipStreamCreateWithFlags, hipStreamCreateWithPriority, hipStreamWaitEvent,\n hipStreamSynchronize, hipStreamDestroy"]
    pub fn hipStreamQuery(stream: hipStream_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Wait for all commands in stream to complete.\n\n @param[in] stream stream identifier.\n\n @returns #hipSuccess, #hipErrorInvalidHandle\n\n This command is host-synchronous : the host will block until the specified stream is empty.\n\n This command follows standard null-stream semantics.  Specifically, specifying the null stream\n will cause the command to wait for other streams on the same device to complete all pending\n operations.\n\n This command honors the hipDeviceLaunchBlocking flag, which controls whether the wait is active\n or blocking.\n\n @see hipStreamCreate, hipStreamCreateWithFlags, hipStreamCreateWithPriority, hipStreamWaitEvent,\n hipStreamDestroy\n"]
    pub fn hipStreamSynchronize(stream: hipStream_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Make the specified compute stream wait for an event\n\n @param[in] stream stream to make wait.\n @param[in] event event to wait on\n @param[in] flags control operation [must be 0]\n\n @returns #hipSuccess, #hipErrorInvalidHandle\n\n This function inserts a wait operation into the specified stream.\n All future work submitted to @p stream will wait until @p event reports completion before\n beginning execution.\n\n This function only waits for commands in the current stream to complete.  Notably, this function\n does not implicitly wait for commands in the default stream to complete, even if the specified\n stream is created with hipStreamNonBlocking = 0.\n\n @see hipStreamCreate, hipStreamCreateWithFlags, hipStreamCreateWithPriority, hipStreamSynchronize, hipStreamDestroy"]
    pub fn hipStreamWaitEvent(
        stream: hipStream_t,
        event: hipEvent_t,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Return flags associated with this stream.\n\n @param[in] stream stream to be queried\n @param[in,out] flags Pointer to an unsigned integer in which the stream's flags are returned\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidHandle\n\n @returns #hipSuccess #hipErrorInvalidValue #hipErrorInvalidHandle\n\n Return flags associated with this stream in *@p flags.\n\n @see hipStreamCreateWithFlags"]
    pub fn hipStreamGetFlags(stream: hipStream_t, flags: *mut ::std::os::raw::c_uint)
        -> hipError_t;
}
extern "C" {
    #[doc = " @brief Query the priority of a stream.\n\n @param[in] stream stream to be queried\n @param[in,out] priority Pointer to an unsigned integer in which the stream's priority is returned\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidHandle\n\n @returns #hipSuccess #hipErrorInvalidValue #hipErrorInvalidHandle\n\n Query the priority of a stream. The priority is returned in in priority.\n\n @see hipStreamCreateWithFlags"]
    pub fn hipStreamGetPriority(
        stream: hipStream_t,
        priority: *mut ::std::os::raw::c_int,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Get the device assocaited with the stream\n\n @param[in] stream stream to be queried\n @param[out] device device associated with the stream\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorContextIsDestroyed, #hipErrorInvalidHandle,\n #hipErrorNotInitialized, #hipErrorDeinitialized, #hipErrorInvalidContext\n\n @see hipStreamCreate, hipStreamDestroy, hipDeviceGetStreamPriorityRange"]
    pub fn hipStreamGetDevice(stream: hipStream_t, device: *mut hipDevice_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Create an asynchronous stream with the specified CU mask.\n\n @param[in, out] stream Pointer to new stream\n @param[in ] cuMaskSize Size of CU mask bit array passed in.\n @param[in ] cuMask Bit-vector representing the CU mask. Each active bit represents using one CU.\n The first 32 bits represent the first 32 CUs, and so on. If its size is greater than physical\n CU number (i.e., multiProcessorCount member of hipDeviceProp_t), the extra elements are ignored.\n It is user's responsibility to make sure the input is meaningful.\n @returns #hipSuccess, #hipErrorInvalidHandle, #hipErrorInvalidValue\n\n Create a new asynchronous stream with the specified CU mask.  @p stream returns an opaque handle\n that can be used to reference the newly created stream in subsequent hipStream* commands.  The\n stream is allocated on the heap and will remain allocated even if the handle goes out-of-scope.\n To release the memory used by the stream, application must call hipStreamDestroy.\n\n\n @see hipStreamCreate, hipStreamSynchronize, hipStreamWaitEvent, hipStreamDestroy"]
    pub fn hipExtStreamCreateWithCUMask(
        stream: *mut hipStream_t,
        cuMaskSize: u32,
        cuMask: *const u32,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Get CU mask associated with an asynchronous stream\n\n @param[in] stream stream to be queried\n @param[in] cuMaskSize number of the block of memories (uint32_t *) allocated by user\n @param[out] cuMask Pointer to a pre-allocated block of memories (uint32_t *) in which\n the stream's CU mask is returned. The CU mask is returned in a chunck of 32 bits where\n each active bit represents one active CU\n @returns #hipSuccess, #hipErrorInvalidHandle, #hipErrorInvalidValue\n\n @see hipStreamCreate, hipStreamSynchronize, hipStreamWaitEvent, hipStreamDestroy"]
    pub fn hipExtStreamGetCUMask(
        stream: hipStream_t,
        cuMaskSize: u32,
        cuMask: *mut u32,
    ) -> hipError_t;
}
#[doc = " Stream CallBack struct"]
pub type hipStreamCallback_t = ::std::option::Option<
    unsafe extern "C" fn(
        stream: hipStream_t,
        status: hipError_t,
        userData: *mut ::std::os::raw::c_void,
    ),
>;
extern "C" {
    #[doc = " @brief Adds a callback to be called on the host after all currently enqueued\n items in the stream have completed.  For each\n hipStreamAddCallback call, a callback will be executed exactly once.\n The callback will block later work in the stream until it is finished.\n @param[in] stream   - Stream to add callback to\n @param[in] callback - The function to call once preceding stream operations are complete\n @param[in] userData - User specified data to be passed to the callback function\n @param[in] flags    - Reserved for future use, must be 0\n @returns #hipSuccess, #hipErrorInvalidHandle, #hipErrorNotSupported\n\n @see hipStreamCreate, hipStreamCreateWithFlags, hipStreamQuery, hipStreamSynchronize,\n hipStreamWaitEvent, hipStreamDestroy, hipStreamCreateWithPriority\n"]
    pub fn hipStreamAddCallback(
        stream: hipStream_t,
        callback: hipStreamCallback_t,
        userData: *mut ::std::os::raw::c_void,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Enqueues a wait command to the stream.[BETA]\n\n @param [in] stream - Stream identifier\n @param [in] ptr    - Pointer to memory object allocated using #hipMallocSignalMemory flag\n @param [in] value  - Value to be used in compare operation\n @param [in] flags  - Defines the compare operation, supported values are #hipStreamWaitValueGte\n #hipStreamWaitValueEq, #hipStreamWaitValueAnd and #hipStreamWaitValueNor\n @param [in] mask   - Mask to be applied on value at memory before it is compared with value,\n default value is set to enable every bit\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n Enqueues a wait command to the stream, all operations enqueued  on this stream after this, will\n not execute until the defined wait condition is true.\n\n #hipStreamWaitValueGte: waits until *ptr&mask >= value\n\n #hipStreamWaitValueEq : waits until *ptr&mask == value\n\n #hipStreamWaitValueAnd: waits until ((*ptr&mask) & value) != 0\n\n #hipStreamWaitValueNor: waits until ~((*ptr&mask) | (value&mask)) != 0\n\n @note when using #hipStreamWaitValueNor, mask is applied on both 'value' and '*ptr'.\n\n @note Support for #hipStreamWaitValue32 can be queried using 'hipDeviceGetAttribute()' and\n 'hipDeviceAttributeCanUseStreamWaitValue' flag.\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @see hipExtMallocWithFlags, hipFree, hipStreamWaitValue64, hipStreamWriteValue64,\n hipStreamWriteValue32, hipDeviceGetAttribute"]
    pub fn hipStreamWaitValue32(
        stream: hipStream_t,
        ptr: *mut ::std::os::raw::c_void,
        value: u32,
        flags: ::std::os::raw::c_uint,
        mask: u32,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Enqueues a wait command to the stream.[BETA]\n\n @param [in] stream - Stream identifier\n @param [in] ptr    - Pointer to memory object allocated using 'hipMallocSignalMemory' flag\n @param [in] value  - Value to be used in compare operation\n @param [in] flags  - Defines the compare operation, supported values are #hipStreamWaitValueGte\n #hipStreamWaitValueEq, #hipStreamWaitValueAnd and #hipStreamWaitValueNor.\n @param [in] mask   - Mask to be applied on value at memory before it is compared with value\n default value is set to enable every bit\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n Enqueues a wait command to the stream, all operations enqueued  on this stream after this, will\n not execute until the defined wait condition is true.\n\n #hipStreamWaitValueGte: waits until *ptr&mask >= value\n\n #hipStreamWaitValueEq : waits until *ptr&mask == value\n\n #hipStreamWaitValueAnd: waits until ((*ptr&mask) & value) != 0\n\n #hipStreamWaitValueNor: waits until ~((*ptr&mask) | (value&mask)) != 0\n\n @note when using #hipStreamWaitValueNor, mask is applied on both 'value' and '*ptr'.\n\n @note Support for hipStreamWaitValue64 can be queried using 'hipDeviceGetAttribute()' and\n 'hipDeviceAttributeCanUseStreamWaitValue' flag.\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @see hipExtMallocWithFlags, hipFree, hipStreamWaitValue32, hipStreamWriteValue64,\n hipStreamWriteValue32, hipDeviceGetAttribute"]
    pub fn hipStreamWaitValue64(
        stream: hipStream_t,
        ptr: *mut ::std::os::raw::c_void,
        value: u64,
        flags: ::std::os::raw::c_uint,
        mask: u64,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Enqueues a write command to the stream.[BETA]\n\n @param [in] stream - Stream identifier\n @param [in] ptr    - Pointer to a GPU accessible memory object\n @param [in] value  - Value to be written\n @param [in] flags  - reserved, ignored for now, will be used in future releases\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n Enqueues a write command to the stream, write operation is performed after all earlier commands\n on this stream have completed the execution.\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @see hipExtMallocWithFlags, hipFree, hipStreamWriteValue32, hipStreamWaitValue32,\n hipStreamWaitValue64"]
    pub fn hipStreamWriteValue32(
        stream: hipStream_t,
        ptr: *mut ::std::os::raw::c_void,
        value: u32,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Enqueues a write command to the stream.[BETA]\n\n @param [in] stream - Stream identifier\n @param [in] ptr    - Pointer to a GPU accessible memory object\n @param [in] value  - Value to be written\n @param [in] flags  - reserved, ignored for now, will be used in future releases\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n Enqueues a write command to the stream, write operation is performed after all earlier commands\n on this stream have completed the execution.\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @see hipExtMallocWithFlags, hipFree, hipStreamWriteValue32, hipStreamWaitValue32,\n hipStreamWaitValue64"]
    pub fn hipStreamWriteValue64(
        stream: hipStream_t,
        ptr: *mut ::std::os::raw::c_void,
        value: u64,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Enqueues an array of stream memory operations in the stream.[BETA]\n\n @param [in] stream      - Stream identifier\n @param [in] count       - The number of operations in the array. Must be less than 256\n @param [in] paramArray  - The types and parameters of the individual operations.\n @param [in] flags       - Reserved for future expansion; must be 0.\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n Batch operations to synchronize the stream via memory operations.\n\n @warning This API is marked as beta, meaning, while this is feature complete,\n it is still open to changes and may have outstanding issues.\n\n @see hipStreamWriteValue32, hipStreamWaitValue32,\n hipStreamWaitValue64. hipStreamWriteValue64"]
    pub fn hipStreamBatchMemOp(
        stream: hipStream_t,
        count: ::std::os::raw::c_uint,
        paramArray: *mut hipStreamBatchMemOpParams,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Creates a batch memory operation node and adds it to a graph.[BETA]\n\n @param [in] phGraphNode      - Returns the newly created node\n @param [in] hGraph           - Graph to which to add the node\n @param [in] dependencies     -  Dependencies of the node\n @param [in] numDependencies  - Number of dependencies\n @param [in] nodeParams       - Parameters for the node\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @warning This API is marked as beta, meaning, while this is feature complete,\n it is still open to changes and may have outstanding issues.\n\n @see hipStreamWriteValue32, hipStreamWaitValue32,\n hipStreamWaitValue64. hipStreamWriteValue64, hipStreamBatchMemOp"]
    pub fn hipGraphAddBatchMemOpNode(
        phGraphNode: *mut hipGraphNode_t,
        hGraph: hipGraph_t,
        dependencies: *const hipGraphNode_t,
        numDependencies: usize,
        nodeParams: *const hipBatchMemOpNodeParams,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns a batch mem op node's parameters.[BETA]\n\n @param [in] hNode           - Node to get the parameters for\n @param [in] nodeParams_out  - Pointer to return the parameters\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n Returns the parameters of batch mem op node hNode in nodeParams_out.\n The paramArray returned in nodeParams_out is owned by the node.\n This memory remains valid until the node is destroyed or its parameters are modified,\n and should not be modified directly.\n\n @warning This API is marked as beta, meaning, while this is feature complete,\n it is still open to changes and may have outstanding issues.\n\n @see hipStreamWriteValue32, hipStreamWaitValue32,\n hipStreamWaitValue64. hipStreamWriteValue64. hipGraphBatchMemOpNodeSetParams"]
    pub fn hipGraphBatchMemOpNodeGetParams(
        hNode: hipGraphNode_t,
        nodeParams_out: *mut hipBatchMemOpNodeParams,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets the batch mem op node's parameters.[BETA]\n\n @param [in] hNode       - Node to set the parameters for\n @param [in] nodeParams  - Parameters to copy\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n Sets the parameters of batch mem op node hNode to nodeParams.\n\n @warning This API is marked as beta, meaning, while this is feature complete,\n it is still open to changes and may have outstanding issues.\n\n @see hipStreamWriteValue32, hipStreamWaitValue32,\n hipStreamWaitValue64. hipStreamWriteValue64, hipGraphBatchMemOpNodeGetParams"]
    pub fn hipGraphBatchMemOpNodeSetParams(
        hNode: hipGraphNode_t,
        nodeParams: *mut hipBatchMemOpNodeParams,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets the parameters for a batch mem op node in the given graphExec.[BETA]\n\n @param [in] hGraphExec  - The executable graph in which to set the specified node\n @param [in] hNode       - Batch mem op node from the graph from which graphExec was instantiated\n @param [in] nodeParams  - Updated Parameters to set\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n Sets the parameters of a batch mem op node in an executable graph hGraphExec.\n The node is identified by the corresponding node hNode in the non-executable graph,\n from which the executable graph was instantiated.\n\n @warning This API is marked as beta, meaning, while this is feature complete,\n it is still open to changes and may have outstanding issues.\n\n @see hipStreamWriteValue32, hipStreamWaitValue32,\n hipStreamWaitValue64. hipStreamWriteValue64, hipStreamBatchMemOp"]
    pub fn hipGraphExecBatchMemOpNodeSetParams(
        hGraphExec: hipGraphExec_t,
        hNode: hipGraphNode_t,
        nodeParams: *const hipBatchMemOpNodeParams,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @}\n/\n/**\n-------------------------------------------------------------------------------------------------\n-------------------------------------------------------------------------------------------------\n  @defgroup Event Event Management\n  @{\n  This section describes the event management functions of HIP runtime API.\n/\n/**\n @brief Create an event with the specified flags\n\n @param[in,out] event Returns the newly created event.\n @param[in] flags     Flags to control event behavior.  Valid values are #hipEventDefault,\n#hipEventBlockingSync, #hipEventDisableTiming, #hipEventInterprocess\n #hipEventDefault : Default flag.  The event will use active synchronization and will support\ntiming.  Blocking synchronization provides lowest possible latency at the expense of dedicating a\nCPU to poll on the event.\n #hipEventBlockingSync : The event will use blocking synchronization : if hipEventSynchronize is\ncalled on this event, the thread will block until the event completes.  This can increase latency\nfor the synchroniation but can result in lower power and more resources for other CPU threads.\n #hipEventDisableTiming : Disable recording of timing information. Events created with this flag\nwould not record profiling data and provide best performance if used for synchronization.\n #hipEventInterprocess : The event can be used as an interprocess event. hipEventDisableTiming\nflag also must be set when hipEventInterprocess flag is set.\n #hipEventDisableSystemFence : Disable acquire and release system scope fence. This may\nimprove performance but device memory may not be visible to the host and other devices\nif this flag is set.\n\n @returns #hipSuccess, #hipErrorNotInitialized, #hipErrorInvalidValue,\n#hipErrorLaunchFailure, #hipErrorOutOfMemory\n\n @see hipEventCreate, hipEventSynchronize, hipEventDestroy, hipEventElapsedTime"]
    pub fn hipEventCreateWithFlags(
        event: *mut hipEvent_t,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  Create an event\n\n @param[in,out] event Returns the newly created event.\n\n @returns #hipSuccess, #hipErrorNotInitialized, #hipErrorInvalidValue,\n #hipErrorLaunchFailure, #hipErrorOutOfMemory\n\n @see hipEventCreateWithFlags, hipEventRecord, hipEventQuery, hipEventSynchronize,\n hipEventDestroy, hipEventElapsedTime"]
    pub fn hipEventCreate(event: *mut hipEvent_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Record an event in the specified stream.\n\n @param[in] event event to record.\n @param[in] stream stream in which to record event.\n @param[in] flags parameter for operations\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotInitialized,\n #hipErrorInvalidHandle, #hipErrorLaunchFailure\n\n hipEventQuery() or hipEventSynchronize() must be used to determine when the event\n transitions from \"recording\" (after hipEventRecord() is called) to \"recorded\"\n (when timestamps are set, if requested).\n\n Events which are recorded in a non-NULL stream will transition to\n from recording to \"recorded\" state when they reach the head of\n the specified stream, after all previous\n commands in that stream have completed executing.\n\n Flags include:\n   hipEventRecordDefault: Default event creation flag.\n   hipEventRecordExternal: Event is captured in the graph as an external event node when\n                           performing stream capture\n\n If hipEventRecord() has been previously called on this event, then this call will overwrite any\n existing state in event.\n\n If this function is called on an event that is currently being recorded, results are undefined\n - either outstanding recording may save state into the event, and the order is not guaranteed.\n\n @note: If this function is not called before use hipEventQuery() or hipEventSynchronize(),\n #hipSuccess is returned, meaning no pending event in the stream.\n\n @see hipEventCreate, hipEventCreateWithFlags, hipEventQuery, hipEventSynchronize,\n hipEventDestroy, hipEventElapsedTime\n"]
    pub fn hipEventRecordWithFlags(
        event: hipEvent_t,
        stream: hipStream_t,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    pub fn hipEventRecord(event: hipEvent_t, stream: hipStream_t) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Destroy the specified event.\n\n  @param[in] event Event to destroy.\n  @returns #hipSuccess, #hipErrorNotInitialized, #hipErrorInvalidValue,\n #hipErrorLaunchFailure\n\n  Releases memory associated with the event.  If the event is recording but has not completed\n recording when hipEventDestroy() is called, the function will return immediately and the\n completion_future resources will be released later, when the hipDevice is synchronized.\n\n @see hipEventCreate, hipEventCreateWithFlags, hipEventQuery, hipEventSynchronize, hipEventRecord,\n hipEventElapsedTime\n\n @returns #hipSuccess"]
    pub fn hipEventDestroy(event: hipEvent_t) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Wait for an event to complete.\n\n  This function will block until the event is ready, waiting for all previous work in the stream\n specified when event was recorded with hipEventRecord().\n\n  If hipEventRecord() has not been called on @p event, this function returns #hipSuccess when no\n  event is captured.\n\n\n  @param[in] event Event on which to wait.\n\n  @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotInitialized,\n #hipErrorInvalidHandle, #hipErrorLaunchFailure\n\n  @see hipEventCreate, hipEventCreateWithFlags, hipEventQuery, hipEventDestroy, hipEventRecord,\n hipEventElapsedTime"]
    pub fn hipEventSynchronize(event: hipEvent_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Return the elapsed time between two events.\n\n @param[out] ms : Return time between start and stop in ms.\n @param[in]   start : Start event.\n @param[in]   stop  : Stop event.\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotReady, #hipErrorInvalidHandle,\n #hipErrorNotInitialized, #hipErrorLaunchFailure\n\n Computes the elapsed time between two events. Time is computed in ms, with\n a resolution of approximately 1 us.\n\n Events which are recorded in a NULL stream will block until all commands\n on all other streams complete execution, and then record the timestamp.\n\n Events which are recorded in a non-NULL stream will record their timestamp\n when they reach the head of the specified stream, after all previous\n commands in that stream have completed executing.  Thus the time that\n the event recorded may be significantly after the host calls hipEventRecord().\n\n If hipEventRecord() has not been called on either event, then #hipErrorInvalidHandle is\n returned. If hipEventRecord() has been called on both events, but the timestamp has not yet been\n recorded on one or both events (that is, hipEventQuery() would return #hipErrorNotReady on at\n least one of the events), then #hipErrorNotReady is returned.\n\n @see hipEventCreate, hipEventCreateWithFlags, hipEventQuery, hipEventDestroy, hipEventRecord,\n hipEventSynchronize"]
    pub fn hipEventElapsedTime(ms: *mut f32, start: hipEvent_t, stop: hipEvent_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Query event status\n\n @param[in] event Event to query.\n @returns #hipSuccess, #hipErrorNotReady, #hipErrorInvalidHandle, #hipErrorInvalidValue,\n #hipErrorNotInitialized, #hipErrorLaunchFailure\n\n Query the status of the specified event.  This function will return #hipSuccess if all\n commands in the appropriate stream (specified to hipEventRecord()) have completed.  If any execution\n has not completed, then #hipErrorNotReady is returned.\n\n @note This API returns #hipSuccess, if hipEventRecord() is not called before this API.\n\n @see hipEventCreate, hipEventCreateWithFlags, hipEventRecord, hipEventDestroy,\n hipEventSynchronize, hipEventElapsedTime"]
    pub fn hipEventQuery(event: hipEvent_t) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Sets information on the specified pointer.[BETA]\n\n  @param [in]      value     Sets pointer attribute value\n  @param [in]      attribute  Attribute to set\n  @param [in]      ptr      Pointer to set attributes for\n\n  @returns #hipSuccess, #hipErrorInvalidDevice, #hipErrorInvalidValue\n\n  @warning This API is marked as Beta. While this feature is complete, it can\n           change and might have outstanding issues.\n"]
    pub fn hipPointerSetAttribute(
        value: *const ::std::os::raw::c_void,
        attribute: hipPointer_attribute,
        ptr: hipDeviceptr_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Returns attributes for the specified pointer\n\n  @param [out]  attributes  attributes for the specified pointer\n  @param [in]   ptr         pointer to get attributes for\n\n  The output parameter 'attributes' has a member named 'type' that describes what memory the\n  pointer is associated with, such as device memory, host memory, managed memory, and others.\n  Otherwise, the API cannot handle the pointer and returns #hipErrorInvalidValue.\n\n  @note  The unrecognized memory type is unsupported to keep the HIP functionality backward\n  compatibility due to #hipMemoryType enum values.\n\n  @returns #hipSuccess, #hipErrorInvalidDevice, #hipErrorInvalidValue\n\n  @note  The current behavior of this HIP API corresponds to the CUDA API before version 11.0.\n\n  @see hipPointerGetAttribute"]
    pub fn hipPointerGetAttributes(
        attributes: *mut hipPointerAttribute_t,
        ptr: *const ::std::os::raw::c_void,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Returns information about the specified pointer.[BETA]\n\n  @param [in, out] data     Returned pointer attribute value\n  @param [in]      attribute  Attribute to query for\n  @param [in]      ptr      Pointer to get attributes for\n\n  @returns #hipSuccess, #hipErrorInvalidDevice, #hipErrorInvalidValue\n\n  @warning This API is marked as Beta. While this feature is complete, it can\n           change and might have outstanding issues.\n\n  @see hipPointerGetAttributes"]
    pub fn hipPointerGetAttribute(
        data: *mut ::std::os::raw::c_void,
        attribute: hipPointer_attribute,
        ptr: hipDeviceptr_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Returns information about the specified pointer.[BETA]\n\n  @param [in]  numAttributes   number of attributes to query for\n  @param [in]  attributes      attributes to query for\n  @param [in, out] data        a two-dimensional containing pointers to memory locations\n                               where the result of each attribute query will be written to\n  @param [in]  ptr             pointer to get attributes for\n\n  @returns #hipSuccess, #hipErrorInvalidDevice, #hipErrorInvalidValue\n\n  @warning This API is marked as Beta. While this feature is complete, it can\n           change and might have outstanding issues.\n\n  @see hipPointerGetAttribute"]
    pub fn hipDrvPointerGetAttributes(
        numAttributes: ::std::os::raw::c_uint,
        attributes: *mut hipPointer_attribute,
        data: *mut *mut ::std::os::raw::c_void,
        ptr: hipDeviceptr_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "-------------------------------------------------------------------------------------------------\n-------------------------------------------------------------------------------------------------\n  @defgroup External External Resource Interoperability\n  @{\n  @ingroup API\n\n  This section describes the external resource interoperability functions of HIP runtime API.\n\n/\n/**\n  @brief Imports an external semaphore.\n\n  @param[out] extSem_out  External semaphores to be waited on\n  @param[in] semHandleDesc Semaphore import handle descriptor\n\n  @returns #hipSuccess, #hipErrorInvalidDevice, #hipErrorInvalidValue\n\n  @see\n\n  @note  This API is currently not supported on Linux.\n"]
    pub fn hipImportExternalSemaphore(
        extSem_out: *mut hipExternalSemaphore_t,
        semHandleDesc: *const hipExternalSemaphoreHandleDesc,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Signals a set of external semaphore objects.\n\n  @param[in] extSemArray  External semaphores to be waited on\n  @param[in] paramsArray Array of semaphore parameters\n  @param[in] numExtSems Number of semaphores to wait on\n  @param[in] stream Stream to enqueue the wait operations in\n\n  @returns #hipSuccess, #hipErrorInvalidDevice, #hipErrorInvalidValue\n\n  @see\n\n  @note  This API is currently not supported on Linux.\n"]
    pub fn hipSignalExternalSemaphoresAsync(
        extSemArray: *const hipExternalSemaphore_t,
        paramsArray: *const hipExternalSemaphoreSignalParams,
        numExtSems: ::std::os::raw::c_uint,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Waits on a set of external semaphore objects\n\n  @param[in] extSemArray  External semaphores to be waited on\n  @param[in] paramsArray Array of semaphore parameters\n  @param[in] numExtSems Number of semaphores to wait on\n  @param[in] stream Stream to enqueue the wait operations in\n\n  @returns #hipSuccess, #hipErrorInvalidDevice, #hipErrorInvalidValue\n\n  @see\n\n  @note  This API is currently not supported on Linux.\n"]
    pub fn hipWaitExternalSemaphoresAsync(
        extSemArray: *const hipExternalSemaphore_t,
        paramsArray: *const hipExternalSemaphoreWaitParams,
        numExtSems: ::std::os::raw::c_uint,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Destroys an external semaphore object and releases any references to the underlying resource. Any outstanding signals or waits must have completed before the semaphore is destroyed.\n\n  @param[in] extSem handle to an external memory object\n\n  @returns #hipSuccess, #hipErrorInvalidDevice, #hipErrorInvalidValue\n\n  @see\n\n  @note  This API is currently not supported on Linux.\n"]
    pub fn hipDestroyExternalSemaphore(extSem: hipExternalSemaphore_t) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Imports an external memory object.\n\n  @param[out] extMem_out  Returned handle to an external memory object\n  @param[in]  memHandleDesc Memory import handle descriptor\n\n  @returns #hipSuccess, #hipErrorInvalidDevice, #hipErrorInvalidValue\n\n  @see"]
    pub fn hipImportExternalMemory(
        extMem_out: *mut hipExternalMemory_t,
        memHandleDesc: *const hipExternalMemoryHandleDesc,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Maps a buffer onto an imported memory object.\n\n  @param[out] devPtr Returned device pointer to buffer\n  @param[in]  extMem  Handle to external memory object\n  @param[in]  bufferDesc  Buffer descriptor\n\n  @returns #hipSuccess, #hipErrorInvalidDevice, #hipErrorInvalidValue\n\n  @see"]
    pub fn hipExternalMemoryGetMappedBuffer(
        devPtr: *mut *mut ::std::os::raw::c_void,
        extMem: hipExternalMemory_t,
        bufferDesc: *const hipExternalMemoryBufferDesc,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Destroys an external memory object.\n\n  @param[in] extMem  External memory object to be destroyed\n\n  @returns #hipSuccess, #hipErrorInvalidDevice, #hipErrorInvalidValue\n\n  @see"]
    pub fn hipDestroyExternalMemory(extMem: hipExternalMemory_t) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Maps a mipmapped array onto an external memory object.\n\n  @param[out] mipmap mipmapped array to return\n  @param[in]  extMem external memory object handle\n  @param[in]  mipmapDesc external mipmapped array descriptor\n\n  Returned mipmapped array must be freed using hipFreeMipmappedArray.\n\n  @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidResourceHandle\n\n  @see hipImportExternalMemory, hipDestroyExternalMemory, hipExternalMemoryGetMappedBuffer, hipFreeMipmappedArray"]
    pub fn hipExternalMemoryGetMappedMipmappedArray(
        mipmap: *mut hipMipmappedArray_t,
        extMem: hipExternalMemory_t,
        mipmapDesc: *const hipExternalMemoryMipmappedArrayDesc,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @}\n/\n/**\n  @brief Allocate memory on the default accelerator\n\n  @param[out] ptr Pointer to the allocated memory\n  @param[in]  size Requested memory size\n\n  If size is 0, no memory is allocated, *ptr returns nullptr, and hipSuccess is returned.\n\n  @returns #hipSuccess, #hipErrorOutOfMemory, #hipErrorInvalidValue (bad context, null *ptr)\n\n  @see hipMallocPitch, hipFree, hipMallocArray, hipFreeArray, hipMalloc3D, hipMalloc3DArray,\n hipHostFree, hipHostMalloc"]
    pub fn hipMalloc(ptr: *mut *mut ::std::os::raw::c_void, size: usize) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Allocate memory on the default accelerator\n\n  @param[out] ptr  Pointer to the allocated memory\n  @param[in]  sizeBytes  Requested memory size\n  @param[in]  flags  Type of memory allocation\n\n  If requested memory size is 0, no memory is allocated, *ptr returns nullptr, and #hipSuccess\n  is returned.\n\n  The memory allocation flag should be either #hipDeviceMallocDefault,\n  #hipDeviceMallocFinegrained, #hipDeviceMallocUncached, or #hipMallocSignalMemory.\n  If the flag is any other value, the API returns #hipErrorInvalidValue.\n\n  @returns #hipSuccess, #hipErrorOutOfMemory, #hipErrorInvalidValue (bad context, null *ptr)\n\n  @see hipMallocPitch, hipFree, hipMallocArray, hipFreeArray, hipMalloc3D, hipMalloc3DArray,\n hipHostFree, hiHostMalloc"]
    pub fn hipExtMallocWithFlags(
        ptr: *mut *mut ::std::os::raw::c_void,
        sizeBytes: usize,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Allocate pinned host memory [Deprecated]\n\n  @param[out] ptr Pointer to the allocated host pinned memory\n  @param[in]  size Requested memory size\n\n  If size is 0, no memory is allocated, *ptr returns nullptr, and hipSuccess is returned.\n\n  @returns #hipSuccess, #hipErrorOutOfMemory\n\n  @warning  This API is deprecated, use hipHostMalloc() instead"]
    pub fn hipMallocHost(ptr: *mut *mut ::std::os::raw::c_void, size: usize) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Allocate pinned host memory [Deprecated]\n\n  @param[out] ptr Pointer to the allocated host pinned memory\n  @param[in]  size Requested memory size\n\n  If size is 0, no memory is allocated, *ptr returns nullptr, and hipSuccess is returned.\n\n  @returns #hipSuccess, #hipErrorOutOfMemory\n\n  @warning  This API is deprecated, use hipHostMalloc() instead"]
    pub fn hipMemAllocHost(ptr: *mut *mut ::std::os::raw::c_void, size: usize) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Allocates device accessible page locked (pinned) host memory\n\n  This API allocates pinned host memory which is mapped into the address space of all GPUs\n  in the system, the memory can be accessed directly by the GPU device, and can be read or\n  written with much higher bandwidth than pageable memory obtained with functions such as\n  malloc().\n\n  Using the pinned host memory, applications can implement faster data transfers for HostToDevice\n  and DeviceToHost. The runtime tracks the hipHostMalloc allocations and can avoid some of the\n  setup required for regular unpinned memory.\n\n  When the memory accesses are infrequent, zero-copy memory can be a good choice, for coherent\n  allocation. GPU can directly access the host memory over the CPU/GPU interconnect, without need\n  to copy the data.\n\n  Currently the allocation granularity is 4KB for the API.\n\n  Developers need to choose proper allocation flag with consideration of synchronization.\n\n  @param[out] ptr Pointer to the allocated host pinned memory\n  @param[in]  size Requested memory size in bytes\n  If size is 0, no memory is allocated, *ptr returns nullptr, and hipSuccess is returned.\n  @param[in]  flags Type of host memory allocation. See the description of flags in\n  hipSetDeviceFlags.\n\n  If no input for flags, it will be the default pinned memory allocation on the host.\n\n  @returns #hipSuccess, #hipErrorOutOfMemory\n\n\n  @see hipSetDeviceFlags, hiptHostFree"]
    pub fn hipHostMalloc(
        ptr: *mut *mut ::std::os::raw::c_void,
        size: usize,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "-------------------------------------------------------------------------------------------------\n-------------------------------------------------------------------------------------------------\n  @defgroup MemoryM Managed Memory\n\n  @ingroup Memory\n @{\n  This section describes the managed memory management functions of HIP runtime API.\n\n  @note  The managed memory management APIs are implemented on Linux, under developement\n  on Windows.\n\n/\n/**\n @brief Allocates memory that will be automatically managed by HIP.\n\n This API is used for managed memory, allows data be shared and accessible to both CPU and\n GPU using a single pointer.\n\n The API returns the allocation pointer, managed by HMM, can be used further to execute kernels\n on device and fetch data between the host and device as needed.\n\n @note   It is recommend to do the capability check before call this API.\n\n @param [out] dev_ptr - pointer to allocated device memory\n @param [in]  size    - requested allocation size in bytes, it should be granularity of 4KB\n @param [in]  flags   - must be either hipMemAttachGlobal or hipMemAttachHost\n                        (defaults to hipMemAttachGlobal)\n\n @returns #hipSuccess, #hipErrorMemoryAllocation, #hipErrorNotSupported, #hipErrorInvalidValue\n"]
    pub fn hipMallocManaged(
        dev_ptr: *mut *mut ::std::os::raw::c_void,
        size: usize,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Prefetches memory to the specified destination device using HIP.\n\n @param [in] dev_ptr  pointer to be prefetched\n @param [in] count    size in bytes for prefetching\n @param [in] device   destination device to prefetch to\n @param [in] stream   stream to enqueue prefetch operation\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows."]
    pub fn hipMemPrefetchAsync(
        dev_ptr: *const ::std::os::raw::c_void,
        count: usize,
        device: ::std::os::raw::c_int,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Advise about the usage of a given memory range to HIP.\n\n @param [in] dev_ptr  pointer to memory to set the advice for\n @param [in] count    size in bytes of the memory range, it should be CPU page size alligned.\n @param [in] advice   advice to be applied for the specified memory range\n @param [in] device   device to apply the advice for\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n This HIP API advises about the usage to be applied on unified memory allocation in the\n range starting from the pointer address devPtr, with the size of count bytes.\n The memory range must refer to managed memory allocated via the API hipMallocManaged, and the\n range will be handled with proper round down and round up respectively in the driver to\n be aligned to CPU page size, the same way as corresponding CUDA API behaves in CUDA version 8.0\n and afterwards.\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows."]
    pub fn hipMemAdvise(
        dev_ptr: *const ::std::os::raw::c_void,
        count: usize,
        advice: hipMemoryAdvise,
        device: ::std::os::raw::c_int,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Query an attribute of a given memory range in HIP.\n\n @param [in,out] data   a pointer to a memory location where the result of each\n                        attribute query will be written to\n @param [in] data_size  the size of data\n @param [in] attribute  the attribute to query\n @param [in] dev_ptr    start of the range to query\n @param [in] count      size of the range to query\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows."]
    pub fn hipMemRangeGetAttribute(
        data: *mut ::std::os::raw::c_void,
        data_size: usize,
        attribute: hipMemRangeAttribute,
        dev_ptr: *const ::std::os::raw::c_void,
        count: usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Query attributes of a given memory range in HIP.\n\n @param [in,out] data     a two-dimensional array containing pointers to memory locations\n                          where the result of each attribute query will be written to\n @param [in] data_sizes   an array, containing the sizes of each result\n @param [in] attributes   the attribute to query\n @param [in] num_attributes  an array of attributes to query (numAttributes and the number\n                          of attributes in this array should match)\n @param [in] dev_ptr      start of the range to query\n @param [in] count        size of the range to query\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows."]
    pub fn hipMemRangeGetAttributes(
        data: *mut *mut ::std::os::raw::c_void,
        data_sizes: *mut usize,
        attributes: *mut hipMemRangeAttribute,
        num_attributes: usize,
        dev_ptr: *const ::std::os::raw::c_void,
        count: usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Attach memory to a stream asynchronously in HIP.\n\n @param [in] stream     - stream in which to enqueue the attach operation\n @param [in] dev_ptr    - pointer to memory (must be a pointer to managed memory or\n                          to a valid host-accessible region of system-allocated memory)\n @param [in] length     - length of memory (defaults to zero)\n @param [in] flags      - must be one of hipMemAttachGlobal, hipMemAttachHost or\n                          hipMemAttachSingle (defaults to hipMemAttachSingle)\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @warning This API is under development. Currently it is a no-operation (NOP)\n          function on AMD GPUs and returns #hipSuccess."]
    pub fn hipStreamAttachMemAsync(
        stream: hipStream_t,
        dev_ptr: *mut ::std::os::raw::c_void,
        length: usize,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Allocates memory with stream ordered semantics\n\n Inserts a memory allocation operation into @p stream.\n A pointer to the allocated memory is returned immediately in *dptr.\n The allocation must not be accessed until the allocation operation completes.\n The allocation comes from the memory pool associated with the stream's device.\n\n @note The default memory pool of a device contains device memory from that device.\n @note Basic stream ordering allows future work submitted into the same stream to use the\n  allocation. Stream query, stream synchronize, and HIP events can be used to guarantee that\n  the allocation operation completes before work submitted in a separate stream runs.\n @note During stream capture, this function results in the creation of an allocation node.\n  In this case, the allocation is owned by the graph instead of the memory pool. The memory\n  pool's properties are used to set the node's creation parameters.\n\n @param [out] dev_ptr  Returned device pointer of memory allocation\n @param [in] size      Number of bytes to allocate\n @param [in] stream    The stream establishing the stream ordering contract and\n                       the memory pool to allocate from\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported, #hipErrorOutOfMemory\n\n @see hipMallocFromPoolAsync, hipFreeAsync, hipMemPoolTrimTo, hipMemPoolGetAttribute,\n hipDeviceSetMemPool, hipMemPoolSetAttribute, hipMemPoolSetAccess, hipMemPoolGetAccess\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows."]
    pub fn hipMallocAsync(
        dev_ptr: *mut *mut ::std::os::raw::c_void,
        size: usize,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Frees memory with stream ordered semantics\n\n Inserts a free operation into @p stream.\n The allocation must not be used after stream execution reaches the free.\n After this API returns, accessing the memory from any subsequent work launched on the GPU\n or querying its pointer attributes results in undefined behavior.\n\n @note During stream capture, this function results in the creation of a free node and\n must therefore be passed the address of a graph allocation.\n\n @param [in] dev_ptr Pointer to device memory to free\n @param [in] stream  The stream, where the destruciton will occur according to the execution order\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n\n @see hipMallocFromPoolAsync, hipMallocAsync, hipMemPoolTrimTo, hipMemPoolGetAttribute,\n hipDeviceSetMemPool, hipMemPoolSetAttribute, hipMemPoolSetAccess, hipMemPoolGetAccess\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows."]
    pub fn hipFreeAsync(dev_ptr: *mut ::std::os::raw::c_void, stream: hipStream_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Releases freed memory back to the OS\n\n Releases memory back to the OS until the pool contains fewer than @p min_bytes_to_keep\n reserved bytes, or there is no more memory that the allocator can safely release.\n The allocator cannot release OS allocations that back outstanding asynchronous allocations.\n The OS allocations may happen at different granularity from the user allocations.\n\n @note Allocations that have not been freed count as outstanding.\n @note Allocations that have been asynchronously freed but whose completion has\n not been observed on the host (eg. by a synchronize) can count as outstanding.\n\n @param[in] mem_pool          The memory pool to trim allocations\n @param[in] min_bytes_to_hold If the pool has less than min_bytes_to_hold reserved,\n then the TrimTo operation is a no-op.  Otherwise the memory pool will contain\n at least min_bytes_to_hold bytes reserved after the operation.\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @see hipMallocFromPoolAsync, hipMallocAsync, hipFreeAsync, hipMemPoolGetAttribute,\n hipDeviceSetMemPool, hipMemPoolSetAttribute, hipMemPoolSetAccess, hipMemPoolGetAccess\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows."]
    pub fn hipMemPoolTrimTo(mem_pool: hipMemPool_t, min_bytes_to_hold: usize) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets attributes of a memory pool\n\n Supported attributes are:\n - @p hipMemPoolAttrReleaseThreshold: (value type = cuuint64_t)\n                                  Amount of reserved memory in bytes to hold onto before trying\n                                  to release memory back to the OS. When more than the release\n                                  threshold bytes of memory are held by the memory pool, the\n                                  allocator will try to release memory back to the OS on the\n                                  next call to stream, event or context synchronize. (default 0)\n - @p hipMemPoolReuseFollowEventDependencies: (value type = int)\n                                  Allow @p hipMallocAsync to use memory asynchronously freed\n                                  in another stream as long as a stream ordering dependency\n                                  of the allocating stream on the free action exists.\n                                  HIP events and null stream interactions can create the required\n                                  stream ordered dependencies. (default enabled)\n - @p hipMemPoolReuseAllowOpportunistic: (value type = int)\n                                  Allow reuse of already completed frees when there is no dependency\n                                  between the free and allocation. (default enabled)\n - @p hipMemPoolReuseAllowInternalDependencies: (value type = int)\n                                  Allow @p hipMallocAsync to insert new stream dependencies\n                                  in order to establish the stream ordering required to reuse\n                                  a piece of memory released by @p hipFreeAsync (default enabled).\n\n @param [in] mem_pool The memory pool to modify\n @param [in] attr     The attribute to modify\n @param [in] value    Pointer to the value to assign\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @see hipMallocFromPoolAsync, hipMallocAsync, hipFreeAsync, hipMemPoolGetAttribute,\n hipMemPoolTrimTo, hipDeviceSetMemPool, hipMemPoolSetAccess, hipMemPoolGetAccess\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows."]
    pub fn hipMemPoolSetAttribute(
        mem_pool: hipMemPool_t,
        attr: hipMemPoolAttr,
        value: *mut ::std::os::raw::c_void,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets attributes of a memory pool\n\n Supported attributes are:\n - @p hipMemPoolAttrReleaseThreshold: (value type = cuuint64_t)\n                                  Amount of reserved memory in bytes to hold onto before trying\n                                  to release memory back to the OS. When more than the release\n                                  threshold bytes of memory are held by the memory pool, the\n                                  allocator will try to release memory back to the OS on the\n                                  next call to stream, event or context synchronize. (default 0)\n - @p hipMemPoolReuseFollowEventDependencies: (value type = int)\n                                  Allow @p hipMallocAsync to use memory asynchronously freed\n                                  in another stream as long as a stream ordering dependency\n                                  of the allocating stream on the free action exists.\n                                  HIP events and null stream interactions can create the required\n                                  stream ordered dependencies. (default enabled)\n - @p hipMemPoolReuseAllowOpportunistic: (value type = int)\n                                  Allow reuse of already completed frees when there is no dependency\n                                  between the free and allocation. (default enabled)\n - @p hipMemPoolReuseAllowInternalDependencies: (value type = int)\n                                  Allow @p hipMallocAsync to insert new stream dependencies\n                                  in order to establish the stream ordering required to reuse\n                                  a piece of memory released by @p hipFreeAsync (default enabled).\n\n @param [in] mem_pool The memory pool to get attributes of\n @param [in] attr     The attribute to get\n @param [in] value    Retrieved value\n\n @returns  #hipSuccess, #hipErrorInvalidValue\n\n @see hipMallocFromPoolAsync, hipMallocAsync, hipFreeAsync,\n hipMemPoolTrimTo, hipDeviceSetMemPool, hipMemPoolSetAttribute, hipMemPoolSetAccess, hipMemPoolGetAccess\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows."]
    pub fn hipMemPoolGetAttribute(
        mem_pool: hipMemPool_t,
        attr: hipMemPoolAttr,
        value: *mut ::std::os::raw::c_void,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Controls visibility of the specified pool between devices\n\n @param [in] mem_pool   Memory pool for acccess change\n @param [in] desc_list  Array of access descriptors. Each descriptor instructs the access to enable for a single gpu\n @param [in] count  Number of descriptors in the map array.\n\n @returns  #hipSuccess, #hipErrorInvalidValue\n\n @see hipMallocFromPoolAsync, hipMallocAsync, hipFreeAsync, hipMemPoolGetAttribute,\n hipMemPoolTrimTo, hipDeviceSetMemPool, hipMemPoolSetAttribute, hipMemPoolGetAccess\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows."]
    pub fn hipMemPoolSetAccess(
        mem_pool: hipMemPool_t,
        desc_list: *const hipMemAccessDesc,
        count: usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns the accessibility of a pool from a device\n\n Returns the accessibility of the pool's memory from the specified location.\n\n @param [out] flags    Accessibility of the memory pool from the specified location/device\n @param [in] mem_pool   Memory pool being queried\n @param [in] location  Location/device for memory pool access\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @see hipMallocFromPoolAsync, hipMallocAsync, hipFreeAsync, hipMemPoolGetAttribute,\n hipMemPoolTrimTo, hipDeviceSetMemPool, hipMemPoolSetAttribute, hipMemPoolSetAccess\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows."]
    pub fn hipMemPoolGetAccess(
        flags: *mut hipMemAccessFlags,
        mem_pool: hipMemPool_t,
        location: *mut hipMemLocation,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Creates a memory pool\n\n Creates a HIP memory pool and returns the handle in @p mem_pool. The @p pool_props determines\n the properties of the pool such as the backing device and IPC capabilities.\n\n By default, the memory pool will be accessible from the device it is allocated on.\n\n @param [out] mem_pool    Contains createed memory pool\n @param [in] pool_props   Memory pool properties\n\n @note Specifying hipMemHandleTypeNone creates a memory pool that will not support IPC.\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n\n @see hipMallocFromPoolAsync, hipMallocAsync, hipFreeAsync, hipMemPoolGetAttribute, hipMemPoolDestroy,\n hipMemPoolTrimTo, hipDeviceSetMemPool, hipMemPoolSetAttribute, hipMemPoolSetAccess, hipMemPoolGetAccess\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows."]
    pub fn hipMemPoolCreate(
        mem_pool: *mut hipMemPool_t,
        pool_props: *const hipMemPoolProps,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Destroys the specified memory pool\n\n If any pointers obtained from this pool haven't been freed or\n the pool has free operations that haven't completed\n when @p hipMemPoolDestroy is invoked, the function will return immediately and the\n resources associated with the pool will be released automatically\n once there are no more outstanding allocations.\n\n Destroying the current mempool of a device sets the default mempool of\n that device as the current mempool for that device.\n\n @param [in] mem_pool Memory pool for destruction\n\n @note A device's default memory pool cannot be destroyed.\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @see hipMallocFromPoolAsync, hipMallocAsync, hipFreeAsync, hipMemPoolGetAttribute, hipMemPoolCreate\n hipMemPoolTrimTo, hipDeviceSetMemPool, hipMemPoolSetAttribute, hipMemPoolSetAccess, hipMemPoolGetAccess\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows."]
    pub fn hipMemPoolDestroy(mem_pool: hipMemPool_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Allocates memory from a specified pool with stream ordered semantics.\n\n Inserts an allocation operation into @p stream.\n A pointer to the allocated memory is returned immediately in @p dev_ptr.\n The allocation must not be accessed until the allocation operation completes.\n The allocation comes from the specified memory pool.\n\n @note The specified memory pool may be from a device different than that of the specified @p stream.\n\n Basic stream ordering allows future work submitted into the same stream to use the allocation.\n Stream query, stream synchronize, and HIP events can be used to guarantee that the allocation\n operation completes before work submitted in a separate stream runs.\n\n @note During stream capture, this function results in the creation of an allocation node. In this case,\n the allocation is owned by the graph instead of the memory pool. The memory pool's properties\n are used to set the node's creation parameters.\n\n @param [out] dev_ptr Returned device pointer\n @param [in] size     Number of bytes to allocate\n @param [in] mem_pool The pool to allocate from\n @param [in] stream   The stream establishing the stream ordering semantic\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported, #hipErrorOutOfMemory\n\n @see hipMallocAsync, hipFreeAsync, hipMemPoolGetAttribute, hipMemPoolCreate\n hipMemPoolTrimTo, hipDeviceSetMemPool, hipMemPoolSetAttribute, hipMemPoolSetAccess, hipMemPoolGetAccess,\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows."]
    pub fn hipMallocFromPoolAsync(
        dev_ptr: *mut *mut ::std::os::raw::c_void,
        size: usize,
        mem_pool: hipMemPool_t,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Exports a memory pool to the requested handle type.\n\n Given an IPC capable mempool, create an OS handle to share the pool with another process.\n A recipient process can convert the shareable handle into a mempool with @p hipMemPoolImportFromShareableHandle.\n Individual pointers can then be shared with the @p hipMemPoolExportPointer and @p hipMemPoolImportPointer APIs.\n The implementation of what the shareable handle is and how it can be transferred is defined by the requested\n handle type.\n\n @note To create an IPC capable mempool, create a mempool with a @p hipMemAllocationHandleType other\n than @p hipMemHandleTypeNone.\n\n @param [out] shared_handle Pointer to the location in which to store the requested handle\n @param [in] mem_pool       Pool to export\n @param [in] handle_type    The type of handle to create\n @param [in] flags          Must be 0\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorOutOfMemory\n\n @see hipMemPoolImportFromShareableHandle\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows."]
    pub fn hipMemPoolExportToShareableHandle(
        shared_handle: *mut ::std::os::raw::c_void,
        mem_pool: hipMemPool_t,
        handle_type: hipMemAllocationHandleType,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Imports a memory pool from a shared handle.\n\n Specific allocations can be imported from the imported pool with @p hipMemPoolImportPointer.\n\n @note Imported memory pools do not support creating new allocations.\n As such imported memory pools may not be used in @p hipDeviceSetMemPool\n or @p hipMallocFromPoolAsync calls.\n\n @param [out] mem_pool     Returned memory pool\n @param [in] shared_handle OS handle of the pool to open\n @param [in] handle_type   The type of handle being imported\n @param [in] flags         Must be 0\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorOutOfMemory\n\n @see hipMemPoolExportToShareableHandle\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows."]
    pub fn hipMemPoolImportFromShareableHandle(
        mem_pool: *mut hipMemPool_t,
        shared_handle: *mut ::std::os::raw::c_void,
        handle_type: hipMemAllocationHandleType,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Export data to share a memory pool allocation between processes.\n\n Constructs @p export_data for sharing a specific allocation from an already shared memory pool.\n The recipient process can import the allocation with the @p hipMemPoolImportPointer api.\n The data is not a handle and may be shared through any IPC mechanism.\n\n @param[out] export_data  Returned export data\n @param[in] dev_ptr       Pointer to memory being exported\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorOutOfMemory\n\n @see hipMemPoolImportPointer\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows."]
    pub fn hipMemPoolExportPointer(
        export_data: *mut hipMemPoolPtrExportData,
        dev_ptr: *mut ::std::os::raw::c_void,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Import a memory pool allocation from another process.\n\n Returns in @p dev_ptr a pointer to the imported memory.\n The imported memory must not be accessed before the allocation operation completes\n in the exporting process. The imported memory must be freed from all importing processes before\n being freed in the exporting process. The pointer may be freed with @p hipFree\n or @p hipFreeAsync. If @p hipFreeAsync is used, the free must be completed\n on the importing process before the free operation on the exporting process.\n\n @note The @p hipFreeAsync api may be used in the exporting process before\n the @p hipFreeAsync operation completes in its stream as long as the\n @p hipFreeAsync in the exporting process specifies a stream with\n a stream dependency on the importing process's @p hipFreeAsync.\n\n @param [out] dev_ptr     Pointer to imported memory\n @param [in] mem_pool     Memory pool from which to import a pointer\n @param [in] export_data  Data specifying the memory to import\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotInitialized, #hipErrorOutOfMemory\n\n @see hipMemPoolExportPointer\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows."]
    pub fn hipMemPoolImportPointer(
        dev_ptr: *mut *mut ::std::os::raw::c_void,
        mem_pool: hipMemPool_t,
        export_data: *mut hipMemPoolPtrExportData,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Allocate device accessible page locked host memory\n\n  @param[out] ptr Pointer to the allocated host pinned memory\n  @param[in]  size Requested memory size in bytes\n  @param[in]  flags Type of host memory allocation see below\n\n  If size is 0, no memory is allocated, *ptr returns nullptr, and hipSuccess is returned.\n\n  Flags:\n  - #hipHostAllocDefault   Default pinned memory allocation on the host.\n  - #hipHostAllocPortable  Memory is considered allocated by all contexts.\n  - #hipHostAllocMapped    Map the allocation into the address space for the current device.\n  - #hipHostAllocWriteCombined  Allocates the memory as write-combined.\n\n  @return #hipSuccess, #hipErrorOutOfMemory, #hipErrorInvalidValue"]
    pub fn hipHostAlloc(
        ptr: *mut *mut ::std::os::raw::c_void,
        size: usize,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Get Device pointer from Host Pointer allocated through hipHostMalloc\n\n  @param[out] devPtr Device Pointer mapped to passed host pointer\n  @param[in]  hstPtr Host Pointer allocated through hipHostMalloc\n  @param[in]  flags Flags to be passed for extension\n\n  @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorOutOfMemory\n\n  @see hipSetDeviceFlags, hipHostMalloc"]
    pub fn hipHostGetDevicePointer(
        devPtr: *mut *mut ::std::os::raw::c_void,
        hstPtr: *mut ::std::os::raw::c_void,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Return flags associated with host pointer\n\n  @param[out] flagsPtr Memory location to store flags\n  @param[in]  hostPtr Host Pointer allocated through hipHostMalloc\n  @returns #hipSuccess, #hipErrorInvalidValue\n\n  @see hipHostMalloc"]
    pub fn hipHostGetFlags(
        flagsPtr: *mut ::std::os::raw::c_uint,
        hostPtr: *mut ::std::os::raw::c_void,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Register host memory so it can be accessed from the current device.\n\n  @param[out] hostPtr Pointer to host memory to be registered.\n  @param[in] sizeBytes Size of the host memory\n  @param[in] flags  See below.\n\n  Flags:\n  - #hipHostRegisterDefault   Memory is Mapped and Portable\n  - #hipHostRegisterPortable  Memory is considered registered by all contexts.  HIP only supports\n one context so this is always assumed true.\n  - #hipHostRegisterMapped    Map the allocation into the address space for the current device.\n The device pointer can be obtained with #hipHostGetDevicePointer.\n\n\n  After registering the memory, use #hipHostGetDevicePointer to obtain the mapped device pointer.\n  On many systems, the mapped device pointer will have a different value than the mapped host\n pointer.  Applications must use the device pointer in device code, and the host pointer in host\n code.\n\n  On some systems, registered memory is pinned.  On some systems, registered memory may not be\n actually be pinned but uses OS or hardware facilities to all GPU access to the host memory.\n\n  Developers are strongly encouraged to register memory blocks which are aligned to the host\n cache-line size. (typically 64-bytes but can be obtains from the CPUID instruction).\n\n  If registering non-aligned pointers, the application must take care when register pointers from\n the same cache line on different devices.  HIP's coarse-grained synchronization model does not\n guarantee correct results if different devices write to different parts of the same cache block -\n typically one of the writes will \"win\" and overwrite data from the other registered memory\n region.\n\n  @returns #hipSuccess, #hipErrorOutOfMemory\n\n  @see hipHostUnregister, hipHostGetFlags, hipHostGetDevicePointer"]
    pub fn hipHostRegister(
        hostPtr: *mut ::std::os::raw::c_void,
        sizeBytes: usize,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Un-register host pointer\n\n  @param[in] hostPtr Host pointer previously registered with #hipHostRegister\n  @returns Error code\n\n  @see hipHostRegister"]
    pub fn hipHostUnregister(hostPtr: *mut ::std::os::raw::c_void) -> hipError_t;
}
extern "C" {
    #[doc = "  Allocates at least width (in bytes) * height bytes of linear memory\n  Padding may occur to ensure alighnment requirements are met for the given row\n  The change in width size due to padding will be returned in *pitch.\n  Currently the alignment is set to 128 bytes\n\n  @param[out] ptr Pointer to the allocated device memory\n  @param[out] pitch Pitch for allocation (in bytes)\n  @param[in]  width Requested pitched allocation width (in bytes)\n  @param[in]  height Requested pitched allocation height\n\n  If size is 0, no memory is allocated, *ptr returns nullptr, and hipSuccess is returned.\n\n  @returns Error code\n\n  @see hipMalloc, hipFree, hipMallocArray, hipFreeArray, hipHostFree, hipMalloc3D,\n hipMalloc3DArray, hipHostMalloc"]
    pub fn hipMallocPitch(
        ptr: *mut *mut ::std::os::raw::c_void,
        pitch: *mut usize,
        width: usize,
        height: usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  Allocates at least width (in bytes) * height bytes of linear memory\n  Padding may occur to ensure alighnment requirements are met for the given row\n  The change in width size due to padding will be returned in *pitch.\n  Currently the alignment is set to 128 bytes\n\n  @param[out] dptr  Pointer to the allocated device memory\n  @param[out] pitch  Pitch for allocation (in bytes)\n  @param[in]  widthInBytes  Requested pitched allocation width (in bytes)\n  @param[in]  height  Requested pitched allocation height\n  @param[in]  elementSizeBytes  The size of element bytes, should be 4, 8 or 16\n\n  If size is 0, no memory is allocated, *ptr returns nullptr, and hipSuccess is returned.\n  The intended usage of pitch is as a separate parameter of the allocation, used to compute addresses within the 2D array.\n  Given the row and column of an array element of type T, the address is computed as:\n  T* pElement = (T*)((char*)BaseAddress + Row * Pitch) + Column;\n\n  @returns Error code\n\n  @see hipMalloc, hipFree, hipMallocArray, hipFreeArray, hipHostFree, hipMalloc3D,\n hipMalloc3DArray, hipHostMalloc"]
    pub fn hipMemAllocPitch(
        dptr: *mut hipDeviceptr_t,
        pitch: *mut usize,
        widthInBytes: usize,
        height: usize,
        elementSizeBytes: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Free memory allocated by the hcc hip memory allocation API.\n  This API performs an implicit hipDeviceSynchronize() call.\n  If pointer is NULL, the hip runtime is initialized and hipSuccess is returned.\n\n  @param[in] ptr Pointer to memory to be freed\n  @returns #hipSuccess\n  @returns #hipErrorInvalidDevicePointer (if pointer is invalid, including host pointers allocated\n with hipHostMalloc)\n\n  @see hipMalloc, hipMallocPitch, hipMallocArray, hipFreeArray, hipHostFree, hipMalloc3D,\n hipMalloc3DArray, hipHostMalloc"]
    pub fn hipFree(ptr: *mut ::std::os::raw::c_void) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Frees page-locked memory\n  This API performs an implicit hipDeviceSynchronize() call.\n  If pointer is NULL, the hip runtime is initialized and hipSuccess is returned.\n\n  @param[in] ptr Pointer to memory to be freed\n  @returns #hipSuccess,\n          #hipErrorInvalidValue (if pointer is invalid, including device pointers allocated\n  with hipMalloc)\n"]
    pub fn hipFreeHost(ptr: *mut ::std::os::raw::c_void) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Free memory allocated by the hcc hip host memory allocation API\n  This API performs an implicit hipDeviceSynchronize() call.\n  If pointer is NULL, the hip runtime is initialized and hipSuccess is returned.\n\n  @ingroup MemoryD\n\n  @param[in] ptr Pointer to memory to be freed\n  @returns #hipSuccess,\n          #hipErrorInvalidValue (if pointer is invalid, including device pointers allocated with\n hipMalloc)\n\n  @see hipMalloc, hipMallocPitch, hipFree, hipMallocArray, hipFreeArray, hipMalloc3D,\n hipMalloc3DArray, hipHostMalloc\n"]
    pub fn hipHostFree(ptr: *mut ::std::os::raw::c_void) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copy data from src to dst.\n\n  It supports memory from host to device,\n  device to host, device to device and host to host\n  The src and dst must not overlap.\n\n  For hipMemcpy, the copy is always performed by the current device (set by hipSetDevice).\n  For multi-gpu or peer-to-peer configurations, it is recommended to set the current device to the\n  device where the src data is physically located. For optimal peer-to-peer copies, the copy device\n  must be able to access the src and dst pointers (by calling hipDeviceEnablePeerAccess with copy\n  agent as the current device and src/dest as the peerDevice argument.  if this is not done, the\n  hipMemcpy will still work, but will perform the copy using a staging buffer on the host.\n  Calling hipMemcpy with dst and src pointers that do not match the hipMemcpyKind results in\n  undefined behavior.\n\n  @param[out]  dst Data being copy to\n  @param[in]  src Data being copy from\n  @param[in]  sizeBytes Data size in bytes\n  @param[in]  kind Kind of transfer\n  @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorUnknown\n\n  @see hipArrayCreate, hipArrayDestroy, hipArrayGetDescriptor, hipMemAlloc, hipMemAllocHost,\n hipMemAllocPitch, hipMemcpy2D, hipMemcpy2DAsync, hipMemcpy2DUnaligned, hipMemcpyAtoA,\n hipMemcpyAtoD, hipMemcpyAtoH, hipMemcpyAtoHAsync, hipMemcpyDtoA, hipMemcpyDtoD,\n hipMemcpyDtoDAsync, hipMemcpyDtoH, hipMemcpyDtoHAsync, hipMemcpyHtoA, hipMemcpyHtoAAsync,\n hipMemcpyHtoDAsync, hipMemFree, hipMemFreeHost, hipMemGetAddressRange, hipMemGetInfo,\n hipMemHostAlloc, hipMemHostGetDevicePointer"]
    pub fn hipMemcpy(
        dst: *mut ::std::os::raw::c_void,
        src: *const ::std::os::raw::c_void,
        sizeBytes: usize,
        kind: hipMemcpyKind,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Memory copy on the stream.\n  It allows single or multiple devices to do memory copy on single or multiple streams.\n\n  @param[out]  dst Data being copy to\n  @param[in]  src Data being copy from\n  @param[in]  sizeBytes Data size in bytes\n  @param[in]  kind Kind of transfer\n  @param[in]  stream Valid stream\n  @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorUnknown, #hipErrorContextIsDestroyed\n\n  @see hipMemcpy, hipStreamCreate, hipStreamSynchronize, hipStreamDestroy, hipSetDevice, hipLaunchKernelGGL\n"]
    pub fn hipMemcpyWithStream(
        dst: *mut ::std::os::raw::c_void,
        src: *const ::std::os::raw::c_void,
        sizeBytes: usize,
        kind: hipMemcpyKind,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copy data from Host to Device\n\n  @param[out]  dst Data being copy to\n  @param[in]   src Data being copy from\n  @param[in]   sizeBytes Data size in bytes\n\n  @returns #hipSuccess, #hipErrorDeinitialized, #hipErrorNotInitialized, #hipErrorInvalidContext,\n #hipErrorInvalidValue\n\n  @see hipArrayCreate, hipArrayDestroy, hipArrayGetDescriptor, hipMemAlloc, hipMemAllocHost,\n hipMemAllocPitch, hipMemcpy2D, hipMemcpy2DAsync, hipMemcpy2DUnaligned, hipMemcpyAtoA,\n hipMemcpyAtoD, hipMemcpyAtoH, hipMemcpyAtoHAsync, hipMemcpyDtoA, hipMemcpyDtoD,\n hipMemcpyDtoDAsync, hipMemcpyDtoH, hipMemcpyDtoHAsync, hipMemcpyHtoA, hipMemcpyHtoAAsync,\n hipMemcpyHtoDAsync, hipMemFree, hipMemFreeHost, hipMemGetAddressRange, hipMemGetInfo,\n hipMemHostAlloc, hipMemHostGetDevicePointer"]
    pub fn hipMemcpyHtoD(
        dst: hipDeviceptr_t,
        src: *mut ::std::os::raw::c_void,
        sizeBytes: usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copy data from Device to Host\n\n  @param[out]  dst Data being copy to\n  @param[in]   src Data being copy from\n  @param[in]   sizeBytes Data size in bytes\n\n  @returns #hipSuccess, #hipErrorDeinitialized, #hipErrorNotInitialized, #hipErrorInvalidContext,\n #hipErrorInvalidValue\n\n  @see hipArrayCreate, hipArrayDestroy, hipArrayGetDescriptor, hipMemAlloc, hipMemAllocHost,\n hipMemAllocPitch, hipMemcpy2D, hipMemcpy2DAsync, hipMemcpy2DUnaligned, hipMemcpyAtoA,\n hipMemcpyAtoD, hipMemcpyAtoH, hipMemcpyAtoHAsync, hipMemcpyDtoA, hipMemcpyDtoD,\n hipMemcpyDtoDAsync, hipMemcpyDtoH, hipMemcpyDtoHAsync, hipMemcpyHtoA, hipMemcpyHtoAAsync,\n hipMemcpyHtoDAsync, hipMemFree, hipMemFreeHost, hipMemGetAddressRange, hipMemGetInfo,\n hipMemHostAlloc, hipMemHostGetDevicePointer"]
    pub fn hipMemcpyDtoH(
        dst: *mut ::std::os::raw::c_void,
        src: hipDeviceptr_t,
        sizeBytes: usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copy data from Device to Device\n\n  @param[out]  dst Data being copy to\n  @param[in]   src Data being copy from\n  @param[in]   sizeBytes Data size in bytes\n\n  @returns #hipSuccess, #hipErrorDeinitialized, #hipErrorNotInitialized, #hipErrorInvalidContext,\n #hipErrorInvalidValue\n\n  @see hipArrayCreate, hipArrayDestroy, hipArrayGetDescriptor, hipMemAlloc, hipMemAllocHost,\n hipMemAllocPitch, hipMemcpy2D, hipMemcpy2DAsync, hipMemcpy2DUnaligned, hipMemcpyAtoA,\n hipMemcpyAtoD, hipMemcpyAtoH, hipMemcpyAtoHAsync, hipMemcpyDtoA, hipMemcpyDtoD,\n hipMemcpyDtoDAsync, hipMemcpyDtoH, hipMemcpyDtoHAsync, hipMemcpyHtoA, hipMemcpyHtoAAsync,\n hipMemcpyHtoDAsync, hipMemFree, hipMemFreeHost, hipMemGetAddressRange, hipMemGetInfo,\n hipMemHostAlloc, hipMemHostGetDevicePointer"]
    pub fn hipMemcpyDtoD(dst: hipDeviceptr_t, src: hipDeviceptr_t, sizeBytes: usize) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copies from one 1D array to device memory.\n\n  @param[out]  dstDevice Destination device pointer\n  @param[in]   srcArray Source array\n  @param[in]   srcOffset Offset in bytes of source array\n  @param[in]   ByteCount Size of memory copy in bytes\n\n  @returns #hipSuccess, #hipErrorDeinitialized, #hipErrorNotInitialized, #hipErrorInvalidContext,\n #hipErrorInvalidValue\n\n  @see hipArrayCreate, hipArrayDestroy, hipArrayGetDescriptor, hipMemAlloc, hipMemAllocHost,\n hipMemAllocPitch, hipMemcpy2D, hipMemcpy2DAsync, hipMemcpy2DUnaligned, hipMemcpyAtoA,\n hipMemcpyAtoD, hipMemcpyAtoH, hipMemcpyAtoHAsync, hipMemcpyDtoA, hipMemcpyDtoD,\n hipMemcpyDtoDAsync, hipMemcpyDtoH, hipMemcpyDtoHAsync, hipMemcpyHtoA, hipMemcpyHtoAAsync,\n hipMemcpyHtoDAsync, hipMemFree, hipMemFreeHost, hipMemGetAddressRange, hipMemGetInfo,\n hipMemHostAlloc, hipMemHostGetDevicePointer"]
    pub fn hipMemcpyAtoD(
        dstDevice: hipDeviceptr_t,
        srcArray: hipArray_t,
        srcOffset: usize,
        ByteCount: usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copies from device memory to a 1D array.\n\n  @param[out]  dstArray Destination array\n  @param[in]   dstOffset Offset in bytes of destination array\n  @param[in]   srcDevice Source device pointer\n  @param[in]   ByteCount Size of memory copy in bytes\n\n  @returns #hipSuccess, #hipErrorDeinitialized, #hipErrorNotInitialized, #hipErrorInvalidContext,\n #hipErrorInvalidValue\n\n  @see hipArrayCreate, hipArrayDestroy, hipArrayGetDescriptor, hipMemAlloc, hipMemAllocHost,\n hipMemAllocPitch, hipMemcpy2D, hipMemcpy2DAsync, hipMemcpy2DUnaligned, hipMemcpyAtoA,\n hipMemcpyAtoD, hipMemcpyAtoH, hipMemcpyAtoHAsync, hipMemcpyDtoA, hipMemcpyDtoD,\n hipMemcpyDtoDAsync, hipMemcpyDtoH, hipMemcpyDtoHAsync, hipMemcpyHtoA, hipMemcpyHtoAAsync,\n hipMemcpyHtoDAsync, hipMemFree, hipMemFreeHost, hipMemGetAddressRange, hipMemGetInfo,\n hipMemHostAlloc, hipMemHostGetDevicePointer"]
    pub fn hipMemcpyDtoA(
        dstArray: hipArray_t,
        dstOffset: usize,
        srcDevice: hipDeviceptr_t,
        ByteCount: usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copies from one 1D array to another.\n\n  @param[out]  dstArray Destination array\n  @param[in]   dstOffset Offset in bytes of destination array\n  @param[in]   srcArray Source array\n  @param[in]   srcOffset Offset in bytes of source array\n  @param[in]   ByteCount Size of memory copy in bytes\n\n  @returns #hipSuccess, #hipErrorDeinitialized, #hipErrorNotInitialized, #hipErrorInvalidContext,\n #hipErrorInvalidValue\n\n  @see hipArrayCreate, hipArrayDestroy, hipArrayGetDescriptor, hipMemAlloc, hipMemAllocHost,\n hipMemAllocPitch, hipMemcpy2D, hipMemcpy2DAsync, hipMemcpy2DUnaligned, hipMemcpyAtoA,\n hipMemcpyAtoD, hipMemcpyAtoH, hipMemcpyAtoHAsync, hipMemcpyDtoA, hipMemcpyDtoD,\n hipMemcpyDtoDAsync, hipMemcpyDtoH, hipMemcpyDtoHAsync, hipMemcpyHtoA, hipMemcpyHtoAAsync,\n hipMemcpyHtoDAsync, hipMemFree, hipMemFreeHost, hipMemGetAddressRange, hipMemGetInfo,\n hipMemHostAlloc, hipMemHostGetDevicePointer"]
    pub fn hipMemcpyAtoA(
        dstArray: hipArray_t,
        dstOffset: usize,
        srcArray: hipArray_t,
        srcOffset: usize,
        ByteCount: usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copy data from Host to Device asynchronously\n\n  @param[out]  dst  Data being copy to\n  @param[in]   src  Data being copy from\n  @param[in]   sizeBytes  Data size in bytes\n  @param[in]   stream  Stream identifier\n\n  @returns #hipSuccess, #hipErrorDeinitialized, #hipErrorNotInitialized, #hipErrorInvalidContext,\n #hipErrorInvalidValue\n\n  @see hipArrayCreate, hipArrayDestroy, hipArrayGetDescriptor, hipMemAlloc, hipMemAllocHost,\n hipMemAllocPitch, hipMemcpy2D, hipMemcpy2DAsync, hipMemcpy2DUnaligned, hipMemcpyAtoA,\n hipMemcpyAtoD, hipMemcpyAtoH, hipMemcpyAtoHAsync, hipMemcpyDtoA, hipMemcpyDtoD,\n hipMemcpyDtoDAsync, hipMemcpyDtoH, hipMemcpyDtoHAsync, hipMemcpyHtoA, hipMemcpyHtoAAsync,\n hipMemcpyHtoDAsync, hipMemFree, hipMemFreeHost, hipMemGetAddressRange, hipMemGetInfo,\n hipMemHostAlloc, hipMemHostGetDevicePointer"]
    pub fn hipMemcpyHtoDAsync(
        dst: hipDeviceptr_t,
        src: *mut ::std::os::raw::c_void,
        sizeBytes: usize,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copy data from Device to Host asynchronously\n\n  @param[out]  dst Data being copy to\n  @param[in]   src Data being copy from\n  @param[in]   sizeBytes Data size in bytes\n  @param[in]   stream  Stream identifier\n\n  @returns #hipSuccess, #hipErrorDeinitialized, #hipErrorNotInitialized, #hipErrorInvalidContext,\n #hipErrorInvalidValue\n\n  @see hipArrayCreate, hipArrayDestroy, hipArrayGetDescriptor, hipMemAlloc, hipMemAllocHost,\n hipMemAllocPitch, hipMemcpy2D, hipMemcpy2DAsync, hipMemcpy2DUnaligned, hipMemcpyAtoA,\n hipMemcpyAtoD, hipMemcpyAtoH, hipMemcpyAtoHAsync, hipMemcpyDtoA, hipMemcpyDtoD,\n hipMemcpyDtoDAsync, hipMemcpyDtoH, hipMemcpyDtoHAsync, hipMemcpyHtoA, hipMemcpyHtoAAsync,\n hipMemcpyHtoDAsync, hipMemFree, hipMemFreeHost, hipMemGetAddressRange, hipMemGetInfo,\n hipMemHostAlloc, hipMemHostGetDevicePointer"]
    pub fn hipMemcpyDtoHAsync(
        dst: *mut ::std::os::raw::c_void,
        src: hipDeviceptr_t,
        sizeBytes: usize,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copy data from Device to Device asynchronously\n\n  @param[out]  dst  Data being copy to\n  @param[in]   src  Data being copy from\n  @param[in]   sizeBytes  Data size in bytes\n  @param[in]   stream  Stream identifier\n\n  @returns #hipSuccess, #hipErrorDeinitialized, #hipErrorNotInitialized, #hipErrorInvalidContext,\n #hipErrorInvalidValue\n\n  @see hipArrayCreate, hipArrayDestroy, hipArrayGetDescriptor, hipMemAlloc, hipMemAllocHost,\n hipMemAllocPitch, hipMemcpy2D, hipMemcpy2DAsync, hipMemcpy2DUnaligned, hipMemcpyAtoA,\n hipMemcpyAtoD, hipMemcpyAtoH, hipMemcpyAtoHAsync, hipMemcpyDtoA, hipMemcpyDtoD,\n hipMemcpyDtoDAsync, hipMemcpyDtoH, hipMemcpyDtoHAsync, hipMemcpyHtoA, hipMemcpyHtoAAsync,\n hipMemcpyHtoDAsync, hipMemFree, hipMemFreeHost, hipMemGetAddressRange, hipMemGetInfo,\n hipMemHostAlloc, hipMemHostGetDevicePointer"]
    pub fn hipMemcpyDtoDAsync(
        dst: hipDeviceptr_t,
        src: hipDeviceptr_t,
        sizeBytes: usize,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Copies from one 1D array to host memory.\n\n  @param[out]  dstHost Destination pointer\n  @param[in]   srcArray Source array\n  @param[in]   srcOffset Offset in bytes of source array\n  @param[in]   ByteCount Size of memory copy in bytes\n  @param[in]   stream Stream identifier\n\n  @returns #hipSuccess, #hipErrorDeinitialized, #hipErrorNotInitialized, #hipErrorInvalidContext,\n #hipErrorInvalidValue\n\n  @see hipArrayCreate, hipArrayDestroy, hipArrayGetDescriptor, hipMemAlloc, hipMemAllocHost,\n hipMemAllocPitch, hipMemcpy2D, hipMemcpy2DAsync, hipMemcpy2DUnaligned, hipMemcpyAtoA,\n hipMemcpyAtoD, hipMemcpyAtoH, hipMemcpyAtoHAsync, hipMemcpyDtoA, hipMemcpyDtoD,\n hipMemcpyDtoDAsync, hipMemcpyDtoH, hipMemcpyDtoHAsync, hipMemcpyHtoA, hipMemcpyHtoAAsync,\n hipMemcpyHtoDAsync, hipMemFree, hipMemFreeHost, hipMemGetAddressRange, hipMemGetInfo,\n hipMemHostAlloc, hipMemHostGetDevicePointer"]
    pub fn hipMemcpyAtoHAsync(
        dstHost: *mut ::std::os::raw::c_void,
        srcArray: hipArray_t,
        srcOffset: usize,
        ByteCount: usize,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Copies from host memory to a 1D array.\n\n  @param[out]  dstArray Destination array\n  @param[in]   dstOffset Offset in bytes of destination array\n  @param[in]   srcHost Source host pointer\n  @param[in]   ByteCount Size of memory copy in bytes\n  @param[in]   stream Stream identifier\n\n  @returns #hipSuccess, #hipErrorDeinitialized, #hipErrorNotInitialized, #hipErrorInvalidContext,\n #hipErrorInvalidValue\n\n  @see hipArrayCreate, hipArrayDestroy, hipArrayGetDescriptor, hipMemAlloc, hipMemAllocHost,\n hipMemAllocPitch, hipMemcpy2D, hipMemcpy2DAsync, hipMemcpy2DUnaligned, hipMemcpyAtoA,\n hipMemcpyAtoD, hipMemcpyAtoH, hipMemcpyAtoHAsync, hipMemcpyDtoA, hipMemcpyDtoD,\n hipMemcpyDtoDAsync, hipMemcpyDtoH, hipMemcpyDtoHAsync, hipMemcpyHtoA, hipMemcpyHtoAAsync,\n hipMemcpyHtoDAsync, hipMemFree, hipMemFreeHost, hipMemGetAddressRange, hipMemGetInfo,\n hipMemHostAlloc, hipMemHostGetDevicePointer"]
    pub fn hipMemcpyHtoAAsync(
        dstArray: hipArray_t,
        dstOffset: usize,
        srcHost: *const ::std::os::raw::c_void,
        ByteCount: usize,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Returns a global pointer from a module.\n  @ingroup Module\n\n  Returns in *dptr and *bytes the pointer and size of the global of name name located in module hmod.\n  If no variable of that name exists, it returns hipErrorNotFound. Both parameters dptr and bytes are optional.\n  If one of them is NULL, it is ignored and hipSuccess is returned.\n\n  @param[out]  dptr  Returns global device pointer\n  @param[out]  bytes Returns global size in bytes\n  @param[in]   hmod  Module to retrieve global from\n  @param[in]   name  Name of global to retrieve\n\n  @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotFound, #hipErrorInvalidContext\n"]
    pub fn hipModuleGetGlobal(
        dptr: *mut hipDeviceptr_t,
        bytes: *mut usize,
        hmod: hipModule_t,
        name: *const ::std::os::raw::c_char,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Gets device pointer associated with symbol on the device.\n\n  @param[out]  devPtr  pointer to the device associated the symbole\n  @param[in]   symbol  pointer to the symbole of the device\n\n  @returns #hipSuccess, #hipErrorInvalidValue\n"]
    pub fn hipGetSymbolAddress(
        devPtr: *mut *mut ::std::os::raw::c_void,
        symbol: *const ::std::os::raw::c_void,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Gets the size of the given symbol on the device.\n\n  @param[in]   symbol  pointer to the device symbole\n  @param[out]  size  pointer to the size\n\n  @returns #hipSuccess, #hipErrorInvalidValue\n"]
    pub fn hipGetSymbolSize(size: *mut usize, symbol: *const ::std::os::raw::c_void) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets the pointer of requested HIP driver function.\n\n @param[in] symbol  The Symbol name of the driver function to request.\n @param[out] pfn  Output pointer to the requested driver function.\n @param[in] hipVersion  The HIP version for the requested driver function symbol.\n HIP version is defined as 100*version_major + version_minor. For example, in HIP 6.1, the\n hipversion is 601, for the symbol function \"hipGetDeviceProperties\", the specified hipVersion 601\n is greater or equal to the version 600, the symbol function will be handle properly as backend\n compatible function.\n\n @param[in] flags  Currently only default flag is suppported.\n @param[out] symbolStatus  Optional enumeration for returned status of searching for symbol driver\n function based on the input hipVersion.\n\n Returns hipSuccess if the returned pfn is addressed to the pointer of found driver function.\n\n @returns #hipSuccess, #hipErrorInvalidValue."]
    pub fn hipGetProcAddress(
        symbol: *const ::std::os::raw::c_char,
        pfn: *mut *mut ::std::os::raw::c_void,
        hipVersion: ::std::os::raw::c_int,
        flags: u64,
        symbolStatus: *mut hipDriverProcAddressQueryResult,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copies data to the given symbol on the device.\n Symbol HIP APIs allow a kernel to define a device-side data symbol which can be accessed on\n the host side. The symbol can be in __constant or device space.\n Note that the symbol name needs to be encased in the HIP_SYMBOL macro.\n This also applies to hipMemcpyFromSymbol, hipGetSymbolAddress, and hipGetSymbolSize.\n For detailed usage, see the\n <a href=\"https://rocm.docs.amd.com/projects/HIP/en/latest/how-to/hip_porting_guide.html#memcpytosymbol\">memcpyToSymbol example</a>\n in the HIP Porting Guide.\n\n\n  @param[out]  symbol  pointer to the device symbole\n  @param[in]   src  pointer to the source address\n  @param[in]   sizeBytes  size in bytes to copy\n  @param[in]   offset  offset in bytes from start of symbole\n  @param[in]   kind  type of memory transfer\n\n  @returns #hipSuccess, #hipErrorInvalidValue\n"]
    pub fn hipMemcpyToSymbol(
        symbol: *const ::std::os::raw::c_void,
        src: *const ::std::os::raw::c_void,
        sizeBytes: usize,
        offset: usize,
        kind: hipMemcpyKind,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copies data to the given symbol on the device asynchronously.\n\n  @param[out]  symbol  pointer to the device symbole\n  @param[in]   src  pointer to the source address\n  @param[in]   sizeBytes  size in bytes to copy\n  @param[in]   offset  offset in bytes from start of symbole\n  @param[in]   kind  type of memory transfer\n  @param[in]   stream  stream identifier\n\n  @returns #hipSuccess, #hipErrorInvalidValue\n"]
    pub fn hipMemcpyToSymbolAsync(
        symbol: *const ::std::os::raw::c_void,
        src: *const ::std::os::raw::c_void,
        sizeBytes: usize,
        offset: usize,
        kind: hipMemcpyKind,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copies data from the given symbol on the device.\n\n  @param[out]  dst  Returns pointer to destinition memory address\n  @param[in]   symbol  Pointer to the symbole address on the device\n  @param[in]   sizeBytes  Size in bytes to copy\n  @param[in]   offset  Offset in bytes from the start of symbole\n  @param[in]   kind  Type of memory transfer\n\n  @returns #hipSuccess, #hipErrorInvalidValue\n"]
    pub fn hipMemcpyFromSymbol(
        dst: *mut ::std::os::raw::c_void,
        symbol: *const ::std::os::raw::c_void,
        sizeBytes: usize,
        offset: usize,
        kind: hipMemcpyKind,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copies data from the given symbol on the device asynchronously.\n\n  @param[out]  dst  Returns pointer to destinition memory address\n  @param[in]   symbol  pointer to the symbole address on the device\n  @param[in]   sizeBytes  size in bytes to copy\n  @param[in]   offset  offset in bytes from the start of symbole\n  @param[in]   kind  type of memory transfer\n  @param[in]   stream  stream identifier\n\n  @returns #hipSuccess, #hipErrorInvalidValue\n"]
    pub fn hipMemcpyFromSymbolAsync(
        dst: *mut ::std::os::raw::c_void,
        symbol: *const ::std::os::raw::c_void,
        sizeBytes: usize,
        offset: usize,
        kind: hipMemcpyKind,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copy data from src to dst asynchronously.\n\n  @warning If host or dest are not pinned, the memory copy will be performed synchronously.  For\n best performance, use hipHostMalloc to allocate host memory that is transferred asynchronously.\n\n  @warning on HCC hipMemcpyAsync does not support overlapped H2D and D2H copies.\n  For hipMemcpy, the copy is always performed by the device associated with the specified stream.\n\n  For multi-gpu or peer-to-peer configurations, it is recommended to use a stream which is a\n attached to the device where the src data is physically located. For optimal peer-to-peer copies,\n the copy device must be able to access the src and dst pointers (by calling\n hipDeviceEnablePeerAccess with copy agent as the current device and src/dest as the peerDevice\n argument.  if this is not done, the hipMemcpy will still work, but will perform the copy using a\n staging buffer on the host.\n\n  @param[out] dst Data being copy to\n  @param[in]  src Data being copy from\n  @param[in]  sizeBytes Data size in bytes\n  @param[in]  kind  Type of memory transfer\n  @param[in]  stream  Stream identifier\n  @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorUnknown\n\n  @see hipMemcpy, hipMemcpy2D, hipMemcpyToArray, hipMemcpy2DToArray, hipMemcpyFromArray,\n hipMemcpy2DFromArray, hipMemcpyArrayToArray, hipMemcpy2DArrayToArray, hipMemcpyToSymbol,\n hipMemcpyFromSymbol, hipMemcpy2DAsync, hipMemcpyToArrayAsync, hipMemcpy2DToArrayAsync,\n hipMemcpyFromArrayAsync, hipMemcpy2DFromArrayAsync, hipMemcpyToSymbolAsync,\n hipMemcpyFromSymbolAsync"]
    pub fn hipMemcpyAsync(
        dst: *mut ::std::os::raw::c_void,
        src: *const ::std::os::raw::c_void,
        sizeBytes: usize,
        kind: hipMemcpyKind,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Fills the first sizeBytes bytes of the memory area pointed to by dest with the constant\n byte value value.\n\n  @param[out] dst  Data being filled\n  @param[in]  value  Value to be set\n  @param[in]  sizeBytes  Data size in bytes\n  @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotInitialized"]
    pub fn hipMemset(
        dst: *mut ::std::os::raw::c_void,
        value: ::std::os::raw::c_int,
        sizeBytes: usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Fills the first sizeBytes bytes of the memory area pointed to by dest with the constant\n byte value value.\n\n  @param[out] dest  Data ptr to be filled\n  @param[in]  value  Value to be set\n  @param[in]  count  Number of values to be set\n  @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotInitialized"]
    pub fn hipMemsetD8(
        dest: hipDeviceptr_t,
        value: ::std::os::raw::c_uchar,
        count: usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Fills the first sizeBytes bytes of the memory area pointed to by dest with the constant\n byte value value.\n\n hipMemsetD8Async() is asynchronous with respect to the host, so the call may return before the\n memset is complete. The operation can optionally be associated to a stream by passing a non-zero\n stream argument. If stream is non-zero, the operation may overlap with operations in other\n streams.\n\n  @param[out] dest  Data ptr to be filled\n  @param[in]  value  Constant value to be set\n  @param[in]  count  Number of values to be set\n  @param[in]  stream  Stream identifier\n  @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotInitialized"]
    pub fn hipMemsetD8Async(
        dest: hipDeviceptr_t,
        value: ::std::os::raw::c_uchar,
        count: usize,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Fills the first sizeBytes bytes of the memory area pointed to by dest with the constant\n short value value.\n\n  @param[out] dest  Data ptr to be filled\n  @param[in]  value  Constant value to be set\n  @param[in]  count  Number of values to be set\n  @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotInitialized"]
    pub fn hipMemsetD16(
        dest: hipDeviceptr_t,
        value: ::std::os::raw::c_ushort,
        count: usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Fills the first sizeBytes bytes of the memory area pointed to by dest with the constant\n short value value.\n\n hipMemsetD16Async() is asynchronous with respect to the host, so the call may return before the\n memset is complete. The operation can optionally be associated to a stream by passing a non-zero\n stream argument. If stream is non-zero, the operation may overlap with operations in other\n streams.\n\n  @param[out] dest  Data ptr to be filled\n  @param[in]  value  Constant value to be set\n  @param[in]  count  Number of values to be set\n  @param[in]  stream  Stream identifier\n  @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotInitialized"]
    pub fn hipMemsetD16Async(
        dest: hipDeviceptr_t,
        value: ::std::os::raw::c_ushort,
        count: usize,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Fills the memory area pointed to by dest with the constant integer\n value for specified number of times.\n\n  @param[out] dest  Data being filled\n  @param[in]  value  Constant value to be set\n  @param[in]  count  Number of values to be set\n  @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotInitialized"]
    pub fn hipMemsetD32(
        dest: hipDeviceptr_t,
        value: ::std::os::raw::c_int,
        count: usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Fills the first sizeBytes bytes of the memory area pointed to by dev with the constant\n byte value value.\n\n hipMemsetAsync() is asynchronous with respect to the host, so the call may return before the\n memset is complete. The operation can optionally be associated to a stream by passing a non-zero\n stream argument. If stream is non-zero, the operation may overlap with operations in other\n streams.\n\n  @param[out] dst Pointer to device memory\n  @param[in]  value  Value to set for each byte of specified memory\n  @param[in]  sizeBytes  Size in bytes to set\n  @param[in]  stream  Stream identifier\n  @return #hipSuccess, #hipErrorInvalidValue"]
    pub fn hipMemsetAsync(
        dst: *mut ::std::os::raw::c_void,
        value: ::std::os::raw::c_int,
        sizeBytes: usize,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Fills the memory area pointed to by dev with the constant integer\n value for specified number of times.\n\n  hipMemsetD32Async() is asynchronous with respect to the host, so the call may return before the\n memset is complete. The operation can optionally be associated to a stream by passing a non-zero\n stream argument. If stream is non-zero, the operation may overlap with operations in other\n streams.\n\n  @param[out] dst Pointer to device memory\n  @param[in]  value  Value to set for each byte of specified memory\n  @param[in]  count  Number of values to be set\n  @param[in]  stream  Stream identifier\n  @return #hipSuccess, #hipErrorInvalidValue"]
    pub fn hipMemsetD32Async(
        dst: hipDeviceptr_t,
        value: ::std::os::raw::c_int,
        count: usize,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Fills the memory area pointed to by dst with the constant value.\n\n  @param[out] dst Pointer to device memory\n  @param[in]  pitch  Data size in bytes\n  @param[in]  value  Constant value to be set\n  @param[in]  width\n  @param[in]  height\n  @returns #hipSuccess, #hipErrorInvalidValue"]
    pub fn hipMemset2D(
        dst: *mut ::std::os::raw::c_void,
        pitch: usize,
        value: ::std::os::raw::c_int,
        width: usize,
        height: usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Fills asynchronously the memory area pointed to by dst with the constant value.\n\n  @param[in]  dst Pointer to 2D device memory\n  @param[in]  pitch  Pitch size in bytes\n  @param[in]  value  Value to be set for each byte of specified memory\n  @param[in]  width  Width of matrix set columns in bytes\n  @param[in]  height  Height of matrix set rows in bytes\n  @param[in]  stream  Stream identifier\n  @returns #hipSuccess, #hipErrorInvalidValue"]
    pub fn hipMemset2DAsync(
        dst: *mut ::std::os::raw::c_void,
        pitch: usize,
        value: ::std::os::raw::c_int,
        width: usize,
        height: usize,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Fills synchronously the memory area pointed to by pitchedDevPtr with the constant value.\n\n  @param[in] pitchedDevPtr  Pointer to pitched device memory\n  @param[in]  value  Value to set for each byte of specified memory\n  @param[in]  extent  Size parameters for width field in bytes in device memory\n  @returns #hipSuccess, #hipErrorInvalidValue"]
    pub fn hipMemset3D(
        pitchedDevPtr: hipPitchedPtr,
        value: ::std::os::raw::c_int,
        extent: hipExtent,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Fills asynchronously the memory area pointed to by pitchedDevPtr with the constant value.\n\n  @param[in] pitchedDevPtr  Pointer to pitched device memory\n  @param[in]  value  Value to set for each byte of specified memory\n  @param[in]  extent  Size parameters for width field in bytes in device memory\n  @param[in]  stream  Stream identifier\n  @returns #hipSuccess, #hipErrorInvalidValue"]
    pub fn hipMemset3DAsync(
        pitchedDevPtr: hipPitchedPtr,
        value: ::std::os::raw::c_int,
        extent: hipExtent,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Query memory info.\n\n On ROCM, this function gets the actual free memory left on the current device, so supports\n the cases while running multi-workload (such as multiple processes, multiple threads, and\n multiple GPUs).\n\n @warning On Windows, the free memory only accounts for memory allocated by this process and may\n be optimistic.\n\n @param[out] free Returns free memory on the current device in bytes\n @param[out] total Returns total allocatable memory on the current device in bytes\n\n @returns #hipSuccess, #hipErrorInvalidDevice, #hipErrorInvalidValue\n"]
    pub fn hipMemGetInfo(free: *mut usize, total: *mut usize) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Get allocated memory size via memory pointer.\n\n This function gets the allocated shared virtual memory size from memory pointer.\n\n @param[in] ptr Pointer to allocated memory\n @param[out] size Returns the allocated memory size in bytes\n\n @returns #hipSuccess, #hipErrorInvalidValue\n"]
    pub fn hipMemPtrGetInfo(ptr: *mut ::std::os::raw::c_void, size: *mut usize) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Allocate an array on the device.\n\n  @param[out]  array  Pointer to allocated array in device memory\n  @param[in]   desc   Requested channel format\n  @param[in]   width  Requested array allocation width\n  @param[in]   height Requested array allocation height\n  @param[in]   flags  Requested properties of allocated array\n  @returns     #hipSuccess, #hipErrorOutOfMemory\n\n  @see hipMalloc, hipMallocPitch, hipFree, hipFreeArray, hipHostMalloc, hipHostFree"]
    pub fn hipMallocArray(
        array: *mut hipArray_t,
        desc: *const hipChannelFormatDesc,
        width: usize,
        height: usize,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Create an array memory pointer on the device.\n\n  @param[out]  pHandle  Pointer to the array memory\n  @param[in]   pAllocateArray   Requested array desciptor\n\n  @returns     #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n\n  @see hipMallocArray, hipArrayDestroy, hipFreeArray"]
    pub fn hipArrayCreate(
        pHandle: *mut hipArray_t,
        pAllocateArray: *const HIP_ARRAY_DESCRIPTOR,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Destroy an array memory pointer on the device.\n\n  @param[in]  array  Pointer to the array memory\n\n  @returns     #hipSuccess, #hipErrorInvalidValue\n\n  @see hipArrayCreate, hipArrayDestroy, hipFreeArray"]
    pub fn hipArrayDestroy(array: hipArray_t) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Create a 3D array memory pointer on the device.\n\n  @param[out]  array  Pointer to the 3D array memory\n  @param[in]   pAllocateArray   Requested array desciptor\n\n  @returns     #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n\n  @see hipMallocArray, hipArrayDestroy, hipFreeArray"]
    pub fn hipArray3DCreate(
        array: *mut hipArray_t,
        pAllocateArray: *const HIP_ARRAY3D_DESCRIPTOR,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Create a 3D memory pointer on the device.\n\n  @param[out]  pitchedDevPtr  Pointer to the 3D memory\n  @param[in]   extent   Requested extent\n\n  @returns     #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n\n  @see hipMallocPitch, hipMemGetInfo, hipFree"]
    pub fn hipMalloc3D(pitchedDevPtr: *mut hipPitchedPtr, extent: hipExtent) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Frees an array on the device.\n\n  @param[in]  array  Pointer to array to free\n  @returns    #hipSuccess, #hipErrorInvalidValue, #hipErrorNotInitialized\n\n  @see hipMalloc, hipMallocPitch, hipFree, hipMallocArray, hipHostMalloc, hipHostFree"]
    pub fn hipFreeArray(array: hipArray_t) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Allocate an array on the device.\n\n  @param[out]  array  Pointer to allocated array in device memory\n  @param[in]   desc   Requested channel format\n  @param[in]   extent Requested array allocation width, height and depth\n  @param[in]   flags  Requested properties of allocated array\n  @returns     #hipSuccess, #hipErrorOutOfMemory\n\n  @see hipMalloc, hipMallocPitch, hipFree, hipFreeArray, hipHostMalloc, hipHostFree"]
    pub fn hipMalloc3DArray(
        array: *mut hipArray_t,
        desc: *const hipChannelFormatDesc,
        extent: hipExtent,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets info about the specified array\n\n @param[out] desc   - Returned array type\n @param[out] extent - Returned array shape. 2D arrays will have depth of zero\n @param[out] flags  - Returned array flags\n @param[in]  array  - The HIP array to get info for\n\n @returns #hipSuccess, #hipErrorInvalidValue #hipErrorInvalidHandle\n\n @see hipArrayGetDescriptor, hipArray3DGetDescriptor"]
    pub fn hipArrayGetInfo(
        desc: *mut hipChannelFormatDesc,
        extent: *mut hipExtent,
        flags: *mut ::std::os::raw::c_uint,
        array: hipArray_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets a 1D or 2D array descriptor\n\n @param[out] pArrayDescriptor - Returned array descriptor\n @param[in]  array            - Array to get descriptor of\n\n @returns #hipSuccess, #hipErrorDeinitialized, #hipErrorNotInitialized, #hipErrorInvalidContext,\n #hipErrorInvalidValue #hipErrorInvalidHandle\n\n @see hipArray3DCreate, hipArray3DGetDescriptor, hipArrayCreate, hipArrayDestroy, hipMemAlloc,\n hipMemAllocHost, hipMemAllocPitch, hipMemcpy2D, hipMemcpy2DAsync, hipMemcpy2DUnaligned,\n hipMemcpy3D, hipMemcpy3DAsync, hipMemcpyAtoA, hipMemcpyAtoD, hipMemcpyAtoH, hipMemcpyAtoHAsync,\n hipMemcpyDtoA, hipMemcpyDtoD, hipMemcpyDtoDAsync, hipMemcpyDtoH, hipMemcpyDtoHAsync,\n hipMemcpyHtoA, hipMemcpyHtoAAsync, hipMemcpyHtoD, hipMemcpyHtoDAsync, hipMemFree,\n hipMemFreeHost, hipMemGetAddressRange, hipMemGetInfo, hipMemHostAlloc,\n hipMemHostGetDevicePointer, hipMemsetD8, hipMemsetD16, hipMemsetD32, hipArrayGetInfo"]
    pub fn hipArrayGetDescriptor(
        pArrayDescriptor: *mut HIP_ARRAY_DESCRIPTOR,
        array: hipArray_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets a 3D array descriptor\n\n @param[out] pArrayDescriptor - Returned 3D array descriptor\n @param[in]  array            - 3D array to get descriptor of\n\n @returns #hipSuccess, #hipErrorDeinitialized, #hipErrorNotInitialized, #hipErrorInvalidContext,\n #hipErrorInvalidValue #hipErrorInvalidHandle, #hipErrorContextIsDestroyed\n\n @see hipArray3DCreate, hipArrayCreate, hipArrayDestroy, hipArrayGetDescriptor, hipMemAlloc,\n hipMemAllocHost, hipMemAllocPitch, hipMemcpy2D, hipMemcpy2DAsync, hipMemcpy2DUnaligned,\n hipMemcpy3D, hipMemcpy3DAsync, hipMemcpyAtoA, hipMemcpyAtoD, hipMemcpyAtoH, hipMemcpyAtoHAsync,\n hipMemcpyDtoA, hipMemcpyDtoD, hipMemcpyDtoDAsync, hipMemcpyDtoH, hipMemcpyDtoHAsync,\n hipMemcpyHtoA, hipMemcpyHtoAAsync, hipMemcpyHtoD, hipMemcpyHtoDAsync, hipMemFree,\n hipMemFreeHost, hipMemGetAddressRange, hipMemGetInfo, hipMemHostAlloc,\n hipMemHostGetDevicePointer, hipMemsetD8, hipMemsetD16, hipMemsetD32, hipArrayGetInfo"]
    pub fn hipArray3DGetDescriptor(
        pArrayDescriptor: *mut HIP_ARRAY3D_DESCRIPTOR,
        array: hipArray_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copies data between host and device.\n\n  @param[in]   dst    Destination memory address\n  @param[in]   dpitch Pitch of destination memory\n  @param[in]   src    Source memory address\n  @param[in]   spitch Pitch of source memory\n  @param[in]   width  Width of matrix transfer (columns in bytes)\n  @param[in]   height Height of matrix transfer (rows)\n  @param[in]   kind   Type of transfer\n  @returns     #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidPitchValue,\n #hipErrorInvalidDevicePointer, #hipErrorInvalidMemcpyDirection\n\n  @see hipMemcpy, hipMemcpyToArray, hipMemcpy2DToArray, hipMemcpyFromArray, hipMemcpyToSymbol,\n hipMemcpyAsync"]
    pub fn hipMemcpy2D(
        dst: *mut ::std::os::raw::c_void,
        dpitch: usize,
        src: *const ::std::os::raw::c_void,
        spitch: usize,
        width: usize,
        height: usize,
        kind: hipMemcpyKind,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copies memory for 2D arrays.\n  @param[in]   pCopy Parameters for the memory copy\n  @returns     #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidPitchValue,\n  #hipErrorInvalidDevicePointer, #hipErrorInvalidMemcpyDirection\n\n  @see hipMemcpy, hipMemcpy2D, hipMemcpyToArray, hipMemcpy2DToArray, hipMemcpyFromArray,\n hipMemcpyToSymbol, hipMemcpyAsync"]
    pub fn hipMemcpyParam2D(pCopy: *const hip_Memcpy2D) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copies memory for 2D arrays.\n  @param[in]   pCopy Parameters for the memory copy\n  @param[in]   stream Stream to use\n  @returns     #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidPitchValue,\n #hipErrorInvalidDevicePointer, #hipErrorInvalidMemcpyDirection\n\n  @see hipMemcpy, hipMemcpy2D, hipMemcpyToArray, hipMemcpy2DToArray, hipMemcpyFromArray,\n hipMemcpyToSymbol, hipMemcpyAsync"]
    pub fn hipMemcpyParam2DAsync(pCopy: *const hip_Memcpy2D, stream: hipStream_t) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copies data between host and device.\n\n  @param[in]   dst    Destination memory address\n  @param[in]   dpitch Pitch of destination memory\n  @param[in]   src    Source memory address\n  @param[in]   spitch Pitch of source memory\n  @param[in]   width  Width of matrix transfer (columns in bytes)\n  @param[in]   height Height of matrix transfer (rows)\n  @param[in]   kind   Type of transfer\n  @param[in]   stream Stream to use\n  @returns     #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidPitchValue,\n #hipErrorInvalidDevicePointer, #hipErrorInvalidMemcpyDirection\n\n  @see hipMemcpy, hipMemcpyToArray, hipMemcpy2DToArray, hipMemcpyFromArray, hipMemcpyToSymbol,\n hipMemcpyAsync"]
    pub fn hipMemcpy2DAsync(
        dst: *mut ::std::os::raw::c_void,
        dpitch: usize,
        src: *const ::std::os::raw::c_void,
        spitch: usize,
        width: usize,
        height: usize,
        kind: hipMemcpyKind,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copies data between host and device.\n\n  @param[in]   dst     Destination memory address\n  @param[in]   wOffset Destination starting X offset\n  @param[in]   hOffset Destination starting Y offset\n  @param[in]   src     Source memory address\n  @param[in]   spitch  Pitch of source memory\n  @param[in]   width   Width of matrix transfer (columns in bytes)\n  @param[in]   height  Height of matrix transfer (rows)\n  @param[in]   kind    Type of transfer\n  @returns     #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidPitchValue,\n #hipErrorInvalidDevicePointer, #hipErrorInvalidMemcpyDirection\n\n  @see hipMemcpy, hipMemcpyToArray, hipMemcpy2D, hipMemcpyFromArray, hipMemcpyToSymbol,\n hipMemcpyAsync"]
    pub fn hipMemcpy2DToArray(
        dst: hipArray_t,
        wOffset: usize,
        hOffset: usize,
        src: *const ::std::os::raw::c_void,
        spitch: usize,
        width: usize,
        height: usize,
        kind: hipMemcpyKind,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copies data between host and device.\n\n  @param[in]   dst     Destination memory address\n  @param[in]   wOffset Destination starting X offset\n  @param[in]   hOffset Destination starting Y offset\n  @param[in]   src     Source memory address\n  @param[in]   spitch  Pitch of source memory\n  @param[in]   width   Width of matrix transfer (columns in bytes)\n  @param[in]   height  Height of matrix transfer (rows)\n  @param[in]   kind    Type of transfer\n  @param[in]   stream    Accelerator view which the copy is being enqueued\n  @returns     #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidPitchValue,\n #hipErrorInvalidDevicePointer, #hipErrorInvalidMemcpyDirection\n\n  @see hipMemcpy, hipMemcpyToArray, hipMemcpy2D, hipMemcpyFromArray, hipMemcpyToSymbol,\n hipMemcpyAsync"]
    pub fn hipMemcpy2DToArrayAsync(
        dst: hipArray_t,
        wOffset: usize,
        hOffset: usize,
        src: *const ::std::os::raw::c_void,
        spitch: usize,
        width: usize,
        height: usize,
        kind: hipMemcpyKind,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copies data between host and device.\n\n  @param[in]   dst Destination memory address\n  @param[in]   wOffsetDst Destination starting X offset\n  @param[in]   hOffsetDst Destination starting Y offset\n  @param[in]   src  Source memory address\n  @param[in]   wOffsetSrc Source starting X offset\n  @param[in]   hOffsetSrc Source starting Y offset (columns in bytes)\n  @param[in]   width  Width of matrix transfer (columns in bytes)\n  @param[in]   height  Height of matrix transfer (rows)\n  @param[in]   kind Type of transfer\n\n  @returns     #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidMemcpyDirection\n\n  @see hipMemcpy, hipMemcpyToArray, hipMemcpy2D, hipMemcpyFromArray, hipMemcpyToSymbol,\n hipMemcpyAsync"]
    pub fn hipMemcpy2DArrayToArray(
        dst: hipArray_t,
        wOffsetDst: usize,
        hOffsetDst: usize,
        src: hipArray_const_t,
        wOffsetSrc: usize,
        hOffsetSrc: usize,
        width: usize,
        height: usize,
        kind: hipMemcpyKind,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copies data between host and device [Deprecated]\n\n  @ingroup MemoryD\n\n  @param[in]   dst     Destination memory address\n  @param[in]   wOffset Destination starting X offset\n  @param[in]   hOffset Destination starting Y offset\n  @param[in]   src     Source memory address\n  @param[in]   count   size in bytes to copy\n  @param[in]   kind    Type of transfer\n  @returns     #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidPitchValue,\n #hipErrorInvalidDevicePointer, #hipErrorInvalidMemcpyDirection\n\n  @see hipMemcpy, hipMemcpy2DToArray, hipMemcpy2D, hipMemcpyFromArray, hipMemcpyToSymbol,\n  hipMemcpyAsync\n  @warning  This API is deprecated."]
    pub fn hipMemcpyToArray(
        dst: hipArray_t,
        wOffset: usize,
        hOffset: usize,
        src: *const ::std::os::raw::c_void,
        count: usize,
        kind: hipMemcpyKind,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copies data between host and device [Deprecated]\n\n  @ingroup MemoryD\n\n  @param[in]   dst       Destination memory address\n  @param[in]   srcArray  Source memory address\n  @param[in]   wOffset   Source starting X offset\n  @param[in]   hOffset   Source starting Y offset\n  @param[in]   count     Size in bytes to copy\n  @param[in]   kind      Type of transfer\n  @returns     #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidPitchValue,\n #hipErrorInvalidDevicePointer, #hipErrorInvalidMemcpyDirection\n\n  @see hipMemcpy, hipMemcpy2DToArray, hipMemcpy2D, hipMemcpyFromArray, hipMemcpyToSymbol,\n hipMemcpyAsync\n @warning  This API is deprecated."]
    pub fn hipMemcpyFromArray(
        dst: *mut ::std::os::raw::c_void,
        srcArray: hipArray_const_t,
        wOffset: usize,
        hOffset: usize,
        count: usize,
        kind: hipMemcpyKind,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copies data between host and device.\n\n  @param[in]   dst       Destination memory address\n  @param[in]   dpitch    Pitch of destination memory\n  @param[in]   src       Source memory address\n  @param[in]   wOffset   Source starting X offset\n  @param[in]   hOffset   Source starting Y offset\n  @param[in]   width     Width of matrix transfer (columns in bytes)\n  @param[in]   height    Height of matrix transfer (rows)\n  @param[in]   kind      Type of transfer\n  @returns     #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidPitchValue,\n #hipErrorInvalidDevicePointer, #hipErrorInvalidMemcpyDirection\n\n  @see hipMemcpy, hipMemcpy2DToArray, hipMemcpy2D, hipMemcpyFromArray, hipMemcpyToSymbol,\n hipMemcpyAsync"]
    pub fn hipMemcpy2DFromArray(
        dst: *mut ::std::os::raw::c_void,
        dpitch: usize,
        src: hipArray_const_t,
        wOffset: usize,
        hOffset: usize,
        width: usize,
        height: usize,
        kind: hipMemcpyKind,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copies data between host and device asynchronously.\n\n  @param[in]   dst       Destination memory address\n  @param[in]   dpitch    Pitch of destination memory\n  @param[in]   src       Source memory address\n  @param[in]   wOffset   Source starting X offset\n  @param[in]   hOffset   Source starting Y offset\n  @param[in]   width     Width of matrix transfer (columns in bytes)\n  @param[in]   height    Height of matrix transfer (rows)\n  @param[in]   kind      Type of transfer\n  @param[in]   stream    Accelerator view which the copy is being enqueued\n  @returns     #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidPitchValue,\n #hipErrorInvalidDevicePointer, #hipErrorInvalidMemcpyDirection\n\n  @see hipMemcpy, hipMemcpy2DToArray, hipMemcpy2D, hipMemcpyFromArray, hipMemcpyToSymbol,\n hipMemcpyAsync"]
    pub fn hipMemcpy2DFromArrayAsync(
        dst: *mut ::std::os::raw::c_void,
        dpitch: usize,
        src: hipArray_const_t,
        wOffset: usize,
        hOffset: usize,
        width: usize,
        height: usize,
        kind: hipMemcpyKind,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copies data between host and device.\n\n  @param[in]   dst       Destination memory address\n  @param[in]   srcArray  Source array\n  @param[in]   srcOffset Offset in bytes of source array\n  @param[in]   count     Size of memory copy in bytes\n  @returns     #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidPitchValue,\n #hipErrorInvalidDevicePointer, #hipErrorInvalidMemcpyDirection\n\n  @see hipMemcpy, hipMemcpy2DToArray, hipMemcpy2D, hipMemcpyFromArray, hipMemcpyToSymbol,\n hipMemcpyAsync"]
    pub fn hipMemcpyAtoH(
        dst: *mut ::std::os::raw::c_void,
        srcArray: hipArray_t,
        srcOffset: usize,
        count: usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copies data between host and device.\n\n  @param[in]   dstArray   Destination memory address\n  @param[in]   dstOffset  Offset in bytes of destination array\n  @param[in]   srcHost    Source host pointer\n  @param[in]   count      Size of memory copy in bytes\n  @returns     #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidPitchValue,\n #hipErrorInvalidDevicePointer, #hipErrorInvalidMemcpyDirection\n\n  @see hipMemcpy, hipMemcpy2DToArray, hipMemcpy2D, hipMemcpyFromArray, hipMemcpyToSymbol,\n hipMemcpyAsync"]
    pub fn hipMemcpyHtoA(
        dstArray: hipArray_t,
        dstOffset: usize,
        srcHost: *const ::std::os::raw::c_void,
        count: usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copies data between host and device.\n\n  @param[in]   p   3D memory copy parameters\n  @returns     #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidPitchValue,\n #hipErrorInvalidDevicePointer, #hipErrorInvalidMemcpyDirection\n\n  @see hipMemcpy, hipMemcpy2DToArray, hipMemcpy2D, hipMemcpyFromArray, hipMemcpyToSymbol,\n hipMemcpyAsync"]
    pub fn hipMemcpy3D(p: *const hipMemcpy3DParms) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copies data between host and device asynchronously.\n\n  @param[in]   p        3D memory copy parameters\n  @param[in]   stream   Stream to use\n  @returns     #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidPitchValue,\n #hipErrorInvalidDevicePointer, #hipErrorInvalidMemcpyDirection\n\n  @see hipMemcpy, hipMemcpy2DToArray, hipMemcpy2D, hipMemcpyFromArray, hipMemcpyToSymbol,\n hipMemcpyAsync"]
    pub fn hipMemcpy3DAsync(p: *const hipMemcpy3DParms, stream: hipStream_t) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copies data between host and device.\n\n  @param[in]   pCopy   3D memory copy parameters\n  @returns     #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidPitchValue,\n  #hipErrorInvalidDevicePointer, #hipErrorInvalidMemcpyDirection\n\n  @see hipMemcpy, hipMemcpy2DToArray, hipMemcpy2D, hipMemcpyFromArray, hipMemcpyToSymbol,\n hipMemcpyAsync"]
    pub fn hipDrvMemcpy3D(pCopy: *const HIP_MEMCPY3D) -> hipError_t;
}
extern "C" {
    #[doc = "  @brief Copies data between host and device asynchronously.\n\n  @param[in]   pCopy    3D memory copy parameters\n  @param[in]   stream   Stream to use\n  @returns     #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidPitchValue,\n  #hipErrorInvalidDevicePointer, #hipErrorInvalidMemcpyDirection\n\n  @see hipMemcpy, hipMemcpy2DToArray, hipMemcpy2D, hipMemcpyFromArray, hipMemcpyToSymbol,\n hipMemcpyAsync"]
    pub fn hipDrvMemcpy3DAsync(pCopy: *const HIP_MEMCPY3D, stream: hipStream_t) -> hipError_t;
}
extern "C" {
    #[doc = " @}\n/\n/**\n-------------------------------------------------------------------------------------------------\n-------------------------------------------------------------------------------------------------\n  @defgroup PeerToPeer PeerToPeer Device Memory Access\n  @{\n  @warning PeerToPeer support is experimental.\n  This section describes the PeerToPeer device memory access functions of HIP runtime API.\n/\n/**\n @brief Determine if a device can access a peer's memory.\n\n @param [out] canAccessPeer Returns the peer access capability (0 or 1)\n @param [in] deviceId - device from where memory may be accessed.\n @param [in] peerDeviceId - device where memory is physically located\n\n Returns \"1\" in @p canAccessPeer if the specified @p device is capable\n of directly accessing memory physically located on peerDevice , or \"0\" if not.\n\n Returns \"0\" in @p canAccessPeer if deviceId == peerDeviceId, and both are valid devices : a\n device is not a peer of itself.\n\n @returns #hipSuccess,\n @returns #hipErrorInvalidDevice if deviceId or peerDeviceId are not valid devices"]
    pub fn hipDeviceCanAccessPeer(
        canAccessPeer: *mut ::std::os::raw::c_int,
        deviceId: ::std::os::raw::c_int,
        peerDeviceId: ::std::os::raw::c_int,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Enable direct access from current device's virtual address space to memory allocations\n physically located on a peer device.\n\n Memory which already allocated on peer device will be mapped into the address space of the\n current device.  In addition, all future memory allocations on peerDeviceId will be mapped into\n the address space of the current device when the memory is allocated. The peer memory remains\n accessible from the current device until a call to hipDeviceDisablePeerAccess or hipDeviceReset.\n\n\n @param [in] peerDeviceId  Peer device to enable direct access to from the current device\n @param [in] flags  Reserved for future use, must be zero\n\n Returns #hipSuccess, #hipErrorInvalidDevice, #hipErrorInvalidValue,\n @returns #hipErrorPeerAccessAlreadyEnabled if peer access is already enabled for this device."]
    pub fn hipDeviceEnablePeerAccess(
        peerDeviceId: ::std::os::raw::c_int,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Disable direct access from current device's virtual address space to memory allocations\n physically located on a peer device.\n\n Returns hipErrorPeerAccessNotEnabled if direct access to memory on peerDevice has not yet been\n enabled from the current device.\n\n @param [in] peerDeviceId  Peer device to disable direct access to\n\n @returns #hipSuccess, #hipErrorPeerAccessNotEnabled"]
    pub fn hipDeviceDisablePeerAccess(peerDeviceId: ::std::os::raw::c_int) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Get information on memory allocations.\n\n @param [out] pbase - BAse pointer address\n @param [out] psize - Size of allocation\n @param [in]  dptr- Device Pointer\n\n @returns #hipSuccess, #hipErrorNotFound\n\n @see hipCtxCreate, hipCtxDestroy, hipCtxGetFlags, hipCtxPopCurrent, hipCtxGetCurrent,\n hipCtxSetCurrent, hipCtxPushCurrent, hipCtxSetCacheConfig, hipCtxSynchronize, hipCtxGetDevice"]
    pub fn hipMemGetAddressRange(
        pbase: *mut hipDeviceptr_t,
        psize: *mut usize,
        dptr: hipDeviceptr_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Copies memory from one device to memory on another device.\n\n @param [out] dst - Destination device pointer.\n @param [in] dstDeviceId - Destination device\n @param [in] src - Source device pointer\n @param [in] srcDeviceId - Source device\n @param [in] sizeBytes - Size of memory copy in bytes\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidDevice"]
    pub fn hipMemcpyPeer(
        dst: *mut ::std::os::raw::c_void,
        dstDeviceId: ::std::os::raw::c_int,
        src: *const ::std::os::raw::c_void,
        srcDeviceId: ::std::os::raw::c_int,
        sizeBytes: usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Copies memory from one device to memory on another device.\n\n @param [out] dst - Destination device pointer.\n @param [in] dstDeviceId - Destination device\n @param [in] src - Source device pointer\n @param [in] srcDevice - Source device\n @param [in] sizeBytes - Size of memory copy in bytes\n @param [in] stream - Stream identifier\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidDevice"]
    pub fn hipMemcpyPeerAsync(
        dst: *mut ::std::os::raw::c_void,
        dstDeviceId: ::std::os::raw::c_int,
        src: *const ::std::os::raw::c_void,
        srcDevice: ::std::os::raw::c_int,
        sizeBytes: usize,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Create a context and set it as current/default context\n\n @param [out] ctx  Context to create\n @param [in] flags  Context creation flags\n @param [in] device  device handle\n\n @returns #hipSuccess\n\n @see hipCtxDestroy, hipCtxGetFlags, hipCtxPopCurrent, hipCtxGetCurrent, hipCtxPushCurrent,\n hipCtxSetCacheConfig, hipCtxSynchronize, hipCtxGetDevice\n\n @warning  This API is deprecated on the AMD platform, only for equivalent cuCtx driver API on the\n NVIDIA platform.\n"]
    pub fn hipCtxCreate(
        ctx: *mut hipCtx_t,
        flags: ::std::os::raw::c_uint,
        device: hipDevice_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Destroy a HIP context [Deprecated]\n\n @param [in] ctx Context to destroy\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @see hipCtxCreate, hipCtxGetFlags, hipCtxPopCurrent, hipCtxGetCurrent,hipCtxSetCurrent,\n hipCtxPushCurrent, hipCtxSetCacheConfig, hipCtxSynchronize , hipCtxGetDevice\n\n @warning  This API is deprecated on the AMD platform, only for equivalent cuCtx driver API on the\n NVIDIA platform."]
    pub fn hipCtxDestroy(ctx: hipCtx_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Pop the current/default context and return the popped context [Deprecated]\n\n @param [out] ctx  The current context to pop\n\n @returns #hipSuccess, #hipErrorInvalidContext\n\n @see hipCtxCreate, hipCtxDestroy, hipCtxGetFlags, hipCtxSetCurrent, hipCtxGetCurrent,\n hipCtxPushCurrent, hipCtxSetCacheConfig, hipCtxSynchronize, hipCtxGetDevice\n\n @warning  This API is deprecated on the AMD platform, only for equivalent cuCtx driver API on the\n NVIDIA platform."]
    pub fn hipCtxPopCurrent(ctx: *mut hipCtx_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Push the context to be set as current/ default context [Deprecated]\n\n @param [in] ctx  The current context to push\n\n @returns #hipSuccess, #hipErrorInvalidContext\n\n @see hipCtxCreate, hipCtxDestroy, hipCtxGetFlags, hipCtxPopCurrent, hipCtxGetCurrent,\n hipCtxPushCurrent, hipCtxSetCacheConfig, hipCtxSynchronize , hipCtxGetDevice\n\n @warning  This API is deprecated on the AMD platform, only for equivalent cuCtx driver API on the\n NVIDIA platform."]
    pub fn hipCtxPushCurrent(ctx: hipCtx_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Set the passed context as current/default [Deprecated]\n\n @param [in] ctx The context to set as current\n\n @returns #hipSuccess, #hipErrorInvalidContext\n\n @see hipCtxCreate, hipCtxDestroy, hipCtxGetFlags, hipCtxPopCurrent, hipCtxGetCurrent,\n hipCtxPushCurrent, hipCtxSetCacheConfig, hipCtxSynchronize , hipCtxGetDevice\n\n @warning  This API is deprecated on the AMD platform, only for equivalent cuCtx driver API on the\n NVIDIA platform."]
    pub fn hipCtxSetCurrent(ctx: hipCtx_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Get the handle of the current/ default context [Deprecated]\n\n @param [out] ctx  The context to get as current\n\n @returns #hipSuccess, #hipErrorInvalidContext\n\n @see hipCtxCreate, hipCtxDestroy, hipCtxGetDevice, hipCtxGetFlags, hipCtxPopCurrent,\n hipCtxPushCurrent, hipCtxSetCacheConfig, hipCtxSynchronize, hipCtxGetDevice\n\n @warning  This API is deprecated on the AMD platform, only for equivalent cuCtx driver API on the\n NVIDIA platform."]
    pub fn hipCtxGetCurrent(ctx: *mut hipCtx_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Get the handle of the device associated with current/default context [Deprecated]\n\n @param [out] device The device from the current context\n\n @returns #hipSuccess, #hipErrorInvalidContext\n\n @see hipCtxCreate, hipCtxDestroy, hipCtxGetFlags, hipCtxPopCurrent, hipCtxGetCurrent,\n hipCtxPushCurrent, hipCtxSetCacheConfig, hipCtxSynchronize\n\n @warning  This API is deprecated on the AMD platform, only for equivalent cuCtx driver API on the\n NVIDIA platform."]
    pub fn hipCtxGetDevice(device: *mut hipDevice_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns the approximate HIP api version.\n\n @param [in]  ctx Context to check [Deprecated]\n @param [out] apiVersion API version to get\n\n @returns #hipSuccess\n\n @warning The HIP feature set does not correspond to an exact CUDA SDK api revision.\n This function always set *apiVersion to 4 as an approximation though HIP supports\n some features which were introduced in later CUDA SDK revisions.\n HIP apps code should not rely on the api revision number here and should\n use arch feature flags to test device capabilities or conditional compilation.\n\n @see hipCtxCreate, hipCtxDestroy, hipCtxGetDevice, hipCtxGetFlags, hipCtxPopCurrent,\n hipCtxPushCurrent, hipCtxSetCacheConfig, hipCtxSynchronize, hipCtxGetDevice\n\n @warning  This API is deprecated on the AMD platform, only for equivalent cuCtx driver API on the\n NVIDIA platform."]
    pub fn hipCtxGetApiVersion(ctx: hipCtx_t, apiVersion: *mut ::std::os::raw::c_int)
        -> hipError_t;
}
extern "C" {
    #[doc = " @brief Get Cache configuration for a specific function [Deprecated]\n\n @param [out] cacheConfig  Cache configuration\n\n @returns #hipSuccess\n\n @warning AMD devices and some Nvidia GPUS do not support reconfigurable cache.  This hint is\n ignored on those architectures.\n\n @see hipCtxCreate, hipCtxDestroy, hipCtxGetFlags, hipCtxPopCurrent, hipCtxGetCurrent,\n hipCtxSetCurrent, hipCtxPushCurrent, hipCtxSetCacheConfig, hipCtxSynchronize, hipCtxGetDevice\n\n @warning  This API is deprecated on the AMD platform, only for equivalent cuCtx driver API on the\n NVIDIA platform."]
    pub fn hipCtxGetCacheConfig(cacheConfig: *mut hipFuncCache_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Set L1/Shared cache partition [Deprecated]\n\n @param [in] cacheConfig  Cache configuration to set\n\n @return #hipSuccess\n\n @warning AMD devices and some Nvidia GPUS do not support reconfigurable cache.  This hint is\n ignored on those architectures.\n\n @see hipCtxCreate, hipCtxDestroy, hipCtxGetFlags, hipCtxPopCurrent, hipCtxGetCurrent,\n hipCtxSetCurrent, hipCtxPushCurrent, hipCtxSetCacheConfig, hipCtxSynchronize, hipCtxGetDevice\n\n @warning  This API is deprecated on the AMD platform, only for equivalent cuCtx driver API on the\n NVIDIA platform."]
    pub fn hipCtxSetCacheConfig(cacheConfig: hipFuncCache_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Set Shared memory bank configuration  [Deprecated]\n\n @param [in] config  Shared memory configuration to set\n\n @return #hipSuccess\n\n @warning AMD devices and some Nvidia GPUS do not support shared cache banking, and the hint is\n ignored on those architectures.\n\n @see hipCtxCreate, hipCtxDestroy, hipCtxGetFlags, hipCtxPopCurrent, hipCtxGetCurrent,\n hipCtxSetCurrent, hipCtxPushCurrent, hipCtxSetCacheConfig, hipCtxSynchronize, hipCtxGetDevice\n\n @warning  This API is deprecated on the AMD platform, only for equivalent cuCtx driver API on the\n NVIDIA platform."]
    pub fn hipCtxSetSharedMemConfig(config: hipSharedMemConfig) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Get Shared memory bank configuration [Deprecated]\n\n @param [out] pConfig  Pointer of shared memory configuration\n\n @return #hipSuccess\n\n @warning AMD devices and some Nvidia GPUS do not support shared cache banking, and the hint is\n ignored on those architectures.\n\n @see hipCtxCreate, hipCtxDestroy, hipCtxGetFlags, hipCtxPopCurrent, hipCtxGetCurrent,\n hipCtxSetCurrent, hipCtxPushCurrent, hipCtxSetCacheConfig, hipCtxSynchronize, hipCtxGetDevice\n\n @warning  This API is deprecated on the AMD platform, only for equivalent cuCtx driver API on the\n NVIDIA platform."]
    pub fn hipCtxGetSharedMemConfig(pConfig: *mut hipSharedMemConfig) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Blocks until the default context has completed all preceding requested tasks [Deprecated]\n\n @return #hipSuccess\n\n @warning This function waits for all streams on the default context to complete execution, and\n then returns.\n\n @see hipCtxCreate, hipCtxDestroy, hipCtxGetFlags, hipCtxPopCurrent, hipCtxGetCurrent,\n hipCtxSetCurrent, hipCtxPushCurrent, hipCtxSetCacheConfig, hipCtxGetDevice\n\n @warning  This API is deprecated on the AMD platform, only for equivalent cuCtx driver API on the\n NVIDIA platform."]
    pub fn hipCtxSynchronize() -> hipError_t;
}
extern "C" {
    #[doc = " @brief Return flags used for creating default context [Deprecated]\n\n @param [out] flags  Pointer of flags\n\n @returns #hipSuccess\n\n @see hipCtxCreate, hipCtxDestroy, hipCtxPopCurrent, hipCtxGetCurrent, hipCtxGetCurrent,\n hipCtxSetCurrent, hipCtxPushCurrent, hipCtxSetCacheConfig, hipCtxSynchronize, hipCtxGetDevice\n\n @warning  This API is deprecated on the AMD platform, only for equivalent cuCtx driver API on the\n NVIDIA platform."]
    pub fn hipCtxGetFlags(flags: *mut ::std::os::raw::c_uint) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Enables direct access to memory allocations in a peer context [Deprecated]\n\n Memory which already allocated on peer device will be mapped into the address space of the\n current device.  In addition, all future memory allocations on peerDeviceId will be mapped into\n the address space of the current device when the memory is allocated. The peer memory remains\n accessible from the current device until a call to hipDeviceDisablePeerAccess or hipDeviceReset.\n\n\n @param [in] peerCtx  Peer context\n @param [in] flags  flags, need to set as 0\n\n @returns #hipSuccess, #hipErrorInvalidDevice, #hipErrorInvalidValue,\n #hipErrorPeerAccessAlreadyEnabled\n\n @see hipCtxCreate, hipCtxDestroy, hipCtxGetFlags, hipCtxPopCurrent, hipCtxGetCurrent,\n hipCtxSetCurrent, hipCtxPushCurrent, hipCtxSetCacheConfig, hipCtxSynchronize, hipCtxGetDevice\n @warning PeerToPeer support is experimental.\n\n @warning  This API is deprecated on the AMD platform, only for equivalent cuCtx driver API on the\n NVIDIA platform."]
    pub fn hipCtxEnablePeerAccess(peerCtx: hipCtx_t, flags: ::std::os::raw::c_uint) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Disable direct access from current context's virtual address space to memory allocations\n physically located on a peer context.Disables direct access to memory allocations in a peer\n context and unregisters any registered allocations [Deprecated]\n\n Returns #hipErrorPeerAccessNotEnabled if direct access to memory on peerDevice has not yet been\n enabled from the current device.\n\n @param [in] peerCtx  Peer context to be disabled\n\n @returns #hipSuccess, #hipErrorPeerAccessNotEnabled\n\n @see hipCtxCreate, hipCtxDestroy, hipCtxGetFlags, hipCtxPopCurrent, hipCtxGetCurrent,\n hipCtxSetCurrent, hipCtxPushCurrent, hipCtxSetCacheConfig, hipCtxSynchronize, hipCtxGetDevice\n @warning PeerToPeer support is experimental.\n\n @warning  This API is deprecated on the AMD platform, only for equivalent cuCtx driver API on the\n NVIDIA platform."]
    pub fn hipCtxDisablePeerAccess(peerCtx: hipCtx_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Get the state of the primary context [Deprecated]\n\n @param [in] dev  Device to get primary context flags for\n @param [out] flags  Pointer to store flags\n @param [out] active  Pointer to store context state; 0 = inactive, 1 = active\n\n @returns #hipSuccess\n\n @see hipCtxCreate, hipCtxDestroy, hipCtxGetFlags, hipCtxPopCurrent, hipCtxGetCurrent,\n hipCtxSetCurrent, hipCtxPushCurrent, hipCtxSetCacheConfig, hipCtxSynchronize, hipCtxGetDevice\n\n @warning  This API is deprecated on the AMD platform, only for equivalent driver API on the\n NVIDIA platform."]
    pub fn hipDevicePrimaryCtxGetState(
        dev: hipDevice_t,
        flags: *mut ::std::os::raw::c_uint,
        active: *mut ::std::os::raw::c_int,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Release the primary context on the GPU.\n\n @param [in] dev  Device which primary context is released [Deprecated]\n\n @returns #hipSuccess\n\n @see hipCtxCreate, hipCtxDestroy, hipCtxGetFlags, hipCtxPopCurrent, hipCtxGetCurrent,\n hipCtxSetCurrent, hipCtxPushCurrent, hipCtxSetCacheConfig, hipCtxSynchronize, hipCtxGetDevice\n @warning This function return #hipSuccess though doesn't release the primaryCtx by design on\n HIP/HCC path.\n\n @warning  This API is deprecated on the AMD platform, only for equivalent driver API on the NVIDIA\n platform."]
    pub fn hipDevicePrimaryCtxRelease(dev: hipDevice_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Retain the primary context on the GPU [Deprecated]\n\n @param [out] pctx  Returned context handle of the new context\n @param [in] dev  Device which primary context is released\n\n @returns #hipSuccess\n\n @see hipCtxCreate, hipCtxDestroy, hipCtxGetFlags, hipCtxPopCurrent, hipCtxGetCurrent,\n hipCtxSetCurrent, hipCtxPushCurrent, hipCtxSetCacheConfig, hipCtxSynchronize, hipCtxGetDevice\n\n @warning  This API is deprecated on the AMD platform, only for equivalent driver API on the NVIDIA\n platform."]
    pub fn hipDevicePrimaryCtxRetain(pctx: *mut hipCtx_t, dev: hipDevice_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Resets the primary context on the GPU [Deprecated]\n\n @param [in] dev  Device which primary context is reset\n\n @returns #hipSuccess\n\n @see hipCtxCreate, hipCtxDestroy, hipCtxGetFlags, hipCtxPopCurrent, hipCtxGetCurrent,\n hipCtxSetCurrent, hipCtxPushCurrent, hipCtxSetCacheConfig, hipCtxSynchronize, hipCtxGetDevice\n\n @warning  This API is deprecated on the AMD platform, only for equivalent driver API on the NVIDIA\n platform."]
    pub fn hipDevicePrimaryCtxReset(dev: hipDevice_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Set flags for the primary context [Deprecated]\n\n @param [in] dev  Device for which the primary context flags are set\n @param [in] flags  New flags for the device\n\n @returns #hipSuccess, #hipErrorContextAlreadyInUse\n\n @see hipCtxCreate, hipCtxDestroy, hipCtxGetFlags, hipCtxPopCurrent, hipCtxGetCurrent,\n hipCtxSetCurrent, hipCtxPushCurrent, hipCtxSetCacheConfig, hipCtxSynchronize, hipCtxGetDevice\n\n @warning  This API is deprecated on the AMD platform, only for equivalent driver API on the NVIDIA\n platform."]
    pub fn hipDevicePrimaryCtxSetFlags(
        dev: hipDevice_t,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @}\n/\n/**\n-------------------------------------------------------------------------------------------------\n-------------------------------------------------------------------------------------------------\n\n  @defgroup Module Module Management\n  @{\n  @ingroup API\n  This section describes the module management functions of HIP runtime API.\n\n/\n/**\n @brief Loads code object from file into a module the currrent context.\n\n @param [in] fname  Filename of code object to load\n\n @param [out] module  Module\n\n @warning File/memory resources allocated in this function are released only in hipModuleUnload.\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidContext, #hipErrorFileNotFound,\n #hipErrorOutOfMemory, #hipErrorSharedObjectInitFailed, #hipErrorNotInitialized\n"]
    pub fn hipModuleLoad(
        module: *mut hipModule_t,
        fname: *const ::std::os::raw::c_char,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Frees the module\n\n @param [in] module  Module to free\n\n @returns #hipSuccess, #hipErrorInvalidResourceHandle\n\n The module is freed, and the code objects associated with it are destroyed."]
    pub fn hipModuleUnload(module: hipModule_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Function with kname will be extracted if present in module\n\n @param [in] module  Module to get function from\n @param [in] kname  Pointer to the name of function\n @param [out] function  Pointer to function handle\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidContext, #hipErrorNotInitialized,\n #hipErrorNotFound,"]
    pub fn hipModuleGetFunction(
        function: *mut hipFunction_t,
        module: hipModule_t,
        kname: *const ::std::os::raw::c_char,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Find out attributes for a given function.\n @ingroup Execution\n @param [out] attr  Attributes of funtion\n @param [in] func  Pointer to the function handle\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidDeviceFunction"]
    pub fn hipFuncGetAttributes(
        attr: *mut hipFuncAttributes,
        func: *const ::std::os::raw::c_void,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Find out a specific attribute for a given function.\n @ingroup Execution\n @param [out] value  Pointer to the value\n @param [in]  attrib  Attributes of the given funtion\n @param [in]  hfunc  Function to get attributes from\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidDeviceFunction"]
    pub fn hipFuncGetAttribute(
        value: *mut ::std::os::raw::c_int,
        attrib: hipFunction_attribute,
        hfunc: hipFunction_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets pointer to device entry function that matches entry function symbolPtr.\n\n @param [out] functionPtr  Device entry function\n @param [in]  symbolPtr  Pointer to device entry function to search for\n\n @returns #hipSuccess, #hipErrorInvalidDeviceFunction\n"]
    pub fn hipGetFuncBySymbol(
        functionPtr: *mut hipFunction_t,
        symbolPtr: *const ::std::os::raw::c_void,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief returns the handle of the texture reference with the name from the module.\n\n @param [in] hmod  Module\n @param [in] name  Pointer of name of texture reference\n @param [out] texRef  Pointer of texture reference\n\n @returns #hipSuccess, #hipErrorNotInitialized, #hipErrorNotFound, #hipErrorInvalidValue"]
    pub fn hipModuleGetTexRef(
        texRef: *mut *mut textureReference,
        hmod: hipModule_t,
        name: *const ::std::os::raw::c_char,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief builds module from code object which resides in host memory. Image is pointer to that\n location.\n\n @param [in] image  The pointer to the location of data\n @param [out] module  Retuned module\n\n @returns hipSuccess, hipErrorNotInitialized, hipErrorOutOfMemory, hipErrorNotInitialized"]
    pub fn hipModuleLoadData(
        module: *mut hipModule_t,
        image: *const ::std::os::raw::c_void,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief builds module from code object which resides in host memory. Image is pointer to that\n location. Options are not used. hipModuleLoadData is called.\n\n @param [in] image  The pointer to the location of data\n @param [out] module  Retuned module\n @param [in] numOptions Number of options\n @param [in] options Options for JIT\n @param [in] optionValues  Option values for JIT\n\n @returns hipSuccess, hipErrorNotInitialized, hipErrorOutOfMemory, hipErrorNotInitialized"]
    pub fn hipModuleLoadDataEx(
        module: *mut hipModule_t,
        image: *const ::std::os::raw::c_void,
        numOptions: ::std::os::raw::c_uint,
        options: *mut hipJitOption,
        optionValues: *mut *mut ::std::os::raw::c_void,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Completes the linking of the given program.\n @param [in] state hip link state\n @param [in] type  Type of the input data or bitcode\n @param [in] data  Input data which is null terminated\n @param [in] size  Size of the input data\n @param [in] name  Optional name for this input\n @param [in] numOptions  Size of the options\n @param [in] options  Array of options applied to this input\n @param [in] optionValues  Array of option values cast to void*\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidHandle\n\n If adding the file fails, it will\n @return #hipErrorInvalidConfiguration\n\n @see hipError_t"]
    pub fn hipLinkAddData(
        state: hipLinkState_t,
        type_: hipJitInputType,
        data: *mut ::std::os::raw::c_void,
        size: usize,
        name: *const ::std::os::raw::c_char,
        numOptions: ::std::os::raw::c_uint,
        options: *mut hipJitOption,
        optionValues: *mut *mut ::std::os::raw::c_void,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Adds a file with bit code to be linked with options\n @param [in] state hip link state\n @param [in] type  Type of the input data or bitcode\n @param [in] path  Path to the input file where bitcode is present\n @param [in] numOptions  Size of the options\n @param [in] options  Array of options applied to this input\n @param [in] optionValues  Array of option values cast to void*\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n If adding the file fails, it will\n @return #hipErrorInvalidConfiguration\n\n @see hipError_t"]
    pub fn hipLinkAddFile(
        state: hipLinkState_t,
        type_: hipJitInputType,
        path: *const ::std::os::raw::c_char,
        numOptions: ::std::os::raw::c_uint,
        options: *mut hipJitOption,
        optionValues: *mut *mut ::std::os::raw::c_void,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Completes the linking of the given program.\n @param [in]   state hip link state\n @param [out]  hipBinOut  Upon success, points to the output binary\n @param [out]  sizeOut  Size of the binary is stored (optional)\n\n @returns #hipSuccess #hipErrorInvalidValue\n\n If adding the data fails, it will\n @return #hipErrorInvalidConfiguration\n\n @see hipError_t"]
    pub fn hipLinkComplete(
        state: hipLinkState_t,
        hipBinOut: *mut *mut ::std::os::raw::c_void,
        sizeOut: *mut usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Creates the link instance via hip APIs.\n @param [in] numOptions  Number of options\n @param [in] option  Array of options\n @param [in] optionValues  Array of option values cast to void*\n @param [out] stateOut  hip link state created upon success\n\n @returns #hipSuccess #hipErrorInvalidValue #hipErrorInvalidConfiguration\n\n @see hipSuccess"]
    pub fn hipLinkCreate(
        numOptions: ::std::os::raw::c_uint,
        options: *mut hipJitOption,
        optionValues: *mut *mut ::std::os::raw::c_void,
        stateOut: *mut hipLinkState_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Deletes the link instance via hip APIs.\n @param [in] state link state instance\n\n @returns #hipSuccess #hipErrorInvalidValue\n\n @see hipSuccess"]
    pub fn hipLinkDestroy(state: hipLinkState_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief launches kernel f with launch parameters and shared memory on stream with arguments passed\n to kernelparams or extra\n @ingroup Execution\n @param [in] f         Kernel to launch.\n @param [in] gridDimX  X grid dimension specified as multiple of blockDimX.\n @param [in] gridDimY  Y grid dimension specified as multiple of blockDimY.\n @param [in] gridDimZ  Z grid dimension specified as multiple of blockDimZ.\n @param [in] blockDimX X block dimensions specified in work-items\n @param [in] blockDimY Y grid dimension specified in work-items\n @param [in] blockDimZ Z grid dimension specified in work-items\n @param [in] sharedMemBytes Amount of dynamic shared memory to allocate for this kernel. The\n HIP-Clang compiler provides support for extern shared declarations.\n @param [in] stream    Stream where the kernel should be dispatched.  May be 0, in which case th\n default stream is used with associated synchronization rules.\n @param [in] kernelParams  Kernel parameters to launch\n @param [in] extra     Pointer to kernel arguments.   These are passed directly to the kernel and\n must be in the memory layout and alignment expected by the kernel.\n All passed arguments must be naturally aligned according to their type. The memory address of each\n argument should be a multiple of its size in bytes. Please refer to hip_porting_driver_api.md\n for sample usage.\n\n Please note, HIP does not support kernel launch with total work items defined in dimension with\n size gridDim x blockDim >= 2^32. So gridDim.x * blockDim.x, gridDim.y * blockDim.y\n and gridDim.z * blockDim.z are always less than 2^32.\n\n @returns #hipSuccess, #hipErrorNotInitialized, #hipErrorInvalidValue"]
    pub fn hipModuleLaunchKernel(
        f: hipFunction_t,
        gridDimX: ::std::os::raw::c_uint,
        gridDimY: ::std::os::raw::c_uint,
        gridDimZ: ::std::os::raw::c_uint,
        blockDimX: ::std::os::raw::c_uint,
        blockDimY: ::std::os::raw::c_uint,
        blockDimZ: ::std::os::raw::c_uint,
        sharedMemBytes: ::std::os::raw::c_uint,
        stream: hipStream_t,
        kernelParams: *mut *mut ::std::os::raw::c_void,
        extra: *mut *mut ::std::os::raw::c_void,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " \\addtogroup ModuleCooperativeG Cooperative groups kernel launch of Module management.\n \\ingroup Module\n  @{ */\n/**\n @brief launches kernel f with launch parameters and shared memory on stream with arguments passed\n to kernelParams, where thread blocks can cooperate and synchronize as they execute\n\n @param [in] f              Kernel to launch.\n @param [in] gridDimX       X grid dimension specified as multiple of blockDimX.\n @param [in] gridDimY       Y grid dimension specified as multiple of blockDimY.\n @param [in] gridDimZ       Z grid dimension specified as multiple of blockDimZ.\n @param [in] blockDimX      X block dimension specified in work-items.\n @param [in] blockDimY      Y block dimension specified in work-items.\n @param [in] blockDimZ      Z block dimension specified in work-items.\n @param [in] sharedMemBytes Amount of dynamic shared memory to allocate for this kernel. The\n HIP-Clang compiler provides support for extern shared declarations.\n @param [in] stream         Stream where the kernel should be dispatched. May be 0,\n in which case the default stream is used with associated synchronization rules.\n @param [in] kernelParams   A list of kernel arguments.\n\n Please note, HIP does not support kernel launch with total work items defined in dimension with\n size \\f$ gridDim \\cdot blockDim \\geq 2^{32} \\f$.\n\n @returns #hipSuccess, #hipErrorDeinitialized, #hipErrorNotInitialized, #hipErrorInvalidContext,\n #hipErrorInvalidHandle, #hipErrorInvalidImage, #hipErrorInvalidValue,\n #hipErrorInvalidConfiguration, #hipErrorLaunchFailure, #hipErrorLaunchOutOfResources,\n #hipErrorLaunchTimeOut, #hipErrorCooperativeLaunchTooLarge, #hipErrorSharedObjectInitFailed"]
    pub fn hipModuleLaunchCooperativeKernel(
        f: hipFunction_t,
        gridDimX: ::std::os::raw::c_uint,
        gridDimY: ::std::os::raw::c_uint,
        gridDimZ: ::std::os::raw::c_uint,
        blockDimX: ::std::os::raw::c_uint,
        blockDimY: ::std::os::raw::c_uint,
        blockDimZ: ::std::os::raw::c_uint,
        sharedMemBytes: ::std::os::raw::c_uint,
        stream: hipStream_t,
        kernelParams: *mut *mut ::std::os::raw::c_void,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Launches kernels on multiple devices where thread blocks can cooperate and\n synchronize as they execute.\n\n @param [in] launchParamsList         List of launch parameters, one per device.\n @param [in] numDevices               Size of the launchParamsList array.\n @param [in] flags                    Flags to control launch behavior.\n\n @returns #hipSuccess, #hipErrorDeinitialized, #hipErrorNotInitialized, #hipErrorInvalidContext,\n #hipErrorInvalidHandle, #hipErrorInvalidImage, #hipErrorInvalidValue,\n #hipErrorInvalidConfiguration, #hipErrorInvalidResourceHandle, #hipErrorLaunchFailure,\n #hipErrorLaunchOutOfResources, #hipErrorLaunchTimeOut, #hipErrorCooperativeLaunchTooLarge,\n #hipErrorSharedObjectInitFailed"]
    pub fn hipModuleLaunchCooperativeKernelMultiDevice(
        launchParamsList: *mut hipFunctionLaunchParams,
        numDevices: ::std::os::raw::c_uint,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Launches kernel f with launch parameters and shared memory on stream with arguments passed\n to kernelparams or extra, where thread blocks can cooperate and synchronize as they execute.\n\n @param [in] f - Kernel to launch.\n @param [in] gridDim - Grid dimensions specified as multiple of blockDim.\n @param [in] blockDimX - Block dimensions specified in work-items\n @param [in] kernelParams - Pointer of arguments passed to the kernel. If the kernel has multiple\n parameters, 'kernelParams' should be array of pointers, each points the corresponding argument.\n @param [in] sharedMemBytes - Amount of dynamic shared memory to allocate for this kernel. The\n HIP-Clang compiler provides support for extern shared declarations.\n @param [in] stream - Stream where the kernel should be dispatched.  May be 0, in which case th\n default stream is used with associated synchronization rules.\n\n Please note, HIP does not support kernel launch with total work items defined in dimension with\n size \\f$ gridDim \\cdot blockDim \\geq 2^{32} \\f$.\n\n @returns #hipSuccess, #hipErrorNotInitialized, #hipErrorInvalidValue,\n #hipErrorCooperativeLaunchTooLarge"]
    pub fn hipLaunchCooperativeKernel(
        f: *const ::std::os::raw::c_void,
        gridDim: dim3,
        blockDimX: dim3,
        kernelParams: *mut *mut ::std::os::raw::c_void,
        sharedMemBytes: ::std::os::raw::c_uint,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Launches kernels on multiple devices where thread blocks can cooperate and\n synchronize as they execute.\n\n @param [in] launchParamsList         List of launch parameters, one per device.\n @param [in] numDevices               Size of the launchParamsList array.\n @param [in] flags                    Flags to control launch behavior.\n\n @returns #hipSuccess, #hipErrorNotInitialized, #hipErrorInvalidValue,\n  #hipErrorCooperativeLaunchTooLarge"]
    pub fn hipLaunchCooperativeKernelMultiDevice(
        launchParamsList: *mut hipLaunchParams,
        numDevices: ::std::os::raw::c_int,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Launches kernels on multiple devices and guarantees all specified kernels are dispatched\n on respective streams before enqueuing any other work on the specified streams from any other threads\n @ingroup Execution\n @param [in] launchParamsList          List of launch parameters, one per device.\n @param [in] numDevices               Size of the launchParamsList array.\n @param [in] flags                    Flags to control launch behavior.\n\n @returns #hipSuccess, #hipErrorNotInitialized, #hipErrorInvalidValue"]
    pub fn hipExtLaunchMultiKernelMultiDevice(
        launchParamsList: *mut hipLaunchParams,
        numDevices: ::std::os::raw::c_int,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "-------------------------------------------------------------------------------------------------\n-------------------------------------------------------------------------------------------------\n  @defgroup Occupancy Occupancy\n  @{\n  This section describes the occupancy functions of HIP runtime API.\n\n/\n/**\n @brief determine the grid and block sizes to achieves maximum occupancy for a kernel\n\n @param [out] gridSize           minimum grid size for maximum potential occupancy\n @param [out] blockSize          block size for maximum potential occupancy\n @param [in]  f                  kernel function for which occupancy is calulated\n @param [in]  dynSharedMemPerBlk dynamic shared memory usage (in bytes) intended for each block\n @param [in]  blockSizeLimit     the maximum block size for the kernel, use 0 for no limit\n\n Please note, HIP does not support kernel launch with total work items defined in dimension with\n size gridDim x blockDim >= 2^32.\n\n @returns #hipSuccess, #hipErrorInvalidValue"]
    pub fn hipModuleOccupancyMaxPotentialBlockSize(
        gridSize: *mut ::std::os::raw::c_int,
        blockSize: *mut ::std::os::raw::c_int,
        f: hipFunction_t,
        dynSharedMemPerBlk: usize,
        blockSizeLimit: ::std::os::raw::c_int,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief determine the grid and block sizes to achieves maximum occupancy for a kernel\n\n @param [out] gridSize           minimum grid size for maximum potential occupancy\n @param [out] blockSize          block size for maximum potential occupancy\n @param [in]  f                  kernel function for which occupancy is calulated\n @param [in]  dynSharedMemPerBlk dynamic shared memory usage (in bytes) intended for each block\n @param [in]  blockSizeLimit     the maximum block size for the kernel, use 0 for no limit\n @param [in]  flags            Extra flags for occupancy calculation (only default supported)\n\n Please note, HIP does not support kernel launch with total work items defined in dimension with\n size gridDim x blockDim >= 2^32.\n\n @returns #hipSuccess, #hipErrorInvalidValue"]
    pub fn hipModuleOccupancyMaxPotentialBlockSizeWithFlags(
        gridSize: *mut ::std::os::raw::c_int,
        blockSize: *mut ::std::os::raw::c_int,
        f: hipFunction_t,
        dynSharedMemPerBlk: usize,
        blockSizeLimit: ::std::os::raw::c_int,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns occupancy for a device function.\n\n @param [out] numBlocks        Returned occupancy\n @param [in]  f                Kernel function (hipFunction) for which occupancy is calulated\n @param [in]  blockSize        Block size the kernel is intended to be launched with\n @param [in]  dynSharedMemPerBlk Dynamic shared memory usage (in bytes) intended for each block\n @returns  #hipSuccess, #hipErrorInvalidValue"]
    pub fn hipModuleOccupancyMaxActiveBlocksPerMultiprocessor(
        numBlocks: *mut ::std::os::raw::c_int,
        f: hipFunction_t,
        blockSize: ::std::os::raw::c_int,
        dynSharedMemPerBlk: usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns occupancy for a device function.\n\n @param [out] numBlocks        Returned occupancy\n @param [in]  f                Kernel function(hipFunction_t) for which occupancy is calulated\n @param [in]  blockSize        Block size the kernel is intended to be launched with\n @param [in]  dynSharedMemPerBlk Dynamic shared memory usage (in bytes) intended for each block\n @param [in]  flags            Extra flags for occupancy calculation (only default supported)\n @returns  #hipSuccess, #hipErrorInvalidValue"]
    pub fn hipModuleOccupancyMaxActiveBlocksPerMultiprocessorWithFlags(
        numBlocks: *mut ::std::os::raw::c_int,
        f: hipFunction_t,
        blockSize: ::std::os::raw::c_int,
        dynSharedMemPerBlk: usize,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns occupancy for a device function.\n\n @param [out] numBlocks        Returned occupancy\n @param [in]  f                Kernel function for which occupancy is calulated\n @param [in]  blockSize        Block size the kernel is intended to be launched with\n @param [in]  dynSharedMemPerBlk Dynamic shared memory usage (in bytes) intended for each block\n @returns  #hipSuccess, #hipErrorInvalidDeviceFunction, #hipErrorInvalidValue"]
    pub fn hipOccupancyMaxActiveBlocksPerMultiprocessor(
        numBlocks: *mut ::std::os::raw::c_int,
        f: *const ::std::os::raw::c_void,
        blockSize: ::std::os::raw::c_int,
        dynSharedMemPerBlk: usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns occupancy for a device function.\n\n @param [out] numBlocks        Returned occupancy\n @param [in]  f                Kernel function for which occupancy is calulated\n @param [in]  blockSize        Block size the kernel is intended to be launched with\n @param [in]  dynSharedMemPerBlk Dynamic shared memory usage (in bytes) intended for each block\n @param [in]  flags            Extra flags for occupancy calculation (currently ignored)\n @returns  #hipSuccess, #hipErrorInvalidDeviceFunction, #hipErrorInvalidValue"]
    pub fn hipOccupancyMaxActiveBlocksPerMultiprocessorWithFlags(
        numBlocks: *mut ::std::os::raw::c_int,
        f: *const ::std::os::raw::c_void,
        blockSize: ::std::os::raw::c_int,
        dynSharedMemPerBlk: usize,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief determine the grid and block sizes to achieves maximum occupancy for a kernel\n\n @param [out] gridSize           minimum grid size for maximum potential occupancy\n @param [out] blockSize          block size for maximum potential occupancy\n @param [in]  f                  kernel function for which occupancy is calulated\n @param [in]  dynSharedMemPerBlk dynamic shared memory usage (in bytes) intended for each block\n @param [in]  blockSizeLimit     the maximum block size for the kernel, use 0 for no limit\n\n Please note, HIP does not support kernel launch with total work items defined in dimension with\n size gridDim x blockDim >= 2^32.\n\n @returns #hipSuccess, #hipErrorInvalidValue"]
    pub fn hipOccupancyMaxPotentialBlockSize(
        gridSize: *mut ::std::os::raw::c_int,
        blockSize: *mut ::std::os::raw::c_int,
        f: *const ::std::os::raw::c_void,
        dynSharedMemPerBlk: usize,
        blockSizeLimit: ::std::os::raw::c_int,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Start recording of profiling information [Deprecated]\n When using this API, start the profiler with profiling disabled.  (--startdisabled)\n @returns  #hipErrorNotSupported\n @warning hipProfilerStart API is deprecated, use roctracer/rocTX instead."]
    pub fn hipProfilerStart() -> hipError_t;
}
extern "C" {
    #[doc = " @brief Stop recording of profiling information [Deprecated]\n When using this API, start the profiler with profiling disabled.  (--startdisabled)\n @returns  #hipErrorNotSupported\n @warning  hipProfilerStart API is deprecated, use roctracer/rocTX instead."]
    pub fn hipProfilerStop() -> hipError_t;
}
extern "C" {
    #[doc = " @}\n/\n/**\n-------------------------------------------------------------------------------------------------\n-------------------------------------------------------------------------------------------------\n  @defgroup Clang Launch API to support the triple-chevron syntax\n  @{\n  This section describes the API to support the triple-chevron syntax.\n/\n/**\n @brief Configure a kernel launch.\n\n @param [in] gridDim   grid dimension specified as multiple of blockDim.\n @param [in] blockDim  block dimensions specified in work-items\n @param [in] sharedMem Amount of dynamic shared memory to allocate for this kernel. The\n HIP-Clang compiler provides support for extern shared declarations.\n @param [in] stream    Stream where the kernel should be dispatched.  May be 0, in which case the\n default stream is used with associated synchronization rules.\n\n Please note, HIP does not support kernel launch with total work items defined in dimension with\n size gridDim x blockDim >= 2^32.\n\n @returns #hipSuccess, #hipErrorNotInitialized, #hipErrorInvalidValue\n"]
    pub fn hipConfigureCall(
        gridDim: dim3,
        blockDim: dim3,
        sharedMem: usize,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Set a kernel argument.\n\n @returns #hipSuccess, #hipErrorNotInitialized, #hipErrorInvalidValue\n\n @param [in] arg    Pointer the argument in host memory.\n @param [in] size   Size of the argument.\n @param [in] offset Offset of the argument on the argument stack.\n"]
    pub fn hipSetupArgument(
        arg: *const ::std::os::raw::c_void,
        size: usize,
        offset: usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Launch a kernel.\n\n @param [in] func Kernel to launch.\n\n @returns #hipSuccess, #hipErrorNotInitialized, #hipErrorInvalidValue\n"]
    pub fn hipLaunchByPtr(func: *const ::std::os::raw::c_void) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Push configuration of a kernel launch.\n\n @param [in] gridDim   grid dimension specified as multiple of blockDim.\n @param [in] blockDim  block dimensions specified in work-items\n @param [in] sharedMem Amount of dynamic shared memory to allocate for this kernel. The\n HIP-Clang compiler provides support for extern shared declarations.\n @param [in] stream    Stream where the kernel should be dispatched.  May be 0, in which case the\n default stream is used with associated synchronization rules.\n\n Please note, HIP does not support kernel launch with total work items defined in dimension with\n size gridDim x blockDim >= 2^32.\n\n @returns #hipSuccess, #hipErrorNotInitialized, #hipErrorInvalidValue\n"]
    pub fn __hipPushCallConfiguration(
        gridDim: dim3,
        blockDim: dim3,
        sharedMem: usize,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Pop configuration of a kernel launch.\n\n @param [out] gridDim   grid dimension specified as multiple of blockDim.\n @param [out] blockDim  block dimensions specified in work-items\n @param [out] sharedMem Amount of dynamic shared memory to allocate for this kernel.  The\n HIP-Clang compiler provides support for extern shared declarations.\n @param [out] stream    Stream where the kernel should be dispatched.  May be 0, in which case the\n default stream is used with associated synchronization rules.\n\n Please note, HIP does not support kernel launch with total work items defined in dimension with\n size gridDim x blockDim >= 2^32.\n\n Please note, HIP does not support kernel launch with total work items defined in dimension with\n size gridDim x blockDim >= 2^32.\n\n @returns #hipSuccess, #hipErrorNotInitialized, #hipErrorInvalidValue\n"]
    pub fn __hipPopCallConfiguration(
        gridDim: *mut dim3,
        blockDim: *mut dim3,
        sharedMem: *mut usize,
        stream: *mut hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief C compliant kernel launch API\n\n @param [in] function_address - Kernel stub function pointer.\n @param [in] numBlocks - Number of blocks.\n @param [in] dimBlocks - Dimension of a block\n @param [in] args - Pointer of arguments passed to the kernel. If the kernel has multiple\n parameters, 'args' should be array of pointers, each points the corresponding argument.\n @param [in] sharedMemBytes - Amount of dynamic shared memory to allocate for this kernel. The\n HIP-Clang compiler provides support for extern shared declarations.\n @param [in] stream - Stream where the kernel should be dispatched.  May be 0, in which case th\n  default stream is used with associated synchronization rules.\n\n @returns #hipSuccess, #hipErrorInvalidValue\n"]
    pub fn hipLaunchKernel(
        function_address: *const ::std::os::raw::c_void,
        numBlocks: dim3,
        dimBlocks: dim3,
        args: *mut *mut ::std::os::raw::c_void,
        sharedMemBytes: usize,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Enqueues a host function call in a stream.\n\n @param [in] stream - The stream to enqueue work in.\n @param [in] fn - The function to call once enqueued preceeding operations are complete.\n @param [in] userData - User-specified data to be passed to the function.\n\n @returns #hipSuccess, #hipErrorInvalidResourceHandle, #hipErrorInvalidValue,\n #hipErrorNotSupported\n\n The host function to call in this API will be executed after the preceding operations in\n the stream are complete. The function is a blocking operation that blocks operations in the\n stream that follow it, until the function is returned.\n Event synchronization and internal callback functions make sure enqueued operations will\n execute in order, in the stream.\n\n The host function must not make any HIP API calls. The host function is non-reentrant. It must\n not perform sychronization with any operation that may depend on other processing execution\n but is not enqueued to run earlier in the stream.\n\n Host functions that are enqueued respectively in different non-blocking streams can run concurrently.\n\n @warning  This API is marked as beta, meaning, while this is feature complete,\n it is still open to changes and may have outstanding issues."]
    pub fn hipLaunchHostFunc(
        stream: hipStream_t,
        fn_: hipHostFn_t,
        userData: *mut ::std::os::raw::c_void,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " Copies memory for 2D arrays.\n\n @param pCopy           - Parameters for the memory copy\n\n @returns #hipSuccess, #hipErrorInvalidValue"]
    pub fn hipDrvMemcpy2DUnaligned(pCopy: *const hip_Memcpy2D) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Launches kernel from the pointer address, with arguments and shared memory on stream.\n\n @param [in] function_address - Pointer to the Kernel to launch.\n @param [in] numBlocks -  Number of blocks.\n @param [in] dimBlocks - Dimension of a block.\n @param [in] args - Pointer of arguments passed to the kernel. If the kernel has multiple\n parameters, 'args' should be array of pointers, each points the corresponding argument.\n @param [in] sharedMemBytes - Amount of dynamic shared memory to allocate for this kernel.\n HIP-Clang compiler provides support for extern shared declarations.\n @param [in] stream - Stream where the kernel should be dispatched.\n May be 0, in which case the default stream is used with associated synchronization rules.\n @param [in] startEvent - If non-null, specified event will be updated to track the start time of\n the kernel launch. The event must be created before calling this API.\n @param [in] stopEvent - If non-null, specified event will be updated to track the stop time of\n the kernel launch. The event must be created before calling this API.\n @param [in] flags - The value of hipExtAnyOrderLaunch, signifies if kernel can be\n launched in any order.\n @returns #hipSuccess, #hipErrorNotInitialized, #hipErrorInvalidValue.\n"]
    pub fn hipExtLaunchKernel(
        function_address: *const ::std::os::raw::c_void,
        numBlocks: dim3,
        dimBlocks: dim3,
        args: *mut *mut ::std::os::raw::c_void,
        sharedMemBytes: usize,
        stream: hipStream_t,
        startEvent: hipEvent_t,
        stopEvent: hipEvent_t,
        flags: ::std::os::raw::c_int,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Creates a texture object.\n\n @param [out] pTexObject  pointer to the texture object to create\n @param [in] pResDesc  pointer to resource descriptor\n @param [in] pTexDesc  pointer to texture descriptor\n @param [in] pResViewDesc  pointer to resource view descriptor\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported, #hipErrorOutOfMemory\n\n @note 3D liner filter isn't supported on GFX90A boards, on which the API @p hipCreateTextureObject will\n return hipErrorNotSupported.\n"]
    pub fn hipCreateTextureObject(
        pTexObject: *mut hipTextureObject_t,
        pResDesc: *const hipResourceDesc,
        pTexDesc: *const hipTextureDesc,
        pResViewDesc: *const hipResourceViewDesc,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Destroys a texture object.\n\n @param [in] textureObject  texture object to destroy\n\n @returns #hipSuccess, #hipErrorInvalidValue\n"]
    pub fn hipDestroyTextureObject(textureObject: hipTextureObject_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets the channel descriptor in an array.\n\n @param [in] desc  pointer to channel format descriptor\n @param [out] array  memory array on the device\n\n @returns #hipSuccess, #hipErrorInvalidValue\n"]
    pub fn hipGetChannelDesc(
        desc: *mut hipChannelFormatDesc,
        array: hipArray_const_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets resource descriptor for the texture object.\n\n @param [out] pResDesc  pointer to resource descriptor\n @param [in] textureObject  texture object\n\n @returns #hipSuccess, #hipErrorInvalidValue\n"]
    pub fn hipGetTextureObjectResourceDesc(
        pResDesc: *mut hipResourceDesc,
        textureObject: hipTextureObject_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets resource view descriptor for the texture object.\n\n @param [out] pResViewDesc  pointer to resource view descriptor\n @param [in] textureObject  texture object\n\n @returns #hipSuccess, #hipErrorInvalidValue\n"]
    pub fn hipGetTextureObjectResourceViewDesc(
        pResViewDesc: *mut hipResourceViewDesc,
        textureObject: hipTextureObject_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets texture descriptor for the texture object.\n\n @param [out] pTexDesc  pointer to texture descriptor\n @param [in] textureObject  texture object\n\n @returns #hipSuccess, #hipErrorInvalidValue\n"]
    pub fn hipGetTextureObjectTextureDesc(
        pTexDesc: *mut hipTextureDesc,
        textureObject: hipTextureObject_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Creates a texture object.\n\n @param [out] pTexObject  pointer to texture object to create\n @param [in] pResDesc  pointer to resource descriptor\n @param [in] pTexDesc  pointer to texture descriptor\n @param [in] pResViewDesc  pointer to resource view descriptor\n\n @returns #hipSuccess, #hipErrorInvalidValue\n"]
    pub fn hipTexObjectCreate(
        pTexObject: *mut hipTextureObject_t,
        pResDesc: *const HIP_RESOURCE_DESC,
        pTexDesc: *const HIP_TEXTURE_DESC,
        pResViewDesc: *const HIP_RESOURCE_VIEW_DESC,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Destroys a texture object.\n\n @param [in] texObject  texture object to destroy\n\n @returns #hipSuccess, #hipErrorInvalidValue\n"]
    pub fn hipTexObjectDestroy(texObject: hipTextureObject_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets resource descriptor of a texture object.\n\n @param [out] pResDesc  pointer to resource descriptor\n @param [in] texObject  texture object\n\n @returns #hipSuccess, #hipErrorNotSupported, #hipErrorInvalidValue\n"]
    pub fn hipTexObjectGetResourceDesc(
        pResDesc: *mut HIP_RESOURCE_DESC,
        texObject: hipTextureObject_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets resource view descriptor of a texture object.\n\n @param [out] pResViewDesc  pointer to resource view descriptor\n @param [in] texObject  texture object\n\n @returns #hipSuccess, #hipErrorNotSupported, #hipErrorInvalidValue\n"]
    pub fn hipTexObjectGetResourceViewDesc(
        pResViewDesc: *mut HIP_RESOURCE_VIEW_DESC,
        texObject: hipTextureObject_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets texture descriptor of a texture object.\n\n @param [out] pTexDesc  pointer to texture descriptor\n @param [in] texObject  texture object\n\n @returns #hipSuccess, #hipErrorNotSupported, #hipErrorInvalidValue\n"]
    pub fn hipTexObjectGetTextureDesc(
        pTexDesc: *mut HIP_TEXTURE_DESC,
        texObject: hipTextureObject_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Allocate a mipmapped array on the device.\n\n @param[out] mipmappedArray  - Pointer to allocated mipmapped array in device memory\n @param[in]  desc            - Requested channel format\n @param[in]  extent          - Requested allocation size (width field in elements)\n @param[in]  numLevels       - Number of mipmap levels to allocate\n @param[in]  flags           - Flags for extensions\n\n @return #hipSuccess, #hipErrorInvalidValue, #hipErrorMemoryAllocation\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows.\n"]
    pub fn hipMallocMipmappedArray(
        mipmappedArray: *mut hipMipmappedArray_t,
        desc: *const hipChannelFormatDesc,
        extent: hipExtent,
        numLevels: ::std::os::raw::c_uint,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Frees a mipmapped array on the device.\n\n @param[in] mipmappedArray - Pointer to mipmapped array to free\n\n @return #hipSuccess, #hipErrorInvalidValue\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows.\n"]
    pub fn hipFreeMipmappedArray(mipmappedArray: hipMipmappedArray_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets a mipmap level of a HIP mipmapped array.\n\n @param[out] levelArray     - Returned mipmap level HIP array\n @param[in]  mipmappedArray - HIP mipmapped array\n @param[in]  level          - Mipmap level\n\n @return #hipSuccess, #hipErrorInvalidValue\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows.\n"]
    pub fn hipGetMipmappedArrayLevel(
        levelArray: *mut hipArray_t,
        mipmappedArray: hipMipmappedArray_const_t,
        level: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Create a mipmapped array.\n\n @param [out] pHandle  pointer to mipmapped array\n @param [in] pMipmappedArrayDesc  mipmapped array descriptor\n @param [in] numMipmapLevels  mipmap level\n\n @returns #hipSuccess, #hipErrorNotSupported, #hipErrorInvalidValue\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows."]
    pub fn hipMipmappedArrayCreate(
        pHandle: *mut hipMipmappedArray_t,
        pMipmappedArrayDesc: *mut HIP_ARRAY3D_DESCRIPTOR,
        numMipmapLevels: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Destroy a mipmapped array.\n\n @param [out] hMipmappedArray  pointer to mipmapped array to destroy\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows.\n"]
    pub fn hipMipmappedArrayDestroy(hMipmappedArray: hipMipmappedArray_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Get a mipmapped array on a mipmapped level.\n\n @param [in] pLevelArray Pointer of array\n @param [out] hMipMappedArray Pointer of mipmapped array on the requested mipmap level\n @param [out] level  Mipmap level\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows.\n"]
    pub fn hipMipmappedArrayGetLevel(
        pLevelArray: *mut hipArray_t,
        hMipMappedArray: hipMipmappedArray_t,
        level: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief  Binds a mipmapped array to a texture [Deprecated]\n\n @param [in] tex  pointer to the texture reference to bind\n @param [in] mipmappedArray memory mipmapped array on the device\n @param [in] desc  opointer to the channel format\n\n @returns #hipSuccess, #hipErrorInvalidValue\n"]
    pub fn hipBindTextureToMipmappedArray(
        tex: *const textureReference,
        mipmappedArray: hipMipmappedArray_const_t,
        desc: *const hipChannelFormatDesc,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets the texture reference related with the symbol [Deprecated]\n\n @param [out] texref  texture reference\n @param [in] symbol  pointer to the symbol related with the texture for the reference\n\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is deprecated.\n"]
    pub fn hipGetTextureReference(
        texref: *mut *const textureReference,
        symbol: *const ::std::os::raw::c_void,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets the border color used by a texture reference [Deprecated]\n\n @param [out] pBorderColor  Returned Type and Value of RGBA color.\n @param [in] texRef  Texture reference.\n\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is deprecated.\n"]
    pub fn hipTexRefGetBorderColor(
        pBorderColor: *mut f32,
        texRef: *const textureReference,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets the array bound to a texture reference [Deprecated]\n\n\n @param [in] pArray  Returned array.\n @param [in] texRef  texture reference.\n\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is deprecated.\n"]
    pub fn hipTexRefGetArray(
        pArray: *mut hipArray_t,
        texRef: *const textureReference,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets address mode for a texture reference [Deprecated]\n\n @param [in] texRef  texture reference.\n @param [in] dim  Dimension of the texture.\n @param [in] am  Value of the texture address mode.\n\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is deprecated.\n"]
    pub fn hipTexRefSetAddressMode(
        texRef: *mut textureReference,
        dim: ::std::os::raw::c_int,
        am: hipTextureAddressMode,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Binds an array as a texture reference [Deprecated]\n\n @param [in] tex  Pointer texture reference.\n @param [in] array  Array to bind.\n @param [in] flags  Flags should be set as HIP_TRSA_OVERRIDE_FORMAT, as a valid value.\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @warning This API is deprecated.\n"]
    pub fn hipTexRefSetArray(
        tex: *mut textureReference,
        array: hipArray_const_t,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Set filter mode for a texture reference [Deprecated]\n\n @param [in] texRef  Pointer texture reference.\n @param [in] fm  Value of texture filter mode.\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @warning This API is deprecated.\n"]
    pub fn hipTexRefSetFilterMode(
        texRef: *mut textureReference,
        fm: hipTextureFilterMode,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Set flags for a texture reference [Deprecated]\n\n @param [in] texRef  Pointer texture reference.\n @param [in] Flags  Value of flags.\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @warning This API is deprecated.\n"]
    pub fn hipTexRefSetFlags(
        texRef: *mut textureReference,
        Flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Set format for a texture reference [Deprecated]\n\n @param [in] texRef  Pointer texture reference.\n @param [in] fmt  Value of format.\n @param [in] NumPackedComponents  Number of components per array.\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @warning This API is deprecated.\n"]
    pub fn hipTexRefSetFormat(
        texRef: *mut textureReference,
        fmt: hipArray_Format,
        NumPackedComponents: ::std::os::raw::c_int,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Binds a memory area to a texture [Deprecated]\n\n @param [in] offset  Offset in bytes.\n @param [in] tex  Texture to bind.\n @param [in] devPtr  Pointer of memory on the device.\n @param [in] desc  Pointer of channel format descriptor.\n @param [in] size  Size of memory in bites.\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n\n @warning This API is deprecated.\n"]
    pub fn hipBindTexture(
        offset: *mut usize,
        tex: *const textureReference,
        devPtr: *const ::std::os::raw::c_void,
        desc: *const hipChannelFormatDesc,
        size: usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Binds a 2D memory area to a texture [Deprecated]\n\n @param [in] offset  Offset in bytes.\n @param [in] tex  Texture to bind.\n @param [in] devPtr  Pointer of 2D memory area on the device.\n @param [in] desc  Pointer of channel format descriptor.\n @param [in] width  Width in texel units.\n @param [in] height  Height in texel units.\n @param [in] pitch  Pitch in bytes.\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n\n @warning This API is deprecated.\n"]
    pub fn hipBindTexture2D(
        offset: *mut usize,
        tex: *const textureReference,
        devPtr: *const ::std::os::raw::c_void,
        desc: *const hipChannelFormatDesc,
        width: usize,
        height: usize,
        pitch: usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Binds a memory area to a texture [Deprecated]\n\n @param [in] tex  Pointer of texture reference.\n @param [in] array  Array to bind.\n @param [in] desc  Pointer of channel format descriptor.\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n\n @warning This API is deprecated.\n"]
    pub fn hipBindTextureToArray(
        tex: *const textureReference,
        array: hipArray_const_t,
        desc: *const hipChannelFormatDesc,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Get the offset of the alignment in a texture [Deprecated]\n\n @param [in] offset  Offset in bytes.\n @param [in] texref  Pointer of texture reference.\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n\n @warning This API is deprecated.\n"]
    pub fn hipGetTextureAlignmentOffset(
        offset: *mut usize,
        texref: *const textureReference,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Unbinds a texture [Deprecated]\n\n @param [in] tex  Texture to unbind.\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n\n @warning This API is deprecated.\n"]
    pub fn hipUnbindTexture(tex: *const textureReference) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets the address for a texture reference [Deprecated]\n\n @param [out] dev_ptr  Pointer of device address.\n @param [in] texRef  Pointer of texture reference.\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n\n @warning This API is deprecated.\n"]
    pub fn hipTexRefGetAddress(
        dev_ptr: *mut hipDeviceptr_t,
        texRef: *const textureReference,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets the address mode for a texture reference [Deprecated]\n\n @param [out] pam  Pointer of address mode.\n @param [in] texRef  Pointer of texture reference.\n @param [in] dim  Dimension.\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n\n @warning This API is deprecated.\n"]
    pub fn hipTexRefGetAddressMode(
        pam: *mut hipTextureAddressMode,
        texRef: *const textureReference,
        dim: ::std::os::raw::c_int,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets filter mode for a texture reference [Deprecated]\n\n @param [out] pfm  Pointer of filter mode.\n @param [in] texRef  Pointer of texture reference.\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n\n @warning This API is deprecated.\n"]
    pub fn hipTexRefGetFilterMode(
        pfm: *mut hipTextureFilterMode,
        texRef: *const textureReference,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets flags for a texture reference [Deprecated]\n\n @param [out] pFlags  Pointer of flags.\n @param [in] texRef  Pointer of texture reference.\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n\n @warning This API is deprecated.\n"]
    pub fn hipTexRefGetFlags(
        pFlags: *mut ::std::os::raw::c_uint,
        texRef: *const textureReference,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets texture format for a texture reference [Deprecated]\n\n @param [out] pFormat  Pointer of the format.\n @param [out] pNumChannels  Pointer of number of channels.\n @param [in] texRef  Pointer of texture reference.\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n\n @warning This API is deprecated.\n"]
    pub fn hipTexRefGetFormat(
        pFormat: *mut hipArray_Format,
        pNumChannels: *mut ::std::os::raw::c_int,
        texRef: *const textureReference,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets the maximum anisotropy for a texture reference [Deprecated]\n\n @param [out] pmaxAnsio  Pointer of the maximum anisotropy.\n @param [in] texRef  Pointer of texture reference.\n\n @returns #hipErrorInvalidValue, #hipErrorNotSupported\n\n @warning This API is deprecated.\n"]
    pub fn hipTexRefGetMaxAnisotropy(
        pmaxAnsio: *mut ::std::os::raw::c_int,
        texRef: *const textureReference,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets the mipmap filter mode for a texture reference [Deprecated]\n\n @param [out] pfm  Pointer of the mipmap filter mode.\n @param [in] texRef  Pointer of texture reference.\n\n @returns #hipErrorInvalidValue, #hipErrorNotSupported\n\n @warning This API is deprecated.\n"]
    pub fn hipTexRefGetMipmapFilterMode(
        pfm: *mut hipTextureFilterMode,
        texRef: *const textureReference,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets the mipmap level bias for a texture reference [Deprecated]\n\n @param [out] pbias  Pointer of the mipmap level bias.\n @param [in] texRef  Pointer of texture reference.\n\n @returns #hipErrorInvalidValue, #hipErrorNotSupported\n\n @warning This API is deprecated.\n"]
    pub fn hipTexRefGetMipmapLevelBias(
        pbias: *mut f32,
        texRef: *const textureReference,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets the minimum and maximum mipmap level clamps for a texture reference [Deprecated]\n\n @param [out] pminMipmapLevelClamp  Pointer of the minimum mipmap level clamp.\n @param [out] pmaxMipmapLevelClamp  Pointer of the maximum mipmap level clamp.\n @param [in] texRef  Pointer of texture reference.\n\n @returns #hipErrorInvalidValue, #hipErrorNotSupported\n\n @warning This API is deprecated.\n"]
    pub fn hipTexRefGetMipmapLevelClamp(
        pminMipmapLevelClamp: *mut f32,
        pmaxMipmapLevelClamp: *mut f32,
        texRef: *const textureReference,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets the mipmapped array bound to a texture reference [Deprecated]\n\n @param [out] pArray  Pointer of the mipmapped array.\n @param [in] texRef  Pointer of texture reference.\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n\n @warning This API is deprecated.\n"]
    pub fn hipTexRefGetMipMappedArray(
        pArray: *mut hipMipmappedArray_t,
        texRef: *const textureReference,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets an bound address for a texture reference [Deprecated]\n\n @param [out] ByteOffset  Pointer of the offset in bytes.\n @param [in] texRef  Pointer of texture reference.\n @param [in] dptr  Pointer of device address to bind.\n @param [in] bytes  Size in bytes.\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @warning This API is deprecated.\n"]
    pub fn hipTexRefSetAddress(
        ByteOffset: *mut usize,
        texRef: *mut textureReference,
        dptr: hipDeviceptr_t,
        bytes: usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Set a bind an address as a 2D texture reference [Deprecated]\n\n @param [in] texRef  Pointer of texture reference.\n @param [in] desc  Pointer of array descriptor.\n @param [in] dptr  Pointer of device address to bind.\n @param [in] Pitch  Pitch in bytes.\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n\n @warning This API is deprecated.\n"]
    pub fn hipTexRefSetAddress2D(
        texRef: *mut textureReference,
        desc: *const HIP_ARRAY_DESCRIPTOR,
        dptr: hipDeviceptr_t,
        Pitch: usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets the maximum anisotropy for a texture reference [Deprecated]\n\n @param [in] texRef  Pointer of texture reference.\n @param [out] maxAniso  Value of the maximum anisotropy.\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n\n @warning This API is deprecated.\n"]
    pub fn hipTexRefSetMaxAnisotropy(
        texRef: *mut textureReference,
        maxAniso: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets border color for a texture reference [Deprecated]\n\n @param [in] texRef  Pointer of texture reference.\n @param [in] pBorderColor  Pointer of border color.\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n\n @warning This API is deprecated.\n"]
    pub fn hipTexRefSetBorderColor(
        texRef: *mut textureReference,
        pBorderColor: *mut f32,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets mipmap filter mode for a texture reference [Deprecated]\n\n @param [in] texRef  Pointer of texture reference.\n @param [in] fm  Value of filter mode.\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n\n @warning This API is deprecated.\n"]
    pub fn hipTexRefSetMipmapFilterMode(
        texRef: *mut textureReference,
        fm: hipTextureFilterMode,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets mipmap level bias for a texture reference [Deprecated]\n\n @param [in] texRef  Pointer of texture reference.\n @param [in] bias  Value of mipmap bias.\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n\n @warning This API is deprecated.\n"]
    pub fn hipTexRefSetMipmapLevelBias(texRef: *mut textureReference, bias: f32) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets mipmap level clamp for a texture reference [Deprecated]\n\n @param [in] texRef  Pointer of texture reference.\n @param [in] minMipMapLevelClamp  Value of minimum mipmap level clamp.\n @param [in] maxMipMapLevelClamp  Value of maximum mipmap level clamp.\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n\n @warning This API is deprecated.\n"]
    pub fn hipTexRefSetMipmapLevelClamp(
        texRef: *mut textureReference,
        minMipMapLevelClamp: f32,
        maxMipMapLevelClamp: f32,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Binds mipmapped array to a texture reference [Deprecated]\n\n @param [in] texRef  Pointer of texture reference to bind.\n @param [in] mipmappedArray  Pointer of mipmapped array to bind.\n @param [in] Flags  Flags should be set as HIP_TRSA_OVERRIDE_FORMAT, as a valid value.\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @warning This API is deprecated.\n"]
    pub fn hipTexRefSetMipmappedArray(
        texRef: *mut textureReference,
        mipmappedArray: *mut hipMipmappedArray,
        Flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = "  @defgroup Callback Callback Activity APIs\n  @{\n  This section describes the callback/Activity of HIP runtime API.\n/\n/**\n @brief Returns HIP API name by ID.\n\n @param [in] id ID of HIP API\n\n @returns #hipSuccess, #hipErrorInvalidValue\n"]
    pub fn hipApiName(id: u32) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " @brief Returns kernel name reference by function name.\n\n @param [in] f Name of function\n\n @returns #hipSuccess, #hipErrorInvalidValue\n"]
    pub fn hipKernelNameRef(f: hipFunction_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " @brief Retrives kernel for a given host pointer, unless stated otherwise.\n\n @param [in] hostFunction Pointer of host function.\n @param [in] stream Stream the kernel is executed on.\n\n @returns #hipSuccess, #hipErrorInvalidValue\n"]
    pub fn hipKernelNameRefByPtr(
        hostFunction: *const ::std::os::raw::c_void,
        stream: hipStream_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " @brief Returns device ID on the stream.\n\n @param [in] stream Stream of device executed on.\n\n @returns #hipSuccess, #hipErrorInvalidValue\n"]
    pub fn hipGetStreamDeviceId(stream: hipStream_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Begins graph capture on a stream.\n\n @param [in] stream - Stream to initiate capture.\n @param [in] mode - Controls the interaction of this capture sequence with other API calls that\n are not safe.\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n"]
    pub fn hipStreamBeginCapture(stream: hipStream_t, mode: hipStreamCaptureMode) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Begins graph capture on a stream to an existing graph.\n\n @param [in] stream - Stream to initiate capture.\n @param [in] graph - Graph to capture into.\n @param [in] dependencies - Dependencies of the first node captured in the stream. Can be NULL if\n numDependencies is 0.\n @param [in] dependencyData - Optional array of data associated with each dependency.\n @param [in] numDependencies - Number of dependencies.\n @param [in] mode - Controls the interaction of this capture sequence with other API calls that\nare not safe.\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @warning param \"const hipGraphEdgeData* dependencyData\" is currently not supported and has to be\npassed as nullptr. This API is marked as beta, meaning, while this is feature complete, it is still\nopen to changes and may have outstanding issues."]
    pub fn hipStreamBeginCaptureToGraph(
        stream: hipStream_t,
        graph: hipGraph_t,
        dependencies: *const hipGraphNode_t,
        dependencyData: *const hipGraphEdgeData,
        numDependencies: usize,
        mode: hipStreamCaptureMode,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Ends capture on a stream, returning the captured graph.\n\n @param [in] stream - Stream to end capture.\n @param [out] pGraph - Captured graph.\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n"]
    pub fn hipStreamEndCapture(stream: hipStream_t, pGraph: *mut hipGraph_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Get capture status of a stream.\n\n @param [in] stream - Stream of which to get capture status from.\n @param [out] pCaptureStatus - Returns current capture status.\n @param [out] pId - Unique capture ID.\n\n @returns #hipSuccess, #hipErrorStreamCaptureImplicit\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n"]
    pub fn hipStreamGetCaptureInfo(
        stream: hipStream_t,
        pCaptureStatus: *mut hipStreamCaptureStatus,
        pId: *mut ::std::os::raw::c_ulonglong,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Get stream's capture state\n\n @param [in] stream - Stream of which to get capture status from.\n @param [out] captureStatus_out - Returns current capture status.\n @param [out] id_out - Unique capture ID.\n @param [out] graph_out - Returns the graph being captured into.\n @param [out] dependencies_out - Pointer to an array of nodes representing the graphs dependencies.\n @param [out] numDependencies_out - Returns size of the array returned in dependencies_out.\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorStreamCaptureImplicit\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n"]
    pub fn hipStreamGetCaptureInfo_v2(
        stream: hipStream_t,
        captureStatus_out: *mut hipStreamCaptureStatus,
        id_out: *mut ::std::os::raw::c_ulonglong,
        graph_out: *mut hipGraph_t,
        dependencies_out: *mut *const hipGraphNode_t,
        numDependencies_out: *mut usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Get stream's capture state\n\n @param [in] stream - Stream of which to get capture status from.\n @param [out] pCaptureStatus - Returns current capture status.\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorStreamCaptureImplicit\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n"]
    pub fn hipStreamIsCapturing(
        stream: hipStream_t,
        pCaptureStatus: *mut hipStreamCaptureStatus,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Update the set of dependencies in a capturing stream\n\n @param [in] stream  Stream that is being captured.\n @param [in] dependencies  Pointer to an array of nodes to add/replace.\n @param [in] numDependencies  Size of the dependencies array.\n @param [in] flags  Flag to update dependency set. Should be one of the values\n in enum #hipStreamUpdateCaptureDependenciesFlags.\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorIllegalState\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n"]
    pub fn hipStreamUpdateCaptureDependencies(
        stream: hipStream_t,
        dependencies: *mut hipGraphNode_t,
        numDependencies: usize,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Swaps the stream capture mode of a thread.\n\n @param [in] mode - Pointer to mode value to swap with the current mode.\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n"]
    pub fn hipThreadExchangeStreamCaptureMode(mode: *mut hipStreamCaptureMode) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Creates a graph\n\n @param [out] pGraph - pointer to graph to create.\n @param [in] flags - flags for graph creation, must be 0.\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorMemoryAllocation\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n"]
    pub fn hipGraphCreate(pGraph: *mut hipGraph_t, flags: ::std::os::raw::c_uint) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Destroys a graph\n\n @param [in] graph - instance of graph to destroy.\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n"]
    pub fn hipGraphDestroy(graph: hipGraph_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Adds dependency edges to a graph.\n\n @param [in] graph - Instance of the graph to add dependencies to.\n @param [in] from - Pointer to the graph nodes with dependencies to add from.\n @param [in] to - Pointer to the graph nodes to add dependencies to.\n @param [in] numDependencies - Number of dependencies to add.\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n"]
    pub fn hipGraphAddDependencies(
        graph: hipGraph_t,
        from: *const hipGraphNode_t,
        to: *const hipGraphNode_t,
        numDependencies: usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Removes dependency edges from a graph.\n\n @param [in] graph - Instance of the graph to remove dependencies from.\n @param [in] from - Array of nodes that provide the dependencies.\n @param [in] to - Array of dependent nodes.\n @param [in] numDependencies - Number of dependencies to remove.\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n"]
    pub fn hipGraphRemoveDependencies(
        graph: hipGraph_t,
        from: *const hipGraphNode_t,
        to: *const hipGraphNode_t,
        numDependencies: usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns a graph's dependency edges.\n\n @param [in] graph - Instance of the graph to get the edges from.\n @param [out] from - Pointer to the graph nodes to return edge endpoints.\n @param [out] to - Pointer to the graph nodes to return edge endpoints.\n @param [out] numEdges - Returns number of edges.\n @returns #hipSuccess, #hipErrorInvalidValue\n\n from and to may both be NULL, in which case this function only returns the number of edges in\n numEdges. Otherwise, numEdges entries will be filled in. If numEdges is higher than the actual\n number of edges, the remaining entries in from and to will be set to NULL, and the number of\n edges actually returned will be written to numEdges.\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n"]
    pub fn hipGraphGetEdges(
        graph: hipGraph_t,
        from: *mut hipGraphNode_t,
        to: *mut hipGraphNode_t,
        numEdges: *mut usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns a graph's nodes.\n\n @param [in] graph - Instance of graph to get the nodes from.\n @param [out] nodes - Pointer to return the  graph nodes.\n @param [out] numNodes - Returns the number of graph nodes.\n @returns #hipSuccess, #hipErrorInvalidValue\n\n nodes may be NULL, in which case this function will return the number of nodes in numNodes.\n Otherwise, numNodes entries will be filled in. If numNodes is higher than the actual number of\n nodes, the remaining entries in nodes will be set to NULL, and the number of nodes actually\n obtained will be returned in numNodes.\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n"]
    pub fn hipGraphGetNodes(
        graph: hipGraph_t,
        nodes: *mut hipGraphNode_t,
        numNodes: *mut usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns a graph's root nodes.\n\n @param [in] graph - Instance of the graph to get the nodes from.\n @param [out] pRootNodes - Pointer to return the graph's root nodes.\n @param [out] pNumRootNodes - Returns the number of graph's root nodes.\n @returns #hipSuccess, #hipErrorInvalidValue\n\n pRootNodes may be NULL, in which case this function will return the number of root nodes in\n pNumRootNodes. Otherwise, pNumRootNodes entries will be filled in. If pNumRootNodes is higher\n than the actual number of root nodes, the remaining entries in pRootNodes will be set to NULL,\n and the number of nodes actually obtained will be returned in pNumRootNodes.\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n"]
    pub fn hipGraphGetRootNodes(
        graph: hipGraph_t,
        pRootNodes: *mut hipGraphNode_t,
        pNumRootNodes: *mut usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns a node's dependencies.\n\n @param [in] node - Graph node to get the dependencies from.\n @param [out] pDependencies - Pointer to return the dependencies.\n @param [out] pNumDependencies -  Returns the number of graph node dependencies.\n @returns #hipSuccess, #hipErrorInvalidValue\n\n pDependencies may be NULL, in which case this function will return the number of dependencies in\n pNumDependencies. Otherwise, pNumDependencies entries will be filled in. If pNumDependencies is\n higher than the actual number of dependencies, the remaining entries in pDependencies will be set\n to NULL, and the number of nodes actually obtained will be returned in pNumDependencies.\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n"]
    pub fn hipGraphNodeGetDependencies(
        node: hipGraphNode_t,
        pDependencies: *mut hipGraphNode_t,
        pNumDependencies: *mut usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns a node's dependent nodes.\n\n @param [in] node - Graph node to get the dependent nodes from.\n @param [out] pDependentNodes - Pointer to return the graph dependent nodes.\n @param [out] pNumDependentNodes - Returns the number of graph node dependent nodes.\n @returns #hipSuccess, #hipErrorInvalidValue\n\n pDependentNodes may be NULL, in which case this function will return the number of dependent nodes\n in pNumDependentNodes. Otherwise, pNumDependentNodes entries will be filled in. If\n pNumDependentNodes is higher than the actual number of dependent nodes, the remaining entries in\n pDependentNodes will be set to NULL, and the number of nodes actually obtained will be returned\n in pNumDependentNodes.\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n"]
    pub fn hipGraphNodeGetDependentNodes(
        node: hipGraphNode_t,
        pDependentNodes: *mut hipGraphNode_t,
        pNumDependentNodes: *mut usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns a node's type.\n\n @param [in] node - Node to get type of.\n @param [out] pType - Returns the node's type.\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n"]
    pub fn hipGraphNodeGetType(node: hipGraphNode_t, pType: *mut hipGraphNodeType) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Remove a node from the graph.\n\n @param [in] node - graph node to remove\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n"]
    pub fn hipGraphDestroyNode(node: hipGraphNode_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Clones a graph.\n\n @param [out] pGraphClone - Returns newly created cloned graph.\n @param [in] originalGraph - original graph to clone from.\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorMemoryAllocation\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n"]
    pub fn hipGraphClone(pGraphClone: *mut hipGraph_t, originalGraph: hipGraph_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Finds a cloned version of a node.\n\n @param [out] pNode - Returns the cloned node.\n @param [in] originalNode - original node handle.\n @param [in] clonedGraph - Cloned graph to query.\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n"]
    pub fn hipGraphNodeFindInClone(
        pNode: *mut hipGraphNode_t,
        originalNode: hipGraphNode_t,
        clonedGraph: hipGraph_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Creates an executable graph from a graph\n\n @param [out] pGraphExec - Pointer to instantiated executable graph.\n @param [in] graph - Instance of graph to instantiate.\n @param [out] pErrorNode - Pointer to error node. In case an error occured during\n graph instantiation, it could modify the corresponding node.\n @param [out] pLogBuffer - Pointer to log buffer.\n @param [out] bufferSize - Size of the log buffer.\n\n @returns #hipSuccess, #hipErrorOutOfMemory\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n"]
    pub fn hipGraphInstantiate(
        pGraphExec: *mut hipGraphExec_t,
        graph: hipGraph_t,
        pErrorNode: *mut hipGraphNode_t,
        pLogBuffer: *mut ::std::os::raw::c_char,
        bufferSize: usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Creates an executable graph from a graph.\n\n @param [out] pGraphExec - Pointer to instantiated executable graph.\n @param [in] graph - Instance of graph to instantiate.\n @param [in] flags - Flags to control instantiation.\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues. It does not support any of\n          flag and is behaving as hipGraphInstantiate."]
    pub fn hipGraphInstantiateWithFlags(
        pGraphExec: *mut hipGraphExec_t,
        graph: hipGraph_t,
        flags: ::std::os::raw::c_ulonglong,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Creates an executable graph from a graph.\n\n @param [out] pGraphExec - Pointer to instantiated executable graph.\n @param [in] graph - Instance of graph to instantiate.\n @param [in] instantiateParams - Graph instantiation Params\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphInstantiateWithParams(
        pGraphExec: *mut hipGraphExec_t,
        graph: hipGraph_t,
        instantiateParams: *mut hipGraphInstantiateParams,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Launches an executable graph in the specified stream.\n\n @param [in] graphExec - Instance of executable graph to launch.\n @param [in] stream - Instance of stream in which to launch executable graph.\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphLaunch(graphExec: hipGraphExec_t, stream: hipStream_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Uploads an executable graph to a stream\n\n @param [in] graphExec - Instance of executable graph to be uploaded.\n @param [in] stream - Instance of stream to which the executable graph is uploaded to.\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphUpload(graphExec: hipGraphExec_t, stream: hipStream_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Creates a kernel execution node and adds it to a graph.\n\n @param [out] pGraphNode - Pointer to kernel graph node that is created.\n @param [in] graph - Instance of graph to add the created node to.\n @param [in] pDependencies - Pointer to the dependencies on the kernel execution node.\n @param [in] numDependencies - Number of dependencies.\n @param [in] nodeParams - Pointer to the node parameters.\n @returns #hipSuccess, #hipErrorInvalidValue.\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphAddNode(
        pGraphNode: *mut hipGraphNode_t,
        graph: hipGraph_t,
        pDependencies: *const hipGraphNode_t,
        numDependencies: usize,
        nodeParams: *mut hipGraphNodeParams,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Return the flags of an executable graph.\n\n @param [in] graphExec - Executable graph to get the flags from.\n @param [out] flags - Flags used to instantiate this executable graph.\n @returns #hipSuccess, #hipErrorInvalidValue.\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphExecGetFlags(
        graphExec: hipGraphExec_t,
        flags: *mut ::std::os::raw::c_ulonglong,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Updates parameters of a graph's node.\n\n @param [in] node - Instance of the node to set parameters for.\n @param [in] nodeParams - Pointer to the parameters to be set.\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidDeviceFunction, #hipErrorNotSupported.\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphNodeSetParams(
        node: hipGraphNode_t,
        nodeParams: *mut hipGraphNodeParams,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Updates parameters of an executable graph's node.\n\n @param [in] graphExec - Instance of the executable graph.\n @param [in] node - Instance of the node to set parameters to.\n @param [in] nodeParams - Pointer to the parameters to be set.\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidDeviceFunction, #hipErrorNotSupported.\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphExecNodeSetParams(
        graphExec: hipGraphExec_t,
        node: hipGraphNode_t,
        nodeParams: *mut hipGraphNodeParams,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Destroys an executable graph\n\n @param [in] graphExec - Instance of executable graph to destroy.\n\n @returns #hipSuccess.\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphExecDestroy(graphExec: hipGraphExec_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Check whether an executable graph can be updated with a graph and perform the update if  *\n possible.\n\n @param [in] hGraphExec - instance of executable graph to update.\n @param [in] hGraph - graph that contains the updated parameters.\n @param [in] hErrorNode_out -  node which caused the permissibility check to forbid the update.\n @param [in] updateResult_out - Return code whether the graph update was performed.\n @returns #hipSuccess, #hipErrorGraphExecUpdateFailure\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphExecUpdate(
        hGraphExec: hipGraphExec_t,
        hGraph: hipGraph_t,
        hErrorNode_out: *mut hipGraphNode_t,
        updateResult_out: *mut hipGraphExecUpdateResult,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Creates a kernel execution node and adds it to a graph.\n\n @param [out] pGraphNode - Pointer to graph node that is created\n @param [in] graph - Instance of graph to add the created node to.\n @param [in] pDependencies - Pointer to the dependencies of the kernel execution node.\n @param [in] numDependencies - The number of the dependencies.\n @param [in] pNodeParams - Pointer to the parameters of the kernel execution node.\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorInvalidDeviceFunction\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphAddKernelNode(
        pGraphNode: *mut hipGraphNode_t,
        graph: hipGraph_t,
        pDependencies: *const hipGraphNode_t,
        numDependencies: usize,
        pNodeParams: *const hipKernelNodeParams,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets kernel node's parameters.\n\n @param [in] node - instance of the node to get parameters from.\n @param [out] pNodeParams - pointer to the parameters\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphKernelNodeGetParams(
        node: hipGraphNode_t,
        pNodeParams: *mut hipKernelNodeParams,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets a kernel node's parameters.\n\n @param [in] node - Instance of the node to set parameters of.\n @param [in] pNodeParams - const pointer to the parameters.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphKernelNodeSetParams(
        node: hipGraphNode_t,
        pNodeParams: *const hipKernelNodeParams,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets the parameters for a kernel node in the given graphExec.\n\n @param [in] hGraphExec - Instance of the executable graph with the node.\n @param [in] node - Instance of the node to set parameters of.\n @param [in] pNodeParams - const pointer to the kernel node parameters.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphExecKernelNodeSetParams(
        hGraphExec: hipGraphExec_t,
        node: hipGraphNode_t,
        pNodeParams: *const hipKernelNodeParams,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Creates a memcpy node and adds it to a graph.\n\n @param [out] phGraphNode - Pointer to graph node that is created.\n @param [in] hGraph - Instance of graph to add the created node to.\n @param [in] dependencies - const pointer to the dependencies of the memcpy execution node.\n @param [in] numDependencies - The number of dependencies.\n @param [in] copyParams - const pointer to the parameters for the memory copy.\n @param [in] ctx - context related to current device.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipDrvGraphAddMemcpyNode(
        phGraphNode: *mut hipGraphNode_t,
        hGraph: hipGraph_t,
        dependencies: *const hipGraphNode_t,
        numDependencies: usize,
        copyParams: *const HIP_MEMCPY3D,
        ctx: hipCtx_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Creates a memcpy node and adds it to a graph.\n\n @param [out] pGraphNode - Pointer to graph node that is created.\n @param [in] graph - Instance of graph to add the created node to.\n @param [in] pDependencies - const pointer to the dependencies of the memcpy execution node.\n @param [in] numDependencies - The number of dependencies.\n @param [in] pCopyParams - const pointer to the parameters for the memory copy.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphAddMemcpyNode(
        pGraphNode: *mut hipGraphNode_t,
        graph: hipGraph_t,
        pDependencies: *const hipGraphNode_t,
        numDependencies: usize,
        pCopyParams: *const hipMemcpy3DParms,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets a memcpy node's parameters.\n\n @param [in] node - instance of the node to get parameters from.\n @param [out] pNodeParams - pointer to the parameters.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphMemcpyNodeGetParams(
        node: hipGraphNode_t,
        pNodeParams: *mut hipMemcpy3DParms,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets a memcpy node's parameters.\n\n @param [in] node - instance of the node to set parameters to.\n @param [in] pNodeParams - const pointer to the parameters.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphMemcpyNodeSetParams(
        node: hipGraphNode_t,
        pNodeParams: *const hipMemcpy3DParms,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets a node's attribute.\n\n @param [in] hNode - Instance of the node to set parameters of.\n @param [in] attr - The attribute type to be set.\n @param [in] value - const pointer to the parameters.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphKernelNodeSetAttribute(
        hNode: hipGraphNode_t,
        attr: hipLaunchAttributeID,
        value: *const hipLaunchAttributeValue,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets a node's attribute.\n\n @param [in] hNode - Instance of the node to set parameters of.\n @param [in] attr - The attribute type to be set.\n @param [in] value - const pointer to the parameters.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphKernelNodeGetAttribute(
        hNode: hipGraphNode_t,
        attr: hipLaunchAttributeID,
        value: *mut hipLaunchAttributeValue,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets the parameters of a memcpy node in the given graphExec.\n\n @param [in] hGraphExec - Instance of the executable graph with the node.\n @param [in] node - Instance of the node to set parameters of.\n @param [in] pNodeParams - const pointer to the kernel node parameters.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphExecMemcpyNodeSetParams(
        hGraphExec: hipGraphExec_t,
        node: hipGraphNode_t,
        pNodeParams: *mut hipMemcpy3DParms,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Creates a 1D memcpy node and adds it to a graph.\n\n @param [out] pGraphNode - Pointer to graph node that is created.\n @param [in] graph - Instance of graph to add the created node to.\n @param [in] pDependencies - const pointer to the dependencies of the memcpy execution node.\n @param [in] numDependencies - The number of dependencies.\n @param [in] dst - Pointer to memory address of the destination.\n @param [in] src - Pointer to memory address of the source.\n @param [in] count - Size of the memory to copy.\n @param [in] kind - Type of memory copy.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphAddMemcpyNode1D(
        pGraphNode: *mut hipGraphNode_t,
        graph: hipGraph_t,
        pDependencies: *const hipGraphNode_t,
        numDependencies: usize,
        dst: *mut ::std::os::raw::c_void,
        src: *const ::std::os::raw::c_void,
        count: usize,
        kind: hipMemcpyKind,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets a memcpy node's parameters to perform a 1-dimensional copy.\n\n @param [in] node - Instance of the node to set parameters of.\n @param [in] dst - Pointer to memory address of the destination.\n @param [in] src - Pointer to memory address of the source.\n @param [in] count - Size of the memory to copy.\n @param [in] kind - Type of memory copy.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphMemcpyNodeSetParams1D(
        node: hipGraphNode_t,
        dst: *mut ::std::os::raw::c_void,
        src: *const ::std::os::raw::c_void,
        count: usize,
        kind: hipMemcpyKind,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets the parameters for a memcpy node in the given graphExec to perform a 1-dimensional\n copy.\n\n @param [in] hGraphExec - Instance of the executable graph with the node.\n @param [in] node - Instance of the node to set parameters of.\n @param [in] dst - Pointer to memory address of the destination.\n @param [in] src - Pointer to memory address of the source.\n @param [in] count - Size of the memory to copy.\n @param [in] kind - Type of memory copy.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphExecMemcpyNodeSetParams1D(
        hGraphExec: hipGraphExec_t,
        node: hipGraphNode_t,
        dst: *mut ::std::os::raw::c_void,
        src: *const ::std::os::raw::c_void,
        count: usize,
        kind: hipMemcpyKind,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Creates a memcpy node to copy from a symbol on the device and adds it to a graph.\n\n @param [out] pGraphNode - Pointer to graph node that is created.\n @param [in] graph - Instance of graph to add the created node to.\n @param [in] pDependencies - const pointer to the dependencies of the memcpy execution node.\n @param [in] numDependencies - Number of the dependencies.\n @param [in] dst - Pointer to memory address of the destination.\n @param [in] symbol - Device symbol address.\n @param [in] count - Size of the memory to copy.\n @param [in] offset - Offset from start of symbol in bytes.\n @param [in] kind - Type of memory copy.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphAddMemcpyNodeFromSymbol(
        pGraphNode: *mut hipGraphNode_t,
        graph: hipGraph_t,
        pDependencies: *const hipGraphNode_t,
        numDependencies: usize,
        dst: *mut ::std::os::raw::c_void,
        symbol: *const ::std::os::raw::c_void,
        count: usize,
        offset: usize,
        kind: hipMemcpyKind,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets a memcpy node's parameters to copy from a symbol on the device.\n\n @param [in] node - Instance of the node to set parameters of.\n @param [in] dst - Pointer to memory address of the destination.\n @param [in] symbol - Device symbol address.\n @param [in] count - Size of the memory to copy.\n @param [in] offset - Offset from start of symbol in bytes.\n @param [in] kind - Type of memory copy.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphMemcpyNodeSetParamsFromSymbol(
        node: hipGraphNode_t,
        dst: *mut ::std::os::raw::c_void,
        symbol: *const ::std::os::raw::c_void,
        count: usize,
        offset: usize,
        kind: hipMemcpyKind,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets the parameters for a memcpy node in the given graphExec to copy from a symbol on the\n * device.\n\n @param [in] hGraphExec - Instance of the executable graph with the node.\n @param [in] node - Instance of the node to set parameters of.\n @param [in] dst - Pointer to memory address of the destination.\n @param [in] symbol - Device symbol address.\n @param [in] count - Size of the memory to copy.\n @param [in] offset - Offset from start of symbol in bytes.\n @param [in] kind - Type of memory copy.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphExecMemcpyNodeSetParamsFromSymbol(
        hGraphExec: hipGraphExec_t,
        node: hipGraphNode_t,
        dst: *mut ::std::os::raw::c_void,
        symbol: *const ::std::os::raw::c_void,
        count: usize,
        offset: usize,
        kind: hipMemcpyKind,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Creates a memcpy node to copy to a symbol on the device and adds it to a graph.\n\n @param [out] pGraphNode - Pointer to graph node that is created.\n @param [in] graph - Instance of graph to add the created node to.\n @param [in] pDependencies - const pointer to the dependencies on the memcpy execution node.\n @param [in] numDependencies - Number of dependencies.\n @param [in] symbol - Device symbol address.\n @param [in] src - Pointer to memory address of the src.\n @param [in] count - Size of the memory to copy.\n @param [in] offset - Offset from start of symbol in bytes.\n @param [in] kind - Type of memory copy.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphAddMemcpyNodeToSymbol(
        pGraphNode: *mut hipGraphNode_t,
        graph: hipGraph_t,
        pDependencies: *const hipGraphNode_t,
        numDependencies: usize,
        symbol: *const ::std::os::raw::c_void,
        src: *const ::std::os::raw::c_void,
        count: usize,
        offset: usize,
        kind: hipMemcpyKind,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets a memcpy node's parameters to copy to a symbol on the device.\n\n @param [in] node - Instance of the node to set parameters of.\n @param [in] symbol - Device symbol address.\n @param [in] src - Pointer to memory address of the src.\n @param [in] count - Size of the memory to copy.\n @param [in] offset - Offset from start of symbol in bytes.\n @param [in] kind - Type of memory copy.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphMemcpyNodeSetParamsToSymbol(
        node: hipGraphNode_t,
        symbol: *const ::std::os::raw::c_void,
        src: *const ::std::os::raw::c_void,
        count: usize,
        offset: usize,
        kind: hipMemcpyKind,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets the parameters for a memcpy node in the given graphExec to copy to a symbol on the\n device.\n @param [in] hGraphExec - Instance of the executable graph with the node.\n @param [in] node - Instance of the node to set parameters of.\n @param [in] symbol - Device symbol address.\n @param [in] src - Pointer to memory address of the src.\n @param [in] count - Size of the memory to copy.\n @param [in] offset - Offset from start of symbol in bytes.\n @param [in] kind - Type of memory copy.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphExecMemcpyNodeSetParamsToSymbol(
        hGraphExec: hipGraphExec_t,
        node: hipGraphNode_t,
        symbol: *const ::std::os::raw::c_void,
        src: *const ::std::os::raw::c_void,
        count: usize,
        offset: usize,
        kind: hipMemcpyKind,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Creates a memset node and adds it to a graph.\n\n @param [out] pGraphNode - Pointer to graph node that is created.\n @param [in] graph - Instance of the graph to add the created node to.\n @param [in] pDependencies - const pointer to the dependencies on the memset execution node.\n @param [in] numDependencies - Number of dependencies.\n @param [in] pMemsetParams - const pointer to the parameters for the memory set.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphAddMemsetNode(
        pGraphNode: *mut hipGraphNode_t,
        graph: hipGraph_t,
        pDependencies: *const hipGraphNode_t,
        numDependencies: usize,
        pMemsetParams: *const hipMemsetParams,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets a memset node's parameters.\n\n @param [in] node - Instance of the node to get parameters of.\n @param [out] pNodeParams - Pointer to the parameters.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphMemsetNodeGetParams(
        node: hipGraphNode_t,
        pNodeParams: *mut hipMemsetParams,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets a memset node's parameters.\n\n @param [in] node - Instance of the node to set parameters of.\n @param [in] pNodeParams - Pointer to the parameters.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphMemsetNodeSetParams(
        node: hipGraphNode_t,
        pNodeParams: *const hipMemsetParams,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets the parameters for a memset node in the given graphExec.\n\n @param [in] hGraphExec - Instance of the executable graph with the node.\n @param [in] node - Instance of the node to set parameters of.\n @param [in] pNodeParams - Pointer to the parameters.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphExecMemsetNodeSetParams(
        hGraphExec: hipGraphExec_t,
        node: hipGraphNode_t,
        pNodeParams: *const hipMemsetParams,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Creates a host execution node and adds it to a graph.\n\n @param [out] pGraphNode - Pointer to graph node that is created.\n @param [in] graph - Instance of the graph to add the created node to.\n @param [in] pDependencies - const pointer to the dependencies of the memset execution node.\n @param [in] numDependencies - Number of dependencies.\n @param [in] pNodeParams - Pointer to the parameters.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphAddHostNode(
        pGraphNode: *mut hipGraphNode_t,
        graph: hipGraph_t,
        pDependencies: *const hipGraphNode_t,
        numDependencies: usize,
        pNodeParams: *const hipHostNodeParams,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns a host node's parameters.\n\n @param [in] node - Instance of the node to get parameters of.\n @param [out] pNodeParams - Pointer to the parameters.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphHostNodeGetParams(
        node: hipGraphNode_t,
        pNodeParams: *mut hipHostNodeParams,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets a host node's parameters.\n\n @param [in] node - Instance of the node to set parameters of.\n @param [in] pNodeParams - Pointer to the parameters.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphHostNodeSetParams(
        node: hipGraphNode_t,
        pNodeParams: *const hipHostNodeParams,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets the parameters for a host node in the given graphExec.\n\n @param [in] hGraphExec - Instance of the executable graph with the node.\n @param [in] node - Instance of the node to set parameters of.\n @param [in] pNodeParams - Pointer to the parameters.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphExecHostNodeSetParams(
        hGraphExec: hipGraphExec_t,
        node: hipGraphNode_t,
        pNodeParams: *const hipHostNodeParams,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Creates a child graph node and adds it to a graph.\n\n @param [out] pGraphNode - Pointer to graph node that is created.\n @param [in] graph - Instance of the graph to add the created node.\n @param [in] pDependencies - const pointer to the dependencies of the memset execution node.\n @param [in] numDependencies - Number of dependencies.\n @param [in] childGraph - Graph to clone into this node\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphAddChildGraphNode(
        pGraphNode: *mut hipGraphNode_t,
        graph: hipGraph_t,
        pDependencies: *const hipGraphNode_t,
        numDependencies: usize,
        childGraph: hipGraph_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets a handle to the embedded graph of a child graph node.\n\n @param [in] node - Instance of the node to get child graph of.\n @param [out] pGraph - Pointer to get the graph.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphChildGraphNodeGetGraph(
        node: hipGraphNode_t,
        pGraph: *mut hipGraph_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Updates node parameters in the child graph node in the given graphExec.\n\n @param [in] hGraphExec - instance of the executable graph with the node.\n @param [in] node - node from the graph which was used to instantiate graphExec.\n @param [in] childGraph - child graph with updated parameters.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphExecChildGraphNodeSetParams(
        hGraphExec: hipGraphExec_t,
        node: hipGraphNode_t,
        childGraph: hipGraph_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Creates an empty node and adds it to a graph.\n\n @param [out] pGraphNode - Pointer to graph node that is created.\n @param [in] graph - Instance of the graph the node is added to.\n @param [in] pDependencies - const pointer to the node dependencies.\n @param [in] numDependencies - Number of dependencies.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphAddEmptyNode(
        pGraphNode: *mut hipGraphNode_t,
        graph: hipGraph_t,
        pDependencies: *const hipGraphNode_t,
        numDependencies: usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Creates an event record node and adds it to a graph.\n\n @param [out] pGraphNode - Pointer to graph node that is created.\n @param [in] graph - Instance of the graph the node is added to.\n @param [in] pDependencies - const pointer to the node dependencies.\n @param [in] numDependencies - Number of dependencies.\n @param [in] event - Event of the node.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphAddEventRecordNode(
        pGraphNode: *mut hipGraphNode_t,
        graph: hipGraph_t,
        pDependencies: *const hipGraphNode_t,
        numDependencies: usize,
        event: hipEvent_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns the event associated with an event record node.\n\n @param [in] node -  Instance of the node to get event of.\n @param [out] event_out - Pointer to return the event.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphEventRecordNodeGetEvent(
        node: hipGraphNode_t,
        event_out: *mut hipEvent_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets an event record node's event.\n\n @param [in] node - Instance of the node to set event to.\n @param [in] event - Pointer to the event.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphEventRecordNodeSetEvent(node: hipGraphNode_t, event: hipEvent_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets the event for an event record node in the given graphExec.\n\n @param [in] hGraphExec - instance of the executable graph with the node.\n @param [in] hNode - node from the graph which was used to instantiate graphExec.\n @param [in] event - pointer to the event.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphExecEventRecordNodeSetEvent(
        hGraphExec: hipGraphExec_t,
        hNode: hipGraphNode_t,
        event: hipEvent_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Creates an event wait node and adds it to a graph.\n\n @param [out] pGraphNode - Pointer to graph node that is created.\n @param [in] graph - Instance of the graph the node to be added.\n @param [in] pDependencies - const pointer to the node dependencies.\n @param [in] numDependencies - Number of dependencies.\n @param [in] event - Event for the node.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphAddEventWaitNode(
        pGraphNode: *mut hipGraphNode_t,
        graph: hipGraph_t,
        pDependencies: *const hipGraphNode_t,
        numDependencies: usize,
        event: hipEvent_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns the event associated with an event wait node.\n\n @param [in] node -  Instance of the node to get event of.\n @param [out] event_out - Pointer to return the event.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphEventWaitNodeGetEvent(
        node: hipGraphNode_t,
        event_out: *mut hipEvent_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets an event wait node's event.\n\n @param [in] node - Instance of the node to set event of.\n @param [in] event - Pointer to the event.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphEventWaitNodeSetEvent(node: hipGraphNode_t, event: hipEvent_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets the event for an event record node in the given graphExec.\n\n @param [in] hGraphExec - instance of the executable graph with the node.\n @param [in] hNode - node from the graph which was used to instantiate graphExec.\n @param [in] event - pointer to the event.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphExecEventWaitNodeSetEvent(
        hGraphExec: hipGraphExec_t,
        hNode: hipGraphNode_t,
        event: hipEvent_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Creates a memory allocation node and adds it to a graph\n\n @param [out] pGraphNode      - Pointer to the graph node to create and add to the graph\n @param [in] graph            - Instance of the graph node to be added\n @param [in] pDependencies    - Const pointer to the node dependencies\n @param [in] numDependencies  - The number of dependencies\n @param [in, out] pNodeParams - Node parameters for memory allocation, returns a pointer to the allocated memory.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphAddMemAllocNode(
        pGraphNode: *mut hipGraphNode_t,
        graph: hipGraph_t,
        pDependencies: *const hipGraphNode_t,
        numDependencies: usize,
        pNodeParams: *mut hipMemAllocNodeParams,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns parameters for memory allocation node\n\n @param [in] node         - Memory allocation node to query\n @param [out] pNodeParams - Parameters for the specified memory allocation node\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphMemAllocNodeGetParams(
        node: hipGraphNode_t,
        pNodeParams: *mut hipMemAllocNodeParams,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Creates a memory free node and adds it to a graph\n\n @param [out] pGraphNode      - Pointer to the graph node to create and add to the graph\n @param [in] graph            - Instance of the graph node to be added\n @param [in] pDependencies    - Const pointer to the node dependencies\n @param [in] numDependencies  - The number of dependencies\n @param [in] dev_ptr          - Pointer to the memory to be freed\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphAddMemFreeNode(
        pGraphNode: *mut hipGraphNode_t,
        graph: hipGraph_t,
        pDependencies: *const hipGraphNode_t,
        numDependencies: usize,
        dev_ptr: *mut ::std::os::raw::c_void,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns parameters for memory free node\n\n @param [in] node     - Memory free node to query\n @param [out] dev_ptr - Device pointer of the specified memory free node\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphMemFreeNodeGetParams(
        node: hipGraphNode_t,
        dev_ptr: *mut ::std::os::raw::c_void,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Get the mem attribute for graphs.\n\n @param [in] device - Device to get attributes from\n @param [in] attr - Attribute type to be queried\n @param [out] value - Value of the queried attribute\n @returns #hipSuccess, #hipErrorInvalidDevice\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipDeviceGetGraphMemAttribute(
        device: ::std::os::raw::c_int,
        attr: hipGraphMemAttributeType,
        value: *mut ::std::os::raw::c_void,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Set the mem attribute for graphs.\n\n @param [in] device - Device to set attribute of.\n @param [in] attr - Attribute type to be set.\n @param [in] value - Value of the attribute.\n @returns #hipSuccess, #hipErrorInvalidDevice\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipDeviceSetGraphMemAttribute(
        device: ::std::os::raw::c_int,
        attr: hipGraphMemAttributeType,
        value: *mut ::std::os::raw::c_void,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Free unused memory reserved for graphs on a specific device and return it back to the OS.\n\n @param [in] device - Device for which memory should be trimmed\n @returns #hipSuccess, #hipErrorInvalidDevice\n\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipDeviceGraphMemTrim(device: ::std::os::raw::c_int) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Create an instance of userObject to manage lifetime of a resource.\n\n @param [out] object_out - pointer to instace of userobj.\n @param [in] ptr - pointer to pass to destroy function.\n @param [in] destroy - destroy callback to remove resource.\n @param [in] initialRefcount - reference to resource.\n @param [in] flags - flags passed to API.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipUserObjectCreate(
        object_out: *mut hipUserObject_t,
        ptr: *mut ::std::os::raw::c_void,
        destroy: hipHostFn_t,
        initialRefcount: ::std::os::raw::c_uint,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Release number of references to resource.\n\n @param [in] object - pointer to instace of userobj.\n @param [in] count - reference to resource to be retained.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipUserObjectRelease(
        object: hipUserObject_t,
        count: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Retain number of references to resource.\n\n @param [in] object - pointer to instace of userobj.\n @param [in] count - reference to resource to be retained.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipUserObjectRetain(
        object: hipUserObject_t,
        count: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Retain user object for graphs.\n\n @param [in] graph - pointer to graph to retain the user object for.\n @param [in] object - pointer to instace of userobj.\n @param [in] count - reference to resource to be retained.\n @param [in] flags - flags passed to API.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphRetainUserObject(
        graph: hipGraph_t,
        object: hipUserObject_t,
        count: ::std::os::raw::c_uint,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Release user object from graphs.\n\n @param [in] graph - pointer to graph to retain the user object for.\n @param [in] object - pointer to instace of userobj.\n @param [in] count - reference to resource to be retained.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphReleaseUserObject(
        graph: hipGraph_t,
        object: hipUserObject_t,
        count: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Write a DOT file describing graph structure.\n\n @param [in] graph - graph object for which DOT file has to be generated.\n @param [in] path - path to write the DOT file.\n @param [in] flags - Flags from hipGraphDebugDotFlags to get additional node information.\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorOperatingSystem\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphDebugDotPrint(
        graph: hipGraph_t,
        path: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Copies attributes from source node to destination node.\n\n Copies attributes from source node to destination node.\n Both node must have the same context.\n\n @param [out] hDst - Destination node.\n @param [in] hSrc - Source node.\n For list of attributes see ::hipKernelNodeAttrID.\n\n @returns #hipSuccess, #hipErrorInvalidContext\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphKernelNodeCopyAttributes(
        hSrc: hipGraphNode_t,
        hDst: hipGraphNode_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Enables or disables the specified node in the given graphExec\n\n Sets hNode to be either enabled or disabled. Disabled nodes are functionally equivalent\n to empty nodes until they are reenabled. Existing node parameters are not affected by\n disabling/enabling the node.\n\n The node is identified by the corresponding hNode in the non-executable graph, from which the\n executable graph was instantiated.\n\n hNode must not have been removed from the original graph.\n\n @note Currently only kernel, memset and memcpy nodes are supported.\n\n @param [in] hGraphExec - The executable graph in which to set the specified node.\n @param [in] hNode      - Node from the graph from which graphExec was instantiated.\n @param [in] isEnabled  - Node is enabled if != 0, otherwise the node is disabled.\n\n @returns #hipSuccess, #hipErrorInvalidValue,\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphNodeSetEnabled(
        hGraphExec: hipGraphExec_t,
        hNode: hipGraphNode_t,
        isEnabled: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Query whether a node in the given graphExec is enabled\n\n Sets isEnabled to 1 if hNode is enabled, or 0 if it is disabled.\n\n The node is identified by the corresponding node in the non-executable graph, from which the\n executable graph was instantiated.\n\n hNode must not have been removed from the original graph.\n\n @note Currently only kernel, memset and memcpy nodes are supported.\n\n @param [in]  hGraphExec - The executable graph in which to set the specified node.\n @param [in]  hNode      - Node from the graph from which graphExec was instantiated.\n @param [out] isEnabled  - Location to return the enabled status of the node.\n\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphNodeGetEnabled(
        hGraphExec: hipGraphExec_t,
        hNode: hipGraphNode_t,
        isEnabled: *mut ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Creates a external semaphor wait node and adds it to a graph.\n\n @param [out] pGraphNode - pointer to the graph node to create.\n @param [in] graph - instance of the graph to add the created node.\n @param [in] pDependencies - const pointer to the dependencies on the memset execution node.\n @param [in] numDependencies - the number of the dependencies.\n @param [in] nodeParams -pointer to the parameters.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphAddExternalSemaphoresWaitNode(
        pGraphNode: *mut hipGraphNode_t,
        graph: hipGraph_t,
        pDependencies: *const hipGraphNode_t,
        numDependencies: usize,
        nodeParams: *const hipExternalSemaphoreWaitNodeParams,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Creates a external semaphor signal node and adds it to a graph.\n\n @param [out] pGraphNode - pointer to the graph node to create.\n @param [in] graph - instance of the graph to add the created node.\n @param [in] pDependencies - const pointer to the dependencies on the memset execution node.\n @param [in] numDependencies - the number of the dependencies.\n @param [in] nodeParams -pointer to the parameters.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphAddExternalSemaphoresSignalNode(
        pGraphNode: *mut hipGraphNode_t,
        graph: hipGraph_t,
        pDependencies: *const hipGraphNode_t,
        numDependencies: usize,
        nodeParams: *const hipExternalSemaphoreSignalNodeParams,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Updates node parameters in the external semaphore signal node.\n\n @param [in]  hNode      - Node from the graph from which graphExec was instantiated.\n @param [in]  nodeParams  - Pointer to the params to be set.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphExternalSemaphoresSignalNodeSetParams(
        hNode: hipGraphNode_t,
        nodeParams: *const hipExternalSemaphoreSignalNodeParams,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Updates node parameters in the external semaphore wait node.\n\n @param [in]  hNode      - Node from the graph from which graphExec was instantiated.\n @param [in]  nodeParams  - Pointer to the params to be set.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphExternalSemaphoresWaitNodeSetParams(
        hNode: hipGraphNode_t,
        nodeParams: *const hipExternalSemaphoreWaitNodeParams,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns external semaphore signal node params.\n\n @param [in]   hNode       - Node from the graph from which graphExec was instantiated.\n @param [out]  params_out  - Pointer to params.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphExternalSemaphoresSignalNodeGetParams(
        hNode: hipGraphNode_t,
        params_out: *mut hipExternalSemaphoreSignalNodeParams,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns external semaphore wait node params.\n\n @param [in]   hNode       - Node from the graph from which graphExec was instantiated.\n @param [out]  params_out  - Pointer to params.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphExternalSemaphoresWaitNodeGetParams(
        hNode: hipGraphNode_t,
        params_out: *mut hipExternalSemaphoreWaitNodeParams,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Updates node parameters in the external semaphore signal node in the given graphExec.\n\n @param [in]  hGraphExec - The executable graph in which to set the specified node.\n @param [in]  hNode      - Node from the graph from which graphExec was instantiated.\n @param [in]  nodeParams  - Pointer to the params to be set.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphExecExternalSemaphoresSignalNodeSetParams(
        hGraphExec: hipGraphExec_t,
        hNode: hipGraphNode_t,
        nodeParams: *const hipExternalSemaphoreSignalNodeParams,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Updates node parameters in the external semaphore wait node in the given graphExec.\n\n @param [in]  hGraphExec - The executable graph in which to set the specified node.\n @param [in]  hNode      - Node from the graph from which graphExec was instantiated.\n @param [in]  nodeParams  - Pointer to the params to be set.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipGraphExecExternalSemaphoresWaitNodeSetParams(
        hGraphExec: hipGraphExec_t,
        hNode: hipGraphNode_t,
        nodeParams: *const hipExternalSemaphoreWaitNodeParams,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets a memcpy node's parameters.\n\n @param [in] hNode - instance of the node to get parameters from.\n @param [out] nodeParams - pointer to the parameters.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipDrvGraphMemcpyNodeGetParams(
        hNode: hipGraphNode_t,
        nodeParams: *mut HIP_MEMCPY3D,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets a memcpy node's parameters.\n\n @param [in] hNode - instance of the node to Set parameters for.\n @param [out] nodeParams - pointer to the parameters.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipDrvGraphMemcpyNodeSetParams(
        hNode: hipGraphNode_t,
        nodeParams: *const HIP_MEMCPY3D,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Creates a memset node and adds it to a graph.\n\n @param [out] phGraphNode - pointer to graph node to create.\n @param [in] hGraph - instance of graph to add the created node to.\n @param [in] dependencies - const pointer to the dependencies on the memset execution node.\n @param [in] numDependencies - number of the dependencies.\n @param [in] memsetParams - const pointer to the parameters for the memory set.\n @param [in] ctx - cotext related to current device.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipDrvGraphAddMemsetNode(
        phGraphNode: *mut hipGraphNode_t,
        hGraph: hipGraph_t,
        dependencies: *const hipGraphNode_t,
        numDependencies: usize,
        memsetParams: *const HIP_MEMSET_NODE_PARAMS,
        ctx: hipCtx_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Creates a memory free node and adds it to a graph\n\n @param [out] phGraphNode - Pointer to the graph node to create and add to the graph\n @param [in]  hGraph - Instance of the graph the node to be added\n @param [in]  dependencies - Const pointer to the node dependencies\n @param [in]  numDependencies - The number of dependencies\n @param [in]  dptr - Pointer to the memory to be freed\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipDrvGraphAddMemFreeNode(
        phGraphNode: *mut hipGraphNode_t,
        hGraph: hipGraph_t,
        dependencies: *const hipGraphNode_t,
        numDependencies: usize,
        dptr: hipDeviceptr_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets the parameters for a memcpy node in the given graphExec.\n\n @param [in] hGraphExec - instance of the executable graph with the node.\n @param [in] hNode - instance of the node to set parameters to.\n @param [in] copyParams - const pointer to the memcpy node params.\n @param [in] ctx - cotext related to current device.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipDrvGraphExecMemcpyNodeSetParams(
        hGraphExec: hipGraphExec_t,
        hNode: hipGraphNode_t,
        copyParams: *const HIP_MEMCPY3D,
        ctx: hipCtx_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Sets the parameters for a memset node in the given graphExec.\n\n @param [in] hGraphExec - instance of the executable graph with the node.\n @param [in] hNode - instance of the node to set parameters to.\n @param [in] memsetParams - pointer to the parameters.\n @param [in] ctx - cotext related to current device.\n @returns #hipSuccess, #hipErrorInvalidValue\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues."]
    pub fn hipDrvGraphExecMemsetNodeSetParams(
        hGraphExec: hipGraphExec_t,
        hNode: hipGraphNode_t,
        memsetParams: *const HIP_MEMSET_NODE_PARAMS,
        ctx: hipCtx_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Frees an address range reservation made via hipMemAddressReserve\n\n @param [in] devPtr - starting address of the range.\n @param [in] size - size of the range.\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows."]
    pub fn hipMemAddressFree(devPtr: *mut ::std::os::raw::c_void, size: usize) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Reserves an address range\n\n @param [out] ptr - starting address of the reserved range.\n @param [in] size - size of the reservation.\n @param [in] alignment - alignment of the address.\n @param [in] addr - requested starting address of the range.\n @param [in] flags - currently unused, must be zero.\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows."]
    pub fn hipMemAddressReserve(
        ptr: *mut *mut ::std::os::raw::c_void,
        size: usize,
        alignment: usize,
        addr: *mut ::std::os::raw::c_void,
        flags: ::std::os::raw::c_ulonglong,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Creates a memory allocation described by the properties and size\n\n @param [out] handle - value of the returned handle.\n @param [in] size - size of the allocation.\n @param [in] prop - properties of the allocation.\n @param [in] flags - currently unused, must be zero.\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows."]
    pub fn hipMemCreate(
        handle: *mut hipMemGenericAllocationHandle_t,
        size: usize,
        prop: *const hipMemAllocationProp,
        flags: ::std::os::raw::c_ulonglong,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Exports an allocation to a requested shareable handle type.\n\n @param [out] shareableHandle - value of the returned handle.\n @param [in] handle - handle to share.\n @param [in] handleType - type of the shareable handle.\n @param [in] flags - currently unused, must be zero.\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows."]
    pub fn hipMemExportToShareableHandle(
        shareableHandle: *mut ::std::os::raw::c_void,
        handle: hipMemGenericAllocationHandle_t,
        handleType: hipMemAllocationHandleType,
        flags: ::std::os::raw::c_ulonglong,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Get the access flags set for the given location and ptr.\n\n @param [out] flags - flags for this location.\n @param [in] location - target location.\n @param [in] ptr - address to check the access flags.\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows."]
    pub fn hipMemGetAccess(
        flags: *mut ::std::os::raw::c_ulonglong,
        location: *const hipMemLocation,
        ptr: *mut ::std::os::raw::c_void,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Calculates either the minimal or recommended granularity.\n\n @param [out] granularity - returned granularity.\n @param [in] prop - location properties.\n @param [in] option - determines which granularity to return.\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows.\n"]
    pub fn hipMemGetAllocationGranularity(
        granularity: *mut usize,
        prop: *const hipMemAllocationProp,
        option: hipMemAllocationGranularity_flags,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Retrieve the property structure of the given handle.\n\n @param [out] prop - properties of the given handle.\n @param [in] handle - handle to perform the query on.\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows."]
    pub fn hipMemGetAllocationPropertiesFromHandle(
        prop: *mut hipMemAllocationProp,
        handle: hipMemGenericAllocationHandle_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Imports an allocation from a requested shareable handle type.\n\n @param [out] handle - returned value.\n @param [in] osHandle - shareable handle representing the memory allocation.\n @param [in] shHandleType - handle type.\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows."]
    pub fn hipMemImportFromShareableHandle(
        handle: *mut hipMemGenericAllocationHandle_t,
        osHandle: *mut ::std::os::raw::c_void,
        shHandleType: hipMemAllocationHandleType,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Maps an allocation handle to a reserved virtual address range.\n\n @param [in] ptr - address where the memory will be mapped.\n @param [in] size - size of the mapping.\n @param [in] offset - offset into the memory, currently must be zero.\n @param [in] handle - memory allocation to be mapped.\n @param [in] flags - currently unused, must be zero.\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows."]
    pub fn hipMemMap(
        ptr: *mut ::std::os::raw::c_void,
        size: usize,
        offset: usize,
        handle: hipMemGenericAllocationHandle_t,
        flags: ::std::os::raw::c_ulonglong,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Maps or unmaps subregions of sparse HIP arrays and sparse HIP mipmapped arrays.\n\n @param [in] mapInfoList - list of hipArrayMapInfo.\n @param [in] count - number of hipArrayMapInfo in mapInfoList.\n @param [in] stream - stream identifier for the stream to use for map or unmap operations.\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n @warning This API is under development. Currently it is not supported on AMD\n          GPUs and returns #hipErrorNotSupported."]
    pub fn hipMemMapArrayAsync(
        mapInfoList: *mut hipArrayMapInfo,
        count: ::std::os::raw::c_uint,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Release a memory handle representing a memory allocation which was previously allocated through hipMemCreate.\n\n @param [in] handle - handle of the memory allocation.\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows."]
    pub fn hipMemRelease(handle: hipMemGenericAllocationHandle_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Returns the allocation handle of the backing memory allocation given the address.\n\n @param [out] handle - handle representing addr.\n @param [in] addr - address to look up.\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows."]
    pub fn hipMemRetainAllocationHandle(
        handle: *mut hipMemGenericAllocationHandle_t,
        addr: *mut ::std::os::raw::c_void,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Set the access flags for each location specified in desc for the given virtual address range.\n\n @param [in] ptr - starting address of the virtual address range.\n @param [in] size - size of the range.\n @param [in] desc - array of hipMemAccessDesc.\n @param [in] count - number of hipMemAccessDesc in desc.\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows."]
    pub fn hipMemSetAccess(
        ptr: *mut ::std::os::raw::c_void,
        size: usize,
        desc: *const hipMemAccessDesc,
        count: usize,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Unmap memory allocation of a given address range.\n\n @param [in] ptr - starting address of the range to unmap.\n @param [in] size - size of the virtual address range.\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorNotSupported\n @warning This API is marked as Beta. While this feature is complete, it can\n          change and might have outstanding issues.\n\n @note  This API is implemented on Linux and is under development on Microsoft Windows."]
    pub fn hipMemUnmap(ptr: *mut ::std::os::raw::c_void, size: usize) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Maps a graphics resource for access.\n\n @param [in] count - Number of resources to map.\n @param [in] resources - Pointer of resources to map.\n @param [in] stream - Stream for synchronization.\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorUnknown, #hipErrorInvalidResourceHandle\n"]
    pub fn hipGraphicsMapResources(
        count: ::std::os::raw::c_int,
        resources: *mut hipGraphicsResource_t,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Get an array through which to access a subresource of a mapped graphics resource.\n\n @param [out] array - Pointer of array through which a subresource of resource may be accessed.\n @param [in] resource - Mapped resource to access.\n @param [in] arrayIndex - Array index for the subresource to access.\n @param [in] mipLevel - Mipmap level for the subresource to access.\n\n @returns #hipSuccess, #hipErrorInvalidValue\n\n @note  In this API, the value of arrayIndex higher than zero is currently not supported.\n"]
    pub fn hipGraphicsSubResourceGetMappedArray(
        array: *mut hipArray_t,
        resource: hipGraphicsResource_t,
        arrayIndex: ::std::os::raw::c_uint,
        mipLevel: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Gets device accessible address of a graphics resource.\n\n @param [out] devPtr - Pointer of device through which graphic resource may be accessed.\n @param [out] size - Size of the buffer accessible from devPtr.\n @param [in] resource - Mapped resource to access.\n\n @returns #hipSuccess, #hipErrorInvalidValue\n"]
    pub fn hipGraphicsResourceGetMappedPointer(
        devPtr: *mut *mut ::std::os::raw::c_void,
        size: *mut usize,
        resource: hipGraphicsResource_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Unmaps graphics resources.\n\n @param [in] count - Number of resources to unmap.\n @param [in] resources - Pointer of resources to unmap.\n @param [in] stream - Stream for synchronization.\n\n @returns #hipSuccess, #hipErrorInvalidValue, #hipErrorUnknown, #hipErrorContextIsDestroyed\n"]
    pub fn hipGraphicsUnmapResources(
        count: ::std::os::raw::c_int,
        resources: *mut hipGraphicsResource_t,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Unregisters a graphics resource.\n\n @param [in] resource - Graphics resources to unregister.\n\n @returns #hipSuccess\n"]
    pub fn hipGraphicsUnregisterResource(resource: hipGraphicsResource_t) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Create a surface object.\n\n @param [out] pSurfObject  Pointer of surface object to be created.\n @param [in] pResDesc  Pointer of suface object descriptor.\n\n @returns #hipSuccess, #hipErrorInvalidValue\n"]
    pub fn hipCreateSurfaceObject(
        pSurfObject: *mut hipSurfaceObject_t,
        pResDesc: *const hipResourceDesc,
    ) -> hipError_t;
}
extern "C" {
    #[doc = " @brief Destroy a surface object.\n\n @param [in] surfaceObject  Surface object to be destroyed.\n\n @returns #hipSuccess, #hipErrorInvalidValue"]
    pub fn hipDestroySurfaceObject(surfaceObject: hipSurfaceObject_t) -> hipError_t;
}
extern "C" {
    pub fn hipMemcpy_spt(
        dst: *mut ::std::os::raw::c_void,
        src: *const ::std::os::raw::c_void,
        sizeBytes: usize,
        kind: hipMemcpyKind,
    ) -> hipError_t;
}
extern "C" {
    pub fn hipMemcpyToSymbol_spt(
        symbol: *const ::std::os::raw::c_void,
        src: *const ::std::os::raw::c_void,
        sizeBytes: usize,
        offset: usize,
        kind: hipMemcpyKind,
    ) -> hipError_t;
}
extern "C" {
    pub fn hipMemcpyFromSymbol_spt(
        dst: *mut ::std::os::raw::c_void,
        symbol: *const ::std::os::raw::c_void,
        sizeBytes: usize,
        offset: usize,
        kind: hipMemcpyKind,
    ) -> hipError_t;
}
extern "C" {
    pub fn hipMemcpy2D_spt(
        dst: *mut ::std::os::raw::c_void,
        dpitch: usize,
        src: *const ::std::os::raw::c_void,
        spitch: usize,
        width: usize,
        height: usize,
        kind: hipMemcpyKind,
    ) -> hipError_t;
}
extern "C" {
    pub fn hipMemcpy2DFromArray_spt(
        dst: *mut ::std::os::raw::c_void,
        dpitch: usize,
        src: hipArray_const_t,
        wOffset: usize,
        hOffset: usize,
        width: usize,
        height: usize,
        kind: hipMemcpyKind,
    ) -> hipError_t;
}
extern "C" {
    pub fn hipMemcpy3D_spt(p: *const hipMemcpy3DParms) -> hipError_t;
}
extern "C" {
    pub fn hipMemset_spt(
        dst: *mut ::std::os::raw::c_void,
        value: ::std::os::raw::c_int,
        sizeBytes: usize,
    ) -> hipError_t;
}
extern "C" {
    pub fn hipMemsetAsync_spt(
        dst: *mut ::std::os::raw::c_void,
        value: ::std::os::raw::c_int,
        sizeBytes: usize,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    pub fn hipMemset2D_spt(
        dst: *mut ::std::os::raw::c_void,
        pitch: usize,
        value: ::std::os::raw::c_int,
        width: usize,
        height: usize,
    ) -> hipError_t;
}
extern "C" {
    pub fn hipMemset2DAsync_spt(
        dst: *mut ::std::os::raw::c_void,
        pitch: usize,
        value: ::std::os::raw::c_int,
        width: usize,
        height: usize,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    pub fn hipMemset3DAsync_spt(
        pitchedDevPtr: hipPitchedPtr,
        value: ::std::os::raw::c_int,
        extent: hipExtent,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    pub fn hipMemset3D_spt(
        pitchedDevPtr: hipPitchedPtr,
        value: ::std::os::raw::c_int,
        extent: hipExtent,
    ) -> hipError_t;
}
extern "C" {
    pub fn hipMemcpyAsync_spt(
        dst: *mut ::std::os::raw::c_void,
        src: *const ::std::os::raw::c_void,
        sizeBytes: usize,
        kind: hipMemcpyKind,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    pub fn hipMemcpy3DAsync_spt(p: *const hipMemcpy3DParms, stream: hipStream_t) -> hipError_t;
}
extern "C" {
    pub fn hipMemcpy2DAsync_spt(
        dst: *mut ::std::os::raw::c_void,
        dpitch: usize,
        src: *const ::std::os::raw::c_void,
        spitch: usize,
        width: usize,
        height: usize,
        kind: hipMemcpyKind,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    pub fn hipMemcpyFromSymbolAsync_spt(
        dst: *mut ::std::os::raw::c_void,
        symbol: *const ::std::os::raw::c_void,
        sizeBytes: usize,
        offset: usize,
        kind: hipMemcpyKind,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    pub fn hipMemcpyToSymbolAsync_spt(
        symbol: *const ::std::os::raw::c_void,
        src: *const ::std::os::raw::c_void,
        sizeBytes: usize,
        offset: usize,
        kind: hipMemcpyKind,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    pub fn hipMemcpyFromArray_spt(
        dst: *mut ::std::os::raw::c_void,
        src: hipArray_const_t,
        wOffsetSrc: usize,
        hOffset: usize,
        count: usize,
        kind: hipMemcpyKind,
    ) -> hipError_t;
}
extern "C" {
    pub fn hipMemcpy2DToArray_spt(
        dst: hipArray_t,
        wOffset: usize,
        hOffset: usize,
        src: *const ::std::os::raw::c_void,
        spitch: usize,
        width: usize,
        height: usize,
        kind: hipMemcpyKind,
    ) -> hipError_t;
}
extern "C" {
    pub fn hipMemcpy2DFromArrayAsync_spt(
        dst: *mut ::std::os::raw::c_void,
        dpitch: usize,
        src: hipArray_const_t,
        wOffsetSrc: usize,
        hOffsetSrc: usize,
        width: usize,
        height: usize,
        kind: hipMemcpyKind,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    pub fn hipMemcpy2DToArrayAsync_spt(
        dst: hipArray_t,
        wOffset: usize,
        hOffset: usize,
        src: *const ::std::os::raw::c_void,
        spitch: usize,
        width: usize,
        height: usize,
        kind: hipMemcpyKind,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    pub fn hipStreamQuery_spt(stream: hipStream_t) -> hipError_t;
}
extern "C" {
    pub fn hipStreamSynchronize_spt(stream: hipStream_t) -> hipError_t;
}
extern "C" {
    pub fn hipStreamGetPriority_spt(
        stream: hipStream_t,
        priority: *mut ::std::os::raw::c_int,
    ) -> hipError_t;
}
extern "C" {
    pub fn hipStreamWaitEvent_spt(
        stream: hipStream_t,
        event: hipEvent_t,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    pub fn hipStreamGetFlags_spt(
        stream: hipStream_t,
        flags: *mut ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    pub fn hipStreamAddCallback_spt(
        stream: hipStream_t,
        callback: hipStreamCallback_t,
        userData: *mut ::std::os::raw::c_void,
        flags: ::std::os::raw::c_uint,
    ) -> hipError_t;
}
extern "C" {
    pub fn hipEventRecord_spt(event: hipEvent_t, stream: hipStream_t) -> hipError_t;
}
extern "C" {
    pub fn hipLaunchCooperativeKernel_spt(
        f: *const ::std::os::raw::c_void,
        gridDim: dim3,
        blockDim: dim3,
        kernelParams: *mut *mut ::std::os::raw::c_void,
        sharedMemBytes: u32,
        hStream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    pub fn hipLaunchKernel_spt(
        function_address: *const ::std::os::raw::c_void,
        numBlocks: dim3,
        dimBlocks: dim3,
        args: *mut *mut ::std::os::raw::c_void,
        sharedMemBytes: usize,
        stream: hipStream_t,
    ) -> hipError_t;
}
extern "C" {
    pub fn hipGraphLaunch_spt(graphExec: hipGraphExec_t, stream: hipStream_t) -> hipError_t;
}
extern "C" {
    pub fn hipStreamBeginCapture_spt(stream: hipStream_t, mode: hipStreamCaptureMode)
        -> hipError_t;
}
extern "C" {
    pub fn hipStreamEndCapture_spt(stream: hipStream_t, pGraph: *mut hipGraph_t) -> hipError_t;
}
extern "C" {
    pub fn hipStreamIsCapturing_spt(
        stream: hipStream_t,
        pCaptureStatus: *mut hipStreamCaptureStatus,
    ) -> hipError_t;
}
extern "C" {
    pub fn hipStreamGetCaptureInfo_spt(
        stream: hipStream_t,
        pCaptureStatus: *mut hipStreamCaptureStatus,
        pId: *mut ::std::os::raw::c_ulonglong,
    ) -> hipError_t;
}
extern "C" {
    pub fn hipStreamGetCaptureInfo_v2_spt(
        stream: hipStream_t,
        captureStatus_out: *mut hipStreamCaptureStatus,
        id_out: *mut ::std::os::raw::c_ulonglong,
        graph_out: *mut hipGraph_t,
        dependencies_out: *mut *const hipGraphNode_t,
        numDependencies_out: *mut usize,
    ) -> hipError_t;
}
extern "C" {
    pub fn hipLaunchHostFunc_spt(
        stream: hipStream_t,
        fn_: hipHostFn_t,
        userData: *mut ::std::os::raw::c_void,
    ) -> hipError_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __locale_data {
    pub _address: u8,
}
