// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotevents

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateDetectorModel = "CreateDetectorModel"

// CreateDetectorModelRequest generates a "aws/request.Request" representing the
// client's request for the CreateDetectorModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDetectorModel for more information on using the CreateDetectorModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDetectorModelRequest method.
//    req, resp := client.CreateDetectorModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/CreateDetectorModel
func (c *IoTEvents) CreateDetectorModelRequest(input *CreateDetectorModelInput) (req *request.Request, output *CreateDetectorModelOutput) {
	op := &request.Operation{
		Name:       opCreateDetectorModel,
		HTTPMethod: "POST",
		HTTPPath:   "/detector-models",
	}

	if input == nil {
		input = &CreateDetectorModelInput{}
	}

	output = &CreateDetectorModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDetectorModel API operation for AWS IoT Events.
//
// Creates a detector model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Events's
// API operation CreateDetectorModel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was invalid.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource is in use.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The resource already exists.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request could not be completed due to throttling.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/CreateDetectorModel
func (c *IoTEvents) CreateDetectorModel(input *CreateDetectorModelInput) (*CreateDetectorModelOutput, error) {
	req, out := c.CreateDetectorModelRequest(input)
	return out, req.Send()
}

// CreateDetectorModelWithContext is the same as CreateDetectorModel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDetectorModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTEvents) CreateDetectorModelWithContext(ctx aws.Context, input *CreateDetectorModelInput, opts ...request.Option) (*CreateDetectorModelOutput, error) {
	req, out := c.CreateDetectorModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInput = "CreateInput"

// CreateInputRequest generates a "aws/request.Request" representing the
// client's request for the CreateInput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInput for more information on using the CreateInput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateInputRequest method.
//    req, resp := client.CreateInputRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/CreateInput
func (c *IoTEvents) CreateInputRequest(input *CreateInputInput) (req *request.Request, output *CreateInputOutput) {
	op := &request.Operation{
		Name:       opCreateInput,
		HTTPMethod: "POST",
		HTTPPath:   "/inputs",
	}

	if input == nil {
		input = &CreateInputInput{}
	}

	output = &CreateInputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInput API operation for AWS IoT Events.
//
// Creates an input.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Events's
// API operation CreateInput for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was invalid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request could not be completed due to throttling.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is currently unavailable.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The resource already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/CreateInput
func (c *IoTEvents) CreateInput(input *CreateInputInput) (*CreateInputOutput, error) {
	req, out := c.CreateInputRequest(input)
	return out, req.Send()
}

// CreateInputWithContext is the same as CreateInput with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTEvents) CreateInputWithContext(ctx aws.Context, input *CreateInputInput, opts ...request.Option) (*CreateInputOutput, error) {
	req, out := c.CreateInputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDetectorModel = "DeleteDetectorModel"

// DeleteDetectorModelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDetectorModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDetectorModel for more information on using the DeleteDetectorModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDetectorModelRequest method.
//    req, resp := client.DeleteDetectorModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DeleteDetectorModel
func (c *IoTEvents) DeleteDetectorModelRequest(input *DeleteDetectorModelInput) (req *request.Request, output *DeleteDetectorModelOutput) {
	op := &request.Operation{
		Name:       opDeleteDetectorModel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/detector-models/{detectorModelName}",
	}

	if input == nil {
		input = &DeleteDetectorModelInput{}
	}

	output = &DeleteDetectorModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDetectorModel API operation for AWS IoT Events.
//
// Deletes a detector model. Any active instances of the detector model are
// also deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Events's
// API operation DeleteDetectorModel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was invalid.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource is in use.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource was not found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request could not be completed due to throttling.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DeleteDetectorModel
func (c *IoTEvents) DeleteDetectorModel(input *DeleteDetectorModelInput) (*DeleteDetectorModelOutput, error) {
	req, out := c.DeleteDetectorModelRequest(input)
	return out, req.Send()
}

// DeleteDetectorModelWithContext is the same as DeleteDetectorModel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDetectorModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTEvents) DeleteDetectorModelWithContext(ctx aws.Context, input *DeleteDetectorModelInput, opts ...request.Option) (*DeleteDetectorModelOutput, error) {
	req, out := c.DeleteDetectorModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInput = "DeleteInput"

// DeleteInputRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInput for more information on using the DeleteInput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteInputRequest method.
//    req, resp := client.DeleteInputRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DeleteInput
func (c *IoTEvents) DeleteInputRequest(input *DeleteInputInput) (req *request.Request, output *DeleteInputOutput) {
	op := &request.Operation{
		Name:       opDeleteInput,
		HTTPMethod: "DELETE",
		HTTPPath:   "/inputs/{inputName}",
	}

	if input == nil {
		input = &DeleteInputInput{}
	}

	output = &DeleteInputOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteInput API operation for AWS IoT Events.
//
// Deletes an input.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Events's
// API operation DeleteInput for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was invalid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource was not found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request could not be completed due to throttling.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is currently unavailable.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DeleteInput
func (c *IoTEvents) DeleteInput(input *DeleteInputInput) (*DeleteInputOutput, error) {
	req, out := c.DeleteInputRequest(input)
	return out, req.Send()
}

// DeleteInputWithContext is the same as DeleteInput with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTEvents) DeleteInputWithContext(ctx aws.Context, input *DeleteInputInput, opts ...request.Option) (*DeleteInputOutput, error) {
	req, out := c.DeleteInputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDetectorModel = "DescribeDetectorModel"

// DescribeDetectorModelRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDetectorModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDetectorModel for more information on using the DescribeDetectorModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDetectorModelRequest method.
//    req, resp := client.DescribeDetectorModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DescribeDetectorModel
func (c *IoTEvents) DescribeDetectorModelRequest(input *DescribeDetectorModelInput) (req *request.Request, output *DescribeDetectorModelOutput) {
	op := &request.Operation{
		Name:       opDescribeDetectorModel,
		HTTPMethod: "GET",
		HTTPPath:   "/detector-models/{detectorModelName}",
	}

	if input == nil {
		input = &DescribeDetectorModelInput{}
	}

	output = &DescribeDetectorModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDetectorModel API operation for AWS IoT Events.
//
// Describes a detector model. If the version parameter is not specified, information
// about the latest version is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Events's
// API operation DescribeDetectorModel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was invalid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource was not found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request could not be completed due to throttling.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DescribeDetectorModel
func (c *IoTEvents) DescribeDetectorModel(input *DescribeDetectorModelInput) (*DescribeDetectorModelOutput, error) {
	req, out := c.DescribeDetectorModelRequest(input)
	return out, req.Send()
}

// DescribeDetectorModelWithContext is the same as DescribeDetectorModel with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDetectorModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTEvents) DescribeDetectorModelWithContext(ctx aws.Context, input *DescribeDetectorModelInput, opts ...request.Option) (*DescribeDetectorModelOutput, error) {
	req, out := c.DescribeDetectorModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInput = "DescribeInput"

// DescribeInputRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInput for more information on using the DescribeInput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInputRequest method.
//    req, resp := client.DescribeInputRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DescribeInput
func (c *IoTEvents) DescribeInputRequest(input *DescribeInputInput) (req *request.Request, output *DescribeInputOutput) {
	op := &request.Operation{
		Name:       opDescribeInput,
		HTTPMethod: "GET",
		HTTPPath:   "/inputs/{inputName}",
	}

	if input == nil {
		input = &DescribeInputInput{}
	}

	output = &DescribeInputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInput API operation for AWS IoT Events.
//
// Describes an input.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Events's
// API operation DescribeInput for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was invalid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource was not found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request could not be completed due to throttling.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DescribeInput
func (c *IoTEvents) DescribeInput(input *DescribeInputInput) (*DescribeInputOutput, error) {
	req, out := c.DescribeInputRequest(input)
	return out, req.Send()
}

// DescribeInputWithContext is the same as DescribeInput with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTEvents) DescribeInputWithContext(ctx aws.Context, input *DescribeInputInput, opts ...request.Option) (*DescribeInputOutput, error) {
	req, out := c.DescribeInputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLoggingOptions = "DescribeLoggingOptions"

// DescribeLoggingOptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLoggingOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLoggingOptions for more information on using the DescribeLoggingOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLoggingOptionsRequest method.
//    req, resp := client.DescribeLoggingOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DescribeLoggingOptions
func (c *IoTEvents) DescribeLoggingOptionsRequest(input *DescribeLoggingOptionsInput) (req *request.Request, output *DescribeLoggingOptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeLoggingOptions,
		HTTPMethod: "GET",
		HTTPPath:   "/logging",
	}

	if input == nil {
		input = &DescribeLoggingOptionsInput{}
	}

	output = &DescribeLoggingOptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLoggingOptions API operation for AWS IoT Events.
//
// Retrieves the current settings of the AWS IoT Events logging options.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Events's
// API operation DescribeLoggingOptions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was invalid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request could not be completed due to throttling.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource was not found.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is currently unavailable.
//
//   * ErrCodeUnsupportedOperationException "UnsupportedOperationException"
//   The requested operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/DescribeLoggingOptions
func (c *IoTEvents) DescribeLoggingOptions(input *DescribeLoggingOptionsInput) (*DescribeLoggingOptionsOutput, error) {
	req, out := c.DescribeLoggingOptionsRequest(input)
	return out, req.Send()
}

// DescribeLoggingOptionsWithContext is the same as DescribeLoggingOptions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLoggingOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTEvents) DescribeLoggingOptionsWithContext(ctx aws.Context, input *DescribeLoggingOptionsInput, opts ...request.Option) (*DescribeLoggingOptionsOutput, error) {
	req, out := c.DescribeLoggingOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDetectorModelVersions = "ListDetectorModelVersions"

// ListDetectorModelVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListDetectorModelVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDetectorModelVersions for more information on using the ListDetectorModelVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDetectorModelVersionsRequest method.
//    req, resp := client.ListDetectorModelVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListDetectorModelVersions
func (c *IoTEvents) ListDetectorModelVersionsRequest(input *ListDetectorModelVersionsInput) (req *request.Request, output *ListDetectorModelVersionsOutput) {
	op := &request.Operation{
		Name:       opListDetectorModelVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/detector-models/{detectorModelName}/versions",
	}

	if input == nil {
		input = &ListDetectorModelVersionsInput{}
	}

	output = &ListDetectorModelVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDetectorModelVersions API operation for AWS IoT Events.
//
// Lists all the versions of a detector model. Only the metadata associated
// with each detector model version is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Events's
// API operation ListDetectorModelVersions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was invalid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource was not found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request could not be completed due to throttling.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListDetectorModelVersions
func (c *IoTEvents) ListDetectorModelVersions(input *ListDetectorModelVersionsInput) (*ListDetectorModelVersionsOutput, error) {
	req, out := c.ListDetectorModelVersionsRequest(input)
	return out, req.Send()
}

// ListDetectorModelVersionsWithContext is the same as ListDetectorModelVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListDetectorModelVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTEvents) ListDetectorModelVersionsWithContext(ctx aws.Context, input *ListDetectorModelVersionsInput, opts ...request.Option) (*ListDetectorModelVersionsOutput, error) {
	req, out := c.ListDetectorModelVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDetectorModels = "ListDetectorModels"

// ListDetectorModelsRequest generates a "aws/request.Request" representing the
// client's request for the ListDetectorModels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDetectorModels for more information on using the ListDetectorModels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDetectorModelsRequest method.
//    req, resp := client.ListDetectorModelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListDetectorModels
func (c *IoTEvents) ListDetectorModelsRequest(input *ListDetectorModelsInput) (req *request.Request, output *ListDetectorModelsOutput) {
	op := &request.Operation{
		Name:       opListDetectorModels,
		HTTPMethod: "GET",
		HTTPPath:   "/detector-models",
	}

	if input == nil {
		input = &ListDetectorModelsInput{}
	}

	output = &ListDetectorModelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDetectorModels API operation for AWS IoT Events.
//
// Lists the detector models you have created. Only the metadata associated
// with each detector model is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Events's
// API operation ListDetectorModels for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was invalid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request could not be completed due to throttling.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListDetectorModels
func (c *IoTEvents) ListDetectorModels(input *ListDetectorModelsInput) (*ListDetectorModelsOutput, error) {
	req, out := c.ListDetectorModelsRequest(input)
	return out, req.Send()
}

// ListDetectorModelsWithContext is the same as ListDetectorModels with the addition of
// the ability to pass a context and additional request options.
//
// See ListDetectorModels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTEvents) ListDetectorModelsWithContext(ctx aws.Context, input *ListDetectorModelsInput, opts ...request.Option) (*ListDetectorModelsOutput, error) {
	req, out := c.ListDetectorModelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListInputs = "ListInputs"

// ListInputsRequest generates a "aws/request.Request" representing the
// client's request for the ListInputs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInputs for more information on using the ListInputs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListInputsRequest method.
//    req, resp := client.ListInputsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListInputs
func (c *IoTEvents) ListInputsRequest(input *ListInputsInput) (req *request.Request, output *ListInputsOutput) {
	op := &request.Operation{
		Name:       opListInputs,
		HTTPMethod: "GET",
		HTTPPath:   "/inputs",
	}

	if input == nil {
		input = &ListInputsInput{}
	}

	output = &ListInputsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInputs API operation for AWS IoT Events.
//
// Lists the inputs you have created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Events's
// API operation ListInputs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was invalid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request could not be completed due to throttling.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListInputs
func (c *IoTEvents) ListInputs(input *ListInputsInput) (*ListInputsOutput, error) {
	req, out := c.ListInputsRequest(input)
	return out, req.Send()
}

// ListInputsWithContext is the same as ListInputs with the addition of
// the ability to pass a context and additional request options.
//
// See ListInputs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTEvents) ListInputsWithContext(ctx aws.Context, input *ListInputsInput, opts ...request.Option) (*ListInputsOutput, error) {
	req, out := c.ListInputsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListTagsForResource
func (c *IoTEvents) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS IoT Events.
//
// Lists the tags (metadata) you have assigned to the resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Events's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was invalid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource was not found.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource is in use.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request could not be completed due to throttling.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/ListTagsForResource
func (c *IoTEvents) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTEvents) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutLoggingOptions = "PutLoggingOptions"

// PutLoggingOptionsRequest generates a "aws/request.Request" representing the
// client's request for the PutLoggingOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutLoggingOptions for more information on using the PutLoggingOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutLoggingOptionsRequest method.
//    req, resp := client.PutLoggingOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/PutLoggingOptions
func (c *IoTEvents) PutLoggingOptionsRequest(input *PutLoggingOptionsInput) (req *request.Request, output *PutLoggingOptionsOutput) {
	op := &request.Operation{
		Name:       opPutLoggingOptions,
		HTTPMethod: "PUT",
		HTTPPath:   "/logging",
	}

	if input == nil {
		input = &PutLoggingOptionsInput{}
	}

	output = &PutLoggingOptionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutLoggingOptions API operation for AWS IoT Events.
//
// Sets or updates the AWS IoT Events logging options.
//
// Note that if you update the value of any loggingOptions field, it takes up
// to one minute for the change to take effect. Also, if you change the policy
// attached to the role you specified in the roleArn field (for example, to
// correct an invalid policy) it takes up to five minutes for that change to
// take effect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Events's
// API operation PutLoggingOptions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was invalid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request could not be completed due to throttling.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is currently unavailable.
//
//   * ErrCodeUnsupportedOperationException "UnsupportedOperationException"
//   The requested operation is not supported.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/PutLoggingOptions
func (c *IoTEvents) PutLoggingOptions(input *PutLoggingOptionsInput) (*PutLoggingOptionsOutput, error) {
	req, out := c.PutLoggingOptionsRequest(input)
	return out, req.Send()
}

// PutLoggingOptionsWithContext is the same as PutLoggingOptions with the addition of
// the ability to pass a context and additional request options.
//
// See PutLoggingOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTEvents) PutLoggingOptionsWithContext(ctx aws.Context, input *PutLoggingOptionsInput, opts ...request.Option) (*PutLoggingOptionsOutput, error) {
	req, out := c.PutLoggingOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/TagResource
func (c *IoTEvents) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS IoT Events.
//
// Add to or modifies the tags of the given resource. Tags are metadata which
// can be used to manage a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Events's
// API operation TagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was invalid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource was not found.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource is in use.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request could not be completed due to throttling.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/TagResource
func (c *IoTEvents) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTEvents) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/UntagResource
func (c *IoTEvents) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS IoT Events.
//
// Removes the given tags (metadata) from the resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Events's
// API operation UntagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was invalid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource was not found.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource is in use.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request could not be completed due to throttling.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/UntagResource
func (c *IoTEvents) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTEvents) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDetectorModel = "UpdateDetectorModel"

// UpdateDetectorModelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDetectorModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDetectorModel for more information on using the UpdateDetectorModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDetectorModelRequest method.
//    req, resp := client.UpdateDetectorModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/UpdateDetectorModel
func (c *IoTEvents) UpdateDetectorModelRequest(input *UpdateDetectorModelInput) (req *request.Request, output *UpdateDetectorModelOutput) {
	op := &request.Operation{
		Name:       opUpdateDetectorModel,
		HTTPMethod: "POST",
		HTTPPath:   "/detector-models/{detectorModelName}",
	}

	if input == nil {
		input = &UpdateDetectorModelInput{}
	}

	output = &UpdateDetectorModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDetectorModel API operation for AWS IoT Events.
//
// Updates a detector model. Detectors (instances) spawned by the previous version
// will be deleted and re-created as new inputs arrive.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Events's
// API operation UpdateDetectorModel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was invalid.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource is in use.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource was not found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request could not be completed due to throttling.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/UpdateDetectorModel
func (c *IoTEvents) UpdateDetectorModel(input *UpdateDetectorModelInput) (*UpdateDetectorModelOutput, error) {
	req, out := c.UpdateDetectorModelRequest(input)
	return out, req.Send()
}

// UpdateDetectorModelWithContext is the same as UpdateDetectorModel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDetectorModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTEvents) UpdateDetectorModelWithContext(ctx aws.Context, input *UpdateDetectorModelInput, opts ...request.Option) (*UpdateDetectorModelOutput, error) {
	req, out := c.UpdateDetectorModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateInput = "UpdateInput"

// UpdateInputRequest generates a "aws/request.Request" representing the
// client's request for the UpdateInput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateInput for more information on using the UpdateInput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateInputRequest method.
//    req, resp := client.UpdateInputRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/UpdateInput
func (c *IoTEvents) UpdateInputRequest(input *UpdateInputInput) (req *request.Request, output *UpdateInputOutput) {
	op := &request.Operation{
		Name:       opUpdateInput,
		HTTPMethod: "PUT",
		HTTPPath:   "/inputs/{inputName}",
	}

	if input == nil {
		input = &UpdateInputInput{}
	}

	output = &UpdateInputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateInput API operation for AWS IoT Events.
//
// Updates an input.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Events's
// API operation UpdateInput for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request was invalid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request could not be completed due to throttling.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource was not found.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is currently unavailable.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/UpdateInput
func (c *IoTEvents) UpdateInput(input *UpdateInputInput) (*UpdateInputOutput, error) {
	req, out := c.UpdateInputRequest(input)
	return out, req.Send()
}

// UpdateInputWithContext is the same as UpdateInput with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateInput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTEvents) UpdateInputWithContext(ctx aws.Context, input *UpdateInputInput, opts ...request.Option) (*UpdateInputOutput, error) {
	req, out := c.UpdateInputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An action to be performed when the condition is TRUE.
type Action struct {
	_ struct{} `type:"structure"`

	// Information needed to clear the timer.
	ClearTimer *ClearTimerAction `locationName:"clearTimer" type:"structure"`

	// Publishes an MQTT message with the given topic to the AWS IoT Message Broker.
	IotTopicPublish *IotTopicPublishAction `locationName:"iotTopicPublish" type:"structure"`

	// Information needed to reset the timer.
	ResetTimer *ResetTimerAction `locationName:"resetTimer" type:"structure"`

	// Information needed to set the timer.
	SetTimer *SetTimerAction `locationName:"setTimer" type:"structure"`

	// Sets a variable to a specified value.
	SetVariable *SetVariableAction `locationName:"setVariable" type:"structure"`

	// Sends an Amazon SNS message.
	Sns *SNSTopicPublishAction `locationName:"sns" type:"structure"`
}

// String returns the string representation
func (s Action) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Action) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Action) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Action"}
	if s.ClearTimer != nil {
		if err := s.ClearTimer.Validate(); err != nil {
			invalidParams.AddNested("ClearTimer", err.(request.ErrInvalidParams))
		}
	}
	if s.IotTopicPublish != nil {
		if err := s.IotTopicPublish.Validate(); err != nil {
			invalidParams.AddNested("IotTopicPublish", err.(request.ErrInvalidParams))
		}
	}
	if s.ResetTimer != nil {
		if err := s.ResetTimer.Validate(); err != nil {
			invalidParams.AddNested("ResetTimer", err.(request.ErrInvalidParams))
		}
	}
	if s.SetTimer != nil {
		if err := s.SetTimer.Validate(); err != nil {
			invalidParams.AddNested("SetTimer", err.(request.ErrInvalidParams))
		}
	}
	if s.SetVariable != nil {
		if err := s.SetVariable.Validate(); err != nil {
			invalidParams.AddNested("SetVariable", err.(request.ErrInvalidParams))
		}
	}
	if s.Sns != nil {
		if err := s.Sns.Validate(); err != nil {
			invalidParams.AddNested("Sns", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClearTimer sets the ClearTimer field's value.
func (s *Action) SetClearTimer(v *ClearTimerAction) *Action {
	s.ClearTimer = v
	return s
}

// SetIotTopicPublish sets the IotTopicPublish field's value.
func (s *Action) SetIotTopicPublish(v *IotTopicPublishAction) *Action {
	s.IotTopicPublish = v
	return s
}

// SetResetTimer sets the ResetTimer field's value.
func (s *Action) SetResetTimer(v *ResetTimerAction) *Action {
	s.ResetTimer = v
	return s
}

// SetSetTimer sets the SetTimer field's value.
func (s *Action) SetSetTimer(v *SetTimerAction) *Action {
	s.SetTimer = v
	return s
}

// SetSetVariable sets the SetVariable field's value.
func (s *Action) SetSetVariable(v *SetVariableAction) *Action {
	s.SetVariable = v
	return s
}

// SetSns sets the Sns field's value.
func (s *Action) SetSns(v *SNSTopicPublishAction) *Action {
	s.Sns = v
	return s
}

// The attributes from the JSON payload that are made available by the input.
// Inputs are derived from messages sent to the AWS IoT Events system using
// BatchPutMessage. Each such message contains a JSON payload, and those attributes
// (and their paired values) specified here are available for use in the condition
// expressions used by detectors.
type Attribute struct {
	_ struct{} `type:"structure"`

	// An expression that specifies an attribute-value pair in a JSON structure.
	// Use this to specify an attribute from the JSON payload that is made available
	// by the input. Inputs are derived from messages sent to the AWS IoT Events
	// system (BatchPutMessage). Each such message contains a JSON payload, and
	// the attribute (and its paired value) specified here are available for use
	// in the condition expressions used by detectors.
	//
	// Syntax: <field-name>.<field-name>...
	//
	// JsonPath is a required field
	JsonPath *string `locationName:"jsonPath" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Attribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Attribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Attribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Attribute"}
	if s.JsonPath == nil {
		invalidParams.Add(request.NewErrParamRequired("JsonPath"))
	}
	if s.JsonPath != nil && len(*s.JsonPath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JsonPath", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJsonPath sets the JsonPath field's value.
func (s *Attribute) SetJsonPath(v string) *Attribute {
	s.JsonPath = &v
	return s
}

// Information needed to clear the timer.
type ClearTimerAction struct {
	_ struct{} `type:"structure"`

	// The name of the timer to clear.
	//
	// TimerName is a required field
	TimerName *string `locationName:"timerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ClearTimerAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClearTimerAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ClearTimerAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ClearTimerAction"}
	if s.TimerName == nil {
		invalidParams.Add(request.NewErrParamRequired("TimerName"))
	}
	if s.TimerName != nil && len(*s.TimerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TimerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTimerName sets the TimerName field's value.
func (s *ClearTimerAction) SetTimerName(v string) *ClearTimerAction {
	s.TimerName = &v
	return s
}

type CreateDetectorModelInput struct {
	_ struct{} `type:"structure"`

	// Information that defines how the detectors operate.
	//
	// DetectorModelDefinition is a required field
	DetectorModelDefinition *DetectorModelDefinition `locationName:"detectorModelDefinition" type:"structure" required:"true"`

	// A brief description of the detector model.
	DetectorModelDescription *string `locationName:"detectorModelDescription" type:"string"`

	// The name of the detector model.
	//
	// DetectorModelName is a required field
	DetectorModelName *string `locationName:"detectorModelName" min:"1" type:"string" required:"true"`

	// The input attribute key used to identify a device or system in order to create
	// a detector (an instance of the detector model) and then to route each input
	// received to the appropriate detector (instance). This parameter uses a JSON-path
	// expression to specify the attribute-value pair in the message payload of
	// each input that is used to identify the device associated with the input.
	Key *string `locationName:"key" min:"1" type:"string"`

	// The ARN of the role that grants permission to AWS IoT Events to perform its
	// operations.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"1" type:"string" required:"true"`

	// Metadata which can be used to manage the detector model.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateDetectorModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDetectorModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDetectorModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDetectorModelInput"}
	if s.DetectorModelDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorModelDefinition"))
	}
	if s.DetectorModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorModelName"))
	}
	if s.DetectorModelName != nil && len(*s.DetectorModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorModelName", 1))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.DetectorModelDefinition != nil {
		if err := s.DetectorModelDefinition.Validate(); err != nil {
			invalidParams.AddNested("DetectorModelDefinition", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorModelDefinition sets the DetectorModelDefinition field's value.
func (s *CreateDetectorModelInput) SetDetectorModelDefinition(v *DetectorModelDefinition) *CreateDetectorModelInput {
	s.DetectorModelDefinition = v
	return s
}

// SetDetectorModelDescription sets the DetectorModelDescription field's value.
func (s *CreateDetectorModelInput) SetDetectorModelDescription(v string) *CreateDetectorModelInput {
	s.DetectorModelDescription = &v
	return s
}

// SetDetectorModelName sets the DetectorModelName field's value.
func (s *CreateDetectorModelInput) SetDetectorModelName(v string) *CreateDetectorModelInput {
	s.DetectorModelName = &v
	return s
}

// SetKey sets the Key field's value.
func (s *CreateDetectorModelInput) SetKey(v string) *CreateDetectorModelInput {
	s.Key = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateDetectorModelInput) SetRoleArn(v string) *CreateDetectorModelInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDetectorModelInput) SetTags(v []*Tag) *CreateDetectorModelInput {
	s.Tags = v
	return s
}

type CreateDetectorModelOutput struct {
	_ struct{} `type:"structure"`

	// Information about how the detector model is configured.
	DetectorModelConfiguration *DetectorModelConfiguration `locationName:"detectorModelConfiguration" type:"structure"`
}

// String returns the string representation
func (s CreateDetectorModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDetectorModelOutput) GoString() string {
	return s.String()
}

// SetDetectorModelConfiguration sets the DetectorModelConfiguration field's value.
func (s *CreateDetectorModelOutput) SetDetectorModelConfiguration(v *DetectorModelConfiguration) *CreateDetectorModelOutput {
	s.DetectorModelConfiguration = v
	return s
}

type CreateInputInput struct {
	_ struct{} `type:"structure"`

	// The definition of the input.
	//
	// InputDefinition is a required field
	InputDefinition *InputDefinition `locationName:"inputDefinition" type:"structure" required:"true"`

	// A brief description of the input.
	InputDescription *string `locationName:"inputDescription" type:"string"`

	// The name you want to give to the input.
	//
	// InputName is a required field
	InputName *string `locationName:"inputName" min:"1" type:"string" required:"true"`

	// Metadata which can be used to manage the input.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateInputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInputInput"}
	if s.InputDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDefinition"))
	}
	if s.InputName == nil {
		invalidParams.Add(request.NewErrParamRequired("InputName"))
	}
	if s.InputName != nil && len(*s.InputName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputName", 1))
	}
	if s.InputDefinition != nil {
		if err := s.InputDefinition.Validate(); err != nil {
			invalidParams.AddNested("InputDefinition", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputDefinition sets the InputDefinition field's value.
func (s *CreateInputInput) SetInputDefinition(v *InputDefinition) *CreateInputInput {
	s.InputDefinition = v
	return s
}

// SetInputDescription sets the InputDescription field's value.
func (s *CreateInputInput) SetInputDescription(v string) *CreateInputInput {
	s.InputDescription = &v
	return s
}

// SetInputName sets the InputName field's value.
func (s *CreateInputInput) SetInputName(v string) *CreateInputInput {
	s.InputName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateInputInput) SetTags(v []*Tag) *CreateInputInput {
	s.Tags = v
	return s
}

type CreateInputOutput struct {
	_ struct{} `type:"structure"`

	// Information about the configuration of the input.
	InputConfiguration *InputConfiguration `locationName:"inputConfiguration" type:"structure"`
}

// String returns the string representation
func (s CreateInputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInputOutput) GoString() string {
	return s.String()
}

// SetInputConfiguration sets the InputConfiguration field's value.
func (s *CreateInputOutput) SetInputConfiguration(v *InputConfiguration) *CreateInputOutput {
	s.InputConfiguration = v
	return s
}

type DeleteDetectorModelInput struct {
	_ struct{} `type:"structure"`

	// The name of the detector model to be deleted.
	//
	// DetectorModelName is a required field
	DetectorModelName *string `location:"uri" locationName:"detectorModelName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDetectorModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDetectorModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDetectorModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDetectorModelInput"}
	if s.DetectorModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorModelName"))
	}
	if s.DetectorModelName != nil && len(*s.DetectorModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorModelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorModelName sets the DetectorModelName field's value.
func (s *DeleteDetectorModelInput) SetDetectorModelName(v string) *DeleteDetectorModelInput {
	s.DetectorModelName = &v
	return s
}

type DeleteDetectorModelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDetectorModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDetectorModelOutput) GoString() string {
	return s.String()
}

type DeleteInputInput struct {
	_ struct{} `type:"structure"`

	// The name of the input to be deleted.
	//
	// InputName is a required field
	InputName *string `location:"uri" locationName:"inputName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInputInput"}
	if s.InputName == nil {
		invalidParams.Add(request.NewErrParamRequired("InputName"))
	}
	if s.InputName != nil && len(*s.InputName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputName sets the InputName field's value.
func (s *DeleteInputInput) SetInputName(v string) *DeleteInputInput {
	s.InputName = &v
	return s
}

type DeleteInputOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteInputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInputOutput) GoString() string {
	return s.String()
}

type DescribeDetectorModelInput struct {
	_ struct{} `type:"structure"`

	// The name of the detector model.
	//
	// DetectorModelName is a required field
	DetectorModelName *string `location:"uri" locationName:"detectorModelName" min:"1" type:"string" required:"true"`

	// The version of the detector model.
	DetectorModelVersion *string `location:"querystring" locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeDetectorModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDetectorModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDetectorModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDetectorModelInput"}
	if s.DetectorModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorModelName"))
	}
	if s.DetectorModelName != nil && len(*s.DetectorModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorModelName", 1))
	}
	if s.DetectorModelVersion != nil && len(*s.DetectorModelVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorModelVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorModelName sets the DetectorModelName field's value.
func (s *DescribeDetectorModelInput) SetDetectorModelName(v string) *DescribeDetectorModelInput {
	s.DetectorModelName = &v
	return s
}

// SetDetectorModelVersion sets the DetectorModelVersion field's value.
func (s *DescribeDetectorModelInput) SetDetectorModelVersion(v string) *DescribeDetectorModelInput {
	s.DetectorModelVersion = &v
	return s
}

type DescribeDetectorModelOutput struct {
	_ struct{} `type:"structure"`

	// Information about the detector model.
	DetectorModel *DetectorModel `locationName:"detectorModel" type:"structure"`
}

// String returns the string representation
func (s DescribeDetectorModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDetectorModelOutput) GoString() string {
	return s.String()
}

// SetDetectorModel sets the DetectorModel field's value.
func (s *DescribeDetectorModelOutput) SetDetectorModel(v *DetectorModel) *DescribeDetectorModelOutput {
	s.DetectorModel = v
	return s
}

type DescribeInputInput struct {
	_ struct{} `type:"structure"`

	// The name of the input.
	//
	// InputName is a required field
	InputName *string `location:"uri" locationName:"inputName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeInputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInputInput"}
	if s.InputName == nil {
		invalidParams.Add(request.NewErrParamRequired("InputName"))
	}
	if s.InputName != nil && len(*s.InputName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputName sets the InputName field's value.
func (s *DescribeInputInput) SetInputName(v string) *DescribeInputInput {
	s.InputName = &v
	return s
}

type DescribeInputOutput struct {
	_ struct{} `type:"structure"`

	// Information about the input.
	Input *Input `locationName:"input" type:"structure"`
}

// String returns the string representation
func (s DescribeInputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInputOutput) GoString() string {
	return s.String()
}

// SetInput sets the Input field's value.
func (s *DescribeInputOutput) SetInput(v *Input) *DescribeInputOutput {
	s.Input = v
	return s
}

type DescribeLoggingOptionsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeLoggingOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoggingOptionsInput) GoString() string {
	return s.String()
}

type DescribeLoggingOptionsOutput struct {
	_ struct{} `type:"structure"`

	// The current settings of the AWS IoT Events logging options.
	LoggingOptions *LoggingOptions `locationName:"loggingOptions" type:"structure"`
}

// String returns the string representation
func (s DescribeLoggingOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoggingOptionsOutput) GoString() string {
	return s.String()
}

// SetLoggingOptions sets the LoggingOptions field's value.
func (s *DescribeLoggingOptionsOutput) SetLoggingOptions(v *LoggingOptions) *DescribeLoggingOptionsOutput {
	s.LoggingOptions = v
	return s
}

// The detector model and the specific detectors (instances) for which the logging
// level is given.
type DetectorDebugOption struct {
	_ struct{} `type:"structure"`

	// The name of the detector model.
	//
	// DetectorModelName is a required field
	DetectorModelName *string `locationName:"detectorModelName" min:"1" type:"string" required:"true"`

	// The value of the input attribute key used to create the detector (the instance
	// of the detector model).
	KeyValue *string `locationName:"keyValue" min:"1" type:"string"`
}

// String returns the string representation
func (s DetectorDebugOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectorDebugOption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectorDebugOption) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectorDebugOption"}
	if s.DetectorModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorModelName"))
	}
	if s.DetectorModelName != nil && len(*s.DetectorModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorModelName", 1))
	}
	if s.KeyValue != nil && len(*s.KeyValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorModelName sets the DetectorModelName field's value.
func (s *DetectorDebugOption) SetDetectorModelName(v string) *DetectorDebugOption {
	s.DetectorModelName = &v
	return s
}

// SetKeyValue sets the KeyValue field's value.
func (s *DetectorDebugOption) SetKeyValue(v string) *DetectorDebugOption {
	s.KeyValue = &v
	return s
}

// Information about the detector model.
type DetectorModel struct {
	_ struct{} `type:"structure"`

	// Information about how the detector is configured.
	DetectorModelConfiguration *DetectorModelConfiguration `locationName:"detectorModelConfiguration" type:"structure"`

	// Information that defines how a detector operates.
	DetectorModelDefinition *DetectorModelDefinition `locationName:"detectorModelDefinition" type:"structure"`
}

// String returns the string representation
func (s DetectorModel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectorModel) GoString() string {
	return s.String()
}

// SetDetectorModelConfiguration sets the DetectorModelConfiguration field's value.
func (s *DetectorModel) SetDetectorModelConfiguration(v *DetectorModelConfiguration) *DetectorModel {
	s.DetectorModelConfiguration = v
	return s
}

// SetDetectorModelDefinition sets the DetectorModelDefinition field's value.
func (s *DetectorModel) SetDetectorModelDefinition(v *DetectorModelDefinition) *DetectorModel {
	s.DetectorModelDefinition = v
	return s
}

// Information about how the detector model is configured.
type DetectorModelConfiguration struct {
	_ struct{} `type:"structure"`

	// The time the detector model was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The ARN of the detector model.
	DetectorModelArn *string `locationName:"detectorModelArn" type:"string"`

	// A brief description of the detector model.
	DetectorModelDescription *string `locationName:"detectorModelDescription" type:"string"`

	// The name of the detector model.
	DetectorModelName *string `locationName:"detectorModelName" min:"1" type:"string"`

	// The version of the detector model.
	DetectorModelVersion *string `locationName:"detectorModelVersion" min:"1" type:"string"`

	// The input attribute key used to identify a device or system in order to create
	// a detector (an instance of the detector model) and then to route each input
	// received to the appropriate detector (instance). This parameter uses a JSON-path
	// expression to specify the attribute-value pair in the message payload of
	// each input that is used to identify the device associated with the input.
	Key *string `locationName:"key" min:"1" type:"string"`

	// The time the detector model was last updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The ARN of the role that grants permission to AWS IoT Events to perform its
	// operations.
	RoleArn *string `locationName:"roleArn" min:"1" type:"string"`

	// The status of the detector model.
	Status *string `locationName:"status" type:"string" enum:"DetectorModelVersionStatus"`
}

// String returns the string representation
func (s DetectorModelConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectorModelConfiguration) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DetectorModelConfiguration) SetCreationTime(v time.Time) *DetectorModelConfiguration {
	s.CreationTime = &v
	return s
}

// SetDetectorModelArn sets the DetectorModelArn field's value.
func (s *DetectorModelConfiguration) SetDetectorModelArn(v string) *DetectorModelConfiguration {
	s.DetectorModelArn = &v
	return s
}

// SetDetectorModelDescription sets the DetectorModelDescription field's value.
func (s *DetectorModelConfiguration) SetDetectorModelDescription(v string) *DetectorModelConfiguration {
	s.DetectorModelDescription = &v
	return s
}

// SetDetectorModelName sets the DetectorModelName field's value.
func (s *DetectorModelConfiguration) SetDetectorModelName(v string) *DetectorModelConfiguration {
	s.DetectorModelName = &v
	return s
}

// SetDetectorModelVersion sets the DetectorModelVersion field's value.
func (s *DetectorModelConfiguration) SetDetectorModelVersion(v string) *DetectorModelConfiguration {
	s.DetectorModelVersion = &v
	return s
}

// SetKey sets the Key field's value.
func (s *DetectorModelConfiguration) SetKey(v string) *DetectorModelConfiguration {
	s.Key = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *DetectorModelConfiguration) SetLastUpdateTime(v time.Time) *DetectorModelConfiguration {
	s.LastUpdateTime = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DetectorModelConfiguration) SetRoleArn(v string) *DetectorModelConfiguration {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DetectorModelConfiguration) SetStatus(v string) *DetectorModelConfiguration {
	s.Status = &v
	return s
}

// Information that defines how a detector operates.
type DetectorModelDefinition struct {
	_ struct{} `type:"structure"`

	// The state that is entered at the creation of each detector (instance).
	//
	// InitialStateName is a required field
	InitialStateName *string `locationName:"initialStateName" min:"1" type:"string" required:"true"`

	// Information about the states of the detector.
	//
	// States is a required field
	States []*State `locationName:"states" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DetectorModelDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectorModelDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectorModelDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectorModelDefinition"}
	if s.InitialStateName == nil {
		invalidParams.Add(request.NewErrParamRequired("InitialStateName"))
	}
	if s.InitialStateName != nil && len(*s.InitialStateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InitialStateName", 1))
	}
	if s.States == nil {
		invalidParams.Add(request.NewErrParamRequired("States"))
	}
	if s.States != nil && len(s.States) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("States", 1))
	}
	if s.States != nil {
		for i, v := range s.States {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "States", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInitialStateName sets the InitialStateName field's value.
func (s *DetectorModelDefinition) SetInitialStateName(v string) *DetectorModelDefinition {
	s.InitialStateName = &v
	return s
}

// SetStates sets the States field's value.
func (s *DetectorModelDefinition) SetStates(v []*State) *DetectorModelDefinition {
	s.States = v
	return s
}

// Information about the detector model.
type DetectorModelSummary struct {
	_ struct{} `type:"structure"`

	// The time the detector model was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// A brief description of the detector model.
	DetectorModelDescription *string `locationName:"detectorModelDescription" type:"string"`

	// The name of the detector model.
	DetectorModelName *string `locationName:"detectorModelName" min:"1" type:"string"`
}

// String returns the string representation
func (s DetectorModelSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectorModelSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DetectorModelSummary) SetCreationTime(v time.Time) *DetectorModelSummary {
	s.CreationTime = &v
	return s
}

// SetDetectorModelDescription sets the DetectorModelDescription field's value.
func (s *DetectorModelSummary) SetDetectorModelDescription(v string) *DetectorModelSummary {
	s.DetectorModelDescription = &v
	return s
}

// SetDetectorModelName sets the DetectorModelName field's value.
func (s *DetectorModelSummary) SetDetectorModelName(v string) *DetectorModelSummary {
	s.DetectorModelName = &v
	return s
}

// Information about the detector model version.
type DetectorModelVersionSummary struct {
	_ struct{} `type:"structure"`

	// The time the detector model version was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The ARN of the detector model version.
	DetectorModelArn *string `locationName:"detectorModelArn" type:"string"`

	// The name of the detector model.
	DetectorModelName *string `locationName:"detectorModelName" min:"1" type:"string"`

	// The ID of the detector model version.
	DetectorModelVersion *string `locationName:"detectorModelVersion" min:"1" type:"string"`

	// The last time the detector model version was updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The ARN of the role that grants the detector model permission to perform
	// its tasks.
	RoleArn *string `locationName:"roleArn" min:"1" type:"string"`

	// The status of the detector model version.
	Status *string `locationName:"status" type:"string" enum:"DetectorModelVersionStatus"`
}

// String returns the string representation
func (s DetectorModelVersionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectorModelVersionSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DetectorModelVersionSummary) SetCreationTime(v time.Time) *DetectorModelVersionSummary {
	s.CreationTime = &v
	return s
}

// SetDetectorModelArn sets the DetectorModelArn field's value.
func (s *DetectorModelVersionSummary) SetDetectorModelArn(v string) *DetectorModelVersionSummary {
	s.DetectorModelArn = &v
	return s
}

// SetDetectorModelName sets the DetectorModelName field's value.
func (s *DetectorModelVersionSummary) SetDetectorModelName(v string) *DetectorModelVersionSummary {
	s.DetectorModelName = &v
	return s
}

// SetDetectorModelVersion sets the DetectorModelVersion field's value.
func (s *DetectorModelVersionSummary) SetDetectorModelVersion(v string) *DetectorModelVersionSummary {
	s.DetectorModelVersion = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *DetectorModelVersionSummary) SetLastUpdateTime(v time.Time) *DetectorModelVersionSummary {
	s.LastUpdateTime = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DetectorModelVersionSummary) SetRoleArn(v string) *DetectorModelVersionSummary {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DetectorModelVersionSummary) SetStatus(v string) *DetectorModelVersionSummary {
	s.Status = &v
	return s
}

// Specifies the actions to be performed when the condition evaluates to TRUE.
type Event struct {
	_ struct{} `type:"structure"`

	// The actions to be performed.
	Actions []*Action `locationName:"actions" type:"list"`

	// [Optional] The Boolean expression that when TRUE causes the actions to be
	// performed. If not present, the actions are performed (=TRUE); if the expression
	// result is not a Boolean value the actions are NOT performed (=FALSE).
	Condition *string `locationName:"condition" type:"string"`

	// The name of the event.
	//
	// EventName is a required field
	EventName *string `locationName:"eventName" type:"string" required:"true"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Event) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Event) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Event"}
	if s.EventName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventName"))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *Event) SetActions(v []*Action) *Event {
	s.Actions = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *Event) SetCondition(v string) *Event {
	s.Condition = &v
	return s
}

// SetEventName sets the EventName field's value.
func (s *Event) SetEventName(v string) *Event {
	s.EventName = &v
	return s
}

// Information about the input.
type Input struct {
	_ struct{} `type:"structure"`

	// Information about the configuration of an input.
	InputConfiguration *InputConfiguration `locationName:"inputConfiguration" type:"structure"`

	// The definition of the input.
	InputDefinition *InputDefinition `locationName:"inputDefinition" type:"structure"`
}

// String returns the string representation
func (s Input) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Input) GoString() string {
	return s.String()
}

// SetInputConfiguration sets the InputConfiguration field's value.
func (s *Input) SetInputConfiguration(v *InputConfiguration) *Input {
	s.InputConfiguration = v
	return s
}

// SetInputDefinition sets the InputDefinition field's value.
func (s *Input) SetInputDefinition(v *InputDefinition) *Input {
	s.InputDefinition = v
	return s
}

// Information about the configuration of an input.
type InputConfiguration struct {
	_ struct{} `type:"structure"`

	// The time the input was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// The ARN of the input.
	//
	// InputArn is a required field
	InputArn *string `locationName:"inputArn" type:"string" required:"true"`

	// A brief description of the input.
	InputDescription *string `locationName:"inputDescription" type:"string"`

	// The name of the input.
	//
	// InputName is a required field
	InputName *string `locationName:"inputName" min:"1" type:"string" required:"true"`

	// The last time the input was updated.
	//
	// LastUpdateTime is a required field
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp" required:"true"`

	// The status of the input.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"InputStatus"`
}

// String returns the string representation
func (s InputConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputConfiguration) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *InputConfiguration) SetCreationTime(v time.Time) *InputConfiguration {
	s.CreationTime = &v
	return s
}

// SetInputArn sets the InputArn field's value.
func (s *InputConfiguration) SetInputArn(v string) *InputConfiguration {
	s.InputArn = &v
	return s
}

// SetInputDescription sets the InputDescription field's value.
func (s *InputConfiguration) SetInputDescription(v string) *InputConfiguration {
	s.InputDescription = &v
	return s
}

// SetInputName sets the InputName field's value.
func (s *InputConfiguration) SetInputName(v string) *InputConfiguration {
	s.InputName = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *InputConfiguration) SetLastUpdateTime(v time.Time) *InputConfiguration {
	s.LastUpdateTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *InputConfiguration) SetStatus(v string) *InputConfiguration {
	s.Status = &v
	return s
}

// The definition of the input.
type InputDefinition struct {
	_ struct{} `type:"structure"`

	// The attributes from the JSON payload that are made available by the input.
	// Inputs are derived from messages sent to the AWS IoT Events system using
	// BatchPutMessage. Each such message contains a JSON payload, and those attributes
	// (and their paired values) specified here is available for use in the condition
	// expressions used by detectors that monitor this input.
	//
	// Attributes is a required field
	Attributes []*Attribute `locationName:"attributes" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s InputDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputDefinition"}
	if s.Attributes == nil {
		invalidParams.Add(request.NewErrParamRequired("Attributes"))
	}
	if s.Attributes != nil && len(s.Attributes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Attributes", 1))
	}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *InputDefinition) SetAttributes(v []*Attribute) *InputDefinition {
	s.Attributes = v
	return s
}

// Information about the input.
type InputSummary struct {
	_ struct{} `type:"structure"`

	// The time the input was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The ARN of the input.
	InputArn *string `locationName:"inputArn" type:"string"`

	// A brief description of the input.
	InputDescription *string `locationName:"inputDescription" type:"string"`

	// The name of the input.
	InputName *string `locationName:"inputName" min:"1" type:"string"`

	// The last time the input was updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The status of the input.
	Status *string `locationName:"status" type:"string" enum:"InputStatus"`
}

// String returns the string representation
func (s InputSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *InputSummary) SetCreationTime(v time.Time) *InputSummary {
	s.CreationTime = &v
	return s
}

// SetInputArn sets the InputArn field's value.
func (s *InputSummary) SetInputArn(v string) *InputSummary {
	s.InputArn = &v
	return s
}

// SetInputDescription sets the InputDescription field's value.
func (s *InputSummary) SetInputDescription(v string) *InputSummary {
	s.InputDescription = &v
	return s
}

// SetInputName sets the InputName field's value.
func (s *InputSummary) SetInputName(v string) *InputSummary {
	s.InputName = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *InputSummary) SetLastUpdateTime(v time.Time) *InputSummary {
	s.LastUpdateTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *InputSummary) SetStatus(v string) *InputSummary {
	s.Status = &v
	return s
}

// Information required to publish the MQTT message via the AWS IoT Message
// Broker.
type IotTopicPublishAction struct {
	_ struct{} `type:"structure"`

	// The MQTT topic of the message.
	//
	// MqttTopic is a required field
	MqttTopic *string `locationName:"mqttTopic" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s IotTopicPublishAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IotTopicPublishAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IotTopicPublishAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IotTopicPublishAction"}
	if s.MqttTopic == nil {
		invalidParams.Add(request.NewErrParamRequired("MqttTopic"))
	}
	if s.MqttTopic != nil && len(*s.MqttTopic) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MqttTopic", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMqttTopic sets the MqttTopic field's value.
func (s *IotTopicPublishAction) SetMqttTopic(v string) *IotTopicPublishAction {
	s.MqttTopic = &v
	return s
}

type ListDetectorModelVersionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the detector model whose versions are returned.
	//
	// DetectorModelName is a required field
	DetectorModelName *string `location:"uri" locationName:"detectorModelName" min:"1" type:"string" required:"true"`

	// The maximum number of results to return at one time.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDetectorModelVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDetectorModelVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDetectorModelVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDetectorModelVersionsInput"}
	if s.DetectorModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorModelName"))
	}
	if s.DetectorModelName != nil && len(*s.DetectorModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorModelName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorModelName sets the DetectorModelName field's value.
func (s *ListDetectorModelVersionsInput) SetDetectorModelName(v string) *ListDetectorModelVersionsInput {
	s.DetectorModelName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDetectorModelVersionsInput) SetMaxResults(v int64) *ListDetectorModelVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDetectorModelVersionsInput) SetNextToken(v string) *ListDetectorModelVersionsInput {
	s.NextToken = &v
	return s
}

type ListDetectorModelVersionsOutput struct {
	_ struct{} `type:"structure"`

	// Summary information about the detector model versions.
	DetectorModelVersionSummaries []*DetectorModelVersionSummary `locationName:"detectorModelVersionSummaries" type:"list"`

	// A token to retrieve the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDetectorModelVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDetectorModelVersionsOutput) GoString() string {
	return s.String()
}

// SetDetectorModelVersionSummaries sets the DetectorModelVersionSummaries field's value.
func (s *ListDetectorModelVersionsOutput) SetDetectorModelVersionSummaries(v []*DetectorModelVersionSummary) *ListDetectorModelVersionsOutput {
	s.DetectorModelVersionSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDetectorModelVersionsOutput) SetNextToken(v string) *ListDetectorModelVersionsOutput {
	s.NextToken = &v
	return s
}

type ListDetectorModelsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return at one time.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDetectorModelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDetectorModelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDetectorModelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDetectorModelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDetectorModelsInput) SetMaxResults(v int64) *ListDetectorModelsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDetectorModelsInput) SetNextToken(v string) *ListDetectorModelsInput {
	s.NextToken = &v
	return s
}

type ListDetectorModelsOutput struct {
	_ struct{} `type:"structure"`

	// Summary information about the detector models.
	DetectorModelSummaries []*DetectorModelSummary `locationName:"detectorModelSummaries" type:"list"`

	// A token to retrieve the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDetectorModelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDetectorModelsOutput) GoString() string {
	return s.String()
}

// SetDetectorModelSummaries sets the DetectorModelSummaries field's value.
func (s *ListDetectorModelsOutput) SetDetectorModelSummaries(v []*DetectorModelSummary) *ListDetectorModelsOutput {
	s.DetectorModelSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDetectorModelsOutput) SetNextToken(v string) *ListDetectorModelsOutput {
	s.NextToken = &v
	return s
}

type ListInputsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return at one time.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListInputsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInputsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInputsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInputsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInputsInput) SetMaxResults(v int64) *ListInputsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInputsInput) SetNextToken(v string) *ListInputsInput {
	s.NextToken = &v
	return s
}

type ListInputsOutput struct {
	_ struct{} `type:"structure"`

	// Summary information about the inputs.
	InputSummaries []*InputSummary `locationName:"inputSummaries" type:"list"`

	// A token to retrieve the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListInputsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInputsOutput) GoString() string {
	return s.String()
}

// SetInputSummaries sets the InputSummaries field's value.
func (s *ListInputsOutput) SetInputSummaries(v []*InputSummary) *ListInputsOutput {
	s.InputSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInputsOutput) SetNextToken(v string) *ListInputsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The list of tags assigned to the resource.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The values of the AWS IoT Events logging options.
type LoggingOptions struct {
	_ struct{} `type:"structure"`

	// Information that identifies those detector models and their detectors (instances)
	// for which the logging level is given.
	DetectorDebugOptions []*DetectorDebugOption `locationName:"detectorDebugOptions" min:"1" type:"list"`

	// If TRUE, logging is enabled for AWS IoT Events.
	//
	// Enabled is a required field
	Enabled *bool `locationName:"enabled" type:"boolean" required:"true"`

	// The logging level. Currently, only "ERROR" is supported.
	//
	// Level is a required field
	Level *string `locationName:"level" type:"string" required:"true" enum:"LoggingLevel"`

	// The ARN of the role that grants permission to AWS IoT Events to perform logging.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s LoggingOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoggingOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LoggingOptions"}
	if s.DetectorDebugOptions != nil && len(s.DetectorDebugOptions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorDebugOptions", 1))
	}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.Level == nil {
		invalidParams.Add(request.NewErrParamRequired("Level"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.DetectorDebugOptions != nil {
		for i, v := range s.DetectorDebugOptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DetectorDebugOptions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorDebugOptions sets the DetectorDebugOptions field's value.
func (s *LoggingOptions) SetDetectorDebugOptions(v []*DetectorDebugOption) *LoggingOptions {
	s.DetectorDebugOptions = v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *LoggingOptions) SetEnabled(v bool) *LoggingOptions {
	s.Enabled = &v
	return s
}

// SetLevel sets the Level field's value.
func (s *LoggingOptions) SetLevel(v string) *LoggingOptions {
	s.Level = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *LoggingOptions) SetRoleArn(v string) *LoggingOptions {
	s.RoleArn = &v
	return s
}

// When entering this state, perform these actions if the condition is TRUE.
type OnEnterLifecycle struct {
	_ struct{} `type:"structure"`

	// Specifies the actions that are performed when the state is entered and the
	// condition is TRUE.
	Events []*Event `locationName:"events" type:"list"`
}

// String returns the string representation
func (s OnEnterLifecycle) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OnEnterLifecycle) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OnEnterLifecycle) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OnEnterLifecycle"}
	if s.Events != nil {
		for i, v := range s.Events {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Events", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvents sets the Events field's value.
func (s *OnEnterLifecycle) SetEvents(v []*Event) *OnEnterLifecycle {
	s.Events = v
	return s
}

// When exiting this state, perform these actions if the specified condition
// is TRUE.
type OnExitLifecycle struct {
	_ struct{} `type:"structure"`

	// Specifies the actions that are performed when the state is exited and the
	// condition is TRUE.
	Events []*Event `locationName:"events" type:"list"`
}

// String returns the string representation
func (s OnExitLifecycle) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OnExitLifecycle) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OnExitLifecycle) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OnExitLifecycle"}
	if s.Events != nil {
		for i, v := range s.Events {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Events", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvents sets the Events field's value.
func (s *OnExitLifecycle) SetEvents(v []*Event) *OnExitLifecycle {
	s.Events = v
	return s
}

// Specifies the actions performed when the condition evaluates to TRUE.
type OnInputLifecycle struct {
	_ struct{} `type:"structure"`

	// Specifies the actions performed when the condition evaluates to TRUE.
	Events []*Event `locationName:"events" type:"list"`

	// Specifies the actions performed and the next state entered when a condition
	// evaluates to TRUE.
	TransitionEvents []*TransitionEvent `locationName:"transitionEvents" type:"list"`
}

// String returns the string representation
func (s OnInputLifecycle) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OnInputLifecycle) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OnInputLifecycle) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OnInputLifecycle"}
	if s.Events != nil {
		for i, v := range s.Events {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Events", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TransitionEvents != nil {
		for i, v := range s.TransitionEvents {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TransitionEvents", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvents sets the Events field's value.
func (s *OnInputLifecycle) SetEvents(v []*Event) *OnInputLifecycle {
	s.Events = v
	return s
}

// SetTransitionEvents sets the TransitionEvents field's value.
func (s *OnInputLifecycle) SetTransitionEvents(v []*TransitionEvent) *OnInputLifecycle {
	s.TransitionEvents = v
	return s
}

type PutLoggingOptionsInput struct {
	_ struct{} `type:"structure"`

	// The new values of the AWS IoT Events logging options.
	//
	// LoggingOptions is a required field
	LoggingOptions *LoggingOptions `locationName:"loggingOptions" type:"structure" required:"true"`
}

// String returns the string representation
func (s PutLoggingOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutLoggingOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutLoggingOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutLoggingOptionsInput"}
	if s.LoggingOptions == nil {
		invalidParams.Add(request.NewErrParamRequired("LoggingOptions"))
	}
	if s.LoggingOptions != nil {
		if err := s.LoggingOptions.Validate(); err != nil {
			invalidParams.AddNested("LoggingOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoggingOptions sets the LoggingOptions field's value.
func (s *PutLoggingOptionsInput) SetLoggingOptions(v *LoggingOptions) *PutLoggingOptionsInput {
	s.LoggingOptions = v
	return s
}

type PutLoggingOptionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutLoggingOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutLoggingOptionsOutput) GoString() string {
	return s.String()
}

// Information needed to reset the timer.
type ResetTimerAction struct {
	_ struct{} `type:"structure"`

	// The name of the timer to reset.
	//
	// TimerName is a required field
	TimerName *string `locationName:"timerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ResetTimerAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetTimerAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetTimerAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResetTimerAction"}
	if s.TimerName == nil {
		invalidParams.Add(request.NewErrParamRequired("TimerName"))
	}
	if s.TimerName != nil && len(*s.TimerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TimerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTimerName sets the TimerName field's value.
func (s *ResetTimerAction) SetTimerName(v string) *ResetTimerAction {
	s.TimerName = &v
	return s
}

// Information required to publish the Amazon SNS message.
type SNSTopicPublishAction struct {
	_ struct{} `type:"structure"`

	// The ARN of the Amazon SNS target to which the message is sent.
	//
	// TargetArn is a required field
	TargetArn *string `locationName:"targetArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SNSTopicPublishAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SNSTopicPublishAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SNSTopicPublishAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SNSTopicPublishAction"}
	if s.TargetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetArn"))
	}
	if s.TargetArn != nil && len(*s.TargetArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTargetArn sets the TargetArn field's value.
func (s *SNSTopicPublishAction) SetTargetArn(v string) *SNSTopicPublishAction {
	s.TargetArn = &v
	return s
}

// Information needed to set the timer.
type SetTimerAction struct {
	_ struct{} `type:"structure"`

	// The number of seconds until the timer expires. The minimum value is 60 seconds
	// to ensure accuracy.
	//
	// Seconds is a required field
	Seconds *int64 `locationName:"seconds" type:"integer" required:"true"`

	// The name of the timer.
	//
	// TimerName is a required field
	TimerName *string `locationName:"timerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SetTimerAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetTimerAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetTimerAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetTimerAction"}
	if s.Seconds == nil {
		invalidParams.Add(request.NewErrParamRequired("Seconds"))
	}
	if s.TimerName == nil {
		invalidParams.Add(request.NewErrParamRequired("TimerName"))
	}
	if s.TimerName != nil && len(*s.TimerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TimerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSeconds sets the Seconds field's value.
func (s *SetTimerAction) SetSeconds(v int64) *SetTimerAction {
	s.Seconds = &v
	return s
}

// SetTimerName sets the TimerName field's value.
func (s *SetTimerAction) SetTimerName(v string) *SetTimerAction {
	s.TimerName = &v
	return s
}

// Information about the variable and its new value.
type SetVariableAction struct {
	_ struct{} `type:"structure"`

	// The new value of the variable.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`

	// The name of the variable.
	//
	// VariableName is a required field
	VariableName *string `locationName:"variableName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SetVariableAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetVariableAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetVariableAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetVariableAction"}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}
	if s.VariableName == nil {
		invalidParams.Add(request.NewErrParamRequired("VariableName"))
	}
	if s.VariableName != nil && len(*s.VariableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VariableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValue sets the Value field's value.
func (s *SetVariableAction) SetValue(v string) *SetVariableAction {
	s.Value = &v
	return s
}

// SetVariableName sets the VariableName field's value.
func (s *SetVariableAction) SetVariableName(v string) *SetVariableAction {
	s.VariableName = &v
	return s
}

// Information that defines a state of a detector.
type State struct {
	_ struct{} `type:"structure"`

	// When entering this state, perform these actions if the condition is TRUE.
	OnEnter *OnEnterLifecycle `locationName:"onEnter" type:"structure"`

	// When exiting this state, perform these actions if the specified condition
	// is TRUE.
	OnExit *OnExitLifecycle `locationName:"onExit" type:"structure"`

	// When an input is received and the condition is TRUE, perform the specified
	// actions.
	OnInput *OnInputLifecycle `locationName:"onInput" type:"structure"`

	// The name of the state.
	//
	// StateName is a required field
	StateName *string `locationName:"stateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s State) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s State) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *State) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "State"}
	if s.StateName == nil {
		invalidParams.Add(request.NewErrParamRequired("StateName"))
	}
	if s.StateName != nil && len(*s.StateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StateName", 1))
	}
	if s.OnEnter != nil {
		if err := s.OnEnter.Validate(); err != nil {
			invalidParams.AddNested("OnEnter", err.(request.ErrInvalidParams))
		}
	}
	if s.OnExit != nil {
		if err := s.OnExit.Validate(); err != nil {
			invalidParams.AddNested("OnExit", err.(request.ErrInvalidParams))
		}
	}
	if s.OnInput != nil {
		if err := s.OnInput.Validate(); err != nil {
			invalidParams.AddNested("OnInput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOnEnter sets the OnEnter field's value.
func (s *State) SetOnEnter(v *OnEnterLifecycle) *State {
	s.OnEnter = v
	return s
}

// SetOnExit sets the OnExit field's value.
func (s *State) SetOnExit(v *OnExitLifecycle) *State {
	s.OnExit = v
	return s
}

// SetOnInput sets the OnInput field's value.
func (s *State) SetOnInput(v *OnInputLifecycle) *State {
	s.OnInput = v
	return s
}

// SetStateName sets the StateName field's value.
func (s *State) SetStateName(v string) *State {
	s.StateName = &v
	return s
}

// Metadata which can be used to manage the resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag's key.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The tag's value.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The new or modified tags for the resource.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Specifies the actions performed and the next state entered when a condition
// evaluates to TRUE.
type TransitionEvent struct {
	_ struct{} `type:"structure"`

	// The actions to be performed.
	Actions []*Action `locationName:"actions" type:"list"`

	// [Required] A Boolean expression that when TRUE causes the actions to be performed
	// and the nextState to be entered.
	//
	// Condition is a required field
	Condition *string `locationName:"condition" type:"string" required:"true"`

	// The name of the transition event.
	//
	// EventName is a required field
	EventName *string `locationName:"eventName" type:"string" required:"true"`

	// The next state to enter.
	//
	// NextState is a required field
	NextState *string `locationName:"nextState" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TransitionEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TransitionEvent) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransitionEvent) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TransitionEvent"}
	if s.Condition == nil {
		invalidParams.Add(request.NewErrParamRequired("Condition"))
	}
	if s.EventName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventName"))
	}
	if s.NextState == nil {
		invalidParams.Add(request.NewErrParamRequired("NextState"))
	}
	if s.NextState != nil && len(*s.NextState) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextState", 1))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *TransitionEvent) SetActions(v []*Action) *TransitionEvent {
	s.Actions = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *TransitionEvent) SetCondition(v string) *TransitionEvent {
	s.Condition = &v
	return s
}

// SetEventName sets the EventName field's value.
func (s *TransitionEvent) SetEventName(v string) *TransitionEvent {
	s.EventName = &v
	return s
}

// SetNextState sets the NextState field's value.
func (s *TransitionEvent) SetNextState(v string) *TransitionEvent {
	s.NextState = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// A list of the keys of the tags to be removed from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateDetectorModelInput struct {
	_ struct{} `type:"structure"`

	// Information that defines how a detector operates.
	//
	// DetectorModelDefinition is a required field
	DetectorModelDefinition *DetectorModelDefinition `locationName:"detectorModelDefinition" type:"structure" required:"true"`

	// A brief description of the detector model.
	DetectorModelDescription *string `locationName:"detectorModelDescription" type:"string"`

	// The name of the detector model to be updated.
	//
	// DetectorModelName is a required field
	DetectorModelName *string `location:"uri" locationName:"detectorModelName" min:"1" type:"string" required:"true"`

	// The ARN of the role that grants permission to AWS IoT Events to perform its
	// operations.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateDetectorModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDetectorModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDetectorModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDetectorModelInput"}
	if s.DetectorModelDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorModelDefinition"))
	}
	if s.DetectorModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorModelName"))
	}
	if s.DetectorModelName != nil && len(*s.DetectorModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorModelName", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.DetectorModelDefinition != nil {
		if err := s.DetectorModelDefinition.Validate(); err != nil {
			invalidParams.AddNested("DetectorModelDefinition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorModelDefinition sets the DetectorModelDefinition field's value.
func (s *UpdateDetectorModelInput) SetDetectorModelDefinition(v *DetectorModelDefinition) *UpdateDetectorModelInput {
	s.DetectorModelDefinition = v
	return s
}

// SetDetectorModelDescription sets the DetectorModelDescription field's value.
func (s *UpdateDetectorModelInput) SetDetectorModelDescription(v string) *UpdateDetectorModelInput {
	s.DetectorModelDescription = &v
	return s
}

// SetDetectorModelName sets the DetectorModelName field's value.
func (s *UpdateDetectorModelInput) SetDetectorModelName(v string) *UpdateDetectorModelInput {
	s.DetectorModelName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateDetectorModelInput) SetRoleArn(v string) *UpdateDetectorModelInput {
	s.RoleArn = &v
	return s
}

type UpdateDetectorModelOutput struct {
	_ struct{} `type:"structure"`

	// Information about how the detector model is configured.
	DetectorModelConfiguration *DetectorModelConfiguration `locationName:"detectorModelConfiguration" type:"structure"`
}

// String returns the string representation
func (s UpdateDetectorModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDetectorModelOutput) GoString() string {
	return s.String()
}

// SetDetectorModelConfiguration sets the DetectorModelConfiguration field's value.
func (s *UpdateDetectorModelOutput) SetDetectorModelConfiguration(v *DetectorModelConfiguration) *UpdateDetectorModelOutput {
	s.DetectorModelConfiguration = v
	return s
}

type UpdateInputInput struct {
	_ struct{} `type:"structure"`

	// The definition of the input.
	//
	// InputDefinition is a required field
	InputDefinition *InputDefinition `locationName:"inputDefinition" type:"structure" required:"true"`

	// A brief description of the input.
	InputDescription *string `locationName:"inputDescription" type:"string"`

	// The name of the input you want to update.
	//
	// InputName is a required field
	InputName *string `location:"uri" locationName:"inputName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateInputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateInputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateInputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateInputInput"}
	if s.InputDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDefinition"))
	}
	if s.InputName == nil {
		invalidParams.Add(request.NewErrParamRequired("InputName"))
	}
	if s.InputName != nil && len(*s.InputName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputName", 1))
	}
	if s.InputDefinition != nil {
		if err := s.InputDefinition.Validate(); err != nil {
			invalidParams.AddNested("InputDefinition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputDefinition sets the InputDefinition field's value.
func (s *UpdateInputInput) SetInputDefinition(v *InputDefinition) *UpdateInputInput {
	s.InputDefinition = v
	return s
}

// SetInputDescription sets the InputDescription field's value.
func (s *UpdateInputInput) SetInputDescription(v string) *UpdateInputInput {
	s.InputDescription = &v
	return s
}

// SetInputName sets the InputName field's value.
func (s *UpdateInputInput) SetInputName(v string) *UpdateInputInput {
	s.InputName = &v
	return s
}

type UpdateInputOutput struct {
	_ struct{} `type:"structure"`

	// Information about the configuration of the input.
	InputConfiguration *InputConfiguration `locationName:"inputConfiguration" type:"structure"`
}

// String returns the string representation
func (s UpdateInputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateInputOutput) GoString() string {
	return s.String()
}

// SetInputConfiguration sets the InputConfiguration field's value.
func (s *UpdateInputOutput) SetInputConfiguration(v *InputConfiguration) *UpdateInputOutput {
	s.InputConfiguration = v
	return s
}

const (
	// DetectorModelVersionStatusActive is a DetectorModelVersionStatus enum value
	DetectorModelVersionStatusActive = "ACTIVE"

	// DetectorModelVersionStatusActivating is a DetectorModelVersionStatus enum value
	DetectorModelVersionStatusActivating = "ACTIVATING"

	// DetectorModelVersionStatusInactive is a DetectorModelVersionStatus enum value
	DetectorModelVersionStatusInactive = "INACTIVE"

	// DetectorModelVersionStatusDeprecated is a DetectorModelVersionStatus enum value
	DetectorModelVersionStatusDeprecated = "DEPRECATED"

	// DetectorModelVersionStatusDraft is a DetectorModelVersionStatus enum value
	DetectorModelVersionStatusDraft = "DRAFT"

	// DetectorModelVersionStatusPaused is a DetectorModelVersionStatus enum value
	DetectorModelVersionStatusPaused = "PAUSED"

	// DetectorModelVersionStatusFailed is a DetectorModelVersionStatus enum value
	DetectorModelVersionStatusFailed = "FAILED"
)

const (
	// InputStatusCreating is a InputStatus enum value
	InputStatusCreating = "CREATING"

	// InputStatusUpdating is a InputStatus enum value
	InputStatusUpdating = "UPDATING"

	// InputStatusActive is a InputStatus enum value
	InputStatusActive = "ACTIVE"

	// InputStatusDeleting is a InputStatus enum value
	InputStatusDeleting = "DELETING"
)

const (
	// LoggingLevelError is a LoggingLevel enum value
	LoggingLevelError = "ERROR"

	// LoggingLevelInfo is a LoggingLevel enum value
	LoggingLevelInfo = "INFO"

	// LoggingLevelDebug is a LoggingLevel enum value
	LoggingLevelDebug = "DEBUG"
)
