// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCreateGroup = "CreateGroup"

// CreateGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGroup for more information on using the CreateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGroupRequest method.
//    req, resp := client.CreateGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroup
func (c *QuickSight) CreateGroupRequest(input *CreateGroupInput) (req *request.Request, output *CreateGroupOutput) {
	op := &request.Operation{
		Name:       opCreateGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups",
	}

	if input == nil {
		input = &CreateGroupInput{}
	}

	output = &CreateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGroup API operation for Amazon QuickSight.
//
// Creates an Amazon QuickSight group.
//
// The permissions resource is arn:aws:quicksight:us-east-1:<relevant-aws-account-id>:group/default/<group-name> .
//
// The response is a group object.
//
// CLI Sample:
//
// aws quicksight create-group --aws-account-id=111122223333 --namespace=default
// --group-name="Sales-Management" --description="Sales Management - Forecasting"
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceExistsException "ResourceExistsException"
//   The resource specified doesn't exist.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodePreconditionNotMetException "PreconditionNotMetException"
//   One or more preconditions aren't met.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit is exceeded.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroup
func (c *QuickSight) CreateGroup(input *CreateGroupInput) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	return out, req.Send()
}

// CreateGroupWithContext is the same as CreateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateGroupWithContext(ctx aws.Context, input *CreateGroupInput, opts ...request.Option) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGroupMembership = "CreateGroupMembership"

// CreateGroupMembershipRequest generates a "aws/request.Request" representing the
// client's request for the CreateGroupMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGroupMembership for more information on using the CreateGroupMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGroupMembershipRequest method.
//    req, resp := client.CreateGroupMembershipRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroupMembership
func (c *QuickSight) CreateGroupMembershipRequest(input *CreateGroupMembershipInput) (req *request.Request, output *CreateGroupMembershipOutput) {
	op := &request.Operation{
		Name:       opCreateGroupMembership,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members/{MemberName}",
	}

	if input == nil {
		input = &CreateGroupMembershipInput{}
	}

	output = &CreateGroupMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGroupMembership API operation for Amazon QuickSight.
//
// Adds an Amazon QuickSight user to an Amazon QuickSight group.
//
// The permissions resource is arn:aws:quicksight:us-east-1:<aws-account-id>:group/default/<group-name> .
//
// The condition resource is the user name.
//
// The condition key is quicksight:UserName.
//
// The response is the group member object.
//
// CLI Sample:
//
// aws quicksight create-group-membership --aws-account-id=111122223333 --namespace=default
// --group-name=Sales --member-name=Pat
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateGroupMembership for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodePreconditionNotMetException "PreconditionNotMetException"
//   One or more preconditions aren't met.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroupMembership
func (c *QuickSight) CreateGroupMembership(input *CreateGroupMembershipInput) (*CreateGroupMembershipOutput, error) {
	req, out := c.CreateGroupMembershipRequest(input)
	return out, req.Send()
}

// CreateGroupMembershipWithContext is the same as CreateGroupMembership with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGroupMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateGroupMembershipWithContext(ctx aws.Context, input *CreateGroupMembershipInput, opts ...request.Option) (*CreateGroupMembershipOutput, error) {
	req, out := c.CreateGroupMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGroup = "DeleteGroup"

// DeleteGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGroup for more information on using the DeleteGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGroupRequest method.
//    req, resp := client.DeleteGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroup
func (c *QuickSight) DeleteGroupRequest(input *DeleteGroupInput) (req *request.Request, output *DeleteGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}",
	}

	if input == nil {
		input = &DeleteGroupInput{}
	}

	output = &DeleteGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteGroup API operation for Amazon QuickSight.
//
// Removes a user group from Amazon QuickSight.
//
// The permissions resource is arn:aws:quicksight:us-east-1:<aws-account-id>:group/default/<group-name> .
//
// CLI Sample:
//
// aws quicksight delete-group -\-aws-account-id=111122223333 -\-namespace=default
// -\-group-name=Sales-Management
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodePreconditionNotMetException "PreconditionNotMetException"
//   One or more preconditions aren't met.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroup
func (c *QuickSight) DeleteGroup(input *DeleteGroupInput) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	return out, req.Send()
}

// DeleteGroupWithContext is the same as DeleteGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteGroupWithContext(ctx aws.Context, input *DeleteGroupInput, opts ...request.Option) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGroupMembership = "DeleteGroupMembership"

// DeleteGroupMembershipRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGroupMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGroupMembership for more information on using the DeleteGroupMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGroupMembershipRequest method.
//    req, resp := client.DeleteGroupMembershipRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroupMembership
func (c *QuickSight) DeleteGroupMembershipRequest(input *DeleteGroupMembershipInput) (req *request.Request, output *DeleteGroupMembershipOutput) {
	op := &request.Operation{
		Name:       opDeleteGroupMembership,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members/{MemberName}",
	}

	if input == nil {
		input = &DeleteGroupMembershipInput{}
	}

	output = &DeleteGroupMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteGroupMembership API operation for Amazon QuickSight.
//
// Removes a user from a group so that the user is no longer a member of the
// group.
//
// The permissions resource is arn:aws:quicksight:us-east-1:<aws-account-id>:group/default/<group-name> .
//
// The condition resource is the user name.
//
// The condition key is quicksight:UserName.
//
// CLI Sample:
//
// aws quicksight delete-group-membership --aws-account-id=111122223333 --namespace=default
// --group-name=Sales-Management --member-name=Charlie
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteGroupMembership for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodePreconditionNotMetException "PreconditionNotMetException"
//   One or more preconditions aren't met.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroupMembership
func (c *QuickSight) DeleteGroupMembership(input *DeleteGroupMembershipInput) (*DeleteGroupMembershipOutput, error) {
	req, out := c.DeleteGroupMembershipRequest(input)
	return out, req.Send()
}

// DeleteGroupMembershipWithContext is the same as DeleteGroupMembership with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGroupMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteGroupMembershipWithContext(ctx aws.Context, input *DeleteGroupMembershipInput, opts ...request.Option) (*DeleteGroupMembershipOutput, error) {
	req, out := c.DeleteGroupMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUser = "DeleteUser"

// DeleteUserRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUser for more information on using the DeleteUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserRequest method.
//    req, resp := client.DeleteUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUser
func (c *QuickSight) DeleteUserRequest(input *DeleteUserInput) (req *request.Request, output *DeleteUserOutput) {
	op := &request.Operation{
		Name:       opDeleteUser,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}",
	}

	if input == nil {
		input = &DeleteUserInput{}
	}

	output = &DeleteUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteUser API operation for Amazon QuickSight.
//
// Deletes the Amazon QuickSight user that is associated with the identity of
// the AWS Identity and Access Management (IAM) user or role that's making the
// call. The IAM user isn't deleted as a result of this call.
//
// The permission resource is arn:aws:quicksight:us-east-1:<aws-account-id>:user/default/<user-name> .
//
// CLI Sample:
//
// aws quicksight delete-user --aws-account-id=111122223333 --namespace=default
// --user-name=Pat
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUser
func (c *QuickSight) DeleteUser(input *DeleteUserInput) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	return out, req.Send()
}

// DeleteUserWithContext is the same as DeleteUser with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteUserWithContext(ctx aws.Context, input *DeleteUserInput, opts ...request.Option) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUserByPrincipalId = "DeleteUserByPrincipalId"

// DeleteUserByPrincipalIdRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUserByPrincipalId operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUserByPrincipalId for more information on using the DeleteUserByPrincipalId
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserByPrincipalIdRequest method.
//    req, resp := client.DeleteUserByPrincipalIdRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUserByPrincipalId
func (c *QuickSight) DeleteUserByPrincipalIdRequest(input *DeleteUserByPrincipalIdInput) (req *request.Request, output *DeleteUserByPrincipalIdOutput) {
	op := &request.Operation{
		Name:       opDeleteUserByPrincipalId,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/user-principals/{PrincipalId}",
	}

	if input == nil {
		input = &DeleteUserByPrincipalIdInput{}
	}

	output = &DeleteUserByPrincipalIdOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteUserByPrincipalId API operation for Amazon QuickSight.
//
// Deletes a user after locating the user by its principal ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteUserByPrincipalId for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUserByPrincipalId
func (c *QuickSight) DeleteUserByPrincipalId(input *DeleteUserByPrincipalIdInput) (*DeleteUserByPrincipalIdOutput, error) {
	req, out := c.DeleteUserByPrincipalIdRequest(input)
	return out, req.Send()
}

// DeleteUserByPrincipalIdWithContext is the same as DeleteUserByPrincipalId with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUserByPrincipalId for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteUserByPrincipalIdWithContext(ctx aws.Context, input *DeleteUserByPrincipalIdInput, opts ...request.Option) (*DeleteUserByPrincipalIdOutput, error) {
	req, out := c.DeleteUserByPrincipalIdRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGroup = "DescribeGroup"

// DescribeGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGroup for more information on using the DescribeGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeGroupRequest method.
//    req, resp := client.DescribeGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeGroup
func (c *QuickSight) DescribeGroupRequest(input *DescribeGroupInput) (req *request.Request, output *DescribeGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}",
	}

	if input == nil {
		input = &DescribeGroupInput{}
	}

	output = &DescribeGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGroup API operation for Amazon QuickSight.
//
// Returns an Amazon QuickSight group's description and Amazon Resource Name
// (ARN).
//
// The permissions resource is arn:aws:quicksight:us-east-1:<relevant-aws-account-id>:group/default/<group-name> .
//
// The response is the group object.
//
// CLI Sample:
//
// aws quicksight describe-group -\-aws-account-id=11112222333 -\-namespace=default
// -\-group-name=Sales
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodePreconditionNotMetException "PreconditionNotMetException"
//   One or more preconditions aren't met.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeGroup
func (c *QuickSight) DescribeGroup(input *DescribeGroupInput) (*DescribeGroupOutput, error) {
	req, out := c.DescribeGroupRequest(input)
	return out, req.Send()
}

// DescribeGroupWithContext is the same as DescribeGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeGroupWithContext(ctx aws.Context, input *DescribeGroupInput, opts ...request.Option) (*DescribeGroupOutput, error) {
	req, out := c.DescribeGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUser = "DescribeUser"

// DescribeUserRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUser for more information on using the DescribeUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUserRequest method.
//    req, resp := client.DescribeUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeUser
func (c *QuickSight) DescribeUserRequest(input *DescribeUserInput) (req *request.Request, output *DescribeUserOutput) {
	op := &request.Operation{
		Name:       opDescribeUser,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}",
	}

	if input == nil {
		input = &DescribeUserInput{}
	}

	output = &DescribeUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUser API operation for Amazon QuickSight.
//
// Returns information about a user, given the user name.
//
// The permission resource is arn:aws:quicksight:us-east-1:<aws-account-id>:user/default/<user-name> .
//
// The response is a user object that contains the user's Amazon Resource Name
// (ARN), AWS Identity and Access Management (IAM) role, and email address.
//
// CLI Sample:
//
// aws quicksight describe-user --aws-account-id=111122223333 --namespace=default
// --user-name=Pat
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeUser
func (c *QuickSight) DescribeUser(input *DescribeUserInput) (*DescribeUserOutput, error) {
	req, out := c.DescribeUserRequest(input)
	return out, req.Send()
}

// DescribeUserWithContext is the same as DescribeUser with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeUserWithContext(ctx aws.Context, input *DescribeUserInput, opts ...request.Option) (*DescribeUserOutput, error) {
	req, out := c.DescribeUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDashboardEmbedUrl = "GetDashboardEmbedUrl"

// GetDashboardEmbedUrlRequest generates a "aws/request.Request" representing the
// client's request for the GetDashboardEmbedUrl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDashboardEmbedUrl for more information on using the GetDashboardEmbedUrl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDashboardEmbedUrlRequest method.
//    req, resp := client.GetDashboardEmbedUrlRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GetDashboardEmbedUrl
func (c *QuickSight) GetDashboardEmbedUrlRequest(input *GetDashboardEmbedUrlInput) (req *request.Request, output *GetDashboardEmbedUrlOutput) {
	op := &request.Operation{
		Name:       opGetDashboardEmbedUrl,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}/embed-url",
	}

	if input == nil {
		input = &GetDashboardEmbedUrlInput{}
	}

	output = &GetDashboardEmbedUrlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDashboardEmbedUrl API operation for Amazon QuickSight.
//
// Generates a server-side embeddable URL and authorization code. Before this
// can work properly, first you need to configure the dashboards and user permissions.
// For more information, see Embedding Amazon QuickSight Dashboards (https://docs.aws.amazon.com/en_us/quicksight/latest/user/embedding.html).
//
// Currently, you can use GetDashboardEmbedURL only from the server, not from
// the user’s browser.
//
// CLI Sample:
//
// Assume the role with permissions enabled for actions: quickSight:RegisterUser
// and quicksight:GetDashboardEmbedURL. You can use assume-role, assume-role-with-web-identity,
// or assume-role-with-saml.
//
// aws sts assume-role --role-arn "arn:aws:iam::111122223333:role/embedding_quicksight_dashboard_role"
// --role-session-name embeddingsession
//
// If the user does not exist in QuickSight, register the user:
//
// aws quicksight register-user --aws-account-id 111122223333 --namespace default
// --identity-type IAM --iam-arn "arn:aws:iam::111122223333:role/embedding_quicksight_dashboard_role"
// --user-role READER --session-name "embeddingsession" --email user123@example.com
// --region us-east-1
//
// Get the URL for the embedded dashboard
//
// aws quicksight get-dashboard-embed-url --aws-account-id 111122223333 --dashboard-id
// 1a1ac2b2-3fc3-4b44-5e5d-c6db6778df89 --identity-type IAM
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation GetDashboardEmbedUrl for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceExistsException "ResourceExistsException"
//   The resource specified doesn't exist.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodePreconditionNotMetException "PreconditionNotMetException"
//   One or more preconditions aren't met.
//
//   * ErrCodeDomainNotWhitelistedException "DomainNotWhitelistedException"
//   The domain specified is not on the allowlist. All domains for embedded dashboards
//   must be added to the approved list by an Amazon QuickSight admin.
//
//   * ErrCodeUserNotFoundException "QuickSightUserNotFoundException"
//   The user is not found. This error can happen in any operation that requires
//   finding a user based on a provided user name, such as DeleteUser, DescribeUser,
//   and so on.
//
//   * ErrCodeIdentityTypeNotSupportedException "IdentityTypeNotSupportedException"
//   The identity type specified is not supported. Supported identity types include
//   IAM and QUICKSIGHT.
//
//   * ErrCodeSessionLifetimeInMinutesInvalidException "SessionLifetimeInMinutesInvalidException"
//   The number of minutes specified for the lifetime of a session is not valid.
//   The session lifetime must be from 15 to 600 minutes.
//
//   * ErrCodeUnsupportedUserEditionException "UnsupportedUserEditionException"
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GetDashboardEmbedUrl
func (c *QuickSight) GetDashboardEmbedUrl(input *GetDashboardEmbedUrlInput) (*GetDashboardEmbedUrlOutput, error) {
	req, out := c.GetDashboardEmbedUrlRequest(input)
	return out, req.Send()
}

// GetDashboardEmbedUrlWithContext is the same as GetDashboardEmbedUrl with the addition of
// the ability to pass a context and additional request options.
//
// See GetDashboardEmbedUrl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) GetDashboardEmbedUrlWithContext(ctx aws.Context, input *GetDashboardEmbedUrlInput, opts ...request.Option) (*GetDashboardEmbedUrlOutput, error) {
	req, out := c.GetDashboardEmbedUrlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGroupMemberships = "ListGroupMemberships"

// ListGroupMembershipsRequest generates a "aws/request.Request" representing the
// client's request for the ListGroupMemberships operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroupMemberships for more information on using the ListGroupMemberships
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGroupMembershipsRequest method.
//    req, resp := client.ListGroupMembershipsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroupMemberships
func (c *QuickSight) ListGroupMembershipsRequest(input *ListGroupMembershipsInput) (req *request.Request, output *ListGroupMembershipsOutput) {
	op := &request.Operation{
		Name:       opListGroupMemberships,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members",
	}

	if input == nil {
		input = &ListGroupMembershipsInput{}
	}

	output = &ListGroupMembershipsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroupMemberships API operation for Amazon QuickSight.
//
// Lists member users in a group.
//
// The permissions resource is arn:aws:quicksight:us-east-1:<aws-account-id>:group/default/<group-name> .
//
// The response is a list of group member objects.
//
// CLI Sample:
//
// aws quicksight list-group-memberships -\-aws-account-id=111122223333 -\-namespace=default
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListGroupMemberships for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The NextToken value isn't valid.
//
//   * ErrCodePreconditionNotMetException "PreconditionNotMetException"
//   One or more preconditions aren't met.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroupMemberships
func (c *QuickSight) ListGroupMemberships(input *ListGroupMembershipsInput) (*ListGroupMembershipsOutput, error) {
	req, out := c.ListGroupMembershipsRequest(input)
	return out, req.Send()
}

// ListGroupMembershipsWithContext is the same as ListGroupMemberships with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroupMemberships for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListGroupMembershipsWithContext(ctx aws.Context, input *ListGroupMembershipsInput, opts ...request.Option) (*ListGroupMembershipsOutput, error) {
	req, out := c.ListGroupMembershipsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGroups = "ListGroups"

// ListGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroups for more information on using the ListGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGroupsRequest method.
//    req, resp := client.ListGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroups
func (c *QuickSight) ListGroupsRequest(input *ListGroupsInput) (req *request.Request, output *ListGroupsOutput) {
	op := &request.Operation{
		Name:       opListGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups",
	}

	if input == nil {
		input = &ListGroupsInput{}
	}

	output = &ListGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroups API operation for Amazon QuickSight.
//
// Lists all user groups in Amazon QuickSight.
//
// The permissions resource is arn:aws:quicksight:us-east-1:<aws-account-id>:group/default/*.
//
// The response is a list of group objects.
//
// CLI Sample:
//
// aws quicksight list-groups -\-aws-account-id=111122223333 -\-namespace=default
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The NextToken value isn't valid.
//
//   * ErrCodePreconditionNotMetException "PreconditionNotMetException"
//   One or more preconditions aren't met.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroups
func (c *QuickSight) ListGroups(input *ListGroupsInput) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	return out, req.Send()
}

// ListGroupsWithContext is the same as ListGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListGroupsWithContext(ctx aws.Context, input *ListGroupsInput, opts ...request.Option) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListUserGroups = "ListUserGroups"

// ListUserGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListUserGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUserGroups for more information on using the ListUserGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUserGroupsRequest method.
//    req, resp := client.ListUserGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUserGroups
func (c *QuickSight) ListUserGroupsRequest(input *ListUserGroupsInput) (req *request.Request, output *ListUserGroupsOutput) {
	op := &request.Operation{
		Name:       opListUserGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}/groups",
	}

	if input == nil {
		input = &ListUserGroupsInput{}
	}

	output = &ListUserGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUserGroups API operation for Amazon QuickSight.
//
// Lists the Amazon QuickSight groups that an Amazon QuickSight user is a member
// of.
//
// The permission resource is arn:aws:quicksight:us-east-1:<aws-account-id>:user/default/<user-name> .
//
// The response is a one or more group objects.
//
// CLI Sample:
//
// aws quicksight list-user-groups -\-user-name=Pat -\-aws-account-id=111122223333
// -\-namespace=default -\-region=us-east-1
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListUserGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUserGroups
func (c *QuickSight) ListUserGroups(input *ListUserGroupsInput) (*ListUserGroupsOutput, error) {
	req, out := c.ListUserGroupsRequest(input)
	return out, req.Send()
}

// ListUserGroupsWithContext is the same as ListUserGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListUserGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListUserGroupsWithContext(ctx aws.Context, input *ListUserGroupsInput, opts ...request.Option) (*ListUserGroupsOutput, error) {
	req, out := c.ListUserGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListUsers = "ListUsers"

// ListUsersRequest generates a "aws/request.Request" representing the
// client's request for the ListUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUsers for more information on using the ListUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUsersRequest method.
//    req, resp := client.ListUsersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUsers
func (c *QuickSight) ListUsersRequest(input *ListUsersInput) (req *request.Request, output *ListUsersOutput) {
	op := &request.Operation{
		Name:       opListUsers,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users",
	}

	if input == nil {
		input = &ListUsersInput{}
	}

	output = &ListUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUsers API operation for Amazon QuickSight.
//
// Returns a list of all of the Amazon QuickSight users belonging to this account.
//
// The permission resource is arn:aws:quicksight:us-east-1:<aws-account-id>:user/default/* .
//
// The response is a list of user objects, containing each user's Amazon Resource
// Name (ARN), AWS Identity and Access Management (IAM) role, and email address.
//
// CLI Sample:
//
// aws quicksight list-users --aws-account-id=111122223333 --namespace=default
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListUsers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The NextToken value isn't valid.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUsers
func (c *QuickSight) ListUsers(input *ListUsersInput) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	return out, req.Send()
}

// ListUsersWithContext is the same as ListUsers with the addition of
// the ability to pass a context and additional request options.
//
// See ListUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListUsersWithContext(ctx aws.Context, input *ListUsersInput, opts ...request.Option) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterUser = "RegisterUser"

// RegisterUserRequest generates a "aws/request.Request" representing the
// client's request for the RegisterUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterUser for more information on using the RegisterUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterUserRequest method.
//    req, resp := client.RegisterUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/RegisterUser
func (c *QuickSight) RegisterUserRequest(input *RegisterUserInput) (req *request.Request, output *RegisterUserOutput) {
	op := &request.Operation{
		Name:       opRegisterUser,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users",
	}

	if input == nil {
		input = &RegisterUserInput{}
	}

	output = &RegisterUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterUser API operation for Amazon QuickSight.
//
// Creates an Amazon QuickSight user, whose identity is associated with the
// AWS Identity and Access Management (IAM) identity or role specified in the
// request.
//
// The permission resource is arn:aws:quicksight:us-east-1:<aws-account-id>:user/default/<user-name> .
//
// The condition resource is the Amazon Resource Name (ARN) for the IAM user
// or role, and the session name.
//
// The condition keys are quicksight:IamArn and quicksight:SessionName.
//
// CLI Sample:
//
// aws quicksight register-user -\-aws-account-id=111122223333 -\-namespace=default
// -\-email=pat@example.com -\-identity-type=IAM -\-user-role=AUTHOR -\-iam-arn=arn:aws:iam::111122223333:user/Pat
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation RegisterUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit is exceeded.
//
//   * ErrCodeResourceExistsException "ResourceExistsException"
//   The resource specified doesn't exist.
//
//   * ErrCodePreconditionNotMetException "PreconditionNotMetException"
//   One or more preconditions aren't met.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/RegisterUser
func (c *QuickSight) RegisterUser(input *RegisterUserInput) (*RegisterUserOutput, error) {
	req, out := c.RegisterUserRequest(input)
	return out, req.Send()
}

// RegisterUserWithContext is the same as RegisterUser with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) RegisterUserWithContext(ctx aws.Context, input *RegisterUserInput, opts ...request.Option) (*RegisterUserOutput, error) {
	req, out := c.RegisterUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGroup = "UpdateGroup"

// UpdateGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGroup for more information on using the UpdateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGroupRequest method.
//    req, resp := client.UpdateGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateGroup
func (c *QuickSight) UpdateGroupRequest(input *UpdateGroupInput) (req *request.Request, output *UpdateGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}",
	}

	if input == nil {
		input = &UpdateGroupInput{}
	}

	output = &UpdateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGroup API operation for Amazon QuickSight.
//
// Changes a group description.
//
// The permissions resource is arn:aws:quicksight:us-east-1:<aws-account-id>:group/default/<group-name> .
//
// The response is a group object.
//
// CLI Sample:
//
// aws quicksight update-group --aws-account-id=111122223333 --namespace=default
// --group-name=Sales --description="Sales BI Dashboards"
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodePreconditionNotMetException "PreconditionNotMetException"
//   One or more preconditions aren't met.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateGroup
func (c *QuickSight) UpdateGroup(input *UpdateGroupInput) (*UpdateGroupOutput, error) {
	req, out := c.UpdateGroupRequest(input)
	return out, req.Send()
}

// UpdateGroupWithContext is the same as UpdateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateGroupWithContext(ctx aws.Context, input *UpdateGroupInput, opts ...request.Option) (*UpdateGroupOutput, error) {
	req, out := c.UpdateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUser = "UpdateUser"

// UpdateUserRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUser for more information on using the UpdateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserRequest method.
//    req, resp := client.UpdateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateUser
func (c *QuickSight) UpdateUserRequest(input *UpdateUserInput) (req *request.Request, output *UpdateUserOutput) {
	op := &request.Operation{
		Name:       opUpdateUser,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}",
	}

	if input == nil {
		input = &UpdateUserInput{}
	}

	output = &UpdateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateUser API operation for Amazon QuickSight.
//
// Updates an Amazon QuickSight user.
//
// The permission resource is arn:aws:quicksight:us-east-1:<aws-account-id>:user/default/<user-name> .
//
// The response is a user object that contains the user's Amazon QuickSight
// user name, email address, active or inactive status in Amazon QuickSight,
// Amazon QuickSight role, and Amazon Resource Name (ARN).
//
// CLI Sample:
//
// aws quicksight update-user --user-name=Pat --role=ADMIN --email=new_address@amazon.com
// --aws-account-id=111122223333 --namespace=default --region=us-east-1
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have access to this. The provided credentials couldn't be validated.
//   You might not be authorized to carry out the request. Ensure that your account
//   is authorized to use the Amazon QuickSight service, that your policies have
//   the correct permissions, and that you are using the correct access keys.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more parameters don't have a valid value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   One or more resources can't be found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Access is throttled.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   An internal failure occurred.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateUser
func (c *QuickSight) UpdateUser(input *UpdateUserInput) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	return out, req.Send()
}

// UpdateUserWithContext is the same as UpdateUser with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateUserWithContext(ctx aws.Context, input *UpdateUserInput, opts ...request.Option) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The request object for this operation.
type CreateGroupInput struct {
	_ struct{} `type:"structure"`

	// The ID for the AWS account that the group is in. Currently, you use the ID
	// for the AWS account that contains your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// A description for the group that you want to create.
	Description *string `min:"1" type:"string"`

	// A name for the group that you want to create.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGroupInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateGroupInput) SetAwsAccountId(v string) *CreateGroupInput {
	s.AwsAccountId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateGroupInput) SetDescription(v string) *CreateGroupInput {
	s.Description = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *CreateGroupInput) SetGroupName(v string) *CreateGroupInput {
	s.GroupName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CreateGroupInput) SetNamespace(v string) *CreateGroupInput {
	s.Namespace = &v
	return s
}

type CreateGroupMembershipInput struct {
	_ struct{} `type:"structure"`

	// The ID for the AWS account that the group is in. Currently, you use the ID
	// for the AWS account that contains your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The name of the group that you want to add the user to.
	//
	// GroupName is a required field
	GroupName *string `location:"uri" locationName:"GroupName" min:"1" type:"string" required:"true"`

	// The name of the user that you want to add to the group membership.
	//
	// MemberName is a required field
	MemberName *string `location:"uri" locationName:"MemberName" min:"1" type:"string" required:"true"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateGroupMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGroupMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGroupMembershipInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.MemberName == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberName"))
	}
	if s.MemberName != nil && len(*s.MemberName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateGroupMembershipInput) SetAwsAccountId(v string) *CreateGroupMembershipInput {
	s.AwsAccountId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *CreateGroupMembershipInput) SetGroupName(v string) *CreateGroupMembershipInput {
	s.GroupName = &v
	return s
}

// SetMemberName sets the MemberName field's value.
func (s *CreateGroupMembershipInput) SetMemberName(v string) *CreateGroupMembershipInput {
	s.MemberName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CreateGroupMembershipInput) SetNamespace(v string) *CreateGroupMembershipInput {
	s.Namespace = &v
	return s
}

type CreateGroupMembershipOutput struct {
	_ struct{} `type:"structure"`

	// The group member.
	GroupMember *GroupMember `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The http status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s CreateGroupMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupMembershipOutput) GoString() string {
	return s.String()
}

// SetGroupMember sets the GroupMember field's value.
func (s *CreateGroupMembershipOutput) SetGroupMember(v *GroupMember) *CreateGroupMembershipOutput {
	s.GroupMember = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateGroupMembershipOutput) SetRequestId(v string) *CreateGroupMembershipOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateGroupMembershipOutput) SetStatus(v int64) *CreateGroupMembershipOutput {
	s.Status = &v
	return s
}

// The response object for this operation.
type CreateGroupOutput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	Group *Group `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The http status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s CreateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupOutput) GoString() string {
	return s.String()
}

// SetGroup sets the Group field's value.
func (s *CreateGroupOutput) SetGroup(v *Group) *CreateGroupOutput {
	s.Group = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateGroupOutput) SetRequestId(v string) *CreateGroupOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateGroupOutput) SetStatus(v int64) *CreateGroupOutput {
	s.Status = &v
	return s
}

type DeleteGroupInput struct {
	_ struct{} `type:"structure"`

	// The ID for the AWS account that the group is in. Currently, you use the ID
	// for the AWS account that contains your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The name of the group that you want to delete.
	//
	// GroupName is a required field
	GroupName *string `location:"uri" locationName:"GroupName" min:"1" type:"string" required:"true"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGroupInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteGroupInput) SetAwsAccountId(v string) *DeleteGroupInput {
	s.AwsAccountId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *DeleteGroupInput) SetGroupName(v string) *DeleteGroupInput {
	s.GroupName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DeleteGroupInput) SetNamespace(v string) *DeleteGroupInput {
	s.Namespace = &v
	return s
}

type DeleteGroupMembershipInput struct {
	_ struct{} `type:"structure"`

	// The ID for the AWS account that the group is in. Currently, you use the ID
	// for the AWS account that contains your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The name of the group that you want to delete the user from.
	//
	// GroupName is a required field
	GroupName *string `location:"uri" locationName:"GroupName" min:"1" type:"string" required:"true"`

	// The name of the user that you want to delete from the group membership.
	//
	// MemberName is a required field
	MemberName *string `location:"uri" locationName:"MemberName" min:"1" type:"string" required:"true"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGroupMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGroupMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGroupMembershipInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.MemberName == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberName"))
	}
	if s.MemberName != nil && len(*s.MemberName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteGroupMembershipInput) SetAwsAccountId(v string) *DeleteGroupMembershipInput {
	s.AwsAccountId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *DeleteGroupMembershipInput) SetGroupName(v string) *DeleteGroupMembershipInput {
	s.GroupName = &v
	return s
}

// SetMemberName sets the MemberName field's value.
func (s *DeleteGroupMembershipInput) SetMemberName(v string) *DeleteGroupMembershipInput {
	s.MemberName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DeleteGroupMembershipInput) SetNamespace(v string) *DeleteGroupMembershipInput {
	s.Namespace = &v
	return s
}

type DeleteGroupMembershipOutput struct {
	_ struct{} `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The http status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s DeleteGroupMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupMembershipOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteGroupMembershipOutput) SetRequestId(v string) *DeleteGroupMembershipOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteGroupMembershipOutput) SetStatus(v int64) *DeleteGroupMembershipOutput {
	s.Status = &v
	return s
}

type DeleteGroupOutput struct {
	_ struct{} `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The http status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s DeleteGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteGroupOutput) SetRequestId(v string) *DeleteGroupOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteGroupOutput) SetStatus(v int64) *DeleteGroupOutput {
	s.Status = &v
	return s
}

type DeleteUserByPrincipalIdInput struct {
	_ struct{} `type:"structure"`

	// The ID for the AWS account that the user is in. Currently, you use the ID
	// for the AWS account that contains your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`

	// The principal ID of the user.
	//
	// PrincipalId is a required field
	PrincipalId *string `location:"uri" locationName:"PrincipalId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserByPrincipalIdInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserByPrincipalIdInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserByPrincipalIdInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserByPrincipalIdInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.PrincipalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalId"))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteUserByPrincipalIdInput) SetAwsAccountId(v string) *DeleteUserByPrincipalIdInput {
	s.AwsAccountId = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DeleteUserByPrincipalIdInput) SetNamespace(v string) *DeleteUserByPrincipalIdInput {
	s.Namespace = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *DeleteUserByPrincipalIdInput) SetPrincipalId(v string) *DeleteUserByPrincipalIdInput {
	s.PrincipalId = &v
	return s
}

type DeleteUserByPrincipalIdOutput struct {
	_ struct{} `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The http status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s DeleteUserByPrincipalIdOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserByPrincipalIdOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteUserByPrincipalIdOutput) SetRequestId(v string) *DeleteUserByPrincipalIdOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteUserByPrincipalIdOutput) SetStatus(v int64) *DeleteUserByPrincipalIdOutput {
	s.Status = &v
	return s
}

type DeleteUserInput struct {
	_ struct{} `type:"structure"`

	// The ID for the AWS account that the user is in. Currently, you use the ID
	// for the AWS account that contains your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`

	// The name of the user that you want to delete.
	//
	// UserName is a required field
	UserName *string `location:"uri" locationName:"UserName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteUserInput) SetAwsAccountId(v string) *DeleteUserInput {
	s.AwsAccountId = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DeleteUserInput) SetNamespace(v string) *DeleteUserInput {
	s.Namespace = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DeleteUserInput) SetUserName(v string) *DeleteUserInput {
	s.UserName = &v
	return s
}

type DeleteUserOutput struct {
	_ struct{} `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The http status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s DeleteUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteUserOutput) SetRequestId(v string) *DeleteUserOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteUserOutput) SetStatus(v int64) *DeleteUserOutput {
	s.Status = &v
	return s
}

type DescribeGroupInput struct {
	_ struct{} `type:"structure"`

	// The ID for the AWS account that the group is in. Currently, you use the ID
	// for the AWS account that contains your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The name of the group that you want to describe.
	//
	// GroupName is a required field
	GroupName *string `location:"uri" locationName:"GroupName" min:"1" type:"string" required:"true"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGroupInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeGroupInput) SetAwsAccountId(v string) *DescribeGroupInput {
	s.AwsAccountId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *DescribeGroupInput) SetGroupName(v string) *DescribeGroupInput {
	s.GroupName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DescribeGroupInput) SetNamespace(v string) *DescribeGroupInput {
	s.Namespace = &v
	return s
}

type DescribeGroupOutput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	Group *Group `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The http status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s DescribeGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGroupOutput) GoString() string {
	return s.String()
}

// SetGroup sets the Group field's value.
func (s *DescribeGroupOutput) SetGroup(v *Group) *DescribeGroupOutput {
	s.Group = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeGroupOutput) SetRequestId(v string) *DescribeGroupOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeGroupOutput) SetStatus(v int64) *DescribeGroupOutput {
	s.Status = &v
	return s
}

type DescribeUserInput struct {
	_ struct{} `type:"structure"`

	// The ID for the AWS account that the user is in. Currently, you use the ID
	// for the AWS account that contains your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`

	// The name of the user that you want to describe.
	//
	// UserName is a required field
	UserName *string `location:"uri" locationName:"UserName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUserInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeUserInput) SetAwsAccountId(v string) *DescribeUserInput {
	s.AwsAccountId = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DescribeUserInput) SetNamespace(v string) *DescribeUserInput {
	s.Namespace = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DescribeUserInput) SetUserName(v string) *DescribeUserInput {
	s.UserName = &v
	return s
}

type DescribeUserOutput struct {
	_ struct{} `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The http status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The user name.
	User *User `type:"structure"`
}

// String returns the string representation
func (s DescribeUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeUserOutput) SetRequestId(v string) *DescribeUserOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeUserOutput) SetStatus(v int64) *DescribeUserOutput {
	s.Status = &v
	return s
}

// SetUser sets the User field's value.
func (s *DescribeUserOutput) SetUser(v *User) *DescribeUserOutput {
	s.User = v
	return s
}

type GetDashboardEmbedUrlInput struct {
	_ struct{} `type:"structure"`

	// AWS account ID that contains the dashboard you are embedding.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the dashboard, also added to IAM policy
	//
	// DashboardId is a required field
	DashboardId *string `location:"uri" locationName:"DashboardId" type:"string" required:"true"`

	// The authentication method the user uses to sign in (IAM only).
	//
	// IdentityType is a required field
	IdentityType *string `location:"querystring" locationName:"creds-type" type:"string" required:"true" enum:"IdentityType"`

	// Remove the reset button on embedded dashboard. The default is FALSE, which
	// allows the reset button.
	ResetDisabled *bool `location:"querystring" locationName:"reset-disabled" type:"boolean"`

	// How many minutes the session is valid. The session lifetime must be between
	// 15 and 600 minutes.
	SessionLifetimeInMinutes *int64 `location:"querystring" locationName:"session-lifetime" min:"15" type:"long"`

	// Remove the undo/redo button on embedded dashboard. The default is FALSE,
	// which enables the undo/redo button.
	UndoRedoDisabled *bool `location:"querystring" locationName:"undo-redo-disabled" type:"boolean"`
}

// String returns the string representation
func (s GetDashboardEmbedUrlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDashboardEmbedUrlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDashboardEmbedUrlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDashboardEmbedUrlInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DashboardId == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardId"))
	}
	if s.DashboardId != nil && len(*s.DashboardId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardId", 1))
	}
	if s.IdentityType == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityType"))
	}
	if s.SessionLifetimeInMinutes != nil && *s.SessionLifetimeInMinutes < 15 {
		invalidParams.Add(request.NewErrParamMinValue("SessionLifetimeInMinutes", 15))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *GetDashboardEmbedUrlInput) SetAwsAccountId(v string) *GetDashboardEmbedUrlInput {
	s.AwsAccountId = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *GetDashboardEmbedUrlInput) SetDashboardId(v string) *GetDashboardEmbedUrlInput {
	s.DashboardId = &v
	return s
}

// SetIdentityType sets the IdentityType field's value.
func (s *GetDashboardEmbedUrlInput) SetIdentityType(v string) *GetDashboardEmbedUrlInput {
	s.IdentityType = &v
	return s
}

// SetResetDisabled sets the ResetDisabled field's value.
func (s *GetDashboardEmbedUrlInput) SetResetDisabled(v bool) *GetDashboardEmbedUrlInput {
	s.ResetDisabled = &v
	return s
}

// SetSessionLifetimeInMinutes sets the SessionLifetimeInMinutes field's value.
func (s *GetDashboardEmbedUrlInput) SetSessionLifetimeInMinutes(v int64) *GetDashboardEmbedUrlInput {
	s.SessionLifetimeInMinutes = &v
	return s
}

// SetUndoRedoDisabled sets the UndoRedoDisabled field's value.
func (s *GetDashboardEmbedUrlInput) SetUndoRedoDisabled(v bool) *GetDashboardEmbedUrlInput {
	s.UndoRedoDisabled = &v
	return s
}

type GetDashboardEmbedUrlOutput struct {
	_ struct{} `type:"structure"`

	// URL that you can put into your server-side webpage to embed your dashboard.
	// This URL is valid for 5 minutes, and the resulting session is valid for 10
	// hours. The API provides the URL with an auth_code that enables a single-signon
	// session.
	EmbedUrl *string `type:"string" sensitive:"true"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The http status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s GetDashboardEmbedUrlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDashboardEmbedUrlOutput) GoString() string {
	return s.String()
}

// SetEmbedUrl sets the EmbedUrl field's value.
func (s *GetDashboardEmbedUrlOutput) SetEmbedUrl(v string) *GetDashboardEmbedUrlOutput {
	s.EmbedUrl = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *GetDashboardEmbedUrlOutput) SetRequestId(v string) *GetDashboardEmbedUrlOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetDashboardEmbedUrlOutput) SetStatus(v int64) *GetDashboardEmbedUrlOutput {
	s.Status = &v
	return s
}

// A group in Amazon QuickSight consists of a set of users. You can use groups
// to make it easier to manage access and security. Currently, an Amazon QuickSight
// subscription can't contain more than 500 Amazon QuickSight groups.
type Group struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the group.
	Arn *string `type:"string"`

	// The group description.
	Description *string `min:"1" type:"string"`

	// The name of the group.
	GroupName *string `min:"1" type:"string"`

	// The principal ID of the group.
	PrincipalId *string `type:"string"`
}

// String returns the string representation
func (s Group) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Group) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Group) SetArn(v string) *Group {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Group) SetDescription(v string) *Group {
	s.Description = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *Group) SetGroupName(v string) *Group {
	s.GroupName = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *Group) SetPrincipalId(v string) *Group {
	s.PrincipalId = &v
	return s
}

// A member of an Amazon QuickSight group. Currently, group members must be
// users. Groups can't be members of another group.
type GroupMember struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the group member (user).
	Arn *string `type:"string"`

	// The name of the group member (user).
	MemberName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GroupMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupMember) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GroupMember) SetArn(v string) *GroupMember {
	s.Arn = &v
	return s
}

// SetMemberName sets the MemberName field's value.
func (s *GroupMember) SetMemberName(v string) *GroupMember {
	s.MemberName = &v
	return s
}

type ListGroupMembershipsInput struct {
	_ struct{} `type:"structure"`

	// The ID for the AWS account that the group is in. Currently, you use the ID
	// for the AWS account that contains your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The name of the group that you want to see a membership list of.
	//
	// GroupName is a required field
	GroupName *string `location:"uri" locationName:"GroupName" min:"1" type:"string" required:"true"`

	// The maximum number of results to return from this request.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`

	// A pagination token that can be used in a subsequent request.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation
func (s ListGroupMembershipsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupMembershipsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGroupMembershipsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGroupMembershipsInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *ListGroupMembershipsInput) SetAwsAccountId(v string) *ListGroupMembershipsInput {
	s.AwsAccountId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *ListGroupMembershipsInput) SetGroupName(v string) *ListGroupMembershipsInput {
	s.GroupName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGroupMembershipsInput) SetMaxResults(v int64) *ListGroupMembershipsInput {
	s.MaxResults = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ListGroupMembershipsInput) SetNamespace(v string) *ListGroupMembershipsInput {
	s.Namespace = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupMembershipsInput) SetNextToken(v string) *ListGroupMembershipsInput {
	s.NextToken = &v
	return s
}

type ListGroupMembershipsOutput struct {
	_ struct{} `type:"structure"`

	// The list of the members of the group.
	GroupMemberList []*GroupMember `type:"list"`

	// A pagination token that can be used in a subsequent request.
	NextToken *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The http status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s ListGroupMembershipsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupMembershipsOutput) GoString() string {
	return s.String()
}

// SetGroupMemberList sets the GroupMemberList field's value.
func (s *ListGroupMembershipsOutput) SetGroupMemberList(v []*GroupMember) *ListGroupMembershipsOutput {
	s.GroupMemberList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupMembershipsOutput) SetNextToken(v string) *ListGroupMembershipsOutput {
	s.NextToken = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ListGroupMembershipsOutput) SetRequestId(v string) *ListGroupMembershipsOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListGroupMembershipsOutput) SetStatus(v int64) *ListGroupMembershipsOutput {
	s.Status = &v
	return s
}

type ListGroupsInput struct {
	_ struct{} `type:"structure"`

	// The ID for the AWS account that the group is in. Currently, you use the ID
	// for the AWS account that contains your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The maximum number of results to return.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`

	// A pagination token that can be used in a subsequent request.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation
func (s ListGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGroupsInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *ListGroupsInput) SetAwsAccountId(v string) *ListGroupsInput {
	s.AwsAccountId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGroupsInput) SetMaxResults(v int64) *ListGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ListGroupsInput) SetNamespace(v string) *ListGroupsInput {
	s.Namespace = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupsInput) SetNextToken(v string) *ListGroupsInput {
	s.NextToken = &v
	return s
}

type ListGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The list of the groups.
	GroupList []*Group `type:"list"`

	// A pagination token that can be used in a subsequent request.
	NextToken *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The http status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s ListGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupsOutput) GoString() string {
	return s.String()
}

// SetGroupList sets the GroupList field's value.
func (s *ListGroupsOutput) SetGroupList(v []*Group) *ListGroupsOutput {
	s.GroupList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupsOutput) SetNextToken(v string) *ListGroupsOutput {
	s.NextToken = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ListGroupsOutput) SetRequestId(v string) *ListGroupsOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListGroupsOutput) SetStatus(v int64) *ListGroupsOutput {
	s.Status = &v
	return s
}

type ListUserGroupsInput struct {
	_ struct{} `type:"structure"`

	// The AWS Account ID that the user is in. Currently, you use the ID for the
	// AWS account that contains your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The maximum number of results to return from this request.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`

	// A pagination token that can be used in a subsequent request.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	// The Amazon QuickSight user name that you want to list group memberships for.
	//
	// UserName is a required field
	UserName *string `location:"uri" locationName:"UserName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListUserGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUserGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUserGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUserGroupsInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *ListUserGroupsInput) SetAwsAccountId(v string) *ListUserGroupsInput {
	s.AwsAccountId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUserGroupsInput) SetMaxResults(v int64) *ListUserGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ListUserGroupsInput) SetNamespace(v string) *ListUserGroupsInput {
	s.Namespace = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUserGroupsInput) SetNextToken(v string) *ListUserGroupsInput {
	s.NextToken = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *ListUserGroupsInput) SetUserName(v string) *ListUserGroupsInput {
	s.UserName = &v
	return s
}

type ListUserGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The list of groups the user is a member of.
	GroupList []*Group `type:"list"`

	// A pagination token that can be used in a subsequent request.
	NextToken *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s ListUserGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUserGroupsOutput) GoString() string {
	return s.String()
}

// SetGroupList sets the GroupList field's value.
func (s *ListUserGroupsOutput) SetGroupList(v []*Group) *ListUserGroupsOutput {
	s.GroupList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUserGroupsOutput) SetNextToken(v string) *ListUserGroupsOutput {
	s.NextToken = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ListUserGroupsOutput) SetRequestId(v string) *ListUserGroupsOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListUserGroupsOutput) SetStatus(v int64) *ListUserGroupsOutput {
	s.Status = &v
	return s
}

type ListUsersInput struct {
	_ struct{} `type:"structure"`

	// The ID for the AWS account that the user is in. Currently, you use the ID
	// for the AWS account that contains your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The maximum number of results to return from this request.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`

	// A pagination token that can be used in a subsequent request.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation
func (s ListUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUsersInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *ListUsersInput) SetAwsAccountId(v string) *ListUsersInput {
	s.AwsAccountId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUsersInput) SetMaxResults(v int64) *ListUsersInput {
	s.MaxResults = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ListUsersInput) SetNamespace(v string) *ListUsersInput {
	s.Namespace = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsersInput) SetNextToken(v string) *ListUsersInput {
	s.NextToken = &v
	return s
}

type ListUsersOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token that can be used in a subsequent request.
	NextToken *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The http status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The list of users.
	UserList []*User `type:"list"`
}

// String returns the string representation
func (s ListUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsersOutput) SetNextToken(v string) *ListUsersOutput {
	s.NextToken = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ListUsersOutput) SetRequestId(v string) *ListUsersOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListUsersOutput) SetStatus(v int64) *ListUsersOutput {
	s.Status = &v
	return s
}

// SetUserList sets the UserList field's value.
func (s *ListUsersOutput) SetUserList(v []*User) *ListUsersOutput {
	s.UserList = v
	return s
}

type RegisterUserInput struct {
	_ struct{} `type:"structure"`

	// The ID for the AWS account that the user is in. Currently, you use the ID
	// for the AWS account that contains your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The email address of the user that you want to register.
	//
	// Email is a required field
	Email *string `type:"string" required:"true"`

	// The ARN of the IAM user or role that you are registering with Amazon QuickSight.
	IamArn *string `type:"string"`

	// Amazon QuickSight supports several ways of managing the identity of users.
	// This parameter accepts two values:
	//
	//    * IAM: A user whose identity maps to an existing IAM user or role.
	//
	//    * QUICKSIGHT: A user whose identity is owned and managed internally by
	//    Amazon QuickSight.
	//
	// IdentityType is a required field
	IdentityType *string `type:"string" required:"true" enum:"IdentityType"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`

	// The name of the session with the assumed IAM role. By using this parameter,
	// you can register multiple users with the same IAM role, provided that each
	// has a different session name. For more information on assuming IAM roles,
	// see assume-role (https://docs.aws.amazon.com/cli/latest/reference/sts/assume-role.html)
	// in the AWS CLI Reference.
	SessionName *string `min:"2" type:"string"`

	// The Amazon QuickSight user name that you want to create for the user you
	// are registering.
	UserName *string `min:"1" type:"string"`

	// The Amazon QuickSight role of the user. The user role can be one of the following:
	//
	//    * READER: A user who has read-only access to dashboards.
	//
	//    * AUTHOR: A user who can create data sources, data sets, analyses, and
	//    dashboards.
	//
	//    * ADMIN: A user who is an author, who can also manage Amazon QuickSight
	//    settings.
	//
	// UserRole is a required field
	UserRole *string `type:"string" required:"true" enum:"UserRole"`
}

// String returns the string representation
func (s RegisterUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterUserInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Email == nil {
		invalidParams.Add(request.NewErrParamRequired("Email"))
	}
	if s.IdentityType == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityType"))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.SessionName != nil && len(*s.SessionName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SessionName", 2))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}
	if s.UserRole == nil {
		invalidParams.Add(request.NewErrParamRequired("UserRole"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *RegisterUserInput) SetAwsAccountId(v string) *RegisterUserInput {
	s.AwsAccountId = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *RegisterUserInput) SetEmail(v string) *RegisterUserInput {
	s.Email = &v
	return s
}

// SetIamArn sets the IamArn field's value.
func (s *RegisterUserInput) SetIamArn(v string) *RegisterUserInput {
	s.IamArn = &v
	return s
}

// SetIdentityType sets the IdentityType field's value.
func (s *RegisterUserInput) SetIdentityType(v string) *RegisterUserInput {
	s.IdentityType = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *RegisterUserInput) SetNamespace(v string) *RegisterUserInput {
	s.Namespace = &v
	return s
}

// SetSessionName sets the SessionName field's value.
func (s *RegisterUserInput) SetSessionName(v string) *RegisterUserInput {
	s.SessionName = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *RegisterUserInput) SetUserName(v string) *RegisterUserInput {
	s.UserName = &v
	return s
}

// SetUserRole sets the UserRole field's value.
func (s *RegisterUserInput) SetUserRole(v string) *RegisterUserInput {
	s.UserRole = &v
	return s
}

type RegisterUserOutput struct {
	_ struct{} `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The http status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The user name.
	User *User `type:"structure"`

	// The URL the user visits to complete registration and provide a password.
	// This is returned only for users with an identity type of QUICKSIGHT.
	UserInvitationUrl *string `type:"string"`
}

// String returns the string representation
func (s RegisterUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterUserOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *RegisterUserOutput) SetRequestId(v string) *RegisterUserOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RegisterUserOutput) SetStatus(v int64) *RegisterUserOutput {
	s.Status = &v
	return s
}

// SetUser sets the User field's value.
func (s *RegisterUserOutput) SetUser(v *User) *RegisterUserOutput {
	s.User = v
	return s
}

// SetUserInvitationUrl sets the UserInvitationUrl field's value.
func (s *RegisterUserOutput) SetUserInvitationUrl(v string) *RegisterUserOutput {
	s.UserInvitationUrl = &v
	return s
}

type UpdateGroupInput struct {
	_ struct{} `type:"structure"`

	// The ID for the AWS account that the group is in. Currently, you use the ID
	// for the AWS account that contains your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The description for the group that you want to update.
	Description *string `min:"1" type:"string"`

	// The name of the group that you want to update.
	//
	// GroupName is a required field
	GroupName *string `location:"uri" locationName:"GroupName" min:"1" type:"string" required:"true"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGroupInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *UpdateGroupInput) SetAwsAccountId(v string) *UpdateGroupInput {
	s.AwsAccountId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateGroupInput) SetDescription(v string) *UpdateGroupInput {
	s.Description = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *UpdateGroupInput) SetGroupName(v string) *UpdateGroupInput {
	s.GroupName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *UpdateGroupInput) SetNamespace(v string) *UpdateGroupInput {
	s.Namespace = &v
	return s
}

type UpdateGroupOutput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	Group *Group `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The http status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s UpdateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGroupOutput) GoString() string {
	return s.String()
}

// SetGroup sets the Group field's value.
func (s *UpdateGroupOutput) SetGroup(v *Group) *UpdateGroupOutput {
	s.Group = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *UpdateGroupOutput) SetRequestId(v string) *UpdateGroupOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateGroupOutput) SetStatus(v int64) *UpdateGroupOutput {
	s.Status = &v
	return s
}

type UpdateUserInput struct {
	_ struct{} `type:"structure"`

	// The ID for the AWS account that the user is in. Currently, you use the ID
	// for the AWS account that contains your Amazon QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The email address of the user that you want to update.
	//
	// Email is a required field
	Email *string `type:"string" required:"true"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`

	// The Amazon QuickSight role of the user. The user role can be one of the following:
	//
	//    * READER: A user who has read-only access to dashboards.
	//
	//    * AUTHOR: A user who can create data sources, data sets, analyses, and
	//    dashboards.
	//
	//    * ADMIN: A user who is an author, who can also manage Amazon QuickSight
	//    settings.
	//
	// Role is a required field
	Role *string `type:"string" required:"true" enum:"UserRole"`

	// The Amazon QuickSight user name that you want to update.
	//
	// UserName is a required field
	UserName *string `location:"uri" locationName:"UserName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Email == nil {
		invalidParams.Add(request.NewErrParamRequired("Email"))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Role == nil {
		invalidParams.Add(request.NewErrParamRequired("Role"))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *UpdateUserInput) SetAwsAccountId(v string) *UpdateUserInput {
	s.AwsAccountId = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *UpdateUserInput) SetEmail(v string) *UpdateUserInput {
	s.Email = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *UpdateUserInput) SetNamespace(v string) *UpdateUserInput {
	s.Namespace = &v
	return s
}

// SetRole sets the Role field's value.
func (s *UpdateUserInput) SetRole(v string) *UpdateUserInput {
	s.Role = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *UpdateUserInput) SetUserName(v string) *UpdateUserInput {
	s.UserName = &v
	return s
}

type UpdateUserOutput struct {
	_ struct{} `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The http status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The Amazon QuickSight user.
	User *User `type:"structure"`
}

// String returns the string representation
func (s UpdateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *UpdateUserOutput) SetRequestId(v string) *UpdateUserOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateUserOutput) SetStatus(v int64) *UpdateUserOutput {
	s.Status = &v
	return s
}

// SetUser sets the User field's value.
func (s *UpdateUserOutput) SetUser(v *User) *UpdateUserOutput {
	s.User = v
	return s
}

// A registered user of Amazon QuickSight. Currently, an Amazon QuickSight subscription
// can't contain more than 20 million users.
type User struct {
	_ struct{} `type:"structure"`

	// Active status of user. When you create an Amazon QuickSight user that’s
	// not an IAM user or an AD user, that user is inactive until they sign in and
	// provide a password
	Active *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) for the user.
	Arn *string `type:"string"`

	// The user's email address.
	Email *string `type:"string"`

	// The type of identity authentication used by the user.
	IdentityType *string `type:"string" enum:"IdentityType"`

	// The principal ID of the user.
	PrincipalId *string `type:"string"`

	// The Amazon QuickSight role for the user.
	Role *string `type:"string" enum:"UserRole"`

	// The user's user name.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s User) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s User) GoString() string {
	return s.String()
}

// SetActive sets the Active field's value.
func (s *User) SetActive(v bool) *User {
	s.Active = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *User) SetArn(v string) *User {
	s.Arn = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *User) SetEmail(v string) *User {
	s.Email = &v
	return s
}

// SetIdentityType sets the IdentityType field's value.
func (s *User) SetIdentityType(v string) *User {
	s.IdentityType = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *User) SetPrincipalId(v string) *User {
	s.PrincipalId = &v
	return s
}

// SetRole sets the Role field's value.
func (s *User) SetRole(v string) *User {
	s.Role = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *User) SetUserName(v string) *User {
	s.UserName = &v
	return s
}

const (
	// ExceptionResourceTypeUser is a ExceptionResourceType enum value
	ExceptionResourceTypeUser = "USER"

	// ExceptionResourceTypeGroup is a ExceptionResourceType enum value
	ExceptionResourceTypeGroup = "GROUP"

	// ExceptionResourceTypeNamespace is a ExceptionResourceType enum value
	ExceptionResourceTypeNamespace = "NAMESPACE"

	// ExceptionResourceTypeDataSource is a ExceptionResourceType enum value
	ExceptionResourceTypeDataSource = "DATA_SOURCE"

	// ExceptionResourceTypeDataSet is a ExceptionResourceType enum value
	ExceptionResourceTypeDataSet = "DATA_SET"

	// ExceptionResourceTypeVpcConnection is a ExceptionResourceType enum value
	ExceptionResourceTypeVpcConnection = "VPC_CONNECTION"

	// ExceptionResourceTypeIngestion is a ExceptionResourceType enum value
	ExceptionResourceTypeIngestion = "INGESTION"
)

const (
	// IdentityTypeIam is a IdentityType enum value
	IdentityTypeIam = "IAM"

	// IdentityTypeQuicksight is a IdentityType enum value
	IdentityTypeQuicksight = "QUICKSIGHT"
)

const (
	// UserRoleAdmin is a UserRole enum value
	UserRoleAdmin = "ADMIN"

	// UserRoleAuthor is a UserRole enum value
	UserRoleAuthor = "AUTHOR"

	// UserRoleReader is a UserRole enum value
	UserRoleReader = "READER"

	// UserRoleRestrictedAuthor is a UserRole enum value
	UserRoleRestrictedAuthor = "RESTRICTED_AUTHOR"

	// UserRoleRestrictedReader is a UserRole enum value
	UserRoleRestrictedReader = "RESTRICTED_READER"
)
