// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package acmpca

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type CreatePermissionInput struct {
	_ struct{} `type:"structure"`

	// The actions that the specified AWS service principal can use. These include
	// IssueCertificate, GetCertificate, and ListPermissions.
	//
	// Actions is a required field
	Actions []ActionType `min:"1" type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the CA that grants the permissions. You
	// can find the ARN by calling the ListCertificateAuthorities action. This must
	// have the following form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 .
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`

	// The AWS service or identity that receives the permission. At this time, the
	// only valid principal is acm.amazonaws.com.
	//
	// Principal is a required field
	Principal *string `type:"string" required:"true"`

	// The ID of the calling account.
	SourceAccount *string `min:"12" type:"string"`
}

// String returns the string representation
func (s CreatePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePermissionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreatePermissionInput"}

	if s.Actions == nil {
		invalidParams.Add(aws.NewErrParamRequired("Actions"))
	}
	if s.Actions != nil && len(s.Actions) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Actions", 1))
	}

	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(aws.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}

	if s.Principal == nil {
		invalidParams.Add(aws.NewErrParamRequired("Principal"))
	}
	if s.SourceAccount != nil && len(*s.SourceAccount) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("SourceAccount", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreatePermissionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreatePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreatePermission = "CreatePermission"

// CreatePermissionRequest returns a request value for making API operation for
// AWS Certificate Manager Private Certificate Authority.
//
// Assigns permissions from a private CA to a designated AWS service. Services
// are specified by their service principals and can be given permission to
// create and retrieve certificates on a private CA. Services can also be given
// permission to list the active permissions that the private CA has granted.
// For ACM to automatically renew your private CA's certificates, you must assign
// all possible permissions from the CA to the ACM service principal.
//
// At this time, you can only assign permissions to ACM (acm.amazonaws.com).
// Permissions can be revoked with the DeletePermission action and listed with
// the ListPermissions action.
//
//    // Example sending a request using CreatePermissionRequest.
//    req := client.CreatePermissionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/CreatePermission
func (c *Client) CreatePermissionRequest(input *CreatePermissionInput) CreatePermissionRequest {
	op := &aws.Operation{
		Name:       opCreatePermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePermissionInput{}
	}

	req := c.newRequest(op, input, &CreatePermissionOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return CreatePermissionRequest{Request: req, Input: input, Copy: c.CreatePermissionRequest}
}

// CreatePermissionRequest is the request type for the
// CreatePermission API operation.
type CreatePermissionRequest struct {
	*aws.Request
	Input *CreatePermissionInput
	Copy  func(*CreatePermissionInput) CreatePermissionRequest
}

// Send marshals and sends the CreatePermission API request.
func (r CreatePermissionRequest) Send(ctx context.Context) (*CreatePermissionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreatePermissionResponse{
		CreatePermissionOutput: r.Request.Data.(*CreatePermissionOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreatePermissionResponse is the response type for the
// CreatePermission API operation.
type CreatePermissionResponse struct {
	*CreatePermissionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreatePermission request.
func (r *CreatePermissionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
