// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListSmartHomeAppliancesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of appliances to be returned, per paginated calls.
	MaxResults *int64 `min:"1" type:"integer"`

	// The tokens used for pagination.
	NextToken *string `min:"1" type:"string"`

	// The room that the appliances are associated with.
	//
	// RoomArn is a required field
	RoomArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListSmartHomeAppliancesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSmartHomeAppliancesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListSmartHomeAppliancesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if s.RoomArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoomArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListSmartHomeAppliancesOutput struct {
	_ struct{} `type:"structure"`

	// The tokens used for pagination.
	NextToken *string `min:"1" type:"string"`

	// The smart home appliances.
	SmartHomeAppliances []SmartHomeAppliance `type:"list"`
}

// String returns the string representation
func (s ListSmartHomeAppliancesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListSmartHomeAppliances = "ListSmartHomeAppliances"

// ListSmartHomeAppliancesRequest returns a request value for making API operation for
// Alexa For Business.
//
// Lists all of the smart home appliances associated with a room.
//
//    // Example sending a request using ListSmartHomeAppliancesRequest.
//    req := client.ListSmartHomeAppliancesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSmartHomeAppliances
func (c *Client) ListSmartHomeAppliancesRequest(input *ListSmartHomeAppliancesInput) ListSmartHomeAppliancesRequest {
	op := &aws.Operation{
		Name:       opListSmartHomeAppliances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSmartHomeAppliancesInput{}
	}

	req := c.newRequest(op, input, &ListSmartHomeAppliancesOutput{})

	return ListSmartHomeAppliancesRequest{Request: req, Input: input, Copy: c.ListSmartHomeAppliancesRequest}
}

// ListSmartHomeAppliancesRequest is the request type for the
// ListSmartHomeAppliances API operation.
type ListSmartHomeAppliancesRequest struct {
	*aws.Request
	Input *ListSmartHomeAppliancesInput
	Copy  func(*ListSmartHomeAppliancesInput) ListSmartHomeAppliancesRequest
}

// Send marshals and sends the ListSmartHomeAppliances API request.
func (r ListSmartHomeAppliancesRequest) Send(ctx context.Context) (*ListSmartHomeAppliancesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListSmartHomeAppliancesResponse{
		ListSmartHomeAppliancesOutput: r.Request.Data.(*ListSmartHomeAppliancesOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListSmartHomeAppliancesRequestPaginator returns a paginator for ListSmartHomeAppliances.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListSmartHomeAppliancesRequest(input)
//   p := alexaforbusiness.NewListSmartHomeAppliancesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListSmartHomeAppliancesPaginator(req ListSmartHomeAppliancesRequest) ListSmartHomeAppliancesPaginator {
	return ListSmartHomeAppliancesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListSmartHomeAppliancesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListSmartHomeAppliancesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListSmartHomeAppliancesPaginator struct {
	aws.Pager
}

func (p *ListSmartHomeAppliancesPaginator) CurrentPage() *ListSmartHomeAppliancesOutput {
	return p.Pager.CurrentPage().(*ListSmartHomeAppliancesOutput)
}

// ListSmartHomeAppliancesResponse is the response type for the
// ListSmartHomeAppliances API operation.
type ListSmartHomeAppliancesResponse struct {
	*ListSmartHomeAppliancesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListSmartHomeAppliances request.
func (r *ListSmartHomeAppliancesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
