// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package amplify

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The request structure for the backend environment create request.
type CreateBackendEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The unique ID for an Amplify app.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" min:"1" type:"string" required:"true"`

	// The name of deployment artifacts.
	DeploymentArtifacts *string `locationName:"deploymentArtifacts" min:"1" type:"string"`

	// The name for the backend environment.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `locationName:"environmentName" min:"1" type:"string" required:"true"`

	// The AWS CloudFormation stack name of a backend environment.
	StackName *string `locationName:"stackName" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateBackendEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBackendEnvironmentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateBackendEnvironmentInput"}

	if s.AppId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AppId", 1))
	}
	if s.DeploymentArtifacts != nil && len(*s.DeploymentArtifacts) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DeploymentArtifacts", 1))
	}

	if s.EnvironmentName == nil {
		invalidParams.Add(aws.NewErrParamRequired("EnvironmentName"))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("EnvironmentName", 1))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateBackendEnvironmentInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DeploymentArtifacts != nil {
		v := *s.DeploymentArtifacts

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deploymentArtifacts", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EnvironmentName != nil {
		v := *s.EnvironmentName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "environmentName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StackName != nil {
		v := *s.StackName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stackName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AppId != nil {
		v := *s.AppId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "appId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The result structure for the create backend environment request.
type CreateBackendEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// Describes the backend environment for an Amplify app.
	//
	// BackendEnvironment is a required field
	BackendEnvironment *BackendEnvironment `locationName:"backendEnvironment" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateBackendEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateBackendEnvironmentOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.BackendEnvironment != nil {
		v := s.BackendEnvironment

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "backendEnvironment", v, metadata)
	}
	return nil
}

const opCreateBackendEnvironment = "CreateBackendEnvironment"

// CreateBackendEnvironmentRequest returns a request value for making API operation for
// AWS Amplify.
//
// Creates a new backend environment for an Amplify app.
//
//    // Example sending a request using CreateBackendEnvironmentRequest.
//    req := client.CreateBackendEnvironmentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/CreateBackendEnvironment
func (c *Client) CreateBackendEnvironmentRequest(input *CreateBackendEnvironmentInput) CreateBackendEnvironmentRequest {
	op := &aws.Operation{
		Name:       opCreateBackendEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/apps/{appId}/backendenvironments",
	}

	if input == nil {
		input = &CreateBackendEnvironmentInput{}
	}

	req := c.newRequest(op, input, &CreateBackendEnvironmentOutput{})

	return CreateBackendEnvironmentRequest{Request: req, Input: input, Copy: c.CreateBackendEnvironmentRequest}
}

// CreateBackendEnvironmentRequest is the request type for the
// CreateBackendEnvironment API operation.
type CreateBackendEnvironmentRequest struct {
	*aws.Request
	Input *CreateBackendEnvironmentInput
	Copy  func(*CreateBackendEnvironmentInput) CreateBackendEnvironmentRequest
}

// Send marshals and sends the CreateBackendEnvironment API request.
func (r CreateBackendEnvironmentRequest) Send(ctx context.Context) (*CreateBackendEnvironmentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateBackendEnvironmentResponse{
		CreateBackendEnvironmentOutput: r.Request.Data.(*CreateBackendEnvironmentOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateBackendEnvironmentResponse is the response type for the
// CreateBackendEnvironment API operation.
type CreateBackendEnvironmentResponse struct {
	*CreateBackendEnvironmentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateBackendEnvironment request.
func (r *CreateBackendEnvironmentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
