// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package amplify

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The request structure for the update app request.
type UpdateAppInput struct {
	_ struct{} `type:"structure"`

	// The personal access token for a third-party source control system for an
	// Amplify app. The token is used to create webhook and a read-only deploy key.
	// The token is not stored.
	AccessToken *string `locationName:"accessToken" min:"1" type:"string" sensitive:"true"`

	// The unique ID for an Amplify app.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" min:"1" type:"string" required:"true"`

	// The automated branch creation configuration for the Amplify app.
	AutoBranchCreationConfig *AutoBranchCreationConfig `locationName:"autoBranchCreationConfig" type:"structure"`

	// Describes the automated branch creation glob patterns for the Amplify app.
	AutoBranchCreationPatterns []string `locationName:"autoBranchCreationPatterns" type:"list"`

	// The basic authorization credentials for an Amplify app.
	BasicAuthCredentials *string `locationName:"basicAuthCredentials" type:"string" sensitive:"true"`

	// The build specification (build spec) for an Amplify app.
	BuildSpec *string `locationName:"buildSpec" min:"1" type:"string"`

	// The custom redirect and rewrite rules for an Amplify app.
	CustomRules []CustomRule `locationName:"customRules" type:"list"`

	// The description for an Amplify app.
	Description *string `locationName:"description" type:"string"`

	// Enables automated branch creation for the Amplify app.
	EnableAutoBranchCreation *bool `locationName:"enableAutoBranchCreation" type:"boolean"`

	// Enables basic authorization for an Amplify app.
	EnableBasicAuth *bool `locationName:"enableBasicAuth" type:"boolean"`

	// Enables branch auto-building for an Amplify app.
	EnableBranchAutoBuild *bool `locationName:"enableBranchAutoBuild" type:"boolean"`

	// Automatically disconnects a branch in the Amplify Console when you delete
	// a branch from your Git repository.
	EnableBranchAutoDeletion *bool `locationName:"enableBranchAutoDeletion" type:"boolean"`

	// The environment variables for an Amplify app.
	EnvironmentVariables map[string]string `locationName:"environmentVariables" type:"map"`

	// The AWS Identity and Access Management (IAM) service role for an Amplify
	// app.
	IamServiceRoleArn *string `locationName:"iamServiceRoleArn" min:"1" type:"string"`

	// The name for an Amplify app.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The OAuth token for a third-party source control system for an Amplify app.
	// The token is used to create a webhook and a read-only deploy key. The OAuth
	// token is not stored.
	OauthToken *string `locationName:"oauthToken" type:"string" sensitive:"true"`

	// The platform for an Amplify app.
	Platform Platform `locationName:"platform" type:"string" enum:"true"`

	// The name of the repository for an Amplify app
	Repository *string `locationName:"repository" type:"string"`
}

// String returns the string representation
func (s UpdateAppInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAppInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateAppInput"}
	if s.AccessToken != nil && len(*s.AccessToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AccessToken", 1))
	}

	if s.AppId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AppId", 1))
	}
	if s.BuildSpec != nil && len(*s.BuildSpec) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("BuildSpec", 1))
	}
	if s.IamServiceRoleArn != nil && len(*s.IamServiceRoleArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IamServiceRoleArn", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.AutoBranchCreationConfig != nil {
		if err := s.AutoBranchCreationConfig.Validate(); err != nil {
			invalidParams.AddNested("AutoBranchCreationConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.CustomRules != nil {
		for i, v := range s.CustomRules {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CustomRules", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateAppInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AccessToken != nil {
		v := *s.AccessToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accessToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AutoBranchCreationConfig != nil {
		v := s.AutoBranchCreationConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "autoBranchCreationConfig", v, metadata)
	}
	if s.AutoBranchCreationPatterns != nil {
		v := s.AutoBranchCreationPatterns

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "autoBranchCreationPatterns", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.BasicAuthCredentials != nil {
		v := *s.BasicAuthCredentials

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "basicAuthCredentials", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BuildSpec != nil {
		v := *s.BuildSpec

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "buildSpec", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CustomRules != nil {
		v := s.CustomRules

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "customRules", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EnableAutoBranchCreation != nil {
		v := *s.EnableAutoBranchCreation

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "enableAutoBranchCreation", protocol.BoolValue(v), metadata)
	}
	if s.EnableBasicAuth != nil {
		v := *s.EnableBasicAuth

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "enableBasicAuth", protocol.BoolValue(v), metadata)
	}
	if s.EnableBranchAutoBuild != nil {
		v := *s.EnableBranchAutoBuild

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "enableBranchAutoBuild", protocol.BoolValue(v), metadata)
	}
	if s.EnableBranchAutoDeletion != nil {
		v := *s.EnableBranchAutoDeletion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "enableBranchAutoDeletion", protocol.BoolValue(v), metadata)
	}
	if s.EnvironmentVariables != nil {
		v := s.EnvironmentVariables

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "environmentVariables", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.IamServiceRoleArn != nil {
		v := *s.IamServiceRoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "iamServiceRoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OauthToken != nil {
		v := *s.OauthToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "oauthToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Platform) > 0 {
		v := s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "platform", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Repository != nil {
		v := *s.Repository

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "repository", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AppId != nil {
		v := *s.AppId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "appId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The result structure for an Amplify app update request.
type UpdateAppOutput struct {
	_ struct{} `type:"structure"`

	// Represents the updated Amplify app.
	//
	// App is a required field
	App *App `locationName:"app" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateAppOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateAppOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.App != nil {
		v := s.App

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "app", v, metadata)
	}
	return nil
}

const opUpdateApp = "UpdateApp"

// UpdateAppRequest returns a request value for making API operation for
// AWS Amplify.
//
// Updates an existing Amplify app.
//
//    // Example sending a request using UpdateAppRequest.
//    req := client.UpdateAppRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/UpdateApp
func (c *Client) UpdateAppRequest(input *UpdateAppInput) UpdateAppRequest {
	op := &aws.Operation{
		Name:       opUpdateApp,
		HTTPMethod: "POST",
		HTTPPath:   "/apps/{appId}",
	}

	if input == nil {
		input = &UpdateAppInput{}
	}

	req := c.newRequest(op, input, &UpdateAppOutput{})

	return UpdateAppRequest{Request: req, Input: input, Copy: c.UpdateAppRequest}
}

// UpdateAppRequest is the request type for the
// UpdateApp API operation.
type UpdateAppRequest struct {
	*aws.Request
	Input *UpdateAppInput
	Copy  func(*UpdateAppInput) UpdateAppRequest
}

// Send marshals and sends the UpdateApp API request.
func (r UpdateAppRequest) Send(ctx context.Context) (*UpdateAppResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateAppResponse{
		UpdateAppOutput: r.Request.Data.(*UpdateAppOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateAppResponse is the response type for the
// UpdateApp API operation.
type UpdateAppResponse struct {
	*UpdateAppOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateApp request.
func (r *UpdateAppResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
