// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigatewayv2

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateVpcLinkInput struct {
	_ struct{} `type:"structure"`

	// A string with a length between [1-128].
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// A list of security group IDs for the VPC link.
	SecurityGroupIds []string `locationName:"securityGroupIds" type:"list"`

	// A list of subnet IDs to include in the VPC link.
	//
	// SubnetIds is a required field
	SubnetIds []string `locationName:"subnetIds" type:"list" required:"true"`

	// Represents a collection of tags associated with the resource.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateVpcLinkInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVpcLinkInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateVpcLinkInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.SubnetIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateVpcLinkInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SecurityGroupIds != nil {
		v := s.SecurityGroupIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "securityGroupIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.SubnetIds != nil {
		v := s.SubnetIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "subnetIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

type CreateVpcLinkOutput struct {
	_ struct{} `type:"structure"`

	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601"`

	// A string with a length between [1-128].
	Name *string `locationName:"name" type:"string"`

	// A list of security group IDs for the VPC link.
	SecurityGroupIds []string `locationName:"securityGroupIds" type:"list"`

	// A list of subnet IDs to include in the VPC link.
	SubnetIds []string `locationName:"subnetIds" type:"list"`

	// Represents a collection of tags associated with the resource.
	Tags map[string]string `locationName:"tags" type:"map"`

	// The identifier.
	VpcLinkId *string `locationName:"vpcLinkId" type:"string"`

	// The status of the VPC link.
	VpcLinkStatus VpcLinkStatus `locationName:"vpcLinkStatus" type:"string" enum:"true"`

	// A string with a length between [0-1024].
	VpcLinkStatusMessage *string `locationName:"vpcLinkStatusMessage" type:"string"`

	// The version of the VPC link.
	VpcLinkVersion VpcLinkVersion `locationName:"vpcLinkVersion" type:"string" enum:"true"`
}

// String returns the string representation
func (s CreateVpcLinkOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateVpcLinkOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedDate != nil {
		v := *s.CreatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdDate",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SecurityGroupIds != nil {
		v := s.SecurityGroupIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "securityGroupIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.SubnetIds != nil {
		v := s.SubnetIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "subnetIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.VpcLinkId != nil {
		v := *s.VpcLinkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "vpcLinkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.VpcLinkStatus) > 0 {
		v := s.VpcLinkStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "vpcLinkStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.VpcLinkStatusMessage != nil {
		v := *s.VpcLinkStatusMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "vpcLinkStatusMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.VpcLinkVersion) > 0 {
		v := s.VpcLinkVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "vpcLinkVersion", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

const opCreateVpcLink = "CreateVpcLink"

// CreateVpcLinkRequest returns a request value for making API operation for
// AmazonApiGatewayV2.
//
// Creates a VPC link.
//
//    // Example sending a request using CreateVpcLinkRequest.
//    req := client.CreateVpcLinkRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/CreateVpcLink
func (c *Client) CreateVpcLinkRequest(input *CreateVpcLinkInput) CreateVpcLinkRequest {
	op := &aws.Operation{
		Name:       opCreateVpcLink,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/vpclinks",
	}

	if input == nil {
		input = &CreateVpcLinkInput{}
	}

	req := c.newRequest(op, input, &CreateVpcLinkOutput{})

	return CreateVpcLinkRequest{Request: req, Input: input, Copy: c.CreateVpcLinkRequest}
}

// CreateVpcLinkRequest is the request type for the
// CreateVpcLink API operation.
type CreateVpcLinkRequest struct {
	*aws.Request
	Input *CreateVpcLinkInput
	Copy  func(*CreateVpcLinkInput) CreateVpcLinkRequest
}

// Send marshals and sends the CreateVpcLink API request.
func (r CreateVpcLinkRequest) Send(ctx context.Context) (*CreateVpcLinkResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateVpcLinkResponse{
		CreateVpcLinkOutput: r.Request.Data.(*CreateVpcLinkOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateVpcLinkResponse is the response type for the
// CreateVpcLink API operation.
type CreateVpcLinkResponse struct {
	*CreateVpcLinkOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateVpcLink request.
func (r *CreateVpcLinkResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
