// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigatewayv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetVpcLinksInput struct {
	_ struct{} `type:"structure"`

	MaxResults *string `location:"querystring" locationName:"maxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetVpcLinksInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetVpcLinksInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetVpcLinksOutput struct {
	_ struct{} `type:"structure"`

	Items []VpcLink `locationName:"items" type:"list"`

	// The next page of elements from this collection. Not valid for the last element
	// of the collection.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetVpcLinksOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetVpcLinksOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Items != nil {
		v := s.Items

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetVpcLinks = "GetVpcLinks"

// GetVpcLinksRequest returns a request value for making API operation for
// AmazonApiGatewayV2.
//
// Gets a collection of VPC links.
//
//    // Example sending a request using GetVpcLinksRequest.
//    req := client.GetVpcLinksRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetVpcLinks
func (c *Client) GetVpcLinksRequest(input *GetVpcLinksInput) GetVpcLinksRequest {
	op := &aws.Operation{
		Name:       opGetVpcLinks,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/vpclinks",
	}

	if input == nil {
		input = &GetVpcLinksInput{}
	}

	req := c.newRequest(op, input, &GetVpcLinksOutput{})

	return GetVpcLinksRequest{Request: req, Input: input, Copy: c.GetVpcLinksRequest}
}

// GetVpcLinksRequest is the request type for the
// GetVpcLinks API operation.
type GetVpcLinksRequest struct {
	*aws.Request
	Input *GetVpcLinksInput
	Copy  func(*GetVpcLinksInput) GetVpcLinksRequest
}

// Send marshals and sends the GetVpcLinks API request.
func (r GetVpcLinksRequest) Send(ctx context.Context) (*GetVpcLinksResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetVpcLinksResponse{
		GetVpcLinksOutput: r.Request.Data.(*GetVpcLinksOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetVpcLinksResponse is the response type for the
// GetVpcLinks API operation.
type GetVpcLinksResponse struct {
	*GetVpcLinksOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetVpcLinks request.
func (r *GetVpcLinksResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
