// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appconfig

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type ValidateConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The application ID.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"ApplicationId" type:"string" required:"true"`

	// The configuration profile ID.
	//
	// ConfigurationProfileId is a required field
	ConfigurationProfileId *string `location:"uri" locationName:"ConfigurationProfileId" type:"string" required:"true"`

	// The version of the configuration to validate.
	//
	// ConfigurationVersion is a required field
	ConfigurationVersion *string `location:"querystring" locationName:"configuration_version" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ValidateConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ValidateConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ValidateConfigurationInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if s.ConfigurationProfileId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConfigurationProfileId"))
	}

	if s.ConfigurationVersion == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConfigurationVersion"))
	}
	if s.ConfigurationVersion != nil && len(*s.ConfigurationVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ConfigurationVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ValidateConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ConfigurationProfileId != nil {
		v := *s.ConfigurationProfileId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ConfigurationProfileId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ConfigurationVersion != nil {
		v := *s.ConfigurationVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "configuration_version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ValidateConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ValidateConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ValidateConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opValidateConfiguration = "ValidateConfiguration"

// ValidateConfigurationRequest returns a request value for making API operation for
// Amazon AppConfig.
//
// Uses the validators in a configuration profile to validate a configuration.
//
//    // Example sending a request using ValidateConfigurationRequest.
//    req := client.ValidateConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ValidateConfiguration
func (c *Client) ValidateConfigurationRequest(input *ValidateConfigurationInput) ValidateConfigurationRequest {
	op := &aws.Operation{
		Name:       opValidateConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{ApplicationId}/configurationprofiles/{ConfigurationProfileId}/validators",
	}

	if input == nil {
		input = &ValidateConfigurationInput{}
	}

	req := c.newRequest(op, input, &ValidateConfigurationOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return ValidateConfigurationRequest{Request: req, Input: input, Copy: c.ValidateConfigurationRequest}
}

// ValidateConfigurationRequest is the request type for the
// ValidateConfiguration API operation.
type ValidateConfigurationRequest struct {
	*aws.Request
	Input *ValidateConfigurationInput
	Copy  func(*ValidateConfigurationInput) ValidateConfigurationRequest
}

// Send marshals and sends the ValidateConfiguration API request.
func (r ValidateConfigurationRequest) Send(ctx context.Context) (*ValidateConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ValidateConfigurationResponse{
		ValidateConfigurationOutput: r.Request.Data.(*ValidateConfigurationOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ValidateConfigurationResponse is the response type for the
// ValidateConfiguration API operation.
type ValidateConfigurationResponse struct {
	*ValidateConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ValidateConfiguration request.
func (r *ValidateConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
