// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationinsights

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeComponentConfigurationRecommendationInput struct {
	_ struct{} `type:"structure"`

	// The name of the component.
	//
	// ComponentName is a required field
	ComponentName *string `type:"string" required:"true"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `min:"1" type:"string" required:"true"`

	// The tier of the application component. Supported tiers include DOT_NET_CORE,
	// DOT_NET_WORKER, DOT_NET_WEB, SQL_SERVER, and DEFAULT.
	//
	// Tier is a required field
	Tier Tier `min:"1" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s DescribeComponentConfigurationRecommendationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeComponentConfigurationRecommendationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeComponentConfigurationRecommendationInput"}

	if s.ComponentName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ComponentName"))
	}

	if s.ResourceGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceGroupName"))
	}
	if s.ResourceGroupName != nil && len(*s.ResourceGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceGroupName", 1))
	}
	if len(s.Tier) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Tier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeComponentConfigurationRecommendationOutput struct {
	_ struct{} `type:"structure"`

	// The recommended configuration settings of the component. The value is the
	// escaped JSON of the configuration.
	ComponentConfiguration *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeComponentConfigurationRecommendationOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeComponentConfigurationRecommendation = "DescribeComponentConfigurationRecommendation"

// DescribeComponentConfigurationRecommendationRequest returns a request value for making API operation for
// Amazon CloudWatch Application Insights.
//
// Describes the recommended monitoring configuration of the component.
//
//    // Example sending a request using DescribeComponentConfigurationRecommendationRequest.
//    req := client.DescribeComponentConfigurationRecommendationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeComponentConfigurationRecommendation
func (c *Client) DescribeComponentConfigurationRecommendationRequest(input *DescribeComponentConfigurationRecommendationInput) DescribeComponentConfigurationRecommendationRequest {
	op := &aws.Operation{
		Name:       opDescribeComponentConfigurationRecommendation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeComponentConfigurationRecommendationInput{}
	}

	req := c.newRequest(op, input, &DescribeComponentConfigurationRecommendationOutput{})

	return DescribeComponentConfigurationRecommendationRequest{Request: req, Input: input, Copy: c.DescribeComponentConfigurationRecommendationRequest}
}

// DescribeComponentConfigurationRecommendationRequest is the request type for the
// DescribeComponentConfigurationRecommendation API operation.
type DescribeComponentConfigurationRecommendationRequest struct {
	*aws.Request
	Input *DescribeComponentConfigurationRecommendationInput
	Copy  func(*DescribeComponentConfigurationRecommendationInput) DescribeComponentConfigurationRecommendationRequest
}

// Send marshals and sends the DescribeComponentConfigurationRecommendation API request.
func (r DescribeComponentConfigurationRecommendationRequest) Send(ctx context.Context) (*DescribeComponentConfigurationRecommendationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeComponentConfigurationRecommendationResponse{
		DescribeComponentConfigurationRecommendationOutput: r.Request.Data.(*DescribeComponentConfigurationRecommendationOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeComponentConfigurationRecommendationResponse is the response type for the
// DescribeComponentConfigurationRecommendation API operation.
type DescribeComponentConfigurationRecommendationResponse struct {
	*DescribeComponentConfigurationRecommendationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeComponentConfigurationRecommendation request.
func (r *DescribeComponentConfigurationRecommendationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
