// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appmesh

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListGatewayRoutesInput struct {
	_ struct{} `type:"structure"`

	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// VirtualGatewayName is a required field
	VirtualGatewayName *string `location:"uri" locationName:"virtualGatewayName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListGatewayRoutesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGatewayRoutesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListGatewayRoutesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}

	if s.MeshName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("MeshOwner", 12))
	}

	if s.VirtualGatewayName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VirtualGatewayName"))
	}
	if s.VirtualGatewayName != nil && len(*s.VirtualGatewayName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VirtualGatewayName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListGatewayRoutesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MeshName != nil {
		v := *s.MeshName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "meshName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VirtualGatewayName != nil {
		v := *s.VirtualGatewayName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "virtualGatewayName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Limit != nil {
		v := *s.Limit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "limit", protocol.Int64Value(v), metadata)
	}
	if s.MeshOwner != nil {
		v := *s.MeshOwner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "meshOwner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListGatewayRoutesOutput struct {
	_ struct{} `type:"structure"`

	// GatewayRoutes is a required field
	GatewayRoutes []GatewayRouteRef `locationName:"gatewayRoutes" type:"list" required:"true"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListGatewayRoutesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListGatewayRoutesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.GatewayRoutes != nil {
		v := s.GatewayRoutes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "gatewayRoutes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListGatewayRoutes = "ListGatewayRoutes"

// ListGatewayRoutesRequest returns a request value for making API operation for
// AWS App Mesh.
//
// Returns a list of existing gateway routes that are associated to a virtual
// gateway.
//
//    // Example sending a request using ListGatewayRoutesRequest.
//    req := client.ListGatewayRoutesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/ListGatewayRoutes
func (c *Client) ListGatewayRoutesRequest(input *ListGatewayRoutesInput) ListGatewayRoutesRequest {
	op := &aws.Operation{
		Name:       opListGatewayRoutes,
		HTTPMethod: "GET",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualGateway/{virtualGatewayName}/gatewayRoutes",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGatewayRoutesInput{}
	}

	req := c.newRequest(op, input, &ListGatewayRoutesOutput{})

	return ListGatewayRoutesRequest{Request: req, Input: input, Copy: c.ListGatewayRoutesRequest}
}

// ListGatewayRoutesRequest is the request type for the
// ListGatewayRoutes API operation.
type ListGatewayRoutesRequest struct {
	*aws.Request
	Input *ListGatewayRoutesInput
	Copy  func(*ListGatewayRoutesInput) ListGatewayRoutesRequest
}

// Send marshals and sends the ListGatewayRoutes API request.
func (r ListGatewayRoutesRequest) Send(ctx context.Context) (*ListGatewayRoutesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListGatewayRoutesResponse{
		ListGatewayRoutesOutput: r.Request.Data.(*ListGatewayRoutesOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListGatewayRoutesRequestPaginator returns a paginator for ListGatewayRoutes.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListGatewayRoutesRequest(input)
//   p := appmesh.NewListGatewayRoutesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListGatewayRoutesPaginator(req ListGatewayRoutesRequest) ListGatewayRoutesPaginator {
	return ListGatewayRoutesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListGatewayRoutesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListGatewayRoutesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListGatewayRoutesPaginator struct {
	aws.Pager
}

func (p *ListGatewayRoutesPaginator) CurrentPage() *ListGatewayRoutesOutput {
	return p.Pager.CurrentPage().(*ListGatewayRoutesOutput)
}

// ListGatewayRoutesResponse is the response type for the
// ListGatewayRoutes API operation.
type ListGatewayRoutesResponse struct {
	*ListGatewayRoutesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListGatewayRoutes request.
func (r *ListGatewayRoutesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
