// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ExitStandbyInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The IDs of the instances. You can specify up to 20 instances.
	InstanceIds []string `type:"list"`
}

// String returns the string representation
func (s ExitStandbyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExitStandbyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ExitStandbyInput"}

	if s.AutoScalingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ExitStandbyOutput struct {
	_ struct{} `type:"structure"`

	// The activities related to moving instances out of Standby mode.
	Activities []Activity `type:"list"`
}

// String returns the string representation
func (s ExitStandbyOutput) String() string {
	return awsutil.Prettify(s)
}

const opExitStandby = "ExitStandby"

// ExitStandbyRequest returns a request value for making API operation for
// Auto Scaling.
//
// Moves the specified instances out of the standby state.
//
// After you put the instances back in service, the desired capacity is incremented.
//
// For more information, see Temporarily Removing Instances from Your Auto Scaling
// Group (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enter-exit-standby.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
//    // Example sending a request using ExitStandbyRequest.
//    req := client.ExitStandbyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/ExitStandby
func (c *Client) ExitStandbyRequest(input *ExitStandbyInput) ExitStandbyRequest {
	op := &aws.Operation{
		Name:       opExitStandby,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExitStandbyInput{}
	}

	req := c.newRequest(op, input, &ExitStandbyOutput{})

	return ExitStandbyRequest{Request: req, Input: input, Copy: c.ExitStandbyRequest}
}

// ExitStandbyRequest is the request type for the
// ExitStandby API operation.
type ExitStandbyRequest struct {
	*aws.Request
	Input *ExitStandbyInput
	Copy  func(*ExitStandbyInput) ExitStandbyRequest
}

// Send marshals and sends the ExitStandby API request.
func (r ExitStandbyRequest) Send(ctx context.Context) (*ExitStandbyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ExitStandbyResponse{
		ExitStandbyOutput: r.Request.Data.(*ExitStandbyOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ExitStandbyResponse is the response type for the
// ExitStandby API operation.
type ExitStandbyResponse struct {
	*ExitStandbyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ExitStandby request.
func (r *ExitStandbyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
