// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

type SetDesiredCapacityInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The desired capacity is the initial capacity of the Auto Scaling group after
	// this operation completes and the capacity it attempts to maintain.
	//
	// DesiredCapacity is a required field
	DesiredCapacity *int64 `type:"integer" required:"true"`

	// Indicates whether Amazon EC2 Auto Scaling waits for the cooldown period to
	// complete before initiating a scaling activity to set your Auto Scaling group
	// to its new capacity. By default, Amazon EC2 Auto Scaling does not honor the
	// cooldown period during manual scaling activities.
	HonorCooldown *bool `type:"boolean"`
}

// String returns the string representation
func (s SetDesiredCapacityInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetDesiredCapacityInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SetDesiredCapacityInput"}

	if s.AutoScalingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if s.DesiredCapacity == nil {
		invalidParams.Add(aws.NewErrParamRequired("DesiredCapacity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SetDesiredCapacityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetDesiredCapacityOutput) String() string {
	return awsutil.Prettify(s)
}

const opSetDesiredCapacity = "SetDesiredCapacity"

// SetDesiredCapacityRequest returns a request value for making API operation for
// Auto Scaling.
//
// Sets the size of the specified Auto Scaling group.
//
// If a scale-in activity occurs as a result of a new DesiredCapacity value
// that is lower than the current size of the group, the Auto Scaling group
// uses its termination policy to determine which instances to terminate.
//
// For more information, see Manual Scaling (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-manual-scaling.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
//    // Example sending a request using SetDesiredCapacityRequest.
//    req := client.SetDesiredCapacityRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SetDesiredCapacity
func (c *Client) SetDesiredCapacityRequest(input *SetDesiredCapacityInput) SetDesiredCapacityRequest {
	op := &aws.Operation{
		Name:       opSetDesiredCapacity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetDesiredCapacityInput{}
	}

	req := c.newRequest(op, input, &SetDesiredCapacityOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return SetDesiredCapacityRequest{Request: req, Input: input, Copy: c.SetDesiredCapacityRequest}
}

// SetDesiredCapacityRequest is the request type for the
// SetDesiredCapacity API operation.
type SetDesiredCapacityRequest struct {
	*aws.Request
	Input *SetDesiredCapacityInput
	Copy  func(*SetDesiredCapacityInput) SetDesiredCapacityRequest
}

// Send marshals and sends the SetDesiredCapacity API request.
func (r SetDesiredCapacityRequest) Send(ctx context.Context) (*SetDesiredCapacityResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SetDesiredCapacityResponse{
		SetDesiredCapacityOutput: r.Request.Data.(*SetDesiredCapacityOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SetDesiredCapacityResponse is the response type for the
// SetDesiredCapacity API operation.
type SetDesiredCapacityResponse struct {
	*SetDesiredCapacityOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SetDesiredCapacity request.
func (r *SetDesiredCapacityResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
