// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package backup

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListRecoveryPointsByResourceInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return maxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// An ARN that uniquely identifies a resource. The format of the ARN depends
	// on the resource type.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListRecoveryPointsByResourceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRecoveryPointsByResourceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListRecoveryPointsByResourceInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.ResourceArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListRecoveryPointsByResourceInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ResourceArn != nil {
		v := *s.ResourceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "resourceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListRecoveryPointsByResourceOutput struct {
	_ struct{} `type:"structure"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return maxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `type:"string"`

	// An array of objects that contain detailed information about recovery points
	// of the specified resource type.
	RecoveryPoints []RecoveryPointByResource `type:"list"`
}

// String returns the string representation
func (s ListRecoveryPointsByResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListRecoveryPointsByResourceOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RecoveryPoints != nil {
		v := s.RecoveryPoints

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "RecoveryPoints", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListRecoveryPointsByResource = "ListRecoveryPointsByResource"

// ListRecoveryPointsByResourceRequest returns a request value for making API operation for
// AWS Backup.
//
// Returns detailed information about recovery points of the type specified
// by a resource Amazon Resource Name (ARN).
//
//    // Example sending a request using ListRecoveryPointsByResourceRequest.
//    req := client.ListRecoveryPointsByResourceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByResource
func (c *Client) ListRecoveryPointsByResourceRequest(input *ListRecoveryPointsByResourceInput) ListRecoveryPointsByResourceRequest {
	op := &aws.Operation{
		Name:       opListRecoveryPointsByResource,
		HTTPMethod: "GET",
		HTTPPath:   "/resources/{resourceArn}/recovery-points/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRecoveryPointsByResourceInput{}
	}

	req := c.newRequest(op, input, &ListRecoveryPointsByResourceOutput{})

	return ListRecoveryPointsByResourceRequest{Request: req, Input: input, Copy: c.ListRecoveryPointsByResourceRequest}
}

// ListRecoveryPointsByResourceRequest is the request type for the
// ListRecoveryPointsByResource API operation.
type ListRecoveryPointsByResourceRequest struct {
	*aws.Request
	Input *ListRecoveryPointsByResourceInput
	Copy  func(*ListRecoveryPointsByResourceInput) ListRecoveryPointsByResourceRequest
}

// Send marshals and sends the ListRecoveryPointsByResource API request.
func (r ListRecoveryPointsByResourceRequest) Send(ctx context.Context) (*ListRecoveryPointsByResourceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListRecoveryPointsByResourceResponse{
		ListRecoveryPointsByResourceOutput: r.Request.Data.(*ListRecoveryPointsByResourceOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListRecoveryPointsByResourceRequestPaginator returns a paginator for ListRecoveryPointsByResource.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListRecoveryPointsByResourceRequest(input)
//   p := backup.NewListRecoveryPointsByResourceRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListRecoveryPointsByResourcePaginator(req ListRecoveryPointsByResourceRequest) ListRecoveryPointsByResourcePaginator {
	return ListRecoveryPointsByResourcePaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListRecoveryPointsByResourceInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListRecoveryPointsByResourcePaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListRecoveryPointsByResourcePaginator struct {
	aws.Pager
}

func (p *ListRecoveryPointsByResourcePaginator) CurrentPage() *ListRecoveryPointsByResourceOutput {
	return p.Pager.CurrentPage().(*ListRecoveryPointsByResourceOutput)
}

// ListRecoveryPointsByResourceResponse is the response type for the
// ListRecoveryPointsByResource API operation.
type ListRecoveryPointsByResourceResponse struct {
	*ListRecoveryPointsByResourceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListRecoveryPointsByResource request.
func (r *ListRecoveryPointsByResourceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
