// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type DeleteVoiceConnectorEmergencyCallingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime Voice Connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVoiceConnectorEmergencyCallingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVoiceConnectorEmergencyCallingConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteVoiceConnectorEmergencyCallingConfigurationInput"}

	if s.VoiceConnectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VoiceConnectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteVoiceConnectorEmergencyCallingConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.VoiceConnectorId != nil {
		v := *s.VoiceConnectorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "voiceConnectorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteVoiceConnectorEmergencyCallingConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVoiceConnectorEmergencyCallingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteVoiceConnectorEmergencyCallingConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteVoiceConnectorEmergencyCallingConfiguration = "DeleteVoiceConnectorEmergencyCallingConfiguration"

// DeleteVoiceConnectorEmergencyCallingConfigurationRequest returns a request value for making API operation for
// Amazon Chime.
//
// Deletes the emergency calling configuration details from the specified Amazon
// Chime Voice Connector.
//
//    // Example sending a request using DeleteVoiceConnectorEmergencyCallingConfigurationRequest.
//    req := client.DeleteVoiceConnectorEmergencyCallingConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorEmergencyCallingConfiguration
func (c *Client) DeleteVoiceConnectorEmergencyCallingConfigurationRequest(input *DeleteVoiceConnectorEmergencyCallingConfigurationInput) DeleteVoiceConnectorEmergencyCallingConfigurationRequest {
	op := &aws.Operation{
		Name:       opDeleteVoiceConnectorEmergencyCallingConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/emergency-calling-configuration",
	}

	if input == nil {
		input = &DeleteVoiceConnectorEmergencyCallingConfigurationInput{}
	}

	req := c.newRequest(op, input, &DeleteVoiceConnectorEmergencyCallingConfigurationOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteVoiceConnectorEmergencyCallingConfigurationRequest{Request: req, Input: input, Copy: c.DeleteVoiceConnectorEmergencyCallingConfigurationRequest}
}

// DeleteVoiceConnectorEmergencyCallingConfigurationRequest is the request type for the
// DeleteVoiceConnectorEmergencyCallingConfiguration API operation.
type DeleteVoiceConnectorEmergencyCallingConfigurationRequest struct {
	*aws.Request
	Input *DeleteVoiceConnectorEmergencyCallingConfigurationInput
	Copy  func(*DeleteVoiceConnectorEmergencyCallingConfigurationInput) DeleteVoiceConnectorEmergencyCallingConfigurationRequest
}

// Send marshals and sends the DeleteVoiceConnectorEmergencyCallingConfiguration API request.
func (r DeleteVoiceConnectorEmergencyCallingConfigurationRequest) Send(ctx context.Context) (*DeleteVoiceConnectorEmergencyCallingConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteVoiceConnectorEmergencyCallingConfigurationResponse{
		DeleteVoiceConnectorEmergencyCallingConfigurationOutput: r.Request.Data.(*DeleteVoiceConnectorEmergencyCallingConfigurationOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteVoiceConnectorEmergencyCallingConfigurationResponse is the response type for the
// DeleteVoiceConnectorEmergencyCallingConfiguration API operation.
type DeleteVoiceConnectorEmergencyCallingConfigurationResponse struct {
	*DeleteVoiceConnectorEmergencyCallingConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteVoiceConnectorEmergencyCallingConfiguration request.
func (r *DeleteVoiceConnectorEmergencyCallingConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
