// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListAttendeeTagsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime SDK attendee ID.
	//
	// AttendeeId is a required field
	AttendeeId *string `location:"uri" locationName:"attendeeId" type:"string" required:"true"`

	// The Amazon Chime SDK meeting ID.
	//
	// MeetingId is a required field
	MeetingId *string `location:"uri" locationName:"meetingId" type:"string" required:"true"`
}

// String returns the string representation
func (s ListAttendeeTagsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAttendeeTagsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListAttendeeTagsInput"}

	if s.AttendeeId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AttendeeId"))
	}

	if s.MeetingId == nil {
		invalidParams.Add(aws.NewErrParamRequired("MeetingId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListAttendeeTagsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AttendeeId != nil {
		v := *s.AttendeeId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "attendeeId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MeetingId != nil {
		v := *s.MeetingId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "meetingId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListAttendeeTagsOutput struct {
	_ struct{} `type:"structure"`

	// A list of tag key-value pairs.
	Tags []Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s ListAttendeeTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListAttendeeTagsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListAttendeeTags = "ListAttendeeTags"

// ListAttendeeTagsRequest returns a request value for making API operation for
// Amazon Chime.
//
// Lists the tags applied to an Amazon Chime SDK attendee resource.
//
//    // Example sending a request using ListAttendeeTagsRequest.
//    req := client.ListAttendeeTagsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListAttendeeTags
func (c *Client) ListAttendeeTagsRequest(input *ListAttendeeTagsInput) ListAttendeeTagsRequest {
	op := &aws.Operation{
		Name:       opListAttendeeTags,
		HTTPMethod: "GET",
		HTTPPath:   "/meetings/{meetingId}/attendees/{attendeeId}/tags",
	}

	if input == nil {
		input = &ListAttendeeTagsInput{}
	}

	req := c.newRequest(op, input, &ListAttendeeTagsOutput{})

	return ListAttendeeTagsRequest{Request: req, Input: input, Copy: c.ListAttendeeTagsRequest}
}

// ListAttendeeTagsRequest is the request type for the
// ListAttendeeTags API operation.
type ListAttendeeTagsRequest struct {
	*aws.Request
	Input *ListAttendeeTagsInput
	Copy  func(*ListAttendeeTagsInput) ListAttendeeTagsRequest
}

// Send marshals and sends the ListAttendeeTags API request.
func (r ListAttendeeTagsRequest) Send(ctx context.Context) (*ListAttendeeTagsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListAttendeeTagsResponse{
		ListAttendeeTagsOutput: r.Request.Data.(*ListAttendeeTagsOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListAttendeeTagsResponse is the response type for the
// ListAttendeeTags API operation.
type ListAttendeeTagsResponse struct {
	*ListAttendeeTagsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListAttendeeTags request.
func (r *ListAttendeeTagsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
