// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type RedactRoomMessageInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The message ID.
	//
	// MessageId is a required field
	MessageId *string `location:"uri" locationName:"messageId" type:"string" required:"true"`

	// The room ID.
	//
	// RoomId is a required field
	RoomId *string `location:"uri" locationName:"roomId" type:"string" required:"true"`
}

// String returns the string representation
func (s RedactRoomMessageInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedactRoomMessageInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RedactRoomMessageInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.MessageId == nil {
		invalidParams.Add(aws.NewErrParamRequired("MessageId"))
	}

	if s.RoomId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoomId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RedactRoomMessageInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MessageId != nil {
		v := *s.MessageId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "messageId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoomId != nil {
		v := *s.RoomId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "roomId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type RedactRoomMessageOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RedactRoomMessageOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RedactRoomMessageOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opRedactRoomMessage = "RedactRoomMessage"

// RedactRoomMessageRequest returns a request value for making API operation for
// Amazon Chime.
//
// Redacts the specified message from the specified Amazon Chime chat room.
//
//    // Example sending a request using RedactRoomMessageRequest.
//    req := client.RedactRoomMessageRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/RedactRoomMessage
func (c *Client) RedactRoomMessageRequest(input *RedactRoomMessageInput) RedactRoomMessageRequest {
	op := &aws.Operation{
		Name:       opRedactRoomMessage,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/rooms/{roomId}/messages/{messageId}?operation=redact",
	}

	if input == nil {
		input = &RedactRoomMessageInput{}
	}

	req := c.newRequest(op, input, &RedactRoomMessageOutput{})

	return RedactRoomMessageRequest{Request: req, Input: input, Copy: c.RedactRoomMessageRequest}
}

// RedactRoomMessageRequest is the request type for the
// RedactRoomMessage API operation.
type RedactRoomMessageRequest struct {
	*aws.Request
	Input *RedactRoomMessageInput
	Copy  func(*RedactRoomMessageInput) RedactRoomMessageRequest
}

// Send marshals and sends the RedactRoomMessage API request.
func (r RedactRoomMessageRequest) Send(ctx context.Context) (*RedactRoomMessageResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RedactRoomMessageResponse{
		RedactRoomMessageOutput: r.Request.Data.(*RedactRoomMessageOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RedactRoomMessageResponse is the response type for the
// RedactRoomMessage API operation.
type RedactRoomMessageResponse struct {
	*RedactRoomMessageOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RedactRoomMessage request.
func (r *RedactRoomMessageResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
