// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package clouddirectory

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListTypedLinkFacetNamesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The Amazon Resource Name (ARN) that is associated with the schema. For more
	// information, see arns.
	//
	// SchemaArn is a required field
	SchemaArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTypedLinkFacetNamesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTypedLinkFacetNamesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListTypedLinkFacetNamesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.SchemaArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SchemaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListTypedLinkFacetNamesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SchemaArn != nil {
		v := *s.SchemaArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-data-partition", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListTypedLinkFacetNamesOutput struct {
	_ struct{} `type:"structure"`

	// The names of typed link facets that exist within the schema.
	FacetNames []string `type:"list"`

	// The pagination token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListTypedLinkFacetNamesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListTypedLinkFacetNamesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.FacetNames != nil {
		v := s.FacetNames

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "FacetNames", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListTypedLinkFacetNames = "ListTypedLinkFacetNames"

// ListTypedLinkFacetNamesRequest returns a request value for making API operation for
// Amazon CloudDirectory.
//
// Returns a paginated list of TypedLink facet names for a particular schema.
// For more information, see Typed Links (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
//
//    // Example sending a request using ListTypedLinkFacetNamesRequest.
//    req := client.ListTypedLinkFacetNamesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListTypedLinkFacetNames
func (c *Client) ListTypedLinkFacetNamesRequest(input *ListTypedLinkFacetNamesInput) ListTypedLinkFacetNamesRequest {
	op := &aws.Operation{
		Name:       opListTypedLinkFacetNames,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/typedlink/facet/list",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTypedLinkFacetNamesInput{}
	}

	req := c.newRequest(op, input, &ListTypedLinkFacetNamesOutput{})

	return ListTypedLinkFacetNamesRequest{Request: req, Input: input, Copy: c.ListTypedLinkFacetNamesRequest}
}

// ListTypedLinkFacetNamesRequest is the request type for the
// ListTypedLinkFacetNames API operation.
type ListTypedLinkFacetNamesRequest struct {
	*aws.Request
	Input *ListTypedLinkFacetNamesInput
	Copy  func(*ListTypedLinkFacetNamesInput) ListTypedLinkFacetNamesRequest
}

// Send marshals and sends the ListTypedLinkFacetNames API request.
func (r ListTypedLinkFacetNamesRequest) Send(ctx context.Context) (*ListTypedLinkFacetNamesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListTypedLinkFacetNamesResponse{
		ListTypedLinkFacetNamesOutput: r.Request.Data.(*ListTypedLinkFacetNamesOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListTypedLinkFacetNamesRequestPaginator returns a paginator for ListTypedLinkFacetNames.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListTypedLinkFacetNamesRequest(input)
//   p := clouddirectory.NewListTypedLinkFacetNamesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListTypedLinkFacetNamesPaginator(req ListTypedLinkFacetNamesRequest) ListTypedLinkFacetNamesPaginator {
	return ListTypedLinkFacetNamesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListTypedLinkFacetNamesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListTypedLinkFacetNamesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListTypedLinkFacetNamesPaginator struct {
	aws.Pager
}

func (p *ListTypedLinkFacetNamesPaginator) CurrentPage() *ListTypedLinkFacetNamesOutput {
	return p.Pager.CurrentPage().(*ListTypedLinkFacetNamesOutput)
}

// ListTypedLinkFacetNamesResponse is the response type for the
// ListTypedLinkFacetNames API operation.
type ListTypedLinkFacetNamesResponse struct {
	*ListTypedLinkFacetNamesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListTypedLinkFacetNames request.
func (r *ListTypedLinkFacetNamesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
