// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudformation

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DetectStackSetDriftInput struct {
	_ struct{} `type:"structure"`

	// The ID of the stack set operation.
	OperationId *string `min:"1" type:"string" idempotencyToken:"true"`

	// The user-specified preferences for how AWS CloudFormation performs a stack
	// set operation.
	//
	// For more information on maximum concurrent accounts and failure tolerance,
	// see Stack set operation options (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options).
	OperationPreferences *StackSetOperationPreferences `type:"structure"`

	// The name of the stack set on which to perform the drift detection operation.
	//
	// StackSetName is a required field
	StackSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DetectStackSetDriftInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectStackSetDriftInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DetectStackSetDriftInput"}
	if s.OperationId != nil && len(*s.OperationId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OperationId", 1))
	}

	if s.StackSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackSetName"))
	}
	if s.OperationPreferences != nil {
		if err := s.OperationPreferences.Validate(); err != nil {
			invalidParams.AddNested("OperationPreferences", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DetectStackSetDriftOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the drift detection stack set operation.
	//
	// you can use this operation id with DescribeStackSetOperation to monitor the
	// progress of the drift detection operation.
	OperationId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DetectStackSetDriftOutput) String() string {
	return awsutil.Prettify(s)
}

const opDetectStackSetDrift = "DetectStackSetDrift"

// DetectStackSetDriftRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Detect drift on a stack set. When CloudFormation performs drift detection
// on a stack set, it performs drift detection on the stack associated with
// each stack instance in the stack set. For more information, see How CloudFormation
// Performs Drift Detection on a Stack Set (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html).
//
// DetectStackSetDrift returns the OperationId of the stack set drift detection
// operation. Use this operation id with DescribeStackSetOperation to monitor
// the progress of the drift detection operation. The drift detection operation
// may take some time, depending on the number of stack instances included in
// the stack set, as well as the number of resources included in each stack.
//
// Once the operation has completed, use the following actions to return drift
// information:
//
//    * Use DescribeStackSet to return detailed informaiton about the stack
//    set, including detailed information about the last completed drift operation
//    performed on the stack set. (Information about drift operations that are
//    in progress is not included.)
//
//    * Use ListStackInstances to return a list of stack instances belonging
//    to the stack set, including the drift status and last drift time checked
//    of each instance.
//
//    * Use DescribeStackInstance to return detailed information about a specific
//    stack instance, including its drift status and last drift time checked.
//
// For more information on performing a drift detection operation on a stack
// set, see Detecting Unmanaged Changes in Stack Sets (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html).
//
// You can only run a single drift detection operation on a given stack set
// at one time.
//
// To stop a drift detection stack set operation, use StopStackSetOperation .
//
//    // Example sending a request using DetectStackSetDriftRequest.
//    req := client.DetectStackSetDriftRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackSetDrift
func (c *Client) DetectStackSetDriftRequest(input *DetectStackSetDriftInput) DetectStackSetDriftRequest {
	op := &aws.Operation{
		Name:       opDetectStackSetDrift,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectStackSetDriftInput{}
	}

	req := c.newRequest(op, input, &DetectStackSetDriftOutput{})

	return DetectStackSetDriftRequest{Request: req, Input: input, Copy: c.DetectStackSetDriftRequest}
}

// DetectStackSetDriftRequest is the request type for the
// DetectStackSetDrift API operation.
type DetectStackSetDriftRequest struct {
	*aws.Request
	Input *DetectStackSetDriftInput
	Copy  func(*DetectStackSetDriftInput) DetectStackSetDriftRequest
}

// Send marshals and sends the DetectStackSetDrift API request.
func (r DetectStackSetDriftRequest) Send(ctx context.Context) (*DetectStackSetDriftResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DetectStackSetDriftResponse{
		DetectStackSetDriftOutput: r.Request.Data.(*DetectStackSetDriftOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DetectStackSetDriftResponse is the response type for the
// DetectStackSetDrift API operation.
type DetectStackSetDriftResponse struct {
	*DetectStackSetDriftOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DetectStackSetDrift request.
func (r *DetectStackSetDriftResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
