// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudfront

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetOriginRequestPolicyInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the origin request policy. If the origin request
	// policy is attached to a distribution’s cache behavior, you can get the
	// policy’s identifier using ListDistributions or GetDistribution. If the
	// origin request policy is not attached to a cache behavior, you can get the
	// identifier using ListOriginRequestPolicies.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetOriginRequestPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOriginRequestPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetOriginRequestPolicyInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetOriginRequestPolicyInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.StringValue(v), metadata)
	}
	return nil
}

type GetOriginRequestPolicyOutput struct {
	_ struct{} `type:"structure" payload:"OriginRequestPolicy"`

	// The current version of the origin request policy.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The origin request policy.
	OriginRequestPolicy *OriginRequestPolicy `type:"structure"`
}

// String returns the string representation
func (s GetOriginRequestPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetOriginRequestPolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.OriginRequestPolicy != nil {
		v := s.OriginRequestPolicy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "OriginRequestPolicy", v, metadata)
	}
	return nil
}

const opGetOriginRequestPolicy = "GetOriginRequestPolicy2020_05_31"

// GetOriginRequestPolicyRequest returns a request value for making API operation for
// Amazon CloudFront.
//
// Gets an origin request policy, including the following metadata:
//
//    * The policy’s identifier.
//
//    * The date and time when the policy was last modified.
//
// To get an origin request policy, you must provide the policy’s identifier.
// If the origin request policy is attached to a distribution’s cache behavior,
// you can get the policy’s identifier using ListDistributions or GetDistribution.
// If the origin request policy is not attached to a cache behavior, you can
// get the identifier using ListOriginRequestPolicies.
//
//    // Example sending a request using GetOriginRequestPolicyRequest.
//    req := client.GetOriginRequestPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetOriginRequestPolicy
func (c *Client) GetOriginRequestPolicyRequest(input *GetOriginRequestPolicyInput) GetOriginRequestPolicyRequest {
	op := &aws.Operation{
		Name:       opGetOriginRequestPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/origin-request-policy/{Id}",
	}

	if input == nil {
		input = &GetOriginRequestPolicyInput{}
	}

	req := c.newRequest(op, input, &GetOriginRequestPolicyOutput{})

	return GetOriginRequestPolicyRequest{Request: req, Input: input, Copy: c.GetOriginRequestPolicyRequest}
}

// GetOriginRequestPolicyRequest is the request type for the
// GetOriginRequestPolicy API operation.
type GetOriginRequestPolicyRequest struct {
	*aws.Request
	Input *GetOriginRequestPolicyInput
	Copy  func(*GetOriginRequestPolicyInput) GetOriginRequestPolicyRequest
}

// Send marshals and sends the GetOriginRequestPolicy API request.
func (r GetOriginRequestPolicyRequest) Send(ctx context.Context) (*GetOriginRequestPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetOriginRequestPolicyResponse{
		GetOriginRequestPolicyOutput: r.Request.Data.(*GetOriginRequestPolicyOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetOriginRequestPolicyResponse is the response type for the
// GetOriginRequestPolicy API operation.
type GetOriginRequestPolicyResponse struct {
	*GetOriginRequestPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetOriginRequestPolicy request.
func (r *GetOriginRequestPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
