// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudsearch

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Container for the parameters to the DescribeAvailabilityOptions operation.
// Specifies the name of the domain you want to describe. To show the active
// configuration and exclude any pending changes, set the Deployed option to
// true.
type DescribeAvailabilityOptionsInput struct {
	_ struct{} `type:"structure"`

	// Whether to display the deployed configuration (true) or include any pending
	// changes (false). Defaults to false.
	Deployed *bool `type:"boolean"`

	// The name of the domain you want to describe.
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAvailabilityOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAvailabilityOptionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeAvailabilityOptionsInput"}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DescribeAvailabilityOptions request. Indicates whether or
// not the Multi-AZ option is enabled for the domain specified in the request.
type DescribeAvailabilityOptionsOutput struct {
	_ struct{} `type:"structure"`

	// The availability options configured for the domain. Indicates whether Multi-AZ
	// is enabled for the domain.
	AvailabilityOptions *AvailabilityOptionsStatus `type:"structure"`
}

// String returns the string representation
func (s DescribeAvailabilityOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeAvailabilityOptions = "DescribeAvailabilityOptions"

// DescribeAvailabilityOptionsRequest returns a request value for making API operation for
// Amazon CloudSearch.
//
// Gets the availability options configured for a domain. By default, shows
// the configuration with any pending changes. Set the Deployed option to true
// to show the active configuration and exclude pending changes. For more information,
// see Configuring Availability Options (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-availability-options.html)
// in the Amazon CloudSearch Developer Guide.
//
//    // Example sending a request using DescribeAvailabilityOptionsRequest.
//    req := client.DescribeAvailabilityOptionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DescribeAvailabilityOptionsRequest(input *DescribeAvailabilityOptionsInput) DescribeAvailabilityOptionsRequest {
	op := &aws.Operation{
		Name:       opDescribeAvailabilityOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAvailabilityOptionsInput{}
	}

	req := c.newRequest(op, input, &DescribeAvailabilityOptionsOutput{})

	return DescribeAvailabilityOptionsRequest{Request: req, Input: input, Copy: c.DescribeAvailabilityOptionsRequest}
}

// DescribeAvailabilityOptionsRequest is the request type for the
// DescribeAvailabilityOptions API operation.
type DescribeAvailabilityOptionsRequest struct {
	*aws.Request
	Input *DescribeAvailabilityOptionsInput
	Copy  func(*DescribeAvailabilityOptionsInput) DescribeAvailabilityOptionsRequest
}

// Send marshals and sends the DescribeAvailabilityOptions API request.
func (r DescribeAvailabilityOptionsRequest) Send(ctx context.Context) (*DescribeAvailabilityOptionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAvailabilityOptionsResponse{
		DescribeAvailabilityOptionsOutput: r.Request.Data.(*DescribeAvailabilityOptionsOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeAvailabilityOptionsResponse is the response type for the
// DescribeAvailabilityOptions API operation.
type DescribeAvailabilityOptionsResponse struct {
	*DescribeAvailabilityOptionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeAvailabilityOptions request.
func (r *DescribeAvailabilityOptionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
