// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudtrail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Returns information about the trail.
type DescribeTrailsInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether to include shadow trails in the response. A shadow trail
	// is the replication in a region of a trail that was created in a different
	// region, or in the case of an organization trail, the replication of an organization
	// trail in member accounts. If you do not include shadow trails, organization
	// trails in a member account and region replication trails will not be returned.
	// The default is true.
	IncludeShadowTrails *bool `locationName:"includeShadowTrails" type:"boolean"`

	// Specifies a list of trail names, trail ARNs, or both, of the trails to describe.
	// The format of a trail ARN is:
	//
	// arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
	//
	// If an empty list is specified, information for the trail in the current region
	// is returned.
	//
	//    * If an empty list is specified and IncludeShadowTrails is false, then
	//    information for all trails in the current region is returned.
	//
	//    * If an empty list is specified and IncludeShadowTrails is null or true,
	//    then information for all trails in the current region and any associated
	//    shadow trails in other regions is returned.
	//
	// If one or more trail names are specified, information is returned only if
	// the names match the names of trails belonging only to the current region.
	// To return information about a trail in another region, you must specify its
	// trail ARN.
	TrailNameList []string `locationName:"trailNameList" type:"list"`
}

// String returns the string representation
func (s DescribeTrailsInput) String() string {
	return awsutil.Prettify(s)
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
type DescribeTrailsOutput struct {
	_ struct{} `type:"structure"`

	// The list of trail objects. Trail objects with string values are only returned
	// if values for the objects exist in a trail's configuration. For example,
	// SNSTopicName and SNSTopicARN are only returned in results if a trail is configured
	// to send SNS notifications. Similarly, KMSKeyId only appears in results if
	// a trail's log files are encrypted with AWS KMS-managed keys.
	TrailList []Trail `locationName:"trailList" type:"list"`
}

// String returns the string representation
func (s DescribeTrailsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeTrails = "DescribeTrails"

// DescribeTrailsRequest returns a request value for making API operation for
// AWS CloudTrail.
//
// Retrieves settings for one or more trails associated with the current region
// for your account.
//
//    // Example sending a request using DescribeTrailsRequest.
//    req := client.DescribeTrailsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DescribeTrails
func (c *Client) DescribeTrailsRequest(input *DescribeTrailsInput) DescribeTrailsRequest {
	op := &aws.Operation{
		Name:       opDescribeTrails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTrailsInput{}
	}

	req := c.newRequest(op, input, &DescribeTrailsOutput{})

	return DescribeTrailsRequest{Request: req, Input: input, Copy: c.DescribeTrailsRequest}
}

// DescribeTrailsRequest is the request type for the
// DescribeTrails API operation.
type DescribeTrailsRequest struct {
	*aws.Request
	Input *DescribeTrailsInput
	Copy  func(*DescribeTrailsInput) DescribeTrailsRequest
}

// Send marshals and sends the DescribeTrails API request.
func (r DescribeTrailsRequest) Send(ctx context.Context) (*DescribeTrailsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeTrailsResponse{
		DescribeTrailsOutput: r.Request.Data.(*DescribeTrailsOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeTrailsResponse is the response type for the
// DescribeTrails API operation.
type DescribeTrailsResponse struct {
	*DescribeTrailsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeTrails request.
func (r *DescribeTrailsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
