// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeartifact

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListPackageVersionDependenciesInput struct {
	_ struct{} `type:"structure"`

	// The domain that contains the repository that contains the requested package
	// version dependencies.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the AWS account that owns the domain. It does
	// not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The format of the package with the requested dependencies. The valid package
	// types are:
	//
	//    * npm: A Node Package Manager (npm) package.
	//
	//    * pypi: A Python Package Index (PyPI) package.
	//
	//    * maven: A Maven package that contains compiled code in a distributable
	//    format, such as a JAR file.
	//
	// Format is a required field
	Format PackageFormat `location:"querystring" locationName:"format" type:"string" required:"true" enum:"true"`

	// The namespace of the package. The package component that specifies its namespace
	// depends on its type. For example:
	//
	//    * The namespace of a Maven package is its groupId.
	//
	//    * The namespace of an npm package is its scope.
	//
	//    * A Python package does not contain a corresponding component, so Python
	//    packages do not have a namespace.
	Namespace *string `location:"querystring" locationName:"namespace" min:"1" type:"string"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`

	// The name of the package versions' package.
	//
	// Package is a required field
	Package *string `location:"querystring" locationName:"package" min:"1" type:"string" required:"true"`

	// A string that contains the package version (for example, 3.5.2).
	//
	// PackageVersion is a required field
	PackageVersion *string `location:"querystring" locationName:"version" min:"1" type:"string" required:"true"`

	// The name of the repository that contains the requested package version.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPackageVersionDependenciesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPackageVersionDependenciesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListPackageVersionDependenciesInput"}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainOwner", 12))
	}
	if len(s.Format) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Format"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Namespace", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if s.Package == nil {
		invalidParams.Add(aws.NewErrParamRequired("Package"))
	}
	if s.Package != nil && len(*s.Package) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Package", 1))
	}

	if s.PackageVersion == nil {
		invalidParams.Add(aws.NewErrParamRequired("PackageVersion"))
	}
	if s.PackageVersion != nil && len(*s.PackageVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PackageVersion", 1))
	}

	if s.Repository == nil {
		invalidParams.Add(aws.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Repository", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPackageVersionDependenciesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Domain != nil {
		v := *s.Domain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainOwner != nil {
		v := *s.DomainOwner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain-owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "format", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Namespace != nil {
		v := *s.Namespace

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "namespace", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "next-token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Package != nil {
		v := *s.Package

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "package", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PackageVersion != nil {
		v := *s.PackageVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Repository != nil {
		v := *s.Repository

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "repository", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListPackageVersionDependenciesOutput struct {
	_ struct{} `type:"structure"`

	// The returned list of PackageDependency (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDependency.html)
	// objects.
	Dependencies []PackageDependency `locationName:"dependencies" type:"list"`

	// A format that specifies the type of the package that contains the returned
	// dependencies. The valid values are:
	//
	//    * npm
	//
	//    * pypi
	//
	//    * maven
	Format PackageFormat `locationName:"format" type:"string" enum:"true"`

	// The namespace of the package. The package component that specifies its namespace
	// depends on its type. For example:
	//
	//    * The namespace of a Maven package is its groupId.
	//
	//    * The namespace of an npm package is its scope.
	//
	//    * A Python package does not contain a corresponding component, so Python
	//    packages do not have a namespace.
	Namespace *string `locationName:"namespace" min:"1" type:"string"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The name of the package that contains the returned package versions dependencies.
	Package *string `locationName:"package" min:"1" type:"string"`

	// The version of the package that is specified in the request.
	Version *string `locationName:"version" min:"1" type:"string"`

	// The current revision associated with the package version.
	VersionRevision *string `locationName:"versionRevision" min:"1" type:"string"`
}

// String returns the string representation
func (s ListPackageVersionDependenciesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPackageVersionDependenciesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Dependencies != nil {
		v := s.Dependencies

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "dependencies", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "format", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Namespace != nil {
		v := *s.Namespace

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "namespace", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Package != nil {
		v := *s.Package

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "package", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VersionRevision != nil {
		v := *s.VersionRevision

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "versionRevision", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListPackageVersionDependencies = "ListPackageVersionDependencies"

// ListPackageVersionDependenciesRequest returns a request value for making API operation for
// CodeArtifact.
//
// Returns the direct dependencies for a package version. The dependencies are
// returned as PackageDependency (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDependency.html)
// objects. CodeArtifact extracts the dependencies for a package version from
// the metadata file for the package format (for example, the package.json file
// for npm packages and the pom.xml file for Maven). Any package version dependencies
// that are not listed in the configuration file are not returned.
//
//    // Example sending a request using ListPackageVersionDependenciesRequest.
//    req := client.ListPackageVersionDependenciesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListPackageVersionDependencies
func (c *Client) ListPackageVersionDependenciesRequest(input *ListPackageVersionDependenciesInput) ListPackageVersionDependenciesRequest {
	op := &aws.Operation{
		Name:       opListPackageVersionDependencies,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/package/version/dependencies",
	}

	if input == nil {
		input = &ListPackageVersionDependenciesInput{}
	}

	req := c.newRequest(op, input, &ListPackageVersionDependenciesOutput{})

	return ListPackageVersionDependenciesRequest{Request: req, Input: input, Copy: c.ListPackageVersionDependenciesRequest}
}

// ListPackageVersionDependenciesRequest is the request type for the
// ListPackageVersionDependencies API operation.
type ListPackageVersionDependenciesRequest struct {
	*aws.Request
	Input *ListPackageVersionDependenciesInput
	Copy  func(*ListPackageVersionDependenciesInput) ListPackageVersionDependenciesRequest
}

// Send marshals and sends the ListPackageVersionDependencies API request.
func (r ListPackageVersionDependenciesRequest) Send(ctx context.Context) (*ListPackageVersionDependenciesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListPackageVersionDependenciesResponse{
		ListPackageVersionDependenciesOutput: r.Request.Data.(*ListPackageVersionDependenciesOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListPackageVersionDependenciesResponse is the response type for the
// ListPackageVersionDependencies API operation.
type ListPackageVersionDependenciesResponse struct {
	*ListPackageVersionDependenciesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListPackageVersionDependencies request.
func (r *ListPackageVersionDependenciesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
