// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeartifact

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListRepositoriesInDomainInput struct {
	_ struct{} `type:"structure"`

	// Filter the list of repositories to only include those that are managed by
	// the AWS account ID.
	AdministratorAccount *string `location:"querystring" locationName:"administrator-account" min:"12" type:"string"`

	// The name of the domain that contains the returned list of repositories.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the AWS account that owns the domain. It does
	// not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`

	// A prefix used to filter returned repositories. Only repositories with names
	// that start with repositoryPrefix are returned.
	RepositoryPrefix *string `location:"querystring" locationName:"repository-prefix" min:"2" type:"string"`
}

// String returns the string representation
func (s ListRepositoriesInDomainInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRepositoriesInDomainInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListRepositoriesInDomainInput"}
	if s.AdministratorAccount != nil && len(*s.AdministratorAccount) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AdministratorAccount", 12))
	}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainOwner", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.RepositoryPrefix != nil && len(*s.RepositoryPrefix) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("RepositoryPrefix", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListRepositoriesInDomainInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AdministratorAccount != nil {
		v := *s.AdministratorAccount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "administrator-account", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Domain != nil {
		v := *s.Domain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainOwner != nil {
		v := *s.DomainOwner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain-owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "max-results", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "next-token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RepositoryPrefix != nil {
		v := *s.RepositoryPrefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "repository-prefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListRepositoriesInDomainOutput struct {
	_ struct{} `type:"structure"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The returned list of repositories.
	Repositories []RepositorySummary `locationName:"repositories" type:"list"`
}

// String returns the string representation
func (s ListRepositoriesInDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListRepositoriesInDomainOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Repositories != nil {
		v := s.Repositories

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "repositories", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListRepositoriesInDomain = "ListRepositoriesInDomain"

// ListRepositoriesInDomainRequest returns a request value for making API operation for
// CodeArtifact.
//
// Returns a list of RepositorySummary (https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html)
// objects. Each RepositorySummary contains information about a repository in
// the specified domain and that matches the input parameters.
//
//    // Example sending a request using ListRepositoriesInDomainRequest.
//    req := client.ListRepositoriesInDomainRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/ListRepositoriesInDomain
func (c *Client) ListRepositoriesInDomainRequest(input *ListRepositoriesInDomainInput) ListRepositoriesInDomainRequest {
	op := &aws.Operation{
		Name:       opListRepositoriesInDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/domain/repositories",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRepositoriesInDomainInput{}
	}

	req := c.newRequest(op, input, &ListRepositoriesInDomainOutput{})

	return ListRepositoriesInDomainRequest{Request: req, Input: input, Copy: c.ListRepositoriesInDomainRequest}
}

// ListRepositoriesInDomainRequest is the request type for the
// ListRepositoriesInDomain API operation.
type ListRepositoriesInDomainRequest struct {
	*aws.Request
	Input *ListRepositoriesInDomainInput
	Copy  func(*ListRepositoriesInDomainInput) ListRepositoriesInDomainRequest
}

// Send marshals and sends the ListRepositoriesInDomain API request.
func (r ListRepositoriesInDomainRequest) Send(ctx context.Context) (*ListRepositoriesInDomainResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListRepositoriesInDomainResponse{
		ListRepositoriesInDomainOutput: r.Request.Data.(*ListRepositoriesInDomainOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListRepositoriesInDomainRequestPaginator returns a paginator for ListRepositoriesInDomain.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListRepositoriesInDomainRequest(input)
//   p := codeartifact.NewListRepositoriesInDomainRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListRepositoriesInDomainPaginator(req ListRepositoriesInDomainRequest) ListRepositoriesInDomainPaginator {
	return ListRepositoriesInDomainPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListRepositoriesInDomainInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListRepositoriesInDomainPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListRepositoriesInDomainPaginator struct {
	aws.Pager
}

func (p *ListRepositoriesInDomainPaginator) CurrentPage() *ListRepositoriesInDomainOutput {
	return p.Pager.CurrentPage().(*ListRepositoriesInDomainOutput)
}

// ListRepositoriesInDomainResponse is the response type for the
// ListRepositoriesInDomain API operation.
type ListRepositoriesInDomainResponse struct {
	*ListRepositoriesInDomainOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListRepositoriesInDomain request.
func (r *ListRepositoriesInDomainResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
