// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeartifact

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateRepositoryInput struct {
	_ struct{} `type:"structure"`

	// An updated repository description.
	Description *string `locationName:"description" type:"string"`

	// The name of the domain associated with the repository to update.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"2" type:"string" required:"true"`

	// The 12-digit account number of the AWS account that owns the domain. It does
	// not include dashes or spaces.
	DomainOwner *string `location:"querystring" locationName:"domain-owner" min:"12" type:"string"`

	// The name of the repository to update.
	//
	// Repository is a required field
	Repository *string `location:"querystring" locationName:"repository" min:"2" type:"string" required:"true"`

	// A list of upstream repositories to associate with the repository. The order
	// of the upstream repositories in the list determines their priority order
	// when AWS CodeArtifact looks for a requested package version. For more information,
	// see Working with upstream repositories (https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html).
	Upstreams []UpstreamRepository `locationName:"upstreams" type:"list"`
}

// String returns the string representation
func (s UpdateRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRepositoryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateRepositoryInput"}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 2))
	}
	if s.DomainOwner != nil && len(*s.DomainOwner) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainOwner", 12))
	}

	if s.Repository == nil {
		invalidParams.Add(aws.NewErrParamRequired("Repository"))
	}
	if s.Repository != nil && len(*s.Repository) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Repository", 2))
	}
	if s.Upstreams != nil {
		for i, v := range s.Upstreams {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Upstreams", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateRepositoryInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Upstreams != nil {
		v := s.Upstreams

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "upstreams", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Domain != nil {
		v := *s.Domain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainOwner != nil {
		v := *s.DomainOwner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domain-owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Repository != nil {
		v := *s.Repository

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "repository", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// The updated repository.
	Repository *RepositoryDescription `locationName:"repository" type:"structure"`
}

// String returns the string representation
func (s UpdateRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateRepositoryOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Repository != nil {
		v := s.Repository

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "repository", v, metadata)
	}
	return nil
}

const opUpdateRepository = "UpdateRepository"

// UpdateRepositoryRequest returns a request value for making API operation for
// CodeArtifact.
//
// Update the properties of a repository.
//
//    // Example sending a request using UpdateRepositoryRequest.
//    req := client.UpdateRepositoryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeartifact-2018-09-22/UpdateRepository
func (c *Client) UpdateRepositoryRequest(input *UpdateRepositoryInput) UpdateRepositoryRequest {
	op := &aws.Operation{
		Name:       opUpdateRepository,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/repository",
	}

	if input == nil {
		input = &UpdateRepositoryInput{}
	}

	req := c.newRequest(op, input, &UpdateRepositoryOutput{})

	return UpdateRepositoryRequest{Request: req, Input: input, Copy: c.UpdateRepositoryRequest}
}

// UpdateRepositoryRequest is the request type for the
// UpdateRepository API operation.
type UpdateRepositoryRequest struct {
	*aws.Request
	Input *UpdateRepositoryInput
	Copy  func(*UpdateRepositoryInput) UpdateRepositoryRequest
}

// Send marshals and sends the UpdateRepository API request.
func (r UpdateRepositoryRequest) Send(ctx context.Context) (*UpdateRepositoryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateRepositoryResponse{
		UpdateRepositoryOutput: r.Request.Data.(*UpdateRepositoryOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateRepositoryResponse is the response type for the
// UpdateRepository API operation.
type UpdateRepositoryResponse struct {
	*UpdateRepositoryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateRepository request.
func (r *UpdateRepositoryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
