// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codecommit

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetCommentReactionsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the comment for which you want to get reactions information.
	//
	// CommentId is a required field
	CommentId *string `locationName:"commentId" type:"string" required:"true"`

	// A non-zero, non-negative integer used to limit the number of returned results.
	// The default is the same as the allowed maximum, 1,000.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// An enumeration token that, when provided in a request, returns the next batch
	// of the results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Optional. The Amazon Resource Name (ARN) of the user or identity for which
	// you want to get reaction information.
	ReactionUserArn *string `locationName:"reactionUserArn" type:"string"`
}

// String returns the string representation
func (s GetCommentReactionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCommentReactionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetCommentReactionsInput"}

	if s.CommentId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CommentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetCommentReactionsOutput struct {
	_ struct{} `type:"structure"`

	// An enumeration token that can be used in a request to return the next batch
	// of the results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of reactions to the specified comment.
	//
	// ReactionsForComment is a required field
	ReactionsForComment []ReactionForComment `locationName:"reactionsForComment" type:"list" required:"true"`
}

// String returns the string representation
func (s GetCommentReactionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetCommentReactions = "GetCommentReactions"

// GetCommentReactionsRequest returns a request value for making API operation for
// AWS CodeCommit.
//
// Returns information about reactions to a specified comment ID. Reactions
// from users who have been deleted will not be included in the count.
//
//    // Example sending a request using GetCommentReactionsRequest.
//    req := client.GetCommentReactionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommentReactions
func (c *Client) GetCommentReactionsRequest(input *GetCommentReactionsInput) GetCommentReactionsRequest {
	op := &aws.Operation{
		Name:       opGetCommentReactions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetCommentReactionsInput{}
	}

	req := c.newRequest(op, input, &GetCommentReactionsOutput{})

	return GetCommentReactionsRequest{Request: req, Input: input, Copy: c.GetCommentReactionsRequest}
}

// GetCommentReactionsRequest is the request type for the
// GetCommentReactions API operation.
type GetCommentReactionsRequest struct {
	*aws.Request
	Input *GetCommentReactionsInput
	Copy  func(*GetCommentReactionsInput) GetCommentReactionsRequest
}

// Send marshals and sends the GetCommentReactions API request.
func (r GetCommentReactionsRequest) Send(ctx context.Context) (*GetCommentReactionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetCommentReactionsResponse{
		GetCommentReactionsOutput: r.Request.Data.(*GetCommentReactionsOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetCommentReactionsRequestPaginator returns a paginator for GetCommentReactions.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetCommentReactionsRequest(input)
//   p := codecommit.NewGetCommentReactionsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetCommentReactionsPaginator(req GetCommentReactionsRequest) GetCommentReactionsPaginator {
	return GetCommentReactionsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetCommentReactionsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetCommentReactionsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetCommentReactionsPaginator struct {
	aws.Pager
}

func (p *GetCommentReactionsPaginator) CurrentPage() *GetCommentReactionsOutput {
	return p.Pager.CurrentPage().(*GetCommentReactionsOutput)
}

// GetCommentReactionsResponse is the response type for the
// GetCommentReactions API operation.
type GetCommentReactionsResponse struct {
	*GetCommentReactionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetCommentReactions request.
func (r *GetCommentReactionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
