// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package codecommitiface provides an interface to enable mocking the AWS CodeCommit service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package codecommitiface

import (
	"github.com/aws/aws-sdk-go-v2/service/codecommit"
)

// ClientAPI provides an interface to enable mocking the
// codecommit.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // CodeCommit.
//    func myFunc(svc codecommitiface.ClientAPI) bool {
//        // Make svc.AssociateApprovalRuleTemplateWithRepository request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := codecommit.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        codecommitiface.ClientPI
//    }
//    func (m *mockClientClient) AssociateApprovalRuleTemplateWithRepository(input *codecommit.AssociateApprovalRuleTemplateWithRepositoryInput) (*codecommit.AssociateApprovalRuleTemplateWithRepositoryOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	AssociateApprovalRuleTemplateWithRepositoryRequest(*codecommit.AssociateApprovalRuleTemplateWithRepositoryInput) codecommit.AssociateApprovalRuleTemplateWithRepositoryRequest

	BatchAssociateApprovalRuleTemplateWithRepositoriesRequest(*codecommit.BatchAssociateApprovalRuleTemplateWithRepositoriesInput) codecommit.BatchAssociateApprovalRuleTemplateWithRepositoriesRequest

	BatchDescribeMergeConflictsRequest(*codecommit.BatchDescribeMergeConflictsInput) codecommit.BatchDescribeMergeConflictsRequest

	BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest(*codecommit.BatchDisassociateApprovalRuleTemplateFromRepositoriesInput) codecommit.BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest

	BatchGetCommitsRequest(*codecommit.BatchGetCommitsInput) codecommit.BatchGetCommitsRequest

	BatchGetRepositoriesRequest(*codecommit.BatchGetRepositoriesInput) codecommit.BatchGetRepositoriesRequest

	CreateApprovalRuleTemplateRequest(*codecommit.CreateApprovalRuleTemplateInput) codecommit.CreateApprovalRuleTemplateRequest

	CreateBranchRequest(*codecommit.CreateBranchInput) codecommit.CreateBranchRequest

	CreateCommitRequest(*codecommit.CreateCommitInput) codecommit.CreateCommitRequest

	CreatePullRequestRequest(*codecommit.CreatePullRequestInput) codecommit.CreatePullRequestRequest

	CreatePullRequestApprovalRuleRequest(*codecommit.CreatePullRequestApprovalRuleInput) codecommit.CreatePullRequestApprovalRuleRequest

	CreateRepositoryRequest(*codecommit.CreateRepositoryInput) codecommit.CreateRepositoryRequest

	CreateUnreferencedMergeCommitRequest(*codecommit.CreateUnreferencedMergeCommitInput) codecommit.CreateUnreferencedMergeCommitRequest

	DeleteApprovalRuleTemplateRequest(*codecommit.DeleteApprovalRuleTemplateInput) codecommit.DeleteApprovalRuleTemplateRequest

	DeleteBranchRequest(*codecommit.DeleteBranchInput) codecommit.DeleteBranchRequest

	DeleteCommentContentRequest(*codecommit.DeleteCommentContentInput) codecommit.DeleteCommentContentRequest

	DeleteFileRequest(*codecommit.DeleteFileInput) codecommit.DeleteFileRequest

	DeletePullRequestApprovalRuleRequest(*codecommit.DeletePullRequestApprovalRuleInput) codecommit.DeletePullRequestApprovalRuleRequest

	DeleteRepositoryRequest(*codecommit.DeleteRepositoryInput) codecommit.DeleteRepositoryRequest

	DescribeMergeConflictsRequest(*codecommit.DescribeMergeConflictsInput) codecommit.DescribeMergeConflictsRequest

	DescribePullRequestEventsRequest(*codecommit.DescribePullRequestEventsInput) codecommit.DescribePullRequestEventsRequest

	DisassociateApprovalRuleTemplateFromRepositoryRequest(*codecommit.DisassociateApprovalRuleTemplateFromRepositoryInput) codecommit.DisassociateApprovalRuleTemplateFromRepositoryRequest

	EvaluatePullRequestApprovalRulesRequest(*codecommit.EvaluatePullRequestApprovalRulesInput) codecommit.EvaluatePullRequestApprovalRulesRequest

	GetApprovalRuleTemplateRequest(*codecommit.GetApprovalRuleTemplateInput) codecommit.GetApprovalRuleTemplateRequest

	GetBlobRequest(*codecommit.GetBlobInput) codecommit.GetBlobRequest

	GetBranchRequest(*codecommit.GetBranchInput) codecommit.GetBranchRequest

	GetCommentRequest(*codecommit.GetCommentInput) codecommit.GetCommentRequest

	GetCommentReactionsRequest(*codecommit.GetCommentReactionsInput) codecommit.GetCommentReactionsRequest

	GetCommentsForComparedCommitRequest(*codecommit.GetCommentsForComparedCommitInput) codecommit.GetCommentsForComparedCommitRequest

	GetCommentsForPullRequestRequest(*codecommit.GetCommentsForPullRequestInput) codecommit.GetCommentsForPullRequestRequest

	GetCommitRequest(*codecommit.GetCommitInput) codecommit.GetCommitRequest

	GetDifferencesRequest(*codecommit.GetDifferencesInput) codecommit.GetDifferencesRequest

	GetFileRequest(*codecommit.GetFileInput) codecommit.GetFileRequest

	GetFolderRequest(*codecommit.GetFolderInput) codecommit.GetFolderRequest

	GetMergeCommitRequest(*codecommit.GetMergeCommitInput) codecommit.GetMergeCommitRequest

	GetMergeConflictsRequest(*codecommit.GetMergeConflictsInput) codecommit.GetMergeConflictsRequest

	GetMergeOptionsRequest(*codecommit.GetMergeOptionsInput) codecommit.GetMergeOptionsRequest

	GetPullRequestRequest(*codecommit.GetPullRequestInput) codecommit.GetPullRequestRequest

	GetPullRequestApprovalStatesRequest(*codecommit.GetPullRequestApprovalStatesInput) codecommit.GetPullRequestApprovalStatesRequest

	GetPullRequestOverrideStateRequest(*codecommit.GetPullRequestOverrideStateInput) codecommit.GetPullRequestOverrideStateRequest

	GetRepositoryRequest(*codecommit.GetRepositoryInput) codecommit.GetRepositoryRequest

	GetRepositoryTriggersRequest(*codecommit.GetRepositoryTriggersInput) codecommit.GetRepositoryTriggersRequest

	ListApprovalRuleTemplatesRequest(*codecommit.ListApprovalRuleTemplatesInput) codecommit.ListApprovalRuleTemplatesRequest

	ListAssociatedApprovalRuleTemplatesForRepositoryRequest(*codecommit.ListAssociatedApprovalRuleTemplatesForRepositoryInput) codecommit.ListAssociatedApprovalRuleTemplatesForRepositoryRequest

	ListBranchesRequest(*codecommit.ListBranchesInput) codecommit.ListBranchesRequest

	ListPullRequestsRequest(*codecommit.ListPullRequestsInput) codecommit.ListPullRequestsRequest

	ListRepositoriesRequest(*codecommit.ListRepositoriesInput) codecommit.ListRepositoriesRequest

	ListRepositoriesForApprovalRuleTemplateRequest(*codecommit.ListRepositoriesForApprovalRuleTemplateInput) codecommit.ListRepositoriesForApprovalRuleTemplateRequest

	ListTagsForResourceRequest(*codecommit.ListTagsForResourceInput) codecommit.ListTagsForResourceRequest

	MergeBranchesByFastForwardRequest(*codecommit.MergeBranchesByFastForwardInput) codecommit.MergeBranchesByFastForwardRequest

	MergeBranchesBySquashRequest(*codecommit.MergeBranchesBySquashInput) codecommit.MergeBranchesBySquashRequest

	MergeBranchesByThreeWayRequest(*codecommit.MergeBranchesByThreeWayInput) codecommit.MergeBranchesByThreeWayRequest

	MergePullRequestByFastForwardRequest(*codecommit.MergePullRequestByFastForwardInput) codecommit.MergePullRequestByFastForwardRequest

	MergePullRequestBySquashRequest(*codecommit.MergePullRequestBySquashInput) codecommit.MergePullRequestBySquashRequest

	MergePullRequestByThreeWayRequest(*codecommit.MergePullRequestByThreeWayInput) codecommit.MergePullRequestByThreeWayRequest

	OverridePullRequestApprovalRulesRequest(*codecommit.OverridePullRequestApprovalRulesInput) codecommit.OverridePullRequestApprovalRulesRequest

	PostCommentForComparedCommitRequest(*codecommit.PostCommentForComparedCommitInput) codecommit.PostCommentForComparedCommitRequest

	PostCommentForPullRequestRequest(*codecommit.PostCommentForPullRequestInput) codecommit.PostCommentForPullRequestRequest

	PostCommentReplyRequest(*codecommit.PostCommentReplyInput) codecommit.PostCommentReplyRequest

	PutCommentReactionRequest(*codecommit.PutCommentReactionInput) codecommit.PutCommentReactionRequest

	PutFileRequest(*codecommit.PutFileInput) codecommit.PutFileRequest

	PutRepositoryTriggersRequest(*codecommit.PutRepositoryTriggersInput) codecommit.PutRepositoryTriggersRequest

	TagResourceRequest(*codecommit.TagResourceInput) codecommit.TagResourceRequest

	TestRepositoryTriggersRequest(*codecommit.TestRepositoryTriggersInput) codecommit.TestRepositoryTriggersRequest

	UntagResourceRequest(*codecommit.UntagResourceInput) codecommit.UntagResourceRequest

	UpdateApprovalRuleTemplateContentRequest(*codecommit.UpdateApprovalRuleTemplateContentInput) codecommit.UpdateApprovalRuleTemplateContentRequest

	UpdateApprovalRuleTemplateDescriptionRequest(*codecommit.UpdateApprovalRuleTemplateDescriptionInput) codecommit.UpdateApprovalRuleTemplateDescriptionRequest

	UpdateApprovalRuleTemplateNameRequest(*codecommit.UpdateApprovalRuleTemplateNameInput) codecommit.UpdateApprovalRuleTemplateNameRequest

	UpdateCommentRequest(*codecommit.UpdateCommentInput) codecommit.UpdateCommentRequest

	UpdateDefaultBranchRequest(*codecommit.UpdateDefaultBranchInput) codecommit.UpdateDefaultBranchRequest

	UpdatePullRequestApprovalRuleContentRequest(*codecommit.UpdatePullRequestApprovalRuleContentInput) codecommit.UpdatePullRequestApprovalRuleContentRequest

	UpdatePullRequestApprovalStateRequest(*codecommit.UpdatePullRequestApprovalStateInput) codecommit.UpdatePullRequestApprovalStateRequest

	UpdatePullRequestDescriptionRequest(*codecommit.UpdatePullRequestDescriptionInput) codecommit.UpdatePullRequestDescriptionRequest

	UpdatePullRequestStatusRequest(*codecommit.UpdatePullRequestStatusInput) codecommit.UpdatePullRequestStatusRequest

	UpdatePullRequestTitleRequest(*codecommit.UpdatePullRequestTitleInput) codecommit.UpdatePullRequestTitleRequest

	UpdateRepositoryDescriptionRequest(*codecommit.UpdateRepositoryDescriptionInput) codecommit.UpdateRepositoryDescriptionRequest

	UpdateRepositoryNameRequest(*codecommit.UpdateRepositoryNameInput) codecommit.UpdateRepositoryNameRequest
}

var _ ClientAPI = (*codecommit.Client)(nil)
