// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeguruprofiler

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The structure representing the putPermissionRequest.
type PutPermissionInput struct {
	_ struct{} `type:"structure"`

	// Specifies an action group that contains permissions to add to a profiling
	// group resource. One action group is supported, agentPermissions, which grants
	// permission to perform actions required by the profiling agent, ConfigureAgent
	// and PostAgentProfile permissions.
	//
	// ActionGroup is a required field
	ActionGroup ActionGroup `location:"uri" locationName:"actionGroup" type:"string" required:"true" enum:"true"`

	// A list ARNs for the roles and users you want to grant access to the profiling
	// group. Wildcards are not are supported in the ARNs.
	//
	// Principals is a required field
	Principals []string `locationName:"principals" min:"1" type:"list" required:"true"`

	// The name of the profiling group to grant access to.
	//
	// ProfilingGroupName is a required field
	ProfilingGroupName *string `location:"uri" locationName:"profilingGroupName" min:"1" type:"string" required:"true"`

	// A universally unique identifier (UUID) for the revision of the policy you
	// are adding to the profiling group. Do not specify this when you add permissions
	// to a profiling group for the first time. If a policy already exists on the
	// profiling group, you must specify the revisionId.
	RevisionId *string `locationName:"revisionId" type:"string"`
}

// String returns the string representation
func (s PutPermissionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutPermissionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutPermissionInput"}
	if len(s.ActionGroup) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ActionGroup"))
	}

	if s.Principals == nil {
		invalidParams.Add(aws.NewErrParamRequired("Principals"))
	}
	if s.Principals != nil && len(s.Principals) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Principals", 1))
	}

	if s.ProfilingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProfilingGroupName"))
	}
	if s.ProfilingGroupName != nil && len(*s.ProfilingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProfilingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutPermissionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Principals != nil {
		v := s.Principals

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "principals", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.RevisionId != nil {
		v := *s.RevisionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "revisionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ActionGroup) > 0 {
		v := s.ActionGroup

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "actionGroup", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ProfilingGroupName != nil {
		v := *s.ProfilingGroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "profilingGroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The structure representing the putPermissionResponse.
type PutPermissionOutput struct {
	_ struct{} `type:"structure"`

	// The JSON-formatted resource-based policy on the profiling group that includes
	// the added permissions.
	//
	// Policy is a required field
	Policy *string `locationName:"policy" type:"string" required:"true"`

	// A universally unique identifier (UUID) for the revision of the resource-based
	// policy that includes the added permissions. The JSON-formatted policy is
	// in the policy element of the response.
	//
	// RevisionId is a required field
	RevisionId *string `locationName:"revisionId" type:"string" required:"true"`
}

// String returns the string representation
func (s PutPermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutPermissionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Policy != nil {
		v := *s.Policy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "policy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RevisionId != nil {
		v := *s.RevisionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "revisionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opPutPermission = "PutPermission"

// PutPermissionRequest returns a request value for making API operation for
// Amazon CodeGuru Profiler.
//
// Adds permissions to a profiling group's resource-based policy that are provided
// using an action group. If a profiling group doesn't have a resource-based
// policy, one is created for it using the permissions in the action group and
// the roles and users in the principals parameter.
//
//    <p> The one supported action group that can be added is <code>agentPermission</code>
//    which grants <code>ConfigureAgent</code> and <code>PostAgent</code> permissions.
//    For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-ug/resource-based-policies.html">Resource-based
//    policies in CodeGuru Profiler</a> in the <i>Amazon CodeGuru Profiler User
//    Guide</i>, <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html">
//    <code>ConfigureAgent</code> </a>, and <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PostAgentProfile.html">
//    <code>PostAgentProfile</code> </a>. </p> <p> The first time you call <code>PutPermission</code>
//    on a profiling group, do not specify a <code>revisionId</code> because
//    it doesn't have a resource-based policy. Subsequent calls must provide
//    a <code>revisionId</code> to specify which revision of the resource-based
//    policy to add the permissions to. </p> <p> The response contains the profiling
//    group's JSON-formatted resource policy. </p>
//
//    // Example sending a request using PutPermissionRequest.
//    req := client.PutPermissionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/PutPermission
func (c *Client) PutPermissionRequest(input *PutPermissionInput) PutPermissionRequest {
	op := &aws.Operation{
		Name:       opPutPermission,
		HTTPMethod: "PUT",
		HTTPPath:   "/profilingGroups/{profilingGroupName}/policy/{actionGroup}",
	}

	if input == nil {
		input = &PutPermissionInput{}
	}

	req := c.newRequest(op, input, &PutPermissionOutput{})

	return PutPermissionRequest{Request: req, Input: input, Copy: c.PutPermissionRequest}
}

// PutPermissionRequest is the request type for the
// PutPermission API operation.
type PutPermissionRequest struct {
	*aws.Request
	Input *PutPermissionInput
	Copy  func(*PutPermissionInput) PutPermissionRequest
}

// Send marshals and sends the PutPermission API request.
func (r PutPermissionRequest) Send(ctx context.Context) (*PutPermissionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutPermissionResponse{
		PutPermissionOutput: r.Request.Data.(*PutPermissionOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutPermissionResponse is the response type for the
// PutPermission API operation.
type PutPermissionResponse struct {
	*PutPermissionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutPermission request.
func (r *PutPermissionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
