// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteUserPoolDomainInput struct {
	_ struct{} `type:"structure"`

	// The domain string.
	//
	// Domain is a required field
	Domain *string `min:"1" type:"string" required:"true"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserPoolDomainInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserPoolDomainInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteUserPoolDomainInput"}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 1))
	}

	if s.UserPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteUserPoolDomainOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUserPoolDomainOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteUserPoolDomain = "DeleteUserPoolDomain"

// DeleteUserPoolDomainRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Deletes a domain for a user pool.
//
//    // Example sending a request using DeleteUserPoolDomainRequest.
//    req := client.DeleteUserPoolDomainRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPoolDomain
func (c *Client) DeleteUserPoolDomainRequest(input *DeleteUserPoolDomainInput) DeleteUserPoolDomainRequest {
	op := &aws.Operation{
		Name:       opDeleteUserPoolDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserPoolDomainInput{}
	}

	req := c.newRequest(op, input, &DeleteUserPoolDomainOutput{})

	return DeleteUserPoolDomainRequest{Request: req, Input: input, Copy: c.DeleteUserPoolDomainRequest}
}

// DeleteUserPoolDomainRequest is the request type for the
// DeleteUserPoolDomain API operation.
type DeleteUserPoolDomainRequest struct {
	*aws.Request
	Input *DeleteUserPoolDomainInput
	Copy  func(*DeleteUserPoolDomainInput) DeleteUserPoolDomainRequest
}

// Send marshals and sends the DeleteUserPoolDomain API request.
func (r DeleteUserPoolDomainRequest) Send(ctx context.Context) (*DeleteUserPoolDomainResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteUserPoolDomainResponse{
		DeleteUserPoolDomainOutput: r.Request.Data.(*DeleteUserPoolDomainOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteUserPoolDomainResponse is the response type for the
// DeleteUserPoolDomain API operation.
type DeleteUserPoolDomainResponse struct {
	*DeleteUserPoolDomainOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteUserPoolDomain request.
func (r *DeleteUserPoolDomainResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
