// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetConformancePackComplianceSummaryInput struct {
	_ struct{} `type:"structure"`

	// Names of conformance packs.
	//
	// ConformancePackNames is a required field
	ConformancePackNames []string `min:"1" type:"list" required:"true"`

	// The maximum number of conformance packs returned on each page.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetConformancePackComplianceSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConformancePackComplianceSummaryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetConformancePackComplianceSummaryInput"}

	if s.ConformancePackNames == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConformancePackNames"))
	}
	if s.ConformancePackNames != nil && len(s.ConformancePackNames) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ConformancePackNames", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetConformancePackComplianceSummaryOutput struct {
	_ struct{} `type:"structure"`

	// A list of ConformancePackComplianceSummary objects.
	ConformancePackComplianceSummaryList []ConformancePackComplianceSummary `min:"1" type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetConformancePackComplianceSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetConformancePackComplianceSummary = "GetConformancePackComplianceSummary"

// GetConformancePackComplianceSummaryRequest returns a request value for making API operation for
// AWS Config.
//
// Returns compliance details for the conformance pack based on the cumulative
// compliance results of all the rules in that conformance pack.
//
//    // Example sending a request using GetConformancePackComplianceSummaryRequest.
//    req := client.GetConformancePackComplianceSummaryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceSummary
func (c *Client) GetConformancePackComplianceSummaryRequest(input *GetConformancePackComplianceSummaryInput) GetConformancePackComplianceSummaryRequest {
	op := &aws.Operation{
		Name:       opGetConformancePackComplianceSummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetConformancePackComplianceSummaryInput{}
	}

	req := c.newRequest(op, input, &GetConformancePackComplianceSummaryOutput{})

	return GetConformancePackComplianceSummaryRequest{Request: req, Input: input, Copy: c.GetConformancePackComplianceSummaryRequest}
}

// GetConformancePackComplianceSummaryRequest is the request type for the
// GetConformancePackComplianceSummary API operation.
type GetConformancePackComplianceSummaryRequest struct {
	*aws.Request
	Input *GetConformancePackComplianceSummaryInput
	Copy  func(*GetConformancePackComplianceSummaryInput) GetConformancePackComplianceSummaryRequest
}

// Send marshals and sends the GetConformancePackComplianceSummary API request.
func (r GetConformancePackComplianceSummaryRequest) Send(ctx context.Context) (*GetConformancePackComplianceSummaryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetConformancePackComplianceSummaryResponse{
		GetConformancePackComplianceSummaryOutput: r.Request.Data.(*GetConformancePackComplianceSummaryOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetConformancePackComplianceSummaryResponse is the response type for the
// GetConformancePackComplianceSummary API operation.
type GetConformancePackComplianceSummaryResponse struct {
	*GetConformancePackComplianceSummaryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetConformancePackComplianceSummary request.
func (r *GetConformancePackComplianceSummaryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
