// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dataexchange

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The CreateJob request. AWS Data Exchange Jobs are asynchronous import or
// export operations used to create or copy assets. A data set owner can both
// import and export as they see fit. Someone with an entitlement to a data
// set can only export. Jobs are deleted 90 days after they are created. Created
// jobs must be started with the StartJob operation.
type CreateJobInput struct {
	_ struct{} `type:"structure"`

	// The details for the CreateJob request.
	//
	// Details is a required field
	Details *RequestDetails `type:"structure" required:"true"`

	// The type of job to be created.
	//
	// Type is a required field
	Type Type `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s CreateJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateJobInput"}

	if s.Details == nil {
		invalidParams.Add(aws.NewErrParamRequired("Details"))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}
	if s.Details != nil {
		if err := s.Details.Validate(); err != nil {
			invalidParams.AddNested("Details", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateJobInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Details != nil {
		v := s.Details

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Details", v, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

type CreateJobOutput struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.
	Arn *string `type:"string"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Details for the response.
	Details *ResponseDetails `type:"structure"`

	Errors []JobError `type:"list"`

	// A unique identifier.
	Id *string `type:"string"`

	State State `type:"string" enum:"true"`

	Type Type `type:"string" enum:"true"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s CreateJobOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateJobOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Details != nil {
		v := s.Details

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Details", v, metadata)
	}
	if s.Errors != nil {
		v := s.Errors

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Errors", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.UpdatedAt != nil {
		v := *s.UpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdatedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

const opCreateJob = "CreateJob"

// CreateJobRequest returns a request value for making API operation for
// AWS Data Exchange.
//
// This operation creates a job.
//
//    // Example sending a request using CreateJobRequest.
//    req := client.CreateJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/CreateJob
func (c *Client) CreateJobRequest(input *CreateJobInput) CreateJobRequest {
	op := &aws.Operation{
		Name:       opCreateJob,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/jobs",
	}

	if input == nil {
		input = &CreateJobInput{}
	}

	req := c.newRequest(op, input, &CreateJobOutput{})

	return CreateJobRequest{Request: req, Input: input, Copy: c.CreateJobRequest}
}

// CreateJobRequest is the request type for the
// CreateJob API operation.
type CreateJobRequest struct {
	*aws.Request
	Input *CreateJobInput
	Copy  func(*CreateJobInput) CreateJobRequest
}

// Send marshals and sends the CreateJob API request.
func (r CreateJobRequest) Send(ctx context.Context) (*CreateJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateJobResponse{
		CreateJobOutput: r.Request.Data.(*CreateJobOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateJobResponse is the response type for the
// CreateJob API operation.
type CreateJobResponse struct {
	*CreateJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateJob request.
func (r *CreateJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
