// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package datapipeline

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the parameters for RemoveTags.
type RemoveTagsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the pipeline.
	//
	// PipelineId is a required field
	PipelineId *string `locationName:"pipelineId" min:"1" type:"string" required:"true"`

	// The keys of the tags to remove.
	//
	// TagKeys is a required field
	TagKeys []string `locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RemoveTagsInput"}

	if s.PipelineId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PipelineId"))
	}
	if s.PipelineId != nil && len(*s.PipelineId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PipelineId", 1))
	}

	if s.TagKeys == nil {
		invalidParams.Add(aws.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of RemoveTags.
type RemoveTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsOutput) String() string {
	return awsutil.Prettify(s)
}

const opRemoveTags = "RemoveTags"

// RemoveTagsRequest returns a request value for making API operation for
// AWS Data Pipeline.
//
// Removes existing tags from the specified pipeline.
//
//    // Example sending a request using RemoveTagsRequest.
//    req := client.RemoveTagsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/RemoveTags
func (c *Client) RemoveTagsRequest(input *RemoveTagsInput) RemoveTagsRequest {
	op := &aws.Operation{
		Name:       opRemoveTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsInput{}
	}

	req := c.newRequest(op, input, &RemoveTagsOutput{})

	return RemoveTagsRequest{Request: req, Input: input, Copy: c.RemoveTagsRequest}
}

// RemoveTagsRequest is the request type for the
// RemoveTags API operation.
type RemoveTagsRequest struct {
	*aws.Request
	Input *RemoveTagsInput
	Copy  func(*RemoveTagsInput) RemoveTagsRequest
}

// Send marshals and sends the RemoveTags API request.
func (r RemoveTagsRequest) Send(ctx context.Context) (*RemoveTagsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RemoveTagsResponse{
		RemoveTagsOutput: r.Request.Data.(*RemoveTagsOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RemoveTagsResponse is the response type for the
// RemoveTags API operation.
type RemoveTagsResponse struct {
	*RemoveTagsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RemoveTags request.
func (r *RemoveTagsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
