// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package datasync

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// DescribeLocationNfsRequest
type DescribeLocationNfsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon resource Name (ARN) of the NFS location to describe.
	//
	// LocationArn is a required field
	LocationArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeLocationNfsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLocationNfsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeLocationNfsInput"}

	if s.LocationArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("LocationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// DescribeLocationNfsResponse
type DescribeLocationNfsOutput struct {
	_ struct{} `type:"structure"`

	// The time that the NFS location was created.
	CreationTime *time.Time `type:"timestamp"`

	// The Amazon resource Name (ARN) of the NFS location that was described.
	LocationArn *string `type:"string"`

	// The URL of the source NFS location that was described.
	LocationUri *string `type:"string"`

	// The NFS mount options that DataSync used to mount your NFS share.
	MountOptions *NfsMountOptions `type:"structure"`

	// A list of Amazon Resource Names (ARNs) of agents to use for a Network File
	// System (NFS) location.
	OnPremConfig *OnPremConfig `type:"structure"`
}

// String returns the string representation
func (s DescribeLocationNfsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeLocationNfs = "DescribeLocationNfs"

// DescribeLocationNfsRequest returns a request value for making API operation for
// AWS DataSync.
//
// Returns metadata, such as the path information, about a NFS location.
//
//    // Example sending a request using DescribeLocationNfsRequest.
//    req := client.DescribeLocationNfsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/DescribeLocationNfs
func (c *Client) DescribeLocationNfsRequest(input *DescribeLocationNfsInput) DescribeLocationNfsRequest {
	op := &aws.Operation{
		Name:       opDescribeLocationNfs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLocationNfsInput{}
	}

	req := c.newRequest(op, input, &DescribeLocationNfsOutput{})

	return DescribeLocationNfsRequest{Request: req, Input: input, Copy: c.DescribeLocationNfsRequest}
}

// DescribeLocationNfsRequest is the request type for the
// DescribeLocationNfs API operation.
type DescribeLocationNfsRequest struct {
	*aws.Request
	Input *DescribeLocationNfsInput
	Copy  func(*DescribeLocationNfsInput) DescribeLocationNfsRequest
}

// Send marshals and sends the DescribeLocationNfs API request.
func (r DescribeLocationNfsRequest) Send(ctx context.Context) (*DescribeLocationNfsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeLocationNfsResponse{
		DescribeLocationNfsOutput: r.Request.Data.(*DescribeLocationNfsOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeLocationNfsResponse is the response type for the
// DescribeLocationNfs API operation.
type DescribeLocationNfsResponse struct {
	*DescribeLocationNfsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeLocationNfs request.
func (r *DescribeLocationNfsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
