// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the result of a list devices request.
type ListDevicesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the project.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// Used to select a set of devices. A filter is made up of an attribute, an
	// operator, and one or more values.
	//
	//    * Attribute: The aspect of a device such as platform or model used as
	//    the selection criteria in a device filter. Allowed values include: ARN:
	//    The Amazon Resource Name (ARN) of the device (for example, arn:aws:devicefarm:us-west-2::device:12345Example).
	//    PLATFORM: The device platform. Valid values are ANDROID or IOS. OS_VERSION:
	//    The operating system version (for example, 10.3.2). MODEL: The device
	//    model (for example, iPad 5th Gen). AVAILABILITY: The current availability
	//    of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
	//    TEMPORARY_NOT_AVAILABLE. FORM_FACTOR: The device form factor. Valid values
	//    are PHONE or TABLET. MANUFACTURER: The device manufacturer (for example,
	//    Apple). REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote
	//    access. Valid values are TRUE or FALSE. REMOTE_DEBUG_ENABLED: Whether
	//    the device is enabled for remote debugging. Valid values are TRUE or FALSE.
	//    Because remote debugging is no longer supported (https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html),
	//    this attribute is ignored. INSTANCE_ARN: The Amazon Resource Name (ARN)
	//    of the device instance. INSTANCE_LABELS: The label of the device instance.
	//    FLEET_TYPE: The fleet type. Valid values are PUBLIC or PRIVATE.
	//
	//    * Operator: The filter operator. The EQUALS operator is available for
	//    every attribute except INSTANCE_LABELS. The CONTAINS operator is available
	//    for the INSTANCE_LABELS and MODEL attributes. The IN and NOT_IN operators
	//    are available for the ARN, OS_VERSION, MODEL, MANUFACTURER, and INSTANCE_ARN
	//    attributes. The LESS_THAN, GREATER_THAN, LESS_THAN_OR_EQUALS, and GREATER_THAN_OR_EQUALS
	//    operators are also available for the OS_VERSION attribute.
	//
	//    * Values: An array of one or more filter values. The IN and NOT_IN operators
	//    take a values array that has one or more elements. The other operators
	//    require an array with a single element. In a request, the AVAILABILITY
	//    attribute takes the following values: AVAILABLE, HIGHLY_AVAILABLE, BUSY,
	//    or TEMPORARY_NOT_AVAILABLE.
	Filters []DeviceFilter `locationName:"filters" type:"list"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s ListDevicesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDevicesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListDevicesInput"}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("Arn", 32))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the result of a list devices operation.
type ListDevicesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the devices.
	Devices []Device `locationName:"devices" type:"list"`

	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned. It can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s ListDevicesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListDevices = "ListDevices"

// ListDevicesRequest returns a request value for making API operation for
// AWS Device Farm.
//
// Gets information about unique device types.
//
//    // Example sending a request using ListDevicesRequest.
//    req := client.ListDevicesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevices
func (c *Client) ListDevicesRequest(input *ListDevicesInput) ListDevicesRequest {
	op := &aws.Operation{
		Name:       opListDevices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDevicesInput{}
	}

	req := c.newRequest(op, input, &ListDevicesOutput{})

	return ListDevicesRequest{Request: req, Input: input, Copy: c.ListDevicesRequest}
}

// ListDevicesRequest is the request type for the
// ListDevices API operation.
type ListDevicesRequest struct {
	*aws.Request
	Input *ListDevicesInput
	Copy  func(*ListDevicesInput) ListDevicesRequest
}

// Send marshals and sends the ListDevices API request.
func (r ListDevicesRequest) Send(ctx context.Context) (*ListDevicesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListDevicesResponse{
		ListDevicesOutput: r.Request.Data.(*ListDevicesOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListDevicesRequestPaginator returns a paginator for ListDevices.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListDevicesRequest(input)
//   p := devicefarm.NewListDevicesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListDevicesPaginator(req ListDevicesRequest) ListDevicesPaginator {
	return ListDevicesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListDevicesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListDevicesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListDevicesPaginator struct {
	aws.Pager
}

func (p *ListDevicesPaginator) CurrentPage() *ListDevicesOutput {
	return p.Pager.CurrentPage().(*ListDevicesOutput)
}

// ListDevicesResponse is the response type for the
// ListDevices API operation.
type ListDevicesResponse struct {
	*ListDevicesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListDevices request.
func (r *ListDevicesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
