// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directconnect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteDirectConnectGatewayAssociationProposalInput struct {
	_ struct{} `type:"structure"`

	// The ID of the proposal.
	//
	// ProposalId is a required field
	ProposalId *string `locationName:"proposalId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDirectConnectGatewayAssociationProposalInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDirectConnectGatewayAssociationProposalInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteDirectConnectGatewayAssociationProposalInput"}

	if s.ProposalId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProposalId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteDirectConnectGatewayAssociationProposalOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the associated gateway.
	DirectConnectGatewayAssociationProposal *DirectConnectGatewayAssociationProposal `locationName:"directConnectGatewayAssociationProposal" type:"structure"`
}

// String returns the string representation
func (s DeleteDirectConnectGatewayAssociationProposalOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteDirectConnectGatewayAssociationProposal = "DeleteDirectConnectGatewayAssociationProposal"

// DeleteDirectConnectGatewayAssociationProposalRequest returns a request value for making API operation for
// AWS Direct Connect.
//
// Deletes the association proposal request between the specified Direct Connect
// gateway and virtual private gateway or transit gateway.
//
//    // Example sending a request using DeleteDirectConnectGatewayAssociationProposalRequest.
//    req := client.DeleteDirectConnectGatewayAssociationProposalRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteDirectConnectGatewayAssociationProposal
func (c *Client) DeleteDirectConnectGatewayAssociationProposalRequest(input *DeleteDirectConnectGatewayAssociationProposalInput) DeleteDirectConnectGatewayAssociationProposalRequest {
	op := &aws.Operation{
		Name:       opDeleteDirectConnectGatewayAssociationProposal,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDirectConnectGatewayAssociationProposalInput{}
	}

	req := c.newRequest(op, input, &DeleteDirectConnectGatewayAssociationProposalOutput{})

	return DeleteDirectConnectGatewayAssociationProposalRequest{Request: req, Input: input, Copy: c.DeleteDirectConnectGatewayAssociationProposalRequest}
}

// DeleteDirectConnectGatewayAssociationProposalRequest is the request type for the
// DeleteDirectConnectGatewayAssociationProposal API operation.
type DeleteDirectConnectGatewayAssociationProposalRequest struct {
	*aws.Request
	Input *DeleteDirectConnectGatewayAssociationProposalInput
	Copy  func(*DeleteDirectConnectGatewayAssociationProposalInput) DeleteDirectConnectGatewayAssociationProposalRequest
}

// Send marshals and sends the DeleteDirectConnectGatewayAssociationProposal API request.
func (r DeleteDirectConnectGatewayAssociationProposalRequest) Send(ctx context.Context) (*DeleteDirectConnectGatewayAssociationProposalResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteDirectConnectGatewayAssociationProposalResponse{
		DeleteDirectConnectGatewayAssociationProposalOutput: r.Request.Data.(*DeleteDirectConnectGatewayAssociationProposalOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteDirectConnectGatewayAssociationProposalResponse is the response type for the
// DeleteDirectConnectGatewayAssociationProposal API operation.
type DeleteDirectConnectGatewayAssociationProposalResponse struct {
	*DeleteDirectConnectGatewayAssociationProposalOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteDirectConnectGatewayAssociationProposal request.
func (r *DeleteDirectConnectGatewayAssociationProposalResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
