// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directconnect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StartBgpFailoverTestInput struct {
	_ struct{} `type:"structure"`

	// The BGP peers to place in the DOWN state.
	BgpPeers []string `locationName:"bgpPeers" type:"list"`

	// The time in minutes that the virtual interface failover test will last.
	//
	// Maximum value: 180 minutes (3 hours).
	//
	// Default: 180 minutes (3 hours).
	TestDurationInMinutes *int64 `locationName:"testDurationInMinutes" type:"integer"`

	// The ID of the virtual interface you want to test.
	//
	// VirtualInterfaceId is a required field
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string" required:"true"`
}

// String returns the string representation
func (s StartBgpFailoverTestInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartBgpFailoverTestInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartBgpFailoverTestInput"}

	if s.VirtualInterfaceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VirtualInterfaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StartBgpFailoverTestOutput struct {
	_ struct{} `type:"structure"`

	// Information about the virtual interface failover test.
	VirtualInterfaceTest *VirtualInterfaceTestHistory `locationName:"virtualInterfaceTest" type:"structure"`
}

// String returns the string representation
func (s StartBgpFailoverTestOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartBgpFailoverTest = "StartBgpFailoverTest"

// StartBgpFailoverTestRequest returns a request value for making API operation for
// AWS Direct Connect.
//
// Starts the virtual interface failover test that verifies your configuration
// meets your resiliency requirements by placing the BGP peering session in
// the DOWN state. You can then send traffic to verify that there are no outages.
//
// You can run the test on public, private, transit, and hosted virtual interfaces.
//
// You can use ListVirtualInterfaceTestHistory (https://docs.aws.amazon.com/directconnect/latest/APIReference/API_ListVirtualInterfaceTestHistory.html)
// to view the virtual interface test history.
//
// If you need to stop the test before the test interval completes, use StopBgpFailoverTest
// (https://docs.aws.amazon.com/directconnect/latest/APIReference/API_StopBgpFailoverTest.html).
//
//    // Example sending a request using StartBgpFailoverTestRequest.
//    req := client.StartBgpFailoverTestRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/StartBgpFailoverTest
func (c *Client) StartBgpFailoverTestRequest(input *StartBgpFailoverTestInput) StartBgpFailoverTestRequest {
	op := &aws.Operation{
		Name:       opStartBgpFailoverTest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartBgpFailoverTestInput{}
	}

	req := c.newRequest(op, input, &StartBgpFailoverTestOutput{})

	return StartBgpFailoverTestRequest{Request: req, Input: input, Copy: c.StartBgpFailoverTestRequest}
}

// StartBgpFailoverTestRequest is the request type for the
// StartBgpFailoverTest API operation.
type StartBgpFailoverTestRequest struct {
	*aws.Request
	Input *StartBgpFailoverTestInput
	Copy  func(*StartBgpFailoverTestInput) StartBgpFailoverTestRequest
}

// Send marshals and sends the StartBgpFailoverTest API request.
func (r StartBgpFailoverTestRequest) Send(ctx context.Context) (*StartBgpFailoverTestResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartBgpFailoverTestResponse{
		StartBgpFailoverTestOutput: r.Request.Data.(*StartBgpFailoverTestOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartBgpFailoverTestResponse is the response type for the
// StartBgpFailoverTest API operation.
type StartBgpFailoverTestResponse struct {
	*StartBgpFailoverTestOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartBgpFailoverTest request.
func (r *StartBgpFailoverTestResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
