// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directoryservice

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the inputs for the CreateDirectory operation.
type CreateDirectoryInput struct {
	_ struct{} `type:"structure"`

	// A description for the directory.
	Description *string `type:"string"`

	// The fully qualified name for the directory, such as corp.example.com.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The password for the directory administrator. The directory creation process
	// creates a directory administrator account with the user name Administrator
	// and this password.
	//
	// If you need to change the password for the administrator account, you can
	// use the ResetUserPassword API call.
	//
	// Password is a required field
	Password *string `type:"string" required:"true" sensitive:"true"`

	// The NetBIOS name of the directory, such as CORP.
	ShortName *string `type:"string"`

	// The size of the directory.
	//
	// Size is a required field
	Size DirectorySize `type:"string" required:"true" enum:"true"`

	// The tags to be assigned to the Simple AD directory.
	Tags []Tag `type:"list"`

	// A DirectoryVpcSettings object that contains additional information for the
	// operation.
	VpcSettings *DirectoryVpcSettings `type:"structure"`
}

// String returns the string representation
func (s CreateDirectoryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDirectoryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateDirectoryInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Password == nil {
		invalidParams.Add(aws.NewErrParamRequired("Password"))
	}
	if len(s.Size) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Size"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.VpcSettings != nil {
		if err := s.VpcSettings.Validate(); err != nil {
			invalidParams.AddNested("VpcSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the results of the CreateDirectory operation.
type CreateDirectoryOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory that was created.
	DirectoryId *string `type:"string"`
}

// String returns the string representation
func (s CreateDirectoryOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateDirectory = "CreateDirectory"

// CreateDirectoryRequest returns a request value for making API operation for
// AWS Directory Service.
//
// Creates a Simple AD directory. For more information, see Simple Active Directory
// (https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_simple_ad.html)
// in the AWS Directory Service Admin Guide.
//
// Before you call CreateDirectory, ensure that all of the required permissions
// have been explicitly granted through a policy. For details about what permissions
// are required to run the CreateDirectory operation, see AWS Directory Service
// API Permissions: Actions, Resources, and Conditions Reference (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html).
//
//    // Example sending a request using CreateDirectoryRequest.
//    req := client.CreateDirectoryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateDirectory
func (c *Client) CreateDirectoryRequest(input *CreateDirectoryInput) CreateDirectoryRequest {
	op := &aws.Operation{
		Name:       opCreateDirectory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDirectoryInput{}
	}

	req := c.newRequest(op, input, &CreateDirectoryOutput{})

	return CreateDirectoryRequest{Request: req, Input: input, Copy: c.CreateDirectoryRequest}
}

// CreateDirectoryRequest is the request type for the
// CreateDirectory API operation.
type CreateDirectoryRequest struct {
	*aws.Request
	Input *CreateDirectoryInput
	Copy  func(*CreateDirectoryInput) CreateDirectoryRequest
}

// Send marshals and sends the CreateDirectory API request.
func (r CreateDirectoryRequest) Send(ctx context.Context) (*CreateDirectoryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateDirectoryResponse{
		CreateDirectoryOutput: r.Request.Data.(*CreateDirectoryOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateDirectoryResponse is the response type for the
// CreateDirectory API operation.
type CreateDirectoryResponse struct {
	*CreateDirectoryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateDirectory request.
func (r *CreateDirectoryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
